; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+avx512dq | FileCheck %s --check-prefixes=AVX512,AVX512DQ

;
; trunc(abs(sub(zext(a),zext(b)))) -> abdu(a,b)
;

define <64 x i8> @abd_ext_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; AVX512-LABEL: abd_ext_v64i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm2 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero,xmm4[8],zero,xmm4[9],zero,xmm4[10],zero,xmm4[11],zero,xmm4[12],zero,xmm4[13],zero,xmm4[14],zero,xmm4[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm5 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero,xmm4[4],zero,zero,zero,xmm4[5],zero,zero,zero,xmm4[6],zero,zero,zero,xmm4[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero,xmm4[4],zero,zero,zero,xmm4[5],zero,zero,zero,xmm4[6],zero,zero,zero,xmm4[7],zero,zero,zero
; AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm6 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm7 = xmm6[0],zero,zero,zero,xmm6[1],zero,zero,zero,xmm6[2],zero,zero,zero,xmm6[3],zero,zero,zero,xmm6[4],zero,zero,zero,xmm6[5],zero,zero,zero,xmm6[6],zero,zero,zero,xmm6[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm6 = xmm6[0],zero,zero,zero,xmm6[1],zero,zero,zero,xmm6[2],zero,zero,zero,xmm6[3],zero,zero,zero,xmm6[4],zero,zero,zero,xmm6[5],zero,zero,zero,xmm6[6],zero,zero,zero,xmm6[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm8 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm9 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm10 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero,xmm9[4],zero,zero,zero,xmm9[5],zero,zero,zero,xmm9[6],zero,zero,zero,xmm9[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm10, %zmm3, %zmm3
; AVX512-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm9 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero,xmm9[4],zero,zero,zero,xmm9[5],zero,zero,zero,xmm9[6],zero,zero,zero,xmm9[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm9, %zmm2, %zmm2
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm9
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm9 = xmm9[0],zero,xmm9[1],zero,xmm9[2],zero,xmm9[3],zero,xmm9[4],zero,xmm9[5],zero,xmm9[6],zero,xmm9[7],zero,xmm9[8],zero,xmm9[9],zero,xmm9[10],zero,xmm9[11],zero,xmm9[12],zero,xmm9[13],zero,xmm9[14],zero,xmm9[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm10 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero,xmm9[4],zero,zero,zero,xmm9[5],zero,zero,zero,xmm9[6],zero,zero,zero,xmm9[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm10, %zmm5, %zmm5
; AVX512-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm9 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero,xmm9[4],zero,zero,zero,xmm9[5],zero,zero,zero,xmm9[6],zero,zero,zero,xmm9[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm9, %zmm4, %zmm4
; AVX512-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm9 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm10 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero,xmm9[4],zero,zero,zero,xmm9[5],zero,zero,zero,xmm9[6],zero,zero,zero,xmm9[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm10, %zmm7, %zmm7
; AVX512-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm9 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero,xmm9[4],zero,zero,zero,xmm9[5],zero,zero,zero,xmm9[6],zero,zero,zero,xmm9[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm9, %zmm6, %zmm6
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm9 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm9, %zmm8, %zmm8
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm3, %zmm1
; AVX512-NEXT:    vpabsq %zmm2, %zmm2
; AVX512-NEXT:    vpabsq %zmm5, %zmm3
; AVX512-NEXT:    vpabsq %zmm4, %zmm4
; AVX512-NEXT:    vpabsq %zmm7, %zmm5
; AVX512-NEXT:    vpabsq %zmm6, %zmm6
; AVX512-NEXT:    vpabsq %zmm8, %zmm7
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpmovqb %zmm7, %xmm7
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm7[0],xmm0[0]
; AVX512-NEXT:    vpmovqb %zmm6, %xmm6
; AVX512-NEXT:    vpmovqb %zmm5, %xmm5
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm6[0]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm5, %ymm0
; AVX512-NEXT:    vpmovqb %zmm4, %xmm4
; AVX512-NEXT:    vpmovqb %zmm3, %xmm3
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; AVX512-NEXT:    vpmovqb %zmm2, %xmm2
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX512-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-NEXT:    retq
  %aext = zext <64 x i8> %a to <64 x i64>
  %bext = zext <64 x i8> %b to <64 x i64>
  %sub = sub <64 x i64> %aext, %bext
  %abs = call <64 x i64> @llvm.abs.v64i64(<64 x i64> %sub, i1 false)
  %trunc = trunc <64 x i64> %abs to <64 x i8>
  ret <64 x i8> %trunc
}

define <64 x i8> @abd_ext_v64i8_undef(<64 x i8> %a, <64 x i8> %b) nounwind {
; AVX512-LABEL: abd_ext_v64i8_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm2 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero,xmm4[8],zero,xmm4[9],zero,xmm4[10],zero,xmm4[11],zero,xmm4[12],zero,xmm4[13],zero,xmm4[14],zero,xmm4[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm5 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero,xmm4[4],zero,zero,zero,xmm4[5],zero,zero,zero,xmm4[6],zero,zero,zero,xmm4[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero,xmm4[4],zero,zero,zero,xmm4[5],zero,zero,zero,xmm4[6],zero,zero,zero,xmm4[7],zero,zero,zero
; AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm6 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm7 = xmm6[0],zero,zero,zero,xmm6[1],zero,zero,zero,xmm6[2],zero,zero,zero,xmm6[3],zero,zero,zero,xmm6[4],zero,zero,zero,xmm6[5],zero,zero,zero,xmm6[6],zero,zero,zero,xmm6[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm6 = xmm6[0],zero,zero,zero,xmm6[1],zero,zero,zero,xmm6[2],zero,zero,zero,xmm6[3],zero,zero,zero,xmm6[4],zero,zero,zero,xmm6[5],zero,zero,zero,xmm6[6],zero,zero,zero,xmm6[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm8 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm9 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm10 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero,xmm9[4],zero,zero,zero,xmm9[5],zero,zero,zero,xmm9[6],zero,zero,zero,xmm9[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm10, %zmm3, %zmm3
; AVX512-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm9 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero,xmm9[4],zero,zero,zero,xmm9[5],zero,zero,zero,xmm9[6],zero,zero,zero,xmm9[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm9, %zmm2, %zmm2
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm9
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm9 = xmm9[0],zero,xmm9[1],zero,xmm9[2],zero,xmm9[3],zero,xmm9[4],zero,xmm9[5],zero,xmm9[6],zero,xmm9[7],zero,xmm9[8],zero,xmm9[9],zero,xmm9[10],zero,xmm9[11],zero,xmm9[12],zero,xmm9[13],zero,xmm9[14],zero,xmm9[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm10 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero,xmm9[4],zero,zero,zero,xmm9[5],zero,zero,zero,xmm9[6],zero,zero,zero,xmm9[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm10, %zmm5, %zmm5
; AVX512-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm9 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero,xmm9[4],zero,zero,zero,xmm9[5],zero,zero,zero,xmm9[6],zero,zero,zero,xmm9[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm9, %zmm4, %zmm4
; AVX512-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm9 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm10 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero,xmm9[4],zero,zero,zero,xmm9[5],zero,zero,zero,xmm9[6],zero,zero,zero,xmm9[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm10, %zmm7, %zmm7
; AVX512-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm9 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero,xmm9[4],zero,zero,zero,xmm9[5],zero,zero,zero,xmm9[6],zero,zero,zero,xmm9[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm9, %zmm6, %zmm6
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm9 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm9, %zmm8, %zmm8
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm3, %zmm1
; AVX512-NEXT:    vpabsq %zmm2, %zmm2
; AVX512-NEXT:    vpabsq %zmm5, %zmm3
; AVX512-NEXT:    vpabsq %zmm4, %zmm4
; AVX512-NEXT:    vpabsq %zmm7, %zmm5
; AVX512-NEXT:    vpabsq %zmm6, %zmm6
; AVX512-NEXT:    vpabsq %zmm8, %zmm7
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpmovqb %zmm7, %xmm7
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm7[0],xmm0[0]
; AVX512-NEXT:    vpmovqb %zmm6, %xmm6
; AVX512-NEXT:    vpmovqb %zmm5, %xmm5
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm6[0]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm5, %ymm0
; AVX512-NEXT:    vpmovqb %zmm4, %xmm4
; AVX512-NEXT:    vpmovqb %zmm3, %xmm3
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; AVX512-NEXT:    vpmovqb %zmm2, %xmm2
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX512-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-NEXT:    retq
  %aext = zext <64 x i8> %a to <64 x i64>
  %bext = zext <64 x i8> %b to <64 x i64>
  %sub = sub <64 x i64> %aext, %bext
  %abs = call <64 x i64> @llvm.abs.v64i64(<64 x i64> %sub, i1 true)
  %trunc = trunc <64 x i64> %abs to <64 x i8>
  ret <64 x i8> %trunc
}

define <32 x i16> @abd_ext_v32i16(<32 x i16> %a, <32 x i16> %b) nounwind {
; AVX512-LABEL: abd_ext_v32i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm3 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero,xmm4[4],zero,zero,zero,xmm4[5],zero,zero,zero,xmm4[6],zero,zero,zero,xmm4[7],zero,zero,zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm5
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm5 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero,xmm5[2],zero,zero,zero,xmm5[3],zero,zero,zero,xmm5[4],zero,zero,zero,xmm5[5],zero,zero,zero,xmm5[6],zero,zero,zero,xmm5[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm5, %zmm2, %zmm2
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm5 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm5, %zmm3, %zmm3
; AVX512-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm5
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm5 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero,xmm5[2],zero,zero,zero,xmm5[3],zero,zero,zero,xmm5[4],zero,zero,zero,xmm5[5],zero,zero,zero,xmm5[6],zero,zero,zero,xmm5[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm5, %zmm4, %zmm4
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm2, %zmm1
; AVX512-NEXT:    vpabsq %zmm3, %zmm2
; AVX512-NEXT:    vpabsq %zmm4, %zmm3
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vpmovqw %zmm3, %xmm3
; AVX512-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm0
; AVX512-NEXT:    vpmovqw %zmm2, %xmm2
; AVX512-NEXT:    vpmovqw %zmm1, %xmm1
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-NEXT:    retq
  %aext = zext <32 x i16> %a to <32 x i64>
  %bext = zext <32 x i16> %b to <32 x i64>
  %sub = sub <32 x i64> %aext, %bext
  %abs = call <32 x i64> @llvm.abs.v32i64(<32 x i64> %sub, i1 false)
  %trunc = trunc <32 x i64> %abs to <32 x i16>
  ret <32 x i16> %trunc
}

define <32 x i16> @abd_ext_v32i16_undef(<32 x i16> %a, <32 x i16> %b) nounwind {
; AVX512-LABEL: abd_ext_v32i16_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm3 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero,xmm4[4],zero,zero,zero,xmm4[5],zero,zero,zero,xmm4[6],zero,zero,zero,xmm4[7],zero,zero,zero
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm5
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm5 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero,xmm5[2],zero,zero,zero,xmm5[3],zero,zero,zero,xmm5[4],zero,zero,zero,xmm5[5],zero,zero,zero,xmm5[6],zero,zero,zero,xmm5[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm5, %zmm2, %zmm2
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm5 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm5, %zmm3, %zmm3
; AVX512-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm5
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm5 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero,xmm5[2],zero,zero,zero,xmm5[3],zero,zero,zero,xmm5[4],zero,zero,zero,xmm5[5],zero,zero,zero,xmm5[6],zero,zero,zero,xmm5[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm5, %zmm4, %zmm4
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm2, %zmm1
; AVX512-NEXT:    vpabsq %zmm3, %zmm2
; AVX512-NEXT:    vpabsq %zmm4, %zmm3
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vpmovqw %zmm3, %xmm3
; AVX512-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm0
; AVX512-NEXT:    vpmovqw %zmm2, %xmm2
; AVX512-NEXT:    vpmovqw %zmm1, %xmm1
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-NEXT:    retq
  %aext = zext <32 x i16> %a to <32 x i64>
  %bext = zext <32 x i16> %b to <32 x i64>
  %sub = sub <32 x i64> %aext, %bext
  %abs = call <32 x i64> @llvm.abs.v32i64(<32 x i64> %sub, i1 true)
  %trunc = trunc <32 x i64> %abs to <32 x i16>
  ret <32 x i16> %trunc
}

define <16 x i32> @abd_ext_v16i32(<16 x i32> %a, <16 x i32> %b) nounwind {
; AVX512-LABEL: abd_ext_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512-NEXT:    vpmovzxdq {{.*#+}} zmm2 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero
; AVX512-NEXT:    vpmovzxdq {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero
; AVX512-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512-NEXT:    vpmovzxdq {{.*#+}} zmm3 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero
; AVX512-NEXT:    vpsubq %zmm3, %zmm2, %zmm2
; AVX512-NEXT:    vpmovzxdq {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm2, %zmm1
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    vpmovqd %zmm1, %ymm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %aext = zext <16 x i32> %a to <16 x i64>
  %bext = zext <16 x i32> %b to <16 x i64>
  %sub = sub <16 x i64> %aext, %bext
  %abs = call <16 x i64> @llvm.abs.v16i64(<16 x i64> %sub, i1 false)
  %trunc = trunc <16 x i64> %abs to <16 x i32>
  ret <16 x i32> %trunc
}

define <16 x i32> @abd_ext_v16i32_undef(<16 x i32> %a, <16 x i32> %b) nounwind {
; AVX512-LABEL: abd_ext_v16i32_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512-NEXT:    vpmovzxdq {{.*#+}} zmm2 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero
; AVX512-NEXT:    vpmovzxdq {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero
; AVX512-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512-NEXT:    vpmovzxdq {{.*#+}} zmm3 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero
; AVX512-NEXT:    vpsubq %zmm3, %zmm2, %zmm2
; AVX512-NEXT:    vpmovzxdq {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm2, %zmm1
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    vpmovqd %zmm1, %ymm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %aext = zext <16 x i32> %a to <16 x i64>
  %bext = zext <16 x i32> %b to <16 x i64>
  %sub = sub <16 x i64> %aext, %bext
  %abs = call <16 x i64> @llvm.abs.v16i64(<16 x i64> %sub, i1 true)
  %trunc = trunc <16 x i64> %abs to <16 x i32>
  ret <16 x i32> %trunc
}

define <8 x i64> @abd_ext_v8i64(<8 x i64> %a, <8 x i64> %b) nounwind {
; AVX512-LABEL: abd_ext_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    pushq %r15
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %r13
; AVX512-NEXT:    pushq %r12
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512-NEXT:    vmovq %xmm2, %rax
; AVX512-NEXT:    vpextrq $1, %xmm2, %rdx
; AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512-NEXT:    vmovq %xmm2, %rsi
; AVX512-NEXT:    vpextrq $1, %xmm2, %rdi
; AVX512-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512-NEXT:    vmovq %xmm2, %r8
; AVX512-NEXT:    vpextrq $1, %xmm2, %r9
; AVX512-NEXT:    vpextrq $1, %xmm1, %rbx
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512-NEXT:    vmovq %xmm2, %rbp
; AVX512-NEXT:    vpextrq $1, %xmm2, %r13
; AVX512-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512-NEXT:    vmovq %xmm2, %r15
; AVX512-NEXT:    vpextrq $1, %xmm2, %r14
; AVX512-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512-NEXT:    vmovq %xmm2, %r11
; AVX512-NEXT:    vpextrq $1, %xmm2, %r10
; AVX512-NEXT:    xorl %r12d, %r12d
; AVX512-NEXT:    subq %r10, %r9
; AVX512-NEXT:    movl $0, %r10d
; AVX512-NEXT:    sbbq %r10, %r10
; AVX512-NEXT:    subq %r11, %r8
; AVX512-NEXT:    movl $0, %r11d
; AVX512-NEXT:    sbbq %r11, %r11
; AVX512-NEXT:    subq %r14, %rdi
; AVX512-NEXT:    movl $0, %r14d
; AVX512-NEXT:    sbbq %r14, %r14
; AVX512-NEXT:    subq %r15, %rsi
; AVX512-NEXT:    movl $0, %r15d
; AVX512-NEXT:    sbbq %r15, %r15
; AVX512-NEXT:    subq %r13, %rdx
; AVX512-NEXT:    movl $0, %r13d
; AVX512-NEXT:    sbbq %r13, %r13
; AVX512-NEXT:    subq %rbp, %rax
; AVX512-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; AVX512-NEXT:    movl $0, %ebp
; AVX512-NEXT:    sbbq %rbp, %rbp
; AVX512-NEXT:    subq %rbx, %rcx
; AVX512-NEXT:    movq %rcx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; AVX512-NEXT:    movl $0, %eax
; AVX512-NEXT:    sbbq %rax, %rax
; AVX512-NEXT:    vmovq %xmm0, %rbx
; AVX512-NEXT:    vmovq %xmm1, %rcx
; AVX512-NEXT:    subq %rcx, %rbx
; AVX512-NEXT:    sbbq %r12, %r12
; AVX512-NEXT:    sarq $63, %r12
; AVX512-NEXT:    xorq %r12, %rbx
; AVX512-NEXT:    subq %r12, %rbx
; AVX512-NEXT:    sarq $63, %rax
; AVX512-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; AVX512-NEXT:    xorq %rax, %rcx
; AVX512-NEXT:    subq %rax, %rcx
; AVX512-NEXT:    movq %rcx, %rax
; AVX512-NEXT:    sarq $63, %rbp
; AVX512-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; AVX512-NEXT:    xorq %rbp, %rcx
; AVX512-NEXT:    subq %rbp, %rcx
; AVX512-NEXT:    sarq $63, %r13
; AVX512-NEXT:    xorq %r13, %rdx
; AVX512-NEXT:    subq %r13, %rdx
; AVX512-NEXT:    sarq $63, %r15
; AVX512-NEXT:    xorq %r15, %rsi
; AVX512-NEXT:    subq %r15, %rsi
; AVX512-NEXT:    sarq $63, %r14
; AVX512-NEXT:    xorq %r14, %rdi
; AVX512-NEXT:    subq %r14, %rdi
; AVX512-NEXT:    sarq $63, %r11
; AVX512-NEXT:    xorq %r11, %r8
; AVX512-NEXT:    subq %r11, %r8
; AVX512-NEXT:    sarq $63, %r10
; AVX512-NEXT:    xorq %r10, %r9
; AVX512-NEXT:    subq %r10, %r9
; AVX512-NEXT:    vmovq %r9, %xmm0
; AVX512-NEXT:    vmovq %r8, %xmm1
; AVX512-NEXT:    vmovq %rdi, %xmm2
; AVX512-NEXT:    vmovq %rsi, %xmm3
; AVX512-NEXT:    vmovq %rdx, %xmm4
; AVX512-NEXT:    vmovq %rcx, %xmm5
; AVX512-NEXT:    vmovq %rax, %xmm6
; AVX512-NEXT:    vmovq %rbx, %xmm7
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm2[0]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm5[0],xmm4[0]
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm7[0],xmm6[0]
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r12
; AVX512-NEXT:    popq %r13
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    popq %r15
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %aext = zext <8 x i64> %a to <8 x i128>
  %bext = zext <8 x i64> %b to <8 x i128>
  %sub = sub <8 x i128> %aext, %bext
  %abs = call <8 x i128> @llvm.abs.v8i128(<8 x i128> %sub, i1 false)
  %trunc = trunc <8 x i128> %abs to <8 x i64>
  ret <8 x i64> %trunc
}

define <8 x i64> @abd_ext_v8i64_undef(<8 x i64> %a, <8 x i64> %b) nounwind {
; AVX512-LABEL: abd_ext_v8i64_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    pushq %r15
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %r13
; AVX512-NEXT:    pushq %r12
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512-NEXT:    vmovq %xmm2, %rax
; AVX512-NEXT:    vpextrq $1, %xmm2, %rdx
; AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512-NEXT:    vmovq %xmm2, %rsi
; AVX512-NEXT:    vpextrq $1, %xmm2, %rdi
; AVX512-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512-NEXT:    vmovq %xmm2, %r8
; AVX512-NEXT:    vpextrq $1, %xmm2, %r9
; AVX512-NEXT:    vpextrq $1, %xmm1, %rbx
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512-NEXT:    vmovq %xmm2, %rbp
; AVX512-NEXT:    vpextrq $1, %xmm2, %r13
; AVX512-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512-NEXT:    vmovq %xmm2, %r15
; AVX512-NEXT:    vpextrq $1, %xmm2, %r14
; AVX512-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512-NEXT:    vmovq %xmm2, %r11
; AVX512-NEXT:    vpextrq $1, %xmm2, %r10
; AVX512-NEXT:    xorl %r12d, %r12d
; AVX512-NEXT:    subq %r10, %r9
; AVX512-NEXT:    movl $0, %r10d
; AVX512-NEXT:    sbbq %r10, %r10
; AVX512-NEXT:    subq %r11, %r8
; AVX512-NEXT:    movl $0, %r11d
; AVX512-NEXT:    sbbq %r11, %r11
; AVX512-NEXT:    subq %r14, %rdi
; AVX512-NEXT:    movl $0, %r14d
; AVX512-NEXT:    sbbq %r14, %r14
; AVX512-NEXT:    subq %r15, %rsi
; AVX512-NEXT:    movl $0, %r15d
; AVX512-NEXT:    sbbq %r15, %r15
; AVX512-NEXT:    subq %r13, %rdx
; AVX512-NEXT:    movl $0, %r13d
; AVX512-NEXT:    sbbq %r13, %r13
; AVX512-NEXT:    subq %rbp, %rax
; AVX512-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; AVX512-NEXT:    movl $0, %ebp
; AVX512-NEXT:    sbbq %rbp, %rbp
; AVX512-NEXT:    subq %rbx, %rcx
; AVX512-NEXT:    movq %rcx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; AVX512-NEXT:    movl $0, %eax
; AVX512-NEXT:    sbbq %rax, %rax
; AVX512-NEXT:    vmovq %xmm0, %rbx
; AVX512-NEXT:    vmovq %xmm1, %rcx
; AVX512-NEXT:    subq %rcx, %rbx
; AVX512-NEXT:    sbbq %r12, %r12
; AVX512-NEXT:    sarq $63, %r12
; AVX512-NEXT:    xorq %r12, %rbx
; AVX512-NEXT:    subq %r12, %rbx
; AVX512-NEXT:    sarq $63, %rax
; AVX512-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; AVX512-NEXT:    xorq %rax, %rcx
; AVX512-NEXT:    subq %rax, %rcx
; AVX512-NEXT:    movq %rcx, %rax
; AVX512-NEXT:    sarq $63, %rbp
; AVX512-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; AVX512-NEXT:    xorq %rbp, %rcx
; AVX512-NEXT:    subq %rbp, %rcx
; AVX512-NEXT:    sarq $63, %r13
; AVX512-NEXT:    xorq %r13, %rdx
; AVX512-NEXT:    subq %r13, %rdx
; AVX512-NEXT:    sarq $63, %r15
; AVX512-NEXT:    xorq %r15, %rsi
; AVX512-NEXT:    subq %r15, %rsi
; AVX512-NEXT:    sarq $63, %r14
; AVX512-NEXT:    xorq %r14, %rdi
; AVX512-NEXT:    subq %r14, %rdi
; AVX512-NEXT:    sarq $63, %r11
; AVX512-NEXT:    xorq %r11, %r8
; AVX512-NEXT:    subq %r11, %r8
; AVX512-NEXT:    sarq $63, %r10
; AVX512-NEXT:    xorq %r10, %r9
; AVX512-NEXT:    subq %r10, %r9
; AVX512-NEXT:    vmovq %r9, %xmm0
; AVX512-NEXT:    vmovq %r8, %xmm1
; AVX512-NEXT:    vmovq %rdi, %xmm2
; AVX512-NEXT:    vmovq %rsi, %xmm3
; AVX512-NEXT:    vmovq %rdx, %xmm4
; AVX512-NEXT:    vmovq %rcx, %xmm5
; AVX512-NEXT:    vmovq %rax, %xmm6
; AVX512-NEXT:    vmovq %rbx, %xmm7
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm2[0]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm5[0],xmm4[0]
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm7[0],xmm6[0]
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r12
; AVX512-NEXT:    popq %r13
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    popq %r15
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %aext = zext <8 x i64> %a to <8 x i128>
  %bext = zext <8 x i64> %b to <8 x i128>
  %sub = sub <8 x i128> %aext, %bext
  %abs = call <8 x i128> @llvm.abs.v8i128(<8 x i128> %sub, i1 true)
  %trunc = trunc <8 x i128> %abs to <8 x i64>
  ret <8 x i64> %trunc
}

;
; sub(umax(a,b),umin(a,b)) -> abdu(a,b)
;

define <64 x i8> @abd_minmax_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; AVX512BW-LABEL: abd_minmax_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpminub %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmaxub %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsubb %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: abd_minmax_v64i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpminub %ymm1, %ymm0, %ymm2
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512DQ-NEXT:    vpminub %ymm3, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpmaxub %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsubb %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmaxub %ymm3, %ymm4, %ymm1
; AVX512DQ-NEXT:    vpsubb %ymm5, %ymm1, %ymm1
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %min = call <64 x i8> @llvm.umin.v64i8(<64 x i8> %a, <64 x i8> %b)
  %max = call <64 x i8> @llvm.umax.v64i8(<64 x i8> %a, <64 x i8> %b)
  %sub = sub <64 x i8> %max, %min
  ret <64 x i8> %sub
}

define <32 x i16> @abd_minmax_v32i16(<32 x i16> %a, <32 x i16> %b) nounwind {
; AVX512BW-LABEL: abd_minmax_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpminuw %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmaxuw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsubw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: abd_minmax_v32i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpminuw %ymm1, %ymm0, %ymm2
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512DQ-NEXT:    vpminuw %ymm3, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsubw %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmaxuw %ymm3, %ymm4, %ymm1
; AVX512DQ-NEXT:    vpsubw %ymm5, %ymm1, %ymm1
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %min = call <32 x i16> @llvm.umin.v32i16(<32 x i16> %a, <32 x i16> %b)
  %max = call <32 x i16> @llvm.umax.v32i16(<32 x i16> %a, <32 x i16> %b)
  %sub = sub <32 x i16> %max, %min
  ret <32 x i16> %sub
}

define <16 x i32> @abd_minmax_v16i32(<16 x i32> %a, <16 x i32> %b) nounwind {
; AVX512-LABEL: abd_minmax_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminud %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmaxud %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsubd %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %min = call <16 x i32> @llvm.umin.v16i32(<16 x i32> %a, <16 x i32> %b)
  %max = call <16 x i32> @llvm.umax.v16i32(<16 x i32> %a, <16 x i32> %b)
  %sub = sub <16 x i32> %max, %min
  ret <16 x i32> %sub
}

define <8 x i64> @abd_minmax_v8i64(<8 x i64> %a, <8 x i64> %b) nounwind {
; AVX512-LABEL: abd_minmax_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminuq %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsubq %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %min = call <8 x i64> @llvm.umin.v8i64(<8 x i64> %a, <8 x i64> %b)
  %max = call <8 x i64> @llvm.umax.v8i64(<8 x i64> %a, <8 x i64> %b)
  %sub = sub <8 x i64> %max, %min
  ret <8 x i64> %sub
}

declare <64 x i8> @llvm.abs.v64i8(<64 x i8>, i1)
declare <32 x i16> @llvm.abs.v32i16(<32 x i16>, i1)
declare <16 x i32> @llvm.abs.v16i32(<16 x i32>, i1)
declare <8 x i64> @llvm.abs.v8i64(<8 x i64>, i1)
declare <16 x i64> @llvm.abs.v16i64(<16 x i64>, i1)
declare <32 x i64> @llvm.abs.v32i64(<32 x i64>, i1)
declare <64 x i64> @llvm.abs.v64i64(<64 x i64>, i1)
declare <8 x i128> @llvm.abs.v8i128(<8 x i128>, i1)

declare <64 x i8> @llvm.umax.v64i8(<64 x i8>, <64 x i8>)
declare <32 x i16> @llvm.umax.v32i16(<32 x i16>, <32 x i16>)
declare <16 x i32> @llvm.umax.v16i32(<16 x i32>, <16 x i32>)
declare <8 x i64> @llvm.umax.v8i64(<8 x i64>, <8 x i64>)

declare <64 x i8> @llvm.umin.v64i8(<64 x i8>, <64 x i8>)
declare <32 x i16> @llvm.umin.v32i16(<32 x i16>, <32 x i16>)
declare <16 x i32> @llvm.umin.v16i32(<16 x i32>, <16 x i32>)
declare <8 x i64> @llvm.umin.v8i64(<8 x i64>, <8 x i64>)
