; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -amdgpu-atomic-optimizations=false -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=SI %s
; RUN: llc -march=amdgcn -mcpu=tonga -amdgpu-atomic-optimizations=false -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=VI %s
; RUN: llc -march=amdgcn -mcpu=gfx900 -amdgpu-atomic-optimizations=false -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX9 %s

define amdgpu_kernel void @atomic_max_i32_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: atomic_max_i32_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s3, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB0_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_i32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB0_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i32_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x24
; VI-NEXT:    s_load_dword s6, s[0:1], 0x2c
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[8:9], 0x10
; VI-NEXT:    s_add_u32 s0, s8, 16
; VI-NEXT:    s_addc_u32 s1, s9, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB0_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_i32_e32 v0, s6, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB0_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i32_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s5, s[2:3], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_i32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[2:3] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB0_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i32, ptr addrspace(1) %out, i64 4
  %val = atomicrmw volatile max ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i32_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in) {
; SI-LABEL: atomic_max_i32_ret_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s10, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s2, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB1_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_i32_e32 v0, s10, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB1_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i32_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s10, s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[4:5], 0x10
; VI-NEXT:    s_add_u32 s0, s4, 16
; VI-NEXT:    s_addc_u32 s1, s5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB1_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_i32_e32 v0, s10, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; VI-NEXT:    s_cbranch_execnz .LBB1_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[8:9]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i32_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s3, s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_i32_e32 v2, s2, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB1_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i32, ptr addrspace(1) %out, i64 4
  %val = atomicrmw volatile max ptr addrspace(1) %gep, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i32_addr64_offset(ptr addrspace(1) %out, i32 %in, i64 %index) {
; SI-LABEL: atomic_max_i32_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s6, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x4
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB2_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_i32_e32 v0, s6, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB2_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i32_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s6, s[0:1], 0x2c
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x10
; VI-NEXT:    s_add_u32 s0, s0, 16
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB2_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_i32_e32 v0, s6, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB2_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i32_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s6, s0
; GFX9-NEXT:    s_addc_u32 s1, s7, s1
; GFX9-NEXT:    s_load_dword s5, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_i32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB2_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i64 4
  %val = atomicrmw volatile max ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i32_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i64 %index) {
; SI-LABEL: atomic_max_i32_ret_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xf
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s8, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x4
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB3_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_i32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB3_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i32_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s8, s[0:1], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x10
; VI-NEXT:    s_add_u32 s0, s0, 16
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB3_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_i32_e32 v0, s8, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB3_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i32_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_i32_e32 v2, s8, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB3_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i64 4
  %val = atomicrmw volatile max ptr addrspace(1) %gep, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i32(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: atomic_max_i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s3, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB4_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_i32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB4_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s3, s[4:5], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:  .LBB4_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_i32_e32 v0, s2, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB4_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s5, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_i32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[2:3] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB4_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %val = atomicrmw volatile max ptr addrspace(1) %out, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i32_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in) {
; SI-LABEL: atomic_max_i32_ret:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s10, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s2, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB5_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_i32_e32 v0, s10, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB5_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i32_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s10, s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[4:5], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB5_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_i32_e32 v0, s10, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; VI-NEXT:    s_cbranch_execnz .LBB5_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[8:9]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i32_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_i32_e32 v2, s2, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB5_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %val = atomicrmw volatile max ptr addrspace(1) %out, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i32_addr64(ptr addrspace(1) %out, i32 %in, i64 %index) {
; SI-LABEL: atomic_max_i32_addr64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s6, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x0
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB6_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_i32_e32 v0, s6, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB6_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i32_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s6, s[0:1], 0x2c
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x0
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB6_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_i32_e32 v0, s6, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB6_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i32_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s6, s0
; GFX9-NEXT:    s_addc_u32 s1, s7, s1
; GFX9-NEXT:    s_load_dword s5, s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_i32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB6_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %val = atomicrmw volatile max ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i32_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i64 %index) {
; SI-LABEL: atomic_max_i32_ret_addr64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xf
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s8, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x0
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB7_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_i32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB7_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i32_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s8, s[0:1], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x0
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB7_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_i32_e32 v0, s8, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB7_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i32_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_i32_e32 v2, s8, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB7_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %val = atomicrmw volatile max ptr addrspace(1) %ptr, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i32_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: atomic_umax_i32_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s3, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB8_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_u32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB8_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i32_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x24
; VI-NEXT:    s_load_dword s6, s[0:1], 0x2c
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[8:9], 0x10
; VI-NEXT:    s_add_u32 s0, s8, 16
; VI-NEXT:    s_addc_u32 s1, s9, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB8_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_u32_e32 v0, s6, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB8_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i32_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s5, s[2:3], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_u32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[2:3] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB8_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i32, ptr addrspace(1) %out, i64 4
  %val = atomicrmw volatile umax ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i32_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in) {
; SI-LABEL: atomic_umax_i32_ret_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s10, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s2, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB9_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_u32_e32 v0, s10, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB9_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i32_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s10, s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[4:5], 0x10
; VI-NEXT:    s_add_u32 s0, s4, 16
; VI-NEXT:    s_addc_u32 s1, s5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB9_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_u32_e32 v0, s10, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; VI-NEXT:    s_cbranch_execnz .LBB9_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[8:9]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i32_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s3, s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_u32_e32 v2, s2, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB9_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i32, ptr addrspace(1) %out, i64 4
  %val = atomicrmw volatile umax ptr addrspace(1) %gep, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i32_addr64_offset(ptr addrspace(1) %out, i32 %in, i64 %index) {
; SI-LABEL: atomic_umax_i32_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s6, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x4
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB10_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_u32_e32 v0, s6, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB10_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i32_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s6, s[0:1], 0x2c
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x10
; VI-NEXT:    s_add_u32 s0, s0, 16
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB10_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_u32_e32 v0, s6, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB10_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i32_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s6, s0
; GFX9-NEXT:    s_addc_u32 s1, s7, s1
; GFX9-NEXT:    s_load_dword s5, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_u32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB10_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i64 4
  %val = atomicrmw volatile umax ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i32_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i64 %index) {
; SI-LABEL: atomic_umax_i32_ret_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xf
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s8, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x4
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB11_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_u32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB11_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i32_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s8, s[0:1], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x10
; VI-NEXT:    s_add_u32 s0, s0, 16
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB11_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_u32_e32 v0, s8, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB11_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i32_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_u32_e32 v2, s8, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB11_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i64 4
  %val = atomicrmw volatile umax ptr addrspace(1) %gep, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i32(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: atomic_umax_i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s3, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB12_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_u32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB12_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s3, s[4:5], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:  .LBB12_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_u32_e32 v0, s2, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB12_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s5, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_u32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[2:3] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB12_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %val = atomicrmw volatile umax ptr addrspace(1) %out, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i32_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in) {
; SI-LABEL: atomic_umax_i32_ret:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s10, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s2, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB13_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_u32_e32 v0, s10, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB13_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i32_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s10, s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[4:5], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB13_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_u32_e32 v0, s10, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; VI-NEXT:    s_cbranch_execnz .LBB13_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[8:9]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i32_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_u32_e32 v2, s2, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB13_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %val = atomicrmw volatile umax ptr addrspace(1) %out, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i32_addr64(ptr addrspace(1) %out, i32 %in, i64 %index) {
; SI-LABEL: atomic_umax_i32_addr64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s6, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x0
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB14_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_u32_e32 v0, s6, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB14_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i32_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s6, s[0:1], 0x2c
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x0
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB14_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_u32_e32 v0, s6, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB14_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i32_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s6, s0
; GFX9-NEXT:    s_addc_u32 s1, s7, s1
; GFX9-NEXT:    s_load_dword s5, s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_max_u32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB14_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %val = atomicrmw volatile umax ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i32_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i64 %index) {
; SI-LABEL: atomic_umax_i32_ret_addr64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xf
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s8, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x0
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB15_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_max_u32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB15_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i32_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s8, s[0:1], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x0
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB15_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_max_u32_e32 v0, s8, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB15_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i32_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_max_u32_e32 v2, s8, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB15_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %val = atomicrmw volatile umax ptr addrspace(1) %ptr, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i32_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: atomic_min_i32_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s3, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB16_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_i32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB16_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i32_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x24
; VI-NEXT:    s_load_dword s6, s[0:1], 0x2c
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[8:9], 0x10
; VI-NEXT:    s_add_u32 s0, s8, 16
; VI-NEXT:    s_addc_u32 s1, s9, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB16_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_i32_e32 v0, s6, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB16_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i32_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s5, s[2:3], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_min_i32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[2:3] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB16_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i32, ptr addrspace(1) %out, i64 4
  %val = atomicrmw volatile min ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i32_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in) {
; SI-LABEL: atomic_min_i32_ret_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s10, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s2, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB17_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_i32_e32 v0, s10, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB17_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i32_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s10, s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[4:5], 0x10
; VI-NEXT:    s_add_u32 s0, s4, 16
; VI-NEXT:    s_addc_u32 s1, s5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB17_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_i32_e32 v0, s10, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; VI-NEXT:    s_cbranch_execnz .LBB17_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[8:9]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i32_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s3, s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_i32_e32 v2, s2, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB17_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i32, ptr addrspace(1) %out, i64 4
  %val = atomicrmw volatile min ptr addrspace(1) %gep, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i32_addr64_offset(ptr addrspace(1) %out, i32 %in, i64 %index) {
; SI-LABEL: atomic_min_i32_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s6, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x4
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB18_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_i32_e32 v0, s6, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB18_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i32_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s6, s[0:1], 0x2c
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x10
; VI-NEXT:    s_add_u32 s0, s0, 16
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB18_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_i32_e32 v0, s6, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB18_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i32_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s6, s0
; GFX9-NEXT:    s_addc_u32 s1, s7, s1
; GFX9-NEXT:    s_load_dword s5, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_min_i32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB18_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i64 4
  %val = atomicrmw volatile min ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i32_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i64 %index) {
; SI-LABEL: atomic_min_i32_ret_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xf
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s8, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x4
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB19_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_i32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB19_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i32_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s8, s[0:1], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x10
; VI-NEXT:    s_add_u32 s0, s0, 16
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB19_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_i32_e32 v0, s8, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB19_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i32_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_i32_e32 v2, s8, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB19_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i64 4
  %val = atomicrmw volatile min ptr addrspace(1) %gep, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i32(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: atomic_min_i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s3, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB20_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_i32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB20_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s3, s[4:5], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:  .LBB20_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_i32_e32 v0, s2, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB20_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s5, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_min_i32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[2:3] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB20_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %val = atomicrmw volatile min ptr addrspace(1) %out, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i32_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in) {
; SI-LABEL: atomic_min_i32_ret:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s10, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s2, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB21_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_i32_e32 v0, s10, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB21_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i32_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s10, s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[4:5], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB21_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_i32_e32 v0, s10, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; VI-NEXT:    s_cbranch_execnz .LBB21_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[8:9]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i32_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_i32_e32 v2, s2, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB21_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %val = atomicrmw volatile min ptr addrspace(1) %out, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i32_addr64(ptr addrspace(1) %out, i32 %in, i64 %index) {
; SI-LABEL: atomic_min_i32_addr64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s6, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x0
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB22_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_i32_e32 v0, s6, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB22_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i32_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s6, s[0:1], 0x2c
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x0
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB22_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_i32_e32 v0, s6, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB22_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i32_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s6, s0
; GFX9-NEXT:    s_addc_u32 s1, s7, s1
; GFX9-NEXT:    s_load_dword s5, s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_min_i32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB22_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %val = atomicrmw volatile min ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i32_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i64 %index) {
; SI-LABEL: atomic_min_i32_ret_addr64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xf
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s8, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x0
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB23_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_i32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB23_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i32_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s8, s[0:1], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x0
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB23_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_i32_e32 v0, s8, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB23_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i32_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_i32_e32 v2, s8, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB23_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %val = atomicrmw volatile min ptr addrspace(1) %ptr, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i32_offset(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: atomic_umin_i32_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s3, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB24_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_u32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB24_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i32_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x24
; VI-NEXT:    s_load_dword s6, s[0:1], 0x2c
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[8:9], 0x10
; VI-NEXT:    s_add_u32 s0, s8, 16
; VI-NEXT:    s_addc_u32 s1, s9, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB24_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_u32_e32 v0, s6, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB24_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i32_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s5, s[2:3], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_min_u32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[2:3] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB24_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i32, ptr addrspace(1) %out, i64 4
  %val = atomicrmw volatile umin ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umin_i32_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in) {
; SI-LABEL: atomic_umin_i32_ret_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s10, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s2, s[4:5], 0x4
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB25_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_u32_e32 v0, s10, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB25_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i32_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s10, s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[4:5], 0x10
; VI-NEXT:    s_add_u32 s0, s4, 16
; VI-NEXT:    s_addc_u32 s1, s5, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB25_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_u32_e32 v0, s10, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; VI-NEXT:    s_cbranch_execnz .LBB25_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[8:9]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i32_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s3, s[4:5], 0x10
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_u32_e32 v2, s2, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB25_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %gep = getelementptr i32, ptr addrspace(1) %out, i64 4
  %val = atomicrmw volatile umin ptr addrspace(1) %gep, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i32_addr64_offset(ptr addrspace(1) %out, i32 %in, i64 %index) {
; SI-LABEL: atomic_umin_i32_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s6, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x4
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB26_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_u32_e32 v0, s6, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB26_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i32_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s6, s[0:1], 0x2c
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x10
; VI-NEXT:    s_add_u32 s0, s0, 16
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB26_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_u32_e32 v0, s6, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB26_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i32_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s6, s0
; GFX9-NEXT:    s_addc_u32 s1, s7, s1
; GFX9-NEXT:    s_load_dword s5, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_min_u32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB26_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i64 4
  %val = atomicrmw volatile umin ptr addrspace(1) %gep, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umin_i32_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i64 %index) {
; SI-LABEL: atomic_umin_i32_ret_addr64_offset:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xf
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s8, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x4
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB27_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_u32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 offset:16 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB27_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i32_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s8, s[0:1], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x10
; VI-NEXT:    s_add_u32 s0, s0, 16
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB27_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_u32_e32 v0, s8, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB27_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i32_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x10
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_u32_e32 v2, s8, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] offset:16 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB27_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i32, ptr addrspace(1) %ptr, i64 4
  %val = atomicrmw volatile umin ptr addrspace(1) %gep, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i32(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: atomic_umin_i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s2, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s3, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[0:1], 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:  .LBB28_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_u32_e32 v0, s2, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; SI-NEXT:    s_cbranch_execnz .LBB28_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; VI-NEXT:    s_mov_b64 s[0:1], 0
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s3, s[4:5], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:  .LBB28_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_u32_e32 v0, s2, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; VI-NEXT:    s_cbranch_execnz .LBB28_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s5, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_min_u32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[2:3] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB28_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %val = atomicrmw volatile umin ptr addrspace(1) %out, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umin_i32_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in) {
; SI-LABEL: atomic_umin_i32_ret:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s10, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s2, s[4:5], 0x0
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB29_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_u32_e32 v0, s10, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; SI-NEXT:    s_cbranch_execnz .LBB29_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[8:9]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i32_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s10, s[0:1], 0x34
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[4:5], 0x0
; VI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB29_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_u32_e32 v0, s10, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; VI-NEXT:    s_cbranch_execnz .LBB29_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[8:9]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i32_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[0:1], 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_u32_e32 v2, s2, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execnz .LBB29_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %val = atomicrmw volatile umin ptr addrspace(1) %out, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i32_addr64(ptr addrspace(1) %out, i32 %in, i64 %index) {
; SI-LABEL: atomic_umin_i32_addr64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xd
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x9
; SI-NEXT:    s_load_dword s6, s[0:1], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x0
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB30_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_u32_e32 v0, s6, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB30_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i32_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; VI-NEXT:    s_load_dword s6, s[0:1], 0x2c
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x0
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB30_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_u32_e32 v0, s6, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB30_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i32_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s6, s0
; GFX9-NEXT:    s_addc_u32 s1, s7, s1
; GFX9-NEXT:    s_load_dword s5, s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_min_u32_e32 v0, s4, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB30_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %val = atomicrmw volatile umin ptr addrspace(1) %ptr, i32 %in seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umin_i32_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i32 %in, i64 %index) {
; SI-LABEL: atomic_umin_i32_ret_addr64:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0xf
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s8, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; SI-NEXT:    s_add_u32 s0, s4, s0
; SI-NEXT:    s_addc_u32 s1, s5, s1
; SI-NEXT:    s_load_dword s2, s[0:1], 0x0
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s2
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:  .LBB31_1: ; %atomicrmw.start
; SI-NEXT:    ; =>This Inner Loop Header: Depth=1
; SI-NEXT:    v_min_u32_e32 v0, s8, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    v_mov_b32_e32 v2, v0
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_wbinvl1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; SI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v1, v2
; SI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB31_1
; SI-NEXT:  ; %bb.2: ; %atomicrmw.end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s0, s6
; SI-NEXT:    s_mov_b32 s1, s7
; SI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i32_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s8, s[0:1], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_load_dword s2, s[0:1], 0x0
; VI-NEXT:    s_mov_b64 s[4:5], 0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s2
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:  .LBB31_1: ; %atomicrmw.start
; VI-NEXT:    ; =>This Inner Loop Header: Depth=1
; VI-NEXT:    v_min_u32_e32 v0, s8, v1
; VI-NEXT:    v_mov_b32_e32 v3, v1
; VI-NEXT:    v_mov_b32_e32 v2, v0
; VI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; VI-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB31_1
; VI-NEXT:  ; %bb.2: ; %atomicrmw.end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i32_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x3c
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[2:3], 2
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    v_min_u32_e32 v2, s8, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_atomic_cmpswap v0, v1, v[2:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v3
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB31_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i32, ptr addrspace(1) %out, i64 %index
  %val = atomicrmw volatile umin ptr addrspace(1) %ptr, i32 %in seq_cst
  store i32 %val, ptr addrspace(1) %out2
  ret void
}
