; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 -mattr=+sve | FileCheck %s

; Float

declare <vscale x 2 x i32> @llvm.fptosi.sat.nxv2f32.nxv2i32(<vscale x 2 x float>)
declare <vscale x 4 x i32> @llvm.fptosi.sat.nxv4f32.nxv4i32(<vscale x 4 x float>)
declare <vscale x 8 x i32> @llvm.fptosi.sat.nxv8f32.nxv8i32(<vscale x 8 x float>)
declare <vscale x 4 x i16> @llvm.fptosi.sat.nxv4f32.nxv4i16(<vscale x 4 x float>)
declare <vscale x 8 x i16> @llvm.fptosi.sat.nxv8f32.nxv8i16(<vscale x 8 x float>)
declare <vscale x 2 x i64> @llvm.fptosi.sat.nxv2f32.nxv2i64(<vscale x 2 x float>)
declare <vscale x 4 x i64> @llvm.fptosi.sat.nxv4f32.nxv4i64(<vscale x 4 x float>)

define <vscale x 2 x i32> @test_signed_v2f32_v2i32(<vscale x 2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-822083584
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z2.d, #0xffffffff80000000
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    mov w8, #1325400063
; CHECK-NEXT:    fcmge p1.s, p0/z, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    fcvtzs z1.d, p0/m, z0.s
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    fcmgt p1.s, p0/z, z0.s, z2.s
; CHECK-NEXT:    mov z2.d, #0x7fffffff
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    fcmuo p0.s, p0/z, z0.s, z0.s
; CHECK-NEXT:    mov z1.d, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
    %x = call <vscale x 2 x i32> @llvm.fptosi.sat.nxv2f32.nxv2i32(<vscale x 2 x float> %f)
    ret <vscale x 2 x i32> %x
}

define <vscale x 4 x i32> @test_signed_v4f32_v4i32(<vscale x 4 x float> %f) {
; CHECK-LABEL: test_signed_v4f32_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-822083584
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, #0x80000000
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    mov w8, #1325400063
; CHECK-NEXT:    fcmge p1.s, p0/z, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    fcvtzs z1.s, p0/m, z0.s
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z1.s, p1/m, z2.s
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    fcmgt p1.s, p0/z, z0.s, z2.s
; CHECK-NEXT:    mov z2.s, #0x7fffffff
; CHECK-NEXT:    mov z1.s, p1/m, z2.s
; CHECK-NEXT:    fcmuo p0.s, p0/z, z0.s, z0.s
; CHECK-NEXT:    mov z1.s, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
    %x = call <vscale x 4 x i32> @llvm.fptosi.sat.nxv4f32.nxv4i32(<vscale x 4 x float> %f)
    ret <vscale x 4 x i32> %x
}

define <vscale x 8 x i32> @test_signed_v8f32_v8i32(<vscale x 8 x float> %f) {
; CHECK-LABEL: test_signed_v8f32_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-822083584
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov w9, #1325400063
; CHECK-NEXT:    mov z3.s, #0x80000000
; CHECK-NEXT:    movprfx z4, z0
; CHECK-NEXT:    fcvtzs z4.s, p0/m, z0.s
; CHECK-NEXT:    mov z6.s, #0x7fffffff
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    fcmge p1.s, p0/z, z0.s, z2.s
; CHECK-NEXT:    mov z5.s, w9
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    fcmgt p2.s, p0/z, z0.s, z5.s
; CHECK-NEXT:    mov z4.s, p1/m, z3.s
; CHECK-NEXT:    fcmge p1.s, p0/z, z1.s, z2.s
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    movprfx z2, z1
; CHECK-NEXT:    fcvtzs z2.s, p0/m, z1.s
; CHECK-NEXT:    sel z3.s, p1, z3.s, z2.s
; CHECK-NEXT:    fcmgt p1.s, p0/z, z1.s, z5.s
; CHECK-NEXT:    sel z2.s, p2, z6.s, z4.s
; CHECK-NEXT:    mov z3.s, p1/m, z6.s
; CHECK-NEXT:    fcmuo p1.s, p0/z, z0.s, z0.s
; CHECK-NEXT:    fcmuo p0.s, p0/z, z1.s, z1.s
; CHECK-NEXT:    mov z2.s, p1/m, #0 // =0x0
; CHECK-NEXT:    mov z3.s, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    mov z1.d, z3.d
; CHECK-NEXT:    ret
    %x = call <vscale x 8 x i32> @llvm.fptosi.sat.nxv8f32.nxv8i32(<vscale x 8 x float> %f)
    ret <vscale x 8 x i32> %x
}

define <vscale x 4 x i16> @test_signed_v4f32_v4i16(<vscale x 4 x float> %f) {
; CHECK-LABEL: test_signed_v4f32_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-956301312
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    mov w8, #65024
; CHECK-NEXT:    movk w8, #18175, lsl #16
; CHECK-NEXT:    fcmge p1.s, p0/z, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    fcvtzs z1.s, p0/m, z0.s
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z1.s, p1/m, #-32768 // =0xffffffffffff8000
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    fcmgt p1.s, p0/z, z0.s, z2.s
; CHECK-NEXT:    mov z2.s, #32767 // =0x7fff
; CHECK-NEXT:    mov z1.s, p1/m, z2.s
; CHECK-NEXT:    fcmuo p0.s, p0/z, z0.s, z0.s
; CHECK-NEXT:    mov z1.s, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
    %x = call <vscale x 4 x i16> @llvm.fptosi.sat.nxv4f32.nxv4i16(<vscale x 4 x float> %f)
    ret <vscale x 4 x i16> %x
}

define <vscale x 8 x i16> @test_signed_v8f32_v8i16(<vscale x 8 x float> %f) {
; CHECK-LABEL: test_signed_v8f32_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-956301312
; CHECK-NEXT:    mov w9, #65024
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movk w9, #18175, lsl #16
; CHECK-NEXT:    movprfx z4, z1
; CHECK-NEXT:    fcvtzs z4.s, p0/m, z1.s
; CHECK-NEXT:    mov z3.s, #32767 // =0x7fff
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    fcmge p1.s, p0/z, z1.s, z2.s
; CHECK-NEXT:    mov z5.s, w9
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    fcmgt p2.s, p0/z, z1.s, z5.s
; CHECK-NEXT:    mov z4.s, p1/m, #-32768 // =0xffffffffffff8000
; CHECK-NEXT:    fcmge p1.s, p0/z, z0.s, z2.s
; CHECK-NEXT:    movprfx z2, z0
; CHECK-NEXT:    fcvtzs z2.s, p0/m, z0.s
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z2.s, p1/m, #-32768 // =0xffffffffffff8000
; CHECK-NEXT:    fcmgt p1.s, p0/z, z0.s, z5.s
; CHECK-NEXT:    mov z4.s, p2/m, z3.s
; CHECK-NEXT:    mov z2.s, p1/m, z3.s
; CHECK-NEXT:    fcmuo p1.s, p0/z, z1.s, z1.s
; CHECK-NEXT:    fcmuo p0.s, p0/z, z0.s, z0.s
; CHECK-NEXT:    mov z4.s, p1/m, #0 // =0x0
; CHECK-NEXT:    mov z2.s, p0/m, #0 // =0x0
; CHECK-NEXT:    uzp1 z0.h, z2.h, z4.h
; CHECK-NEXT:    ret
    %x = call <vscale x 8 x i16> @llvm.fptosi.sat.nxv8f32.nxv8i16(<vscale x 8 x float> %f)
    ret <vscale x 8 x i16> %x
}

define <vscale x 2 x i64> @test_signed_v2f32_v2i64(<vscale x 2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-553648128
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z2.d, #0x8000000000000000
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    mov w8, #1593835519
; CHECK-NEXT:    fcmge p1.s, p0/z, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    fcvtzs z1.d, p0/m, z0.s
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    fcmgt p1.s, p0/z, z0.s, z2.s
; CHECK-NEXT:    mov z2.d, #0x7fffffffffffffff
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    fcmuo p0.s, p0/z, z0.s, z0.s
; CHECK-NEXT:    mov z1.d, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
    %x = call <vscale x 2 x i64> @llvm.fptosi.sat.nxv2f32.nxv2i64(<vscale x 2 x float> %f)
    ret <vscale x 2 x i64> %x
}

define <vscale x 4 x i64> @test_signed_v4f32_v4i64(<vscale x 4 x float> %f) {
; CHECK-LABEL: test_signed_v4f32_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-553648128
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    uunpklo z3.d, z0.s
; CHECK-NEXT:    mov w9, #1593835519
; CHECK-NEXT:    mov z2.d, #0x8000000000000000
; CHECK-NEXT:    uunpkhi z5.d, z0.s
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    movprfx z0, z3
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z3.s
; CHECK-NEXT:    fcmge p1.s, p0/z, z3.s, z1.s
; CHECK-NEXT:    mov z4.s, w9
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    fcmgt p2.s, p0/z, z3.s, z4.s
; CHECK-NEXT:    mov z0.d, p1/m, z2.d
; CHECK-NEXT:    fcmge p1.s, p0/z, z5.s, z1.s
; CHECK-NEXT:    movprfx z1, z5
; CHECK-NEXT:    fcvtzs z1.d, p0/m, z5.s
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z6.d, #0x7fffffffffffffff
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    fcmgt p1.s, p0/z, z5.s, z4.s
; CHECK-NEXT:    mov z0.d, p2/m, z6.d
; CHECK-NEXT:    mov z1.d, p1/m, z6.d
; CHECK-NEXT:    fcmuo p1.s, p0/z, z3.s, z3.s
; CHECK-NEXT:    fcmuo p0.s, p0/z, z5.s, z5.s
; CHECK-NEXT:    mov z0.d, p1/m, #0 // =0x0
; CHECK-NEXT:    mov z1.d, p0/m, #0 // =0x0
; CHECK-NEXT:    ret
    %x = call <vscale x 4 x i64> @llvm.fptosi.sat.nxv4f32.nxv4i64(<vscale x 4 x float> %f)
    ret <vscale x 4 x i64> %x
}

; Double

declare <vscale x 2 x i32> @llvm.fptosi.sat.nxv2f64.nxv2i32(<vscale x 2 x double>)
declare <vscale x 4 x i32> @llvm.fptosi.sat.nxv4f64.nxv4i32(<vscale x 4 x double>)
declare <vscale x 8 x i32> @llvm.fptosi.sat.nxv8f64.nxv8i32(<vscale x 8 x double>)
declare <vscale x 4 x i16> @llvm.fptosi.sat.nxv4f64.nxv4i16(<vscale x 4 x double>)
declare <vscale x 8 x i16> @llvm.fptosi.sat.nxv8f64.nxv8i16(<vscale x 8 x double>)
declare <vscale x 2 x i64> @llvm.fptosi.sat.nxv2f64.nxv2i64(<vscale x 2 x double>)
declare <vscale x 4 x i64> @llvm.fptosi.sat.nxv4f64.nxv4i64(<vscale x 4 x double>)

define <vscale x 2 x i32> @test_signed_v2f64_v2i32(<vscale x 2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4476578029606273024
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z2.d, #0xffffffff80000000
; CHECK-NEXT:    mov z1.d, x8
; CHECK-NEXT:    mov x8, #281474972516352
; CHECK-NEXT:    movk x8, #16863, lsl #48
; CHECK-NEXT:    fcmge p1.d, p0/z, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    fcvtzs z1.d, p0/m, z0.d
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    mov z2.d, x8
; CHECK-NEXT:    fcmgt p1.d, p0/z, z0.d, z2.d
; CHECK-NEXT:    mov z2.d, #0x7fffffff
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    fcmuo p0.d, p0/z, z0.d, z0.d
; CHECK-NEXT:    mov z1.d, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
    %x = call <vscale x 2 x i32> @llvm.fptosi.sat.nxv2f64.nxv2i32(<vscale x 2 x double> %f)
    ret <vscale x 2 x i32> %x
}

define <vscale x 4 x i32> @test_signed_v4f64_v4i32(<vscale x 4 x double> %f) {
; CHECK-LABEL: test_signed_v4f64_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4476578029606273024
; CHECK-NEXT:    mov x9, #281474972516352
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movk x9, #16863, lsl #48
; CHECK-NEXT:    mov z3.d, #0xffffffff80000000
; CHECK-NEXT:    movprfx z4, z1
; CHECK-NEXT:    fcvtzs z4.d, p0/m, z1.d
; CHECK-NEXT:    mov z2.d, x8
; CHECK-NEXT:    mov z6.d, #0x7fffffff
; CHECK-NEXT:    fcmge p1.d, p0/z, z1.d, z2.d
; CHECK-NEXT:    mov z5.d, x9
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    fcmgt p2.d, p0/z, z1.d, z5.d
; CHECK-NEXT:    mov z4.d, p1/m, z3.d
; CHECK-NEXT:    fcmge p1.d, p0/z, z0.d, z2.d
; CHECK-NEXT:    movprfx z2, z0
; CHECK-NEXT:    fcvtzs z2.d, p0/m, z0.d
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z2.d, p1/m, z3.d
; CHECK-NEXT:    fcmgt p1.d, p0/z, z0.d, z5.d
; CHECK-NEXT:    sel z3.d, p2, z6.d, z4.d
; CHECK-NEXT:    mov z2.d, p1/m, z6.d
; CHECK-NEXT:    fcmuo p1.d, p0/z, z1.d, z1.d
; CHECK-NEXT:    fcmuo p0.d, p0/z, z0.d, z0.d
; CHECK-NEXT:    mov z3.d, p1/m, #0 // =0x0
; CHECK-NEXT:    mov z2.d, p0/m, #0 // =0x0
; CHECK-NEXT:    uzp1 z0.s, z2.s, z3.s
; CHECK-NEXT:    ret
    %x = call <vscale x 4 x i32> @llvm.fptosi.sat.nxv4f64.nxv4i32(<vscale x 4 x double> %f)
    ret <vscale x 4 x i32> %x
}

define <vscale x 8 x i32> @test_signed_v8f64_v8i32(<vscale x 8 x double> %f) {
; CHECK-LABEL: test_signed_v8f64_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4476578029606273024
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z5.d, #0xffffffff80000000
; CHECK-NEXT:    movprfx z6, z1
; CHECK-NEXT:    fcvtzs z6.d, p0/m, z1.d
; CHECK-NEXT:    mov z24.d, #0x7fffffff
; CHECK-NEXT:    mov z4.d, x8
; CHECK-NEXT:    mov x8, #281474972516352
; CHECK-NEXT:    movk x8, #16863, lsl #48
; CHECK-NEXT:    fcmge p1.d, p0/z, z1.d, z4.d
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    fcmge p2.d, p0/z, z0.d, z4.d
; CHECK-NEXT:    mov z6.d, p1/m, z5.d
; CHECK-NEXT:    not p2.b, p0/z, p2.b
; CHECK-NEXT:    mov z7.d, x8
; CHECK-NEXT:    fcmgt p1.d, p0/z, z1.d, z7.d
; CHECK-NEXT:    mov z6.d, p1/m, z24.d
; CHECK-NEXT:    fcmuo p1.d, p0/z, z1.d, z1.d
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    fcvtzs z1.d, p0/m, z0.d
; CHECK-NEXT:    mov z6.d, p1/m, #0 // =0x0
; CHECK-NEXT:    mov z1.d, p2/m, z5.d
; CHECK-NEXT:    fcmgt p2.d, p0/z, z0.d, z7.d
; CHECK-NEXT:    mov z1.d, p2/m, z24.d
; CHECK-NEXT:    fcmge p2.d, p0/z, z3.d, z4.d
; CHECK-NEXT:    fcmuo p1.d, p0/z, z0.d, z0.d
; CHECK-NEXT:    movprfx z0, z3
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z3.d
; CHECK-NEXT:    not p2.b, p0/z, p2.b
; CHECK-NEXT:    mov z1.d, p1/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, p2/m, z5.d
; CHECK-NEXT:    fcmge p2.d, p0/z, z2.d, z4.d
; CHECK-NEXT:    movprfx z4, z2
; CHECK-NEXT:    fcvtzs z4.d, p0/m, z2.d
; CHECK-NEXT:    not p2.b, p0/z, p2.b
; CHECK-NEXT:    fcmgt p1.d, p0/z, z3.d, z7.d
; CHECK-NEXT:    mov z4.d, p2/m, z5.d
; CHECK-NEXT:    fcmgt p2.d, p0/z, z2.d, z7.d
; CHECK-NEXT:    sel z5.d, p1, z24.d, z0.d
; CHECK-NEXT:    mov z4.d, p2/m, z24.d
; CHECK-NEXT:    fcmuo p1.d, p0/z, z3.d, z3.d
; CHECK-NEXT:    fcmuo p0.d, p0/z, z2.d, z2.d
; CHECK-NEXT:    mov z5.d, p1/m, #0 // =0x0
; CHECK-NEXT:    mov z4.d, p0/m, #0 // =0x0
; CHECK-NEXT:    uzp1 z0.s, z1.s, z6.s
; CHECK-NEXT:    uzp1 z1.s, z4.s, z5.s
; CHECK-NEXT:    ret
    %x = call <vscale x 8 x i32> @llvm.fptosi.sat.nxv8f64.nxv8i32(<vscale x 8 x double> %f)
    ret <vscale x 8 x i32> %x
}

define <vscale x 4 x i16> @test_signed_v4f64_v4i16(<vscale x 4 x double> %f) {
; CHECK-LABEL: test_signed_v4f64_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4548635623644200960
; CHECK-NEXT:    mov x9, #281200098803712
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movk x9, #16607, lsl #48
; CHECK-NEXT:    movprfx z4, z1
; CHECK-NEXT:    fcvtzs z4.d, p0/m, z1.d
; CHECK-NEXT:    mov z3.d, #32767 // =0x7fff
; CHECK-NEXT:    mov z2.d, x8
; CHECK-NEXT:    fcmge p1.d, p0/z, z1.d, z2.d
; CHECK-NEXT:    mov z5.d, x9
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    fcmgt p2.d, p0/z, z1.d, z5.d
; CHECK-NEXT:    mov z4.d, p1/m, #-32768 // =0xffffffffffff8000
; CHECK-NEXT:    fcmge p1.d, p0/z, z0.d, z2.d
; CHECK-NEXT:    movprfx z2, z0
; CHECK-NEXT:    fcvtzs z2.d, p0/m, z0.d
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z2.d, p1/m, #-32768 // =0xffffffffffff8000
; CHECK-NEXT:    fcmgt p1.d, p0/z, z0.d, z5.d
; CHECK-NEXT:    mov z4.d, p2/m, z3.d
; CHECK-NEXT:    mov z2.d, p1/m, z3.d
; CHECK-NEXT:    fcmuo p1.d, p0/z, z1.d, z1.d
; CHECK-NEXT:    fcmuo p0.d, p0/z, z0.d, z0.d
; CHECK-NEXT:    mov z4.d, p1/m, #0 // =0x0
; CHECK-NEXT:    mov z2.d, p0/m, #0 // =0x0
; CHECK-NEXT:    uzp1 z0.s, z2.s, z4.s
; CHECK-NEXT:    ret
    %x = call <vscale x 4 x i16> @llvm.fptosi.sat.nxv4f64.nxv4i16(<vscale x 4 x double> %f)
    ret <vscale x 4 x i16> %x
}

define <vscale x 8 x i16> @test_signed_v8f64_v8i16(<vscale x 8 x double> %f) {
; CHECK-LABEL: test_signed_v8f64_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4548635623644200960
; CHECK-NEXT:    mov x9, #281200098803712
; CHECK-NEXT:    movk x9, #16607, lsl #48
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z5, z3
; CHECK-NEXT:    fcvtzs z5.d, p0/m, z3.d
; CHECK-NEXT:    mov z7.d, #32767 // =0x7fff
; CHECK-NEXT:    mov z4.d, x8
; CHECK-NEXT:    fcmge p1.d, p0/z, z3.d, z4.d
; CHECK-NEXT:    mov z6.d, x9
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    fcmgt p2.d, p0/z, z3.d, z6.d
; CHECK-NEXT:    mov z5.d, p1/m, #-32768 // =0xffffffffffff8000
; CHECK-NEXT:    fcmuo p1.d, p0/z, z3.d, z3.d
; CHECK-NEXT:    mov z5.d, p2/m, z7.d
; CHECK-NEXT:    fcmge p2.d, p0/z, z2.d, z4.d
; CHECK-NEXT:    movprfx z3, z2
; CHECK-NEXT:    fcvtzs z3.d, p0/m, z2.d
; CHECK-NEXT:    not p2.b, p0/z, p2.b
; CHECK-NEXT:    mov z3.d, p2/m, #-32768 // =0xffffffffffff8000
; CHECK-NEXT:    fcmgt p2.d, p0/z, z2.d, z6.d
; CHECK-NEXT:    mov z3.d, p2/m, z7.d
; CHECK-NEXT:    fcmge p2.d, p0/z, z1.d, z4.d
; CHECK-NEXT:    mov z5.d, p1/m, #0 // =0x0
; CHECK-NEXT:    fcmuo p1.d, p0/z, z2.d, z2.d
; CHECK-NEXT:    movprfx z2, z1
; CHECK-NEXT:    fcvtzs z2.d, p0/m, z1.d
; CHECK-NEXT:    not p2.b, p0/z, p2.b
; CHECK-NEXT:    mov z2.d, p2/m, #-32768 // =0xffffffffffff8000
; CHECK-NEXT:    fcmge p2.d, p0/z, z0.d, z4.d
; CHECK-NEXT:    movprfx z4, z0
; CHECK-NEXT:    fcvtzs z4.d, p0/m, z0.d
; CHECK-NEXT:    not p2.b, p0/z, p2.b
; CHECK-NEXT:    mov z3.d, p1/m, #0 // =0x0
; CHECK-NEXT:    fcmgt p1.d, p0/z, z1.d, z6.d
; CHECK-NEXT:    mov z4.d, p2/m, #-32768 // =0xffffffffffff8000
; CHECK-NEXT:    fcmgt p2.d, p0/z, z0.d, z6.d
; CHECK-NEXT:    mov z2.d, p1/m, z7.d
; CHECK-NEXT:    mov z4.d, p2/m, z7.d
; CHECK-NEXT:    fcmuo p1.d, p0/z, z1.d, z1.d
; CHECK-NEXT:    fcmuo p0.d, p0/z, z0.d, z0.d
; CHECK-NEXT:    mov z2.d, p1/m, #0 // =0x0
; CHECK-NEXT:    mov z4.d, p0/m, #0 // =0x0
; CHECK-NEXT:    uzp1 z0.s, z3.s, z5.s
; CHECK-NEXT:    uzp1 z1.s, z4.s, z2.s
; CHECK-NEXT:    uzp1 z0.h, z1.h, z0.h
; CHECK-NEXT:    ret
    %x = call <vscale x 8 x i16> @llvm.fptosi.sat.nxv8f64.nxv8i16(<vscale x 8 x double> %f)
    ret <vscale x 8 x i16> %x
}

define <vscale x 2 x i64> @test_signed_v2f64_v2i64(<vscale x 2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4332462841530417152
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z2.d, #0x8000000000000000
; CHECK-NEXT:    mov z1.d, x8
; CHECK-NEXT:    mov x8, #4890909195324358655
; CHECK-NEXT:    fcmge p1.d, p0/z, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    fcvtzs z1.d, p0/m, z0.d
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    mov z2.d, x8
; CHECK-NEXT:    fcmgt p1.d, p0/z, z0.d, z2.d
; CHECK-NEXT:    mov z2.d, #0x7fffffffffffffff
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    fcmuo p0.d, p0/z, z0.d, z0.d
; CHECK-NEXT:    mov z1.d, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
    %x = call <vscale x 2 x i64> @llvm.fptosi.sat.nxv2f64.nxv2i64(<vscale x 2 x double> %f)
    ret <vscale x 2 x i64> %x
}

define <vscale x 4 x i64> @test_signed_v4f64_v4i64(<vscale x 4 x double> %f) {
; CHECK-LABEL: test_signed_v4f64_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4332462841530417152
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov x9, #4890909195324358655
; CHECK-NEXT:    mov z3.d, #0x8000000000000000
; CHECK-NEXT:    movprfx z4, z0
; CHECK-NEXT:    fcvtzs z4.d, p0/m, z0.d
; CHECK-NEXT:    mov z6.d, #0x7fffffffffffffff
; CHECK-NEXT:    mov z2.d, x8
; CHECK-NEXT:    fcmge p1.d, p0/z, z0.d, z2.d
; CHECK-NEXT:    mov z5.d, x9
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    fcmgt p2.d, p0/z, z0.d, z5.d
; CHECK-NEXT:    mov z4.d, p1/m, z3.d
; CHECK-NEXT:    fcmge p1.d, p0/z, z1.d, z2.d
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    movprfx z2, z1
; CHECK-NEXT:    fcvtzs z2.d, p0/m, z1.d
; CHECK-NEXT:    sel z3.d, p1, z3.d, z2.d
; CHECK-NEXT:    fcmgt p1.d, p0/z, z1.d, z5.d
; CHECK-NEXT:    sel z2.d, p2, z6.d, z4.d
; CHECK-NEXT:    mov z3.d, p1/m, z6.d
; CHECK-NEXT:    fcmuo p1.d, p0/z, z0.d, z0.d
; CHECK-NEXT:    fcmuo p0.d, p0/z, z1.d, z1.d
; CHECK-NEXT:    mov z2.d, p1/m, #0 // =0x0
; CHECK-NEXT:    mov z3.d, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    mov z1.d, z3.d
; CHECK-NEXT:    ret
    %x = call <vscale x 4 x i64> @llvm.fptosi.sat.nxv4f64.nxv4i64(<vscale x 4 x double> %f)
    ret <vscale x 4 x i64> %x
}


; half

declare <vscale x 2 x i32> @llvm.fptosi.sat.nxv2f16.nxv2i32(<vscale x 2 x half>)
declare <vscale x 4 x i32> @llvm.fptosi.sat.nxv4f16.nxv4i32(<vscale x 4 x half>)
declare <vscale x 8 x i32> @llvm.fptosi.sat.nxv8f16.nxv8i32(<vscale x 8 x half>)
declare <vscale x 4 x i16> @llvm.fptosi.sat.nxv4f16.nxv4i16(<vscale x 4 x half>)
declare <vscale x 8 x i16> @llvm.fptosi.sat.nxv8f16.nxv8i16(<vscale x 8 x half>)
declare <vscale x 2 x i64> @llvm.fptosi.sat.nxv2f16.nxv2i64(<vscale x 2 x half>)
declare <vscale x 4 x i64> @llvm.fptosi.sat.nxv4f16.nxv4i64(<vscale x 4 x half>)

define <vscale x 2 x i32> @test_signed_v2f16_v2i32(<vscale x 2 x half> %f) {
; CHECK-LABEL: test_signed_v2f16_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #64511
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z2.d, #0xffffffff80000000
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    mov w8, #31743
; CHECK-NEXT:    fcmge p1.h, p0/z, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    fcvtzs z1.d, p0/m, z0.h
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    fcmgt p1.h, p0/z, z0.h, z2.h
; CHECK-NEXT:    mov z2.d, #0x7fffffff
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    fcmuo p0.h, p0/z, z0.h, z0.h
; CHECK-NEXT:    mov z1.d, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
    %x = call <vscale x 2 x i32> @llvm.fptosi.sat.nxv2f16.nxv2i32(<vscale x 2 x half> %f)
    ret <vscale x 2 x i32> %x
}

define <vscale x 4 x i32> @test_signed_v4f16_v4i32(<vscale x 4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #64511
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, #0x80000000
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    mov w8, #31743
; CHECK-NEXT:    fcmge p1.h, p0/z, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    fcvtzs z1.s, p0/m, z0.h
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z1.s, p1/m, z2.s
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    fcmgt p1.h, p0/z, z0.h, z2.h
; CHECK-NEXT:    mov z2.s, #0x7fffffff
; CHECK-NEXT:    mov z1.s, p1/m, z2.s
; CHECK-NEXT:    fcmuo p0.h, p0/z, z0.h, z0.h
; CHECK-NEXT:    mov z1.s, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
    %x = call <vscale x 4 x i32> @llvm.fptosi.sat.nxv4f16.nxv4i32(<vscale x 4 x half> %f)
    ret <vscale x 4 x i32> %x
}

define <vscale x 8 x i32> @test_signed_v8f16_v8i32(<vscale x 8 x half> %f) {
; CHECK-LABEL: test_signed_v8f16_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #64511
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uunpklo z3.s, z0.h
; CHECK-NEXT:    mov w9, #31743
; CHECK-NEXT:    mov z2.s, #0x80000000
; CHECK-NEXT:    uunpkhi z5.s, z0.h
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    movprfx z0, z3
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z3.h
; CHECK-NEXT:    fcmge p1.h, p0/z, z3.h, z1.h
; CHECK-NEXT:    mov z4.h, w9
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    fcmgt p2.h, p0/z, z3.h, z4.h
; CHECK-NEXT:    mov z0.s, p1/m, z2.s
; CHECK-NEXT:    fcmge p1.h, p0/z, z5.h, z1.h
; CHECK-NEXT:    movprfx z1, z5
; CHECK-NEXT:    fcvtzs z1.s, p0/m, z5.h
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z6.s, #0x7fffffff
; CHECK-NEXT:    mov z1.s, p1/m, z2.s
; CHECK-NEXT:    fcmgt p1.h, p0/z, z5.h, z4.h
; CHECK-NEXT:    mov z0.s, p2/m, z6.s
; CHECK-NEXT:    mov z1.s, p1/m, z6.s
; CHECK-NEXT:    fcmuo p1.h, p0/z, z3.h, z3.h
; CHECK-NEXT:    fcmuo p0.h, p0/z, z5.h, z5.h
; CHECK-NEXT:    mov z0.s, p1/m, #0 // =0x0
; CHECK-NEXT:    mov z1.s, p0/m, #0 // =0x0
; CHECK-NEXT:    ret
    %x = call <vscale x 8 x i32> @llvm.fptosi.sat.nxv8f16.nxv8i32(<vscale x 8 x half> %f)
    ret <vscale x 8 x i32> %x
}

define <vscale x 4 x i16> @test_signed_v4f16_v4i16(<vscale x 4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #63488
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    mov w8, #30719
; CHECK-NEXT:    fcmge p1.h, p0/z, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    fcvtzs z1.s, p0/m, z0.h
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    mov z1.s, p1/m, #-32768 // =0xffffffffffff8000
; CHECK-NEXT:    fcmgt p1.h, p0/z, z0.h, z2.h
; CHECK-NEXT:    mov z2.s, #32767 // =0x7fff
; CHECK-NEXT:    mov z1.s, p1/m, z2.s
; CHECK-NEXT:    fcmuo p0.h, p0/z, z0.h, z0.h
; CHECK-NEXT:    mov z1.s, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
    %x = call <vscale x 4 x i16> @llvm.fptosi.sat.nxv4f16.nxv4i16(<vscale x 4 x half> %f)
    ret <vscale x 4 x i16> %x
}

define <vscale x 8 x i16> @test_signed_v8f16_v8i16(<vscale x 8 x half> %f) {
; CHECK-LABEL: test_signed_v8f16_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #63488
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    mov w8, #30719
; CHECK-NEXT:    fcmge p1.h, p0/z, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    fcvtzs z1.h, p0/m, z0.h
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    mov z1.h, p1/m, #-32768 // =0xffffffffffff8000
; CHECK-NEXT:    fcmgt p1.h, p0/z, z0.h, z2.h
; CHECK-NEXT:    mov z2.h, #32767 // =0x7fff
; CHECK-NEXT:    mov z1.h, p1/m, z2.h
; CHECK-NEXT:    fcmuo p0.h, p0/z, z0.h, z0.h
; CHECK-NEXT:    mov z1.h, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
    %x = call <vscale x 8 x i16> @llvm.fptosi.sat.nxv8f16.nxv8i16(<vscale x 8 x half> %f)
    ret <vscale x 8 x i16> %x
}

define <vscale x 2 x i64> @test_signed_v2f16_v2i64(<vscale x 2 x half> %f) {
; CHECK-LABEL: test_signed_v2f16_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #64511
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z2.d, #0x8000000000000000
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    mov w8, #31743
; CHECK-NEXT:    fcmge p1.h, p0/z, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z0
; CHECK-NEXT:    fcvtzs z1.d, p0/m, z0.h
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    fcmgt p1.h, p0/z, z0.h, z2.h
; CHECK-NEXT:    mov z2.d, #0x7fffffffffffffff
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    fcmuo p0.h, p0/z, z0.h, z0.h
; CHECK-NEXT:    mov z1.d, p0/m, #0 // =0x0
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
    %x = call <vscale x 2 x i64> @llvm.fptosi.sat.nxv2f16.nxv2i64(<vscale x 2 x half> %f)
    ret <vscale x 2 x i64> %x
}

define <vscale x 4 x i64> @test_signed_v4f16_v4i64(<vscale x 4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #64511
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    uunpklo z3.d, z0.s
; CHECK-NEXT:    mov w9, #31743
; CHECK-NEXT:    mov z2.d, #0x8000000000000000
; CHECK-NEXT:    uunpkhi z5.d, z0.s
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    movprfx z0, z3
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z3.h
; CHECK-NEXT:    fcmge p1.h, p0/z, z3.h, z1.h
; CHECK-NEXT:    mov z4.h, w9
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    fcmgt p2.h, p0/z, z3.h, z4.h
; CHECK-NEXT:    mov z0.d, p1/m, z2.d
; CHECK-NEXT:    fcmge p1.h, p0/z, z5.h, z1.h
; CHECK-NEXT:    movprfx z1, z5
; CHECK-NEXT:    fcvtzs z1.d, p0/m, z5.h
; CHECK-NEXT:    not p1.b, p0/z, p1.b
; CHECK-NEXT:    mov z6.d, #0x7fffffffffffffff
; CHECK-NEXT:    mov z1.d, p1/m, z2.d
; CHECK-NEXT:    fcmgt p1.h, p0/z, z5.h, z4.h
; CHECK-NEXT:    mov z0.d, p2/m, z6.d
; CHECK-NEXT:    mov z1.d, p1/m, z6.d
; CHECK-NEXT:    fcmuo p1.h, p0/z, z3.h, z3.h
; CHECK-NEXT:    fcmuo p0.h, p0/z, z5.h, z5.h
; CHECK-NEXT:    mov z0.d, p1/m, #0 // =0x0
; CHECK-NEXT:    mov z1.d, p0/m, #0 // =0x0
; CHECK-NEXT:    ret
    %x = call <vscale x 4 x i64> @llvm.fptosi.sat.nxv4f16.nxv4i64(<vscale x 4 x half> %f)
    ret <vscale x 4 x i64> %x
}

