.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtDisplay-Initialize XtOpen-Display XtClose-Display XtDatabase
.hw XtScreen-Database wid-get
.na
.TH XtDisplayInitialize __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtDisplayInitialize, XtOpenDisplay, XtDatabase, XtScreenDatabase, XtCloseDisplay \- initialize, open, or close a display
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
void XtDisplayInitialize(XtAppContext \fIapp_context\fP,
Display *\fIdisplay\fP,
const char *\fIapplication_name\fP,
const char *\fIapplication_class\fP,
XrmOptionDescRec *\fIoptions\fP, Cardinal \fInum_options\fP,
int *\fIargc\fP, char **\fIargv\fP);
.HP
Display *XtOpenDisplay(XtAppContext \fIapp_context\fP,
const char *\fIdisplay_string\fP,
const char *\fIapplication_name\fP,
const char *\fIapplication_class\fP,
XrmOptionDescRec *\fIoptions\fP, Cardinal \fInum_options\fP,
int *\fIargc\fP, char **\fIargv\fP);
.HP
void XtCloseDisplay(Display *\fIdisplay\fP);
.HP
XrmDatabase XtDatabase(Display *\fIdisplay\fP);
.HP
XrmDatabase XtScreenDatabase(Screen* \fIscreen\fP);
.SH ARGUMENTS
.IP \fIargc\fP 1i
Specifies a pointer to the number of command line parameters.
.IP \fIargv\fP 1i
Specifies the command line parameters.
.IP \fIapp_context\fP 1i
Specifies the application context.
.IP \fIapplication_class\fP 1i
Specifies the class name of this application, which usually is the generic name for all instances of this application.
.IP \fIapplication_name\fP 1i
Specifies the name of the application instance.
.IP \fIdisplay\fP 1i
Specifies the display.
Note that a display can be in at most one application context.
.IP \fInum_options\fP 1i
Specifies the number of entries in the options list.
.IP \fIoptions\fP 1i
Specifies how to parse the command line for any application-specific resources.
The options argument is passed as a parameter to
.BR XrmParseCommand .
For further information,
see \fI\*(xL\fP.
.IP \fIscreen\fP 1i
Specifies the screen whose resource database is to be returned.
.SH DESCRIPTION
The
.B XtDisplayInitialize
function builds the resource database, calls the Xlib
.B XrmParseCommand
function to parse the command line,
and performs other per display initialization.
After
.B XrmParseCommand
has been called,
argc and argv contain only those parameters that
were not in the standard option table or in the table specified by the
options argument.
If the modified argc is not zero,
most applications simply print out the modified argv along with a message
listing the allowable options.
On UNIX-based systems,
the application name is usually the final component of argv[0].
If the synchronize resource is
.B True
for the specified application,
.B XtDisplayInitialize
calls the Xlib
.B XSynchronize
function to put Xlib into synchronous mode for this display connection.
If the reverseVideo resource is
.BR True ,
the \*(xI exchange
.B XtDefaultForeground
and
.B XtDefaultBackground
for widgets created on this display.
(See Section 9.6.1).
.LP
The
.B XtOpenDisplay
function calls
.B XOpenDisplay
the specified display name.
If display_string is NULL,
.B XtOpenDisplay
uses the current value of the \-display option specified in argv
and if no display is specified in argv,
uses the user's default display (on UNIX-based systems,
this is the value of the DISPLAY environment variable).
.LP
If this succeeds, it then calls
.B XtDisplayInitialize
and pass it the opened display and
the value of the \-name option specified in argv as the application name.
If no name option is specified,
it uses the application name passed to
.BR XtOpenDisplay .
If the application name is NULL,
it uses the last component of argv[0].
.B XtOpenDisplay
returns the newly opened display or NULL if it failed.
.LP
.B XtOpenDisplay
is provided as a convenience to the application programmer.
.LP
The
.B XtCloseDisplay
function closes the specified display as soon as it is safe to do so.
If called from within an event dispatch (for example, a callback procedure),
.B XtCloseDisplay
does not close the display until the dispatch is complete.
Note that applications need only call
.B XtCloseDisplay
if they are to continue executing after closing the display;
otherwise, they should call
.B XtDestroyApplicationContext
or just exit.
.LP
The
.B XtDatabase
function returns the fully merged resource database that was built by
.B XtDisplayInitialize
associated with the display that was passed in.
If this display has not been initialized by
.BR XtDisplayInitialize ,
the results are not defined.
.LP
The
.B XtScreenDatabase
function returns the fully merged resource database associated with the
specified screen.
If the \fIscreen\fP does not belong to a
.B Display
initialized by
.BR XtDisplayInitialize ,
the results are undefined.
.SH "SEE ALSO"
XtAppCreateShell(__libmansuffix__),
XtCreateApplicationContext(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
