#include "ns_rr.h"

namespace ADNS {

	NS_RR::NS_RR()
	{
		rr_type = RR_TYPE::NS;
		rr_class = RR_CLASS::IN;
		Nsdname = gcnew DOMAIN_NAME();
		UpdateRdata();
	}

	Void NS_RR::SetNsdname(DOMAIN_NAME^ dn)
	{
		Nsdname = gcnew DOMAIN_NAME(dn->GetName());
		UpdateRdata();
		return;
	}

	DOMAIN_NAME^ NS_RR::GetNsdname()
	{
		return Nsdname->Clone();
	}

	String^ NS_RR::Print()
	{
		String^ output;
		output = PrintHeader();
		output += Nsdname->Print();

		return output;
	}

	Void NS_RR::UpdateRdata()
	{
		if (!rdata)
			rdata = gcnew array<Byte>(Nsdname->GetName()->Length);
		else
			rdata->Resize(rdata,Nsdname->GetName()->Length);

		Nsdname->GetName()->CopyTo(rdata,0);

		return;
	}
	
	Void NS_RR::ToCanonical()
	{
		Nsdname->MakeCanonical();
		owner->MakeCanonical();
		UpdateRdata();
		return;
	}

	NS_RR^ NS_RR::Clone()
	{
		NS_RR^ newrr = gcnew NS_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->Nsdname = Nsdname->Clone();
		newrr->UpdateRdata();
		return newrr;
	}

	ResourceRecord^ NS_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		NS_RR^ nsout;
		array<Byte>^ tmparray;
		int reallen;

		nsout = gcnew NS_RR();
		nsout->owner = gcnew DOMAIN_NAME(domainname);
		nsout->rr_class = (RR_CLASS) rr_class;
		nsout->ttl = ttl;
		tmparray = ReadDomainFromPacket(packet, rdata_start, reallen);
		nsout->SetNsdname(gcnew DOMAIN_NAME(tmparray));
		return nsout;
	}

	String^ NS_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<NS_RR^>(rec)->Print();
	}

	ResourceRecord^ NS_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<NS_RR^>(rec)->Clone();
	}
}