/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;

public class LDAPAttributeSet
implements Cloneable,
Serializable {
    static final long serialVersionUID = 5018474561697778100L;
    Hashtable<String, LDAPAttribute> attrHash = null;
    LDAPAttribute[] attrs = new LDAPAttribute[0];
    static final int ATTR_COUNT_REQUIRES_HASH = 5;

    public LDAPAttributeSet() {
    }

    public LDAPAttributeSet(LDAPAttribute[] attrs) {
        this.attrs = attrs;
    }

    public synchronized Object clone() {
        try {
            LDAPAttributeSet attributeSet = new LDAPAttributeSet();
            attributeSet.attrs = new LDAPAttribute[this.attrs.length];
            for (int i = 0; i < this.attrs.length; ++i) {
                attributeSet.attrs[i] = new LDAPAttribute(this.attrs[i]);
            }
            return attributeSet;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<LDAPAttribute> getAttributes() {
        Vector<LDAPAttribute> v = new Vector<LDAPAttribute>();
        LDAPAttributeSet lDAPAttributeSet = this;
        synchronized (lDAPAttributeSet) {
            for (int i = 0; i < this.attrs.length; ++i) {
                v.addElement(this.attrs[i]);
            }
        }
        return v.elements();
    }

    public LDAPAttributeSet getSubset(String subtype) {
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        if (subtype == null) {
            return attrs;
        }
        StringTokenizer st = new StringTokenizer(subtype, ";");
        if (st.countTokens() < 1) {
            return attrs;
        }
        String[] searchTypes = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            searchTypes[i] = (String)st.nextElement();
            ++i;
        }
        Enumeration<LDAPAttribute> attrEnum = this.getAttributes();
        while (attrEnum.hasMoreElements()) {
            LDAPAttribute attr = attrEnum.nextElement();
            if (!attr.hasSubtypes(searchTypes)) continue;
            attrs.add(new LDAPAttribute(attr));
        }
        return attrs;
    }

    public LDAPAttribute getAttribute(String attrName) {
        this.prepareHashtable();
        if (this.attrHash != null) {
            return this.attrHash.get(attrName.toLowerCase());
        }
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!attrName.equalsIgnoreCase(this.attrs[i].getName())) continue;
            return this.attrs[i];
        }
        return null;
    }

    private void prepareHashtable() {
        if (this.attrHash == null && this.attrs.length >= 5) {
            this.attrHash = new Hashtable();
            for (int j = 0; j < this.attrs.length; ++j) {
                this.attrHash.put(this.attrs[j].getName().toLowerCase(), this.attrs[j]);
            }
        }
    }

    public LDAPAttribute getAttribute(String attrName, String lang) {
        if (lang == null || lang.length() < 1) {
            return this.getAttribute(attrName);
        }
        String langLower = lang.toLowerCase();
        if (langLower.length() < 5 || !langLower.substring(0, 5).equals("lang-")) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(langLower, "-");
        st.nextToken();
        String[] langComponents = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            langComponents[i] = st.nextToken();
            ++i;
        }
        String searchBasename = LDAPAttribute.getBaseName(attrName);
        String[] searchTypes = LDAPAttribute.getSubtypes(attrName);
        LDAPAttribute found = null;
        int matchCount = 0;
        for (i = 0; i < this.attrs.length; ++i) {
            boolean isCandidate = false;
            LDAPAttribute attr = this.attrs[i];
            if (attr.getBaseName().equalsIgnoreCase(searchBasename)) {
                if (searchTypes == null || searchTypes.length < 1) {
                    isCandidate = true;
                } else if (attr.hasSubtypes(searchTypes)) {
                    isCandidate = true;
                }
            }
            String attrLang = null;
            if (!isCandidate) continue;
            attrLang = attr.getLangSubtype();
            if (attrLang == null) {
                found = attr;
                continue;
            }
            st = new StringTokenizer(attrLang.toLowerCase(), "-");
            st.nextToken();
            if (st.countTokens() > langComponents.length) continue;
            int j = 0;
            while (st.hasMoreTokens()) {
                if (!langComponents[j].equals(st.nextToken())) {
                    j = 0;
                    break;
                }
                ++j;
            }
            if (j <= matchCount) continue;
            found = attr;
            matchCount = j;
        }
        return found;
    }

    public LDAPAttribute elementAt(int index) {
        return this.attrs[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElementAt(int index) {
        if (index >= 0 && index < this.attrs.length) {
            LDAPAttributeSet lDAPAttributeSet = this;
            synchronized (lDAPAttributeSet) {
                LDAPAttribute[] vals = new LDAPAttribute[this.attrs.length - 1];
                int j = 0;
                for (int i = 0; i < this.attrs.length; ++i) {
                    if (i == index) continue;
                    vals[j++] = this.attrs[i];
                }
                if (this.attrHash != null) {
                    this.attrHash.remove(this.attrs[index].getName().toLowerCase());
                }
                this.attrs = vals;
            }
        }
    }

    public int size() {
        return this.attrs.length;
    }

    public synchronized void add(LDAPAttribute attr) {
        if (attr != null) {
            LDAPAttribute[] vals = new LDAPAttribute[this.attrs.length + 1];
            for (int i = 0; i < this.attrs.length; ++i) {
                vals[i] = this.attrs[i];
            }
            vals[this.attrs.length] = attr;
            this.attrs = vals;
            if (this.attrHash != null) {
                this.attrHash.put(attr.getName().toLowerCase(), attr);
            }
        }
    }

    public synchronized void remove(String name) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!name.equalsIgnoreCase(this.attrs[i].getName())) continue;
            this.removeElementAt(i);
            break;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LDAPAttributeSet: ");
        for (int i = 0; i < this.attrs.length; ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(this.attrs[i].toString());
        }
        return sb.toString();
    }
}

