"""Generated message classes for toolresults version v1beta3.

Reads and publishes results from Firebase Test Lab.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages


package = 'toolresults'


class AndroidAppInfo(_messages.Message):
  r"""Android app information.

  Fields:
    name: The name of the app. Optional
    packageName: The package name of the app. Required.
    versionCode: The internal version code of the app. Optional.
    versionName: The version name of the app. Optional.
  """

  name = _messages.StringField(1)
  packageName = _messages.StringField(2)
  versionCode = _messages.StringField(3)
  versionName = _messages.StringField(4)


class AndroidInstrumentationTest(_messages.Message):
  r"""A test of an Android application that can control an Android component
  independently of its normal lifecycle.  See  for more information on types
  of Android tests.

  Fields:
    testPackageId: The java package for the test to be executed. Required
    testRunnerClass: The InstrumentationTestRunner class. Required
    testTargets: Each target must be fully qualified with the package name or
      class name, in one of these formats: - "package package_name" - "class
      package_name.class_name" - "class package_name.class_name#method_name"
      If empty, all targets in the module will be run.
    useOrchestrator: The flag indicates whether Android Test Orchestrator will
      be used to run test or not.
  """

  testPackageId = _messages.StringField(1)
  testRunnerClass = _messages.StringField(2)
  testTargets = _messages.StringField(3, repeated=True)
  useOrchestrator = _messages.BooleanField(4)


class AndroidRoboTest(_messages.Message):
  r"""A test of an android application that explores the application on a
  virtual or physical Android device, finding culprits and crashes as it goes.

  Fields:
    appInitialActivity: The initial activity that should be used to start the
      app. Optional
    bootstrapPackageId: The java package for the bootstrap. Optional
    bootstrapRunnerClass: The runner class for the bootstrap. Optional
    maxDepth: The max depth of the traversal stack Robo can explore. Optional
    maxSteps: The max number of steps/actions Robo can execute. Default is no
      limit (0). Optional
  """

  appInitialActivity = _messages.StringField(1)
  bootstrapPackageId = _messages.StringField(2)
  bootstrapRunnerClass = _messages.StringField(3)
  maxDepth = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  maxSteps = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class AndroidTest(_messages.Message):
  r"""An Android mobile test specification.

  Fields:
    androidAppInfo: Information about the application under test.
    androidInstrumentationTest: An Android instrumentation test.
    androidRoboTest: An Android robo test.
    testTimeout: Max time a test is allowed to run before it is automatically
      cancelled.
  """

  androidAppInfo = _messages.MessageField('AndroidAppInfo', 1)
  androidInstrumentationTest = _messages.MessageField('AndroidInstrumentationTest', 2)
  androidRoboTest = _messages.MessageField('AndroidRoboTest', 3)
  testTimeout = _messages.MessageField('Duration', 4)


class Any(_messages.Message):
  r"""`Any` contains an arbitrary serialized protocol buffer message along
  with a URL that describes the type of the serialized message.  Protobuf
  library provides support to pack/unpack Any values in the form of utility
  functions or additional generated methods of the Any type.  Example 1: Pack
  and unpack a message in C++.  Foo foo = ...; Any any; any.PackFrom(foo); ...
  if (any.UnpackTo(&foo)) { ... }  Example 2: Pack and unpack a message in
  Java.  Foo foo = ...; Any any = Any.pack(foo); ... if (any.is(Foo.class)) {
  foo = any.unpack(Foo.class); }  Example 3: Pack and unpack a message in
  Python.  foo = Foo(...) any = Any() any.Pack(foo) ... if
  any.Is(Foo.DESCRIPTOR): any.Unpack(foo) ...  Example 4: Pack and unpack a
  message in Go  foo := &pb.Foo{...} any, err := ptypes.MarshalAny(foo) ...
  foo := &pb.Foo{} if err := ptypes.UnmarshalAny(any, foo); err != nil { ... }
  The pack methods provided by protobuf library will by default use
  'type.googleapis.com/full.type.name' as the type URL and the unpack methods
  only use the fully qualified type name after the last '/' in the type URL,
  for example "foo.bar.com/x/y.z" will yield type name "y.z".    JSON ==== The
  JSON representation of an `Any` value uses the regular representation of the
  deserialized, embedded message, with an additional field `@type` which
  contains the type URL. Example:  package google.profile; message Person {
  string first_name = 1; string last_name = 2; }  { "@type":
  "type.googleapis.com/google.profile.Person", "firstName": , "lastName":  }
  If the embedded message type is well-known and has a custom JSON
  representation, that representation will be embedded adding a field `value`
  which holds the custom JSON in addition to the `@type` field. Example (for
  message [google.protobuf.Duration][]):  { "@type":
  "type.googleapis.com/google.protobuf.Duration", "value": "1.212s" }

  Fields:
    typeUrl: A URL/resource name that uniquely identifies the type of the
      serialized protocol buffer message. The last segment of the URL's path
      must represent the fully qualified name of the type (as in
      `path/google.protobuf.Duration`). The name should be in a canonical form
      (e.g., leading "." is not accepted).  In practice, teams usually
      precompile into the binary all types that they expect it to use in the
      context of Any. However, for URLs which use the scheme `http`, `https`,
      or no scheme, one can optionally set up a type server that maps type
      URLs to message definitions as follows:  * If no scheme is provided,
      `https` is assumed. * An HTTP GET on the URL must yield a
      [google.protobuf.Type][] value in binary format, or produce an error. *
      Applications are allowed to cache lookup results based on the URL, or
      have them precompiled into a binary to avoid any lookup. Therefore,
      binary compatibility needs to be preserved on changes to types. (Use
      versioned type names to manage breaking changes.)  Note: this
      functionality is not currently available in the official protobuf
      release, and it is not used for type URLs beginning with
      type.googleapis.com.  Schemes other than `http`, `https` (or the empty
      scheme) might be used with implementation specific semantics.
    value: Must be a valid serialized protocol buffer of the above specified
      type.
  """

  typeUrl = _messages.StringField(1)
  value = _messages.BytesField(2)


class AppStartTime(_messages.Message):
  r"""A AppStartTime object.

  Fields:
    fullyDrawnTime: Optional. The time from app start to reaching the
      developer-reported "fully drawn" time. This is only stored if the app
      includes a call to Activity.reportFullyDrawn(). See
      https://developer.android.com/topic/performance/launch-time.html#time-
      full
    initialDisplayTime: The time from app start to the first displayed
      activity being drawn, as reported in Logcat. See
      https://developer.android.com/topic/performance/launch-time.html#time-
      initial
  """

  fullyDrawnTime = _messages.MessageField('Duration', 1)
  initialDisplayTime = _messages.MessageField('Duration', 2)


class BasicPerfSampleSeries(_messages.Message):
  r"""Encapsulates the metadata for basic sample series represented by a line
  chart

  Enums:
    PerfMetricTypeValueValuesEnum:
    PerfUnitValueValuesEnum:
    SampleSeriesLabelValueValuesEnum:

  Fields:
    perfMetricType: A PerfMetricTypeValueValuesEnum attribute.
    perfUnit: A PerfUnitValueValuesEnum attribute.
    sampleSeriesLabel: A SampleSeriesLabelValueValuesEnum attribute.
  """

  class PerfMetricTypeValueValuesEnum(_messages.Enum):
    r"""PerfMetricTypeValueValuesEnum enum type.

    Values:
      cpu: <no description>
      graphics: <no description>
      memory: <no description>
      network: <no description>
      perfMetricTypeUnspecified: <no description>
    """
    cpu = 0
    graphics = 1
    memory = 2
    network = 3
    perfMetricTypeUnspecified = 4

  class PerfUnitValueValuesEnum(_messages.Enum):
    r"""PerfUnitValueValuesEnum enum type.

    Values:
      byte: <no description>
      bytesPerSecond: <no description>
      framesPerSecond: <no description>
      kibibyte: <no description>
      percent: <no description>
      perfUnitUnspecified: <no description>
    """
    byte = 0
    bytesPerSecond = 1
    framesPerSecond = 2
    kibibyte = 3
    percent = 4
    perfUnitUnspecified = 5

  class SampleSeriesLabelValueValuesEnum(_messages.Enum):
    r"""SampleSeriesLabelValueValuesEnum enum type.

    Values:
      cpuKernel: <no description>
      cpuTotal: <no description>
      cpuUser: <no description>
      graphicsFrameRate: <no description>
      memoryRssPrivate: <no description>
      memoryRssShared: <no description>
      memoryRssTotal: <no description>
      memoryTotal: <no description>
      networkReceived: <no description>
      networkSent: <no description>
      ntBytesReceived: <no description>
      ntBytesTransferred: <no description>
      sampleSeriesTypeUnspecified: <no description>
    """
    cpuKernel = 0
    cpuTotal = 1
    cpuUser = 2
    graphicsFrameRate = 3
    memoryRssPrivate = 4
    memoryRssShared = 5
    memoryRssTotal = 6
    memoryTotal = 7
    networkReceived = 8
    networkSent = 9
    ntBytesReceived = 10
    ntBytesTransferred = 11
    sampleSeriesTypeUnspecified = 12

  perfMetricType = _messages.EnumField('PerfMetricTypeValueValuesEnum', 1)
  perfUnit = _messages.EnumField('PerfUnitValueValuesEnum', 2)
  sampleSeriesLabel = _messages.EnumField('SampleSeriesLabelValueValuesEnum', 3)


class BatchCreatePerfSamplesRequest(_messages.Message):
  r"""The request must provide up to a maximum of 5000 samples to be created;
  a larger sample size will cause an INVALID_ARGUMENT error

  Fields:
    perfSamples: The set of PerfSamples to create should not include existing
      timestamps
  """

  perfSamples = _messages.MessageField('PerfSample', 1, repeated=True)


class BatchCreatePerfSamplesResponse(_messages.Message):
  r"""A BatchCreatePerfSamplesResponse object.

  Fields:
    perfSamples: A PerfSample attribute.
  """

  perfSamples = _messages.MessageField('PerfSample', 1, repeated=True)


class CPUInfo(_messages.Message):
  r"""A CPUInfo object.

  Fields:
    cpuProcessor: description of the device processor ie '1.8 GHz hexa core
      64-bit ARMv8-A'
    cpuSpeedInGhz: the CPU clock speed in GHz
    numberOfCores: the number of CPU cores
  """

  cpuProcessor = _messages.StringField(1)
  cpuSpeedInGhz = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  numberOfCores = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class Duration(_messages.Message):
  r"""A Duration represents a signed, fixed-length span of time represented as
  a count of seconds and fractions of seconds at nanosecond resolution. It is
  independent of any calendar and concepts like "day" or "month". It is
  related to Timestamp in that the difference between two Timestamp values is
  a Duration and it can be added or subtracted from a Timestamp. Range is
  approximately +-10,000 years.  # Examples  Example 1: Compute Duration from
  two Timestamps in pseudo code.  Timestamp start = ...; Timestamp end = ...;
  Duration duration = ...;  duration.seconds = end.seconds - start.seconds;
  duration.nanos = end.nanos - start.nanos;  if (duration.seconds  0) {
  duration.seconds += 1; duration.nanos -= 1000000000; } else if
  (durations.seconds > 0 && duration.nanos < 0) { duration.seconds -= 1;
  duration.nanos += 1000000000; }  Example 2: Compute Timestamp from Timestamp
  + Duration in pseudo code.  Timestamp start = ...; Duration duration = ...;
  Timestamp end = ...;  end.seconds = start.seconds + duration.seconds;
  end.nanos = start.nanos + duration.nanos;  if (end.nanos = 1000000000) {
  end.seconds += 1; end.nanos -= 1000000000; }  Example 3: Compute Duration
  from datetime.timedelta in Python.  td = datetime.timedelta(days=3,
  minutes=10) duration = Duration() duration.FromTimedelta(td)  # JSON Mapping
  In JSON format, the Duration type is encoded as a string rather than an
  object, where the string ends in the suffix "s" (indicating seconds) and is
  preceded by the number of seconds, with nanoseconds expressed as fractional
  seconds. For example, 3 seconds with 0 nanoseconds should be encoded in JSON
  format as "3s", while 3 seconds and 1 nanosecond should be expressed in JSON
  format as "3.000000001s", and 3 seconds and 1 microsecond should be
  expressed in JSON format as "3.000001s".

  Fields:
    nanos: Signed fractions of a second at nanosecond resolution of the span
      of time. Durations less than one second are represented with a 0
      `seconds` field and a positive or negative `nanos` field. For durations
      of one second or more, a non-zero value for the `nanos` field must be of
      the same sign as the `seconds` field. Must be from -999,999,999 to
      +999,999,999 inclusive.
    seconds: Signed seconds of the span of time. Must be from -315,576,000,000
      to +315,576,000,000 inclusive. Note: these bounds are computed from: 60
      sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
  """

  nanos = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(2)


class Execution(_messages.Message):
  r"""An Execution represents a collection of Steps. For instance, it could
  represent: - a mobile test executed across a range of device configurations
  - a jenkins job with a build step followed by a test step  The maximum size
  of an execution message is 1 MiB.  An Execution can be updated until its
  state is set to COMPLETE at which point it becomes immutable.

  Enums:
    StateValueValuesEnum: The initial state is IN_PROGRESS.  The only legal
      state transitions is from IN_PROGRESS to COMPLETE.  A
      PRECONDITION_FAILED will be returned if an invalid transition is
      requested.  The state can only be set to COMPLETE once. A
      FAILED_PRECONDITION will be returned if the state is set to COMPLETE
      multiple times.  If the state is set to COMPLETE, all the in-progress
      steps within the execution will be set as COMPLETE. If the outcome of
      the step is not set, the outcome will be set to INCONCLUSIVE.  - In
      response always set - In create/update request: optional

  Fields:
    completionTime: The time when the Execution status transitioned to
      COMPLETE.  This value will be set automatically when state transitions
      to COMPLETE.  - In response: set if the execution state is COMPLETE. -
      In create/update request: never set
    creationTime: The time when the Execution was created.  This value will be
      set automatically when CreateExecution is called.  - In response: always
      set - In create/update request: never set
    executionId: A unique identifier within a History for this Execution.
      Returns INVALID_ARGUMENT if this field is set or overwritten by the
      caller.  - In response always set - In create/update request: never set
    outcome: Classify the result, for example into SUCCESS or FAILURE  - In
      response: present if set by create/update request - In create/update
      request: optional
    specification: Lightweight information about execution request.  - In
      response: present if set by create - In create: optional - In update:
      optional
    state: The initial state is IN_PROGRESS.  The only legal state transitions
      is from IN_PROGRESS to COMPLETE.  A PRECONDITION_FAILED will be returned
      if an invalid transition is requested.  The state can only be set to
      COMPLETE once. A FAILED_PRECONDITION will be returned if the state is
      set to COMPLETE multiple times.  If the state is set to COMPLETE, all
      the in-progress steps within the execution will be set as COMPLETE. If
      the outcome of the step is not set, the outcome will be set to
      INCONCLUSIVE.  - In response always set - In create/update request:
      optional
    testExecutionMatrixId: TestExecution Matrix ID that the
      TestExecutionService uses.  - In response: present if set by create - In
      create: optional - In update: never set
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The initial state is IN_PROGRESS.  The only legal state transitions is
    from IN_PROGRESS to COMPLETE.  A PRECONDITION_FAILED will be returned if
    an invalid transition is requested.  The state can only be set to COMPLETE
    once. A FAILED_PRECONDITION will be returned if the state is set to
    COMPLETE multiple times.  If the state is set to COMPLETE, all the in-
    progress steps within the execution will be set as COMPLETE. If the
    outcome of the step is not set, the outcome will be set to INCONCLUSIVE.
    - In response always set - In create/update request: optional

    Values:
      complete: <no description>
      inProgress: <no description>
      pending: <no description>
      unknownState: <no description>
    """
    complete = 0
    inProgress = 1
    pending = 2
    unknownState = 3

  completionTime = _messages.MessageField('Timestamp', 1)
  creationTime = _messages.MessageField('Timestamp', 2)
  executionId = _messages.StringField(3)
  outcome = _messages.MessageField('Outcome', 4)
  specification = _messages.MessageField('Specification', 5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  testExecutionMatrixId = _messages.StringField(7)


class FailureDetail(_messages.Message):
  r"""A FailureDetail object.

  Fields:
    crashed: If the failure was severe because the system (app) under test
      crashed.
    notInstalled: If an app is not installed and thus no test can be run with
      the app. This might be caused by trying to run a test on an unsupported
      platform.
    otherNativeCrash: If a native process (including any other than the app)
      crashed.
    timedOut: If the test overran some time limit, and that is why it failed.
    unableToCrawl: If the robo was unable to crawl the app; perhaps because
      the app did not start.
  """

  crashed = _messages.BooleanField(1)
  notInstalled = _messages.BooleanField(2)
  otherNativeCrash = _messages.BooleanField(3)
  timedOut = _messages.BooleanField(4)
  unableToCrawl = _messages.BooleanField(5)


class FileReference(_messages.Message):
  r"""A reference to a file.

  Fields:
    fileUri: The URI of a file stored in Google Cloud Storage.  For example:
      http://storage.googleapis.com/mybucket/path/to/test.xml or in gsutil
      format: gs://mybucket/path/to/test.xml with version-specific info,
      gs://mybucket/path/to/test.xml#1360383693690000  An INVALID_ARGUMENT
      error will be returned if the URI format is not supported.  - In
      response: always set - In create/update request: always set
  """

  fileUri = _messages.StringField(1)


class GraphicsStats(_messages.Message):
  r"""Graphics statistics for the App. The information is collected from 'adb
  shell dumpsys graphicsstats'. For more info see:
  https://developer.android.com/training/testing/performance.html Statistics
  will only be present for API 23+.

  Fields:
    buckets: Histogram of frame render times. There should be 154 buckets
      ranging from [5ms, 6ms) to [4950ms, infinity)
    highInputLatencyCount: Total "high input latency" events.
    jankyFrames: Total frames with slow render time. Should be <=
      total_frames.
    missedVsyncCount: Total "missed vsync" events.
    p50Millis: 50th percentile frame render time in milliseconds.
    p90Millis: 90th percentile frame render time in milliseconds.
    p95Millis: 95th percentile frame render time in milliseconds.
    p99Millis: 99th percentile frame render time in milliseconds.
    slowBitmapUploadCount: Total "slow bitmap upload" events.
    slowDrawCount: Total "slow draw" events.
    slowUiThreadCount: Total "slow UI thread" events.
    totalFrames: Total frames rendered by package.
  """

  buckets = _messages.MessageField('GraphicsStatsBucket', 1, repeated=True)
  highInputLatencyCount = _messages.IntegerField(2)
  jankyFrames = _messages.IntegerField(3)
  missedVsyncCount = _messages.IntegerField(4)
  p50Millis = _messages.IntegerField(5)
  p90Millis = _messages.IntegerField(6)
  p95Millis = _messages.IntegerField(7)
  p99Millis = _messages.IntegerField(8)
  slowBitmapUploadCount = _messages.IntegerField(9)
  slowDrawCount = _messages.IntegerField(10)
  slowUiThreadCount = _messages.IntegerField(11)
  totalFrames = _messages.IntegerField(12)


class GraphicsStatsBucket(_messages.Message):
  r"""A GraphicsStatsBucket object.

  Fields:
    frameCount: Number of frames in the bucket.
    renderMillis: Lower bound of render time in milliseconds.
  """

  frameCount = _messages.IntegerField(1)
  renderMillis = _messages.IntegerField(2)


class History(_messages.Message):
  r"""A History represents a sorted list of Executions ordered by the
  start_timestamp_millis field (descending). It can be used to group all the
  Executions of a continuous build.  Note that the ordering only operates on
  one-dimension. If a repository has multiple branches, it means that multiple
  histories will need to be used in order to order Executions per branch.

  Fields:
    displayName: A short human-readable (plain text) name to display in the
      UI. Maximum of 100 characters.  - In response: present if set during
      create. - In create request: optional
    historyId: A unique identifier within a project for this History.  Returns
      INVALID_ARGUMENT if this field is set or overwritten by the caller.  -
      In response always set - In create request: never set
    name: A name to uniquely identify a history within a project. Maximum of
      200 characters.  - In response always set - In create request: always
      set
  """

  displayName = _messages.StringField(1)
  historyId = _messages.StringField(2)
  name = _messages.StringField(3)


class Image(_messages.Message):
  r"""An image, with a link to the main image and a thumbnail.

  Fields:
    error: An error explaining why the thumbnail could not be rendered.
    sourceImage: A reference to the full-size, original image.  This is the
      same as the tool_outputs entry for the image under its Step.  Always
      set.
    stepId: The step to which the image is attached.  Always set.
    thumbnail: The thumbnail.
  """

  error = _messages.MessageField('Status', 1)
  sourceImage = _messages.MessageField('ToolOutputReference', 2)
  stepId = _messages.StringField(3)
  thumbnail = _messages.MessageField('Thumbnail', 4)


class InconclusiveDetail(_messages.Message):
  r"""A InconclusiveDetail object.

  Fields:
    abortedByUser: If the end user aborted the test execution before a pass or
      fail could be determined. For example, the user pressed ctrl-c which
      sent a kill signal to the test runner while the test was running.
    infrastructureFailure: If the test runner could not determine success or
      failure because the test depends on a component other than the system
      under test which failed.  For example, a mobile test requires
      provisioning a device where the test executes, and that provisioning can
      fail.
  """

  abortedByUser = _messages.BooleanField(1)
  infrastructureFailure = _messages.BooleanField(2)


class ListExecutionsResponse(_messages.Message):
  r"""A ListExecutionsResponse object.

  Fields:
    executions: Executions.  Always set.
    nextPageToken: A continuation token to resume the query at the next item.
      Will only be set if there are more Executions to fetch.
  """

  executions = _messages.MessageField('Execution', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListHistoriesResponse(_messages.Message):
  r"""Response message for HistoryService.List

  Fields:
    histories: Histories.
    nextPageToken: A continuation token to resume the query at the next item.
      Will only be set if there are more histories to fetch.  Tokens are valid
      for up to one hour from the time of the first list request. For
      instance, if you make a list request at 1PM and use the token from this
      first request 10 minutes later, the token from this second response will
      only be valid for 50 minutes.
  """

  histories = _messages.MessageField('History', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListPerfSampleSeriesResponse(_messages.Message):
  r"""A ListPerfSampleSeriesResponse object.

  Fields:
    perfSampleSeries: The resulting PerfSampleSeries sorted by id
  """

  perfSampleSeries = _messages.MessageField('PerfSampleSeries', 1, repeated=True)


class ListPerfSamplesResponse(_messages.Message):
  r"""A ListPerfSamplesResponse object.

  Fields:
    nextPageToken: Optional, returned if result size exceeds the page size
      specified in the request (or the default page size, 500, if
      unspecified). It indicates the last sample timestamp to be used as
      page_token in subsequent request
    perfSamples: A PerfSample attribute.
  """

  nextPageToken = _messages.StringField(1)
  perfSamples = _messages.MessageField('PerfSample', 2, repeated=True)


class ListScreenshotClustersResponse(_messages.Message):
  r"""A ListScreenshotClustersResponse object.

  Fields:
    clusters: The set of clusters associated with an execution Always set
  """

  clusters = _messages.MessageField('ScreenshotCluster', 1, repeated=True)


class ListStepThumbnailsResponse(_messages.Message):
  r"""A response containing the thumbnails in a step.

  Fields:
    nextPageToken: A continuation token to resume the query at the next item.
      If set, indicates that there are more thumbnails to read, by calling
      list again with this value in the page_token field.
    thumbnails: A list of image data.  Images are returned in a deterministic
      order; they are ordered by these factors, in order of importance: *
      First, by their associated test case. Images without a test case are
      considered greater than images with one. * Second, by their creation
      time. Images without a creation time are greater than images with one. *
      Third, by the order in which they were added to the step (by calls to
      CreateStep or UpdateStep).
  """

  nextPageToken = _messages.StringField(1)
  thumbnails = _messages.MessageField('Image', 2, repeated=True)


class ListStepsResponse(_messages.Message):
  r"""Response message for StepService.List.

  Fields:
    nextPageToken: A continuation token to resume the query at the next item.
      If set, indicates that there are more steps to read, by calling list
      again with this value in the page_token field.
    steps: Steps.
  """

  nextPageToken = _messages.StringField(1)
  steps = _messages.MessageField('Step', 2, repeated=True)


class MemoryInfo(_messages.Message):
  r"""A MemoryInfo object.

  Fields:
    memoryCapInKibibyte: Maximum memory that can be allocated to the process
      in KiB
    memoryTotalInKibibyte: Total memory available on the device in KiB
  """

  memoryCapInKibibyte = _messages.IntegerField(1)
  memoryTotalInKibibyte = _messages.IntegerField(2)


class Outcome(_messages.Message):
  r"""Interprets a result so that humans and machines can act on it.

  Enums:
    SummaryValueValuesEnum: The simplest way to interpret a result.  Required

  Fields:
    failureDetail: More information about a FAILURE outcome.  Returns
      INVALID_ARGUMENT if this field is set but the summary is not FAILURE.
      Optional
    inconclusiveDetail: More information about an INCONCLUSIVE outcome.
      Returns INVALID_ARGUMENT if this field is set but the summary is not
      INCONCLUSIVE.  Optional
    skippedDetail: More information about a SKIPPED outcome.  Returns
      INVALID_ARGUMENT if this field is set but the summary is not SKIPPED.
      Optional
    successDetail: More information about a SUCCESS outcome.  Returns
      INVALID_ARGUMENT if this field is set but the summary is not SUCCESS.
      Optional
    summary: The simplest way to interpret a result.  Required
  """

  class SummaryValueValuesEnum(_messages.Enum):
    r"""The simplest way to interpret a result.  Required

    Values:
      failure: <no description>
      inconclusive: <no description>
      skipped: <no description>
      success: <no description>
      unset: <no description>
    """
    failure = 0
    inconclusive = 1
    skipped = 2
    success = 3
    unset = 4

  failureDetail = _messages.MessageField('FailureDetail', 1)
  inconclusiveDetail = _messages.MessageField('InconclusiveDetail', 2)
  skippedDetail = _messages.MessageField('SkippedDetail', 3)
  successDetail = _messages.MessageField('SuccessDetail', 4)
  summary = _messages.EnumField('SummaryValueValuesEnum', 5)


class PerfEnvironment(_messages.Message):
  r"""Encapsulates performance environment info

  Fields:
    cpuInfo: CPU related environment info
    memoryInfo: Memory related environment info
  """

  cpuInfo = _messages.MessageField('CPUInfo', 1)
  memoryInfo = _messages.MessageField('MemoryInfo', 2)


class PerfMetricsSummary(_messages.Message):
  r"""A summary of perf metrics collected and performance environment info

  Enums:
    PerfMetricsValueListEntryValuesEnum:

  Fields:
    appStartTime: A AppStartTime attribute.
    executionId: A tool results execution ID.
    graphicsStats: Graphics statistics for the entire run. Statistics are
      reset at the beginning of the run and collected at the end of the run.
    historyId: A tool results history ID.
    perfEnvironment: Describes the environment in which the performance
      metrics were collected
    perfMetrics: Set of resource collected
    projectId: The cloud project
    stepId: A tool results step ID.
  """

  class PerfMetricsValueListEntryValuesEnum(_messages.Enum):
    r"""PerfMetricsValueListEntryValuesEnum enum type.

    Values:
      cpu: <no description>
      graphics: <no description>
      memory: <no description>
      network: <no description>
      perfMetricTypeUnspecified: <no description>
    """
    cpu = 0
    graphics = 1
    memory = 2
    network = 3
    perfMetricTypeUnspecified = 4

  appStartTime = _messages.MessageField('AppStartTime', 1)
  executionId = _messages.StringField(2)
  graphicsStats = _messages.MessageField('GraphicsStats', 3)
  historyId = _messages.StringField(4)
  perfEnvironment = _messages.MessageField('PerfEnvironment', 5)
  perfMetrics = _messages.EnumField('PerfMetricsValueListEntryValuesEnum', 6, repeated=True)
  projectId = _messages.StringField(7)
  stepId = _messages.StringField(8)


class PerfSample(_messages.Message):
  r"""Resource representing a single performance measure or data point

  Fields:
    sampleTime: Timestamp of collection
    value: Value observed
  """

  sampleTime = _messages.MessageField('Timestamp', 1)
  value = _messages.FloatField(2)


class PerfSampleSeries(_messages.Message):
  r"""Resource representing a collection of performance samples (or data
  points)

  Fields:
    basicPerfSampleSeries: Basic series represented by a line chart
    executionId: A tool results execution ID.
    historyId: A tool results history ID.
    projectId: The cloud project
    sampleSeriesId: A sample series id
    stepId: A tool results step ID.
  """

  basicPerfSampleSeries = _messages.MessageField('BasicPerfSampleSeries', 1)
  executionId = _messages.StringField(2)
  historyId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  sampleSeriesId = _messages.StringField(5)
  stepId = _messages.StringField(6)


class ProjectSettings(_messages.Message):
  r"""Per-project settings for the Tool Results service.

  Fields:
    defaultBucket: The name of the Google Cloud Storage bucket to which
      results are written.  By default, this is unset.  In update request:
      optional In response: optional
    name: The name of the project's settings.  Always of the form: projects
      /{project-id}/settings  In update request: never set In response: always
      set
  """

  defaultBucket = _messages.StringField(1)
  name = _messages.StringField(2)


class PublishXunitXmlFilesRequest(_messages.Message):
  r"""Request message for StepService.PublishXunitXmlFiles.

  Fields:
    xunitXmlFiles: URI of the Xunit XML files to publish.  The maximum size of
      the file this reference is pointing to is 50MB.  Required.
  """

  xunitXmlFiles = _messages.MessageField('FileReference', 1, repeated=True)


class Screen(_messages.Message):
  r"""A Screen object.

  Fields:
    fileReference: File reference of the png file. Required.
    locale: Locale of the device that the screenshot was taken on. Required.
    model: Model of the device that the screenshot was taken on. Required.
    version: OS version of the device that the screenshot was taken on.
      Required.
  """

  fileReference = _messages.StringField(1)
  locale = _messages.StringField(2)
  model = _messages.StringField(3)
  version = _messages.StringField(4)


class ScreenshotCluster(_messages.Message):
  r"""A ScreenshotCluster object.

  Fields:
    activity: A string that describes the activity of every screen in the
      cluster.
    clusterId: A unique identifier for the cluster.
    keyScreen: A singular screen that represents the cluster as a whole. This
      screen will act as the "cover" of the entire cluster. When users look at
      the clusters, only the key screen from each cluster will be shown. Which
      screen is the key screen is determined by the ClusteringAlgorithm
    screens: Full list of screens.
  """

  activity = _messages.StringField(1)
  clusterId = _messages.StringField(2)
  keyScreen = _messages.MessageField('Screen', 3)
  screens = _messages.MessageField('Screen', 4, repeated=True)


class SkippedDetail(_messages.Message):
  r"""A SkippedDetail object.

  Fields:
    incompatibleAppVersion: If the App doesn't support the specific API level.
    incompatibleArchitecture: If the App doesn't run on the specific
      architecture, for example, x86.
    incompatibleDevice: If the requested OS version doesn't run on the
      specific device model.
  """

  incompatibleAppVersion = _messages.BooleanField(1)
  incompatibleArchitecture = _messages.BooleanField(2)
  incompatibleDevice = _messages.BooleanField(3)


class Specification(_messages.Message):
  r"""The details about how to run the execution.

  Fields:
    androidTest: An Android mobile test execution specification.
  """

  androidTest = _messages.MessageField('AndroidTest', 1)


class StackTrace(_messages.Message):
  r"""A stacktrace.

  Fields:
    clusterId: Exception cluster ID
    exception: The stack trace message.  Required
    reportId: Exception report ID
  """

  clusterId = _messages.StringField(1)
  exception = _messages.StringField(2)
  reportId = _messages.StringField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: An opaque string that represents a user for quota purposes.
      Must not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: Deprecated. Please use quotaUser instead.
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of [google.rpc.Code][], but it may accept additional error
  codes if needed. The error message should be a developer-facing English
  message that helps developers *understand* and *resolve* the error. If a
  localized user-facing error message is needed, put the localized message in
  the error details or localize it in the client. The optional error details
  may contain arbitrary information about the error. There is a predefined set
  of error detail types in the package `google.rpc` that can be used for
  common error conditions.  # Language mapping  The `Status` message is the
  logical representation of the error model, but it is not necessarily the
  actual wire format. When the `Status` message is exposed in different client
  libraries and different wire protocols, it can be mapped differently. For
  example, it will likely be mapped to some exceptions in Java, but more
  likely mapped to some error codes in C.  # Other uses  The error model and
  the `Status` message can be used in a variety of environments, either with
  or without APIs, to provide a consistent developer experience across
  different environments.  Example uses of this error model include:  -
  Partial errors. If a service needs to return partial errors to the client,
  it may embed the `Status` in the normal response to indicate the partial
  errors.  - Workflow errors. A typical workflow has multiple steps. Each step
  may have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the `Status` message should be
  used directly inside batch response, one for each error sub-response.  -
  Asynchronous operations. If an API call embeds asynchronous operation
  results in its response, the status of those operations should be
  represented directly using the `Status` message.  - Logging. If some API
  errors are stored in logs, the message `Status` could be used directly after
  any stripping needed for security/privacy reasons.

  Fields:
    code: The status code, which should be an enum value of
      [google.rpc.Code][].
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      [google.rpc.Status.details][] field, or localized by the client.
  """

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('Any', 2, repeated=True)
  message = _messages.StringField(3)


class Step(_messages.Message):
  r"""A Step represents a single operation performed as part of Execution. A
  step can be used to represent the execution of a tool ( for example a test
  runner execution or an execution of a compiler).  Steps can overlap (for
  instance two steps might have the same start time if some operations are
  done in parallel).  Here is an example, let's consider that we have a
  continuous build is executing a test runner for each iteration. The workflow
  would look like: - user creates a Execution with id 1 - user creates an
  TestExecutionStep with id 100 for Execution 1 - user update
  TestExecutionStep with id 100 to add a raw xml log + the service parses the
  xml logs and returns a TestExecutionStep with updated TestResult(s). - user
  update the status of TestExecutionStep with id 100 to COMPLETE  A Step can
  be updated until its state is set to COMPLETE at which points it becomes
  immutable.

  Enums:
    StateValueValuesEnum: The initial state is IN_PROGRESS. The only legal
      state transitions are * IN_PROGRESS -> COMPLETE  A PRECONDITION_FAILED
      will be returned if an invalid transition is requested.  It is valid to
      create Step with a state set to COMPLETE. The state can only be set to
      COMPLETE once. A PRECONDITION_FAILED will be returned if the state is
      set to COMPLETE multiple times.  - In response: always set - In
      create/update request: optional

  Fields:
    completionTime: The time when the step status was set to complete.  This
      value will be set automatically when state transitions to COMPLETE.  -
      In response: set if the execution state is COMPLETE. - In create/update
      request: never set
    creationTime: The time when the step was created.  - In response: always
      set - In create/update request: never set
    description: A description of this tool For example: mvn clean package -D
      skipTests=true  - In response: present if set by create/update request -
      In create/update request: optional
    deviceUsageDuration: How much the device resource is used to perform the
      test.  This is the device usage used for billing purpose, which is
      different from the run_duration, for example, infrastructure failure
      won't be charged for device usage.  PRECONDITION_FAILED will be returned
      if one attempts to set a device_usage on a step which already has this
      field set.  - In response: present if previously set. - In create
      request: optional - In update request: optional
    dimensionValue: If the execution containing this step has any
      dimension_definition set, then this field allows the child to specify
      the values of the dimensions.  The keys must exactly match the
      dimension_definition of the execution.  For example, if the execution
      has `dimension_definition = ['attempt', 'device']` then a step must
      define values for those dimensions, eg. `dimension_value = ['attempt':
      '1', 'device': 'Nexus 6']`  If a step does not participate in one
      dimension of the matrix, the value for that dimension should be empty
      string. For example, if one of the tests is executed by a runner which
      does not support retries, the step could have `dimension_value =
      ['attempt': '', 'device': 'Nexus 6']`  If the step does not participate
      in any dimensions of the matrix, it may leave dimension_value unset.  A
      PRECONDITION_FAILED will be returned if any of the keys do not exist in
      the dimension_definition of the execution.  A PRECONDITION_FAILED will
      be returned if another step in this execution already has the same name
      and dimension_value, but differs on other data fields, for example, step
      field is different.  A PRECONDITION_FAILED will be returned if
      dimension_value is set, and there is a dimension_definition in the
      execution which is not specified as one of the keys.  - In response:
      present if set by create - In create request: optional - In update
      request: never set
    hasImages: Whether any of the outputs of this step are images whose
      thumbnails can be fetched with ListThumbnails.  - In response: always
      set - In create/update request: never set
    labels: Arbitrary user-supplied key/value pairs that are associated with
      the step.  Users are responsible for managing the key namespace such
      that keys don't accidentally collide.  An INVALID_ARGUMENT will be
      returned if the number of labels exceeds 100 or if the length of any of
      the keys or values exceeds 100 characters.  - In response: always set -
      In create request: optional - In update request: optional; any new
      key/value pair will be added to the map, and any new value for an
      existing key will update that key's value
    name: A short human-readable name to display in the UI. Maximum of 100
      characters. For example: Clean build  A PRECONDITION_FAILED will be
      returned upon creating a new step if it shares its name and
      dimension_value with an existing step. If two steps represent a similar
      action, but have different dimension values, they should share the same
      name. For instance, if the same set of tests is run on two different
      platforms, the two steps should have the same name.  - In response:
      always set - In create request: always set - In update request: never
      set
    outcome: Classification of the result, for example into SUCCESS or FAILURE
      - In response: present if set by create/update request - In
      create/update request: optional
    runDuration: How long it took for this step to run.  If unset, this is set
      to the difference between creation_time and completion_time when the
      step is set to the COMPLETE state. In some cases, it is appropriate to
      set this value separately: For instance, if a step is created, but the
      operation it represents is queued for a few minutes before it executes,
      it would be appropriate not to include the time spent queued in its
      run_duration.  PRECONDITION_FAILED will be returned if one attempts to
      set a run_duration on a step which already has this field set.  - In
      response: present if previously set; always present on COMPLETE step -
      In create request: optional - In update request: optional
    state: The initial state is IN_PROGRESS. The only legal state transitions
      are * IN_PROGRESS -> COMPLETE  A PRECONDITION_FAILED will be returned if
      an invalid transition is requested.  It is valid to create Step with a
      state set to COMPLETE. The state can only be set to COMPLETE once. A
      PRECONDITION_FAILED will be returned if the state is set to COMPLETE
      multiple times.  - In response: always set - In create/update request:
      optional
    stepId: A unique identifier within a Execution for this Step.  Returns
      INVALID_ARGUMENT if this field is set or overwritten by the caller.  -
      In response: always set - In create/update request: never set
    testExecutionStep: An execution of a test runner.
    toolExecutionStep: An execution of a tool (used for steps we don't
      explicitly support).
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The initial state is IN_PROGRESS. The only legal state transitions are
    * IN_PROGRESS -> COMPLETE  A PRECONDITION_FAILED will be returned if an
    invalid transition is requested.  It is valid to create Step with a state
    set to COMPLETE. The state can only be set to COMPLETE once. A
    PRECONDITION_FAILED will be returned if the state is set to COMPLETE
    multiple times.  - In response: always set - In create/update request:
    optional

    Values:
      complete: <no description>
      inProgress: <no description>
      pending: <no description>
      unknownState: <no description>
    """
    complete = 0
    inProgress = 1
    pending = 2
    unknownState = 3

  completionTime = _messages.MessageField('Timestamp', 1)
  creationTime = _messages.MessageField('Timestamp', 2)
  description = _messages.StringField(3)
  deviceUsageDuration = _messages.MessageField('Duration', 4)
  dimensionValue = _messages.MessageField('StepDimensionValueEntry', 5, repeated=True)
  hasImages = _messages.BooleanField(6)
  labels = _messages.MessageField('StepLabelsEntry', 7, repeated=True)
  name = _messages.StringField(8)
  outcome = _messages.MessageField('Outcome', 9)
  runDuration = _messages.MessageField('Duration', 10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  stepId = _messages.StringField(12)
  testExecutionStep = _messages.MessageField('TestExecutionStep', 13)
  toolExecutionStep = _messages.MessageField('ToolExecutionStep', 14)


class StepDimensionValueEntry(_messages.Message):
  r"""A StepDimensionValueEntry object.

  Fields:
    key: A string attribute.
    value: A string attribute.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class StepLabelsEntry(_messages.Message):
  r"""A StepLabelsEntry object.

  Fields:
    key: A string attribute.
    value: A string attribute.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class SuccessDetail(_messages.Message):
  r"""A SuccessDetail object.

  Fields:
    otherNativeCrash: If a native process other than the app crashed.
  """

  otherNativeCrash = _messages.BooleanField(1)


class TestCaseReference(_messages.Message):
  r"""A reference to a test case.  Test case references are canonically
  ordered lexicographically by these three factors: * First, by
  test_suite_name. * Second, by class_name. * Third, by name.

  Fields:
    className: The name of the class.
    name: The name of the test case.  Required.
    testSuiteName: The name of the test suite to which this test case belongs.
  """

  className = _messages.StringField(1)
  name = _messages.StringField(2)
  testSuiteName = _messages.StringField(3)


class TestExecutionStep(_messages.Message):
  r"""A step that represents running tests.  It accepts ant-junit xml files
  which will be parsed into structured test results by the service. Xml file
  paths are updated in order to append more files, however they can't be
  deleted.  Users can also add test results manually by using the test_result
  field.

  Fields:
    testIssues: Issues observed during the test execution.  For example, if
      the mobile app under test crashed during the test, the error message and
      the stack trace content can be recorded here to assist debugging.  - In
      response: present if set by create or update - In create/update request:
      optional
    testSuiteOverviews: List of test suite overview contents. This could be
      parsed from xUnit XML log by server, or uploaded directly by user. This
      references should only be called when test suites are fully parsed or
      uploaded.  The maximum allowed number of test suite overviews per step
      is 1000.  - In response: always set - In create request: optional - In
      update request: never (use publishXunitXmlFiles custom method instead)
    testTiming: The timing break down of the test execution.  - In response:
      present if set by create or update - In create/update request: optional
    toolExecution: Represents the execution of the test runner.  The exit code
      of this tool will be used to determine if the test passed.  - In
      response: always set - In create/update request: optional
  """

  testIssues = _messages.MessageField('TestIssue', 1, repeated=True)
  testSuiteOverviews = _messages.MessageField('TestSuiteOverview', 2, repeated=True)
  testTiming = _messages.MessageField('TestTiming', 3)
  toolExecution = _messages.MessageField('ToolExecution', 4)


class TestIssue(_messages.Message):
  r"""An issue detected occurring during a test execution.

  Enums:
    SeverityValueValuesEnum: Severity of issue. Required.
    TypeValueValuesEnum: Type of issue. Required.

  Fields:
    errorMessage: A brief human-readable message describing the issue.
      Required.
    severity: Severity of issue. Required.
    stackTrace: Deprecated in favor of stack trace fields inside specific
      warnings.
    type: Type of issue. Required.
    warning: Warning message with additional details of the issue. Should
      always be a message from com.google.devtools.toolresults.v1.warnings
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Severity of issue. Required.

    Values:
      info: <no description>
      severe: <no description>
      unspecifiedSeverity: <no description>
      warning: <no description>
    """
    info = 0
    severe = 1
    unspecifiedSeverity = 2
    warning = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of issue. Required.

    Values:
      anr: <no description>
      compatibleWithOrchestrator: <no description>
      completeRoboScriptExecution: <no description>
      failedToInstall: <no description>
      fatalException: <no description>
      incompleteRoboScriptExecution: <no description>
      launcherActivityNotFound: <no description>
      nativeCrash: <no description>
      startActivityNotFound: <no description>
      unspecifiedType: <no description>
      unusedRoboDirective: <no description>
    """
    anr = 0
    compatibleWithOrchestrator = 1
    completeRoboScriptExecution = 2
    failedToInstall = 3
    fatalException = 4
    incompleteRoboScriptExecution = 5
    launcherActivityNotFound = 6
    nativeCrash = 7
    startActivityNotFound = 8
    unspecifiedType = 9
    unusedRoboDirective = 10

  errorMessage = _messages.StringField(1)
  severity = _messages.EnumField('SeverityValueValuesEnum', 2)
  stackTrace = _messages.MessageField('StackTrace', 3)
  type = _messages.EnumField('TypeValueValuesEnum', 4)
  warning = _messages.MessageField('Any', 5)


class TestSuiteOverview(_messages.Message):
  r"""A summary of a test suite result either parsed from XML or uploaded
  directly by a user.  Note: the API related comments are for StepService
  only. This message is also being used in ExecutionService in a read only
  mode for the corresponding step.

  Fields:
    errorCount: Number of test cases in error, typically set by the service by
      parsing the xml_source.  - In create/response: always set - In update
      request: never
    failureCount: Number of failed test cases, typically set by the service by
      parsing the xml_source. May also be set by the user.  - In
      create/response: always set - In update request: never
    name: The name of the test suite.  - In create/response: always set - In
      update request: never
    skippedCount: Number of test cases not run, typically set by the service
      by parsing the xml_source.  - In create/response: always set - In update
      request: never
    totalCount: Number of test cases, typically set by the service by parsing
      the xml_source.  - In create/response: always set - In update request:
      never
    xmlSource: If this test suite was parsed from XML, this is the URI where
      the original XML file is stored.  Note: Multiple test suites can share
      the same xml_source  Returns INVALID_ARGUMENT if the uri format is not
      supported.  - In create/response: optional - In update request: never
  """

  errorCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  failureCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  name = _messages.StringField(3)
  skippedCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  totalCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  xmlSource = _messages.MessageField('FileReference', 6)


class TestTiming(_messages.Message):
  r"""Testing timing break down to know phases.

  Fields:
    testProcessDuration: How long it took to run the test process.  - In
      response: present if previously set. - In create/update request:
      optional
  """

  testProcessDuration = _messages.MessageField('Duration', 1)


class Thumbnail(_messages.Message):
  r"""A single thumbnail, with its size and format.

  Fields:
    contentType: The thumbnail's content type, i.e. "image/png".  Always set.
    data: The thumbnail file itself.  That is, the bytes here are precisely
      the bytes that make up the thumbnail file; they can be served as an
      image as-is (with the appropriate content type.)  Always set.
    heightPx: The height of the thumbnail, in pixels.  Always set.
    widthPx: The width of the thumbnail, in pixels.  Always set.
  """

  contentType = _messages.StringField(1)
  data = _messages.BytesField(2)
  heightPx = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  widthPx = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Timestamp(_messages.Message):
  r"""A Timestamp represents a point in time independent of any time zone or
  calendar, represented as seconds and fractions of seconds at nanosecond
  resolution in UTC Epoch time. It is encoded using the Proleptic Gregorian
  Calendar which extends the Gregorian calendar backwards to year one. It is
  encoded assuming all minutes are 60 seconds long, i.e. leap seconds are
  "smeared" so that no leap second table is needed for interpretation. Range
  is from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59.999999999Z. By
  restricting to that range, we ensure that we can convert to and from RFC
  3339 date strings. See [https://www.ietf.org/rfc/rfc3339.txt](https://www.ie
  tf.org/rfc/rfc3339.txt).  # Examples  Example 1: Compute Timestamp from
  POSIX `time()`.  Timestamp timestamp; timestamp.set_seconds(time(NULL));
  timestamp.set_nanos(0);  Example 2: Compute Timestamp from POSIX
  `gettimeofday()`.  struct timeval tv; gettimeofday(&tv, NULL);  Timestamp
  timestamp; timestamp.set_seconds(tv.tv_sec); timestamp.set_nanos(tv.tv_usec
  * 1000);  Example 3: Compute Timestamp from Win32
  `GetSystemTimeAsFileTime()`.  FILETIME ft; GetSystemTimeAsFileTime(&ft);
  UINT64 ticks = (((UINT64)ft.dwHighDateTime) << 32) | ft.dwLowDateTime;  // A
  Windows tick is 100 nanoseconds. Windows epoch 1601-01-01T00:00:00Z // is
  11644473600 seconds before Unix epoch 1970-01-01T00:00:00Z. Timestamp
  timestamp; timestamp.set_seconds((INT64) ((ticks / 10000000) -
  11644473600LL)); timestamp.set_nanos((INT32) ((ticks % 10000000) * 100));
  Example 4: Compute Timestamp from Java `System.currentTimeMillis()`.  long
  millis = System.currentTimeMillis();  Timestamp timestamp =
  Timestamp.newBuilder().setSeconds(millis / 1000) .setNanos((int) ((millis %
  1000) * 1000000)).build();    Example 5: Compute Timestamp from current time
  in Python.  timestamp = Timestamp() timestamp.GetCurrentTime()  # JSON
  Mapping  In JSON format, the Timestamp type is encoded as a string in the
  [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format. That is, the format
  is "{year}-{month}-{day}T{hour}:{min}:{sec}[.{frac_sec}]Z" where {year} is
  always expressed using four digits while {month}, {day}, {hour}, {min}, and
  {sec} are zero-padded to two digits each. The fractional seconds, which can
  go up to 9 digits (i.e. up to 1 nanosecond resolution), are optional. The
  "Z" suffix indicates the timezone ("UTC"); the timezone is required. A
  proto3 JSON serializer should always use UTC (as indicated by "Z") when
  printing the Timestamp type and a proto3 JSON parser should be able to
  accept both UTC and other timezones (as indicated by an offset).  For
  example, "2017-01-15T01:30:15.01Z" encodes 15.01 seconds past 01:30 UTC on
  January 15, 2017.  In JavaScript, one can convert a Date object to this
  format using the standard [toISOString()](https://developer.mozilla.org/en-
  US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString] method. In
  Python, a standard `datetime.datetime` object can be converted to this
  format using
  [`strftime`](https://docs.python.org/2/library/time.html#time.strftime) with
  the time format spec '%Y-%m-%dT%H:%M:%S.%fZ'. Likewise, in Java, one can use
  the Joda Time's [`ISODateTimeFormat.dateTime()`]( http://www.joda.org/joda-
  time/apidocs/org/joda/time/format/ISODateTimeFormat.html#dateTime-- ) to
  obtain a formatter capable of generating timestamps in this format.

  Fields:
    nanos: Non-negative fractions of a second at nanosecond resolution.
      Negative second values with fractions must still have non-negative nanos
      values that count forward in time. Must be from 0 to 999,999,999
      inclusive.
    seconds: Represents seconds of UTC time since Unix epoch
      1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
      9999-12-31T23:59:59Z inclusive.
  """

  nanos = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(2)


class ToolExecution(_messages.Message):
  r"""An execution of an arbitrary tool. It could be a test runner or a tool
  copying artifacts or deploying code.

  Fields:
    commandLineArguments: The full tokenized command line including the
      program name (equivalent to argv in a C program).  - In response:
      present if set by create request - In create request: optional - In
      update request: never set
    exitCode: Tool execution exit code. This field will be set once the tool
      has exited.  - In response: present if set by create/update request - In
      create request: optional - In update request: optional, a
      FAILED_PRECONDITION error will be returned if an exit_code is already
      set.
    toolLogs: References to any plain text logs output the tool execution.
      This field can be set before the tool has exited in order to be able to
      have access to a live view of the logs while the tool is running.  The
      maximum allowed number of tool logs per step is 1000.  - In response:
      present if set by create/update request - In create request: optional -
      In update request: optional, any value provided will be appended to the
      existing list
    toolOutputs: References to opaque files of any format output by the tool
      execution.  The maximum allowed number of tool outputs per step is 1000.
      - In response: present if set by create/update request - In create
      request: optional - In update request: optional, any value provided will
      be appended to the existing list
  """

  commandLineArguments = _messages.StringField(1, repeated=True)
  exitCode = _messages.MessageField('ToolExitCode', 2)
  toolLogs = _messages.MessageField('FileReference', 3, repeated=True)
  toolOutputs = _messages.MessageField('ToolOutputReference', 4, repeated=True)


class ToolExecutionStep(_messages.Message):
  r"""Generic tool step to be used for binaries we do not explicitly support.
  For example: running cp to copy artifacts from one location to another.

  Fields:
    toolExecution: A Tool execution.  - In response: present if set by
      create/update request - In create/update request: optional
  """

  toolExecution = _messages.MessageField('ToolExecution', 1)


class ToolExitCode(_messages.Message):
  r"""Exit code from a tool execution.

  Fields:
    number: Tool execution exit code. A value of 0 means that the execution
      was successful.  - In response: always set - In create/update request:
      always set
  """

  number = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class ToolOutputReference(_messages.Message):
  r"""A reference to a ToolExecution output file.

  Fields:
    creationTime: The creation time of the file.  - In response: present if
      set by create/update request - In create/update request: optional
    output: A FileReference to an output file.  - In response: always set - In
      create/update request: always set
    testCase: The test case to which this output file belongs.  - In response:
      present if set by create/update request - In create/update request:
      optional
  """

  creationTime = _messages.MessageField('Timestamp', 1)
  output = _messages.MessageField('FileReference', 2)
  testCase = _messages.MessageField('TestCaseReference', 3)


class ToolresultsProjectsGetSettingsRequest(_messages.Message):
  r"""A ToolresultsProjectsGetSettingsRequest object.

  Fields:
    projectId: A Project id.  Required.
  """

  projectId = _messages.StringField(1, required=True)


class ToolresultsProjectsHistoriesCreateRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesCreateRequest object.

  Fields:
    history: A History resource to be passed as the request body.
    projectId: A Project id.  Required.
    requestId: A unique request ID for server to detect duplicated requests.
      For example, a UUID.  Optional, but strongly recommended.
  """

  history = _messages.MessageField('History', 1)
  projectId = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ToolresultsProjectsHistoriesExecutionsClustersGetRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsClustersGetRequest object.

  Fields:
    clusterId: A Cluster id  Required.
    executionId: An Execution id.  Required.
    historyId: A History id.  Required.
    projectId: A Project id.  Required.
  """

  clusterId = _messages.StringField(1, required=True)
  executionId = _messages.StringField(2, required=True)
  historyId = _messages.StringField(3, required=True)
  projectId = _messages.StringField(4, required=True)


class ToolresultsProjectsHistoriesExecutionsClustersListRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsClustersListRequest object.

  Fields:
    executionId: An Execution id.  Required.
    historyId: A History id.  Required.
    projectId: A Project id.  Required.
  """

  executionId = _messages.StringField(1, required=True)
  historyId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)


class ToolresultsProjectsHistoriesExecutionsCreateRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsCreateRequest object.

  Fields:
    execution: A Execution resource to be passed as the request body.
    historyId: A History id.  Required.
    projectId: A Project id.  Required.
    requestId: A unique request ID for server to detect duplicated requests.
      For example, a UUID.  Optional, but strongly recommended.
  """

  execution = _messages.MessageField('Execution', 1)
  historyId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ToolresultsProjectsHistoriesExecutionsGetRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsGetRequest object.

  Fields:
    executionId: An Execution id.  Required.
    historyId: A History id.  Required.
    projectId: A Project id.  Required.
  """

  executionId = _messages.StringField(1, required=True)
  historyId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)


class ToolresultsProjectsHistoriesExecutionsListRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsListRequest object.

  Fields:
    historyId: A History id.  Required.
    pageSize: The maximum number of Executions to fetch.  Default value: 25.
      The server will use this default if the field is not set or has a value
      of 0.  Optional.
    pageToken: A continuation token to resume the query at the next item.
      Optional.
    projectId: A Project id.  Required.
  """

  historyId = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)


class ToolresultsProjectsHistoriesExecutionsPatchRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsPatchRequest object.

  Fields:
    execution: A Execution resource to be passed as the request body.
    executionId: Required.
    historyId: Required.
    projectId: A Project id. Required.
    requestId: A unique request ID for server to detect duplicated requests.
      For example, a UUID.  Optional, but strongly recommended.
  """

  execution = _messages.MessageField('Execution', 1)
  executionId = _messages.StringField(2, required=True)
  historyId = _messages.StringField(3, required=True)
  projectId = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ToolresultsProjectsHistoriesExecutionsStepsCreateRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsStepsCreateRequest object.

  Fields:
    executionId: A Execution id.  Required.
    historyId: A History id.  Required.
    projectId: A Project id.  Required.
    requestId: A unique request ID for server to detect duplicated requests.
      For example, a UUID.  Optional, but strongly recommended.
    step: A Step resource to be passed as the request body.
  """

  executionId = _messages.StringField(1, required=True)
  historyId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  step = _messages.MessageField('Step', 5)


class ToolresultsProjectsHistoriesExecutionsStepsGetPerfMetricsSummaryRequest(_messages.Message):
  r"""A
  ToolresultsProjectsHistoriesExecutionsStepsGetPerfMetricsSummaryRequest
  object.

  Fields:
    executionId: A tool results execution ID.
    historyId: A tool results history ID.
    projectId: The cloud project
    stepId: A tool results step ID.
  """

  executionId = _messages.StringField(1, required=True)
  historyId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  stepId = _messages.StringField(4, required=True)


class ToolresultsProjectsHistoriesExecutionsStepsGetRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsStepsGetRequest object.

  Fields:
    executionId: A Execution id.  Required.
    historyId: A History id.  Required.
    projectId: A Project id.  Required.
    stepId: A Step id.  Required.
  """

  executionId = _messages.StringField(1, required=True)
  historyId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  stepId = _messages.StringField(4, required=True)


class ToolresultsProjectsHistoriesExecutionsStepsListRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsStepsListRequest object.

  Fields:
    executionId: A Execution id.  Required.
    historyId: A History id.  Required.
    pageSize: The maximum number of Steps to fetch.  Default value: 25. The
      server will use this default if the field is not set or has a value of
      0.  Optional.
    pageToken: A continuation token to resume the query at the next item.
      Optional.
    projectId: A Project id.  Required.
  """

  executionId = _messages.StringField(1, required=True)
  historyId = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  projectId = _messages.StringField(5, required=True)


class ToolresultsProjectsHistoriesExecutionsStepsPatchRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsStepsPatchRequest object.

  Fields:
    executionId: A Execution id.  Required.
    historyId: A History id.  Required.
    projectId: A Project id.  Required.
    requestId: A unique request ID for server to detect duplicated requests.
      For example, a UUID.  Optional, but strongly recommended.
    step: A Step resource to be passed as the request body.
    stepId: A Step id.  Required.
  """

  executionId = _messages.StringField(1, required=True)
  historyId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  step = _messages.MessageField('Step', 5)
  stepId = _messages.StringField(6, required=True)


class ToolresultsProjectsHistoriesExecutionsStepsPerfSampleSeriesGetRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsStepsPerfSampleSeriesGetRequest
  object.

  Fields:
    executionId: A tool results execution ID.
    historyId: A tool results history ID.
    projectId: The cloud project
    sampleSeriesId: A sample series id
    stepId: A tool results step ID.
  """

  executionId = _messages.StringField(1, required=True)
  historyId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  sampleSeriesId = _messages.StringField(4, required=True)
  stepId = _messages.StringField(5, required=True)


class ToolresultsProjectsHistoriesExecutionsStepsPerfSampleSeriesListRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsStepsPerfSampleSeriesListRequest
  object.

  Enums:
    FilterValueValuesEnum: Specify one or more PerfMetricType values such as
      CPU to filter the result

  Fields:
    executionId: A tool results execution ID.
    filter: Specify one or more PerfMetricType values such as CPU to filter
      the result
    historyId: A tool results history ID.
    projectId: The cloud project
    stepId: A tool results step ID.
  """

  class FilterValueValuesEnum(_messages.Enum):
    r"""Specify one or more PerfMetricType values such as CPU to filter the
    result

    Values:
      cpu: <no description>
      graphics: <no description>
      memory: <no description>
      network: <no description>
      perfMetricTypeUnspecified: <no description>
    """
    cpu = 0
    graphics = 1
    memory = 2
    network = 3
    perfMetricTypeUnspecified = 4

  executionId = _messages.StringField(1, required=True)
  filter = _messages.EnumField('FilterValueValuesEnum', 2, repeated=True)
  historyId = _messages.StringField(3, required=True)
  projectId = _messages.StringField(4, required=True)
  stepId = _messages.StringField(5, required=True)


class ToolresultsProjectsHistoriesExecutionsStepsPerfSampleSeriesSamplesBatchCreateRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsStepsPerfSampleSeriesSamplesBatc
  hCreateRequest object.

  Fields:
    batchCreatePerfSamplesRequest: A BatchCreatePerfSamplesRequest resource to
      be passed as the request body.
    executionId: A tool results execution ID.
    historyId: A tool results history ID.
    projectId: The cloud project
    sampleSeriesId: A sample series id
    stepId: A tool results step ID.
  """

  batchCreatePerfSamplesRequest = _messages.MessageField('BatchCreatePerfSamplesRequest', 1)
  executionId = _messages.StringField(2, required=True)
  historyId = _messages.StringField(3, required=True)
  projectId = _messages.StringField(4, required=True)
  sampleSeriesId = _messages.StringField(5, required=True)
  stepId = _messages.StringField(6, required=True)


class ToolresultsProjectsHistoriesExecutionsStepsPerfSampleSeriesSamplesListRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsStepsPerfSampleSeriesSamplesList
  Request object.

  Fields:
    executionId: A tool results execution ID.
    historyId: A tool results history ID.
    pageSize: The default page size is 500 samples, and the maximum size is
      5000. If the page_size is greater than 5000, the effective page size
      will be 5000
    pageToken: Optional, the next_page_token returned in the previous response
    projectId: The cloud project
    sampleSeriesId: A sample series id
    stepId: A tool results step ID.
  """

  executionId = _messages.StringField(1, required=True)
  historyId = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  projectId = _messages.StringField(5, required=True)
  sampleSeriesId = _messages.StringField(6, required=True)
  stepId = _messages.StringField(7, required=True)


class ToolresultsProjectsHistoriesExecutionsStepsPublishXunitXmlFilesRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsStepsPublishXunitXmlFilesRequest
  object.

  Fields:
    executionId: A Execution id.  Required.
    historyId: A History id.  Required.
    projectId: A Project id.  Required.
    publishXunitXmlFilesRequest: A PublishXunitXmlFilesRequest resource to be
      passed as the request body.
    stepId: A Step id. Note: This step must include a TestExecutionStep.
      Required.
  """

  executionId = _messages.StringField(1, required=True)
  historyId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  publishXunitXmlFilesRequest = _messages.MessageField('PublishXunitXmlFilesRequest', 4)
  stepId = _messages.StringField(5, required=True)


class ToolresultsProjectsHistoriesExecutionsStepsThumbnailsListRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesExecutionsStepsThumbnailsListRequest
  object.

  Fields:
    executionId: An Execution id.  Required.
    historyId: A History id.  Required.
    pageSize: The maximum number of thumbnails to fetch.  Default value: 50.
      The server will use this default if the field is not set or has a value
      of 0.  Optional.
    pageToken: A continuation token to resume the query at the next item.
      Optional.
    projectId: A Project id.  Required.
    stepId: A Step id.  Required.
  """

  executionId = _messages.StringField(1, required=True)
  historyId = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  projectId = _messages.StringField(5, required=True)
  stepId = _messages.StringField(6, required=True)


class ToolresultsProjectsHistoriesGetRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesGetRequest object.

  Fields:
    historyId: A History id.  Required.
    projectId: A Project id.  Required.
  """

  historyId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class ToolresultsProjectsHistoriesListRequest(_messages.Message):
  r"""A ToolresultsProjectsHistoriesListRequest object.

  Fields:
    filterByName: If set, only return histories with the given name.
      Optional.
    pageSize: The maximum number of Histories to fetch.  Default value: 20.
      The server will use this default if the field is not set or has a value
      of 0. Any value greater than 100 will be treated as 100.  Optional.
    pageToken: A continuation token to resume the query at the next item.
      Optional.
    projectId: A Project id.  Required.
  """

  filterByName = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)


class ToolresultsProjectsInitializeSettingsRequest(_messages.Message):
  r"""A ToolresultsProjectsInitializeSettingsRequest object.

  Fields:
    projectId: A Project id.  Required.
  """

  projectId = _messages.StringField(1, required=True)


