/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Thu May 24 08:06:30 EDT 2018 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_hc2hc.native -fma -compact -variables 4 -pipeline-latency 4 -n 32 -dit -name hf_32 -include rdft/scalar/hf.h */

/*
 * This function contains 434 FP additions, 260 FP multiplications,
 * (or, 236 additions, 62 multiplications, 198 fused multiply/add),
 * 102 stack variables, 7 constants, and 128 memory accesses
 */
#include "rdft/scalar/hf.h"

static void hf_32(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 62, MAKE_VOLATILE_STRIDE(64, rs)) {
	       E T8, T8y, T3w, T87, Tl, T8x, T3B, T83, Tz, T6G, T3J, T5T, TM, T6F, T3Q;
	       E T5U, T11, T1e, T6J, T6K, T6L, T6M, T3Z, T5Y, T46, T5X, T1s, T1F, T6O, T6P;
	       E T6Q, T6R, T4e, T61, T4l, T60, T32, T76, T7d, T7N, T54, T6c, T5r, T6f, T29;
	       E T6V, T72, T7I, T4v, T65, T4S, T68, T3t, T7e, T79, T7O, T5b, T5t, T5i, T5s;
	       E T2A, T73, T6Y, T7J, T4C, T4T, T4J, T4U;
	       {
		    E T1, T86, T3, T6, T4, T84, T2, T7, T85, T5;
		    T1 = cr[0];
		    T86 = ci[0];
		    T3 = cr[WS(rs, 16)];
		    T6 = ci[WS(rs, 16)];
		    T2 = W[30];
		    T4 = T2 * T3;
		    T84 = T2 * T6;
		    T5 = W[31];
		    T7 = FMA(T5, T6, T4);
		    T85 = FNMS(T5, T3, T84);
		    T8 = T1 + T7;
		    T8y = T86 - T85;
		    T3w = T1 - T7;
		    T87 = T85 + T86;
	       }
	       {
		    E Ta, Td, Tb, T3x, Tg, Tj, Th, T3z, T9, Tf;
		    Ta = cr[WS(rs, 8)];
		    Td = ci[WS(rs, 8)];
		    T9 = W[14];
		    Tb = T9 * Ta;
		    T3x = T9 * Td;
		    Tg = cr[WS(rs, 24)];
		    Tj = ci[WS(rs, 24)];
		    Tf = W[46];
		    Th = Tf * Tg;
		    T3z = Tf * Tj;
		    {
			 E Te, T3y, Tk, T3A, Tc, Ti;
			 Tc = W[15];
			 Te = FMA(Tc, Td, Tb);
			 T3y = FNMS(Tc, Ta, T3x);
			 Ti = W[47];
			 Tk = FMA(Ti, Tj, Th);
			 T3A = FNMS(Ti, Tg, T3z);
			 Tl = Te + Tk;
			 T8x = Te - Tk;
			 T3B = T3y - T3A;
			 T83 = T3y + T3A;
		    }
	       }
	       {
		    E Ts, T3F, Ty, T3H, T3D, T3I;
		    {
			 E To, Tr, Tp, T3E, Tn, Tq;
			 To = cr[WS(rs, 4)];
			 Tr = ci[WS(rs, 4)];
			 Tn = W[6];
			 Tp = Tn * To;
			 T3E = Tn * Tr;
			 Tq = W[7];
			 Ts = FMA(Tq, Tr, Tp);
			 T3F = FNMS(Tq, To, T3E);
		    }
		    {
			 E Tu, Tx, Tv, T3G, Tt, Tw;
			 Tu = cr[WS(rs, 20)];
			 Tx = ci[WS(rs, 20)];
			 Tt = W[38];
			 Tv = Tt * Tu;
			 T3G = Tt * Tx;
			 Tw = W[39];
			 Ty = FMA(Tw, Tx, Tv);
			 T3H = FNMS(Tw, Tu, T3G);
		    }
		    Tz = Ts + Ty;
		    T6G = T3F + T3H;
		    T3D = Ts - Ty;
		    T3I = T3F - T3H;
		    T3J = T3D - T3I;
		    T5T = T3D + T3I;
	       }
	       {
		    E TF, T3M, TL, T3O, T3K, T3P;
		    {
			 E TB, TE, TC, T3L, TA, TD;
			 TB = cr[WS(rs, 28)];
			 TE = ci[WS(rs, 28)];
			 TA = W[54];
			 TC = TA * TB;
			 T3L = TA * TE;
			 TD = W[55];
			 TF = FMA(TD, TE, TC);
			 T3M = FNMS(TD, TB, T3L);
		    }
		    {
			 E TH, TK, TI, T3N, TG, TJ;
			 TH = cr[WS(rs, 12)];
			 TK = ci[WS(rs, 12)];
			 TG = W[22];
			 TI = TG * TH;
			 T3N = TG * TK;
			 TJ = W[23];
			 TL = FMA(TJ, TK, TI);
			 T3O = FNMS(TJ, TH, T3N);
		    }
		    TM = TF + TL;
		    T6F = T3M + T3O;
		    T3K = TF - TL;
		    T3P = T3M - T3O;
		    T3Q = T3K + T3P;
		    T5U = T3K - T3P;
	       }
	       {
		    E TU, T3U, T1d, T44, T10, T3W, T17, T42;
		    {
			 E TQ, TT, TR, T3T, TP, TS;
			 TQ = cr[WS(rs, 2)];
			 TT = ci[WS(rs, 2)];
			 TP = W[2];
			 TR = TP * TQ;
			 T3T = TP * TT;
			 TS = W[3];
			 TU = FMA(TS, TT, TR);
			 T3U = FNMS(TS, TQ, T3T);
		    }
		    {
			 E T19, T1c, T1a, T43, T18, T1b;
			 T19 = cr[WS(rs, 26)];
			 T1c = ci[WS(rs, 26)];
			 T18 = W[50];
			 T1a = T18 * T19;
			 T43 = T18 * T1c;
			 T1b = W[51];
			 T1d = FMA(T1b, T1c, T1a);
			 T44 = FNMS(T1b, T19, T43);
		    }
		    {
			 E TW, TZ, TX, T3V, TV, TY;
			 TW = cr[WS(rs, 18)];
			 TZ = ci[WS(rs, 18)];
			 TV = W[34];
			 TX = TV * TW;
			 T3V = TV * TZ;
			 TY = W[35];
			 T10 = FMA(TY, TZ, TX);
			 T3W = FNMS(TY, TW, T3V);
		    }
		    {
			 E T13, T16, T14, T41, T12, T15;
			 T13 = cr[WS(rs, 10)];
			 T16 = ci[WS(rs, 10)];
			 T12 = W[18];
			 T14 = T12 * T13;
			 T41 = T12 * T16;
			 T15 = W[19];
			 T17 = FMA(T15, T16, T14);
			 T42 = FNMS(T15, T13, T41);
		    }
		    T11 = TU + T10;
		    T1e = T17 + T1d;
		    T6J = T11 - T1e;
		    T6K = T3U + T3W;
		    T6L = T42 + T44;
		    T6M = T6K - T6L;
		    {
			 E T3X, T3Y, T40, T45;
			 T3X = T3U - T3W;
			 T3Y = T17 - T1d;
			 T3Z = T3X + T3Y;
			 T5Y = T3X - T3Y;
			 T40 = TU - T10;
			 T45 = T42 - T44;
			 T46 = T40 - T45;
			 T5X = T40 + T45;
		    }
	       }
	       {
		    E T1l, T49, T1E, T4j, T1r, T4b, T1y, T4h;
		    {
			 E T1h, T1k, T1i, T48, T1g, T1j;
			 T1h = cr[WS(rs, 30)];
			 T1k = ci[WS(rs, 30)];
			 T1g = W[58];
			 T1i = T1g * T1h;
			 T48 = T1g * T1k;
			 T1j = W[59];
			 T1l = FMA(T1j, T1k, T1i);
			 T49 = FNMS(T1j, T1h, T48);
		    }
		    {
			 E T1A, T1D, T1B, T4i, T1z, T1C;
			 T1A = cr[WS(rs, 22)];
			 T1D = ci[WS(rs, 22)];
			 T1z = W[42];
			 T1B = T1z * T1A;
			 T4i = T1z * T1D;
			 T1C = W[43];
			 T1E = FMA(T1C, T1D, T1B);
			 T4j = FNMS(T1C, T1A, T4i);
		    }
		    {
			 E T1n, T1q, T1o, T4a, T1m, T1p;
			 T1n = cr[WS(rs, 14)];
			 T1q = ci[WS(rs, 14)];
			 T1m = W[26];
			 T1o = T1m * T1n;
			 T4a = T1m * T1q;
			 T1p = W[27];
			 T1r = FMA(T1p, T1q, T1o);
			 T4b = FNMS(T1p, T1n, T4a);
		    }
		    {
			 E T1u, T1x, T1v, T4g, T1t, T1w;
			 T1u = cr[WS(rs, 6)];
			 T1x = ci[WS(rs, 6)];
			 T1t = W[10];
			 T1v = T1t * T1u;
			 T4g = T1t * T1x;
			 T1w = W[11];
			 T1y = FMA(T1w, T1x, T1v);
			 T4h = FNMS(T1w, T1u, T4g);
		    }
		    T1s = T1l + T1r;
		    T1F = T1y + T1E;
		    T6O = T1s - T1F;
		    T6P = T49 + T4b;
		    T6Q = T4h + T4j;
		    T6R = T6P - T6Q;
		    {
			 E T4c, T4d, T4f, T4k;
			 T4c = T49 - T4b;
			 T4d = T1y - T1E;
			 T4e = T4c + T4d;
			 T61 = T4c - T4d;
			 T4f = T1l - T1r;
			 T4k = T4h - T4j;
			 T4l = T4f - T4k;
			 T60 = T4f + T4k;
		    }
	       }
	       {
		    E T2H, T5n, T30, T52, T2N, T5p, T2U, T50;
		    {
			 E T2D, T2G, T2E, T5m, T2C, T2F;
			 T2D = cr[WS(rs, 31)];
			 T2G = ci[WS(rs, 31)];
			 T2C = W[60];
			 T2E = T2C * T2D;
			 T5m = T2C * T2G;
			 T2F = W[61];
			 T2H = FMA(T2F, T2G, T2E);
			 T5n = FNMS(T2F, T2D, T5m);
		    }
		    {
			 E T2W, T2Z, T2X, T51, T2V, T2Y;
			 T2W = cr[WS(rs, 23)];
			 T2Z = ci[WS(rs, 23)];
			 T2V = W[44];
			 T2X = T2V * T2W;
			 T51 = T2V * T2Z;
			 T2Y = W[45];
			 T30 = FMA(T2Y, T2Z, T2X);
			 T52 = FNMS(T2Y, T2W, T51);
		    }
		    {
			 E T2J, T2M, T2K, T5o, T2I, T2L;
			 T2J = cr[WS(rs, 15)];
			 T2M = ci[WS(rs, 15)];
			 T2I = W[28];
			 T2K = T2I * T2J;
			 T5o = T2I * T2M;
			 T2L = W[29];
			 T2N = FMA(T2L, T2M, T2K);
			 T5p = FNMS(T2L, T2J, T5o);
		    }
		    {
			 E T2Q, T2T, T2R, T4Z, T2P, T2S;
			 T2Q = cr[WS(rs, 7)];
			 T2T = ci[WS(rs, 7)];
			 T2P = W[12];
			 T2R = T2P * T2Q;
			 T4Z = T2P * T2T;
			 T2S = W[13];
			 T2U = FMA(T2S, T2T, T2R);
			 T50 = FNMS(T2S, T2Q, T4Z);
		    }
		    {
			 E T2O, T31, T7b, T7c;
			 T2O = T2H + T2N;
			 T31 = T2U + T30;
			 T32 = T2O + T31;
			 T76 = T2O - T31;
			 T7b = T5n + T5p;
			 T7c = T50 + T52;
			 T7d = T7b - T7c;
			 T7N = T7b + T7c;
		    }
		    {
			 E T4Y, T53, T5l, T5q;
			 T4Y = T2H - T2N;
			 T53 = T50 - T52;
			 T54 = T4Y - T53;
			 T6c = T4Y + T53;
			 T5l = T30 - T2U;
			 T5q = T5n - T5p;
			 T5r = T5l - T5q;
			 T6f = T5q + T5l;
		    }
	       }
	       {
		    E T1O, T4N, T27, T4t, T1U, T4P, T21, T4r;
		    {
			 E T1K, T1N, T1L, T4M, T1J, T1M;
			 T1K = cr[WS(rs, 1)];
			 T1N = ci[WS(rs, 1)];
			 T1J = W[0];
			 T1L = T1J * T1K;
			 T4M = T1J * T1N;
			 T1M = W[1];
			 T1O = FMA(T1M, T1N, T1L);
			 T4N = FNMS(T1M, T1K, T4M);
		    }
		    {
			 E T23, T26, T24, T4s, T22, T25;
			 T23 = cr[WS(rs, 25)];
			 T26 = ci[WS(rs, 25)];
			 T22 = W[48];
			 T24 = T22 * T23;
			 T4s = T22 * T26;
			 T25 = W[49];
			 T27 = FMA(T25, T26, T24);
			 T4t = FNMS(T25, T23, T4s);
		    }
		    {
			 E T1Q, T1T, T1R, T4O, T1P, T1S;
			 T1Q = cr[WS(rs, 17)];
			 T1T = ci[WS(rs, 17)];
			 T1P = W[32];
			 T1R = T1P * T1Q;
			 T4O = T1P * T1T;
			 T1S = W[33];
			 T1U = FMA(T1S, T1T, T1R);
			 T4P = FNMS(T1S, T1Q, T4O);
		    }
		    {
			 E T1X, T20, T1Y, T4q, T1W, T1Z;
			 T1X = cr[WS(rs, 9)];
			 T20 = ci[WS(rs, 9)];
			 T1W = W[16];
			 T1Y = T1W * T1X;
			 T4q = T1W * T20;
			 T1Z = W[17];
			 T21 = FMA(T1Z, T20, T1Y);
			 T4r = FNMS(T1Z, T1X, T4q);
		    }
		    {
			 E T1V, T28, T70, T71;
			 T1V = T1O + T1U;
			 T28 = T21 + T27;
			 T29 = T1V + T28;
			 T6V = T1V - T28;
			 T70 = T4N + T4P;
			 T71 = T4r + T4t;
			 T72 = T70 - T71;
			 T7I = T70 + T71;
		    }
		    {
			 E T4p, T4u, T4Q, T4R;
			 T4p = T1O - T1U;
			 T4u = T4r - T4t;
			 T4v = T4p - T4u;
			 T65 = T4p + T4u;
			 T4Q = T4N - T4P;
			 T4R = T21 - T27;
			 T4S = T4Q + T4R;
			 T68 = T4Q - T4R;
		    }
	       }
	       {
		    E T38, T57, T3r, T5g, T3e, T59, T3l, T5e;
		    {
			 E T34, T37, T35, T56, T33, T36;
			 T34 = cr[WS(rs, 3)];
			 T37 = ci[WS(rs, 3)];
			 T33 = W[4];
			 T35 = T33 * T34;
			 T56 = T33 * T37;
			 T36 = W[5];
			 T38 = FMA(T36, T37, T35);
			 T57 = FNMS(T36, T34, T56);
		    }
		    {
			 E T3n, T3q, T3o, T5f, T3m, T3p;
			 T3n = cr[WS(rs, 11)];
			 T3q = ci[WS(rs, 11)];
			 T3m = W[20];
			 T3o = T3m * T3n;
			 T5f = T3m * T3q;
			 T3p = W[21];
			 T3r = FMA(T3p, T3q, T3o);
			 T5g = FNMS(T3p, T3n, T5f);
		    }
		    {
			 E T3a, T3d, T3b, T58, T39, T3c;
			 T3a = cr[WS(rs, 19)];
			 T3d = ci[WS(rs, 19)];
			 T39 = W[36];
			 T3b = T39 * T3a;
			 T58 = T39 * T3d;
			 T3c = W[37];
			 T3e = FMA(T3c, T3d, T3b);
			 T59 = FNMS(T3c, T3a, T58);
		    }
		    {
			 E T3h, T3k, T3i, T5d, T3g, T3j;
			 T3h = cr[WS(rs, 27)];
			 T3k = ci[WS(rs, 27)];
			 T3g = W[52];
			 T3i = T3g * T3h;
			 T5d = T3g * T3k;
			 T3j = W[53];
			 T3l = FMA(T3j, T3k, T3i);
			 T5e = FNMS(T3j, T3h, T5d);
		    }
		    {
			 E T3f, T3s, T77, T78;
			 T3f = T38 + T3e;
			 T3s = T3l + T3r;
			 T3t = T3f + T3s;
			 T7e = T3s - T3f;
			 T77 = T5e + T5g;
			 T78 = T57 + T59;
			 T79 = T77 - T78;
			 T7O = T78 + T77;
		    }
		    {
			 E T55, T5a, T5c, T5h;
			 T55 = T38 - T3e;
			 T5a = T57 - T59;
			 T5b = T55 - T5a;
			 T5t = T55 + T5a;
			 T5c = T3l - T3r;
			 T5h = T5e - T5g;
			 T5i = T5c + T5h;
			 T5s = T5c - T5h;
		    }
	       }
	       {
		    E T2f, T4y, T2y, T4H, T2l, T4A, T2s, T4F;
		    {
			 E T2b, T2e, T2c, T4x, T2a, T2d;
			 T2b = cr[WS(rs, 5)];
			 T2e = ci[WS(rs, 5)];
			 T2a = W[8];
			 T2c = T2a * T2b;
			 T4x = T2a * T2e;
			 T2d = W[9];
			 T2f = FMA(T2d, T2e, T2c);
			 T4y = FNMS(T2d, T2b, T4x);
		    }
		    {
			 E T2u, T2x, T2v, T4G, T2t, T2w;
			 T2u = cr[WS(rs, 13)];
			 T2x = ci[WS(rs, 13)];
			 T2t = W[24];
			 T2v = T2t * T2u;
			 T4G = T2t * T2x;
			 T2w = W[25];
			 T2y = FMA(T2w, T2x, T2v);
			 T4H = FNMS(T2w, T2u, T4G);
		    }
		    {
			 E T2h, T2k, T2i, T4z, T2g, T2j;
			 T2h = cr[WS(rs, 21)];
			 T2k = ci[WS(rs, 21)];
			 T2g = W[40];
			 T2i = T2g * T2h;
			 T4z = T2g * T2k;
			 T2j = W[41];
			 T2l = FMA(T2j, T2k, T2i);
			 T4A = FNMS(T2j, T2h, T4z);
		    }
		    {
			 E T2o, T2r, T2p, T4E, T2n, T2q;
			 T2o = cr[WS(rs, 29)];
			 T2r = ci[WS(rs, 29)];
			 T2n = W[56];
			 T2p = T2n * T2o;
			 T4E = T2n * T2r;
			 T2q = W[57];
			 T2s = FMA(T2q, T2r, T2p);
			 T4F = FNMS(T2q, T2o, T4E);
		    }
		    {
			 E T2m, T2z, T6W, T6X;
			 T2m = T2f + T2l;
			 T2z = T2s + T2y;
			 T2A = T2m + T2z;
			 T73 = T2m - T2z;
			 T6W = T4F + T4H;
			 T6X = T4y + T4A;
			 T6Y = T6W - T6X;
			 T7J = T6X + T6W;
		    }
		    {
			 E T4w, T4B, T4D, T4I;
			 T4w = T2f - T2l;
			 T4B = T4y - T4A;
			 T4C = T4w - T4B;
			 T4T = T4w + T4B;
			 T4D = T2s - T2y;
			 T4I = T4F - T4H;
			 T4J = T4D + T4I;
			 T4U = T4I - T4D;
		    }
	       }
	       {
		    E TO, T7C, T7Z, T80, T89, T8e, T1H, T8d, T3v, T8b, T7L, T7T, T7Q, T7U, T7F;
		    E T81;
		    {
			 E Tm, TN, T7X, T7Y;
			 Tm = T8 + Tl;
			 TN = Tz + TM;
			 TO = Tm + TN;
			 T7C = Tm - TN;
			 T7X = T7N + T7O;
			 T7Y = T7I + T7J;
			 T7Z = T7X - T7Y;
			 T80 = T7Y + T7X;
		    }
		    {
			 E T82, T88, T1f, T1G;
			 T82 = T6G + T6F;
			 T88 = T83 + T87;
			 T89 = T82 + T88;
			 T8e = T88 - T82;
			 T1f = T11 + T1e;
			 T1G = T1s + T1F;
			 T1H = T1f + T1G;
			 T8d = T1f - T1G;
		    }
		    {
			 E T2B, T3u, T7H, T7K;
			 T2B = T29 + T2A;
			 T3u = T32 + T3t;
			 T3v = T2B + T3u;
			 T8b = T3u - T2B;
			 T7H = T29 - T2A;
			 T7K = T7I - T7J;
			 T7L = T7H + T7K;
			 T7T = T7H - T7K;
		    }
		    {
			 E T7M, T7P, T7D, T7E;
			 T7M = T32 - T3t;
			 T7P = T7N - T7O;
			 T7Q = T7M - T7P;
			 T7U = T7M + T7P;
			 T7D = T6P + T6Q;
			 T7E = T6K + T6L;
			 T7F = T7D - T7E;
			 T81 = T7E + T7D;
		    }
		    {
			 E T1I, T8a, T8c, T7W;
			 T1I = TO + T1H;
			 ci[WS(rs, 15)] = T1I - T3v;
			 cr[0] = T1I + T3v;
			 T8a = T81 + T89;
			 cr[WS(rs, 16)] = T80 - T8a;
			 ci[WS(rs, 31)] = T80 + T8a;
			 T8c = T89 - T81;
			 cr[WS(rs, 24)] = T8b - T8c;
			 ci[WS(rs, 23)] = T8b + T8c;
			 T7W = TO - T1H;
			 cr[WS(rs, 8)] = T7W - T7Z;
			 ci[WS(rs, 7)] = T7W + T7Z;
		    }
		    {
			 E T7G, T7R, T8f, T8g;
			 T7G = T7C - T7F;
			 T7R = T7L + T7Q;
			 ci[WS(rs, 11)] = FNMS(KP707106781, T7R, T7G);
			 cr[WS(rs, 4)] = FMA(KP707106781, T7R, T7G);
			 T8f = T8d + T8e;
			 T8g = T7Q - T7L;
			 cr[WS(rs, 28)] = FMS(KP707106781, T8g, T8f);
			 ci[WS(rs, 19)] = FMA(KP707106781, T8g, T8f);
		    }
		    {
			 E T8h, T8i, T7S, T7V;
			 T8h = T8e - T8d;
			 T8i = T7U - T7T;
			 cr[WS(rs, 20)] = FMS(KP707106781, T8i, T8h);
			 ci[WS(rs, 27)] = FMA(KP707106781, T8i, T8h);
			 T7S = T7C + T7F;
			 T7V = T7T + T7U;
			 cr[WS(rs, 12)] = FNMS(KP707106781, T7V, T7S);
			 ci[WS(rs, 3)] = FMA(KP707106781, T7V, T7S);
		    }
	       }
	       {
		    E T3S, T5C, T4n, T8C, T8B, T8H, T5F, T8I, T5w, T5Q, T5A, T5M, T4X, T5P, T5z;
		    E T5J;
		    {
			 E T3C, T3R, T5D, T5E;
			 T3C = T3w - T3B;
			 T3R = T3J + T3Q;
			 T3S = FNMS(KP707106781, T3R, T3C);
			 T5C = FMA(KP707106781, T3R, T3C);
			 {
			      E T47, T4m, T8z, T8A;
			      T47 = FMA(KP414213562, T46, T3Z);
			      T4m = FNMS(KP414213562, T4l, T4e);
			      T4n = T47 - T4m;
			      T8C = T47 + T4m;
			      T8z = T8x + T8y;
			      T8A = T5T - T5U;
			      T8B = FMA(KP707106781, T8A, T8z);
			      T8H = FNMS(KP707106781, T8A, T8z);
			 }
			 T5D = FNMS(KP414213562, T3Z, T46);
			 T5E = FMA(KP414213562, T4e, T4l);
			 T5F = T5D + T5E;
			 T8I = T5E - T5D;
			 {
			      E T5k, T5K, T5v, T5L, T5j, T5u;
			      T5j = T5b + T5i;
			      T5k = FNMS(KP707106781, T5j, T54);
			      T5K = FMA(KP707106781, T5j, T54);
			      T5u = T5s - T5t;
			      T5v = FNMS(KP707106781, T5u, T5r);
			      T5L = FMA(KP707106781, T5u, T5r);
			      T5w = FMA(KP668178637, T5v, T5k);
			      T5Q = FMA(KP198912367, T5K, T5L);
			      T5A = FNMS(KP668178637, T5k, T5v);
			      T5M = FNMS(KP198912367, T5L, T5K);
			 }
			 {
			      E T4L, T5H, T4W, T5I, T4K, T4V;
			      T4K = T4C + T4J;
			      T4L = FNMS(KP707106781, T4K, T4v);
			      T5H = FMA(KP707106781, T4K, T4v);
			      T4V = T4T + T4U;
			      T4W = FNMS(KP707106781, T4V, T4S);
			      T5I = FMA(KP707106781, T4V, T4S);
			      T4X = FMA(KP668178637, T4W, T4L);
			      T5P = FMA(KP198912367, T5H, T5I);
			      T5z = FNMS(KP668178637, T4L, T4W);
			      T5J = FNMS(KP198912367, T5I, T5H);
			 }
		    }
		    {
			 E T4o, T5x, T8J, T8K;
			 T4o = FMA(KP923879532, T4n, T3S);
			 T5x = T4X + T5w;
			 ci[WS(rs, 12)] = FNMS(KP831469612, T5x, T4o);
			 cr[WS(rs, 3)] = FMA(KP831469612, T5x, T4o);
			 T8J = FMA(KP923879532, T8I, T8H);
			 T8K = T5z - T5A;
			 cr[WS(rs, 19)] = FMS(KP831469612, T8K, T8J);
			 ci[WS(rs, 28)] = FMA(KP831469612, T8K, T8J);
		    }
		    {
			 E T8L, T8M, T5y, T5B;
			 T8L = FNMS(KP923879532, T8I, T8H);
			 T8M = T5w - T4X;
			 cr[WS(rs, 27)] = FMS(KP831469612, T8M, T8L);
			 ci[WS(rs, 20)] = FMA(KP831469612, T8M, T8L);
			 T5y = FNMS(KP923879532, T4n, T3S);
			 T5B = T5z + T5A;
			 cr[WS(rs, 11)] = FMA(KP831469612, T5B, T5y);
			 ci[WS(rs, 4)] = FNMS(KP831469612, T5B, T5y);
		    }
		    {
			 E T5G, T5N, T8D, T8E;
			 T5G = FMA(KP923879532, T5F, T5C);
			 T5N = T5J + T5M;
			 cr[WS(rs, 15)] = FNMS(KP980785280, T5N, T5G);
			 ci[0] = FMA(KP980785280, T5N, T5G);
			 T8D = FMA(KP923879532, T8C, T8B);
			 T8E = T5Q - T5P;
			 cr[WS(rs, 31)] = FMS(KP980785280, T8E, T8D);
			 ci[WS(rs, 16)] = FMA(KP980785280, T8E, T8D);
		    }
		    {
			 E T8F, T8G, T5O, T5R;
			 T8F = FNMS(KP923879532, T8C, T8B);
			 T8G = T5M - T5J;
			 cr[WS(rs, 23)] = FMS(KP980785280, T8G, T8F);
			 ci[WS(rs, 24)] = FMA(KP980785280, T8G, T8F);
			 T5O = FNMS(KP923879532, T5F, T5C);
			 T5R = T5P + T5Q;
			 ci[WS(rs, 8)] = FNMS(KP980785280, T5R, T5O);
			 cr[WS(rs, 7)] = FMA(KP980785280, T5R, T5O);
		    }
	       }
	       {
		    E T6I, T7m, T7w, T7A, T8l, T8r, T6T, T8m, T75, T7k, T7p, T8s, T7t, T7z, T7g;
		    E T7j;
		    {
			 E T6E, T6H, T7u, T7v;
			 T6E = T8 - Tl;
			 T6H = T6F - T6G;
			 T6I = T6E - T6H;
			 T7m = T6E + T6H;
			 T7u = T76 + T79;
			 T7v = T7e - T7d;
			 T7w = FNMS(KP414213562, T7v, T7u);
			 T7A = FMA(KP414213562, T7u, T7v);
		    }
		    {
			 E T8j, T8k, T6N, T6S;
			 T8j = Tz - TM;
			 T8k = T87 - T83;
			 T8l = T8j + T8k;
			 T8r = T8k - T8j;
			 T6N = T6J + T6M;
			 T6S = T6O - T6R;
			 T6T = T6N + T6S;
			 T8m = T6N - T6S;
		    }
		    {
			 E T6Z, T74, T7n, T7o;
			 T6Z = T6V - T6Y;
			 T74 = T72 - T73;
			 T75 = FMA(KP414213562, T74, T6Z);
			 T7k = FNMS(KP414213562, T6Z, T74);
			 T7n = T6J - T6M;
			 T7o = T6O + T6R;
			 T7p = T7n + T7o;
			 T8s = T7o - T7n;
		    }
		    {
			 E T7r, T7s, T7a, T7f;
			 T7r = T6V + T6Y;
			 T7s = T72 + T73;
			 T7t = FNMS(KP414213562, T7s, T7r);
			 T7z = FMA(KP414213562, T7r, T7s);
			 T7a = T76 - T79;
			 T7f = T7d + T7e;
			 T7g = FNMS(KP414213562, T7f, T7a);
			 T7j = FMA(KP414213562, T7a, T7f);
		    }
		    {
			 E T6U, T7h, T8t, T8u;
			 T6U = FMA(KP707106781, T6T, T6I);
			 T7h = T75 + T7g;
			 ci[WS(rs, 13)] = FNMS(KP923879532, T7h, T6U);
			 cr[WS(rs, 2)] = FMA(KP923879532, T7h, T6U);
			 T8t = FMA(KP707106781, T8s, T8r);
			 T8u = T7k + T7j;
			 cr[WS(rs, 18)] = FMS(KP923879532, T8u, T8t);
			 ci[WS(rs, 29)] = FMA(KP923879532, T8u, T8t);
		    }
		    {
			 E T8v, T8w, T7i, T7l;
			 T8v = FNMS(KP707106781, T8s, T8r);
			 T8w = T7g - T75;
			 cr[WS(rs, 26)] = FMS(KP923879532, T8w, T8v);
			 ci[WS(rs, 21)] = FMA(KP923879532, T8w, T8v);
			 T7i = FNMS(KP707106781, T6T, T6I);
			 T7l = T7j - T7k;
			 cr[WS(rs, 10)] = FNMS(KP923879532, T7l, T7i);
			 ci[WS(rs, 5)] = FMA(KP923879532, T7l, T7i);
		    }
		    {
			 E T7q, T7x, T8n, T8o;
			 T7q = FMA(KP707106781, T7p, T7m);
			 T7x = T7t + T7w;
			 cr[WS(rs, 14)] = FNMS(KP923879532, T7x, T7q);
			 ci[WS(rs, 1)] = FMA(KP923879532, T7x, T7q);
			 T8n = FMA(KP707106781, T8m, T8l);
			 T8o = T7A - T7z;
			 cr[WS(rs, 30)] = FMS(KP923879532, T8o, T8n);
			 ci[WS(rs, 17)] = FMA(KP923879532, T8o, T8n);
		    }
		    {
			 E T8p, T8q, T7y, T7B;
			 T8p = FNMS(KP707106781, T8m, T8l);
			 T8q = T7w - T7t;
			 cr[WS(rs, 22)] = FMS(KP923879532, T8q, T8p);
			 ci[WS(rs, 25)] = FMA(KP923879532, T8q, T8p);
			 T7y = FNMS(KP707106781, T7p, T7m);
			 T7B = T7z + T7A;
			 ci[WS(rs, 9)] = FNMS(KP923879532, T7B, T7y);
			 cr[WS(rs, 6)] = FMA(KP923879532, T7B, T7y);
		    }
	       }
	       {
		    E T5W, T6o, T63, T8W, T8P, T8V, T6r, T8Q, T6i, T6C, T6l, T6y, T6b, T6B, T6m;
		    E T6v;
		    {
			 E T5S, T5V, T6p, T6q;
			 T5S = T3w + T3B;
			 T5V = T5T + T5U;
			 T5W = FMA(KP707106781, T5V, T5S);
			 T6o = FNMS(KP707106781, T5V, T5S);
			 {
			      E T5Z, T62, T8N, T8O;
			      T5Z = FMA(KP414213562, T5Y, T5X);
			      T62 = FNMS(KP414213562, T61, T60);
			      T63 = T5Z + T62;
			      T8W = T5Z - T62;
			      T8N = T8y - T8x;
			      T8O = T3Q - T3J;
			      T8P = FMA(KP707106781, T8O, T8N);
			      T8V = FNMS(KP707106781, T8O, T8N);
			 }
			 T6p = FMA(KP414213562, T60, T61);
			 T6q = FNMS(KP414213562, T5X, T5Y);
			 T6r = T6p - T6q;
			 T8Q = T6q + T6p;
			 {
			      E T6e, T6w, T6h, T6x, T6d, T6g;
			      T6d = T5t + T5s;
			      T6e = FMA(KP707106781, T6d, T6c);
			      T6w = FNMS(KP707106781, T6d, T6c);
			      T6g = T5i - T5b;
			      T6h = FMA(KP707106781, T6g, T6f);
			      T6x = FNMS(KP707106781, T6g, T6f);
			      T6i = FNMS(KP198912367, T6h, T6e);
			      T6C = FNMS(KP668178637, T6w, T6x);
			      T6l = FMA(KP198912367, T6e, T6h);
			      T6y = FMA(KP668178637, T6x, T6w);
			 }
			 {
			      E T67, T6t, T6a, T6u, T66, T69;
			      T66 = T4T - T4U;
			      T67 = FMA(KP707106781, T66, T65);
			      T6t = FNMS(KP707106781, T66, T65);
			      T69 = T4J - T4C;
			      T6a = FMA(KP707106781, T69, T68);
			      T6u = FNMS(KP707106781, T69, T68);
			      T6b = FMA(KP198912367, T6a, T67);
			      T6B = FMA(KP668178637, T6t, T6u);
			      T6m = FNMS(KP198912367, T67, T6a);
			      T6v = FNMS(KP668178637, T6u, T6t);
			 }
		    }
		    {
			 E T64, T6j, T8X, T8Y;
			 T64 = FMA(KP923879532, T63, T5W);
			 T6j = T6b + T6i;
			 ci[WS(rs, 14)] = FNMS(KP980785280, T6j, T64);
			 cr[WS(rs, 1)] = FMA(KP980785280, T6j, T64);
			 T8X = FMA(KP923879532, T8W, T8V);
			 T8Y = T6B + T6C;
			 cr[WS(rs, 29)] = -(FMA(KP831469612, T8Y, T8X));
			 ci[WS(rs, 18)] = FNMS(KP831469612, T8Y, T8X);
		    }
		    {
			 E T8Z, T90, T6k, T6n;
			 T8Z = FNMS(KP923879532, T8W, T8V);
			 T90 = T6y - T6v;
			 cr[WS(rs, 21)] = FMS(KP831469612, T90, T8Z);
			 ci[WS(rs, 26)] = FMA(KP831469612, T90, T8Z);
			 T6k = FNMS(KP923879532, T63, T5W);
			 T6n = T6l - T6m;
			 cr[WS(rs, 9)] = FNMS(KP980785280, T6n, T6k);
			 ci[WS(rs, 6)] = FMA(KP980785280, T6n, T6k);
		    }
		    {
			 E T6s, T6z, T8R, T8S;
			 T6s = FMA(KP923879532, T6r, T6o);
			 T6z = T6v + T6y;
			 cr[WS(rs, 13)] = FNMS(KP831469612, T6z, T6s);
			 ci[WS(rs, 2)] = FMA(KP831469612, T6z, T6s);
			 T8R = FMA(KP923879532, T8Q, T8P);
			 T8S = T6m + T6l;
			 cr[WS(rs, 17)] = FMS(KP980785280, T8S, T8R);
			 ci[WS(rs, 30)] = FMA(KP980785280, T8S, T8R);
		    }
		    {
			 E T8T, T8U, T6A, T6D;
			 T8T = FNMS(KP923879532, T8Q, T8P);
			 T8U = T6i - T6b;
			 cr[WS(rs, 25)] = FMS(KP980785280, T8U, T8T);
			 ci[WS(rs, 22)] = FMA(KP980785280, T8U, T8T);
			 T6A = FNMS(KP923879532, T6r, T6o);
			 T6D = T6B - T6C;
			 ci[WS(rs, 10)] = FNMS(KP831469612, T6D, T6A);
			 cr[WS(rs, 5)] = FMA(KP831469612, T6D, T6A);
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 32},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 32, "hf_32", twinstr, &GENUS, {236, 62, 198, 0} };

void X(codelet_hf_32) (planner *p) {
     X(khc2hc_register) (p, hf_32, &desc);
}
#else

/* Generated by: ../../../genfft/gen_hc2hc.native -compact -variables 4 -pipeline-latency 4 -n 32 -dit -name hf_32 -include rdft/scalar/hf.h */

/*
 * This function contains 434 FP additions, 208 FP multiplications,
 * (or, 340 additions, 114 multiplications, 94 fused multiply/add),
 * 96 stack variables, 7 constants, and 128 memory accesses
 */
#include "rdft/scalar/hf.h"

static void hf_32(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 62, MAKE_VOLATILE_STRIDE(64, rs)) {
	       E Tj, T5F, T7C, T7Q, T35, T4T, T78, T7m, T1Q, T61, T5Y, T6J, T3K, T56, T41;
	       E T59, T2B, T67, T6e, T6O, T4b, T5g, T4s, T5d, TG, T7l, T5I, T73, T3a, T4U;
	       E T3f, T4V, T14, T5K, T5N, T6F, T3m, T4Z, T3r, T4Y, T1r, T5P, T5S, T6E, T3x;
	       E T52, T3C, T51, T2d, T5Z, T64, T6K, T3V, T5a, T44, T57, T2Y, T6f, T6a, T6P;
	       E T4m, T5e, T4v, T5h;
	       {
		    E T1, T76, T6, T75, Tc, T32, Th, T33;
		    T1 = cr[0];
		    T76 = ci[0];
		    {
			 E T3, T5, T2, T4;
			 T3 = cr[WS(rs, 16)];
			 T5 = ci[WS(rs, 16)];
			 T2 = W[30];
			 T4 = W[31];
			 T6 = FMA(T2, T3, T4 * T5);
			 T75 = FNMS(T4, T3, T2 * T5);
		    }
		    {
			 E T9, Tb, T8, Ta;
			 T9 = cr[WS(rs, 8)];
			 Tb = ci[WS(rs, 8)];
			 T8 = W[14];
			 Ta = W[15];
			 Tc = FMA(T8, T9, Ta * Tb);
			 T32 = FNMS(Ta, T9, T8 * Tb);
		    }
		    {
			 E Te, Tg, Td, Tf;
			 Te = cr[WS(rs, 24)];
			 Tg = ci[WS(rs, 24)];
			 Td = W[46];
			 Tf = W[47];
			 Th = FMA(Td, Te, Tf * Tg);
			 T33 = FNMS(Tf, Te, Td * Tg);
		    }
		    {
			 E T7, Ti, T7A, T7B;
			 T7 = T1 + T6;
			 Ti = Tc + Th;
			 Tj = T7 + Ti;
			 T5F = T7 - Ti;
			 T7A = Tc - Th;
			 T7B = T76 - T75;
			 T7C = T7A + T7B;
			 T7Q = T7B - T7A;
		    }
		    {
			 E T31, T34, T74, T77;
			 T31 = T1 - T6;
			 T34 = T32 - T33;
			 T35 = T31 + T34;
			 T4T = T31 - T34;
			 T74 = T32 + T33;
			 T77 = T75 + T76;
			 T78 = T74 + T77;
			 T7m = T77 - T74;
		    }
	       }
	       {
		    E T1y, T3X, T1O, T3I, T1D, T3Y, T1J, T3H;
		    {
			 E T1v, T1x, T1u, T1w;
			 T1v = cr[WS(rs, 1)];
			 T1x = ci[WS(rs, 1)];
			 T1u = W[0];
			 T1w = W[1];
			 T1y = FMA(T1u, T1v, T1w * T1x);
			 T3X = FNMS(T1w, T1v, T1u * T1x);
		    }
		    {
			 E T1L, T1N, T1K, T1M;
			 T1L = cr[WS(rs, 25)];
			 T1N = ci[WS(rs, 25)];
			 T1K = W[48];
			 T1M = W[49];
			 T1O = FMA(T1K, T1L, T1M * T1N);
			 T3I = FNMS(T1M, T1L, T1K * T1N);
		    }
		    {
			 E T1A, T1C, T1z, T1B;
			 T1A = cr[WS(rs, 17)];
			 T1C = ci[WS(rs, 17)];
			 T1z = W[32];
			 T1B = W[33];
			 T1D = FMA(T1z, T1A, T1B * T1C);
			 T3Y = FNMS(T1B, T1A, T1z * T1C);
		    }
		    {
			 E T1G, T1I, T1F, T1H;
			 T1G = cr[WS(rs, 9)];
			 T1I = ci[WS(rs, 9)];
			 T1F = W[16];
			 T1H = W[17];
			 T1J = FMA(T1F, T1G, T1H * T1I);
			 T3H = FNMS(T1H, T1G, T1F * T1I);
		    }
		    {
			 E T1E, T1P, T5W, T5X;
			 T1E = T1y + T1D;
			 T1P = T1J + T1O;
			 T1Q = T1E + T1P;
			 T61 = T1E - T1P;
			 T5W = T3X + T3Y;
			 T5X = T3H + T3I;
			 T5Y = T5W - T5X;
			 T6J = T5W + T5X;
		    }
		    {
			 E T3G, T3J, T3Z, T40;
			 T3G = T1y - T1D;
			 T3J = T3H - T3I;
			 T3K = T3G + T3J;
			 T56 = T3G - T3J;
			 T3Z = T3X - T3Y;
			 T40 = T1J - T1O;
			 T41 = T3Z - T40;
			 T59 = T3Z + T40;
		    }
	       }
	       {
		    E T2j, T47, T2z, T4q, T2o, T48, T2u, T4p;
		    {
			 E T2g, T2i, T2f, T2h;
			 T2g = cr[WS(rs, 31)];
			 T2i = ci[WS(rs, 31)];
			 T2f = W[60];
			 T2h = W[61];
			 T2j = FMA(T2f, T2g, T2h * T2i);
			 T47 = FNMS(T2h, T2g, T2f * T2i);
		    }
		    {
			 E T2w, T2y, T2v, T2x;
			 T2w = cr[WS(rs, 23)];
			 T2y = ci[WS(rs, 23)];
			 T2v = W[44];
			 T2x = W[45];
			 T2z = FMA(T2v, T2w, T2x * T2y);
			 T4q = FNMS(T2x, T2w, T2v * T2y);
		    }
		    {
			 E T2l, T2n, T2k, T2m;
			 T2l = cr[WS(rs, 15)];
			 T2n = ci[WS(rs, 15)];
			 T2k = W[28];
			 T2m = W[29];
			 T2o = FMA(T2k, T2l, T2m * T2n);
			 T48 = FNMS(T2m, T2l, T2k * T2n);
		    }
		    {
			 E T2r, T2t, T2q, T2s;
			 T2r = cr[WS(rs, 7)];
			 T2t = ci[WS(rs, 7)];
			 T2q = W[12];
			 T2s = W[13];
			 T2u = FMA(T2q, T2r, T2s * T2t);
			 T4p = FNMS(T2s, T2r, T2q * T2t);
		    }
		    {
			 E T2p, T2A, T6c, T6d;
			 T2p = T2j + T2o;
			 T2A = T2u + T2z;
			 T2B = T2p + T2A;
			 T67 = T2p - T2A;
			 T6c = T47 + T48;
			 T6d = T4p + T4q;
			 T6e = T6c - T6d;
			 T6O = T6c + T6d;
		    }
		    {
			 E T49, T4a, T4o, T4r;
			 T49 = T47 - T48;
			 T4a = T2u - T2z;
			 T4b = T49 - T4a;
			 T5g = T49 + T4a;
			 T4o = T2j - T2o;
			 T4r = T4p - T4q;
			 T4s = T4o + T4r;
			 T5d = T4o - T4r;
		    }
	       }
	       {
		    E To, T37, TE, T3d, Tt, T38, Tz, T3c;
		    {
			 E Tl, Tn, Tk, Tm;
			 Tl = cr[WS(rs, 4)];
			 Tn = ci[WS(rs, 4)];
			 Tk = W[6];
			 Tm = W[7];
			 To = FMA(Tk, Tl, Tm * Tn);
			 T37 = FNMS(Tm, Tl, Tk * Tn);
		    }
		    {
			 E TB, TD, TA, TC;
			 TB = cr[WS(rs, 12)];
			 TD = ci[WS(rs, 12)];
			 TA = W[22];
			 TC = W[23];
			 TE = FMA(TA, TB, TC * TD);
			 T3d = FNMS(TC, TB, TA * TD);
		    }
		    {
			 E Tq, Ts, Tp, Tr;
			 Tq = cr[WS(rs, 20)];
			 Ts = ci[WS(rs, 20)];
			 Tp = W[38];
			 Tr = W[39];
			 Tt = FMA(Tp, Tq, Tr * Ts);
			 T38 = FNMS(Tr, Tq, Tp * Ts);
		    }
		    {
			 E Tw, Ty, Tv, Tx;
			 Tw = cr[WS(rs, 28)];
			 Ty = ci[WS(rs, 28)];
			 Tv = W[54];
			 Tx = W[55];
			 Tz = FMA(Tv, Tw, Tx * Ty);
			 T3c = FNMS(Tx, Tw, Tv * Ty);
		    }
		    {
			 E Tu, TF, T5G, T5H;
			 Tu = To + Tt;
			 TF = Tz + TE;
			 TG = Tu + TF;
			 T7l = Tu - TF;
			 T5G = T3c + T3d;
			 T5H = T37 + T38;
			 T5I = T5G - T5H;
			 T73 = T5H + T5G;
		    }
		    {
			 E T36, T39, T3b, T3e;
			 T36 = To - Tt;
			 T39 = T37 - T38;
			 T3a = T36 + T39;
			 T4U = T36 - T39;
			 T3b = Tz - TE;
			 T3e = T3c - T3d;
			 T3f = T3b - T3e;
			 T4V = T3b + T3e;
		    }
	       }
	       {
		    E TM, T3n, T12, T3k, TR, T3o, TX, T3j;
		    {
			 E TJ, TL, TI, TK;
			 TJ = cr[WS(rs, 2)];
			 TL = ci[WS(rs, 2)];
			 TI = W[2];
			 TK = W[3];
			 TM = FMA(TI, TJ, TK * TL);
			 T3n = FNMS(TK, TJ, TI * TL);
		    }
		    {
			 E TZ, T11, TY, T10;
			 TZ = cr[WS(rs, 26)];
			 T11 = ci[WS(rs, 26)];
			 TY = W[50];
			 T10 = W[51];
			 T12 = FMA(TY, TZ, T10 * T11);
			 T3k = FNMS(T10, TZ, TY * T11);
		    }
		    {
			 E TO, TQ, TN, TP;
			 TO = cr[WS(rs, 18)];
			 TQ = ci[WS(rs, 18)];
			 TN = W[34];
			 TP = W[35];
			 TR = FMA(TN, TO, TP * TQ);
			 T3o = FNMS(TP, TO, TN * TQ);
		    }
		    {
			 E TU, TW, TT, TV;
			 TU = cr[WS(rs, 10)];
			 TW = ci[WS(rs, 10)];
			 TT = W[18];
			 TV = W[19];
			 TX = FMA(TT, TU, TV * TW);
			 T3j = FNMS(TV, TU, TT * TW);
		    }
		    {
			 E TS, T13, T5L, T5M;
			 TS = TM + TR;
			 T13 = TX + T12;
			 T14 = TS + T13;
			 T5K = TS - T13;
			 T5L = T3n + T3o;
			 T5M = T3j + T3k;
			 T5N = T5L - T5M;
			 T6F = T5L + T5M;
		    }
		    {
			 E T3i, T3l, T3p, T3q;
			 T3i = TM - TR;
			 T3l = T3j - T3k;
			 T3m = T3i + T3l;
			 T4Z = T3i - T3l;
			 T3p = T3n - T3o;
			 T3q = TX - T12;
			 T3r = T3p - T3q;
			 T4Y = T3p + T3q;
		    }
	       }
	       {
		    E T19, T3t, T1p, T3A, T1e, T3u, T1k, T3z;
		    {
			 E T16, T18, T15, T17;
			 T16 = cr[WS(rs, 30)];
			 T18 = ci[WS(rs, 30)];
			 T15 = W[58];
			 T17 = W[59];
			 T19 = FMA(T15, T16, T17 * T18);
			 T3t = FNMS(T17, T16, T15 * T18);
		    }
		    {
			 E T1m, T1o, T1l, T1n;
			 T1m = cr[WS(rs, 22)];
			 T1o = ci[WS(rs, 22)];
			 T1l = W[42];
			 T1n = W[43];
			 T1p = FMA(T1l, T1m, T1n * T1o);
			 T3A = FNMS(T1n, T1m, T1l * T1o);
		    }
		    {
			 E T1b, T1d, T1a, T1c;
			 T1b = cr[WS(rs, 14)];
			 T1d = ci[WS(rs, 14)];
			 T1a = W[26];
			 T1c = W[27];
			 T1e = FMA(T1a, T1b, T1c * T1d);
			 T3u = FNMS(T1c, T1b, T1a * T1d);
		    }
		    {
			 E T1h, T1j, T1g, T1i;
			 T1h = cr[WS(rs, 6)];
			 T1j = ci[WS(rs, 6)];
			 T1g = W[10];
			 T1i = W[11];
			 T1k = FMA(T1g, T1h, T1i * T1j);
			 T3z = FNMS(T1i, T1h, T1g * T1j);
		    }
		    {
			 E T1f, T1q, T5Q, T5R;
			 T1f = T19 + T1e;
			 T1q = T1k + T1p;
			 T1r = T1f + T1q;
			 T5P = T1f - T1q;
			 T5Q = T3t + T3u;
			 T5R = T3z + T3A;
			 T5S = T5Q - T5R;
			 T6E = T5Q + T5R;
		    }
		    {
			 E T3v, T3w, T3y, T3B;
			 T3v = T3t - T3u;
			 T3w = T1k - T1p;
			 T3x = T3v - T3w;
			 T52 = T3v + T3w;
			 T3y = T19 - T1e;
			 T3B = T3z - T3A;
			 T3C = T3y + T3B;
			 T51 = T3y - T3B;
		    }
	       }
	       {
		    E T1V, T3M, T20, T3N, T3L, T3O, T26, T3Q, T2b, T3R, T3S, T3T;
		    {
			 E T1S, T1U, T1R, T1T;
			 T1S = cr[WS(rs, 5)];
			 T1U = ci[WS(rs, 5)];
			 T1R = W[8];
			 T1T = W[9];
			 T1V = FMA(T1R, T1S, T1T * T1U);
			 T3M = FNMS(T1T, T1S, T1R * T1U);
		    }
		    {
			 E T1X, T1Z, T1W, T1Y;
			 T1X = cr[WS(rs, 21)];
			 T1Z = ci[WS(rs, 21)];
			 T1W = W[40];
			 T1Y = W[41];
			 T20 = FMA(T1W, T1X, T1Y * T1Z);
			 T3N = FNMS(T1Y, T1X, T1W * T1Z);
		    }
		    T3L = T1V - T20;
		    T3O = T3M - T3N;
		    {
			 E T23, T25, T22, T24;
			 T23 = cr[WS(rs, 29)];
			 T25 = ci[WS(rs, 29)];
			 T22 = W[56];
			 T24 = W[57];
			 T26 = FMA(T22, T23, T24 * T25);
			 T3Q = FNMS(T24, T23, T22 * T25);
		    }
		    {
			 E T28, T2a, T27, T29;
			 T28 = cr[WS(rs, 13)];
			 T2a = ci[WS(rs, 13)];
			 T27 = W[24];
			 T29 = W[25];
			 T2b = FMA(T27, T28, T29 * T2a);
			 T3R = FNMS(T29, T28, T27 * T2a);
		    }
		    T3S = T3Q - T3R;
		    T3T = T26 - T2b;
		    {
			 E T21, T2c, T62, T63;
			 T21 = T1V + T20;
			 T2c = T26 + T2b;
			 T2d = T21 + T2c;
			 T5Z = T21 - T2c;
			 T62 = T3Q + T3R;
			 T63 = T3M + T3N;
			 T64 = T62 - T63;
			 T6K = T63 + T62;
		    }
		    {
			 E T3P, T3U, T42, T43;
			 T3P = T3L + T3O;
			 T3U = T3S - T3T;
			 T3V = KP707106781 * (T3P - T3U);
			 T5a = KP707106781 * (T3P + T3U);
			 T42 = T3T + T3S;
			 T43 = T3L - T3O;
			 T44 = KP707106781 * (T42 - T43);
			 T57 = KP707106781 * (T43 + T42);
		    }
	       }
	       {
		    E T2G, T4i, T2L, T4j, T4h, T4k, T2R, T4d, T2W, T4e, T4c, T4f;
		    {
			 E T2D, T2F, T2C, T2E;
			 T2D = cr[WS(rs, 3)];
			 T2F = ci[WS(rs, 3)];
			 T2C = W[4];
			 T2E = W[5];
			 T2G = FMA(T2C, T2D, T2E * T2F);
			 T4i = FNMS(T2E, T2D, T2C * T2F);
		    }
		    {
			 E T2I, T2K, T2H, T2J;
			 T2I = cr[WS(rs, 19)];
			 T2K = ci[WS(rs, 19)];
			 T2H = W[36];
			 T2J = W[37];
			 T2L = FMA(T2H, T2I, T2J * T2K);
			 T4j = FNMS(T2J, T2I, T2H * T2K);
		    }
		    T4h = T2G - T2L;
		    T4k = T4i - T4j;
		    {
			 E T2O, T2Q, T2N, T2P;
			 T2O = cr[WS(rs, 27)];
			 T2Q = ci[WS(rs, 27)];
			 T2N = W[52];
			 T2P = W[53];
			 T2R = FMA(T2N, T2O, T2P * T2Q);
			 T4d = FNMS(T2P, T2O, T2N * T2Q);
		    }
		    {
			 E T2T, T2V, T2S, T2U;
			 T2T = cr[WS(rs, 11)];
			 T2V = ci[WS(rs, 11)];
			 T2S = W[20];
			 T2U = W[21];
			 T2W = FMA(T2S, T2T, T2U * T2V);
			 T4e = FNMS(T2U, T2T, T2S * T2V);
		    }
		    T4c = T2R - T2W;
		    T4f = T4d - T4e;
		    {
			 E T2M, T2X, T68, T69;
			 T2M = T2G + T2L;
			 T2X = T2R + T2W;
			 T2Y = T2M + T2X;
			 T6f = T2M - T2X;
			 T68 = T4d + T4e;
			 T69 = T4i + T4j;
			 T6a = T68 - T69;
			 T6P = T69 + T68;
		    }
		    {
			 E T4g, T4l, T4t, T4u;
			 T4g = T4c + T4f;
			 T4l = T4h - T4k;
			 T4m = KP707106781 * (T4g - T4l);
			 T5e = KP707106781 * (T4l + T4g);
			 T4t = T4h + T4k;
			 T4u = T4f - T4c;
			 T4v = KP707106781 * (T4t - T4u);
			 T5h = KP707106781 * (T4t + T4u);
		    }
	       }
	       {
		    E T1t, T6X, T7a, T7c, T30, T7b, T70, T71;
		    {
			 E TH, T1s, T72, T79;
			 TH = Tj + TG;
			 T1s = T14 + T1r;
			 T1t = TH + T1s;
			 T6X = TH - T1s;
			 T72 = T6F + T6E;
			 T79 = T73 + T78;
			 T7a = T72 + T79;
			 T7c = T79 - T72;
		    }
		    {
			 E T2e, T2Z, T6Y, T6Z;
			 T2e = T1Q + T2d;
			 T2Z = T2B + T2Y;
			 T30 = T2e + T2Z;
			 T7b = T2Z - T2e;
			 T6Y = T6O + T6P;
			 T6Z = T6J + T6K;
			 T70 = T6Y - T6Z;
			 T71 = T6Z + T6Y;
		    }
		    ci[WS(rs, 15)] = T1t - T30;
		    cr[WS(rs, 24)] = T7b - T7c;
		    ci[WS(rs, 23)] = T7b + T7c;
		    cr[0] = T1t + T30;
		    cr[WS(rs, 8)] = T6X - T70;
		    cr[WS(rs, 16)] = T71 - T7a;
		    ci[WS(rs, 31)] = T71 + T7a;
		    ci[WS(rs, 7)] = T6X + T70;
	       }
	       {
		    E T4X, T5p, T7D, T7J, T54, T7y, T5z, T5D, T5c, T5m, T5s, T7I, T5w, T5C, T5j;
		    E T5n, T4W, T7z;
		    T4W = KP707106781 * (T4U + T4V);
		    T4X = T4T - T4W;
		    T5p = T4T + T4W;
		    T7z = KP707106781 * (T3a - T3f);
		    T7D = T7z + T7C;
		    T7J = T7C - T7z;
		    {
			 E T50, T53, T5x, T5y;
			 T50 = FMA(KP923879532, T4Y, KP382683432 * T4Z);
			 T53 = FNMS(KP923879532, T52, KP382683432 * T51);
			 T54 = T50 + T53;
			 T7y = T50 - T53;
			 T5x = T5d + T5e;
			 T5y = T5g + T5h;
			 T5z = FNMS(KP980785280, T5y, KP195090322 * T5x);
			 T5D = FMA(KP980785280, T5x, KP195090322 * T5y);
		    }
		    {
			 E T58, T5b, T5q, T5r;
			 T58 = T56 - T57;
			 T5b = T59 - T5a;
			 T5c = FMA(KP831469612, T58, KP555570233 * T5b);
			 T5m = FNMS(KP831469612, T5b, KP555570233 * T58);
			 T5q = FNMS(KP382683432, T4Y, KP923879532 * T4Z);
			 T5r = FMA(KP382683432, T52, KP923879532 * T51);
			 T5s = T5q + T5r;
			 T7I = T5r - T5q;
		    }
		    {
			 E T5u, T5v, T5f, T5i;
			 T5u = T56 + T57;
			 T5v = T59 + T5a;
			 T5w = FMA(KP195090322, T5u, KP980785280 * T5v);
			 T5C = FNMS(KP195090322, T5v, KP980785280 * T5u);
			 T5f = T5d - T5e;
			 T5i = T5g - T5h;
			 T5j = FNMS(KP555570233, T5i, KP831469612 * T5f);
			 T5n = FMA(KP555570233, T5f, KP831469612 * T5i);
		    }
		    {
			 E T55, T5k, T7H, T7K;
			 T55 = T4X + T54;
			 T5k = T5c + T5j;
			 ci[WS(rs, 12)] = T55 - T5k;
			 cr[WS(rs, 3)] = T55 + T5k;
			 T7H = T5n - T5m;
			 T7K = T7I + T7J;
			 cr[WS(rs, 19)] = T7H - T7K;
			 ci[WS(rs, 28)] = T7H + T7K;
		    }
		    {
			 E T7L, T7M, T5l, T5o;
			 T7L = T5j - T5c;
			 T7M = T7J - T7I;
			 cr[WS(rs, 27)] = T7L - T7M;
			 ci[WS(rs, 20)] = T7L + T7M;
			 T5l = T4X - T54;
			 T5o = T5m + T5n;
			 cr[WS(rs, 11)] = T5l - T5o;
			 ci[WS(rs, 4)] = T5l + T5o;
		    }
		    {
			 E T5t, T5A, T7x, T7E;
			 T5t = T5p - T5s;
			 T5A = T5w + T5z;
			 ci[WS(rs, 8)] = T5t - T5A;
			 cr[WS(rs, 7)] = T5t + T5A;
			 T7x = T5z - T5w;
			 T7E = T7y + T7D;
			 cr[WS(rs, 31)] = T7x - T7E;
			 ci[WS(rs, 16)] = T7x + T7E;
		    }
		    {
			 E T7F, T7G, T5B, T5E;
			 T7F = T5D - T5C;
			 T7G = T7D - T7y;
			 cr[WS(rs, 23)] = T7F - T7G;
			 ci[WS(rs, 24)] = T7F + T7G;
			 T5B = T5p + T5s;
			 T5E = T5C + T5D;
			 cr[WS(rs, 15)] = T5B - T5E;
			 ci[0] = T5B + T5E;
		    }
	       }
	       {
		    E T6H, T6T, T7g, T7i, T6M, T6U, T6R, T6V;
		    {
			 E T6D, T6G, T7e, T7f;
			 T6D = Tj - TG;
			 T6G = T6E - T6F;
			 T6H = T6D - T6G;
			 T6T = T6D + T6G;
			 T7e = T14 - T1r;
			 T7f = T78 - T73;
			 T7g = T7e + T7f;
			 T7i = T7f - T7e;
		    }
		    {
			 E T6I, T6L, T6N, T6Q;
			 T6I = T1Q - T2d;
			 T6L = T6J - T6K;
			 T6M = T6I + T6L;
			 T6U = T6I - T6L;
			 T6N = T2B - T2Y;
			 T6Q = T6O - T6P;
			 T6R = T6N - T6Q;
			 T6V = T6N + T6Q;
		    }
		    {
			 E T6S, T7h, T6W, T7d;
			 T6S = KP707106781 * (T6M + T6R);
			 ci[WS(rs, 11)] = T6H - T6S;
			 cr[WS(rs, 4)] = T6H + T6S;
			 T7h = KP707106781 * (T6V - T6U);
			 cr[WS(rs, 20)] = T7h - T7i;
			 ci[WS(rs, 27)] = T7h + T7i;
			 T6W = KP707106781 * (T6U + T6V);
			 cr[WS(rs, 12)] = T6T - T6W;
			 ci[WS(rs, 3)] = T6T + T6W;
			 T7d = KP707106781 * (T6R - T6M);
			 cr[WS(rs, 28)] = T7d - T7g;
			 ci[WS(rs, 19)] = T7d + T7g;
		    }
	       }
	       {
		    E T5J, T7n, T7t, T6n, T5U, T7k, T6x, T6B, T6q, T7s, T66, T6k, T6u, T6A, T6h;
		    E T6l;
		    {
			 E T5O, T5T, T60, T65;
			 T5J = T5F - T5I;
			 T7n = T7l + T7m;
			 T7t = T7m - T7l;
			 T6n = T5F + T5I;
			 T5O = T5K + T5N;
			 T5T = T5P - T5S;
			 T5U = KP707106781 * (T5O + T5T);
			 T7k = KP707106781 * (T5O - T5T);
			 {
			      E T6v, T6w, T6o, T6p;
			      T6v = T6e + T6f;
			      T6w = T67 + T6a;
			      T6x = FMA(KP382683432, T6v, KP923879532 * T6w);
			      T6B = FNMS(KP923879532, T6v, KP382683432 * T6w);
			      T6o = T5K - T5N;
			      T6p = T5P + T5S;
			      T6q = KP707106781 * (T6o + T6p);
			      T7s = KP707106781 * (T6p - T6o);
			 }
			 T60 = T5Y - T5Z;
			 T65 = T61 - T64;
			 T66 = FMA(KP382683432, T60, KP923879532 * T65);
			 T6k = FNMS(KP923879532, T60, KP382683432 * T65);
			 {
			      E T6s, T6t, T6b, T6g;
			      T6s = T61 + T64;
			      T6t = T5Y + T5Z;
			      T6u = FNMS(KP382683432, T6t, KP923879532 * T6s);
			      T6A = FMA(KP923879532, T6t, KP382683432 * T6s);
			      T6b = T67 - T6a;
			      T6g = T6e - T6f;
			      T6h = FNMS(KP382683432, T6g, KP923879532 * T6b);
			      T6l = FMA(KP923879532, T6g, KP382683432 * T6b);
			 }
		    }
		    {
			 E T5V, T6i, T7r, T7u;
			 T5V = T5J + T5U;
			 T6i = T66 + T6h;
			 ci[WS(rs, 13)] = T5V - T6i;
			 cr[WS(rs, 2)] = T5V + T6i;
			 T7r = T6l - T6k;
			 T7u = T7s + T7t;
			 cr[WS(rs, 18)] = T7r - T7u;
			 ci[WS(rs, 29)] = T7r + T7u;
		    }
		    {
			 E T7v, T7w, T6j, T6m;
			 T7v = T6h - T66;
			 T7w = T7t - T7s;
			 cr[WS(rs, 26)] = T7v - T7w;
			 ci[WS(rs, 21)] = T7v + T7w;
			 T6j = T5J - T5U;
			 T6m = T6k + T6l;
			 cr[WS(rs, 10)] = T6j - T6m;
			 ci[WS(rs, 5)] = T6j + T6m;
		    }
		    {
			 E T6r, T6y, T7j, T7o;
			 T6r = T6n + T6q;
			 T6y = T6u + T6x;
			 cr[WS(rs, 14)] = T6r - T6y;
			 ci[WS(rs, 1)] = T6r + T6y;
			 T7j = T6B - T6A;
			 T7o = T7k + T7n;
			 cr[WS(rs, 30)] = T7j - T7o;
			 ci[WS(rs, 17)] = T7j + T7o;
		    }
		    {
			 E T7p, T7q, T6z, T6C;
			 T7p = T6x - T6u;
			 T7q = T7n - T7k;
			 cr[WS(rs, 22)] = T7p - T7q;
			 ci[WS(rs, 25)] = T7p + T7q;
			 T6z = T6n - T6q;
			 T6C = T6A + T6B;
			 ci[WS(rs, 9)] = T6z - T6C;
			 cr[WS(rs, 6)] = T6z + T6C;
		    }
	       }
	       {
		    E T3h, T4D, T7R, T7X, T3E, T7O, T4N, T4R, T46, T4A, T4G, T7W, T4K, T4Q, T4x;
		    E T4B, T3g, T7P;
		    T3g = KP707106781 * (T3a + T3f);
		    T3h = T35 - T3g;
		    T4D = T35 + T3g;
		    T7P = KP707106781 * (T4V - T4U);
		    T7R = T7P + T7Q;
		    T7X = T7Q - T7P;
		    {
			 E T3s, T3D, T4L, T4M;
			 T3s = FNMS(KP923879532, T3r, KP382683432 * T3m);
			 T3D = FMA(KP923879532, T3x, KP382683432 * T3C);
			 T3E = T3s + T3D;
			 T7O = T3D - T3s;
			 T4L = T4s + T4v;
			 T4M = T4b + T4m;
			 T4N = FNMS(KP195090322, T4M, KP980785280 * T4L);
			 T4R = FMA(KP980785280, T4M, KP195090322 * T4L);
		    }
		    {
			 E T3W, T45, T4E, T4F;
			 T3W = T3K - T3V;
			 T45 = T41 - T44;
			 T46 = FNMS(KP555570233, T45, KP831469612 * T3W);
			 T4A = FMA(KP831469612, T45, KP555570233 * T3W);
			 T4E = FMA(KP382683432, T3r, KP923879532 * T3m);
			 T4F = FNMS(KP382683432, T3x, KP923879532 * T3C);
			 T4G = T4E + T4F;
			 T7W = T4E - T4F;
		    }
		    {
			 E T4I, T4J, T4n, T4w;
			 T4I = T41 + T44;
			 T4J = T3K + T3V;
			 T4K = FMA(KP195090322, T4I, KP980785280 * T4J);
			 T4Q = FNMS(KP980785280, T4I, KP195090322 * T4J);
			 T4n = T4b - T4m;
			 T4w = T4s - T4v;
			 T4x = FMA(KP555570233, T4n, KP831469612 * T4w);
			 T4B = FNMS(KP831469612, T4n, KP555570233 * T4w);
		    }
		    {
			 E T3F, T4y, T7V, T7Y;
			 T3F = T3h + T3E;
			 T4y = T46 + T4x;
			 cr[WS(rs, 13)] = T3F - T4y;
			 ci[WS(rs, 2)] = T3F + T4y;
			 T7V = T4B - T4A;
			 T7Y = T7W + T7X;
			 cr[WS(rs, 29)] = T7V - T7Y;
			 ci[WS(rs, 18)] = T7V + T7Y;
		    }
		    {
			 E T7Z, T80, T4z, T4C;
			 T7Z = T4x - T46;
			 T80 = T7X - T7W;
			 cr[WS(rs, 21)] = T7Z - T80;
			 ci[WS(rs, 26)] = T7Z + T80;
			 T4z = T3h - T3E;
			 T4C = T4A + T4B;
			 ci[WS(rs, 10)] = T4z - T4C;
			 cr[WS(rs, 5)] = T4z + T4C;
		    }
		    {
			 E T4H, T4O, T7N, T7S;
			 T4H = T4D + T4G;
			 T4O = T4K + T4N;
			 ci[WS(rs, 14)] = T4H - T4O;
			 cr[WS(rs, 1)] = T4H + T4O;
			 T7N = T4R - T4Q;
			 T7S = T7O + T7R;
			 cr[WS(rs, 17)] = T7N - T7S;
			 ci[WS(rs, 30)] = T7N + T7S;
		    }
		    {
			 E T7T, T7U, T4P, T4S;
			 T7T = T4N - T4K;
			 T7U = T7R - T7O;
			 cr[WS(rs, 25)] = T7T - T7U;
			 ci[WS(rs, 22)] = T7T + T7U;
			 T4P = T4D - T4G;
			 T4S = T4Q + T4R;
			 cr[WS(rs, 9)] = T4P - T4S;
			 ci[WS(rs, 6)] = T4P + T4S;
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 32},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 32, "hf_32", twinstr, &GENUS, {340, 114, 94, 0} };

void X(codelet_hf_32) (planner *p) {
     X(khc2hc_register) (p, hf_32, &desc);
}
#endif
