/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the TaskResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &TaskResponse{}

// TaskResponse Base serializer for use with :class:`pulpcore.app.models.Model`  This ensures that all Serializers provide values for the 'pulp_href` field.  The class provides a default for the ``ref_name`` attribute in the ModelSerializers's ``Meta`` class. This ensures that the OpenAPI definitions of plugins are namespaced properly.
type TaskResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// The current state of the task. The possible values include: 'waiting', 'skipped', 'running', 'completed', 'failed', 'canceled' and 'canceling'.
	State *string `json:"state,omitempty"`
	// The name of task.
	Name string `json:"name"`
	// The logging correlation id associated with this task
	LoggingCid string `json:"logging_cid"`
	// User who dispatched this task.
	CreatedBy *string `json:"created_by,omitempty"`
	// Timestamp of the when this task started execution.
	StartedAt *time.Time `json:"started_at,omitempty"`
	// Timestamp of the when this task stopped execution.
	FinishedAt *time.Time `json:"finished_at,omitempty"`
	// A JSON Object of a fatal error encountered during the execution of this task.
	Error map[string]map[string]interface{} `json:"error,omitempty"`
	// The worker associated with this task. This field is empty if a worker is not yet assigned.
	Worker *string `json:"worker,omitempty"`
	// The parent task that spawned this task.
	ParentTask *string `json:"parent_task,omitempty"`
	// Any tasks spawned by this task.
	ChildTasks []string `json:"child_tasks,omitempty"`
	// The task group that this task is a member of.
	TaskGroup *string `json:"task_group,omitempty"`
	ProgressReports []ProgressReportResponse `json:"progress_reports,omitempty"`
	// Resources created by this task.
	CreatedResources []string `json:"created_resources,omitempty"`
	// A list of resources required by that task.
	ReservedResourcesRecord []string `json:"reserved_resources_record,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _TaskResponse TaskResponse

// NewTaskResponse instantiates a new TaskResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTaskResponse(name string, loggingCid string) *TaskResponse {
	this := TaskResponse{}
	this.Name = name
	this.LoggingCid = loggingCid
	return &this
}

// NewTaskResponseWithDefaults instantiates a new TaskResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTaskResponseWithDefaults() *TaskResponse {
	this := TaskResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *TaskResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *TaskResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *TaskResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *TaskResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *TaskResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *TaskResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetState returns the State field value if set, zero value otherwise.
func (o *TaskResponse) GetState() string {
	if o == nil || IsNil(o.State) {
		var ret string
		return ret
	}
	return *o.State
}

// GetStateOk returns a tuple with the State field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetStateOk() (*string, bool) {
	if o == nil || IsNil(o.State) {
		return nil, false
	}
	return o.State, true
}

// HasState returns a boolean if a field has been set.
func (o *TaskResponse) HasState() bool {
	if o != nil && !IsNil(o.State) {
		return true
	}

	return false
}

// SetState gets a reference to the given string and assigns it to the State field.
func (o *TaskResponse) SetState(v string) {
	o.State = &v
}

// GetName returns the Name field value
func (o *TaskResponse) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *TaskResponse) SetName(v string) {
	o.Name = v
}

// GetLoggingCid returns the LoggingCid field value
func (o *TaskResponse) GetLoggingCid() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.LoggingCid
}

// GetLoggingCidOk returns a tuple with the LoggingCid field value
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetLoggingCidOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.LoggingCid, true
}

// SetLoggingCid sets field value
func (o *TaskResponse) SetLoggingCid(v string) {
	o.LoggingCid = v
}

// GetCreatedBy returns the CreatedBy field value if set, zero value otherwise.
func (o *TaskResponse) GetCreatedBy() string {
	if o == nil || IsNil(o.CreatedBy) {
		var ret string
		return ret
	}
	return *o.CreatedBy
}

// GetCreatedByOk returns a tuple with the CreatedBy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetCreatedByOk() (*string, bool) {
	if o == nil || IsNil(o.CreatedBy) {
		return nil, false
	}
	return o.CreatedBy, true
}

// HasCreatedBy returns a boolean if a field has been set.
func (o *TaskResponse) HasCreatedBy() bool {
	if o != nil && !IsNil(o.CreatedBy) {
		return true
	}

	return false
}

// SetCreatedBy gets a reference to the given string and assigns it to the CreatedBy field.
func (o *TaskResponse) SetCreatedBy(v string) {
	o.CreatedBy = &v
}

// GetStartedAt returns the StartedAt field value if set, zero value otherwise.
func (o *TaskResponse) GetStartedAt() time.Time {
	if o == nil || IsNil(o.StartedAt) {
		var ret time.Time
		return ret
	}
	return *o.StartedAt
}

// GetStartedAtOk returns a tuple with the StartedAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetStartedAtOk() (*time.Time, bool) {
	if o == nil || IsNil(o.StartedAt) {
		return nil, false
	}
	return o.StartedAt, true
}

// HasStartedAt returns a boolean if a field has been set.
func (o *TaskResponse) HasStartedAt() bool {
	if o != nil && !IsNil(o.StartedAt) {
		return true
	}

	return false
}

// SetStartedAt gets a reference to the given time.Time and assigns it to the StartedAt field.
func (o *TaskResponse) SetStartedAt(v time.Time) {
	o.StartedAt = &v
}

// GetFinishedAt returns the FinishedAt field value if set, zero value otherwise.
func (o *TaskResponse) GetFinishedAt() time.Time {
	if o == nil || IsNil(o.FinishedAt) {
		var ret time.Time
		return ret
	}
	return *o.FinishedAt
}

// GetFinishedAtOk returns a tuple with the FinishedAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetFinishedAtOk() (*time.Time, bool) {
	if o == nil || IsNil(o.FinishedAt) {
		return nil, false
	}
	return o.FinishedAt, true
}

// HasFinishedAt returns a boolean if a field has been set.
func (o *TaskResponse) HasFinishedAt() bool {
	if o != nil && !IsNil(o.FinishedAt) {
		return true
	}

	return false
}

// SetFinishedAt gets a reference to the given time.Time and assigns it to the FinishedAt field.
func (o *TaskResponse) SetFinishedAt(v time.Time) {
	o.FinishedAt = &v
}

// GetError returns the Error field value if set, zero value otherwise.
func (o *TaskResponse) GetError() map[string]map[string]interface{} {
	if o == nil || IsNil(o.Error) {
		var ret map[string]map[string]interface{}
		return ret
	}
	return o.Error
}

// GetErrorOk returns a tuple with the Error field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetErrorOk() (map[string]map[string]interface{}, bool) {
	if o == nil || IsNil(o.Error) {
		return map[string]map[string]interface{}{}, false
	}
	return o.Error, true
}

// HasError returns a boolean if a field has been set.
func (o *TaskResponse) HasError() bool {
	if o != nil && !IsNil(o.Error) {
		return true
	}

	return false
}

// SetError gets a reference to the given map[string]map[string]interface{} and assigns it to the Error field.
func (o *TaskResponse) SetError(v map[string]map[string]interface{}) {
	o.Error = v
}

// GetWorker returns the Worker field value if set, zero value otherwise.
func (o *TaskResponse) GetWorker() string {
	if o == nil || IsNil(o.Worker) {
		var ret string
		return ret
	}
	return *o.Worker
}

// GetWorkerOk returns a tuple with the Worker field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetWorkerOk() (*string, bool) {
	if o == nil || IsNil(o.Worker) {
		return nil, false
	}
	return o.Worker, true
}

// HasWorker returns a boolean if a field has been set.
func (o *TaskResponse) HasWorker() bool {
	if o != nil && !IsNil(o.Worker) {
		return true
	}

	return false
}

// SetWorker gets a reference to the given string and assigns it to the Worker field.
func (o *TaskResponse) SetWorker(v string) {
	o.Worker = &v
}

// GetParentTask returns the ParentTask field value if set, zero value otherwise.
func (o *TaskResponse) GetParentTask() string {
	if o == nil || IsNil(o.ParentTask) {
		var ret string
		return ret
	}
	return *o.ParentTask
}

// GetParentTaskOk returns a tuple with the ParentTask field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetParentTaskOk() (*string, bool) {
	if o == nil || IsNil(o.ParentTask) {
		return nil, false
	}
	return o.ParentTask, true
}

// HasParentTask returns a boolean if a field has been set.
func (o *TaskResponse) HasParentTask() bool {
	if o != nil && !IsNil(o.ParentTask) {
		return true
	}

	return false
}

// SetParentTask gets a reference to the given string and assigns it to the ParentTask field.
func (o *TaskResponse) SetParentTask(v string) {
	o.ParentTask = &v
}

// GetChildTasks returns the ChildTasks field value if set, zero value otherwise.
func (o *TaskResponse) GetChildTasks() []string {
	if o == nil || IsNil(o.ChildTasks) {
		var ret []string
		return ret
	}
	return o.ChildTasks
}

// GetChildTasksOk returns a tuple with the ChildTasks field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetChildTasksOk() ([]string, bool) {
	if o == nil || IsNil(o.ChildTasks) {
		return nil, false
	}
	return o.ChildTasks, true
}

// HasChildTasks returns a boolean if a field has been set.
func (o *TaskResponse) HasChildTasks() bool {
	if o != nil && !IsNil(o.ChildTasks) {
		return true
	}

	return false
}

// SetChildTasks gets a reference to the given []string and assigns it to the ChildTasks field.
func (o *TaskResponse) SetChildTasks(v []string) {
	o.ChildTasks = v
}

// GetTaskGroup returns the TaskGroup field value if set, zero value otherwise.
func (o *TaskResponse) GetTaskGroup() string {
	if o == nil || IsNil(o.TaskGroup) {
		var ret string
		return ret
	}
	return *o.TaskGroup
}

// GetTaskGroupOk returns a tuple with the TaskGroup field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetTaskGroupOk() (*string, bool) {
	if o == nil || IsNil(o.TaskGroup) {
		return nil, false
	}
	return o.TaskGroup, true
}

// HasTaskGroup returns a boolean if a field has been set.
func (o *TaskResponse) HasTaskGroup() bool {
	if o != nil && !IsNil(o.TaskGroup) {
		return true
	}

	return false
}

// SetTaskGroup gets a reference to the given string and assigns it to the TaskGroup field.
func (o *TaskResponse) SetTaskGroup(v string) {
	o.TaskGroup = &v
}

// GetProgressReports returns the ProgressReports field value if set, zero value otherwise.
func (o *TaskResponse) GetProgressReports() []ProgressReportResponse {
	if o == nil || IsNil(o.ProgressReports) {
		var ret []ProgressReportResponse
		return ret
	}
	return o.ProgressReports
}

// GetProgressReportsOk returns a tuple with the ProgressReports field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetProgressReportsOk() ([]ProgressReportResponse, bool) {
	if o == nil || IsNil(o.ProgressReports) {
		return nil, false
	}
	return o.ProgressReports, true
}

// HasProgressReports returns a boolean if a field has been set.
func (o *TaskResponse) HasProgressReports() bool {
	if o != nil && !IsNil(o.ProgressReports) {
		return true
	}

	return false
}

// SetProgressReports gets a reference to the given []ProgressReportResponse and assigns it to the ProgressReports field.
func (o *TaskResponse) SetProgressReports(v []ProgressReportResponse) {
	o.ProgressReports = v
}

// GetCreatedResources returns the CreatedResources field value if set, zero value otherwise.
func (o *TaskResponse) GetCreatedResources() []string {
	if o == nil || IsNil(o.CreatedResources) {
		var ret []string
		return ret
	}
	return o.CreatedResources
}

// GetCreatedResourcesOk returns a tuple with the CreatedResources field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetCreatedResourcesOk() ([]string, bool) {
	if o == nil || IsNil(o.CreatedResources) {
		return nil, false
	}
	return o.CreatedResources, true
}

// HasCreatedResources returns a boolean if a field has been set.
func (o *TaskResponse) HasCreatedResources() bool {
	if o != nil && !IsNil(o.CreatedResources) {
		return true
	}

	return false
}

// SetCreatedResources gets a reference to the given []string and assigns it to the CreatedResources field.
func (o *TaskResponse) SetCreatedResources(v []string) {
	o.CreatedResources = v
}

// GetReservedResourcesRecord returns the ReservedResourcesRecord field value if set, zero value otherwise.
func (o *TaskResponse) GetReservedResourcesRecord() []string {
	if o == nil || IsNil(o.ReservedResourcesRecord) {
		var ret []string
		return ret
	}
	return o.ReservedResourcesRecord
}

// GetReservedResourcesRecordOk returns a tuple with the ReservedResourcesRecord field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TaskResponse) GetReservedResourcesRecordOk() ([]string, bool) {
	if o == nil || IsNil(o.ReservedResourcesRecord) {
		return nil, false
	}
	return o.ReservedResourcesRecord, true
}

// HasReservedResourcesRecord returns a boolean if a field has been set.
func (o *TaskResponse) HasReservedResourcesRecord() bool {
	if o != nil && !IsNil(o.ReservedResourcesRecord) {
		return true
	}

	return false
}

// SetReservedResourcesRecord gets a reference to the given []string and assigns it to the ReservedResourcesRecord field.
func (o *TaskResponse) SetReservedResourcesRecord(v []string) {
	o.ReservedResourcesRecord = v
}

func (o TaskResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o TaskResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	if !IsNil(o.State) {
		toSerialize["state"] = o.State
	}
	toSerialize["name"] = o.Name
	toSerialize["logging_cid"] = o.LoggingCid
	if !IsNil(o.CreatedBy) {
		toSerialize["created_by"] = o.CreatedBy
	}
	if !IsNil(o.StartedAt) {
		toSerialize["started_at"] = o.StartedAt
	}
	if !IsNil(o.FinishedAt) {
		toSerialize["finished_at"] = o.FinishedAt
	}
	if !IsNil(o.Error) {
		toSerialize["error"] = o.Error
	}
	if !IsNil(o.Worker) {
		toSerialize["worker"] = o.Worker
	}
	if !IsNil(o.ParentTask) {
		toSerialize["parent_task"] = o.ParentTask
	}
	if !IsNil(o.ChildTasks) {
		toSerialize["child_tasks"] = o.ChildTasks
	}
	if !IsNil(o.TaskGroup) {
		toSerialize["task_group"] = o.TaskGroup
	}
	if !IsNil(o.ProgressReports) {
		toSerialize["progress_reports"] = o.ProgressReports
	}
	if !IsNil(o.CreatedResources) {
		toSerialize["created_resources"] = o.CreatedResources
	}
	if !IsNil(o.ReservedResourcesRecord) {
		toSerialize["reserved_resources_record"] = o.ReservedResourcesRecord
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *TaskResponse) UnmarshalJSON(bytes []byte) (err error) {
	varTaskResponse := _TaskResponse{}

	if err = json.Unmarshal(bytes, &varTaskResponse); err == nil {
		*o = TaskResponse(varTaskResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "state")
		delete(additionalProperties, "name")
		delete(additionalProperties, "logging_cid")
		delete(additionalProperties, "created_by")
		delete(additionalProperties, "started_at")
		delete(additionalProperties, "finished_at")
		delete(additionalProperties, "error")
		delete(additionalProperties, "worker")
		delete(additionalProperties, "parent_task")
		delete(additionalProperties, "child_tasks")
		delete(additionalProperties, "task_group")
		delete(additionalProperties, "progress_reports")
		delete(additionalProperties, "created_resources")
		delete(additionalProperties, "reserved_resources_record")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableTaskResponse struct {
	value *TaskResponse
	isSet bool
}

func (v NullableTaskResponse) Get() *TaskResponse {
	return v.value
}

func (v *NullableTaskResponse) Set(val *TaskResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableTaskResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableTaskResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTaskResponse(val *TaskResponse) *NullableTaskResponse {
	return &NullableTaskResponse{value: val, isSet: true}
}

func (v NullableTaskResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTaskResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


