CREATE TABLE if not exists trade_sequence_000(name varchar(512),value int,min_value int,max_value int,step int, gmt_create DATETIME, gmt_modified DATETIME, primary key (name)) COMPRESSION="ZLIB_1.0";
CREATE TABLE if not exists BUSINESS_ACTION_000(ACTION_ID int NOT NULL,TX_ID varchar(256) NOT NULL, NAME varchar(128) NOT NULL, STATE varchar(2) NOT NULL,GMT_CREATE DATETIME NOT NULL,GMT_MODIFIED DATETIME NOT NULL,CONTEXT varchar(8000),primary key (ACTION_ID)) COMPRESSION="ZLIB_1.0";

CREATE INDEX BUSINESS_ACTION_GMT_IND ON BUSINESS_ACTION_000 (GMT_MODIFIED) STORING(STATE) COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists BUSINESS_ACTIVITY_000(TX_ID varchar(256) NOT NULL, STATE varchar(2) NOT NULL,ACCOUNT_TRANS_STATE varchar(2) NOT NULL,GMT_CREATE DATETIME NOT NULL,GMT_MODIFIED DATETIME NOT NULL, PROPAGATION varchar(2), CONTEXT varchar(4096), primary key (TX_ID)) COMPRESSION="ZLIB_1.0";

CREATE INDEX BUSINESS_ACTIVITY_GMT_IND ON BUSINESS_ACTIVITY_000(GMT_MODIFIED) STORING (STATE) COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists NOTIFY_000(ID varchar(68) NOT NULL,PLUGIN varchar(100) NOT NULL,PARAMETER varchar(8000) NOT NULL,GROUP_NO int NOT NULL,STATUS varchar(2) NOT NULL, GMT_CREATE DATETIME NOT NULL,GMT_MODIFY DATETIME NOT NULL,IW_USER_ID varchar(16),CHANNEL_ENDPOINT varchar(400),BUSINESS_ORDER varchar(256),BUSINESS_TYPE varchar(100),PLUGIN_HOST varchar(30),GMT_LOCAL_CREATE  DATETIME,GMT_COMPENSATE DATETIME,primary key (id))COMPRESSION="ZLIB_1.0";
CREATE INDEX NOTIFY_BUSINESS_ORDER1_IND ON NOTIFY_000 (BUSINESS_ORDER)COMPRESSION="ZLIB_1.0";
CREATE INDEX NOTIFY_PLUGIN_IND ON NOTIFY_000 (PLUGIN, CHANNEL_ENDPOINT)COMPRESSION="ZLIB_1.0";
CREATE UNIQUE INDEX IDX_GMT_COMPENSATE_NOFITY ON NOTIFY_000 (GMT_COMPENSATE) STORING (STATUS) COMPRESSION="ZLIB_1.0";
CREATE TABLE if not exists NOTIFY_HISTORY_000(ID varchar(68) NOT NULL,PLUGIN varchar(100) NOT NULL,PARAMETER varchar(8000) NOT NULL,GROUP_NO int NOT NULL,STATUS varchar(2) NOT NULL,GMT_CREATE DATETIME NOT NULL,GMT_MODIFY DATETIME NOT NULL,IW_USER_ID varchar(16),CHANNEL_ENDPOINT varchar(400),BUSINESS_ORDER varchar(256),BUSINESS_TYPE varchar(100),PLUGIN_HOST varchar(30),GMT_LOCAL_CREATE  DATETIME,PRIMARY KEY (ID,GMT_CREATE))COMPRESSION="ZLIB_1.0";
CREATE INDEX NOTIFY_HISTORY_BORDER_IND ON NOTIFY_HISTORY_000 (BUSINESS_ORDER)COMPRESSION="ZLIB_1.0";
CREATE INDEX NOTIFY_HISTORY_IG_IND ON NOTIFY_HISTORY_000 (IW_USER_ID, GROUP_NO)COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TIMEOUT_000(JOB_ID varchar(64) NOT NULL, TRADE_NO_PREFIX varchar(1) NOT NULL, TRADE_NO varchar(64) NOT NULL,USER_ID varchar(128),PAYTYPE varchar(8),END_TIME DATETIME,ACTION varchar(60),PARAMETER varchar(200),STATUS varchar(2),ACTION_TYPE varchar(2),GMT_CREATE DATETIME,PRIOR_LEVEL int default 1,GMT_MODIFIED DATETIME,GMT_OCCUR DATETIME,GMT_COMPENSATED DATETIME,PRIMARY KEY (JOB_ID)) COMPRESSION="ZLIB_1.0";

CREATE INDEX IND_BEYOND_TIMEOUT_ETIME ON TIMEOUT_000 (END_TIME)COMPRESSION="ZLIB_1.0";
CREATE INDEX TIMEOUT_PL_IND ON TIMEOUT_000 (PRIOR_LEVEL)COMPRESSION="ZLIB_1.0";
CREATE INDEX TIMEOUT_TNO_IND ON TIMEOUT_000 (TRADE_NO_PREFIX,TRADE_NO)COMPRESSION="ZLIB_1.0";
CREATE INDEX IDX_GMT_COMPENSATED_TIMEOUT ON TIMEOUT_000 (GMT_COMPENSATED) STORING(STATUS) COMPRESSION="ZLIB_1.0";
CREATE TABLE if not exists TIMEOUT_HISTORY_000(JOB_ID varchar(64) NOT NULL,TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,USER_ID varchar(128),PAYTYPE varchar(8),END_TIME DATETIME,ACTION varchar(60),PARAMETER varchar(200),STATUS varchar(2),ACTION_TYPE varchar(2) NOT NULL,GMT_CREATE DATETIME,PRIOR_LEVEL int,GMT_MODIFIED DATETIME,GMT_OCCUR DATETIME,PRIMARY KEY (JOB_ID, TRADE_NO_PREFIX, TRADE_NO, ACTION_TYPE)) COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TIMEOUT_LONG_000(JOB_ID varchar(64) NOT NULL,TRADE_NO_PREFIX varchar(1),TRADE_NO varchar(64),USER_ID varchar(128),PAYTYPE  varchar(8),END_TIME DATETIME,ACTION varchar(60),PARAMETER varchar(200),STATUS varchar(2),ACTION_TYPE varchar(2),GMT_CREATE DATETIME,PRIOR_LEVEL int default 1,GMT_MODIFIED DATETIME,GMT_OCCUR DATETIME,GMT_COMPENSATED DATETIME,PRIMARY KEY (JOB_ID)) COMPRESSION="ZLIB_1.0";
CREATE INDEX BYD_TIMEOUT_LONG_ENDTIME_IND ON TIMEOUT_LONG_000 (END_TIME)COMPRESSION="ZLIB_1.0";
CREATE INDEX TIMEOUT_LONG_PL_IND ON TIMEOUT_LONG_000 (PRIOR_LEVEL)COMPRESSION="ZLIB_1.0";
CREATE INDEX TIMEOUT_LONG_TNO_IND ON TIMEOUT_LONG_000 (TRADE_NO_PREFIX,TRADE_NO)COMPRESSION="ZLIB_1.0";
CREATE INDEX IDX_GMT_COMPENSATED_TIMEOUT_LONG ON TIMEOUT_LONG_000 (GMT_COMPENSATED) STORING(STATUS) COMPRESSION="ZLIB_1.0";


CREATE TABLE if not exists TIMEOUT_REMIND_000(JOB_ID varchar(64) NOT NULL,TRADE_NO_PREFIX varchar(1),TRADE_NO varchar(64),USER_ID varchar(128),PAYTYPE varchar(8),END_TIME DATETIME,ACTION varchar(60),PARAMETER varchar(200),STATUS varchar(2),ACTION_TYPE varchar(2),GMT_CREATE DATETIME,PRIOR_LEVEL int default 1,GMT_MODIFIED DATETIME,GMT_OCCUR DATETIME,GMT_COMPENSATED DATETIME,PRIMARY KEY (JOB_ID)) COMPRESSION="ZLIB_1.0";

CREATE INDEX BY_TIMEOUT_REMIND_ETIME_IND ON TIMEOUT_REMIND_000 (END_TIME)COMPRESSION="ZLIB_1.0";
CREATE INDEX TIMEOUT_REMIND_PL_IND ON TIMEOUT_REMIND_000 (PRIOR_LEVEL)COMPRESSION="ZLIB_1.0";
CREATE INDEX TIMEOUT_REMIND_TNO_IND ON TIMEOUT_REMIND_000 (TRADE_NO_PREFIX,TRADE_NO)COMPRESSION="ZLIB_1.0";
CREATE INDEX IDX_GMT_COMPENSATED_TIMEOUT_REMIND ON TIMEOUT_REMIND_000 (GMT_COMPENSATED) STORING(STATUS) COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_BASE_000(TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,ID int NOT NULL,OUT_TRADE_NO varchar(64),SELLER_ACCOUNT varchar(200) NOT NULL,SELLER_LOGIN_EMAIL varchar(200) NOT NULL,BUYER_ACCOUNT varchar(200) NOT NULL,BUYER_LOGIN_EMAIL varchar(200) NOT NULL,SELLER_TYPE int,BUYER_TYPE int,TRADE_FROM varchar(200),TRADE_EMAIL varchar(200),OPERATOR_ROLE varchar(2) NOT NULL,TRADE_STATUS varchar(100) NOT NULL,TOTAL_FEE int default 0 NOT NULL,SERVICE_FEE_RATIO decimal(5,3),SERVICE_FEE int default 0 NOT NULL,CURRENCY varchar(6),SELLER_ACTION varchar(400),BUYER_ACTION varchar(400),GMT_CREATE DATETIME default now(),SELLER_USER_ID varchar(16),BUYER_USER_ID varchar(16),ADDITIONAL_TRD_STATUS varchar(100),TRADE_TYPE varchar(8) NOT NULL,SELLER_FULLNAME varchar(512) default '',BUYER_FULLNAME varchar(512) default '',SELLER_NICK varchar(200) default '' NOT NULL,BUYER_NICK varchar(200) default '' NOT NULL,GOODS_TITLE varchar(512),GMT_LAST_MODIFIED_DT DATETIME,STOP_TIMEOUT varchar(8) default '0',GATHERING_TYPE varchar(8),BUYER_MARKER varchar(2),SELLER_MARKER varchar(2),BUYER_MARKER_MEMO varchar(2000),SELLER_MARKER_MEMO varchar(2000),CHANNEL varchar(64),PRODUCT varchar(40),PAY_CHANNEL varchar(64),OTHER_SERVICE_FEE int,RELATION_PRO varchar(128),PLATFORM varchar(200),CHANNEL_PARTNER varchar(200),GOODS_TYPE varchar(8),GOODS_SUB_TYPE varchar(8),PRIMARY KEY (TRADE_NO_PREFIX,TRADE_NO))COMPRESSION="ZLIB_1.0";

CREATE INDEX BYD_TRADE_BASE_TEMAIL_GMTC_IND ON TRADE_BASE_000(TRADE_EMAIL, GMT_CREATE)COMPRESSION="ZLIB_1.0";

CREATE INDEX IND_BEYOND_TRADE_BASE_BUYGMT1 ON TRADE_BASE_000(BUYER_ACCOUNT, GMT_CREATE)COMPRESSION="ZLIB_1.0";

CREATE INDEX IND_BEYOND_TRADE_BASE_SALGMT1 ON TRADE_BASE_000(SELLER_ACCOUNT, GMT_CREATE)COMPRESSION="ZLIB_1.0";

CREATE INDEX TRADE_BASE_GMT_IND ON TRADE_BASE_000 (GMT_LAST_MODIFIED_DT) COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_CHARGE_000(ID int NOT NULL,TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,GMT_CHARGE DATETIME NOT NULL,GMT_PAY DATETIME,CHARGE_OUT_DATE varchar(16),GMT_MODIFIED DATETIME,PLAN_CHARGE int,ACTUAL_CHARGE int,RATE_ID int,RATE decimal(7,6),RATE_ORIGIN varchar(2),PRODUCT_NAME varchar(64),CHARGE_TYPE varchar(32) DEFAULT '' NOT NULL,SERVICE_EVENT_ID int,PAYMENT_BILL_ID int,SALES_ID int,PARTNER_ID varchar(60),DEBIT_ACCOUNT varchar(40),CREDIT_ACCOUNT varchar(40),BILL_STATUS varchar(2),SERVICE_AMOUNT decimal(15,4),TRADE_FROM varchar(200),DEBIT_USER_ID varchar(16),SERVICT_TYPE varchar(16) DEFAULT '',SUB_TRADE_NO varchar(128) DEFAULT '' NOT NULL,primary key (TRADE_NO_PREFIX,TRADE_NO, SERVICT_TYPE,	CHARGE_TYPE, SUB_TRADE_NO))COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_EXT_000(TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,EXT_INFO varchar(4000),TRADE_AGENT varchar(60),GMT_MODIFIED DATETIME,FP_TIME_OUT_RULE varchar(2000),FOREX_RATE_ID int,FOREX_CURRENCY varchar(16),FOREX_TOTAL_FEE int,GOODS_INNER_SELL_RATE int,PREPARE_COUPON_FEE int, PREPARE_COUPON_LIST varchar(128),FOREX_CERT_NO varchar(256),GMT_CREATE DATETIME,AUTH_DEBIT_TYPE varchar(2),SUPPORT_CREDIT_CARD varchar(512),SPECIFIED_PAY_CHANNEL varchar(256),CHARGE_CHANNEL_INFO varchar(512),PAY_CHANNELS varchar(1800),REDUND_INFO varchar(2000),PRIMARY KEY (TRADE_NO_PREFIX,TRADE_NO))COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_GOODS_INFO_000(ID int NOT NULL,TRADE_NO_PREFIX varchar(1) NOT NULL, TRADE_NO varchar(64) NOT NULL,GOODS_ID varchar(64) default ' ' NOT NULL,GOODS_TITLE varchar(512),GOODS_BID decimal(18,3) default 0 NOT NULL,GOODS_QUANTITY int default 1 NOT NULL,DETAIL_URL varchar(800),GOODS_MEMO varchar(2000),REFER_URL varchar(800),PARTNER varchar(200),GMT_CREATE DATETIME NOT NULL,OTHER_FEE int,CATEGORY varchar(48),PROMOTION_DESC varchar(512),PIC_URL varchar(800),GOODS_TYPE varchar(8),GOODS_SUB_TYPE  varchar(8),primary key (TRADE_NO_PREFIX,TRADE_NO, ID))COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_LOGISTICS_000(ID int NOT NULL,TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,LOGISTICS_ID varchar(40),LOGISTICS_NAME varchar(256),INVOICE_NO varchar(128),SIGN_VOUCHER_NO varchar(128),TRANSPORT_TYPE int,TRANSPORT_FEE int default 0 NOT NULL,OTHER_FEE int default 0,ADDITIONAL_SERVICE varchar(600),LOGISTICS_STATUS varchar(200),SEND_FULLNAME varchar(512),SEND_PHONE varchar(60),SEND_MOBILE_PHONE varchar(60),SEND_ADDRESS varchar(512),SEND_POST varchar(40), RECEIVE_FULLNAME varchar(512),RECEIVE_PHONE varchar(60),RECEIVE_MOBILE_PHONE varchar(60),RECEIVE_ADDRESS varchar(512),RECEIVE_POST varchar(40),LOGISTICS_MEMO varchar(1200),TRADE_OR_REFUND_FLAG  int default 1 NOT NULL,GMT_CREATE DATETIME default now() NOT NULL,GMT_APPLY DATETIME,GMT_FETCH DATETIME,GMT_TRANSPORT DATETIME,GMT_SIGN DATETIME,GMT_MODIFIED DATETIME,SEND_IM_TYPE varchar(20),SEND_IM_ID varchar(200),RECEIVE_IM_TYPE varchar(20),RECEIVE_IM_ID varchar(200),TRANSPORT_PAYMENT int,TRANSPORT_MODIFIABLE int,RECEIVE_ADDRESS_CODE varchar(16),SEND_ADDRESS_CODE varchar(16),TRANSPORT_TYPE_SEND int,LOGISTICS_NO varchar(200),TRANS_GOODS_INFO varchar(800),REC_ADDRESS_NO varchar(200),FLAG_MAIN int,primary key (TRADE_NO_PREFIX,TRADE_NO, TRADE_OR_REFUND_FLAG, ID))COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_MESSAGE_BOARD_000(ID int NOT NULL,TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,MESSAGE varchar(4000) NOT NULL,POSTER varchar(200) default ' ' NOT NULL,POSTER_ROLE int,OPERATOR_IP varchar(30),MSG_TYPE int default 0,IS_READ int default 0 NOT NULL,GMT_CREATE DATETIME,PRIMARY KEY (TRADE_NO_PREFIX,TRADE_NO, ID)) COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_NOTE_000(ID int NOT NULL,TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,TRADE_STATUS varchar(128) default ' ',BUYER_EMAIL varchar(200) default ' ' NOT NULL,SELLER_EMAIL varchar(200) default ' ' NOT NULL,OPERATOR_EMAIL varchar(200) default ' ' NOT NULL,OPERATOR_IP varchar(30),GMT_CREATE DATETIME default now() NOT NULL,OPERATOR_MEMO varchar(512),NOTE_TYPE varchar(200),REMOTE_MAC varchar(128),primary key (TRADE_NO_PREFIX,TRADE_NO, ID, GMT_CREATE))COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_OUTTRADE_000(PARTNER_ID varchar(400) NOT NULL,OUT_TRADE_NO varchar(64) NOT NULL,TRADE_FROM varchar(200) NOT NULL,TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,GMT_CREATE DATETIME NOT NULL,primary key (OUT_TRADE_NO, PARTNER_ID, TRADE_FROM)) COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_PAYMENT_CLAUSE_000(ID int NOT NULL,OUT_RELATION_ID varchar(128) DEFAULT '' NOT NULL,SERIAL_NO int,TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,GMT_CREATE DATETIME,GMT_MODIFIED DATETIME,PAYMENT_TYPE varchar(128) NOT NULL,STATUS varchar(100),PAY_ACCOUNT_NO varchar(40),PAY_USER_ID varchar(16),RECEIVE_ACCOUNT_NO varchar(40),RECEIVE_USER_ID varchar(16),AMOUNT int,CURRENCY varchar(128),PAYMENT_RESTRICT_RULE varchar(8000),DESCRIPTION varchar(2000),MEMO varchar(2000),CONTEXT varchar(2000),primary key (TRADE_NO_PREFIX,TRADE_NO, OUT_RELATION_ID))COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_PAYMENT_ORDER_000(ORDER_NO varchar(128) NOT NULL,TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,BIZ_TYPE varchar(40) NOT NULL,OUT_ORDER_NO varchar(128),GMT_MODIFIED DATETIME NOT NULL,STATUS varchar(4) NOT NULL,PAY_ACCOUNT_NO varchar(40), RECEIVE_ACCOUNT_NO  varchar(40),AMOUNT int NOT NULL,RETURN_AMOUNT int,CURRENCY varchar(6),FREEZE_TYPE varchar(10),EXT_INFO varchar(4000),MEMO varchar(2000),PAYMENT_ID  varchar(400),PAYMENT_CONTEXT  varchar(2000),GMT_PAY DATETIME, GMT_CREATE DATETIME NOT NULL,FREEZE_AMOUNT int,SUB_TRANS_CODE varchar(80),primary key (TRADE_NO_PREFIX,TRADE_NO, ORDER_NO))COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_PROCESS_000(ID int NOT NULL,TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(128) default ' ' NOT NULL,OUT_TRADE_NO varchar(64),RECEIVE_FEE int default 0 NOT NULL,SEND_FEE int default 0 NOT NULL,ADJUST_FEE int default 0 NOT NULL,MEMO varchar(1200), OPERATE_TIME DATETIME,OPERATE_NAME varchar(512),FLAG_REFUND varchar(8) default '0' NOT NULL,FLAG_DEFERPAY varchar(8) default '0' NOT NULL,FLAG_PAYMENT varchar(16) default '0' NOT NULL,FLAG_TRADE_LOCKED varchar(8) default '0' NOT NULL,FLAG_SELLER_MDF varchar(8) default '0' NOT NULL,GMT_CREATE DATETIME default now() NOT NULL ,GMT_MODIFIED DATETIME,GMT_RECEIVE_PAY DATETIME,GMT_SEND_PAY DATETIME,GMT_SEND_GOODS DATETIME,TIME_OUT_RULE varchar(2000),GMT_OUT_TRADE_NO_CREATED DATETIME,COUPON_CLEAR_FEE int,COUPON_ADJUST_FEE int, REFUND_FEE int,GMT_REFUND_PAY DATETIME,GMT_FINISH DATETIME,ACCOUNT_TX_ID varchar(80),ADJUST_TIMEOUT int,GMT_PRE_AUTH DATETIME,PRE_AUTH_FEE int,ACTUAL_ADJUST_FEE int,EXPIRE_TIME DATETIME, SEND_BACK_FEE int,PRE_AUTH_CANCEL_FEE int,GMT_PRE_AUTH_CANCEL DATETIME,PRIMARY KEY (TRADE_NO_PREFIX,TRADE_NO))COMPRESSION="ZLIB_1.0";

CREATE UNIQUE INDEX IND_BYD_TRD_PROCESS_GRPAY ON TRADE_PROCESS_000(GMT_RECEIVE_PAY, RECEIVE_FEE)COMPRESSION="ZLIB_1.0";
CREATE TABLE if not exists TRADE_REFUND_000(ID int NOT NULL,TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,OUT_TRADE_NO varchar(64),RETURN_STATUS varchar(200),MEMO varchar(4000),RETURN_FEE int, GMT_ADMIN_MODIFIED  DATETIME,ADMIN_STATUS varchar(200), RETURN_TYPE varchar(40) NOT NULL,RETURN_GOODS int, GOODS_STATUS int,CLOSE_CAUSE varchar(1200),REQUIRE_VOUCHER int,GMT_CREATE DATETIME NOT NULL,GMT_MODIFIED DATETIME,SELLER_NOT_RECEIVE  int,REFUND_REASON varchar(800),APPEAL_NO varchar(100),GMT_DW_SYNC DATETIME default now(),BUY_USER_ID varchar(16) NOT NULL,BUY_ACCOUNT varchar(40) NOT NULL,SELL_USER_ID varchar(16) NOT NULL,SELL_ACCOUNT        varchar(40)    NOT NULL,TRADE_FROM          varchar(200), TRADE_EMAIL         varchar(200),IS_INPOUR_REFUND   	varchar(2), REFUND_FLOW_TYPE   	varchar(2),GMT_LAST_APPLY      DATETIME,REFUND_FOREX_FEE    int,PRIMARY KEY (TRADE_NO_PREFIX,TRADE_NO, ID))COMPRESSION="ZLIB_1.0";
CREATE INDEX TRADE_REFUND_BG_IND ON TRADE_REFUND_000(BUY_ACCOUNT, GMT_CREATE)COMPRESSION="ZLIB_1.0";

CREATE INDEX TRADE_REFUND_SG_IND ON TRADE_REFUND_000(SELL_ACCOUNT, GMT_CREATE)COMPRESSION="ZLIB_1.0";

CREATE INDEX TRADE_REFUND_TG_IND ON TRADE_REFUND_000(TRADE_EMAIL, GMT_CREATE)COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_RECEIVE_ADDRESS_000(TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,ADDRESS_NO        varchar(200)  NOT NULL,RECEIVE_NAME      varchar(512),ADDRESS_CODE      varchar(16),ADDRESS           varchar(512),MOBILE_PHONE      varchar(60),PHONE             varchar(60),RECEIVE_POST      varchar(40),VIRTUAL_REC_INFO  varchar(800),GMT_CREATE        DATETIME                NOT NULL,GMT_MODIFIED      DATETIME,PRIMARY KEY (TRADE_NO_PREFIX,TRADE_NO, ADDRESS_NO))COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_COOPERATE_000(TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,COOPERATE_NO     varchar(128) default ' ' NOT NULL,COOPERATOR_FROM  varchar(64) default ' ' NOT NULL,GMT_CREATE       DATETIME,GMT_MODIFIED     DATETIME,PRIMARY key (TRADE_NO_PREFIX,TRADE_NO, COOPERATE_NO, COOPERATOR_FROM))COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists TRADE_PARTICIPANT_000(TRADE_NO_PREFIX varchar(1) NOT NULL,TRADE_NO varchar(64) NOT NULL,USER_ID           varchar(16)   NOT NULL,USER_NAME         varchar(512),USER_NICK         varchar(200),PARTICIPANT_ROLE  varchar(128)   NOT NULL,MEMO              varchar(400),GMT_CREATE        DATETIME               NOT NULL,GMT_MODIFIED      DATETIME,PRIMARY KEY (TRADE_NO_PREFIX,TRADE_NO, USER_ID, PARTICIPANT_ROLE))COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists BUSINESS_ACTIVITY_ASYNC_000(TX_ID                varchar(256)   NOT NULL,STATE                varchar(2)         NOT NULL,ACCOUNT_TRANS_STATE  varchar(2)         NOT NULL,GMT_CREATE           DATETIME         NOT NULL,GMT_MODIFIED         DATETIME         NOT NULL,PROPAGATION          varchar(2),CONTEXT              varchar(4096),PRIMARY KEY (TX_ID))COMPRESSION="ZLIB_1.0";
CREATE INDEX IDX_GMT_MODIFY_ACTIVITY_ASYNC ON BUSINESS_ACTIVITY_ASYNC_000 (GMT_MODIFIED) STORING(STATE) ;

CREATE TABLE if not exists EXTERFACE_INVOKE_000(  ID           int         NOT NULL, PARTNER_ID   varchar(64)   NOT NULL,  TARGET       varchar(128)   NOT NULL,  EXTERFACE    varchar(256)  NOT NULL,  NOTIFY_URL   varchar(400),  RETURN_URL   varchar(400),  SIGN_TYPE    varchar(20),  CHARSET      varchar(40),  GMT_INVOKE   DATETIME        NOT NULL,  GMT_FINISH   DATETIME       NOT NULL,  TARGET_TYPE  varchar(40)   NOT NULL,  GMT_NOTIFY   DATETIME,  GMT_RETURN   DATETIME,  PRIMARY KEY(TARGET_TYPE, TARGET, PARTNER_ID))COMPRESSION="ZLIB_1.0";

CREATE INDEX EXTERFACE_INVOKE_ID_IND ON EXTERFACE_INVOKE_000(ID);

CREATE TABLE if not exists NOTIFY_BYTES_MSG_NORMAL_000(  MESSAGE_ID               varchar(64)    NOT NULL,  COMMITTED                varchar(2)     NOT NULL,  GMT_CREATE               DATETIME      NOT NULL,  GMT_LAST_DELIVERY        DATETIME      NOT NULL,  DELIVERY_COUNT           int            NOT NULL,  FLAG                     int            NOT NULL,  TIME_TO_LIVE             int            NOT NULL,  DLQ_TIME                 int            NOT NULL,  POST_TIME_OUT            int            NOT NULL,  BORN_TIME                int            NOT NULL,GROUP_ID                 varchar(256)   NOT NULL,  TOPIC                    varchar(64)    NOT NULL,  MESSAGE_TYPE             varchar(128)    NOT NULL,  HOST_NAME                varchar(128)    NOT NULL,  SERVER_TAG               varchar(64)    NOT NULL,  NEXT_DELIVER_TIME        int,  FAILED_TARGET            varchar(8000),  USER_DEFINED_PROPERTIES  varchar(8000),  CONTEXT_DATA             varchar(8000),  BYTES_BODY               varchar(16384)  NOT NULL,  PRIMARY KEY (MESSAGE_ID))COMPRESSION="ZLIB_1.0";

CREATE INDEX IDX_SERV_MESS_TYPE_DEL ON NOTIFY_BYTES_MSG_NORMAL_000(SERVER_TAG, NEXT_DELIVER_TIME, TOPIC, MESSAGE_TYPE) COMPRESSION="ZLIB_1.0";

CREATE TABLE if not exists NOTIFY_STRING_MSG_NORMAL_000(  MESSAGE_ID               varchar(64)    NOT NULL,  COMMITTED                varchar(2)     NOT NULL,  GMT_CREATE               DATETIME		NOT NULL,  GMT_LAST_DELIVERY        DATETIME		NOT NULL,  DELIVERY_COUNT           int                 NOT NULL,  FLAG                     int                 NOT NULL,  TIME_TO_LIVE             int                 NOT NULL,  DLQ_TIME                 int                 NOT NULL, POST_TIME_OUT            int                 NOT NULL,  BORN_TIME                int                 NOT NULL,  GROUP_ID                 varchar(256)        NOT NULL,  TOPIC                    varchar(64)         NOT NULL,  MESSAGE_TYPE             varchar(128)         NOT NULL, HOST_NAME                varchar(128)         NOT NULL,  SERVER_TAG               varchar(64)         NOT NULL,  NEXT_DELIVER_TIME        int,  FAILED_TARGET            varchar(8000),  USER_DEFINED_PROPERTIES  varchar(8000),  CONTEXT_DATA             varchar(8000),  STRING_BODY              varchar(16384)  NOT NULL,  PRIMARY KEY (MESSAGE_ID))COMPRESSION="ZLIB_1.0";
CREATE INDEX IDX_SERTOP_TYPE_DELI ON NOTIFY_STRING_MSG_NORMAL_000(SERVER_TAG, NEXT_DELIVER_TIME, TOPIC, MESSAGE_TYPE) COMPRESSION="ZLIB_1.0";


CREATE TABLE if not exists TRADE_UNIFORM_EVENT_000 (ID VARCHAR(64) not null,TRADE_NO VARCHAR(64) not null,TOPIC VARCHAR(128) not null,EVENT_CODE VARCHAR(128) NOT NULL,EVENT_CONTENT VARCHAR(65535) NOT NULL,GMT_CREATE DATETIME DEFAULT now() NOT NULL,PRIMARY KEY(ID)) COMPRESSION="ZLIB_1.0";

create table trade_trace_000( trade_no     int,trace        int,gmt_create DATETIME default now(),gmt_modify DATETIME default now(),primary key(trade_no));

