/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#include "ob_expr_to_pinyin_tab.h"

namespace oceanbase
{
namespace sql
{
PinyinPair PINYIN_TABLE[PINYIN_COUNT] = {
  {7239, 7243, "ā"},
  {7244, 7244, "á"},
  {7245, 7245, "a"},
  {7246, 7264, "āi"},
  {7265, 7285, "ái"},
  {7286, 7304, "ǎi"},
  {7305, 7374, "ài"},
  {7375, 7417, "ān"},
  {7418, 7425, "án"},
  {7426, 7443, "ǎn"},
  {7444, 7482, "àn"},
  {7483, 7486, "āng"},
  {7487, 7498, "áng"},
  {7499, 7501, "ǎng"},
  {7502, 7512, "àng"},
  {7513, 7525, "āo"},
  {7526, 7570, "áo"},
  {7571, 7589, "ǎo"},
  {7590, 7628, "ào"},
  {7629, 7674, "bā"},
  {7675, 7704, "bá"},
  {7705, 7711, "bǎ"},
  {7712, 7745, "bà"},
  {7746, 7749, "ba"},
  {7750, 7756, "bāi"},
  {7757, 7762, "bái"},
  {7763, 7776, "bǎi"},
  {7777, 7804, "bài"},
  {7805, 7805, "bai"},
  {7806, 7840, "bān"},
  {7841, 7860, "bǎn"},
  {7861, 7889, "bàn"},
  {7890, 7890, "ban"},
  {7891, 7916, "bāng"},
  {7917, 7925, "bǎng"},
  {7926, 7957, "bàng"},
  {7958, 7977, "bāo"},
  {7978, 7992, "báo"},
  {7993, 8032, "bǎo"},
  {8033, 8077, "bào"},
  {8078, 8104, "bēi"},
  {8105, 8110, "běi"},
  {8111, 8194, "bèi"},
  {8195, 8196, "bei"},
  {8197, 8207, "bēn"},
  {8208, 8216, "běn"},
  {8217, 8237, "bèn"},
  {8238, 8270, "bēng"},
  {8271, 8271, "béng"},
  {8272, 8291, "běng"},
  {8292, 8314, "bèng"},
  {8315, 8315, "beng"},
  {8316, 8341, "bī"},
  {8342, 8348, "bí"},
  {8349, 8392, "bǐ"},
  {8393, 8520, "bì"},
  {8521, 8635, "bì"},
  {8636, 8669, "biān"},
  {8670, 8698, "biǎn"},
  {8699, 8761, "biàn"},
  {8762, 8762, "bian"},
  {8763, 8831, "biāo"},
  {8832, 8845, "biǎo"},
  {8846, 8855, "biào"},
  {8856, 8883, "biē"},
  {8884, 8910, "bié"},
  {8911, 8913, "biě"},
  {8914, 8917, "biè"},
  {8918, 8966, "bīn"},
  {8967, 8967, "bǐn"},
  {8968, 8981, "bìn"},
  {8982, 8982, "bin"},
  {8983, 8997, "bīng"},
  {8998, 9036, "bǐng"},
  {9037, 9066, "bìng"},
  {9067, 9116, "bō"},
  {9117, 9244, "bó"},
  {9245, 9274, "bó"},
  {9275, 9282, "bǒ"},
  {9283, 9292, "bò"},
  {9293, 9295, "bo"},
  {9296, 9307, "bū"},
  {9308, 9311, "bú"},
  {9312, 9335, "bǔ"},
  {9336, 9398, "bù"},
  {9399, 9407, "cā"},
  {9408, 9409, "cǎ"},
  {9410, 9414, "cà"},
  {9415, 9420, "cāi"},
  {9421, 9432, "cái"},
  {9433, 9452, "cǎi"},
  {9453, 9464, "cài"},
  {9465, 9487, "cān"},
  {9488, 9521, "cán"},
  {9522, 9537, "cǎn"},
  {9538, 9560, "càn"},
  {9561, 9583, "cāng"},
  {9584, 9592, "cáng"},
  {9593, 9595, "càng"},
  {9596, 9601, "cāo"},
  {9602, 9629, "cáo"},
  {9630, 9636, "cǎo"},
  {9637, 9640, "cào"},
  {9641, 9643, "cao"},
  {9645, 9691, "cè"},
  {9692, 9692, "cèi"},
  {9693, 9693, "cēn"},
  {9694, 9710, "cén"},
  {9711, 9713, "cēng"},
  {9714, 9728, "céng"},
  {9729, 9731, "cèng"},
  {9732, 9772, "chā"},
  {9773, 9814, "chá"},
  {9815, 9822, "chǎ"},
  {9823, 9849, "chà"},
  {9850, 9858, "chāi"},
  {9859, 9874, "chái"},
  {9875, 9876, "chǎi"},
  {9877, 9892, "chài"},
  {9893, 9920, "chān"},
  {9921, 10002, "chán"},
  {10003, 10079, "chǎn"},
  {10080, 10106, "chàn"},
  {10107, 10132, "chāng"},
  {10133, 10172, "cháng"},
  {10174, 10190, "chǎng"},
  {10191, 10212, "chàng"},
  {10213, 10213, "chang"},
  {10214, 10233, "chāo"},
  {10234, 10258, "cháo"},
  {10259, 10276, "chǎo"},
  {10277, 10289, "chào"},
  {10290, 10302, "chē"},
  {10303, 10303, "ché"},
  {10304, 10313, "chě"},
  {10314, 10361, "chè"},
  {10362, 10390, "chēn"},
  {10391, 10446, "chén"},
  {10447, 10461, "chěn"},
  {10462, 10483, "chèn"},
  {10484, 10533, "chēng"},
  {10534, 10624, "chéng"},
  {10625, 10636, "chěng"},
  {10637, 10645, "chèng"},
  {10646, 10699, "chī"},
  {10700, 10761, "chí"},
  {10762, 10811, "chǐ"},
  {10812, 10915, "chì"},
  {10916, 10916, "chi"},
  {10917, 10964, "chōng"},
  {10965, 10987, "chóng"},
  {10988, 10996, "chǒng"},
  {10997, 11009, "chòng"},
  {11010, 11030, "chōu"},
  {11031, 11101, "chóu"},
  {11102, 11121, "chǒu"},
  {11122, 11128, "chòu"},
  {11129, 11145, "chū"},
  {11146, 11194, "chú"},
  {11195, 11219, "chǔ"},
  {11220, 11293, "chù"},
  {11294, 11295, "chu"},
  {11296, 11301, "chuā"},
  {11302, 11305, "chuǎ"},
  {11306, 11306, "chuà"},
  {11307, 11309, "chuāi"},
  {11310, 11311, "chuái"},
  {11312, 11313, "chuǎi"},
  {11314, 11323, "chuài"},
  {11324, 11335, "chuān"},
  {11336, 11354, "chuán"},
  {11355, 11364, "chuǎn"},
  {11365, 11380, "chuàn"},
  {11381, 11397, "chuāng"},
  {11398, 11413, "chuáng"},
  {11414, 11422, "chuǎng"},
  {11423, 11433, "chuàng"},
  {11434, 11437, "chuī"},
  {11438, 11463, "chuí"},
  {11464, 11465, "chuǐ"},
  {11466, 11468, "chuì"},
  {11469, 11494, "chūn"},
  {11495, 11530, "chún"},
  {11531, 11546, "chǔn"},
  {11547, 11552, "chuō"},
  {11553, 11592, "chuò"},
  {11593, 11612, "cī"},
  {11613, 11667, "cí"},
  {11668, 11680, "cǐ"},
  {11681, 11719, "cì"},
  {11720, 11787, "cōng"},
  {11788, 11833, "cóng"},
  {11834, 11834, "cǒng"},
  {11835, 11838, "còng"},
  {11839, 11839, "cōu"},
  {11840, 11840, "cóu"},
  {11841, 11856, "còu"},
  {11857, 11867, "cū"},
  {11868, 11872, "cú"},
  {11873, 11873, "cǔ"},
  {11874, 11923, "cù"},
  {11924, 11932, "cuān"},
  {11933, 11939, "cuán"},
  {11940, 11953, "cuàn"},
  {11954, 11978, "cuī"},
  {11979, 11992, "cuǐ"},
  {11993, 12051, "cuì"},
  {12052, 12052, "cui"},
  {12053, 12062, "cūn"},
  {12063, 12068, "cún"},
  {12069, 12070, "cǔn"},
  {12071, 12074, "cùn"},
  {12075, 12088, "cuō"},
  {12089, 12114, "cuó"},
  {12115, 12116, "cuǒ"},
  {12117, 12140, "cuò"},
  {12141, 12167, "dā"},
  {12168, 12225, "dá"},
  {12226, 12227, "dǎ"},
  {12228, 12238, "dà"},
  {12239, 12243, "da"},
  {12244, 12250, "dāi"},
  {12251, 12257, "dǎi"},
  {12258, 12331, "dài"},
  {12332, 12332, "dai"},
  {12333, 12384, "dān"},
  {12385, 12418, "dǎn"},
  {12419, 12494, "dàn"},
  {12495, 12521, "dāng"},
  {12522, 12540, "dǎng"},
  {12541, 12586, "dàng"},
  {12587, 12601, "dāo"},
  {12602, 12602, "dáo"},
  {12603, 12629, "dǎo"},
  {12630, 12673, "dào"},
  {12674, 12674, "dē"},
  {12675, 12698, "dé"},
  {12699, 12702, "de"},
  {12703, 12705, "dèn"},
  {12706, 12729, "dēng"},
  {12730, 12735, "děng"},
  {12736, 12761, "dèng"},
  {12762, 12797, "dī"},
  {12798, 12858, "dí"},
  {12859, 12890, "dǐ"},
  {12891, 12976, "dì"},
  {12977, 13014, "diān"},
  {13015, 13037, "diǎn"},
  {13038, 13093, "diàn"},
  {13094, 13134, "diāo"},
  {13135, 13144, "diǎo"},
  {13145, 13185, "diào"},
  {13186, 13191, "diē"},
  {13192, 13297, "dié"},
  {13298, 13298, "diě"},
  {13299, 13302, "diè"},
  {13303, 13303, "dìn"},
  {13304, 13323, "dīng"},
  {13324, 13341, "dǐng"},
  {13342, 13372, "dìng"},
  {13373, 13378, "diū"},
  {13379, 13422, "dōng"},
  {13423, 13439, "dǒng"},
  {13440, 13478, "dòng"},
  {13479, 13505, "dōu"},
  {13506, 13523, "dǒu"},
  {13524, 13572, "dòu"},
  {13573, 13593, "dū"},
  {13594, 13662, "dú"},
  {13663, 13677, "dǔ"},
  {13678, 13725, "dù"},
  {13726, 13738, "duān"},
  {13739, 13743, "duǎn"},
  {13744, 13770, "duàn"},
  {13771, 13795, "duī"},
  {13796, 13800, "duǐ"},
  {13801, 13856, "duì"},
  {13857, 13881, "dūn"},
  {13882, 13886, "dǔn"},
  {13887, 13920, "dùn"},
  {13921, 13939, "duō"},
  {13940, 13964, "duó"},
  {13965, 14009, "duǒ"},
  {14010, 14057, "duò"},
  {14058, 14058, "duo"},
  {14059, 14068, "ē"},
  {14069, 14118, "é"},
  {14119, 14129, "ě"},
  {14130, 14257, "è"},
  {14258, 14291, "è"},
  {14292, 14293, "éi"},
  {14294, 14300, "ēn"},
  {14301, 14304, "ěn"},
  {14305, 14308, "èn"},
  {14309, 14309, "ēng"},
  {14310, 14348, "ér"},
  {14349, 14376, "ěr"},
  {14377, 14399, "èr"},
  {14400, 14406, "fā"},
  {14407, 14436, "fá"},
  {14437, 14443, "fǎ"},
  {14444, 14450, "fà"},
  {14451, 14451, "fa"},
  {14452, 14475, "fān"},
  {14476, 14544, "fán"},
  {14545, 14554, "fǎn"},
  {14555, 14607, "fàn"},
  {14608, 14626, "fāng"},
  {14627, 14637, "fáng"},
  {14638, 14659, "fǎng"},
  {14660, 14662, "fàng"},
  {14663, 14663, "fang"},
  {14664, 14699, "fēi"},
  {14700, 14710, "féi"},
  {14711, 14737, "fěi"},
  {14738, 14805, "fèi"},
  {14806, 14842, "fēn"},
  {14843, 14894, "fén"},
  {14895, 14901, "fěn"},
  {14902, 14935, "fèn"},
  {14936, 15008, "fēng"},
  {15009, 15030, "féng"},
  {15031, 15038, "fěng"},
  {15039, 15059, "fèng"},
  {15060, 15060, "fiào"},
  {15061, 15065, "fó"},
  {15066, 15066, "fōu"},
  {15067, 15069, "fóu"},
  {15070, 15082, "fǒu"},
  {15083, 15154, "fū"},
  {15155, 15282, "fú"},
  {15283, 15339, "fú"},
  {15340, 15395, "fǔ"},
  {15396, 15525, "fù"},
  {15526, 15532, "fù"},
  {15533, 15533, "fu"},
  {15534, 15538, "gā"},
  {15539, 15543, "gá"},
  {15544, 15546, "gǎ"},
  {15547, 15550, "gà"},
  {15551, 15573, "gāi"},
  {15574, 15584, "gǎi"},
  {15585, 15614, "gài"},
  {15615, 15665, "gān"},
  {15666, 15701, "gǎn"},
  {15702, 15734, "gàn"},
  {15735, 15772, "gāng"},
  {15773, 15780, "gǎng"},
  {15781, 15788, "gàng"},
  {15789, 15824, "gāo"},
  {15825, 15853, "gǎo"},
  {15854, 15874, "gào"},
  {15875, 15924, "gē"},
  {15925, 16014, "gé"},
  {16015, 16019, "gě"},
  {16020, 16028, "gè"},
  {16029, 16030, "gěi"},
  {16031, 16033, "gēn"},
  {16034, 16034, "gén"},
  {16035, 16038, "gěn"},
  {16039, 16048, "gèn"},
  {16049, 16075, "gēng"},
  {16076, 16103, "gěng"},
  {16104, 16119, "gèng"},
  {16120, 16185, "gōng"},
  {16186, 16215, "gǒng"},
  {16216, 16233, "gòng"},
  {16234, 16234, "gong"},
  {16235, 16264, "gōu"},
  {16265, 16283, "gǒu"},
  {16284, 16325, "gòu"},
  {16326, 16375, "gū"},
  {16376, 16380, "gú"},
  {16381, 16470, "gǔ"},
  {16471, 16496, "gù"},
  {16497, 16532, "guā"},
  {16533, 16533, "guá"},
  {16534, 16547, "guǎ"},
  {16548, 16561, "guà"},
  {16562, 16572, "guāi"},
  {16573, 16578, "guǎi"},
  {16579, 16593, "guài"},
  {16594, 16630, "guān"},
  {16631, 16650, "guǎn"},
  {16651, 16698, "guàn"},
  {16699, 16724, "guāng"},
  {16725, 16735, "guǎng"},
  {16736, 16746, "guàng"},
  {16747, 16747, "guang"},
  {16748, 16814, "guī"},
  {16815, 16869, "guǐ"},
  {16870, 16941, "guì"},
  {16942, 16973, "gǔn"},
  {16974, 16984, "gùn"},
  {16985, 17020, "guō"},
  {17021, 17065, "guó"},
  {17066, 17093, "guǒ"},
  {17094, 17102, "guò"},
  {17103, 17105, "hā"},
  {17106, 17107, "há"},
  {17108, 17108, "hǎ"},
  {17109, 17118, "hāi"},
  {17119, 17133, "hái"},
  {17134, 17144, "hǎi"},
  {17145, 17177, "hài"},
  {17178, 17178, "hai"},
  {17179, 17206, "hān"},
  {17207, 17272, "hán"},
  {17273, 17294, "hǎn"},
  {17295, 17392, "hàn"},
  {17393, 17394, "han"},
  {17395, 17404, "hāng"},
  {17405, 17432, "háng"},
  {17433, 17439, "hàng"},
  {17440, 17452, "hāo"},
  {17453, 17491, "háo"},
  {17492, 17495, "hǎo"},
  {17496, 17554, "hào"},
  {17555, 17576, "hē"},
  {17577, 17704, "hé"},
  {17705, 17705, "hé"},
  {17706, 17757, "hè"},
  {17758, 17767, "hēi"},
  {17768, 17772, "hén"},
  {17773, 17777, "hěn"},
  {17778, 17778, "hèn"},
  {17779, 17786, "hēng"},
  {17787, 17814, "héng"},
  {17815, 17815, "hèng"},
  {17816, 17816, "hm"},
  {17817, 17862, "hōng"},
  {17863, 17952, "hóng"},
  {17953, 17964, "hǒng"},
  {17965, 17988, "hòng"},
  {17989, 17993, "hōu"},
  {17994, 18039, "hóu"},
  {18040, 18048, "hǒu"},
  {18049, 18075, "hòu"},
  {18076, 18145, "hū"},
  {18146, 18268, "hú"},
  {18269, 18288, "hǔ"},
  {18289, 18389, "hù"},
  {18390, 18390, "hu"},
  {18391, 18412, "huā"},
  {18413, 18452, "huá"},
  {18453, 18503, "huà"},
  {18504, 18521, "huái"},
  {18522, 18534, "huài"},
  {18535, 18560, "huān"},
  {18561, 18624, "huán"},
  {18625, 18634, "huǎn"},
  {18635, 18699, "huàn"},
  {18700, 18726, "huāng"},
  {18727, 18803, "huáng"},
  {18804, 18825, "huǎng"},
  {18826, 18838, "huàng"},
  {18839, 18909, "huī"},
  {18910, 18937, "huí"},
  {18938, 18966, "huǐ"},
  {18967, 19094, "huì"},
  {19095, 19116, "huì"},
  {19117, 19118, "hui"},
  {19119, 19140, "hūn"},
  {19141, 19166, "hún"},
  {19167, 19169, "hǔn"},
  {19170, 19197, "hùn"},
  {19198, 19210, "huō"},
  {19211, 19222, "huó"},
  {19223, 19231, "huǒ"},
  {19232, 19333, "huò"},
  {19334, 19461, "jī"},
  {19462, 19506, "jī"},
  {19507, 19634, "jí"},
  {19635, 19678, "jí"},
  {19679, 19722, "jǐ"},
  {19723, 19851, "jì"},
  {19852, 19933, "jì"},
  {19934, 19998, "jiā"},
  {19999, 20048, "jiá"},
  {20049, 20076, "jiǎ"},
  {20077, 20092, "jià"},
  {20093, 20220, "jiān"},
  {20221, 20224, "jiān"},
  {20225, 20344, "jiǎn"},
  {20345, 20463, "jiàn"},
  {20464, 20464, "jian"},
  {20465, 20509, "jiāng"},
  {20510, 20535, "jiǎng"},
  {20536, 20573, "jiàng"},
  {20574, 20574, "jiang"},
  {20575, 20650, "jiāo"},
  {20651, 20749, "jiǎo"},
  {20750, 20807, "jiào"},
  {20808, 20809, "jiao"},
  {20810, 20854, "jiē"},
  {20855, 20982, "jié"},
  {20983, 21024, "jié"},
  {21025, 21032, "jiě"},
  {21033, 21089, "jiè"},
  {21090, 21143, "jīn"},
  {21144, 21182, "jǐn"},
  {21183, 21271, "jìn"},
  {21272, 21334, "jīng"},
  {21335, 21370, "jǐng"},
  {21371, 21434, "jìng"},
  {21435, 21435, "jing"},
  {21436, 21452, "jiōng"},
  {21453, 21488, "jiǒng"},
  {21489, 21537, "jiū"},
  {21538, 21538, "jiú"},
  {21539, 21562, "jiǔ"},
  {21563, 21624, "jiù"},
  {21625, 21625, "jiu"},
  {21626, 21704, "jū"},
  {21705, 21795, "jú"},
  {21796, 21832, "jǔ"},
  {21833, 21952, "jù"},
  {21953, 21953, "ju"},
  {21954, 21980, "juān"},
  {21981, 21999, "juǎn"},
  {22000, 22058, "juàn"},
  {22059, 22067, "juē"},
  {22068, 22195, "jué"},
  {22196, 22266, "jué"},
  {22267, 22267, "juě"},
  {22268, 22269, "juè"},
  {22270, 22302, "jūn"},
  {22303, 22303, "jǔn"},
  {22304, 22364, "jùn"},
  {22365, 22370, "kā"},
  {22371, 22376, "kǎ"},
  {22377, 22392, "kāi"},
  {22393, 22420, "kǎi"},
  {22421, 22438, "kài"},
  {22439, 22452, "kān"},
  {22453, 22485, "kǎn"},
  {22486, 22503, "kàn"},
  {22504, 22537, "kāng"},
  {22538, 22540, "káng"},
  {22541, 22544, "kǎng"},
  {22545, 22558, "kàng"},
  {22559, 22562, "kāo"},
  {22563, 22576, "kǎo"},
  {22577, 22589, "kào"},
  {22590, 22651, "kē"},
  {22652, 22655, "ké"},
  {22656, 22672, "kě"},
  {22673, 22732, "kè"},
  {22733, 22733, "kēn"},
  {22734, 22751, "kěn"},
  {22752, 22755, "kèn"},
  {22756, 22790, "kēng"},
  {22791, 22791, "kěng"},
  {22792, 22814, "kōng"},
  {22815, 22823, "kǒng"},
  {22824, 22828, "kòng"},
  {22829, 22840, "kōu"},
  {22841, 22846, "kǒu"},
  {22847, 22879, "kòu"},
  {22880, 22924, "kū"},
  {22925, 22925, "kú"},
  {22926, 22931, "kǔ"},
  {22932, 22959, "kù"},
  {22960, 22973, "kuā"},
  {22974, 22980, "kuǎ"},
  {22981, 22990, "kuà"},
  {22991, 22999, "kuǎi"},
  {23000, 23036, "kuài"},
  {23037, 23045, "kuān"},
  {23046, 23059, "kuǎn"},
  {23060, 23087, "kuāng"},
  {23088, 23101, "kuáng"},
  {23102, 23104, "kuǎng"},
  {23105, 23149, "kuàng"},
  {23150, 23171, "kuī"},
  {23172, 23226, "kuí"},
  {23227, 23240, "kuǐ"},
  {23241, 23288, "kuì"},
  {23289, 23336, "kūn"},
  {23337, 23356, "kǔn"},
  {23357, 23365, "kùn"},
  {23366, 23366, "kun"},
  {23367, 23407, "kuò"},
  {23408, 23423, "lā"},
  {23424, 23430, "lá"},
  {23431, 23435, "lǎ"},
  {23436, 23488, "là"},
  {23489, 23492, "la"},
  {23493, 23537, "lái"},
  {23538, 23542, "lǎi"},
  {23543, 23575, "lài"},
  {23576, 23653, "lán"},
  {23654, 23693, "lǎn"},
  {23694, 23715, "làn"},
  {23716, 23716, "lāng"},
  {23717, 23760, "láng"},
  {23761, 23775, "lǎng"},
  {23776, 23792, "làng"},
  {23793, 23793, "lang"},
  {23794, 23796, "lāo"},
  {23797, 23842, "láo"},
  {23843, 23874, "lǎo"},
  {23875, 23892, "lào"},
  {23893, 23893, "lao"},
  {23894, 23895, "lē"},
  {23896, 23921, "lè"},
  {23922, 23924, "le"},
  {23925, 23925, "lēi"},
  {23926, 23982, "léi"},
  {23983, 24040, "lěi"},
  {24041, 24078, "lèi"},
  {24079, 24079, "lei"},
  {24080, 24080, "lēng"},
  {24081, 24095, "léng"},
  {24096, 24096, "lěng"},
  {24097, 24102, "lèng"},
  {24103, 24103, "lī"},
  {24104, 24231, "lí"},
  {24232, 24275, "lí"},
  {24276, 24329, "lǐ"},
  {24330, 24457, "lì"},
  {24458, 24585, "lì"},
  {24586, 24648, "lì"},
  {24649, 24650, "liǎ"},
  {24651, 24751, "lián"},
  {24752, 24776, "liǎn"},
  {24777, 24823, "liàn"},
  {24824, 24851, "liáng"},
  {24852, 24873, "liǎng"},
  {24874, 24891, "liàng"},
  {24892, 24893, "liang"},
  {24894, 24895, "liāo"},
  {24896, 24964, "liáo"},
  {24965, 24988, "liǎo"},
  {24989, 25008, "liào"},
  {25009, 25009, "liē"},
  {25010, 25014, "liě"},
  {25015, 25123, "liè"},
  {25124, 25124, "līn"},
  {25125, 25185, "lín"},
  {25186, 25207, "lǐn"},
  {25208, 25248, "lìn"},
  {25249, 25376, "líng"},
  {25377, 25436, "líng"},
  {25437, 25444, "lǐng"},
  {25445, 25454, "lìng"},
  {25455, 25455, "ling"},
  {25456, 25459, "liū"},
  {25460, 25554, "liú"},
  {25555, 25577, "liǔ"},
  {25578, 25607, "liù"},
  {25608, 25608, "lo"},
  {25609, 25709, "lóng"},
  {25710, 25726, "lǒng"},
  {25727, 25743, "lòng"},
  {25744, 25745, "lōu"},
  {25746, 25798, "lóu"},
  {25799, 25814, "lǒu"},
  {25815, 25834, "lòu"},
  {25835, 25837, "lū"},
  {25838, 25906, "lú"},
  {25907, 25951, "lǔ"},
  {25952, 26079, "lù"},
  {26080, 26109, "lù"},
  {26110, 26110, "lu"},
  {26111, 26128, "lǘ"},
  {26129, 26172, "lǚ"},
  {26173, 26221, "lǜ"},
  {26222, 26268, "luán"},
  {26269, 26270, "luǎn"},
  {26271, 26278, "luàn"},
  {26279, 26304, "lüè"},
  {26305, 26306, "lūn"},
  {26307, 26339, "lún"},
  {26340, 26345, "lǔn"},
  {26346, 26350, "lùn"},
  {26351, 26356, "luō"},
  {26357, 26411, "luó"},
  {26412, 26439, "luǒ"},
  {26440, 26500, "luò"},
  {26501, 26501, "ḿ"},
  {26502, 26507, "mā"},
  {26508, 26526, "má"},
  {26527, 26545, "mǎ"},
  {26546, 26575, "mà"},
  {26576, 26580, "ma"},
  {26581, 26591, "mái"},
  {26592, 26598, "mǎi"},
  {26599, 26628, "mài"},
  {26629, 26630, "mān"},
  {26631, 26675, "mán"},
  {26676, 26694, "mǎn"},
  {26695, 26726, "màn"},
  {26727, 26730, "māng"},
  {26731, 26778, "máng"},
  {26779, 26803, "mǎng"},
  {26804, 26806, "màng"},
  {26807, 26809, "māo"},
  {26810, 26853, "máo"},
  {26854, 26871, "mǎo"},
  {26872, 26937, "mào"},
  {26938, 26938, "mē"},
  {26939, 26943, "me"},
  {26944, 27004, "méi"},
  {27005, 27027, "měi"},
  {27028, 27063, "mèi"},
  {27064, 27064, "mēn"},
  {27065, 27086, "mén"},
  {27087, 27098, "mèn"},
  {27099, 27100, "men"},
  {27101, 27101, "mēng"},
  {27102, 27199, "méng"},
  {27200, 27223, "měng"},
  {27224, 27245, "mèng"},
  {27246, 27246, "meng"},
  {27247, 27249, "mī"},
  {27250, 27330, "mí"},
  {27331, 27363, "mǐ"},
  {27364, 27442, "mì"},
  {27443, 27477, "mián"},
  {27478, 27516, "miǎn"},
  {27517, 27534, "miàn"},
  {27535, 27535, "miāo"},
  {27536, 27549, "miáo"},
  {27550, 27566, "miǎo"},
  {27567, 27575, "miào"},
  {27576, 27581, "miē"},
  {27582, 27582, "mié"},
  {27583, 27628, "miè"},
  {27629, 27678, "mín"},
  {27679, 27724, "mǐn"},
  {27725, 27725, "min"},
  {27726, 27759, "míng"},
  {27760, 27769, "mǐng"},
  {27770, 27777, "mìng"},
  {27778, 27778, "ming"},
  {27779, 27779, "miǔ"},
  {27780, 27781, "miù"},
  {27782, 27782, "mō"},
  {27783, 27826, "mó"},
  {27827, 27834, "mǒ"},
  {27835, 27957, "mò"},
  {27958, 27959, "mo"},
  {27960, 27960, "mōu"},
  {27961, 27992, "móu"},
  {27993, 27999, "mǒu"},
  {28000, 28001, "mòu"},
  {28002, 28010, "mú"},
  {28011, 28041, "mǔ"},
  {28042, 28093, "mù"},
  {28094, 28094, "ń"},
  {28095, 28095, "ň"},
  {28096, 28096, "ǹ"},
  {28097, 28097, "n"},
  {28098, 28114, "ná"},
  {28115, 28122, "nǎ"},
  {28123, 28184, "nà"},
  {28185, 28194, "nái"},
  {28195, 28210, "nǎi"},
  {28211, 28235, "nài"},
  {28236, 28236, "nān"},
  {28237, 28268, "nán"},
  {28269, 28288, "nǎn"},
  {28289, 28295, "nàn"},
  {28296, 28296, "nāng"},
  {28297, 28309, "náng"},
  {28310, 28315, "nǎng"},
  {28316, 28325, "nàng"},
  {28326, 28326, "nāo"},
  {28327, 28363, "náo"},
  {28364, 28404, "nǎo"},
  {28405, 28414, "nào"},
  {28415, 28426, "nè"},
  {28427, 28427, "ne"},
  {28428, 28432, "néi"},
  {28433, 28443, "něi"},
  {28444, 28453, "nèi"},
  {28454, 28462, "nèn"},
  {28463, 28467, "néng"},
  {28468, 28469, "něng"},
  {28470, 28470, "nèng"},
  {28471, 28471, "nī"},
  {28472, 28523, "ní"},
  {28524, 28566, "nǐ"},
  {28567, 28625, "nì"},
  {28626, 28628, "niān"},
  {28629, 28646, "nián"},
  {28647, 28679, "niǎn"},
  {28680, 28694, "niàn"},
  {28695, 28697, "niáng"},
  {28698, 28698, "niǎng"},
  {28699, 28703, "niàng"},
  {28704, 28738, "niǎo"},
  {28739, 28743, "niào"},
  {28744, 28745, "niē"},
  {28746, 28749, "nié"},
  {28750, 28750, "niě"},
  {28751, 28876, "niè"},
  {28877, 28882, "nín"},
  {28883, 28883, "nǐn"},
  {28884, 28884, "nin"},
  {28885, 28926, "níng"},
  {28927, 28931, "nǐng"},
  {28932, 28941, "nìng"},
  {28942, 28942, "niū"},
  {28943, 28951, "niú"},
  {28952, 28975, "niǔ"},
  {28976, 28978, "niù"},
  {28979, 29009, "nóng"},
  {29010, 29011, "nǒng"},
  {29012, 29017, "nòng"},
  {29018, 29030, "nóu"},
  {29031, 29036, "nǒu"},
  {29037, 29048, "nòu"},
  {29049, 29056, "nú"},
  {29057, 29067, "nǔ"},
  {29068, 29074, "nù"},
  {29075, 29075, "nǘ"},
  {29076, 29079, "nǚ"},
  {29080, 29092, "nǜ"},
  {29093, 29093, "nuán"},
  {29094, 29099, "nuǎn"},
  {29100, 29100, "nuàn"},
  {29101, 29108, "nüè"},
  {29109, 29109, "nún"},
  {29110, 29128, "nuó"},
  {29129, 29136, "nuǒ"},
  {29137, 29167, "nuò"},
  {29168, 29169, "ō"},
  {29170, 29170, "ó"},
  {29171, 29171, "o"},
  {29172, 29203, "ōu"},
  {29204, 29207, "óu"},
  {29208, 29227, "ǒu"},
  {29228, 29236, "òu"},
  {29237, 29253, "pā"},
  {29254, 29262, "pá"},
  {29263, 29263, "pǎ"},
  {29264, 29268, "pà"},
  {29269, 29272, "pāi"},
  {29273, 29287, "pái"},
  {29288, 29288, "pǎi"},
  {29289, 29306, "pài"},
  {29307, 29318, "pān"},
  {29319, 29353, "pán"},
  {29354, 29354, "pǎn"},
  {29355, 29379, "pàn"},
  {29380, 29397, "pāng"},
  {29398, 29419, "páng"},
  {29420, 29423, "pǎng"},
  {29424, 29430, "pàng"},
  {29431, 29439, "pāo"},
  {29440, 29467, "páo"},
  {29468, 29470, "pǎo"},
  {29471, 29491, "pào"},
  {29492, 29504, "pēi"},
  {29505, 29527, "péi"},
  {29528, 29529, "pěi"},
  {29530, 29556, "pèi"},
  {29557, 29561, "pēn"},
  {29562, 29567, "pén"},
  {29568, 29569, "pěn"},
  {29570, 29571, "pèn"},
  {29572, 29602, "pēng"},
  {29603, 29661, "péng"},
  {29662, 29668, "pěng"},
  {29669, 29678, "pèng"},
  {29679, 29746, "pī"},
  {29747, 29823, "pí"},
  {29824, 29856, "pǐ"},
  {29857, 29907, "pì"},
  {29908, 29921, "piān"},
  {29922, 29947, "pián"},
  {29948, 29951, "piǎn"},
  {29952, 29959, "piàn"},
  {29960, 29979, "piāo"},
  {29980, 29989, "piáo"},
  {29990, 30002, "piǎo"},
  {30003, 30014, "piào"},
  {30015, 30026, "piē"},
  {30027, 30030, "piě"},
  {30031, 30032, "piè"},
  {30033, 30045, "pīn"},
  {30046, 30070, "pín"},
  {30071, 30074, "pǐn"},
  {30075, 30078, "pìn"},
  {30079, 30098, "pīng"},
  {30099, 30160, "píng"},
  {30161, 30162, "pìng"},
  {30163, 30192, "pō"},
  {30193, 30207, "pó"},
  {30208, 30223, "pǒ"},
  {30224, 30269, "pò"},
  {30270, 30270, "po"},
  {30271, 30275, "pōu"},
  {30276, 30288, "póu"},
  {30289, 30295, "pǒu"},
  {30296, 30321, "pū"},
  {30322, 30366, "pú"},
  {30367, 30387, "pǔ"},
  {30388, 30398, "pù"},
  {30399, 30400, "pu"},
  {30401, 30481, "qī"},
  {30482, 30609, "qí"},
  {30610, 30662, "qí"},
  {30663, 30713, "qǐ"},
  {30714, 30830, "qì"},
  {30831, 30833, "qi"},
  {30834, 30842, "qiā"},
  {30843, 30844, "qiá"},
  {30845, 30848, "qiǎ"},
  {30849, 30887, "qià"},
  {30888, 30998, "qiān"},
  {30999, 31065, "qián"},
  {31066, 31104, "qiǎn"},
  {31105, 31150, "qiàn"},
  {31151, 31153, "qian"},
  {31154, 31206, "qiāng"},
  {31207, 31233, "qiáng"},
  {31234, 31247, "qiǎng"},
  {31248, 31254, "qiàng"},
  {31255, 31306, "qiāo"},
  {31307, 31345, "qiáo"},
  {31346, 31357, "qiǎo"},
  {31358, 31392, "qiào"},
  {31393, 31397, "qiē"},
  {31398, 31403, "qié"},
  {31404, 31405, "qiě"},
  {31406, 31471, "qiè"},
  {31472, 31497, "qīn"},
  {31498, 31558, "qín"},
  {31559, 31584, "qǐn"},
  {31585, 31610, "qìn"},
  {31611, 31641, "qīng"},
  {31642, 31665, "qíng"},
  {31666, 31684, "qǐng"},
  {31685, 31706, "qìng"},
  {31707, 31707, "qing"},
  {31708, 31709, "qiōng"},
  {31710, 31785, "qióng"},
  {31786, 31787, "qiòng"},
  {31788, 31834, "qiū"},
  {31835, 31931, "qiú"},
  {31932, 31937, "qiǔ"},
  {31938, 31941, "qiù"},
  {31942, 32027, "qū"},
  {32028, 32130, "qú"},
  {32131, 32145, "qǔ"},
  {32146, 32167, "qù"},
  {32168, 32168, "qu"},
  {32169, 32187, "quān"},
  {32188, 32267, "quán"},
  {32268, 32286, "quǎn"},
  {32287, 32296, "quàn"},
  {32297, 32297, "quan"},
  {32298, 32306, "quē"},
  {32307, 32307, "qué"},
  {32308, 32377, "què"},
  {32378, 32387, "qūn"},
  {32388, 32400, "qún"},
  {32401, 32401, "qǔn"},
  {32402, 32437, "rán"},
  {32438, 32464, "rǎn"},
  {32465, 32466, "ràn"},
  {32467, 32484, "ráng"},
  {32485, 32495, "rǎng"},
  {32496, 32499, "ràng"},
  {32500, 32510, "ráo"},
  {32511, 32518, "rǎo"},
  {32519, 32521, "rào"},
  {32522, 32523, "rě"},
  {32524, 32528, "rè"},
  {32529, 32548, "rén"},
  {32549, 32565, "rěn"},
  {32566, 32618, "rèn"},
  {32619, 32619, "rēng"},
  {32620, 32635, "réng"},
  {32636, 32636, "rèng"},
  {32637, 32649, "rì"},
  {32650, 32650, "rōng"},
  {32651, 32729, "róng"},
  {32730, 32767, "rǒng"},
  {32768, 32768, "ròng"},
  {32769, 32769, "rong"},
  {32770, 32798, "róu"},
  {32799, 32802, "rǒu"},
  {32803, 32806, "ròu"},
  {32807, 32861, "rú"},
  {32862, 32874, "rǔ"},
  {32875, 32894, "rù"},
  {32895, 32895, "ru"},
  {32896, 32896, "ruá"},
  {32897, 32904, "ruán"},
  {32905, 32939, "ruǎn"},
  {32940, 32942, "ruàn"},
  {32943, 32951, "ruí"},
  {32952, 32961, "ruǐ"},
  {32962, 32986, "ruì"},
  {32987, 32989, "rún"},
  {32990, 32990, "rǔn"},
  {32991, 33001, "rùn"},
  {33002, 33002, "ruó"},
  {33003, 33025, "ruò"},
  {33026, 33032, "sā"},
  {33033, 33043, "sǎ"},
  {33044, 33090, "sà"},
  {33091, 33091, "sa"},
  {33092, 33106, "sāi"},
  {33107, 33109, "sǎi"},
  {33110, 33116, "sài"},
  {33117, 33134, "sān"},
  {33135, 33160, "sǎn"},
  {33161, 33174, "sàn"},
  {33175, 33176, "san"},
  {33177, 33187, "sāng"},
  {33188, 33202, "sǎng"},
  {33203, 33206, "sàng"},
  {33207, 33235, "sāo"},
  {33236, 33242, "sǎo"},
  {33243, 33260, "sào"},
  {33261, 33261, "sē"},
  {33262, 33336, "sè"},
  {33337, 33342, "sēn"},
  {33343, 33343, "sěn"},
  {33344, 33346, "sēng"},
  {33347, 33347, "sèng"},
  {33348, 33404, "shā"},
  {33405, 33407, "shǎ"},
  {33408, 33446, "shà"},
  {33447, 33447, "sha"},
  {33448, 33455, "shāi"},
  {33456, 33457, "shǎi"},
  {33458, 33467, "shài"},
  {33468, 33528, "shān"},
  {33529, 33529, "shán"},
  {33530, 33562, "shǎn"},
  {33563, 33636, "shàn"},
  {33637, 33662, "shāng"},
  {33663, 33672, "shǎng"},
  {33673, 33682, "shàng"},
  {33683, 33683, "shang"},
  {33684, 33711, "shāo"},
  {33712, 33722, "sháo"},
  {33723, 33732, "shǎo"},
  {33733, 33752, "shào"},
  {33753, 33766, "shē"},
  {33767, 33783, "shé"},
  {33784, 33787, "shě"},
  {33788, 33839, "shè"},
  {33840, 33840, "shéi"},
  {33841, 33922, "shēn"},
  {33923, 33929, "shén"},
  {33930, 33967, "shěn"},
  {33968, 33997, "shèn"},
  {33998, 34040, "shēng"},
  {34041, 34048, "shéng"},
  {34049, 34067, "shěng"},
  {34068, 34093, "shèng"},
  {34094, 34169, "shī"},
  {34170, 34237, "shí"},
  {34238, 34270, "shǐ"},
  {34271, 34398, "shì"},
  {34399, 34421, "shì"},
  {34422, 34426, "shi"},
  {34427, 34434, "shōu"},
  {34435, 34447, "shǒu"},
  {34448, 34480, "shòu"},
  {34481, 34482, "shou"},
  {34483, 34556, "shū"},
  {34557, 34576, "shú"},
  {34577, 34613, "shǔ"},
  {34614, 34694, "shù"},
  {34695, 34698, "shuā"},
  {34699, 34703, "shuǎ"},
  {34704, 34704, "shuà"},
  {34705, 34711, "shuāi"},
  {34712, 34712, "shuǎi"},
  {34713, 34726, "shuài"},
  {34727, 34734, "shuān"},
  {34735, 34743, "shuàn"},
  {34744, 34767, "shuāng"},
  {34768, 34784, "shuǎng"},
  {34785, 34788, "shuàng"},
  {34789, 34791, "shuí"},
  {34792, 34800, "shuǐ"},
  {34801, 34822, "shuì"},
  {34823, 34825, "shui"},
  {34826, 34827, "shǔn"},
  {34828, 34841, "shùn"},
  {34842, 34845, "shuō"},
  {34846, 34880, "shuò"},
  {34881, 34975, "sī"},
  {34976, 34977, "sǐ"},
  {34978, 35047, "sì"},
  {35048, 35084, "sōng"},
  {35085, 35087, "sóng"},
  {35088, 35109, "sǒng"},
  {35110, 35128, "sòng"},
  {35129, 35181, "sōu"},
  {35182, 35206, "sǒu"},
  {35207, 35210, "sòu"},
  {35211, 35232, "sū"},
  {35233, 35235, "sú"},
  {35236, 35236, "sǔ"},
  {35237, 35364, "sù"},
  {35365, 35365, "sù"},
  {35366, 35375, "suān"},
  {35376, 35377, "suǎn"},
  {35378, 35385, "suàn"},
  {35386, 35420, "suī"},
  {35421, 35433, "suí"},
  {35434, 35442, "suǐ"},
  {35443, 35528, "suì"},
  {35529, 35541, "sūn"},
  {35542, 35558, "sǔn"},
  {35559, 35592, "suō"},
  {35593, 35593, "suó"},
  {35594, 35655, "suǒ"},
  {35656, 35663, "suò"},
  {35664, 35664, "suo"},
  {35665, 35685, "tā"},
  {35686, 35687, "tá"},
  {35688, 35705, "tǎ"},
  {35706, 35808, "tà"},
  {35809, 35810, "ta"},
  {35811, 35816, "tāi"},
  {35817, 35852, "tái"},
  {35853, 35854, "tǎi"},
  {35855, 35877, "tài"},
  {35878, 35878, "tai"},
  {35879, 35910, "tān"},
  {35911, 35977, "tán"},
  {35978, 36007, "tǎn"},
  {36008, 36030, "tàn"},
  {36031, 36051, "tāng"},
  {36052, 36120, "táng"},
  {36121, 36143, "tǎng"},
  {36144, 36149, "tàng"},
  {36150, 36196, "tāo"},
  {36197, 36238, "táo"},
  {36239, 36242, "tǎo"},
  {36243, 36246, "tào"},
  {36247, 36263, "tè"},
  {36264, 36271, "tēng"},
  {36272, 36308, "téng"},
  {36309, 36309, "tèng"},
  {36310, 36328, "tī"},
  {36329, 36414, "tí"},
  {36415, 36426, "tǐ"},
  {36427, 36488, "tì"},
  {36489, 36489, "ti"},
  {36490, 36510, "tiān"},
  {36511, 36558, "tián"},
  {36559, 36600, "tiǎn"},
  {36601, 36611, "tiàn"},
  {36612, 36628, "tiāo"},
  {36629, 36668, "tiáo"},
  {36669, 36681, "tiǎo"},
  {36682, 36691, "tiào"},
  {36692, 36692, "tiao"},
  {36693, 36699, "tiē"},
  {36700, 36700, "tié"},
  {36701, 36711, "tiě"},
  {36712, 36720, "tiè"},
  {36721, 36749, "tīng"},
  {36750, 36787, "tíng"},
  {36788, 36820, "tǐng"},
  {36821, 36823, "tìng"},
  {36824, 36837, "tōng"},
  {36838, 36918, "tóng"},
  {36919, 36931, "tǒng"},
  {36932, 36937, "tòng"},
  {36938, 36945, "tōu"},
  {36946, 36963, "tóu"},
  {36964, 36978, "tǒu"},
  {36979, 36986, "tòu"},
  {36987, 37025, "tū"},
  {37026, 37097, "tú"},
  {37098, 37103, "tǔ"},
  {37104, 37112, "tù"},
  {37113, 37113, "tu"},
  {37114, 37122, "tuān"},
  {37123, 37151, "tuán"},
  {37152, 37156, "tuǎn"},
  {37157, 37160, "tuàn"},
  {37161, 37166, "tuī"},
  {37167, 37201, "tuí"},
  {37202, 37211, "tuǐ"},
  {37212, 37229, "tuì"},
  {37230, 37245, "tūn"},
  {37246, 37277, "tún"},
  {37278, 37285, "tǔn"},
  {37286, 37290, "tùn"},
  {37291, 37330, "tuō"},
  {37331, 37402, "tuó"},
  {37403, 37425, "tuǒ"},
  {37426, 37444, "tuò"},
  {37445, 37477, "wā"},
  {37478, 37481, "wá"},
  {37482, 37492, "wǎ"},
  {37493, 37512, "wà"},
  {37513, 37514, "wa"},
  {37515, 37523, "wāi"},
  {37524, 37527, "wǎi"},
  {37528, 37540, "wài"},
  {37541, 37565, "wān"},
  {37566, 37596, "wán"},
  {37597, 37657, "wǎn"},
  {37658, 37697, "wàn"},
  {37698, 37710, "wāng"},
  {37711, 37723, "wáng"},
  {37724, 37767, "wǎng"},
  {37768, 37782, "wàng"},
  {37783, 37840, "wēi"},
  {37841, 37925, "wéi"},
  {37926, 38041, "wěi"},
  {38042, 38150, "wèi"},
  {38151, 38151, "wei"},
  {38152, 38177, "wēn"},
  {38178, 38216, "wén"},
  {38217, 38241, "wěn"},
  {38242, 38258, "wèn"},
  {38259, 38259, "wen"},
  {38260, 38279, "wēng"},
  {38280, 38298, "wěng"},
  {38299, 38306, "wèng"},
  {38307, 38327, "wō"},
  {38328, 38346, "wǒ"},
  {38347, 38401, "wò"},
  {38402, 38402, "wòng"},
  {38403, 38448, "wū"},
  {38449, 38507, "wú"},
  {38508, 38572, "wǔ"},
  {38573, 38670, "wù"},
  {38672, 38672, "wu"},
  {38673, 38800, "xī"},
  {38801, 38928, "xī"},
  {38929, 38943, "xī"},
  {38944, 38997, "xí"},
  {38998, 39047, "xǐ"},
  {39048, 39175, "xì"},
  {39176, 39180, "xì"},
  {39181, 39205, "xiā"},
  {39206, 39284, "xiá"},
  {39285, 39285, "xiǎ"},
  {39286, 39318, "xià"},
  {39319, 39412, "xiān"},
  {39413, 39511, "xián"},
  {39512, 39581, "xiǎn"},
  {39582, 39696, "xiàn"},
  {39697, 39697, "xian"},
  {39698, 39737, "xiāng"},
  {39738, 39760, "xiáng"},
  {39761, 39791, "xiǎng"},
  {39792, 39838, "xiàng"},
  {39839, 39958, "xiāo"},
  {39959, 39983, "xiáo"},
  {39984, 40006, "xiǎo"},
  {40007, 40057, "xiào"},
  {40058, 40058, "xiao"},
  {40059, 40081, "xiē"},
  {40082, 40191, "xié"},
  {40192, 40202, "xiě"},
  {40203, 40330, "xiè"},
  {40331, 40368, "xiè"},
  {40369, 40414, "xīn"},
  {40415, 40421, "xín"},
  {40422, 40423, "xǐn"},
  {40424, 40464, "xìn"},
  {40465, 40466, "xin"},
  {40468, 40505, "xīng"},
  {40506, 40542, "xíng"},
  {40543, 40550, "xǐng"},
  {40551, 40575, "xìng"},
  {40576, 40577, "xing"},
  {40578, 40603, "xiōng"},
  {40604, 40608, "xióng"},
  {40609, 40609, "xiǒng"},
  {40610, 40631, "xiòng"},
  {40632, 40684, "xiū"},
  {40685, 40685, "xiú"},
  {40686, 40694, "xiǔ"},
  {40695, 40719, "xiù"},
  {40720, 40810, "xū"},
  {40811, 40817, "xú"},
  {40818, 40850, "xǔ"},
  {40851, 40978, "xù"},
  {40979, 40986, "xù"},
  {40987, 40987, "xu"},
  {40988, 41053, "xuān"},
  {41054, 41088, "xuán"},
  {41089, 41109, "xuǎn"},
  {41110, 41163, "xuàn"},
  {41164, 41176, "xuē"},
  {41177, 41207, "xué"},
  {41208, 41215, "xuě"},
  {41216, 41254, "xuè"},
  {41255, 41290, "xūn"},
  {41291, 41360, "xún"},
  {41361, 41407, "xùn"},
  {41408, 41442, "yā"},
  {41443, 41472, "yá"},
  {41473, 41487, "yǎ"},
  {41488, 41544, "yà"},
  {41545, 41548, "ya"},
  {41549, 41605, "yān"},
  {41606, 41721, "yán"},
  {41722, 41849, "yǎn"},
  {41850, 41850, "yǎn"},
  {41851, 41978, "yàn"},
  {41979, 41981, "yàn"},
  {41982, 42007, "yāng"},
  {42008, 42075, "yáng"},
  {42076, 42110, "yǎng"},
  {42111, 42138, "yàng"},
  {42139, 42139, "yang"},
  {42140, 42175, "yāo"},
  {42176, 42270, "yáo"},
  {42271, 42323, "yǎo"},
  {42324, 42380, "yào"},
  {42381, 42393, "yē"},
  {42394, 42415, "yé"},
  {42416, 42429, "yě"},
  {42430, 42556, "yè"},
  {42557, 42557, "ye"},
  {42558, 42634, "yī"},
  {42635, 42762, "yí"},
  {42763, 42815, "yí"},
  {42816, 42884, "yǐ"},
  {42885, 43012, "yì"},
  {43013, 43140, "yì"},
  {43141, 43268, "yì"},
  {43269, 43312, "yì"},
  {43313, 43375, "yīn"},
  {43376, 43456, "yín"},
  {43457, 43517, "yǐn"},
  {43518, 43567, "yìn"},
  {43568, 43568, "yin"},
  {43569, 43663, "yīng"},
  {43664, 43737, "yíng"},
  {43738, 43778, "yǐng"},
  {43779, 43802, "yìng"},
  {43803, 43805, "yō"},
  {43806, 43864, "yōng"},
  {43865, 43877, "yóng"},
  {43878, 43926, "yǒng"},
  {43927, 43938, "yòng"},
  {43939, 43981, "yōu"},
  {43982, 44075, "yóu"},
  {44076, 44130, "yǒu"},
  {44131, 44182, "yòu"},
  {44183, 44183, "you"},
  {44184, 44207, "yū"},
  {44208, 44335, "yú"},
  {44336, 44392, "yú"},
  {44393, 44476, "yǔ"},
  {44477, 44604, "yù"},
  {44605, 44732, "yù"},
  {44733, 44737, "yù"},
  {44739, 44739, "yu"},
  {44740, 44791, "yuān"},
  {44792, 44881, "yuán"},
  {44882, 44894, "yuǎn"},
  {44895, 44930, "yuàn"},
  {44931, 44947, "yuē"},
  {44948, 44948, "yuě"},
  {44949, 45062, "yuè"},
  {45063, 45082, "yūn"},
  {45083, 45128, "yún"},
  {45129, 45161, "yǔn"},
  {45162, 45214, "yùn"},
  {45215, 45216, "yun"},
  {45217, 45239, "zā"},
  {45240, 45269, "zá"},
  {45270, 45271, "zǎ"},
  {45272, 45289, "zāi"},
  {45290, 45300, "zǎi"},
  {45301, 45318, "zài"},
  {45319, 45328, "zān"},
  {45329, 45329, "zán"},
  {45330, 45348, "zǎn"},
  {45349, 45382, "zàn"},
  {45383, 45403, "zāng"},
  {45404, 45405, "zǎng"},
  {45406, 45417, "zàng"},
  {45418, 45433, "zāo"},
  {45434, 45436, "záo"},
  {45437, 45459, "zǎo"},
  {45460, 45489, "zào"},
  {45490, 45561, "zé"},
  {45562, 45581, "zè"},
  {45582, 45582, "ze"},
  {45583, 45594, "zéi"},
  {45595, 45595, "zēn"},
  {45596, 45596, "zěn"},
  {45597, 45599, "zèn"},
  {45600, 45600, "zen"},
  {45601, 45622, "zēng"},
  {45623, 45623, "zěng"},
  {45624, 45632, "zèng"},
  {45633, 45675, "zhā"},
  {45676, 45720, "zhá"},
  {45721, 45747, "zhǎ"},
  {45748, 45780, "zhà"},
  {45781, 45806, "zhāi"},
  {45807, 45813, "zhái"},
  {45814, 45822, "zhǎi"},
  {45823, 45838, "zhài"},
  {45839, 45902, "zhān"},
  {45903, 45903, "zhán"},
  {45904, 45955, "zhǎn"},
  {45956, 46008, "zhàn"},
  {46009, 46042, "zhāng"},
  {46043, 46060, "zhǎng"},
  {46061, 46085, "zhàng"},
  {46086, 46086, "zhang"},
  {46087, 46110, "zhāo"},
  {46111, 46124, "zhǎo"},
  {46125, 46171, "zhào"},
  {46172, 46172, "zhao"},
  {46173, 46180, "zhē"},
  {46181, 46280, "zhé"},
  {46281, 46289, "zhě"},
  {46290, 46313, "zhè"},
  {46314, 46316, "zhe"},
  {46317, 46388, "zhēn"},
  {46389, 46389, "zhén"},
  {46390, 46438, "zhěn"},
  {46439, 46495, "zhèn"},
  {46496, 46571, "zhēng"},
  {46572, 46587, "zhěng"},
  {46588, 46621, "zhèng"},
  {46622, 46713, "zhī"},
  {46714, 46784, "zhí"},
  {46785, 46866, "zhǐ"},
  {46867, 46994, "zhì"},
  {46995, 47122, "zhì"},
  {47123, 47134, "zhì"},
  {47135, 47135, "zhi"},
  {47136, 47185, "zhōng"},
  {47186, 47205, "zhǒng"},
  {47206, 47236, "zhòng"},
  {47237, 47300, "zhōu"},
  {47301, 47307, "zhóu"},
  {47308, 47322, "zhǒu"},
  {47323, 47387, "zhòu"},
  {47388, 47445, "zhū"},
  {47446, 47495, "zhú"},
  {47496, 47530, "zhǔ"},
  {47531, 47624, "zhù"},
  {47625, 47631, "zhuā"},
  {47632, 47633, "zhuǎ"},
  {47634, 47634, "zhuāi"},
  {47635, 47635, "zhuǎi"},
  {47636, 47636, "zhuài"},
  {47637, 47661, "zhuān"},
  {47662, 47675, "zhuǎn"},
  {47676, 47713, "zhuàn"},
  {47714, 47732, "zhuāng"},
  {47733, 47733, "zhuǎng"},
  {47734, 47753, "zhuàng"},
  {47754, 47769, "zhuī"},
  {47770, 47771, "zhuǐ"},
  {47772, 47809, "zhuì"},
  {47810, 47818, "zhūn"},
  {47819, 47823, "zhǔn"},
  {47824, 47826, "zhùn"},
  {47827, 47851, "zhuō"},
  {47852, 47960, "zhuó"},
  {47961, 47962, "zhuò"},
  {47963, 47963, "zhuo"},
  {47964, 48072, "zī"},
  {48073, 48073, "zí"},
  {48074, 48116, "zǐ"},
  {48117, 48149, "zì"},
  {48150, 48150, "zi"},
  {48151, 48211, "zōng"},
  {48212, 48235, "zǒng"},
  {48236, 48257, "zòng"},
  {48258, 48258, "zong"},
  {48259, 48286, "zōu"},
  {48287, 48291, "zǒu"},
  {48292, 48301, "zòu"},
  {48302, 48305, "zū"},
  {48306, 48355, "zú"},
  {48356, 48376, "zǔ"},
  {48377, 48380, "zù"},
  {48381, 48389, "zuān"},
  {48390, 48402, "zuǎn"},
  {48403, 48405, "zuàn"},
  {48406, 48421, "zuī"},
  {48422, 48436, "zuǐ"},
  {48437, 48467, "zuì"},
  {48468, 48469, "zui"},
  {48470, 48485, "zūn"},
  {48486, 48492, "zǔn"},
  {48493, 48500, "zùn"},
  {48501, 48503, "zuō"},
  {48504, 48528, "zuó"},
  {48529, 48537, "zuǒ"},
  {48538, 48573, "zuò"},
  {48574, 48574, "zuo"},
};
} // end namespace sql
} // end namespace oceanbase
