/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#define USING_LOG_PREFIX SQL_ENG

#include "sql/engine/aggregate/ob_distinct_op.h"

namespace oceanbase
{
using namespace common;
namespace sql
{

ObDistinctSpec::ObDistinctSpec(ObIAllocator &alloc, const ObPhyOperatorType type)
  : ObOpSpec(alloc, type),
  distinct_exprs_(alloc),
  cmp_funcs_(alloc),
  is_block_mode_(false),
  by_pass_enabled_(false)
{}

OB_SERIALIZE_MEMBER((ObDistinctSpec, ObOpSpec),
                    distinct_exprs_,
                    cmp_funcs_,
                    is_block_mode_,
                    by_pass_enabled_);


} // end namespace sql
} // end namespace oceanbase

