/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef OCEANBASE_SHARE_SYSTEM_VARIABLE_OB_SYSTEM_VARIABLE_ALIAS_
#define OCEANBASE_SHARE_SYSTEM_VARIABLE_OB_SYSTEM_VARIABLE_ALIAS_
namespace oceanbase
{
namespace share
{
  static const char* const OB_SV_AUTO_INCREMENT_INCREMENT = "auto_increment_increment";
  static const char* const OB_SV_AUTO_INCREMENT_OFFSET = "auto_increment_offset";
  static const char* const OB_SV_AUTOCOMMIT = "autocommit";
  static const char* const OB_SV_CHARACTER_SET_CLIENT = "character_set_client";
  static const char* const OB_SV_CHARACTER_SET_CONNECTION = "character_set_connection";
  static const char* const OB_SV_CHARACTER_SET_DATABASE = "character_set_database";
  static const char* const OB_SV_CHARACTER_SET_RESULTS = "character_set_results";
  static const char* const OB_SV_CHARACTER_SET_SERVER = "character_set_server";
  static const char* const OB_SV_CHARACTER_SET_SYSTEM = "character_set_system";
  static const char* const OB_SV_COLLATION_CONNECTION = "collation_connection";
  static const char* const OB_SV_COLLATION_DATABASE = "collation_database";
  static const char* const OB_SV_COLLATION_SERVER = "collation_server";
  static const char* const OB_SV_INTERACTIVE_TIMEOUT = "interactive_timeout";
  static const char* const OB_SV_LAST_INSERT_ID = "last_insert_id";
  static const char* const OB_SV_MAX_ALLOWED_PACKET = "max_allowed_packet";
  static const char* const OB_SV_SQL_MODE = "sql_mode";
  static const char* const OB_SV_TIME_ZONE = "time_zone";
  static const char* const OB_SV_TX_ISOLATION = "tx_isolation";
  static const char* const OB_SV_VERSION_COMMENT = "version_comment";
  static const char* const OB_SV_WAIT_TIMEOUT = "wait_timeout";
  static const char* const OB_SV_BINLOG_ROW_IMAGE = "binlog_row_image";
  static const char* const OB_SV_CHARACTER_SET_FILESYSTEM = "character_set_filesystem";
  static const char* const OB_SV_CONNECT_TIMEOUT = "connect_timeout";
  static const char* const OB_SV_DATADIR = "datadir";
  static const char* const OB_SV_DEBUG_SYNC = "debug_sync";
  static const char* const OB_SV_DIV_PRECISION_INCREMENT = "div_precision_increment";
  static const char* const OB_SV_EXPLICIT_DEFAULTS_FOR_TIMESTAMP = "explicit_defaults_for_timestamp";
  static const char* const OB_SV_GROUP_CONCAT_MAX_LEN = "group_concat_max_len";
  static const char* const OB_SV_IDENTITY = "identity";
  static const char* const OB_SV_LOWER_CASE_TABLE_NAMES = "lower_case_table_names";
  static const char* const OB_SV_NET_READ_TIMEOUT = "net_read_timeout";
  static const char* const OB_SV_NET_WRITE_TIMEOUT = "net_write_timeout";
  static const char* const OB_SV_READ_ONLY = "read_only";
  static const char* const OB_SV_SQL_AUTO_IS_NULL = "sql_auto_is_null";
  static const char* const OB_SV_SQL_SELECT_LIMIT = "sql_select_limit";
  static const char* const OB_SV_TIMESTAMP = "timestamp";
  static const char* const OB_SV_TX_READ_ONLY = "tx_read_only";
  static const char* const OB_SV_VERSION = "version";
  static const char* const OB_SV_SQL_WARNINGS = "sql_warnings";
  static const char* const OB_SV_MAX_USER_CONNECTIONS = "max_user_connections";
  static const char* const OB_SV_INIT_CONNECT = "init_connect";
  static const char* const OB_SV_LICENSE = "license";
  static const char* const OB_SV_NET_BUFFER_LENGTH = "net_buffer_length";
  static const char* const OB_SV_SYSTEM_TIME_ZONE = "system_time_zone";
  static const char* const OB_SV_QUERY_CACHE_SIZE = "query_cache_size";
  static const char* const OB_SV_QUERY_CACHE_TYPE = "query_cache_type";
  static const char* const OB_SV_SQL_QUOTE_SHOW_CREATE = "sql_quote_show_create";
  static const char* const OB_SV_MAX_SP_RECURSION_DEPTH = "max_sp_recursion_depth";
  static const char* const OB_SV_SQL_SAFE_UPDATES = "sql_safe_updates";
  static const char* const OB_SV_CONCURRENT_INSERT = "concurrent_insert";
  static const char* const OB_SV_DEFAULT_AUTHENTICATION_PLUGIN = "default_authentication_plugin";
  static const char* const OB_SV_DISABLED_STORAGE_ENGINES = "disabled_storage_engines";
  static const char* const OB_SV_ERROR_COUNT = "error_count";
  static const char* const OB_SV_GENERAL_LOG = "general_log";
  static const char* const OB_SV_HAVE_OPENSSL = "have_openssl";
  static const char* const OB_SV_HAVE_PROFILING = "have_profiling";
  static const char* const OB_SV_HAVE_SSL = "have_ssl";
  static const char* const OB_SV_HOSTNAME = "hostname";
  static const char* const OB_SV_LC_MESSAGES = "lc_messages";
  static const char* const OB_SV_LOCAL_INFILE = "local_infile";
  static const char* const OB_SV_LOCK_WAIT_TIMEOUT = "lock_wait_timeout";
  static const char* const OB_SV_LONG_QUERY_TIME = "long_query_time";
  static const char* const OB_SV_MAX_CONNECTIONS = "max_connections";
  static const char* const OB_SV_MAX_EXECUTION_TIME = "max_execution_time";
  static const char* const OB_SV_PROTOCOL_VERSION = "protocol_version";
  static const char* const OB_SV_SERVER_ID = "server_id";
  static const char* const OB_SV_SSL_CA = "ssl_ca";
  static const char* const OB_SV_SSL_CAPATH = "ssl_capath";
  static const char* const OB_SV_SSL_CERT = "ssl_cert";
  static const char* const OB_SV_SSL_CIPHER = "ssl_cipher";
  static const char* const OB_SV_SSL_CRL = "ssl_crl";
  static const char* const OB_SV_SSL_CRLPATH = "ssl_crlpath";
  static const char* const OB_SV_SSL_KEY = "ssl_key";
  static const char* const OB_SV_TIME_FORMAT = "time_format";
  static const char* const OB_SV_TLS_VERSION = "tls_version";
  static const char* const OB_SV_TMP_TABLE_SIZE = "tmp_table_size";
  static const char* const OB_SV_TMPDIR = "tmpdir";
  static const char* const OB_SV_UNIQUE_CHECKS = "unique_checks";
  static const char* const OB_SV_VERSION_COMPILE_MACHINE = "version_compile_machine";
  static const char* const OB_SV_VERSION_COMPILE_OS = "version_compile_os";
  static const char* const OB_SV_WARNING_COUNT = "warning_count";
  static const char* const OB_SV_SESSION_TRACK_SCHEMA = "session_track_schema";
  static const char* const OB_SV_SESSION_TRACK_SYSTEM_VARIABLES = "session_track_system_variables";
  static const char* const OB_SV_SESSION_TRACK_STATE_CHANGE = "session_track_state_change";
  static const char* const OB_SV_HAVE_QUERY_CACHE = "have_query_cache";
  static const char* const OB_SV_QUERY_CACHE_LIMIT = "query_cache_limit";
  static const char* const OB_SV_QUERY_CACHE_MIN_RES_UNIT = "query_cache_min_res_unit";
  static const char* const OB_SV_QUERY_CACHE_WLOCK_INVALIDATE = "query_cache_wlock_invalidate";
  static const char* const OB_SV_BINLOG_FORMAT = "binlog_format";
  static const char* const OB_SV_BINLOG_CHECKSUM = "binlog_checksum";
  static const char* const OB_SV_BINLOG_ROWS_QUERY_LOG_EVENTS = "binlog_rows_query_log_events";
  static const char* const OB_SV_LOG_BIN = "log_bin";
  static const char* const OB_SV_SERVER_UUID = "server_uuid";
  static const char* const OB_SV_DEFAULT_STORAGE_ENGINE = "default_storage_engine";
  static const char* const OB_SV_CTE_MAX_RECURSION_DEPTH = "cte_max_recursion_depth";
  static const char* const OB_SV_REGEXP_STACK_LIMIT = "regexp_stack_limit";
  static const char* const OB_SV_REGEXP_TIME_LIMIT = "regexp_time_limit";
  static const char* const OB_SV_PROFILING = "profiling";
  static const char* const OB_SV_PROFILING_HISTORY_SIZE = "profiling_history_size";
  static const char* const OB_SV_INTERM_RESULT_MEM_LIMIT = "ob_interm_result_mem_limit";
  static const char* const OB_SV_PROXY_PARTITION_HIT = "ob_proxy_partition_hit";
  static const char* const OB_SV_LOG_LEVEL = "ob_log_level";
  static const char* const OB_SV_QUERY_TIMEOUT = "ob_query_timeout";
  static const char* const OB_SV_READ_CONSISTENCY = "ob_read_consistency";
  static const char* const OB_SV_ENABLE_TRANSFORMATION = "ob_enable_transformation";
  static const char* const OB_SV_TRX_TIMEOUT = "ob_trx_timeout";
  static const char* const OB_SV_ENABLE_PLAN_CACHE = "ob_enable_plan_cache";
  static const char* const OB_SV_ENABLE_INDEX_DIRECT_SELECT = "ob_enable_index_direct_select";
  static const char* const OB_SV_PROXY_SET_TRX_EXECUTED = "ob_proxy_set_trx_executed";
  static const char* const OB_SV_ENABLE_AGGREGATION_PUSHDOWN = "ob_enable_aggregation_pushdown";
  static const char* const OB_SV_LAST_SCHEMA_VERSION = "ob_last_schema_version";
  static const char* const OB_SV_GLOBAL_DEBUG_SYNC = "ob_global_debug_sync";
  static const char* const OB_SV_PROXY_GLOBAL_VARIABLES_VERSION = "ob_proxy_global_variables_version";
  static const char* const OB_SV_ENABLE_SHOW_TRACE = "ob_enable_show_trace";
  static const char* const OB_SV_BNL_JOIN_CACHE_SIZE = "ob_bnl_join_cache_size";
  static const char* const OB_SV_PROXY_USER_PRIVILEGE = "ob_proxy_user_privilege";
  static const char* const OB_SV_ORG_CLUSTER_ID = "ob_org_cluster_id";
  static const char* const OB_SV_PLAN_CACHE_PERCENTAGE = "ob_plan_cache_percentage";
  static const char* const OB_SV_PLAN_CACHE_EVICT_HIGH_PERCENTAGE = "ob_plan_cache_evict_high_percentage";
  static const char* const OB_SV_PLAN_CACHE_EVICT_LOW_PERCENTAGE = "ob_plan_cache_evict_low_percentage";
  static const char* const OB_SV_RECYCLEBIN = "recyclebin";
  static const char* const OB_SV_CAPABILITY_FLAG = "ob_capability_flag";
  static const char* const OB_SV_IS_RESULT_ACCURATE = "is_result_accurate";
  static const char* const OB_SV_ERROR_ON_OVERLAP_TIME = "error_on_overlap_time";
  static const char* const OB_SV_COMPATIBILITY_MODE = "ob_compatibility_mode";
  static const char* const OB_SV_SQL_WORK_AREA_PERCENTAGE = "ob_sql_work_area_percentage";
  static const char* const OB_SV_SAFE_WEAK_READ_SNAPSHOT = "ob_safe_weak_read_snapshot";
  static const char* const OB_SV_ROUTE_POLICY = "ob_route_policy";
  static const char* const OB_SV_ENABLE_TRANSMISSION_CHECKSUM = "ob_enable_transmission_checksum";
  static const char* const OB_SV_FOREIGN_KEY_CHECKS = "foreign_key_checks";
  static const char* const OB_SV_STATEMENT_TRACE_ID = "ob_statement_trace_id";
  static const char* const OB_SV_ENABLE_TRUNCATE_FLASHBACK = "ob_enable_truncate_flashback";
  static const char* const OB_SV_TCP_INVITED_NODES = "ob_tcp_invited_nodes";
  static const char* const OB_SV_SQL_THROTTLE_CURRENT_PRIORITY = "sql_throttle_current_priority";
  static const char* const OB_SV_SQL_THROTTLE_PRIORITY = "sql_throttle_priority";
  static const char* const OB_SV_SQL_THROTTLE_RT = "sql_throttle_rt";
  static const char* const OB_SV_SQL_THROTTLE_CPU = "sql_throttle_cpu";
  static const char* const OB_SV_SQL_THROTTLE_IO = "sql_throttle_io";
  static const char* const OB_SV_SQL_THROTTLE_NETWORK = "sql_throttle_network";
  static const char* const OB_SV_SQL_THROTTLE_LOGICAL_READS = "sql_throttle_logical_reads";
  static const char* const OB_SV_AUTO_INCREMENT_CACHE_SIZE = "auto_increment_cache_size";
  static const char* const OB_SV_ENABLE_JIT = "ob_enable_jit";
  static const char* const OB_SV_TEMP_TABLESPACE_SIZE_PERCENTAGE = "ob_temp_tablespace_size_percentage";
  static const char* const OB_SV_PLUGIN_DIR = "plugin_dir";
  static const char* const OB_SV_SQL_AUDIT_PERCENTAGE = "ob_sql_audit_percentage";
  static const char* const OB_SV_ENABLE_SQL_AUDIT = "ob_enable_sql_audit";
  static const char* const OB_SV_OPTIMIZER_USE_SQL_PLAN_BASELINES = "optimizer_use_sql_plan_baselines";
  static const char* const OB_SV_OPTIMIZER_CAPTURE_SQL_PLAN_BASELINES = "optimizer_capture_sql_plan_baselines";
  static const char* const OB_SV_PARALLEL_SERVERS_TARGET = "parallel_servers_target";
  static const char* const OB_SV_EARLY_LOCK_RELEASE = "ob_early_lock_release";
  static const char* const OB_SV_TRX_IDLE_TIMEOUT = "ob_trx_idle_timeout";
  static const char* const OB_SV_BLOCK_ENCRYPTION_MODE = "block_encryption_mode";
  static const char* const OB_SV_NLS_DATE_FORMAT = "nls_date_format";
  static const char* const OB_SV_NLS_TIMESTAMP_FORMAT = "nls_timestamp_format";
  static const char* const OB_SV_NLS_TIMESTAMP_TZ_FORMAT = "nls_timestamp_tz_format";
  static const char* const OB_SV_RESERVED_META_MEMORY_PERCENTAGE = "ob_reserved_meta_memory_percentage";
  static const char* const OB_SV_CHECK_SYS_VARIABLE = "ob_check_sys_variable";
  static const char* const OB_SV_NLS_LANGUAGE = "nls_language";
  static const char* const OB_SV_NLS_TERRITORY = "nls_territory";
  static const char* const OB_SV_NLS_SORT = "nls_sort";
  static const char* const OB_SV_NLS_COMP = "nls_comp";
  static const char* const OB_SV_NLS_CHARACTERSET = "nls_characterset";
  static const char* const OB_SV_NLS_NCHAR_CHARACTERSET = "nls_nchar_characterset";
  static const char* const OB_SV_NLS_DATE_LANGUAGE = "nls_date_language";
  static const char* const OB_SV_NLS_LENGTH_SEMANTICS = "nls_length_semantics";
  static const char* const OB_SV_NLS_NCHAR_CONV_EXCP = "nls_nchar_conv_excp";
  static const char* const OB_SV_NLS_CALENDAR = "nls_calendar";
  static const char* const OB_SV_NLS_NUMERIC_CHARACTERS = "nls_numeric_characters";
  static const char* const OB_SV__NLJ_BATCHING_ENABLED = "_nlj_batching_enabled";
  static const char* const OB_SV_TRACEFILE_IDENTIFIER = "tracefile_identifier";
  static const char* const OB_SV__GROUPBY_NOPUSHDOWN_CUT_RATIO = "_groupby_nopushdown_cut_ratio";
  static const char* const OB_SV__PX_BROADCAST_FUDGE_FACTOR = "_px_broadcast_fudge_factor";
  static const char* const OB_SV_TRANSACTION_ISOLATION = "transaction_isolation";
  static const char* const OB_SV_TRX_LOCK_TIMEOUT = "ob_trx_lock_timeout";
  static const char* const OB_SV_VALIDATE_PASSWORD_CHECK_USER_NAME = "validate_password_check_user_name";
  static const char* const OB_SV_VALIDATE_PASSWORD_LENGTH = "validate_password_length";
  static const char* const OB_SV_VALIDATE_PASSWORD_MIXED_CASE_COUNT = "validate_password_mixed_case_count";
  static const char* const OB_SV_VALIDATE_PASSWORD_NUMBER_COUNT = "validate_password_number_count";
  static const char* const OB_SV_VALIDATE_PASSWORD_POLICY = "validate_password_policy";
  static const char* const OB_SV_VALIDATE_PASSWORD_SPECIAL_CHAR_COUNT = "validate_password_special_char_count";
  static const char* const OB_SV_DEFAULT_PASSWORD_LIFETIME = "default_password_lifetime";
  static const char* const OB_SV__OB_OLS_POLICY_SESSION_LABELS = "_ob_ols_policy_session_labels";
  static const char* const OB_SV_TRACE_INFO = "ob_trace_info";
  static const char* const OB_SV__PX_PARTITION_SCAN_THRESHOLD = "_px_partition_scan_threshold";
  static const char* const OB_SV__OB_PX_BCAST_OPTIMIZATION = "_ob_px_bcast_optimization";
  static const char* const OB_SV__OB_PX_SLAVE_MAPPING_THRESHOLD = "_ob_px_slave_mapping_threshold";
  static const char* const OB_SV__ENABLE_PARALLEL_DML = "_enable_parallel_dml";
  static const char* const OB_SV__PX_MIN_GRANULES_PER_SLAVE = "_px_min_granules_per_slave";
  static const char* const OB_SV_SECURE_FILE_PRIV = "secure_file_priv";
  static const char* const OB_SV_PLSQL_WARNINGS = "plsql_warnings";
  static const char* const OB_SV__ENABLE_PARALLEL_QUERY = "_enable_parallel_query";
  static const char* const OB_SV__FORCE_PARALLEL_QUERY_DOP = "_force_parallel_query_dop";
  static const char* const OB_SV__FORCE_PARALLEL_DML_DOP = "_force_parallel_dml_dop";
  static const char* const OB_SV_PL_BLOCK_TIMEOUT = "ob_pl_block_timeout";
  static const char* const OB_SV_TRANSACTION_READ_ONLY = "transaction_read_only";
  static const char* const OB_SV_RESOURCE_MANAGER_PLAN = "resource_manager_plan";
  static const char* const OB_SV_PERFORMANCE_SCHEMA = "performance_schema";
  static const char* const OB_SV_NLS_CURRENCY = "nls_currency";
  static const char* const OB_SV_NLS_ISO_CURRENCY = "nls_iso_currency";
  static const char* const OB_SV_NLS_DUAL_CURRENCY = "nls_dual_currency";
  static const char* const OB_SV_PLSQL_CCFLAGS = "plsql_ccflags";
  static const char* const OB_SV__OB_PROXY_SESSION_TEMPORARY_TABLE_USED = "_ob_proxy_session_temporary_table_used";
  static const char* const OB_SV__ENABLE_PARALLEL_DDL = "_enable_parallel_ddl";
  static const char* const OB_SV__FORCE_PARALLEL_DDL_DOP = "_force_parallel_ddl_dop";
  static const char* const OB_SV_CURSOR_SHARING = "cursor_sharing";
  static const char* const OB_SV__OPTIMIZER_NULL_AWARE_ANTIJOIN = "_optimizer_null_aware_antijoin";
  static const char* const OB_SV__PX_PARTIAL_ROLLUP_PUSHDOWN = "_px_partial_rollup_pushdown";
  static const char* const OB_SV__PX_DIST_AGG_PARTIAL_ROLLUP_PUSHDOWN = "_px_dist_agg_partial_rollup_pushdown";
  static const char* const OB_SV__CREATE_AUDIT_PURGE_JOB = "_create_audit_purge_job";
  static const char* const OB_SV__DROP_AUDIT_PURGE_JOB = "_drop_audit_purge_job";
  static const char* const OB_SV__SET_PURGE_JOB_INTERVAL = "_set_purge_job_interval";
  static const char* const OB_SV__SET_PURGE_JOB_STATUS = "_set_purge_job_status";
  static const char* const OB_SV__SET_LAST_ARCHIVE_TIMESTAMP = "_set_last_archive_timestamp";
  static const char* const OB_SV__CLEAR_LAST_ARCHIVE_TIMESTAMP = "_clear_last_archive_timestamp";
  static const char* const OB_SV__AGGREGATION_OPTIMIZATION_SETTINGS = "_aggregation_optimization_settings";
  static const char* const OB_SV__PX_SHARED_HASH_JOIN = "_px_shared_hash_join";
  static const char* const OB_SV_SQL_NOTES = "sql_notes";
  static const char* const OB_SV_INNODB_STRICT_MODE = "innodb_strict_mode";
  static const char* const OB_SV__WINDOWFUNC_OPTIMIZATION_SETTINGS = "_windowfunc_optimization_settings";
  static const char* const OB_SV_ENABLE_RICH_ERROR_MSG = "ob_enable_rich_error_msg";
  static const char* const OB_SV_LOG_ROW_VALUE_OPTIONS = "log_row_value_options";
  static const char* const OB_SV_MAX_READ_STALE_TIME = "ob_max_read_stale_time";
  static const char* const OB_SV__OPTIMIZER_GATHER_STATS_ON_LOAD = "_optimizer_gather_stats_on_load";
  static const char* const OB_SV__SET_REVERSE_DBLINK_INFOS = "_set_reverse_dblink_infos";
  static const char* const OB_SV__FORCE_ORDER_PRESERVE_SET = "_force_order_preserve_set";
  static const char* const OB_SV__SHOW_DDL_IN_COMPAT_MODE = "_show_ddl_in_compat_mode";
  static const char* const OB_SV_PARALLEL_DEGREE_POLICY = "parallel_degree_policy";
  static const char* const OB_SV_PARALLEL_DEGREE_LIMIT = "parallel_degree_limit";
  static const char* const OB_SV_PARALLEL_MIN_SCAN_TIME_THRESHOLD = "parallel_min_scan_time_threshold";
  static const char* const OB_SV_OPTIMIZER_DYNAMIC_SAMPLING = "optimizer_dynamic_sampling";
  static const char* const OB_SV_RUNTIME_FILTER_TYPE = "runtime_filter_type";
  static const char* const OB_SV_RUNTIME_FILTER_WAIT_TIME_MS = "runtime_filter_wait_time_ms";
  static const char* const OB_SV_RUNTIME_FILTER_MAX_IN_NUM = "runtime_filter_max_in_num";
  static const char* const OB_SV_RUNTIME_BLOOM_FILTER_MAX_SIZE = "runtime_bloom_filter_max_size";
  static const char* const OB_SV_OPTIMIZER_FEATURES_ENABLE = "optimizer_features_enable";
  static const char* const OB_SV__OB_PROXY_WEAKREAD_FEEDBACK = "_ob_proxy_weakread_feedback";
  static const char* const OB_SV_NCHARACTER_SET_CONNECTION = "ncharacter_set_connection";
  static const char* const OB_SV_AUTOMATIC_SP_PRIVILEGES = "automatic_sp_privileges";
  static const char* const OB_SV_PRIVILEGE_FEATURES_ENABLE = "privilege_features_enable";
  static const char* const OB_SV__PRIV_CONTROL = "_priv_control";
  static const char* const OB_SV__ENABLE_MYSQL_PL_PRIV_CHECK = "_enable_mysql_pl_priv_check";
  static const char* const OB_SV_ENABLE_PL_CACHE = "ob_enable_pl_cache";
  static const char* const OB_SV_DEFAULT_LOB_INROW_THRESHOLD = "ob_default_lob_inrow_threshold";
  static const char* const OB_SV__ENABLE_STORAGE_CARDINALITY_ESTIMATION = "_enable_storage_cardinality_estimation";
  static const char* const OB_SV_LC_TIME_NAMES = "lc_time_names";
  static const char* const OB_SV_ACTIVATE_ALL_ROLES_ON_LOGIN = "activate_all_roles_on_login";
  static const char* const OB_SV__ENABLE_RICH_VECTOR_FORMAT = "_enable_rich_vector_format";
  static const char* const OB_SV_INNODB_STATS_PERSISTENT = "innodb_stats_persistent";
  static const char* const OB_SV_DEBUG = "debug";
  static const char* const OB_SV_INNODB_CHANGE_BUFFERING_DEBUG = "innodb_change_buffering_debug";
  static const char* const OB_SV_INNODB_COMPRESS_DEBUG = "innodb_compress_debug";
  static const char* const OB_SV_INNODB_DISABLE_RESIZE_BUFFER_POOL_DEBUG = "innodb_disable_resize_buffer_pool_debug";
  static const char* const OB_SV_INNODB_FIL_MAKE_PAGE_DIRTY_DEBUG = "innodb_fil_make_page_dirty_debug";
  static const char* const OB_SV_INNODB_LIMIT_OPTIMISTIC_INSERT_DEBUG = "innodb_limit_optimistic_insert_debug";
  static const char* const OB_SV_INNODB_MERGE_THRESHOLD_SET_ALL_DEBUG = "innodb_merge_threshold_set_all_debug";
  static const char* const OB_SV_INNODB_SAVED_PAGE_NUMBER_DEBUG = "innodb_saved_page_number_debug";
  static const char* const OB_SV_INNODB_TRX_PURGE_VIEW_UPDATE_ONLY_DEBUG = "innodb_trx_purge_view_update_only_debug";
  static const char* const OB_SV_INNODB_TRX_RSEG_N_SLOTS_DEBUG = "innodb_trx_rseg_n_slots_debug";
  static const char* const OB_SV_STORED_PROGRAM_CACHE = "stored_program_cache";
  static const char* const OB_SV_COMPATIBILITY_CONTROL = "ob_compatibility_control";
  static const char* const OB_SV_COMPATIBILITY_VERSION = "ob_compatibility_version";
  static const char* const OB_SV_SECURITY_VERSION = "ob_security_version";
  static const char* const OB_SV_CARDINALITY_ESTIMATION_MODEL = "cardinality_estimation_model";
  static const char* const OB_SV_QUERY_REWRITE_ENABLED = "query_rewrite_enabled";
  static const char* const OB_SV_QUERY_REWRITE_INTEGRITY = "query_rewrite_integrity";
  static const char* const OB_SV_FLUSH = "flush";
  static const char* const OB_SV_FLUSH_TIME = "flush_time";
  static const char* const OB_SV_INNODB_ADAPTIVE_FLUSHING = "innodb_adaptive_flushing";
  static const char* const OB_SV_INNODB_ADAPTIVE_FLUSHING_LWM = "innodb_adaptive_flushing_lwm";
  static const char* const OB_SV_INNODB_ADAPTIVE_HASH_INDEX = "innodb_adaptive_hash_index";
  static const char* const OB_SV_INNODB_ADAPTIVE_HASH_INDEX_PARTS = "innodb_adaptive_hash_index_parts";
  static const char* const OB_SV_INNODB_ADAPTIVE_MAX_SLEEP_DELAY = "innodb_adaptive_max_sleep_delay";
  static const char* const OB_SV_INNODB_AUTOEXTEND_INCREMENT = "innodb_autoextend_increment";
  static const char* const OB_SV_INNODB_BACKGROUND_DROP_LIST_EMPTY = "innodb_background_drop_list_empty";
  static const char* const OB_SV_INNODB_BUFFER_POOL_DUMP_AT_SHUTDOWN = "innodb_buffer_pool_dump_at_shutdown";
  static const char* const OB_SV_INNODB_BUFFER_POOL_DUMP_NOW = "innodb_buffer_pool_dump_now";
  static const char* const OB_SV_INNODB_BUFFER_POOL_DUMP_PCT = "innodb_buffer_pool_dump_pct";
  static const char* const OB_SV_INNODB_BUFFER_POOL_FILENAME = "innodb_buffer_pool_filename";
  static const char* const OB_SV_INNODB_BUFFER_POOL_LOAD_ABORT = "innodb_buffer_pool_load_abort";
  static const char* const OB_SV_INNODB_BUFFER_POOL_LOAD_NOW = "innodb_buffer_pool_load_now";
  static const char* const OB_SV_INNODB_BUFFER_POOL_SIZE = "innodb_buffer_pool_size";
  static const char* const OB_SV_INNODB_CHANGE_BUFFER_MAX_SIZE = "innodb_change_buffer_max_size";
  static const char* const OB_SV_INNODB_CHANGE_BUFFERING = "innodb_change_buffering";
  static const char* const OB_SV_INNODB_CHECKSUM_ALGORITHM = "innodb_checksum_algorithm";
  static const char* const OB_SV_INNODB_CMP_PER_INDEX_ENABLED = "innodb_cmp_per_index_enabled";
  static const char* const OB_SV_INNODB_COMMIT_CONCURRENCY = "innodb_commit_concurrency";
  static const char* const OB_SV_INNODB_COMPRESSION_FAILURE_THRESHOLD_PCT = "innodb_compression_failure_threshold_pct";
  static const char* const OB_SV_INNODB_COMPRESSION_LEVEL = "innodb_compression_level";
  static const char* const OB_SV_INNODB_COMPRESSION_PAD_PCT_MAX = "innodb_compression_pad_pct_max";
  static const char* const OB_SV_INNODB_CONCURRENCY_TICKETS = "innodb_concurrency_tickets";
  static const char* const OB_SV_INNODB_DEFAULT_ROW_FORMAT = "innodb_default_row_format";
  static const char* const OB_SV_INNODB_DISABLE_SORT_FILE_CACHE = "innodb_disable_sort_file_cache";
  static const char* const OB_SV_INNODB_FILE_FORMAT = "innodb_file_format";
  static const char* const OB_SV_INNODB_FILE_FORMAT_MAX = "innodb_file_format_max";
  static const char* const OB_SV_INNODB_FILE_PER_TABLE = "innodb_file_per_table";
  static const char* const OB_SV_INNODB_FILL_FACTOR = "innodb_fill_factor";
  static const char* const OB_SV_INNODB_FLUSH_NEIGHBORS = "innodb_flush_neighbors";
  static const char* const OB_SV_INNODB_FLUSH_SYNC = "innodb_flush_sync";
  static const char* const OB_SV_INNODB_FLUSHING_AVG_LOOPS = "innodb_flushing_avg_loops";
  static const char* const OB_SV_INNODB_LRU_SCAN_DEPTH = "innodb_lru_scan_depth";
  static const char* const OB_SV_INNODB_MAX_DIRTY_PAGES_PCT = "innodb_max_dirty_pages_pct";
  static const char* const OB_SV_INNODB_MAX_DIRTY_PAGES_PCT_LWM = "innodb_max_dirty_pages_pct_lwm";
  static const char* const OB_SV_INNODB_MAX_PURGE_LAG = "innodb_max_purge_lag";
  static const char* const OB_SV_INNODB_MAX_PURGE_LAG_DELAY = "innodb_max_purge_lag_delay";
  static const char* const OB_SV_HAVE_SYMLINK = "have_symlink";
  static const char* const OB_SV_IGNORE_BUILTIN_INNODB = "ignore_builtin_innodb";
  static const char* const OB_SV_INNODB_BUFFER_POOL_CHUNK_SIZE = "innodb_buffer_pool_chunk_size";
  static const char* const OB_SV_INNODB_BUFFER_POOL_INSTANCES = "innodb_buffer_pool_instances";
  static const char* const OB_SV_INNODB_BUFFER_POOL_LOAD_AT_STARTUP = "innodb_buffer_pool_load_at_startup";
  static const char* const OB_SV_INNODB_CHECKSUMS = "innodb_checksums";
  static const char* const OB_SV_INNODB_DOUBLEWRITE = "innodb_doublewrite";
  static const char* const OB_SV_INNODB_FILE_FORMAT_CHECK = "innodb_file_format_check";
  static const char* const OB_SV_INNODB_FLUSH_METHOD = "innodb_flush_method";
  static const char* const OB_SV_INNODB_FORCE_LOAD_CORRUPTED = "innodb_force_load_corrupted";
  static const char* const OB_SV_INNODB_PAGE_SIZE = "innodb_page_size";
  static const char* const OB_SV_INNODB_VERSION = "innodb_version";
  static const char* const OB_SV_MYISAM_MMAP_SIZE = "myisam_mmap_size";
  static const char* const OB_SV_TABLE_OPEN_CACHE_INSTANCES = "table_open_cache_instances";
  static const char* const OB_SV_GTID_EXECUTED = "gtid_executed";
  static const char* const OB_SV_GTID_OWNED = "gtid_owned";
  static const char* const OB_SV_INNODB_ROLLBACK_ON_TIMEOUT = "innodb_rollback_on_timeout";
  static const char* const OB_SV_COMPLETION_TYPE = "completion_type";
  static const char* const OB_SV_ENFORCE_GTID_CONSISTENCY = "enforce_gtid_consistency";
  static const char* const OB_SV_GTID_EXECUTED_COMPRESSION_PERIOD = "gtid_executed_compression_period";
  static const char* const OB_SV_GTID_MODE = "gtid_mode";
  static const char* const OB_SV_GTID_NEXT = "gtid_next";
  static const char* const OB_SV_GTID_PURGED = "gtid_purged";
  static const char* const OB_SV_INNODB_API_BK_COMMIT_INTERVAL = "innodb_api_bk_commit_interval";
  static const char* const OB_SV_INNODB_API_TRX_LEVEL = "innodb_api_trx_level";
  static const char* const OB_SV_INNODB_SUPPORT_XA = "innodb_support_xa";
  static const char* const OB_SV_SESSION_TRACK_GTIDS = "session_track_gtids";
  static const char* const OB_SV_SESSION_TRACK_TRANSACTION_INFO = "session_track_transaction_info";
  static const char* const OB_SV_TRANSACTION_ALLOC_BLOCK_SIZE = "transaction_alloc_block_size";
  static const char* const OB_SV_TRANSACTION_ALLOW_BATCHING = "transaction_allow_batching";
  static const char* const OB_SV_TRANSACTION_PREALLOC_SIZE = "transaction_prealloc_size";
  static const char* const OB_SV_TRANSACTION_WRITE_SET_EXTRACTION = "transaction_write_set_extraction";
  static const char* const OB_SV_INFORMATION_SCHEMA_STATS_EXPIRY = "information_schema_stats_expiry";
  static const char* const OB_SV__ORACLE_SQL_SELECT_LIMIT = "_oracle_sql_select_limit";
  static const char* const OB_SV_GROUP_REPLICATION_ALLOW_LOCAL_DISJOINT_GTIDS_JOIN = "group_replication_allow_local_disjoint_gtids_join";
  static const char* const OB_SV_GROUP_REPLICATION_ALLOW_LOCAL_LOWER_VERSION_JOIN = "group_replication_allow_local_lower_version_join";
  static const char* const OB_SV_GROUP_REPLICATION_AUTO_INCREMENT_INCREMENT = "group_replication_auto_increment_increment";
  static const char* const OB_SV_GROUP_REPLICATION_BOOTSTRAP_GROUP = "group_replication_bootstrap_group";
  static const char* const OB_SV_GROUP_REPLICATION_COMPONENTS_STOP_TIMEOUT = "group_replication_components_stop_timeout";
  static const char* const OB_SV_GROUP_REPLICATION_COMPRESSION_THRESHOLD = "group_replication_compression_threshold";
  static const char* const OB_SV_GROUP_REPLICATION_ENFORCE_UPDATE_EVERYWHERE_CHECKS = "group_replication_enforce_update_everywhere_checks";
  static const char* const OB_SV_GROUP_REPLICATION_EXIT_STATE_ACTION = "group_replication_exit_state_action";
  static const char* const OB_SV_GROUP_REPLICATION_FLOW_CONTROL_APPLIER_THRESHOLD = "group_replication_flow_control_applier_threshold";
  static const char* const OB_SV_GROUP_REPLICATION_FLOW_CONTROL_CERTIFIER_THRESHOLD = "group_replication_flow_control_certifier_threshold";
  static const char* const OB_SV_GROUP_REPLICATION_FLOW_CONTROL_MODE = "group_replication_flow_control_mode";
  static const char* const OB_SV_GROUP_REPLICATION_FORCE_MEMBERS = "group_replication_force_members";
  static const char* const OB_SV_GROUP_REPLICATION_GROUP_NAME = "group_replication_group_name";
  static const char* const OB_SV_GROUP_REPLICATION_GTID_ASSIGNMENT_BLOCK_SIZE = "group_replication_gtid_assignment_block_size";
  static const char* const OB_SV_GROUP_REPLICATION_IP_WHITELIST = "group_replication_ip_whitelist";
  static const char* const OB_SV_GROUP_REPLICATION_LOCAL_ADDRESS = "group_replication_local_address";
  static const char* const OB_SV_GROUP_REPLICATION_MEMBER_WEIGHT = "group_replication_member_weight";
  static const char* const OB_SV_GROUP_REPLICATION_POLL_SPIN_LOOPS = "group_replication_poll_spin_loops";
  static const char* const OB_SV_GROUP_REPLICATION_RECOVERY_COMPLETE_AT = "group_replication_recovery_complete_at";
  static const char* const OB_SV_GROUP_REPLICATION_RECOVERY_RECONNECT_INTERVAL = "group_replication_recovery_reconnect_interval";
  static const char* const OB_SV_GROUP_REPLICATION_RECOVERY_RETRY_COUNT = "group_replication_recovery_retry_count";
  static const char* const OB_SV_GROUP_REPLICATION_RECOVERY_SSL_CA = "group_replication_recovery_ssl_ca";
  static const char* const OB_SV_GROUP_REPLICATION_RECOVERY_SSL_CAPATH = "group_replication_recovery_ssl_capath";
  static const char* const OB_SV_GROUP_REPLICATION_RECOVERY_SSL_CERT = "group_replication_recovery_ssl_cert";
  static const char* const OB_SV_GROUP_REPLICATION_RECOVERY_SSL_CIPHER = "group_replication_recovery_ssl_cipher";
  static const char* const OB_SV_GROUP_REPLICATION_RECOVERY_SSL_CRL = "group_replication_recovery_ssl_crl";
  static const char* const OB_SV_GROUP_REPLICATION_RECOVERY_SSL_CRLPATH = "group_replication_recovery_ssl_crlpath";
  static const char* const OB_SV_GROUP_REPLICATION_RECOVERY_SSL_KEY = "group_replication_recovery_ssl_key";
  static const char* const OB_SV_GROUP_REPLICATION_RECOVERY_SSL_VERIFY_SERVER_CERT = "group_replication_recovery_ssl_verify_server_cert";
  static const char* const OB_SV_GROUP_REPLICATION_RECOVERY_USE_SSL = "group_replication_recovery_use_ssl";
  static const char* const OB_SV_GROUP_REPLICATION_SINGLE_PRIMARY_MODE = "group_replication_single_primary_mode";
  static const char* const OB_SV_GROUP_REPLICATION_SSL_MODE = "group_replication_ssl_mode";
  static const char* const OB_SV_GROUP_REPLICATION_START_ON_BOOT = "group_replication_start_on_boot";
  static const char* const OB_SV_GROUP_REPLICATION_TRANSACTION_SIZE_LIMIT = "group_replication_transaction_size_limit";
  static const char* const OB_SV_GROUP_REPLICATION_UNREACHABLE_MAJORITY_TIMEOUT = "group_replication_unreachable_majority_timeout";
  static const char* const OB_SV_INNODB_REPLICATION_DELAY = "innodb_replication_delay";
  static const char* const OB_SV_MASTER_INFO_REPOSITORY = "master_info_repository";
  static const char* const OB_SV_MASTER_VERIFY_CHECKSUM = "master_verify_checksum";
  static const char* const OB_SV_PSEUDO_SLAVE_MODE = "pseudo_slave_mode";
  static const char* const OB_SV_PSEUDO_THREAD_ID = "pseudo_thread_id";
  static const char* const OB_SV_RBR_EXEC_MODE = "rbr_exec_mode";
  static const char* const OB_SV_REPLICATION_OPTIMIZE_FOR_STATIC_PLUGIN_CONFIG = "replication_optimize_for_static_plugin_config";
  static const char* const OB_SV_REPLICATION_SENDER_OBSERVE_COMMIT_ONLY = "replication_sender_observe_commit_only";
  static const char* const OB_SV_RPL_SEMI_SYNC_MASTER_ENABLED = "rpl_semi_sync_master_enabled";
  static const char* const OB_SV_RPL_SEMI_SYNC_MASTER_TIMEOUT = "rpl_semi_sync_master_timeout";
  static const char* const OB_SV_RPL_SEMI_SYNC_MASTER_TRACE_LEVEL = "rpl_semi_sync_master_trace_level";
  static const char* const OB_SV_RPL_SEMI_SYNC_MASTER_WAIT_FOR_SLAVE_COUNT = "rpl_semi_sync_master_wait_for_slave_count";
  static const char* const OB_SV_RPL_SEMI_SYNC_MASTER_WAIT_NO_SLAVE = "rpl_semi_sync_master_wait_no_slave";
  static const char* const OB_SV_RPL_SEMI_SYNC_MASTER_WAIT_POINT = "rpl_semi_sync_master_wait_point";
  static const char* const OB_SV_RPL_SEMI_SYNC_SLAVE_ENABLED = "rpl_semi_sync_slave_enabled";
  static const char* const OB_SV_RPL_SEMI_SYNC_SLAVE_TRACE_LEVEL = "rpl_semi_sync_slave_trace_level";
  static const char* const OB_SV_RPL_STOP_SLAVE_TIMEOUT = "rpl_stop_slave_timeout";
  static const char* const OB_SV_SLAVE_ALLOW_BATCHING = "slave_allow_batching";
  static const char* const OB_SV_SLAVE_CHECKPOINT_GROUP = "slave_checkpoint_group";
  static const char* const OB_SV_SLAVE_CHECKPOINT_PERIOD = "slave_checkpoint_period";
  static const char* const OB_SV_SLAVE_COMPRESSED_PROTOCOL = "slave_compressed_protocol";
  static const char* const OB_SV_SLAVE_EXEC_MODE = "slave_exec_mode";
  static const char* const OB_SV_SLAVE_MAX_ALLOWED_PACKET = "slave_max_allowed_packet";
  static const char* const OB_SV_SLAVE_NET_TIMEOUT = "slave_net_timeout";
  static const char* const OB_SV_SLAVE_PARALLEL_TYPE = "slave_parallel_type";
  static const char* const OB_SV_SLAVE_PARALLEL_WORKERS = "slave_parallel_workers";
  static const char* const OB_SV_SLAVE_PENDING_JOBS_SIZE_MAX = "slave_pending_jobs_size_max";
  static const char* const OB_SV_SLAVE_PRESERVE_COMMIT_ORDER = "slave_preserve_commit_order";
  static const char* const OB_SV_SLAVE_SQL_VERIFY_CHECKSUM = "slave_sql_verify_checksum";
  static const char* const OB_SV_SLAVE_TRANSACTION_RETRIES = "slave_transaction_retries";
  static const char* const OB_SV_SQL_SLAVE_SKIP_COUNTER = "sql_slave_skip_counter";
  static const char* const OB_SV_INNODB_FORCE_RECOVERY = "innodb_force_recovery";
  static const char* const OB_SV_SKIP_SLAVE_START = "skip_slave_start";
  static const char* const OB_SV_SLAVE_LOAD_TMPDIR = "slave_load_tmpdir";
  static const char* const OB_SV_SLAVE_SKIP_ERRORS = "slave_skip_errors";
  static const char* const OB_SV_INNODB_SYNC_DEBUG = "innodb_sync_debug";
  static const char* const OB_SV_DEFAULT_COLLATION_FOR_UTF8MB4 = "default_collation_for_utf8mb4";
  static const char* const OB_SV__ENABLE_OLD_CHARSET_AGGREGATION = "_enable_old_charset_aggregation";
  static const char* const OB_SV_ENABLE_SQL_PLAN_MONITOR = "enable_sql_plan_monitor";
  static const char* const OB_SV_INSERT_ID = "insert_id";
  static const char* const OB_SV_JOIN_BUFFER_SIZE = "join_buffer_size";
  static const char* const OB_SV_MAX_JOIN_SIZE = "max_join_size";
  static const char* const OB_SV_MAX_LENGTH_FOR_SORT_DATA = "max_length_for_sort_data";
  static const char* const OB_SV_MAX_PREPARED_STMT_COUNT = "max_prepared_stmt_count";
  static const char* const OB_SV_MAX_SORT_LENGTH = "max_sort_length";
  static const char* const OB_SV_MIN_EXAMINED_ROW_LIMIT = "min_examined_row_limit";
  static const char* const OB_SV_MULTI_RANGE_COUNT = "multi_range_count";
  static const char* const OB_SV_MYSQLX_CONNECT_TIMEOUT = "mysqlx_connect_timeout";
  static const char* const OB_SV_MYSQLX_IDLE_WORKER_THREAD_TIMEOUT = "mysqlx_idle_worker_thread_timeout";
  static const char* const OB_SV_MYSQLX_MAX_ALLOWED_PACKET = "mysqlx_max_allowed_packet";
  static const char* const OB_SV_MYSQLX_MAX_CONNECTIONS = "mysqlx_max_connections";
  static const char* const OB_SV_MYSQLX_MIN_WORKER_THREADS = "mysqlx_min_worker_threads";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_SHOW_PROCESSLIST = "performance_schema_show_processlist";
  static const char* const OB_SV_QUERY_ALLOC_BLOCK_SIZE = "query_alloc_block_size";
  static const char* const OB_SV_QUERY_PREALLOC_SIZE = "query_prealloc_size";
  static const char* const OB_SV_SLOW_QUERY_LOG = "slow_query_log";
  static const char* const OB_SV_SLOW_QUERY_LOG_FILE = "slow_query_log_file";
  static const char* const OB_SV_SORT_BUFFER_SIZE = "sort_buffer_size";
  static const char* const OB_SV_SQL_BUFFER_RESULT = "sql_buffer_result";
  static const char* const OB_SV_BINLOG_CACHE_SIZE = "binlog_cache_size";
  static const char* const OB_SV_BINLOG_DIRECT_NON_TRANSACTIONAL_UPDATES = "binlog_direct_non_transactional_updates";
  static const char* const OB_SV_BINLOG_ERROR_ACTION = "binlog_error_action";
  static const char* const OB_SV_BINLOG_GROUP_COMMIT_SYNC_DELAY = "binlog_group_commit_sync_delay";
  static const char* const OB_SV_BINLOG_GROUP_COMMIT_SYNC_NO_DELAY_COUNT = "binlog_group_commit_sync_no_delay_count";
  static const char* const OB_SV_BINLOG_MAX_FLUSH_QUEUE_TIME = "binlog_max_flush_queue_time";
  static const char* const OB_SV_BINLOG_ORDER_COMMITS = "binlog_order_commits";
  static const char* const OB_SV_BINLOG_STMT_CACHE_SIZE = "binlog_stmt_cache_size";
  static const char* const OB_SV_BINLOG_TRANSACTION_DEPENDENCY_HISTORY_SIZE = "binlog_transaction_dependency_history_size";
  static const char* const OB_SV_BINLOG_TRANSACTION_DEPENDENCY_TRACKING = "binlog_transaction_dependency_tracking";
  static const char* const OB_SV_EXPIRE_LOGS_DAYS = "expire_logs_days";
  static const char* const OB_SV_INNODB_FLUSH_LOG_AT_TIMEOUT = "innodb_flush_log_at_timeout";
  static const char* const OB_SV_INNODB_FLUSH_LOG_AT_TRX_COMMIT = "innodb_flush_log_at_trx_commit";
  static const char* const OB_SV_INNODB_LOG_CHECKPOINT_NOW = "innodb_log_checkpoint_now";
  static const char* const OB_SV_INNODB_LOG_CHECKSUMS = "innodb_log_checksums";
  static const char* const OB_SV_INNODB_LOG_COMPRESSED_PAGES = "innodb_log_compressed_pages";
  static const char* const OB_SV_INNODB_LOG_WRITE_AHEAD_SIZE = "innodb_log_write_ahead_size";
  static const char* const OB_SV_INNODB_MAX_UNDO_LOG_SIZE = "innodb_max_undo_log_size";
  static const char* const OB_SV_INNODB_ONLINE_ALTER_LOG_MAX_SIZE = "innodb_online_alter_log_max_size";
  static const char* const OB_SV_INNODB_UNDO_LOG_TRUNCATE = "innodb_undo_log_truncate";
  static const char* const OB_SV_INNODB_UNDO_LOGS = "innodb_undo_logs";
  static const char* const OB_SV_LOG_BIN_TRUST_FUNCTION_CREATORS = "log_bin_trust_function_creators";
  static const char* const OB_SV_LOG_BIN_USE_V1_ROW_EVENTS = "log_bin_use_v1_row_events";
  static const char* const OB_SV_LOG_BUILTIN_AS_IDENTIFIED_BY_PASSWORD = "log_builtin_as_identified_by_password";
  static const char* const OB_SV_MAX_BINLOG_CACHE_SIZE = "max_binlog_cache_size";
  static const char* const OB_SV_MAX_BINLOG_SIZE = "max_binlog_size";
  static const char* const OB_SV_MAX_BINLOG_STMT_CACHE_SIZE = "max_binlog_stmt_cache_size";
  static const char* const OB_SV_MAX_RELAY_LOG_SIZE = "max_relay_log_size";
  static const char* const OB_SV_RELAY_LOG_INFO_REPOSITORY = "relay_log_info_repository";
  static const char* const OB_SV_RELAY_LOG_PURGE = "relay_log_purge";
  static const char* const OB_SV_SYNC_BINLOG = "sync_binlog";
  static const char* const OB_SV_SYNC_RELAY_LOG = "sync_relay_log";
  static const char* const OB_SV_SYNC_RELAY_LOG_INFO = "sync_relay_log_info";
  static const char* const OB_SV_INNODB_DEADLOCK_DETECT = "innodb_deadlock_detect";
  static const char* const OB_SV_INNODB_LOCK_WAIT_TIMEOUT = "innodb_lock_wait_timeout";
  static const char* const OB_SV_INNODB_PRINT_ALL_DEADLOCKS = "innodb_print_all_deadlocks";
  static const char* const OB_SV_INNODB_TABLE_LOCKS = "innodb_table_locks";
  static const char* const OB_SV_MAX_WRITE_LOCK_COUNT = "max_write_lock_count";
  static const char* const OB_SV__OB_ENABLE_ROLE_IDS = "_ob_enable_role_ids";
  static const char* const OB_SV_INNODB_READ_ONLY = "innodb_read_only";
  static const char* const OB_SV_INNODB_API_DISABLE_ROWLOCK = "innodb_api_disable_rowlock";
  static const char* const OB_SV_INNODB_AUTOINC_LOCK_MODE = "innodb_autoinc_lock_mode";
  static const char* const OB_SV_SKIP_EXTERNAL_LOCKING = "skip_external_locking";
  static const char* const OB_SV_SUPER_READ_ONLY = "super_read_only";
  static const char* const OB_SV_PLSQL_OPTIMIZE_LEVEL = "plsql_optimize_level";
  static const char* const OB_SV_LOW_PRIORITY_UPDATES = "low_priority_updates";
  static const char* const OB_SV_MAX_ERROR_COUNT = "max_error_count";
  static const char* const OB_SV_MAX_INSERT_DELAYED_THREADS = "max_insert_delayed_threads";
  static const char* const OB_SV_FT_STOPWORD_FILE = "ft_stopword_file";
  static const char* const OB_SV_INNODB_FT_CACHE_SIZE = "innodb_ft_cache_size";
  static const char* const OB_SV_INNODB_FT_SORT_PLL_DEGREE = "innodb_ft_sort_pll_degree";
  static const char* const OB_SV_INNODB_FT_TOTAL_CACHE_SIZE = "innodb_ft_total_cache_size";
  static const char* const OB_SV_MECAB_RC_FILE = "mecab_rc_file";
  static const char* const OB_SV_METADATA_LOCKS_CACHE_SIZE = "metadata_locks_cache_size";
  static const char* const OB_SV_METADATA_LOCKS_HASH_INSTANCES = "metadata_locks_hash_instances";
  static const char* const OB_SV_INNODB_TEMP_DATA_FILE_PATH = "innodb_temp_data_file_path";
  static const char* const OB_SV_INNODB_DATA_FILE_PATH = "innodb_data_file_path";
  static const char* const OB_SV_INNODB_DATA_HOME_DIR = "innodb_data_home_dir";
  static const char* const OB_SV_AVOID_TEMPORAL_UPGRADE = "avoid_temporal_upgrade";
  static const char* const OB_SV_DEFAULT_TMP_STORAGE_ENGINE = "default_tmp_storage_engine";
  static const char* const OB_SV_INNODB_FT_ENABLE_DIAG_PRINT = "innodb_ft_enable_diag_print";
  static const char* const OB_SV_INNODB_FT_NUM_WORD_OPTIMIZE = "innodb_ft_num_word_optimize";
  static const char* const OB_SV_INNODB_FT_RESULT_CACHE_LIMIT = "innodb_ft_result_cache_limit";
  static const char* const OB_SV_INNODB_FT_SERVER_STOPWORD_TABLE = "innodb_ft_server_stopword_table";
  static const char* const OB_SV_INNODB_OPTIMIZE_FULLTEXT_ONLY = "innodb_optimize_fulltext_only";
  static const char* const OB_SV_MAX_TMP_TABLES = "max_tmp_tables";
  static const char* const OB_SV_INNODB_TMPDIR = "innodb_tmpdir";
  static const char* const OB_SV_GROUP_REPLICATION_GROUP_SEEDS = "group_replication_group_seeds";
  static const char* const OB_SV_SLAVE_ROWS_SEARCH_ALGORITHMS = "slave_rows_search_algorithms";
  static const char* const OB_SV_SLAVE_TYPE_CONVERSIONS = "slave_type_conversions";
  static const char* const OB_SV_HNSW_EF_SEARCH = "ob_hnsw_ef_search";
  static const char* const OB_SV_NDB_ALLOW_COPYING_ALTER_TABLE = "ndb_allow_copying_alter_table";
  static const char* const OB_SV_NDB_AUTOINCREMENT_PREFETCH_SZ = "ndb_autoincrement_prefetch_sz";
  static const char* const OB_SV_NDB_BLOB_READ_BATCH_BYTES = "ndb_blob_read_batch_bytes";
  static const char* const OB_SV_NDB_BLOB_WRITE_BATCH_BYTES = "ndb_blob_write_batch_bytes";
  static const char* const OB_SV_NDB_CACHE_CHECK_TIME = "ndb_cache_check_time";
  static const char* const OB_SV_NDB_CLEAR_APPLY_STATUS = "ndb_clear_apply_status";
  static const char* const OB_SV_NDB_DATA_NODE_NEIGHBOUR = "ndb_data_node_neighbour";
  static const char* const OB_SV_NDB_DEFAULT_COLUMN_FORMAT = "ndb_default_column_format";
  static const char* const OB_SV_NDB_DEFERRED_CONSTRAINTS = "ndb_deferred_constraints";
  static const char* const OB_SV_NDB_DISTRIBUTION = "ndb_distribution";
  static const char* const OB_SV_NDB_EVENTBUFFER_FREE_PERCENT = "ndb_eventbuffer_free_percent";
  static const char* const OB_SV_NDB_EVENTBUFFER_MAX_ALLOC = "ndb_eventbuffer_max_alloc";
  static const char* const OB_SV_NDB_EXTRA_LOGGING = "ndb_extra_logging";
  static const char* const OB_SV_NDB_FORCE_SEND = "ndb_force_send";
  static const char* const OB_SV_NDB_FULLY_REPLICATED = "ndb_fully_replicated";
  static const char* const OB_SV_NDB_INDEX_STAT_ENABLE = "ndb_index_stat_enable";
  static const char* const OB_SV_NDB_INDEX_STAT_OPTION = "ndb_index_stat_option";
  static const char* const OB_SV_NDB_JOIN_PUSHDOWN = "ndb_join_pushdown";
  static const char* const OB_SV_NDB_LOG_BINLOG_INDEX = "ndb_log_binlog_index";
  static const char* const OB_SV_NDB_LOG_EMPTY_EPOCHS = "ndb_log_empty_epochs";
  static const char* const OB_SV_NDB_LOG_EMPTY_UPDATE = "ndb_log_empty_update";
  static const char* const OB_SV_NDB_LOG_EXCLUSIVE_READS = "ndb_log_exclusive_reads";
  static const char* const OB_SV_NDB_LOG_UPDATE_AS_WRITE = "ndb_log_update_as_write";
  static const char* const OB_SV_NDB_LOG_UPDATE_MINIMAL = "ndb_log_update_minimal";
  static const char* const OB_SV_NDB_LOG_UPDATED_ONLY = "ndb_log_updated_only";
  static const char* const OB_SV_NDB_OPTIMIZATION_DELAY = "ndb_optimization_delay";
  static const char* const OB_SV_NDB_READ_BACKUP = "ndb_read_backup";
  static const char* const OB_SV_NDB_RECV_THREAD_ACTIVATION_THRESHOLD = "ndb_recv_thread_activation_threshold";
  static const char* const OB_SV_NDB_RECV_THREAD_CPU_MASK = "ndb_recv_thread_cpu_mask";
  static const char* const OB_SV_NDB_REPORT_THRESH_BINLOG_EPOCH_SLIP = "ndb_report_thresh_binlog_epoch_slip";
  static const char* const OB_SV_NDB_REPORT_THRESH_BINLOG_MEM_USAGE = "ndb_report_thresh_binlog_mem_usage";
  static const char* const OB_SV_NDB_ROW_CHECKSUM = "ndb_row_checksum";
  static const char* const OB_SV_NDB_SHOW_FOREIGN_KEY_MOCK_TABLES = "ndb_show_foreign_key_mock_tables";
  static const char* const OB_SV_NDB_SLAVE_CONFLICT_ROLE = "ndb_slave_conflict_role";
  static const char* const OB_SV_NDB_TABLE_NO_LOGGING = "ndb_table_no_logging";
  static const char* const OB_SV_NDB_TABLE_TEMPORARY = "ndb_table_temporary";
  static const char* const OB_SV_NDB_USE_EXACT_COUNT = "ndb_use_exact_count";
  static const char* const OB_SV_NDB_USE_TRANSACTIONS = "ndb_use_transactions";
  static const char* const OB_SV_NDBINFO_MAX_BYTES = "ndbinfo_max_bytes";
  static const char* const OB_SV_NDBINFO_MAX_ROWS = "ndbinfo_max_rows";
  static const char* const OB_SV_NDBINFO_OFFLINE = "ndbinfo_offline";
  static const char* const OB_SV_NDBINFO_SHOW_HIDDEN = "ndbinfo_show_hidden";
  static const char* const OB_SV_MYISAM_DATA_POINTER_SIZE = "myisam_data_pointer_size";
  static const char* const OB_SV_MYISAM_MAX_SORT_FILE_SIZE = "myisam_max_sort_file_size";
  static const char* const OB_SV_MYISAM_REPAIR_THREADS = "myisam_repair_threads";
  static const char* const OB_SV_MYISAM_SORT_BUFFER_SIZE = "myisam_sort_buffer_size";
  static const char* const OB_SV_MYISAM_STATS_METHOD = "myisam_stats_method";
  static const char* const OB_SV_MYISAM_USE_MMAP = "myisam_use_mmap";
  static const char* const OB_SV_PRELOAD_BUFFER_SIZE = "preload_buffer_size";
  static const char* const OB_SV_READ_BUFFER_SIZE = "read_buffer_size";
  static const char* const OB_SV_READ_RND_BUFFER_SIZE = "read_rnd_buffer_size";
  static const char* const OB_SV_SYNC_FRM = "sync_frm";
  static const char* const OB_SV_SYNC_MASTER_INFO = "sync_master_info";
  static const char* const OB_SV_TABLE_OPEN_CACHE = "table_open_cache";
  static const char* const OB_SV_INNODB_MONITOR_DISABLE = "innodb_monitor_disable";
  static const char* const OB_SV_INNODB_MONITOR_ENABLE = "innodb_monitor_enable";
  static const char* const OB_SV_INNODB_MONITOR_RESET = "innodb_monitor_reset";
  static const char* const OB_SV_INNODB_MONITOR_RESET_ALL = "innodb_monitor_reset_all";
  static const char* const OB_SV_INNODB_OLD_BLOCKS_PCT = "innodb_old_blocks_pct";
  static const char* const OB_SV_INNODB_OLD_BLOCKS_TIME = "innodb_old_blocks_time";
  static const char* const OB_SV_INNODB_PURGE_BATCH_SIZE = "innodb_purge_batch_size";
  static const char* const OB_SV_INNODB_PURGE_RSEG_TRUNCATE_FREQUENCY = "innodb_purge_rseg_truncate_frequency";
  static const char* const OB_SV_INNODB_RANDOM_READ_AHEAD = "innodb_random_read_ahead";
  static const char* const OB_SV_INNODB_READ_AHEAD_THRESHOLD = "innodb_read_ahead_threshold";
  static const char* const OB_SV_INNODB_ROLLBACK_SEGMENTS = "innodb_rollback_segments";
  static const char* const OB_SV_INNODB_SPIN_WAIT_DELAY = "innodb_spin_wait_delay";
  static const char* const OB_SV_INNODB_STATUS_OUTPUT = "innodb_status_output";
  static const char* const OB_SV_INNODB_STATUS_OUTPUT_LOCKS = "innodb_status_output_locks";
  static const char* const OB_SV_INNODB_SYNC_SPIN_LOOPS = "innodb_sync_spin_loops";
  static const char* const OB_SV_INTERNAL_TMP_DISK_STORAGE_ENGINE = "internal_tmp_disk_storage_engine";
  static const char* const OB_SV_KEEP_FILES_ON_CREATE = "keep_files_on_create";
  static const char* const OB_SV_MAX_HEAP_TABLE_SIZE = "max_heap_table_size";
  static const char* const OB_SV_BULK_INSERT_BUFFER_SIZE = "bulk_insert_buffer_size";
  static const char* const OB_SV_HOST_CACHE_SIZE = "host_cache_size";
  static const char* const OB_SV_INIT_SLAVE = "init_slave";
  static const char* const OB_SV_INNODB_FAST_SHUTDOWN = "innodb_fast_shutdown";
  static const char* const OB_SV_INNODB_IO_CAPACITY = "innodb_io_capacity";
  static const char* const OB_SV_INNODB_IO_CAPACITY_MAX = "innodb_io_capacity_max";
  static const char* const OB_SV_INNODB_THREAD_CONCURRENCY = "innodb_thread_concurrency";
  static const char* const OB_SV_INNODB_THREAD_SLEEP_DELAY = "innodb_thread_sleep_delay";
  static const char* const OB_SV_LOG_ERROR_VERBOSITY = "log_error_verbosity";
  static const char* const OB_SV_LOG_OUTPUT = "log_output";
  static const char* const OB_SV_LOG_QUERIES_NOT_USING_INDEXES = "log_queries_not_using_indexes";
  static const char* const OB_SV_LOG_SLOW_ADMIN_STATEMENTS = "log_slow_admin_statements";
  static const char* const OB_SV_LOG_SLOW_SLAVE_STATEMENTS = "log_slow_slave_statements";
  static const char* const OB_SV_LOG_STATEMENTS_UNSAFE_FOR_BINLOG = "log_statements_unsafe_for_binlog";
  static const char* const OB_SV_LOG_SYSLOG = "log_syslog";
  static const char* const OB_SV_LOG_SYSLOG_FACILITY = "log_syslog_facility";
  static const char* const OB_SV_LOG_SYSLOG_INCLUDE_PID = "log_syslog_include_pid";
  static const char* const OB_SV_LOG_SYSLOG_TAG = "log_syslog_tag";
  static const char* const OB_SV_LOG_THROTTLE_QUERIES_NOT_USING_INDEXES = "log_throttle_queries_not_using_indexes";
  static const char* const OB_SV_LOG_TIMESTAMPS = "log_timestamps";
  static const char* const OB_SV_LOG_WARNINGS = "log_warnings";
  static const char* const OB_SV_MAX_DELAYED_THREADS = "max_delayed_threads";
  static const char* const OB_SV_OFFLINE_MODE = "offline_mode";
  static const char* const OB_SV_REQUIRE_SECURE_TRANSPORT = "require_secure_transport";
  static const char* const OB_SV_SLOW_LAUNCH_TIME = "slow_launch_time";
  static const char* const OB_SV_SQL_LOG_OFF = "sql_log_off";
  static const char* const OB_SV_THREAD_CACHE_SIZE = "thread_cache_size";
  static const char* const OB_SV_THREAD_POOL_HIGH_PRIORITY_CONNECTION = "thread_pool_high_priority_connection";
  static const char* const OB_SV_THREAD_POOL_MAX_UNUSED_THREADS = "thread_pool_max_unused_threads";
  static const char* const OB_SV_THREAD_POOL_PRIO_KICKUP_TIMER = "thread_pool_prio_kickup_timer";
  static const char* const OB_SV_THREAD_POOL_STALL_LIMIT = "thread_pool_stall_limit";
  static const char* const OB_SV_HAVE_STATEMENT_TIMEOUT = "have_statement_timeout";
  static const char* const OB_SV_MYSQLX_BIND_ADDRESS = "mysqlx_bind_address";
  static const char* const OB_SV_MYSQLX_PORT = "mysqlx_port";
  static const char* const OB_SV_MYSQLX_PORT_OPEN_TIMEOUT = "mysqlx_port_open_timeout";
  static const char* const OB_SV_MYSQLX_SOCKET = "mysqlx_socket";
  static const char* const OB_SV_MYSQLX_SSL_CA = "mysqlx_ssl_ca";
  static const char* const OB_SV_MYSQLX_SSL_CAPATH = "mysqlx_ssl_capath";
  static const char* const OB_SV_MYSQLX_SSL_CERT = "mysqlx_ssl_cert";
  static const char* const OB_SV_MYSQLX_SSL_CIPHER = "mysqlx_ssl_cipher";
  static const char* const OB_SV_MYSQLX_SSL_CRL = "mysqlx_ssl_crl";
  static const char* const OB_SV_MYSQLX_SSL_CRLPATH = "mysqlx_ssl_crlpath";
  static const char* const OB_SV_MYSQLX_SSL_KEY = "mysqlx_ssl_key";
  static const char* const OB_SV_OLD = "old";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_ACCOUNTS_SIZE = "performance_schema_accounts_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_DIGESTS_SIZE = "performance_schema_digests_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_EVENTS_STAGES_HISTORY_LONG_SIZE = "performance_schema_events_stages_history_long_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_EVENTS_STAGES_HISTORY_SIZE = "performance_schema_events_stages_history_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_EVENTS_STATEMENTS_HISTORY_LONG_SIZE = "performance_schema_events_statements_history_long_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_EVENTS_STATEMENTS_HISTORY_SIZE = "performance_schema_events_statements_history_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_EVENTS_TRANSACTIONS_HISTORY_LONG_SIZE = "performance_schema_events_transactions_history_long_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_EVENTS_TRANSACTIONS_HISTORY_SIZE = "performance_schema_events_transactions_history_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_EVENTS_WAITS_HISTORY_LONG_SIZE = "performance_schema_events_waits_history_long_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_EVENTS_WAITS_HISTORY_SIZE = "performance_schema_events_waits_history_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_HOSTS_SIZE = "performance_schema_hosts_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_COND_CLASSES = "performance_schema_max_cond_classes";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_COND_INSTANCES = "performance_schema_max_cond_instances";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_DIGEST_LENGTH = "performance_schema_max_digest_length";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_FILE_CLASSES = "performance_schema_max_file_classes";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_FILE_HANDLES = "performance_schema_max_file_handles";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_FILE_INSTANCES = "performance_schema_max_file_instances";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_INDEX_STAT = "performance_schema_max_index_stat";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_MEMORY_CLASSES = "performance_schema_max_memory_classes";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_METADATA_LOCKS = "performance_schema_max_metadata_locks";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_MUTEX_CLASSES = "performance_schema_max_mutex_classes";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_MUTEX_INSTANCES = "performance_schema_max_mutex_instances";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_PREPARED_STATEMENTS_INSTANCES = "performance_schema_max_prepared_statements_instances";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_PROGRAM_INSTANCES = "performance_schema_max_program_instances";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_RWLOCK_CLASSES = "performance_schema_max_rwlock_classes";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_RWLOCK_INSTANCES = "performance_schema_max_rwlock_instances";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_SOCKET_CLASSES = "performance_schema_max_socket_classes";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_SOCKET_INSTANCES = "performance_schema_max_socket_instances";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_SQL_TEXT_LENGTH = "performance_schema_max_sql_text_length";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_STAGE_CLASSES = "performance_schema_max_stage_classes";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_STATEMENT_CLASSES = "performance_schema_max_statement_classes";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_STATEMENT_STACK = "performance_schema_max_statement_stack";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_TABLE_HANDLES = "performance_schema_max_table_handles";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_TABLE_INSTANCES = "performance_schema_max_table_instances";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_TABLE_LOCK_STAT = "performance_schema_max_table_lock_stat";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_THREAD_CLASSES = "performance_schema_max_thread_classes";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_MAX_THREAD_INSTANCES = "performance_schema_max_thread_instances";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_SESSION_CONNECT_ATTRS_SIZE = "performance_schema_session_connect_attrs_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_SETUP_ACTORS_SIZE = "performance_schema_setup_actors_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_SETUP_OBJECTS_SIZE = "performance_schema_setup_objects_size";
  static const char* const OB_SV_PERFORMANCE_SCHEMA_USERS_SIZE = "performance_schema_users_size";
  static const char* const OB_SV_VERSION_TOKENS_SESSION_NUMBER = "version_tokens_session_number";
  static const char* const OB_SV_BACK_LOG = "back_log";
  static const char* const OB_SV_BASEDIR = "basedir";
  static const char* const OB_SV_BIND_ADDRESS = "bind_address";
  static const char* const OB_SV_CORE_FILE = "core_file";
  static const char* const OB_SV_HAVE_COMPRESS = "have_compress";
  static const char* const OB_SV_IGNORE_DB_DIRS = "ignore_db_dirs";
  static const char* const OB_SV_INIT_FILE = "init_file";
  static const char* const OB_SV_INNODB_NUMA_INTERLEAVE = "innodb_numa_interleave";
  static const char* const OB_SV_INNODB_OPEN_FILES = "innodb_open_files";
  static const char* const OB_SV_INNODB_PAGE_CLEANERS = "innodb_page_cleaners";
  static const char* const OB_SV_INNODB_PURGE_THREADS = "innodb_purge_threads";
  static const char* const OB_SV_INNODB_READ_IO_THREADS = "innodb_read_io_threads";
  static const char* const OB_SV_INNODB_SYNC_ARRAY_SIZE = "innodb_sync_array_size";
  static const char* const OB_SV_INNODB_USE_NATIVE_AIO = "innodb_use_native_aio";
  static const char* const OB_SV_INNODB_WRITE_IO_THREADS = "innodb_write_io_threads";
  static const char* const OB_SV_LARGE_FILES_SUPPORT = "large_files_support";
  static const char* const OB_SV_LARGE_PAGES = "large_pages";
  static const char* const OB_SV_LARGE_PAGE_SIZE = "large_page_size";
  static const char* const OB_SV_LOCKED_IN_MEMORY = "locked_in_memory";
  static const char* const OB_SV_LOG_ERROR = "log_error";
  static const char* const OB_SV_NAMED_PIPE = "named_pipe";
  static const char* const OB_SV_NAMED_PIPE_FULL_ACCESS_GROUP = "named_pipe_full_access_group";
  static const char* const OB_SV_OPEN_FILES_LIMIT = "open_files_limit";
  static const char* const OB_SV_REPORT_HOST = "report_host";
  static const char* const OB_SV_REPORT_PASSWORD = "report_password";
  static const char* const OB_SV_REPORT_PORT = "report_port";
  static const char* const OB_SV_REPORT_USER = "report_user";
  static const char* const OB_SV_SERVER_ID_BITS = "server_id_bits";
  static const char* const OB_SV_SHARED_MEMORY = "shared_memory";
  static const char* const OB_SV_SHARED_MEMORY_BASE_NAME = "shared_memory_base_name";
  static const char* const OB_SV_SKIP_NAME_RESOLVE = "skip_name_resolve";
  static const char* const OB_SV_SKIP_NETWORKING = "skip_networking";
  static const char* const OB_SV_THREAD_HANDLING = "thread_handling";
  static const char* const OB_SV_THREAD_POOL_ALGORITHM = "thread_pool_algorithm";
  static const char* const OB_SV_THREAD_POOL_SIZE = "thread_pool_size";
  static const char* const OB_SV_THREAD_STACK = "thread_stack";
  static const char* const OB_SV_BINLOG_GTID_SIMPLE_RECOVERY = "binlog_gtid_simple_recovery";
  static const char* const OB_SV_INNODB_API_ENABLE_BINLOG = "innodb_api_enable_binlog";
  static const char* const OB_SV_INNODB_LOCKS_UNSAFE_FOR_BINLOG = "innodb_locks_unsafe_for_binlog";
  static const char* const OB_SV_INNODB_LOG_BUFFER_SIZE = "innodb_log_buffer_size";
  static const char* const OB_SV_INNODB_LOG_FILES_IN_GROUP = "innodb_log_files_in_group";
  static const char* const OB_SV_INNODB_LOG_FILE_SIZE = "innodb_log_file_size";
  static const char* const OB_SV_INNODB_LOG_GROUP_HOME_DIR = "innodb_log_group_home_dir";
  static const char* const OB_SV_INNODB_UNDO_DIRECTORY = "innodb_undo_directory";
  static const char* const OB_SV_INNODB_UNDO_TABLESPACES = "innodb_undo_tablespaces";
  static const char* const OB_SV_LOG_BIN_BASENAME = "log_bin_basename";
  static const char* const OB_SV_LOG_BIN_INDEX = "log_bin_index";
  static const char* const OB_SV_LOG_SLAVE_UPDATES = "log_slave_updates";
  static const char* const OB_SV_RELAY_LOG = "relay_log";
  static const char* const OB_SV_RELAY_LOG_BASENAME = "relay_log_basename";
  static const char* const OB_SV_RELAY_LOG_INDEX = "relay_log_index";
  static const char* const OB_SV_RELAY_LOG_INFO_FILE = "relay_log_info_file";
  static const char* const OB_SV_RELAY_LOG_RECOVERY = "relay_log_recovery";
  static const char* const OB_SV_RELAY_LOG_SPACE_LIMIT = "relay_log_space_limit";
  static const char* const OB_SV_DELAY_KEY_WRITE = "delay_key_write";
  static const char* const OB_SV_INNODB_LARGE_PREFIX = "innodb_large_prefix";
  static const char* const OB_SV_KEY_BUFFER_SIZE = "key_buffer_size";
  static const char* const OB_SV_KEY_CACHE_AGE_THRESHOLD = "key_cache_age_threshold";
  static const char* const OB_SV_KEY_CACHE_DIVISION_LIMIT = "key_cache_division_limit";
  static const char* const OB_SV_MAX_SEEKS_FOR_KEY = "max_seeks_for_key";
  static const char* const OB_SV_OLD_ALTER_TABLE = "old_alter_table";
  static const char* const OB_SV_TABLE_DEFINITION_CACHE = "table_definition_cache";
  static const char* const OB_SV_INNODB_SORT_BUFFER_SIZE = "innodb_sort_buffer_size";
  static const char* const OB_SV_KEY_CACHE_BLOCK_SIZE = "key_cache_block_size";
  static const char* const OB_SV_KV_MODE = "ob_kv_mode";
  static const char* const OB_SV___OB_CLIENT_CAPABILITY_FLAG = "__ob_client_capability_flag";
  static const char* const OB_SV_ENABLE_PARAMETER_ANONYMOUS_BLOCK = "ob_enable_parameter_anonymous_block";
  static const char* const OB_SV_CHARACTER_SETS_DIR = "character_sets_dir";
  static const char* const OB_SV_DATE_FORMAT = "date_format";
  static const char* const OB_SV_DATETIME_FORMAT = "datetime_format";
  static const char* const OB_SV_DISCONNECT_ON_EXPIRED_PASSWORD = "disconnect_on_expired_password";
  static const char* const OB_SV_EXTERNAL_USER = "external_user";
  static const char* const OB_SV_HAVE_CRYPT = "have_crypt";
  static const char* const OB_SV_HAVE_DYNAMIC_LOADING = "have_dynamic_loading";
  static const char* const OB_SV_KEYRING_AWS_CONF_FILE = "keyring_aws_conf_file";
  static const char* const OB_SV_KEYRING_AWS_DATA_FILE = "keyring_aws_data_file";
  static const char* const OB_SV_LANGUAGE = "language";
  static const char* const OB_SV_LC_MESSAGES_DIR = "lc_messages_dir";
  static const char* const OB_SV_LOWER_CASE_FILE_SYSTEM = "lower_case_file_system";
  static const char* const OB_SV_MAX_DIGEST_LENGTH = "max_digest_length";
  static const char* const OB_SV_NDBINFO_DATABASE = "ndbinfo_database";
  static const char* const OB_SV_NDBINFO_TABLE_PREFIX = "ndbinfo_table_prefix";
  static const char* const OB_SV_NDBINFO_VERSION = "ndbinfo_version";
  static const char* const OB_SV_NDB_BATCH_SIZE = "ndb_batch_size";
  static const char* const OB_SV_NDB_CLUSTER_CONNECTION_POOL = "ndb_cluster_connection_pool";
  static const char* const OB_SV_NDB_CLUSTER_CONNECTION_POOL_NODEIDS = "ndb_cluster_connection_pool_nodeids";
  static const char* const OB_SV_NDB_LOG_APPLY_STATUS = "ndb_log_apply_status";
  static const char* const OB_SV_NDB_LOG_BIN = "ndb_log_bin";
  static const char* const OB_SV_NDB_LOG_FAIL_TERMINATE = "ndb_log_fail_terminate";
  static const char* const OB_SV_NDB_LOG_ORIG = "ndb_log_orig";
  static const char* const OB_SV_NDB_LOG_TRANSACTION_ID = "ndb_log_transaction_id";
  static const char* const OB_SV_NDB_OPTIMIZED_NODE_SELECTION = "ndb_optimized_node_selection";
  static const char* const OB_SV_NDB_SYSTEM_NAME = "Ndb_system_name";
  static const char* const OB_SV_NDB_USE_COPYING_ALTER_TABLE = "ndb_use_copying_alter_table";
  static const char* const OB_SV_NDB_VERSION_STRING = "ndb_version_string";
  static const char* const OB_SV_NDB_WAIT_CONNECTED = "ndb_wait_connected";
  static const char* const OB_SV_NDB_WAIT_SETUP = "ndb_wait_setup";
  static const char* const OB_SV_PROXY_USER = "proxy_user";
  static const char* const OB_SV_SHA256_PASSWORD_AUTO_GENERATE_RSA_KEYS = "sha256_password_auto_generate_rsa_keys";
  static const char* const OB_SV_SHA256_PASSWORD_PRIVATE_KEY_PATH = "sha256_password_private_key_path";
  static const char* const OB_SV_SHA256_PASSWORD_PUBLIC_KEY_PATH = "sha256_password_public_key_path";
  static const char* const OB_SV_SKIP_SHOW_DATABASE = "skip_show_database";
  static const char* const OB_SV_PLUGIN_LOAD = "plugin_load";
  static const char* const OB_SV_PLUGIN_LOAD_ADD = "plugin_load_add";
  static const char* const OB_SV_BIG_TABLES = "big_tables";
  static const char* const OB_SV_CHECK_PROXY_USERS = "check_proxy_users";
  static const char* const OB_SV_CONNECTION_CONTROL_FAILED_CONNECTIONS_THRESHOLD = "connection_control_failed_connections_threshold";
  static const char* const OB_SV_CONNECTION_CONTROL_MAX_CONNECTION_DELAY = "connection_control_max_connection_delay";
  static const char* const OB_SV_CONNECTION_CONTROL_MIN_CONNECTION_DELAY = "connection_control_min_connection_delay";
  static const char* const OB_SV_DEFAULT_WEEK_FORMAT = "default_week_format";
  static const char* const OB_SV_DELAYED_INSERT_TIMEOUT = "delayed_insert_timeout";
  static const char* const OB_SV_DELAYED_QUEUE_SIZE = "delayed_queue_size";
  static const char* const OB_SV_EQ_RANGE_INDEX_DIVE_LIMIT = "eq_range_index_dive_limit";
  static const char* const OB_SV_INNODB_STATS_AUTO_RECALC = "innodb_stats_auto_recalc";
  static const char* const OB_SV_INNODB_STATS_INCLUDE_DELETE_MARKED = "innodb_stats_include_delete_marked";
  static const char* const OB_SV_INNODB_STATS_METHOD = "innodb_stats_method";
  static const char* const OB_SV_INNODB_STATS_ON_METADATA = "innodb_stats_on_metadata";
  static const char* const OB_SV_VERSION_TOKENS_SESSION = "version_tokens_session";
  static const char* const OB_SV_INNODB_STATS_PERSISTENT_SAMPLE_PAGES = "innodb_stats_persistent_sample_pages";
  static const char* const OB_SV_INNODB_STATS_SAMPLE_PAGES = "innodb_stats_sample_pages";
  static const char* const OB_SV_INNODB_STATS_TRANSIENT_SAMPLE_PAGES = "innodb_stats_transient_sample_pages";
  static const char* const OB_SV_KEYRING_AWS_CMK_ID = "keyring_aws_cmk_id";
  static const char* const OB_SV_KEYRING_AWS_REGION = "keyring_aws_region";
  static const char* const OB_SV_KEYRING_ENCRYPTED_FILE_DATA = "keyring_encrypted_file_data";
  static const char* const OB_SV_KEYRING_ENCRYPTED_FILE_PASSWORD = "keyring_encrypted_file_password";
  static const char* const OB_SV_KEYRING_FILE_DATA = "keyring_file_data";
  static const char* const OB_SV_KEYRING_OKV_CONF_DIR = "keyring_okv_conf_dir";
  static const char* const OB_SV_KEYRING_OPERATIONS = "keyring_operations";
  static const char* const OB_SV_OPTIMIZER_SWITCH = "optimizer_switch";
  static const char* const OB_SV_MAX_CONNECT_ERRORS = "max_connect_errors";
  static const char* const OB_SV_MYSQL_FIREWALL_MODE = "mysql_firewall_mode";
  static const char* const OB_SV_MYSQL_FIREWALL_TRACE = "mysql_firewall_trace";
  static const char* const OB_SV_MYSQL_NATIVE_PASSWORD_PROXY_USERS = "mysql_native_password_proxy_users";
  static const char* const OB_SV_NET_RETRY_COUNT = "net_retry_count";
  static const char* const OB_SV_NEW = "new";
  static const char* const OB_SV_OLD_PASSWORDS = "old_passwords";
  static const char* const OB_SV_OPTIMIZER_PRUNE_LEVEL = "optimizer_prune_level";
  static const char* const OB_SV_OPTIMIZER_SEARCH_DEPTH = "optimizer_search_depth";
  static const char* const OB_SV_OPTIMIZER_TRACE = "optimizer_trace";
  static const char* const OB_SV_OPTIMIZER_TRACE_FEATURES = "optimizer_trace_features";
  static const char* const OB_SV_OPTIMIZER_TRACE_LIMIT = "optimizer_trace_limit";
  static const char* const OB_SV_OPTIMIZER_TRACE_MAX_MEM_SIZE = "optimizer_trace_max_mem_size";
  static const char* const OB_SV_OPTIMIZER_TRACE_OFFSET = "optimizer_trace_offset";
  static const char* const OB_SV_PARSER_MAX_MEM_SIZE = "parser_max_mem_size";
  static const char* const OB_SV_RAND_SEED1 = "rand_seed1";
  static const char* const OB_SV_RAND_SEED2 = "rand_seed2";
  static const char* const OB_SV_RANGE_ALLOC_BLOCK_SIZE = "range_alloc_block_size";
  static const char* const OB_SV_RANGE_OPTIMIZER_MAX_MEM_SIZE = "range_optimizer_max_mem_size";
  static const char* const OB_SV_REWRITER_ENABLED = "rewriter_enabled";
  static const char* const OB_SV_REWRITER_VERBOSE = "rewriter_verbose";
  static const char* const OB_SV_SECURE_AUTH = "secure_auth";
  static const char* const OB_SV_SHA256_PASSWORD_PROXY_USERS = "sha256_password_proxy_users";
  static const char* const OB_SV_SHOW_COMPATIBILITY_56 = "show_compatibility_56";
  static const char* const OB_SV_SHOW_CREATE_TABLE_VERBOSITY = "show_create_table_verbosity";
  static const char* const OB_SV_SHOW_OLD_TEMPORALS = "show_old_temporals";
  static const char* const OB_SV_SQL_BIG_SELECTS = "sql_big_selects";
  static const char* const OB_SV_UPDATABLE_VIEWS_WITH_LIMIT = "updatable_views_with_limit";
  static const char* const OB_SV_VALIDATE_PASSWORD_DICTIONARY_FILE = "validate_password_dictionary_file";
  static const char* const OB_SV_DELAYED_INSERT_LIMIT = "delayed_insert_limit";
  static const char* const OB_SV_NDB_VERSION = "ndb_version";
  static const char* const OB_SV_AUTO_GENERATE_CERTS = "auto_generate_certs";
  static const char* const OB_SV__OPTIMIZER_COST_BASED_TRANSFORMATION = "_optimizer_cost_based_transformation";
  static const char* const OB_SV_RANGE_INDEX_DIVE_LIMIT = "range_index_dive_limit";
  static const char* const OB_SV_PARTITION_INDEX_DIVE_LIMIT = "partition_index_dive_limit";
  static const char* const OB_SV_TABLE_ACCESS_POLICY = "ob_table_access_policy";
  static const char* const OB_SV_PID_FILE = "pid_file";
  static const char* const OB_SV_PORT = "port";
  static const char* const OB_SV_SOCKET = "socket";
  static const char* const OB_SV_MVIEW_REFRESH_DOP = "mview_refresh_dop";
  static const char* const OB_SV_ENABLE_OPTIMIZER_ROWGOAL = "enable_optimizer_rowgoal";
  static const char* const OB_SV_IVF_NPROBES = "ob_ivf_nprobes";

}
}
#endif //OCEANBASE_COMMON_OB_SYSTEM_VARIABLE_ALIAS_H_

