#type_name:sdo_geometry
#package_name:sdo_geometry

CREATE OR REPLACE TYPE BODY SDO_GEOMETRY AS

  -- extraction functions
  MEMBER FUNCTION GET_WKB RETURN BLOB DETERMINISTIC;
  PRAGMA INTERFACE(c, sdo_geometry_get_wkb);

  MEMBER FUNCTION GET_WKT RETURN CLOB DETERMINISTIC;
  PRAGMA INTERFACE(c, sdo_geometry_get_wkt);

  MEMBER FUNCTION Get_GType RETURN NUMBER DETERMINISTIC;
  PRAGMA INTERFACE(c, sdo_geometry_get_gtype);

  MEMBER FUNCTION ST_CoordDim RETURN NUMBER DETERMINISTIC;
  PRAGMA INTERFACE(c, sdo_geometry_st_coorddim);

  MEMBER FUNCTION Get_Dims RETURN NUMBER DETERMINISTIC;
  PRAGMA INTERFACE(c, sdo_geometry_get_dims);

  MEMBER FUNCTION ST_IsValid RETURN NUMBER DETERMINISTIC;
  PRAGMA INTERFACE(c, sdo_geometry_st_isvalid);

  MEMBER FUNCTION Get_GeoJson RETURN CLOB DETERMINISTIC;
  PRAGMA INTERFACE(c, sdo_geometry_get_geojson);

  CONSTRUCTOR FUNCTION SDO_GEOMETRY(wkb IN BLOB, srid IN NUMBER DEFAULT NULL) RETURN SELF AS RESULT DETERMINISTIC;
  PRAGMA INTERFACE(c, sdo_geometry_constructor);

  CONSTRUCTOR FUNCTION SDO_GEOMETRY(wkt IN CLOB, srid IN NUMBER DEFAULT NULL) RETURN SELF AS RESULT DETERMINISTIC;
  PRAGMA INTERFACE(c, sdo_geometry_constructor);

  CONSTRUCTOR FUNCTION SDO_GEOMETRY(wkt IN VARCHAR2, srid IN NUMBER DEFAULT NULL) RETURN SELF AS RESULT DETERMINISTIC;
  PRAGMA INTERFACE(c, sdo_geometry_constructor);
END;
//
