/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
#include "lib/charset/ob_mysql_global.h"

extern const int MIN_ZH3_HAN_PAGE = 0x2E;
extern const int MAX_ZH3_HAN_PAGE = 0x313;

uint16 zh3_han_p02E[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 3, 2,
  2, 3, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 3, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 3, 2, 2, 2, 2,
  2, 2, 2, 3, 3, 3, 2, 3, 2, 2, 2, 3, 2, 3, 2, 3,
  3, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 3, 2,
  2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 3, 2, 2, 3, 2, 2, 3, 2, 2, 2, 3, 2, 3, 2, 3,
  2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x03B6,   /* U+2E00 */
  0x03B7,   /* U+2E01 */
  0x035B,   /* U+2E02 */
  0x035C,   /* U+2E03 */
  0x035D,   /* U+2E04 */
  0x035E,   /* U+2E05 */
  0x03B8,   /* U+2E06 */
  0x03B9,   /* U+2E07 */
  0x03BA,   /* U+2E08 */
  0x035F,   /* U+2E09 */
  0x0360,   /* U+2E0A */
  0x03BB,   /* U+2E0B */
  0x0361,   /* U+2E0C */
  0x0362,   /* U+2E0D */
  0x03BC,   /* U+2E0E */
  0x03BD,   /* U+2E0F */
  0x03BE,   /* U+2E10 */
  0x03BF,   /* U+2E11 */
  0x03C0,   /* U+2E12 */
  0x03C1,   /* U+2E13 */
  0x03C2,   /* U+2E14 */
  0x03C3,   /* U+2E15 */
  0x03C4,   /* U+2E16 */
  0x021C,   /* U+2E17 */
  0x0276,   /* U+2E18 */
  0x02F8,   /* U+2E19 */
  0x03C5,   /* U+2E1A */
  0x03C6,   /* U+2E1B */
  0x0363,   /* U+2E1C */
  0x0364,   /* U+2E1D */
  0x03C7,   /* U+2E1E */
  0x03C8,   /* U+2E1F */
  0x0365,   /* U+2E20 */
  0x0366,   /* U+2E21 */
  0x0367,   /* U+2E22 */
  0x0368,   /* U+2E23 */
  0x0369,   /* U+2E24 */
  0x036A,   /* U+2E25 */
  0x036B,   /* U+2E26 */
  0x036C,   /* U+2E27 */
  0x036D,   /* U+2E28 */
  0x036E,   /* U+2E29 */
  0x02F1,   /* U+2E2A */
  0x02F2,   /* U+2E2B */
  0x02F3,   /* U+2E2C */
  0x02F4,   /* U+2E2D */
  0x0268,   /* U+2E2E */
  0x21F6,   /* U+2E2F */
  0x0283,   /* U+2E30 */
  0x028C,   /* U+2E31 */
  0x0224,   /* U+2E32 */
  0x028D,   /* U+2E33 */
  0x0223,   /* U+2E34 */
  0x0237,   /* U+2E35 */
  0x03A1,   /* U+2E36 */
  0x03A2,   /* U+2E37 */
  0x03A3,   /* U+2E38 */
  0x038A,   /* U+2E39 */
  0x0218,   /* U+2E3A */
  0x0219,   /* U+2E3B */
  0x0284,   /* U+2E3C */
  0x02F5,   /* U+2E3D */
  0x0384,   /* U+2E3E */
  0x038D,   /* U+2E3F */
  0x021D,   /* U+2E40 */
  0x0225,   /* U+2E41 */
  0x0311,   /* U+2E42 */
  0x021B,   /* U+2E43 */
  0x03C9,   /* U+2E44 */
  0xFBC0,   /* U+2E45 */
  0xFBC0,   /* U+2E46 */
  0xFBC0,   /* U+2E47 */
  0xFBC0,   /* U+2E48 */
  0xFBC0,   /* U+2E49 */
  0xFBC0,   /* U+2E4A */
  0xFBC0,   /* U+2E4B */
  0xFBC0,   /* U+2E4C */
  0xFBC0,   /* U+2E4D */
  0xFBC0,   /* U+2E4E */
  0xFBC0,   /* U+2E4F */
  0xFBC0,   /* U+2E50 */
  0xFBC0,   /* U+2E51 */
  0xFBC0,   /* U+2E52 */
  0xFBC0,   /* U+2E53 */
  0xFBC0,   /* U+2E54 */
  0xFBC0,   /* U+2E55 */
  0xFBC0,   /* U+2E56 */
  0xFBC0,   /* U+2E57 */
  0xFBC0,   /* U+2E58 */
  0xFBC0,   /* U+2E59 */
  0xFBC0,   /* U+2E5A */
  0xFBC0,   /* U+2E5B */
  0xFBC0,   /* U+2E5C */
  0xFBC0,   /* U+2E5D */
  0xFBC0,   /* U+2E5E */
  0xFBC0,   /* U+2E5F */
  0xFBC0,   /* U+2E60 */
  0xFBC0,   /* U+2E61 */
  0xFBC0,   /* U+2E62 */
  0xFBC0,   /* U+2E63 */
  0xFBC0,   /* U+2E64 */
  0xFBC0,   /* U+2E65 */
  0xFBC0,   /* U+2E66 */
  0xFBC0,   /* U+2E67 */
  0xFBC0,   /* U+2E68 */
  0xFBC0,   /* U+2E69 */
  0xFBC0,   /* U+2E6A */
  0xFBC0,   /* U+2E6B */
  0xFBC0,   /* U+2E6C */
  0xFBC0,   /* U+2E6D */
  0xFBC0,   /* U+2E6E */
  0xFBC0,   /* U+2E6F */
  0xFBC0,   /* U+2E70 */
  0xFBC0,   /* U+2E71 */
  0xFBC0,   /* U+2E72 */
  0xFBC0,   /* U+2E73 */
  0xFBC0,   /* U+2E74 */
  0xFBC0,   /* U+2E75 */
  0xFBC0,   /* U+2E76 */
  0xFBC0,   /* U+2E77 */
  0xFBC0,   /* U+2E78 */
  0xFBC0,   /* U+2E79 */
  0xFBC0,   /* U+2E7A */
  0xFBC0,   /* U+2E7B */
  0xFBC0,   /* U+2E7C */
  0xFBC0,   /* U+2E7D */
  0xFBC0,   /* U+2E7E */
  0xFBC0,   /* U+2E7F */
  0x1C49,   /* U+2E80 */
  0x1C49,   /* U+2E81 */
  0x1C48,   /* U+2E82 */
  0x1C48,   /* U+2E83 */
  0x1C48,   /* U+2E84 */
  0x1C49,   /* U+2E85 */
  0x1C49,   /* U+2E86 */
  0x1C49,   /* U+2E87 */
  0x1C49,   /* U+2E88 */
  0x1C49,   /* U+2E89 */
  0x1C49,   /* U+2E8A */
  0x1C49,   /* U+2E8B */
  0x1C4A,   /* U+2E8C */
  0x1C4A,   /* U+2E8D */
  0x1C4A,   /* U+2E8E */
  0x1C4B,   /* U+2E8F */
  0x1C4A,   /* U+2E90 */
  0x1C4B,   /* U+2E91 */
  0x1C4A,   /* U+2E92 */
  0x1C4A,   /* U+2E93 */
  0x1C4A,   /* U+2E94 */
  0x1C4A,   /* U+2E95 */
  0x1C4A,   /* U+2E96 */
  0x1C4B,   /* U+2E97 */
  0x1C4A,   /* U+2E98 */
  0x1C4B,   /* U+2E99 */
  0xFBC0,   /* U+2E9A */
  0x1C4B,   /* U+2E9B */
  0x1C4B,   /* U+2E9C */
  0x1C4B,   /* U+2E9D */
  0x1C4C,   /* U+2E9E */
  0x1C4C,   /* U+2E9F */
  0x1C4C,   /* U+2EA0 */
  0x1C4A,   /* U+2EA1 */
  0x1C4C,   /* U+2EA2 */
  0x1C4B,   /* U+2EA3 */
  0x1C4B,   /* U+2EA4 */
  0x1C4B,   /* U+2EA5 */
  0x1C4B,   /* U+2EA6 */
  0x1C4B,   /* U+2EA7 */
  0x1C4A,   /* U+2EA8 */
  0x1C4B,   /* U+2EA9 */
  0x1C4C,   /* U+2EAA */
  0x1C4C,   /* U+2EAB */
  0x1C4C,   /* U+2EAC */
  0x1C4B,   /* U+2EAD */
  0x1C4D,   /* U+2EAE */
  0x1C4D,   /* U+2EAF */
  0x1C4A,   /* U+2EB0 */
  0x1C4B,   /* U+2EB1 */
  0x1C4C,   /* U+2EB2 */
  0x1C4B,   /* U+2EB3 */
  0x1C4B,   /* U+2EB4 */
  0x1C4C,   /* U+2EB5 */
  0x1C4D,   /* U+2EB6 */
  0x1C4D,   /* U+2EB7 */
  0x1C4F,   /* U+2EB8 */
  0x1C4B,   /* U+2EB9 */
  0x1C4B,   /* U+2EBA */
  0x1C4D,   /* U+2EBB */
  0x1C4B,   /* U+2EBC */
  0x1C4D,   /* U+2EBD */
  0x1C4A,   /* U+2EBE */
  0x1C4A,   /* U+2EBF */
  0x1C4A,   /* U+2EC0 */
  0x1C4F,   /* U+2EC1 */
  0x1C4C,   /* U+2EC2 */
  0x1C4D,   /* U+2EC3 */
  0x1C4D,   /* U+2EC4 */
  0x1C4B,   /* U+2EC5 */
  0x1C4E,   /* U+2EC6 */
  0x1C4E,   /* U+2EC7 */
  0x1C49,   /* U+2EC8 */
  0x1C4B,   /* U+2EC9 */
  0x1C4E,   /* U+2ECA */
  0x1C4B,   /* U+2ECB */
  0x1C4A,   /* U+2ECC */
  0x1C4B,   /* U+2ECD */
  0x1C4B,   /* U+2ECE */
  0x1C49,   /* U+2ECF */
  0x1C4C,   /* U+2ED0 */
  0x1C4F,   /* U+2ED1 */
  0x1C4F,   /* U+2ED2 */
  0x1C4C,   /* U+2ED3 */
  0x1C4A,   /* U+2ED4 */
  0x1C4F,   /* U+2ED5 */
  0x1C49,   /* U+2ED6 */
  0x1C4F,   /* U+2ED7 */
  0x1C4F,   /* U+2ED8 */
  0x1C4B,   /* U+2ED9 */
  0x1C4D,   /* U+2EDA */
  0x1C4B,   /* U+2EDB */
  0x1C4A,   /* U+2EDC */
  0x1C50,   /* U+2EDD */
  0x1C50,   /* U+2EDE */
  0x1C50,   /* U+2EDF */
  0x1C4A,   /* U+2EE0 */
  0x1C50,   /* U+2EE1 */
  0x1C4A,   /* U+2EE2 */
  0x1C50,   /* U+2EE3 */
  0x1C51,   /* U+2EE4 */
  0x1C4F,   /* U+2EE5 */
  0x1C4C,   /* U+2EE6 */
  0x1C52,   /* U+2EE7 */
  0x1C4E,   /* U+2EE8 */
  0x1C53,   /* U+2EE9 */
  0x1C4F,   /* U+2EEA */
  0x1C55,   /* U+2EEB */
  0x1C4D,   /* U+2EEC */
  0x1C56,   /* U+2EED */
  0x1C4F,   /* U+2EEE */
  0x1C57,   /* U+2EEF */
  0x1C4C,   /* U+2EF0 */
  0x1C57,   /* U+2EF1 */
  0x1C57,   /* U+2EF2 */
  0x1C4E,   /* U+2EF3 */
  0xFBC0,   /* U+2EF4 */
  0xFBC0,   /* U+2EF5 */
  0xFBC0,   /* U+2EF6 */
  0xFBC0,   /* U+2EF7 */
  0xFBC0,   /* U+2EF8 */
  0xFBC0,   /* U+2EF9 */
  0xFBC0,   /* U+2EFA */
  0xFBC0,   /* U+2EFB */
  0xFBC0,   /* U+2EFC */
  0xFBC0,   /* U+2EFD */
  0xFBC0,   /* U+2EFE */
  0xFBC0,   /* U+2EFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+2E00 */
  0x0020,   /* U+2E01 */
  0x0020,   /* U+2E02 */
  0x0020,   /* U+2E03 */
  0x0020,   /* U+2E04 */
  0x0020,   /* U+2E05 */
  0x0020,   /* U+2E06 */
  0x0020,   /* U+2E07 */
  0x0020,   /* U+2E08 */
  0x0020,   /* U+2E09 */
  0x0020,   /* U+2E0A */
  0x0020,   /* U+2E0B */
  0x0020,   /* U+2E0C */
  0x0020,   /* U+2E0D */
  0x0020,   /* U+2E0E */
  0x0020,   /* U+2E0F */
  0x0020,   /* U+2E10 */
  0x0020,   /* U+2E11 */
  0x0020,   /* U+2E12 */
  0x0020,   /* U+2E13 */
  0x0020,   /* U+2E14 */
  0x0020,   /* U+2E15 */
  0x0020,   /* U+2E16 */
  0x0020,   /* U+2E17 */
  0x0020,   /* U+2E18 */
  0x0020,   /* U+2E19 */
  0x0020,   /* U+2E1A */
  0x0020,   /* U+2E1B */
  0x0020,   /* U+2E1C */
  0x0020,   /* U+2E1D */
  0x0020,   /* U+2E1E */
  0x0020,   /* U+2E1F */
  0x0020,   /* U+2E20 */
  0x0020,   /* U+2E21 */
  0x0020,   /* U+2E22 */
  0x0020,   /* U+2E23 */
  0x0020,   /* U+2E24 */
  0x0020,   /* U+2E25 */
  0x0020,   /* U+2E26 */
  0x0020,   /* U+2E27 */
  0x0020,   /* U+2E28 */
  0x0020,   /* U+2E29 */
  0x0020,   /* U+2E2A */
  0x0020,   /* U+2E2B */
  0x0020,   /* U+2E2C */
  0x0020,   /* U+2E2D */
  0x0020,   /* U+2E2E */
  0x0020,   /* U+2E2F */
  0x0020,   /* U+2E30 */
  0x0020,   /* U+2E31 */
  0x0020,   /* U+2E32 */
  0x0020,   /* U+2E33 */
  0x0020,   /* U+2E34 */
  0x0020,   /* U+2E35 */
  0x0020,   /* U+2E36 */
  0x0020,   /* U+2E37 */
  0x0020,   /* U+2E38 */
  0x0020,   /* U+2E39 */
  0x0020,   /* U+2E3A */
  0x0020,   /* U+2E3B */
  0x0020,   /* U+2E3C */
  0x0020,   /* U+2E3D */
  0x0020,   /* U+2E3E */
  0x0020,   /* U+2E3F */
  0x0020,   /* U+2E40 */
  0x0020,   /* U+2E41 */
  0x0020,   /* U+2E42 */
  0x0020,   /* U+2E43 */
  0x0020,   /* U+2E44 */
  0x0020,   /* U+2E45 */
  0x0020,   /* U+2E46 */
  0x0020,   /* U+2E47 */
  0x0020,   /* U+2E48 */
  0x0020,   /* U+2E49 */
  0x0020,   /* U+2E4A */
  0x0020,   /* U+2E4B */
  0x0020,   /* U+2E4C */
  0x0020,   /* U+2E4D */
  0x0020,   /* U+2E4E */
  0x0020,   /* U+2E4F */
  0x0020,   /* U+2E50 */
  0x0020,   /* U+2E51 */
  0x0020,   /* U+2E52 */
  0x0020,   /* U+2E53 */
  0x0020,   /* U+2E54 */
  0x0020,   /* U+2E55 */
  0x0020,   /* U+2E56 */
  0x0020,   /* U+2E57 */
  0x0020,   /* U+2E58 */
  0x0020,   /* U+2E59 */
  0x0020,   /* U+2E5A */
  0x0020,   /* U+2E5B */
  0x0020,   /* U+2E5C */
  0x0020,   /* U+2E5D */
  0x0020,   /* U+2E5E */
  0x0020,   /* U+2E5F */
  0x0020,   /* U+2E60 */
  0x0020,   /* U+2E61 */
  0x0020,   /* U+2E62 */
  0x0020,   /* U+2E63 */
  0x0020,   /* U+2E64 */
  0x0020,   /* U+2E65 */
  0x0020,   /* U+2E66 */
  0x0020,   /* U+2E67 */
  0x0020,   /* U+2E68 */
  0x0020,   /* U+2E69 */
  0x0020,   /* U+2E6A */
  0x0020,   /* U+2E6B */
  0x0020,   /* U+2E6C */
  0x0020,   /* U+2E6D */
  0x0020,   /* U+2E6E */
  0x0020,   /* U+2E6F */
  0x0020,   /* U+2E70 */
  0x0020,   /* U+2E71 */
  0x0020,   /* U+2E72 */
  0x0020,   /* U+2E73 */
  0x0020,   /* U+2E74 */
  0x0020,   /* U+2E75 */
  0x0020,   /* U+2E76 */
  0x0020,   /* U+2E77 */
  0x0020,   /* U+2E78 */
  0x0020,   /* U+2E79 */
  0x0020,   /* U+2E7A */
  0x0020,   /* U+2E7B */
  0x0020,   /* U+2E7C */
  0x0020,   /* U+2E7D */
  0x0020,   /* U+2E7E */
  0x0020,   /* U+2E7F */
  0x0020,   /* U+2E80 */
  0x0020,   /* U+2E81 */
  0x0020,   /* U+2E82 */
  0x0020,   /* U+2E83 */
  0x0020,   /* U+2E84 */
  0x0020,   /* U+2E85 */
  0x0020,   /* U+2E86 */
  0x0020,   /* U+2E87 */
  0x0020,   /* U+2E88 */
  0x0020,   /* U+2E89 */
  0x0020,   /* U+2E8A */
  0x0020,   /* U+2E8B */
  0x0020,   /* U+2E8C */
  0x0020,   /* U+2E8D */
  0x0020,   /* U+2E8E */
  0x0020,   /* U+2E8F */
  0x0020,   /* U+2E90 */
  0x0020,   /* U+2E91 */
  0x0020,   /* U+2E92 */
  0x0020,   /* U+2E93 */
  0x0020,   /* U+2E94 */
  0x0020,   /* U+2E95 */
  0x0020,   /* U+2E96 */
  0x0020,   /* U+2E97 */
  0x0020,   /* U+2E98 */
  0x0020,   /* U+2E99 */
  0x0020,   /* U+2E9A */
  0x0020,   /* U+2E9B */
  0x0020,   /* U+2E9C */
  0x0020,   /* U+2E9D */
  0x0020,   /* U+2E9E */
  0x0020,   /* U+2E9F */
  0x0020,   /* U+2EA0 */
  0x0020,   /* U+2EA1 */
  0x0020,   /* U+2EA2 */
  0x0020,   /* U+2EA3 */
  0x0020,   /* U+2EA4 */
  0x0020,   /* U+2EA5 */
  0x0020,   /* U+2EA6 */
  0x0020,   /* U+2EA7 */
  0x0020,   /* U+2EA8 */
  0x0020,   /* U+2EA9 */
  0x0020,   /* U+2EAA */
  0x0020,   /* U+2EAB */
  0x0020,   /* U+2EAC */
  0x0020,   /* U+2EAD */
  0x0020,   /* U+2EAE */
  0x0020,   /* U+2EAF */
  0x0020,   /* U+2EB0 */
  0x0020,   /* U+2EB1 */
  0x0020,   /* U+2EB2 */
  0x0020,   /* U+2EB3 */
  0x0020,   /* U+2EB4 */
  0x0020,   /* U+2EB5 */
  0x0020,   /* U+2EB6 */
  0x0020,   /* U+2EB7 */
  0x0020,   /* U+2EB8 */
  0x0020,   /* U+2EB9 */
  0x0020,   /* U+2EBA */
  0x0020,   /* U+2EBB */
  0x0020,   /* U+2EBC */
  0x0020,   /* U+2EBD */
  0x0020,   /* U+2EBE */
  0x0020,   /* U+2EBF */
  0x0020,   /* U+2EC0 */
  0x0020,   /* U+2EC1 */
  0x0020,   /* U+2EC2 */
  0x0020,   /* U+2EC3 */
  0x0020,   /* U+2EC4 */
  0x0020,   /* U+2EC5 */
  0x0020,   /* U+2EC6 */
  0x0020,   /* U+2EC7 */
  0x0020,   /* U+2EC8 */
  0x0020,   /* U+2EC9 */
  0x0020,   /* U+2ECA */
  0x0020,   /* U+2ECB */
  0x0020,   /* U+2ECC */
  0x0020,   /* U+2ECD */
  0x0020,   /* U+2ECE */
  0x0020,   /* U+2ECF */
  0x0020,   /* U+2ED0 */
  0x0020,   /* U+2ED1 */
  0x0020,   /* U+2ED2 */
  0x0020,   /* U+2ED3 */
  0x0020,   /* U+2ED4 */
  0x0020,   /* U+2ED5 */
  0x0020,   /* U+2ED6 */
  0x0020,   /* U+2ED7 */
  0x0020,   /* U+2ED8 */
  0x0020,   /* U+2ED9 */
  0x0020,   /* U+2EDA */
  0x0020,   /* U+2EDB */
  0x0020,   /* U+2EDC */
  0x0020,   /* U+2EDD */
  0x0020,   /* U+2EDE */
  0x0020,   /* U+2EDF */
  0x0020,   /* U+2EE0 */
  0x0020,   /* U+2EE1 */
  0x0020,   /* U+2EE2 */
  0x0020,   /* U+2EE3 */
  0x0020,   /* U+2EE4 */
  0x0020,   /* U+2EE5 */
  0x0020,   /* U+2EE6 */
  0x0020,   /* U+2EE7 */
  0x0020,   /* U+2EE8 */
  0x0020,   /* U+2EE9 */
  0x0020,   /* U+2EEA */
  0x0020,   /* U+2EEB */
  0x0020,   /* U+2EEC */
  0x0020,   /* U+2EED */
  0x0020,   /* U+2EEE */
  0x0020,   /* U+2EEF */
  0x0020,   /* U+2EF0 */
  0x0020,   /* U+2EF1 */
  0x0020,   /* U+2EF2 */
  0x0020,   /* U+2EF3 */
  0x0020,   /* U+2EF4 */
  0x0020,   /* U+2EF5 */
  0x0020,   /* U+2EF6 */
  0x0020,   /* U+2EF7 */
  0x0020,   /* U+2EF8 */
  0x0020,   /* U+2EF9 */
  0x0020,   /* U+2EFA */
  0x0020,   /* U+2EFB */
  0x0020,   /* U+2EFC */
  0x0020,   /* U+2EFD */
  0x0020,   /* U+2EFE */
  0x0020,   /* U+2EFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+2E00 */
  0x0002,   /* U+2E01 */
  0x0002,   /* U+2E02 */
  0x0002,   /* U+2E03 */
  0x0002,   /* U+2E04 */
  0x0002,   /* U+2E05 */
  0x0002,   /* U+2E06 */
  0x0002,   /* U+2E07 */
  0x0002,   /* U+2E08 */
  0x0002,   /* U+2E09 */
  0x0002,   /* U+2E0A */
  0x0002,   /* U+2E0B */
  0x0002,   /* U+2E0C */
  0x0002,   /* U+2E0D */
  0x0002,   /* U+2E0E */
  0x0002,   /* U+2E0F */
  0x0002,   /* U+2E10 */
  0x0002,   /* U+2E11 */
  0x0002,   /* U+2E12 */
  0x0002,   /* U+2E13 */
  0x0002,   /* U+2E14 */
  0x0002,   /* U+2E15 */
  0x0002,   /* U+2E16 */
  0x0002,   /* U+2E17 */
  0x0002,   /* U+2E18 */
  0x0002,   /* U+2E19 */
  0x0002,   /* U+2E1A */
  0x0002,   /* U+2E1B */
  0x0002,   /* U+2E1C */
  0x0002,   /* U+2E1D */
  0x0002,   /* U+2E1E */
  0x0002,   /* U+2E1F */
  0x0002,   /* U+2E20 */
  0x0002,   /* U+2E21 */
  0x0002,   /* U+2E22 */
  0x0002,   /* U+2E23 */
  0x0002,   /* U+2E24 */
  0x0002,   /* U+2E25 */
  0x0002,   /* U+2E26 */
  0x0002,   /* U+2E27 */
  0x0002,   /* U+2E28 */
  0x0002,   /* U+2E29 */
  0x0002,   /* U+2E2A */
  0x0002,   /* U+2E2B */
  0x0002,   /* U+2E2C */
  0x0002,   /* U+2E2D */
  0x0002,   /* U+2E2E */
  0x0002,   /* U+2E2F */
  0x0002,   /* U+2E30 */
  0x0002,   /* U+2E31 */
  0x0002,   /* U+2E32 */
  0x0002,   /* U+2E33 */
  0x0002,   /* U+2E34 */
  0x0002,   /* U+2E35 */
  0x0002,   /* U+2E36 */
  0x0002,   /* U+2E37 */
  0x0002,   /* U+2E38 */
  0x0002,   /* U+2E39 */
  0x0002,   /* U+2E3A */
  0x0002,   /* U+2E3B */
  0x0002,   /* U+2E3C */
  0x0002,   /* U+2E3D */
  0x0002,   /* U+2E3E */
  0x0002,   /* U+2E3F */
  0x0002,   /* U+2E40 */
  0x0002,   /* U+2E41 */
  0x0002,   /* U+2E42 */
  0x0002,   /* U+2E43 */
  0x0002,   /* U+2E44 */
  0x0002,   /* U+2E45 */
  0x0002,   /* U+2E46 */
  0x0002,   /* U+2E47 */
  0x0002,   /* U+2E48 */
  0x0002,   /* U+2E49 */
  0x0002,   /* U+2E4A */
  0x0002,   /* U+2E4B */
  0x0002,   /* U+2E4C */
  0x0002,   /* U+2E4D */
  0x0002,   /* U+2E4E */
  0x0002,   /* U+2E4F */
  0x0002,   /* U+2E50 */
  0x0002,   /* U+2E51 */
  0x0002,   /* U+2E52 */
  0x0002,   /* U+2E53 */
  0x0002,   /* U+2E54 */
  0x0002,   /* U+2E55 */
  0x0002,   /* U+2E56 */
  0x0002,   /* U+2E57 */
  0x0002,   /* U+2E58 */
  0x0002,   /* U+2E59 */
  0x0002,   /* U+2E5A */
  0x0002,   /* U+2E5B */
  0x0002,   /* U+2E5C */
  0x0002,   /* U+2E5D */
  0x0002,   /* U+2E5E */
  0x0002,   /* U+2E5F */
  0x0002,   /* U+2E60 */
  0x0002,   /* U+2E61 */
  0x0002,   /* U+2E62 */
  0x0002,   /* U+2E63 */
  0x0002,   /* U+2E64 */
  0x0002,   /* U+2E65 */
  0x0002,   /* U+2E66 */
  0x0002,   /* U+2E67 */
  0x0002,   /* U+2E68 */
  0x0002,   /* U+2E69 */
  0x0002,   /* U+2E6A */
  0x0002,   /* U+2E6B */
  0x0002,   /* U+2E6C */
  0x0002,   /* U+2E6D */
  0x0002,   /* U+2E6E */
  0x0002,   /* U+2E6F */
  0x0002,   /* U+2E70 */
  0x0002,   /* U+2E71 */
  0x0002,   /* U+2E72 */
  0x0002,   /* U+2E73 */
  0x0002,   /* U+2E74 */
  0x0002,   /* U+2E75 */
  0x0002,   /* U+2E76 */
  0x0002,   /* U+2E77 */
  0x0002,   /* U+2E78 */
  0x0002,   /* U+2E79 */
  0x0002,   /* U+2E7A */
  0x0002,   /* U+2E7B */
  0x0002,   /* U+2E7C */
  0x0002,   /* U+2E7D */
  0x0002,   /* U+2E7E */
  0x0002,   /* U+2E7F */
  0x0002,   /* U+2E80 */
  0x0004,   /* U+2E81 */
  0x0004,   /* U+2E82 */
  0x0004,   /* U+2E83 */
  0x0002,   /* U+2E84 */
  0x0004,   /* U+2E85 */
  0x0002,   /* U+2E86 */
  0x0002,   /* U+2E87 */
  0x0002,   /* U+2E88 */
  0x0004,   /* U+2E89 */
  0x0002,   /* U+2E8A */
  0x0004,   /* U+2E8B */
  0x0002,   /* U+2E8C */
  0x0002,   /* U+2E8D */
  0x0004,   /* U+2E8E */
  0x0004,   /* U+2E8F */
  0x0004,   /* U+2E90 */
  0x0004,   /* U+2E91 */
  0x0004,   /* U+2E92 */
  0x0004,   /* U+2E93 */
  0x0004,   /* U+2E94 */
  0x0002,   /* U+2E95 */
  0x0004,   /* U+2E96 */
  0x0004,   /* U+2E97 */
  0x0004,   /* U+2E98 */
  0x0004,   /* U+2E99 */
  0x0002,   /* U+2E9A */
  0x0004,   /* U+2E9B */
  0x0002,   /* U+2E9C */
  0x0002,   /* U+2E9D */
  0x0004,   /* U+2E9E */
  0x0004,   /* U+2E9F */
  0x0004,   /* U+2EA0 */
  0x0004,   /* U+2EA1 */
  0x0004,   /* U+2EA2 */
  0x0004,   /* U+2EA3 */
  0x0004,   /* U+2EA4 */
  0x0002,   /* U+2EA5 */
  0x0004,   /* U+2EA6 */
  0x0002,   /* U+2EA7 */
  0x0004,   /* U+2EA8 */
  0x0004,   /* U+2EA9 */
  0x0002,   /* U+2EAA */
  0x0004,   /* U+2EAB */
  0x0002,   /* U+2EAC */
  0x0004,   /* U+2EAD */
  0x0002,   /* U+2EAE */
  0x0004,   /* U+2EAF */
  0x0004,   /* U+2EB0 */
  0x0004,   /* U+2EB1 */
  0x0004,   /* U+2EB2 */
  0x0004,   /* U+2EB3 */
  0x0004,   /* U+2EB4 */
  0x0004,   /* U+2EB5 */
  0x0002,   /* U+2EB6 */
  0x0004,   /* U+2EB7 */
  0x0004,   /* U+2EB8 */
  0x0004,   /* U+2EB9 */
  0x0004,   /* U+2EBA */
  0x0004,   /* U+2EBB */
  0x0002,   /* U+2EBC */
  0x0004,   /* U+2EBD */
  0x0002,   /* U+2EBE */
  0x0004,   /* U+2EBF */
  0x0004,   /* U+2EC0 */
  0x0004,   /* U+2EC1 */
  0x0004,   /* U+2EC2 */
  0x0004,   /* U+2EC3 */
  0x0004,   /* U+2EC4 */
  0x0004,   /* U+2EC5 */
  0x0002,   /* U+2EC6 */
  0x0004,   /* U+2EC7 */
  0x0004,   /* U+2EC8 */
  0x0004,   /* U+2EC9 */
  0x0002,   /* U+2ECA */
  0x0004,   /* U+2ECB */
  0x0002,   /* U+2ECC */
  0x0002,   /* U+2ECD */
  0x0004,   /* U+2ECE */
  0x0002,   /* U+2ECF */
  0x0004,   /* U+2ED0 */
  0x0004,   /* U+2ED1 */
  0x0004,   /* U+2ED2 */
  0x0004,   /* U+2ED3 */
  0x0004,   /* U+2ED4 */
  0x0004,   /* U+2ED5 */
  0x0002,   /* U+2ED6 */
  0x0002,   /* U+2ED7 */
  0x0004,   /* U+2ED8 */
  0x0004,   /* U+2ED9 */
  0x0004,   /* U+2EDA */
  0x0004,   /* U+2EDB */
  0x0004,   /* U+2EDC */
  0x0004,   /* U+2EDD */
  0x0002,   /* U+2EDE */
  0x0004,   /* U+2EDF */
  0x0004,   /* U+2EE0 */
  0x0004,   /* U+2EE1 */
  0x0004,   /* U+2EE2 */
  0x0002,   /* U+2EE3 */
  0x0004,   /* U+2EE4 */
  0x0004,   /* U+2EE5 */
  0x0004,   /* U+2EE6 */
  0x0004,   /* U+2EE7 */
  0x0004,   /* U+2EE8 */
  0x0004,   /* U+2EE9 */
  0x0004,   /* U+2EEA */
  0x0004,   /* U+2EEB */
  0x0004,   /* U+2EEC */
  0x0004,   /* U+2EED */
  0x0004,   /* U+2EEE */
  0x0004,   /* U+2EEF */
  0x0004,   /* U+2EF0 */
  0x0004,   /* U+2EF1 */
  0x0004,   /* U+2EF2 */
  0x0004,   /* U+2EF3 */
  0x0002,   /* U+2EF4 */
  0x0002,   /* U+2EF5 */
  0x0002,   /* U+2EF6 */
  0x0002,   /* U+2EF7 */
  0x0002,   /* U+2EF8 */
  0x0002,   /* U+2EF9 */
  0x0002,   /* U+2EFA */
  0x0002,   /* U+2EFB */
  0x0002,   /* U+2EFC */
  0x0002,   /* U+2EFD */
  0x0002,   /* U+2EFE */
  0x0002,   /* U+2EFF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+2E00 */
  0x0000,   /* U+2E01 */
  0x0000,   /* U+2E02 */
  0x0000,   /* U+2E03 */
  0x0000,   /* U+2E04 */
  0x0000,   /* U+2E05 */
  0x0000,   /* U+2E06 */
  0x0000,   /* U+2E07 */
  0x0000,   /* U+2E08 */
  0x0000,   /* U+2E09 */
  0x0000,   /* U+2E0A */
  0x0000,   /* U+2E0B */
  0x0000,   /* U+2E0C */
  0x0000,   /* U+2E0D */
  0x0000,   /* U+2E0E */
  0x0000,   /* U+2E0F */
  0x0000,   /* U+2E10 */
  0x0000,   /* U+2E11 */
  0x0000,   /* U+2E12 */
  0x0000,   /* U+2E13 */
  0x0000,   /* U+2E14 */
  0x0000,   /* U+2E15 */
  0x0000,   /* U+2E16 */
  0x0000,   /* U+2E17 */
  0x0000,   /* U+2E18 */
  0x0000,   /* U+2E19 */
  0x0000,   /* U+2E1A */
  0x0000,   /* U+2E1B */
  0x0000,   /* U+2E1C */
  0x0000,   /* U+2E1D */
  0x0000,   /* U+2E1E */
  0x0000,   /* U+2E1F */
  0x0000,   /* U+2E20 */
  0x0000,   /* U+2E21 */
  0x0000,   /* U+2E22 */
  0x0000,   /* U+2E23 */
  0x0000,   /* U+2E24 */
  0x0000,   /* U+2E25 */
  0x0000,   /* U+2E26 */
  0x0000,   /* U+2E27 */
  0x0000,   /* U+2E28 */
  0x0000,   /* U+2E29 */
  0x0000,   /* U+2E2A */
  0x0000,   /* U+2E2B */
  0x0000,   /* U+2E2C */
  0x0000,   /* U+2E2D */
  0x0000,   /* U+2E2E */
  0x0000,   /* U+2E2F */
  0x0000,   /* U+2E30 */
  0x0000,   /* U+2E31 */
  0x0000,   /* U+2E32 */
  0x0000,   /* U+2E33 */
  0x0000,   /* U+2E34 */
  0x0000,   /* U+2E35 */
  0x0000,   /* U+2E36 */
  0x0000,   /* U+2E37 */
  0x0000,   /* U+2E38 */
  0x0000,   /* U+2E39 */
  0x0000,   /* U+2E3A */
  0x0000,   /* U+2E3B */
  0x0000,   /* U+2E3C */
  0x0000,   /* U+2E3D */
  0x0000,   /* U+2E3E */
  0x0000,   /* U+2E3F */
  0x0000,   /* U+2E40 */
  0x0000,   /* U+2E41 */
  0x0000,   /* U+2E42 */
  0x0000,   /* U+2E43 */
  0x0000,   /* U+2E44 */
  0xAE45,   /* U+2E45 */
  0xAE46,   /* U+2E46 */
  0xAE47,   /* U+2E47 */
  0xAE48,   /* U+2E48 */
  0xAE49,   /* U+2E49 */
  0xAE4A,   /* U+2E4A */
  0xAE4B,   /* U+2E4B */
  0xAE4C,   /* U+2E4C */
  0xAE4D,   /* U+2E4D */
  0xAE4E,   /* U+2E4E */
  0xAE4F,   /* U+2E4F */
  0xAE50,   /* U+2E50 */
  0xAE51,   /* U+2E51 */
  0xAE52,   /* U+2E52 */
  0xAE53,   /* U+2E53 */
  0xAE54,   /* U+2E54 */
  0xAE55,   /* U+2E55 */
  0xAE56,   /* U+2E56 */
  0xAE57,   /* U+2E57 */
  0xAE58,   /* U+2E58 */
  0xAE59,   /* U+2E59 */
  0xAE5A,   /* U+2E5A */
  0xAE5B,   /* U+2E5B */
  0xAE5C,   /* U+2E5C */
  0xAE5D,   /* U+2E5D */
  0xAE5E,   /* U+2E5E */
  0xAE5F,   /* U+2E5F */
  0xAE60,   /* U+2E60 */
  0xAE61,   /* U+2E61 */
  0xAE62,   /* U+2E62 */
  0xAE63,   /* U+2E63 */
  0xAE64,   /* U+2E64 */
  0xAE65,   /* U+2E65 */
  0xAE66,   /* U+2E66 */
  0xAE67,   /* U+2E67 */
  0xAE68,   /* U+2E68 */
  0xAE69,   /* U+2E69 */
  0xAE6A,   /* U+2E6A */
  0xAE6B,   /* U+2E6B */
  0xAE6C,   /* U+2E6C */
  0xAE6D,   /* U+2E6D */
  0xAE6E,   /* U+2E6E */
  0xAE6F,   /* U+2E6F */
  0xAE70,   /* U+2E70 */
  0xAE71,   /* U+2E71 */
  0xAE72,   /* U+2E72 */
  0xAE73,   /* U+2E73 */
  0xAE74,   /* U+2E74 */
  0xAE75,   /* U+2E75 */
  0xAE76,   /* U+2E76 */
  0xAE77,   /* U+2E77 */
  0xAE78,   /* U+2E78 */
  0xAE79,   /* U+2E79 */
  0xAE7A,   /* U+2E7A */
  0xAE7B,   /* U+2E7B */
  0xAE7C,   /* U+2E7C */
  0xAE7D,   /* U+2E7D */
  0xAE7E,   /* U+2E7E */
  0xAE7F,   /* U+2E7F */
  0x8051,   /* U+2E80 */
  0x804F,   /* U+2E81 */
  0x800B,   /* U+2E82 */
  0x8009,   /* U+2E83 */
  0x800A,   /* U+2E84 */
  0x802F,   /* U+2E85 */
  0x8034,   /* U+2E86 */
  0x803A,   /* U+2E87 */
  0x8040,   /* U+2E88 */
  0x8041,   /* U+2E89 */
  0x804B,   /* U+2E8A */
  0x804D,   /* U+2E8B */
  0x8083,   /* U+2E8C */
  0x8084,   /* U+2E8D */
  0x8088,   /* U+2E8E */
  0x8134,   /* U+2E8F */
  0x8088,   /* U+2E90 */
  0x8134,   /* U+2E91 */
  0x809A,   /* U+2E92 */
  0x809E,   /* U+2E93 */
  0x80AA,   /* U+2E94 */
  0x80A9,   /* U+2E95 */
  0x80AD,   /* U+2E96 */
  0x816A,   /* U+2E97 */
  0x80AF,   /* U+2E98 */
  0x8179,   /* U+2E99 */
  0xAE9A,   /* U+2E9A */
  0x8181,   /* U+2E9B */
  0x8182,   /* U+2E9C */
  0x8185,   /* U+2E9D */
  0x82AE,   /* U+2E9E */
  0x82B0,   /* U+2E9F */
  0x82B3,   /* U+2EA0 */
  0x80B4,   /* U+2EA1 */
  0x82B6,   /* U+2EA2 */
  0x81A1,   /* U+2EA3 */
  0x81A4,   /* U+2EA4 */
  0x81A3,   /* U+2EA5 */
  0x81A9,   /* U+2EA6 */
  0x81AF,   /* U+2EA7 */
  0x80B7,   /* U+2EA8 */
  0x81B6,   /* U+2EA9 */
  0x8304,   /* U+2EAA */
  0x830C,   /* U+2EAB */
  0x8312,   /* U+2EAC */
  0x81BA,   /* U+2EAD */
  0x85BE,   /* U+2EAE */
  0x85D1,   /* U+2EAF */
  0x80B8,   /* U+2EB0 */
  0x81BD,   /* U+2EB1 */
  0x831E,   /* U+2EB2 */
  0x81BD,   /* U+2EB3 */
  0x81BD,   /* U+2EB4 */
  0x831E,   /* U+2EB5 */
  0x85E5,   /* U+2EB6 */
  0x85E3,   /* U+2EB7 */
  0x8D8A,   /* U+2EB8 */
  0x81BE,   /* U+2EB9 */
  0x81BF,   /* U+2EBA */
  0x85F1,   /* U+2EBB */
  0x81C0,   /* U+2EBC */
  0x860D,   /* U+2EBD */
  0x80B9,   /* U+2EBE */
  0x80BA,   /* U+2EBF */
  0x80BA,   /* U+2EC0 */
  0x8E9F,   /* U+2EC1 */
  0x8330,   /* U+2EC2 */
  0x863D,   /* U+2EC3 */
  0x863C,   /* U+2EC4 */
  0x81C1,   /* U+2EC5 */
  0x8A58,   /* U+2EC6 */
  0x8A57,   /* U+2EC7 */
  0x805A,   /* U+2EC8 */
  0x81C8,   /* U+2EC9 */
  0x8AA0,   /* U+2ECA */
  0x81C9,   /* U+2ECB */
  0x80BB,   /* U+2ECC */
  0x81CA,   /* U+2ECD */
  0x81CB,   /* U+2ECE */
  0x805C,   /* U+2ECF */
  0x835C,   /* U+2ED0 */
  0x8FF2,   /* U+2ED1 */
  0x8FF3,   /* U+2ED2 */
  0x835D,   /* U+2ED3 */
  0x80BD,   /* U+2ED4 */
  0x9002,   /* U+2ED5 */
  0x805D,   /* U+2ED6 */
  0x903D,   /* U+2ED7 */
  0x9040,   /* U+2ED8 */
  0x81D7,   /* U+2ED9 */
  0x86DA,   /* U+2EDA */
  0x81D8,   /* U+2EDB */
  0x80BF,   /* U+2EDC */
  0x949B,   /* U+2EDD */
  0x949D,   /* U+2EDE */
  0x949C,   /* U+2EDF */
  0x80C0,   /* U+2EE0 */
  0x94B5,   /* U+2EE1 */
  0x80C1,   /* U+2EE2 */
  0x94DD,   /* U+2EE3 */
  0x98EA,   /* U+2EE4 */
  0x9093,   /* U+2EE5 */
  0x8372,   /* U+2EE6 */
  0x9C42,   /* U+2EE7 */
  0x8BB1,   /* U+2EE8 */
  0x9F60,   /* U+2EE9 */
  0x909B,   /* U+2EEA */
  0x9D6F,   /* U+2EEB */
  0x86EB,   /* U+2EEC */
  0x9CAB,   /* U+2EED */
  0x909D,   /* U+2EEE */
  0x9A06,   /* U+2EEF */
  0x8373,   /* U+2EF0 */
  0x9A08,   /* U+2EF1 */
  0x9A08,   /* U+2EF2 */
  0x8BB2,   /* U+2EF3 */
  0xAEF4,   /* U+2EF4 */
  0xAEF5,   /* U+2EF5 */
  0xAEF6,   /* U+2EF6 */
  0xAEF7,   /* U+2EF7 */
  0xAEF8,   /* U+2EF8 */
  0xAEF9,   /* U+2EF9 */
  0xAEFA,   /* U+2EFA */
  0xAEFB,   /* U+2EFB */
  0xAEFC,   /* U+2EFC */
  0xAEFD,   /* U+2EFD */
  0xAEFE,   /* U+2EFE */
  0xAEFF,   /* U+2EFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+2E00 */
  0x0000,   /* U+2E01 */
  0x0000,   /* U+2E02 */
  0x0000,   /* U+2E03 */
  0x0000,   /* U+2E04 */
  0x0000,   /* U+2E05 */
  0x0000,   /* U+2E06 */
  0x0000,   /* U+2E07 */
  0x0000,   /* U+2E08 */
  0x0000,   /* U+2E09 */
  0x0000,   /* U+2E0A */
  0x0000,   /* U+2E0B */
  0x0000,   /* U+2E0C */
  0x0000,   /* U+2E0D */
  0x0000,   /* U+2E0E */
  0x0000,   /* U+2E0F */
  0x0000,   /* U+2E10 */
  0x0000,   /* U+2E11 */
  0x0000,   /* U+2E12 */
  0x0000,   /* U+2E13 */
  0x0000,   /* U+2E14 */
  0x0000,   /* U+2E15 */
  0x0000,   /* U+2E16 */
  0x0000,   /* U+2E17 */
  0x0000,   /* U+2E18 */
  0x0000,   /* U+2E19 */
  0x0000,   /* U+2E1A */
  0x0000,   /* U+2E1B */
  0x0000,   /* U+2E1C */
  0x0000,   /* U+2E1D */
  0x0000,   /* U+2E1E */
  0x0000,   /* U+2E1F */
  0x0000,   /* U+2E20 */
  0x0000,   /* U+2E21 */
  0x0000,   /* U+2E22 */
  0x0000,   /* U+2E23 */
  0x0000,   /* U+2E24 */
  0x0000,   /* U+2E25 */
  0x0000,   /* U+2E26 */
  0x0000,   /* U+2E27 */
  0x0000,   /* U+2E28 */
  0x0000,   /* U+2E29 */
  0x0000,   /* U+2E2A */
  0x0000,   /* U+2E2B */
  0x0000,   /* U+2E2C */
  0x0000,   /* U+2E2D */
  0x0000,   /* U+2E2E */
  0x0000,   /* U+2E2F */
  0x0000,   /* U+2E30 */
  0x0000,   /* U+2E31 */
  0x0000,   /* U+2E32 */
  0x0000,   /* U+2E33 */
  0x0000,   /* U+2E34 */
  0x0000,   /* U+2E35 */
  0x0000,   /* U+2E36 */
  0x0000,   /* U+2E37 */
  0x0000,   /* U+2E38 */
  0x0000,   /* U+2E39 */
  0x0000,   /* U+2E3A */
  0x0000,   /* U+2E3B */
  0x0000,   /* U+2E3C */
  0x0000,   /* U+2E3D */
  0x0000,   /* U+2E3E */
  0x0000,   /* U+2E3F */
  0x0000,   /* U+2E40 */
  0x0000,   /* U+2E41 */
  0x0000,   /* U+2E42 */
  0x0000,   /* U+2E43 */
  0x0000,   /* U+2E44 */
  0x0000,   /* U+2E45 */
  0x0000,   /* U+2E46 */
  0x0000,   /* U+2E47 */
  0x0000,   /* U+2E48 */
  0x0000,   /* U+2E49 */
  0x0000,   /* U+2E4A */
  0x0000,   /* U+2E4B */
  0x0000,   /* U+2E4C */
  0x0000,   /* U+2E4D */
  0x0000,   /* U+2E4E */
  0x0000,   /* U+2E4F */
  0x0000,   /* U+2E50 */
  0x0000,   /* U+2E51 */
  0x0000,   /* U+2E52 */
  0x0000,   /* U+2E53 */
  0x0000,   /* U+2E54 */
  0x0000,   /* U+2E55 */
  0x0000,   /* U+2E56 */
  0x0000,   /* U+2E57 */
  0x0000,   /* U+2E58 */
  0x0000,   /* U+2E59 */
  0x0000,   /* U+2E5A */
  0x0000,   /* U+2E5B */
  0x0000,   /* U+2E5C */
  0x0000,   /* U+2E5D */
  0x0000,   /* U+2E5E */
  0x0000,   /* U+2E5F */
  0x0000,   /* U+2E60 */
  0x0000,   /* U+2E61 */
  0x0000,   /* U+2E62 */
  0x0000,   /* U+2E63 */
  0x0000,   /* U+2E64 */
  0x0000,   /* U+2E65 */
  0x0000,   /* U+2E66 */
  0x0000,   /* U+2E67 */
  0x0000,   /* U+2E68 */
  0x0000,   /* U+2E69 */
  0x0000,   /* U+2E6A */
  0x0000,   /* U+2E6B */
  0x0000,   /* U+2E6C */
  0x0000,   /* U+2E6D */
  0x0000,   /* U+2E6E */
  0x0000,   /* U+2E6F */
  0x0000,   /* U+2E70 */
  0x0000,   /* U+2E71 */
  0x0000,   /* U+2E72 */
  0x0000,   /* U+2E73 */
  0x0000,   /* U+2E74 */
  0x0000,   /* U+2E75 */
  0x0000,   /* U+2E76 */
  0x0000,   /* U+2E77 */
  0x0000,   /* U+2E78 */
  0x0000,   /* U+2E79 */
  0x0000,   /* U+2E7A */
  0x0000,   /* U+2E7B */
  0x0000,   /* U+2E7C */
  0x0000,   /* U+2E7D */
  0x0000,   /* U+2E7E */
  0x0000,   /* U+2E7F */
  0x0000,   /* U+2E80 */
  0x0000,   /* U+2E81 */
  0x0000,   /* U+2E82 */
  0x0000,   /* U+2E83 */
  0x0000,   /* U+2E84 */
  0x0000,   /* U+2E85 */
  0x0000,   /* U+2E86 */
  0x0000,   /* U+2E87 */
  0x0000,   /* U+2E88 */
  0x0000,   /* U+2E89 */
  0x0000,   /* U+2E8A */
  0x0000,   /* U+2E8B */
  0x0000,   /* U+2E8C */
  0x0000,   /* U+2E8D */
  0x0000,   /* U+2E8E */
  0x0000,   /* U+2E8F */
  0x0000,   /* U+2E90 */
  0x0000,   /* U+2E91 */
  0x0000,   /* U+2E92 */
  0x0000,   /* U+2E93 */
  0x0000,   /* U+2E94 */
  0x0000,   /* U+2E95 */
  0x0000,   /* U+2E96 */
  0x0000,   /* U+2E97 */
  0x0000,   /* U+2E98 */
  0x0000,   /* U+2E99 */
  0x0000,   /* U+2E9A */
  0x0000,   /* U+2E9B */
  0x0000,   /* U+2E9C */
  0x0000,   /* U+2E9D */
  0x0000,   /* U+2E9E */
  0x0000,   /* U+2E9F */
  0x0000,   /* U+2EA0 */
  0x0000,   /* U+2EA1 */
  0x0000,   /* U+2EA2 */
  0x0000,   /* U+2EA3 */
  0x0000,   /* U+2EA4 */
  0x0000,   /* U+2EA5 */
  0x0000,   /* U+2EA6 */
  0x0000,   /* U+2EA7 */
  0x0000,   /* U+2EA8 */
  0x0000,   /* U+2EA9 */
  0x0000,   /* U+2EAA */
  0x0000,   /* U+2EAB */
  0x0000,   /* U+2EAC */
  0x0000,   /* U+2EAD */
  0x0000,   /* U+2EAE */
  0x0000,   /* U+2EAF */
  0x0000,   /* U+2EB0 */
  0x0000,   /* U+2EB1 */
  0x0000,   /* U+2EB2 */
  0x0000,   /* U+2EB3 */
  0x0000,   /* U+2EB4 */
  0x0000,   /* U+2EB5 */
  0x0000,   /* U+2EB6 */
  0x0000,   /* U+2EB7 */
  0x0000,   /* U+2EB8 */
  0x0000,   /* U+2EB9 */
  0x0000,   /* U+2EBA */
  0x0000,   /* U+2EBB */
  0x0000,   /* U+2EBC */
  0x0000,   /* U+2EBD */
  0x0000,   /* U+2EBE */
  0x0000,   /* U+2EBF */
  0x0000,   /* U+2EC0 */
  0x0000,   /* U+2EC1 */
  0x0000,   /* U+2EC2 */
  0x0000,   /* U+2EC3 */
  0x0000,   /* U+2EC4 */
  0x0000,   /* U+2EC5 */
  0x0000,   /* U+2EC6 */
  0x0000,   /* U+2EC7 */
  0x0000,   /* U+2EC8 */
  0x0000,   /* U+2EC9 */
  0x0000,   /* U+2ECA */
  0x0000,   /* U+2ECB */
  0x0000,   /* U+2ECC */
  0x0000,   /* U+2ECD */
  0x0000,   /* U+2ECE */
  0x0000,   /* U+2ECF */
  0x0000,   /* U+2ED0 */
  0x0000,   /* U+2ED1 */
  0x0000,   /* U+2ED2 */
  0x0000,   /* U+2ED3 */
  0x0000,   /* U+2ED4 */
  0x0000,   /* U+2ED5 */
  0x0000,   /* U+2ED6 */
  0x0000,   /* U+2ED7 */
  0x0000,   /* U+2ED8 */
  0x0000,   /* U+2ED9 */
  0x0000,   /* U+2EDA */
  0x0000,   /* U+2EDB */
  0x0000,   /* U+2EDC */
  0x0000,   /* U+2EDD */
  0x0000,   /* U+2EDE */
  0x0000,   /* U+2EDF */
  0x0000,   /* U+2EE0 */
  0x0000,   /* U+2EE1 */
  0x0000,   /* U+2EE2 */
  0x0000,   /* U+2EE3 */
  0x0000,   /* U+2EE4 */
  0x0000,   /* U+2EE5 */
  0x0000,   /* U+2EE6 */
  0x0000,   /* U+2EE7 */
  0x0000,   /* U+2EE8 */
  0x0000,   /* U+2EE9 */
  0x0000,   /* U+2EEA */
  0x0000,   /* U+2EEB */
  0x0000,   /* U+2EEC */
  0x0000,   /* U+2EED */
  0x0000,   /* U+2EEE */
  0x0000,   /* U+2EEF */
  0x0000,   /* U+2EF0 */
  0x0000,   /* U+2EF1 */
  0x0000,   /* U+2EF2 */
  0x0000,   /* U+2EF3 */
  0x0000,   /* U+2EF4 */
  0x0000,   /* U+2EF5 */
  0x0000,   /* U+2EF6 */
  0x0000,   /* U+2EF7 */
  0x0000,   /* U+2EF8 */
  0x0000,   /* U+2EF9 */
  0x0000,   /* U+2EFA */
  0x0000,   /* U+2EFB */
  0x0000,   /* U+2EFC */
  0x0000,   /* U+2EFD */
  0x0000,   /* U+2EFE */
  0x0000,   /* U+2EFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+2E00 */
  0x0000,   /* U+2E01 */
  0x0000,   /* U+2E02 */
  0x0000,   /* U+2E03 */
  0x0000,   /* U+2E04 */
  0x0000,   /* U+2E05 */
  0x0000,   /* U+2E06 */
  0x0000,   /* U+2E07 */
  0x0000,   /* U+2E08 */
  0x0000,   /* U+2E09 */
  0x0000,   /* U+2E0A */
  0x0000,   /* U+2E0B */
  0x0000,   /* U+2E0C */
  0x0000,   /* U+2E0D */
  0x0000,   /* U+2E0E */
  0x0000,   /* U+2E0F */
  0x0000,   /* U+2E10 */
  0x0000,   /* U+2E11 */
  0x0000,   /* U+2E12 */
  0x0000,   /* U+2E13 */
  0x0000,   /* U+2E14 */
  0x0000,   /* U+2E15 */
  0x0000,   /* U+2E16 */
  0x0000,   /* U+2E17 */
  0x0000,   /* U+2E18 */
  0x0000,   /* U+2E19 */
  0x0000,   /* U+2E1A */
  0x0000,   /* U+2E1B */
  0x0000,   /* U+2E1C */
  0x0000,   /* U+2E1D */
  0x0000,   /* U+2E1E */
  0x0000,   /* U+2E1F */
  0x0000,   /* U+2E20 */
  0x0000,   /* U+2E21 */
  0x0000,   /* U+2E22 */
  0x0000,   /* U+2E23 */
  0x0000,   /* U+2E24 */
  0x0000,   /* U+2E25 */
  0x0000,   /* U+2E26 */
  0x0000,   /* U+2E27 */
  0x0000,   /* U+2E28 */
  0x0000,   /* U+2E29 */
  0x0000,   /* U+2E2A */
  0x0000,   /* U+2E2B */
  0x0000,   /* U+2E2C */
  0x0000,   /* U+2E2D */
  0x0000,   /* U+2E2E */
  0x0000,   /* U+2E2F */
  0x0000,   /* U+2E30 */
  0x0000,   /* U+2E31 */
  0x0000,   /* U+2E32 */
  0x0000,   /* U+2E33 */
  0x0000,   /* U+2E34 */
  0x0000,   /* U+2E35 */
  0x0000,   /* U+2E36 */
  0x0000,   /* U+2E37 */
  0x0000,   /* U+2E38 */
  0x0000,   /* U+2E39 */
  0x0000,   /* U+2E3A */
  0x0000,   /* U+2E3B */
  0x0000,   /* U+2E3C */
  0x0000,   /* U+2E3D */
  0x0000,   /* U+2E3E */
  0x0000,   /* U+2E3F */
  0x0000,   /* U+2E40 */
  0x0000,   /* U+2E41 */
  0x0000,   /* U+2E42 */
  0x0000,   /* U+2E43 */
  0x0000,   /* U+2E44 */
  0x0000,   /* U+2E45 */
  0x0000,   /* U+2E46 */
  0x0000,   /* U+2E47 */
  0x0000,   /* U+2E48 */
  0x0000,   /* U+2E49 */
  0x0000,   /* U+2E4A */
  0x0000,   /* U+2E4B */
  0x0000,   /* U+2E4C */
  0x0000,   /* U+2E4D */
  0x0000,   /* U+2E4E */
  0x0000,   /* U+2E4F */
  0x0000,   /* U+2E50 */
  0x0000,   /* U+2E51 */
  0x0000,   /* U+2E52 */
  0x0000,   /* U+2E53 */
  0x0000,   /* U+2E54 */
  0x0000,   /* U+2E55 */
  0x0000,   /* U+2E56 */
  0x0000,   /* U+2E57 */
  0x0000,   /* U+2E58 */
  0x0000,   /* U+2E59 */
  0x0000,   /* U+2E5A */
  0x0000,   /* U+2E5B */
  0x0000,   /* U+2E5C */
  0x0000,   /* U+2E5D */
  0x0000,   /* U+2E5E */
  0x0000,   /* U+2E5F */
  0x0000,   /* U+2E60 */
  0x0000,   /* U+2E61 */
  0x0000,   /* U+2E62 */
  0x0000,   /* U+2E63 */
  0x0000,   /* U+2E64 */
  0x0000,   /* U+2E65 */
  0x0000,   /* U+2E66 */
  0x0000,   /* U+2E67 */
  0x0000,   /* U+2E68 */
  0x0000,   /* U+2E69 */
  0x0000,   /* U+2E6A */
  0x0000,   /* U+2E6B */
  0x0000,   /* U+2E6C */
  0x0000,   /* U+2E6D */
  0x0000,   /* U+2E6E */
  0x0000,   /* U+2E6F */
  0x0000,   /* U+2E70 */
  0x0000,   /* U+2E71 */
  0x0000,   /* U+2E72 */
  0x0000,   /* U+2E73 */
  0x0000,   /* U+2E74 */
  0x0000,   /* U+2E75 */
  0x0000,   /* U+2E76 */
  0x0000,   /* U+2E77 */
  0x0000,   /* U+2E78 */
  0x0000,   /* U+2E79 */
  0x0000,   /* U+2E7A */
  0x0000,   /* U+2E7B */
  0x0000,   /* U+2E7C */
  0x0000,   /* U+2E7D */
  0x0000,   /* U+2E7E */
  0x0000,   /* U+2E7F */
  0x0000,   /* U+2E80 */
  0x0000,   /* U+2E81 */
  0x0000,   /* U+2E82 */
  0x0000,   /* U+2E83 */
  0x0000,   /* U+2E84 */
  0x0000,   /* U+2E85 */
  0x0000,   /* U+2E86 */
  0x0000,   /* U+2E87 */
  0x0000,   /* U+2E88 */
  0x0000,   /* U+2E89 */
  0x0000,   /* U+2E8A */
  0x0000,   /* U+2E8B */
  0x0000,   /* U+2E8C */
  0x0000,   /* U+2E8D */
  0x0000,   /* U+2E8E */
  0x0000,   /* U+2E8F */
  0x0000,   /* U+2E90 */
  0x0000,   /* U+2E91 */
  0x0000,   /* U+2E92 */
  0x0000,   /* U+2E93 */
  0x0000,   /* U+2E94 */
  0x0000,   /* U+2E95 */
  0x0000,   /* U+2E96 */
  0x0000,   /* U+2E97 */
  0x0000,   /* U+2E98 */
  0x0000,   /* U+2E99 */
  0x0000,   /* U+2E9A */
  0x0000,   /* U+2E9B */
  0x0000,   /* U+2E9C */
  0x0000,   /* U+2E9D */
  0x0000,   /* U+2E9E */
  0x0000,   /* U+2E9F */
  0x0000,   /* U+2EA0 */
  0x0000,   /* U+2EA1 */
  0x0000,   /* U+2EA2 */
  0x0000,   /* U+2EA3 */
  0x0000,   /* U+2EA4 */
  0x0000,   /* U+2EA5 */
  0x0000,   /* U+2EA6 */
  0x0000,   /* U+2EA7 */
  0x0000,   /* U+2EA8 */
  0x0000,   /* U+2EA9 */
  0x0000,   /* U+2EAA */
  0x0000,   /* U+2EAB */
  0x0000,   /* U+2EAC */
  0x0000,   /* U+2EAD */
  0x0000,   /* U+2EAE */
  0x0000,   /* U+2EAF */
  0x0000,   /* U+2EB0 */
  0x0000,   /* U+2EB1 */
  0x0000,   /* U+2EB2 */
  0x0000,   /* U+2EB3 */
  0x0000,   /* U+2EB4 */
  0x0000,   /* U+2EB5 */
  0x0000,   /* U+2EB6 */
  0x0000,   /* U+2EB7 */
  0x0000,   /* U+2EB8 */
  0x0000,   /* U+2EB9 */
  0x0000,   /* U+2EBA */
  0x0000,   /* U+2EBB */
  0x0000,   /* U+2EBC */
  0x0000,   /* U+2EBD */
  0x0000,   /* U+2EBE */
  0x0000,   /* U+2EBF */
  0x0000,   /* U+2EC0 */
  0x0000,   /* U+2EC1 */
  0x0000,   /* U+2EC2 */
  0x0000,   /* U+2EC3 */
  0x0000,   /* U+2EC4 */
  0x0000,   /* U+2EC5 */
  0x0000,   /* U+2EC6 */
  0x0000,   /* U+2EC7 */
  0x0000,   /* U+2EC8 */
  0x0000,   /* U+2EC9 */
  0x0000,   /* U+2ECA */
  0x0000,   /* U+2ECB */
  0x0000,   /* U+2ECC */
  0x0000,   /* U+2ECD */
  0x0000,   /* U+2ECE */
  0x0000,   /* U+2ECF */
  0x0000,   /* U+2ED0 */
  0x0000,   /* U+2ED1 */
  0x0000,   /* U+2ED2 */
  0x0000,   /* U+2ED3 */
  0x0000,   /* U+2ED4 */
  0x0000,   /* U+2ED5 */
  0x0000,   /* U+2ED6 */
  0x0000,   /* U+2ED7 */
  0x0000,   /* U+2ED8 */
  0x0000,   /* U+2ED9 */
  0x0000,   /* U+2EDA */
  0x0000,   /* U+2EDB */
  0x0000,   /* U+2EDC */
  0x0000,   /* U+2EDD */
  0x0000,   /* U+2EDE */
  0x0000,   /* U+2EDF */
  0x0000,   /* U+2EE0 */
  0x0000,   /* U+2EE1 */
  0x0000,   /* U+2EE2 */
  0x0000,   /* U+2EE3 */
  0x0000,   /* U+2EE4 */
  0x0000,   /* U+2EE5 */
  0x0000,   /* U+2EE6 */
  0x0000,   /* U+2EE7 */
  0x0000,   /* U+2EE8 */
  0x0000,   /* U+2EE9 */
  0x0000,   /* U+2EEA */
  0x0000,   /* U+2EEB */
  0x0000,   /* U+2EEC */
  0x0000,   /* U+2EED */
  0x0000,   /* U+2EEE */
  0x0000,   /* U+2EEF */
  0x0000,   /* U+2EF0 */
  0x0000,   /* U+2EF1 */
  0x0000,   /* U+2EF2 */
  0x0000,   /* U+2EF3 */
  0x0000,   /* U+2EF4 */
  0x0000,   /* U+2EF5 */
  0x0000,   /* U+2EF6 */
  0x0000,   /* U+2EF7 */
  0x0000,   /* U+2EF8 */
  0x0000,   /* U+2EF9 */
  0x0000,   /* U+2EFA */
  0x0000,   /* U+2EFB */
  0x0000,   /* U+2EFC */
  0x0000,   /* U+2EFD */
  0x0000,   /* U+2EFE */
  0x0000,   /* U+2EFF */

  /* Primary weight 3 for each character. */
  0x0000,   /* U+2E00 */
  0x0000,   /* U+2E01 */
  0x0000,   /* U+2E02 */
  0x0000,   /* U+2E03 */
  0x0000,   /* U+2E04 */
  0x0000,   /* U+2E05 */
  0x0000,   /* U+2E06 */
  0x0000,   /* U+2E07 */
  0x0000,   /* U+2E08 */
  0x0000,   /* U+2E09 */
  0x0000,   /* U+2E0A */
  0x0000,   /* U+2E0B */
  0x0000,   /* U+2E0C */
  0x0000,   /* U+2E0D */
  0x0000,   /* U+2E0E */
  0x0000,   /* U+2E0F */
  0x0000,   /* U+2E10 */
  0x0000,   /* U+2E11 */
  0x0000,   /* U+2E12 */
  0x0000,   /* U+2E13 */
  0x0000,   /* U+2E14 */
  0x0000,   /* U+2E15 */
  0x0000,   /* U+2E16 */
  0x0000,   /* U+2E17 */
  0x0000,   /* U+2E18 */
  0x0000,   /* U+2E19 */
  0x0000,   /* U+2E1A */
  0x0000,   /* U+2E1B */
  0x0000,   /* U+2E1C */
  0x0000,   /* U+2E1D */
  0x0000,   /* U+2E1E */
  0x0000,   /* U+2E1F */
  0x0000,   /* U+2E20 */
  0x0000,   /* U+2E21 */
  0x0000,   /* U+2E22 */
  0x0000,   /* U+2E23 */
  0x0000,   /* U+2E24 */
  0x0000,   /* U+2E25 */
  0x0000,   /* U+2E26 */
  0x0000,   /* U+2E27 */
  0x0000,   /* U+2E28 */
  0x0000,   /* U+2E29 */
  0x0000,   /* U+2E2A */
  0x0000,   /* U+2E2B */
  0x0000,   /* U+2E2C */
  0x0000,   /* U+2E2D */
  0x0000,   /* U+2E2E */
  0x0000,   /* U+2E2F */
  0x0000,   /* U+2E30 */
  0x0000,   /* U+2E31 */
  0x0000,   /* U+2E32 */
  0x0000,   /* U+2E33 */
  0x0000,   /* U+2E34 */
  0x0000,   /* U+2E35 */
  0x0000,   /* U+2E36 */
  0x0000,   /* U+2E37 */
  0x0000,   /* U+2E38 */
  0x0000,   /* U+2E39 */
  0x0000,   /* U+2E3A */
  0x0000,   /* U+2E3B */
  0x0000,   /* U+2E3C */
  0x0000,   /* U+2E3D */
  0x0000,   /* U+2E3E */
  0x0000,   /* U+2E3F */
  0x0000,   /* U+2E40 */
  0x0000,   /* U+2E41 */
  0x0000,   /* U+2E42 */
  0x0000,   /* U+2E43 */
  0x0000,   /* U+2E44 */
  0x0000,   /* U+2E45 */
  0x0000,   /* U+2E46 */
  0x0000,   /* U+2E47 */
  0x0000,   /* U+2E48 */
  0x0000,   /* U+2E49 */
  0x0000,   /* U+2E4A */
  0x0000,   /* U+2E4B */
  0x0000,   /* U+2E4C */
  0x0000,   /* U+2E4D */
  0x0000,   /* U+2E4E */
  0x0000,   /* U+2E4F */
  0x0000,   /* U+2E50 */
  0x0000,   /* U+2E51 */
  0x0000,   /* U+2E52 */
  0x0000,   /* U+2E53 */
  0x0000,   /* U+2E54 */
  0x0000,   /* U+2E55 */
  0x0000,   /* U+2E56 */
  0x0000,   /* U+2E57 */
  0x0000,   /* U+2E58 */
  0x0000,   /* U+2E59 */
  0x0000,   /* U+2E5A */
  0x0000,   /* U+2E5B */
  0x0000,   /* U+2E5C */
  0x0000,   /* U+2E5D */
  0x0000,   /* U+2E5E */
  0x0000,   /* U+2E5F */
  0x0000,   /* U+2E60 */
  0x0000,   /* U+2E61 */
  0x0000,   /* U+2E62 */
  0x0000,   /* U+2E63 */
  0x0000,   /* U+2E64 */
  0x0000,   /* U+2E65 */
  0x0000,   /* U+2E66 */
  0x0000,   /* U+2E67 */
  0x0000,   /* U+2E68 */
  0x0000,   /* U+2E69 */
  0x0000,   /* U+2E6A */
  0x0000,   /* U+2E6B */
  0x0000,   /* U+2E6C */
  0x0000,   /* U+2E6D */
  0x0000,   /* U+2E6E */
  0x0000,   /* U+2E6F */
  0x0000,   /* U+2E70 */
  0x0000,   /* U+2E71 */
  0x0000,   /* U+2E72 */
  0x0000,   /* U+2E73 */
  0x0000,   /* U+2E74 */
  0x0000,   /* U+2E75 */
  0x0000,   /* U+2E76 */
  0x0000,   /* U+2E77 */
  0x0000,   /* U+2E78 */
  0x0000,   /* U+2E79 */
  0x0000,   /* U+2E7A */
  0x0000,   /* U+2E7B */
  0x0000,   /* U+2E7C */
  0x0000,   /* U+2E7D */
  0x0000,   /* U+2E7E */
  0x0000,   /* U+2E7F */
  0x0000,   /* U+2E80 */
  0x0000,   /* U+2E81 */
  0x0000,   /* U+2E82 */
  0x0000,   /* U+2E83 */
  0x0000,   /* U+2E84 */
  0x0000,   /* U+2E85 */
  0x0000,   /* U+2E86 */
  0x0000,   /* U+2E87 */
  0x0000,   /* U+2E88 */
  0x0000,   /* U+2E89 */
  0x0000,   /* U+2E8A */
  0x0000,   /* U+2E8B */
  0x0000,   /* U+2E8C */
  0x0000,   /* U+2E8D */
  0x0000,   /* U+2E8E */
  0x0000,   /* U+2E8F */
  0x0000,   /* U+2E90 */
  0x0000,   /* U+2E91 */
  0x0000,   /* U+2E92 */
  0x0000,   /* U+2E93 */
  0x0000,   /* U+2E94 */
  0x0000,   /* U+2E95 */
  0x0000,   /* U+2E96 */
  0x0000,   /* U+2E97 */
  0x0000,   /* U+2E98 */
  0x0000,   /* U+2E99 */
  0x0000,   /* U+2E9A */
  0x0000,   /* U+2E9B */
  0x0000,   /* U+2E9C */
  0x0000,   /* U+2E9D */
  0x0000,   /* U+2E9E */
  0x0000,   /* U+2E9F */
  0x0000,   /* U+2EA0 */
  0x0000,   /* U+2EA1 */
  0x0000,   /* U+2EA2 */
  0x0000,   /* U+2EA3 */
  0x0000,   /* U+2EA4 */
  0x0000,   /* U+2EA5 */
  0x0000,   /* U+2EA6 */
  0x0000,   /* U+2EA7 */
  0x0000,   /* U+2EA8 */
  0x0000,   /* U+2EA9 */
  0x0000,   /* U+2EAA */
  0x0000,   /* U+2EAB */
  0x0000,   /* U+2EAC */
  0x0000,   /* U+2EAD */
  0x0000,   /* U+2EAE */
  0x0000,   /* U+2EAF */
  0x0000,   /* U+2EB0 */
  0x0000,   /* U+2EB1 */
  0x0000,   /* U+2EB2 */
  0x0000,   /* U+2EB3 */
  0x0000,   /* U+2EB4 */
  0x0000,   /* U+2EB5 */
  0x0000,   /* U+2EB6 */
  0x0000,   /* U+2EB7 */
  0x0000,   /* U+2EB8 */
  0x0000,   /* U+2EB9 */
  0x0000,   /* U+2EBA */
  0x0000,   /* U+2EBB */
  0x0000,   /* U+2EBC */
  0x0000,   /* U+2EBD */
  0x0000,   /* U+2EBE */
  0x0000,   /* U+2EBF */
  0x0000,   /* U+2EC0 */
  0x0000,   /* U+2EC1 */
  0x0000,   /* U+2EC2 */
  0x0000,   /* U+2EC3 */
  0x0000,   /* U+2EC4 */
  0x0000,   /* U+2EC5 */
  0x0000,   /* U+2EC6 */
  0x0000,   /* U+2EC7 */
  0x0000,   /* U+2EC8 */
  0x0000,   /* U+2EC9 */
  0x0000,   /* U+2ECA */
  0x0000,   /* U+2ECB */
  0x0000,   /* U+2ECC */
  0x0000,   /* U+2ECD */
  0x0000,   /* U+2ECE */
  0x0000,   /* U+2ECF */
  0x0000,   /* U+2ED0 */
  0x0000,   /* U+2ED1 */
  0x0000,   /* U+2ED2 */
  0x0000,   /* U+2ED3 */
  0x0000,   /* U+2ED4 */
  0x0000,   /* U+2ED5 */
  0x0000,   /* U+2ED6 */
  0x0000,   /* U+2ED7 */
  0x0000,   /* U+2ED8 */
  0x0000,   /* U+2ED9 */
  0x0000,   /* U+2EDA */
  0x0000,   /* U+2EDB */
  0x0000,   /* U+2EDC */
  0x0000,   /* U+2EDD */
  0x0000,   /* U+2EDE */
  0x0000,   /* U+2EDF */
  0x0000,   /* U+2EE0 */
  0x0000,   /* U+2EE1 */
  0x0000,   /* U+2EE2 */
  0x0000,   /* U+2EE3 */
  0x0000,   /* U+2EE4 */
  0x0000,   /* U+2EE5 */
  0x0000,   /* U+2EE6 */
  0x0000,   /* U+2EE7 */
  0x0000,   /* U+2EE8 */
  0x0000,   /* U+2EE9 */
  0x0000,   /* U+2EEA */
  0x0000,   /* U+2EEB */
  0x0000,   /* U+2EEC */
  0x0000,   /* U+2EED */
  0x0000,   /* U+2EEE */
  0x0000,   /* U+2EEF */
  0x0000,   /* U+2EF0 */
  0x0000,   /* U+2EF1 */
  0x0000,   /* U+2EF2 */
  0x0000,   /* U+2EF3 */
  0x0000,   /* U+2EF4 */
  0x0000,   /* U+2EF5 */
  0x0000,   /* U+2EF6 */
  0x0000,   /* U+2EF7 */
  0x0000,   /* U+2EF8 */
  0x0000,   /* U+2EF9 */
  0x0000,   /* U+2EFA */
  0x0000,   /* U+2EFB */
  0x0000,   /* U+2EFC */
  0x0000,   /* U+2EFD */
  0x0000,   /* U+2EFE */
  0x0000,   /* U+2EFF */

  /* Secondary weight 3 for each character. */
  0x0000,   /* U+2E00 */
  0x0000,   /* U+2E01 */
  0x0000,   /* U+2E02 */
  0x0000,   /* U+2E03 */
  0x0000,   /* U+2E04 */
  0x0000,   /* U+2E05 */
  0x0000,   /* U+2E06 */
  0x0000,   /* U+2E07 */
  0x0000,   /* U+2E08 */
  0x0000,   /* U+2E09 */
  0x0000,   /* U+2E0A */
  0x0000,   /* U+2E0B */
  0x0000,   /* U+2E0C */
  0x0000,   /* U+2E0D */
  0x0000,   /* U+2E0E */
  0x0000,   /* U+2E0F */
  0x0000,   /* U+2E10 */
  0x0000,   /* U+2E11 */
  0x0000,   /* U+2E12 */
  0x0000,   /* U+2E13 */
  0x0000,   /* U+2E14 */
  0x0000,   /* U+2E15 */
  0x0000,   /* U+2E16 */
  0x0000,   /* U+2E17 */
  0x0000,   /* U+2E18 */
  0x0000,   /* U+2E19 */
  0x0000,   /* U+2E1A */
  0x0000,   /* U+2E1B */
  0x0000,   /* U+2E1C */
  0x0000,   /* U+2E1D */
  0x0000,   /* U+2E1E */
  0x0000,   /* U+2E1F */
  0x0000,   /* U+2E20 */
  0x0000,   /* U+2E21 */
  0x0000,   /* U+2E22 */
  0x0000,   /* U+2E23 */
  0x0000,   /* U+2E24 */
  0x0000,   /* U+2E25 */
  0x0000,   /* U+2E26 */
  0x0000,   /* U+2E27 */
  0x0000,   /* U+2E28 */
  0x0000,   /* U+2E29 */
  0x0000,   /* U+2E2A */
  0x0000,   /* U+2E2B */
  0x0000,   /* U+2E2C */
  0x0000,   /* U+2E2D */
  0x0000,   /* U+2E2E */
  0x0000,   /* U+2E2F */
  0x0000,   /* U+2E30 */
  0x0000,   /* U+2E31 */
  0x0000,   /* U+2E32 */
  0x0000,   /* U+2E33 */
  0x0000,   /* U+2E34 */
  0x0000,   /* U+2E35 */
  0x0000,   /* U+2E36 */
  0x0000,   /* U+2E37 */
  0x0000,   /* U+2E38 */
  0x0000,   /* U+2E39 */
  0x0000,   /* U+2E3A */
  0x0000,   /* U+2E3B */
  0x0000,   /* U+2E3C */
  0x0000,   /* U+2E3D */
  0x0000,   /* U+2E3E */
  0x0000,   /* U+2E3F */
  0x0000,   /* U+2E40 */
  0x0000,   /* U+2E41 */
  0x0000,   /* U+2E42 */
  0x0000,   /* U+2E43 */
  0x0000,   /* U+2E44 */
  0x0000,   /* U+2E45 */
  0x0000,   /* U+2E46 */
  0x0000,   /* U+2E47 */
  0x0000,   /* U+2E48 */
  0x0000,   /* U+2E49 */
  0x0000,   /* U+2E4A */
  0x0000,   /* U+2E4B */
  0x0000,   /* U+2E4C */
  0x0000,   /* U+2E4D */
  0x0000,   /* U+2E4E */
  0x0000,   /* U+2E4F */
  0x0000,   /* U+2E50 */
  0x0000,   /* U+2E51 */
  0x0000,   /* U+2E52 */
  0x0000,   /* U+2E53 */
  0x0000,   /* U+2E54 */
  0x0000,   /* U+2E55 */
  0x0000,   /* U+2E56 */
  0x0000,   /* U+2E57 */
  0x0000,   /* U+2E58 */
  0x0000,   /* U+2E59 */
  0x0000,   /* U+2E5A */
  0x0000,   /* U+2E5B */
  0x0000,   /* U+2E5C */
  0x0000,   /* U+2E5D */
  0x0000,   /* U+2E5E */
  0x0000,   /* U+2E5F */
  0x0000,   /* U+2E60 */
  0x0000,   /* U+2E61 */
  0x0000,   /* U+2E62 */
  0x0000,   /* U+2E63 */
  0x0000,   /* U+2E64 */
  0x0000,   /* U+2E65 */
  0x0000,   /* U+2E66 */
  0x0000,   /* U+2E67 */
  0x0000,   /* U+2E68 */
  0x0000,   /* U+2E69 */
  0x0000,   /* U+2E6A */
  0x0000,   /* U+2E6B */
  0x0000,   /* U+2E6C */
  0x0000,   /* U+2E6D */
  0x0000,   /* U+2E6E */
  0x0000,   /* U+2E6F */
  0x0000,   /* U+2E70 */
  0x0000,   /* U+2E71 */
  0x0000,   /* U+2E72 */
  0x0000,   /* U+2E73 */
  0x0000,   /* U+2E74 */
  0x0000,   /* U+2E75 */
  0x0000,   /* U+2E76 */
  0x0000,   /* U+2E77 */
  0x0000,   /* U+2E78 */
  0x0000,   /* U+2E79 */
  0x0000,   /* U+2E7A */
  0x0000,   /* U+2E7B */
  0x0000,   /* U+2E7C */
  0x0000,   /* U+2E7D */
  0x0000,   /* U+2E7E */
  0x0000,   /* U+2E7F */
  0x0000,   /* U+2E80 */
  0x0110,   /* U+2E81 */
  0x0000,   /* U+2E82 */
  0x0000,   /* U+2E83 */
  0x0000,   /* U+2E84 */
  0x0000,   /* U+2E85 */
  0x0000,   /* U+2E86 */
  0x0000,   /* U+2E87 */
  0x0000,   /* U+2E88 */
  0x0000,   /* U+2E89 */
  0x0000,   /* U+2E8A */
  0x0110,   /* U+2E8B */
  0x0000,   /* U+2E8C */
  0x0000,   /* U+2E8D */
  0x0110,   /* U+2E8E */
  0x0000,   /* U+2E8F */
  0x0000,   /* U+2E90 */
  0x0110,   /* U+2E91 */
  0x0000,   /* U+2E92 */
  0x0000,   /* U+2E93 */
  0x0000,   /* U+2E94 */
  0x0000,   /* U+2E95 */
  0x0000,   /* U+2E96 */
  0x0110,   /* U+2E97 */
  0x0000,   /* U+2E98 */
  0x0000,   /* U+2E99 */
  0x0000,   /* U+2E9A */
  0x0000,   /* U+2E9B */
  0x0000,   /* U+2E9C */
  0x0000,   /* U+2E9D */
  0x0110,   /* U+2E9E */
  0x0000,   /* U+2E9F */
  0x0000,   /* U+2EA0 */
  0x0000,   /* U+2EA1 */
  0x0000,   /* U+2EA2 */
  0x0000,   /* U+2EA3 */
  0x0000,   /* U+2EA4 */
  0x0000,   /* U+2EA5 */
  0x0000,   /* U+2EA6 */
  0x0000,   /* U+2EA7 */
  0x0000,   /* U+2EA8 */
  0x0110,   /* U+2EA9 */
  0x0000,   /* U+2EAA */
  0x0110,   /* U+2EAB */
  0x0000,   /* U+2EAC */
  0x0000,   /* U+2EAD */
  0x0000,   /* U+2EAE */
  0x0000,   /* U+2EAF */
  0x0000,   /* U+2EB0 */
  0x0000,   /* U+2EB1 */
  0x0000,   /* U+2EB2 */
  0x0110,   /* U+2EB3 */
  0x0111,   /* U+2EB4 */
  0x0110,   /* U+2EB5 */
  0x0000,   /* U+2EB6 */
  0x0111,   /* U+2EB7 */
  0x0000,   /* U+2EB8 */
  0x0000,   /* U+2EB9 */
  0x0000,   /* U+2EBA */
  0x0110,   /* U+2EBB */
  0x0000,   /* U+2EBC */
  0x0110,   /* U+2EBD */
  0x0000,   /* U+2EBE */
  0x0110,   /* U+2EBF */
  0x0111,   /* U+2EC0 */
  0x0000,   /* U+2EC1 */
  0x0000,   /* U+2EC2 */
  0x0000,   /* U+2EC3 */
  0x0000,   /* U+2EC4 */
  0x0000,   /* U+2EC5 */
  0x0000,   /* U+2EC6 */
  0x0110,   /* U+2EC7 */
  0x0000,   /* U+2EC8 */
  0x0000,   /* U+2EC9 */
  0x0000,   /* U+2ECA */
  0x0000,   /* U+2ECB */
  0x0000,   /* U+2ECC */
  0x0000,   /* U+2ECD */
  0x0111,   /* U+2ECE */
  0x0000,   /* U+2ECF */
  0x0000,   /* U+2ED0 */
  0x0000,   /* U+2ED1 */
  0x0000,   /* U+2ED2 */
  0x0000,   /* U+2ED3 */
  0x0000,   /* U+2ED4 */
  0x0110,   /* U+2ED5 */
  0x0000,   /* U+2ED6 */
  0x0000,   /* U+2ED7 */
  0x0000,   /* U+2ED8 */
  0x0000,   /* U+2ED9 */
  0x0000,   /* U+2EDA */
  0x0000,   /* U+2EDB */
  0x0000,   /* U+2EDC */
  0x0000,   /* U+2EDD */
  0x0000,   /* U+2EDE */
  0x0000,   /* U+2EDF */
  0x0000,   /* U+2EE0 */
  0x0110,   /* U+2EE1 */
  0x0000,   /* U+2EE2 */
  0x0000,   /* U+2EE3 */
  0x0110,   /* U+2EE4 */
  0x0000,   /* U+2EE5 */
  0x0000,   /* U+2EE6 */
  0x0110,   /* U+2EE7 */
  0x0000,   /* U+2EE8 */
  0x0000,   /* U+2EE9 */
  0x0000,   /* U+2EEA */
  0x0110,   /* U+2EEB */
  0x0000,   /* U+2EEC */
  0x0110,   /* U+2EED */
  0x0000,   /* U+2EEE */
  0x0110,   /* U+2EEF */
  0x0000,   /* U+2EF0 */
  0x0110,   /* U+2EF1 */
  0x0111,   /* U+2EF2 */
  0x0000,   /* U+2EF3 */
  0x0000,   /* U+2EF4 */
  0x0000,   /* U+2EF5 */
  0x0000,   /* U+2EF6 */
  0x0000,   /* U+2EF7 */
  0x0000,   /* U+2EF8 */
  0x0000,   /* U+2EF9 */
  0x0000,   /* U+2EFA */
  0x0000,   /* U+2EFB */
  0x0000,   /* U+2EFC */
  0x0000,   /* U+2EFD */
  0x0000,   /* U+2EFE */
  0x0000,   /* U+2EFF */

  /* Tertiary weight 3 for each character. */
  0x0000,   /* U+2E00 */
  0x0000,   /* U+2E01 */
  0x0000,   /* U+2E02 */
  0x0000,   /* U+2E03 */
  0x0000,   /* U+2E04 */
  0x0000,   /* U+2E05 */
  0x0000,   /* U+2E06 */
  0x0000,   /* U+2E07 */
  0x0000,   /* U+2E08 */
  0x0000,   /* U+2E09 */
  0x0000,   /* U+2E0A */
  0x0000,   /* U+2E0B */
  0x0000,   /* U+2E0C */
  0x0000,   /* U+2E0D */
  0x0000,   /* U+2E0E */
  0x0000,   /* U+2E0F */
  0x0000,   /* U+2E10 */
  0x0000,   /* U+2E11 */
  0x0000,   /* U+2E12 */
  0x0000,   /* U+2E13 */
  0x0000,   /* U+2E14 */
  0x0000,   /* U+2E15 */
  0x0000,   /* U+2E16 */
  0x0000,   /* U+2E17 */
  0x0000,   /* U+2E18 */
  0x0000,   /* U+2E19 */
  0x0000,   /* U+2E1A */
  0x0000,   /* U+2E1B */
  0x0000,   /* U+2E1C */
  0x0000,   /* U+2E1D */
  0x0000,   /* U+2E1E */
  0x0000,   /* U+2E1F */
  0x0000,   /* U+2E20 */
  0x0000,   /* U+2E21 */
  0x0000,   /* U+2E22 */
  0x0000,   /* U+2E23 */
  0x0000,   /* U+2E24 */
  0x0000,   /* U+2E25 */
  0x0000,   /* U+2E26 */
  0x0000,   /* U+2E27 */
  0x0000,   /* U+2E28 */
  0x0000,   /* U+2E29 */
  0x0000,   /* U+2E2A */
  0x0000,   /* U+2E2B */
  0x0000,   /* U+2E2C */
  0x0000,   /* U+2E2D */
  0x0000,   /* U+2E2E */
  0x0000,   /* U+2E2F */
  0x0000,   /* U+2E30 */
  0x0000,   /* U+2E31 */
  0x0000,   /* U+2E32 */
  0x0000,   /* U+2E33 */
  0x0000,   /* U+2E34 */
  0x0000,   /* U+2E35 */
  0x0000,   /* U+2E36 */
  0x0000,   /* U+2E37 */
  0x0000,   /* U+2E38 */
  0x0000,   /* U+2E39 */
  0x0000,   /* U+2E3A */
  0x0000,   /* U+2E3B */
  0x0000,   /* U+2E3C */
  0x0000,   /* U+2E3D */
  0x0000,   /* U+2E3E */
  0x0000,   /* U+2E3F */
  0x0000,   /* U+2E40 */
  0x0000,   /* U+2E41 */
  0x0000,   /* U+2E42 */
  0x0000,   /* U+2E43 */
  0x0000,   /* U+2E44 */
  0x0000,   /* U+2E45 */
  0x0000,   /* U+2E46 */
  0x0000,   /* U+2E47 */
  0x0000,   /* U+2E48 */
  0x0000,   /* U+2E49 */
  0x0000,   /* U+2E4A */
  0x0000,   /* U+2E4B */
  0x0000,   /* U+2E4C */
  0x0000,   /* U+2E4D */
  0x0000,   /* U+2E4E */
  0x0000,   /* U+2E4F */
  0x0000,   /* U+2E50 */
  0x0000,   /* U+2E51 */
  0x0000,   /* U+2E52 */
  0x0000,   /* U+2E53 */
  0x0000,   /* U+2E54 */
  0x0000,   /* U+2E55 */
  0x0000,   /* U+2E56 */
  0x0000,   /* U+2E57 */
  0x0000,   /* U+2E58 */
  0x0000,   /* U+2E59 */
  0x0000,   /* U+2E5A */
  0x0000,   /* U+2E5B */
  0x0000,   /* U+2E5C */
  0x0000,   /* U+2E5D */
  0x0000,   /* U+2E5E */
  0x0000,   /* U+2E5F */
  0x0000,   /* U+2E60 */
  0x0000,   /* U+2E61 */
  0x0000,   /* U+2E62 */
  0x0000,   /* U+2E63 */
  0x0000,   /* U+2E64 */
  0x0000,   /* U+2E65 */
  0x0000,   /* U+2E66 */
  0x0000,   /* U+2E67 */
  0x0000,   /* U+2E68 */
  0x0000,   /* U+2E69 */
  0x0000,   /* U+2E6A */
  0x0000,   /* U+2E6B */
  0x0000,   /* U+2E6C */
  0x0000,   /* U+2E6D */
  0x0000,   /* U+2E6E */
  0x0000,   /* U+2E6F */
  0x0000,   /* U+2E70 */
  0x0000,   /* U+2E71 */
  0x0000,   /* U+2E72 */
  0x0000,   /* U+2E73 */
  0x0000,   /* U+2E74 */
  0x0000,   /* U+2E75 */
  0x0000,   /* U+2E76 */
  0x0000,   /* U+2E77 */
  0x0000,   /* U+2E78 */
  0x0000,   /* U+2E79 */
  0x0000,   /* U+2E7A */
  0x0000,   /* U+2E7B */
  0x0000,   /* U+2E7C */
  0x0000,   /* U+2E7D */
  0x0000,   /* U+2E7E */
  0x0000,   /* U+2E7F */
  0x0000,   /* U+2E80 */
  0x0004,   /* U+2E81 */
  0x0000,   /* U+2E82 */
  0x0000,   /* U+2E83 */
  0x0000,   /* U+2E84 */
  0x0000,   /* U+2E85 */
  0x0000,   /* U+2E86 */
  0x0000,   /* U+2E87 */
  0x0000,   /* U+2E88 */
  0x0000,   /* U+2E89 */
  0x0000,   /* U+2E8A */
  0x0004,   /* U+2E8B */
  0x0000,   /* U+2E8C */
  0x0000,   /* U+2E8D */
  0x0004,   /* U+2E8E */
  0x0000,   /* U+2E8F */
  0x0000,   /* U+2E90 */
  0x0004,   /* U+2E91 */
  0x0000,   /* U+2E92 */
  0x0000,   /* U+2E93 */
  0x0000,   /* U+2E94 */
  0x0000,   /* U+2E95 */
  0x0000,   /* U+2E96 */
  0x0004,   /* U+2E97 */
  0x0000,   /* U+2E98 */
  0x0000,   /* U+2E99 */
  0x0000,   /* U+2E9A */
  0x0000,   /* U+2E9B */
  0x0000,   /* U+2E9C */
  0x0000,   /* U+2E9D */
  0x0004,   /* U+2E9E */
  0x0000,   /* U+2E9F */
  0x0000,   /* U+2EA0 */
  0x0000,   /* U+2EA1 */
  0x0000,   /* U+2EA2 */
  0x0000,   /* U+2EA3 */
  0x0000,   /* U+2EA4 */
  0x0000,   /* U+2EA5 */
  0x0000,   /* U+2EA6 */
  0x0000,   /* U+2EA7 */
  0x0000,   /* U+2EA8 */
  0x0004,   /* U+2EA9 */
  0x0000,   /* U+2EAA */
  0x0004,   /* U+2EAB */
  0x0000,   /* U+2EAC */
  0x0000,   /* U+2EAD */
  0x0000,   /* U+2EAE */
  0x0000,   /* U+2EAF */
  0x0000,   /* U+2EB0 */
  0x0000,   /* U+2EB1 */
  0x0000,   /* U+2EB2 */
  0x0004,   /* U+2EB3 */
  0x0004,   /* U+2EB4 */
  0x0004,   /* U+2EB5 */
  0x0000,   /* U+2EB6 */
  0x0004,   /* U+2EB7 */
  0x0000,   /* U+2EB8 */
  0x0000,   /* U+2EB9 */
  0x0000,   /* U+2EBA */
  0x0004,   /* U+2EBB */
  0x0000,   /* U+2EBC */
  0x0004,   /* U+2EBD */
  0x0000,   /* U+2EBE */
  0x0004,   /* U+2EBF */
  0x0004,   /* U+2EC0 */
  0x0000,   /* U+2EC1 */
  0x0000,   /* U+2EC2 */
  0x0000,   /* U+2EC3 */
  0x0000,   /* U+2EC4 */
  0x0000,   /* U+2EC5 */
  0x0000,   /* U+2EC6 */
  0x0004,   /* U+2EC7 */
  0x0000,   /* U+2EC8 */
  0x0000,   /* U+2EC9 */
  0x0000,   /* U+2ECA */
  0x0000,   /* U+2ECB */
  0x0000,   /* U+2ECC */
  0x0000,   /* U+2ECD */
  0x0004,   /* U+2ECE */
  0x0000,   /* U+2ECF */
  0x0000,   /* U+2ED0 */
  0x0000,   /* U+2ED1 */
  0x0000,   /* U+2ED2 */
  0x0000,   /* U+2ED3 */
  0x0000,   /* U+2ED4 */
  0x0004,   /* U+2ED5 */
  0x0000,   /* U+2ED6 */
  0x0000,   /* U+2ED7 */
  0x0000,   /* U+2ED8 */
  0x0000,   /* U+2ED9 */
  0x0000,   /* U+2EDA */
  0x0000,   /* U+2EDB */
  0x0000,   /* U+2EDC */
  0x0000,   /* U+2EDD */
  0x0000,   /* U+2EDE */
  0x0000,   /* U+2EDF */
  0x0000,   /* U+2EE0 */
  0x0004,   /* U+2EE1 */
  0x0000,   /* U+2EE2 */
  0x0000,   /* U+2EE3 */
  0x0004,   /* U+2EE4 */
  0x0000,   /* U+2EE5 */
  0x0000,   /* U+2EE6 */
  0x0004,   /* U+2EE7 */
  0x0000,   /* U+2EE8 */
  0x0000,   /* U+2EE9 */
  0x0000,   /* U+2EEA */
  0x0004,   /* U+2EEB */
  0x0000,   /* U+2EEC */
  0x0004,   /* U+2EED */
  0x0000,   /* U+2EEE */
  0x0004,   /* U+2EEF */
  0x0000,   /* U+2EF0 */
  0x0004,   /* U+2EF1 */
  0x0004,   /* U+2EF2 */
  0x0000,   /* U+2EF3 */
  0x0000,   /* U+2EF4 */
  0x0000,   /* U+2EF5 */
  0x0000,   /* U+2EF6 */
  0x0000,   /* U+2EF7 */
  0x0000,   /* U+2EF8 */
  0x0000,   /* U+2EF9 */
  0x0000,   /* U+2EFA */
  0x0000,   /* U+2EFB */
  0x0000,   /* U+2EFC */
  0x0000,   /* U+2EFD */
  0x0000,   /* U+2EFE */
  0x0000,   /* U+2EFF */
};

uint16 zh3_han_p030[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1,
  1, 1, 2, 1, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1,
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1,
  2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
  2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1,
  2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1,
  2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
  2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1,
  2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 2, 1, 1, 2, 2, 2, 2, 1, 1, 1, 2, 2,

  /* Primary weight 1 for each character. */
  0x0209,   /* U+3000 */
  0x0231,   /* U+3001 */
  0x028A,   /* U+3002 */
  0x03AC,   /* U+3003 */
  0x1A8B,   /* U+3004 */
  0x1C4A,   /* U+3005 */
  0x1C48,   /* U+3006 */
  0x1C48,   /* U+3007 */
  0x036F,   /* U+3008 */
  0x0370,   /* U+3009 */
  0x0371,   /* U+300A */
  0x0372,   /* U+300B */
  0x0373,   /* U+300C */
  0x0374,   /* U+300D */
  0x0375,   /* U+300E */
  0x0376,   /* U+300F */
  0x0377,   /* U+3010 */
  0x0378,   /* U+3011 */
  0x1A8C,   /* U+3012 */
  0x1A8D,   /* U+3013 */
  0x0379,   /* U+3014 */
  0x037A,   /* U+3015 */
  0x037B,   /* U+3016 */
  0x037C,   /* U+3017 */
  0x037D,   /* U+3018 */
  0x037E,   /* U+3019 */
  0x037F,   /* U+301A */
  0x0380,   /* U+301B */
  0x021E,   /* U+301C */
  0x0312,   /* U+301D */
  0x0313,   /* U+301E */
  0x0314,   /* U+301F */
  0x1A8E,   /* U+3020 */
  0x1C48,   /* U+3021 */
  0x1C49,   /* U+3022 */
  0x1C4A,   /* U+3023 */
  0x1C49,   /* U+3024 */
  0x1C48,   /* U+3025 */
  0x1C49,   /* U+3026 */
  0x1C4A,   /* U+3027 */
  0x1C4B,   /* U+3028 */
  0x1C4B,   /* U+3029 */
  0x0000,   /* U+302A */
  0x0000,   /* U+302B */
  0x0000,   /* U+302C */
  0x0000,   /* U+302D */
  0x0000,   /* U+302E */
  0x0000,   /* U+302F */
  0x021F,   /* U+3030 */
  0x1C0A,   /* U+3031 */
  0x1C0A,   /* U+3032 */
  0x1C0B,   /* U+3033 */
  0x1C0B,   /* U+3034 */
  0x1C0C,   /* U+3035 */
  0x1A8C,   /* U+3036 */
  0x1A8F,   /* U+3037 */
  0x1C49,   /* U+3038 */
  0x1C4A,   /* U+3039 */
  0x1C4B,   /* U+303A */
  0x1C48,   /* U+303B */
  0x3DE2,   /* U+303C */
  0x03AD,   /* U+303D */
  0x1A90,   /* U+303E */
  0x1A91,   /* U+303F */
  0xFBC0,   /* U+3040 */
  0x3DC3,   /* U+3041 */
  0x3DC3,   /* U+3042 */
  0x3DC4,   /* U+3043 */
  0x3DC4,   /* U+3044 */
  0x3DC5,   /* U+3045 */
  0x3DC5,   /* U+3046 */
  0x3DC7,   /* U+3047 */
  0x3DC7,   /* U+3048 */
  0x3DC8,   /* U+3049 */
  0x3DC8,   /* U+304A */
  0x3DC9,   /* U+304B */
  0x3DC9,   /* U+304C */
  0x3DCA,   /* U+304D */
  0x3DCA,   /* U+304E */
  0x3DCB,   /* U+304F */
  0x3DCB,   /* U+3050 */
  0x3DCC,   /* U+3051 */
  0x3DCC,   /* U+3052 */
  0x3DCD,   /* U+3053 */
  0x3DCD,   /* U+3054 */
  0x3DCE,   /* U+3055 */
  0x3DCE,   /* U+3056 */
  0x3DCF,   /* U+3057 */
  0x3DCF,   /* U+3058 */
  0x3DD0,   /* U+3059 */
  0x3DD0,   /* U+305A */
  0x3DD1,   /* U+305B */
  0x3DD1,   /* U+305C */
  0x3DD2,   /* U+305D */
  0x3DD2,   /* U+305E */
  0x3DD3,   /* U+305F */
  0x3DD3,   /* U+3060 */
  0x3DD4,   /* U+3061 */
  0x3DD4,   /* U+3062 */
  0x3DD5,   /* U+3063 */
  0x3DD5,   /* U+3064 */
  0x3DD5,   /* U+3065 */
  0x3DD6,   /* U+3066 */
  0x3DD6,   /* U+3067 */
  0x3DD7,   /* U+3068 */
  0x3DD7,   /* U+3069 */
  0x3DD8,   /* U+306A */
  0x3DD9,   /* U+306B */
  0x3DDA,   /* U+306C */
  0x3DDB,   /* U+306D */
  0x3DDC,   /* U+306E */
  0x3DDD,   /* U+306F */
  0x3DDD,   /* U+3070 */
  0x3DDD,   /* U+3071 */
  0x3DDE,   /* U+3072 */
  0x3DDE,   /* U+3073 */
  0x3DDE,   /* U+3074 */
  0x3DDF,   /* U+3075 */
  0x3DDF,   /* U+3076 */
  0x3DDF,   /* U+3077 */
  0x3DE0,   /* U+3078 */
  0x3DE0,   /* U+3079 */
  0x3DE0,   /* U+307A */
  0x3DE1,   /* U+307B */
  0x3DE1,   /* U+307C */
  0x3DE1,   /* U+307D */
  0x3DE2,   /* U+307E */
  0x3DE3,   /* U+307F */
  0x3DE4,   /* U+3080 */
  0x3DE5,   /* U+3081 */
  0x3DE6,   /* U+3082 */
  0x3DE7,   /* U+3083 */
  0x3DE7,   /* U+3084 */
  0x3DE8,   /* U+3085 */
  0x3DE8,   /* U+3086 */
  0x3DEA,   /* U+3087 */
  0x3DEA,   /* U+3088 */
  0x3DEB,   /* U+3089 */
  0x3DEC,   /* U+308A */
  0x3DED,   /* U+308B */
  0x3DEE,   /* U+308C */
  0x3DEF,   /* U+308D */
  0x3DF0,   /* U+308E */
  0x3DF0,   /* U+308F */
  0x3DF1,   /* U+3090 */
  0x3DF2,   /* U+3091 */
  0x3DF3,   /* U+3092 */
  0x3DF4,   /* U+3093 */
  0x3DC5,   /* U+3094 */
  0x3DC9,   /* U+3095 */
  0x3DCC,   /* U+3096 */
  0xFBC0,   /* U+3097 */
  0xFBC0,   /* U+3098 */
  0x0000,   /* U+3099 */
  0x0000,   /* U+309A */
  0x0491,   /* U+309B */
  0x0492,   /* U+309C */
  0x1C0D,   /* U+309D */
  0x1C0D,   /* U+309E */
  0x3DEA,   /* U+309F */
  0x0220,   /* U+30A0 */
  0x3DC3,   /* U+30A1 */
  0x3DC3,   /* U+30A2 */
  0x3DC4,   /* U+30A3 */
  0x3DC4,   /* U+30A4 */
  0x3DC5,   /* U+30A5 */
  0x3DC5,   /* U+30A6 */
  0x3DC7,   /* U+30A7 */
  0x3DC7,   /* U+30A8 */
  0x3DC8,   /* U+30A9 */
  0x3DC8,   /* U+30AA */
  0x3DC9,   /* U+30AB */
  0x3DC9,   /* U+30AC */
  0x3DCA,   /* U+30AD */
  0x3DCA,   /* U+30AE */
  0x3DCB,   /* U+30AF */
  0x3DCB,   /* U+30B0 */
  0x3DCC,   /* U+30B1 */
  0x3DCC,   /* U+30B2 */
  0x3DCD,   /* U+30B3 */
  0x3DCD,   /* U+30B4 */
  0x3DCE,   /* U+30B5 */
  0x3DCE,   /* U+30B6 */
  0x3DCF,   /* U+30B7 */
  0x3DCF,   /* U+30B8 */
  0x3DD0,   /* U+30B9 */
  0x3DD0,   /* U+30BA */
  0x3DD1,   /* U+30BB */
  0x3DD1,   /* U+30BC */
  0x3DD2,   /* U+30BD */
  0x3DD2,   /* U+30BE */
  0x3DD3,   /* U+30BF */
  0x3DD3,   /* U+30C0 */
  0x3DD4,   /* U+30C1 */
  0x3DD4,   /* U+30C2 */
  0x3DD5,   /* U+30C3 */
  0x3DD5,   /* U+30C4 */
  0x3DD5,   /* U+30C5 */
  0x3DD6,   /* U+30C6 */
  0x3DD6,   /* U+30C7 */
  0x3DD7,   /* U+30C8 */
  0x3DD7,   /* U+30C9 */
  0x3DD8,   /* U+30CA */
  0x3DD9,   /* U+30CB */
  0x3DDA,   /* U+30CC */
  0x3DDB,   /* U+30CD */
  0x3DDC,   /* U+30CE */
  0x3DDD,   /* U+30CF */
  0x3DDD,   /* U+30D0 */
  0x3DDD,   /* U+30D1 */
  0x3DDE,   /* U+30D2 */
  0x3DDE,   /* U+30D3 */
  0x3DDE,   /* U+30D4 */
  0x3DDF,   /* U+30D5 */
  0x3DDF,   /* U+30D6 */
  0x3DDF,   /* U+30D7 */
  0x3DE0,   /* U+30D8 */
  0x3DE0,   /* U+30D9 */
  0x3DE0,   /* U+30DA */
  0x3DE1,   /* U+30DB */
  0x3DE1,   /* U+30DC */
  0x3DE1,   /* U+30DD */
  0x3DE2,   /* U+30DE */
  0x3DE3,   /* U+30DF */
  0x3DE4,   /* U+30E0 */
  0x3DE5,   /* U+30E1 */
  0x3DE6,   /* U+30E2 */
  0x3DE7,   /* U+30E3 */
  0x3DE7,   /* U+30E4 */
  0x3DE8,   /* U+30E5 */
  0x3DE8,   /* U+30E6 */
  0x3DEA,   /* U+30E7 */
  0x3DEA,   /* U+30E8 */
  0x3DEB,   /* U+30E9 */
  0x3DEC,   /* U+30EA */
  0x3DED,   /* U+30EB */
  0x3DEE,   /* U+30EC */
  0x3DEF,   /* U+30ED */
  0x3DF0,   /* U+30EE */
  0x3DF0,   /* U+30EF */
  0x3DF1,   /* U+30F0 */
  0x3DF2,   /* U+30F1 */
  0x3DF3,   /* U+30F2 */
  0x3DF4,   /* U+30F3 */
  0x3DC5,   /* U+30F4 */
  0x3DC9,   /* U+30F5 */
  0x3DCC,   /* U+30F6 */
  0x3DF0,   /* U+30F7 */
  0x3DF1,   /* U+30F8 */
  0x3DF2,   /* U+30F9 */
  0x3DF3,   /* U+30FA */
  0x0221,   /* U+30FB */
  0x1C0E,   /* U+30FC */
  0x1C0F,   /* U+30FD */
  0x1C0F,   /* U+30FE */
  0x3DCD,   /* U+30FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3000 */
  0x0020,   /* U+3001 */
  0x0020,   /* U+3002 */
  0x0020,   /* U+3003 */
  0x0020,   /* U+3004 */
  0x0020,   /* U+3005 */
  0x0020,   /* U+3006 */
  0x0020,   /* U+3007 */
  0x0020,   /* U+3008 */
  0x0020,   /* U+3009 */
  0x0020,   /* U+300A */
  0x0020,   /* U+300B */
  0x0020,   /* U+300C */
  0x0020,   /* U+300D */
  0x0020,   /* U+300E */
  0x0020,   /* U+300F */
  0x0020,   /* U+3010 */
  0x0020,   /* U+3011 */
  0x0020,   /* U+3012 */
  0x0020,   /* U+3013 */
  0x0020,   /* U+3014 */
  0x0020,   /* U+3015 */
  0x0020,   /* U+3016 */
  0x0020,   /* U+3017 */
  0x0020,   /* U+3018 */
  0x0020,   /* U+3019 */
  0x0020,   /* U+301A */
  0x0020,   /* U+301B */
  0x0020,   /* U+301C */
  0x0020,   /* U+301D */
  0x0020,   /* U+301E */
  0x0020,   /* U+301F */
  0x0020,   /* U+3020 */
  0x0020,   /* U+3021 */
  0x0020,   /* U+3022 */
  0x0020,   /* U+3023 */
  0x0020,   /* U+3024 */
  0x0020,   /* U+3025 */
  0x0020,   /* U+3026 */
  0x0020,   /* U+3027 */
  0x0020,   /* U+3028 */
  0x0020,   /* U+3029 */
  0x00FB,   /* U+302A */
  0x00FC,   /* U+302B */
  0x00FD,   /* U+302C */
  0x00FE,   /* U+302D */
  0x00FF,   /* U+302E */
  0x0100,   /* U+302F */
  0x0020,   /* U+3030 */
  0x0020,   /* U+3031 */
  0x0020,   /* U+3032 */
  0x0020,   /* U+3033 */
  0x0020,   /* U+3034 */
  0x0020,   /* U+3035 */
  0x0020,   /* U+3036 */
  0x0020,   /* U+3037 */
  0x0020,   /* U+3038 */
  0x0020,   /* U+3039 */
  0x0020,   /* U+303A */
  0x0020,   /* U+303B */
  0x0020,   /* U+303C */
  0x0020,   /* U+303D */
  0x0020,   /* U+303E */
  0x0020,   /* U+303F */
  0x0020,   /* U+3040 */
  0x0020,   /* U+3041 */
  0x0020,   /* U+3042 */
  0x0020,   /* U+3043 */
  0x0020,   /* U+3044 */
  0x0020,   /* U+3045 */
  0x0020,   /* U+3046 */
  0x0020,   /* U+3047 */
  0x0020,   /* U+3048 */
  0x0020,   /* U+3049 */
  0x0020,   /* U+304A */
  0x0020,   /* U+304B */
  0x0020,   /* U+304C */
  0x0020,   /* U+304D */
  0x0020,   /* U+304E */
  0x0020,   /* U+304F */
  0x0020,   /* U+3050 */
  0x0020,   /* U+3051 */
  0x0020,   /* U+3052 */
  0x0020,   /* U+3053 */
  0x0020,   /* U+3054 */
  0x0020,   /* U+3055 */
  0x0020,   /* U+3056 */
  0x0020,   /* U+3057 */
  0x0020,   /* U+3058 */
  0x0020,   /* U+3059 */
  0x0020,   /* U+305A */
  0x0020,   /* U+305B */
  0x0020,   /* U+305C */
  0x0020,   /* U+305D */
  0x0020,   /* U+305E */
  0x0020,   /* U+305F */
  0x0020,   /* U+3060 */
  0x0020,   /* U+3061 */
  0x0020,   /* U+3062 */
  0x0020,   /* U+3063 */
  0x0020,   /* U+3064 */
  0x0020,   /* U+3065 */
  0x0020,   /* U+3066 */
  0x0020,   /* U+3067 */
  0x0020,   /* U+3068 */
  0x0020,   /* U+3069 */
  0x0020,   /* U+306A */
  0x0020,   /* U+306B */
  0x0020,   /* U+306C */
  0x0020,   /* U+306D */
  0x0020,   /* U+306E */
  0x0020,   /* U+306F */
  0x0020,   /* U+3070 */
  0x0020,   /* U+3071 */
  0x0020,   /* U+3072 */
  0x0020,   /* U+3073 */
  0x0020,   /* U+3074 */
  0x0020,   /* U+3075 */
  0x0020,   /* U+3076 */
  0x0020,   /* U+3077 */
  0x0020,   /* U+3078 */
  0x0020,   /* U+3079 */
  0x0020,   /* U+307A */
  0x0020,   /* U+307B */
  0x0020,   /* U+307C */
  0x0020,   /* U+307D */
  0x0020,   /* U+307E */
  0x0020,   /* U+307F */
  0x0020,   /* U+3080 */
  0x0020,   /* U+3081 */
  0x0020,   /* U+3082 */
  0x0020,   /* U+3083 */
  0x0020,   /* U+3084 */
  0x0020,   /* U+3085 */
  0x0020,   /* U+3086 */
  0x0020,   /* U+3087 */
  0x0020,   /* U+3088 */
  0x0020,   /* U+3089 */
  0x0020,   /* U+308A */
  0x0020,   /* U+308B */
  0x0020,   /* U+308C */
  0x0020,   /* U+308D */
  0x0020,   /* U+308E */
  0x0020,   /* U+308F */
  0x0020,   /* U+3090 */
  0x0020,   /* U+3091 */
  0x0020,   /* U+3092 */
  0x0020,   /* U+3093 */
  0x0020,   /* U+3094 */
  0x0020,   /* U+3095 */
  0x0020,   /* U+3096 */
  0x0020,   /* U+3097 */
  0x0020,   /* U+3098 */
  0x0037,   /* U+3099 */
  0x0038,   /* U+309A */
  0x0020,   /* U+309B */
  0x0020,   /* U+309C */
  0x0020,   /* U+309D */
  0x0020,   /* U+309E */
  0x0020,   /* U+309F */
  0x0020,   /* U+30A0 */
  0x0020,   /* U+30A1 */
  0x0020,   /* U+30A2 */
  0x0020,   /* U+30A3 */
  0x0020,   /* U+30A4 */
  0x0020,   /* U+30A5 */
  0x0020,   /* U+30A6 */
  0x0020,   /* U+30A7 */
  0x0020,   /* U+30A8 */
  0x0020,   /* U+30A9 */
  0x0020,   /* U+30AA */
  0x0020,   /* U+30AB */
  0x0020,   /* U+30AC */
  0x0020,   /* U+30AD */
  0x0020,   /* U+30AE */
  0x0020,   /* U+30AF */
  0x0020,   /* U+30B0 */
  0x0020,   /* U+30B1 */
  0x0020,   /* U+30B2 */
  0x0020,   /* U+30B3 */
  0x0020,   /* U+30B4 */
  0x0020,   /* U+30B5 */
  0x0020,   /* U+30B6 */
  0x0020,   /* U+30B7 */
  0x0020,   /* U+30B8 */
  0x0020,   /* U+30B9 */
  0x0020,   /* U+30BA */
  0x0020,   /* U+30BB */
  0x0020,   /* U+30BC */
  0x0020,   /* U+30BD */
  0x0020,   /* U+30BE */
  0x0020,   /* U+30BF */
  0x0020,   /* U+30C0 */
  0x0020,   /* U+30C1 */
  0x0020,   /* U+30C2 */
  0x0020,   /* U+30C3 */
  0x0020,   /* U+30C4 */
  0x0020,   /* U+30C5 */
  0x0020,   /* U+30C6 */
  0x0020,   /* U+30C7 */
  0x0020,   /* U+30C8 */
  0x0020,   /* U+30C9 */
  0x0020,   /* U+30CA */
  0x0020,   /* U+30CB */
  0x0020,   /* U+30CC */
  0x0020,   /* U+30CD */
  0x0020,   /* U+30CE */
  0x0020,   /* U+30CF */
  0x0020,   /* U+30D0 */
  0x0020,   /* U+30D1 */
  0x0020,   /* U+30D2 */
  0x0020,   /* U+30D3 */
  0x0020,   /* U+30D4 */
  0x0020,   /* U+30D5 */
  0x0020,   /* U+30D6 */
  0x0020,   /* U+30D7 */
  0x0020,   /* U+30D8 */
  0x0020,   /* U+30D9 */
  0x0020,   /* U+30DA */
  0x0020,   /* U+30DB */
  0x0020,   /* U+30DC */
  0x0020,   /* U+30DD */
  0x0020,   /* U+30DE */
  0x0020,   /* U+30DF */
  0x0020,   /* U+30E0 */
  0x0020,   /* U+30E1 */
  0x0020,   /* U+30E2 */
  0x0020,   /* U+30E3 */
  0x0020,   /* U+30E4 */
  0x0020,   /* U+30E5 */
  0x0020,   /* U+30E6 */
  0x0020,   /* U+30E7 */
  0x0020,   /* U+30E8 */
  0x0020,   /* U+30E9 */
  0x0020,   /* U+30EA */
  0x0020,   /* U+30EB */
  0x0020,   /* U+30EC */
  0x0020,   /* U+30ED */
  0x0020,   /* U+30EE */
  0x0020,   /* U+30EF */
  0x0020,   /* U+30F0 */
  0x0020,   /* U+30F1 */
  0x0020,   /* U+30F2 */
  0x0020,   /* U+30F3 */
  0x0020,   /* U+30F4 */
  0x0020,   /* U+30F5 */
  0x0020,   /* U+30F6 */
  0x0020,   /* U+30F7 */
  0x0020,   /* U+30F8 */
  0x0020,   /* U+30F9 */
  0x0020,   /* U+30FA */
  0x0020,   /* U+30FB */
  0x0020,   /* U+30FC */
  0x0020,   /* U+30FD */
  0x0020,   /* U+30FE */
  0x0020,   /* U+30FF */

  /* Tertiary weight 1 for each character. */
  0x0003,   /* U+3000 */
  0x0002,   /* U+3001 */
  0x0002,   /* U+3002 */
  0x0002,   /* U+3003 */
  0x0002,   /* U+3004 */
  0x0002,   /* U+3005 */
  0x0002,   /* U+3006 */
  0x0002,   /* U+3007 */
  0x0002,   /* U+3008 */
  0x0002,   /* U+3009 */
  0x0002,   /* U+300A */
  0x0002,   /* U+300B */
  0x0002,   /* U+300C */
  0x0002,   /* U+300D */
  0x0002,   /* U+300E */
  0x0002,   /* U+300F */
  0x0002,   /* U+3010 */
  0x0002,   /* U+3011 */
  0x0002,   /* U+3012 */
  0x0002,   /* U+3013 */
  0x0002,   /* U+3014 */
  0x0002,   /* U+3015 */
  0x0002,   /* U+3016 */
  0x0002,   /* U+3017 */
  0x0002,   /* U+3018 */
  0x0002,   /* U+3019 */
  0x0002,   /* U+301A */
  0x0002,   /* U+301B */
  0x0002,   /* U+301C */
  0x0002,   /* U+301D */
  0x0002,   /* U+301E */
  0x0002,   /* U+301F */
  0x0002,   /* U+3020 */
  0x0002,   /* U+3021 */
  0x0002,   /* U+3022 */
  0x0002,   /* U+3023 */
  0x0002,   /* U+3024 */
  0x0002,   /* U+3025 */
  0x0002,   /* U+3026 */
  0x0002,   /* U+3027 */
  0x0002,   /* U+3028 */
  0x0002,   /* U+3029 */
  0x0002,   /* U+302A */
  0x0002,   /* U+302B */
  0x0002,   /* U+302C */
  0x0002,   /* U+302D */
  0x0002,   /* U+302E */
  0x0002,   /* U+302F */
  0x0002,   /* U+3030 */
  0x0002,   /* U+3031 */
  0x0002,   /* U+3032 */
  0x0002,   /* U+3033 */
  0x0002,   /* U+3034 */
  0x0002,   /* U+3035 */
  0x0004,   /* U+3036 */
  0x0002,   /* U+3037 */
  0x0004,   /* U+3038 */
  0x0004,   /* U+3039 */
  0x0004,   /* U+303A */
  0x0002,   /* U+303B */
  0x0004,   /* U+303C */
  0x0002,   /* U+303D */
  0x0002,   /* U+303E */
  0x0002,   /* U+303F */
  0x0002,   /* U+3040 */
  0x000D,   /* U+3041 */
  0x000E,   /* U+3042 */
  0x000D,   /* U+3043 */
  0x000E,   /* U+3044 */
  0x000D,   /* U+3045 */
  0x000E,   /* U+3046 */
  0x000D,   /* U+3047 */
  0x000E,   /* U+3048 */
  0x000D,   /* U+3049 */
  0x000E,   /* U+304A */
  0x000E,   /* U+304B */
  0x000E,   /* U+304C */
  0x000E,   /* U+304D */
  0x000E,   /* U+304E */
  0x000E,   /* U+304F */
  0x000E,   /* U+3050 */
  0x000E,   /* U+3051 */
  0x000E,   /* U+3052 */
  0x000E,   /* U+3053 */
  0x000E,   /* U+3054 */
  0x000E,   /* U+3055 */
  0x000E,   /* U+3056 */
  0x000E,   /* U+3057 */
  0x000E,   /* U+3058 */
  0x000E,   /* U+3059 */
  0x000E,   /* U+305A */
  0x000E,   /* U+305B */
  0x000E,   /* U+305C */
  0x000E,   /* U+305D */
  0x000E,   /* U+305E */
  0x000E,   /* U+305F */
  0x000E,   /* U+3060 */
  0x000E,   /* U+3061 */
  0x000E,   /* U+3062 */
  0x000D,   /* U+3063 */
  0x000E,   /* U+3064 */
  0x000E,   /* U+3065 */
  0x000E,   /* U+3066 */
  0x000E,   /* U+3067 */
  0x000E,   /* U+3068 */
  0x000E,   /* U+3069 */
  0x000E,   /* U+306A */
  0x000E,   /* U+306B */
  0x000E,   /* U+306C */
  0x000E,   /* U+306D */
  0x000E,   /* U+306E */
  0x000E,   /* U+306F */
  0x000E,   /* U+3070 */
  0x000E,   /* U+3071 */
  0x000E,   /* U+3072 */
  0x000E,   /* U+3073 */
  0x000E,   /* U+3074 */
  0x000E,   /* U+3075 */
  0x000E,   /* U+3076 */
  0x000E,   /* U+3077 */
  0x000E,   /* U+3078 */
  0x000E,   /* U+3079 */
  0x000E,   /* U+307A */
  0x000E,   /* U+307B */
  0x000E,   /* U+307C */
  0x000E,   /* U+307D */
  0x000E,   /* U+307E */
  0x000E,   /* U+307F */
  0x000E,   /* U+3080 */
  0x000E,   /* U+3081 */
  0x000E,   /* U+3082 */
  0x000D,   /* U+3083 */
  0x000E,   /* U+3084 */
  0x000D,   /* U+3085 */
  0x000E,   /* U+3086 */
  0x000D,   /* U+3087 */
  0x000E,   /* U+3088 */
  0x000E,   /* U+3089 */
  0x000E,   /* U+308A */
  0x000E,   /* U+308B */
  0x000E,   /* U+308C */
  0x000E,   /* U+308D */
  0x000D,   /* U+308E */
  0x000E,   /* U+308F */
  0x000E,   /* U+3090 */
  0x000E,   /* U+3091 */
  0x000E,   /* U+3092 */
  0x000E,   /* U+3093 */
  0x000E,   /* U+3094 */
  0x000D,   /* U+3095 */
  0x000D,   /* U+3096 */
  0x0002,   /* U+3097 */
  0x0002,   /* U+3098 */
  0x0002,   /* U+3099 */
  0x0002,   /* U+309A */
  0x0002,   /* U+309B */
  0x0002,   /* U+309C */
  0x0002,   /* U+309D */
  0x0002,   /* U+309E */
  0x0016,   /* U+309F */
  0x0002,   /* U+30A0 */
  0x000F,   /* U+30A1 */
  0x0011,   /* U+30A2 */
  0x000F,   /* U+30A3 */
  0x0011,   /* U+30A4 */
  0x000F,   /* U+30A5 */
  0x0011,   /* U+30A6 */
  0x000F,   /* U+30A7 */
  0x0011,   /* U+30A8 */
  0x000F,   /* U+30A9 */
  0x0011,   /* U+30AA */
  0x0011,   /* U+30AB */
  0x0011,   /* U+30AC */
  0x0011,   /* U+30AD */
  0x0011,   /* U+30AE */
  0x0011,   /* U+30AF */
  0x0011,   /* U+30B0 */
  0x0011,   /* U+30B1 */
  0x0011,   /* U+30B2 */
  0x0011,   /* U+30B3 */
  0x0011,   /* U+30B4 */
  0x0011,   /* U+30B5 */
  0x0011,   /* U+30B6 */
  0x0011,   /* U+30B7 */
  0x0011,   /* U+30B8 */
  0x0011,   /* U+30B9 */
  0x0011,   /* U+30BA */
  0x0011,   /* U+30BB */
  0x0011,   /* U+30BC */
  0x0011,   /* U+30BD */
  0x0011,   /* U+30BE */
  0x0011,   /* U+30BF */
  0x0011,   /* U+30C0 */
  0x0011,   /* U+30C1 */
  0x0011,   /* U+30C2 */
  0x000F,   /* U+30C3 */
  0x0011,   /* U+30C4 */
  0x0011,   /* U+30C5 */
  0x0011,   /* U+30C6 */
  0x0011,   /* U+30C7 */
  0x0011,   /* U+30C8 */
  0x0011,   /* U+30C9 */
  0x0011,   /* U+30CA */
  0x0011,   /* U+30CB */
  0x0011,   /* U+30CC */
  0x0011,   /* U+30CD */
  0x0011,   /* U+30CE */
  0x0011,   /* U+30CF */
  0x0011,   /* U+30D0 */
  0x0011,   /* U+30D1 */
  0x0011,   /* U+30D2 */
  0x0011,   /* U+30D3 */
  0x0011,   /* U+30D4 */
  0x0011,   /* U+30D5 */
  0x0011,   /* U+30D6 */
  0x0011,   /* U+30D7 */
  0x0011,   /* U+30D8 */
  0x0011,   /* U+30D9 */
  0x0011,   /* U+30DA */
  0x0011,   /* U+30DB */
  0x0011,   /* U+30DC */
  0x0011,   /* U+30DD */
  0x0011,   /* U+30DE */
  0x0011,   /* U+30DF */
  0x0011,   /* U+30E0 */
  0x0011,   /* U+30E1 */
  0x0011,   /* U+30E2 */
  0x000F,   /* U+30E3 */
  0x0011,   /* U+30E4 */
  0x000F,   /* U+30E5 */
  0x0011,   /* U+30E6 */
  0x000F,   /* U+30E7 */
  0x0011,   /* U+30E8 */
  0x0011,   /* U+30E9 */
  0x0011,   /* U+30EA */
  0x0011,   /* U+30EB */
  0x0011,   /* U+30EC */
  0x0011,   /* U+30ED */
  0x000F,   /* U+30EE */
  0x0011,   /* U+30EF */
  0x0011,   /* U+30F0 */
  0x0011,   /* U+30F1 */
  0x0011,   /* U+30F2 */
  0x0011,   /* U+30F3 */
  0x0011,   /* U+30F4 */
  0x000F,   /* U+30F5 */
  0x000F,   /* U+30F6 */
  0x0011,   /* U+30F7 */
  0x0011,   /* U+30F8 */
  0x0011,   /* U+30F9 */
  0x0011,   /* U+30FA */
  0x0002,   /* U+30FB */
  0x0002,   /* U+30FC */
  0x0002,   /* U+30FD */
  0x0002,   /* U+30FE */
  0x0016,   /* U+30FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+3000 */
  0x0000,   /* U+3001 */
  0x0000,   /* U+3002 */
  0x0000,   /* U+3003 */
  0x0000,   /* U+3004 */
  0x80C2,   /* U+3005 */
  0x8015,   /* U+3006 */
  0x8016,   /* U+3007 */
  0x0000,   /* U+3008 */
  0x0000,   /* U+3009 */
  0x0000,   /* U+300A */
  0x0000,   /* U+300B */
  0x0000,   /* U+300C */
  0x0000,   /* U+300D */
  0x0000,   /* U+300E */
  0x0000,   /* U+300F */
  0x0000,   /* U+3010 */
  0x0000,   /* U+3011 */
  0x0000,   /* U+3012 */
  0x0000,   /* U+3013 */
  0x0000,   /* U+3014 */
  0x0000,   /* U+3015 */
  0x0000,   /* U+3016 */
  0x0000,   /* U+3017 */
  0x0000,   /* U+3018 */
  0x0000,   /* U+3019 */
  0x0000,   /* U+301A */
  0x0000,   /* U+301B */
  0x0000,   /* U+301C */
  0x0000,   /* U+301D */
  0x0000,   /* U+301E */
  0x0000,   /* U+301F */
  0x0000,   /* U+3020 */
  0x8017,   /* U+3021 */
  0x805F,   /* U+3022 */
  0x80C3,   /* U+3023 */
  0x8060,   /* U+3024 */
  0x8018,   /* U+3025 */
  0x8061,   /* U+3026 */
  0x80C4,   /* U+3027 */
  0x81D9,   /* U+3028 */
  0x81DA,   /* U+3029 */
  0x0000,   /* U+302A */
  0x0000,   /* U+302B */
  0x0000,   /* U+302C */
  0x0000,   /* U+302D */
  0x0000,   /* U+302E */
  0x0000,   /* U+302F */
  0x0000,   /* U+3030 */
  0x0000,   /* U+3031 */
  0x0000,   /* U+3032 */
  0x0000,   /* U+3033 */
  0x0000,   /* U+3034 */
  0x0000,   /* U+3035 */
  0x0000,   /* U+3036 */
  0x0000,   /* U+3037 */
  0x804A,   /* U+3038 */
  0x8007,   /* U+3039 */
  0x80D6,   /* U+303A */
  0x8019,   /* U+303B */
  0x3DD0,   /* U+303C */
  0x0000,   /* U+303D */
  0x0000,   /* U+303E */
  0x0000,   /* U+303F */
  0xB040,   /* U+3040 */
  0x0000,   /* U+3041 */
  0x0000,   /* U+3042 */
  0x0000,   /* U+3043 */
  0x0000,   /* U+3044 */
  0x0000,   /* U+3045 */
  0x0000,   /* U+3046 */
  0x0000,   /* U+3047 */
  0x0000,   /* U+3048 */
  0x0000,   /* U+3049 */
  0x0000,   /* U+304A */
  0x0000,   /* U+304B */
  0x0000,   /* U+304C */
  0x0000,   /* U+304D */
  0x0000,   /* U+304E */
  0x0000,   /* U+304F */
  0x0000,   /* U+3050 */
  0x0000,   /* U+3051 */
  0x0000,   /* U+3052 */
  0x0000,   /* U+3053 */
  0x0000,   /* U+3054 */
  0x0000,   /* U+3055 */
  0x0000,   /* U+3056 */
  0x0000,   /* U+3057 */
  0x0000,   /* U+3058 */
  0x0000,   /* U+3059 */
  0x0000,   /* U+305A */
  0x0000,   /* U+305B */
  0x0000,   /* U+305C */
  0x0000,   /* U+305D */
  0x0000,   /* U+305E */
  0x0000,   /* U+305F */
  0x0000,   /* U+3060 */
  0x0000,   /* U+3061 */
  0x0000,   /* U+3062 */
  0x0000,   /* U+3063 */
  0x0000,   /* U+3064 */
  0x0000,   /* U+3065 */
  0x0000,   /* U+3066 */
  0x0000,   /* U+3067 */
  0x0000,   /* U+3068 */
  0x0000,   /* U+3069 */
  0x0000,   /* U+306A */
  0x0000,   /* U+306B */
  0x0000,   /* U+306C */
  0x0000,   /* U+306D */
  0x0000,   /* U+306E */
  0x0000,   /* U+306F */
  0x0000,   /* U+3070 */
  0x0000,   /* U+3071 */
  0x0000,   /* U+3072 */
  0x0000,   /* U+3073 */
  0x0000,   /* U+3074 */
  0x0000,   /* U+3075 */
  0x0000,   /* U+3076 */
  0x0000,   /* U+3077 */
  0x0000,   /* U+3078 */
  0x0000,   /* U+3079 */
  0x0000,   /* U+307A */
  0x0000,   /* U+307B */
  0x0000,   /* U+307C */
  0x0000,   /* U+307D */
  0x0000,   /* U+307E */
  0x0000,   /* U+307F */
  0x0000,   /* U+3080 */
  0x0000,   /* U+3081 */
  0x0000,   /* U+3082 */
  0x0000,   /* U+3083 */
  0x0000,   /* U+3084 */
  0x0000,   /* U+3085 */
  0x0000,   /* U+3086 */
  0x0000,   /* U+3087 */
  0x0000,   /* U+3088 */
  0x0000,   /* U+3089 */
  0x0000,   /* U+308A */
  0x0000,   /* U+308B */
  0x0000,   /* U+308C */
  0x0000,   /* U+308D */
  0x0000,   /* U+308E */
  0x0000,   /* U+308F */
  0x0000,   /* U+3090 */
  0x0000,   /* U+3091 */
  0x0000,   /* U+3092 */
  0x0000,   /* U+3093 */
  0x0000,   /* U+3094 */
  0x0000,   /* U+3095 */
  0x0000,   /* U+3096 */
  0xB097,   /* U+3097 */
  0xB098,   /* U+3098 */
  0x0000,   /* U+3099 */
  0x0000,   /* U+309A */
  0x0000,   /* U+309B */
  0x0000,   /* U+309C */
  0x0000,   /* U+309D */
  0x0000,   /* U+309E */
  0x3DEC,   /* U+309F */
  0x0000,   /* U+30A0 */
  0x0000,   /* U+30A1 */
  0x0000,   /* U+30A2 */
  0x0000,   /* U+30A3 */
  0x0000,   /* U+30A4 */
  0x0000,   /* U+30A5 */
  0x0000,   /* U+30A6 */
  0x0000,   /* U+30A7 */
  0x0000,   /* U+30A8 */
  0x0000,   /* U+30A9 */
  0x0000,   /* U+30AA */
  0x0000,   /* U+30AB */
  0x0000,   /* U+30AC */
  0x0000,   /* U+30AD */
  0x0000,   /* U+30AE */
  0x0000,   /* U+30AF */
  0x0000,   /* U+30B0 */
  0x0000,   /* U+30B1 */
  0x0000,   /* U+30B2 */
  0x0000,   /* U+30B3 */
  0x0000,   /* U+30B4 */
  0x0000,   /* U+30B5 */
  0x0000,   /* U+30B6 */
  0x0000,   /* U+30B7 */
  0x0000,   /* U+30B8 */
  0x0000,   /* U+30B9 */
  0x0000,   /* U+30BA */
  0x0000,   /* U+30BB */
  0x0000,   /* U+30BC */
  0x0000,   /* U+30BD */
  0x0000,   /* U+30BE */
  0x0000,   /* U+30BF */
  0x0000,   /* U+30C0 */
  0x0000,   /* U+30C1 */
  0x0000,   /* U+30C2 */
  0x0000,   /* U+30C3 */
  0x0000,   /* U+30C4 */
  0x0000,   /* U+30C5 */
  0x0000,   /* U+30C6 */
  0x0000,   /* U+30C7 */
  0x0000,   /* U+30C8 */
  0x0000,   /* U+30C9 */
  0x0000,   /* U+30CA */
  0x0000,   /* U+30CB */
  0x0000,   /* U+30CC */
  0x0000,   /* U+30CD */
  0x0000,   /* U+30CE */
  0x0000,   /* U+30CF */
  0x0000,   /* U+30D0 */
  0x0000,   /* U+30D1 */
  0x0000,   /* U+30D2 */
  0x0000,   /* U+30D3 */
  0x0000,   /* U+30D4 */
  0x0000,   /* U+30D5 */
  0x0000,   /* U+30D6 */
  0x0000,   /* U+30D7 */
  0x0000,   /* U+30D8 */
  0x0000,   /* U+30D9 */
  0x0000,   /* U+30DA */
  0x0000,   /* U+30DB */
  0x0000,   /* U+30DC */
  0x0000,   /* U+30DD */
  0x0000,   /* U+30DE */
  0x0000,   /* U+30DF */
  0x0000,   /* U+30E0 */
  0x0000,   /* U+30E1 */
  0x0000,   /* U+30E2 */
  0x0000,   /* U+30E3 */
  0x0000,   /* U+30E4 */
  0x0000,   /* U+30E5 */
  0x0000,   /* U+30E6 */
  0x0000,   /* U+30E7 */
  0x0000,   /* U+30E8 */
  0x0000,   /* U+30E9 */
  0x0000,   /* U+30EA */
  0x0000,   /* U+30EB */
  0x0000,   /* U+30EC */
  0x0000,   /* U+30ED */
  0x0000,   /* U+30EE */
  0x0000,   /* U+30EF */
  0x0000,   /* U+30F0 */
  0x0000,   /* U+30F1 */
  0x0000,   /* U+30F2 */
  0x0000,   /* U+30F3 */
  0x0000,   /* U+30F4 */
  0x0000,   /* U+30F5 */
  0x0000,   /* U+30F6 */
  0x0000,   /* U+30F7 */
  0x0000,   /* U+30F8 */
  0x0000,   /* U+30F9 */
  0x0000,   /* U+30FA */
  0x0000,   /* U+30FB */
  0x0000,   /* U+30FC */
  0x0000,   /* U+30FD */
  0x0000,   /* U+30FE */
  0x3DD7,   /* U+30FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3000 */
  0x0000,   /* U+3001 */
  0x0000,   /* U+3002 */
  0x0000,   /* U+3003 */
  0x0000,   /* U+3004 */
  0x0000,   /* U+3005 */
  0x0000,   /* U+3006 */
  0x0000,   /* U+3007 */
  0x0000,   /* U+3008 */
  0x0000,   /* U+3009 */
  0x0000,   /* U+300A */
  0x0000,   /* U+300B */
  0x0000,   /* U+300C */
  0x0000,   /* U+300D */
  0x0000,   /* U+300E */
  0x0000,   /* U+300F */
  0x0000,   /* U+3010 */
  0x0000,   /* U+3011 */
  0x0000,   /* U+3012 */
  0x0000,   /* U+3013 */
  0x0000,   /* U+3014 */
  0x0000,   /* U+3015 */
  0x0000,   /* U+3016 */
  0x0000,   /* U+3017 */
  0x0000,   /* U+3018 */
  0x0000,   /* U+3019 */
  0x0000,   /* U+301A */
  0x0000,   /* U+301B */
  0x0000,   /* U+301C */
  0x0000,   /* U+301D */
  0x0000,   /* U+301E */
  0x0000,   /* U+301F */
  0x0000,   /* U+3020 */
  0x0000,   /* U+3021 */
  0x0000,   /* U+3022 */
  0x0000,   /* U+3023 */
  0x0000,   /* U+3024 */
  0x0000,   /* U+3025 */
  0x0000,   /* U+3026 */
  0x0000,   /* U+3027 */
  0x0000,   /* U+3028 */
  0x0000,   /* U+3029 */
  0x0000,   /* U+302A */
  0x0000,   /* U+302B */
  0x0000,   /* U+302C */
  0x0000,   /* U+302D */
  0x0000,   /* U+302E */
  0x0000,   /* U+302F */
  0x0000,   /* U+3030 */
  0x0000,   /* U+3031 */
  0x0037,   /* U+3032 */
  0x0000,   /* U+3033 */
  0x0037,   /* U+3034 */
  0x0000,   /* U+3035 */
  0x0000,   /* U+3036 */
  0x0000,   /* U+3037 */
  0x0000,   /* U+3038 */
  0x0000,   /* U+3039 */
  0x0000,   /* U+303A */
  0x0000,   /* U+303B */
  0x0020,   /* U+303C */
  0x0000,   /* U+303D */
  0x0000,   /* U+303E */
  0x0000,   /* U+303F */
  0x0000,   /* U+3040 */
  0x0000,   /* U+3041 */
  0x0000,   /* U+3042 */
  0x0000,   /* U+3043 */
  0x0000,   /* U+3044 */
  0x0000,   /* U+3045 */
  0x0000,   /* U+3046 */
  0x0000,   /* U+3047 */
  0x0000,   /* U+3048 */
  0x0000,   /* U+3049 */
  0x0000,   /* U+304A */
  0x0000,   /* U+304B */
  0x0037,   /* U+304C */
  0x0000,   /* U+304D */
  0x0037,   /* U+304E */
  0x0000,   /* U+304F */
  0x0037,   /* U+3050 */
  0x0000,   /* U+3051 */
  0x0037,   /* U+3052 */
  0x0000,   /* U+3053 */
  0x0037,   /* U+3054 */
  0x0000,   /* U+3055 */
  0x0037,   /* U+3056 */
  0x0000,   /* U+3057 */
  0x0037,   /* U+3058 */
  0x0000,   /* U+3059 */
  0x0037,   /* U+305A */
  0x0000,   /* U+305B */
  0x0037,   /* U+305C */
  0x0000,   /* U+305D */
  0x0037,   /* U+305E */
  0x0000,   /* U+305F */
  0x0037,   /* U+3060 */
  0x0000,   /* U+3061 */
  0x0037,   /* U+3062 */
  0x0000,   /* U+3063 */
  0x0000,   /* U+3064 */
  0x0037,   /* U+3065 */
  0x0000,   /* U+3066 */
  0x0037,   /* U+3067 */
  0x0000,   /* U+3068 */
  0x0037,   /* U+3069 */
  0x0000,   /* U+306A */
  0x0000,   /* U+306B */
  0x0000,   /* U+306C */
  0x0000,   /* U+306D */
  0x0000,   /* U+306E */
  0x0000,   /* U+306F */
  0x0037,   /* U+3070 */
  0x0038,   /* U+3071 */
  0x0000,   /* U+3072 */
  0x0037,   /* U+3073 */
  0x0038,   /* U+3074 */
  0x0000,   /* U+3075 */
  0x0037,   /* U+3076 */
  0x0038,   /* U+3077 */
  0x0000,   /* U+3078 */
  0x0037,   /* U+3079 */
  0x0038,   /* U+307A */
  0x0000,   /* U+307B */
  0x0037,   /* U+307C */
  0x0038,   /* U+307D */
  0x0000,   /* U+307E */
  0x0000,   /* U+307F */
  0x0000,   /* U+3080 */
  0x0000,   /* U+3081 */
  0x0000,   /* U+3082 */
  0x0000,   /* U+3083 */
  0x0000,   /* U+3084 */
  0x0000,   /* U+3085 */
  0x0000,   /* U+3086 */
  0x0000,   /* U+3087 */
  0x0000,   /* U+3088 */
  0x0000,   /* U+3089 */
  0x0000,   /* U+308A */
  0x0000,   /* U+308B */
  0x0000,   /* U+308C */
  0x0000,   /* U+308D */
  0x0000,   /* U+308E */
  0x0000,   /* U+308F */
  0x0000,   /* U+3090 */
  0x0000,   /* U+3091 */
  0x0000,   /* U+3092 */
  0x0000,   /* U+3093 */
  0x0037,   /* U+3094 */
  0x0000,   /* U+3095 */
  0x0000,   /* U+3096 */
  0x0000,   /* U+3097 */
  0x0000,   /* U+3098 */
  0x0000,   /* U+3099 */
  0x0000,   /* U+309A */
  0x0000,   /* U+309B */
  0x0000,   /* U+309C */
  0x0000,   /* U+309D */
  0x0037,   /* U+309E */
  0x0020,   /* U+309F */
  0x0000,   /* U+30A0 */
  0x0000,   /* U+30A1 */
  0x0000,   /* U+30A2 */
  0x0000,   /* U+30A3 */
  0x0000,   /* U+30A4 */
  0x0000,   /* U+30A5 */
  0x0000,   /* U+30A6 */
  0x0000,   /* U+30A7 */
  0x0000,   /* U+30A8 */
  0x0000,   /* U+30A9 */
  0x0000,   /* U+30AA */
  0x0000,   /* U+30AB */
  0x0037,   /* U+30AC */
  0x0000,   /* U+30AD */
  0x0037,   /* U+30AE */
  0x0000,   /* U+30AF */
  0x0037,   /* U+30B0 */
  0x0000,   /* U+30B1 */
  0x0037,   /* U+30B2 */
  0x0000,   /* U+30B3 */
  0x0037,   /* U+30B4 */
  0x0000,   /* U+30B5 */
  0x0037,   /* U+30B6 */
  0x0000,   /* U+30B7 */
  0x0037,   /* U+30B8 */
  0x0000,   /* U+30B9 */
  0x0037,   /* U+30BA */
  0x0000,   /* U+30BB */
  0x0037,   /* U+30BC */
  0x0000,   /* U+30BD */
  0x0037,   /* U+30BE */
  0x0000,   /* U+30BF */
  0x0037,   /* U+30C0 */
  0x0000,   /* U+30C1 */
  0x0037,   /* U+30C2 */
  0x0000,   /* U+30C3 */
  0x0000,   /* U+30C4 */
  0x0037,   /* U+30C5 */
  0x0000,   /* U+30C6 */
  0x0037,   /* U+30C7 */
  0x0000,   /* U+30C8 */
  0x0037,   /* U+30C9 */
  0x0000,   /* U+30CA */
  0x0000,   /* U+30CB */
  0x0000,   /* U+30CC */
  0x0000,   /* U+30CD */
  0x0000,   /* U+30CE */
  0x0000,   /* U+30CF */
  0x0037,   /* U+30D0 */
  0x0038,   /* U+30D1 */
  0x0000,   /* U+30D2 */
  0x0037,   /* U+30D3 */
  0x0038,   /* U+30D4 */
  0x0000,   /* U+30D5 */
  0x0037,   /* U+30D6 */
  0x0038,   /* U+30D7 */
  0x0000,   /* U+30D8 */
  0x0037,   /* U+30D9 */
  0x0038,   /* U+30DA */
  0x0000,   /* U+30DB */
  0x0037,   /* U+30DC */
  0x0038,   /* U+30DD */
  0x0000,   /* U+30DE */
  0x0000,   /* U+30DF */
  0x0000,   /* U+30E0 */
  0x0000,   /* U+30E1 */
  0x0000,   /* U+30E2 */
  0x0000,   /* U+30E3 */
  0x0000,   /* U+30E4 */
  0x0000,   /* U+30E5 */
  0x0000,   /* U+30E6 */
  0x0000,   /* U+30E7 */
  0x0000,   /* U+30E8 */
  0x0000,   /* U+30E9 */
  0x0000,   /* U+30EA */
  0x0000,   /* U+30EB */
  0x0000,   /* U+30EC */
  0x0000,   /* U+30ED */
  0x0000,   /* U+30EE */
  0x0000,   /* U+30EF */
  0x0000,   /* U+30F0 */
  0x0000,   /* U+30F1 */
  0x0000,   /* U+30F2 */
  0x0000,   /* U+30F3 */
  0x0037,   /* U+30F4 */
  0x0000,   /* U+30F5 */
  0x0000,   /* U+30F6 */
  0x0037,   /* U+30F7 */
  0x0037,   /* U+30F8 */
  0x0037,   /* U+30F9 */
  0x0037,   /* U+30FA */
  0x0000,   /* U+30FB */
  0x0000,   /* U+30FC */
  0x0000,   /* U+30FD */
  0x0037,   /* U+30FE */
  0x0020,   /* U+30FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3000 */
  0x0000,   /* U+3001 */
  0x0000,   /* U+3002 */
  0x0000,   /* U+3003 */
  0x0000,   /* U+3004 */
  0x0000,   /* U+3005 */
  0x0000,   /* U+3006 */
  0x0000,   /* U+3007 */
  0x0000,   /* U+3008 */
  0x0000,   /* U+3009 */
  0x0000,   /* U+300A */
  0x0000,   /* U+300B */
  0x0000,   /* U+300C */
  0x0000,   /* U+300D */
  0x0000,   /* U+300E */
  0x0000,   /* U+300F */
  0x0000,   /* U+3010 */
  0x0000,   /* U+3011 */
  0x0000,   /* U+3012 */
  0x0000,   /* U+3013 */
  0x0000,   /* U+3014 */
  0x0000,   /* U+3015 */
  0x0000,   /* U+3016 */
  0x0000,   /* U+3017 */
  0x0000,   /* U+3018 */
  0x0000,   /* U+3019 */
  0x0000,   /* U+301A */
  0x0000,   /* U+301B */
  0x0000,   /* U+301C */
  0x0000,   /* U+301D */
  0x0000,   /* U+301E */
  0x0000,   /* U+301F */
  0x0000,   /* U+3020 */
  0x0000,   /* U+3021 */
  0x0000,   /* U+3022 */
  0x0000,   /* U+3023 */
  0x0000,   /* U+3024 */
  0x0000,   /* U+3025 */
  0x0000,   /* U+3026 */
  0x0000,   /* U+3027 */
  0x0000,   /* U+3028 */
  0x0000,   /* U+3029 */
  0x0000,   /* U+302A */
  0x0000,   /* U+302B */
  0x0000,   /* U+302C */
  0x0000,   /* U+302D */
  0x0000,   /* U+302E */
  0x0000,   /* U+302F */
  0x0000,   /* U+3030 */
  0x0000,   /* U+3031 */
  0x0002,   /* U+3032 */
  0x0000,   /* U+3033 */
  0x0002,   /* U+3034 */
  0x0000,   /* U+3035 */
  0x0000,   /* U+3036 */
  0x0000,   /* U+3037 */
  0x0000,   /* U+3038 */
  0x0000,   /* U+3039 */
  0x0000,   /* U+303A */
  0x0000,   /* U+303B */
  0x0004,   /* U+303C */
  0x0000,   /* U+303D */
  0x0000,   /* U+303E */
  0x0000,   /* U+303F */
  0x0000,   /* U+3040 */
  0x0000,   /* U+3041 */
  0x0000,   /* U+3042 */
  0x0000,   /* U+3043 */
  0x0000,   /* U+3044 */
  0x0000,   /* U+3045 */
  0x0000,   /* U+3046 */
  0x0000,   /* U+3047 */
  0x0000,   /* U+3048 */
  0x0000,   /* U+3049 */
  0x0000,   /* U+304A */
  0x0000,   /* U+304B */
  0x0002,   /* U+304C */
  0x0000,   /* U+304D */
  0x0002,   /* U+304E */
  0x0000,   /* U+304F */
  0x0002,   /* U+3050 */
  0x0000,   /* U+3051 */
  0x0002,   /* U+3052 */
  0x0000,   /* U+3053 */
  0x0002,   /* U+3054 */
  0x0000,   /* U+3055 */
  0x0002,   /* U+3056 */
  0x0000,   /* U+3057 */
  0x0002,   /* U+3058 */
  0x0000,   /* U+3059 */
  0x0002,   /* U+305A */
  0x0000,   /* U+305B */
  0x0002,   /* U+305C */
  0x0000,   /* U+305D */
  0x0002,   /* U+305E */
  0x0000,   /* U+305F */
  0x0002,   /* U+3060 */
  0x0000,   /* U+3061 */
  0x0002,   /* U+3062 */
  0x0000,   /* U+3063 */
  0x0000,   /* U+3064 */
  0x0002,   /* U+3065 */
  0x0000,   /* U+3066 */
  0x0002,   /* U+3067 */
  0x0000,   /* U+3068 */
  0x0002,   /* U+3069 */
  0x0000,   /* U+306A */
  0x0000,   /* U+306B */
  0x0000,   /* U+306C */
  0x0000,   /* U+306D */
  0x0000,   /* U+306E */
  0x0000,   /* U+306F */
  0x0002,   /* U+3070 */
  0x0002,   /* U+3071 */
  0x0000,   /* U+3072 */
  0x0002,   /* U+3073 */
  0x0002,   /* U+3074 */
  0x0000,   /* U+3075 */
  0x0002,   /* U+3076 */
  0x0002,   /* U+3077 */
  0x0000,   /* U+3078 */
  0x0002,   /* U+3079 */
  0x0002,   /* U+307A */
  0x0000,   /* U+307B */
  0x0002,   /* U+307C */
  0x0002,   /* U+307D */
  0x0000,   /* U+307E */
  0x0000,   /* U+307F */
  0x0000,   /* U+3080 */
  0x0000,   /* U+3081 */
  0x0000,   /* U+3082 */
  0x0000,   /* U+3083 */
  0x0000,   /* U+3084 */
  0x0000,   /* U+3085 */
  0x0000,   /* U+3086 */
  0x0000,   /* U+3087 */
  0x0000,   /* U+3088 */
  0x0000,   /* U+3089 */
  0x0000,   /* U+308A */
  0x0000,   /* U+308B */
  0x0000,   /* U+308C */
  0x0000,   /* U+308D */
  0x0000,   /* U+308E */
  0x0000,   /* U+308F */
  0x0000,   /* U+3090 */
  0x0000,   /* U+3091 */
  0x0000,   /* U+3092 */
  0x0000,   /* U+3093 */
  0x0002,   /* U+3094 */
  0x0000,   /* U+3095 */
  0x0000,   /* U+3096 */
  0x0000,   /* U+3097 */
  0x0000,   /* U+3098 */
  0x0000,   /* U+3099 */
  0x0000,   /* U+309A */
  0x0000,   /* U+309B */
  0x0000,   /* U+309C */
  0x0000,   /* U+309D */
  0x0002,   /* U+309E */
  0x0016,   /* U+309F */
  0x0000,   /* U+30A0 */
  0x0000,   /* U+30A1 */
  0x0000,   /* U+30A2 */
  0x0000,   /* U+30A3 */
  0x0000,   /* U+30A4 */
  0x0000,   /* U+30A5 */
  0x0000,   /* U+30A6 */
  0x0000,   /* U+30A7 */
  0x0000,   /* U+30A8 */
  0x0000,   /* U+30A9 */
  0x0000,   /* U+30AA */
  0x0000,   /* U+30AB */
  0x0002,   /* U+30AC */
  0x0000,   /* U+30AD */
  0x0002,   /* U+30AE */
  0x0000,   /* U+30AF */
  0x0002,   /* U+30B0 */
  0x0000,   /* U+30B1 */
  0x0002,   /* U+30B2 */
  0x0000,   /* U+30B3 */
  0x0002,   /* U+30B4 */
  0x0000,   /* U+30B5 */
  0x0002,   /* U+30B6 */
  0x0000,   /* U+30B7 */
  0x0002,   /* U+30B8 */
  0x0000,   /* U+30B9 */
  0x0002,   /* U+30BA */
  0x0000,   /* U+30BB */
  0x0002,   /* U+30BC */
  0x0000,   /* U+30BD */
  0x0002,   /* U+30BE */
  0x0000,   /* U+30BF */
  0x0002,   /* U+30C0 */
  0x0000,   /* U+30C1 */
  0x0002,   /* U+30C2 */
  0x0000,   /* U+30C3 */
  0x0000,   /* U+30C4 */
  0x0002,   /* U+30C5 */
  0x0000,   /* U+30C6 */
  0x0002,   /* U+30C7 */
  0x0000,   /* U+30C8 */
  0x0002,   /* U+30C9 */
  0x0000,   /* U+30CA */
  0x0000,   /* U+30CB */
  0x0000,   /* U+30CC */
  0x0000,   /* U+30CD */
  0x0000,   /* U+30CE */
  0x0000,   /* U+30CF */
  0x0002,   /* U+30D0 */
  0x0002,   /* U+30D1 */
  0x0000,   /* U+30D2 */
  0x0002,   /* U+30D3 */
  0x0002,   /* U+30D4 */
  0x0000,   /* U+30D5 */
  0x0002,   /* U+30D6 */
  0x0002,   /* U+30D7 */
  0x0000,   /* U+30D8 */
  0x0002,   /* U+30D9 */
  0x0002,   /* U+30DA */
  0x0000,   /* U+30DB */
  0x0002,   /* U+30DC */
  0x0002,   /* U+30DD */
  0x0000,   /* U+30DE */
  0x0000,   /* U+30DF */
  0x0000,   /* U+30E0 */
  0x0000,   /* U+30E1 */
  0x0000,   /* U+30E2 */
  0x0000,   /* U+30E3 */
  0x0000,   /* U+30E4 */
  0x0000,   /* U+30E5 */
  0x0000,   /* U+30E6 */
  0x0000,   /* U+30E7 */
  0x0000,   /* U+30E8 */
  0x0000,   /* U+30E9 */
  0x0000,   /* U+30EA */
  0x0000,   /* U+30EB */
  0x0000,   /* U+30EC */
  0x0000,   /* U+30ED */
  0x0000,   /* U+30EE */
  0x0000,   /* U+30EF */
  0x0000,   /* U+30F0 */
  0x0000,   /* U+30F1 */
  0x0000,   /* U+30F2 */
  0x0000,   /* U+30F3 */
  0x0002,   /* U+30F4 */
  0x0000,   /* U+30F5 */
  0x0000,   /* U+30F6 */
  0x0002,   /* U+30F7 */
  0x0002,   /* U+30F8 */
  0x0002,   /* U+30F9 */
  0x0002,   /* U+30FA */
  0x0000,   /* U+30FB */
  0x0000,   /* U+30FC */
  0x0000,   /* U+30FD */
  0x0002,   /* U+30FE */
  0x0016,   /* U+30FF */
};

uint16 zh3_han_p034[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C4C,   /* U+3400 */
  0x1C4D,   /* U+3401 */
  0x1C4D,   /* U+3402 */
  0x1C4A,   /* U+3403 */
  0x1C4A,   /* U+3404 */
  0x1C49,   /* U+3405 */
  0x1C4D,   /* U+3406 */
  0x1C4A,   /* U+3407 */
  0x1C4A,   /* U+3408 */
  0x1C4A,   /* U+3409 */
  0x1C4B,   /* U+340A */
  0x1C4B,   /* U+340B */
  0x1C4C,   /* U+340C */
  0x1C4C,   /* U+340D */
  0x1C4C,   /* U+340E */
  0x1C4C,   /* U+340F */
  0x1C4D,   /* U+3410 */
  0x1C4D,   /* U+3411 */
  0x1C4D,   /* U+3412 */
  0x1C4D,   /* U+3413 */
  0x1C4D,   /* U+3414 */
  0x1C4D,   /* U+3415 */
  0x1C4E,   /* U+3416 */
  0x1C4E,   /* U+3417 */
  0x1C4E,   /* U+3418 */
  0x1C4F,   /* U+3419 */
  0x1C4F,   /* U+341A */
  0x1C4F,   /* U+341B */
  0x1C50,   /* U+341C */
  0x1C50,   /* U+341D */
  0x1C50,   /* U+341E */
  0x1C50,   /* U+341F */
  0x1C50,   /* U+3420 */
  0x1C52,   /* U+3421 */
  0x1C52,   /* U+3422 */
  0x1C52,   /* U+3423 */
  0x1C53,   /* U+3424 */
  0x1C57,   /* U+3425 */
  0x1C5A,   /* U+3426 */
  0x1C4B,   /* U+3427 */
  0x1C4F,   /* U+3428 */
  0x1C4F,   /* U+3429 */
  0x1C4D,   /* U+342A */
  0x1C4D,   /* U+342B */
  0x1C4E,   /* U+342C */
  0x1C4F,   /* U+342D */
  0x1C54,   /* U+342E */
  0x1C58,   /* U+342F */
  0x1C4C,   /* U+3430 */
  0x1C4C,   /* U+3431 */
  0x1C4C,   /* U+3432 */
  0x1C4C,   /* U+3433 */
  0x1C4C,   /* U+3434 */
  0x1C4C,   /* U+3435 */
  0x1C4C,   /* U+3436 */
  0x1C4C,   /* U+3437 */
  0x1C4D,   /* U+3438 */
  0x1C4D,   /* U+3439 */
  0x1C4D,   /* U+343A */
  0x1C4D,   /* U+343B */
  0x1C4D,   /* U+343C */
  0x1C4D,   /* U+343D */
  0x1C4D,   /* U+343E */
  0x1C4D,   /* U+343F */
  0x1C4D,   /* U+3440 */
  0x1C4E,   /* U+3441 */
  0x1C4E,   /* U+3442 */
  0x1C4E,   /* U+3443 */
  0x1C4E,   /* U+3444 */
  0x1C4E,   /* U+3445 */
  0x1C4E,   /* U+3446 */
  0x1C4E,   /* U+3447 */
  0x1C4E,   /* U+3448 */
  0x1C4F,   /* U+3449 */
  0x1C4F,   /* U+344A */
  0x1C4F,   /* U+344B */
  0x1C4F,   /* U+344C */
  0x1C4F,   /* U+344D */
  0x1C4F,   /* U+344E */
  0x1C4F,   /* U+344F */
  0x1C4F,   /* U+3450 */
  0x1C4F,   /* U+3451 */
  0x1C4F,   /* U+3452 */
  0x1C4F,   /* U+3453 */
  0x1C4F,   /* U+3454 */
  0x1C4F,   /* U+3455 */
  0x1C4F,   /* U+3456 */
  0x1C50,   /* U+3457 */
  0x1C50,   /* U+3458 */
  0x1C50,   /* U+3459 */
  0x1C50,   /* U+345A */
  0x1C50,   /* U+345B */
  0x1C50,   /* U+345C */
  0x1C50,   /* U+345D */
  0x1C50,   /* U+345E */
  0x1C50,   /* U+345F */
  0x1C50,   /* U+3460 */
  0x1C50,   /* U+3461 */
  0x1C50,   /* U+3462 */
  0x1C51,   /* U+3463 */
  0x1C52,   /* U+3464 */
  0x1C51,   /* U+3465 */
  0x1C51,   /* U+3466 */
  0x1C51,   /* U+3467 */
  0x1C51,   /* U+3468 */
  0x1C51,   /* U+3469 */
  0x1C51,   /* U+346A */
  0x1C51,   /* U+346B */
  0x1C51,   /* U+346C */
  0x1C51,   /* U+346D */
  0x1C52,   /* U+346E */
  0x1C52,   /* U+346F */
  0x1C52,   /* U+3470 */
  0x1C52,   /* U+3471 */
  0x1C52,   /* U+3472 */
  0x1C53,   /* U+3473 */
  0x1C53,   /* U+3474 */
  0x1C53,   /* U+3475 */
  0x1C53,   /* U+3476 */
  0x1C53,   /* U+3477 */
  0x1C53,   /* U+3478 */
  0x1C53,   /* U+3479 */
  0x1C53,   /* U+347A */
  0x1C54,   /* U+347B */
  0x1C54,   /* U+347C */
  0x1C54,   /* U+347D */
  0x1C54,   /* U+347E */
  0x1C54,   /* U+347F */
  0x1C54,   /* U+3480 */
  0x1C54,   /* U+3481 */
  0x1C55,   /* U+3482 */
  0x1C55,   /* U+3483 */
  0x1C55,   /* U+3484 */
  0x1C55,   /* U+3485 */
  0x1C55,   /* U+3486 */
  0x1C55,   /* U+3487 */
  0x1C55,   /* U+3488 */
  0x1C55,   /* U+3489 */
  0x1C55,   /* U+348A */
  0x1C55,   /* U+348B */
  0x1C55,   /* U+348C */
  0x1C55,   /* U+348D */
  0x1C55,   /* U+348E */
  0x1C55,   /* U+348F */
  0x1C55,   /* U+3490 */
  0x1C56,   /* U+3491 */
  0x1C56,   /* U+3492 */
  0x1C56,   /* U+3493 */
  0x1C56,   /* U+3494 */
  0x1C56,   /* U+3495 */
  0x1C56,   /* U+3496 */
  0x1C56,   /* U+3497 */
  0x1C56,   /* U+3498 */
  0x1C57,   /* U+3499 */
  0x1C57,   /* U+349A */
  0x1C57,   /* U+349B */
  0x1C57,   /* U+349C */
  0x1C58,   /* U+349D */
  0x1C58,   /* U+349E */
  0x1C59,   /* U+349F */
  0x1C59,   /* U+34A0 */
  0x1C5A,   /* U+34A1 */
  0x1C5A,   /* U+34A2 */
  0x1C5A,   /* U+34A3 */
  0x1C5B,   /* U+34A4 */
  0x1C5B,   /* U+34A5 */
  0x1C5B,   /* U+34A6 */
  0x1C5C,   /* U+34A7 */
  0x1C5C,   /* U+34A8 */
  0x1C5E,   /* U+34A9 */
  0x1C61,   /* U+34AA */
  0x1C4D,   /* U+34AB */
  0x1C4F,   /* U+34AC */
  0x1C51,   /* U+34AD */
  0x1C52,   /* U+34AE */
  0x1C59,   /* U+34AF */
  0x1C4C,   /* U+34B0 */
  0x1C4C,   /* U+34B1 */
  0x1C4D,   /* U+34B2 */
  0x1C4E,   /* U+34B3 */
  0x1C4E,   /* U+34B4 */
  0x1C4E,   /* U+34B5 */
  0x1C4E,   /* U+34B6 */
  0x1C4E,   /* U+34B7 */
  0x1C50,   /* U+34B8 */
  0x1C5B,   /* U+34B9 */
  0x1C4F,   /* U+34BA */
  0x1C52,   /* U+34BB */
  0x1C52,   /* U+34BC */
  0x1C53,   /* U+34BD */
  0x1C54,   /* U+34BE */
  0x1C5D,   /* U+34BF */
  0x1C4B,   /* U+34C0 */
  0x1C4B,   /* U+34C1 */
  0x1C50,   /* U+34C2 */
  0x1C53,   /* U+34C3 */
  0x1C56,   /* U+34C4 */
  0x1C4B,   /* U+34C5 */
  0x1C4D,   /* U+34C6 */
  0x1C4D,   /* U+34C7 */
  0x1C4E,   /* U+34C8 */
  0x1C4F,   /* U+34C9 */
  0x1C4F,   /* U+34CA */
  0x1C4F,   /* U+34CB */
  0x1C4F,   /* U+34CC */
  0x1C4F,   /* U+34CD */
  0x1C50,   /* U+34CE */
  0x1C50,   /* U+34CF */
  0x1C51,   /* U+34D0 */
  0x1C51,   /* U+34D1 */
  0x1C51,   /* U+34D2 */
  0x1C52,   /* U+34D3 */
  0x1C53,   /* U+34D4 */
  0x1C53,   /* U+34D5 */
  0x1C54,   /* U+34D6 */
  0x1C55,   /* U+34D7 */
  0x1C52,   /* U+34D8 */
  0x1C4D,   /* U+34D9 */
  0x1C4C,   /* U+34DA */
  0x1C4C,   /* U+34DB */
  0x1C4C,   /* U+34DC */
  0x1C4D,   /* U+34DD */
  0x1C4D,   /* U+34DE */
  0x1C4E,   /* U+34DF */
  0x1C4E,   /* U+34E0 */
  0x1C4F,   /* U+34E1 */
  0x1C4F,   /* U+34E2 */
  0x1C4F,   /* U+34E3 */
  0x1C4F,   /* U+34E4 */
  0x1C4F,   /* U+34E5 */
  0x1C4F,   /* U+34E6 */
  0x1C50,   /* U+34E7 */
  0x1C50,   /* U+34E8 */
  0x1C50,   /* U+34E9 */
  0x1C50,   /* U+34EA */
  0x1C50,   /* U+34EB */
  0x1C51,   /* U+34EC */
  0x1C51,   /* U+34ED */
  0x1C51,   /* U+34EE */
  0x1C51,   /* U+34EF */
  0x1C51,   /* U+34F0 */
  0x1C52,   /* U+34F1 */
  0x1C52,   /* U+34F2 */
  0x1C52,   /* U+34F3 */
  0x1C52,   /* U+34F4 */
  0x1C52,   /* U+34F5 */
  0x1C52,   /* U+34F6 */
  0x1C53,   /* U+34F7 */
  0x1C53,   /* U+34F8 */
  0x1C53,   /* U+34F9 */
  0x1C53,   /* U+34FA */
  0x1C53,   /* U+34FB */
  0x1C54,   /* U+34FC */
  0x1C54,   /* U+34FD */
  0x1C55,   /* U+34FE */
  0x1C55,   /* U+34FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3400 */
  0x0020,   /* U+3401 */
  0x0020,   /* U+3402 */
  0x0020,   /* U+3403 */
  0x0020,   /* U+3404 */
  0x0020,   /* U+3405 */
  0x0020,   /* U+3406 */
  0x0020,   /* U+3407 */
  0x0020,   /* U+3408 */
  0x0020,   /* U+3409 */
  0x0020,   /* U+340A */
  0x0020,   /* U+340B */
  0x0020,   /* U+340C */
  0x0020,   /* U+340D */
  0x0020,   /* U+340E */
  0x0020,   /* U+340F */
  0x0020,   /* U+3410 */
  0x0020,   /* U+3411 */
  0x0020,   /* U+3412 */
  0x0020,   /* U+3413 */
  0x0020,   /* U+3414 */
  0x0020,   /* U+3415 */
  0x0020,   /* U+3416 */
  0x0020,   /* U+3417 */
  0x0020,   /* U+3418 */
  0x0020,   /* U+3419 */
  0x0020,   /* U+341A */
  0x0020,   /* U+341B */
  0x0020,   /* U+341C */
  0x0020,   /* U+341D */
  0x0020,   /* U+341E */
  0x0020,   /* U+341F */
  0x0020,   /* U+3420 */
  0x0020,   /* U+3421 */
  0x0020,   /* U+3422 */
  0x0020,   /* U+3423 */
  0x0020,   /* U+3424 */
  0x0020,   /* U+3425 */
  0x0020,   /* U+3426 */
  0x0020,   /* U+3427 */
  0x0020,   /* U+3428 */
  0x0020,   /* U+3429 */
  0x0020,   /* U+342A */
  0x0020,   /* U+342B */
  0x0020,   /* U+342C */
  0x0020,   /* U+342D */
  0x0020,   /* U+342E */
  0x0020,   /* U+342F */
  0x0020,   /* U+3430 */
  0x0020,   /* U+3431 */
  0x0020,   /* U+3432 */
  0x0020,   /* U+3433 */
  0x0020,   /* U+3434 */
  0x0020,   /* U+3435 */
  0x0020,   /* U+3436 */
  0x0020,   /* U+3437 */
  0x0020,   /* U+3438 */
  0x0020,   /* U+3439 */
  0x0020,   /* U+343A */
  0x0020,   /* U+343B */
  0x0020,   /* U+343C */
  0x0020,   /* U+343D */
  0x0020,   /* U+343E */
  0x0020,   /* U+343F */
  0x0020,   /* U+3440 */
  0x0020,   /* U+3441 */
  0x0020,   /* U+3442 */
  0x0020,   /* U+3443 */
  0x0020,   /* U+3444 */
  0x0020,   /* U+3445 */
  0x0020,   /* U+3446 */
  0x0020,   /* U+3447 */
  0x0020,   /* U+3448 */
  0x0020,   /* U+3449 */
  0x0020,   /* U+344A */
  0x0020,   /* U+344B */
  0x0020,   /* U+344C */
  0x0020,   /* U+344D */
  0x0020,   /* U+344E */
  0x0020,   /* U+344F */
  0x0020,   /* U+3450 */
  0x0020,   /* U+3451 */
  0x0020,   /* U+3452 */
  0x0020,   /* U+3453 */
  0x0020,   /* U+3454 */
  0x0020,   /* U+3455 */
  0x0020,   /* U+3456 */
  0x0020,   /* U+3457 */
  0x0020,   /* U+3458 */
  0x0020,   /* U+3459 */
  0x0020,   /* U+345A */
  0x0020,   /* U+345B */
  0x0020,   /* U+345C */
  0x0020,   /* U+345D */
  0x0020,   /* U+345E */
  0x0020,   /* U+345F */
  0x0020,   /* U+3460 */
  0x0020,   /* U+3461 */
  0x0020,   /* U+3462 */
  0x0020,   /* U+3463 */
  0x0020,   /* U+3464 */
  0x0020,   /* U+3465 */
  0x0020,   /* U+3466 */
  0x0020,   /* U+3467 */
  0x0020,   /* U+3468 */
  0x0020,   /* U+3469 */
  0x0020,   /* U+346A */
  0x0020,   /* U+346B */
  0x0020,   /* U+346C */
  0x0020,   /* U+346D */
  0x0020,   /* U+346E */
  0x0020,   /* U+346F */
  0x0020,   /* U+3470 */
  0x0020,   /* U+3471 */
  0x0020,   /* U+3472 */
  0x0020,   /* U+3473 */
  0x0020,   /* U+3474 */
  0x0020,   /* U+3475 */
  0x0020,   /* U+3476 */
  0x0020,   /* U+3477 */
  0x0020,   /* U+3478 */
  0x0020,   /* U+3479 */
  0x0020,   /* U+347A */
  0x0020,   /* U+347B */
  0x0020,   /* U+347C */
  0x0020,   /* U+347D */
  0x0020,   /* U+347E */
  0x0020,   /* U+347F */
  0x0020,   /* U+3480 */
  0x0020,   /* U+3481 */
  0x0020,   /* U+3482 */
  0x0020,   /* U+3483 */
  0x0020,   /* U+3484 */
  0x0020,   /* U+3485 */
  0x0020,   /* U+3486 */
  0x0020,   /* U+3487 */
  0x0020,   /* U+3488 */
  0x0020,   /* U+3489 */
  0x0020,   /* U+348A */
  0x0020,   /* U+348B */
  0x0020,   /* U+348C */
  0x0020,   /* U+348D */
  0x0020,   /* U+348E */
  0x0020,   /* U+348F */
  0x0020,   /* U+3490 */
  0x0020,   /* U+3491 */
  0x0020,   /* U+3492 */
  0x0020,   /* U+3493 */
  0x0020,   /* U+3494 */
  0x0020,   /* U+3495 */
  0x0020,   /* U+3496 */
  0x0020,   /* U+3497 */
  0x0020,   /* U+3498 */
  0x0020,   /* U+3499 */
  0x0020,   /* U+349A */
  0x0020,   /* U+349B */
  0x0020,   /* U+349C */
  0x0020,   /* U+349D */
  0x0020,   /* U+349E */
  0x0020,   /* U+349F */
  0x0020,   /* U+34A0 */
  0x0020,   /* U+34A1 */
  0x0020,   /* U+34A2 */
  0x0020,   /* U+34A3 */
  0x0020,   /* U+34A4 */
  0x0020,   /* U+34A5 */
  0x0020,   /* U+34A6 */
  0x0020,   /* U+34A7 */
  0x0020,   /* U+34A8 */
  0x0020,   /* U+34A9 */
  0x0020,   /* U+34AA */
  0x0020,   /* U+34AB */
  0x0020,   /* U+34AC */
  0x0020,   /* U+34AD */
  0x0020,   /* U+34AE */
  0x0020,   /* U+34AF */
  0x0020,   /* U+34B0 */
  0x0020,   /* U+34B1 */
  0x0020,   /* U+34B2 */
  0x0020,   /* U+34B3 */
  0x0020,   /* U+34B4 */
  0x0020,   /* U+34B5 */
  0x0020,   /* U+34B6 */
  0x0020,   /* U+34B7 */
  0x0020,   /* U+34B8 */
  0x0020,   /* U+34B9 */
  0x0020,   /* U+34BA */
  0x0020,   /* U+34BB */
  0x0020,   /* U+34BC */
  0x0020,   /* U+34BD */
  0x0020,   /* U+34BE */
  0x0020,   /* U+34BF */
  0x0020,   /* U+34C0 */
  0x0020,   /* U+34C1 */
  0x0020,   /* U+34C2 */
  0x0020,   /* U+34C3 */
  0x0020,   /* U+34C4 */
  0x0020,   /* U+34C5 */
  0x0020,   /* U+34C6 */
  0x0020,   /* U+34C7 */
  0x0020,   /* U+34C8 */
  0x0020,   /* U+34C9 */
  0x0020,   /* U+34CA */
  0x0020,   /* U+34CB */
  0x0020,   /* U+34CC */
  0x0020,   /* U+34CD */
  0x0020,   /* U+34CE */
  0x0020,   /* U+34CF */
  0x0020,   /* U+34D0 */
  0x0020,   /* U+34D1 */
  0x0020,   /* U+34D2 */
  0x0020,   /* U+34D3 */
  0x0020,   /* U+34D4 */
  0x0020,   /* U+34D5 */
  0x0020,   /* U+34D6 */
  0x0020,   /* U+34D7 */
  0x0020,   /* U+34D8 */
  0x0020,   /* U+34D9 */
  0x0020,   /* U+34DA */
  0x0020,   /* U+34DB */
  0x0020,   /* U+34DC */
  0x0020,   /* U+34DD */
  0x0020,   /* U+34DE */
  0x0020,   /* U+34DF */
  0x0020,   /* U+34E0 */
  0x0020,   /* U+34E1 */
  0x0020,   /* U+34E2 */
  0x0020,   /* U+34E3 */
  0x0020,   /* U+34E4 */
  0x0020,   /* U+34E5 */
  0x0020,   /* U+34E6 */
  0x0020,   /* U+34E7 */
  0x0020,   /* U+34E8 */
  0x0020,   /* U+34E9 */
  0x0020,   /* U+34EA */
  0x0020,   /* U+34EB */
  0x0020,   /* U+34EC */
  0x0020,   /* U+34ED */
  0x0020,   /* U+34EE */
  0x0020,   /* U+34EF */
  0x0020,   /* U+34F0 */
  0x0020,   /* U+34F1 */
  0x0020,   /* U+34F2 */
  0x0020,   /* U+34F3 */
  0x0020,   /* U+34F4 */
  0x0020,   /* U+34F5 */
  0x0020,   /* U+34F6 */
  0x0020,   /* U+34F7 */
  0x0020,   /* U+34F8 */
  0x0020,   /* U+34F9 */
  0x0020,   /* U+34FA */
  0x0020,   /* U+34FB */
  0x0020,   /* U+34FC */
  0x0020,   /* U+34FD */
  0x0020,   /* U+34FE */
  0x0020,   /* U+34FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3400 */
  0x0002,   /* U+3401 */
  0x0002,   /* U+3402 */
  0x0002,   /* U+3403 */
  0x0002,   /* U+3404 */
  0x0002,   /* U+3405 */
  0x0002,   /* U+3406 */
  0x0002,   /* U+3407 */
  0x0002,   /* U+3408 */
  0x0002,   /* U+3409 */
  0x0002,   /* U+340A */
  0x0002,   /* U+340B */
  0x0002,   /* U+340C */
  0x0002,   /* U+340D */
  0x0002,   /* U+340E */
  0x0002,   /* U+340F */
  0x0002,   /* U+3410 */
  0x0002,   /* U+3411 */
  0x0002,   /* U+3412 */
  0x0002,   /* U+3413 */
  0x0002,   /* U+3414 */
  0x0002,   /* U+3415 */
  0x0002,   /* U+3416 */
  0x0002,   /* U+3417 */
  0x0002,   /* U+3418 */
  0x0002,   /* U+3419 */
  0x0002,   /* U+341A */
  0x0002,   /* U+341B */
  0x0002,   /* U+341C */
  0x0002,   /* U+341D */
  0x0002,   /* U+341E */
  0x0002,   /* U+341F */
  0x0002,   /* U+3420 */
  0x0002,   /* U+3421 */
  0x0002,   /* U+3422 */
  0x0002,   /* U+3423 */
  0x0002,   /* U+3424 */
  0x0002,   /* U+3425 */
  0x0002,   /* U+3426 */
  0x0002,   /* U+3427 */
  0x0002,   /* U+3428 */
  0x0002,   /* U+3429 */
  0x0002,   /* U+342A */
  0x0002,   /* U+342B */
  0x0002,   /* U+342C */
  0x0002,   /* U+342D */
  0x0002,   /* U+342E */
  0x0002,   /* U+342F */
  0x0002,   /* U+3430 */
  0x0002,   /* U+3431 */
  0x0002,   /* U+3432 */
  0x0002,   /* U+3433 */
  0x0002,   /* U+3434 */
  0x0002,   /* U+3435 */
  0x0002,   /* U+3436 */
  0x0002,   /* U+3437 */
  0x0002,   /* U+3438 */
  0x0002,   /* U+3439 */
  0x0002,   /* U+343A */
  0x0002,   /* U+343B */
  0x0002,   /* U+343C */
  0x0002,   /* U+343D */
  0x0002,   /* U+343E */
  0x0002,   /* U+343F */
  0x0002,   /* U+3440 */
  0x0002,   /* U+3441 */
  0x0002,   /* U+3442 */
  0x0002,   /* U+3443 */
  0x0002,   /* U+3444 */
  0x0002,   /* U+3445 */
  0x0002,   /* U+3446 */
  0x0002,   /* U+3447 */
  0x0002,   /* U+3448 */
  0x0002,   /* U+3449 */
  0x0002,   /* U+344A */
  0x0002,   /* U+344B */
  0x0002,   /* U+344C */
  0x0002,   /* U+344D */
  0x0002,   /* U+344E */
  0x0002,   /* U+344F */
  0x0002,   /* U+3450 */
  0x0002,   /* U+3451 */
  0x0002,   /* U+3452 */
  0x0002,   /* U+3453 */
  0x0002,   /* U+3454 */
  0x0002,   /* U+3455 */
  0x0002,   /* U+3456 */
  0x0002,   /* U+3457 */
  0x0002,   /* U+3458 */
  0x0002,   /* U+3459 */
  0x0002,   /* U+345A */
  0x0002,   /* U+345B */
  0x0002,   /* U+345C */
  0x0002,   /* U+345D */
  0x0002,   /* U+345E */
  0x0002,   /* U+345F */
  0x0002,   /* U+3460 */
  0x0002,   /* U+3461 */
  0x0002,   /* U+3462 */
  0x0002,   /* U+3463 */
  0x0002,   /* U+3464 */
  0x0002,   /* U+3465 */
  0x0002,   /* U+3466 */
  0x0002,   /* U+3467 */
  0x0002,   /* U+3468 */
  0x0002,   /* U+3469 */
  0x0002,   /* U+346A */
  0x0002,   /* U+346B */
  0x0002,   /* U+346C */
  0x0002,   /* U+346D */
  0x0002,   /* U+346E */
  0x0002,   /* U+346F */
  0x0002,   /* U+3470 */
  0x0002,   /* U+3471 */
  0x0002,   /* U+3472 */
  0x0002,   /* U+3473 */
  0x0002,   /* U+3474 */
  0x0002,   /* U+3475 */
  0x0002,   /* U+3476 */
  0x0002,   /* U+3477 */
  0x0002,   /* U+3478 */
  0x0002,   /* U+3479 */
  0x0002,   /* U+347A */
  0x0002,   /* U+347B */
  0x0002,   /* U+347C */
  0x0002,   /* U+347D */
  0x0002,   /* U+347E */
  0x0002,   /* U+347F */
  0x0002,   /* U+3480 */
  0x0002,   /* U+3481 */
  0x0002,   /* U+3482 */
  0x0002,   /* U+3483 */
  0x0002,   /* U+3484 */
  0x0002,   /* U+3485 */
  0x0002,   /* U+3486 */
  0x0002,   /* U+3487 */
  0x0002,   /* U+3488 */
  0x0002,   /* U+3489 */
  0x0002,   /* U+348A */
  0x0002,   /* U+348B */
  0x0002,   /* U+348C */
  0x0002,   /* U+348D */
  0x0002,   /* U+348E */
  0x0002,   /* U+348F */
  0x0002,   /* U+3490 */
  0x0002,   /* U+3491 */
  0x0002,   /* U+3492 */
  0x0002,   /* U+3493 */
  0x0002,   /* U+3494 */
  0x0002,   /* U+3495 */
  0x0002,   /* U+3496 */
  0x0002,   /* U+3497 */
  0x0002,   /* U+3498 */
  0x0002,   /* U+3499 */
  0x0002,   /* U+349A */
  0x0002,   /* U+349B */
  0x0002,   /* U+349C */
  0x0002,   /* U+349D */
  0x0002,   /* U+349E */
  0x0002,   /* U+349F */
  0x0002,   /* U+34A0 */
  0x0002,   /* U+34A1 */
  0x0002,   /* U+34A2 */
  0x0002,   /* U+34A3 */
  0x0002,   /* U+34A4 */
  0x0002,   /* U+34A5 */
  0x0002,   /* U+34A6 */
  0x0002,   /* U+34A7 */
  0x0002,   /* U+34A8 */
  0x0002,   /* U+34A9 */
  0x0002,   /* U+34AA */
  0x0002,   /* U+34AB */
  0x0002,   /* U+34AC */
  0x0002,   /* U+34AD */
  0x0002,   /* U+34AE */
  0x0002,   /* U+34AF */
  0x0002,   /* U+34B0 */
  0x0002,   /* U+34B1 */
  0x0002,   /* U+34B2 */
  0x0002,   /* U+34B3 */
  0x0002,   /* U+34B4 */
  0x0002,   /* U+34B5 */
  0x0002,   /* U+34B6 */
  0x0002,   /* U+34B7 */
  0x0002,   /* U+34B8 */
  0x0002,   /* U+34B9 */
  0x0002,   /* U+34BA */
  0x0002,   /* U+34BB */
  0x0002,   /* U+34BC */
  0x0002,   /* U+34BD */
  0x0002,   /* U+34BE */
  0x0002,   /* U+34BF */
  0x0002,   /* U+34C0 */
  0x0002,   /* U+34C1 */
  0x0002,   /* U+34C2 */
  0x0002,   /* U+34C3 */
  0x0002,   /* U+34C4 */
  0x0002,   /* U+34C5 */
  0x0002,   /* U+34C6 */
  0x0002,   /* U+34C7 */
  0x0002,   /* U+34C8 */
  0x0002,   /* U+34C9 */
  0x0002,   /* U+34CA */
  0x0002,   /* U+34CB */
  0x0002,   /* U+34CC */
  0x0002,   /* U+34CD */
  0x0002,   /* U+34CE */
  0x0002,   /* U+34CF */
  0x0002,   /* U+34D0 */
  0x0002,   /* U+34D1 */
  0x0002,   /* U+34D2 */
  0x0002,   /* U+34D3 */
  0x0002,   /* U+34D4 */
  0x0002,   /* U+34D5 */
  0x0002,   /* U+34D6 */
  0x0002,   /* U+34D7 */
  0x0002,   /* U+34D8 */
  0x0002,   /* U+34D9 */
  0x0002,   /* U+34DA */
  0x0002,   /* U+34DB */
  0x0002,   /* U+34DC */
  0x0002,   /* U+34DD */
  0x0002,   /* U+34DE */
  0x0002,   /* U+34DF */
  0x0002,   /* U+34E0 */
  0x0002,   /* U+34E1 */
  0x0002,   /* U+34E2 */
  0x0002,   /* U+34E3 */
  0x0002,   /* U+34E4 */
  0x0002,   /* U+34E5 */
  0x0002,   /* U+34E6 */
  0x0002,   /* U+34E7 */
  0x0002,   /* U+34E8 */
  0x0002,   /* U+34E9 */
  0x0002,   /* U+34EA */
  0x0002,   /* U+34EB */
  0x0002,   /* U+34EC */
  0x0002,   /* U+34ED */
  0x0002,   /* U+34EE */
  0x0002,   /* U+34EF */
  0x0002,   /* U+34F0 */
  0x0002,   /* U+34F1 */
  0x0002,   /* U+34F2 */
  0x0002,   /* U+34F3 */
  0x0002,   /* U+34F4 */
  0x0002,   /* U+34F5 */
  0x0002,   /* U+34F6 */
  0x0002,   /* U+34F7 */
  0x0002,   /* U+34F8 */
  0x0002,   /* U+34F9 */
  0x0002,   /* U+34FA */
  0x0002,   /* U+34FB */
  0x0002,   /* U+34FC */
  0x0002,   /* U+34FD */
  0x0002,   /* U+34FE */
  0x0002,   /* U+34FF */

  /* Primary weight 2 for each character. */
  0x800A,   /* U+3400 */
  0x8005,   /* U+3401 */
  0x8006,   /* U+3402 */
  0x801A,   /* U+3403 */
  0x801B,   /* U+3404 */
  0x8013,   /* U+3405 */
  0x8025,   /* U+3406 */
  0x8033,   /* U+3407 */
  0x8034,   /* U+3408 */
  0x8035,   /* U+3409 */
  0x8030,   /* U+340A */
  0x8031,   /* U+340B */
  0x8040,   /* U+340C */
  0x8041,   /* U+340D */
  0x8042,   /* U+340E */
  0x8043,   /* U+340F */
  0x803E,   /* U+3410 */
  0x803F,   /* U+3411 */
  0x8040,   /* U+3412 */
  0x8041,   /* U+3413 */
  0x8042,   /* U+3414 */
  0x8043,   /* U+3415 */
  0x8028,   /* U+3416 */
  0x8029,   /* U+3417 */
  0x802A,   /* U+3418 */
  0x802C,   /* U+3419 */
  0x802D,   /* U+341A */
  0x802E,   /* U+341B */
  0x8025,   /* U+341C */
  0x8026,   /* U+341D */
  0x8027,   /* U+341E */
  0x8028,   /* U+341F */
  0x8029,   /* U+3420 */
  0x8019,   /* U+3421 */
  0x801A,   /* U+3422 */
  0x801B,   /* U+3423 */
  0x8017,   /* U+3424 */
  0x8002,   /* U+3425 */
  0x8001,   /* U+3426 */
  0x8042,   /* U+3427 */
  0x803B,   /* U+3428 */
  0x8042,   /* U+3429 */
  0x806B,   /* U+342A */
  0x806C,   /* U+342B */
  0x8048,   /* U+342C */
  0x804C,   /* U+342D */
  0x8025,   /* U+342E */
  0x8005,   /* U+342F */
  0x8072,   /* U+3430 */
  0x8073,   /* U+3431 */
  0x8074,   /* U+3432 */
  0x8075,   /* U+3433 */
  0x8076,   /* U+3434 */
  0x8077,   /* U+3435 */
  0x8078,   /* U+3436 */
  0x8079,   /* U+3437 */
  0x80B5,   /* U+3438 */
  0x80B6,   /* U+3439 */
  0x80B7,   /* U+343A */
  0x80B8,   /* U+343B */
  0x80B9,   /* U+343C */
  0x80BA,   /* U+343D */
  0x80BB,   /* U+343E */
  0x80BC,   /* U+343F */
  0x80BD,   /* U+3440 */
  0x808C,   /* U+3441 */
  0x808D,   /* U+3442 */
  0x808E,   /* U+3443 */
  0x808F,   /* U+3444 */
  0x8090,   /* U+3445 */
  0x8091,   /* U+3446 */
  0x8092,   /* U+3447 */
  0x8093,   /* U+3448 */
  0x809D,   /* U+3449 */
  0x809E,   /* U+344A */
  0x809F,   /* U+344B */
  0x80A0,   /* U+344C */
  0x80A1,   /* U+344D */
  0x80A2,   /* U+344E */
  0x80A3,   /* U+344F */
  0x80A4,   /* U+3450 */
  0x80A5,   /* U+3451 */
  0x80A6,   /* U+3452 */
  0x80A7,   /* U+3453 */
  0x80A8,   /* U+3454 */
  0x80A9,   /* U+3455 */
  0x80AA,   /* U+3456 */
  0x8090,   /* U+3457 */
  0x8091,   /* U+3458 */
  0x8092,   /* U+3459 */
  0x8093,   /* U+345A */
  0x8094,   /* U+345B */
  0x8095,   /* U+345C */
  0x8096,   /* U+345D */
  0x8097,   /* U+345E */
  0x8098,   /* U+345F */
  0x8099,   /* U+3460 */
  0x809A,   /* U+3461 */
  0x809B,   /* U+3462 */
  0x809E,   /* U+3463 */
  0x807D,   /* U+3464 */
  0x809F,   /* U+3465 */
  0x80A0,   /* U+3466 */
  0x80A1,   /* U+3467 */
  0x80A2,   /* U+3468 */
  0x80A3,   /* U+3469 */
  0x80A4,   /* U+346A */
  0x80A5,   /* U+346B */
  0x80A6,   /* U+346C */
  0x80A7,   /* U+346D */
  0x807E,   /* U+346E */
  0x807F,   /* U+346F */
  0x8080,   /* U+3470 */
  0x8081,   /* U+3471 */
  0x8082,   /* U+3472 */
  0x8061,   /* U+3473 */
  0x8062,   /* U+3474 */
  0x8063,   /* U+3475 */
  0x8064,   /* U+3476 */
  0x8065,   /* U+3477 */
  0x8066,   /* U+3478 */
  0x8067,   /* U+3479 */
  0x8068,   /* U+347A */
  0x805B,   /* U+347B */
  0x805C,   /* U+347C */
  0x805D,   /* U+347D */
  0x805E,   /* U+347E */
  0x805F,   /* U+347F */
  0x8060,   /* U+3480 */
  0x8061,   /* U+3481 */
  0x8043,   /* U+3482 */
  0x8044,   /* U+3483 */
  0x8045,   /* U+3484 */
  0x8046,   /* U+3485 */
  0x8047,   /* U+3486 */
  0x8048,   /* U+3487 */
  0x8049,   /* U+3488 */
  0x804A,   /* U+3489 */
  0x804B,   /* U+348A */
  0x804C,   /* U+348B */
  0x804D,   /* U+348C */
  0x804E,   /* U+348D */
  0x804F,   /* U+348E */
  0x8050,   /* U+348F */
  0x8051,   /* U+3490 */
  0x8039,   /* U+3491 */
  0x803A,   /* U+3492 */
  0x803B,   /* U+3493 */
  0x803C,   /* U+3494 */
  0x803D,   /* U+3495 */
  0x803E,   /* U+3496 */
  0x803F,   /* U+3497 */
  0x8040,   /* U+3498 */
  0x8029,   /* U+3499 */
  0x802A,   /* U+349A */
  0x802B,   /* U+349B */
  0x802C,   /* U+349C */
  0x8016,   /* U+349D */
  0x8017,   /* U+349E */
  0x800A,   /* U+349F */
  0x800B,   /* U+34A0 */
  0x8009,   /* U+34A1 */
  0x800A,   /* U+34A2 */
  0x800B,   /* U+34A3 */
  0x8006,   /* U+34A4 */
  0x8007,   /* U+34A5 */
  0x8008,   /* U+34A6 */
  0x8007,   /* U+34A7 */
  0x8008,   /* U+34A8 */
  0x8003,   /* U+34A9 */
  0x8000,   /* U+34AA */
  0x80FA,   /* U+34AB */
  0x8104,   /* U+34AC */
  0x8120,   /* U+34AD */
  0x80FC,   /* U+34AE */
  0x803D,   /* U+34AF */
  0x8097,   /* U+34B0 */
  0x8098,   /* U+34B1 */
  0x8101,   /* U+34B2 */
  0x80F7,   /* U+34B3 */
  0x80F8,   /* U+34B4 */
  0x8102,   /* U+34B5 */
  0x8103,   /* U+34B6 */
  0x8104,   /* U+34B7 */
  0x811E,   /* U+34B8 */
  0x801D,   /* U+34B9 */
  0x8127,   /* U+34BA */
  0x8113,   /* U+34BB */
  0x8114,   /* U+34BC */
  0x80F7,   /* U+34BD */
  0x80E1,   /* U+34BE */
  0x8013,   /* U+34BF */
  0x8090,   /* U+34C0 */
  0x8091,   /* U+34C1 */
  0x8134,   /* U+34C2 */
  0x80FE,   /* U+34C3 */
  0x80A2,   /* U+34C4 */
  0x8094,   /* U+34C5 */
  0x812F,   /* U+34C6 */
  0x8130,   /* U+34C7 */
  0x8129,   /* U+34C8 */
  0x813E,   /* U+34C9 */
  0x813F,   /* U+34CA */
  0x8140,   /* U+34CB */
  0x8141,   /* U+34CC */
  0x8142,   /* U+34CD */
  0x8140,   /* U+34CE */
  0x8141,   /* U+34CF */
  0x8167,   /* U+34D0 */
  0x8168,   /* U+34D1 */
  0x8169,   /* U+34D2 */
  0x8121,   /* U+34D3 */
  0x810C,   /* U+34D4 */
  0x810D,   /* U+34D5 */
  0x80EA,   /* U+34D6 */
  0x80E7,   /* U+34D7 */
  0x813D,   /* U+34D8 */
  0x8153,   /* U+34D9 */
  0x80D6,   /* U+34DA */
  0x80D7,   /* U+34DB */
  0x80D8,   /* U+34DC */
  0x816A,   /* U+34DD */
  0x816B,   /* U+34DE */
  0x8166,   /* U+34DF */
  0x8167,   /* U+34E0 */
  0x817F,   /* U+34E1 */
  0x8180,   /* U+34E2 */
  0x8181,   /* U+34E3 */
  0x8182,   /* U+34E4 */
  0x8183,   /* U+34E5 */
  0x8184,   /* U+34E6 */
  0x8173,   /* U+34E7 */
  0x8174,   /* U+34E8 */
  0x8175,   /* U+34E9 */
  0x8176,   /* U+34EA */
  0x8177,   /* U+34EB */
  0x81AB,   /* U+34EC */
  0x81AC,   /* U+34ED */
  0x81AD,   /* U+34EE */
  0x81AE,   /* U+34EF */
  0x81AF,   /* U+34F0 */
  0x8159,   /* U+34F1 */
  0x815A,   /* U+34F2 */
  0x815B,   /* U+34F3 */
  0x815C,   /* U+34F4 */
  0x815D,   /* U+34F5 */
  0x815E,   /* U+34F6 */
  0x8137,   /* U+34F7 */
  0x8138,   /* U+34F8 */
  0x8139,   /* U+34F9 */
  0x813A,   /* U+34FA */
  0x813B,   /* U+34FB */
  0x8115,   /* U+34FC */
  0x8116,   /* U+34FD */
  0x8108,   /* U+34FE */
  0x8109,   /* U+34FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3400 */
  0x0000,   /* U+3401 */
  0x0000,   /* U+3402 */
  0x0000,   /* U+3403 */
  0x0000,   /* U+3404 */
  0x0000,   /* U+3405 */
  0x0000,   /* U+3406 */
  0x0000,   /* U+3407 */
  0x0000,   /* U+3408 */
  0x0000,   /* U+3409 */
  0x0000,   /* U+340A */
  0x0000,   /* U+340B */
  0x0000,   /* U+340C */
  0x0000,   /* U+340D */
  0x0000,   /* U+340E */
  0x0000,   /* U+340F */
  0x0000,   /* U+3410 */
  0x0000,   /* U+3411 */
  0x0000,   /* U+3412 */
  0x0000,   /* U+3413 */
  0x0000,   /* U+3414 */
  0x0000,   /* U+3415 */
  0x0000,   /* U+3416 */
  0x0000,   /* U+3417 */
  0x0000,   /* U+3418 */
  0x0000,   /* U+3419 */
  0x0000,   /* U+341A */
  0x0000,   /* U+341B */
  0x0000,   /* U+341C */
  0x0000,   /* U+341D */
  0x0000,   /* U+341E */
  0x0000,   /* U+341F */
  0x0000,   /* U+3420 */
  0x0000,   /* U+3421 */
  0x0000,   /* U+3422 */
  0x0000,   /* U+3423 */
  0x0000,   /* U+3424 */
  0x0000,   /* U+3425 */
  0x0000,   /* U+3426 */
  0x0000,   /* U+3427 */
  0x0000,   /* U+3428 */
  0x0000,   /* U+3429 */
  0x0000,   /* U+342A */
  0x0000,   /* U+342B */
  0x0000,   /* U+342C */
  0x0000,   /* U+342D */
  0x0000,   /* U+342E */
  0x0000,   /* U+342F */
  0x0000,   /* U+3430 */
  0x0000,   /* U+3431 */
  0x0000,   /* U+3432 */
  0x0000,   /* U+3433 */
  0x0000,   /* U+3434 */
  0x0000,   /* U+3435 */
  0x0000,   /* U+3436 */
  0x0000,   /* U+3437 */
  0x0000,   /* U+3438 */
  0x0000,   /* U+3439 */
  0x0000,   /* U+343A */
  0x0000,   /* U+343B */
  0x0000,   /* U+343C */
  0x0000,   /* U+343D */
  0x0000,   /* U+343E */
  0x0000,   /* U+343F */
  0x0000,   /* U+3440 */
  0x0000,   /* U+3441 */
  0x0000,   /* U+3442 */
  0x0000,   /* U+3443 */
  0x0000,   /* U+3444 */
  0x0000,   /* U+3445 */
  0x0000,   /* U+3446 */
  0x0000,   /* U+3447 */
  0x0000,   /* U+3448 */
  0x0000,   /* U+3449 */
  0x0000,   /* U+344A */
  0x0000,   /* U+344B */
  0x0000,   /* U+344C */
  0x0000,   /* U+344D */
  0x0000,   /* U+344E */
  0x0000,   /* U+344F */
  0x0000,   /* U+3450 */
  0x0000,   /* U+3451 */
  0x0000,   /* U+3452 */
  0x0000,   /* U+3453 */
  0x0000,   /* U+3454 */
  0x0000,   /* U+3455 */
  0x0000,   /* U+3456 */
  0x0000,   /* U+3457 */
  0x0000,   /* U+3458 */
  0x0000,   /* U+3459 */
  0x0000,   /* U+345A */
  0x0000,   /* U+345B */
  0x0000,   /* U+345C */
  0x0000,   /* U+345D */
  0x0000,   /* U+345E */
  0x0000,   /* U+345F */
  0x0000,   /* U+3460 */
  0x0000,   /* U+3461 */
  0x0000,   /* U+3462 */
  0x0000,   /* U+3463 */
  0x0000,   /* U+3464 */
  0x0000,   /* U+3465 */
  0x0000,   /* U+3466 */
  0x0000,   /* U+3467 */
  0x0000,   /* U+3468 */
  0x0000,   /* U+3469 */
  0x0000,   /* U+346A */
  0x0000,   /* U+346B */
  0x0000,   /* U+346C */
  0x0000,   /* U+346D */
  0x0000,   /* U+346E */
  0x0000,   /* U+346F */
  0x0000,   /* U+3470 */
  0x0000,   /* U+3471 */
  0x0000,   /* U+3472 */
  0x0000,   /* U+3473 */
  0x0000,   /* U+3474 */
  0x0000,   /* U+3475 */
  0x0000,   /* U+3476 */
  0x0000,   /* U+3477 */
  0x0000,   /* U+3478 */
  0x0000,   /* U+3479 */
  0x0000,   /* U+347A */
  0x0000,   /* U+347B */
  0x0000,   /* U+347C */
  0x0000,   /* U+347D */
  0x0000,   /* U+347E */
  0x0000,   /* U+347F */
  0x0000,   /* U+3480 */
  0x0000,   /* U+3481 */
  0x0000,   /* U+3482 */
  0x0000,   /* U+3483 */
  0x0000,   /* U+3484 */
  0x0000,   /* U+3485 */
  0x0000,   /* U+3486 */
  0x0000,   /* U+3487 */
  0x0000,   /* U+3488 */
  0x0000,   /* U+3489 */
  0x0000,   /* U+348A */
  0x0000,   /* U+348B */
  0x0000,   /* U+348C */
  0x0000,   /* U+348D */
  0x0000,   /* U+348E */
  0x0000,   /* U+348F */
  0x0000,   /* U+3490 */
  0x0000,   /* U+3491 */
  0x0000,   /* U+3492 */
  0x0000,   /* U+3493 */
  0x0000,   /* U+3494 */
  0x0000,   /* U+3495 */
  0x0000,   /* U+3496 */
  0x0000,   /* U+3497 */
  0x0000,   /* U+3498 */
  0x0000,   /* U+3499 */
  0x0000,   /* U+349A */
  0x0000,   /* U+349B */
  0x0000,   /* U+349C */
  0x0000,   /* U+349D */
  0x0000,   /* U+349E */
  0x0000,   /* U+349F */
  0x0000,   /* U+34A0 */
  0x0000,   /* U+34A1 */
  0x0000,   /* U+34A2 */
  0x0000,   /* U+34A3 */
  0x0000,   /* U+34A4 */
  0x0000,   /* U+34A5 */
  0x0000,   /* U+34A6 */
  0x0000,   /* U+34A7 */
  0x0000,   /* U+34A8 */
  0x0000,   /* U+34A9 */
  0x0000,   /* U+34AA */
  0x0000,   /* U+34AB */
  0x0000,   /* U+34AC */
  0x0000,   /* U+34AD */
  0x0000,   /* U+34AE */
  0x0000,   /* U+34AF */
  0x0000,   /* U+34B0 */
  0x0000,   /* U+34B1 */
  0x0000,   /* U+34B2 */
  0x0000,   /* U+34B3 */
  0x0000,   /* U+34B4 */
  0x0000,   /* U+34B5 */
  0x0000,   /* U+34B6 */
  0x0000,   /* U+34B7 */
  0x0000,   /* U+34B8 */
  0x0000,   /* U+34B9 */
  0x0000,   /* U+34BA */
  0x0000,   /* U+34BB */
  0x0000,   /* U+34BC */
  0x0000,   /* U+34BD */
  0x0000,   /* U+34BE */
  0x0000,   /* U+34BF */
  0x0000,   /* U+34C0 */
  0x0000,   /* U+34C1 */
  0x0000,   /* U+34C2 */
  0x0000,   /* U+34C3 */
  0x0000,   /* U+34C4 */
  0x0000,   /* U+34C5 */
  0x0000,   /* U+34C6 */
  0x0000,   /* U+34C7 */
  0x0000,   /* U+34C8 */
  0x0000,   /* U+34C9 */
  0x0000,   /* U+34CA */
  0x0000,   /* U+34CB */
  0x0000,   /* U+34CC */
  0x0000,   /* U+34CD */
  0x0000,   /* U+34CE */
  0x0000,   /* U+34CF */
  0x0000,   /* U+34D0 */
  0x0000,   /* U+34D1 */
  0x0000,   /* U+34D2 */
  0x0000,   /* U+34D3 */
  0x0000,   /* U+34D4 */
  0x0000,   /* U+34D5 */
  0x0000,   /* U+34D6 */
  0x0000,   /* U+34D7 */
  0x0000,   /* U+34D8 */
  0x0000,   /* U+34D9 */
  0x0000,   /* U+34DA */
  0x0000,   /* U+34DB */
  0x0000,   /* U+34DC */
  0x0000,   /* U+34DD */
  0x0000,   /* U+34DE */
  0x0000,   /* U+34DF */
  0x0000,   /* U+34E0 */
  0x0000,   /* U+34E1 */
  0x0000,   /* U+34E2 */
  0x0000,   /* U+34E3 */
  0x0000,   /* U+34E4 */
  0x0000,   /* U+34E5 */
  0x0000,   /* U+34E6 */
  0x0000,   /* U+34E7 */
  0x0000,   /* U+34E8 */
  0x0000,   /* U+34E9 */
  0x0000,   /* U+34EA */
  0x0000,   /* U+34EB */
  0x0000,   /* U+34EC */
  0x0000,   /* U+34ED */
  0x0000,   /* U+34EE */
  0x0000,   /* U+34EF */
  0x0000,   /* U+34F0 */
  0x0000,   /* U+34F1 */
  0x0000,   /* U+34F2 */
  0x0000,   /* U+34F3 */
  0x0000,   /* U+34F4 */
  0x0000,   /* U+34F5 */
  0x0000,   /* U+34F6 */
  0x0000,   /* U+34F7 */
  0x0000,   /* U+34F8 */
  0x0000,   /* U+34F9 */
  0x0000,   /* U+34FA */
  0x0000,   /* U+34FB */
  0x0000,   /* U+34FC */
  0x0000,   /* U+34FD */
  0x0000,   /* U+34FE */
  0x0000,   /* U+34FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3400 */
  0x0000,   /* U+3401 */
  0x0000,   /* U+3402 */
  0x0000,   /* U+3403 */
  0x0000,   /* U+3404 */
  0x0000,   /* U+3405 */
  0x0000,   /* U+3406 */
  0x0000,   /* U+3407 */
  0x0000,   /* U+3408 */
  0x0000,   /* U+3409 */
  0x0000,   /* U+340A */
  0x0000,   /* U+340B */
  0x0000,   /* U+340C */
  0x0000,   /* U+340D */
  0x0000,   /* U+340E */
  0x0000,   /* U+340F */
  0x0000,   /* U+3410 */
  0x0000,   /* U+3411 */
  0x0000,   /* U+3412 */
  0x0000,   /* U+3413 */
  0x0000,   /* U+3414 */
  0x0000,   /* U+3415 */
  0x0000,   /* U+3416 */
  0x0000,   /* U+3417 */
  0x0000,   /* U+3418 */
  0x0000,   /* U+3419 */
  0x0000,   /* U+341A */
  0x0000,   /* U+341B */
  0x0000,   /* U+341C */
  0x0000,   /* U+341D */
  0x0000,   /* U+341E */
  0x0000,   /* U+341F */
  0x0000,   /* U+3420 */
  0x0000,   /* U+3421 */
  0x0000,   /* U+3422 */
  0x0000,   /* U+3423 */
  0x0000,   /* U+3424 */
  0x0000,   /* U+3425 */
  0x0000,   /* U+3426 */
  0x0000,   /* U+3427 */
  0x0000,   /* U+3428 */
  0x0000,   /* U+3429 */
  0x0000,   /* U+342A */
  0x0000,   /* U+342B */
  0x0000,   /* U+342C */
  0x0000,   /* U+342D */
  0x0000,   /* U+342E */
  0x0000,   /* U+342F */
  0x0000,   /* U+3430 */
  0x0000,   /* U+3431 */
  0x0000,   /* U+3432 */
  0x0000,   /* U+3433 */
  0x0000,   /* U+3434 */
  0x0000,   /* U+3435 */
  0x0000,   /* U+3436 */
  0x0000,   /* U+3437 */
  0x0000,   /* U+3438 */
  0x0000,   /* U+3439 */
  0x0000,   /* U+343A */
  0x0000,   /* U+343B */
  0x0000,   /* U+343C */
  0x0000,   /* U+343D */
  0x0000,   /* U+343E */
  0x0000,   /* U+343F */
  0x0000,   /* U+3440 */
  0x0000,   /* U+3441 */
  0x0000,   /* U+3442 */
  0x0000,   /* U+3443 */
  0x0000,   /* U+3444 */
  0x0000,   /* U+3445 */
  0x0000,   /* U+3446 */
  0x0000,   /* U+3447 */
  0x0000,   /* U+3448 */
  0x0000,   /* U+3449 */
  0x0000,   /* U+344A */
  0x0000,   /* U+344B */
  0x0000,   /* U+344C */
  0x0000,   /* U+344D */
  0x0000,   /* U+344E */
  0x0000,   /* U+344F */
  0x0000,   /* U+3450 */
  0x0000,   /* U+3451 */
  0x0000,   /* U+3452 */
  0x0000,   /* U+3453 */
  0x0000,   /* U+3454 */
  0x0000,   /* U+3455 */
  0x0000,   /* U+3456 */
  0x0000,   /* U+3457 */
  0x0000,   /* U+3458 */
  0x0000,   /* U+3459 */
  0x0000,   /* U+345A */
  0x0000,   /* U+345B */
  0x0000,   /* U+345C */
  0x0000,   /* U+345D */
  0x0000,   /* U+345E */
  0x0000,   /* U+345F */
  0x0000,   /* U+3460 */
  0x0000,   /* U+3461 */
  0x0000,   /* U+3462 */
  0x0000,   /* U+3463 */
  0x0000,   /* U+3464 */
  0x0000,   /* U+3465 */
  0x0000,   /* U+3466 */
  0x0000,   /* U+3467 */
  0x0000,   /* U+3468 */
  0x0000,   /* U+3469 */
  0x0000,   /* U+346A */
  0x0000,   /* U+346B */
  0x0000,   /* U+346C */
  0x0000,   /* U+346D */
  0x0000,   /* U+346E */
  0x0000,   /* U+346F */
  0x0000,   /* U+3470 */
  0x0000,   /* U+3471 */
  0x0000,   /* U+3472 */
  0x0000,   /* U+3473 */
  0x0000,   /* U+3474 */
  0x0000,   /* U+3475 */
  0x0000,   /* U+3476 */
  0x0000,   /* U+3477 */
  0x0000,   /* U+3478 */
  0x0000,   /* U+3479 */
  0x0000,   /* U+347A */
  0x0000,   /* U+347B */
  0x0000,   /* U+347C */
  0x0000,   /* U+347D */
  0x0000,   /* U+347E */
  0x0000,   /* U+347F */
  0x0000,   /* U+3480 */
  0x0000,   /* U+3481 */
  0x0000,   /* U+3482 */
  0x0000,   /* U+3483 */
  0x0000,   /* U+3484 */
  0x0000,   /* U+3485 */
  0x0000,   /* U+3486 */
  0x0000,   /* U+3487 */
  0x0000,   /* U+3488 */
  0x0000,   /* U+3489 */
  0x0000,   /* U+348A */
  0x0000,   /* U+348B */
  0x0000,   /* U+348C */
  0x0000,   /* U+348D */
  0x0000,   /* U+348E */
  0x0000,   /* U+348F */
  0x0000,   /* U+3490 */
  0x0000,   /* U+3491 */
  0x0000,   /* U+3492 */
  0x0000,   /* U+3493 */
  0x0000,   /* U+3494 */
  0x0000,   /* U+3495 */
  0x0000,   /* U+3496 */
  0x0000,   /* U+3497 */
  0x0000,   /* U+3498 */
  0x0000,   /* U+3499 */
  0x0000,   /* U+349A */
  0x0000,   /* U+349B */
  0x0000,   /* U+349C */
  0x0000,   /* U+349D */
  0x0000,   /* U+349E */
  0x0000,   /* U+349F */
  0x0000,   /* U+34A0 */
  0x0000,   /* U+34A1 */
  0x0000,   /* U+34A2 */
  0x0000,   /* U+34A3 */
  0x0000,   /* U+34A4 */
  0x0000,   /* U+34A5 */
  0x0000,   /* U+34A6 */
  0x0000,   /* U+34A7 */
  0x0000,   /* U+34A8 */
  0x0000,   /* U+34A9 */
  0x0000,   /* U+34AA */
  0x0000,   /* U+34AB */
  0x0000,   /* U+34AC */
  0x0000,   /* U+34AD */
  0x0000,   /* U+34AE */
  0x0000,   /* U+34AF */
  0x0000,   /* U+34B0 */
  0x0000,   /* U+34B1 */
  0x0000,   /* U+34B2 */
  0x0000,   /* U+34B3 */
  0x0000,   /* U+34B4 */
  0x0000,   /* U+34B5 */
  0x0000,   /* U+34B6 */
  0x0000,   /* U+34B7 */
  0x0000,   /* U+34B8 */
  0x0000,   /* U+34B9 */
  0x0000,   /* U+34BA */
  0x0000,   /* U+34BB */
  0x0000,   /* U+34BC */
  0x0000,   /* U+34BD */
  0x0000,   /* U+34BE */
  0x0000,   /* U+34BF */
  0x0000,   /* U+34C0 */
  0x0000,   /* U+34C1 */
  0x0000,   /* U+34C2 */
  0x0000,   /* U+34C3 */
  0x0000,   /* U+34C4 */
  0x0000,   /* U+34C5 */
  0x0000,   /* U+34C6 */
  0x0000,   /* U+34C7 */
  0x0000,   /* U+34C8 */
  0x0000,   /* U+34C9 */
  0x0000,   /* U+34CA */
  0x0000,   /* U+34CB */
  0x0000,   /* U+34CC */
  0x0000,   /* U+34CD */
  0x0000,   /* U+34CE */
  0x0000,   /* U+34CF */
  0x0000,   /* U+34D0 */
  0x0000,   /* U+34D1 */
  0x0000,   /* U+34D2 */
  0x0000,   /* U+34D3 */
  0x0000,   /* U+34D4 */
  0x0000,   /* U+34D5 */
  0x0000,   /* U+34D6 */
  0x0000,   /* U+34D7 */
  0x0000,   /* U+34D8 */
  0x0000,   /* U+34D9 */
  0x0000,   /* U+34DA */
  0x0000,   /* U+34DB */
  0x0000,   /* U+34DC */
  0x0000,   /* U+34DD */
  0x0000,   /* U+34DE */
  0x0000,   /* U+34DF */
  0x0000,   /* U+34E0 */
  0x0000,   /* U+34E1 */
  0x0000,   /* U+34E2 */
  0x0000,   /* U+34E3 */
  0x0000,   /* U+34E4 */
  0x0000,   /* U+34E5 */
  0x0000,   /* U+34E6 */
  0x0000,   /* U+34E7 */
  0x0000,   /* U+34E8 */
  0x0000,   /* U+34E9 */
  0x0000,   /* U+34EA */
  0x0000,   /* U+34EB */
  0x0000,   /* U+34EC */
  0x0000,   /* U+34ED */
  0x0000,   /* U+34EE */
  0x0000,   /* U+34EF */
  0x0000,   /* U+34F0 */
  0x0000,   /* U+34F1 */
  0x0000,   /* U+34F2 */
  0x0000,   /* U+34F3 */
  0x0000,   /* U+34F4 */
  0x0000,   /* U+34F5 */
  0x0000,   /* U+34F6 */
  0x0000,   /* U+34F7 */
  0x0000,   /* U+34F8 */
  0x0000,   /* U+34F9 */
  0x0000,   /* U+34FA */
  0x0000,   /* U+34FB */
  0x0000,   /* U+34FC */
  0x0000,   /* U+34FD */
  0x0000,   /* U+34FE */
  0x0000,   /* U+34FF */
};

uint16 zh3_han_p035[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C55,   /* U+3500 */
  0x1C55,   /* U+3501 */
  0x1C55,   /* U+3502 */
  0x1C55,   /* U+3503 */
  0x1C55,   /* U+3504 */
  0x1C55,   /* U+3505 */
  0x1C55,   /* U+3506 */
  0x1C55,   /* U+3507 */
  0x1C55,   /* U+3508 */
  0x1C55,   /* U+3509 */
  0x1C56,   /* U+350A */
  0x1C57,   /* U+350B */
  0x1C57,   /* U+350C */
  0x1C57,   /* U+350D */
  0x1C58,   /* U+350E */
  0x1C58,   /* U+350F */
  0x1C59,   /* U+3510 */
  0x1C5A,   /* U+3511 */
  0x1C5B,   /* U+3512 */
  0x1C4C,   /* U+3513 */
  0x1C4D,   /* U+3514 */
  0x1C4D,   /* U+3515 */
  0x1C4D,   /* U+3516 */
  0x1C4E,   /* U+3517 */
  0x1C4E,   /* U+3518 */
  0x1C4F,   /* U+3519 */
  0x1C4F,   /* U+351A */
  0x1C4F,   /* U+351B */
  0x1C50,   /* U+351C */
  0x1C51,   /* U+351D */
  0x1C51,   /* U+351E */
  0x1C51,   /* U+351F */
  0x1C52,   /* U+3520 */
  0x1C53,   /* U+3521 */
  0x1C55,   /* U+3522 */
  0x1C58,   /* U+3523 */
  0x1C58,   /* U+3524 */
  0x1C58,   /* U+3525 */
  0x1C58,   /* U+3526 */
  0x1C59,   /* U+3527 */
  0x1C52,   /* U+3528 */
  0x1C53,   /* U+3529 */
  0x1C54,   /* U+352A */
  0x1C4B,   /* U+352B */
  0x1C4F,   /* U+352C */
  0x1C52,   /* U+352D */
  0x1C5C,   /* U+352E */
  0x1C4E,   /* U+352F */
  0x1C4E,   /* U+3530 */
  0x1C52,   /* U+3531 */
  0x1C54,   /* U+3532 */
  0x1C54,   /* U+3533 */
  0x1C54,   /* U+3534 */
  0x1C55,   /* U+3535 */
  0x1C61,   /* U+3536 */
  0x1C4E,   /* U+3537 */
  0x1C53,   /* U+3538 */
  0x1C4B,   /* U+3539 */
  0x1C4D,   /* U+353A */
  0x1C4D,   /* U+353B */
  0x1C54,   /* U+353C */
  0x1C4F,   /* U+353D */
  0x1C4A,   /* U+353E */
  0x1C4A,   /* U+353F */
  0x1C4E,   /* U+3540 */
  0x1C4F,   /* U+3541 */
  0x1C4D,   /* U+3542 */
  0x1C4D,   /* U+3543 */
  0x1C4D,   /* U+3544 */
  0x1C4E,   /* U+3545 */
  0x1C4E,   /* U+3546 */
  0x1C4E,   /* U+3547 */
  0x1C4F,   /* U+3548 */
  0x1C4F,   /* U+3549 */
  0x1C50,   /* U+354A */
  0x1C51,   /* U+354B */
  0x1C51,   /* U+354C */
  0x1C51,   /* U+354D */
  0x1C53,   /* U+354E */
  0x1C54,   /* U+354F */
  0x1C55,   /* U+3550 */
  0x1C55,   /* U+3551 */
  0x1C56,   /* U+3552 */
  0x1C58,   /* U+3553 */
  0x1C5F,   /* U+3554 */
  0x1C4B,   /* U+3555 */
  0x1C51,   /* U+3556 */
  0x1C52,   /* U+3557 */
  0x1C52,   /* U+3558 */
  0x1C56,   /* U+3559 */
  0x1C4B,   /* U+355A */
  0x1C4B,   /* U+355B */
  0x1C4D,   /* U+355C */
  0x1C4E,   /* U+355D */
  0x1C4F,   /* U+355E */
  0x1C50,   /* U+355F */
  0x1C53,   /* U+3560 */
  0x1C55,   /* U+3561 */
  0x1C55,   /* U+3562 */
  0x1C4C,   /* U+3563 */
  0x1C4C,   /* U+3564 */
  0x1C4C,   /* U+3565 */
  0x1C4D,   /* U+3566 */
  0x1C4D,   /* U+3567 */
  0x1C4D,   /* U+3568 */
  0x1C4E,   /* U+3569 */
  0x1C4E,   /* U+356A */
  0x1C4E,   /* U+356B */
  0x1C4E,   /* U+356C */
  0x1C4E,   /* U+356D */
  0x1C4E,   /* U+356E */
  0x1C4E,   /* U+356F */
  0x1C4E,   /* U+3570 */
  0x1C4E,   /* U+3571 */
  0x1C4E,   /* U+3572 */
  0x1C4E,   /* U+3573 */
  0x1C4E,   /* U+3574 */
  0x1C4E,   /* U+3575 */
  0x1C4E,   /* U+3576 */
  0x1C4F,   /* U+3577 */
  0x1C4F,   /* U+3578 */
  0x1C4F,   /* U+3579 */
  0x1C4F,   /* U+357A */
  0x1C4F,   /* U+357B */
  0x1C4F,   /* U+357C */
  0x1C4F,   /* U+357D */
  0x1C4F,   /* U+357E */
  0x1C4F,   /* U+357F */
  0x1C50,   /* U+3580 */
  0x1C50,   /* U+3581 */
  0x1C50,   /* U+3582 */
  0x1C50,   /* U+3583 */
  0x1C50,   /* U+3584 */
  0x1C50,   /* U+3585 */
  0x1C50,   /* U+3586 */
  0x1C50,   /* U+3587 */
  0x1C50,   /* U+3588 */
  0x1C50,   /* U+3589 */
  0x1C50,   /* U+358A */
  0x1C50,   /* U+358B */
  0x1C50,   /* U+358C */
  0x1C50,   /* U+358D */
  0x1C50,   /* U+358E */
  0x1C51,   /* U+358F */
  0x1C51,   /* U+3590 */
  0x1C51,   /* U+3591 */
  0x1C51,   /* U+3592 */
  0x1C51,   /* U+3593 */
  0x1C51,   /* U+3594 */
  0x1C51,   /* U+3595 */
  0x1C51,   /* U+3596 */
  0x1C51,   /* U+3597 */
  0x1C51,   /* U+3598 */
  0x1C51,   /* U+3599 */
  0x1C51,   /* U+359A */
  0x1C51,   /* U+359B */
  0x1C51,   /* U+359C */
  0x1C51,   /* U+359D */
  0x1C51,   /* U+359E */
  0x1C52,   /* U+359F */
  0x1C52,   /* U+35A0 */
  0x1C52,   /* U+35A1 */
  0x1C52,   /* U+35A2 */
  0x1C52,   /* U+35A3 */
  0x1C52,   /* U+35A4 */
  0x1C52,   /* U+35A5 */
  0x1C52,   /* U+35A6 */
  0x1C52,   /* U+35A7 */
  0x1C52,   /* U+35A8 */
  0x1C52,   /* U+35A9 */
  0x1C52,   /* U+35AA */
  0x1C52,   /* U+35AB */
  0x1C52,   /* U+35AC */
  0x1C52,   /* U+35AD */
  0x1C52,   /* U+35AE */
  0x1C52,   /* U+35AF */
  0x1C52,   /* U+35B0 */
  0x1C52,   /* U+35B1 */
  0x1C52,   /* U+35B2 */
  0x1C52,   /* U+35B3 */
  0x1C52,   /* U+35B4 */
  0x1C52,   /* U+35B5 */
  0x1C53,   /* U+35B6 */
  0x1C53,   /* U+35B7 */
  0x1C53,   /* U+35B8 */
  0x1C53,   /* U+35B9 */
  0x1C53,   /* U+35BA */
  0x1C53,   /* U+35BB */
  0x1C53,   /* U+35BC */
  0x1C53,   /* U+35BD */
  0x1C53,   /* U+35BE */
  0x1C53,   /* U+35BF */
  0x1C53,   /* U+35C0 */
  0x1C53,   /* U+35C1 */
  0x1C53,   /* U+35C2 */
  0x1C53,   /* U+35C3 */
  0x1C53,   /* U+35C4 */
  0x1C53,   /* U+35C5 */
  0x1C53,   /* U+35C6 */
  0x1C53,   /* U+35C7 */
  0x1C53,   /* U+35C8 */
  0x1C53,   /* U+35C9 */
  0x1C53,   /* U+35CA */
  0x1C53,   /* U+35CB */
  0x1C53,   /* U+35CC */
  0x1C53,   /* U+35CD */
  0x1C53,   /* U+35CE */
  0x1C53,   /* U+35CF */
  0x1C53,   /* U+35D0 */
  0x1C53,   /* U+35D1 */
  0x1C54,   /* U+35D2 */
  0x1C54,   /* U+35D3 */
  0x1C54,   /* U+35D4 */
  0x1C54,   /* U+35D5 */
  0x1C54,   /* U+35D6 */
  0x1C54,   /* U+35D7 */
  0x1C54,   /* U+35D8 */
  0x1C54,   /* U+35D9 */
  0x1C54,   /* U+35DA */
  0x1C54,   /* U+35DB */
  0x1C54,   /* U+35DC */
  0x1C54,   /* U+35DD */
  0x1C54,   /* U+35DE */
  0x1C54,   /* U+35DF */
  0x1C54,   /* U+35E0 */
  0x1C54,   /* U+35E1 */
  0x1C55,   /* U+35E2 */
  0x1C55,   /* U+35E3 */
  0x1C55,   /* U+35E4 */
  0x1C55,   /* U+35E5 */
  0x1C55,   /* U+35E6 */
  0x1C55,   /* U+35E7 */
  0x1C55,   /* U+35E8 */
  0x1C55,   /* U+35E9 */
  0x1C55,   /* U+35EA */
  0x1C55,   /* U+35EB */
  0x1C55,   /* U+35EC */
  0x1C55,   /* U+35ED */
  0x1C55,   /* U+35EE */
  0x1C55,   /* U+35EF */
  0x1C55,   /* U+35F0 */
  0x1C56,   /* U+35F1 */
  0x1C56,   /* U+35F2 */
  0x1C56,   /* U+35F3 */
  0x1C56,   /* U+35F4 */
  0x1C56,   /* U+35F5 */
  0x1C56,   /* U+35F6 */
  0x1C56,   /* U+35F7 */
  0x1C56,   /* U+35F8 */
  0x1C56,   /* U+35F9 */
  0x1C56,   /* U+35FA */
  0x1C57,   /* U+35FB */
  0x1C57,   /* U+35FC */
  0x1C57,   /* U+35FD */
  0x1C57,   /* U+35FE */
  0x1C57,   /* U+35FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3500 */
  0x0020,   /* U+3501 */
  0x0020,   /* U+3502 */
  0x0020,   /* U+3503 */
  0x0020,   /* U+3504 */
  0x0020,   /* U+3505 */
  0x0020,   /* U+3506 */
  0x0020,   /* U+3507 */
  0x0020,   /* U+3508 */
  0x0020,   /* U+3509 */
  0x0020,   /* U+350A */
  0x0020,   /* U+350B */
  0x0020,   /* U+350C */
  0x0020,   /* U+350D */
  0x0020,   /* U+350E */
  0x0020,   /* U+350F */
  0x0020,   /* U+3510 */
  0x0020,   /* U+3511 */
  0x0020,   /* U+3512 */
  0x0020,   /* U+3513 */
  0x0020,   /* U+3514 */
  0x0020,   /* U+3515 */
  0x0020,   /* U+3516 */
  0x0020,   /* U+3517 */
  0x0020,   /* U+3518 */
  0x0020,   /* U+3519 */
  0x0020,   /* U+351A */
  0x0020,   /* U+351B */
  0x0020,   /* U+351C */
  0x0020,   /* U+351D */
  0x0020,   /* U+351E */
  0x0020,   /* U+351F */
  0x0020,   /* U+3520 */
  0x0020,   /* U+3521 */
  0x0020,   /* U+3522 */
  0x0020,   /* U+3523 */
  0x0020,   /* U+3524 */
  0x0020,   /* U+3525 */
  0x0020,   /* U+3526 */
  0x0020,   /* U+3527 */
  0x0020,   /* U+3528 */
  0x0020,   /* U+3529 */
  0x0020,   /* U+352A */
  0x0020,   /* U+352B */
  0x0020,   /* U+352C */
  0x0020,   /* U+352D */
  0x0020,   /* U+352E */
  0x0020,   /* U+352F */
  0x0020,   /* U+3530 */
  0x0020,   /* U+3531 */
  0x0020,   /* U+3532 */
  0x0020,   /* U+3533 */
  0x0020,   /* U+3534 */
  0x0020,   /* U+3535 */
  0x0020,   /* U+3536 */
  0x0020,   /* U+3537 */
  0x0020,   /* U+3538 */
  0x0020,   /* U+3539 */
  0x0020,   /* U+353A */
  0x0020,   /* U+353B */
  0x0020,   /* U+353C */
  0x0020,   /* U+353D */
  0x0020,   /* U+353E */
  0x0020,   /* U+353F */
  0x0020,   /* U+3540 */
  0x0020,   /* U+3541 */
  0x0020,   /* U+3542 */
  0x0020,   /* U+3543 */
  0x0020,   /* U+3544 */
  0x0020,   /* U+3545 */
  0x0020,   /* U+3546 */
  0x0020,   /* U+3547 */
  0x0020,   /* U+3548 */
  0x0020,   /* U+3549 */
  0x0020,   /* U+354A */
  0x0020,   /* U+354B */
  0x0020,   /* U+354C */
  0x0020,   /* U+354D */
  0x0020,   /* U+354E */
  0x0020,   /* U+354F */
  0x0020,   /* U+3550 */
  0x0020,   /* U+3551 */
  0x0020,   /* U+3552 */
  0x0020,   /* U+3553 */
  0x0020,   /* U+3554 */
  0x0020,   /* U+3555 */
  0x0020,   /* U+3556 */
  0x0020,   /* U+3557 */
  0x0020,   /* U+3558 */
  0x0020,   /* U+3559 */
  0x0020,   /* U+355A */
  0x0020,   /* U+355B */
  0x0020,   /* U+355C */
  0x0020,   /* U+355D */
  0x0020,   /* U+355E */
  0x0020,   /* U+355F */
  0x0020,   /* U+3560 */
  0x0020,   /* U+3561 */
  0x0020,   /* U+3562 */
  0x0020,   /* U+3563 */
  0x0020,   /* U+3564 */
  0x0020,   /* U+3565 */
  0x0020,   /* U+3566 */
  0x0020,   /* U+3567 */
  0x0020,   /* U+3568 */
  0x0020,   /* U+3569 */
  0x0020,   /* U+356A */
  0x0020,   /* U+356B */
  0x0020,   /* U+356C */
  0x0020,   /* U+356D */
  0x0020,   /* U+356E */
  0x0020,   /* U+356F */
  0x0020,   /* U+3570 */
  0x0020,   /* U+3571 */
  0x0020,   /* U+3572 */
  0x0020,   /* U+3573 */
  0x0020,   /* U+3574 */
  0x0020,   /* U+3575 */
  0x0020,   /* U+3576 */
  0x0020,   /* U+3577 */
  0x0020,   /* U+3578 */
  0x0020,   /* U+3579 */
  0x0020,   /* U+357A */
  0x0020,   /* U+357B */
  0x0020,   /* U+357C */
  0x0020,   /* U+357D */
  0x0020,   /* U+357E */
  0x0020,   /* U+357F */
  0x0020,   /* U+3580 */
  0x0020,   /* U+3581 */
  0x0020,   /* U+3582 */
  0x0020,   /* U+3583 */
  0x0020,   /* U+3584 */
  0x0020,   /* U+3585 */
  0x0020,   /* U+3586 */
  0x0020,   /* U+3587 */
  0x0020,   /* U+3588 */
  0x0020,   /* U+3589 */
  0x0020,   /* U+358A */
  0x0020,   /* U+358B */
  0x0020,   /* U+358C */
  0x0020,   /* U+358D */
  0x0020,   /* U+358E */
  0x0020,   /* U+358F */
  0x0020,   /* U+3590 */
  0x0020,   /* U+3591 */
  0x0020,   /* U+3592 */
  0x0020,   /* U+3593 */
  0x0020,   /* U+3594 */
  0x0020,   /* U+3595 */
  0x0020,   /* U+3596 */
  0x0020,   /* U+3597 */
  0x0020,   /* U+3598 */
  0x0020,   /* U+3599 */
  0x0020,   /* U+359A */
  0x0020,   /* U+359B */
  0x0020,   /* U+359C */
  0x0020,   /* U+359D */
  0x0020,   /* U+359E */
  0x0020,   /* U+359F */
  0x0020,   /* U+35A0 */
  0x0020,   /* U+35A1 */
  0x0020,   /* U+35A2 */
  0x0020,   /* U+35A3 */
  0x0020,   /* U+35A4 */
  0x0020,   /* U+35A5 */
  0x0020,   /* U+35A6 */
  0x0020,   /* U+35A7 */
  0x0020,   /* U+35A8 */
  0x0020,   /* U+35A9 */
  0x0020,   /* U+35AA */
  0x0020,   /* U+35AB */
  0x0020,   /* U+35AC */
  0x0020,   /* U+35AD */
  0x0020,   /* U+35AE */
  0x0020,   /* U+35AF */
  0x0020,   /* U+35B0 */
  0x0020,   /* U+35B1 */
  0x0020,   /* U+35B2 */
  0x0020,   /* U+35B3 */
  0x0020,   /* U+35B4 */
  0x0020,   /* U+35B5 */
  0x0020,   /* U+35B6 */
  0x0020,   /* U+35B7 */
  0x0020,   /* U+35B8 */
  0x0020,   /* U+35B9 */
  0x0020,   /* U+35BA */
  0x0020,   /* U+35BB */
  0x0020,   /* U+35BC */
  0x0020,   /* U+35BD */
  0x0020,   /* U+35BE */
  0x0020,   /* U+35BF */
  0x0020,   /* U+35C0 */
  0x0020,   /* U+35C1 */
  0x0020,   /* U+35C2 */
  0x0020,   /* U+35C3 */
  0x0020,   /* U+35C4 */
  0x0020,   /* U+35C5 */
  0x0020,   /* U+35C6 */
  0x0020,   /* U+35C7 */
  0x0020,   /* U+35C8 */
  0x0020,   /* U+35C9 */
  0x0020,   /* U+35CA */
  0x0020,   /* U+35CB */
  0x0020,   /* U+35CC */
  0x0020,   /* U+35CD */
  0x0020,   /* U+35CE */
  0x0020,   /* U+35CF */
  0x0020,   /* U+35D0 */
  0x0020,   /* U+35D1 */
  0x0020,   /* U+35D2 */
  0x0020,   /* U+35D3 */
  0x0020,   /* U+35D4 */
  0x0020,   /* U+35D5 */
  0x0020,   /* U+35D6 */
  0x0020,   /* U+35D7 */
  0x0020,   /* U+35D8 */
  0x0020,   /* U+35D9 */
  0x0020,   /* U+35DA */
  0x0020,   /* U+35DB */
  0x0020,   /* U+35DC */
  0x0020,   /* U+35DD */
  0x0020,   /* U+35DE */
  0x0020,   /* U+35DF */
  0x0020,   /* U+35E0 */
  0x0020,   /* U+35E1 */
  0x0020,   /* U+35E2 */
  0x0020,   /* U+35E3 */
  0x0020,   /* U+35E4 */
  0x0020,   /* U+35E5 */
  0x0020,   /* U+35E6 */
  0x0020,   /* U+35E7 */
  0x0020,   /* U+35E8 */
  0x0020,   /* U+35E9 */
  0x0020,   /* U+35EA */
  0x0020,   /* U+35EB */
  0x0020,   /* U+35EC */
  0x0020,   /* U+35ED */
  0x0020,   /* U+35EE */
  0x0020,   /* U+35EF */
  0x0020,   /* U+35F0 */
  0x0020,   /* U+35F1 */
  0x0020,   /* U+35F2 */
  0x0020,   /* U+35F3 */
  0x0020,   /* U+35F4 */
  0x0020,   /* U+35F5 */
  0x0020,   /* U+35F6 */
  0x0020,   /* U+35F7 */
  0x0020,   /* U+35F8 */
  0x0020,   /* U+35F9 */
  0x0020,   /* U+35FA */
  0x0020,   /* U+35FB */
  0x0020,   /* U+35FC */
  0x0020,   /* U+35FD */
  0x0020,   /* U+35FE */
  0x0020,   /* U+35FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3500 */
  0x0002,   /* U+3501 */
  0x0002,   /* U+3502 */
  0x0002,   /* U+3503 */
  0x0002,   /* U+3504 */
  0x0002,   /* U+3505 */
  0x0002,   /* U+3506 */
  0x0002,   /* U+3507 */
  0x0002,   /* U+3508 */
  0x0002,   /* U+3509 */
  0x0002,   /* U+350A */
  0x0002,   /* U+350B */
  0x0002,   /* U+350C */
  0x0002,   /* U+350D */
  0x0002,   /* U+350E */
  0x0002,   /* U+350F */
  0x0002,   /* U+3510 */
  0x0002,   /* U+3511 */
  0x0002,   /* U+3512 */
  0x0002,   /* U+3513 */
  0x0002,   /* U+3514 */
  0x0002,   /* U+3515 */
  0x0002,   /* U+3516 */
  0x0002,   /* U+3517 */
  0x0002,   /* U+3518 */
  0x0002,   /* U+3519 */
  0x0002,   /* U+351A */
  0x0002,   /* U+351B */
  0x0002,   /* U+351C */
  0x0002,   /* U+351D */
  0x0002,   /* U+351E */
  0x0002,   /* U+351F */
  0x0002,   /* U+3520 */
  0x0002,   /* U+3521 */
  0x0002,   /* U+3522 */
  0x0002,   /* U+3523 */
  0x0002,   /* U+3524 */
  0x0002,   /* U+3525 */
  0x0002,   /* U+3526 */
  0x0002,   /* U+3527 */
  0x0002,   /* U+3528 */
  0x0002,   /* U+3529 */
  0x0002,   /* U+352A */
  0x0002,   /* U+352B */
  0x0002,   /* U+352C */
  0x0002,   /* U+352D */
  0x0002,   /* U+352E */
  0x0002,   /* U+352F */
  0x0002,   /* U+3530 */
  0x0002,   /* U+3531 */
  0x0002,   /* U+3532 */
  0x0002,   /* U+3533 */
  0x0002,   /* U+3534 */
  0x0002,   /* U+3535 */
  0x0002,   /* U+3536 */
  0x0002,   /* U+3537 */
  0x0002,   /* U+3538 */
  0x0002,   /* U+3539 */
  0x0002,   /* U+353A */
  0x0002,   /* U+353B */
  0x0002,   /* U+353C */
  0x0002,   /* U+353D */
  0x0002,   /* U+353E */
  0x0002,   /* U+353F */
  0x0002,   /* U+3540 */
  0x0002,   /* U+3541 */
  0x0002,   /* U+3542 */
  0x0002,   /* U+3543 */
  0x0002,   /* U+3544 */
  0x0002,   /* U+3545 */
  0x0002,   /* U+3546 */
  0x0002,   /* U+3547 */
  0x0002,   /* U+3548 */
  0x0002,   /* U+3549 */
  0x0002,   /* U+354A */
  0x0002,   /* U+354B */
  0x0002,   /* U+354C */
  0x0002,   /* U+354D */
  0x0002,   /* U+354E */
  0x0002,   /* U+354F */
  0x0002,   /* U+3550 */
  0x0002,   /* U+3551 */
  0x0002,   /* U+3552 */
  0x0002,   /* U+3553 */
  0x0002,   /* U+3554 */
  0x0002,   /* U+3555 */
  0x0002,   /* U+3556 */
  0x0002,   /* U+3557 */
  0x0002,   /* U+3558 */
  0x0002,   /* U+3559 */
  0x0002,   /* U+355A */
  0x0002,   /* U+355B */
  0x0002,   /* U+355C */
  0x0002,   /* U+355D */
  0x0002,   /* U+355E */
  0x0002,   /* U+355F */
  0x0002,   /* U+3560 */
  0x0002,   /* U+3561 */
  0x0002,   /* U+3562 */
  0x0002,   /* U+3563 */
  0x0002,   /* U+3564 */
  0x0002,   /* U+3565 */
  0x0002,   /* U+3566 */
  0x0002,   /* U+3567 */
  0x0002,   /* U+3568 */
  0x0002,   /* U+3569 */
  0x0002,   /* U+356A */
  0x0002,   /* U+356B */
  0x0002,   /* U+356C */
  0x0002,   /* U+356D */
  0x0002,   /* U+356E */
  0x0002,   /* U+356F */
  0x0002,   /* U+3570 */
  0x0002,   /* U+3571 */
  0x0002,   /* U+3572 */
  0x0002,   /* U+3573 */
  0x0002,   /* U+3574 */
  0x0002,   /* U+3575 */
  0x0002,   /* U+3576 */
  0x0002,   /* U+3577 */
  0x0002,   /* U+3578 */
  0x0002,   /* U+3579 */
  0x0002,   /* U+357A */
  0x0002,   /* U+357B */
  0x0002,   /* U+357C */
  0x0002,   /* U+357D */
  0x0002,   /* U+357E */
  0x0002,   /* U+357F */
  0x0002,   /* U+3580 */
  0x0002,   /* U+3581 */
  0x0002,   /* U+3582 */
  0x0002,   /* U+3583 */
  0x0002,   /* U+3584 */
  0x0002,   /* U+3585 */
  0x0002,   /* U+3586 */
  0x0002,   /* U+3587 */
  0x0002,   /* U+3588 */
  0x0002,   /* U+3589 */
  0x0002,   /* U+358A */
  0x0002,   /* U+358B */
  0x0002,   /* U+358C */
  0x0002,   /* U+358D */
  0x0002,   /* U+358E */
  0x0002,   /* U+358F */
  0x0002,   /* U+3590 */
  0x0002,   /* U+3591 */
  0x0002,   /* U+3592 */
  0x0002,   /* U+3593 */
  0x0002,   /* U+3594 */
  0x0002,   /* U+3595 */
  0x0002,   /* U+3596 */
  0x0002,   /* U+3597 */
  0x0002,   /* U+3598 */
  0x0002,   /* U+3599 */
  0x0002,   /* U+359A */
  0x0002,   /* U+359B */
  0x0002,   /* U+359C */
  0x0002,   /* U+359D */
  0x0002,   /* U+359E */
  0x0002,   /* U+359F */
  0x0002,   /* U+35A0 */
  0x0002,   /* U+35A1 */
  0x0002,   /* U+35A2 */
  0x0002,   /* U+35A3 */
  0x0002,   /* U+35A4 */
  0x0002,   /* U+35A5 */
  0x0002,   /* U+35A6 */
  0x0002,   /* U+35A7 */
  0x0002,   /* U+35A8 */
  0x0002,   /* U+35A9 */
  0x0002,   /* U+35AA */
  0x0002,   /* U+35AB */
  0x0002,   /* U+35AC */
  0x0002,   /* U+35AD */
  0x0002,   /* U+35AE */
  0x0002,   /* U+35AF */
  0x0002,   /* U+35B0 */
  0x0002,   /* U+35B1 */
  0x0002,   /* U+35B2 */
  0x0002,   /* U+35B3 */
  0x0002,   /* U+35B4 */
  0x0002,   /* U+35B5 */
  0x0002,   /* U+35B6 */
  0x0002,   /* U+35B7 */
  0x0002,   /* U+35B8 */
  0x0002,   /* U+35B9 */
  0x0002,   /* U+35BA */
  0x0002,   /* U+35BB */
  0x0002,   /* U+35BC */
  0x0002,   /* U+35BD */
  0x0002,   /* U+35BE */
  0x0002,   /* U+35BF */
  0x0002,   /* U+35C0 */
  0x0002,   /* U+35C1 */
  0x0002,   /* U+35C2 */
  0x0002,   /* U+35C3 */
  0x0002,   /* U+35C4 */
  0x0002,   /* U+35C5 */
  0x0002,   /* U+35C6 */
  0x0002,   /* U+35C7 */
  0x0002,   /* U+35C8 */
  0x0002,   /* U+35C9 */
  0x0002,   /* U+35CA */
  0x0002,   /* U+35CB */
  0x0002,   /* U+35CC */
  0x0002,   /* U+35CD */
  0x0002,   /* U+35CE */
  0x0002,   /* U+35CF */
  0x0002,   /* U+35D0 */
  0x0002,   /* U+35D1 */
  0x0002,   /* U+35D2 */
  0x0002,   /* U+35D3 */
  0x0002,   /* U+35D4 */
  0x0002,   /* U+35D5 */
  0x0002,   /* U+35D6 */
  0x0002,   /* U+35D7 */
  0x0002,   /* U+35D8 */
  0x0002,   /* U+35D9 */
  0x0002,   /* U+35DA */
  0x0002,   /* U+35DB */
  0x0002,   /* U+35DC */
  0x0002,   /* U+35DD */
  0x0002,   /* U+35DE */
  0x0002,   /* U+35DF */
  0x0002,   /* U+35E0 */
  0x0002,   /* U+35E1 */
  0x0002,   /* U+35E2 */
  0x0002,   /* U+35E3 */
  0x0002,   /* U+35E4 */
  0x0002,   /* U+35E5 */
  0x0002,   /* U+35E6 */
  0x0002,   /* U+35E7 */
  0x0002,   /* U+35E8 */
  0x0002,   /* U+35E9 */
  0x0002,   /* U+35EA */
  0x0002,   /* U+35EB */
  0x0002,   /* U+35EC */
  0x0002,   /* U+35ED */
  0x0002,   /* U+35EE */
  0x0002,   /* U+35EF */
  0x0002,   /* U+35F0 */
  0x0002,   /* U+35F1 */
  0x0002,   /* U+35F2 */
  0x0002,   /* U+35F3 */
  0x0002,   /* U+35F4 */
  0x0002,   /* U+35F5 */
  0x0002,   /* U+35F6 */
  0x0002,   /* U+35F7 */
  0x0002,   /* U+35F8 */
  0x0002,   /* U+35F9 */
  0x0002,   /* U+35FA */
  0x0002,   /* U+35FB */
  0x0002,   /* U+35FC */
  0x0002,   /* U+35FD */
  0x0002,   /* U+35FE */
  0x0002,   /* U+35FF */

  /* Primary weight 2 for each character. */
  0x810A,   /* U+3500 */
  0x810B,   /* U+3501 */
  0x810C,   /* U+3502 */
  0x810D,   /* U+3503 */
  0x810E,   /* U+3504 */
  0x810F,   /* U+3505 */
  0x8110,   /* U+3506 */
  0x8111,   /* U+3507 */
  0x8112,   /* U+3508 */
  0x8113,   /* U+3509 */
  0x80CC,   /* U+350A */
  0x808B,   /* U+350B */
  0x808C,   /* U+350C */
  0x808D,   /* U+350D */
  0x8066,   /* U+350E */
  0x8067,   /* U+350F */
  0x805D,   /* U+3510 */
  0x803E,   /* U+3511 */
  0x8027,   /* U+3512 */
  0x80EF,   /* U+3513 */
  0x8199,   /* U+3514 */
  0x819A,   /* U+3515 */
  0x819B,   /* U+3516 */
  0x81A3,   /* U+3517 */
  0x81A4,   /* U+3518 */
  0x81D4,   /* U+3519 */
  0x81D5,   /* U+351A */
  0x81D6,   /* U+351B */
  0x81B5,   /* U+351C */
  0x81F8,   /* U+351D */
  0x81F9,   /* U+351E */
  0x81FA,   /* U+351F */
  0x819F,   /* U+3520 */
  0x8174,   /* U+3521 */
  0x8147,   /* U+3522 */
  0x8081,   /* U+3523 */
  0x8082,   /* U+3524 */
  0x8083,   /* U+3525 */
  0x8084,   /* U+3526 */
  0x8068,   /* U+3527 */
  0x81B4,   /* U+3528 */
  0x818D,   /* U+3529 */
  0x816A,   /* U+352A */
  0x80CD,   /* U+352B */
  0x81FB,   /* U+352C */
  0x81C2,   /* U+352D */
  0x83BA,   /* U+352E */
  0x81CA,   /* U+352F */
  0x81CB,   /* U+3530 */
  0x81C8,   /* U+3531 */
  0x8175,   /* U+3532 */
  0x8176,   /* U+3533 */
  0x8177,   /* U+3534 */
  0x816E,   /* U+3535 */
  0x8009,   /* U+3536 */
  0x81D8,   /* U+3537 */
  0x819D,   /* U+3538 */
  0x80DA,   /* U+3539 */
  0x81C5,   /* U+353A */
  0x81C6,   /* U+353B */
  0x817F,   /* U+353C */
  0x8225,   /* U+353D */
  0x8068,   /* U+353E */
  0x8069,   /* U+353F */
  0x81F6,   /* U+3540 */
  0x8237,   /* U+3541 */
  0x81F0,   /* U+3542 */
  0x81F1,   /* U+3543 */
  0x81F2,   /* U+3544 */
  0x81FD,   /* U+3545 */
  0x81FE,   /* U+3546 */
  0x81FF,   /* U+3547 */
  0x8243,   /* U+3548 */
  0x8244,   /* U+3549 */
  0x8220,   /* U+354A */
  0x8259,   /* U+354B */
  0x825A,   /* U+354C */
  0x825B,   /* U+354D */
  0x81B8,   /* U+354E */
  0x819A,   /* U+354F */
  0x8186,   /* U+3550 */
  0x8187,   /* U+3551 */
  0x8112,   /* U+3552 */
  0x80A0,   /* U+3553 */
  0x800B,   /* U+3554 */
  0x80F5,   /* U+3555 */
  0x827D,   /* U+3556 */
  0x8208,   /* U+3557 */
  0x8209,   /* U+3558 */
  0x8125,   /* U+3559 */
  0x80FE,   /* U+355A */
  0x80FF,   /* U+355B */
  0x8211,   /* U+355C */
  0x8218,   /* U+355D */
  0x8266,   /* U+355E */
  0x824E,   /* U+355F */
  0x81E1,   /* U+3560 */
  0x81AC,   /* U+3561 */
  0x973A,   /* U+3562 */
  0x815D,   /* U+3563 */
  0x815E,   /* U+3564 */
  0x815F,   /* U+3565 */
  0x823D,   /* U+3566 */
  0x823E,   /* U+3567 */
  0x823F,   /* U+3568 */
  0x8270,   /* U+3569 */
  0x8271,   /* U+356A */
  0x8272,   /* U+356B */
  0x8273,   /* U+356C */
  0x8274,   /* U+356D */
  0x8275,   /* U+356E */
  0x8276,   /* U+356F */
  0x8277,   /* U+3570 */
  0x8278,   /* U+3571 */
  0x8279,   /* U+3572 */
  0x827A,   /* U+3573 */
  0x827B,   /* U+3574 */
  0x827C,   /* U+3575 */
  0x827D,   /* U+3576 */
  0x82B5,   /* U+3577 */
  0x82B6,   /* U+3578 */
  0x82B7,   /* U+3579 */
  0x82B8,   /* U+357A */
  0x82B9,   /* U+357B */
  0x82BA,   /* U+357C */
  0x82BB,   /* U+357D */
  0x82BC,   /* U+357E */
  0x82BD,   /* U+357F */
  0x82A7,   /* U+3580 */
  0x82A8,   /* U+3581 */
  0x82A9,   /* U+3582 */
  0x82AA,   /* U+3583 */
  0x82AB,   /* U+3584 */
  0x82AC,   /* U+3585 */
  0x82AD,   /* U+3586 */
  0x82AE,   /* U+3587 */
  0x82AF,   /* U+3588 */
  0x82B0,   /* U+3589 */
  0x82B1,   /* U+358A */
  0x82B2,   /* U+358B */
  0x82B3,   /* U+358C */
  0x82B4,   /* U+358D */
  0x82B5,   /* U+358E */
  0x82E7,   /* U+358F */
  0x82E8,   /* U+3590 */
  0x82E9,   /* U+3591 */
  0x82EA,   /* U+3592 */
  0x82EB,   /* U+3593 */
  0x82EC,   /* U+3594 */
  0x82ED,   /* U+3595 */
  0x82EE,   /* U+3596 */
  0x82EF,   /* U+3597 */
  0x82F0,   /* U+3598 */
  0x82F1,   /* U+3599 */
  0x82F2,   /* U+359A */
  0x82F3,   /* U+359B */
  0x82F4,   /* U+359C */
  0x82F5,   /* U+359D */
  0x82F6,   /* U+359E */
  0x8275,   /* U+359F */
  0x8276,   /* U+35A0 */
  0x8277,   /* U+35A1 */
  0x8278,   /* U+35A2 */
  0x8279,   /* U+35A3 */
  0x827A,   /* U+35A4 */
  0x827B,   /* U+35A5 */
  0x827C,   /* U+35A6 */
  0x827D,   /* U+35A7 */
  0x827E,   /* U+35A8 */
  0x827F,   /* U+35A9 */
  0x8280,   /* U+35AA */
  0x8281,   /* U+35AB */
  0x8282,   /* U+35AC */
  0x8283,   /* U+35AD */
  0x8284,   /* U+35AE */
  0x8285,   /* U+35AF */
  0x8286,   /* U+35B0 */
  0x8287,   /* U+35B1 */
  0x8288,   /* U+35B2 */
  0x8289,   /* U+35B3 */
  0x828A,   /* U+35B4 */
  0x828B,   /* U+35B5 */
  0x8239,   /* U+35B6 */
  0x823A,   /* U+35B7 */
  0x823B,   /* U+35B8 */
  0x823C,   /* U+35B9 */
  0x823D,   /* U+35BA */
  0x823E,   /* U+35BB */
  0x823F,   /* U+35BC */
  0x8240,   /* U+35BD */
  0x8241,   /* U+35BE */
  0x8242,   /* U+35BF */
  0x8243,   /* U+35C0 */
  0x8244,   /* U+35C1 */
  0x8245,   /* U+35C2 */
  0x8246,   /* U+35C3 */
  0x8247,   /* U+35C4 */
  0x8248,   /* U+35C5 */
  0x8249,   /* U+35C6 */
  0x824A,   /* U+35C7 */
  0x824B,   /* U+35C8 */
  0x824C,   /* U+35C9 */
  0x824D,   /* U+35CA */
  0x824E,   /* U+35CB */
  0x824F,   /* U+35CC */
  0x8250,   /* U+35CD */
  0x8251,   /* U+35CE */
  0x8252,   /* U+35CF */
  0x8253,   /* U+35D0 */
  0x8254,   /* U+35D1 */
  0x8205,   /* U+35D2 */
  0x8206,   /* U+35D3 */
  0x8207,   /* U+35D4 */
  0x8208,   /* U+35D5 */
  0x8209,   /* U+35D6 */
  0x820A,   /* U+35D7 */
  0x820B,   /* U+35D8 */
  0x820C,   /* U+35D9 */
  0x820D,   /* U+35DA */
  0x820E,   /* U+35DB */
  0x820F,   /* U+35DC */
  0x8210,   /* U+35DD */
  0x8211,   /* U+35DE */
  0x8212,   /* U+35DF */
  0x8213,   /* U+35E0 */
  0x8214,   /* U+35E1 */
  0x81EC,   /* U+35E2 */
  0x81ED,   /* U+35E3 */
  0x81EE,   /* U+35E4 */
  0x81EF,   /* U+35E5 */
  0x81F0,   /* U+35E6 */
  0x81F1,   /* U+35E7 */
  0x81F2,   /* U+35E8 */
  0x81F3,   /* U+35E9 */
  0x81F4,   /* U+35EA */
  0x81F5,   /* U+35EB */
  0x81F6,   /* U+35EC */
  0x81F7,   /* U+35ED */
  0x81F8,   /* U+35EE */
  0x81F9,   /* U+35EF */
  0x81FA,   /* U+35F0 */
  0x8163,   /* U+35F1 */
  0x8164,   /* U+35F2 */
  0x8165,   /* U+35F3 */
  0x8166,   /* U+35F4 */
  0x8167,   /* U+35F5 */
  0x8168,   /* U+35F6 */
  0x8169,   /* U+35F7 */
  0x816A,   /* U+35F8 */
  0x816B,   /* U+35F9 */
  0x816C,   /* U+35FA */
  0x80F0,   /* U+35FB */
  0x80F1,   /* U+35FC */
  0x80F2,   /* U+35FD */
  0x80F3,   /* U+35FE */
  0x80F4,   /* U+35FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3500 */
  0x0000,   /* U+3501 */
  0x0000,   /* U+3502 */
  0x0000,   /* U+3503 */
  0x0000,   /* U+3504 */
  0x0000,   /* U+3505 */
  0x0000,   /* U+3506 */
  0x0000,   /* U+3507 */
  0x0000,   /* U+3508 */
  0x0000,   /* U+3509 */
  0x0000,   /* U+350A */
  0x0000,   /* U+350B */
  0x0000,   /* U+350C */
  0x0000,   /* U+350D */
  0x0000,   /* U+350E */
  0x0000,   /* U+350F */
  0x0000,   /* U+3510 */
  0x0000,   /* U+3511 */
  0x0000,   /* U+3512 */
  0x0000,   /* U+3513 */
  0x0000,   /* U+3514 */
  0x0000,   /* U+3515 */
  0x0000,   /* U+3516 */
  0x0000,   /* U+3517 */
  0x0000,   /* U+3518 */
  0x0000,   /* U+3519 */
  0x0000,   /* U+351A */
  0x0000,   /* U+351B */
  0x0000,   /* U+351C */
  0x0000,   /* U+351D */
  0x0000,   /* U+351E */
  0x0000,   /* U+351F */
  0x0000,   /* U+3520 */
  0x0000,   /* U+3521 */
  0x0000,   /* U+3522 */
  0x0000,   /* U+3523 */
  0x0000,   /* U+3524 */
  0x0000,   /* U+3525 */
  0x0000,   /* U+3526 */
  0x0000,   /* U+3527 */
  0x0000,   /* U+3528 */
  0x0000,   /* U+3529 */
  0x0000,   /* U+352A */
  0x0000,   /* U+352B */
  0x0000,   /* U+352C */
  0x0000,   /* U+352D */
  0x0000,   /* U+352E */
  0x0000,   /* U+352F */
  0x0000,   /* U+3530 */
  0x0000,   /* U+3531 */
  0x0000,   /* U+3532 */
  0x0000,   /* U+3533 */
  0x0000,   /* U+3534 */
  0x0000,   /* U+3535 */
  0x0000,   /* U+3536 */
  0x0000,   /* U+3537 */
  0x0000,   /* U+3538 */
  0x0000,   /* U+3539 */
  0x0000,   /* U+353A */
  0x0000,   /* U+353B */
  0x0000,   /* U+353C */
  0x0000,   /* U+353D */
  0x0000,   /* U+353E */
  0x0000,   /* U+353F */
  0x0000,   /* U+3540 */
  0x0000,   /* U+3541 */
  0x0000,   /* U+3542 */
  0x0000,   /* U+3543 */
  0x0000,   /* U+3544 */
  0x0000,   /* U+3545 */
  0x0000,   /* U+3546 */
  0x0000,   /* U+3547 */
  0x0000,   /* U+3548 */
  0x0000,   /* U+3549 */
  0x0000,   /* U+354A */
  0x0000,   /* U+354B */
  0x0000,   /* U+354C */
  0x0000,   /* U+354D */
  0x0000,   /* U+354E */
  0x0000,   /* U+354F */
  0x0000,   /* U+3550 */
  0x0000,   /* U+3551 */
  0x0000,   /* U+3552 */
  0x0000,   /* U+3553 */
  0x0000,   /* U+3554 */
  0x0000,   /* U+3555 */
  0x0000,   /* U+3556 */
  0x0000,   /* U+3557 */
  0x0000,   /* U+3558 */
  0x0000,   /* U+3559 */
  0x0000,   /* U+355A */
  0x0000,   /* U+355B */
  0x0000,   /* U+355C */
  0x0000,   /* U+355D */
  0x0000,   /* U+355E */
  0x0000,   /* U+355F */
  0x0000,   /* U+3560 */
  0x0000,   /* U+3561 */
  0x0000,   /* U+3562 */
  0x0000,   /* U+3563 */
  0x0000,   /* U+3564 */
  0x0000,   /* U+3565 */
  0x0000,   /* U+3566 */
  0x0000,   /* U+3567 */
  0x0000,   /* U+3568 */
  0x0000,   /* U+3569 */
  0x0000,   /* U+356A */
  0x0000,   /* U+356B */
  0x0000,   /* U+356C */
  0x0000,   /* U+356D */
  0x0000,   /* U+356E */
  0x0000,   /* U+356F */
  0x0000,   /* U+3570 */
  0x0000,   /* U+3571 */
  0x0000,   /* U+3572 */
  0x0000,   /* U+3573 */
  0x0000,   /* U+3574 */
  0x0000,   /* U+3575 */
  0x0000,   /* U+3576 */
  0x0000,   /* U+3577 */
  0x0000,   /* U+3578 */
  0x0000,   /* U+3579 */
  0x0000,   /* U+357A */
  0x0000,   /* U+357B */
  0x0000,   /* U+357C */
  0x0000,   /* U+357D */
  0x0000,   /* U+357E */
  0x0000,   /* U+357F */
  0x0000,   /* U+3580 */
  0x0000,   /* U+3581 */
  0x0000,   /* U+3582 */
  0x0000,   /* U+3583 */
  0x0000,   /* U+3584 */
  0x0000,   /* U+3585 */
  0x0000,   /* U+3586 */
  0x0000,   /* U+3587 */
  0x0000,   /* U+3588 */
  0x0000,   /* U+3589 */
  0x0000,   /* U+358A */
  0x0000,   /* U+358B */
  0x0000,   /* U+358C */
  0x0000,   /* U+358D */
  0x0000,   /* U+358E */
  0x0000,   /* U+358F */
  0x0000,   /* U+3590 */
  0x0000,   /* U+3591 */
  0x0000,   /* U+3592 */
  0x0000,   /* U+3593 */
  0x0000,   /* U+3594 */
  0x0000,   /* U+3595 */
  0x0000,   /* U+3596 */
  0x0000,   /* U+3597 */
  0x0000,   /* U+3598 */
  0x0000,   /* U+3599 */
  0x0000,   /* U+359A */
  0x0000,   /* U+359B */
  0x0000,   /* U+359C */
  0x0000,   /* U+359D */
  0x0000,   /* U+359E */
  0x0000,   /* U+359F */
  0x0000,   /* U+35A0 */
  0x0000,   /* U+35A1 */
  0x0000,   /* U+35A2 */
  0x0000,   /* U+35A3 */
  0x0000,   /* U+35A4 */
  0x0000,   /* U+35A5 */
  0x0000,   /* U+35A6 */
  0x0000,   /* U+35A7 */
  0x0000,   /* U+35A8 */
  0x0000,   /* U+35A9 */
  0x0000,   /* U+35AA */
  0x0000,   /* U+35AB */
  0x0000,   /* U+35AC */
  0x0000,   /* U+35AD */
  0x0000,   /* U+35AE */
  0x0000,   /* U+35AF */
  0x0000,   /* U+35B0 */
  0x0000,   /* U+35B1 */
  0x0000,   /* U+35B2 */
  0x0000,   /* U+35B3 */
  0x0000,   /* U+35B4 */
  0x0000,   /* U+35B5 */
  0x0000,   /* U+35B6 */
  0x0000,   /* U+35B7 */
  0x0000,   /* U+35B8 */
  0x0000,   /* U+35B9 */
  0x0000,   /* U+35BA */
  0x0000,   /* U+35BB */
  0x0000,   /* U+35BC */
  0x0000,   /* U+35BD */
  0x0000,   /* U+35BE */
  0x0000,   /* U+35BF */
  0x0000,   /* U+35C0 */
  0x0000,   /* U+35C1 */
  0x0000,   /* U+35C2 */
  0x0000,   /* U+35C3 */
  0x0000,   /* U+35C4 */
  0x0000,   /* U+35C5 */
  0x0000,   /* U+35C6 */
  0x0000,   /* U+35C7 */
  0x0000,   /* U+35C8 */
  0x0000,   /* U+35C9 */
  0x0000,   /* U+35CA */
  0x0000,   /* U+35CB */
  0x0000,   /* U+35CC */
  0x0000,   /* U+35CD */
  0x0000,   /* U+35CE */
  0x0000,   /* U+35CF */
  0x0000,   /* U+35D0 */
  0x0000,   /* U+35D1 */
  0x0000,   /* U+35D2 */
  0x0000,   /* U+35D3 */
  0x0000,   /* U+35D4 */
  0x0000,   /* U+35D5 */
  0x0000,   /* U+35D6 */
  0x0000,   /* U+35D7 */
  0x0000,   /* U+35D8 */
  0x0000,   /* U+35D9 */
  0x0000,   /* U+35DA */
  0x0000,   /* U+35DB */
  0x0000,   /* U+35DC */
  0x0000,   /* U+35DD */
  0x0000,   /* U+35DE */
  0x0000,   /* U+35DF */
  0x0000,   /* U+35E0 */
  0x0000,   /* U+35E1 */
  0x0000,   /* U+35E2 */
  0x0000,   /* U+35E3 */
  0x0000,   /* U+35E4 */
  0x0000,   /* U+35E5 */
  0x0000,   /* U+35E6 */
  0x0000,   /* U+35E7 */
  0x0000,   /* U+35E8 */
  0x0000,   /* U+35E9 */
  0x0000,   /* U+35EA */
  0x0000,   /* U+35EB */
  0x0000,   /* U+35EC */
  0x0000,   /* U+35ED */
  0x0000,   /* U+35EE */
  0x0000,   /* U+35EF */
  0x0000,   /* U+35F0 */
  0x0000,   /* U+35F1 */
  0x0000,   /* U+35F2 */
  0x0000,   /* U+35F3 */
  0x0000,   /* U+35F4 */
  0x0000,   /* U+35F5 */
  0x0000,   /* U+35F6 */
  0x0000,   /* U+35F7 */
  0x0000,   /* U+35F8 */
  0x0000,   /* U+35F9 */
  0x0000,   /* U+35FA */
  0x0000,   /* U+35FB */
  0x0000,   /* U+35FC */
  0x0000,   /* U+35FD */
  0x0000,   /* U+35FE */
  0x0000,   /* U+35FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3500 */
  0x0000,   /* U+3501 */
  0x0000,   /* U+3502 */
  0x0000,   /* U+3503 */
  0x0000,   /* U+3504 */
  0x0000,   /* U+3505 */
  0x0000,   /* U+3506 */
  0x0000,   /* U+3507 */
  0x0000,   /* U+3508 */
  0x0000,   /* U+3509 */
  0x0000,   /* U+350A */
  0x0000,   /* U+350B */
  0x0000,   /* U+350C */
  0x0000,   /* U+350D */
  0x0000,   /* U+350E */
  0x0000,   /* U+350F */
  0x0000,   /* U+3510 */
  0x0000,   /* U+3511 */
  0x0000,   /* U+3512 */
  0x0000,   /* U+3513 */
  0x0000,   /* U+3514 */
  0x0000,   /* U+3515 */
  0x0000,   /* U+3516 */
  0x0000,   /* U+3517 */
  0x0000,   /* U+3518 */
  0x0000,   /* U+3519 */
  0x0000,   /* U+351A */
  0x0000,   /* U+351B */
  0x0000,   /* U+351C */
  0x0000,   /* U+351D */
  0x0000,   /* U+351E */
  0x0000,   /* U+351F */
  0x0000,   /* U+3520 */
  0x0000,   /* U+3521 */
  0x0000,   /* U+3522 */
  0x0000,   /* U+3523 */
  0x0000,   /* U+3524 */
  0x0000,   /* U+3525 */
  0x0000,   /* U+3526 */
  0x0000,   /* U+3527 */
  0x0000,   /* U+3528 */
  0x0000,   /* U+3529 */
  0x0000,   /* U+352A */
  0x0000,   /* U+352B */
  0x0000,   /* U+352C */
  0x0000,   /* U+352D */
  0x0000,   /* U+352E */
  0x0000,   /* U+352F */
  0x0000,   /* U+3530 */
  0x0000,   /* U+3531 */
  0x0000,   /* U+3532 */
  0x0000,   /* U+3533 */
  0x0000,   /* U+3534 */
  0x0000,   /* U+3535 */
  0x0000,   /* U+3536 */
  0x0000,   /* U+3537 */
  0x0000,   /* U+3538 */
  0x0000,   /* U+3539 */
  0x0000,   /* U+353A */
  0x0000,   /* U+353B */
  0x0000,   /* U+353C */
  0x0000,   /* U+353D */
  0x0000,   /* U+353E */
  0x0000,   /* U+353F */
  0x0000,   /* U+3540 */
  0x0000,   /* U+3541 */
  0x0000,   /* U+3542 */
  0x0000,   /* U+3543 */
  0x0000,   /* U+3544 */
  0x0000,   /* U+3545 */
  0x0000,   /* U+3546 */
  0x0000,   /* U+3547 */
  0x0000,   /* U+3548 */
  0x0000,   /* U+3549 */
  0x0000,   /* U+354A */
  0x0000,   /* U+354B */
  0x0000,   /* U+354C */
  0x0000,   /* U+354D */
  0x0000,   /* U+354E */
  0x0000,   /* U+354F */
  0x0000,   /* U+3550 */
  0x0000,   /* U+3551 */
  0x0000,   /* U+3552 */
  0x0000,   /* U+3553 */
  0x0000,   /* U+3554 */
  0x0000,   /* U+3555 */
  0x0000,   /* U+3556 */
  0x0000,   /* U+3557 */
  0x0000,   /* U+3558 */
  0x0000,   /* U+3559 */
  0x0000,   /* U+355A */
  0x0000,   /* U+355B */
  0x0000,   /* U+355C */
  0x0000,   /* U+355D */
  0x0000,   /* U+355E */
  0x0000,   /* U+355F */
  0x0000,   /* U+3560 */
  0x0000,   /* U+3561 */
  0x0000,   /* U+3562 */
  0x0000,   /* U+3563 */
  0x0000,   /* U+3564 */
  0x0000,   /* U+3565 */
  0x0000,   /* U+3566 */
  0x0000,   /* U+3567 */
  0x0000,   /* U+3568 */
  0x0000,   /* U+3569 */
  0x0000,   /* U+356A */
  0x0000,   /* U+356B */
  0x0000,   /* U+356C */
  0x0000,   /* U+356D */
  0x0000,   /* U+356E */
  0x0000,   /* U+356F */
  0x0000,   /* U+3570 */
  0x0000,   /* U+3571 */
  0x0000,   /* U+3572 */
  0x0000,   /* U+3573 */
  0x0000,   /* U+3574 */
  0x0000,   /* U+3575 */
  0x0000,   /* U+3576 */
  0x0000,   /* U+3577 */
  0x0000,   /* U+3578 */
  0x0000,   /* U+3579 */
  0x0000,   /* U+357A */
  0x0000,   /* U+357B */
  0x0000,   /* U+357C */
  0x0000,   /* U+357D */
  0x0000,   /* U+357E */
  0x0000,   /* U+357F */
  0x0000,   /* U+3580 */
  0x0000,   /* U+3581 */
  0x0000,   /* U+3582 */
  0x0000,   /* U+3583 */
  0x0000,   /* U+3584 */
  0x0000,   /* U+3585 */
  0x0000,   /* U+3586 */
  0x0000,   /* U+3587 */
  0x0000,   /* U+3588 */
  0x0000,   /* U+3589 */
  0x0000,   /* U+358A */
  0x0000,   /* U+358B */
  0x0000,   /* U+358C */
  0x0000,   /* U+358D */
  0x0000,   /* U+358E */
  0x0000,   /* U+358F */
  0x0000,   /* U+3590 */
  0x0000,   /* U+3591 */
  0x0000,   /* U+3592 */
  0x0000,   /* U+3593 */
  0x0000,   /* U+3594 */
  0x0000,   /* U+3595 */
  0x0000,   /* U+3596 */
  0x0000,   /* U+3597 */
  0x0000,   /* U+3598 */
  0x0000,   /* U+3599 */
  0x0000,   /* U+359A */
  0x0000,   /* U+359B */
  0x0000,   /* U+359C */
  0x0000,   /* U+359D */
  0x0000,   /* U+359E */
  0x0000,   /* U+359F */
  0x0000,   /* U+35A0 */
  0x0000,   /* U+35A1 */
  0x0000,   /* U+35A2 */
  0x0000,   /* U+35A3 */
  0x0000,   /* U+35A4 */
  0x0000,   /* U+35A5 */
  0x0000,   /* U+35A6 */
  0x0000,   /* U+35A7 */
  0x0000,   /* U+35A8 */
  0x0000,   /* U+35A9 */
  0x0000,   /* U+35AA */
  0x0000,   /* U+35AB */
  0x0000,   /* U+35AC */
  0x0000,   /* U+35AD */
  0x0000,   /* U+35AE */
  0x0000,   /* U+35AF */
  0x0000,   /* U+35B0 */
  0x0000,   /* U+35B1 */
  0x0000,   /* U+35B2 */
  0x0000,   /* U+35B3 */
  0x0000,   /* U+35B4 */
  0x0000,   /* U+35B5 */
  0x0000,   /* U+35B6 */
  0x0000,   /* U+35B7 */
  0x0000,   /* U+35B8 */
  0x0000,   /* U+35B9 */
  0x0000,   /* U+35BA */
  0x0000,   /* U+35BB */
  0x0000,   /* U+35BC */
  0x0000,   /* U+35BD */
  0x0000,   /* U+35BE */
  0x0000,   /* U+35BF */
  0x0000,   /* U+35C0 */
  0x0000,   /* U+35C1 */
  0x0000,   /* U+35C2 */
  0x0000,   /* U+35C3 */
  0x0000,   /* U+35C4 */
  0x0000,   /* U+35C5 */
  0x0000,   /* U+35C6 */
  0x0000,   /* U+35C7 */
  0x0000,   /* U+35C8 */
  0x0000,   /* U+35C9 */
  0x0000,   /* U+35CA */
  0x0000,   /* U+35CB */
  0x0000,   /* U+35CC */
  0x0000,   /* U+35CD */
  0x0000,   /* U+35CE */
  0x0000,   /* U+35CF */
  0x0000,   /* U+35D0 */
  0x0000,   /* U+35D1 */
  0x0000,   /* U+35D2 */
  0x0000,   /* U+35D3 */
  0x0000,   /* U+35D4 */
  0x0000,   /* U+35D5 */
  0x0000,   /* U+35D6 */
  0x0000,   /* U+35D7 */
  0x0000,   /* U+35D8 */
  0x0000,   /* U+35D9 */
  0x0000,   /* U+35DA */
  0x0000,   /* U+35DB */
  0x0000,   /* U+35DC */
  0x0000,   /* U+35DD */
  0x0000,   /* U+35DE */
  0x0000,   /* U+35DF */
  0x0000,   /* U+35E0 */
  0x0000,   /* U+35E1 */
  0x0000,   /* U+35E2 */
  0x0000,   /* U+35E3 */
  0x0000,   /* U+35E4 */
  0x0000,   /* U+35E5 */
  0x0000,   /* U+35E6 */
  0x0000,   /* U+35E7 */
  0x0000,   /* U+35E8 */
  0x0000,   /* U+35E9 */
  0x0000,   /* U+35EA */
  0x0000,   /* U+35EB */
  0x0000,   /* U+35EC */
  0x0000,   /* U+35ED */
  0x0000,   /* U+35EE */
  0x0000,   /* U+35EF */
  0x0000,   /* U+35F0 */
  0x0000,   /* U+35F1 */
  0x0000,   /* U+35F2 */
  0x0000,   /* U+35F3 */
  0x0000,   /* U+35F4 */
  0x0000,   /* U+35F5 */
  0x0000,   /* U+35F6 */
  0x0000,   /* U+35F7 */
  0x0000,   /* U+35F8 */
  0x0000,   /* U+35F9 */
  0x0000,   /* U+35FA */
  0x0000,   /* U+35FB */
  0x0000,   /* U+35FC */
  0x0000,   /* U+35FD */
  0x0000,   /* U+35FE */
  0x0000,   /* U+35FF */
};

uint16 zh3_han_p036[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C57,   /* U+3600 */
  0x1C57,   /* U+3601 */
  0x1C57,   /* U+3602 */
  0x1C57,   /* U+3603 */
  0x1C57,   /* U+3604 */
  0x1C58,   /* U+3605 */
  0x1C58,   /* U+3606 */
  0x1C58,   /* U+3607 */
  0x1C58,   /* U+3608 */
  0x1C59,   /* U+3609 */
  0x1C59,   /* U+360A */
  0x1C59,   /* U+360B */
  0x1C59,   /* U+360C */
  0x1C59,   /* U+360D */
  0x1C59,   /* U+360E */
  0x1C59,   /* U+360F */
  0x1C5A,   /* U+3610 */
  0x1C5A,   /* U+3611 */
  0x1C5A,   /* U+3612 */
  0x1C5B,   /* U+3613 */
  0x1C5B,   /* U+3614 */
  0x1C5C,   /* U+3615 */
  0x1C5C,   /* U+3616 */
  0x1C5C,   /* U+3617 */
  0x1C5D,   /* U+3618 */
  0x1C5E,   /* U+3619 */
  0x1C5E,   /* U+361A */
  0x1C60,   /* U+361B */
  0x1C61,   /* U+361C */
  0x1C4C,   /* U+361D */
  0x1C4C,   /* U+361E */
  0x1C4D,   /* U+361F */
  0x1C4F,   /* U+3620 */
  0x1C4F,   /* U+3621 */
  0x1C50,   /* U+3622 */
  0x1C51,   /* U+3623 */
  0x1C55,   /* U+3624 */
  0x1C5B,   /* U+3625 */
  0x1C4C,   /* U+3626 */
  0x1C4E,   /* U+3627 */
  0x1C4E,   /* U+3628 */
  0x1C4E,   /* U+3629 */
  0x1C4E,   /* U+362A */
  0x1C4E,   /* U+362B */
  0x1C4E,   /* U+362C */
  0x1C4E,   /* U+362D */
  0x1C4E,   /* U+362E */
  0x1C4E,   /* U+362F */
  0x1C4E,   /* U+3630 */
  0x1C4F,   /* U+3631 */
  0x1C4F,   /* U+3632 */
  0x1C4F,   /* U+3633 */
  0x1C4F,   /* U+3634 */
  0x1C4F,   /* U+3635 */
  0x1C50,   /* U+3636 */
  0x1C50,   /* U+3637 */
  0x1C50,   /* U+3638 */
  0x1C50,   /* U+3639 */
  0x1C50,   /* U+363A */
  0x1C50,   /* U+363B */
  0x1C50,   /* U+363C */
  0x1C50,   /* U+363D */
  0x1C50,   /* U+363E */
  0x1C51,   /* U+363F */
  0x1C51,   /* U+3640 */
  0x1C51,   /* U+3641 */
  0x1C51,   /* U+3642 */
  0x1C51,   /* U+3643 */
  0x1C51,   /* U+3644 */
  0x1C51,   /* U+3645 */
  0x1C51,   /* U+3646 */
  0x1C52,   /* U+3647 */
  0x1C52,   /* U+3648 */
  0x1C52,   /* U+3649 */
  0x1C52,   /* U+364A */
  0x1C52,   /* U+364B */
  0x1C52,   /* U+364C */
  0x1C52,   /* U+364D */
  0x1C53,   /* U+364E */
  0x1C53,   /* U+364F */
  0x1C53,   /* U+3650 */
  0x1C53,   /* U+3651 */
  0x1C53,   /* U+3652 */
  0x1C53,   /* U+3653 */
  0x1C53,   /* U+3654 */
  0x1C53,   /* U+3655 */
  0x1C53,   /* U+3656 */
  0x1C53,   /* U+3657 */
  0x1C53,   /* U+3658 */
  0x1C54,   /* U+3659 */
  0x1C54,   /* U+365A */
  0x1C54,   /* U+365B */
  0x1C54,   /* U+365C */
  0x1C54,   /* U+365D */
  0x1C54,   /* U+365E */
  0x1C54,   /* U+365F */
  0x1C55,   /* U+3660 */
  0x1C55,   /* U+3661 */
  0x1C55,   /* U+3662 */
  0x1C55,   /* U+3663 */
  0x1C55,   /* U+3664 */
  0x1C55,   /* U+3665 */
  0x1C55,   /* U+3666 */
  0x1C56,   /* U+3667 */
  0x1C56,   /* U+3668 */
  0x1C56,   /* U+3669 */
  0x1C56,   /* U+366A */
  0x1C56,   /* U+366B */
  0x1C56,   /* U+366C */
  0x1C56,   /* U+366D */
  0x1C56,   /* U+366E */
  0x1C56,   /* U+366F */
  0x1C57,   /* U+3670 */
  0x1C57,   /* U+3671 */
  0x1C57,   /* U+3672 */
  0x1C57,   /* U+3673 */
  0x1C57,   /* U+3674 */
  0x1C57,   /* U+3675 */
  0x1C57,   /* U+3676 */
  0x1C58,   /* U+3677 */
  0x1C58,   /* U+3678 */
  0x1C58,   /* U+3679 */
  0x1C58,   /* U+367A */
  0x1C59,   /* U+367B */
  0x1C59,   /* U+367C */
  0x1C59,   /* U+367D */
  0x1C5A,   /* U+367E */
  0x1C5A,   /* U+367F */
  0x1C5B,   /* U+3680 */
  0x1C5F,   /* U+3681 */
  0x1C60,   /* U+3682 */
  0x1C53,   /* U+3683 */
  0x1C56,   /* U+3684 */
  0x1C50,   /* U+3685 */
  0x1C50,   /* U+3686 */
  0x1C50,   /* U+3687 */
  0x1C4C,   /* U+3688 */
  0x1C4F,   /* U+3689 */
  0x1C53,   /* U+368A */
  0x1C55,   /* U+368B */
  0x1C55,   /* U+368C */
  0x1C59,   /* U+368D */
  0x1C4C,   /* U+368E */
  0x1C4D,   /* U+368F */
  0x1C4D,   /* U+3690 */
  0x1C4D,   /* U+3691 */
  0x1C4E,   /* U+3692 */
  0x1C4E,   /* U+3693 */
  0x1C4F,   /* U+3694 */
  0x1C4F,   /* U+3695 */
  0x1C4F,   /* U+3696 */
  0x1C4F,   /* U+3697 */
  0x1C4F,   /* U+3698 */
  0x1C4F,   /* U+3699 */
  0x1C50,   /* U+369A */
  0x1C50,   /* U+369B */
  0x1C52,   /* U+369C */
  0x1C52,   /* U+369D */
  0x1C52,   /* U+369E */
  0x1C53,   /* U+369F */
  0x1C54,   /* U+36A0 */
  0x1C57,   /* U+36A1 */
  0x1C4C,   /* U+36A2 */
  0x1C4D,   /* U+36A3 */
  0x1C4D,   /* U+36A4 */
  0x1C4D,   /* U+36A5 */
  0x1C4D,   /* U+36A6 */
  0x1C4D,   /* U+36A7 */
  0x1C4D,   /* U+36A8 */
  0x1C4E,   /* U+36A9 */
  0x1C4E,   /* U+36AA */
  0x1C4E,   /* U+36AB */
  0x1C4E,   /* U+36AC */
  0x1C4E,   /* U+36AD */
  0x1C4E,   /* U+36AE */
  0x1C4E,   /* U+36AF */
  0x1C4F,   /* U+36B0 */
  0x1C4F,   /* U+36B1 */
  0x1C4F,   /* U+36B2 */
  0x1C4F,   /* U+36B3 */
  0x1C4F,   /* U+36B4 */
  0x1C4F,   /* U+36B5 */
  0x1C4F,   /* U+36B6 */
  0x1C4F,   /* U+36B7 */
  0x1C4F,   /* U+36B8 */
  0x1C4F,   /* U+36B9 */
  0x1C4F,   /* U+36BA */
  0x1C4F,   /* U+36BB */
  0x1C4F,   /* U+36BC */
  0x1C4F,   /* U+36BD */
  0x1C4F,   /* U+36BE */
  0x1C4F,   /* U+36BF */
  0x1C4F,   /* U+36C0 */
  0x1C4F,   /* U+36C1 */
  0x1C50,   /* U+36C2 */
  0x1C50,   /* U+36C3 */
  0x1C50,   /* U+36C4 */
  0x1C50,   /* U+36C5 */
  0x1C50,   /* U+36C6 */
  0x1C50,   /* U+36C7 */
  0x1C50,   /* U+36C8 */
  0x1C50,   /* U+36C9 */
  0x1C50,   /* U+36CA */
  0x1C50,   /* U+36CB */
  0x1C50,   /* U+36CC */
  0x1C51,   /* U+36CD */
  0x1C51,   /* U+36CE */
  0x1C51,   /* U+36CF */
  0x1C51,   /* U+36D0 */
  0x1C51,   /* U+36D1 */
  0x1C51,   /* U+36D2 */
  0x1C51,   /* U+36D3 */
  0x1C51,   /* U+36D4 */
  0x1C51,   /* U+36D5 */
  0x1C51,   /* U+36D6 */
  0x1C51,   /* U+36D7 */
  0x1C51,   /* U+36D8 */
  0x1C51,   /* U+36D9 */
  0x1C51,   /* U+36DA */
  0x1C51,   /* U+36DB */
  0x1C51,   /* U+36DC */
  0x1C51,   /* U+36DD */
  0x1C51,   /* U+36DE */
  0x1C51,   /* U+36DF */
  0x1C4E,   /* U+36E0 */
  0x1C51,   /* U+36E1 */
  0x1C51,   /* U+36E2 */
  0x1C51,   /* U+36E3 */
  0x1C51,   /* U+36E4 */
  0x1C52,   /* U+36E5 */
  0x1C52,   /* U+36E6 */
  0x1C52,   /* U+36E7 */
  0x1C52,   /* U+36E8 */
  0x1C52,   /* U+36E9 */
  0x1C52,   /* U+36EA */
  0x1C52,   /* U+36EB */
  0x1C52,   /* U+36EC */
  0x1C52,   /* U+36ED */
  0x1C53,   /* U+36EE */
  0x1C53,   /* U+36EF */
  0x1C53,   /* U+36F0 */
  0x1C53,   /* U+36F1 */
  0x1C53,   /* U+36F2 */
  0x1C53,   /* U+36F3 */
  0x1C53,   /* U+36F4 */
  0x1C53,   /* U+36F5 */
  0x1C53,   /* U+36F6 */
  0x1C53,   /* U+36F7 */
  0x1C53,   /* U+36F8 */
  0x1C53,   /* U+36F9 */
  0x1C53,   /* U+36FA */
  0x1C53,   /* U+36FB */
  0x1C53,   /* U+36FC */
  0x1C53,   /* U+36FD */
  0x1C53,   /* U+36FE */
  0x1C53,   /* U+36FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3600 */
  0x0020,   /* U+3601 */
  0x0020,   /* U+3602 */
  0x0020,   /* U+3603 */
  0x0020,   /* U+3604 */
  0x0020,   /* U+3605 */
  0x0020,   /* U+3606 */
  0x0020,   /* U+3607 */
  0x0020,   /* U+3608 */
  0x0020,   /* U+3609 */
  0x0020,   /* U+360A */
  0x0020,   /* U+360B */
  0x0020,   /* U+360C */
  0x0020,   /* U+360D */
  0x0020,   /* U+360E */
  0x0020,   /* U+360F */
  0x0020,   /* U+3610 */
  0x0020,   /* U+3611 */
  0x0020,   /* U+3612 */
  0x0020,   /* U+3613 */
  0x0020,   /* U+3614 */
  0x0020,   /* U+3615 */
  0x0020,   /* U+3616 */
  0x0020,   /* U+3617 */
  0x0020,   /* U+3618 */
  0x0020,   /* U+3619 */
  0x0020,   /* U+361A */
  0x0020,   /* U+361B */
  0x0020,   /* U+361C */
  0x0020,   /* U+361D */
  0x0020,   /* U+361E */
  0x0020,   /* U+361F */
  0x0020,   /* U+3620 */
  0x0020,   /* U+3621 */
  0x0020,   /* U+3622 */
  0x0020,   /* U+3623 */
  0x0020,   /* U+3624 */
  0x0020,   /* U+3625 */
  0x0020,   /* U+3626 */
  0x0020,   /* U+3627 */
  0x0020,   /* U+3628 */
  0x0020,   /* U+3629 */
  0x0020,   /* U+362A */
  0x0020,   /* U+362B */
  0x0020,   /* U+362C */
  0x0020,   /* U+362D */
  0x0020,   /* U+362E */
  0x0020,   /* U+362F */
  0x0020,   /* U+3630 */
  0x0020,   /* U+3631 */
  0x0020,   /* U+3632 */
  0x0020,   /* U+3633 */
  0x0020,   /* U+3634 */
  0x0020,   /* U+3635 */
  0x0020,   /* U+3636 */
  0x0020,   /* U+3637 */
  0x0020,   /* U+3638 */
  0x0020,   /* U+3639 */
  0x0020,   /* U+363A */
  0x0020,   /* U+363B */
  0x0020,   /* U+363C */
  0x0020,   /* U+363D */
  0x0020,   /* U+363E */
  0x0020,   /* U+363F */
  0x0020,   /* U+3640 */
  0x0020,   /* U+3641 */
  0x0020,   /* U+3642 */
  0x0020,   /* U+3643 */
  0x0020,   /* U+3644 */
  0x0020,   /* U+3645 */
  0x0020,   /* U+3646 */
  0x0020,   /* U+3647 */
  0x0020,   /* U+3648 */
  0x0020,   /* U+3649 */
  0x0020,   /* U+364A */
  0x0020,   /* U+364B */
  0x0020,   /* U+364C */
  0x0020,   /* U+364D */
  0x0020,   /* U+364E */
  0x0020,   /* U+364F */
  0x0020,   /* U+3650 */
  0x0020,   /* U+3651 */
  0x0020,   /* U+3652 */
  0x0020,   /* U+3653 */
  0x0020,   /* U+3654 */
  0x0020,   /* U+3655 */
  0x0020,   /* U+3656 */
  0x0020,   /* U+3657 */
  0x0020,   /* U+3658 */
  0x0020,   /* U+3659 */
  0x0020,   /* U+365A */
  0x0020,   /* U+365B */
  0x0020,   /* U+365C */
  0x0020,   /* U+365D */
  0x0020,   /* U+365E */
  0x0020,   /* U+365F */
  0x0020,   /* U+3660 */
  0x0020,   /* U+3661 */
  0x0020,   /* U+3662 */
  0x0020,   /* U+3663 */
  0x0020,   /* U+3664 */
  0x0020,   /* U+3665 */
  0x0020,   /* U+3666 */
  0x0020,   /* U+3667 */
  0x0020,   /* U+3668 */
  0x0020,   /* U+3669 */
  0x0020,   /* U+366A */
  0x0020,   /* U+366B */
  0x0020,   /* U+366C */
  0x0020,   /* U+366D */
  0x0020,   /* U+366E */
  0x0020,   /* U+366F */
  0x0020,   /* U+3670 */
  0x0020,   /* U+3671 */
  0x0020,   /* U+3672 */
  0x0020,   /* U+3673 */
  0x0020,   /* U+3674 */
  0x0020,   /* U+3675 */
  0x0020,   /* U+3676 */
  0x0020,   /* U+3677 */
  0x0020,   /* U+3678 */
  0x0020,   /* U+3679 */
  0x0020,   /* U+367A */
  0x0020,   /* U+367B */
  0x0020,   /* U+367C */
  0x0020,   /* U+367D */
  0x0020,   /* U+367E */
  0x0020,   /* U+367F */
  0x0020,   /* U+3680 */
  0x0020,   /* U+3681 */
  0x0020,   /* U+3682 */
  0x0020,   /* U+3683 */
  0x0020,   /* U+3684 */
  0x0020,   /* U+3685 */
  0x0020,   /* U+3686 */
  0x0020,   /* U+3687 */
  0x0020,   /* U+3688 */
  0x0020,   /* U+3689 */
  0x0020,   /* U+368A */
  0x0020,   /* U+368B */
  0x0020,   /* U+368C */
  0x0020,   /* U+368D */
  0x0020,   /* U+368E */
  0x0020,   /* U+368F */
  0x0020,   /* U+3690 */
  0x0020,   /* U+3691 */
  0x0020,   /* U+3692 */
  0x0020,   /* U+3693 */
  0x0020,   /* U+3694 */
  0x0020,   /* U+3695 */
  0x0020,   /* U+3696 */
  0x0020,   /* U+3697 */
  0x0020,   /* U+3698 */
  0x0020,   /* U+3699 */
  0x0020,   /* U+369A */
  0x0020,   /* U+369B */
  0x0020,   /* U+369C */
  0x0020,   /* U+369D */
  0x0020,   /* U+369E */
  0x0020,   /* U+369F */
  0x0020,   /* U+36A0 */
  0x0020,   /* U+36A1 */
  0x0020,   /* U+36A2 */
  0x0020,   /* U+36A3 */
  0x0020,   /* U+36A4 */
  0x0020,   /* U+36A5 */
  0x0020,   /* U+36A6 */
  0x0020,   /* U+36A7 */
  0x0020,   /* U+36A8 */
  0x0020,   /* U+36A9 */
  0x0020,   /* U+36AA */
  0x0020,   /* U+36AB */
  0x0020,   /* U+36AC */
  0x0020,   /* U+36AD */
  0x0020,   /* U+36AE */
  0x0020,   /* U+36AF */
  0x0020,   /* U+36B0 */
  0x0020,   /* U+36B1 */
  0x0020,   /* U+36B2 */
  0x0020,   /* U+36B3 */
  0x0020,   /* U+36B4 */
  0x0020,   /* U+36B5 */
  0x0020,   /* U+36B6 */
  0x0020,   /* U+36B7 */
  0x0020,   /* U+36B8 */
  0x0020,   /* U+36B9 */
  0x0020,   /* U+36BA */
  0x0020,   /* U+36BB */
  0x0020,   /* U+36BC */
  0x0020,   /* U+36BD */
  0x0020,   /* U+36BE */
  0x0020,   /* U+36BF */
  0x0020,   /* U+36C0 */
  0x0020,   /* U+36C1 */
  0x0020,   /* U+36C2 */
  0x0020,   /* U+36C3 */
  0x0020,   /* U+36C4 */
  0x0020,   /* U+36C5 */
  0x0020,   /* U+36C6 */
  0x0020,   /* U+36C7 */
  0x0020,   /* U+36C8 */
  0x0020,   /* U+36C9 */
  0x0020,   /* U+36CA */
  0x0020,   /* U+36CB */
  0x0020,   /* U+36CC */
  0x0020,   /* U+36CD */
  0x0020,   /* U+36CE */
  0x0020,   /* U+36CF */
  0x0020,   /* U+36D0 */
  0x0020,   /* U+36D1 */
  0x0020,   /* U+36D2 */
  0x0020,   /* U+36D3 */
  0x0020,   /* U+36D4 */
  0x0020,   /* U+36D5 */
  0x0020,   /* U+36D6 */
  0x0020,   /* U+36D7 */
  0x0020,   /* U+36D8 */
  0x0020,   /* U+36D9 */
  0x0020,   /* U+36DA */
  0x0020,   /* U+36DB */
  0x0020,   /* U+36DC */
  0x0020,   /* U+36DD */
  0x0020,   /* U+36DE */
  0x0020,   /* U+36DF */
  0x0020,   /* U+36E0 */
  0x0020,   /* U+36E1 */
  0x0020,   /* U+36E2 */
  0x0020,   /* U+36E3 */
  0x0020,   /* U+36E4 */
  0x0020,   /* U+36E5 */
  0x0020,   /* U+36E6 */
  0x0020,   /* U+36E7 */
  0x0020,   /* U+36E8 */
  0x0020,   /* U+36E9 */
  0x0020,   /* U+36EA */
  0x0020,   /* U+36EB */
  0x0020,   /* U+36EC */
  0x0020,   /* U+36ED */
  0x0020,   /* U+36EE */
  0x0020,   /* U+36EF */
  0x0020,   /* U+36F0 */
  0x0020,   /* U+36F1 */
  0x0020,   /* U+36F2 */
  0x0020,   /* U+36F3 */
  0x0020,   /* U+36F4 */
  0x0020,   /* U+36F5 */
  0x0020,   /* U+36F6 */
  0x0020,   /* U+36F7 */
  0x0020,   /* U+36F8 */
  0x0020,   /* U+36F9 */
  0x0020,   /* U+36FA */
  0x0020,   /* U+36FB */
  0x0020,   /* U+36FC */
  0x0020,   /* U+36FD */
  0x0020,   /* U+36FE */
  0x0020,   /* U+36FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3600 */
  0x0002,   /* U+3601 */
  0x0002,   /* U+3602 */
  0x0002,   /* U+3603 */
  0x0002,   /* U+3604 */
  0x0002,   /* U+3605 */
  0x0002,   /* U+3606 */
  0x0002,   /* U+3607 */
  0x0002,   /* U+3608 */
  0x0002,   /* U+3609 */
  0x0002,   /* U+360A */
  0x0002,   /* U+360B */
  0x0002,   /* U+360C */
  0x0002,   /* U+360D */
  0x0002,   /* U+360E */
  0x0002,   /* U+360F */
  0x0002,   /* U+3610 */
  0x0002,   /* U+3611 */
  0x0002,   /* U+3612 */
  0x0002,   /* U+3613 */
  0x0002,   /* U+3614 */
  0x0002,   /* U+3615 */
  0x0002,   /* U+3616 */
  0x0002,   /* U+3617 */
  0x0002,   /* U+3618 */
  0x0002,   /* U+3619 */
  0x0002,   /* U+361A */
  0x0002,   /* U+361B */
  0x0002,   /* U+361C */
  0x0002,   /* U+361D */
  0x0002,   /* U+361E */
  0x0002,   /* U+361F */
  0x0002,   /* U+3620 */
  0x0002,   /* U+3621 */
  0x0002,   /* U+3622 */
  0x0002,   /* U+3623 */
  0x0002,   /* U+3624 */
  0x0002,   /* U+3625 */
  0x0002,   /* U+3626 */
  0x0002,   /* U+3627 */
  0x0002,   /* U+3628 */
  0x0002,   /* U+3629 */
  0x0002,   /* U+362A */
  0x0002,   /* U+362B */
  0x0002,   /* U+362C */
  0x0002,   /* U+362D */
  0x0002,   /* U+362E */
  0x0002,   /* U+362F */
  0x0002,   /* U+3630 */
  0x0002,   /* U+3631 */
  0x0002,   /* U+3632 */
  0x0002,   /* U+3633 */
  0x0002,   /* U+3634 */
  0x0002,   /* U+3635 */
  0x0002,   /* U+3636 */
  0x0002,   /* U+3637 */
  0x0002,   /* U+3638 */
  0x0002,   /* U+3639 */
  0x0002,   /* U+363A */
  0x0002,   /* U+363B */
  0x0002,   /* U+363C */
  0x0002,   /* U+363D */
  0x0002,   /* U+363E */
  0x0002,   /* U+363F */
  0x0002,   /* U+3640 */
  0x0002,   /* U+3641 */
  0x0002,   /* U+3642 */
  0x0002,   /* U+3643 */
  0x0002,   /* U+3644 */
  0x0002,   /* U+3645 */
  0x0002,   /* U+3646 */
  0x0002,   /* U+3647 */
  0x0002,   /* U+3648 */
  0x0002,   /* U+3649 */
  0x0002,   /* U+364A */
  0x0002,   /* U+364B */
  0x0002,   /* U+364C */
  0x0002,   /* U+364D */
  0x0002,   /* U+364E */
  0x0002,   /* U+364F */
  0x0002,   /* U+3650 */
  0x0002,   /* U+3651 */
  0x0002,   /* U+3652 */
  0x0002,   /* U+3653 */
  0x0002,   /* U+3654 */
  0x0002,   /* U+3655 */
  0x0002,   /* U+3656 */
  0x0002,   /* U+3657 */
  0x0002,   /* U+3658 */
  0x0002,   /* U+3659 */
  0x0002,   /* U+365A */
  0x0002,   /* U+365B */
  0x0002,   /* U+365C */
  0x0002,   /* U+365D */
  0x0002,   /* U+365E */
  0x0002,   /* U+365F */
  0x0002,   /* U+3660 */
  0x0002,   /* U+3661 */
  0x0002,   /* U+3662 */
  0x0002,   /* U+3663 */
  0x0002,   /* U+3664 */
  0x0002,   /* U+3665 */
  0x0002,   /* U+3666 */
  0x0002,   /* U+3667 */
  0x0002,   /* U+3668 */
  0x0002,   /* U+3669 */
  0x0002,   /* U+366A */
  0x0002,   /* U+366B */
  0x0002,   /* U+366C */
  0x0002,   /* U+366D */
  0x0002,   /* U+366E */
  0x0002,   /* U+366F */
  0x0002,   /* U+3670 */
  0x0002,   /* U+3671 */
  0x0002,   /* U+3672 */
  0x0002,   /* U+3673 */
  0x0002,   /* U+3674 */
  0x0002,   /* U+3675 */
  0x0002,   /* U+3676 */
  0x0002,   /* U+3677 */
  0x0002,   /* U+3678 */
  0x0002,   /* U+3679 */
  0x0002,   /* U+367A */
  0x0002,   /* U+367B */
  0x0002,   /* U+367C */
  0x0002,   /* U+367D */
  0x0002,   /* U+367E */
  0x0002,   /* U+367F */
  0x0002,   /* U+3680 */
  0x0002,   /* U+3681 */
  0x0002,   /* U+3682 */
  0x0002,   /* U+3683 */
  0x0002,   /* U+3684 */
  0x0002,   /* U+3685 */
  0x0002,   /* U+3686 */
  0x0002,   /* U+3687 */
  0x0002,   /* U+3688 */
  0x0002,   /* U+3689 */
  0x0002,   /* U+368A */
  0x0002,   /* U+368B */
  0x0002,   /* U+368C */
  0x0002,   /* U+368D */
  0x0002,   /* U+368E */
  0x0002,   /* U+368F */
  0x0002,   /* U+3690 */
  0x0002,   /* U+3691 */
  0x0002,   /* U+3692 */
  0x0002,   /* U+3693 */
  0x0002,   /* U+3694 */
  0x0002,   /* U+3695 */
  0x0002,   /* U+3696 */
  0x0002,   /* U+3697 */
  0x0002,   /* U+3698 */
  0x0002,   /* U+3699 */
  0x0002,   /* U+369A */
  0x0002,   /* U+369B */
  0x0002,   /* U+369C */
  0x0002,   /* U+369D */
  0x0002,   /* U+369E */
  0x0002,   /* U+369F */
  0x0002,   /* U+36A0 */
  0x0002,   /* U+36A1 */
  0x0002,   /* U+36A2 */
  0x0002,   /* U+36A3 */
  0x0002,   /* U+36A4 */
  0x0002,   /* U+36A5 */
  0x0002,   /* U+36A6 */
  0x0002,   /* U+36A7 */
  0x0002,   /* U+36A8 */
  0x0002,   /* U+36A9 */
  0x0002,   /* U+36AA */
  0x0002,   /* U+36AB */
  0x0002,   /* U+36AC */
  0x0002,   /* U+36AD */
  0x0002,   /* U+36AE */
  0x0002,   /* U+36AF */
  0x0002,   /* U+36B0 */
  0x0002,   /* U+36B1 */
  0x0002,   /* U+36B2 */
  0x0002,   /* U+36B3 */
  0x0002,   /* U+36B4 */
  0x0002,   /* U+36B5 */
  0x0002,   /* U+36B6 */
  0x0002,   /* U+36B7 */
  0x0002,   /* U+36B8 */
  0x0002,   /* U+36B9 */
  0x0002,   /* U+36BA */
  0x0002,   /* U+36BB */
  0x0002,   /* U+36BC */
  0x0002,   /* U+36BD */
  0x0002,   /* U+36BE */
  0x0002,   /* U+36BF */
  0x0002,   /* U+36C0 */
  0x0002,   /* U+36C1 */
  0x0002,   /* U+36C2 */
  0x0002,   /* U+36C3 */
  0x0002,   /* U+36C4 */
  0x0002,   /* U+36C5 */
  0x0002,   /* U+36C6 */
  0x0002,   /* U+36C7 */
  0x0002,   /* U+36C8 */
  0x0002,   /* U+36C9 */
  0x0002,   /* U+36CA */
  0x0002,   /* U+36CB */
  0x0002,   /* U+36CC */
  0x0002,   /* U+36CD */
  0x0002,   /* U+36CE */
  0x0002,   /* U+36CF */
  0x0002,   /* U+36D0 */
  0x0002,   /* U+36D1 */
  0x0002,   /* U+36D2 */
  0x0002,   /* U+36D3 */
  0x0002,   /* U+36D4 */
  0x0002,   /* U+36D5 */
  0x0002,   /* U+36D6 */
  0x0002,   /* U+36D7 */
  0x0002,   /* U+36D8 */
  0x0002,   /* U+36D9 */
  0x0002,   /* U+36DA */
  0x0002,   /* U+36DB */
  0x0002,   /* U+36DC */
  0x0002,   /* U+36DD */
  0x0002,   /* U+36DE */
  0x0002,   /* U+36DF */
  0x0002,   /* U+36E0 */
  0x0002,   /* U+36E1 */
  0x0002,   /* U+36E2 */
  0x0002,   /* U+36E3 */
  0x0002,   /* U+36E4 */
  0x0002,   /* U+36E5 */
  0x0002,   /* U+36E6 */
  0x0002,   /* U+36E7 */
  0x0002,   /* U+36E8 */
  0x0002,   /* U+36E9 */
  0x0002,   /* U+36EA */
  0x0002,   /* U+36EB */
  0x0002,   /* U+36EC */
  0x0002,   /* U+36ED */
  0x0002,   /* U+36EE */
  0x0002,   /* U+36EF */
  0x0002,   /* U+36F0 */
  0x0002,   /* U+36F1 */
  0x0002,   /* U+36F2 */
  0x0002,   /* U+36F3 */
  0x0002,   /* U+36F4 */
  0x0002,   /* U+36F5 */
  0x0002,   /* U+36F6 */
  0x0002,   /* U+36F7 */
  0x0002,   /* U+36F8 */
  0x0002,   /* U+36F9 */
  0x0002,   /* U+36FA */
  0x0002,   /* U+36FB */
  0x0002,   /* U+36FC */
  0x0002,   /* U+36FD */
  0x0002,   /* U+36FE */
  0x0002,   /* U+36FF */

  /* Primary weight 2 for each character. */
  0x80F5,   /* U+3600 */
  0x80F6,   /* U+3601 */
  0x80F7,   /* U+3602 */
  0x80F8,   /* U+3603 */
  0x80F9,   /* U+3604 */
  0x80C8,   /* U+3605 */
  0x80C9,   /* U+3606 */
  0x80CA,   /* U+3607 */
  0x80CB,   /* U+3608 */
  0x809A,   /* U+3609 */
  0x809B,   /* U+360A */
  0x809C,   /* U+360B */
  0x809D,   /* U+360C */
  0x809E,   /* U+360D */
  0x809F,   /* U+360E */
  0x80A0,   /* U+360F */
  0x8061,   /* U+3610 */
  0x8062,   /* U+3611 */
  0x8063,   /* U+3612 */
  0x8047,   /* U+3613 */
  0x8048,   /* U+3614 */
  0x8040,   /* U+3615 */
  0x8041,   /* U+3616 */
  0x8042,   /* U+3617 */
  0x8025,   /* U+3618 */
  0x8023,   /* U+3619 */
  0x8024,   /* U+361A */
  0x8009,   /* U+361B */
  0x800D,   /* U+361C */
  0x817A,   /* U+361D */
  0x80F0,   /* U+361E */
  0x827C,   /* U+361F */
  0x8338,   /* U+3620 */
  0x8339,   /* U+3621 */
  0x835A,   /* U+3622 */
  0x83BD,   /* U+3623 */
  0x82E1,   /* U+3624 */
  0x8084,   /* U+3625 */
  0x8189,   /* U+3626 */
  0x8327,   /* U+3627 */
  0x8328,   /* U+3628 */
  0x8329,   /* U+3629 */
  0x832A,   /* U+362A */
  0x832B,   /* U+362B */
  0x832C,   /* U+362C */
  0x832D,   /* U+362D */
  0x832E,   /* U+362E */
  0x832F,   /* U+362F */
  0x8330,   /* U+3630 */
  0x8374,   /* U+3631 */
  0x8375,   /* U+3632 */
  0x8376,   /* U+3633 */
  0x8377,   /* U+3634 */
  0x8378,   /* U+3635 */
  0x839B,   /* U+3636 */
  0x839C,   /* U+3637 */
  0x839D,   /* U+3638 */
  0x839E,   /* U+3639 */
  0x839F,   /* U+363A */
  0x83A0,   /* U+363B */
  0x83A1,   /* U+363C */
  0x83A2,   /* U+363D */
  0x83A3,   /* U+363E */
  0x83FD,   /* U+363F */
  0x83FE,   /* U+3640 */
  0x83FF,   /* U+3641 */
  0x8400,   /* U+3642 */
  0x8401,   /* U+3643 */
  0x8402,   /* U+3644 */
  0x8403,   /* U+3645 */
  0x8404,   /* U+3646 */
  0x83CB,   /* U+3647 */
  0x83CC,   /* U+3648 */
  0x83CD,   /* U+3649 */
  0x83CE,   /* U+364A */
  0x83CF,   /* U+364B */
  0x83D0,   /* U+364C */
  0x83D1,   /* U+364D */
  0x837A,   /* U+364E */
  0x837B,   /* U+364F */
  0x837C,   /* U+3650 */
  0x837D,   /* U+3651 */
  0x837E,   /* U+3652 */
  0x837F,   /* U+3653 */
  0x8380,   /* U+3654 */
  0x8381,   /* U+3655 */
  0x8382,   /* U+3656 */
  0x8383,   /* U+3657 */
  0x8384,   /* U+3658 */
  0x833F,   /* U+3659 */
  0x8340,   /* U+365A */
  0x8341,   /* U+365B */
  0x8342,   /* U+365C */
  0x8343,   /* U+365D */
  0x8344,   /* U+365E */
  0x8345,   /* U+365F */
  0x8320,   /* U+3660 */
  0x8321,   /* U+3661 */
  0x8322,   /* U+3662 */
  0x8323,   /* U+3663 */
  0x8324,   /* U+3664 */
  0x8325,   /* U+3665 */
  0x8326,   /* U+3666 */
  0x8240,   /* U+3667 */
  0x8241,   /* U+3668 */
  0x8242,   /* U+3669 */
  0x8243,   /* U+366A */
  0x8244,   /* U+366B */
  0x8245,   /* U+366C */
  0x8246,   /* U+366D */
  0x8247,   /* U+366E */
  0x8248,   /* U+366F */
  0x81C7,   /* U+3670 */
  0x81C8,   /* U+3671 */
  0x81C9,   /* U+3672 */
  0x81CA,   /* U+3673 */
  0x81CB,   /* U+3674 */
  0x81CC,   /* U+3675 */
  0x81CD,   /* U+3676 */
  0x8156,   /* U+3677 */
  0x8157,   /* U+3678 */
  0x8158,   /* U+3679 */
  0x8159,   /* U+367A */
  0x812E,   /* U+367B */
  0x812F,   /* U+367C */
  0x8130,   /* U+367D */
  0x80C8,   /* U+367E */
  0x80C9,   /* U+367F */
  0x808D,   /* U+3680 */
  0x802D,   /* U+3681 */
  0x8019,   /* U+3682 */
  0x840D,   /* U+3683 */
  0x82B3,   /* U+3684 */
  0x8407,   /* U+3685 */
  0x840A,   /* U+3686 */
  0x840B,   /* U+3687 */
  0x81A4,   /* U+3688 */
  0x83D4,   /* U+3689 */
  0x8417,   /* U+368A */
  0x83A2,   /* U+368B */
  0x83A3,   /* U+368C */
  0x816F,   /* U+368D */
  0x81AF,   /* U+368E */
  0x82CF,   /* U+368F */
  0x82D0,   /* U+3690 */
  0x82D1,   /* U+3691 */
  0x839A,   /* U+3692 */
  0x839B,   /* U+3693 */
  0x83E6,   /* U+3694 */
  0x83E7,   /* U+3695 */
  0x83E8,   /* U+3696 */
  0x83E9,   /* U+3697 */
  0x83EA,   /* U+3698 */
  0x83EB,   /* U+3699 */
  0x841A,   /* U+369A */
  0x841B,   /* U+369B */
  0x8465,   /* U+369C */
  0x8466,   /* U+369D */
  0x8467,   /* U+369E */
  0x8431,   /* U+369F */
  0x83D9,   /* U+36A0 */
  0x8222,   /* U+36A1 */
  0x81BD,   /* U+36A2 */
  0x82F1,   /* U+36A3 */
  0x82F2,   /* U+36A4 */
  0x82F3,   /* U+36A5 */
  0x82F4,   /* U+36A6 */
  0x82F5,   /* U+36A7 */
  0x82F6,   /* U+36A8 */
  0x83DA,   /* U+36A9 */
  0x83DB,   /* U+36AA */
  0x83DC,   /* U+36AB */
  0x83DD,   /* U+36AC */
  0x83DE,   /* U+36AD */
  0x83DF,   /* U+36AE */
  0x83E0,   /* U+36AF */
  0x8441,   /* U+36B0 */
  0x8442,   /* U+36B1 */
  0x8443,   /* U+36B2 */
  0x8444,   /* U+36B3 */
  0x8445,   /* U+36B4 */
  0x8446,   /* U+36B5 */
  0x8447,   /* U+36B6 */
  0x8448,   /* U+36B7 */
  0x8449,   /* U+36B8 */
  0x844A,   /* U+36B9 */
  0x844B,   /* U+36BA */
  0x844C,   /* U+36BB */
  0x844D,   /* U+36BC */
  0x844E,   /* U+36BD */
  0x844F,   /* U+36BE */
  0x8450,   /* U+36BF */
  0x8451,   /* U+36C0 */
  0x8452,   /* U+36C1 */
  0x8467,   /* U+36C2 */
  0x8468,   /* U+36C3 */
  0x8469,   /* U+36C4 */
  0x846A,   /* U+36C5 */
  0x846B,   /* U+36C6 */
  0x846C,   /* U+36C7 */
  0x846D,   /* U+36C8 */
  0x846E,   /* U+36C9 */
  0x846F,   /* U+36CA */
  0x8470,   /* U+36CB */
  0x8471,   /* U+36CC */
  0x84EC,   /* U+36CD */
  0x84ED,   /* U+36CE */
  0x84EE,   /* U+36CF */
  0x84EF,   /* U+36D0 */
  0x84F0,   /* U+36D1 */
  0x84F1,   /* U+36D2 */
  0x84F2,   /* U+36D3 */
  0x84F3,   /* U+36D4 */
  0x84F4,   /* U+36D5 */
  0x84F5,   /* U+36D6 */
  0x84F6,   /* U+36D7 */
  0x84F7,   /* U+36D8 */
  0x84F8,   /* U+36D9 */
  0x84F9,   /* U+36DA */
  0x84FA,   /* U+36DB */
  0x84FB,   /* U+36DC */
  0x84FC,   /* U+36DD */
  0x84FD,   /* U+36DE */
  0x84FE,   /* U+36DF */
  0x83E1,   /* U+36E0 */
  0x84FF,   /* U+36E1 */
  0x8500,   /* U+36E2 */
  0x8501,   /* U+36E3 */
  0x8502,   /* U+36E4 */
  0x84CD,   /* U+36E5 */
  0x84CE,   /* U+36E6 */
  0x84CF,   /* U+36E7 */
  0x84D0,   /* U+36E8 */
  0x84D1,   /* U+36E9 */
  0x84D2,   /* U+36EA */
  0x84D3,   /* U+36EB */
  0x84D4,   /* U+36EC */
  0x84D5,   /* U+36ED */
  0x8493,   /* U+36EE */
  0x8494,   /* U+36EF */
  0x8495,   /* U+36F0 */
  0x8496,   /* U+36F1 */
  0x8497,   /* U+36F2 */
  0x8498,   /* U+36F3 */
  0x8499,   /* U+36F4 */
  0x849A,   /* U+36F5 */
  0x849B,   /* U+36F6 */
  0x849C,   /* U+36F7 */
  0x849D,   /* U+36F8 */
  0x849E,   /* U+36F9 */
  0x849F,   /* U+36FA */
  0x84A0,   /* U+36FB */
  0x84A1,   /* U+36FC */
  0x84A2,   /* U+36FD */
  0x84A3,   /* U+36FE */
  0x84A4,   /* U+36FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3600 */
  0x0000,   /* U+3601 */
  0x0000,   /* U+3602 */
  0x0000,   /* U+3603 */
  0x0000,   /* U+3604 */
  0x0000,   /* U+3605 */
  0x0000,   /* U+3606 */
  0x0000,   /* U+3607 */
  0x0000,   /* U+3608 */
  0x0000,   /* U+3609 */
  0x0000,   /* U+360A */
  0x0000,   /* U+360B */
  0x0000,   /* U+360C */
  0x0000,   /* U+360D */
  0x0000,   /* U+360E */
  0x0000,   /* U+360F */
  0x0000,   /* U+3610 */
  0x0000,   /* U+3611 */
  0x0000,   /* U+3612 */
  0x0000,   /* U+3613 */
  0x0000,   /* U+3614 */
  0x0000,   /* U+3615 */
  0x0000,   /* U+3616 */
  0x0000,   /* U+3617 */
  0x0000,   /* U+3618 */
  0x0000,   /* U+3619 */
  0x0000,   /* U+361A */
  0x0000,   /* U+361B */
  0x0000,   /* U+361C */
  0x0000,   /* U+361D */
  0x0000,   /* U+361E */
  0x0000,   /* U+361F */
  0x0000,   /* U+3620 */
  0x0000,   /* U+3621 */
  0x0000,   /* U+3622 */
  0x0000,   /* U+3623 */
  0x0000,   /* U+3624 */
  0x0000,   /* U+3625 */
  0x0000,   /* U+3626 */
  0x0000,   /* U+3627 */
  0x0000,   /* U+3628 */
  0x0000,   /* U+3629 */
  0x0000,   /* U+362A */
  0x0000,   /* U+362B */
  0x0000,   /* U+362C */
  0x0000,   /* U+362D */
  0x0000,   /* U+362E */
  0x0000,   /* U+362F */
  0x0000,   /* U+3630 */
  0x0000,   /* U+3631 */
  0x0000,   /* U+3632 */
  0x0000,   /* U+3633 */
  0x0000,   /* U+3634 */
  0x0000,   /* U+3635 */
  0x0000,   /* U+3636 */
  0x0000,   /* U+3637 */
  0x0000,   /* U+3638 */
  0x0000,   /* U+3639 */
  0x0000,   /* U+363A */
  0x0000,   /* U+363B */
  0x0000,   /* U+363C */
  0x0000,   /* U+363D */
  0x0000,   /* U+363E */
  0x0000,   /* U+363F */
  0x0000,   /* U+3640 */
  0x0000,   /* U+3641 */
  0x0000,   /* U+3642 */
  0x0000,   /* U+3643 */
  0x0000,   /* U+3644 */
  0x0000,   /* U+3645 */
  0x0000,   /* U+3646 */
  0x0000,   /* U+3647 */
  0x0000,   /* U+3648 */
  0x0000,   /* U+3649 */
  0x0000,   /* U+364A */
  0x0000,   /* U+364B */
  0x0000,   /* U+364C */
  0x0000,   /* U+364D */
  0x0000,   /* U+364E */
  0x0000,   /* U+364F */
  0x0000,   /* U+3650 */
  0x0000,   /* U+3651 */
  0x0000,   /* U+3652 */
  0x0000,   /* U+3653 */
  0x0000,   /* U+3654 */
  0x0000,   /* U+3655 */
  0x0000,   /* U+3656 */
  0x0000,   /* U+3657 */
  0x0000,   /* U+3658 */
  0x0000,   /* U+3659 */
  0x0000,   /* U+365A */
  0x0000,   /* U+365B */
  0x0000,   /* U+365C */
  0x0000,   /* U+365D */
  0x0000,   /* U+365E */
  0x0000,   /* U+365F */
  0x0000,   /* U+3660 */
  0x0000,   /* U+3661 */
  0x0000,   /* U+3662 */
  0x0000,   /* U+3663 */
  0x0000,   /* U+3664 */
  0x0000,   /* U+3665 */
  0x0000,   /* U+3666 */
  0x0000,   /* U+3667 */
  0x0000,   /* U+3668 */
  0x0000,   /* U+3669 */
  0x0000,   /* U+366A */
  0x0000,   /* U+366B */
  0x0000,   /* U+366C */
  0x0000,   /* U+366D */
  0x0000,   /* U+366E */
  0x0000,   /* U+366F */
  0x0000,   /* U+3670 */
  0x0000,   /* U+3671 */
  0x0000,   /* U+3672 */
  0x0000,   /* U+3673 */
  0x0000,   /* U+3674 */
  0x0000,   /* U+3675 */
  0x0000,   /* U+3676 */
  0x0000,   /* U+3677 */
  0x0000,   /* U+3678 */
  0x0000,   /* U+3679 */
  0x0000,   /* U+367A */
  0x0000,   /* U+367B */
  0x0000,   /* U+367C */
  0x0000,   /* U+367D */
  0x0000,   /* U+367E */
  0x0000,   /* U+367F */
  0x0000,   /* U+3680 */
  0x0000,   /* U+3681 */
  0x0000,   /* U+3682 */
  0x0000,   /* U+3683 */
  0x0000,   /* U+3684 */
  0x0000,   /* U+3685 */
  0x0000,   /* U+3686 */
  0x0000,   /* U+3687 */
  0x0000,   /* U+3688 */
  0x0000,   /* U+3689 */
  0x0000,   /* U+368A */
  0x0000,   /* U+368B */
  0x0000,   /* U+368C */
  0x0000,   /* U+368D */
  0x0000,   /* U+368E */
  0x0000,   /* U+368F */
  0x0000,   /* U+3690 */
  0x0000,   /* U+3691 */
  0x0000,   /* U+3692 */
  0x0000,   /* U+3693 */
  0x0000,   /* U+3694 */
  0x0000,   /* U+3695 */
  0x0000,   /* U+3696 */
  0x0000,   /* U+3697 */
  0x0000,   /* U+3698 */
  0x0000,   /* U+3699 */
  0x0000,   /* U+369A */
  0x0000,   /* U+369B */
  0x0000,   /* U+369C */
  0x0000,   /* U+369D */
  0x0000,   /* U+369E */
  0x0000,   /* U+369F */
  0x0000,   /* U+36A0 */
  0x0000,   /* U+36A1 */
  0x0000,   /* U+36A2 */
  0x0000,   /* U+36A3 */
  0x0000,   /* U+36A4 */
  0x0000,   /* U+36A5 */
  0x0000,   /* U+36A6 */
  0x0000,   /* U+36A7 */
  0x0000,   /* U+36A8 */
  0x0000,   /* U+36A9 */
  0x0000,   /* U+36AA */
  0x0000,   /* U+36AB */
  0x0000,   /* U+36AC */
  0x0000,   /* U+36AD */
  0x0000,   /* U+36AE */
  0x0000,   /* U+36AF */
  0x0000,   /* U+36B0 */
  0x0000,   /* U+36B1 */
  0x0000,   /* U+36B2 */
  0x0000,   /* U+36B3 */
  0x0000,   /* U+36B4 */
  0x0000,   /* U+36B5 */
  0x0000,   /* U+36B6 */
  0x0000,   /* U+36B7 */
  0x0000,   /* U+36B8 */
  0x0000,   /* U+36B9 */
  0x0000,   /* U+36BA */
  0x0000,   /* U+36BB */
  0x0000,   /* U+36BC */
  0x0000,   /* U+36BD */
  0x0000,   /* U+36BE */
  0x0000,   /* U+36BF */
  0x0000,   /* U+36C0 */
  0x0000,   /* U+36C1 */
  0x0000,   /* U+36C2 */
  0x0000,   /* U+36C3 */
  0x0000,   /* U+36C4 */
  0x0000,   /* U+36C5 */
  0x0000,   /* U+36C6 */
  0x0000,   /* U+36C7 */
  0x0000,   /* U+36C8 */
  0x0000,   /* U+36C9 */
  0x0000,   /* U+36CA */
  0x0000,   /* U+36CB */
  0x0000,   /* U+36CC */
  0x0000,   /* U+36CD */
  0x0000,   /* U+36CE */
  0x0000,   /* U+36CF */
  0x0000,   /* U+36D0 */
  0x0000,   /* U+36D1 */
  0x0000,   /* U+36D2 */
  0x0000,   /* U+36D3 */
  0x0000,   /* U+36D4 */
  0x0000,   /* U+36D5 */
  0x0000,   /* U+36D6 */
  0x0000,   /* U+36D7 */
  0x0000,   /* U+36D8 */
  0x0000,   /* U+36D9 */
  0x0000,   /* U+36DA */
  0x0000,   /* U+36DB */
  0x0000,   /* U+36DC */
  0x0000,   /* U+36DD */
  0x0000,   /* U+36DE */
  0x0000,   /* U+36DF */
  0x0000,   /* U+36E0 */
  0x0000,   /* U+36E1 */
  0x0000,   /* U+36E2 */
  0x0000,   /* U+36E3 */
  0x0000,   /* U+36E4 */
  0x0000,   /* U+36E5 */
  0x0000,   /* U+36E6 */
  0x0000,   /* U+36E7 */
  0x0000,   /* U+36E8 */
  0x0000,   /* U+36E9 */
  0x0000,   /* U+36EA */
  0x0000,   /* U+36EB */
  0x0000,   /* U+36EC */
  0x0000,   /* U+36ED */
  0x0000,   /* U+36EE */
  0x0000,   /* U+36EF */
  0x0000,   /* U+36F0 */
  0x0000,   /* U+36F1 */
  0x0000,   /* U+36F2 */
  0x0000,   /* U+36F3 */
  0x0000,   /* U+36F4 */
  0x0000,   /* U+36F5 */
  0x0000,   /* U+36F6 */
  0x0000,   /* U+36F7 */
  0x0000,   /* U+36F8 */
  0x0000,   /* U+36F9 */
  0x0000,   /* U+36FA */
  0x0000,   /* U+36FB */
  0x0000,   /* U+36FC */
  0x0000,   /* U+36FD */
  0x0000,   /* U+36FE */
  0x0000,   /* U+36FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3600 */
  0x0000,   /* U+3601 */
  0x0000,   /* U+3602 */
  0x0000,   /* U+3603 */
  0x0000,   /* U+3604 */
  0x0000,   /* U+3605 */
  0x0000,   /* U+3606 */
  0x0000,   /* U+3607 */
  0x0000,   /* U+3608 */
  0x0000,   /* U+3609 */
  0x0000,   /* U+360A */
  0x0000,   /* U+360B */
  0x0000,   /* U+360C */
  0x0000,   /* U+360D */
  0x0000,   /* U+360E */
  0x0000,   /* U+360F */
  0x0000,   /* U+3610 */
  0x0000,   /* U+3611 */
  0x0000,   /* U+3612 */
  0x0000,   /* U+3613 */
  0x0000,   /* U+3614 */
  0x0000,   /* U+3615 */
  0x0000,   /* U+3616 */
  0x0000,   /* U+3617 */
  0x0000,   /* U+3618 */
  0x0000,   /* U+3619 */
  0x0000,   /* U+361A */
  0x0000,   /* U+361B */
  0x0000,   /* U+361C */
  0x0000,   /* U+361D */
  0x0000,   /* U+361E */
  0x0000,   /* U+361F */
  0x0000,   /* U+3620 */
  0x0000,   /* U+3621 */
  0x0000,   /* U+3622 */
  0x0000,   /* U+3623 */
  0x0000,   /* U+3624 */
  0x0000,   /* U+3625 */
  0x0000,   /* U+3626 */
  0x0000,   /* U+3627 */
  0x0000,   /* U+3628 */
  0x0000,   /* U+3629 */
  0x0000,   /* U+362A */
  0x0000,   /* U+362B */
  0x0000,   /* U+362C */
  0x0000,   /* U+362D */
  0x0000,   /* U+362E */
  0x0000,   /* U+362F */
  0x0000,   /* U+3630 */
  0x0000,   /* U+3631 */
  0x0000,   /* U+3632 */
  0x0000,   /* U+3633 */
  0x0000,   /* U+3634 */
  0x0000,   /* U+3635 */
  0x0000,   /* U+3636 */
  0x0000,   /* U+3637 */
  0x0000,   /* U+3638 */
  0x0000,   /* U+3639 */
  0x0000,   /* U+363A */
  0x0000,   /* U+363B */
  0x0000,   /* U+363C */
  0x0000,   /* U+363D */
  0x0000,   /* U+363E */
  0x0000,   /* U+363F */
  0x0000,   /* U+3640 */
  0x0000,   /* U+3641 */
  0x0000,   /* U+3642 */
  0x0000,   /* U+3643 */
  0x0000,   /* U+3644 */
  0x0000,   /* U+3645 */
  0x0000,   /* U+3646 */
  0x0000,   /* U+3647 */
  0x0000,   /* U+3648 */
  0x0000,   /* U+3649 */
  0x0000,   /* U+364A */
  0x0000,   /* U+364B */
  0x0000,   /* U+364C */
  0x0000,   /* U+364D */
  0x0000,   /* U+364E */
  0x0000,   /* U+364F */
  0x0000,   /* U+3650 */
  0x0000,   /* U+3651 */
  0x0000,   /* U+3652 */
  0x0000,   /* U+3653 */
  0x0000,   /* U+3654 */
  0x0000,   /* U+3655 */
  0x0000,   /* U+3656 */
  0x0000,   /* U+3657 */
  0x0000,   /* U+3658 */
  0x0000,   /* U+3659 */
  0x0000,   /* U+365A */
  0x0000,   /* U+365B */
  0x0000,   /* U+365C */
  0x0000,   /* U+365D */
  0x0000,   /* U+365E */
  0x0000,   /* U+365F */
  0x0000,   /* U+3660 */
  0x0000,   /* U+3661 */
  0x0000,   /* U+3662 */
  0x0000,   /* U+3663 */
  0x0000,   /* U+3664 */
  0x0000,   /* U+3665 */
  0x0000,   /* U+3666 */
  0x0000,   /* U+3667 */
  0x0000,   /* U+3668 */
  0x0000,   /* U+3669 */
  0x0000,   /* U+366A */
  0x0000,   /* U+366B */
  0x0000,   /* U+366C */
  0x0000,   /* U+366D */
  0x0000,   /* U+366E */
  0x0000,   /* U+366F */
  0x0000,   /* U+3670 */
  0x0000,   /* U+3671 */
  0x0000,   /* U+3672 */
  0x0000,   /* U+3673 */
  0x0000,   /* U+3674 */
  0x0000,   /* U+3675 */
  0x0000,   /* U+3676 */
  0x0000,   /* U+3677 */
  0x0000,   /* U+3678 */
  0x0000,   /* U+3679 */
  0x0000,   /* U+367A */
  0x0000,   /* U+367B */
  0x0000,   /* U+367C */
  0x0000,   /* U+367D */
  0x0000,   /* U+367E */
  0x0000,   /* U+367F */
  0x0000,   /* U+3680 */
  0x0000,   /* U+3681 */
  0x0000,   /* U+3682 */
  0x0000,   /* U+3683 */
  0x0000,   /* U+3684 */
  0x0000,   /* U+3685 */
  0x0000,   /* U+3686 */
  0x0000,   /* U+3687 */
  0x0000,   /* U+3688 */
  0x0000,   /* U+3689 */
  0x0000,   /* U+368A */
  0x0000,   /* U+368B */
  0x0000,   /* U+368C */
  0x0000,   /* U+368D */
  0x0000,   /* U+368E */
  0x0000,   /* U+368F */
  0x0000,   /* U+3690 */
  0x0000,   /* U+3691 */
  0x0000,   /* U+3692 */
  0x0000,   /* U+3693 */
  0x0000,   /* U+3694 */
  0x0000,   /* U+3695 */
  0x0000,   /* U+3696 */
  0x0000,   /* U+3697 */
  0x0000,   /* U+3698 */
  0x0000,   /* U+3699 */
  0x0000,   /* U+369A */
  0x0000,   /* U+369B */
  0x0000,   /* U+369C */
  0x0000,   /* U+369D */
  0x0000,   /* U+369E */
  0x0000,   /* U+369F */
  0x0000,   /* U+36A0 */
  0x0000,   /* U+36A1 */
  0x0000,   /* U+36A2 */
  0x0000,   /* U+36A3 */
  0x0000,   /* U+36A4 */
  0x0000,   /* U+36A5 */
  0x0000,   /* U+36A6 */
  0x0000,   /* U+36A7 */
  0x0000,   /* U+36A8 */
  0x0000,   /* U+36A9 */
  0x0000,   /* U+36AA */
  0x0000,   /* U+36AB */
  0x0000,   /* U+36AC */
  0x0000,   /* U+36AD */
  0x0000,   /* U+36AE */
  0x0000,   /* U+36AF */
  0x0000,   /* U+36B0 */
  0x0000,   /* U+36B1 */
  0x0000,   /* U+36B2 */
  0x0000,   /* U+36B3 */
  0x0000,   /* U+36B4 */
  0x0000,   /* U+36B5 */
  0x0000,   /* U+36B6 */
  0x0000,   /* U+36B7 */
  0x0000,   /* U+36B8 */
  0x0000,   /* U+36B9 */
  0x0000,   /* U+36BA */
  0x0000,   /* U+36BB */
  0x0000,   /* U+36BC */
  0x0000,   /* U+36BD */
  0x0000,   /* U+36BE */
  0x0000,   /* U+36BF */
  0x0000,   /* U+36C0 */
  0x0000,   /* U+36C1 */
  0x0000,   /* U+36C2 */
  0x0000,   /* U+36C3 */
  0x0000,   /* U+36C4 */
  0x0000,   /* U+36C5 */
  0x0000,   /* U+36C6 */
  0x0000,   /* U+36C7 */
  0x0000,   /* U+36C8 */
  0x0000,   /* U+36C9 */
  0x0000,   /* U+36CA */
  0x0000,   /* U+36CB */
  0x0000,   /* U+36CC */
  0x0000,   /* U+36CD */
  0x0000,   /* U+36CE */
  0x0000,   /* U+36CF */
  0x0000,   /* U+36D0 */
  0x0000,   /* U+36D1 */
  0x0000,   /* U+36D2 */
  0x0000,   /* U+36D3 */
  0x0000,   /* U+36D4 */
  0x0000,   /* U+36D5 */
  0x0000,   /* U+36D6 */
  0x0000,   /* U+36D7 */
  0x0000,   /* U+36D8 */
  0x0000,   /* U+36D9 */
  0x0000,   /* U+36DA */
  0x0000,   /* U+36DB */
  0x0000,   /* U+36DC */
  0x0000,   /* U+36DD */
  0x0000,   /* U+36DE */
  0x0000,   /* U+36DF */
  0x0000,   /* U+36E0 */
  0x0000,   /* U+36E1 */
  0x0000,   /* U+36E2 */
  0x0000,   /* U+36E3 */
  0x0000,   /* U+36E4 */
  0x0000,   /* U+36E5 */
  0x0000,   /* U+36E6 */
  0x0000,   /* U+36E7 */
  0x0000,   /* U+36E8 */
  0x0000,   /* U+36E9 */
  0x0000,   /* U+36EA */
  0x0000,   /* U+36EB */
  0x0000,   /* U+36EC */
  0x0000,   /* U+36ED */
  0x0000,   /* U+36EE */
  0x0000,   /* U+36EF */
  0x0000,   /* U+36F0 */
  0x0000,   /* U+36F1 */
  0x0000,   /* U+36F2 */
  0x0000,   /* U+36F3 */
  0x0000,   /* U+36F4 */
  0x0000,   /* U+36F5 */
  0x0000,   /* U+36F6 */
  0x0000,   /* U+36F7 */
  0x0000,   /* U+36F8 */
  0x0000,   /* U+36F9 */
  0x0000,   /* U+36FA */
  0x0000,   /* U+36FB */
  0x0000,   /* U+36FC */
  0x0000,   /* U+36FD */
  0x0000,   /* U+36FE */
  0x0000,   /* U+36FF */
};

uint16 zh3_han_p037[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C53,   /* U+3700 */
  0x1C53,   /* U+3701 */
  0x1C53,   /* U+3702 */
  0x1C53,   /* U+3703 */
  0x1C53,   /* U+3704 */
  0x1C54,   /* U+3705 */
  0x1C54,   /* U+3706 */
  0x1C54,   /* U+3707 */
  0x1C54,   /* U+3708 */
  0x1C54,   /* U+3709 */
  0x1C54,   /* U+370A */
  0x1C54,   /* U+370B */
  0x1C54,   /* U+370C */
  0x1C54,   /* U+370D */
  0x1C54,   /* U+370E */
  0x1C54,   /* U+370F */
  0x1C54,   /* U+3710 */
  0x1C54,   /* U+3711 */
  0x1C54,   /* U+3712 */
  0x1C54,   /* U+3713 */
  0x1C54,   /* U+3714 */
  0x1C55,   /* U+3715 */
  0x1C55,   /* U+3716 */
  0x1C55,   /* U+3717 */
  0x1C55,   /* U+3718 */
  0x1C55,   /* U+3719 */
  0x1C55,   /* U+371A */
  0x1C55,   /* U+371B */
  0x1C55,   /* U+371C */
  0x1C55,   /* U+371D */
  0x1C55,   /* U+371E */
  0x1C55,   /* U+371F */
  0x1C55,   /* U+3720 */
  0x1C55,   /* U+3721 */
  0x1C55,   /* U+3722 */
  0x1C56,   /* U+3723 */
  0x1C56,   /* U+3724 */
  0x1C56,   /* U+3725 */
  0x1C56,   /* U+3726 */
  0x1C56,   /* U+3727 */
  0x1C56,   /* U+3728 */
  0x1C57,   /* U+3729 */
  0x1C57,   /* U+372A */
  0x1C57,   /* U+372B */
  0x1C57,   /* U+372C */
  0x1C57,   /* U+372D */
  0x1C58,   /* U+372E */
  0x1C58,   /* U+372F */
  0x1C59,   /* U+3730 */
  0x1C59,   /* U+3731 */
  0x1C5A,   /* U+3732 */
  0x1C5A,   /* U+3733 */
  0x1C5A,   /* U+3734 */
  0x1C5A,   /* U+3735 */
  0x1C5B,   /* U+3736 */
  0x1C5B,   /* U+3737 */
  0x1C5B,   /* U+3738 */
  0x1C5C,   /* U+3739 */
  0x1C5D,   /* U+373A */
  0x1C61,   /* U+373B */
  0x1C61,   /* U+373C */
  0x1C4D,   /* U+373D */
  0x1C4E,   /* U+373E */
  0x1C4E,   /* U+373F */
  0x1C4F,   /* U+3740 */
  0x1C50,   /* U+3741 */
  0x1C51,   /* U+3742 */
  0x1C51,   /* U+3743 */
  0x1C53,   /* U+3744 */
  0x1C54,   /* U+3745 */
  0x1C56,   /* U+3746 */
  0x1C57,   /* U+3747 */
  0x1C60,   /* U+3748 */
  0x1C4B,   /* U+3749 */
  0x1C4C,   /* U+374A */
  0x1C4C,   /* U+374B */
  0x1C4D,   /* U+374C */
  0x1C4D,   /* U+374D */
  0x1C4E,   /* U+374E */
  0x1C4E,   /* U+374F */
  0x1C4E,   /* U+3750 */
  0x1C4E,   /* U+3751 */
  0x1C4F,   /* U+3752 */
  0x1C50,   /* U+3753 */
  0x1C50,   /* U+3754 */
  0x1C50,   /* U+3755 */
  0x1C50,   /* U+3756 */
  0x1C51,   /* U+3757 */
  0x1C51,   /* U+3758 */
  0x1C51,   /* U+3759 */
  0x1C51,   /* U+375A */
  0x1C52,   /* U+375B */
  0x1C52,   /* U+375C */
  0x1C52,   /* U+375D */
  0x1C52,   /* U+375E */
  0x1C52,   /* U+375F */
  0x1C52,   /* U+3760 */
  0x1C52,   /* U+3761 */
  0x1C53,   /* U+3762 */
  0x1C53,   /* U+3763 */
  0x1C54,   /* U+3764 */
  0x1C54,   /* U+3765 */
  0x1C54,   /* U+3766 */
  0x1C54,   /* U+3767 */
  0x1C54,   /* U+3768 */
  0x1C55,   /* U+3769 */
  0x1C55,   /* U+376A */
  0x1C55,   /* U+376B */
  0x1C55,   /* U+376C */
  0x1C56,   /* U+376D */
  0x1C56,   /* U+376E */
  0x1C56,   /* U+376F */
  0x1C59,   /* U+3770 */
  0x1C5C,   /* U+3771 */
  0x1C61,   /* U+3772 */
  0x1C4C,   /* U+3773 */
  0x1C4E,   /* U+3774 */
  0x1C4F,   /* U+3775 */
  0x1C51,   /* U+3776 */
  0x1C53,   /* U+3777 */
  0x1C51,   /* U+3778 */
  0x1C53,   /* U+3779 */
  0x1C55,   /* U+377A */
  0x1C56,   /* U+377B */
  0x1C4D,   /* U+377C */
  0x1C4E,   /* U+377D */
  0x1C4F,   /* U+377E */
  0x1C4F,   /* U+377F */
  0x1C50,   /* U+3780 */
  0x1C50,   /* U+3781 */
  0x1C51,   /* U+3782 */
  0x1C52,   /* U+3783 */
  0x1C52,   /* U+3784 */
  0x1C52,   /* U+3785 */
  0x1C52,   /* U+3786 */
  0x1C53,   /* U+3787 */
  0x1C53,   /* U+3788 */
  0x1C54,   /* U+3789 */
  0x1C54,   /* U+378A */
  0x1C4C,   /* U+378B */
  0x1C4D,   /* U+378C */
  0x1C4D,   /* U+378D */
  0x1C4E,   /* U+378E */
  0x1C4F,   /* U+378F */
  0x1C4F,   /* U+3790 */
  0x1C4F,   /* U+3791 */
  0x1C50,   /* U+3792 */
  0x1C50,   /* U+3793 */
  0x1C50,   /* U+3794 */
  0x1C50,   /* U+3795 */
  0x1C50,   /* U+3796 */
  0x1C51,   /* U+3797 */
  0x1C52,   /* U+3798 */
  0x1C52,   /* U+3799 */
  0x1C53,   /* U+379A */
  0x1C53,   /* U+379B */
  0x1C55,   /* U+379C */
  0x1C55,   /* U+379D */
  0x1C55,   /* U+379E */
  0x1C56,   /* U+379F */
  0x1C56,   /* U+37A0 */
  0x1C5A,   /* U+37A1 */
  0x1C4B,   /* U+37A2 */
  0x1C4E,   /* U+37A3 */
  0x1C4C,   /* U+37A4 */
  0x1C4C,   /* U+37A5 */
  0x1C4C,   /* U+37A6 */
  0x1C4C,   /* U+37A7 */
  0x1C4D,   /* U+37A8 */
  0x1C4D,   /* U+37A9 */
  0x1C4D,   /* U+37AA */
  0x1C4D,   /* U+37AB */
  0x1C4D,   /* U+37AC */
  0x1C4D,   /* U+37AD */
  0x1C4D,   /* U+37AE */
  0x1C4D,   /* U+37AF */
  0x1C4E,   /* U+37B0 */
  0x1C4E,   /* U+37B1 */
  0x1C4E,   /* U+37B2 */
  0x1C4E,   /* U+37B3 */
  0x1C4E,   /* U+37B4 */
  0x1C4E,   /* U+37B5 */
  0x1C4E,   /* U+37B6 */
  0x1C4E,   /* U+37B7 */
  0x1C4E,   /* U+37B8 */
  0x1C4F,   /* U+37B9 */
  0x1C4F,   /* U+37BA */
  0x1C4F,   /* U+37BB */
  0x1C4F,   /* U+37BC */
  0x1C4F,   /* U+37BD */
  0x1C4F,   /* U+37BE */
  0x1C4F,   /* U+37BF */
  0x1C4F,   /* U+37C0 */
  0x1C4F,   /* U+37C1 */
  0x1C4F,   /* U+37C2 */
  0x1C4F,   /* U+37C3 */
  0x1C50,   /* U+37C4 */
  0x1C50,   /* U+37C5 */
  0x1C50,   /* U+37C6 */
  0x1C51,   /* U+37C7 */
  0x1C51,   /* U+37C8 */
  0x1C51,   /* U+37C9 */
  0x1C51,   /* U+37CA */
  0x1C51,   /* U+37CB */
  0x1C51,   /* U+37CC */
  0x1C51,   /* U+37CD */
  0x1C51,   /* U+37CE */
  0x1C51,   /* U+37CF */
  0x1C51,   /* U+37D0 */
  0x1C51,   /* U+37D1 */
  0x1C51,   /* U+37D2 */
  0x1C51,   /* U+37D3 */
  0x1C51,   /* U+37D4 */
  0x1C51,   /* U+37D5 */
  0x1C51,   /* U+37D6 */
  0x1C52,   /* U+37D7 */
  0x1C52,   /* U+37D8 */
  0x1C52,   /* U+37D9 */
  0x1C52,   /* U+37DA */
  0x1C52,   /* U+37DB */
  0x1C52,   /* U+37DC */
  0x1C52,   /* U+37DD */
  0x1C52,   /* U+37DE */
  0x1C52,   /* U+37DF */
  0x1C52,   /* U+37E0 */
  0x1C52,   /* U+37E1 */
  0x1C52,   /* U+37E2 */
  0x1C52,   /* U+37E3 */
  0x1C52,   /* U+37E4 */
  0x1C52,   /* U+37E5 */
  0x1C53,   /* U+37E6 */
  0x1C53,   /* U+37E7 */
  0x1C53,   /* U+37E8 */
  0x1C53,   /* U+37E9 */
  0x1C53,   /* U+37EA */
  0x1C53,   /* U+37EB */
  0x1C53,   /* U+37EC */
  0x1C53,   /* U+37ED */
  0x1C53,   /* U+37EE */
  0x1C53,   /* U+37EF */
  0x1C54,   /* U+37F0 */
  0x1C54,   /* U+37F1 */
  0x1C54,   /* U+37F2 */
  0x1C54,   /* U+37F3 */
  0x1C54,   /* U+37F4 */
  0x1C54,   /* U+37F5 */
  0x1C54,   /* U+37F6 */
  0x1C54,   /* U+37F7 */
  0x1C54,   /* U+37F8 */
  0x1C55,   /* U+37F9 */
  0x1C55,   /* U+37FA */
  0x1C55,   /* U+37FB */
  0x1C55,   /* U+37FC */
  0x1C55,   /* U+37FD */
  0x1C55,   /* U+37FE */
  0x1C55,   /* U+37FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3700 */
  0x0020,   /* U+3701 */
  0x0020,   /* U+3702 */
  0x0020,   /* U+3703 */
  0x0020,   /* U+3704 */
  0x0020,   /* U+3705 */
  0x0020,   /* U+3706 */
  0x0020,   /* U+3707 */
  0x0020,   /* U+3708 */
  0x0020,   /* U+3709 */
  0x0020,   /* U+370A */
  0x0020,   /* U+370B */
  0x0020,   /* U+370C */
  0x0020,   /* U+370D */
  0x0020,   /* U+370E */
  0x0020,   /* U+370F */
  0x0020,   /* U+3710 */
  0x0020,   /* U+3711 */
  0x0020,   /* U+3712 */
  0x0020,   /* U+3713 */
  0x0020,   /* U+3714 */
  0x0020,   /* U+3715 */
  0x0020,   /* U+3716 */
  0x0020,   /* U+3717 */
  0x0020,   /* U+3718 */
  0x0020,   /* U+3719 */
  0x0020,   /* U+371A */
  0x0020,   /* U+371B */
  0x0020,   /* U+371C */
  0x0020,   /* U+371D */
  0x0020,   /* U+371E */
  0x0020,   /* U+371F */
  0x0020,   /* U+3720 */
  0x0020,   /* U+3721 */
  0x0020,   /* U+3722 */
  0x0020,   /* U+3723 */
  0x0020,   /* U+3724 */
  0x0020,   /* U+3725 */
  0x0020,   /* U+3726 */
  0x0020,   /* U+3727 */
  0x0020,   /* U+3728 */
  0x0020,   /* U+3729 */
  0x0020,   /* U+372A */
  0x0020,   /* U+372B */
  0x0020,   /* U+372C */
  0x0020,   /* U+372D */
  0x0020,   /* U+372E */
  0x0020,   /* U+372F */
  0x0020,   /* U+3730 */
  0x0020,   /* U+3731 */
  0x0020,   /* U+3732 */
  0x0020,   /* U+3733 */
  0x0020,   /* U+3734 */
  0x0020,   /* U+3735 */
  0x0020,   /* U+3736 */
  0x0020,   /* U+3737 */
  0x0020,   /* U+3738 */
  0x0020,   /* U+3739 */
  0x0020,   /* U+373A */
  0x0020,   /* U+373B */
  0x0020,   /* U+373C */
  0x0020,   /* U+373D */
  0x0020,   /* U+373E */
  0x0020,   /* U+373F */
  0x0020,   /* U+3740 */
  0x0020,   /* U+3741 */
  0x0020,   /* U+3742 */
  0x0020,   /* U+3743 */
  0x0020,   /* U+3744 */
  0x0020,   /* U+3745 */
  0x0020,   /* U+3746 */
  0x0020,   /* U+3747 */
  0x0020,   /* U+3748 */
  0x0020,   /* U+3749 */
  0x0020,   /* U+374A */
  0x0020,   /* U+374B */
  0x0020,   /* U+374C */
  0x0020,   /* U+374D */
  0x0020,   /* U+374E */
  0x0020,   /* U+374F */
  0x0020,   /* U+3750 */
  0x0020,   /* U+3751 */
  0x0020,   /* U+3752 */
  0x0020,   /* U+3753 */
  0x0020,   /* U+3754 */
  0x0020,   /* U+3755 */
  0x0020,   /* U+3756 */
  0x0020,   /* U+3757 */
  0x0020,   /* U+3758 */
  0x0020,   /* U+3759 */
  0x0020,   /* U+375A */
  0x0020,   /* U+375B */
  0x0020,   /* U+375C */
  0x0020,   /* U+375D */
  0x0020,   /* U+375E */
  0x0020,   /* U+375F */
  0x0020,   /* U+3760 */
  0x0020,   /* U+3761 */
  0x0020,   /* U+3762 */
  0x0020,   /* U+3763 */
  0x0020,   /* U+3764 */
  0x0020,   /* U+3765 */
  0x0020,   /* U+3766 */
  0x0020,   /* U+3767 */
  0x0020,   /* U+3768 */
  0x0020,   /* U+3769 */
  0x0020,   /* U+376A */
  0x0020,   /* U+376B */
  0x0020,   /* U+376C */
  0x0020,   /* U+376D */
  0x0020,   /* U+376E */
  0x0020,   /* U+376F */
  0x0020,   /* U+3770 */
  0x0020,   /* U+3771 */
  0x0020,   /* U+3772 */
  0x0020,   /* U+3773 */
  0x0020,   /* U+3774 */
  0x0020,   /* U+3775 */
  0x0020,   /* U+3776 */
  0x0020,   /* U+3777 */
  0x0020,   /* U+3778 */
  0x0020,   /* U+3779 */
  0x0020,   /* U+377A */
  0x0020,   /* U+377B */
  0x0020,   /* U+377C */
  0x0020,   /* U+377D */
  0x0020,   /* U+377E */
  0x0020,   /* U+377F */
  0x0020,   /* U+3780 */
  0x0020,   /* U+3781 */
  0x0020,   /* U+3782 */
  0x0020,   /* U+3783 */
  0x0020,   /* U+3784 */
  0x0020,   /* U+3785 */
  0x0020,   /* U+3786 */
  0x0020,   /* U+3787 */
  0x0020,   /* U+3788 */
  0x0020,   /* U+3789 */
  0x0020,   /* U+378A */
  0x0020,   /* U+378B */
  0x0020,   /* U+378C */
  0x0020,   /* U+378D */
  0x0020,   /* U+378E */
  0x0020,   /* U+378F */
  0x0020,   /* U+3790 */
  0x0020,   /* U+3791 */
  0x0020,   /* U+3792 */
  0x0020,   /* U+3793 */
  0x0020,   /* U+3794 */
  0x0020,   /* U+3795 */
  0x0020,   /* U+3796 */
  0x0020,   /* U+3797 */
  0x0020,   /* U+3798 */
  0x0020,   /* U+3799 */
  0x0020,   /* U+379A */
  0x0020,   /* U+379B */
  0x0020,   /* U+379C */
  0x0020,   /* U+379D */
  0x0020,   /* U+379E */
  0x0020,   /* U+379F */
  0x0020,   /* U+37A0 */
  0x0020,   /* U+37A1 */
  0x0020,   /* U+37A2 */
  0x0020,   /* U+37A3 */
  0x0020,   /* U+37A4 */
  0x0020,   /* U+37A5 */
  0x0020,   /* U+37A6 */
  0x0020,   /* U+37A7 */
  0x0020,   /* U+37A8 */
  0x0020,   /* U+37A9 */
  0x0020,   /* U+37AA */
  0x0020,   /* U+37AB */
  0x0020,   /* U+37AC */
  0x0020,   /* U+37AD */
  0x0020,   /* U+37AE */
  0x0020,   /* U+37AF */
  0x0020,   /* U+37B0 */
  0x0020,   /* U+37B1 */
  0x0020,   /* U+37B2 */
  0x0020,   /* U+37B3 */
  0x0020,   /* U+37B4 */
  0x0020,   /* U+37B5 */
  0x0020,   /* U+37B6 */
  0x0020,   /* U+37B7 */
  0x0020,   /* U+37B8 */
  0x0020,   /* U+37B9 */
  0x0020,   /* U+37BA */
  0x0020,   /* U+37BB */
  0x0020,   /* U+37BC */
  0x0020,   /* U+37BD */
  0x0020,   /* U+37BE */
  0x0020,   /* U+37BF */
  0x0020,   /* U+37C0 */
  0x0020,   /* U+37C1 */
  0x0020,   /* U+37C2 */
  0x0020,   /* U+37C3 */
  0x0020,   /* U+37C4 */
  0x0020,   /* U+37C5 */
  0x0020,   /* U+37C6 */
  0x0020,   /* U+37C7 */
  0x0020,   /* U+37C8 */
  0x0020,   /* U+37C9 */
  0x0020,   /* U+37CA */
  0x0020,   /* U+37CB */
  0x0020,   /* U+37CC */
  0x0020,   /* U+37CD */
  0x0020,   /* U+37CE */
  0x0020,   /* U+37CF */
  0x0020,   /* U+37D0 */
  0x0020,   /* U+37D1 */
  0x0020,   /* U+37D2 */
  0x0020,   /* U+37D3 */
  0x0020,   /* U+37D4 */
  0x0020,   /* U+37D5 */
  0x0020,   /* U+37D6 */
  0x0020,   /* U+37D7 */
  0x0020,   /* U+37D8 */
  0x0020,   /* U+37D9 */
  0x0020,   /* U+37DA */
  0x0020,   /* U+37DB */
  0x0020,   /* U+37DC */
  0x0020,   /* U+37DD */
  0x0020,   /* U+37DE */
  0x0020,   /* U+37DF */
  0x0020,   /* U+37E0 */
  0x0020,   /* U+37E1 */
  0x0020,   /* U+37E2 */
  0x0020,   /* U+37E3 */
  0x0020,   /* U+37E4 */
  0x0020,   /* U+37E5 */
  0x0020,   /* U+37E6 */
  0x0020,   /* U+37E7 */
  0x0020,   /* U+37E8 */
  0x0020,   /* U+37E9 */
  0x0020,   /* U+37EA */
  0x0020,   /* U+37EB */
  0x0020,   /* U+37EC */
  0x0020,   /* U+37ED */
  0x0020,   /* U+37EE */
  0x0020,   /* U+37EF */
  0x0020,   /* U+37F0 */
  0x0020,   /* U+37F1 */
  0x0020,   /* U+37F2 */
  0x0020,   /* U+37F3 */
  0x0020,   /* U+37F4 */
  0x0020,   /* U+37F5 */
  0x0020,   /* U+37F6 */
  0x0020,   /* U+37F7 */
  0x0020,   /* U+37F8 */
  0x0020,   /* U+37F9 */
  0x0020,   /* U+37FA */
  0x0020,   /* U+37FB */
  0x0020,   /* U+37FC */
  0x0020,   /* U+37FD */
  0x0020,   /* U+37FE */
  0x0020,   /* U+37FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3700 */
  0x0002,   /* U+3701 */
  0x0002,   /* U+3702 */
  0x0002,   /* U+3703 */
  0x0002,   /* U+3704 */
  0x0002,   /* U+3705 */
  0x0002,   /* U+3706 */
  0x0002,   /* U+3707 */
  0x0002,   /* U+3708 */
  0x0002,   /* U+3709 */
  0x0002,   /* U+370A */
  0x0002,   /* U+370B */
  0x0002,   /* U+370C */
  0x0002,   /* U+370D */
  0x0002,   /* U+370E */
  0x0002,   /* U+370F */
  0x0002,   /* U+3710 */
  0x0002,   /* U+3711 */
  0x0002,   /* U+3712 */
  0x0002,   /* U+3713 */
  0x0002,   /* U+3714 */
  0x0002,   /* U+3715 */
  0x0002,   /* U+3716 */
  0x0002,   /* U+3717 */
  0x0002,   /* U+3718 */
  0x0002,   /* U+3719 */
  0x0002,   /* U+371A */
  0x0002,   /* U+371B */
  0x0002,   /* U+371C */
  0x0002,   /* U+371D */
  0x0002,   /* U+371E */
  0x0002,   /* U+371F */
  0x0002,   /* U+3720 */
  0x0002,   /* U+3721 */
  0x0002,   /* U+3722 */
  0x0002,   /* U+3723 */
  0x0002,   /* U+3724 */
  0x0002,   /* U+3725 */
  0x0002,   /* U+3726 */
  0x0002,   /* U+3727 */
  0x0002,   /* U+3728 */
  0x0002,   /* U+3729 */
  0x0002,   /* U+372A */
  0x0002,   /* U+372B */
  0x0002,   /* U+372C */
  0x0002,   /* U+372D */
  0x0002,   /* U+372E */
  0x0002,   /* U+372F */
  0x0002,   /* U+3730 */
  0x0002,   /* U+3731 */
  0x0002,   /* U+3732 */
  0x0002,   /* U+3733 */
  0x0002,   /* U+3734 */
  0x0002,   /* U+3735 */
  0x0002,   /* U+3736 */
  0x0002,   /* U+3737 */
  0x0002,   /* U+3738 */
  0x0002,   /* U+3739 */
  0x0002,   /* U+373A */
  0x0002,   /* U+373B */
  0x0002,   /* U+373C */
  0x0002,   /* U+373D */
  0x0002,   /* U+373E */
  0x0002,   /* U+373F */
  0x0002,   /* U+3740 */
  0x0002,   /* U+3741 */
  0x0002,   /* U+3742 */
  0x0002,   /* U+3743 */
  0x0002,   /* U+3744 */
  0x0002,   /* U+3745 */
  0x0002,   /* U+3746 */
  0x0002,   /* U+3747 */
  0x0002,   /* U+3748 */
  0x0002,   /* U+3749 */
  0x0002,   /* U+374A */
  0x0002,   /* U+374B */
  0x0002,   /* U+374C */
  0x0002,   /* U+374D */
  0x0002,   /* U+374E */
  0x0002,   /* U+374F */
  0x0002,   /* U+3750 */
  0x0002,   /* U+3751 */
  0x0002,   /* U+3752 */
  0x0002,   /* U+3753 */
  0x0002,   /* U+3754 */
  0x0002,   /* U+3755 */
  0x0002,   /* U+3756 */
  0x0002,   /* U+3757 */
  0x0002,   /* U+3758 */
  0x0002,   /* U+3759 */
  0x0002,   /* U+375A */
  0x0002,   /* U+375B */
  0x0002,   /* U+375C */
  0x0002,   /* U+375D */
  0x0002,   /* U+375E */
  0x0002,   /* U+375F */
  0x0002,   /* U+3760 */
  0x0002,   /* U+3761 */
  0x0002,   /* U+3762 */
  0x0002,   /* U+3763 */
  0x0002,   /* U+3764 */
  0x0002,   /* U+3765 */
  0x0002,   /* U+3766 */
  0x0002,   /* U+3767 */
  0x0002,   /* U+3768 */
  0x0002,   /* U+3769 */
  0x0002,   /* U+376A */
  0x0002,   /* U+376B */
  0x0002,   /* U+376C */
  0x0002,   /* U+376D */
  0x0002,   /* U+376E */
  0x0002,   /* U+376F */
  0x0002,   /* U+3770 */
  0x0002,   /* U+3771 */
  0x0002,   /* U+3772 */
  0x0002,   /* U+3773 */
  0x0002,   /* U+3774 */
  0x0002,   /* U+3775 */
  0x0002,   /* U+3776 */
  0x0002,   /* U+3777 */
  0x0002,   /* U+3778 */
  0x0002,   /* U+3779 */
  0x0002,   /* U+377A */
  0x0002,   /* U+377B */
  0x0002,   /* U+377C */
  0x0002,   /* U+377D */
  0x0002,   /* U+377E */
  0x0002,   /* U+377F */
  0x0002,   /* U+3780 */
  0x0002,   /* U+3781 */
  0x0002,   /* U+3782 */
  0x0002,   /* U+3783 */
  0x0002,   /* U+3784 */
  0x0002,   /* U+3785 */
  0x0002,   /* U+3786 */
  0x0002,   /* U+3787 */
  0x0002,   /* U+3788 */
  0x0002,   /* U+3789 */
  0x0002,   /* U+378A */
  0x0002,   /* U+378B */
  0x0002,   /* U+378C */
  0x0002,   /* U+378D */
  0x0002,   /* U+378E */
  0x0002,   /* U+378F */
  0x0002,   /* U+3790 */
  0x0002,   /* U+3791 */
  0x0002,   /* U+3792 */
  0x0002,   /* U+3793 */
  0x0002,   /* U+3794 */
  0x0002,   /* U+3795 */
  0x0002,   /* U+3796 */
  0x0002,   /* U+3797 */
  0x0002,   /* U+3798 */
  0x0002,   /* U+3799 */
  0x0002,   /* U+379A */
  0x0002,   /* U+379B */
  0x0002,   /* U+379C */
  0x0002,   /* U+379D */
  0x0002,   /* U+379E */
  0x0002,   /* U+379F */
  0x0002,   /* U+37A0 */
  0x0002,   /* U+37A1 */
  0x0002,   /* U+37A2 */
  0x0002,   /* U+37A3 */
  0x0002,   /* U+37A4 */
  0x0002,   /* U+37A5 */
  0x0002,   /* U+37A6 */
  0x0002,   /* U+37A7 */
  0x0002,   /* U+37A8 */
  0x0002,   /* U+37A9 */
  0x0002,   /* U+37AA */
  0x0002,   /* U+37AB */
  0x0002,   /* U+37AC */
  0x0002,   /* U+37AD */
  0x0002,   /* U+37AE */
  0x0002,   /* U+37AF */
  0x0002,   /* U+37B0 */
  0x0002,   /* U+37B1 */
  0x0002,   /* U+37B2 */
  0x0002,   /* U+37B3 */
  0x0002,   /* U+37B4 */
  0x0002,   /* U+37B5 */
  0x0002,   /* U+37B6 */
  0x0002,   /* U+37B7 */
  0x0002,   /* U+37B8 */
  0x0002,   /* U+37B9 */
  0x0002,   /* U+37BA */
  0x0002,   /* U+37BB */
  0x0002,   /* U+37BC */
  0x0002,   /* U+37BD */
  0x0002,   /* U+37BE */
  0x0002,   /* U+37BF */
  0x0002,   /* U+37C0 */
  0x0002,   /* U+37C1 */
  0x0002,   /* U+37C2 */
  0x0002,   /* U+37C3 */
  0x0002,   /* U+37C4 */
  0x0002,   /* U+37C5 */
  0x0002,   /* U+37C6 */
  0x0002,   /* U+37C7 */
  0x0002,   /* U+37C8 */
  0x0002,   /* U+37C9 */
  0x0002,   /* U+37CA */
  0x0002,   /* U+37CB */
  0x0002,   /* U+37CC */
  0x0002,   /* U+37CD */
  0x0002,   /* U+37CE */
  0x0002,   /* U+37CF */
  0x0002,   /* U+37D0 */
  0x0002,   /* U+37D1 */
  0x0002,   /* U+37D2 */
  0x0002,   /* U+37D3 */
  0x0002,   /* U+37D4 */
  0x0002,   /* U+37D5 */
  0x0002,   /* U+37D6 */
  0x0002,   /* U+37D7 */
  0x0002,   /* U+37D8 */
  0x0002,   /* U+37D9 */
  0x0002,   /* U+37DA */
  0x0002,   /* U+37DB */
  0x0002,   /* U+37DC */
  0x0002,   /* U+37DD */
  0x0002,   /* U+37DE */
  0x0002,   /* U+37DF */
  0x0002,   /* U+37E0 */
  0x0002,   /* U+37E1 */
  0x0002,   /* U+37E2 */
  0x0002,   /* U+37E3 */
  0x0002,   /* U+37E4 */
  0x0002,   /* U+37E5 */
  0x0002,   /* U+37E6 */
  0x0002,   /* U+37E7 */
  0x0002,   /* U+37E8 */
  0x0002,   /* U+37E9 */
  0x0002,   /* U+37EA */
  0x0002,   /* U+37EB */
  0x0002,   /* U+37EC */
  0x0002,   /* U+37ED */
  0x0002,   /* U+37EE */
  0x0002,   /* U+37EF */
  0x0002,   /* U+37F0 */
  0x0002,   /* U+37F1 */
  0x0002,   /* U+37F2 */
  0x0002,   /* U+37F3 */
  0x0002,   /* U+37F4 */
  0x0002,   /* U+37F5 */
  0x0002,   /* U+37F6 */
  0x0002,   /* U+37F7 */
  0x0002,   /* U+37F8 */
  0x0002,   /* U+37F9 */
  0x0002,   /* U+37FA */
  0x0002,   /* U+37FB */
  0x0002,   /* U+37FC */
  0x0002,   /* U+37FD */
  0x0002,   /* U+37FE */
  0x0002,   /* U+37FF */

  /* Primary weight 2 for each character. */
  0x84A5,   /* U+3700 */
  0x84A6,   /* U+3701 */
  0x84A7,   /* U+3702 */
  0x84A8,   /* U+3703 */
  0x84A9,   /* U+3704 */
  0x841E,   /* U+3705 */
  0x841F,   /* U+3706 */
  0x8420,   /* U+3707 */
  0x8421,   /* U+3708 */
  0x8422,   /* U+3709 */
  0x8423,   /* U+370A */
  0x8424,   /* U+370B */
  0x8425,   /* U+370C */
  0x8426,   /* U+370D */
  0x8427,   /* U+370E */
  0x8428,   /* U+370F */
  0x8429,   /* U+3710 */
  0x842A,   /* U+3711 */
  0x842B,   /* U+3712 */
  0x842C,   /* U+3713 */
  0x842D,   /* U+3714 */
  0x83EB,   /* U+3715 */
  0x83EC,   /* U+3716 */
  0x83ED,   /* U+3717 */
  0x83EE,   /* U+3718 */
  0x83EF,   /* U+3719 */
  0x83F0,   /* U+371A */
  0x83F1,   /* U+371B */
  0x83F2,   /* U+371C */
  0x83F3,   /* U+371D */
  0x83F4,   /* U+371E */
  0x83F5,   /* U+371F */
  0x83F6,   /* U+3720 */
  0x83F7,   /* U+3721 */
  0x83F8,   /* U+3722 */
  0x82FB,   /* U+3723 */
  0x82FC,   /* U+3724 */
  0x82FD,   /* U+3725 */
  0x82FE,   /* U+3726 */
  0x82FF,   /* U+3727 */
  0x8300,   /* U+3728 */
  0x824B,   /* U+3729 */
  0x824C,   /* U+372A */
  0x824D,   /* U+372B */
  0x824E,   /* U+372C */
  0x824F,   /* U+372D */
  0x81BC,   /* U+372E */
  0x81BD,   /* U+372F */
  0x817C,   /* U+3730 */
  0x817D,   /* U+3731 */
  0x80FE,   /* U+3732 */
  0x80FF,   /* U+3733 */
  0x8100,   /* U+3734 */
  0x8101,   /* U+3735 */
  0x80B0,   /* U+3736 */
  0x80B1,   /* U+3737 */
  0x80B2,   /* U+3738 */
  0x8096,   /* U+3739 */
  0x8062,   /* U+373A */
  0x8020,   /* U+373B */
  0x8021,   /* U+373C */
  0x8313,   /* U+373D */
  0x841C,   /* U+373E */
  0x841D,   /* U+373F */
  0x8497,   /* U+3740 */
  0x84C1,   /* U+3741 */
  0x8553,   /* U+3742 */
  0x8554,   /* U+3743 */
  0x851E,   /* U+3744 */
  0x847D,   /* U+3745 */
  0x835F,   /* U+3746 */
  0x829F,   /* U+3747 */
  0x801E,   /* U+3748 */
  0x812D,   /* U+3749 */
  0x81DB,   /* U+374A */
  0x81DC,   /* U+374B */
  0x8322,   /* U+374C */
  0x8323,   /* U+374D */
  0x8437,   /* U+374E */
  0x8438,   /* U+374F */
  0x8439,   /* U+3750 */
  0x843A,   /* U+3751 */
  0x84C0,   /* U+3752 */
  0x84E1,   /* U+3753 */
  0x84E2,   /* U+3754 */
  0x84E3,   /* U+3755 */
  0x84E4,   /* U+3756 */
  0x8577,   /* U+3757 */
  0x8578,   /* U+3758 */
  0x8579,   /* U+3759 */
  0x857A,   /* U+375A */
  0x855F,   /* U+375B */
  0x8560,   /* U+375C */
  0x8561,   /* U+375D */
  0x8562,   /* U+375E */
  0x8563,   /* U+375F */
  0x8564,   /* U+3760 */
  0x8565,   /* U+3761 */
  0x8543,   /* U+3762 */
  0x8544,   /* U+3763 */
  0x849A,   /* U+3764 */
  0x849B,   /* U+3765 */
  0x849C,   /* U+3766 */
  0x849D,   /* U+3767 */
  0x849E,   /* U+3768 */
  0x846C,   /* U+3769 */
  0x846D,   /* U+376A */
  0x846E,   /* U+376B */
  0x846F,   /* U+376C */
  0x836E,   /* U+376D */
  0x836F,   /* U+376E */
  0x8370,   /* U+376F */
  0x81A5,   /* U+3770 */
  0x80A4,   /* U+3771 */
  0x8022,   /* U+3772 */
  0x81E2,   /* U+3773 */
  0x8458,   /* U+3774 */
  0x84E2,   /* U+3775 */
  0x85B5,   /* U+3776 */
  0x858A,   /* U+3777 */
  0x85BB,   /* U+3778 */
  0x8599,   /* U+3779 */
  0x84BB,   /* U+377A */
  0x83B2,   /* U+377B */
  0x8349,   /* U+377C */
  0x846E,   /* U+377D */
  0x84FB,   /* U+377E */
  0x84FC,   /* U+377F */
  0x852E,   /* U+3780 */
  0x852F,   /* U+3781 */
  0x85C7,   /* U+3782 */
  0x85C5,   /* U+3783 */
  0x85C6,   /* U+3784 */
  0x85C7,   /* U+3785 */
  0x85C8,   /* U+3786 */
  0x85A9,   /* U+3787 */
  0x85AA,   /* U+3788 */
  0x84F2,   /* U+3789 */
  0x84F3,   /* U+378A */
  0x81F5,   /* U+378B */
  0x834F,   /* U+378C */
  0x8350,   /* U+378D */
  0x8481,   /* U+378E */
  0x850F,   /* U+378F */
  0x8510,   /* U+3790 */
  0x8511,   /* U+3791 */
  0x853B,   /* U+3792 */
  0x853C,   /* U+3793 */
  0x853D,   /* U+3794 */
  0x853E,   /* U+3795 */
  0x853F,   /* U+3796 */
  0x85DD,   /* U+3797 */
  0x85D6,   /* U+3798 */
  0x85D7,   /* U+3799 */
  0x85B9,   /* U+379A */
  0x85BA,   /* U+379B */
  0x84CF,   /* U+379C */
  0x84D0,   /* U+379D */
  0x84D1,   /* U+379E */
  0x83CB,   /* U+379F */
  0x83CC,   /* U+37A0 */
  0x813E,   /* U+37A1 */
  0x813B,   /* U+37A2 */
  0x8493,   /* U+37A3 */
  0x8204,   /* U+37A4 */
  0x8205,   /* U+37A5 */
  0x8206,   /* U+37A6 */
  0x8207,   /* U+37A7 */
  0x8371,   /* U+37A8 */
  0x8372,   /* U+37A9 */
  0x8373,   /* U+37AA */
  0x8374,   /* U+37AB */
  0x8375,   /* U+37AC */
  0x8376,   /* U+37AD */
  0x8377,   /* U+37AE */
  0x8378,   /* U+37AF */
  0x84B2,   /* U+37B0 */
  0x84B3,   /* U+37B1 */
  0x84B4,   /* U+37B2 */
  0x84B5,   /* U+37B3 */
  0x84B6,   /* U+37B4 */
  0x84B7,   /* U+37B5 */
  0x84B8,   /* U+37B6 */
  0x8494,   /* U+37B7 */
  0x84B9,   /* U+37B8 */
  0x8556,   /* U+37B9 */
  0x8557,   /* U+37BA */
  0x8558,   /* U+37BB */
  0x8559,   /* U+37BC */
  0x855A,   /* U+37BD */
  0x855B,   /* U+37BE */
  0x855C,   /* U+37BF */
  0x855D,   /* U+37C0 */
  0x855E,   /* U+37C1 */
  0x855F,   /* U+37C2 */
  0x8560,   /* U+37C3 */
  0x858F,   /* U+37C4 */
  0x8590,   /* U+37C5 */
  0x8591,   /* U+37C6 */
  0x8625,   /* U+37C7 */
  0x8626,   /* U+37C8 */
  0x8627,   /* U+37C9 */
  0x8628,   /* U+37CA */
  0x8629,   /* U+37CB */
  0x862A,   /* U+37CC */
  0x862B,   /* U+37CD */
  0x862C,   /* U+37CE */
  0x862D,   /* U+37CF */
  0x862E,   /* U+37D0 */
  0x862F,   /* U+37D1 */
  0x8630,   /* U+37D2 */
  0x8631,   /* U+37D3 */
  0x8632,   /* U+37D4 */
  0x8633,   /* U+37D5 */
  0x8634,   /* U+37D6 */
  0x8628,   /* U+37D7 */
  0x8629,   /* U+37D8 */
  0x862A,   /* U+37D9 */
  0x862B,   /* U+37DA */
  0x862C,   /* U+37DB */
  0x862D,   /* U+37DC */
  0x862E,   /* U+37DD */
  0x862F,   /* U+37DE */
  0x8630,   /* U+37DF */
  0x8631,   /* U+37E0 */
  0x8632,   /* U+37E1 */
  0x8633,   /* U+37E2 */
  0x8634,   /* U+37E3 */
  0x8635,   /* U+37E4 */
  0x8636,   /* U+37E5 */
  0x8612,   /* U+37E6 */
  0x8613,   /* U+37E7 */
  0x8614,   /* U+37E8 */
  0x8615,   /* U+37E9 */
  0x8616,   /* U+37EA */
  0x8617,   /* U+37EB */
  0x8618,   /* U+37EC */
  0x8619,   /* U+37ED */
  0x861A,   /* U+37EE */
  0x861B,   /* U+37EF */
  0x853E,   /* U+37F0 */
  0x853F,   /* U+37F1 */
  0x8540,   /* U+37F2 */
  0x8541,   /* U+37F3 */
  0x8542,   /* U+37F4 */
  0x8543,   /* U+37F5 */
  0x8544,   /* U+37F6 */
  0x8545,   /* U+37F7 */
  0x8546,   /* U+37F8 */
  0x8501,   /* U+37F9 */
  0x8502,   /* U+37FA */
  0x8503,   /* U+37FB */
  0x8504,   /* U+37FC */
  0x8505,   /* U+37FD */
  0x8506,   /* U+37FE */
  0x8507,   /* U+37FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3700 */
  0x0000,   /* U+3701 */
  0x0000,   /* U+3702 */
  0x0000,   /* U+3703 */
  0x0000,   /* U+3704 */
  0x0000,   /* U+3705 */
  0x0000,   /* U+3706 */
  0x0000,   /* U+3707 */
  0x0000,   /* U+3708 */
  0x0000,   /* U+3709 */
  0x0000,   /* U+370A */
  0x0000,   /* U+370B */
  0x0000,   /* U+370C */
  0x0000,   /* U+370D */
  0x0000,   /* U+370E */
  0x0000,   /* U+370F */
  0x0000,   /* U+3710 */
  0x0000,   /* U+3711 */
  0x0000,   /* U+3712 */
  0x0000,   /* U+3713 */
  0x0000,   /* U+3714 */
  0x0000,   /* U+3715 */
  0x0000,   /* U+3716 */
  0x0000,   /* U+3717 */
  0x0000,   /* U+3718 */
  0x0000,   /* U+3719 */
  0x0000,   /* U+371A */
  0x0000,   /* U+371B */
  0x0000,   /* U+371C */
  0x0000,   /* U+371D */
  0x0000,   /* U+371E */
  0x0000,   /* U+371F */
  0x0000,   /* U+3720 */
  0x0000,   /* U+3721 */
  0x0000,   /* U+3722 */
  0x0000,   /* U+3723 */
  0x0000,   /* U+3724 */
  0x0000,   /* U+3725 */
  0x0000,   /* U+3726 */
  0x0000,   /* U+3727 */
  0x0000,   /* U+3728 */
  0x0000,   /* U+3729 */
  0x0000,   /* U+372A */
  0x0000,   /* U+372B */
  0x0000,   /* U+372C */
  0x0000,   /* U+372D */
  0x0000,   /* U+372E */
  0x0000,   /* U+372F */
  0x0000,   /* U+3730 */
  0x0000,   /* U+3731 */
  0x0000,   /* U+3732 */
  0x0000,   /* U+3733 */
  0x0000,   /* U+3734 */
  0x0000,   /* U+3735 */
  0x0000,   /* U+3736 */
  0x0000,   /* U+3737 */
  0x0000,   /* U+3738 */
  0x0000,   /* U+3739 */
  0x0000,   /* U+373A */
  0x0000,   /* U+373B */
  0x0000,   /* U+373C */
  0x0000,   /* U+373D */
  0x0000,   /* U+373E */
  0x0000,   /* U+373F */
  0x0000,   /* U+3740 */
  0x0000,   /* U+3741 */
  0x0000,   /* U+3742 */
  0x0000,   /* U+3743 */
  0x0000,   /* U+3744 */
  0x0000,   /* U+3745 */
  0x0000,   /* U+3746 */
  0x0000,   /* U+3747 */
  0x0000,   /* U+3748 */
  0x0000,   /* U+3749 */
  0x0000,   /* U+374A */
  0x0000,   /* U+374B */
  0x0000,   /* U+374C */
  0x0000,   /* U+374D */
  0x0000,   /* U+374E */
  0x0000,   /* U+374F */
  0x0000,   /* U+3750 */
  0x0000,   /* U+3751 */
  0x0000,   /* U+3752 */
  0x0000,   /* U+3753 */
  0x0000,   /* U+3754 */
  0x0000,   /* U+3755 */
  0x0000,   /* U+3756 */
  0x0000,   /* U+3757 */
  0x0000,   /* U+3758 */
  0x0000,   /* U+3759 */
  0x0000,   /* U+375A */
  0x0000,   /* U+375B */
  0x0000,   /* U+375C */
  0x0000,   /* U+375D */
  0x0000,   /* U+375E */
  0x0000,   /* U+375F */
  0x0000,   /* U+3760 */
  0x0000,   /* U+3761 */
  0x0000,   /* U+3762 */
  0x0000,   /* U+3763 */
  0x0000,   /* U+3764 */
  0x0000,   /* U+3765 */
  0x0000,   /* U+3766 */
  0x0000,   /* U+3767 */
  0x0000,   /* U+3768 */
  0x0000,   /* U+3769 */
  0x0000,   /* U+376A */
  0x0000,   /* U+376B */
  0x0000,   /* U+376C */
  0x0000,   /* U+376D */
  0x0000,   /* U+376E */
  0x0000,   /* U+376F */
  0x0000,   /* U+3770 */
  0x0000,   /* U+3771 */
  0x0000,   /* U+3772 */
  0x0000,   /* U+3773 */
  0x0000,   /* U+3774 */
  0x0000,   /* U+3775 */
  0x0000,   /* U+3776 */
  0x0000,   /* U+3777 */
  0x0000,   /* U+3778 */
  0x0000,   /* U+3779 */
  0x0000,   /* U+377A */
  0x0000,   /* U+377B */
  0x0000,   /* U+377C */
  0x0000,   /* U+377D */
  0x0000,   /* U+377E */
  0x0000,   /* U+377F */
  0x0000,   /* U+3780 */
  0x0000,   /* U+3781 */
  0x0000,   /* U+3782 */
  0x0000,   /* U+3783 */
  0x0000,   /* U+3784 */
  0x0000,   /* U+3785 */
  0x0000,   /* U+3786 */
  0x0000,   /* U+3787 */
  0x0000,   /* U+3788 */
  0x0000,   /* U+3789 */
  0x0000,   /* U+378A */
  0x0000,   /* U+378B */
  0x0000,   /* U+378C */
  0x0000,   /* U+378D */
  0x0000,   /* U+378E */
  0x0000,   /* U+378F */
  0x0000,   /* U+3790 */
  0x0000,   /* U+3791 */
  0x0000,   /* U+3792 */
  0x0000,   /* U+3793 */
  0x0000,   /* U+3794 */
  0x0000,   /* U+3795 */
  0x0000,   /* U+3796 */
  0x0000,   /* U+3797 */
  0x0000,   /* U+3798 */
  0x0000,   /* U+3799 */
  0x0000,   /* U+379A */
  0x0000,   /* U+379B */
  0x0000,   /* U+379C */
  0x0000,   /* U+379D */
  0x0000,   /* U+379E */
  0x0000,   /* U+379F */
  0x0000,   /* U+37A0 */
  0x0000,   /* U+37A1 */
  0x0000,   /* U+37A2 */
  0x0000,   /* U+37A3 */
  0x0000,   /* U+37A4 */
  0x0000,   /* U+37A5 */
  0x0000,   /* U+37A6 */
  0x0000,   /* U+37A7 */
  0x0000,   /* U+37A8 */
  0x0000,   /* U+37A9 */
  0x0000,   /* U+37AA */
  0x0000,   /* U+37AB */
  0x0000,   /* U+37AC */
  0x0000,   /* U+37AD */
  0x0000,   /* U+37AE */
  0x0000,   /* U+37AF */
  0x0000,   /* U+37B0 */
  0x0000,   /* U+37B1 */
  0x0000,   /* U+37B2 */
  0x0000,   /* U+37B3 */
  0x0000,   /* U+37B4 */
  0x0000,   /* U+37B5 */
  0x0000,   /* U+37B6 */
  0x0000,   /* U+37B7 */
  0x0000,   /* U+37B8 */
  0x0000,   /* U+37B9 */
  0x0000,   /* U+37BA */
  0x0000,   /* U+37BB */
  0x0000,   /* U+37BC */
  0x0000,   /* U+37BD */
  0x0000,   /* U+37BE */
  0x0000,   /* U+37BF */
  0x0000,   /* U+37C0 */
  0x0000,   /* U+37C1 */
  0x0000,   /* U+37C2 */
  0x0000,   /* U+37C3 */
  0x0000,   /* U+37C4 */
  0x0000,   /* U+37C5 */
  0x0000,   /* U+37C6 */
  0x0000,   /* U+37C7 */
  0x0000,   /* U+37C8 */
  0x0000,   /* U+37C9 */
  0x0000,   /* U+37CA */
  0x0000,   /* U+37CB */
  0x0000,   /* U+37CC */
  0x0000,   /* U+37CD */
  0x0000,   /* U+37CE */
  0x0000,   /* U+37CF */
  0x0000,   /* U+37D0 */
  0x0000,   /* U+37D1 */
  0x0000,   /* U+37D2 */
  0x0000,   /* U+37D3 */
  0x0000,   /* U+37D4 */
  0x0000,   /* U+37D5 */
  0x0000,   /* U+37D6 */
  0x0000,   /* U+37D7 */
  0x0000,   /* U+37D8 */
  0x0000,   /* U+37D9 */
  0x0000,   /* U+37DA */
  0x0000,   /* U+37DB */
  0x0000,   /* U+37DC */
  0x0000,   /* U+37DD */
  0x0000,   /* U+37DE */
  0x0000,   /* U+37DF */
  0x0000,   /* U+37E0 */
  0x0000,   /* U+37E1 */
  0x0000,   /* U+37E2 */
  0x0000,   /* U+37E3 */
  0x0000,   /* U+37E4 */
  0x0000,   /* U+37E5 */
  0x0000,   /* U+37E6 */
  0x0000,   /* U+37E7 */
  0x0000,   /* U+37E8 */
  0x0000,   /* U+37E9 */
  0x0000,   /* U+37EA */
  0x0000,   /* U+37EB */
  0x0000,   /* U+37EC */
  0x0000,   /* U+37ED */
  0x0000,   /* U+37EE */
  0x0000,   /* U+37EF */
  0x0000,   /* U+37F0 */
  0x0000,   /* U+37F1 */
  0x0000,   /* U+37F2 */
  0x0000,   /* U+37F3 */
  0x0000,   /* U+37F4 */
  0x0000,   /* U+37F5 */
  0x0000,   /* U+37F6 */
  0x0000,   /* U+37F7 */
  0x0000,   /* U+37F8 */
  0x0000,   /* U+37F9 */
  0x0000,   /* U+37FA */
  0x0000,   /* U+37FB */
  0x0000,   /* U+37FC */
  0x0000,   /* U+37FD */
  0x0000,   /* U+37FE */
  0x0000,   /* U+37FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3700 */
  0x0000,   /* U+3701 */
  0x0000,   /* U+3702 */
  0x0000,   /* U+3703 */
  0x0000,   /* U+3704 */
  0x0000,   /* U+3705 */
  0x0000,   /* U+3706 */
  0x0000,   /* U+3707 */
  0x0000,   /* U+3708 */
  0x0000,   /* U+3709 */
  0x0000,   /* U+370A */
  0x0000,   /* U+370B */
  0x0000,   /* U+370C */
  0x0000,   /* U+370D */
  0x0000,   /* U+370E */
  0x0000,   /* U+370F */
  0x0000,   /* U+3710 */
  0x0000,   /* U+3711 */
  0x0000,   /* U+3712 */
  0x0000,   /* U+3713 */
  0x0000,   /* U+3714 */
  0x0000,   /* U+3715 */
  0x0000,   /* U+3716 */
  0x0000,   /* U+3717 */
  0x0000,   /* U+3718 */
  0x0000,   /* U+3719 */
  0x0000,   /* U+371A */
  0x0000,   /* U+371B */
  0x0000,   /* U+371C */
  0x0000,   /* U+371D */
  0x0000,   /* U+371E */
  0x0000,   /* U+371F */
  0x0000,   /* U+3720 */
  0x0000,   /* U+3721 */
  0x0000,   /* U+3722 */
  0x0000,   /* U+3723 */
  0x0000,   /* U+3724 */
  0x0000,   /* U+3725 */
  0x0000,   /* U+3726 */
  0x0000,   /* U+3727 */
  0x0000,   /* U+3728 */
  0x0000,   /* U+3729 */
  0x0000,   /* U+372A */
  0x0000,   /* U+372B */
  0x0000,   /* U+372C */
  0x0000,   /* U+372D */
  0x0000,   /* U+372E */
  0x0000,   /* U+372F */
  0x0000,   /* U+3730 */
  0x0000,   /* U+3731 */
  0x0000,   /* U+3732 */
  0x0000,   /* U+3733 */
  0x0000,   /* U+3734 */
  0x0000,   /* U+3735 */
  0x0000,   /* U+3736 */
  0x0000,   /* U+3737 */
  0x0000,   /* U+3738 */
  0x0000,   /* U+3739 */
  0x0000,   /* U+373A */
  0x0000,   /* U+373B */
  0x0000,   /* U+373C */
  0x0000,   /* U+373D */
  0x0000,   /* U+373E */
  0x0000,   /* U+373F */
  0x0000,   /* U+3740 */
  0x0000,   /* U+3741 */
  0x0000,   /* U+3742 */
  0x0000,   /* U+3743 */
  0x0000,   /* U+3744 */
  0x0000,   /* U+3745 */
  0x0000,   /* U+3746 */
  0x0000,   /* U+3747 */
  0x0000,   /* U+3748 */
  0x0000,   /* U+3749 */
  0x0000,   /* U+374A */
  0x0000,   /* U+374B */
  0x0000,   /* U+374C */
  0x0000,   /* U+374D */
  0x0000,   /* U+374E */
  0x0000,   /* U+374F */
  0x0000,   /* U+3750 */
  0x0000,   /* U+3751 */
  0x0000,   /* U+3752 */
  0x0000,   /* U+3753 */
  0x0000,   /* U+3754 */
  0x0000,   /* U+3755 */
  0x0000,   /* U+3756 */
  0x0000,   /* U+3757 */
  0x0000,   /* U+3758 */
  0x0000,   /* U+3759 */
  0x0000,   /* U+375A */
  0x0000,   /* U+375B */
  0x0000,   /* U+375C */
  0x0000,   /* U+375D */
  0x0000,   /* U+375E */
  0x0000,   /* U+375F */
  0x0000,   /* U+3760 */
  0x0000,   /* U+3761 */
  0x0000,   /* U+3762 */
  0x0000,   /* U+3763 */
  0x0000,   /* U+3764 */
  0x0000,   /* U+3765 */
  0x0000,   /* U+3766 */
  0x0000,   /* U+3767 */
  0x0000,   /* U+3768 */
  0x0000,   /* U+3769 */
  0x0000,   /* U+376A */
  0x0000,   /* U+376B */
  0x0000,   /* U+376C */
  0x0000,   /* U+376D */
  0x0000,   /* U+376E */
  0x0000,   /* U+376F */
  0x0000,   /* U+3770 */
  0x0000,   /* U+3771 */
  0x0000,   /* U+3772 */
  0x0000,   /* U+3773 */
  0x0000,   /* U+3774 */
  0x0000,   /* U+3775 */
  0x0000,   /* U+3776 */
  0x0000,   /* U+3777 */
  0x0000,   /* U+3778 */
  0x0000,   /* U+3779 */
  0x0000,   /* U+377A */
  0x0000,   /* U+377B */
  0x0000,   /* U+377C */
  0x0000,   /* U+377D */
  0x0000,   /* U+377E */
  0x0000,   /* U+377F */
  0x0000,   /* U+3780 */
  0x0000,   /* U+3781 */
  0x0000,   /* U+3782 */
  0x0000,   /* U+3783 */
  0x0000,   /* U+3784 */
  0x0000,   /* U+3785 */
  0x0000,   /* U+3786 */
  0x0000,   /* U+3787 */
  0x0000,   /* U+3788 */
  0x0000,   /* U+3789 */
  0x0000,   /* U+378A */
  0x0000,   /* U+378B */
  0x0000,   /* U+378C */
  0x0000,   /* U+378D */
  0x0000,   /* U+378E */
  0x0000,   /* U+378F */
  0x0000,   /* U+3790 */
  0x0000,   /* U+3791 */
  0x0000,   /* U+3792 */
  0x0000,   /* U+3793 */
  0x0000,   /* U+3794 */
  0x0000,   /* U+3795 */
  0x0000,   /* U+3796 */
  0x0000,   /* U+3797 */
  0x0000,   /* U+3798 */
  0x0000,   /* U+3799 */
  0x0000,   /* U+379A */
  0x0000,   /* U+379B */
  0x0000,   /* U+379C */
  0x0000,   /* U+379D */
  0x0000,   /* U+379E */
  0x0000,   /* U+379F */
  0x0000,   /* U+37A0 */
  0x0000,   /* U+37A1 */
  0x0000,   /* U+37A2 */
  0x0000,   /* U+37A3 */
  0x0000,   /* U+37A4 */
  0x0000,   /* U+37A5 */
  0x0000,   /* U+37A6 */
  0x0000,   /* U+37A7 */
  0x0000,   /* U+37A8 */
  0x0000,   /* U+37A9 */
  0x0000,   /* U+37AA */
  0x0000,   /* U+37AB */
  0x0000,   /* U+37AC */
  0x0000,   /* U+37AD */
  0x0000,   /* U+37AE */
  0x0000,   /* U+37AF */
  0x0000,   /* U+37B0 */
  0x0000,   /* U+37B1 */
  0x0000,   /* U+37B2 */
  0x0000,   /* U+37B3 */
  0x0000,   /* U+37B4 */
  0x0000,   /* U+37B5 */
  0x0000,   /* U+37B6 */
  0x0000,   /* U+37B7 */
  0x0000,   /* U+37B8 */
  0x0000,   /* U+37B9 */
  0x0000,   /* U+37BA */
  0x0000,   /* U+37BB */
  0x0000,   /* U+37BC */
  0x0000,   /* U+37BD */
  0x0000,   /* U+37BE */
  0x0000,   /* U+37BF */
  0x0000,   /* U+37C0 */
  0x0000,   /* U+37C1 */
  0x0000,   /* U+37C2 */
  0x0000,   /* U+37C3 */
  0x0000,   /* U+37C4 */
  0x0000,   /* U+37C5 */
  0x0000,   /* U+37C6 */
  0x0000,   /* U+37C7 */
  0x0000,   /* U+37C8 */
  0x0000,   /* U+37C9 */
  0x0000,   /* U+37CA */
  0x0000,   /* U+37CB */
  0x0000,   /* U+37CC */
  0x0000,   /* U+37CD */
  0x0000,   /* U+37CE */
  0x0000,   /* U+37CF */
  0x0000,   /* U+37D0 */
  0x0000,   /* U+37D1 */
  0x0000,   /* U+37D2 */
  0x0000,   /* U+37D3 */
  0x0000,   /* U+37D4 */
  0x0000,   /* U+37D5 */
  0x0000,   /* U+37D6 */
  0x0000,   /* U+37D7 */
  0x0000,   /* U+37D8 */
  0x0000,   /* U+37D9 */
  0x0000,   /* U+37DA */
  0x0000,   /* U+37DB */
  0x0000,   /* U+37DC */
  0x0000,   /* U+37DD */
  0x0000,   /* U+37DE */
  0x0000,   /* U+37DF */
  0x0000,   /* U+37E0 */
  0x0000,   /* U+37E1 */
  0x0000,   /* U+37E2 */
  0x0000,   /* U+37E3 */
  0x0000,   /* U+37E4 */
  0x0000,   /* U+37E5 */
  0x0000,   /* U+37E6 */
  0x0000,   /* U+37E7 */
  0x0000,   /* U+37E8 */
  0x0000,   /* U+37E9 */
  0x0000,   /* U+37EA */
  0x0000,   /* U+37EB */
  0x0000,   /* U+37EC */
  0x0000,   /* U+37ED */
  0x0000,   /* U+37EE */
  0x0000,   /* U+37EF */
  0x0000,   /* U+37F0 */
  0x0000,   /* U+37F1 */
  0x0000,   /* U+37F2 */
  0x0000,   /* U+37F3 */
  0x0000,   /* U+37F4 */
  0x0000,   /* U+37F5 */
  0x0000,   /* U+37F6 */
  0x0000,   /* U+37F7 */
  0x0000,   /* U+37F8 */
  0x0000,   /* U+37F9 */
  0x0000,   /* U+37FA */
  0x0000,   /* U+37FB */
  0x0000,   /* U+37FC */
  0x0000,   /* U+37FD */
  0x0000,   /* U+37FE */
  0x0000,   /* U+37FF */
};

uint16 zh3_han_p038[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C55,   /* U+3800 */
  0x1C55,   /* U+3801 */
  0x1C55,   /* U+3802 */
  0x1C55,   /* U+3803 */
  0x1C55,   /* U+3804 */
  0x1C56,   /* U+3805 */
  0x1C56,   /* U+3806 */
  0x1C56,   /* U+3807 */
  0x1C56,   /* U+3808 */
  0x1C56,   /* U+3809 */
  0x1C56,   /* U+380A */
  0x1C56,   /* U+380B */
  0x1C56,   /* U+380C */
  0x1C56,   /* U+380D */
  0x1C56,   /* U+380E */
  0x1C56,   /* U+380F */
  0x1C56,   /* U+3810 */
  0x1C57,   /* U+3811 */
  0x1C57,   /* U+3812 */
  0x1C57,   /* U+3813 */
  0x1C57,   /* U+3814 */
  0x1C57,   /* U+3815 */
  0x1C57,   /* U+3816 */
  0x1C57,   /* U+3817 */
  0x1C58,   /* U+3818 */
  0x1C58,   /* U+3819 */
  0x1C58,   /* U+381A */
  0x1C58,   /* U+381B */
  0x1C58,   /* U+381C */
  0x1C59,   /* U+381D */
  0x1C59,   /* U+381E */
  0x1C59,   /* U+381F */
  0x1C5A,   /* U+3820 */
  0x1C5A,   /* U+3821 */
  0x1C5A,   /* U+3822 */
  0x1C5A,   /* U+3823 */
  0x1C5B,   /* U+3824 */
  0x1C5C,   /* U+3825 */
  0x1C5C,   /* U+3826 */
  0x1C5D,   /* U+3827 */
  0x1C63,   /* U+3828 */
  0x1C4D,   /* U+3829 */
  0x1C4B,   /* U+382A */
  0x1C51,   /* U+382B */
  0x1C51,   /* U+382C */
  0x1C53,   /* U+382D */
  0x1C56,   /* U+382E */
  0x1C4C,   /* U+382F */
  0x1C4F,   /* U+3830 */
  0x1C52,   /* U+3831 */
  0x1C4C,   /* U+3832 */
  0x1C4C,   /* U+3833 */
  0x1C4D,   /* U+3834 */
  0x1C4D,   /* U+3835 */
  0x1C4D,   /* U+3836 */
  0x1C4E,   /* U+3837 */
  0x1C4E,   /* U+3838 */
  0x1C4E,   /* U+3839 */
  0x1C4E,   /* U+383A */
  0x1C4E,   /* U+383B */
  0x1C4E,   /* U+383C */
  0x1C4F,   /* U+383D */
  0x1C4F,   /* U+383E */
  0x1C4F,   /* U+383F */
  0x1C4F,   /* U+3840 */
  0x1C50,   /* U+3841 */
  0x1C50,   /* U+3842 */
  0x1C50,   /* U+3843 */
  0x1C50,   /* U+3844 */
  0x1C50,   /* U+3845 */
  0x1C50,   /* U+3846 */
  0x1C51,   /* U+3847 */
  0x1C51,   /* U+3848 */
  0x1C52,   /* U+3849 */
  0x1C52,   /* U+384A */
  0x1C52,   /* U+384B */
  0x1C52,   /* U+384C */
  0x1C52,   /* U+384D */
  0x1C52,   /* U+384E */
  0x1C53,   /* U+384F */
  0x1C53,   /* U+3850 */
  0x1C53,   /* U+3851 */
  0x1C53,   /* U+3852 */
  0x1C53,   /* U+3853 */
  0x1C53,   /* U+3854 */
  0x1C53,   /* U+3855 */
  0x1C53,   /* U+3856 */
  0x1C54,   /* U+3857 */
  0x1C54,   /* U+3858 */
  0x1C54,   /* U+3859 */
  0x1C54,   /* U+385A */
  0x1C54,   /* U+385B */
  0x1C55,   /* U+385C */
  0x1C55,   /* U+385D */
  0x1C55,   /* U+385E */
  0x1C55,   /* U+385F */
  0x1C56,   /* U+3860 */
  0x1C56,   /* U+3861 */
  0x1C57,   /* U+3862 */
  0x1C57,   /* U+3863 */
  0x1C57,   /* U+3864 */
  0x1C58,   /* U+3865 */
  0x1C58,   /* U+3866 */
  0x1C5B,   /* U+3867 */
  0x1C5B,   /* U+3868 */
  0x1C5D,   /* U+3869 */
  0x1C5D,   /* U+386A */
  0x1C53,   /* U+386B */
  0x1C53,   /* U+386C */
  0x1C55,   /* U+386D */
  0x1C57,   /* U+386E */
  0x1C4D,   /* U+386F */
  0x1C4D,   /* U+3870 */
  0x1C4D,   /* U+3871 */
  0x1C4E,   /* U+3872 */
  0x1C4E,   /* U+3873 */
  0x1C4F,   /* U+3874 */
  0x1C4F,   /* U+3875 */
  0x1C4F,   /* U+3876 */
  0x1C4F,   /* U+3877 */
  0x1C4F,   /* U+3878 */
  0x1C4F,   /* U+3879 */
  0x1C4F,   /* U+387A */
  0x1C4F,   /* U+387B */
  0x1C50,   /* U+387C */
  0x1C50,   /* U+387D */
  0x1C50,   /* U+387E */
  0x1C50,   /* U+387F */
  0x1C50,   /* U+3880 */
  0x1C50,   /* U+3881 */
  0x1C50,   /* U+3882 */
  0x1C51,   /* U+3883 */
  0x1C51,   /* U+3884 */
  0x1C51,   /* U+3885 */
  0x1C51,   /* U+3886 */
  0x1C51,   /* U+3887 */
  0x1C52,   /* U+3888 */
  0x1C52,   /* U+3889 */
  0x1C52,   /* U+388A */
  0x1C52,   /* U+388B */
  0x1C52,   /* U+388C */
  0x1C53,   /* U+388D */
  0x1C53,   /* U+388E */
  0x1C53,   /* U+388F */
  0x1C53,   /* U+3890 */
  0x1C54,   /* U+3891 */
  0x1C55,   /* U+3892 */
  0x1C55,   /* U+3893 */
  0x1C55,   /* U+3894 */
  0x1C55,   /* U+3895 */
  0x1C56,   /* U+3896 */
  0x1C56,   /* U+3897 */
  0x1C56,   /* U+3898 */
  0x1C57,   /* U+3899 */
  0x1C57,   /* U+389A */
  0x1C57,   /* U+389B */
  0x1C57,   /* U+389C */
  0x1C5A,   /* U+389D */
  0x1C5B,   /* U+389E */
  0x1C4D,   /* U+389F */
  0x1C4F,   /* U+38A0 */
  0x1C55,   /* U+38A1 */
  0x1C56,   /* U+38A2 */
  0x1C57,   /* U+38A3 */
  0x1C4E,   /* U+38A4 */
  0x1C50,   /* U+38A5 */
  0x1C54,   /* U+38A6 */
  0x1C4B,   /* U+38A7 */
  0x1C4D,   /* U+38A8 */
  0x1C4D,   /* U+38A9 */
  0x1C4D,   /* U+38AA */
  0x1C4D,   /* U+38AB */
  0x1C4E,   /* U+38AC */
  0x1C4E,   /* U+38AD */
  0x1C4F,   /* U+38AE */
  0x1C4F,   /* U+38AF */
  0x1C4F,   /* U+38B0 */
  0x1C4F,   /* U+38B1 */
  0x1C50,   /* U+38B2 */
  0x1C50,   /* U+38B3 */
  0x1C50,   /* U+38B4 */
  0x1C50,   /* U+38B5 */
  0x1C50,   /* U+38B6 */
  0x1C50,   /* U+38B7 */
  0x1C51,   /* U+38B8 */
  0x1C51,   /* U+38B9 */
  0x1C52,   /* U+38BA */
  0x1C52,   /* U+38BB */
  0x1C52,   /* U+38BC */
  0x1C53,   /* U+38BD */
  0x1C53,   /* U+38BE */
  0x1C53,   /* U+38BF */
  0x1C54,   /* U+38C0 */
  0x1C54,   /* U+38C1 */
  0x1C54,   /* U+38C2 */
  0x1C55,   /* U+38C3 */
  0x1C56,   /* U+38C4 */
  0x1C56,   /* U+38C5 */
  0x1C5C,   /* U+38C6 */
  0x1C4F,   /* U+38C7 */
  0x1C57,   /* U+38C8 */
  0x1C4D,   /* U+38C9 */
  0x1C4E,   /* U+38CA */
  0x1C4F,   /* U+38CB */
  0x1C4F,   /* U+38CC */
  0x1C4F,   /* U+38CD */
  0x1C52,   /* U+38CE */
  0x1C53,   /* U+38CF */
  0x1C53,   /* U+38D0 */
  0x1C55,   /* U+38D1 */
  0x1C56,   /* U+38D2 */
  0x1C57,   /* U+38D3 */
  0x1C4C,   /* U+38D4 */
  0x1C4D,   /* U+38D5 */
  0x1C4E,   /* U+38D6 */
  0x1C4E,   /* U+38D7 */
  0x1C4F,   /* U+38D8 */
  0x1C4F,   /* U+38D9 */
  0x1C50,   /* U+38DA */
  0x1C50,   /* U+38DB */
  0x1C50,   /* U+38DC */
  0x1C50,   /* U+38DD */
  0x1C50,   /* U+38DE */
  0x1C50,   /* U+38DF */
  0x1C50,   /* U+38E0 */
  0x1C50,   /* U+38E1 */
  0x1C51,   /* U+38E2 */
  0x1C51,   /* U+38E3 */
  0x1C52,   /* U+38E4 */
  0x1C52,   /* U+38E5 */
  0x1C52,   /* U+38E6 */
  0x1C52,   /* U+38E7 */
  0x1C52,   /* U+38E8 */
  0x1C52,   /* U+38E9 */
  0x1C53,   /* U+38EA */
  0x1C53,   /* U+38EB */
  0x1C53,   /* U+38EC */
  0x1C53,   /* U+38ED */
  0x1C53,   /* U+38EE */
  0x1C54,   /* U+38EF */
  0x1C55,   /* U+38F0 */
  0x1C55,   /* U+38F1 */
  0x1C55,   /* U+38F2 */
  0x1C56,   /* U+38F3 */
  0x1C56,   /* U+38F4 */
  0x1C57,   /* U+38F5 */
  0x1C57,   /* U+38F6 */
  0x1C58,   /* U+38F7 */
  0x1C5A,   /* U+38F8 */
  0x1C5B,   /* U+38F9 */
  0x1C4C,   /* U+38FA */
  0x1C4D,   /* U+38FB */
  0x1C4D,   /* U+38FC */
  0x1C4E,   /* U+38FD */
  0x1C4D,   /* U+38FE */
  0x1C4D,   /* U+38FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3800 */
  0x0020,   /* U+3801 */
  0x0020,   /* U+3802 */
  0x0020,   /* U+3803 */
  0x0020,   /* U+3804 */
  0x0020,   /* U+3805 */
  0x0020,   /* U+3806 */
  0x0020,   /* U+3807 */
  0x0020,   /* U+3808 */
  0x0020,   /* U+3809 */
  0x0020,   /* U+380A */
  0x0020,   /* U+380B */
  0x0020,   /* U+380C */
  0x0020,   /* U+380D */
  0x0020,   /* U+380E */
  0x0020,   /* U+380F */
  0x0020,   /* U+3810 */
  0x0020,   /* U+3811 */
  0x0020,   /* U+3812 */
  0x0020,   /* U+3813 */
  0x0020,   /* U+3814 */
  0x0020,   /* U+3815 */
  0x0020,   /* U+3816 */
  0x0020,   /* U+3817 */
  0x0020,   /* U+3818 */
  0x0020,   /* U+3819 */
  0x0020,   /* U+381A */
  0x0020,   /* U+381B */
  0x0020,   /* U+381C */
  0x0020,   /* U+381D */
  0x0020,   /* U+381E */
  0x0020,   /* U+381F */
  0x0020,   /* U+3820 */
  0x0020,   /* U+3821 */
  0x0020,   /* U+3822 */
  0x0020,   /* U+3823 */
  0x0020,   /* U+3824 */
  0x0020,   /* U+3825 */
  0x0020,   /* U+3826 */
  0x0020,   /* U+3827 */
  0x0020,   /* U+3828 */
  0x0020,   /* U+3829 */
  0x0020,   /* U+382A */
  0x0020,   /* U+382B */
  0x0020,   /* U+382C */
  0x0020,   /* U+382D */
  0x0020,   /* U+382E */
  0x0020,   /* U+382F */
  0x0020,   /* U+3830 */
  0x0020,   /* U+3831 */
  0x0020,   /* U+3832 */
  0x0020,   /* U+3833 */
  0x0020,   /* U+3834 */
  0x0020,   /* U+3835 */
  0x0020,   /* U+3836 */
  0x0020,   /* U+3837 */
  0x0020,   /* U+3838 */
  0x0020,   /* U+3839 */
  0x0020,   /* U+383A */
  0x0020,   /* U+383B */
  0x0020,   /* U+383C */
  0x0020,   /* U+383D */
  0x0020,   /* U+383E */
  0x0020,   /* U+383F */
  0x0020,   /* U+3840 */
  0x0020,   /* U+3841 */
  0x0020,   /* U+3842 */
  0x0020,   /* U+3843 */
  0x0020,   /* U+3844 */
  0x0020,   /* U+3845 */
  0x0020,   /* U+3846 */
  0x0020,   /* U+3847 */
  0x0020,   /* U+3848 */
  0x0020,   /* U+3849 */
  0x0020,   /* U+384A */
  0x0020,   /* U+384B */
  0x0020,   /* U+384C */
  0x0020,   /* U+384D */
  0x0020,   /* U+384E */
  0x0020,   /* U+384F */
  0x0020,   /* U+3850 */
  0x0020,   /* U+3851 */
  0x0020,   /* U+3852 */
  0x0020,   /* U+3853 */
  0x0020,   /* U+3854 */
  0x0020,   /* U+3855 */
  0x0020,   /* U+3856 */
  0x0020,   /* U+3857 */
  0x0020,   /* U+3858 */
  0x0020,   /* U+3859 */
  0x0020,   /* U+385A */
  0x0020,   /* U+385B */
  0x0020,   /* U+385C */
  0x0020,   /* U+385D */
  0x0020,   /* U+385E */
  0x0020,   /* U+385F */
  0x0020,   /* U+3860 */
  0x0020,   /* U+3861 */
  0x0020,   /* U+3862 */
  0x0020,   /* U+3863 */
  0x0020,   /* U+3864 */
  0x0020,   /* U+3865 */
  0x0020,   /* U+3866 */
  0x0020,   /* U+3867 */
  0x0020,   /* U+3868 */
  0x0020,   /* U+3869 */
  0x0020,   /* U+386A */
  0x0020,   /* U+386B */
  0x0020,   /* U+386C */
  0x0020,   /* U+386D */
  0x0020,   /* U+386E */
  0x0020,   /* U+386F */
  0x0020,   /* U+3870 */
  0x0020,   /* U+3871 */
  0x0020,   /* U+3872 */
  0x0020,   /* U+3873 */
  0x0020,   /* U+3874 */
  0x0020,   /* U+3875 */
  0x0020,   /* U+3876 */
  0x0020,   /* U+3877 */
  0x0020,   /* U+3878 */
  0x0020,   /* U+3879 */
  0x0020,   /* U+387A */
  0x0020,   /* U+387B */
  0x0020,   /* U+387C */
  0x0020,   /* U+387D */
  0x0020,   /* U+387E */
  0x0020,   /* U+387F */
  0x0020,   /* U+3880 */
  0x0020,   /* U+3881 */
  0x0020,   /* U+3882 */
  0x0020,   /* U+3883 */
  0x0020,   /* U+3884 */
  0x0020,   /* U+3885 */
  0x0020,   /* U+3886 */
  0x0020,   /* U+3887 */
  0x0020,   /* U+3888 */
  0x0020,   /* U+3889 */
  0x0020,   /* U+388A */
  0x0020,   /* U+388B */
  0x0020,   /* U+388C */
  0x0020,   /* U+388D */
  0x0020,   /* U+388E */
  0x0020,   /* U+388F */
  0x0020,   /* U+3890 */
  0x0020,   /* U+3891 */
  0x0020,   /* U+3892 */
  0x0020,   /* U+3893 */
  0x0020,   /* U+3894 */
  0x0020,   /* U+3895 */
  0x0020,   /* U+3896 */
  0x0020,   /* U+3897 */
  0x0020,   /* U+3898 */
  0x0020,   /* U+3899 */
  0x0020,   /* U+389A */
  0x0020,   /* U+389B */
  0x0020,   /* U+389C */
  0x0020,   /* U+389D */
  0x0020,   /* U+389E */
  0x0020,   /* U+389F */
  0x0020,   /* U+38A0 */
  0x0020,   /* U+38A1 */
  0x0020,   /* U+38A2 */
  0x0020,   /* U+38A3 */
  0x0020,   /* U+38A4 */
  0x0020,   /* U+38A5 */
  0x0020,   /* U+38A6 */
  0x0020,   /* U+38A7 */
  0x0020,   /* U+38A8 */
  0x0020,   /* U+38A9 */
  0x0020,   /* U+38AA */
  0x0020,   /* U+38AB */
  0x0020,   /* U+38AC */
  0x0020,   /* U+38AD */
  0x0020,   /* U+38AE */
  0x0020,   /* U+38AF */
  0x0020,   /* U+38B0 */
  0x0020,   /* U+38B1 */
  0x0020,   /* U+38B2 */
  0x0020,   /* U+38B3 */
  0x0020,   /* U+38B4 */
  0x0020,   /* U+38B5 */
  0x0020,   /* U+38B6 */
  0x0020,   /* U+38B7 */
  0x0020,   /* U+38B8 */
  0x0020,   /* U+38B9 */
  0x0020,   /* U+38BA */
  0x0020,   /* U+38BB */
  0x0020,   /* U+38BC */
  0x0020,   /* U+38BD */
  0x0020,   /* U+38BE */
  0x0020,   /* U+38BF */
  0x0020,   /* U+38C0 */
  0x0020,   /* U+38C1 */
  0x0020,   /* U+38C2 */
  0x0020,   /* U+38C3 */
  0x0020,   /* U+38C4 */
  0x0020,   /* U+38C5 */
  0x0020,   /* U+38C6 */
  0x0020,   /* U+38C7 */
  0x0020,   /* U+38C8 */
  0x0020,   /* U+38C9 */
  0x0020,   /* U+38CA */
  0x0020,   /* U+38CB */
  0x0020,   /* U+38CC */
  0x0020,   /* U+38CD */
  0x0020,   /* U+38CE */
  0x0020,   /* U+38CF */
  0x0020,   /* U+38D0 */
  0x0020,   /* U+38D1 */
  0x0020,   /* U+38D2 */
  0x0020,   /* U+38D3 */
  0x0020,   /* U+38D4 */
  0x0020,   /* U+38D5 */
  0x0020,   /* U+38D6 */
  0x0020,   /* U+38D7 */
  0x0020,   /* U+38D8 */
  0x0020,   /* U+38D9 */
  0x0020,   /* U+38DA */
  0x0020,   /* U+38DB */
  0x0020,   /* U+38DC */
  0x0020,   /* U+38DD */
  0x0020,   /* U+38DE */
  0x0020,   /* U+38DF */
  0x0020,   /* U+38E0 */
  0x0020,   /* U+38E1 */
  0x0020,   /* U+38E2 */
  0x0020,   /* U+38E3 */
  0x0020,   /* U+38E4 */
  0x0020,   /* U+38E5 */
  0x0020,   /* U+38E6 */
  0x0020,   /* U+38E7 */
  0x0020,   /* U+38E8 */
  0x0020,   /* U+38E9 */
  0x0020,   /* U+38EA */
  0x0020,   /* U+38EB */
  0x0020,   /* U+38EC */
  0x0020,   /* U+38ED */
  0x0020,   /* U+38EE */
  0x0020,   /* U+38EF */
  0x0020,   /* U+38F0 */
  0x0020,   /* U+38F1 */
  0x0020,   /* U+38F2 */
  0x0020,   /* U+38F3 */
  0x0020,   /* U+38F4 */
  0x0020,   /* U+38F5 */
  0x0020,   /* U+38F6 */
  0x0020,   /* U+38F7 */
  0x0020,   /* U+38F8 */
  0x0020,   /* U+38F9 */
  0x0020,   /* U+38FA */
  0x0020,   /* U+38FB */
  0x0020,   /* U+38FC */
  0x0020,   /* U+38FD */
  0x0020,   /* U+38FE */
  0x0020,   /* U+38FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3800 */
  0x0002,   /* U+3801 */
  0x0002,   /* U+3802 */
  0x0002,   /* U+3803 */
  0x0002,   /* U+3804 */
  0x0002,   /* U+3805 */
  0x0002,   /* U+3806 */
  0x0002,   /* U+3807 */
  0x0002,   /* U+3808 */
  0x0002,   /* U+3809 */
  0x0002,   /* U+380A */
  0x0002,   /* U+380B */
  0x0002,   /* U+380C */
  0x0002,   /* U+380D */
  0x0002,   /* U+380E */
  0x0002,   /* U+380F */
  0x0002,   /* U+3810 */
  0x0002,   /* U+3811 */
  0x0002,   /* U+3812 */
  0x0002,   /* U+3813 */
  0x0002,   /* U+3814 */
  0x0002,   /* U+3815 */
  0x0002,   /* U+3816 */
  0x0002,   /* U+3817 */
  0x0002,   /* U+3818 */
  0x0002,   /* U+3819 */
  0x0002,   /* U+381A */
  0x0002,   /* U+381B */
  0x0002,   /* U+381C */
  0x0002,   /* U+381D */
  0x0002,   /* U+381E */
  0x0002,   /* U+381F */
  0x0002,   /* U+3820 */
  0x0002,   /* U+3821 */
  0x0002,   /* U+3822 */
  0x0002,   /* U+3823 */
  0x0002,   /* U+3824 */
  0x0002,   /* U+3825 */
  0x0002,   /* U+3826 */
  0x0002,   /* U+3827 */
  0x0002,   /* U+3828 */
  0x0002,   /* U+3829 */
  0x0002,   /* U+382A */
  0x0002,   /* U+382B */
  0x0002,   /* U+382C */
  0x0002,   /* U+382D */
  0x0002,   /* U+382E */
  0x0002,   /* U+382F */
  0x0002,   /* U+3830 */
  0x0002,   /* U+3831 */
  0x0002,   /* U+3832 */
  0x0002,   /* U+3833 */
  0x0002,   /* U+3834 */
  0x0002,   /* U+3835 */
  0x0002,   /* U+3836 */
  0x0002,   /* U+3837 */
  0x0002,   /* U+3838 */
  0x0002,   /* U+3839 */
  0x0002,   /* U+383A */
  0x0002,   /* U+383B */
  0x0002,   /* U+383C */
  0x0002,   /* U+383D */
  0x0002,   /* U+383E */
  0x0002,   /* U+383F */
  0x0002,   /* U+3840 */
  0x0002,   /* U+3841 */
  0x0002,   /* U+3842 */
  0x0002,   /* U+3843 */
  0x0002,   /* U+3844 */
  0x0002,   /* U+3845 */
  0x0002,   /* U+3846 */
  0x0002,   /* U+3847 */
  0x0002,   /* U+3848 */
  0x0002,   /* U+3849 */
  0x0002,   /* U+384A */
  0x0002,   /* U+384B */
  0x0002,   /* U+384C */
  0x0002,   /* U+384D */
  0x0002,   /* U+384E */
  0x0002,   /* U+384F */
  0x0002,   /* U+3850 */
  0x0002,   /* U+3851 */
  0x0002,   /* U+3852 */
  0x0002,   /* U+3853 */
  0x0002,   /* U+3854 */
  0x0002,   /* U+3855 */
  0x0002,   /* U+3856 */
  0x0002,   /* U+3857 */
  0x0002,   /* U+3858 */
  0x0002,   /* U+3859 */
  0x0002,   /* U+385A */
  0x0002,   /* U+385B */
  0x0002,   /* U+385C */
  0x0002,   /* U+385D */
  0x0002,   /* U+385E */
  0x0002,   /* U+385F */
  0x0002,   /* U+3860 */
  0x0002,   /* U+3861 */
  0x0002,   /* U+3862 */
  0x0002,   /* U+3863 */
  0x0002,   /* U+3864 */
  0x0002,   /* U+3865 */
  0x0002,   /* U+3866 */
  0x0002,   /* U+3867 */
  0x0002,   /* U+3868 */
  0x0002,   /* U+3869 */
  0x0002,   /* U+386A */
  0x0002,   /* U+386B */
  0x0002,   /* U+386C */
  0x0002,   /* U+386D */
  0x0002,   /* U+386E */
  0x0002,   /* U+386F */
  0x0002,   /* U+3870 */
  0x0002,   /* U+3871 */
  0x0002,   /* U+3872 */
  0x0002,   /* U+3873 */
  0x0002,   /* U+3874 */
  0x0002,   /* U+3875 */
  0x0002,   /* U+3876 */
  0x0002,   /* U+3877 */
  0x0002,   /* U+3878 */
  0x0002,   /* U+3879 */
  0x0002,   /* U+387A */
  0x0002,   /* U+387B */
  0x0002,   /* U+387C */
  0x0002,   /* U+387D */
  0x0002,   /* U+387E */
  0x0002,   /* U+387F */
  0x0002,   /* U+3880 */
  0x0002,   /* U+3881 */
  0x0002,   /* U+3882 */
  0x0002,   /* U+3883 */
  0x0002,   /* U+3884 */
  0x0002,   /* U+3885 */
  0x0002,   /* U+3886 */
  0x0002,   /* U+3887 */
  0x0002,   /* U+3888 */
  0x0002,   /* U+3889 */
  0x0002,   /* U+388A */
  0x0002,   /* U+388B */
  0x0002,   /* U+388C */
  0x0002,   /* U+388D */
  0x0002,   /* U+388E */
  0x0002,   /* U+388F */
  0x0002,   /* U+3890 */
  0x0002,   /* U+3891 */
  0x0002,   /* U+3892 */
  0x0002,   /* U+3893 */
  0x0002,   /* U+3894 */
  0x0002,   /* U+3895 */
  0x0002,   /* U+3896 */
  0x0002,   /* U+3897 */
  0x0002,   /* U+3898 */
  0x0002,   /* U+3899 */
  0x0002,   /* U+389A */
  0x0002,   /* U+389B */
  0x0002,   /* U+389C */
  0x0002,   /* U+389D */
  0x0002,   /* U+389E */
  0x0002,   /* U+389F */
  0x0002,   /* U+38A0 */
  0x0002,   /* U+38A1 */
  0x0002,   /* U+38A2 */
  0x0002,   /* U+38A3 */
  0x0002,   /* U+38A4 */
  0x0002,   /* U+38A5 */
  0x0002,   /* U+38A6 */
  0x0002,   /* U+38A7 */
  0x0002,   /* U+38A8 */
  0x0002,   /* U+38A9 */
  0x0002,   /* U+38AA */
  0x0002,   /* U+38AB */
  0x0002,   /* U+38AC */
  0x0002,   /* U+38AD */
  0x0002,   /* U+38AE */
  0x0002,   /* U+38AF */
  0x0002,   /* U+38B0 */
  0x0002,   /* U+38B1 */
  0x0002,   /* U+38B2 */
  0x0002,   /* U+38B3 */
  0x0002,   /* U+38B4 */
  0x0002,   /* U+38B5 */
  0x0002,   /* U+38B6 */
  0x0002,   /* U+38B7 */
  0x0002,   /* U+38B8 */
  0x0002,   /* U+38B9 */
  0x0002,   /* U+38BA */
  0x0002,   /* U+38BB */
  0x0002,   /* U+38BC */
  0x0002,   /* U+38BD */
  0x0002,   /* U+38BE */
  0x0002,   /* U+38BF */
  0x0002,   /* U+38C0 */
  0x0002,   /* U+38C1 */
  0x0002,   /* U+38C2 */
  0x0002,   /* U+38C3 */
  0x0002,   /* U+38C4 */
  0x0002,   /* U+38C5 */
  0x0002,   /* U+38C6 */
  0x0002,   /* U+38C7 */
  0x0002,   /* U+38C8 */
  0x0002,   /* U+38C9 */
  0x0002,   /* U+38CA */
  0x0002,   /* U+38CB */
  0x0002,   /* U+38CC */
  0x0002,   /* U+38CD */
  0x0002,   /* U+38CE */
  0x0002,   /* U+38CF */
  0x0002,   /* U+38D0 */
  0x0002,   /* U+38D1 */
  0x0002,   /* U+38D2 */
  0x0002,   /* U+38D3 */
  0x0002,   /* U+38D4 */
  0x0002,   /* U+38D5 */
  0x0002,   /* U+38D6 */
  0x0002,   /* U+38D7 */
  0x0002,   /* U+38D8 */
  0x0002,   /* U+38D9 */
  0x0002,   /* U+38DA */
  0x0002,   /* U+38DB */
  0x0002,   /* U+38DC */
  0x0002,   /* U+38DD */
  0x0002,   /* U+38DE */
  0x0002,   /* U+38DF */
  0x0002,   /* U+38E0 */
  0x0002,   /* U+38E1 */
  0x0002,   /* U+38E2 */
  0x0002,   /* U+38E3 */
  0x0002,   /* U+38E4 */
  0x0002,   /* U+38E5 */
  0x0002,   /* U+38E6 */
  0x0002,   /* U+38E7 */
  0x0002,   /* U+38E8 */
  0x0002,   /* U+38E9 */
  0x0002,   /* U+38EA */
  0x0002,   /* U+38EB */
  0x0002,   /* U+38EC */
  0x0002,   /* U+38ED */
  0x0002,   /* U+38EE */
  0x0002,   /* U+38EF */
  0x0002,   /* U+38F0 */
  0x0002,   /* U+38F1 */
  0x0002,   /* U+38F2 */
  0x0002,   /* U+38F3 */
  0x0002,   /* U+38F4 */
  0x0002,   /* U+38F5 */
  0x0002,   /* U+38F6 */
  0x0002,   /* U+38F7 */
  0x0002,   /* U+38F8 */
  0x0002,   /* U+38F9 */
  0x0002,   /* U+38FA */
  0x0002,   /* U+38FB */
  0x0002,   /* U+38FC */
  0x0002,   /* U+38FD */
  0x0002,   /* U+38FE */
  0x0002,   /* U+38FF */

  /* Primary weight 2 for each character. */
  0x8508,   /* U+3800 */
  0x8509,   /* U+3801 */
  0x850A,   /* U+3802 */
  0x850B,   /* U+3803 */
  0x850C,   /* U+3804 */
  0x8403,   /* U+3805 */
  0x8404,   /* U+3806 */
  0x8405,   /* U+3807 */
  0x8406,   /* U+3808 */
  0x8407,   /* U+3809 */
  0x8408,   /* U+380A */
  0x8409,   /* U+380B */
  0x840A,   /* U+380C */
  0x840B,   /* U+380D */
  0x840C,   /* U+380E */
  0x840D,   /* U+380F */
  0x840E,   /* U+3810 */
  0x8313,   /* U+3811 */
  0x8314,   /* U+3812 */
  0x8315,   /* U+3813 */
  0x8316,   /* U+3814 */
  0x8317,   /* U+3815 */
  0x8318,   /* U+3816 */
  0x8319,   /* U+3817 */
  0x822A,   /* U+3818 */
  0x822B,   /* U+3819 */
  0x822C,   /* U+381A */
  0x822D,   /* U+381B */
  0x822E,   /* U+381C */
  0x81D3,   /* U+381D */
  0x81D4,   /* U+381E */
  0x81D5,   /* U+381F */
  0x814E,   /* U+3820 */
  0x814F,   /* U+3821 */
  0x8150,   /* U+3822 */
  0x8151,   /* U+3823 */
  0x80E6,   /* U+3824 */
  0x80C0,   /* U+3825 */
  0x80C1,   /* U+3826 */
  0x808D,   /* U+3827 */
  0x800D,   /* U+3828 */
  0x839B,   /* U+3829 */
  0x8142,   /* U+382A */
  0x8694,   /* U+382B */
  0x8695,   /* U+382C */
  0x867C,   /* U+382D */
  0x8458,   /* U+382E */
  0x8223,   /* U+382F */
  0x85AB,   /* U+3830 */
  0x86B0,   /* U+3831 */
  0x822A,   /* U+3832 */
  0x822B,   /* U+3833 */
  0x83B1,   /* U+3834 */
  0x83B2,   /* U+3835 */
  0x83B3,   /* U+3836 */
  0x8516,   /* U+3837 */
  0x8517,   /* U+3838 */
  0x8518,   /* U+3839 */
  0x8519,   /* U+383A */
  0x851A,   /* U+383B */
  0x851B,   /* U+383C */
  0x85BD,   /* U+383D */
  0x85BE,   /* U+383E */
  0x85BF,   /* U+383F */
  0x85C0,   /* U+3840 */
  0x85FF,   /* U+3841 */
  0x8600,   /* U+3842 */
  0x8601,   /* U+3843 */
  0x8602,   /* U+3844 */
  0x8603,   /* U+3845 */
  0x8604,   /* U+3846 */
  0x86AA,   /* U+3847 */
  0x86AB,   /* U+3848 */
  0x86C3,   /* U+3849 */
  0x86C4,   /* U+384A */
  0x86C5,   /* U+384B */
  0x86C6,   /* U+384C */
  0x86C7,   /* U+384D */
  0x86C8,   /* U+384E */
  0x8698,   /* U+384F */
  0x8699,   /* U+3850 */
  0x869A,   /* U+3851 */
  0x869B,   /* U+3852 */
  0x869C,   /* U+3853 */
  0x869D,   /* U+3854 */
  0x869E,   /* U+3855 */
  0x869F,   /* U+3856 */
  0x8596,   /* U+3857 */
  0x8597,   /* U+3858 */
  0x8598,   /* U+3859 */
  0x8599,   /* U+385A */
  0x859A,   /* U+385B */
  0x856D,   /* U+385C */
  0x856E,   /* U+385D */
  0x856F,   /* U+385E */
  0x8570,   /* U+385F */
  0x8469,   /* U+3860 */
  0x846A,   /* U+3861 */
  0x8358,   /* U+3862 */
  0x8359,   /* U+3863 */
  0x835A,   /* U+3864 */
  0x8267,   /* U+3865 */
  0x8268,   /* U+3866 */
  0x80FB,   /* U+3867 */
  0x80FC,   /* U+3868 */
  0x809D,   /* U+3869 */
  0x809E,   /* U+386A */
  0x86D8,   /* U+386B */
  0x86D9,   /* U+386C */
  0x8591,   /* U+386D */
  0x8378,   /* U+386E */
  0x83D2,   /* U+386F */
  0x83D3,   /* U+3870 */
  0x83D4,   /* U+3871 */
  0x8554,   /* U+3872 */
  0x8555,   /* U+3873 */
  0x85F7,   /* U+3874 */
  0x85F8,   /* U+3875 */
  0x85F9,   /* U+3876 */
  0x85FA,   /* U+3877 */
  0x85FB,   /* U+3878 */
  0x85FC,   /* U+3879 */
  0x85FD,   /* U+387A */
  0x85FE,   /* U+387B */
  0x8641,   /* U+387C */
  0x8642,   /* U+387D */
  0x8643,   /* U+387E */
  0x8644,   /* U+387F */
  0x8645,   /* U+3880 */
  0x8646,   /* U+3881 */
  0x8647,   /* U+3882 */
  0x86E6,   /* U+3883 */
  0x86E7,   /* U+3884 */
  0x86E8,   /* U+3885 */
  0x86E9,   /* U+3886 */
  0x86EA,   /* U+3887 */
  0x8706,   /* U+3888 */
  0x8707,   /* U+3889 */
  0x8708,   /* U+388A */
  0x8709,   /* U+388B */
  0x870A,   /* U+388C */
  0x86E4,   /* U+388D */
  0x86E5,   /* U+388E */
  0x86E6,   /* U+388F */
  0x86E7,   /* U+3890 */
  0x85D0,   /* U+3891 */
  0x85A3,   /* U+3892 */
  0x85A4,   /* U+3893 */
  0x85A5,   /* U+3894 */
  0x85A6,   /* U+3895 */
  0x849D,   /* U+3896 */
  0x849E,   /* U+3897 */
  0x849F,   /* U+3898 */
  0x837F,   /* U+3899 */
  0x8380,   /* U+389A */
  0x8381,   /* U+389B */
  0x8382,   /* U+389C */
  0x818D,   /* U+389D */
  0x8105,   /* U+389E */
  0x83E7,   /* U+389F */
  0x861D,   /* U+38A0 */
  0x85D2,   /* U+38A1 */
  0x84C5,   /* U+38A2 */
  0x839C,   /* U+38A3 */
  0x8580,   /* U+38A4 */
  0x867E,   /* U+38A5 */
  0x85F8,   /* U+38A6 */
  0x815E,   /* U+38A7 */
  0x83FC,   /* U+38A8 */
  0x83FD,   /* U+38A9 */
  0x83FE,   /* U+38AA */
  0x83FF,   /* U+38AB */
  0x858A,   /* U+38AC */
  0x858B,   /* U+38AD */
  0x8637,   /* U+38AE */
  0x8638,   /* U+38AF */
  0x8639,   /* U+38B0 */
  0x863A,   /* U+38B1 */
  0x8689,   /* U+38B2 */
  0x868A,   /* U+38B3 */
  0x868B,   /* U+38B4 */
  0x868C,   /* U+38B5 */
  0x868D,   /* U+38B6 */
  0x868E,   /* U+38B7 */
  0x8736,   /* U+38B8 */
  0x8737,   /* U+38B9 */
  0x8755,   /* U+38BA */
  0x8756,   /* U+38BB */
  0x8757,   /* U+38BC */
  0x8731,   /* U+38BD */
  0x8732,   /* U+38BE */
  0x8733,   /* U+38BF */
  0x8601,   /* U+38C0 */
  0x8602,   /* U+38C1 */
  0x8603,   /* U+38C2 */
  0x85DF,   /* U+38C3 */
  0x84CE,   /* U+38C4 */
  0x84CF,   /* U+38C5 */
  0x80E2,   /* U+38C6 */
  0x8655,   /* U+38C7 */
  0x83B3,   /* U+38C8 */
  0x8417,   /* U+38C9 */
  0x85A4,   /* U+38CA */
  0x865B,   /* U+38CB */
  0x865C,   /* U+38CC */
  0x865D,   /* U+38CD */
  0x877F,   /* U+38CE */
  0x8755,   /* U+38CF */
  0x8756,   /* U+38D0 */
  0x85F8,   /* U+38D1 */
  0x84E5,   /* U+38D2 */
  0x83B6,   /* U+38D3 */
  0x8261,   /* U+38D4 */
  0x841E,   /* U+38D5 */
  0x85B0,   /* U+38D6 */
  0x85B1,   /* U+38D7 */
  0x866E,   /* U+38D8 */
  0x866F,   /* U+38D9 */
  0x86C3,   /* U+38DA */
  0x86C4,   /* U+38DB */
  0x86C5,   /* U+38DC */
  0x86C6,   /* U+38DD */
  0x86C7,   /* U+38DE */
  0x86C8,   /* U+38DF */
  0x86C9,   /* U+38E0 */
  0x86CA,   /* U+38E1 */
  0x8764,   /* U+38E2 */
  0x8765,   /* U+38E3 */
  0x8799,   /* U+38E4 */
  0x879A,   /* U+38E5 */
  0x879B,   /* U+38E6 */
  0x879C,   /* U+38E7 */
  0x879D,   /* U+38E8 */
  0x879E,   /* U+38E9 */
  0x8766,   /* U+38EA */
  0x8767,   /* U+38EB */
  0x8768,   /* U+38EC */
  0x8769,   /* U+38ED */
  0x876A,   /* U+38EE */
  0x8624,   /* U+38EF */
  0x8603,   /* U+38F0 */
  0x8604,   /* U+38F1 */
  0x8605,   /* U+38F2 */
  0x84F3,   /* U+38F3 */
  0x84F4,   /* U+38F4 */
  0x83BD,   /* U+38F5 */
  0x83BE,   /* U+38F6 */
  0x82A4,   /* U+38F7 */
  0x81B1,   /* U+38F8 */
  0x8120,   /* U+38F9 */
  0x8266,   /* U+38FA */
  0x8428,   /* U+38FB */
  0x8436,   /* U+38FC */
  0x85D0,   /* U+38FD */
  0x8437,   /* U+38FE */
  0x8438,   /* U+38FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3800 */
  0x0000,   /* U+3801 */
  0x0000,   /* U+3802 */
  0x0000,   /* U+3803 */
  0x0000,   /* U+3804 */
  0x0000,   /* U+3805 */
  0x0000,   /* U+3806 */
  0x0000,   /* U+3807 */
  0x0000,   /* U+3808 */
  0x0000,   /* U+3809 */
  0x0000,   /* U+380A */
  0x0000,   /* U+380B */
  0x0000,   /* U+380C */
  0x0000,   /* U+380D */
  0x0000,   /* U+380E */
  0x0000,   /* U+380F */
  0x0000,   /* U+3810 */
  0x0000,   /* U+3811 */
  0x0000,   /* U+3812 */
  0x0000,   /* U+3813 */
  0x0000,   /* U+3814 */
  0x0000,   /* U+3815 */
  0x0000,   /* U+3816 */
  0x0000,   /* U+3817 */
  0x0000,   /* U+3818 */
  0x0000,   /* U+3819 */
  0x0000,   /* U+381A */
  0x0000,   /* U+381B */
  0x0000,   /* U+381C */
  0x0000,   /* U+381D */
  0x0000,   /* U+381E */
  0x0000,   /* U+381F */
  0x0000,   /* U+3820 */
  0x0000,   /* U+3821 */
  0x0000,   /* U+3822 */
  0x0000,   /* U+3823 */
  0x0000,   /* U+3824 */
  0x0000,   /* U+3825 */
  0x0000,   /* U+3826 */
  0x0000,   /* U+3827 */
  0x0000,   /* U+3828 */
  0x0000,   /* U+3829 */
  0x0000,   /* U+382A */
  0x0000,   /* U+382B */
  0x0000,   /* U+382C */
  0x0000,   /* U+382D */
  0x0000,   /* U+382E */
  0x0000,   /* U+382F */
  0x0000,   /* U+3830 */
  0x0000,   /* U+3831 */
  0x0000,   /* U+3832 */
  0x0000,   /* U+3833 */
  0x0000,   /* U+3834 */
  0x0000,   /* U+3835 */
  0x0000,   /* U+3836 */
  0x0000,   /* U+3837 */
  0x0000,   /* U+3838 */
  0x0000,   /* U+3839 */
  0x0000,   /* U+383A */
  0x0000,   /* U+383B */
  0x0000,   /* U+383C */
  0x0000,   /* U+383D */
  0x0000,   /* U+383E */
  0x0000,   /* U+383F */
  0x0000,   /* U+3840 */
  0x0000,   /* U+3841 */
  0x0000,   /* U+3842 */
  0x0000,   /* U+3843 */
  0x0000,   /* U+3844 */
  0x0000,   /* U+3845 */
  0x0000,   /* U+3846 */
  0x0000,   /* U+3847 */
  0x0000,   /* U+3848 */
  0x0000,   /* U+3849 */
  0x0000,   /* U+384A */
  0x0000,   /* U+384B */
  0x0000,   /* U+384C */
  0x0000,   /* U+384D */
  0x0000,   /* U+384E */
  0x0000,   /* U+384F */
  0x0000,   /* U+3850 */
  0x0000,   /* U+3851 */
  0x0000,   /* U+3852 */
  0x0000,   /* U+3853 */
  0x0000,   /* U+3854 */
  0x0000,   /* U+3855 */
  0x0000,   /* U+3856 */
  0x0000,   /* U+3857 */
  0x0000,   /* U+3858 */
  0x0000,   /* U+3859 */
  0x0000,   /* U+385A */
  0x0000,   /* U+385B */
  0x0000,   /* U+385C */
  0x0000,   /* U+385D */
  0x0000,   /* U+385E */
  0x0000,   /* U+385F */
  0x0000,   /* U+3860 */
  0x0000,   /* U+3861 */
  0x0000,   /* U+3862 */
  0x0000,   /* U+3863 */
  0x0000,   /* U+3864 */
  0x0000,   /* U+3865 */
  0x0000,   /* U+3866 */
  0x0000,   /* U+3867 */
  0x0000,   /* U+3868 */
  0x0000,   /* U+3869 */
  0x0000,   /* U+386A */
  0x0000,   /* U+386B */
  0x0000,   /* U+386C */
  0x0000,   /* U+386D */
  0x0000,   /* U+386E */
  0x0000,   /* U+386F */
  0x0000,   /* U+3870 */
  0x0000,   /* U+3871 */
  0x0000,   /* U+3872 */
  0x0000,   /* U+3873 */
  0x0000,   /* U+3874 */
  0x0000,   /* U+3875 */
  0x0000,   /* U+3876 */
  0x0000,   /* U+3877 */
  0x0000,   /* U+3878 */
  0x0000,   /* U+3879 */
  0x0000,   /* U+387A */
  0x0000,   /* U+387B */
  0x0000,   /* U+387C */
  0x0000,   /* U+387D */
  0x0000,   /* U+387E */
  0x0000,   /* U+387F */
  0x0000,   /* U+3880 */
  0x0000,   /* U+3881 */
  0x0000,   /* U+3882 */
  0x0000,   /* U+3883 */
  0x0000,   /* U+3884 */
  0x0000,   /* U+3885 */
  0x0000,   /* U+3886 */
  0x0000,   /* U+3887 */
  0x0000,   /* U+3888 */
  0x0000,   /* U+3889 */
  0x0000,   /* U+388A */
  0x0000,   /* U+388B */
  0x0000,   /* U+388C */
  0x0000,   /* U+388D */
  0x0000,   /* U+388E */
  0x0000,   /* U+388F */
  0x0000,   /* U+3890 */
  0x0000,   /* U+3891 */
  0x0000,   /* U+3892 */
  0x0000,   /* U+3893 */
  0x0000,   /* U+3894 */
  0x0000,   /* U+3895 */
  0x0000,   /* U+3896 */
  0x0000,   /* U+3897 */
  0x0000,   /* U+3898 */
  0x0000,   /* U+3899 */
  0x0000,   /* U+389A */
  0x0000,   /* U+389B */
  0x0000,   /* U+389C */
  0x0000,   /* U+389D */
  0x0000,   /* U+389E */
  0x0000,   /* U+389F */
  0x0000,   /* U+38A0 */
  0x0000,   /* U+38A1 */
  0x0000,   /* U+38A2 */
  0x0000,   /* U+38A3 */
  0x0000,   /* U+38A4 */
  0x0000,   /* U+38A5 */
  0x0000,   /* U+38A6 */
  0x0000,   /* U+38A7 */
  0x0000,   /* U+38A8 */
  0x0000,   /* U+38A9 */
  0x0000,   /* U+38AA */
  0x0000,   /* U+38AB */
  0x0000,   /* U+38AC */
  0x0000,   /* U+38AD */
  0x0000,   /* U+38AE */
  0x0000,   /* U+38AF */
  0x0000,   /* U+38B0 */
  0x0000,   /* U+38B1 */
  0x0000,   /* U+38B2 */
  0x0000,   /* U+38B3 */
  0x0000,   /* U+38B4 */
  0x0000,   /* U+38B5 */
  0x0000,   /* U+38B6 */
  0x0000,   /* U+38B7 */
  0x0000,   /* U+38B8 */
  0x0000,   /* U+38B9 */
  0x0000,   /* U+38BA */
  0x0000,   /* U+38BB */
  0x0000,   /* U+38BC */
  0x0000,   /* U+38BD */
  0x0000,   /* U+38BE */
  0x0000,   /* U+38BF */
  0x0000,   /* U+38C0 */
  0x0000,   /* U+38C1 */
  0x0000,   /* U+38C2 */
  0x0000,   /* U+38C3 */
  0x0000,   /* U+38C4 */
  0x0000,   /* U+38C5 */
  0x0000,   /* U+38C6 */
  0x0000,   /* U+38C7 */
  0x0000,   /* U+38C8 */
  0x0000,   /* U+38C9 */
  0x0000,   /* U+38CA */
  0x0000,   /* U+38CB */
  0x0000,   /* U+38CC */
  0x0000,   /* U+38CD */
  0x0000,   /* U+38CE */
  0x0000,   /* U+38CF */
  0x0000,   /* U+38D0 */
  0x0000,   /* U+38D1 */
  0x0000,   /* U+38D2 */
  0x0000,   /* U+38D3 */
  0x0000,   /* U+38D4 */
  0x0000,   /* U+38D5 */
  0x0000,   /* U+38D6 */
  0x0000,   /* U+38D7 */
  0x0000,   /* U+38D8 */
  0x0000,   /* U+38D9 */
  0x0000,   /* U+38DA */
  0x0000,   /* U+38DB */
  0x0000,   /* U+38DC */
  0x0000,   /* U+38DD */
  0x0000,   /* U+38DE */
  0x0000,   /* U+38DF */
  0x0000,   /* U+38E0 */
  0x0000,   /* U+38E1 */
  0x0000,   /* U+38E2 */
  0x0000,   /* U+38E3 */
  0x0000,   /* U+38E4 */
  0x0000,   /* U+38E5 */
  0x0000,   /* U+38E6 */
  0x0000,   /* U+38E7 */
  0x0000,   /* U+38E8 */
  0x0000,   /* U+38E9 */
  0x0000,   /* U+38EA */
  0x0000,   /* U+38EB */
  0x0000,   /* U+38EC */
  0x0000,   /* U+38ED */
  0x0000,   /* U+38EE */
  0x0000,   /* U+38EF */
  0x0000,   /* U+38F0 */
  0x0000,   /* U+38F1 */
  0x0000,   /* U+38F2 */
  0x0000,   /* U+38F3 */
  0x0000,   /* U+38F4 */
  0x0000,   /* U+38F5 */
  0x0000,   /* U+38F6 */
  0x0000,   /* U+38F7 */
  0x0000,   /* U+38F8 */
  0x0000,   /* U+38F9 */
  0x0000,   /* U+38FA */
  0x0000,   /* U+38FB */
  0x0000,   /* U+38FC */
  0x0000,   /* U+38FD */
  0x0000,   /* U+38FE */
  0x0000,   /* U+38FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3800 */
  0x0000,   /* U+3801 */
  0x0000,   /* U+3802 */
  0x0000,   /* U+3803 */
  0x0000,   /* U+3804 */
  0x0000,   /* U+3805 */
  0x0000,   /* U+3806 */
  0x0000,   /* U+3807 */
  0x0000,   /* U+3808 */
  0x0000,   /* U+3809 */
  0x0000,   /* U+380A */
  0x0000,   /* U+380B */
  0x0000,   /* U+380C */
  0x0000,   /* U+380D */
  0x0000,   /* U+380E */
  0x0000,   /* U+380F */
  0x0000,   /* U+3810 */
  0x0000,   /* U+3811 */
  0x0000,   /* U+3812 */
  0x0000,   /* U+3813 */
  0x0000,   /* U+3814 */
  0x0000,   /* U+3815 */
  0x0000,   /* U+3816 */
  0x0000,   /* U+3817 */
  0x0000,   /* U+3818 */
  0x0000,   /* U+3819 */
  0x0000,   /* U+381A */
  0x0000,   /* U+381B */
  0x0000,   /* U+381C */
  0x0000,   /* U+381D */
  0x0000,   /* U+381E */
  0x0000,   /* U+381F */
  0x0000,   /* U+3820 */
  0x0000,   /* U+3821 */
  0x0000,   /* U+3822 */
  0x0000,   /* U+3823 */
  0x0000,   /* U+3824 */
  0x0000,   /* U+3825 */
  0x0000,   /* U+3826 */
  0x0000,   /* U+3827 */
  0x0000,   /* U+3828 */
  0x0000,   /* U+3829 */
  0x0000,   /* U+382A */
  0x0000,   /* U+382B */
  0x0000,   /* U+382C */
  0x0000,   /* U+382D */
  0x0000,   /* U+382E */
  0x0000,   /* U+382F */
  0x0000,   /* U+3830 */
  0x0000,   /* U+3831 */
  0x0000,   /* U+3832 */
  0x0000,   /* U+3833 */
  0x0000,   /* U+3834 */
  0x0000,   /* U+3835 */
  0x0000,   /* U+3836 */
  0x0000,   /* U+3837 */
  0x0000,   /* U+3838 */
  0x0000,   /* U+3839 */
  0x0000,   /* U+383A */
  0x0000,   /* U+383B */
  0x0000,   /* U+383C */
  0x0000,   /* U+383D */
  0x0000,   /* U+383E */
  0x0000,   /* U+383F */
  0x0000,   /* U+3840 */
  0x0000,   /* U+3841 */
  0x0000,   /* U+3842 */
  0x0000,   /* U+3843 */
  0x0000,   /* U+3844 */
  0x0000,   /* U+3845 */
  0x0000,   /* U+3846 */
  0x0000,   /* U+3847 */
  0x0000,   /* U+3848 */
  0x0000,   /* U+3849 */
  0x0000,   /* U+384A */
  0x0000,   /* U+384B */
  0x0000,   /* U+384C */
  0x0000,   /* U+384D */
  0x0000,   /* U+384E */
  0x0000,   /* U+384F */
  0x0000,   /* U+3850 */
  0x0000,   /* U+3851 */
  0x0000,   /* U+3852 */
  0x0000,   /* U+3853 */
  0x0000,   /* U+3854 */
  0x0000,   /* U+3855 */
  0x0000,   /* U+3856 */
  0x0000,   /* U+3857 */
  0x0000,   /* U+3858 */
  0x0000,   /* U+3859 */
  0x0000,   /* U+385A */
  0x0000,   /* U+385B */
  0x0000,   /* U+385C */
  0x0000,   /* U+385D */
  0x0000,   /* U+385E */
  0x0000,   /* U+385F */
  0x0000,   /* U+3860 */
  0x0000,   /* U+3861 */
  0x0000,   /* U+3862 */
  0x0000,   /* U+3863 */
  0x0000,   /* U+3864 */
  0x0000,   /* U+3865 */
  0x0000,   /* U+3866 */
  0x0000,   /* U+3867 */
  0x0000,   /* U+3868 */
  0x0000,   /* U+3869 */
  0x0000,   /* U+386A */
  0x0000,   /* U+386B */
  0x0000,   /* U+386C */
  0x0000,   /* U+386D */
  0x0000,   /* U+386E */
  0x0000,   /* U+386F */
  0x0000,   /* U+3870 */
  0x0000,   /* U+3871 */
  0x0000,   /* U+3872 */
  0x0000,   /* U+3873 */
  0x0000,   /* U+3874 */
  0x0000,   /* U+3875 */
  0x0000,   /* U+3876 */
  0x0000,   /* U+3877 */
  0x0000,   /* U+3878 */
  0x0000,   /* U+3879 */
  0x0000,   /* U+387A */
  0x0000,   /* U+387B */
  0x0000,   /* U+387C */
  0x0000,   /* U+387D */
  0x0000,   /* U+387E */
  0x0000,   /* U+387F */
  0x0000,   /* U+3880 */
  0x0000,   /* U+3881 */
  0x0000,   /* U+3882 */
  0x0000,   /* U+3883 */
  0x0000,   /* U+3884 */
  0x0000,   /* U+3885 */
  0x0000,   /* U+3886 */
  0x0000,   /* U+3887 */
  0x0000,   /* U+3888 */
  0x0000,   /* U+3889 */
  0x0000,   /* U+388A */
  0x0000,   /* U+388B */
  0x0000,   /* U+388C */
  0x0000,   /* U+388D */
  0x0000,   /* U+388E */
  0x0000,   /* U+388F */
  0x0000,   /* U+3890 */
  0x0000,   /* U+3891 */
  0x0000,   /* U+3892 */
  0x0000,   /* U+3893 */
  0x0000,   /* U+3894 */
  0x0000,   /* U+3895 */
  0x0000,   /* U+3896 */
  0x0000,   /* U+3897 */
  0x0000,   /* U+3898 */
  0x0000,   /* U+3899 */
  0x0000,   /* U+389A */
  0x0000,   /* U+389B */
  0x0000,   /* U+389C */
  0x0000,   /* U+389D */
  0x0000,   /* U+389E */
  0x0000,   /* U+389F */
  0x0000,   /* U+38A0 */
  0x0000,   /* U+38A1 */
  0x0000,   /* U+38A2 */
  0x0000,   /* U+38A3 */
  0x0000,   /* U+38A4 */
  0x0000,   /* U+38A5 */
  0x0000,   /* U+38A6 */
  0x0000,   /* U+38A7 */
  0x0000,   /* U+38A8 */
  0x0000,   /* U+38A9 */
  0x0000,   /* U+38AA */
  0x0000,   /* U+38AB */
  0x0000,   /* U+38AC */
  0x0000,   /* U+38AD */
  0x0000,   /* U+38AE */
  0x0000,   /* U+38AF */
  0x0000,   /* U+38B0 */
  0x0000,   /* U+38B1 */
  0x0000,   /* U+38B2 */
  0x0000,   /* U+38B3 */
  0x0000,   /* U+38B4 */
  0x0000,   /* U+38B5 */
  0x0000,   /* U+38B6 */
  0x0000,   /* U+38B7 */
  0x0000,   /* U+38B8 */
  0x0000,   /* U+38B9 */
  0x0000,   /* U+38BA */
  0x0000,   /* U+38BB */
  0x0000,   /* U+38BC */
  0x0000,   /* U+38BD */
  0x0000,   /* U+38BE */
  0x0000,   /* U+38BF */
  0x0000,   /* U+38C0 */
  0x0000,   /* U+38C1 */
  0x0000,   /* U+38C2 */
  0x0000,   /* U+38C3 */
  0x0000,   /* U+38C4 */
  0x0000,   /* U+38C5 */
  0x0000,   /* U+38C6 */
  0x0000,   /* U+38C7 */
  0x0000,   /* U+38C8 */
  0x0000,   /* U+38C9 */
  0x0000,   /* U+38CA */
  0x0000,   /* U+38CB */
  0x0000,   /* U+38CC */
  0x0000,   /* U+38CD */
  0x0000,   /* U+38CE */
  0x0000,   /* U+38CF */
  0x0000,   /* U+38D0 */
  0x0000,   /* U+38D1 */
  0x0000,   /* U+38D2 */
  0x0000,   /* U+38D3 */
  0x0000,   /* U+38D4 */
  0x0000,   /* U+38D5 */
  0x0000,   /* U+38D6 */
  0x0000,   /* U+38D7 */
  0x0000,   /* U+38D8 */
  0x0000,   /* U+38D9 */
  0x0000,   /* U+38DA */
  0x0000,   /* U+38DB */
  0x0000,   /* U+38DC */
  0x0000,   /* U+38DD */
  0x0000,   /* U+38DE */
  0x0000,   /* U+38DF */
  0x0000,   /* U+38E0 */
  0x0000,   /* U+38E1 */
  0x0000,   /* U+38E2 */
  0x0000,   /* U+38E3 */
  0x0000,   /* U+38E4 */
  0x0000,   /* U+38E5 */
  0x0000,   /* U+38E6 */
  0x0000,   /* U+38E7 */
  0x0000,   /* U+38E8 */
  0x0000,   /* U+38E9 */
  0x0000,   /* U+38EA */
  0x0000,   /* U+38EB */
  0x0000,   /* U+38EC */
  0x0000,   /* U+38ED */
  0x0000,   /* U+38EE */
  0x0000,   /* U+38EF */
  0x0000,   /* U+38F0 */
  0x0000,   /* U+38F1 */
  0x0000,   /* U+38F2 */
  0x0000,   /* U+38F3 */
  0x0000,   /* U+38F4 */
  0x0000,   /* U+38F5 */
  0x0000,   /* U+38F6 */
  0x0000,   /* U+38F7 */
  0x0000,   /* U+38F8 */
  0x0000,   /* U+38F9 */
  0x0000,   /* U+38FA */
  0x0000,   /* U+38FB */
  0x0000,   /* U+38FC */
  0x0000,   /* U+38FD */
  0x0000,   /* U+38FE */
  0x0000,   /* U+38FF */
};

uint16 zh3_han_p039[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C4E,   /* U+3900 */
  0x1C4F,   /* U+3901 */
  0x1C4F,   /* U+3902 */
  0x1C4E,   /* U+3903 */
  0x1C4E,   /* U+3904 */
  0x1C4F,   /* U+3905 */
  0x1C4E,   /* U+3906 */
  0x1C4E,   /* U+3907 */
  0x1C4E,   /* U+3908 */
  0x1C4E,   /* U+3909 */
  0x1C4E,   /* U+390A */
  0x1C4E,   /* U+390B */
  0x1C4F,   /* U+390C */
  0x1C50,   /* U+390D */
  0x1C50,   /* U+390E */
  0x1C4F,   /* U+390F */
  0x1C4F,   /* U+3910 */
  0x1C4F,   /* U+3911 */
  0x1C4F,   /* U+3912 */
  0x1C4F,   /* U+3913 */
  0x1C4F,   /* U+3914 */
  0x1C4F,   /* U+3915 */
  0x1C4F,   /* U+3916 */
  0x1C50,   /* U+3917 */
  0x1C4F,   /* U+3918 */
  0x1C50,   /* U+3919 */
  0x1C50,   /* U+391A */
  0x1C50,   /* U+391B */
  0x1C50,   /* U+391C */
  0x1C50,   /* U+391D */
  0x1C50,   /* U+391E */
  0x1C51,   /* U+391F */
  0x1C51,   /* U+3920 */
  0x1C50,   /* U+3921 */
  0x1C50,   /* U+3922 */
  0x1C51,   /* U+3923 */
  0x1C50,   /* U+3924 */
  0x1C50,   /* U+3925 */
  0x1C50,   /* U+3926 */
  0x1C50,   /* U+3927 */
  0x1C50,   /* U+3928 */
  0x1C51,   /* U+3929 */
  0x1C51,   /* U+392A */
  0x1C51,   /* U+392B */
  0x1C50,   /* U+392C */
  0x1C50,   /* U+392D */
  0x1C52,   /* U+392E */
  0x1C51,   /* U+392F */
  0x1C52,   /* U+3930 */
  0x1C51,   /* U+3931 */
  0x1C52,   /* U+3932 */
  0x1C51,   /* U+3933 */
  0x1C51,   /* U+3934 */
  0x1C52,   /* U+3935 */
  0x1C51,   /* U+3936 */
  0x1C51,   /* U+3937 */
  0x1C51,   /* U+3938 */
  0x1C51,   /* U+3939 */
  0x1C50,   /* U+393A */
  0x1C52,   /* U+393B */
  0x1C51,   /* U+393C */
  0x1C51,   /* U+393D */
  0x1C52,   /* U+393E */
  0x1C52,   /* U+393F */
  0x1C52,   /* U+3940 */
  0x1C53,   /* U+3941 */
  0x1C52,   /* U+3942 */
  0x1C52,   /* U+3943 */
  0x1C52,   /* U+3944 */
  0x1C52,   /* U+3945 */
  0x1C52,   /* U+3946 */
  0x1C52,   /* U+3947 */
  0x1C53,   /* U+3948 */
  0x1C52,   /* U+3949 */
  0x1C52,   /* U+394A */
  0x1C53,   /* U+394B */
  0x1C52,   /* U+394C */
  0x1C52,   /* U+394D */
  0x1C53,   /* U+394E */
  0x1C52,   /* U+394F */
  0x1C53,   /* U+3950 */
  0x1C53,   /* U+3951 */
  0x1C52,   /* U+3952 */
  0x1C52,   /* U+3953 */
  0x1C52,   /* U+3954 */
  0x1C53,   /* U+3955 */
  0x1C53,   /* U+3956 */
  0x1C52,   /* U+3957 */
  0x1C52,   /* U+3958 */
  0x1C52,   /* U+3959 */
  0x1C53,   /* U+395A */
  0x1C53,   /* U+395B */
  0x1C53,   /* U+395C */
  0x1C53,   /* U+395D */
  0x1C53,   /* U+395E */
  0x1C53,   /* U+395F */
  0x1C53,   /* U+3960 */
  0x1C53,   /* U+3961 */
  0x1C53,   /* U+3962 */
  0x1C54,   /* U+3963 */
  0x1C54,   /* U+3964 */
  0x1C53,   /* U+3965 */
  0x1C54,   /* U+3966 */
  0x1C53,   /* U+3967 */
  0x1C54,   /* U+3968 */
  0x1C53,   /* U+3969 */
  0x1C53,   /* U+396A */
  0x1C53,   /* U+396B */
  0x1C54,   /* U+396C */
  0x1C54,   /* U+396D */
  0x1C54,   /* U+396E */
  0x1C55,   /* U+396F */
  0x1C54,   /* U+3970 */
  0x1C54,   /* U+3971 */
  0x1C55,   /* U+3972 */
  0x1C54,   /* U+3973 */
  0x1C54,   /* U+3974 */
  0x1C54,   /* U+3975 */
  0x1C55,   /* U+3976 */
  0x1C55,   /* U+3977 */
  0x1C55,   /* U+3978 */
  0x1C55,   /* U+3979 */
  0x1C54,   /* U+397A */
  0x1C55,   /* U+397B */
  0x1C55,   /* U+397C */
  0x1C55,   /* U+397D */
  0x1C55,   /* U+397E */
  0x1C56,   /* U+397F */
  0x1C55,   /* U+3980 */
  0x1C56,   /* U+3981 */
  0x1C56,   /* U+3982 */
  0x1C55,   /* U+3983 */
  0x1C56,   /* U+3984 */
  0x1C55,   /* U+3985 */
  0x1C55,   /* U+3986 */
  0x1C55,   /* U+3987 */
  0x1C55,   /* U+3988 */
  0x1C56,   /* U+3989 */
  0x1C56,   /* U+398A */
  0x1C56,   /* U+398B */
  0x1C57,   /* U+398C */
  0x1C56,   /* U+398D */
  0x1C56,   /* U+398E */
  0x1C56,   /* U+398F */
  0x1C56,   /* U+3990 */
  0x1C56,   /* U+3991 */
  0x1C56,   /* U+3992 */
  0x1C56,   /* U+3993 */
  0x1C57,   /* U+3994 */
  0x1C56,   /* U+3995 */
  0x1C56,   /* U+3996 */
  0x1C57,   /* U+3997 */
  0x1C58,   /* U+3998 */
  0x1C57,   /* U+3999 */
  0x1C59,   /* U+399A */
  0x1C59,   /* U+399B */
  0x1C58,   /* U+399C */
  0x1C59,   /* U+399D */
  0x1C59,   /* U+399E */
  0x1C59,   /* U+399F */
  0x1C58,   /* U+39A0 */
  0x1C59,   /* U+39A1 */
  0x1C59,   /* U+39A2 */
  0x1C5B,   /* U+39A3 */
  0x1C5B,   /* U+39A4 */
  0x1C5A,   /* U+39A5 */
  0x1C5A,   /* U+39A6 */
  0x1C5A,   /* U+39A7 */
  0x1C5B,   /* U+39A8 */
  0x1C5B,   /* U+39A9 */
  0x1C5B,   /* U+39AA */
  0x1C5D,   /* U+39AB */
  0x1C5D,   /* U+39AC */
  0x1C62,   /* U+39AD */
  0x1C4E,   /* U+39AE */
  0x1C4E,   /* U+39AF */
  0x1C4F,   /* U+39B0 */
  0x1C4F,   /* U+39B1 */
  0x1C4F,   /* U+39B2 */
  0x1C50,   /* U+39B3 */
  0x1C51,   /* U+39B4 */
  0x1C51,   /* U+39B5 */
  0x1C51,   /* U+39B6 */
  0x1C52,   /* U+39B7 */
  0x1C53,   /* U+39B8 */
  0x1C54,   /* U+39B9 */
  0x1C55,   /* U+39BA */
  0x1C56,   /* U+39BB */
  0x1C56,   /* U+39BC */
  0x1C58,   /* U+39BD */
  0x1C4E,   /* U+39BE */
  0x1C4F,   /* U+39BF */
  0x1C4F,   /* U+39C0 */
  0x1C50,   /* U+39C1 */
  0x1C50,   /* U+39C2 */
  0x1C4C,   /* U+39C3 */
  0x1C4C,   /* U+39C4 */
  0x1C4C,   /* U+39C5 */
  0x1C4D,   /* U+39C6 */
  0x1C4D,   /* U+39C7 */
  0x1C4D,   /* U+39C8 */
  0x1C4E,   /* U+39C9 */
  0x1C4E,   /* U+39CA */
  0x1C4E,   /* U+39CB */
  0x1C4E,   /* U+39CC */
  0x1C4E,   /* U+39CD */
  0x1C4E,   /* U+39CE */
  0x1C4E,   /* U+39CF */
  0x1C4E,   /* U+39D0 */
  0x1C4E,   /* U+39D1 */
  0x1C4F,   /* U+39D2 */
  0x1C4F,   /* U+39D3 */
  0x1C4F,   /* U+39D4 */
  0x1C4F,   /* U+39D5 */
  0x1C4F,   /* U+39D6 */
  0x1C4F,   /* U+39D7 */
  0x1C50,   /* U+39D8 */
  0x1C4F,   /* U+39D9 */
  0x1C4F,   /* U+39DA */
  0x1C4F,   /* U+39DB */
  0x1C4F,   /* U+39DC */
  0x1C4F,   /* U+39DD */
  0x1C4F,   /* U+39DE */
  0x1C4F,   /* U+39DF */
  0x1C4F,   /* U+39E0 */
  0x1C50,   /* U+39E1 */
  0x1C50,   /* U+39E2 */
  0x1C50,   /* U+39E3 */
  0x1C50,   /* U+39E4 */
  0x1C50,   /* U+39E5 */
  0x1C50,   /* U+39E6 */
  0x1C50,   /* U+39E7 */
  0x1C50,   /* U+39E8 */
  0x1C50,   /* U+39E9 */
  0x1C50,   /* U+39EA */
  0x1C50,   /* U+39EB */
  0x1C51,   /* U+39EC */
  0x1C51,   /* U+39ED */
  0x1C50,   /* U+39EE */
  0x1C50,   /* U+39EF */
  0x1C50,   /* U+39F0 */
  0x1C51,   /* U+39F1 */
  0x1C51,   /* U+39F2 */
  0x1C52,   /* U+39F3 */
  0x1C51,   /* U+39F4 */
  0x1C51,   /* U+39F5 */
  0x1C51,   /* U+39F6 */
  0x1C51,   /* U+39F7 */
  0x1C51,   /* U+39F8 */
  0x1C52,   /* U+39F9 */
  0x1C52,   /* U+39FA */
  0x1C52,   /* U+39FB */
  0x1C52,   /* U+39FC */
  0x1C52,   /* U+39FD */
  0x1C52,   /* U+39FE */
  0x1C52,   /* U+39FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3900 */
  0x0020,   /* U+3901 */
  0x0020,   /* U+3902 */
  0x0020,   /* U+3903 */
  0x0020,   /* U+3904 */
  0x0020,   /* U+3905 */
  0x0020,   /* U+3906 */
  0x0020,   /* U+3907 */
  0x0020,   /* U+3908 */
  0x0020,   /* U+3909 */
  0x0020,   /* U+390A */
  0x0020,   /* U+390B */
  0x0020,   /* U+390C */
  0x0020,   /* U+390D */
  0x0020,   /* U+390E */
  0x0020,   /* U+390F */
  0x0020,   /* U+3910 */
  0x0020,   /* U+3911 */
  0x0020,   /* U+3912 */
  0x0020,   /* U+3913 */
  0x0020,   /* U+3914 */
  0x0020,   /* U+3915 */
  0x0020,   /* U+3916 */
  0x0020,   /* U+3917 */
  0x0020,   /* U+3918 */
  0x0020,   /* U+3919 */
  0x0020,   /* U+391A */
  0x0020,   /* U+391B */
  0x0020,   /* U+391C */
  0x0020,   /* U+391D */
  0x0020,   /* U+391E */
  0x0020,   /* U+391F */
  0x0020,   /* U+3920 */
  0x0020,   /* U+3921 */
  0x0020,   /* U+3922 */
  0x0020,   /* U+3923 */
  0x0020,   /* U+3924 */
  0x0020,   /* U+3925 */
  0x0020,   /* U+3926 */
  0x0020,   /* U+3927 */
  0x0020,   /* U+3928 */
  0x0020,   /* U+3929 */
  0x0020,   /* U+392A */
  0x0020,   /* U+392B */
  0x0020,   /* U+392C */
  0x0020,   /* U+392D */
  0x0020,   /* U+392E */
  0x0020,   /* U+392F */
  0x0020,   /* U+3930 */
  0x0020,   /* U+3931 */
  0x0020,   /* U+3932 */
  0x0020,   /* U+3933 */
  0x0020,   /* U+3934 */
  0x0020,   /* U+3935 */
  0x0020,   /* U+3936 */
  0x0020,   /* U+3937 */
  0x0020,   /* U+3938 */
  0x0020,   /* U+3939 */
  0x0020,   /* U+393A */
  0x0020,   /* U+393B */
  0x0020,   /* U+393C */
  0x0020,   /* U+393D */
  0x0020,   /* U+393E */
  0x0020,   /* U+393F */
  0x0020,   /* U+3940 */
  0x0020,   /* U+3941 */
  0x0020,   /* U+3942 */
  0x0020,   /* U+3943 */
  0x0020,   /* U+3944 */
  0x0020,   /* U+3945 */
  0x0020,   /* U+3946 */
  0x0020,   /* U+3947 */
  0x0020,   /* U+3948 */
  0x0020,   /* U+3949 */
  0x0020,   /* U+394A */
  0x0020,   /* U+394B */
  0x0020,   /* U+394C */
  0x0020,   /* U+394D */
  0x0020,   /* U+394E */
  0x0020,   /* U+394F */
  0x0020,   /* U+3950 */
  0x0020,   /* U+3951 */
  0x0020,   /* U+3952 */
  0x0020,   /* U+3953 */
  0x0020,   /* U+3954 */
  0x0020,   /* U+3955 */
  0x0020,   /* U+3956 */
  0x0020,   /* U+3957 */
  0x0020,   /* U+3958 */
  0x0020,   /* U+3959 */
  0x0020,   /* U+395A */
  0x0020,   /* U+395B */
  0x0020,   /* U+395C */
  0x0020,   /* U+395D */
  0x0020,   /* U+395E */
  0x0020,   /* U+395F */
  0x0020,   /* U+3960 */
  0x0020,   /* U+3961 */
  0x0020,   /* U+3962 */
  0x0020,   /* U+3963 */
  0x0020,   /* U+3964 */
  0x0020,   /* U+3965 */
  0x0020,   /* U+3966 */
  0x0020,   /* U+3967 */
  0x0020,   /* U+3968 */
  0x0020,   /* U+3969 */
  0x0020,   /* U+396A */
  0x0020,   /* U+396B */
  0x0020,   /* U+396C */
  0x0020,   /* U+396D */
  0x0020,   /* U+396E */
  0x0020,   /* U+396F */
  0x0020,   /* U+3970 */
  0x0020,   /* U+3971 */
  0x0020,   /* U+3972 */
  0x0020,   /* U+3973 */
  0x0020,   /* U+3974 */
  0x0020,   /* U+3975 */
  0x0020,   /* U+3976 */
  0x0020,   /* U+3977 */
  0x0020,   /* U+3978 */
  0x0020,   /* U+3979 */
  0x0020,   /* U+397A */
  0x0020,   /* U+397B */
  0x0020,   /* U+397C */
  0x0020,   /* U+397D */
  0x0020,   /* U+397E */
  0x0020,   /* U+397F */
  0x0020,   /* U+3980 */
  0x0020,   /* U+3981 */
  0x0020,   /* U+3982 */
  0x0020,   /* U+3983 */
  0x0020,   /* U+3984 */
  0x0020,   /* U+3985 */
  0x0020,   /* U+3986 */
  0x0020,   /* U+3987 */
  0x0020,   /* U+3988 */
  0x0020,   /* U+3989 */
  0x0020,   /* U+398A */
  0x0020,   /* U+398B */
  0x0020,   /* U+398C */
  0x0020,   /* U+398D */
  0x0020,   /* U+398E */
  0x0020,   /* U+398F */
  0x0020,   /* U+3990 */
  0x0020,   /* U+3991 */
  0x0020,   /* U+3992 */
  0x0020,   /* U+3993 */
  0x0020,   /* U+3994 */
  0x0020,   /* U+3995 */
  0x0020,   /* U+3996 */
  0x0020,   /* U+3997 */
  0x0020,   /* U+3998 */
  0x0020,   /* U+3999 */
  0x0020,   /* U+399A */
  0x0020,   /* U+399B */
  0x0020,   /* U+399C */
  0x0020,   /* U+399D */
  0x0020,   /* U+399E */
  0x0020,   /* U+399F */
  0x0020,   /* U+39A0 */
  0x0020,   /* U+39A1 */
  0x0020,   /* U+39A2 */
  0x0020,   /* U+39A3 */
  0x0020,   /* U+39A4 */
  0x0020,   /* U+39A5 */
  0x0020,   /* U+39A6 */
  0x0020,   /* U+39A7 */
  0x0020,   /* U+39A8 */
  0x0020,   /* U+39A9 */
  0x0020,   /* U+39AA */
  0x0020,   /* U+39AB */
  0x0020,   /* U+39AC */
  0x0020,   /* U+39AD */
  0x0020,   /* U+39AE */
  0x0020,   /* U+39AF */
  0x0020,   /* U+39B0 */
  0x0020,   /* U+39B1 */
  0x0020,   /* U+39B2 */
  0x0020,   /* U+39B3 */
  0x0020,   /* U+39B4 */
  0x0020,   /* U+39B5 */
  0x0020,   /* U+39B6 */
  0x0020,   /* U+39B7 */
  0x0020,   /* U+39B8 */
  0x0020,   /* U+39B9 */
  0x0020,   /* U+39BA */
  0x0020,   /* U+39BB */
  0x0020,   /* U+39BC */
  0x0020,   /* U+39BD */
  0x0020,   /* U+39BE */
  0x0020,   /* U+39BF */
  0x0020,   /* U+39C0 */
  0x0020,   /* U+39C1 */
  0x0020,   /* U+39C2 */
  0x0020,   /* U+39C3 */
  0x0020,   /* U+39C4 */
  0x0020,   /* U+39C5 */
  0x0020,   /* U+39C6 */
  0x0020,   /* U+39C7 */
  0x0020,   /* U+39C8 */
  0x0020,   /* U+39C9 */
  0x0020,   /* U+39CA */
  0x0020,   /* U+39CB */
  0x0020,   /* U+39CC */
  0x0020,   /* U+39CD */
  0x0020,   /* U+39CE */
  0x0020,   /* U+39CF */
  0x0020,   /* U+39D0 */
  0x0020,   /* U+39D1 */
  0x0020,   /* U+39D2 */
  0x0020,   /* U+39D3 */
  0x0020,   /* U+39D4 */
  0x0020,   /* U+39D5 */
  0x0020,   /* U+39D6 */
  0x0020,   /* U+39D7 */
  0x0020,   /* U+39D8 */
  0x0020,   /* U+39D9 */
  0x0020,   /* U+39DA */
  0x0020,   /* U+39DB */
  0x0020,   /* U+39DC */
  0x0020,   /* U+39DD */
  0x0020,   /* U+39DE */
  0x0020,   /* U+39DF */
  0x0020,   /* U+39E0 */
  0x0020,   /* U+39E1 */
  0x0020,   /* U+39E2 */
  0x0020,   /* U+39E3 */
  0x0020,   /* U+39E4 */
  0x0020,   /* U+39E5 */
  0x0020,   /* U+39E6 */
  0x0020,   /* U+39E7 */
  0x0020,   /* U+39E8 */
  0x0020,   /* U+39E9 */
  0x0020,   /* U+39EA */
  0x0020,   /* U+39EB */
  0x0020,   /* U+39EC */
  0x0020,   /* U+39ED */
  0x0020,   /* U+39EE */
  0x0020,   /* U+39EF */
  0x0020,   /* U+39F0 */
  0x0020,   /* U+39F1 */
  0x0020,   /* U+39F2 */
  0x0020,   /* U+39F3 */
  0x0020,   /* U+39F4 */
  0x0020,   /* U+39F5 */
  0x0020,   /* U+39F6 */
  0x0020,   /* U+39F7 */
  0x0020,   /* U+39F8 */
  0x0020,   /* U+39F9 */
  0x0020,   /* U+39FA */
  0x0020,   /* U+39FB */
  0x0020,   /* U+39FC */
  0x0020,   /* U+39FD */
  0x0020,   /* U+39FE */
  0x0020,   /* U+39FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3900 */
  0x0002,   /* U+3901 */
  0x0002,   /* U+3902 */
  0x0002,   /* U+3903 */
  0x0002,   /* U+3904 */
  0x0002,   /* U+3905 */
  0x0002,   /* U+3906 */
  0x0002,   /* U+3907 */
  0x0002,   /* U+3908 */
  0x0002,   /* U+3909 */
  0x0002,   /* U+390A */
  0x0002,   /* U+390B */
  0x0002,   /* U+390C */
  0x0002,   /* U+390D */
  0x0002,   /* U+390E */
  0x0002,   /* U+390F */
  0x0002,   /* U+3910 */
  0x0002,   /* U+3911 */
  0x0002,   /* U+3912 */
  0x0002,   /* U+3913 */
  0x0002,   /* U+3914 */
  0x0002,   /* U+3915 */
  0x0002,   /* U+3916 */
  0x0002,   /* U+3917 */
  0x0002,   /* U+3918 */
  0x0002,   /* U+3919 */
  0x0002,   /* U+391A */
  0x0002,   /* U+391B */
  0x0002,   /* U+391C */
  0x0002,   /* U+391D */
  0x0002,   /* U+391E */
  0x0002,   /* U+391F */
  0x0002,   /* U+3920 */
  0x0002,   /* U+3921 */
  0x0002,   /* U+3922 */
  0x0002,   /* U+3923 */
  0x0002,   /* U+3924 */
  0x0002,   /* U+3925 */
  0x0002,   /* U+3926 */
  0x0002,   /* U+3927 */
  0x0002,   /* U+3928 */
  0x0002,   /* U+3929 */
  0x0002,   /* U+392A */
  0x0002,   /* U+392B */
  0x0002,   /* U+392C */
  0x0002,   /* U+392D */
  0x0002,   /* U+392E */
  0x0002,   /* U+392F */
  0x0002,   /* U+3930 */
  0x0002,   /* U+3931 */
  0x0002,   /* U+3932 */
  0x0002,   /* U+3933 */
  0x0002,   /* U+3934 */
  0x0002,   /* U+3935 */
  0x0002,   /* U+3936 */
  0x0002,   /* U+3937 */
  0x0002,   /* U+3938 */
  0x0002,   /* U+3939 */
  0x0002,   /* U+393A */
  0x0002,   /* U+393B */
  0x0002,   /* U+393C */
  0x0002,   /* U+393D */
  0x0002,   /* U+393E */
  0x0002,   /* U+393F */
  0x0002,   /* U+3940 */
  0x0002,   /* U+3941 */
  0x0002,   /* U+3942 */
  0x0002,   /* U+3943 */
  0x0002,   /* U+3944 */
  0x0002,   /* U+3945 */
  0x0002,   /* U+3946 */
  0x0002,   /* U+3947 */
  0x0002,   /* U+3948 */
  0x0002,   /* U+3949 */
  0x0002,   /* U+394A */
  0x0002,   /* U+394B */
  0x0002,   /* U+394C */
  0x0002,   /* U+394D */
  0x0002,   /* U+394E */
  0x0002,   /* U+394F */
  0x0002,   /* U+3950 */
  0x0002,   /* U+3951 */
  0x0002,   /* U+3952 */
  0x0002,   /* U+3953 */
  0x0002,   /* U+3954 */
  0x0002,   /* U+3955 */
  0x0002,   /* U+3956 */
  0x0002,   /* U+3957 */
  0x0002,   /* U+3958 */
  0x0002,   /* U+3959 */
  0x0002,   /* U+395A */
  0x0002,   /* U+395B */
  0x0002,   /* U+395C */
  0x0002,   /* U+395D */
  0x0002,   /* U+395E */
  0x0002,   /* U+395F */
  0x0002,   /* U+3960 */
  0x0002,   /* U+3961 */
  0x0002,   /* U+3962 */
  0x0002,   /* U+3963 */
  0x0002,   /* U+3964 */
  0x0002,   /* U+3965 */
  0x0002,   /* U+3966 */
  0x0002,   /* U+3967 */
  0x0002,   /* U+3968 */
  0x0002,   /* U+3969 */
  0x0002,   /* U+396A */
  0x0002,   /* U+396B */
  0x0002,   /* U+396C */
  0x0002,   /* U+396D */
  0x0002,   /* U+396E */
  0x0002,   /* U+396F */
  0x0002,   /* U+3970 */
  0x0002,   /* U+3971 */
  0x0002,   /* U+3972 */
  0x0002,   /* U+3973 */
  0x0002,   /* U+3974 */
  0x0002,   /* U+3975 */
  0x0002,   /* U+3976 */
  0x0002,   /* U+3977 */
  0x0002,   /* U+3978 */
  0x0002,   /* U+3979 */
  0x0002,   /* U+397A */
  0x0002,   /* U+397B */
  0x0002,   /* U+397C */
  0x0002,   /* U+397D */
  0x0002,   /* U+397E */
  0x0002,   /* U+397F */
  0x0002,   /* U+3980 */
  0x0002,   /* U+3981 */
  0x0002,   /* U+3982 */
  0x0002,   /* U+3983 */
  0x0002,   /* U+3984 */
  0x0002,   /* U+3985 */
  0x0002,   /* U+3986 */
  0x0002,   /* U+3987 */
  0x0002,   /* U+3988 */
  0x0002,   /* U+3989 */
  0x0002,   /* U+398A */
  0x0002,   /* U+398B */
  0x0002,   /* U+398C */
  0x0002,   /* U+398D */
  0x0002,   /* U+398E */
  0x0002,   /* U+398F */
  0x0002,   /* U+3990 */
  0x0002,   /* U+3991 */
  0x0002,   /* U+3992 */
  0x0002,   /* U+3993 */
  0x0002,   /* U+3994 */
  0x0002,   /* U+3995 */
  0x0002,   /* U+3996 */
  0x0002,   /* U+3997 */
  0x0002,   /* U+3998 */
  0x0002,   /* U+3999 */
  0x0002,   /* U+399A */
  0x0002,   /* U+399B */
  0x0002,   /* U+399C */
  0x0002,   /* U+399D */
  0x0002,   /* U+399E */
  0x0002,   /* U+399F */
  0x0002,   /* U+39A0 */
  0x0002,   /* U+39A1 */
  0x0002,   /* U+39A2 */
  0x0002,   /* U+39A3 */
  0x0002,   /* U+39A4 */
  0x0002,   /* U+39A5 */
  0x0002,   /* U+39A6 */
  0x0002,   /* U+39A7 */
  0x0002,   /* U+39A8 */
  0x0002,   /* U+39A9 */
  0x0002,   /* U+39AA */
  0x0002,   /* U+39AB */
  0x0002,   /* U+39AC */
  0x0002,   /* U+39AD */
  0x0002,   /* U+39AE */
  0x0002,   /* U+39AF */
  0x0002,   /* U+39B0 */
  0x0002,   /* U+39B1 */
  0x0002,   /* U+39B2 */
  0x0002,   /* U+39B3 */
  0x0002,   /* U+39B4 */
  0x0002,   /* U+39B5 */
  0x0002,   /* U+39B6 */
  0x0002,   /* U+39B7 */
  0x0002,   /* U+39B8 */
  0x0002,   /* U+39B9 */
  0x0002,   /* U+39BA */
  0x0002,   /* U+39BB */
  0x0002,   /* U+39BC */
  0x0002,   /* U+39BD */
  0x0002,   /* U+39BE */
  0x0002,   /* U+39BF */
  0x0002,   /* U+39C0 */
  0x0002,   /* U+39C1 */
  0x0002,   /* U+39C2 */
  0x0002,   /* U+39C3 */
  0x0002,   /* U+39C4 */
  0x0002,   /* U+39C5 */
  0x0002,   /* U+39C6 */
  0x0002,   /* U+39C7 */
  0x0002,   /* U+39C8 */
  0x0002,   /* U+39C9 */
  0x0002,   /* U+39CA */
  0x0002,   /* U+39CB */
  0x0002,   /* U+39CC */
  0x0002,   /* U+39CD */
  0x0002,   /* U+39CE */
  0x0002,   /* U+39CF */
  0x0002,   /* U+39D0 */
  0x0002,   /* U+39D1 */
  0x0002,   /* U+39D2 */
  0x0002,   /* U+39D3 */
  0x0002,   /* U+39D4 */
  0x0002,   /* U+39D5 */
  0x0002,   /* U+39D6 */
  0x0002,   /* U+39D7 */
  0x0002,   /* U+39D8 */
  0x0002,   /* U+39D9 */
  0x0002,   /* U+39DA */
  0x0002,   /* U+39DB */
  0x0002,   /* U+39DC */
  0x0002,   /* U+39DD */
  0x0002,   /* U+39DE */
  0x0002,   /* U+39DF */
  0x0002,   /* U+39E0 */
  0x0002,   /* U+39E1 */
  0x0002,   /* U+39E2 */
  0x0002,   /* U+39E3 */
  0x0002,   /* U+39E4 */
  0x0002,   /* U+39E5 */
  0x0002,   /* U+39E6 */
  0x0002,   /* U+39E7 */
  0x0002,   /* U+39E8 */
  0x0002,   /* U+39E9 */
  0x0002,   /* U+39EA */
  0x0002,   /* U+39EB */
  0x0002,   /* U+39EC */
  0x0002,   /* U+39ED */
  0x0002,   /* U+39EE */
  0x0002,   /* U+39EF */
  0x0002,   /* U+39F0 */
  0x0002,   /* U+39F1 */
  0x0002,   /* U+39F2 */
  0x0002,   /* U+39F3 */
  0x0002,   /* U+39F4 */
  0x0002,   /* U+39F5 */
  0x0002,   /* U+39F6 */
  0x0002,   /* U+39F7 */
  0x0002,   /* U+39F8 */
  0x0002,   /* U+39F9 */
  0x0002,   /* U+39FA */
  0x0002,   /* U+39FB */
  0x0002,   /* U+39FC */
  0x0002,   /* U+39FD */
  0x0002,   /* U+39FE */
  0x0002,   /* U+39FF */

  /* Primary weight 2 for each character. */
  0x85D1,   /* U+3900 */
  0x868F,   /* U+3901 */
  0x8690,   /* U+3902 */
  0x85F9,   /* U+3903 */
  0x85FA,   /* U+3904 */
  0x8691,   /* U+3905 */
  0x85FB,   /* U+3906 */
  0x85FC,   /* U+3907 */
  0x85FD,   /* U+3908 */
  0x85FE,   /* U+3909 */
  0x85FF,   /* U+390A */
  0x8600,   /* U+390B */
  0x86C7,   /* U+390C */
  0x86EE,   /* U+390D */
  0x86EF,   /* U+390E */
  0x86C8,   /* U+390F */
  0x86C9,   /* U+3910 */
  0x86CA,   /* U+3911 */
  0x86CB,   /* U+3912 */
  0x86CC,   /* U+3913 */
  0x86CD,   /* U+3914 */
  0x86CE,   /* U+3915 */
  0x86CF,   /* U+3916 */
  0x86F0,   /* U+3917 */
  0x86D0,   /* U+3918 */
  0x86F1,   /* U+3919 */
  0x872B,   /* U+391A */
  0x872C,   /* U+391B */
  0x872D,   /* U+391C */
  0x872E,   /* U+391D */
  0x872F,   /* U+391E */
  0x879A,   /* U+391F */
  0x879B,   /* U+3920 */
  0x8730,   /* U+3921 */
  0x8731,   /* U+3922 */
  0x879C,   /* U+3923 */
  0x8732,   /* U+3924 */
  0x8733,   /* U+3925 */
  0x8734,   /* U+3926 */
  0x8735,   /* U+3927 */
  0x8736,   /* U+3928 */
  0x879D,   /* U+3929 */
  0x879E,   /* U+392A */
  0x879F,   /* U+392B */
  0x8737,   /* U+392C */
  0x8738,   /* U+392D */
  0x87DE,   /* U+392E */
  0x87D4,   /* U+392F */
  0x87DF,   /* U+3930 */
  0x87D5,   /* U+3931 */
  0x87E0,   /* U+3932 */
  0x87D6,   /* U+3933 */
  0x87D7,   /* U+3934 */
  0x87E1,   /* U+3935 */
  0x87D8,   /* U+3936 */
  0x87D9,   /* U+3937 */
  0x87DA,   /* U+3938 */
  0x87DB,   /* U+3939 */
  0x8739,   /* U+393A */
  0x87E2,   /* U+393B */
  0x87DC,   /* U+393C */
  0x87DD,   /* U+393D */
  0x8822,   /* U+393E */
  0x8823,   /* U+393F */
  0x8824,   /* U+3940 */
  0x879F,   /* U+3941 */
  0x8825,   /* U+3942 */
  0x8826,   /* U+3943 */
  0x8827,   /* U+3944 */
  0x8828,   /* U+3945 */
  0x8829,   /* U+3946 */
  0x882A,   /* U+3947 */
  0x87A0,   /* U+3948 */
  0x882B,   /* U+3949 */
  0x882C,   /* U+394A */
  0x87A1,   /* U+394B */
  0x882D,   /* U+394C */
  0x882E,   /* U+394D */
  0x87A2,   /* U+394E */
  0x882F,   /* U+394F */
  0x87A3,   /* U+3950 */
  0x87A4,   /* U+3951 */
  0x8830,   /* U+3952 */
  0x8831,   /* U+3953 */
  0x8832,   /* U+3954 */
  0x87A5,   /* U+3955 */
  0x87A6,   /* U+3956 */
  0x8833,   /* U+3957 */
  0x8834,   /* U+3958 */
  0x8835,   /* U+3959 */
  0x87E5,   /* U+395A */
  0x87E6,   /* U+395B */
  0x87E7,   /* U+395C */
  0x87E8,   /* U+395D */
  0x87E9,   /* U+395E */
  0x87EA,   /* U+395F */
  0x87EB,   /* U+3960 */
  0x87EC,   /* U+3961 */
  0x87ED,   /* U+3962 */
  0x8659,   /* U+3963 */
  0x865A,   /* U+3964 */
  0x87EE,   /* U+3965 */
  0x865B,   /* U+3966 */
  0x87EF,   /* U+3967 */
  0x865C,   /* U+3968 */
  0x87F0,   /* U+3969 */
  0x87F1,   /* U+396A */
  0x87F2,   /* U+396B */
  0x8694,   /* U+396C */
  0x8695,   /* U+396D */
  0x8696,   /* U+396E */
  0x8636,   /* U+396F */
  0x8697,   /* U+3970 */
  0x8698,   /* U+3971 */
  0x8637,   /* U+3972 */
  0x8699,   /* U+3973 */
  0x869A,   /* U+3974 */
  0x869B,   /* U+3975 */
  0x8638,   /* U+3976 */
  0x8639,   /* U+3977 */
  0x863A,   /* U+3978 */
  0x863B,   /* U+3979 */
  0x869C,   /* U+397A */
  0x863C,   /* U+397B */
  0x8671,   /* U+397C */
  0x8672,   /* U+397D */
  0x8673,   /* U+397E */
  0x8524,   /* U+397F */
  0x8674,   /* U+3980 */
  0x8525,   /* U+3981 */
  0x8526,   /* U+3982 */
  0x8675,   /* U+3983 */
  0x8527,   /* U+3984 */
  0x8676,   /* U+3985 */
  0x8677,   /* U+3986 */
  0x8678,   /* U+3987 */
  0x8679,   /* U+3988 */
  0x8557,   /* U+3989 */
  0x8558,   /* U+398A */
  0x8559,   /* U+398B */
  0x83DC,   /* U+398C */
  0x855A,   /* U+398D */
  0x855B,   /* U+398E */
  0x855C,   /* U+398F */
  0x855D,   /* U+3990 */
  0x855E,   /* U+3991 */
  0x855F,   /* U+3992 */
  0x8560,   /* U+3993 */
  0x83DD,   /* U+3994 */
  0x8561,   /* U+3995 */
  0x8562,   /* U+3996 */
  0x8406,   /* U+3997 */
  0x82B6,   /* U+3998 */
  0x8407,   /* U+3999 */
  0x824A,   /* U+399A */
  0x824B,   /* U+399B */
  0x82CD,   /* U+399C */
  0x824C,   /* U+399D */
  0x824D,   /* U+399E */
  0x824E,   /* U+399F */
  0x82CE,   /* U+39A0 */
  0x825E,   /* U+39A1 */
  0x825F,   /* U+39A2 */
  0x8128,   /* U+39A3 */
  0x8129,   /* U+39A4 */
  0x81C6,   /* U+39A5 */
  0x81C7,   /* U+39A6 */
  0x81C8,   /* U+39A7 */
  0x8134,   /* U+39A8 */
  0x8135,   /* U+39A9 */
  0x8136,   /* U+39AA */
  0x80BF,   /* U+39AB */
  0x80C0,   /* U+39AC */
  0x8020,   /* U+39AD */
  0x8652,   /* U+39AE */
  0x8653,   /* U+39AF */
  0x8721,   /* U+39B0 */
  0x8722,   /* U+39B1 */
  0x8723,   /* U+39B2 */
  0x8790,   /* U+39B3 */
  0x8851,   /* U+39B4 */
  0x8852,   /* U+39B5 */
  0x8853,   /* U+39B6 */
  0x88BF,   /* U+39B7 */
  0x8880,   /* U+39B8 */
  0x8715,   /* U+39B9 */
  0x86FA,   /* U+39BA */
  0x85DE,   /* U+39BB */
  0x85DF,   /* U+39BC */
  0x830A,   /* U+39BD */
  0x8661,   /* U+39BE */
  0x873B,   /* U+39BF */
  0x873C,   /* U+39C0 */
  0x87AD,   /* U+39C1 */
  0x87AE,   /* U+39C2 */
  0x8287,   /* U+39C3 */
  0x8288,   /* U+39C4 */
  0x8289,   /* U+39C5 */
  0x847C,   /* U+39C6 */
  0x847D,   /* U+39C7 */
  0x847E,   /* U+39C8 */
  0x86A0,   /* U+39C9 */
  0x86A1,   /* U+39CA */
  0x86A2,   /* U+39CB */
  0x86A3,   /* U+39CC */
  0x86A4,   /* U+39CD */
  0x86A5,   /* U+39CE */
  0x86A6,   /* U+39CF */
  0x86A7,   /* U+39D0 */
  0x86A8,   /* U+39D1 */
  0x8796,   /* U+39D2 */
  0x8797,   /* U+39D3 */
  0x8798,   /* U+39D4 */
  0x8799,   /* U+39D5 */
  0x879A,   /* U+39D6 */
  0x879B,   /* U+39D7 */
  0x87C5,   /* U+39D8 */
  0x879C,   /* U+39D9 */
  0x879D,   /* U+39DA */
  0x879E,   /* U+39DB */
  0x879F,   /* U+39DC */
  0x87A0,   /* U+39DD */
  0x87A1,   /* U+39DE */
  0x87A2,   /* U+39DF */
  0x87A3,   /* U+39E0 */
  0x8806,   /* U+39E1 */
  0x8807,   /* U+39E2 */
  0x8808,   /* U+39E3 */
  0x8809,   /* U+39E4 */
  0x880A,   /* U+39E5 */
  0x880B,   /* U+39E6 */
  0x880C,   /* U+39E7 */
  0x880D,   /* U+39E8 */
  0x880E,   /* U+39E9 */
  0x880F,   /* U+39EA */
  0x8810,   /* U+39EB */
  0x887B,   /* U+39EC */
  0x887C,   /* U+39ED */
  0x8811,   /* U+39EE */
  0x8812,   /* U+39EF */
  0x8813,   /* U+39F0 */
  0x887D,   /* U+39F1 */
  0x88C2,   /* U+39F2 */
  0x88DD,   /* U+39F3 */
  0x88C3,   /* U+39F4 */
  0x88C4,   /* U+39F5 */
  0x88C5,   /* U+39F6 */
  0x88C6,   /* U+39F7 */
  0x88C7,   /* U+39F8 */
  0x893F,   /* U+39F9 */
  0x8940,   /* U+39FA */
  0x8941,   /* U+39FB */
  0x8942,   /* U+39FC */
  0x8943,   /* U+39FD */
  0x8944,   /* U+39FE */
  0x8945,   /* U+39FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3900 */
  0x0000,   /* U+3901 */
  0x0000,   /* U+3902 */
  0x0000,   /* U+3903 */
  0x0000,   /* U+3904 */
  0x0000,   /* U+3905 */
  0x0000,   /* U+3906 */
  0x0000,   /* U+3907 */
  0x0000,   /* U+3908 */
  0x0000,   /* U+3909 */
  0x0000,   /* U+390A */
  0x0000,   /* U+390B */
  0x0000,   /* U+390C */
  0x0000,   /* U+390D */
  0x0000,   /* U+390E */
  0x0000,   /* U+390F */
  0x0000,   /* U+3910 */
  0x0000,   /* U+3911 */
  0x0000,   /* U+3912 */
  0x0000,   /* U+3913 */
  0x0000,   /* U+3914 */
  0x0000,   /* U+3915 */
  0x0000,   /* U+3916 */
  0x0000,   /* U+3917 */
  0x0000,   /* U+3918 */
  0x0000,   /* U+3919 */
  0x0000,   /* U+391A */
  0x0000,   /* U+391B */
  0x0000,   /* U+391C */
  0x0000,   /* U+391D */
  0x0000,   /* U+391E */
  0x0000,   /* U+391F */
  0x0000,   /* U+3920 */
  0x0000,   /* U+3921 */
  0x0000,   /* U+3922 */
  0x0000,   /* U+3923 */
  0x0000,   /* U+3924 */
  0x0000,   /* U+3925 */
  0x0000,   /* U+3926 */
  0x0000,   /* U+3927 */
  0x0000,   /* U+3928 */
  0x0000,   /* U+3929 */
  0x0000,   /* U+392A */
  0x0000,   /* U+392B */
  0x0000,   /* U+392C */
  0x0000,   /* U+392D */
  0x0000,   /* U+392E */
  0x0000,   /* U+392F */
  0x0000,   /* U+3930 */
  0x0000,   /* U+3931 */
  0x0000,   /* U+3932 */
  0x0000,   /* U+3933 */
  0x0000,   /* U+3934 */
  0x0000,   /* U+3935 */
  0x0000,   /* U+3936 */
  0x0000,   /* U+3937 */
  0x0000,   /* U+3938 */
  0x0000,   /* U+3939 */
  0x0000,   /* U+393A */
  0x0000,   /* U+393B */
  0x0000,   /* U+393C */
  0x0000,   /* U+393D */
  0x0000,   /* U+393E */
  0x0000,   /* U+393F */
  0x0000,   /* U+3940 */
  0x0000,   /* U+3941 */
  0x0000,   /* U+3942 */
  0x0000,   /* U+3943 */
  0x0000,   /* U+3944 */
  0x0000,   /* U+3945 */
  0x0000,   /* U+3946 */
  0x0000,   /* U+3947 */
  0x0000,   /* U+3948 */
  0x0000,   /* U+3949 */
  0x0000,   /* U+394A */
  0x0000,   /* U+394B */
  0x0000,   /* U+394C */
  0x0000,   /* U+394D */
  0x0000,   /* U+394E */
  0x0000,   /* U+394F */
  0x0000,   /* U+3950 */
  0x0000,   /* U+3951 */
  0x0000,   /* U+3952 */
  0x0000,   /* U+3953 */
  0x0000,   /* U+3954 */
  0x0000,   /* U+3955 */
  0x0000,   /* U+3956 */
  0x0000,   /* U+3957 */
  0x0000,   /* U+3958 */
  0x0000,   /* U+3959 */
  0x0000,   /* U+395A */
  0x0000,   /* U+395B */
  0x0000,   /* U+395C */
  0x0000,   /* U+395D */
  0x0000,   /* U+395E */
  0x0000,   /* U+395F */
  0x0000,   /* U+3960 */
  0x0000,   /* U+3961 */
  0x0000,   /* U+3962 */
  0x0000,   /* U+3963 */
  0x0000,   /* U+3964 */
  0x0000,   /* U+3965 */
  0x0000,   /* U+3966 */
  0x0000,   /* U+3967 */
  0x0000,   /* U+3968 */
  0x0000,   /* U+3969 */
  0x0000,   /* U+396A */
  0x0000,   /* U+396B */
  0x0000,   /* U+396C */
  0x0000,   /* U+396D */
  0x0000,   /* U+396E */
  0x0000,   /* U+396F */
  0x0000,   /* U+3970 */
  0x0000,   /* U+3971 */
  0x0000,   /* U+3972 */
  0x0000,   /* U+3973 */
  0x0000,   /* U+3974 */
  0x0000,   /* U+3975 */
  0x0000,   /* U+3976 */
  0x0000,   /* U+3977 */
  0x0000,   /* U+3978 */
  0x0000,   /* U+3979 */
  0x0000,   /* U+397A */
  0x0000,   /* U+397B */
  0x0000,   /* U+397C */
  0x0000,   /* U+397D */
  0x0000,   /* U+397E */
  0x0000,   /* U+397F */
  0x0000,   /* U+3980 */
  0x0000,   /* U+3981 */
  0x0000,   /* U+3982 */
  0x0000,   /* U+3983 */
  0x0000,   /* U+3984 */
  0x0000,   /* U+3985 */
  0x0000,   /* U+3986 */
  0x0000,   /* U+3987 */
  0x0000,   /* U+3988 */
  0x0000,   /* U+3989 */
  0x0000,   /* U+398A */
  0x0000,   /* U+398B */
  0x0000,   /* U+398C */
  0x0000,   /* U+398D */
  0x0000,   /* U+398E */
  0x0000,   /* U+398F */
  0x0000,   /* U+3990 */
  0x0000,   /* U+3991 */
  0x0000,   /* U+3992 */
  0x0000,   /* U+3993 */
  0x0000,   /* U+3994 */
  0x0000,   /* U+3995 */
  0x0000,   /* U+3996 */
  0x0000,   /* U+3997 */
  0x0000,   /* U+3998 */
  0x0000,   /* U+3999 */
  0x0000,   /* U+399A */
  0x0000,   /* U+399B */
  0x0000,   /* U+399C */
  0x0000,   /* U+399D */
  0x0000,   /* U+399E */
  0x0000,   /* U+399F */
  0x0000,   /* U+39A0 */
  0x0000,   /* U+39A1 */
  0x0000,   /* U+39A2 */
  0x0000,   /* U+39A3 */
  0x0000,   /* U+39A4 */
  0x0000,   /* U+39A5 */
  0x0000,   /* U+39A6 */
  0x0000,   /* U+39A7 */
  0x0000,   /* U+39A8 */
  0x0000,   /* U+39A9 */
  0x0000,   /* U+39AA */
  0x0000,   /* U+39AB */
  0x0000,   /* U+39AC */
  0x0000,   /* U+39AD */
  0x0000,   /* U+39AE */
  0x0000,   /* U+39AF */
  0x0000,   /* U+39B0 */
  0x0000,   /* U+39B1 */
  0x0000,   /* U+39B2 */
  0x0000,   /* U+39B3 */
  0x0000,   /* U+39B4 */
  0x0000,   /* U+39B5 */
  0x0000,   /* U+39B6 */
  0x0000,   /* U+39B7 */
  0x0000,   /* U+39B8 */
  0x0000,   /* U+39B9 */
  0x0000,   /* U+39BA */
  0x0000,   /* U+39BB */
  0x0000,   /* U+39BC */
  0x0000,   /* U+39BD */
  0x0000,   /* U+39BE */
  0x0000,   /* U+39BF */
  0x0000,   /* U+39C0 */
  0x0000,   /* U+39C1 */
  0x0000,   /* U+39C2 */
  0x0000,   /* U+39C3 */
  0x0000,   /* U+39C4 */
  0x0000,   /* U+39C5 */
  0x0000,   /* U+39C6 */
  0x0000,   /* U+39C7 */
  0x0000,   /* U+39C8 */
  0x0000,   /* U+39C9 */
  0x0000,   /* U+39CA */
  0x0000,   /* U+39CB */
  0x0000,   /* U+39CC */
  0x0000,   /* U+39CD */
  0x0000,   /* U+39CE */
  0x0000,   /* U+39CF */
  0x0000,   /* U+39D0 */
  0x0000,   /* U+39D1 */
  0x0000,   /* U+39D2 */
  0x0000,   /* U+39D3 */
  0x0000,   /* U+39D4 */
  0x0000,   /* U+39D5 */
  0x0000,   /* U+39D6 */
  0x0000,   /* U+39D7 */
  0x0000,   /* U+39D8 */
  0x0000,   /* U+39D9 */
  0x0000,   /* U+39DA */
  0x0000,   /* U+39DB */
  0x0000,   /* U+39DC */
  0x0000,   /* U+39DD */
  0x0000,   /* U+39DE */
  0x0000,   /* U+39DF */
  0x0000,   /* U+39E0 */
  0x0000,   /* U+39E1 */
  0x0000,   /* U+39E2 */
  0x0000,   /* U+39E3 */
  0x0000,   /* U+39E4 */
  0x0000,   /* U+39E5 */
  0x0000,   /* U+39E6 */
  0x0000,   /* U+39E7 */
  0x0000,   /* U+39E8 */
  0x0000,   /* U+39E9 */
  0x0000,   /* U+39EA */
  0x0000,   /* U+39EB */
  0x0000,   /* U+39EC */
  0x0000,   /* U+39ED */
  0x0000,   /* U+39EE */
  0x0000,   /* U+39EF */
  0x0000,   /* U+39F0 */
  0x0000,   /* U+39F1 */
  0x0000,   /* U+39F2 */
  0x0000,   /* U+39F3 */
  0x0000,   /* U+39F4 */
  0x0000,   /* U+39F5 */
  0x0000,   /* U+39F6 */
  0x0000,   /* U+39F7 */
  0x0000,   /* U+39F8 */
  0x0000,   /* U+39F9 */
  0x0000,   /* U+39FA */
  0x0000,   /* U+39FB */
  0x0000,   /* U+39FC */
  0x0000,   /* U+39FD */
  0x0000,   /* U+39FE */
  0x0000,   /* U+39FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3900 */
  0x0000,   /* U+3901 */
  0x0000,   /* U+3902 */
  0x0000,   /* U+3903 */
  0x0000,   /* U+3904 */
  0x0000,   /* U+3905 */
  0x0000,   /* U+3906 */
  0x0000,   /* U+3907 */
  0x0000,   /* U+3908 */
  0x0000,   /* U+3909 */
  0x0000,   /* U+390A */
  0x0000,   /* U+390B */
  0x0000,   /* U+390C */
  0x0000,   /* U+390D */
  0x0000,   /* U+390E */
  0x0000,   /* U+390F */
  0x0000,   /* U+3910 */
  0x0000,   /* U+3911 */
  0x0000,   /* U+3912 */
  0x0000,   /* U+3913 */
  0x0000,   /* U+3914 */
  0x0000,   /* U+3915 */
  0x0000,   /* U+3916 */
  0x0000,   /* U+3917 */
  0x0000,   /* U+3918 */
  0x0000,   /* U+3919 */
  0x0000,   /* U+391A */
  0x0000,   /* U+391B */
  0x0000,   /* U+391C */
  0x0000,   /* U+391D */
  0x0000,   /* U+391E */
  0x0000,   /* U+391F */
  0x0000,   /* U+3920 */
  0x0000,   /* U+3921 */
  0x0000,   /* U+3922 */
  0x0000,   /* U+3923 */
  0x0000,   /* U+3924 */
  0x0000,   /* U+3925 */
  0x0000,   /* U+3926 */
  0x0000,   /* U+3927 */
  0x0000,   /* U+3928 */
  0x0000,   /* U+3929 */
  0x0000,   /* U+392A */
  0x0000,   /* U+392B */
  0x0000,   /* U+392C */
  0x0000,   /* U+392D */
  0x0000,   /* U+392E */
  0x0000,   /* U+392F */
  0x0000,   /* U+3930 */
  0x0000,   /* U+3931 */
  0x0000,   /* U+3932 */
  0x0000,   /* U+3933 */
  0x0000,   /* U+3934 */
  0x0000,   /* U+3935 */
  0x0000,   /* U+3936 */
  0x0000,   /* U+3937 */
  0x0000,   /* U+3938 */
  0x0000,   /* U+3939 */
  0x0000,   /* U+393A */
  0x0000,   /* U+393B */
  0x0000,   /* U+393C */
  0x0000,   /* U+393D */
  0x0000,   /* U+393E */
  0x0000,   /* U+393F */
  0x0000,   /* U+3940 */
  0x0000,   /* U+3941 */
  0x0000,   /* U+3942 */
  0x0000,   /* U+3943 */
  0x0000,   /* U+3944 */
  0x0000,   /* U+3945 */
  0x0000,   /* U+3946 */
  0x0000,   /* U+3947 */
  0x0000,   /* U+3948 */
  0x0000,   /* U+3949 */
  0x0000,   /* U+394A */
  0x0000,   /* U+394B */
  0x0000,   /* U+394C */
  0x0000,   /* U+394D */
  0x0000,   /* U+394E */
  0x0000,   /* U+394F */
  0x0000,   /* U+3950 */
  0x0000,   /* U+3951 */
  0x0000,   /* U+3952 */
  0x0000,   /* U+3953 */
  0x0000,   /* U+3954 */
  0x0000,   /* U+3955 */
  0x0000,   /* U+3956 */
  0x0000,   /* U+3957 */
  0x0000,   /* U+3958 */
  0x0000,   /* U+3959 */
  0x0000,   /* U+395A */
  0x0000,   /* U+395B */
  0x0000,   /* U+395C */
  0x0000,   /* U+395D */
  0x0000,   /* U+395E */
  0x0000,   /* U+395F */
  0x0000,   /* U+3960 */
  0x0000,   /* U+3961 */
  0x0000,   /* U+3962 */
  0x0000,   /* U+3963 */
  0x0000,   /* U+3964 */
  0x0000,   /* U+3965 */
  0x0000,   /* U+3966 */
  0x0000,   /* U+3967 */
  0x0000,   /* U+3968 */
  0x0000,   /* U+3969 */
  0x0000,   /* U+396A */
  0x0000,   /* U+396B */
  0x0000,   /* U+396C */
  0x0000,   /* U+396D */
  0x0000,   /* U+396E */
  0x0000,   /* U+396F */
  0x0000,   /* U+3970 */
  0x0000,   /* U+3971 */
  0x0000,   /* U+3972 */
  0x0000,   /* U+3973 */
  0x0000,   /* U+3974 */
  0x0000,   /* U+3975 */
  0x0000,   /* U+3976 */
  0x0000,   /* U+3977 */
  0x0000,   /* U+3978 */
  0x0000,   /* U+3979 */
  0x0000,   /* U+397A */
  0x0000,   /* U+397B */
  0x0000,   /* U+397C */
  0x0000,   /* U+397D */
  0x0000,   /* U+397E */
  0x0000,   /* U+397F */
  0x0000,   /* U+3980 */
  0x0000,   /* U+3981 */
  0x0000,   /* U+3982 */
  0x0000,   /* U+3983 */
  0x0000,   /* U+3984 */
  0x0000,   /* U+3985 */
  0x0000,   /* U+3986 */
  0x0000,   /* U+3987 */
  0x0000,   /* U+3988 */
  0x0000,   /* U+3989 */
  0x0000,   /* U+398A */
  0x0000,   /* U+398B */
  0x0000,   /* U+398C */
  0x0000,   /* U+398D */
  0x0000,   /* U+398E */
  0x0000,   /* U+398F */
  0x0000,   /* U+3990 */
  0x0000,   /* U+3991 */
  0x0000,   /* U+3992 */
  0x0000,   /* U+3993 */
  0x0000,   /* U+3994 */
  0x0000,   /* U+3995 */
  0x0000,   /* U+3996 */
  0x0000,   /* U+3997 */
  0x0000,   /* U+3998 */
  0x0000,   /* U+3999 */
  0x0000,   /* U+399A */
  0x0000,   /* U+399B */
  0x0000,   /* U+399C */
  0x0000,   /* U+399D */
  0x0000,   /* U+399E */
  0x0000,   /* U+399F */
  0x0000,   /* U+39A0 */
  0x0000,   /* U+39A1 */
  0x0000,   /* U+39A2 */
  0x0000,   /* U+39A3 */
  0x0000,   /* U+39A4 */
  0x0000,   /* U+39A5 */
  0x0000,   /* U+39A6 */
  0x0000,   /* U+39A7 */
  0x0000,   /* U+39A8 */
  0x0000,   /* U+39A9 */
  0x0000,   /* U+39AA */
  0x0000,   /* U+39AB */
  0x0000,   /* U+39AC */
  0x0000,   /* U+39AD */
  0x0000,   /* U+39AE */
  0x0000,   /* U+39AF */
  0x0000,   /* U+39B0 */
  0x0000,   /* U+39B1 */
  0x0000,   /* U+39B2 */
  0x0000,   /* U+39B3 */
  0x0000,   /* U+39B4 */
  0x0000,   /* U+39B5 */
  0x0000,   /* U+39B6 */
  0x0000,   /* U+39B7 */
  0x0000,   /* U+39B8 */
  0x0000,   /* U+39B9 */
  0x0000,   /* U+39BA */
  0x0000,   /* U+39BB */
  0x0000,   /* U+39BC */
  0x0000,   /* U+39BD */
  0x0000,   /* U+39BE */
  0x0000,   /* U+39BF */
  0x0000,   /* U+39C0 */
  0x0000,   /* U+39C1 */
  0x0000,   /* U+39C2 */
  0x0000,   /* U+39C3 */
  0x0000,   /* U+39C4 */
  0x0000,   /* U+39C5 */
  0x0000,   /* U+39C6 */
  0x0000,   /* U+39C7 */
  0x0000,   /* U+39C8 */
  0x0000,   /* U+39C9 */
  0x0000,   /* U+39CA */
  0x0000,   /* U+39CB */
  0x0000,   /* U+39CC */
  0x0000,   /* U+39CD */
  0x0000,   /* U+39CE */
  0x0000,   /* U+39CF */
  0x0000,   /* U+39D0 */
  0x0000,   /* U+39D1 */
  0x0000,   /* U+39D2 */
  0x0000,   /* U+39D3 */
  0x0000,   /* U+39D4 */
  0x0000,   /* U+39D5 */
  0x0000,   /* U+39D6 */
  0x0000,   /* U+39D7 */
  0x0000,   /* U+39D8 */
  0x0000,   /* U+39D9 */
  0x0000,   /* U+39DA */
  0x0000,   /* U+39DB */
  0x0000,   /* U+39DC */
  0x0000,   /* U+39DD */
  0x0000,   /* U+39DE */
  0x0000,   /* U+39DF */
  0x0000,   /* U+39E0 */
  0x0000,   /* U+39E1 */
  0x0000,   /* U+39E2 */
  0x0000,   /* U+39E3 */
  0x0000,   /* U+39E4 */
  0x0000,   /* U+39E5 */
  0x0000,   /* U+39E6 */
  0x0000,   /* U+39E7 */
  0x0000,   /* U+39E8 */
  0x0000,   /* U+39E9 */
  0x0000,   /* U+39EA */
  0x0000,   /* U+39EB */
  0x0000,   /* U+39EC */
  0x0000,   /* U+39ED */
  0x0000,   /* U+39EE */
  0x0000,   /* U+39EF */
  0x0000,   /* U+39F0 */
  0x0000,   /* U+39F1 */
  0x0000,   /* U+39F2 */
  0x0000,   /* U+39F3 */
  0x0000,   /* U+39F4 */
  0x0000,   /* U+39F5 */
  0x0000,   /* U+39F6 */
  0x0000,   /* U+39F7 */
  0x0000,   /* U+39F8 */
  0x0000,   /* U+39F9 */
  0x0000,   /* U+39FA */
  0x0000,   /* U+39FB */
  0x0000,   /* U+39FC */
  0x0000,   /* U+39FD */
  0x0000,   /* U+39FE */
  0x0000,   /* U+39FF */
};

uint16 zh3_han_p03A[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C52,   /* U+3A00 */
  0x1C52,   /* U+3A01 */
  0x1C52,   /* U+3A02 */
  0x1C52,   /* U+3A03 */
  0x1C52,   /* U+3A04 */
  0x1C52,   /* U+3A05 */
  0x1C52,   /* U+3A06 */
  0x1C53,   /* U+3A07 */
  0x1C52,   /* U+3A08 */
  0x1C53,   /* U+3A09 */
  0x1C53,   /* U+3A0A */
  0x1C53,   /* U+3A0B */
  0x1C54,   /* U+3A0C */
  0x1C54,   /* U+3A0D */
  0x1C53,   /* U+3A0E */
  0x1C53,   /* U+3A0F */
  0x1C53,   /* U+3A10 */
  0x1C53,   /* U+3A11 */
  0x1C53,   /* U+3A12 */
  0x1C53,   /* U+3A13 */
  0x1C53,   /* U+3A14 */
  0x1C53,   /* U+3A15 */
  0x1C53,   /* U+3A16 */
  0x1C53,   /* U+3A17 */
  0x1C53,   /* U+3A18 */
  0x1C54,   /* U+3A19 */
  0x1C54,   /* U+3A1A */
  0x1C54,   /* U+3A1B */
  0x1C54,   /* U+3A1C */
  0x1C54,   /* U+3A1D */
  0x1C54,   /* U+3A1E */
  0x1C54,   /* U+3A1F */
  0x1C54,   /* U+3A20 */
  0x1C54,   /* U+3A21 */
  0x1C54,   /* U+3A22 */
  0x1C54,   /* U+3A23 */
  0x1C54,   /* U+3A24 */
  0x1C54,   /* U+3A25 */
  0x1C54,   /* U+3A26 */
  0x1C54,   /* U+3A27 */
  0x1C54,   /* U+3A28 */
  0x1C54,   /* U+3A29 */
  0x1C54,   /* U+3A2A */
  0x1C54,   /* U+3A2B */
  0x1C54,   /* U+3A2C */
  0x1C55,   /* U+3A2D */
  0x1C55,   /* U+3A2E */
  0x1C55,   /* U+3A2F */
  0x1C55,   /* U+3A30 */
  0x1C55,   /* U+3A31 */
  0x1C55,   /* U+3A32 */
  0x1C55,   /* U+3A33 */
  0x1C55,   /* U+3A34 */
  0x1C55,   /* U+3A35 */
  0x1C55,   /* U+3A36 */
  0x1C55,   /* U+3A37 */
  0x1C55,   /* U+3A38 */
  0x1C55,   /* U+3A39 */
  0x1C55,   /* U+3A3A */
  0x1C56,   /* U+3A3B */
  0x1C56,   /* U+3A3C */
  0x1C55,   /* U+3A3D */
  0x1C55,   /* U+3A3E */
  0x1C55,   /* U+3A3F */
  0x1C55,   /* U+3A40 */
  0x1C55,   /* U+3A41 */
  0x1C55,   /* U+3A42 */
  0x1C56,   /* U+3A43 */
  0x1C56,   /* U+3A44 */
  0x1C56,   /* U+3A45 */
  0x1C56,   /* U+3A46 */
  0x1C56,   /* U+3A47 */
  0x1C56,   /* U+3A48 */
  0x1C56,   /* U+3A49 */
  0x1C56,   /* U+3A4A */
  0x1C56,   /* U+3A4B */
  0x1C56,   /* U+3A4C */
  0x1C56,   /* U+3A4D */
  0x1C56,   /* U+3A4E */
  0x1C56,   /* U+3A4F */
  0x1C56,   /* U+3A50 */
  0x1C56,   /* U+3A51 */
  0x1C57,   /* U+3A52 */
  0x1C58,   /* U+3A53 */
  0x1C57,   /* U+3A54 */
  0x1C57,   /* U+3A55 */
  0x1C57,   /* U+3A56 */
  0x1C57,   /* U+3A57 */
  0x1C57,   /* U+3A58 */
  0x1C57,   /* U+3A59 */
  0x1C58,   /* U+3A5A */
  0x1C58,   /* U+3A5B */
  0x1C58,   /* U+3A5C */
  0x1C58,   /* U+3A5D */
  0x1C58,   /* U+3A5E */
  0x1C58,   /* U+3A5F */
  0x1C59,   /* U+3A60 */
  0x1C59,   /* U+3A61 */
  0x1C59,   /* U+3A62 */
  0x1C59,   /* U+3A63 */
  0x1C59,   /* U+3A64 */
  0x1C59,   /* U+3A65 */
  0x1C59,   /* U+3A66 */
  0x1C59,   /* U+3A67 */
  0x1C59,   /* U+3A68 */
  0x1C59,   /* U+3A69 */
  0x1C59,   /* U+3A6A */
  0x1C59,   /* U+3A6B */
  0x1C5A,   /* U+3A6C */
  0x1C5A,   /* U+3A6D */
  0x1C5B,   /* U+3A6E */
  0x1C5B,   /* U+3A6F */
  0x1C5B,   /* U+3A70 */
  0x1C5C,   /* U+3A71 */
  0x1C5C,   /* U+3A72 */
  0x1C5C,   /* U+3A73 */
  0x1C5C,   /* U+3A74 */
  0x1C5E,   /* U+3A75 */
  0x1C5E,   /* U+3A76 */
  0x1C5E,   /* U+3A77 */
  0x1C60,   /* U+3A78 */
  0x1C60,   /* U+3A79 */
  0x1C4F,   /* U+3A7A */
  0x1C51,   /* U+3A7B */
  0x1C51,   /* U+3A7C */
  0x1C52,   /* U+3A7D */
  0x1C53,   /* U+3A7E */
  0x1C4E,   /* U+3A7F */
  0x1C4E,   /* U+3A80 */
  0x1C4F,   /* U+3A81 */
  0x1C4F,   /* U+3A82 */
  0x1C50,   /* U+3A83 */
  0x1C50,   /* U+3A84 */
  0x1C50,   /* U+3A85 */
  0x1C50,   /* U+3A86 */
  0x1C51,   /* U+3A87 */
  0x1C51,   /* U+3A88 */
  0x1C51,   /* U+3A89 */
  0x1C52,   /* U+3A8A */
  0x1C52,   /* U+3A8B */
  0x1C52,   /* U+3A8C */
  0x1C52,   /* U+3A8D */
  0x1C52,   /* U+3A8E */
  0x1C53,   /* U+3A8F */
  0x1C53,   /* U+3A90 */
  0x1C53,   /* U+3A91 */
  0x1C53,   /* U+3A92 */
  0x1C53,   /* U+3A93 */
  0x1C53,   /* U+3A94 */
  0x1C53,   /* U+3A95 */
  0x1C53,   /* U+3A96 */
  0x1C53,   /* U+3A97 */
  0x1C53,   /* U+3A98 */
  0x1C53,   /* U+3A99 */
  0x1C53,   /* U+3A9A */
  0x1C54,   /* U+3A9B */
  0x1C54,   /* U+3A9C */
  0x1C54,   /* U+3A9D */
  0x1C54,   /* U+3A9E */
  0x1C54,   /* U+3A9F */
  0x1C55,   /* U+3AA0 */
  0x1C55,   /* U+3AA1 */
  0x1C55,   /* U+3AA2 */
  0x1C55,   /* U+3AA3 */
  0x1C56,   /* U+3AA4 */
  0x1C56,   /* U+3AA5 */
  0x1C56,   /* U+3AA6 */
  0x1C57,   /* U+3AA7 */
  0x1C57,   /* U+3AA8 */
  0x1C57,   /* U+3AA9 */
  0x1C57,   /* U+3AAA */
  0x1C59,   /* U+3AAB */
  0x1C59,   /* U+3AAC */
  0x1C5B,   /* U+3AAD */
  0x1C5C,   /* U+3AAE */
  0x1C4E,   /* U+3AAF */
  0x1C51,   /* U+3AB0 */
  0x1C54,   /* U+3AB1 */
  0x1C4D,   /* U+3AB2 */
  0x1C4D,   /* U+3AB3 */
  0x1C4F,   /* U+3AB4 */
  0x1C50,   /* U+3AB5 */
  0x1C51,   /* U+3AB6 */
  0x1C52,   /* U+3AB7 */
  0x1C53,   /* U+3AB8 */
  0x1C56,   /* U+3AB9 */
  0x1C58,   /* U+3ABA */
  0x1C5E,   /* U+3ABB */
  0x1C50,   /* U+3ABC */
  0x1C50,   /* U+3ABD */
  0x1C51,   /* U+3ABE */
  0x1C51,   /* U+3ABF */
  0x1C53,   /* U+3AC0 */
  0x1C55,   /* U+3AC1 */
  0x1C56,   /* U+3AC2 */
  0x1C4D,   /* U+3AC3 */
  0x1C4F,   /* U+3AC4 */
  0x1C51,   /* U+3AC5 */
  0x1C50,   /* U+3AC6 */
  0x1C51,   /* U+3AC7 */
  0x1C51,   /* U+3AC8 */
  0x1C51,   /* U+3AC9 */
  0x1C52,   /* U+3ACA */
  0x1C52,   /* U+3ACB */
  0x1C52,   /* U+3ACC */
  0x1C53,   /* U+3ACD */
  0x1C56,   /* U+3ACE */
  0x1C56,   /* U+3ACF */
  0x1C4D,   /* U+3AD0 */
  0x1C4D,   /* U+3AD1 */
  0x1C4E,   /* U+3AD2 */
  0x1C4E,   /* U+3AD3 */
  0x1C4E,   /* U+3AD4 */
  0x1C4E,   /* U+3AD5 */
  0x1C4E,   /* U+3AD6 */
  0x1C4E,   /* U+3AD7 */
  0x1C4F,   /* U+3AD8 */
  0x1C4F,   /* U+3AD9 */
  0x1C4F,   /* U+3ADA */
  0x1C50,   /* U+3ADB */
  0x1C50,   /* U+3ADC */
  0x1C50,   /* U+3ADD */
  0x1C50,   /* U+3ADE */
  0x1C50,   /* U+3ADF */
  0x1C50,   /* U+3AE0 */
  0x1C50,   /* U+3AE1 */
  0x1C50,   /* U+3AE2 */
  0x1C50,   /* U+3AE3 */
  0x1C50,   /* U+3AE4 */
  0x1C51,   /* U+3AE5 */
  0x1C51,   /* U+3AE6 */
  0x1C51,   /* U+3AE7 */
  0x1C51,   /* U+3AE8 */
  0x1C51,   /* U+3AE9 */
  0x1C51,   /* U+3AEA */
  0x1C51,   /* U+3AEB */
  0x1C51,   /* U+3AEC */
  0x1C51,   /* U+3AED */
  0x1C51,   /* U+3AEE */
  0x1C52,   /* U+3AEF */
  0x1C52,   /* U+3AF0 */
  0x1C52,   /* U+3AF1 */
  0x1C52,   /* U+3AF2 */
  0x1C52,   /* U+3AF3 */
  0x1C52,   /* U+3AF4 */
  0x1C53,   /* U+3AF5 */
  0x1C53,   /* U+3AF6 */
  0x1C53,   /* U+3AF7 */
  0x1C53,   /* U+3AF8 */
  0x1C53,   /* U+3AF9 */
  0x1C53,   /* U+3AFA */
  0x1C53,   /* U+3AFB */
  0x1C53,   /* U+3AFC */
  0x1C53,   /* U+3AFD */
  0x1C53,   /* U+3AFE */
  0x1C53,   /* U+3AFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3A00 */
  0x0020,   /* U+3A01 */
  0x0020,   /* U+3A02 */
  0x0020,   /* U+3A03 */
  0x0020,   /* U+3A04 */
  0x0020,   /* U+3A05 */
  0x0020,   /* U+3A06 */
  0x0020,   /* U+3A07 */
  0x0020,   /* U+3A08 */
  0x0020,   /* U+3A09 */
  0x0020,   /* U+3A0A */
  0x0020,   /* U+3A0B */
  0x0020,   /* U+3A0C */
  0x0020,   /* U+3A0D */
  0x0020,   /* U+3A0E */
  0x0020,   /* U+3A0F */
  0x0020,   /* U+3A10 */
  0x0020,   /* U+3A11 */
  0x0020,   /* U+3A12 */
  0x0020,   /* U+3A13 */
  0x0020,   /* U+3A14 */
  0x0020,   /* U+3A15 */
  0x0020,   /* U+3A16 */
  0x0020,   /* U+3A17 */
  0x0020,   /* U+3A18 */
  0x0020,   /* U+3A19 */
  0x0020,   /* U+3A1A */
  0x0020,   /* U+3A1B */
  0x0020,   /* U+3A1C */
  0x0020,   /* U+3A1D */
  0x0020,   /* U+3A1E */
  0x0020,   /* U+3A1F */
  0x0020,   /* U+3A20 */
  0x0020,   /* U+3A21 */
  0x0020,   /* U+3A22 */
  0x0020,   /* U+3A23 */
  0x0020,   /* U+3A24 */
  0x0020,   /* U+3A25 */
  0x0020,   /* U+3A26 */
  0x0020,   /* U+3A27 */
  0x0020,   /* U+3A28 */
  0x0020,   /* U+3A29 */
  0x0020,   /* U+3A2A */
  0x0020,   /* U+3A2B */
  0x0020,   /* U+3A2C */
  0x0020,   /* U+3A2D */
  0x0020,   /* U+3A2E */
  0x0020,   /* U+3A2F */
  0x0020,   /* U+3A30 */
  0x0020,   /* U+3A31 */
  0x0020,   /* U+3A32 */
  0x0020,   /* U+3A33 */
  0x0020,   /* U+3A34 */
  0x0020,   /* U+3A35 */
  0x0020,   /* U+3A36 */
  0x0020,   /* U+3A37 */
  0x0020,   /* U+3A38 */
  0x0020,   /* U+3A39 */
  0x0020,   /* U+3A3A */
  0x0020,   /* U+3A3B */
  0x0020,   /* U+3A3C */
  0x0020,   /* U+3A3D */
  0x0020,   /* U+3A3E */
  0x0020,   /* U+3A3F */
  0x0020,   /* U+3A40 */
  0x0020,   /* U+3A41 */
  0x0020,   /* U+3A42 */
  0x0020,   /* U+3A43 */
  0x0020,   /* U+3A44 */
  0x0020,   /* U+3A45 */
  0x0020,   /* U+3A46 */
  0x0020,   /* U+3A47 */
  0x0020,   /* U+3A48 */
  0x0020,   /* U+3A49 */
  0x0020,   /* U+3A4A */
  0x0020,   /* U+3A4B */
  0x0020,   /* U+3A4C */
  0x0020,   /* U+3A4D */
  0x0020,   /* U+3A4E */
  0x0020,   /* U+3A4F */
  0x0020,   /* U+3A50 */
  0x0020,   /* U+3A51 */
  0x0020,   /* U+3A52 */
  0x0020,   /* U+3A53 */
  0x0020,   /* U+3A54 */
  0x0020,   /* U+3A55 */
  0x0020,   /* U+3A56 */
  0x0020,   /* U+3A57 */
  0x0020,   /* U+3A58 */
  0x0020,   /* U+3A59 */
  0x0020,   /* U+3A5A */
  0x0020,   /* U+3A5B */
  0x0020,   /* U+3A5C */
  0x0020,   /* U+3A5D */
  0x0020,   /* U+3A5E */
  0x0020,   /* U+3A5F */
  0x0020,   /* U+3A60 */
  0x0020,   /* U+3A61 */
  0x0020,   /* U+3A62 */
  0x0020,   /* U+3A63 */
  0x0020,   /* U+3A64 */
  0x0020,   /* U+3A65 */
  0x0020,   /* U+3A66 */
  0x0020,   /* U+3A67 */
  0x0020,   /* U+3A68 */
  0x0020,   /* U+3A69 */
  0x0020,   /* U+3A6A */
  0x0020,   /* U+3A6B */
  0x0020,   /* U+3A6C */
  0x0020,   /* U+3A6D */
  0x0020,   /* U+3A6E */
  0x0020,   /* U+3A6F */
  0x0020,   /* U+3A70 */
  0x0020,   /* U+3A71 */
  0x0020,   /* U+3A72 */
  0x0020,   /* U+3A73 */
  0x0020,   /* U+3A74 */
  0x0020,   /* U+3A75 */
  0x0020,   /* U+3A76 */
  0x0020,   /* U+3A77 */
  0x0020,   /* U+3A78 */
  0x0020,   /* U+3A79 */
  0x0020,   /* U+3A7A */
  0x0020,   /* U+3A7B */
  0x0020,   /* U+3A7C */
  0x0020,   /* U+3A7D */
  0x0020,   /* U+3A7E */
  0x0020,   /* U+3A7F */
  0x0020,   /* U+3A80 */
  0x0020,   /* U+3A81 */
  0x0020,   /* U+3A82 */
  0x0020,   /* U+3A83 */
  0x0020,   /* U+3A84 */
  0x0020,   /* U+3A85 */
  0x0020,   /* U+3A86 */
  0x0020,   /* U+3A87 */
  0x0020,   /* U+3A88 */
  0x0020,   /* U+3A89 */
  0x0020,   /* U+3A8A */
  0x0020,   /* U+3A8B */
  0x0020,   /* U+3A8C */
  0x0020,   /* U+3A8D */
  0x0020,   /* U+3A8E */
  0x0020,   /* U+3A8F */
  0x0020,   /* U+3A90 */
  0x0020,   /* U+3A91 */
  0x0020,   /* U+3A92 */
  0x0020,   /* U+3A93 */
  0x0020,   /* U+3A94 */
  0x0020,   /* U+3A95 */
  0x0020,   /* U+3A96 */
  0x0020,   /* U+3A97 */
  0x0020,   /* U+3A98 */
  0x0020,   /* U+3A99 */
  0x0020,   /* U+3A9A */
  0x0020,   /* U+3A9B */
  0x0020,   /* U+3A9C */
  0x0020,   /* U+3A9D */
  0x0020,   /* U+3A9E */
  0x0020,   /* U+3A9F */
  0x0020,   /* U+3AA0 */
  0x0020,   /* U+3AA1 */
  0x0020,   /* U+3AA2 */
  0x0020,   /* U+3AA3 */
  0x0020,   /* U+3AA4 */
  0x0020,   /* U+3AA5 */
  0x0020,   /* U+3AA6 */
  0x0020,   /* U+3AA7 */
  0x0020,   /* U+3AA8 */
  0x0020,   /* U+3AA9 */
  0x0020,   /* U+3AAA */
  0x0020,   /* U+3AAB */
  0x0020,   /* U+3AAC */
  0x0020,   /* U+3AAD */
  0x0020,   /* U+3AAE */
  0x0020,   /* U+3AAF */
  0x0020,   /* U+3AB0 */
  0x0020,   /* U+3AB1 */
  0x0020,   /* U+3AB2 */
  0x0020,   /* U+3AB3 */
  0x0020,   /* U+3AB4 */
  0x0020,   /* U+3AB5 */
  0x0020,   /* U+3AB6 */
  0x0020,   /* U+3AB7 */
  0x0020,   /* U+3AB8 */
  0x0020,   /* U+3AB9 */
  0x0020,   /* U+3ABA */
  0x0020,   /* U+3ABB */
  0x0020,   /* U+3ABC */
  0x0020,   /* U+3ABD */
  0x0020,   /* U+3ABE */
  0x0020,   /* U+3ABF */
  0x0020,   /* U+3AC0 */
  0x0020,   /* U+3AC1 */
  0x0020,   /* U+3AC2 */
  0x0020,   /* U+3AC3 */
  0x0020,   /* U+3AC4 */
  0x0020,   /* U+3AC5 */
  0x0020,   /* U+3AC6 */
  0x0020,   /* U+3AC7 */
  0x0020,   /* U+3AC8 */
  0x0020,   /* U+3AC9 */
  0x0020,   /* U+3ACA */
  0x0020,   /* U+3ACB */
  0x0020,   /* U+3ACC */
  0x0020,   /* U+3ACD */
  0x0020,   /* U+3ACE */
  0x0020,   /* U+3ACF */
  0x0020,   /* U+3AD0 */
  0x0020,   /* U+3AD1 */
  0x0020,   /* U+3AD2 */
  0x0020,   /* U+3AD3 */
  0x0020,   /* U+3AD4 */
  0x0020,   /* U+3AD5 */
  0x0020,   /* U+3AD6 */
  0x0020,   /* U+3AD7 */
  0x0020,   /* U+3AD8 */
  0x0020,   /* U+3AD9 */
  0x0020,   /* U+3ADA */
  0x0020,   /* U+3ADB */
  0x0020,   /* U+3ADC */
  0x0020,   /* U+3ADD */
  0x0020,   /* U+3ADE */
  0x0020,   /* U+3ADF */
  0x0020,   /* U+3AE0 */
  0x0020,   /* U+3AE1 */
  0x0020,   /* U+3AE2 */
  0x0020,   /* U+3AE3 */
  0x0020,   /* U+3AE4 */
  0x0020,   /* U+3AE5 */
  0x0020,   /* U+3AE6 */
  0x0020,   /* U+3AE7 */
  0x0020,   /* U+3AE8 */
  0x0020,   /* U+3AE9 */
  0x0020,   /* U+3AEA */
  0x0020,   /* U+3AEB */
  0x0020,   /* U+3AEC */
  0x0020,   /* U+3AED */
  0x0020,   /* U+3AEE */
  0x0020,   /* U+3AEF */
  0x0020,   /* U+3AF0 */
  0x0020,   /* U+3AF1 */
  0x0020,   /* U+3AF2 */
  0x0020,   /* U+3AF3 */
  0x0020,   /* U+3AF4 */
  0x0020,   /* U+3AF5 */
  0x0020,   /* U+3AF6 */
  0x0020,   /* U+3AF7 */
  0x0020,   /* U+3AF8 */
  0x0020,   /* U+3AF9 */
  0x0020,   /* U+3AFA */
  0x0020,   /* U+3AFB */
  0x0020,   /* U+3AFC */
  0x0020,   /* U+3AFD */
  0x0020,   /* U+3AFE */
  0x0020,   /* U+3AFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3A00 */
  0x0002,   /* U+3A01 */
  0x0002,   /* U+3A02 */
  0x0002,   /* U+3A03 */
  0x0002,   /* U+3A04 */
  0x0002,   /* U+3A05 */
  0x0002,   /* U+3A06 */
  0x0002,   /* U+3A07 */
  0x0002,   /* U+3A08 */
  0x0002,   /* U+3A09 */
  0x0002,   /* U+3A0A */
  0x0002,   /* U+3A0B */
  0x0002,   /* U+3A0C */
  0x0002,   /* U+3A0D */
  0x0002,   /* U+3A0E */
  0x0002,   /* U+3A0F */
  0x0002,   /* U+3A10 */
  0x0002,   /* U+3A11 */
  0x0002,   /* U+3A12 */
  0x0002,   /* U+3A13 */
  0x0002,   /* U+3A14 */
  0x0002,   /* U+3A15 */
  0x0002,   /* U+3A16 */
  0x0002,   /* U+3A17 */
  0x0002,   /* U+3A18 */
  0x0002,   /* U+3A19 */
  0x0002,   /* U+3A1A */
  0x0002,   /* U+3A1B */
  0x0002,   /* U+3A1C */
  0x0002,   /* U+3A1D */
  0x0002,   /* U+3A1E */
  0x0002,   /* U+3A1F */
  0x0002,   /* U+3A20 */
  0x0002,   /* U+3A21 */
  0x0002,   /* U+3A22 */
  0x0002,   /* U+3A23 */
  0x0002,   /* U+3A24 */
  0x0002,   /* U+3A25 */
  0x0002,   /* U+3A26 */
  0x0002,   /* U+3A27 */
  0x0002,   /* U+3A28 */
  0x0002,   /* U+3A29 */
  0x0002,   /* U+3A2A */
  0x0002,   /* U+3A2B */
  0x0002,   /* U+3A2C */
  0x0002,   /* U+3A2D */
  0x0002,   /* U+3A2E */
  0x0002,   /* U+3A2F */
  0x0002,   /* U+3A30 */
  0x0002,   /* U+3A31 */
  0x0002,   /* U+3A32 */
  0x0002,   /* U+3A33 */
  0x0002,   /* U+3A34 */
  0x0002,   /* U+3A35 */
  0x0002,   /* U+3A36 */
  0x0002,   /* U+3A37 */
  0x0002,   /* U+3A38 */
  0x0002,   /* U+3A39 */
  0x0002,   /* U+3A3A */
  0x0002,   /* U+3A3B */
  0x0002,   /* U+3A3C */
  0x0002,   /* U+3A3D */
  0x0002,   /* U+3A3E */
  0x0002,   /* U+3A3F */
  0x0002,   /* U+3A40 */
  0x0002,   /* U+3A41 */
  0x0002,   /* U+3A42 */
  0x0002,   /* U+3A43 */
  0x0002,   /* U+3A44 */
  0x0002,   /* U+3A45 */
  0x0002,   /* U+3A46 */
  0x0002,   /* U+3A47 */
  0x0002,   /* U+3A48 */
  0x0002,   /* U+3A49 */
  0x0002,   /* U+3A4A */
  0x0002,   /* U+3A4B */
  0x0002,   /* U+3A4C */
  0x0002,   /* U+3A4D */
  0x0002,   /* U+3A4E */
  0x0002,   /* U+3A4F */
  0x0002,   /* U+3A50 */
  0x0002,   /* U+3A51 */
  0x0002,   /* U+3A52 */
  0x0002,   /* U+3A53 */
  0x0002,   /* U+3A54 */
  0x0002,   /* U+3A55 */
  0x0002,   /* U+3A56 */
  0x0002,   /* U+3A57 */
  0x0002,   /* U+3A58 */
  0x0002,   /* U+3A59 */
  0x0002,   /* U+3A5A */
  0x0002,   /* U+3A5B */
  0x0002,   /* U+3A5C */
  0x0002,   /* U+3A5D */
  0x0002,   /* U+3A5E */
  0x0002,   /* U+3A5F */
  0x0002,   /* U+3A60 */
  0x0002,   /* U+3A61 */
  0x0002,   /* U+3A62 */
  0x0002,   /* U+3A63 */
  0x0002,   /* U+3A64 */
  0x0002,   /* U+3A65 */
  0x0002,   /* U+3A66 */
  0x0002,   /* U+3A67 */
  0x0002,   /* U+3A68 */
  0x0002,   /* U+3A69 */
  0x0002,   /* U+3A6A */
  0x0002,   /* U+3A6B */
  0x0002,   /* U+3A6C */
  0x0002,   /* U+3A6D */
  0x0002,   /* U+3A6E */
  0x0002,   /* U+3A6F */
  0x0002,   /* U+3A70 */
  0x0002,   /* U+3A71 */
  0x0002,   /* U+3A72 */
  0x0002,   /* U+3A73 */
  0x0002,   /* U+3A74 */
  0x0002,   /* U+3A75 */
  0x0002,   /* U+3A76 */
  0x0002,   /* U+3A77 */
  0x0002,   /* U+3A78 */
  0x0002,   /* U+3A79 */
  0x0002,   /* U+3A7A */
  0x0002,   /* U+3A7B */
  0x0002,   /* U+3A7C */
  0x0002,   /* U+3A7D */
  0x0002,   /* U+3A7E */
  0x0002,   /* U+3A7F */
  0x0002,   /* U+3A80 */
  0x0002,   /* U+3A81 */
  0x0002,   /* U+3A82 */
  0x0002,   /* U+3A83 */
  0x0002,   /* U+3A84 */
  0x0002,   /* U+3A85 */
  0x0002,   /* U+3A86 */
  0x0002,   /* U+3A87 */
  0x0002,   /* U+3A88 */
  0x0002,   /* U+3A89 */
  0x0002,   /* U+3A8A */
  0x0002,   /* U+3A8B */
  0x0002,   /* U+3A8C */
  0x0002,   /* U+3A8D */
  0x0002,   /* U+3A8E */
  0x0002,   /* U+3A8F */
  0x0002,   /* U+3A90 */
  0x0002,   /* U+3A91 */
  0x0002,   /* U+3A92 */
  0x0002,   /* U+3A93 */
  0x0002,   /* U+3A94 */
  0x0002,   /* U+3A95 */
  0x0002,   /* U+3A96 */
  0x0002,   /* U+3A97 */
  0x0002,   /* U+3A98 */
  0x0002,   /* U+3A99 */
  0x0002,   /* U+3A9A */
  0x0002,   /* U+3A9B */
  0x0002,   /* U+3A9C */
  0x0002,   /* U+3A9D */
  0x0002,   /* U+3A9E */
  0x0002,   /* U+3A9F */
  0x0002,   /* U+3AA0 */
  0x0002,   /* U+3AA1 */
  0x0002,   /* U+3AA2 */
  0x0002,   /* U+3AA3 */
  0x0002,   /* U+3AA4 */
  0x0002,   /* U+3AA5 */
  0x0002,   /* U+3AA6 */
  0x0002,   /* U+3AA7 */
  0x0002,   /* U+3AA8 */
  0x0002,   /* U+3AA9 */
  0x0002,   /* U+3AAA */
  0x0002,   /* U+3AAB */
  0x0002,   /* U+3AAC */
  0x0002,   /* U+3AAD */
  0x0002,   /* U+3AAE */
  0x0002,   /* U+3AAF */
  0x0002,   /* U+3AB0 */
  0x0002,   /* U+3AB1 */
  0x0002,   /* U+3AB2 */
  0x0002,   /* U+3AB3 */
  0x0002,   /* U+3AB4 */
  0x0002,   /* U+3AB5 */
  0x0002,   /* U+3AB6 */
  0x0002,   /* U+3AB7 */
  0x0002,   /* U+3AB8 */
  0x0002,   /* U+3AB9 */
  0x0002,   /* U+3ABA */
  0x0002,   /* U+3ABB */
  0x0002,   /* U+3ABC */
  0x0002,   /* U+3ABD */
  0x0002,   /* U+3ABE */
  0x0002,   /* U+3ABF */
  0x0002,   /* U+3AC0 */
  0x0002,   /* U+3AC1 */
  0x0002,   /* U+3AC2 */
  0x0002,   /* U+3AC3 */
  0x0002,   /* U+3AC4 */
  0x0002,   /* U+3AC5 */
  0x0002,   /* U+3AC6 */
  0x0002,   /* U+3AC7 */
  0x0002,   /* U+3AC8 */
  0x0002,   /* U+3AC9 */
  0x0002,   /* U+3ACA */
  0x0002,   /* U+3ACB */
  0x0002,   /* U+3ACC */
  0x0002,   /* U+3ACD */
  0x0002,   /* U+3ACE */
  0x0002,   /* U+3ACF */
  0x0002,   /* U+3AD0 */
  0x0002,   /* U+3AD1 */
  0x0002,   /* U+3AD2 */
  0x0002,   /* U+3AD3 */
  0x0002,   /* U+3AD4 */
  0x0002,   /* U+3AD5 */
  0x0002,   /* U+3AD6 */
  0x0002,   /* U+3AD7 */
  0x0002,   /* U+3AD8 */
  0x0002,   /* U+3AD9 */
  0x0002,   /* U+3ADA */
  0x0002,   /* U+3ADB */
  0x0002,   /* U+3ADC */
  0x0002,   /* U+3ADD */
  0x0002,   /* U+3ADE */
  0x0002,   /* U+3ADF */
  0x0002,   /* U+3AE0 */
  0x0002,   /* U+3AE1 */
  0x0002,   /* U+3AE2 */
  0x0002,   /* U+3AE3 */
  0x0002,   /* U+3AE4 */
  0x0002,   /* U+3AE5 */
  0x0002,   /* U+3AE6 */
  0x0002,   /* U+3AE7 */
  0x0002,   /* U+3AE8 */
  0x0002,   /* U+3AE9 */
  0x0002,   /* U+3AEA */
  0x0002,   /* U+3AEB */
  0x0002,   /* U+3AEC */
  0x0002,   /* U+3AED */
  0x0002,   /* U+3AEE */
  0x0002,   /* U+3AEF */
  0x0002,   /* U+3AF0 */
  0x0002,   /* U+3AF1 */
  0x0002,   /* U+3AF2 */
  0x0002,   /* U+3AF3 */
  0x0002,   /* U+3AF4 */
  0x0002,   /* U+3AF5 */
  0x0002,   /* U+3AF6 */
  0x0002,   /* U+3AF7 */
  0x0002,   /* U+3AF8 */
  0x0002,   /* U+3AF9 */
  0x0002,   /* U+3AFA */
  0x0002,   /* U+3AFB */
  0x0002,   /* U+3AFC */
  0x0002,   /* U+3AFD */
  0x0002,   /* U+3AFE */
  0x0002,   /* U+3AFF */

  /* Primary weight 2 for each character. */
  0x8946,   /* U+3A00 */
  0x8947,   /* U+3A01 */
  0x8948,   /* U+3A02 */
  0x8949,   /* U+3A03 */
  0x894A,   /* U+3A04 */
  0x894B,   /* U+3A05 */
  0x894C,   /* U+3A06 */
  0x88A9,   /* U+3A07 */
  0x894D,   /* U+3A08 */
  0x88F6,   /* U+3A09 */
  0x88F7,   /* U+3A0A */
  0x88F8,   /* U+3A0B */
  0x8734,   /* U+3A0C */
  0x8735,   /* U+3A0D */
  0x88F9,   /* U+3A0E */
  0x88FA,   /* U+3A0F */
  0x88FB,   /* U+3A10 */
  0x88FC,   /* U+3A11 */
  0x88FD,   /* U+3A12 */
  0x88FE,   /* U+3A13 */
  0x88FF,   /* U+3A14 */
  0x8900,   /* U+3A15 */
  0x89AC,   /* U+3A16 */
  0x8901,   /* U+3A17 */
  0x8902,   /* U+3A18 */
  0x8780,   /* U+3A19 */
  0x8781,   /* U+3A1A */
  0x8782,   /* U+3A1B */
  0x8783,   /* U+3A1C */
  0x8784,   /* U+3A1D */
  0x8785,   /* U+3A1E */
  0x8786,   /* U+3A1F */
  0x8787,   /* U+3A20 */
  0x8788,   /* U+3A21 */
  0x8789,   /* U+3A22 */
  0x878A,   /* U+3A23 */
  0x878B,   /* U+3A24 */
  0x878C,   /* U+3A25 */
  0x878D,   /* U+3A26 */
  0x878E,   /* U+3A27 */
  0x878F,   /* U+3A28 */
  0x8790,   /* U+3A29 */
  0x8791,   /* U+3A2A */
  0x8792,   /* U+3A2B */
  0x8793,   /* U+3A2C */
  0x874E,   /* U+3A2D */
  0x874F,   /* U+3A2E */
  0x8750,   /* U+3A2F */
  0x8751,   /* U+3A30 */
  0x8752,   /* U+3A31 */
  0x8753,   /* U+3A32 */
  0x8754,   /* U+3A33 */
  0x8755,   /* U+3A34 */
  0x8756,   /* U+3A35 */
  0x8757,   /* U+3A36 */
  0x8758,   /* U+3A37 */
  0x8759,   /* U+3A38 */
  0x875A,   /* U+3A39 */
  0x875B,   /* U+3A3A */
  0x860B,   /* U+3A3B */
  0x860C,   /* U+3A3C */
  0x875C,   /* U+3A3D */
  0x875D,   /* U+3A3E */
  0x875E,   /* U+3A3F */
  0x875F,   /* U+3A40 */
  0x8760,   /* U+3A41 */
  0x8761,   /* U+3A42 */
  0x8647,   /* U+3A43 */
  0x8648,   /* U+3A44 */
  0x8649,   /* U+3A45 */
  0x864A,   /* U+3A46 */
  0x864B,   /* U+3A47 */
  0x864C,   /* U+3A48 */
  0x864D,   /* U+3A49 */
  0x864E,   /* U+3A4A */
  0x864F,   /* U+3A4B */
  0x8650,   /* U+3A4C */
  0x8651,   /* U+3A4D */
  0x8652,   /* U+3A4E */
  0x8653,   /* U+3A4F */
  0x8654,   /* U+3A50 */
  0x8655,   /* U+3A51 */
  0x8499,   /* U+3A52 */
  0x8315,   /* U+3A53 */
  0x849A,   /* U+3A54 */
  0x849B,   /* U+3A55 */
  0x849C,   /* U+3A56 */
  0x849D,   /* U+3A57 */
  0x849E,   /* U+3A58 */
  0x849F,   /* U+3A59 */
  0x8329,   /* U+3A5A */
  0x832A,   /* U+3A5B */
  0x832B,   /* U+3A5C */
  0x832C,   /* U+3A5D */
  0x832D,   /* U+3A5E */
  0x832E,   /* U+3A5F */
  0x82BA,   /* U+3A60 */
  0x82BB,   /* U+3A61 */
  0x82BC,   /* U+3A62 */
  0x82BD,   /* U+3A63 */
  0x82BE,   /* U+3A64 */
  0x82BF,   /* U+3A65 */
  0x82C0,   /* U+3A66 */
  0x82C1,   /* U+3A67 */
  0x82C2,   /* U+3A68 */
  0x82C3,   /* U+3A69 */
  0x82C4,   /* U+3A6A */
  0x82C5,   /* U+3A6B */
  0x820A,   /* U+3A6C */
  0x820B,   /* U+3A6D */
  0x8157,   /* U+3A6E */
  0x8158,   /* U+3A6F */
  0x8159,   /* U+3A70 */
  0x8112,   /* U+3A71 */
  0x8113,   /* U+3A72 */
  0x8114,   /* U+3A73 */
  0x8115,   /* U+3A74 */
  0x8081,   /* U+3A75 */
  0x8082,   /* U+3A76 */
  0x8083,   /* U+3A77 */
  0x8037,   /* U+3A78 */
  0x8038,   /* U+3A79 */
  0x87EF,   /* U+3A7A */
  0x894E,   /* U+3A7B */
  0x894F,   /* U+3A7C */
  0x89ED,   /* U+3A7D */
  0x89B2,   /* U+3A7E */
  0x86F6,   /* U+3A7F */
  0x86F7,   /* U+3A80 */
  0x87FA,   /* U+3A81 */
  0x87FB,   /* U+3A82 */
  0x88A4,   /* U+3A83 */
  0x88A5,   /* U+3A84 */
  0x88A6,   /* U+3A85 */
  0x88A7,   /* U+3A86 */
  0x8960,   /* U+3A87 */
  0x8961,   /* U+3A88 */
  0x8962,   /* U+3A89 */
  0x8A03,   /* U+3A8A */
  0x8A04,   /* U+3A8B */
  0x8A05,   /* U+3A8C */
  0x8A06,   /* U+3A8D */
  0x8A07,   /* U+3A8E */
  0x89C9,   /* U+3A8F */
  0x89CA,   /* U+3A90 */
  0x89CB,   /* U+3A91 */
  0x89CC,   /* U+3A92 */
  0x89CD,   /* U+3A93 */
  0x89CE,   /* U+3A94 */
  0x89CF,   /* U+3A95 */
  0x89D0,   /* U+3A96 */
  0x89D1,   /* U+3A97 */
  0x89D2,   /* U+3A98 */
  0x89D3,   /* U+3A99 */
  0x89D4,   /* U+3A9A */
  0x882C,   /* U+3A9B */
  0x882D,   /* U+3A9C */
  0x882E,   /* U+3A9D */
  0x882F,   /* U+3A9E */
  0x8830,   /* U+3A9F */
  0x87FD,   /* U+3AA0 */
  0x87FE,   /* U+3AA1 */
  0x87FF,   /* U+3AA2 */
  0x8800,   /* U+3AA3 */
  0x86E8,   /* U+3AA4 */
  0x86E9,   /* U+3AA5 */
  0x86EA,   /* U+3AA6 */
  0x8514,   /* U+3AA7 */
  0x8515,   /* U+3AA8 */
  0x8516,   /* U+3AA9 */
  0x8517,   /* U+3AAA */
  0x8306,   /* U+3AAB */
  0x8307,   /* U+3AAC */
  0x8182,   /* U+3AAD */
  0x8130,   /* U+3AAE */
  0x8704,   /* U+3AAF */
  0x8996,   /* U+3AB0 */
  0x8868,   /* U+3AB1 */
  0x84A7,   /* U+3AB2 */
  0x84A8,   /* U+3AB3 */
  0x881E,   /* U+3AB4 */
  0x88D0,   /* U+3AB5 */
  0x899E,   /* U+3AB6 */
  0x8A47,   /* U+3AB7 */
  0x8A19,   /* U+3AB8 */
  0x8718,   /* U+3AB9 */
  0x8395,   /* U+3ABA */
  0x8098,   /* U+3ABB */
  0x88D6,   /* U+3ABC */
  0x88D7,   /* U+3ABD */
  0x89A5,   /* U+3ABE */
  0x89A6,   /* U+3ABF */
  0x8A23,   /* U+3AC0 */
  0x883A,   /* U+3AC1 */
  0x8720,   /* U+3AC2 */
  0x84AA,   /* U+3AC3 */
  0x8832,   /* U+3AC4 */
  0x89B2,   /* U+3AC5 */
  0x88E0,   /* U+3AC6 */
  0x89B3,   /* U+3AC7 */
  0x89B4,   /* U+3AC8 */
  0x89B5,   /* U+3AC9 */
  0x8A5C,   /* U+3ACA */
  0x8A5D,   /* U+3ACB */
  0x8A5E,   /* U+3ACC */
  0x8A36,   /* U+3ACD */
  0x8727,   /* U+3ACE */
  0x8728,   /* U+3ACF */
  0x84B9,   /* U+3AD0 */
  0x84BA,   /* U+3AD1 */
  0x8718,   /* U+3AD2 */
  0x8719,   /* U+3AD3 */
  0x871A,   /* U+3AD4 */
  0x871B,   /* U+3AD5 */
  0x871C,   /* U+3AD6 */
  0x871D,   /* U+3AD7 */
  0x885D,   /* U+3AD8 */
  0x885E,   /* U+3AD9 */
  0x885F,   /* U+3ADA */
  0x891B,   /* U+3ADB */
  0x891C,   /* U+3ADC */
  0x891D,   /* U+3ADD */
  0x891E,   /* U+3ADE */
  0x891F,   /* U+3ADF */
  0x8920,   /* U+3AE0 */
  0x8921,   /* U+3AE1 */
  0x8922,   /* U+3AE2 */
  0x8923,   /* U+3AE3 */
  0x8924,   /* U+3AE4 */
  0x89ED,   /* U+3AE5 */
  0x89EE,   /* U+3AE6 */
  0x89EF,   /* U+3AE7 */
  0x89F0,   /* U+3AE8 */
  0x89F1,   /* U+3AE9 */
  0x89F2,   /* U+3AEA */
  0x89F3,   /* U+3AEB */
  0x89F4,   /* U+3AEC */
  0x89F5,   /* U+3AED */
  0x89F6,   /* U+3AEE */
  0x8A85,   /* U+3AEF */
  0x8A86,   /* U+3AF0 */
  0x8A87,   /* U+3AF1 */
  0x8A88,   /* U+3AF2 */
  0x8A89,   /* U+3AF3 */
  0x8A8A,   /* U+3AF4 */
  0x8A6B,   /* U+3AF5 */
  0x8A6C,   /* U+3AF6 */
  0x8A6D,   /* U+3AF7 */
  0x8A6E,   /* U+3AF8 */
  0x8A6F,   /* U+3AF9 */
  0x8A70,   /* U+3AFA */
  0x8A71,   /* U+3AFB */
  0x8A72,   /* U+3AFC */
  0x8A73,   /* U+3AFD */
  0x8A74,   /* U+3AFE */
  0x8A75,   /* U+3AFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3A00 */
  0x0000,   /* U+3A01 */
  0x0000,   /* U+3A02 */
  0x0000,   /* U+3A03 */
  0x0000,   /* U+3A04 */
  0x0000,   /* U+3A05 */
  0x0000,   /* U+3A06 */
  0x0000,   /* U+3A07 */
  0x0000,   /* U+3A08 */
  0x0000,   /* U+3A09 */
  0x0000,   /* U+3A0A */
  0x0000,   /* U+3A0B */
  0x0000,   /* U+3A0C */
  0x0000,   /* U+3A0D */
  0x0000,   /* U+3A0E */
  0x0000,   /* U+3A0F */
  0x0000,   /* U+3A10 */
  0x0000,   /* U+3A11 */
  0x0000,   /* U+3A12 */
  0x0000,   /* U+3A13 */
  0x0000,   /* U+3A14 */
  0x0000,   /* U+3A15 */
  0x0000,   /* U+3A16 */
  0x0000,   /* U+3A17 */
  0x0000,   /* U+3A18 */
  0x0000,   /* U+3A19 */
  0x0000,   /* U+3A1A */
  0x0000,   /* U+3A1B */
  0x0000,   /* U+3A1C */
  0x0000,   /* U+3A1D */
  0x0000,   /* U+3A1E */
  0x0000,   /* U+3A1F */
  0x0000,   /* U+3A20 */
  0x0000,   /* U+3A21 */
  0x0000,   /* U+3A22 */
  0x0000,   /* U+3A23 */
  0x0000,   /* U+3A24 */
  0x0000,   /* U+3A25 */
  0x0000,   /* U+3A26 */
  0x0000,   /* U+3A27 */
  0x0000,   /* U+3A28 */
  0x0000,   /* U+3A29 */
  0x0000,   /* U+3A2A */
  0x0000,   /* U+3A2B */
  0x0000,   /* U+3A2C */
  0x0000,   /* U+3A2D */
  0x0000,   /* U+3A2E */
  0x0000,   /* U+3A2F */
  0x0000,   /* U+3A30 */
  0x0000,   /* U+3A31 */
  0x0000,   /* U+3A32 */
  0x0000,   /* U+3A33 */
  0x0000,   /* U+3A34 */
  0x0000,   /* U+3A35 */
  0x0000,   /* U+3A36 */
  0x0000,   /* U+3A37 */
  0x0000,   /* U+3A38 */
  0x0000,   /* U+3A39 */
  0x0000,   /* U+3A3A */
  0x0000,   /* U+3A3B */
  0x0000,   /* U+3A3C */
  0x0000,   /* U+3A3D */
  0x0000,   /* U+3A3E */
  0x0000,   /* U+3A3F */
  0x0000,   /* U+3A40 */
  0x0000,   /* U+3A41 */
  0x0000,   /* U+3A42 */
  0x0000,   /* U+3A43 */
  0x0000,   /* U+3A44 */
  0x0000,   /* U+3A45 */
  0x0000,   /* U+3A46 */
  0x0000,   /* U+3A47 */
  0x0000,   /* U+3A48 */
  0x0000,   /* U+3A49 */
  0x0000,   /* U+3A4A */
  0x0000,   /* U+3A4B */
  0x0000,   /* U+3A4C */
  0x0000,   /* U+3A4D */
  0x0000,   /* U+3A4E */
  0x0000,   /* U+3A4F */
  0x0000,   /* U+3A50 */
  0x0000,   /* U+3A51 */
  0x0000,   /* U+3A52 */
  0x0000,   /* U+3A53 */
  0x0000,   /* U+3A54 */
  0x0000,   /* U+3A55 */
  0x0000,   /* U+3A56 */
  0x0000,   /* U+3A57 */
  0x0000,   /* U+3A58 */
  0x0000,   /* U+3A59 */
  0x0000,   /* U+3A5A */
  0x0000,   /* U+3A5B */
  0x0000,   /* U+3A5C */
  0x0000,   /* U+3A5D */
  0x0000,   /* U+3A5E */
  0x0000,   /* U+3A5F */
  0x0000,   /* U+3A60 */
  0x0000,   /* U+3A61 */
  0x0000,   /* U+3A62 */
  0x0000,   /* U+3A63 */
  0x0000,   /* U+3A64 */
  0x0000,   /* U+3A65 */
  0x0000,   /* U+3A66 */
  0x0000,   /* U+3A67 */
  0x0000,   /* U+3A68 */
  0x0000,   /* U+3A69 */
  0x0000,   /* U+3A6A */
  0x0000,   /* U+3A6B */
  0x0000,   /* U+3A6C */
  0x0000,   /* U+3A6D */
  0x0000,   /* U+3A6E */
  0x0000,   /* U+3A6F */
  0x0000,   /* U+3A70 */
  0x0000,   /* U+3A71 */
  0x0000,   /* U+3A72 */
  0x0000,   /* U+3A73 */
  0x0000,   /* U+3A74 */
  0x0000,   /* U+3A75 */
  0x0000,   /* U+3A76 */
  0x0000,   /* U+3A77 */
  0x0000,   /* U+3A78 */
  0x0000,   /* U+3A79 */
  0x0000,   /* U+3A7A */
  0x0000,   /* U+3A7B */
  0x0000,   /* U+3A7C */
  0x0000,   /* U+3A7D */
  0x0000,   /* U+3A7E */
  0x0000,   /* U+3A7F */
  0x0000,   /* U+3A80 */
  0x0000,   /* U+3A81 */
  0x0000,   /* U+3A82 */
  0x0000,   /* U+3A83 */
  0x0000,   /* U+3A84 */
  0x0000,   /* U+3A85 */
  0x0000,   /* U+3A86 */
  0x0000,   /* U+3A87 */
  0x0000,   /* U+3A88 */
  0x0000,   /* U+3A89 */
  0x0000,   /* U+3A8A */
  0x0000,   /* U+3A8B */
  0x0000,   /* U+3A8C */
  0x0000,   /* U+3A8D */
  0x0000,   /* U+3A8E */
  0x0000,   /* U+3A8F */
  0x0000,   /* U+3A90 */
  0x0000,   /* U+3A91 */
  0x0000,   /* U+3A92 */
  0x0000,   /* U+3A93 */
  0x0000,   /* U+3A94 */
  0x0000,   /* U+3A95 */
  0x0000,   /* U+3A96 */
  0x0000,   /* U+3A97 */
  0x0000,   /* U+3A98 */
  0x0000,   /* U+3A99 */
  0x0000,   /* U+3A9A */
  0x0000,   /* U+3A9B */
  0x0000,   /* U+3A9C */
  0x0000,   /* U+3A9D */
  0x0000,   /* U+3A9E */
  0x0000,   /* U+3A9F */
  0x0000,   /* U+3AA0 */
  0x0000,   /* U+3AA1 */
  0x0000,   /* U+3AA2 */
  0x0000,   /* U+3AA3 */
  0x0000,   /* U+3AA4 */
  0x0000,   /* U+3AA5 */
  0x0000,   /* U+3AA6 */
  0x0000,   /* U+3AA7 */
  0x0000,   /* U+3AA8 */
  0x0000,   /* U+3AA9 */
  0x0000,   /* U+3AAA */
  0x0000,   /* U+3AAB */
  0x0000,   /* U+3AAC */
  0x0000,   /* U+3AAD */
  0x0000,   /* U+3AAE */
  0x0000,   /* U+3AAF */
  0x0000,   /* U+3AB0 */
  0x0000,   /* U+3AB1 */
  0x0000,   /* U+3AB2 */
  0x0000,   /* U+3AB3 */
  0x0000,   /* U+3AB4 */
  0x0000,   /* U+3AB5 */
  0x0000,   /* U+3AB6 */
  0x0000,   /* U+3AB7 */
  0x0000,   /* U+3AB8 */
  0x0000,   /* U+3AB9 */
  0x0000,   /* U+3ABA */
  0x0000,   /* U+3ABB */
  0x0000,   /* U+3ABC */
  0x0000,   /* U+3ABD */
  0x0000,   /* U+3ABE */
  0x0000,   /* U+3ABF */
  0x0000,   /* U+3AC0 */
  0x0000,   /* U+3AC1 */
  0x0000,   /* U+3AC2 */
  0x0000,   /* U+3AC3 */
  0x0000,   /* U+3AC4 */
  0x0000,   /* U+3AC5 */
  0x0000,   /* U+3AC6 */
  0x0000,   /* U+3AC7 */
  0x0000,   /* U+3AC8 */
  0x0000,   /* U+3AC9 */
  0x0000,   /* U+3ACA */
  0x0000,   /* U+3ACB */
  0x0000,   /* U+3ACC */
  0x0000,   /* U+3ACD */
  0x0000,   /* U+3ACE */
  0x0000,   /* U+3ACF */
  0x0000,   /* U+3AD0 */
  0x0000,   /* U+3AD1 */
  0x0000,   /* U+3AD2 */
  0x0000,   /* U+3AD3 */
  0x0000,   /* U+3AD4 */
  0x0000,   /* U+3AD5 */
  0x0000,   /* U+3AD6 */
  0x0000,   /* U+3AD7 */
  0x0000,   /* U+3AD8 */
  0x0000,   /* U+3AD9 */
  0x0000,   /* U+3ADA */
  0x0000,   /* U+3ADB */
  0x0000,   /* U+3ADC */
  0x0000,   /* U+3ADD */
  0x0000,   /* U+3ADE */
  0x0000,   /* U+3ADF */
  0x0000,   /* U+3AE0 */
  0x0000,   /* U+3AE1 */
  0x0000,   /* U+3AE2 */
  0x0000,   /* U+3AE3 */
  0x0000,   /* U+3AE4 */
  0x0000,   /* U+3AE5 */
  0x0000,   /* U+3AE6 */
  0x0000,   /* U+3AE7 */
  0x0000,   /* U+3AE8 */
  0x0000,   /* U+3AE9 */
  0x0000,   /* U+3AEA */
  0x0000,   /* U+3AEB */
  0x0000,   /* U+3AEC */
  0x0000,   /* U+3AED */
  0x0000,   /* U+3AEE */
  0x0000,   /* U+3AEF */
  0x0000,   /* U+3AF0 */
  0x0000,   /* U+3AF1 */
  0x0000,   /* U+3AF2 */
  0x0000,   /* U+3AF3 */
  0x0000,   /* U+3AF4 */
  0x0000,   /* U+3AF5 */
  0x0000,   /* U+3AF6 */
  0x0000,   /* U+3AF7 */
  0x0000,   /* U+3AF8 */
  0x0000,   /* U+3AF9 */
  0x0000,   /* U+3AFA */
  0x0000,   /* U+3AFB */
  0x0000,   /* U+3AFC */
  0x0000,   /* U+3AFD */
  0x0000,   /* U+3AFE */
  0x0000,   /* U+3AFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3A00 */
  0x0000,   /* U+3A01 */
  0x0000,   /* U+3A02 */
  0x0000,   /* U+3A03 */
  0x0000,   /* U+3A04 */
  0x0000,   /* U+3A05 */
  0x0000,   /* U+3A06 */
  0x0000,   /* U+3A07 */
  0x0000,   /* U+3A08 */
  0x0000,   /* U+3A09 */
  0x0000,   /* U+3A0A */
  0x0000,   /* U+3A0B */
  0x0000,   /* U+3A0C */
  0x0000,   /* U+3A0D */
  0x0000,   /* U+3A0E */
  0x0000,   /* U+3A0F */
  0x0000,   /* U+3A10 */
  0x0000,   /* U+3A11 */
  0x0000,   /* U+3A12 */
  0x0000,   /* U+3A13 */
  0x0000,   /* U+3A14 */
  0x0000,   /* U+3A15 */
  0x0000,   /* U+3A16 */
  0x0000,   /* U+3A17 */
  0x0000,   /* U+3A18 */
  0x0000,   /* U+3A19 */
  0x0000,   /* U+3A1A */
  0x0000,   /* U+3A1B */
  0x0000,   /* U+3A1C */
  0x0000,   /* U+3A1D */
  0x0000,   /* U+3A1E */
  0x0000,   /* U+3A1F */
  0x0000,   /* U+3A20 */
  0x0000,   /* U+3A21 */
  0x0000,   /* U+3A22 */
  0x0000,   /* U+3A23 */
  0x0000,   /* U+3A24 */
  0x0000,   /* U+3A25 */
  0x0000,   /* U+3A26 */
  0x0000,   /* U+3A27 */
  0x0000,   /* U+3A28 */
  0x0000,   /* U+3A29 */
  0x0000,   /* U+3A2A */
  0x0000,   /* U+3A2B */
  0x0000,   /* U+3A2C */
  0x0000,   /* U+3A2D */
  0x0000,   /* U+3A2E */
  0x0000,   /* U+3A2F */
  0x0000,   /* U+3A30 */
  0x0000,   /* U+3A31 */
  0x0000,   /* U+3A32 */
  0x0000,   /* U+3A33 */
  0x0000,   /* U+3A34 */
  0x0000,   /* U+3A35 */
  0x0000,   /* U+3A36 */
  0x0000,   /* U+3A37 */
  0x0000,   /* U+3A38 */
  0x0000,   /* U+3A39 */
  0x0000,   /* U+3A3A */
  0x0000,   /* U+3A3B */
  0x0000,   /* U+3A3C */
  0x0000,   /* U+3A3D */
  0x0000,   /* U+3A3E */
  0x0000,   /* U+3A3F */
  0x0000,   /* U+3A40 */
  0x0000,   /* U+3A41 */
  0x0000,   /* U+3A42 */
  0x0000,   /* U+3A43 */
  0x0000,   /* U+3A44 */
  0x0000,   /* U+3A45 */
  0x0000,   /* U+3A46 */
  0x0000,   /* U+3A47 */
  0x0000,   /* U+3A48 */
  0x0000,   /* U+3A49 */
  0x0000,   /* U+3A4A */
  0x0000,   /* U+3A4B */
  0x0000,   /* U+3A4C */
  0x0000,   /* U+3A4D */
  0x0000,   /* U+3A4E */
  0x0000,   /* U+3A4F */
  0x0000,   /* U+3A50 */
  0x0000,   /* U+3A51 */
  0x0000,   /* U+3A52 */
  0x0000,   /* U+3A53 */
  0x0000,   /* U+3A54 */
  0x0000,   /* U+3A55 */
  0x0000,   /* U+3A56 */
  0x0000,   /* U+3A57 */
  0x0000,   /* U+3A58 */
  0x0000,   /* U+3A59 */
  0x0000,   /* U+3A5A */
  0x0000,   /* U+3A5B */
  0x0000,   /* U+3A5C */
  0x0000,   /* U+3A5D */
  0x0000,   /* U+3A5E */
  0x0000,   /* U+3A5F */
  0x0000,   /* U+3A60 */
  0x0000,   /* U+3A61 */
  0x0000,   /* U+3A62 */
  0x0000,   /* U+3A63 */
  0x0000,   /* U+3A64 */
  0x0000,   /* U+3A65 */
  0x0000,   /* U+3A66 */
  0x0000,   /* U+3A67 */
  0x0000,   /* U+3A68 */
  0x0000,   /* U+3A69 */
  0x0000,   /* U+3A6A */
  0x0000,   /* U+3A6B */
  0x0000,   /* U+3A6C */
  0x0000,   /* U+3A6D */
  0x0000,   /* U+3A6E */
  0x0000,   /* U+3A6F */
  0x0000,   /* U+3A70 */
  0x0000,   /* U+3A71 */
  0x0000,   /* U+3A72 */
  0x0000,   /* U+3A73 */
  0x0000,   /* U+3A74 */
  0x0000,   /* U+3A75 */
  0x0000,   /* U+3A76 */
  0x0000,   /* U+3A77 */
  0x0000,   /* U+3A78 */
  0x0000,   /* U+3A79 */
  0x0000,   /* U+3A7A */
  0x0000,   /* U+3A7B */
  0x0000,   /* U+3A7C */
  0x0000,   /* U+3A7D */
  0x0000,   /* U+3A7E */
  0x0000,   /* U+3A7F */
  0x0000,   /* U+3A80 */
  0x0000,   /* U+3A81 */
  0x0000,   /* U+3A82 */
  0x0000,   /* U+3A83 */
  0x0000,   /* U+3A84 */
  0x0000,   /* U+3A85 */
  0x0000,   /* U+3A86 */
  0x0000,   /* U+3A87 */
  0x0000,   /* U+3A88 */
  0x0000,   /* U+3A89 */
  0x0000,   /* U+3A8A */
  0x0000,   /* U+3A8B */
  0x0000,   /* U+3A8C */
  0x0000,   /* U+3A8D */
  0x0000,   /* U+3A8E */
  0x0000,   /* U+3A8F */
  0x0000,   /* U+3A90 */
  0x0000,   /* U+3A91 */
  0x0000,   /* U+3A92 */
  0x0000,   /* U+3A93 */
  0x0000,   /* U+3A94 */
  0x0000,   /* U+3A95 */
  0x0000,   /* U+3A96 */
  0x0000,   /* U+3A97 */
  0x0000,   /* U+3A98 */
  0x0000,   /* U+3A99 */
  0x0000,   /* U+3A9A */
  0x0000,   /* U+3A9B */
  0x0000,   /* U+3A9C */
  0x0000,   /* U+3A9D */
  0x0000,   /* U+3A9E */
  0x0000,   /* U+3A9F */
  0x0000,   /* U+3AA0 */
  0x0000,   /* U+3AA1 */
  0x0000,   /* U+3AA2 */
  0x0000,   /* U+3AA3 */
  0x0000,   /* U+3AA4 */
  0x0000,   /* U+3AA5 */
  0x0000,   /* U+3AA6 */
  0x0000,   /* U+3AA7 */
  0x0000,   /* U+3AA8 */
  0x0000,   /* U+3AA9 */
  0x0000,   /* U+3AAA */
  0x0000,   /* U+3AAB */
  0x0000,   /* U+3AAC */
  0x0000,   /* U+3AAD */
  0x0000,   /* U+3AAE */
  0x0000,   /* U+3AAF */
  0x0000,   /* U+3AB0 */
  0x0000,   /* U+3AB1 */
  0x0000,   /* U+3AB2 */
  0x0000,   /* U+3AB3 */
  0x0000,   /* U+3AB4 */
  0x0000,   /* U+3AB5 */
  0x0000,   /* U+3AB6 */
  0x0000,   /* U+3AB7 */
  0x0000,   /* U+3AB8 */
  0x0000,   /* U+3AB9 */
  0x0000,   /* U+3ABA */
  0x0000,   /* U+3ABB */
  0x0000,   /* U+3ABC */
  0x0000,   /* U+3ABD */
  0x0000,   /* U+3ABE */
  0x0000,   /* U+3ABF */
  0x0000,   /* U+3AC0 */
  0x0000,   /* U+3AC1 */
  0x0000,   /* U+3AC2 */
  0x0000,   /* U+3AC3 */
  0x0000,   /* U+3AC4 */
  0x0000,   /* U+3AC5 */
  0x0000,   /* U+3AC6 */
  0x0000,   /* U+3AC7 */
  0x0000,   /* U+3AC8 */
  0x0000,   /* U+3AC9 */
  0x0000,   /* U+3ACA */
  0x0000,   /* U+3ACB */
  0x0000,   /* U+3ACC */
  0x0000,   /* U+3ACD */
  0x0000,   /* U+3ACE */
  0x0000,   /* U+3ACF */
  0x0000,   /* U+3AD0 */
  0x0000,   /* U+3AD1 */
  0x0000,   /* U+3AD2 */
  0x0000,   /* U+3AD3 */
  0x0000,   /* U+3AD4 */
  0x0000,   /* U+3AD5 */
  0x0000,   /* U+3AD6 */
  0x0000,   /* U+3AD7 */
  0x0000,   /* U+3AD8 */
  0x0000,   /* U+3AD9 */
  0x0000,   /* U+3ADA */
  0x0000,   /* U+3ADB */
  0x0000,   /* U+3ADC */
  0x0000,   /* U+3ADD */
  0x0000,   /* U+3ADE */
  0x0000,   /* U+3ADF */
  0x0000,   /* U+3AE0 */
  0x0000,   /* U+3AE1 */
  0x0000,   /* U+3AE2 */
  0x0000,   /* U+3AE3 */
  0x0000,   /* U+3AE4 */
  0x0000,   /* U+3AE5 */
  0x0000,   /* U+3AE6 */
  0x0000,   /* U+3AE7 */
  0x0000,   /* U+3AE8 */
  0x0000,   /* U+3AE9 */
  0x0000,   /* U+3AEA */
  0x0000,   /* U+3AEB */
  0x0000,   /* U+3AEC */
  0x0000,   /* U+3AED */
  0x0000,   /* U+3AEE */
  0x0000,   /* U+3AEF */
  0x0000,   /* U+3AF0 */
  0x0000,   /* U+3AF1 */
  0x0000,   /* U+3AF2 */
  0x0000,   /* U+3AF3 */
  0x0000,   /* U+3AF4 */
  0x0000,   /* U+3AF5 */
  0x0000,   /* U+3AF6 */
  0x0000,   /* U+3AF7 */
  0x0000,   /* U+3AF8 */
  0x0000,   /* U+3AF9 */
  0x0000,   /* U+3AFA */
  0x0000,   /* U+3AFB */
  0x0000,   /* U+3AFC */
  0x0000,   /* U+3AFD */
  0x0000,   /* U+3AFE */
  0x0000,   /* U+3AFF */
};

uint16 zh3_han_p03B[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C53,   /* U+3B00 */
  0x1C54,   /* U+3B01 */
  0x1C54,   /* U+3B02 */
  0x1C54,   /* U+3B03 */
  0x1C54,   /* U+3B04 */
  0x1C54,   /* U+3B05 */
  0x1C54,   /* U+3B06 */
  0x1C54,   /* U+3B07 */
  0x1C54,   /* U+3B08 */
  0x1C54,   /* U+3B09 */
  0x1C54,   /* U+3B0A */
  0x1C54,   /* U+3B0B */
  0x1C54,   /* U+3B0C */
  0x1C55,   /* U+3B0D */
  0x1C55,   /* U+3B0E */
  0x1C55,   /* U+3B0F */
  0x1C55,   /* U+3B10 */
  0x1C56,   /* U+3B11 */
  0x1C56,   /* U+3B12 */
  0x1C56,   /* U+3B13 */
  0x1C56,   /* U+3B14 */
  0x1C56,   /* U+3B15 */
  0x1C56,   /* U+3B16 */
  0x1C57,   /* U+3B17 */
  0x1C57,   /* U+3B18 */
  0x1C57,   /* U+3B19 */
  0x1C57,   /* U+3B1A */
  0x1C57,   /* U+3B1B */
  0x1C57,   /* U+3B1C */
  0x1C57,   /* U+3B1D */
  0x1C57,   /* U+3B1E */
  0x1C57,   /* U+3B1F */
  0x1C58,   /* U+3B20 */
  0x1C58,   /* U+3B21 */
  0x1C58,   /* U+3B22 */
  0x1C59,   /* U+3B23 */
  0x1C59,   /* U+3B24 */
  0x1C59,   /* U+3B25 */
  0x1C59,   /* U+3B26 */
  0x1C59,   /* U+3B27 */
  0x1C59,   /* U+3B28 */
  0x1C5A,   /* U+3B29 */
  0x1C5A,   /* U+3B2A */
  0x1C5B,   /* U+3B2B */
  0x1C5D,   /* U+3B2C */
  0x1C5D,   /* U+3B2D */
  0x1C5E,   /* U+3B2E */
  0x1C60,   /* U+3B2F */
  0x1C4D,   /* U+3B30 */
  0x1C57,   /* U+3B31 */
  0x1C58,   /* U+3B32 */
  0x1C4F,   /* U+3B33 */
  0x1C51,   /* U+3B34 */
  0x1C51,   /* U+3B35 */
  0x1C52,   /* U+3B36 */
  0x1C52,   /* U+3B37 */
  0x1C53,   /* U+3B38 */
  0x1C53,   /* U+3B39 */
  0x1C55,   /* U+3B3A */
  0x1C55,   /* U+3B3B */
  0x1C56,   /* U+3B3C */
  0x1C56,   /* U+3B3D */
  0x1C56,   /* U+3B3E */
  0x1C57,   /* U+3B3F */
  0x1C58,   /* U+3B40 */
  0x1C4D,   /* U+3B41 */
  0x1C4E,   /* U+3B42 */
  0x1C4E,   /* U+3B43 */
  0x1C4E,   /* U+3B44 */
  0x1C4E,   /* U+3B45 */
  0x1C4E,   /* U+3B46 */
  0x1C4F,   /* U+3B47 */
  0x1C4F,   /* U+3B48 */
  0x1C4F,   /* U+3B49 */
  0x1C4F,   /* U+3B4A */
  0x1C4F,   /* U+3B4B */
  0x1C4F,   /* U+3B4C */
  0x1C4F,   /* U+3B4D */
  0x1C4F,   /* U+3B4E */
  0x1C4F,   /* U+3B4F */
  0x1C4F,   /* U+3B50 */
  0x1C50,   /* U+3B51 */
  0x1C50,   /* U+3B52 */
  0x1C50,   /* U+3B53 */
  0x1C50,   /* U+3B54 */
  0x1C50,   /* U+3B55 */
  0x1C50,   /* U+3B56 */
  0x1C50,   /* U+3B57 */
  0x1C51,   /* U+3B58 */
  0x1C51,   /* U+3B59 */
  0x1C51,   /* U+3B5A */
  0x1C51,   /* U+3B5B */
  0x1C51,   /* U+3B5C */
  0x1C51,   /* U+3B5D */
  0x1C51,   /* U+3B5E */
  0x1C51,   /* U+3B5F */
  0x1C51,   /* U+3B60 */
  0x1C51,   /* U+3B61 */
  0x1C51,   /* U+3B62 */
  0x1C51,   /* U+3B63 */
  0x1C51,   /* U+3B64 */
  0x1C51,   /* U+3B65 */
  0x1C51,   /* U+3B66 */
  0x1C51,   /* U+3B67 */
  0x1C52,   /* U+3B68 */
  0x1C52,   /* U+3B69 */
  0x1C52,   /* U+3B6A */
  0x1C52,   /* U+3B6B */
  0x1C52,   /* U+3B6C */
  0x1C52,   /* U+3B6D */
  0x1C52,   /* U+3B6E */
  0x1C52,   /* U+3B6F */
  0x1C52,   /* U+3B70 */
  0x1C52,   /* U+3B71 */
  0x1C52,   /* U+3B72 */
  0x1C52,   /* U+3B73 */
  0x1C52,   /* U+3B74 */
  0x1C52,   /* U+3B75 */
  0x1C53,   /* U+3B76 */
  0x1C52,   /* U+3B77 */
  0x1C53,   /* U+3B78 */
  0x1C53,   /* U+3B79 */
  0x1C53,   /* U+3B7A */
  0x1C53,   /* U+3B7B */
  0x1C53,   /* U+3B7C */
  0x1C53,   /* U+3B7D */
  0x1C53,   /* U+3B7E */
  0x1C53,   /* U+3B7F */
  0x1C53,   /* U+3B80 */
  0x1C53,   /* U+3B81 */
  0x1C53,   /* U+3B82 */
  0x1C53,   /* U+3B83 */
  0x1C53,   /* U+3B84 */
  0x1C53,   /* U+3B85 */
  0x1C53,   /* U+3B86 */
  0x1C53,   /* U+3B87 */
  0x1C53,   /* U+3B88 */
  0x1C53,   /* U+3B89 */
  0x1C53,   /* U+3B8A */
  0x1C54,   /* U+3B8B */
  0x1C54,   /* U+3B8C */
  0x1C54,   /* U+3B8D */
  0x1C54,   /* U+3B8E */
  0x1C54,   /* U+3B8F */
  0x1C54,   /* U+3B90 */
  0x1C54,   /* U+3B91 */
  0x1C54,   /* U+3B92 */
  0x1C54,   /* U+3B93 */
  0x1C54,   /* U+3B94 */
  0x1C54,   /* U+3B95 */
  0x1C54,   /* U+3B96 */
  0x1C54,   /* U+3B97 */
  0x1C54,   /* U+3B98 */
  0x1C54,   /* U+3B99 */
  0x1C54,   /* U+3B9A */
  0x1C54,   /* U+3B9B */
  0x1C54,   /* U+3B9C */
  0x1C54,   /* U+3B9D */
  0x1C54,   /* U+3B9E */
  0x1C54,   /* U+3B9F */
  0x1C54,   /* U+3BA0 */
  0x1C54,   /* U+3BA1 */
  0x1C54,   /* U+3BA2 */
  0x1C54,   /* U+3BA3 */
  0x1C55,   /* U+3BA4 */
  0x1C55,   /* U+3BA5 */
  0x1C55,   /* U+3BA6 */
  0x1C55,   /* U+3BA7 */
  0x1C55,   /* U+3BA8 */
  0x1C55,   /* U+3BA9 */
  0x1C55,   /* U+3BAA */
  0x1C55,   /* U+3BAB */
  0x1C55,   /* U+3BAC */
  0x1C55,   /* U+3BAD */
  0x1C55,   /* U+3BAE */
  0x1C55,   /* U+3BAF */
  0x1C55,   /* U+3BB0 */
  0x1C55,   /* U+3BB1 */
  0x1C55,   /* U+3BB2 */
  0x1C55,   /* U+3BB3 */
  0x1C55,   /* U+3BB4 */
  0x1C55,   /* U+3BB5 */
  0x1C55,   /* U+3BB6 */
  0x1C55,   /* U+3BB7 */
  0x1C55,   /* U+3BB8 */
  0x1C55,   /* U+3BB9 */
  0x1C55,   /* U+3BBA */
  0x1C55,   /* U+3BBB */
  0x1C55,   /* U+3BBC */
  0x1C55,   /* U+3BBD */
  0x1C56,   /* U+3BBE */
  0x1C56,   /* U+3BBF */
  0x1C56,   /* U+3BC0 */
  0x1C56,   /* U+3BC1 */
  0x1C56,   /* U+3BC2 */
  0x1C56,   /* U+3BC3 */
  0x1C56,   /* U+3BC4 */
  0x1C56,   /* U+3BC5 */
  0x1C56,   /* U+3BC6 */
  0x1C56,   /* U+3BC7 */
  0x1C56,   /* U+3BC8 */
  0x1C56,   /* U+3BC9 */
  0x1C56,   /* U+3BCA */
  0x1C56,   /* U+3BCB */
  0x1C56,   /* U+3BCC */
  0x1C56,   /* U+3BCD */
  0x1C56,   /* U+3BCE */
  0x1C56,   /* U+3BCF */
  0x1C57,   /* U+3BD0 */
  0x1C56,   /* U+3BD1 */
  0x1C56,   /* U+3BD2 */
  0x1C57,   /* U+3BD3 */
  0x1C57,   /* U+3BD4 */
  0x1C57,   /* U+3BD5 */
  0x1C57,   /* U+3BD6 */
  0x1C57,   /* U+3BD7 */
  0x1C57,   /* U+3BD8 */
  0x1C57,   /* U+3BD9 */
  0x1C57,   /* U+3BDA */
  0x1C57,   /* U+3BDB */
  0x1C57,   /* U+3BDC */
  0x1C57,   /* U+3BDD */
  0x1C57,   /* U+3BDE */
  0x1C57,   /* U+3BDF */
  0x1C56,   /* U+3BE0 */
  0x1C57,   /* U+3BE1 */
  0x1C57,   /* U+3BE2 */
  0x1C57,   /* U+3BE3 */
  0x1C57,   /* U+3BE4 */
  0x1C57,   /* U+3BE5 */
  0x1C57,   /* U+3BE6 */
  0x1C57,   /* U+3BE7 */
  0x1C57,   /* U+3BE8 */
  0x1C57,   /* U+3BE9 */
  0x1C58,   /* U+3BEA */
  0x1C58,   /* U+3BEB */
  0x1C58,   /* U+3BEC */
  0x1C58,   /* U+3BED */
  0x1C58,   /* U+3BEE */
  0x1C58,   /* U+3BEF */
  0x1C58,   /* U+3BF0 */
  0x1C58,   /* U+3BF1 */
  0x1C58,   /* U+3BF2 */
  0x1C58,   /* U+3BF3 */
  0x1C58,   /* U+3BF4 */
  0x1C58,   /* U+3BF5 */
  0x1C58,   /* U+3BF6 */
  0x1C59,   /* U+3BF7 */
  0x1C59,   /* U+3BF8 */
  0x1C59,   /* U+3BF9 */
  0x1C59,   /* U+3BFA */
  0x1C59,   /* U+3BFB */
  0x1C59,   /* U+3BFC */
  0x1C59,   /* U+3BFD */
  0x1C5A,   /* U+3BFE */
  0x1C5A,   /* U+3BFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3B00 */
  0x0020,   /* U+3B01 */
  0x0020,   /* U+3B02 */
  0x0020,   /* U+3B03 */
  0x0020,   /* U+3B04 */
  0x0020,   /* U+3B05 */
  0x0020,   /* U+3B06 */
  0x0020,   /* U+3B07 */
  0x0020,   /* U+3B08 */
  0x0020,   /* U+3B09 */
  0x0020,   /* U+3B0A */
  0x0020,   /* U+3B0B */
  0x0020,   /* U+3B0C */
  0x0020,   /* U+3B0D */
  0x0020,   /* U+3B0E */
  0x0020,   /* U+3B0F */
  0x0020,   /* U+3B10 */
  0x0020,   /* U+3B11 */
  0x0020,   /* U+3B12 */
  0x0020,   /* U+3B13 */
  0x0020,   /* U+3B14 */
  0x0020,   /* U+3B15 */
  0x0020,   /* U+3B16 */
  0x0020,   /* U+3B17 */
  0x0020,   /* U+3B18 */
  0x0020,   /* U+3B19 */
  0x0020,   /* U+3B1A */
  0x0020,   /* U+3B1B */
  0x0020,   /* U+3B1C */
  0x0020,   /* U+3B1D */
  0x0020,   /* U+3B1E */
  0x0020,   /* U+3B1F */
  0x0020,   /* U+3B20 */
  0x0020,   /* U+3B21 */
  0x0020,   /* U+3B22 */
  0x0020,   /* U+3B23 */
  0x0020,   /* U+3B24 */
  0x0020,   /* U+3B25 */
  0x0020,   /* U+3B26 */
  0x0020,   /* U+3B27 */
  0x0020,   /* U+3B28 */
  0x0020,   /* U+3B29 */
  0x0020,   /* U+3B2A */
  0x0020,   /* U+3B2B */
  0x0020,   /* U+3B2C */
  0x0020,   /* U+3B2D */
  0x0020,   /* U+3B2E */
  0x0020,   /* U+3B2F */
  0x0020,   /* U+3B30 */
  0x0020,   /* U+3B31 */
  0x0020,   /* U+3B32 */
  0x0020,   /* U+3B33 */
  0x0020,   /* U+3B34 */
  0x0020,   /* U+3B35 */
  0x0020,   /* U+3B36 */
  0x0020,   /* U+3B37 */
  0x0020,   /* U+3B38 */
  0x0020,   /* U+3B39 */
  0x0020,   /* U+3B3A */
  0x0020,   /* U+3B3B */
  0x0020,   /* U+3B3C */
  0x0020,   /* U+3B3D */
  0x0020,   /* U+3B3E */
  0x0020,   /* U+3B3F */
  0x0020,   /* U+3B40 */
  0x0020,   /* U+3B41 */
  0x0020,   /* U+3B42 */
  0x0020,   /* U+3B43 */
  0x0020,   /* U+3B44 */
  0x0020,   /* U+3B45 */
  0x0020,   /* U+3B46 */
  0x0020,   /* U+3B47 */
  0x0020,   /* U+3B48 */
  0x0020,   /* U+3B49 */
  0x0020,   /* U+3B4A */
  0x0020,   /* U+3B4B */
  0x0020,   /* U+3B4C */
  0x0020,   /* U+3B4D */
  0x0020,   /* U+3B4E */
  0x0020,   /* U+3B4F */
  0x0020,   /* U+3B50 */
  0x0020,   /* U+3B51 */
  0x0020,   /* U+3B52 */
  0x0020,   /* U+3B53 */
  0x0020,   /* U+3B54 */
  0x0020,   /* U+3B55 */
  0x0020,   /* U+3B56 */
  0x0020,   /* U+3B57 */
  0x0020,   /* U+3B58 */
  0x0020,   /* U+3B59 */
  0x0020,   /* U+3B5A */
  0x0020,   /* U+3B5B */
  0x0020,   /* U+3B5C */
  0x0020,   /* U+3B5D */
  0x0020,   /* U+3B5E */
  0x0020,   /* U+3B5F */
  0x0020,   /* U+3B60 */
  0x0020,   /* U+3B61 */
  0x0020,   /* U+3B62 */
  0x0020,   /* U+3B63 */
  0x0020,   /* U+3B64 */
  0x0020,   /* U+3B65 */
  0x0020,   /* U+3B66 */
  0x0020,   /* U+3B67 */
  0x0020,   /* U+3B68 */
  0x0020,   /* U+3B69 */
  0x0020,   /* U+3B6A */
  0x0020,   /* U+3B6B */
  0x0020,   /* U+3B6C */
  0x0020,   /* U+3B6D */
  0x0020,   /* U+3B6E */
  0x0020,   /* U+3B6F */
  0x0020,   /* U+3B70 */
  0x0020,   /* U+3B71 */
  0x0020,   /* U+3B72 */
  0x0020,   /* U+3B73 */
  0x0020,   /* U+3B74 */
  0x0020,   /* U+3B75 */
  0x0020,   /* U+3B76 */
  0x0020,   /* U+3B77 */
  0x0020,   /* U+3B78 */
  0x0020,   /* U+3B79 */
  0x0020,   /* U+3B7A */
  0x0020,   /* U+3B7B */
  0x0020,   /* U+3B7C */
  0x0020,   /* U+3B7D */
  0x0020,   /* U+3B7E */
  0x0020,   /* U+3B7F */
  0x0020,   /* U+3B80 */
  0x0020,   /* U+3B81 */
  0x0020,   /* U+3B82 */
  0x0020,   /* U+3B83 */
  0x0020,   /* U+3B84 */
  0x0020,   /* U+3B85 */
  0x0020,   /* U+3B86 */
  0x0020,   /* U+3B87 */
  0x0020,   /* U+3B88 */
  0x0020,   /* U+3B89 */
  0x0020,   /* U+3B8A */
  0x0020,   /* U+3B8B */
  0x0020,   /* U+3B8C */
  0x0020,   /* U+3B8D */
  0x0020,   /* U+3B8E */
  0x0020,   /* U+3B8F */
  0x0020,   /* U+3B90 */
  0x0020,   /* U+3B91 */
  0x0020,   /* U+3B92 */
  0x0020,   /* U+3B93 */
  0x0020,   /* U+3B94 */
  0x0020,   /* U+3B95 */
  0x0020,   /* U+3B96 */
  0x0020,   /* U+3B97 */
  0x0020,   /* U+3B98 */
  0x0020,   /* U+3B99 */
  0x0020,   /* U+3B9A */
  0x0020,   /* U+3B9B */
  0x0020,   /* U+3B9C */
  0x0020,   /* U+3B9D */
  0x0020,   /* U+3B9E */
  0x0020,   /* U+3B9F */
  0x0020,   /* U+3BA0 */
  0x0020,   /* U+3BA1 */
  0x0020,   /* U+3BA2 */
  0x0020,   /* U+3BA3 */
  0x0020,   /* U+3BA4 */
  0x0020,   /* U+3BA5 */
  0x0020,   /* U+3BA6 */
  0x0020,   /* U+3BA7 */
  0x0020,   /* U+3BA8 */
  0x0020,   /* U+3BA9 */
  0x0020,   /* U+3BAA */
  0x0020,   /* U+3BAB */
  0x0020,   /* U+3BAC */
  0x0020,   /* U+3BAD */
  0x0020,   /* U+3BAE */
  0x0020,   /* U+3BAF */
  0x0020,   /* U+3BB0 */
  0x0020,   /* U+3BB1 */
  0x0020,   /* U+3BB2 */
  0x0020,   /* U+3BB3 */
  0x0020,   /* U+3BB4 */
  0x0020,   /* U+3BB5 */
  0x0020,   /* U+3BB6 */
  0x0020,   /* U+3BB7 */
  0x0020,   /* U+3BB8 */
  0x0020,   /* U+3BB9 */
  0x0020,   /* U+3BBA */
  0x0020,   /* U+3BBB */
  0x0020,   /* U+3BBC */
  0x0020,   /* U+3BBD */
  0x0020,   /* U+3BBE */
  0x0020,   /* U+3BBF */
  0x0020,   /* U+3BC0 */
  0x0020,   /* U+3BC1 */
  0x0020,   /* U+3BC2 */
  0x0020,   /* U+3BC3 */
  0x0020,   /* U+3BC4 */
  0x0020,   /* U+3BC5 */
  0x0020,   /* U+3BC6 */
  0x0020,   /* U+3BC7 */
  0x0020,   /* U+3BC8 */
  0x0020,   /* U+3BC9 */
  0x0020,   /* U+3BCA */
  0x0020,   /* U+3BCB */
  0x0020,   /* U+3BCC */
  0x0020,   /* U+3BCD */
  0x0020,   /* U+3BCE */
  0x0020,   /* U+3BCF */
  0x0020,   /* U+3BD0 */
  0x0020,   /* U+3BD1 */
  0x0020,   /* U+3BD2 */
  0x0020,   /* U+3BD3 */
  0x0020,   /* U+3BD4 */
  0x0020,   /* U+3BD5 */
  0x0020,   /* U+3BD6 */
  0x0020,   /* U+3BD7 */
  0x0020,   /* U+3BD8 */
  0x0020,   /* U+3BD9 */
  0x0020,   /* U+3BDA */
  0x0020,   /* U+3BDB */
  0x0020,   /* U+3BDC */
  0x0020,   /* U+3BDD */
  0x0020,   /* U+3BDE */
  0x0020,   /* U+3BDF */
  0x0020,   /* U+3BE0 */
  0x0020,   /* U+3BE1 */
  0x0020,   /* U+3BE2 */
  0x0020,   /* U+3BE3 */
  0x0020,   /* U+3BE4 */
  0x0020,   /* U+3BE5 */
  0x0020,   /* U+3BE6 */
  0x0020,   /* U+3BE7 */
  0x0020,   /* U+3BE8 */
  0x0020,   /* U+3BE9 */
  0x0020,   /* U+3BEA */
  0x0020,   /* U+3BEB */
  0x0020,   /* U+3BEC */
  0x0020,   /* U+3BED */
  0x0020,   /* U+3BEE */
  0x0020,   /* U+3BEF */
  0x0020,   /* U+3BF0 */
  0x0020,   /* U+3BF1 */
  0x0020,   /* U+3BF2 */
  0x0020,   /* U+3BF3 */
  0x0020,   /* U+3BF4 */
  0x0020,   /* U+3BF5 */
  0x0020,   /* U+3BF6 */
  0x0020,   /* U+3BF7 */
  0x0020,   /* U+3BF8 */
  0x0020,   /* U+3BF9 */
  0x0020,   /* U+3BFA */
  0x0020,   /* U+3BFB */
  0x0020,   /* U+3BFC */
  0x0020,   /* U+3BFD */
  0x0020,   /* U+3BFE */
  0x0020,   /* U+3BFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3B00 */
  0x0002,   /* U+3B01 */
  0x0002,   /* U+3B02 */
  0x0002,   /* U+3B03 */
  0x0002,   /* U+3B04 */
  0x0002,   /* U+3B05 */
  0x0002,   /* U+3B06 */
  0x0002,   /* U+3B07 */
  0x0002,   /* U+3B08 */
  0x0002,   /* U+3B09 */
  0x0002,   /* U+3B0A */
  0x0002,   /* U+3B0B */
  0x0002,   /* U+3B0C */
  0x0002,   /* U+3B0D */
  0x0002,   /* U+3B0E */
  0x0002,   /* U+3B0F */
  0x0002,   /* U+3B10 */
  0x0002,   /* U+3B11 */
  0x0002,   /* U+3B12 */
  0x0002,   /* U+3B13 */
  0x0002,   /* U+3B14 */
  0x0002,   /* U+3B15 */
  0x0002,   /* U+3B16 */
  0x0002,   /* U+3B17 */
  0x0002,   /* U+3B18 */
  0x0002,   /* U+3B19 */
  0x0002,   /* U+3B1A */
  0x0002,   /* U+3B1B */
  0x0002,   /* U+3B1C */
  0x0002,   /* U+3B1D */
  0x0002,   /* U+3B1E */
  0x0002,   /* U+3B1F */
  0x0002,   /* U+3B20 */
  0x0002,   /* U+3B21 */
  0x0002,   /* U+3B22 */
  0x0002,   /* U+3B23 */
  0x0002,   /* U+3B24 */
  0x0002,   /* U+3B25 */
  0x0002,   /* U+3B26 */
  0x0002,   /* U+3B27 */
  0x0002,   /* U+3B28 */
  0x0002,   /* U+3B29 */
  0x0002,   /* U+3B2A */
  0x0002,   /* U+3B2B */
  0x0002,   /* U+3B2C */
  0x0002,   /* U+3B2D */
  0x0002,   /* U+3B2E */
  0x0002,   /* U+3B2F */
  0x0002,   /* U+3B30 */
  0x0002,   /* U+3B31 */
  0x0002,   /* U+3B32 */
  0x0002,   /* U+3B33 */
  0x0002,   /* U+3B34 */
  0x0002,   /* U+3B35 */
  0x0002,   /* U+3B36 */
  0x0002,   /* U+3B37 */
  0x0002,   /* U+3B38 */
  0x0002,   /* U+3B39 */
  0x0002,   /* U+3B3A */
  0x0002,   /* U+3B3B */
  0x0002,   /* U+3B3C */
  0x0002,   /* U+3B3D */
  0x0002,   /* U+3B3E */
  0x0002,   /* U+3B3F */
  0x0002,   /* U+3B40 */
  0x0002,   /* U+3B41 */
  0x0002,   /* U+3B42 */
  0x0002,   /* U+3B43 */
  0x0002,   /* U+3B44 */
  0x0002,   /* U+3B45 */
  0x0002,   /* U+3B46 */
  0x0002,   /* U+3B47 */
  0x0002,   /* U+3B48 */
  0x0002,   /* U+3B49 */
  0x0002,   /* U+3B4A */
  0x0002,   /* U+3B4B */
  0x0002,   /* U+3B4C */
  0x0002,   /* U+3B4D */
  0x0002,   /* U+3B4E */
  0x0002,   /* U+3B4F */
  0x0002,   /* U+3B50 */
  0x0002,   /* U+3B51 */
  0x0002,   /* U+3B52 */
  0x0002,   /* U+3B53 */
  0x0002,   /* U+3B54 */
  0x0002,   /* U+3B55 */
  0x0002,   /* U+3B56 */
  0x0002,   /* U+3B57 */
  0x0002,   /* U+3B58 */
  0x0002,   /* U+3B59 */
  0x0002,   /* U+3B5A */
  0x0002,   /* U+3B5B */
  0x0002,   /* U+3B5C */
  0x0002,   /* U+3B5D */
  0x0002,   /* U+3B5E */
  0x0002,   /* U+3B5F */
  0x0002,   /* U+3B60 */
  0x0002,   /* U+3B61 */
  0x0002,   /* U+3B62 */
  0x0002,   /* U+3B63 */
  0x0002,   /* U+3B64 */
  0x0002,   /* U+3B65 */
  0x0002,   /* U+3B66 */
  0x0002,   /* U+3B67 */
  0x0002,   /* U+3B68 */
  0x0002,   /* U+3B69 */
  0x0002,   /* U+3B6A */
  0x0002,   /* U+3B6B */
  0x0002,   /* U+3B6C */
  0x0002,   /* U+3B6D */
  0x0002,   /* U+3B6E */
  0x0002,   /* U+3B6F */
  0x0002,   /* U+3B70 */
  0x0002,   /* U+3B71 */
  0x0002,   /* U+3B72 */
  0x0002,   /* U+3B73 */
  0x0002,   /* U+3B74 */
  0x0002,   /* U+3B75 */
  0x0002,   /* U+3B76 */
  0x0002,   /* U+3B77 */
  0x0002,   /* U+3B78 */
  0x0002,   /* U+3B79 */
  0x0002,   /* U+3B7A */
  0x0002,   /* U+3B7B */
  0x0002,   /* U+3B7C */
  0x0002,   /* U+3B7D */
  0x0002,   /* U+3B7E */
  0x0002,   /* U+3B7F */
  0x0002,   /* U+3B80 */
  0x0002,   /* U+3B81 */
  0x0002,   /* U+3B82 */
  0x0002,   /* U+3B83 */
  0x0002,   /* U+3B84 */
  0x0002,   /* U+3B85 */
  0x0002,   /* U+3B86 */
  0x0002,   /* U+3B87 */
  0x0002,   /* U+3B88 */
  0x0002,   /* U+3B89 */
  0x0002,   /* U+3B8A */
  0x0002,   /* U+3B8B */
  0x0002,   /* U+3B8C */
  0x0002,   /* U+3B8D */
  0x0002,   /* U+3B8E */
  0x0002,   /* U+3B8F */
  0x0002,   /* U+3B90 */
  0x0002,   /* U+3B91 */
  0x0002,   /* U+3B92 */
  0x0002,   /* U+3B93 */
  0x0002,   /* U+3B94 */
  0x0002,   /* U+3B95 */
  0x0002,   /* U+3B96 */
  0x0002,   /* U+3B97 */
  0x0002,   /* U+3B98 */
  0x0002,   /* U+3B99 */
  0x0002,   /* U+3B9A */
  0x0002,   /* U+3B9B */
  0x0002,   /* U+3B9C */
  0x0002,   /* U+3B9D */
  0x0002,   /* U+3B9E */
  0x0002,   /* U+3B9F */
  0x0002,   /* U+3BA0 */
  0x0002,   /* U+3BA1 */
  0x0002,   /* U+3BA2 */
  0x0002,   /* U+3BA3 */
  0x0002,   /* U+3BA4 */
  0x0002,   /* U+3BA5 */
  0x0002,   /* U+3BA6 */
  0x0002,   /* U+3BA7 */
  0x0002,   /* U+3BA8 */
  0x0002,   /* U+3BA9 */
  0x0002,   /* U+3BAA */
  0x0002,   /* U+3BAB */
  0x0002,   /* U+3BAC */
  0x0002,   /* U+3BAD */
  0x0002,   /* U+3BAE */
  0x0002,   /* U+3BAF */
  0x0002,   /* U+3BB0 */
  0x0002,   /* U+3BB1 */
  0x0002,   /* U+3BB2 */
  0x0002,   /* U+3BB3 */
  0x0002,   /* U+3BB4 */
  0x0002,   /* U+3BB5 */
  0x0002,   /* U+3BB6 */
  0x0002,   /* U+3BB7 */
  0x0002,   /* U+3BB8 */
  0x0002,   /* U+3BB9 */
  0x0002,   /* U+3BBA */
  0x0002,   /* U+3BBB */
  0x0002,   /* U+3BBC */
  0x0002,   /* U+3BBD */
  0x0002,   /* U+3BBE */
  0x0002,   /* U+3BBF */
  0x0002,   /* U+3BC0 */
  0x0002,   /* U+3BC1 */
  0x0002,   /* U+3BC2 */
  0x0002,   /* U+3BC3 */
  0x0002,   /* U+3BC4 */
  0x0002,   /* U+3BC5 */
  0x0002,   /* U+3BC6 */
  0x0002,   /* U+3BC7 */
  0x0002,   /* U+3BC8 */
  0x0002,   /* U+3BC9 */
  0x0002,   /* U+3BCA */
  0x0002,   /* U+3BCB */
  0x0002,   /* U+3BCC */
  0x0002,   /* U+3BCD */
  0x0002,   /* U+3BCE */
  0x0002,   /* U+3BCF */
  0x0002,   /* U+3BD0 */
  0x0002,   /* U+3BD1 */
  0x0002,   /* U+3BD2 */
  0x0002,   /* U+3BD3 */
  0x0002,   /* U+3BD4 */
  0x0002,   /* U+3BD5 */
  0x0002,   /* U+3BD6 */
  0x0002,   /* U+3BD7 */
  0x0002,   /* U+3BD8 */
  0x0002,   /* U+3BD9 */
  0x0002,   /* U+3BDA */
  0x0002,   /* U+3BDB */
  0x0002,   /* U+3BDC */
  0x0002,   /* U+3BDD */
  0x0002,   /* U+3BDE */
  0x0002,   /* U+3BDF */
  0x0002,   /* U+3BE0 */
  0x0002,   /* U+3BE1 */
  0x0002,   /* U+3BE2 */
  0x0002,   /* U+3BE3 */
  0x0002,   /* U+3BE4 */
  0x0002,   /* U+3BE5 */
  0x0002,   /* U+3BE6 */
  0x0002,   /* U+3BE7 */
  0x0002,   /* U+3BE8 */
  0x0002,   /* U+3BE9 */
  0x0002,   /* U+3BEA */
  0x0002,   /* U+3BEB */
  0x0002,   /* U+3BEC */
  0x0002,   /* U+3BED */
  0x0002,   /* U+3BEE */
  0x0002,   /* U+3BEF */
  0x0002,   /* U+3BF0 */
  0x0002,   /* U+3BF1 */
  0x0002,   /* U+3BF2 */
  0x0002,   /* U+3BF3 */
  0x0002,   /* U+3BF4 */
  0x0002,   /* U+3BF5 */
  0x0002,   /* U+3BF6 */
  0x0002,   /* U+3BF7 */
  0x0002,   /* U+3BF8 */
  0x0002,   /* U+3BF9 */
  0x0002,   /* U+3BFA */
  0x0002,   /* U+3BFB */
  0x0002,   /* U+3BFC */
  0x0002,   /* U+3BFD */
  0x0002,   /* U+3BFE */
  0x0002,   /* U+3BFF */

  /* Primary weight 2 for each character. */
  0x8A76,   /* U+3B00 */
  0x88AB,   /* U+3B01 */
  0x88AC,   /* U+3B02 */
  0x88AD,   /* U+3B03 */
  0x88AE,   /* U+3B04 */
  0x88AF,   /* U+3B05 */
  0x88B0,   /* U+3B06 */
  0x88B1,   /* U+3B07 */
  0x88B2,   /* U+3B08 */
  0x88B3,   /* U+3B09 */
  0x88B4,   /* U+3B0A */
  0x88B5,   /* U+3B0B */
  0x88B6,   /* U+3B0C */
  0x8860,   /* U+3B0D */
  0x8861,   /* U+3B0E */
  0x8862,   /* U+3B0F */
  0x8863,   /* U+3B10 */
  0x8745,   /* U+3B11 */
  0x8746,   /* U+3B12 */
  0x8747,   /* U+3B13 */
  0x8748,   /* U+3B14 */
  0x8749,   /* U+3B15 */
  0x874A,   /* U+3B16 */
  0x857A,   /* U+3B17 */
  0x857B,   /* U+3B18 */
  0x857C,   /* U+3B19 */
  0x857D,   /* U+3B1A */
  0x857E,   /* U+3B1B */
  0x857F,   /* U+3B1C */
  0x8580,   /* U+3B1D */
  0x8581,   /* U+3B1E */
  0x8582,   /* U+3B1F */
  0x83AF,   /* U+3B20 */
  0x83B0,   /* U+3B21 */
  0x83B1,   /* U+3B22 */
  0x8337,   /* U+3B23 */
  0x8338,   /* U+3B24 */
  0x8339,   /* U+3B25 */
  0x833A,   /* U+3B26 */
  0x833B,   /* U+3B27 */
  0x833C,   /* U+3B28 */
  0x8269,   /* U+3B29 */
  0x826A,   /* U+3B2A */
  0x81A5,   /* U+3B2B */
  0x80FE,   /* U+3B2C */
  0x80FF,   /* U+3B2D */
  0x809D,   /* U+3B2E */
  0x8044,   /* U+3B2F */
  0x84CA,   /* U+3B30 */
  0x85D4,   /* U+3B31 */
  0x83D9,   /* U+3B32 */
  0x88A3,   /* U+3B33 */
  0x8A61,   /* U+3B34 */
  0x8A62,   /* U+3B35 */
  0x8AEA,   /* U+3B36 */
  0x8AEB,   /* U+3B37 */
  0x8AF1,   /* U+3B38 */
  0x95D7,   /* U+3B39 */
  0x88BC,   /* U+3B3A */
  0x88BD,   /* U+3B3B */
  0x879D,   /* U+3B3C */
  0x879E,   /* U+3B3D */
  0x879F,   /* U+3B3E */
  0x85DD,   /* U+3B3F */
  0x83DD,   /* U+3B40 */
  0x84E5,   /* U+3B41 */
  0x8774,   /* U+3B42 */
  0x8775,   /* U+3B43 */
  0x8776,   /* U+3B44 */
  0x8777,   /* U+3B45 */
  0x8778,   /* U+3B46 */
  0x88F9,   /* U+3B47 */
  0x88FA,   /* U+3B48 */
  0x88FB,   /* U+3B49 */
  0x88FC,   /* U+3B4A */
  0x88FD,   /* U+3B4B */
  0x88FE,   /* U+3B4C */
  0x88FF,   /* U+3B4D */
  0x8900,   /* U+3B4E */
  0x8901,   /* U+3B4F */
  0x8902,   /* U+3B50 */
  0x89DD,   /* U+3B51 */
  0x89DE,   /* U+3B52 */
  0x89DF,   /* U+3B53 */
  0x89E0,   /* U+3B54 */
  0x89E1,   /* U+3B55 */
  0x89E2,   /* U+3B56 */
  0x89E3,   /* U+3B57 */
  0x8ACB,   /* U+3B58 */
  0x8ACC,   /* U+3B59 */
  0x8ACD,   /* U+3B5A */
  0x8ACE,   /* U+3B5B */
  0x8ACF,   /* U+3B5C */
  0x8AD0,   /* U+3B5D */
  0x8AD1,   /* U+3B5E */
  0x8AD2,   /* U+3B5F */
  0x8AD3,   /* U+3B60 */
  0x8AD4,   /* U+3B61 */
  0x8AD5,   /* U+3B62 */
  0x8AD6,   /* U+3B63 */
  0x8AD7,   /* U+3B64 */
  0x8AD8,   /* U+3B65 */
  0x8AD9,   /* U+3B66 */
  0x8ADA,   /* U+3B67 */
  0x8B55,   /* U+3B68 */
  0x8B56,   /* U+3B69 */
  0x8B57,   /* U+3B6A */
  0x8B58,   /* U+3B6B */
  0x8B59,   /* U+3B6C */
  0x8B5A,   /* U+3B6D */
  0x8B5B,   /* U+3B6E */
  0x8B5C,   /* U+3B6F */
  0x8B5D,   /* U+3B70 */
  0x8B5E,   /* U+3B71 */
  0x8B5F,   /* U+3B72 */
  0x8B60,   /* U+3B73 */
  0x8B61,   /* U+3B74 */
  0x8B62,   /* U+3B75 */
  0x8B7B,   /* U+3B76 */
  0x8B63,   /* U+3B77 */
  0x8B7C,   /* U+3B78 */
  0x8B7D,   /* U+3B79 */
  0x8B7E,   /* U+3B7A */
  0x8B7F,   /* U+3B7B */
  0x8B80,   /* U+3B7C */
  0x8B81,   /* U+3B7D */
  0x8B82,   /* U+3B7E */
  0x8B83,   /* U+3B7F */
  0x8B84,   /* U+3B80 */
  0x8B85,   /* U+3B81 */
  0x8B86,   /* U+3B82 */
  0x8B87,   /* U+3B83 */
  0x8B88,   /* U+3B84 */
  0x8B89,   /* U+3B85 */
  0x8B8A,   /* U+3B86 */
  0x8B8B,   /* U+3B87 */
  0x8B8C,   /* U+3B88 */
  0x8B8D,   /* U+3B89 */
  0x8B8E,   /* U+3B8A */
  0x898E,   /* U+3B8B */
  0x898F,   /* U+3B8C */
  0x8990,   /* U+3B8D */
  0x8991,   /* U+3B8E */
  0x8992,   /* U+3B8F */
  0x8993,   /* U+3B90 */
  0x8994,   /* U+3B91 */
  0x8995,   /* U+3B92 */
  0x8996,   /* U+3B93 */
  0x8997,   /* U+3B94 */
  0x8998,   /* U+3B95 */
  0x8999,   /* U+3B96 */
  0x899A,   /* U+3B97 */
  0x899B,   /* U+3B98 */
  0x899C,   /* U+3B99 */
  0x899D,   /* U+3B9A */
  0x899E,   /* U+3B9B */
  0x899F,   /* U+3B9C */
  0x89A0,   /* U+3B9D */
  0x89A1,   /* U+3B9E */
  0x89A2,   /* U+3B9F */
  0x89A3,   /* U+3BA0 */
  0x8C9F,   /* U+3BA1 */
  0x89A4,   /* U+3BA2 */
  0x89A5,   /* U+3BA3 */
  0x8926,   /* U+3BA4 */
  0x8927,   /* U+3BA5 */
  0x8928,   /* U+3BA6 */
  0x8929,   /* U+3BA7 */
  0x892A,   /* U+3BA8 */
  0x892B,   /* U+3BA9 */
  0x892C,   /* U+3BAA */
  0x892D,   /* U+3BAB */
  0x892E,   /* U+3BAC */
  0x892F,   /* U+3BAD */
  0x8930,   /* U+3BAE */
  0x8931,   /* U+3BAF */
  0x8932,   /* U+3BB0 */
  0x8933,   /* U+3BB1 */
  0x8934,   /* U+3BB2 */
  0x8935,   /* U+3BB3 */
  0x8936,   /* U+3BB4 */
  0x8937,   /* U+3BB5 */
  0x8938,   /* U+3BB6 */
  0x8939,   /* U+3BB7 */
  0x893A,   /* U+3BB8 */
  0x893B,   /* U+3BB9 */
  0x893C,   /* U+3BBA */
  0x893D,   /* U+3BBB */
  0x893E,   /* U+3BBC */
  0x893F,   /* U+3BBD */
  0x87FE,   /* U+3BBE */
  0x87FF,   /* U+3BBF */
  0x8800,   /* U+3BC0 */
  0x8801,   /* U+3BC1 */
  0x8802,   /* U+3BC2 */
  0x8803,   /* U+3BC3 */
  0x8804,   /* U+3BC4 */
  0x8805,   /* U+3BC5 */
  0x8806,   /* U+3BC6 */
  0x8807,   /* U+3BC7 */
  0x8808,   /* U+3BC8 */
  0x8809,   /* U+3BC9 */
  0x880A,   /* U+3BCA */
  0x880B,   /* U+3BCB */
  0x880C,   /* U+3BCC */
  0x880D,   /* U+3BCD */
  0x880E,   /* U+3BCE */
  0x880F,   /* U+3BCF */
  0x863A,   /* U+3BD0 */
  0x8810,   /* U+3BD1 */
  0x8811,   /* U+3BD2 */
  0x863B,   /* U+3BD3 */
  0x863C,   /* U+3BD4 */
  0x863D,   /* U+3BD5 */
  0x863E,   /* U+3BD6 */
  0x863F,   /* U+3BD7 */
  0x8640,   /* U+3BD8 */
  0x8641,   /* U+3BD9 */
  0x8642,   /* U+3BDA */
  0x8643,   /* U+3BDB */
  0x8644,   /* U+3BDC */
  0x8645,   /* U+3BDD */
  0x8646,   /* U+3BDE */
  0x8647,   /* U+3BDF */
  0x8812,   /* U+3BE0 */
  0x8648,   /* U+3BE1 */
  0x8649,   /* U+3BE2 */
  0x864A,   /* U+3BE3 */
  0x864B,   /* U+3BE4 */
  0x864C,   /* U+3BE5 */
  0x864D,   /* U+3BE6 */
  0x864E,   /* U+3BE7 */
  0x864F,   /* U+3BE8 */
  0x8650,   /* U+3BE9 */
  0x841C,   /* U+3BEA */
  0x841D,   /* U+3BEB */
  0x841E,   /* U+3BEC */
  0x841F,   /* U+3BED */
  0x8420,   /* U+3BEE */
  0x8421,   /* U+3BEF */
  0x8422,   /* U+3BF0 */
  0x8423,   /* U+3BF1 */
  0x8424,   /* U+3BF2 */
  0x8425,   /* U+3BF3 */
  0x8426,   /* U+3BF4 */
  0x8427,   /* U+3BF5 */
  0x8428,   /* U+3BF6 */
  0x8399,   /* U+3BF7 */
  0x839A,   /* U+3BF8 */
  0x839B,   /* U+3BF9 */
  0x839C,   /* U+3BFA */
  0x839D,   /* U+3BFB */
  0x839E,   /* U+3BFC */
  0x839F,   /* U+3BFD */
  0x82A0,   /* U+3BFE */
  0x82A1,   /* U+3BFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3B00 */
  0x0000,   /* U+3B01 */
  0x0000,   /* U+3B02 */
  0x0000,   /* U+3B03 */
  0x0000,   /* U+3B04 */
  0x0000,   /* U+3B05 */
  0x0000,   /* U+3B06 */
  0x0000,   /* U+3B07 */
  0x0000,   /* U+3B08 */
  0x0000,   /* U+3B09 */
  0x0000,   /* U+3B0A */
  0x0000,   /* U+3B0B */
  0x0000,   /* U+3B0C */
  0x0000,   /* U+3B0D */
  0x0000,   /* U+3B0E */
  0x0000,   /* U+3B0F */
  0x0000,   /* U+3B10 */
  0x0000,   /* U+3B11 */
  0x0000,   /* U+3B12 */
  0x0000,   /* U+3B13 */
  0x0000,   /* U+3B14 */
  0x0000,   /* U+3B15 */
  0x0000,   /* U+3B16 */
  0x0000,   /* U+3B17 */
  0x0000,   /* U+3B18 */
  0x0000,   /* U+3B19 */
  0x0000,   /* U+3B1A */
  0x0000,   /* U+3B1B */
  0x0000,   /* U+3B1C */
  0x0000,   /* U+3B1D */
  0x0000,   /* U+3B1E */
  0x0000,   /* U+3B1F */
  0x0000,   /* U+3B20 */
  0x0000,   /* U+3B21 */
  0x0000,   /* U+3B22 */
  0x0000,   /* U+3B23 */
  0x0000,   /* U+3B24 */
  0x0000,   /* U+3B25 */
  0x0000,   /* U+3B26 */
  0x0000,   /* U+3B27 */
  0x0000,   /* U+3B28 */
  0x0000,   /* U+3B29 */
  0x0000,   /* U+3B2A */
  0x0000,   /* U+3B2B */
  0x0000,   /* U+3B2C */
  0x0000,   /* U+3B2D */
  0x0000,   /* U+3B2E */
  0x0000,   /* U+3B2F */
  0x0000,   /* U+3B30 */
  0x0000,   /* U+3B31 */
  0x0000,   /* U+3B32 */
  0x0000,   /* U+3B33 */
  0x0000,   /* U+3B34 */
  0x0000,   /* U+3B35 */
  0x0000,   /* U+3B36 */
  0x0000,   /* U+3B37 */
  0x0000,   /* U+3B38 */
  0x0000,   /* U+3B39 */
  0x0000,   /* U+3B3A */
  0x0000,   /* U+3B3B */
  0x0000,   /* U+3B3C */
  0x0000,   /* U+3B3D */
  0x0000,   /* U+3B3E */
  0x0000,   /* U+3B3F */
  0x0000,   /* U+3B40 */
  0x0000,   /* U+3B41 */
  0x0000,   /* U+3B42 */
  0x0000,   /* U+3B43 */
  0x0000,   /* U+3B44 */
  0x0000,   /* U+3B45 */
  0x0000,   /* U+3B46 */
  0x0000,   /* U+3B47 */
  0x0000,   /* U+3B48 */
  0x0000,   /* U+3B49 */
  0x0000,   /* U+3B4A */
  0x0000,   /* U+3B4B */
  0x0000,   /* U+3B4C */
  0x0000,   /* U+3B4D */
  0x0000,   /* U+3B4E */
  0x0000,   /* U+3B4F */
  0x0000,   /* U+3B50 */
  0x0000,   /* U+3B51 */
  0x0000,   /* U+3B52 */
  0x0000,   /* U+3B53 */
  0x0000,   /* U+3B54 */
  0x0000,   /* U+3B55 */
  0x0000,   /* U+3B56 */
  0x0000,   /* U+3B57 */
  0x0000,   /* U+3B58 */
  0x0000,   /* U+3B59 */
  0x0000,   /* U+3B5A */
  0x0000,   /* U+3B5B */
  0x0000,   /* U+3B5C */
  0x0000,   /* U+3B5D */
  0x0000,   /* U+3B5E */
  0x0000,   /* U+3B5F */
  0x0000,   /* U+3B60 */
  0x0000,   /* U+3B61 */
  0x0000,   /* U+3B62 */
  0x0000,   /* U+3B63 */
  0x0000,   /* U+3B64 */
  0x0000,   /* U+3B65 */
  0x0000,   /* U+3B66 */
  0x0000,   /* U+3B67 */
  0x0000,   /* U+3B68 */
  0x0000,   /* U+3B69 */
  0x0000,   /* U+3B6A */
  0x0000,   /* U+3B6B */
  0x0000,   /* U+3B6C */
  0x0000,   /* U+3B6D */
  0x0000,   /* U+3B6E */
  0x0000,   /* U+3B6F */
  0x0000,   /* U+3B70 */
  0x0000,   /* U+3B71 */
  0x0000,   /* U+3B72 */
  0x0000,   /* U+3B73 */
  0x0000,   /* U+3B74 */
  0x0000,   /* U+3B75 */
  0x0000,   /* U+3B76 */
  0x0000,   /* U+3B77 */
  0x0000,   /* U+3B78 */
  0x0000,   /* U+3B79 */
  0x0000,   /* U+3B7A */
  0x0000,   /* U+3B7B */
  0x0000,   /* U+3B7C */
  0x0000,   /* U+3B7D */
  0x0000,   /* U+3B7E */
  0x0000,   /* U+3B7F */
  0x0000,   /* U+3B80 */
  0x0000,   /* U+3B81 */
  0x0000,   /* U+3B82 */
  0x0000,   /* U+3B83 */
  0x0000,   /* U+3B84 */
  0x0000,   /* U+3B85 */
  0x0000,   /* U+3B86 */
  0x0000,   /* U+3B87 */
  0x0000,   /* U+3B88 */
  0x0000,   /* U+3B89 */
  0x0000,   /* U+3B8A */
  0x0000,   /* U+3B8B */
  0x0000,   /* U+3B8C */
  0x0000,   /* U+3B8D */
  0x0000,   /* U+3B8E */
  0x0000,   /* U+3B8F */
  0x0000,   /* U+3B90 */
  0x0000,   /* U+3B91 */
  0x0000,   /* U+3B92 */
  0x0000,   /* U+3B93 */
  0x0000,   /* U+3B94 */
  0x0000,   /* U+3B95 */
  0x0000,   /* U+3B96 */
  0x0000,   /* U+3B97 */
  0x0000,   /* U+3B98 */
  0x0000,   /* U+3B99 */
  0x0000,   /* U+3B9A */
  0x0000,   /* U+3B9B */
  0x0000,   /* U+3B9C */
  0x0000,   /* U+3B9D */
  0x0000,   /* U+3B9E */
  0x0000,   /* U+3B9F */
  0x0000,   /* U+3BA0 */
  0x0000,   /* U+3BA1 */
  0x0000,   /* U+3BA2 */
  0x0000,   /* U+3BA3 */
  0x0000,   /* U+3BA4 */
  0x0000,   /* U+3BA5 */
  0x0000,   /* U+3BA6 */
  0x0000,   /* U+3BA7 */
  0x0000,   /* U+3BA8 */
  0x0000,   /* U+3BA9 */
  0x0000,   /* U+3BAA */
  0x0000,   /* U+3BAB */
  0x0000,   /* U+3BAC */
  0x0000,   /* U+3BAD */
  0x0000,   /* U+3BAE */
  0x0000,   /* U+3BAF */
  0x0000,   /* U+3BB0 */
  0x0000,   /* U+3BB1 */
  0x0000,   /* U+3BB2 */
  0x0000,   /* U+3BB3 */
  0x0000,   /* U+3BB4 */
  0x0000,   /* U+3BB5 */
  0x0000,   /* U+3BB6 */
  0x0000,   /* U+3BB7 */
  0x0000,   /* U+3BB8 */
  0x0000,   /* U+3BB9 */
  0x0000,   /* U+3BBA */
  0x0000,   /* U+3BBB */
  0x0000,   /* U+3BBC */
  0x0000,   /* U+3BBD */
  0x0000,   /* U+3BBE */
  0x0000,   /* U+3BBF */
  0x0000,   /* U+3BC0 */
  0x0000,   /* U+3BC1 */
  0x0000,   /* U+3BC2 */
  0x0000,   /* U+3BC3 */
  0x0000,   /* U+3BC4 */
  0x0000,   /* U+3BC5 */
  0x0000,   /* U+3BC6 */
  0x0000,   /* U+3BC7 */
  0x0000,   /* U+3BC8 */
  0x0000,   /* U+3BC9 */
  0x0000,   /* U+3BCA */
  0x0000,   /* U+3BCB */
  0x0000,   /* U+3BCC */
  0x0000,   /* U+3BCD */
  0x0000,   /* U+3BCE */
  0x0000,   /* U+3BCF */
  0x0000,   /* U+3BD0 */
  0x0000,   /* U+3BD1 */
  0x0000,   /* U+3BD2 */
  0x0000,   /* U+3BD3 */
  0x0000,   /* U+3BD4 */
  0x0000,   /* U+3BD5 */
  0x0000,   /* U+3BD6 */
  0x0000,   /* U+3BD7 */
  0x0000,   /* U+3BD8 */
  0x0000,   /* U+3BD9 */
  0x0000,   /* U+3BDA */
  0x0000,   /* U+3BDB */
  0x0000,   /* U+3BDC */
  0x0000,   /* U+3BDD */
  0x0000,   /* U+3BDE */
  0x0000,   /* U+3BDF */
  0x0000,   /* U+3BE0 */
  0x0000,   /* U+3BE1 */
  0x0000,   /* U+3BE2 */
  0x0000,   /* U+3BE3 */
  0x0000,   /* U+3BE4 */
  0x0000,   /* U+3BE5 */
  0x0000,   /* U+3BE6 */
  0x0000,   /* U+3BE7 */
  0x0000,   /* U+3BE8 */
  0x0000,   /* U+3BE9 */
  0x0000,   /* U+3BEA */
  0x0000,   /* U+3BEB */
  0x0000,   /* U+3BEC */
  0x0000,   /* U+3BED */
  0x0000,   /* U+3BEE */
  0x0000,   /* U+3BEF */
  0x0000,   /* U+3BF0 */
  0x0000,   /* U+3BF1 */
  0x0000,   /* U+3BF2 */
  0x0000,   /* U+3BF3 */
  0x0000,   /* U+3BF4 */
  0x0000,   /* U+3BF5 */
  0x0000,   /* U+3BF6 */
  0x0000,   /* U+3BF7 */
  0x0000,   /* U+3BF8 */
  0x0000,   /* U+3BF9 */
  0x0000,   /* U+3BFA */
  0x0000,   /* U+3BFB */
  0x0000,   /* U+3BFC */
  0x0000,   /* U+3BFD */
  0x0000,   /* U+3BFE */
  0x0000,   /* U+3BFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3B00 */
  0x0000,   /* U+3B01 */
  0x0000,   /* U+3B02 */
  0x0000,   /* U+3B03 */
  0x0000,   /* U+3B04 */
  0x0000,   /* U+3B05 */
  0x0000,   /* U+3B06 */
  0x0000,   /* U+3B07 */
  0x0000,   /* U+3B08 */
  0x0000,   /* U+3B09 */
  0x0000,   /* U+3B0A */
  0x0000,   /* U+3B0B */
  0x0000,   /* U+3B0C */
  0x0000,   /* U+3B0D */
  0x0000,   /* U+3B0E */
  0x0000,   /* U+3B0F */
  0x0000,   /* U+3B10 */
  0x0000,   /* U+3B11 */
  0x0000,   /* U+3B12 */
  0x0000,   /* U+3B13 */
  0x0000,   /* U+3B14 */
  0x0000,   /* U+3B15 */
  0x0000,   /* U+3B16 */
  0x0000,   /* U+3B17 */
  0x0000,   /* U+3B18 */
  0x0000,   /* U+3B19 */
  0x0000,   /* U+3B1A */
  0x0000,   /* U+3B1B */
  0x0000,   /* U+3B1C */
  0x0000,   /* U+3B1D */
  0x0000,   /* U+3B1E */
  0x0000,   /* U+3B1F */
  0x0000,   /* U+3B20 */
  0x0000,   /* U+3B21 */
  0x0000,   /* U+3B22 */
  0x0000,   /* U+3B23 */
  0x0000,   /* U+3B24 */
  0x0000,   /* U+3B25 */
  0x0000,   /* U+3B26 */
  0x0000,   /* U+3B27 */
  0x0000,   /* U+3B28 */
  0x0000,   /* U+3B29 */
  0x0000,   /* U+3B2A */
  0x0000,   /* U+3B2B */
  0x0000,   /* U+3B2C */
  0x0000,   /* U+3B2D */
  0x0000,   /* U+3B2E */
  0x0000,   /* U+3B2F */
  0x0000,   /* U+3B30 */
  0x0000,   /* U+3B31 */
  0x0000,   /* U+3B32 */
  0x0000,   /* U+3B33 */
  0x0000,   /* U+3B34 */
  0x0000,   /* U+3B35 */
  0x0000,   /* U+3B36 */
  0x0000,   /* U+3B37 */
  0x0000,   /* U+3B38 */
  0x0000,   /* U+3B39 */
  0x0000,   /* U+3B3A */
  0x0000,   /* U+3B3B */
  0x0000,   /* U+3B3C */
  0x0000,   /* U+3B3D */
  0x0000,   /* U+3B3E */
  0x0000,   /* U+3B3F */
  0x0000,   /* U+3B40 */
  0x0000,   /* U+3B41 */
  0x0000,   /* U+3B42 */
  0x0000,   /* U+3B43 */
  0x0000,   /* U+3B44 */
  0x0000,   /* U+3B45 */
  0x0000,   /* U+3B46 */
  0x0000,   /* U+3B47 */
  0x0000,   /* U+3B48 */
  0x0000,   /* U+3B49 */
  0x0000,   /* U+3B4A */
  0x0000,   /* U+3B4B */
  0x0000,   /* U+3B4C */
  0x0000,   /* U+3B4D */
  0x0000,   /* U+3B4E */
  0x0000,   /* U+3B4F */
  0x0000,   /* U+3B50 */
  0x0000,   /* U+3B51 */
  0x0000,   /* U+3B52 */
  0x0000,   /* U+3B53 */
  0x0000,   /* U+3B54 */
  0x0000,   /* U+3B55 */
  0x0000,   /* U+3B56 */
  0x0000,   /* U+3B57 */
  0x0000,   /* U+3B58 */
  0x0000,   /* U+3B59 */
  0x0000,   /* U+3B5A */
  0x0000,   /* U+3B5B */
  0x0000,   /* U+3B5C */
  0x0000,   /* U+3B5D */
  0x0000,   /* U+3B5E */
  0x0000,   /* U+3B5F */
  0x0000,   /* U+3B60 */
  0x0000,   /* U+3B61 */
  0x0000,   /* U+3B62 */
  0x0000,   /* U+3B63 */
  0x0000,   /* U+3B64 */
  0x0000,   /* U+3B65 */
  0x0000,   /* U+3B66 */
  0x0000,   /* U+3B67 */
  0x0000,   /* U+3B68 */
  0x0000,   /* U+3B69 */
  0x0000,   /* U+3B6A */
  0x0000,   /* U+3B6B */
  0x0000,   /* U+3B6C */
  0x0000,   /* U+3B6D */
  0x0000,   /* U+3B6E */
  0x0000,   /* U+3B6F */
  0x0000,   /* U+3B70 */
  0x0000,   /* U+3B71 */
  0x0000,   /* U+3B72 */
  0x0000,   /* U+3B73 */
  0x0000,   /* U+3B74 */
  0x0000,   /* U+3B75 */
  0x0000,   /* U+3B76 */
  0x0000,   /* U+3B77 */
  0x0000,   /* U+3B78 */
  0x0000,   /* U+3B79 */
  0x0000,   /* U+3B7A */
  0x0000,   /* U+3B7B */
  0x0000,   /* U+3B7C */
  0x0000,   /* U+3B7D */
  0x0000,   /* U+3B7E */
  0x0000,   /* U+3B7F */
  0x0000,   /* U+3B80 */
  0x0000,   /* U+3B81 */
  0x0000,   /* U+3B82 */
  0x0000,   /* U+3B83 */
  0x0000,   /* U+3B84 */
  0x0000,   /* U+3B85 */
  0x0000,   /* U+3B86 */
  0x0000,   /* U+3B87 */
  0x0000,   /* U+3B88 */
  0x0000,   /* U+3B89 */
  0x0000,   /* U+3B8A */
  0x0000,   /* U+3B8B */
  0x0000,   /* U+3B8C */
  0x0000,   /* U+3B8D */
  0x0000,   /* U+3B8E */
  0x0000,   /* U+3B8F */
  0x0000,   /* U+3B90 */
  0x0000,   /* U+3B91 */
  0x0000,   /* U+3B92 */
  0x0000,   /* U+3B93 */
  0x0000,   /* U+3B94 */
  0x0000,   /* U+3B95 */
  0x0000,   /* U+3B96 */
  0x0000,   /* U+3B97 */
  0x0000,   /* U+3B98 */
  0x0000,   /* U+3B99 */
  0x0000,   /* U+3B9A */
  0x0000,   /* U+3B9B */
  0x0000,   /* U+3B9C */
  0x0000,   /* U+3B9D */
  0x0000,   /* U+3B9E */
  0x0000,   /* U+3B9F */
  0x0000,   /* U+3BA0 */
  0x0000,   /* U+3BA1 */
  0x0000,   /* U+3BA2 */
  0x0000,   /* U+3BA3 */
  0x0000,   /* U+3BA4 */
  0x0000,   /* U+3BA5 */
  0x0000,   /* U+3BA6 */
  0x0000,   /* U+3BA7 */
  0x0000,   /* U+3BA8 */
  0x0000,   /* U+3BA9 */
  0x0000,   /* U+3BAA */
  0x0000,   /* U+3BAB */
  0x0000,   /* U+3BAC */
  0x0000,   /* U+3BAD */
  0x0000,   /* U+3BAE */
  0x0000,   /* U+3BAF */
  0x0000,   /* U+3BB0 */
  0x0000,   /* U+3BB1 */
  0x0000,   /* U+3BB2 */
  0x0000,   /* U+3BB3 */
  0x0000,   /* U+3BB4 */
  0x0000,   /* U+3BB5 */
  0x0000,   /* U+3BB6 */
  0x0000,   /* U+3BB7 */
  0x0000,   /* U+3BB8 */
  0x0000,   /* U+3BB9 */
  0x0000,   /* U+3BBA */
  0x0000,   /* U+3BBB */
  0x0000,   /* U+3BBC */
  0x0000,   /* U+3BBD */
  0x0000,   /* U+3BBE */
  0x0000,   /* U+3BBF */
  0x0000,   /* U+3BC0 */
  0x0000,   /* U+3BC1 */
  0x0000,   /* U+3BC2 */
  0x0000,   /* U+3BC3 */
  0x0000,   /* U+3BC4 */
  0x0000,   /* U+3BC5 */
  0x0000,   /* U+3BC6 */
  0x0000,   /* U+3BC7 */
  0x0000,   /* U+3BC8 */
  0x0000,   /* U+3BC9 */
  0x0000,   /* U+3BCA */
  0x0000,   /* U+3BCB */
  0x0000,   /* U+3BCC */
  0x0000,   /* U+3BCD */
  0x0000,   /* U+3BCE */
  0x0000,   /* U+3BCF */
  0x0000,   /* U+3BD0 */
  0x0000,   /* U+3BD1 */
  0x0000,   /* U+3BD2 */
  0x0000,   /* U+3BD3 */
  0x0000,   /* U+3BD4 */
  0x0000,   /* U+3BD5 */
  0x0000,   /* U+3BD6 */
  0x0000,   /* U+3BD7 */
  0x0000,   /* U+3BD8 */
  0x0000,   /* U+3BD9 */
  0x0000,   /* U+3BDA */
  0x0000,   /* U+3BDB */
  0x0000,   /* U+3BDC */
  0x0000,   /* U+3BDD */
  0x0000,   /* U+3BDE */
  0x0000,   /* U+3BDF */
  0x0000,   /* U+3BE0 */
  0x0000,   /* U+3BE1 */
  0x0000,   /* U+3BE2 */
  0x0000,   /* U+3BE3 */
  0x0000,   /* U+3BE4 */
  0x0000,   /* U+3BE5 */
  0x0000,   /* U+3BE6 */
  0x0000,   /* U+3BE7 */
  0x0000,   /* U+3BE8 */
  0x0000,   /* U+3BE9 */
  0x0000,   /* U+3BEA */
  0x0000,   /* U+3BEB */
  0x0000,   /* U+3BEC */
  0x0000,   /* U+3BED */
  0x0000,   /* U+3BEE */
  0x0000,   /* U+3BEF */
  0x0000,   /* U+3BF0 */
  0x0000,   /* U+3BF1 */
  0x0000,   /* U+3BF2 */
  0x0000,   /* U+3BF3 */
  0x0000,   /* U+3BF4 */
  0x0000,   /* U+3BF5 */
  0x0000,   /* U+3BF6 */
  0x0000,   /* U+3BF7 */
  0x0000,   /* U+3BF8 */
  0x0000,   /* U+3BF9 */
  0x0000,   /* U+3BFA */
  0x0000,   /* U+3BFB */
  0x0000,   /* U+3BFC */
  0x0000,   /* U+3BFD */
  0x0000,   /* U+3BFE */
  0x0000,   /* U+3BFF */
};

uint16 zh3_han_p03C[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C5A,   /* U+3C00 */
  0x1C5A,   /* U+3C01 */
  0x1C5A,   /* U+3C02 */
  0x1C5A,   /* U+3C03 */
  0x1C5A,   /* U+3C04 */
  0x1C5A,   /* U+3C05 */
  0x1C5A,   /* U+3C06 */
  0x1C5A,   /* U+3C07 */
  0x1C5A,   /* U+3C08 */
  0x1C5B,   /* U+3C09 */
  0x1C5B,   /* U+3C0A */
  0x1C5B,   /* U+3C0B */
  0x1C5B,   /* U+3C0C */
  0x1C5B,   /* U+3C0D */
  0x1C5B,   /* U+3C0E */
  0x1C5B,   /* U+3C0F */
  0x1C5B,   /* U+3C10 */
  0x1C5B,   /* U+3C11 */
  0x1C5B,   /* U+3C12 */
  0x1C5B,   /* U+3C13 */
  0x1C5C,   /* U+3C14 */
  0x1C5C,   /* U+3C15 */
  0x1C5B,   /* U+3C16 */
  0x1C5D,   /* U+3C17 */
  0x1C5D,   /* U+3C18 */
  0x1C5E,   /* U+3C19 */
  0x1C5E,   /* U+3C1A */
  0x1C5E,   /* U+3C1B */
  0x1C5E,   /* U+3C1C */
  0x1C4E,   /* U+3C1D */
  0x1C4E,   /* U+3C1E */
  0x1C4F,   /* U+3C1F */
  0x1C4F,   /* U+3C20 */
  0x1C4F,   /* U+3C21 */
  0x1C4F,   /* U+3C22 */
  0x1C50,   /* U+3C23 */
  0x1C50,   /* U+3C24 */
  0x1C50,   /* U+3C25 */
  0x1C50,   /* U+3C26 */
  0x1C50,   /* U+3C27 */
  0x1C50,   /* U+3C28 */
  0x1C51,   /* U+3C29 */
  0x1C51,   /* U+3C2A */
  0x1C51,   /* U+3C2B */
  0x1C51,   /* U+3C2C */
  0x1C51,   /* U+3C2D */
  0x1C52,   /* U+3C2E */
  0x1C52,   /* U+3C2F */
  0x1C52,   /* U+3C30 */
  0x1C52,   /* U+3C31 */
  0x1C53,   /* U+3C32 */
  0x1C53,   /* U+3C33 */
  0x1C53,   /* U+3C34 */
  0x1C53,   /* U+3C35 */
  0x1C53,   /* U+3C36 */
  0x1C51,   /* U+3C37 */
  0x1C53,   /* U+3C38 */
  0x1C54,   /* U+3C39 */
  0x1C54,   /* U+3C3A */
  0x1C54,   /* U+3C3B */
  0x1C54,   /* U+3C3C */
  0x1C54,   /* U+3C3D */
  0x1C54,   /* U+3C3E */
  0x1C55,   /* U+3C3F */
  0x1C55,   /* U+3C40 */
  0x1C55,   /* U+3C41 */
  0x1C56,   /* U+3C42 */
  0x1C56,   /* U+3C43 */
  0x1C57,   /* U+3C44 */
  0x1C57,   /* U+3C45 */
  0x1C58,   /* U+3C46 */
  0x1C58,   /* U+3C47 */
  0x1C58,   /* U+3C48 */
  0x1C58,   /* U+3C49 */
  0x1C5A,   /* U+3C4A */
  0x1C5B,   /* U+3C4B */
  0x1C5D,   /* U+3C4C */
  0x1C5E,   /* U+3C4D */
  0x1C60,   /* U+3C4E */
  0x1C4D,   /* U+3C4F */
  0x1C4E,   /* U+3C50 */
  0x1C4E,   /* U+3C51 */
  0x1C50,   /* U+3C52 */
  0x1C50,   /* U+3C53 */
  0x1C50,   /* U+3C54 */
  0x1C53,   /* U+3C55 */
  0x1C53,   /* U+3C56 */
  0x1C55,   /* U+3C57 */
  0x1C59,   /* U+3C58 */
  0x1C4D,   /* U+3C59 */
  0x1C4F,   /* U+3C5A */
  0x1C4F,   /* U+3C5B */
  0x1C4F,   /* U+3C5C */
  0x1C4F,   /* U+3C5D */
  0x1C50,   /* U+3C5E */
  0x1C50,   /* U+3C5F */
  0x1C50,   /* U+3C60 */
  0x1C51,   /* U+3C61 */
  0x1C52,   /* U+3C62 */
  0x1C52,   /* U+3C63 */
  0x1C53,   /* U+3C64 */
  0x1C53,   /* U+3C65 */
  0x1C53,   /* U+3C66 */
  0x1C53,   /* U+3C67 */
  0x1C53,   /* U+3C68 */
  0x1C53,   /* U+3C69 */
  0x1C54,   /* U+3C6A */
  0x1C54,   /* U+3C6B */
  0x1C54,   /* U+3C6C */
  0x1C54,   /* U+3C6D */
  0x1C54,   /* U+3C6E */
  0x1C55,   /* U+3C6F */
  0x1C55,   /* U+3C70 */
  0x1C55,   /* U+3C71 */
  0x1C55,   /* U+3C72 */
  0x1C56,   /* U+3C73 */
  0x1C56,   /* U+3C74 */
  0x1C57,   /* U+3C75 */
  0x1C57,   /* U+3C76 */
  0x1C57,   /* U+3C77 */
  0x1C58,   /* U+3C78 */
  0x1C5B,   /* U+3C79 */
  0x1C5B,   /* U+3C7A */
  0x1C5E,   /* U+3C7B */
  0x1C4E,   /* U+3C7C */
  0x1C4F,   /* U+3C7D */
  0x1C51,   /* U+3C7E */
  0x1C51,   /* U+3C7F */
  0x1C52,   /* U+3C80 */
  0x1C53,   /* U+3C81 */
  0x1C53,   /* U+3C82 */
  0x1C53,   /* U+3C83 */
  0x1C54,   /* U+3C84 */
  0x1C55,   /* U+3C85 */
  0x1C57,   /* U+3C86 */
  0x1C57,   /* U+3C87 */
  0x1C57,   /* U+3C88 */
  0x1C58,   /* U+3C89 */
  0x1C59,   /* U+3C8A */
  0x1C50,   /* U+3C8B */
  0x1C4D,   /* U+3C8C */
  0x1C4F,   /* U+3C8D */
  0x1C4F,   /* U+3C8E */
  0x1C4F,   /* U+3C8F */
  0x1C4F,   /* U+3C90 */
  0x1C4F,   /* U+3C91 */
  0x1C50,   /* U+3C92 */
  0x1C51,   /* U+3C93 */
  0x1C52,   /* U+3C94 */
  0x1C52,   /* U+3C95 */
  0x1C52,   /* U+3C96 */
  0x1C52,   /* U+3C97 */
  0x1C52,   /* U+3C98 */
  0x1C52,   /* U+3C99 */
  0x1C52,   /* U+3C9A */
  0x1C53,   /* U+3C9B */
  0x1C53,   /* U+3C9C */
  0x1C53,   /* U+3C9D */
  0x1C53,   /* U+3C9E */
  0x1C54,   /* U+3C9F */
  0x1C54,   /* U+3CA0 */
  0x1C54,   /* U+3CA1 */
  0x1C54,   /* U+3CA2 */
  0x1C54,   /* U+3CA3 */
  0x1C55,   /* U+3CA4 */
  0x1C55,   /* U+3CA5 */
  0x1C55,   /* U+3CA6 */
  0x1C55,   /* U+3CA7 */
  0x1C55,   /* U+3CA8 */
  0x1C55,   /* U+3CA9 */
  0x1C57,   /* U+3CAA */
  0x1C57,   /* U+3CAB */
  0x1C57,   /* U+3CAC */
  0x1C57,   /* U+3CAD */
  0x1C57,   /* U+3CAE */
  0x1C59,   /* U+3CAF */
  0x1C59,   /* U+3CB0 */
  0x1C5A,   /* U+3CB1 */
  0x1C61,   /* U+3CB2 */
  0x1C51,   /* U+3CB3 */
  0x1C4F,   /* U+3CB4 */
  0x1C52,   /* U+3CB5 */
  0x1C56,   /* U+3CB6 */
  0x1C57,   /* U+3CB7 */
  0x1C4B,   /* U+3CB8 */
  0x1C4C,   /* U+3CB9 */
  0x1C4C,   /* U+3CBA */
  0x1C4D,   /* U+3CBB */
  0x1C4C,   /* U+3CBC */
  0x1C4D,   /* U+3CBD */
  0x1C4E,   /* U+3CBE */
  0x1C4D,   /* U+3CBF */
  0x1C4E,   /* U+3CC0 */
  0x1C4E,   /* U+3CC1 */
  0x1C4E,   /* U+3CC2 */
  0x1C4E,   /* U+3CC3 */
  0x1C4E,   /* U+3CC4 */
  0x1C4E,   /* U+3CC5 */
  0x1C4E,   /* U+3CC6 */
  0x1C4E,   /* U+3CC7 */
  0x1C4E,   /* U+3CC8 */
  0x1C4E,   /* U+3CC9 */
  0x1C4E,   /* U+3CCA */
  0x1C4F,   /* U+3CCB */
  0x1C4F,   /* U+3CCC */
  0x1C4F,   /* U+3CCD */
  0x1C4F,   /* U+3CCE */
  0x1C4F,   /* U+3CCF */
  0x1C4F,   /* U+3CD0 */
  0x1C4F,   /* U+3CD1 */
  0x1C4F,   /* U+3CD2 */
  0x1C4F,   /* U+3CD3 */
  0x1C4F,   /* U+3CD4 */
  0x1C4F,   /* U+3CD5 */
  0x1C50,   /* U+3CD6 */
  0x1C50,   /* U+3CD7 */
  0x1C50,   /* U+3CD8 */
  0x1C50,   /* U+3CD9 */
  0x1C50,   /* U+3CDA */
  0x1C50,   /* U+3CDB */
  0x1C50,   /* U+3CDC */
  0x1C50,   /* U+3CDD */
  0x1C50,   /* U+3CDE */
  0x1C52,   /* U+3CDF */
  0x1C50,   /* U+3CE0 */
  0x1C50,   /* U+3CE1 */
  0x1C50,   /* U+3CE2 */
  0x1C50,   /* U+3CE3 */
  0x1C51,   /* U+3CE4 */
  0x1C51,   /* U+3CE5 */
  0x1C51,   /* U+3CE6 */
  0x1C51,   /* U+3CE7 */
  0x1C51,   /* U+3CE8 */
  0x1C51,   /* U+3CE9 */
  0x1C51,   /* U+3CEA */
  0x1C52,   /* U+3CEB */
  0x1C51,   /* U+3CEC */
  0x1C51,   /* U+3CED */
  0x1C51,   /* U+3CEE */
  0x1C51,   /* U+3CEF */
  0x1C51,   /* U+3CF0 */
  0x1C51,   /* U+3CF1 */
  0x1C51,   /* U+3CF2 */
  0x1C51,   /* U+3CF3 */
  0x1C52,   /* U+3CF4 */
  0x1C52,   /* U+3CF5 */
  0x1C52,   /* U+3CF6 */
  0x1C52,   /* U+3CF7 */
  0x1C52,   /* U+3CF8 */
  0x1C52,   /* U+3CF9 */
  0x1C52,   /* U+3CFA */
  0x1C52,   /* U+3CFB */
  0x1C53,   /* U+3CFC */
  0x1C52,   /* U+3CFD */
  0x1C52,   /* U+3CFE */
  0x1C52,   /* U+3CFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3C00 */
  0x0020,   /* U+3C01 */
  0x0020,   /* U+3C02 */
  0x0020,   /* U+3C03 */
  0x0020,   /* U+3C04 */
  0x0020,   /* U+3C05 */
  0x0020,   /* U+3C06 */
  0x0020,   /* U+3C07 */
  0x0020,   /* U+3C08 */
  0x0020,   /* U+3C09 */
  0x0020,   /* U+3C0A */
  0x0020,   /* U+3C0B */
  0x0020,   /* U+3C0C */
  0x0020,   /* U+3C0D */
  0x0020,   /* U+3C0E */
  0x0020,   /* U+3C0F */
  0x0020,   /* U+3C10 */
  0x0020,   /* U+3C11 */
  0x0020,   /* U+3C12 */
  0x0020,   /* U+3C13 */
  0x0020,   /* U+3C14 */
  0x0020,   /* U+3C15 */
  0x0020,   /* U+3C16 */
  0x0020,   /* U+3C17 */
  0x0020,   /* U+3C18 */
  0x0020,   /* U+3C19 */
  0x0020,   /* U+3C1A */
  0x0020,   /* U+3C1B */
  0x0020,   /* U+3C1C */
  0x0020,   /* U+3C1D */
  0x0020,   /* U+3C1E */
  0x0020,   /* U+3C1F */
  0x0020,   /* U+3C20 */
  0x0020,   /* U+3C21 */
  0x0020,   /* U+3C22 */
  0x0020,   /* U+3C23 */
  0x0020,   /* U+3C24 */
  0x0020,   /* U+3C25 */
  0x0020,   /* U+3C26 */
  0x0020,   /* U+3C27 */
  0x0020,   /* U+3C28 */
  0x0020,   /* U+3C29 */
  0x0020,   /* U+3C2A */
  0x0020,   /* U+3C2B */
  0x0020,   /* U+3C2C */
  0x0020,   /* U+3C2D */
  0x0020,   /* U+3C2E */
  0x0020,   /* U+3C2F */
  0x0020,   /* U+3C30 */
  0x0020,   /* U+3C31 */
  0x0020,   /* U+3C32 */
  0x0020,   /* U+3C33 */
  0x0020,   /* U+3C34 */
  0x0020,   /* U+3C35 */
  0x0020,   /* U+3C36 */
  0x0020,   /* U+3C37 */
  0x0020,   /* U+3C38 */
  0x0020,   /* U+3C39 */
  0x0020,   /* U+3C3A */
  0x0020,   /* U+3C3B */
  0x0020,   /* U+3C3C */
  0x0020,   /* U+3C3D */
  0x0020,   /* U+3C3E */
  0x0020,   /* U+3C3F */
  0x0020,   /* U+3C40 */
  0x0020,   /* U+3C41 */
  0x0020,   /* U+3C42 */
  0x0020,   /* U+3C43 */
  0x0020,   /* U+3C44 */
  0x0020,   /* U+3C45 */
  0x0020,   /* U+3C46 */
  0x0020,   /* U+3C47 */
  0x0020,   /* U+3C48 */
  0x0020,   /* U+3C49 */
  0x0020,   /* U+3C4A */
  0x0020,   /* U+3C4B */
  0x0020,   /* U+3C4C */
  0x0020,   /* U+3C4D */
  0x0020,   /* U+3C4E */
  0x0020,   /* U+3C4F */
  0x0020,   /* U+3C50 */
  0x0020,   /* U+3C51 */
  0x0020,   /* U+3C52 */
  0x0020,   /* U+3C53 */
  0x0020,   /* U+3C54 */
  0x0020,   /* U+3C55 */
  0x0020,   /* U+3C56 */
  0x0020,   /* U+3C57 */
  0x0020,   /* U+3C58 */
  0x0020,   /* U+3C59 */
  0x0020,   /* U+3C5A */
  0x0020,   /* U+3C5B */
  0x0020,   /* U+3C5C */
  0x0020,   /* U+3C5D */
  0x0020,   /* U+3C5E */
  0x0020,   /* U+3C5F */
  0x0020,   /* U+3C60 */
  0x0020,   /* U+3C61 */
  0x0020,   /* U+3C62 */
  0x0020,   /* U+3C63 */
  0x0020,   /* U+3C64 */
  0x0020,   /* U+3C65 */
  0x0020,   /* U+3C66 */
  0x0020,   /* U+3C67 */
  0x0020,   /* U+3C68 */
  0x0020,   /* U+3C69 */
  0x0020,   /* U+3C6A */
  0x0020,   /* U+3C6B */
  0x0020,   /* U+3C6C */
  0x0020,   /* U+3C6D */
  0x0020,   /* U+3C6E */
  0x0020,   /* U+3C6F */
  0x0020,   /* U+3C70 */
  0x0020,   /* U+3C71 */
  0x0020,   /* U+3C72 */
  0x0020,   /* U+3C73 */
  0x0020,   /* U+3C74 */
  0x0020,   /* U+3C75 */
  0x0020,   /* U+3C76 */
  0x0020,   /* U+3C77 */
  0x0020,   /* U+3C78 */
  0x0020,   /* U+3C79 */
  0x0020,   /* U+3C7A */
  0x0020,   /* U+3C7B */
  0x0020,   /* U+3C7C */
  0x0020,   /* U+3C7D */
  0x0020,   /* U+3C7E */
  0x0020,   /* U+3C7F */
  0x0020,   /* U+3C80 */
  0x0020,   /* U+3C81 */
  0x0020,   /* U+3C82 */
  0x0020,   /* U+3C83 */
  0x0020,   /* U+3C84 */
  0x0020,   /* U+3C85 */
  0x0020,   /* U+3C86 */
  0x0020,   /* U+3C87 */
  0x0020,   /* U+3C88 */
  0x0020,   /* U+3C89 */
  0x0020,   /* U+3C8A */
  0x0020,   /* U+3C8B */
  0x0020,   /* U+3C8C */
  0x0020,   /* U+3C8D */
  0x0020,   /* U+3C8E */
  0x0020,   /* U+3C8F */
  0x0020,   /* U+3C90 */
  0x0020,   /* U+3C91 */
  0x0020,   /* U+3C92 */
  0x0020,   /* U+3C93 */
  0x0020,   /* U+3C94 */
  0x0020,   /* U+3C95 */
  0x0020,   /* U+3C96 */
  0x0020,   /* U+3C97 */
  0x0020,   /* U+3C98 */
  0x0020,   /* U+3C99 */
  0x0020,   /* U+3C9A */
  0x0020,   /* U+3C9B */
  0x0020,   /* U+3C9C */
  0x0020,   /* U+3C9D */
  0x0020,   /* U+3C9E */
  0x0020,   /* U+3C9F */
  0x0020,   /* U+3CA0 */
  0x0020,   /* U+3CA1 */
  0x0020,   /* U+3CA2 */
  0x0020,   /* U+3CA3 */
  0x0020,   /* U+3CA4 */
  0x0020,   /* U+3CA5 */
  0x0020,   /* U+3CA6 */
  0x0020,   /* U+3CA7 */
  0x0020,   /* U+3CA8 */
  0x0020,   /* U+3CA9 */
  0x0020,   /* U+3CAA */
  0x0020,   /* U+3CAB */
  0x0020,   /* U+3CAC */
  0x0020,   /* U+3CAD */
  0x0020,   /* U+3CAE */
  0x0020,   /* U+3CAF */
  0x0020,   /* U+3CB0 */
  0x0020,   /* U+3CB1 */
  0x0020,   /* U+3CB2 */
  0x0020,   /* U+3CB3 */
  0x0020,   /* U+3CB4 */
  0x0020,   /* U+3CB5 */
  0x0020,   /* U+3CB6 */
  0x0020,   /* U+3CB7 */
  0x0020,   /* U+3CB8 */
  0x0020,   /* U+3CB9 */
  0x0020,   /* U+3CBA */
  0x0020,   /* U+3CBB */
  0x0020,   /* U+3CBC */
  0x0020,   /* U+3CBD */
  0x0020,   /* U+3CBE */
  0x0020,   /* U+3CBF */
  0x0020,   /* U+3CC0 */
  0x0020,   /* U+3CC1 */
  0x0020,   /* U+3CC2 */
  0x0020,   /* U+3CC3 */
  0x0020,   /* U+3CC4 */
  0x0020,   /* U+3CC5 */
  0x0020,   /* U+3CC6 */
  0x0020,   /* U+3CC7 */
  0x0020,   /* U+3CC8 */
  0x0020,   /* U+3CC9 */
  0x0020,   /* U+3CCA */
  0x0020,   /* U+3CCB */
  0x0020,   /* U+3CCC */
  0x0020,   /* U+3CCD */
  0x0020,   /* U+3CCE */
  0x0020,   /* U+3CCF */
  0x0020,   /* U+3CD0 */
  0x0020,   /* U+3CD1 */
  0x0020,   /* U+3CD2 */
  0x0020,   /* U+3CD3 */
  0x0020,   /* U+3CD4 */
  0x0020,   /* U+3CD5 */
  0x0020,   /* U+3CD6 */
  0x0020,   /* U+3CD7 */
  0x0020,   /* U+3CD8 */
  0x0020,   /* U+3CD9 */
  0x0020,   /* U+3CDA */
  0x0020,   /* U+3CDB */
  0x0020,   /* U+3CDC */
  0x0020,   /* U+3CDD */
  0x0020,   /* U+3CDE */
  0x0020,   /* U+3CDF */
  0x0020,   /* U+3CE0 */
  0x0020,   /* U+3CE1 */
  0x0020,   /* U+3CE2 */
  0x0020,   /* U+3CE3 */
  0x0020,   /* U+3CE4 */
  0x0020,   /* U+3CE5 */
  0x0020,   /* U+3CE6 */
  0x0020,   /* U+3CE7 */
  0x0020,   /* U+3CE8 */
  0x0020,   /* U+3CE9 */
  0x0020,   /* U+3CEA */
  0x0020,   /* U+3CEB */
  0x0020,   /* U+3CEC */
  0x0020,   /* U+3CED */
  0x0020,   /* U+3CEE */
  0x0020,   /* U+3CEF */
  0x0020,   /* U+3CF0 */
  0x0020,   /* U+3CF1 */
  0x0020,   /* U+3CF2 */
  0x0020,   /* U+3CF3 */
  0x0020,   /* U+3CF4 */
  0x0020,   /* U+3CF5 */
  0x0020,   /* U+3CF6 */
  0x0020,   /* U+3CF7 */
  0x0020,   /* U+3CF8 */
  0x0020,   /* U+3CF9 */
  0x0020,   /* U+3CFA */
  0x0020,   /* U+3CFB */
  0x0020,   /* U+3CFC */
  0x0020,   /* U+3CFD */
  0x0020,   /* U+3CFE */
  0x0020,   /* U+3CFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3C00 */
  0x0002,   /* U+3C01 */
  0x0002,   /* U+3C02 */
  0x0002,   /* U+3C03 */
  0x0002,   /* U+3C04 */
  0x0002,   /* U+3C05 */
  0x0002,   /* U+3C06 */
  0x0002,   /* U+3C07 */
  0x0002,   /* U+3C08 */
  0x0002,   /* U+3C09 */
  0x0002,   /* U+3C0A */
  0x0002,   /* U+3C0B */
  0x0002,   /* U+3C0C */
  0x0002,   /* U+3C0D */
  0x0002,   /* U+3C0E */
  0x0002,   /* U+3C0F */
  0x0002,   /* U+3C10 */
  0x0002,   /* U+3C11 */
  0x0002,   /* U+3C12 */
  0x0002,   /* U+3C13 */
  0x0002,   /* U+3C14 */
  0x0002,   /* U+3C15 */
  0x0002,   /* U+3C16 */
  0x0002,   /* U+3C17 */
  0x0002,   /* U+3C18 */
  0x0002,   /* U+3C19 */
  0x0002,   /* U+3C1A */
  0x0002,   /* U+3C1B */
  0x0002,   /* U+3C1C */
  0x0002,   /* U+3C1D */
  0x0002,   /* U+3C1E */
  0x0002,   /* U+3C1F */
  0x0002,   /* U+3C20 */
  0x0002,   /* U+3C21 */
  0x0002,   /* U+3C22 */
  0x0002,   /* U+3C23 */
  0x0002,   /* U+3C24 */
  0x0002,   /* U+3C25 */
  0x0002,   /* U+3C26 */
  0x0002,   /* U+3C27 */
  0x0002,   /* U+3C28 */
  0x0002,   /* U+3C29 */
  0x0002,   /* U+3C2A */
  0x0002,   /* U+3C2B */
  0x0002,   /* U+3C2C */
  0x0002,   /* U+3C2D */
  0x0002,   /* U+3C2E */
  0x0002,   /* U+3C2F */
  0x0002,   /* U+3C30 */
  0x0002,   /* U+3C31 */
  0x0002,   /* U+3C32 */
  0x0002,   /* U+3C33 */
  0x0002,   /* U+3C34 */
  0x0002,   /* U+3C35 */
  0x0002,   /* U+3C36 */
  0x0002,   /* U+3C37 */
  0x0002,   /* U+3C38 */
  0x0002,   /* U+3C39 */
  0x0002,   /* U+3C3A */
  0x0002,   /* U+3C3B */
  0x0002,   /* U+3C3C */
  0x0002,   /* U+3C3D */
  0x0002,   /* U+3C3E */
  0x0002,   /* U+3C3F */
  0x0002,   /* U+3C40 */
  0x0002,   /* U+3C41 */
  0x0002,   /* U+3C42 */
  0x0002,   /* U+3C43 */
  0x0002,   /* U+3C44 */
  0x0002,   /* U+3C45 */
  0x0002,   /* U+3C46 */
  0x0002,   /* U+3C47 */
  0x0002,   /* U+3C48 */
  0x0002,   /* U+3C49 */
  0x0002,   /* U+3C4A */
  0x0002,   /* U+3C4B */
  0x0002,   /* U+3C4C */
  0x0002,   /* U+3C4D */
  0x0002,   /* U+3C4E */
  0x0002,   /* U+3C4F */
  0x0002,   /* U+3C50 */
  0x0002,   /* U+3C51 */
  0x0002,   /* U+3C52 */
  0x0002,   /* U+3C53 */
  0x0002,   /* U+3C54 */
  0x0002,   /* U+3C55 */
  0x0002,   /* U+3C56 */
  0x0002,   /* U+3C57 */
  0x0002,   /* U+3C58 */
  0x0002,   /* U+3C59 */
  0x0002,   /* U+3C5A */
  0x0002,   /* U+3C5B */
  0x0002,   /* U+3C5C */
  0x0002,   /* U+3C5D */
  0x0002,   /* U+3C5E */
  0x0002,   /* U+3C5F */
  0x0002,   /* U+3C60 */
  0x0002,   /* U+3C61 */
  0x0002,   /* U+3C62 */
  0x0002,   /* U+3C63 */
  0x0002,   /* U+3C64 */
  0x0002,   /* U+3C65 */
  0x0002,   /* U+3C66 */
  0x0002,   /* U+3C67 */
  0x0002,   /* U+3C68 */
  0x0002,   /* U+3C69 */
  0x0002,   /* U+3C6A */
  0x0002,   /* U+3C6B */
  0x0002,   /* U+3C6C */
  0x0002,   /* U+3C6D */
  0x0002,   /* U+3C6E */
  0x0002,   /* U+3C6F */
  0x0002,   /* U+3C70 */
  0x0002,   /* U+3C71 */
  0x0002,   /* U+3C72 */
  0x0002,   /* U+3C73 */
  0x0002,   /* U+3C74 */
  0x0002,   /* U+3C75 */
  0x0002,   /* U+3C76 */
  0x0002,   /* U+3C77 */
  0x0002,   /* U+3C78 */
  0x0002,   /* U+3C79 */
  0x0002,   /* U+3C7A */
  0x0002,   /* U+3C7B */
  0x0002,   /* U+3C7C */
  0x0002,   /* U+3C7D */
  0x0002,   /* U+3C7E */
  0x0002,   /* U+3C7F */
  0x0002,   /* U+3C80 */
  0x0002,   /* U+3C81 */
  0x0002,   /* U+3C82 */
  0x0002,   /* U+3C83 */
  0x0002,   /* U+3C84 */
  0x0002,   /* U+3C85 */
  0x0002,   /* U+3C86 */
  0x0002,   /* U+3C87 */
  0x0002,   /* U+3C88 */
  0x0002,   /* U+3C89 */
  0x0002,   /* U+3C8A */
  0x0002,   /* U+3C8B */
  0x0002,   /* U+3C8C */
  0x0002,   /* U+3C8D */
  0x0002,   /* U+3C8E */
  0x0002,   /* U+3C8F */
  0x0002,   /* U+3C90 */
  0x0002,   /* U+3C91 */
  0x0002,   /* U+3C92 */
  0x0002,   /* U+3C93 */
  0x0002,   /* U+3C94 */
  0x0002,   /* U+3C95 */
  0x0002,   /* U+3C96 */
  0x0002,   /* U+3C97 */
  0x0002,   /* U+3C98 */
  0x0002,   /* U+3C99 */
  0x0002,   /* U+3C9A */
  0x0002,   /* U+3C9B */
  0x0002,   /* U+3C9C */
  0x0002,   /* U+3C9D */
  0x0002,   /* U+3C9E */
  0x0002,   /* U+3C9F */
  0x0002,   /* U+3CA0 */
  0x0002,   /* U+3CA1 */
  0x0002,   /* U+3CA2 */
  0x0002,   /* U+3CA3 */
  0x0002,   /* U+3CA4 */
  0x0002,   /* U+3CA5 */
  0x0002,   /* U+3CA6 */
  0x0002,   /* U+3CA7 */
  0x0002,   /* U+3CA8 */
  0x0002,   /* U+3CA9 */
  0x0002,   /* U+3CAA */
  0x0002,   /* U+3CAB */
  0x0002,   /* U+3CAC */
  0x0002,   /* U+3CAD */
  0x0002,   /* U+3CAE */
  0x0002,   /* U+3CAF */
  0x0002,   /* U+3CB0 */
  0x0002,   /* U+3CB1 */
  0x0002,   /* U+3CB2 */
  0x0002,   /* U+3CB3 */
  0x0002,   /* U+3CB4 */
  0x0002,   /* U+3CB5 */
  0x0002,   /* U+3CB6 */
  0x0002,   /* U+3CB7 */
  0x0002,   /* U+3CB8 */
  0x0002,   /* U+3CB9 */
  0x0002,   /* U+3CBA */
  0x0002,   /* U+3CBB */
  0x0002,   /* U+3CBC */
  0x0002,   /* U+3CBD */
  0x0002,   /* U+3CBE */
  0x0002,   /* U+3CBF */
  0x0002,   /* U+3CC0 */
  0x0002,   /* U+3CC1 */
  0x0002,   /* U+3CC2 */
  0x0002,   /* U+3CC3 */
  0x0002,   /* U+3CC4 */
  0x0002,   /* U+3CC5 */
  0x0002,   /* U+3CC6 */
  0x0002,   /* U+3CC7 */
  0x0002,   /* U+3CC8 */
  0x0002,   /* U+3CC9 */
  0x0002,   /* U+3CCA */
  0x0002,   /* U+3CCB */
  0x0002,   /* U+3CCC */
  0x0002,   /* U+3CCD */
  0x0002,   /* U+3CCE */
  0x0002,   /* U+3CCF */
  0x0002,   /* U+3CD0 */
  0x0002,   /* U+3CD1 */
  0x0002,   /* U+3CD2 */
  0x0002,   /* U+3CD3 */
  0x0002,   /* U+3CD4 */
  0x0002,   /* U+3CD5 */
  0x0002,   /* U+3CD6 */
  0x0002,   /* U+3CD7 */
  0x0002,   /* U+3CD8 */
  0x0002,   /* U+3CD9 */
  0x0002,   /* U+3CDA */
  0x0002,   /* U+3CDB */
  0x0002,   /* U+3CDC */
  0x0002,   /* U+3CDD */
  0x0002,   /* U+3CDE */
  0x0002,   /* U+3CDF */
  0x0002,   /* U+3CE0 */
  0x0002,   /* U+3CE1 */
  0x0002,   /* U+3CE2 */
  0x0002,   /* U+3CE3 */
  0x0002,   /* U+3CE4 */
  0x0002,   /* U+3CE5 */
  0x0002,   /* U+3CE6 */
  0x0002,   /* U+3CE7 */
  0x0002,   /* U+3CE8 */
  0x0002,   /* U+3CE9 */
  0x0002,   /* U+3CEA */
  0x0002,   /* U+3CEB */
  0x0002,   /* U+3CEC */
  0x0002,   /* U+3CED */
  0x0002,   /* U+3CEE */
  0x0002,   /* U+3CEF */
  0x0002,   /* U+3CF0 */
  0x0002,   /* U+3CF1 */
  0x0002,   /* U+3CF2 */
  0x0002,   /* U+3CF3 */
  0x0002,   /* U+3CF4 */
  0x0002,   /* U+3CF5 */
  0x0002,   /* U+3CF6 */
  0x0002,   /* U+3CF7 */
  0x0002,   /* U+3CF8 */
  0x0002,   /* U+3CF9 */
  0x0002,   /* U+3CFA */
  0x0002,   /* U+3CFB */
  0x0002,   /* U+3CFC */
  0x0002,   /* U+3CFD */
  0x0002,   /* U+3CFE */
  0x0002,   /* U+3CFF */

  /* Primary weight 2 for each character. */
  0x82A2,   /* U+3C00 */
  0x82A3,   /* U+3C01 */
  0x82A4,   /* U+3C02 */
  0x82A5,   /* U+3C03 */
  0x82A6,   /* U+3C04 */
  0x82A7,   /* U+3C05 */
  0x82A8,   /* U+3C06 */
  0x82A9,   /* U+3C07 */
  0x82AA,   /* U+3C08 */
  0x81CB,   /* U+3C09 */
  0x81CC,   /* U+3C0A */
  0x81CD,   /* U+3C0B */
  0x81CE,   /* U+3C0C */
  0x81CF,   /* U+3C0D */
  0x81D0,   /* U+3C0E */
  0x81D1,   /* U+3C0F */
  0x81D2,   /* U+3C10 */
  0x81D3,   /* U+3C11 */
  0x81D4,   /* U+3C12 */
  0x81D5,   /* U+3C13 */
  0x8162,   /* U+3C14 */
  0x8163,   /* U+3C15 */
  0x81D6,   /* U+3C16 */
  0x8114,   /* U+3C17 */
  0x8115,   /* U+3C18 */
  0x80A9,   /* U+3C19 */
  0x80AA,   /* U+3C1A */
  0x80AB,   /* U+3C1B */
  0x80AC,   /* U+3C1C */
  0x8799,   /* U+3C1D */
  0x879A,   /* U+3C1E */
  0x8952,   /* U+3C1F */
  0x8953,   /* U+3C20 */
  0x8954,   /* U+3C21 */
  0x8955,   /* U+3C22 */
  0x8A33,   /* U+3C23 */
  0x8A34,   /* U+3C24 */
  0x8A35,   /* U+3C25 */
  0x8A36,   /* U+3C26 */
  0x8A37,   /* U+3C27 */
  0x8A38,   /* U+3C28 */
  0x8B63,   /* U+3C29 */
  0x8B64,   /* U+3C2A */
  0x8B65,   /* U+3C2B */
  0x8B66,   /* U+3C2C */
  0x8B67,   /* U+3C2D */
  0x8BE7,   /* U+3C2E */
  0x8BE8,   /* U+3C2F */
  0x8BE9,   /* U+3C30 */
  0x8BEA,   /* U+3C31 */
  0x8C55,   /* U+3C32 */
  0x8C56,   /* U+3C33 */
  0x8C57,   /* U+3C34 */
  0x8C58,   /* U+3C35 */
  0x8C59,   /* U+3C36 */
  0x8B9F,   /* U+3C37 */
  0x8C5A,   /* U+3C38 */
  0x8A87,   /* U+3C39 */
  0x8A88,   /* U+3C3A */
  0x8A89,   /* U+3C3B */
  0x8A8A,   /* U+3C3C */
  0x8A8B,   /* U+3C3D */
  0x8A8C,   /* U+3C3E */
  0x89FA,   /* U+3C3F */
  0x89FB,   /* U+3C40 */
  0x89FC,   /* U+3C41 */
  0x88D2,   /* U+3C42 */
  0x88D3,   /* U+3C43 */
  0x8709,   /* U+3C44 */
  0x870A,   /* U+3C45 */
  0x84A7,   /* U+3C46 */
  0x84A8,   /* U+3C47 */
  0x84A9,   /* U+3C48 */
  0x84AA,   /* U+3C49 */
  0x8303,   /* U+3C4A */
  0x8213,   /* U+3C4B */
  0x813E,   /* U+3C4C */
  0x80C9,   /* U+3C4D */
  0x805F,   /* U+3C4E */
  0x84F7,   /* U+3C4F */
  0x87A6,   /* U+3C50 */
  0x87A7,   /* U+3C51 */
  0x8A50,   /* U+3C52 */
  0x8A51,   /* U+3C53 */
  0x8A52,   /* U+3C54 */
  0x8C7B,   /* U+3C55 */
  0x8C7C,   /* U+3C56 */
  0x8A1C,   /* U+3C57 */
  0x8416,   /* U+3C58 */
  0x8501,   /* U+3C59 */
  0x8991,   /* U+3C5A */
  0x8992,   /* U+3C5B */
  0x8993,   /* U+3C5C */
  0x8994,   /* U+3C5D */
  0x8A65,   /* U+3C5E */
  0x8A66,   /* U+3C5F */
  0x8A67,   /* U+3C60 */
  0x8BA0,   /* U+3C61 */
  0x8C19,   /* U+3C62 */
  0x8C1A,   /* U+3C63 */
  0x8C9E,   /* U+3C64 */
  0x8C9F,   /* U+3C65 */
  0x8CA0,   /* U+3C66 */
  0x8CA1,   /* U+3C67 */
  0x8CA2,   /* U+3C68 */
  0x8CA3,   /* U+3C69 */
  0x8AC7,   /* U+3C6A */
  0x8AC8,   /* U+3C6B */
  0x8AC9,   /* U+3C6C */
  0x8ACA,   /* U+3C6D */
  0x8ACB,   /* U+3C6E */
  0x8A2D,   /* U+3C6F */
  0x8A2E,   /* U+3C70 */
  0x8A2F,   /* U+3C71 */
  0x8A30,   /* U+3C72 */
  0x88FF,   /* U+3C73 */
  0x8900,   /* U+3C74 */
  0x872C,   /* U+3C75 */
  0x872D,   /* U+3C76 */
  0x872E,   /* U+3C77 */
  0x84C2,   /* U+3C78 */
  0x821A,   /* U+3C79 */
  0x821B,   /* U+3C7A */
  0x80CD,   /* U+3C7B */
  0x87C0,   /* U+3C7C */
  0x89AE,   /* U+3C7D */
  0x8BC5,   /* U+3C7E */
  0x8BC6,   /* U+3C7F */
  0x8C39,   /* U+3C80 */
  0x8CC6,   /* U+3C81 */
  0x8CC7,   /* U+3C82 */
  0x8CC8,   /* U+3C83 */
  0x8AE7,   /* U+3C84 */
  0x8A3E,   /* U+3C85 */
  0x8741,   /* U+3C86 */
  0x8742,   /* U+3C87 */
  0x8743,   /* U+3C88 */
  0x84CC,   /* U+3C89 */
  0x842B,   /* U+3C8A */
  0x8A92,   /* U+3C8B */
  0x850D,   /* U+3C8C */
  0x89C0,   /* U+3C8D */
  0x89C1,   /* U+3C8E */
  0x89C2,   /* U+3C8F */
  0x89C3,   /* U+3C90 */
  0x89C4,   /* U+3C91 */
  0x8A96,   /* U+3C92 */
  0x8BE5,   /* U+3C93 */
  0x8C5C,   /* U+3C94 */
  0x8C5D,   /* U+3C95 */
  0x8C5E,   /* U+3C96 */
  0x8C5F,   /* U+3C97 */
  0x8C60,   /* U+3C98 */
  0x8C61,   /* U+3C99 */
  0x8C62,   /* U+3C9A */
  0x8CE5,   /* U+3C9B */
  0x8CE6,   /* U+3C9C */
  0x8CE7,   /* U+3C9D */
  0x8CE8,   /* U+3C9E */
  0x8B0C,   /* U+3C9F */
  0x8B0D,   /* U+3CA0 */
  0x8B0E,   /* U+3CA1 */
  0x8B0F,   /* U+3CA2 */
  0x8B10,   /* U+3CA3 */
  0x8A55,   /* U+3CA4 */
  0x8A56,   /* U+3CA5 */
  0x8A57,   /* U+3CA6 */
  0x8A58,   /* U+3CA7 */
  0x8A59,   /* U+3CA8 */
  0x8A5A,   /* U+3CA9 */
  0x8763,   /* U+3CAA */
  0x8764,   /* U+3CAB */
  0x8765,   /* U+3CAC */
  0x8766,   /* U+3CAD */
  0x8767,   /* U+3CAE */
  0x8438,   /* U+3CAF */
  0x8439,   /* U+3CB0 */
  0x8320,   /* U+3CB1 */
  0x8040,   /* U+3CB2 */
  0x8C00,   /* U+3CB3 */
  0x89E7,   /* U+3CB4 */
  0x8C8A,   /* U+3CB5 */
  0x8946,   /* U+3CB6 */
  0x8780,   /* U+3CB7 */
  0x819C,   /* U+3CB8 */
  0x82C6,   /* U+3CB9 */
  0x82C7,   /* U+3CBA */
  0x851F,   /* U+3CBB */
  0x82C8,   /* U+3CBC */
  0x8539,   /* U+3CBD */
  0x87DD,   /* U+3CBE */
  0x853A,   /* U+3CBF */
  0x8820,   /* U+3CC0 */
  0x8821,   /* U+3CC1 */
  0x8822,   /* U+3CC2 */
  0x8823,   /* U+3CC3 */
  0x8824,   /* U+3CC4 */
  0x8825,   /* U+3CC5 */
  0x8826,   /* U+3CC6 */
  0x8827,   /* U+3CC7 */
  0x8828,   /* U+3CC8 */
  0x8829,   /* U+3CC9 */
  0x882A,   /* U+3CCA */
  0x8A44,   /* U+3CCB */
  0x8A45,   /* U+3CCC */
  0x8A46,   /* U+3CCD */
  0x8A47,   /* U+3CCE */
  0x8A48,   /* U+3CCF */
  0x8A49,   /* U+3CD0 */
  0x8A4A,   /* U+3CD1 */
  0x8A4B,   /* U+3CD2 */
  0x8A4C,   /* U+3CD3 */
  0x8A4D,   /* U+3CD4 */
  0x8A4E,   /* U+3CD5 */
  0x8B39,   /* U+3CD6 */
  0x8B3A,   /* U+3CD7 */
  0x8B3B,   /* U+3CD8 */
  0x8B3C,   /* U+3CD9 */
  0x8B3D,   /* U+3CDA */
  0x8B3E,   /* U+3CDB */
  0x8B3F,   /* U+3CDC */
  0x8B40,   /* U+3CDD */
  0x8B41,   /* U+3CDE */
  0x8C8E,   /* U+3CDF */
  0x8B42,   /* U+3CE0 */
  0x8B43,   /* U+3CE1 */
  0x8B44,   /* U+3CE2 */
  0x8B45,   /* U+3CE3 */
  0x8C6A,   /* U+3CE4 */
  0x8C6B,   /* U+3CE5 */
  0x8C6C,   /* U+3CE6 */
  0x8C6D,   /* U+3CE7 */
  0x8C6E,   /* U+3CE8 */
  0x8C6F,   /* U+3CE9 */
  0x8C70,   /* U+3CEA */
  0x8C90,   /* U+3CEB */
  0x8C71,   /* U+3CEC */
  0x8C72,   /* U+3CED */
  0x8C73,   /* U+3CEE */
  0x8C74,   /* U+3CEF */
  0x8C75,   /* U+3CF0 */
  0x8C76,   /* U+3CF1 */
  0x8C77,   /* U+3CF2 */
  0x8C78,   /* U+3CF3 */
  0x8D00,   /* U+3CF4 */
  0x8D01,   /* U+3CF5 */
  0x8D02,   /* U+3CF6 */
  0x8D03,   /* U+3CF7 */
  0x8D04,   /* U+3CF8 */
  0x8D05,   /* U+3CF9 */
  0x8D06,   /* U+3CFA */
  0x8D07,   /* U+3CFB */
  0x8D20,   /* U+3CFC */
  0x8D08,   /* U+3CFD */
  0x8D09,   /* U+3CFE */
  0x8D0A,   /* U+3CFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3C00 */
  0x0000,   /* U+3C01 */
  0x0000,   /* U+3C02 */
  0x0000,   /* U+3C03 */
  0x0000,   /* U+3C04 */
  0x0000,   /* U+3C05 */
  0x0000,   /* U+3C06 */
  0x0000,   /* U+3C07 */
  0x0000,   /* U+3C08 */
  0x0000,   /* U+3C09 */
  0x0000,   /* U+3C0A */
  0x0000,   /* U+3C0B */
  0x0000,   /* U+3C0C */
  0x0000,   /* U+3C0D */
  0x0000,   /* U+3C0E */
  0x0000,   /* U+3C0F */
  0x0000,   /* U+3C10 */
  0x0000,   /* U+3C11 */
  0x0000,   /* U+3C12 */
  0x0000,   /* U+3C13 */
  0x0000,   /* U+3C14 */
  0x0000,   /* U+3C15 */
  0x0000,   /* U+3C16 */
  0x0000,   /* U+3C17 */
  0x0000,   /* U+3C18 */
  0x0000,   /* U+3C19 */
  0x0000,   /* U+3C1A */
  0x0000,   /* U+3C1B */
  0x0000,   /* U+3C1C */
  0x0000,   /* U+3C1D */
  0x0000,   /* U+3C1E */
  0x0000,   /* U+3C1F */
  0x0000,   /* U+3C20 */
  0x0000,   /* U+3C21 */
  0x0000,   /* U+3C22 */
  0x0000,   /* U+3C23 */
  0x0000,   /* U+3C24 */
  0x0000,   /* U+3C25 */
  0x0000,   /* U+3C26 */
  0x0000,   /* U+3C27 */
  0x0000,   /* U+3C28 */
  0x0000,   /* U+3C29 */
  0x0000,   /* U+3C2A */
  0x0000,   /* U+3C2B */
  0x0000,   /* U+3C2C */
  0x0000,   /* U+3C2D */
  0x0000,   /* U+3C2E */
  0x0000,   /* U+3C2F */
  0x0000,   /* U+3C30 */
  0x0000,   /* U+3C31 */
  0x0000,   /* U+3C32 */
  0x0000,   /* U+3C33 */
  0x0000,   /* U+3C34 */
  0x0000,   /* U+3C35 */
  0x0000,   /* U+3C36 */
  0x0000,   /* U+3C37 */
  0x0000,   /* U+3C38 */
  0x0000,   /* U+3C39 */
  0x0000,   /* U+3C3A */
  0x0000,   /* U+3C3B */
  0x0000,   /* U+3C3C */
  0x0000,   /* U+3C3D */
  0x0000,   /* U+3C3E */
  0x0000,   /* U+3C3F */
  0x0000,   /* U+3C40 */
  0x0000,   /* U+3C41 */
  0x0000,   /* U+3C42 */
  0x0000,   /* U+3C43 */
  0x0000,   /* U+3C44 */
  0x0000,   /* U+3C45 */
  0x0000,   /* U+3C46 */
  0x0000,   /* U+3C47 */
  0x0000,   /* U+3C48 */
  0x0000,   /* U+3C49 */
  0x0000,   /* U+3C4A */
  0x0000,   /* U+3C4B */
  0x0000,   /* U+3C4C */
  0x0000,   /* U+3C4D */
  0x0000,   /* U+3C4E */
  0x0000,   /* U+3C4F */
  0x0000,   /* U+3C50 */
  0x0000,   /* U+3C51 */
  0x0000,   /* U+3C52 */
  0x0000,   /* U+3C53 */
  0x0000,   /* U+3C54 */
  0x0000,   /* U+3C55 */
  0x0000,   /* U+3C56 */
  0x0000,   /* U+3C57 */
  0x0000,   /* U+3C58 */
  0x0000,   /* U+3C59 */
  0x0000,   /* U+3C5A */
  0x0000,   /* U+3C5B */
  0x0000,   /* U+3C5C */
  0x0000,   /* U+3C5D */
  0x0000,   /* U+3C5E */
  0x0000,   /* U+3C5F */
  0x0000,   /* U+3C60 */
  0x0000,   /* U+3C61 */
  0x0000,   /* U+3C62 */
  0x0000,   /* U+3C63 */
  0x0000,   /* U+3C64 */
  0x0000,   /* U+3C65 */
  0x0000,   /* U+3C66 */
  0x0000,   /* U+3C67 */
  0x0000,   /* U+3C68 */
  0x0000,   /* U+3C69 */
  0x0000,   /* U+3C6A */
  0x0000,   /* U+3C6B */
  0x0000,   /* U+3C6C */
  0x0000,   /* U+3C6D */
  0x0000,   /* U+3C6E */
  0x0000,   /* U+3C6F */
  0x0000,   /* U+3C70 */
  0x0000,   /* U+3C71 */
  0x0000,   /* U+3C72 */
  0x0000,   /* U+3C73 */
  0x0000,   /* U+3C74 */
  0x0000,   /* U+3C75 */
  0x0000,   /* U+3C76 */
  0x0000,   /* U+3C77 */
  0x0000,   /* U+3C78 */
  0x0000,   /* U+3C79 */
  0x0000,   /* U+3C7A */
  0x0000,   /* U+3C7B */
  0x0000,   /* U+3C7C */
  0x0000,   /* U+3C7D */
  0x0000,   /* U+3C7E */
  0x0000,   /* U+3C7F */
  0x0000,   /* U+3C80 */
  0x0000,   /* U+3C81 */
  0x0000,   /* U+3C82 */
  0x0000,   /* U+3C83 */
  0x0000,   /* U+3C84 */
  0x0000,   /* U+3C85 */
  0x0000,   /* U+3C86 */
  0x0000,   /* U+3C87 */
  0x0000,   /* U+3C88 */
  0x0000,   /* U+3C89 */
  0x0000,   /* U+3C8A */
  0x0000,   /* U+3C8B */
  0x0000,   /* U+3C8C */
  0x0000,   /* U+3C8D */
  0x0000,   /* U+3C8E */
  0x0000,   /* U+3C8F */
  0x0000,   /* U+3C90 */
  0x0000,   /* U+3C91 */
  0x0000,   /* U+3C92 */
  0x0000,   /* U+3C93 */
  0x0000,   /* U+3C94 */
  0x0000,   /* U+3C95 */
  0x0000,   /* U+3C96 */
  0x0000,   /* U+3C97 */
  0x0000,   /* U+3C98 */
  0x0000,   /* U+3C99 */
  0x0000,   /* U+3C9A */
  0x0000,   /* U+3C9B */
  0x0000,   /* U+3C9C */
  0x0000,   /* U+3C9D */
  0x0000,   /* U+3C9E */
  0x0000,   /* U+3C9F */
  0x0000,   /* U+3CA0 */
  0x0000,   /* U+3CA1 */
  0x0000,   /* U+3CA2 */
  0x0000,   /* U+3CA3 */
  0x0000,   /* U+3CA4 */
  0x0000,   /* U+3CA5 */
  0x0000,   /* U+3CA6 */
  0x0000,   /* U+3CA7 */
  0x0000,   /* U+3CA8 */
  0x0000,   /* U+3CA9 */
  0x0000,   /* U+3CAA */
  0x0000,   /* U+3CAB */
  0x0000,   /* U+3CAC */
  0x0000,   /* U+3CAD */
  0x0000,   /* U+3CAE */
  0x0000,   /* U+3CAF */
  0x0000,   /* U+3CB0 */
  0x0000,   /* U+3CB1 */
  0x0000,   /* U+3CB2 */
  0x0000,   /* U+3CB3 */
  0x0000,   /* U+3CB4 */
  0x0000,   /* U+3CB5 */
  0x0000,   /* U+3CB6 */
  0x0000,   /* U+3CB7 */
  0x0000,   /* U+3CB8 */
  0x0000,   /* U+3CB9 */
  0x0000,   /* U+3CBA */
  0x0000,   /* U+3CBB */
  0x0000,   /* U+3CBC */
  0x0000,   /* U+3CBD */
  0x0000,   /* U+3CBE */
  0x0000,   /* U+3CBF */
  0x0000,   /* U+3CC0 */
  0x0000,   /* U+3CC1 */
  0x0000,   /* U+3CC2 */
  0x0000,   /* U+3CC3 */
  0x0000,   /* U+3CC4 */
  0x0000,   /* U+3CC5 */
  0x0000,   /* U+3CC6 */
  0x0000,   /* U+3CC7 */
  0x0000,   /* U+3CC8 */
  0x0000,   /* U+3CC9 */
  0x0000,   /* U+3CCA */
  0x0000,   /* U+3CCB */
  0x0000,   /* U+3CCC */
  0x0000,   /* U+3CCD */
  0x0000,   /* U+3CCE */
  0x0000,   /* U+3CCF */
  0x0000,   /* U+3CD0 */
  0x0000,   /* U+3CD1 */
  0x0000,   /* U+3CD2 */
  0x0000,   /* U+3CD3 */
  0x0000,   /* U+3CD4 */
  0x0000,   /* U+3CD5 */
  0x0000,   /* U+3CD6 */
  0x0000,   /* U+3CD7 */
  0x0000,   /* U+3CD8 */
  0x0000,   /* U+3CD9 */
  0x0000,   /* U+3CDA */
  0x0000,   /* U+3CDB */
  0x0000,   /* U+3CDC */
  0x0000,   /* U+3CDD */
  0x0000,   /* U+3CDE */
  0x0000,   /* U+3CDF */
  0x0000,   /* U+3CE0 */
  0x0000,   /* U+3CE1 */
  0x0000,   /* U+3CE2 */
  0x0000,   /* U+3CE3 */
  0x0000,   /* U+3CE4 */
  0x0000,   /* U+3CE5 */
  0x0000,   /* U+3CE6 */
  0x0000,   /* U+3CE7 */
  0x0000,   /* U+3CE8 */
  0x0000,   /* U+3CE9 */
  0x0000,   /* U+3CEA */
  0x0000,   /* U+3CEB */
  0x0000,   /* U+3CEC */
  0x0000,   /* U+3CED */
  0x0000,   /* U+3CEE */
  0x0000,   /* U+3CEF */
  0x0000,   /* U+3CF0 */
  0x0000,   /* U+3CF1 */
  0x0000,   /* U+3CF2 */
  0x0000,   /* U+3CF3 */
  0x0000,   /* U+3CF4 */
  0x0000,   /* U+3CF5 */
  0x0000,   /* U+3CF6 */
  0x0000,   /* U+3CF7 */
  0x0000,   /* U+3CF8 */
  0x0000,   /* U+3CF9 */
  0x0000,   /* U+3CFA */
  0x0000,   /* U+3CFB */
  0x0000,   /* U+3CFC */
  0x0000,   /* U+3CFD */
  0x0000,   /* U+3CFE */
  0x0000,   /* U+3CFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3C00 */
  0x0000,   /* U+3C01 */
  0x0000,   /* U+3C02 */
  0x0000,   /* U+3C03 */
  0x0000,   /* U+3C04 */
  0x0000,   /* U+3C05 */
  0x0000,   /* U+3C06 */
  0x0000,   /* U+3C07 */
  0x0000,   /* U+3C08 */
  0x0000,   /* U+3C09 */
  0x0000,   /* U+3C0A */
  0x0000,   /* U+3C0B */
  0x0000,   /* U+3C0C */
  0x0000,   /* U+3C0D */
  0x0000,   /* U+3C0E */
  0x0000,   /* U+3C0F */
  0x0000,   /* U+3C10 */
  0x0000,   /* U+3C11 */
  0x0000,   /* U+3C12 */
  0x0000,   /* U+3C13 */
  0x0000,   /* U+3C14 */
  0x0000,   /* U+3C15 */
  0x0000,   /* U+3C16 */
  0x0000,   /* U+3C17 */
  0x0000,   /* U+3C18 */
  0x0000,   /* U+3C19 */
  0x0000,   /* U+3C1A */
  0x0000,   /* U+3C1B */
  0x0000,   /* U+3C1C */
  0x0000,   /* U+3C1D */
  0x0000,   /* U+3C1E */
  0x0000,   /* U+3C1F */
  0x0000,   /* U+3C20 */
  0x0000,   /* U+3C21 */
  0x0000,   /* U+3C22 */
  0x0000,   /* U+3C23 */
  0x0000,   /* U+3C24 */
  0x0000,   /* U+3C25 */
  0x0000,   /* U+3C26 */
  0x0000,   /* U+3C27 */
  0x0000,   /* U+3C28 */
  0x0000,   /* U+3C29 */
  0x0000,   /* U+3C2A */
  0x0000,   /* U+3C2B */
  0x0000,   /* U+3C2C */
  0x0000,   /* U+3C2D */
  0x0000,   /* U+3C2E */
  0x0000,   /* U+3C2F */
  0x0000,   /* U+3C30 */
  0x0000,   /* U+3C31 */
  0x0000,   /* U+3C32 */
  0x0000,   /* U+3C33 */
  0x0000,   /* U+3C34 */
  0x0000,   /* U+3C35 */
  0x0000,   /* U+3C36 */
  0x0000,   /* U+3C37 */
  0x0000,   /* U+3C38 */
  0x0000,   /* U+3C39 */
  0x0000,   /* U+3C3A */
  0x0000,   /* U+3C3B */
  0x0000,   /* U+3C3C */
  0x0000,   /* U+3C3D */
  0x0000,   /* U+3C3E */
  0x0000,   /* U+3C3F */
  0x0000,   /* U+3C40 */
  0x0000,   /* U+3C41 */
  0x0000,   /* U+3C42 */
  0x0000,   /* U+3C43 */
  0x0000,   /* U+3C44 */
  0x0000,   /* U+3C45 */
  0x0000,   /* U+3C46 */
  0x0000,   /* U+3C47 */
  0x0000,   /* U+3C48 */
  0x0000,   /* U+3C49 */
  0x0000,   /* U+3C4A */
  0x0000,   /* U+3C4B */
  0x0000,   /* U+3C4C */
  0x0000,   /* U+3C4D */
  0x0000,   /* U+3C4E */
  0x0000,   /* U+3C4F */
  0x0000,   /* U+3C50 */
  0x0000,   /* U+3C51 */
  0x0000,   /* U+3C52 */
  0x0000,   /* U+3C53 */
  0x0000,   /* U+3C54 */
  0x0000,   /* U+3C55 */
  0x0000,   /* U+3C56 */
  0x0000,   /* U+3C57 */
  0x0000,   /* U+3C58 */
  0x0000,   /* U+3C59 */
  0x0000,   /* U+3C5A */
  0x0000,   /* U+3C5B */
  0x0000,   /* U+3C5C */
  0x0000,   /* U+3C5D */
  0x0000,   /* U+3C5E */
  0x0000,   /* U+3C5F */
  0x0000,   /* U+3C60 */
  0x0000,   /* U+3C61 */
  0x0000,   /* U+3C62 */
  0x0000,   /* U+3C63 */
  0x0000,   /* U+3C64 */
  0x0000,   /* U+3C65 */
  0x0000,   /* U+3C66 */
  0x0000,   /* U+3C67 */
  0x0000,   /* U+3C68 */
  0x0000,   /* U+3C69 */
  0x0000,   /* U+3C6A */
  0x0000,   /* U+3C6B */
  0x0000,   /* U+3C6C */
  0x0000,   /* U+3C6D */
  0x0000,   /* U+3C6E */
  0x0000,   /* U+3C6F */
  0x0000,   /* U+3C70 */
  0x0000,   /* U+3C71 */
  0x0000,   /* U+3C72 */
  0x0000,   /* U+3C73 */
  0x0000,   /* U+3C74 */
  0x0000,   /* U+3C75 */
  0x0000,   /* U+3C76 */
  0x0000,   /* U+3C77 */
  0x0000,   /* U+3C78 */
  0x0000,   /* U+3C79 */
  0x0000,   /* U+3C7A */
  0x0000,   /* U+3C7B */
  0x0000,   /* U+3C7C */
  0x0000,   /* U+3C7D */
  0x0000,   /* U+3C7E */
  0x0000,   /* U+3C7F */
  0x0000,   /* U+3C80 */
  0x0000,   /* U+3C81 */
  0x0000,   /* U+3C82 */
  0x0000,   /* U+3C83 */
  0x0000,   /* U+3C84 */
  0x0000,   /* U+3C85 */
  0x0000,   /* U+3C86 */
  0x0000,   /* U+3C87 */
  0x0000,   /* U+3C88 */
  0x0000,   /* U+3C89 */
  0x0000,   /* U+3C8A */
  0x0000,   /* U+3C8B */
  0x0000,   /* U+3C8C */
  0x0000,   /* U+3C8D */
  0x0000,   /* U+3C8E */
  0x0000,   /* U+3C8F */
  0x0000,   /* U+3C90 */
  0x0000,   /* U+3C91 */
  0x0000,   /* U+3C92 */
  0x0000,   /* U+3C93 */
  0x0000,   /* U+3C94 */
  0x0000,   /* U+3C95 */
  0x0000,   /* U+3C96 */
  0x0000,   /* U+3C97 */
  0x0000,   /* U+3C98 */
  0x0000,   /* U+3C99 */
  0x0000,   /* U+3C9A */
  0x0000,   /* U+3C9B */
  0x0000,   /* U+3C9C */
  0x0000,   /* U+3C9D */
  0x0000,   /* U+3C9E */
  0x0000,   /* U+3C9F */
  0x0000,   /* U+3CA0 */
  0x0000,   /* U+3CA1 */
  0x0000,   /* U+3CA2 */
  0x0000,   /* U+3CA3 */
  0x0000,   /* U+3CA4 */
  0x0000,   /* U+3CA5 */
  0x0000,   /* U+3CA6 */
  0x0000,   /* U+3CA7 */
  0x0000,   /* U+3CA8 */
  0x0000,   /* U+3CA9 */
  0x0000,   /* U+3CAA */
  0x0000,   /* U+3CAB */
  0x0000,   /* U+3CAC */
  0x0000,   /* U+3CAD */
  0x0000,   /* U+3CAE */
  0x0000,   /* U+3CAF */
  0x0000,   /* U+3CB0 */
  0x0000,   /* U+3CB1 */
  0x0000,   /* U+3CB2 */
  0x0000,   /* U+3CB3 */
  0x0000,   /* U+3CB4 */
  0x0000,   /* U+3CB5 */
  0x0000,   /* U+3CB6 */
  0x0000,   /* U+3CB7 */
  0x0000,   /* U+3CB8 */
  0x0000,   /* U+3CB9 */
  0x0000,   /* U+3CBA */
  0x0000,   /* U+3CBB */
  0x0000,   /* U+3CBC */
  0x0000,   /* U+3CBD */
  0x0000,   /* U+3CBE */
  0x0000,   /* U+3CBF */
  0x0000,   /* U+3CC0 */
  0x0000,   /* U+3CC1 */
  0x0000,   /* U+3CC2 */
  0x0000,   /* U+3CC3 */
  0x0000,   /* U+3CC4 */
  0x0000,   /* U+3CC5 */
  0x0000,   /* U+3CC6 */
  0x0000,   /* U+3CC7 */
  0x0000,   /* U+3CC8 */
  0x0000,   /* U+3CC9 */
  0x0000,   /* U+3CCA */
  0x0000,   /* U+3CCB */
  0x0000,   /* U+3CCC */
  0x0000,   /* U+3CCD */
  0x0000,   /* U+3CCE */
  0x0000,   /* U+3CCF */
  0x0000,   /* U+3CD0 */
  0x0000,   /* U+3CD1 */
  0x0000,   /* U+3CD2 */
  0x0000,   /* U+3CD3 */
  0x0000,   /* U+3CD4 */
  0x0000,   /* U+3CD5 */
  0x0000,   /* U+3CD6 */
  0x0000,   /* U+3CD7 */
  0x0000,   /* U+3CD8 */
  0x0000,   /* U+3CD9 */
  0x0000,   /* U+3CDA */
  0x0000,   /* U+3CDB */
  0x0000,   /* U+3CDC */
  0x0000,   /* U+3CDD */
  0x0000,   /* U+3CDE */
  0x0000,   /* U+3CDF */
  0x0000,   /* U+3CE0 */
  0x0000,   /* U+3CE1 */
  0x0000,   /* U+3CE2 */
  0x0000,   /* U+3CE3 */
  0x0000,   /* U+3CE4 */
  0x0000,   /* U+3CE5 */
  0x0000,   /* U+3CE6 */
  0x0000,   /* U+3CE7 */
  0x0000,   /* U+3CE8 */
  0x0000,   /* U+3CE9 */
  0x0000,   /* U+3CEA */
  0x0000,   /* U+3CEB */
  0x0000,   /* U+3CEC */
  0x0000,   /* U+3CED */
  0x0000,   /* U+3CEE */
  0x0000,   /* U+3CEF */
  0x0000,   /* U+3CF0 */
  0x0000,   /* U+3CF1 */
  0x0000,   /* U+3CF2 */
  0x0000,   /* U+3CF3 */
  0x0000,   /* U+3CF4 */
  0x0000,   /* U+3CF5 */
  0x0000,   /* U+3CF6 */
  0x0000,   /* U+3CF7 */
  0x0000,   /* U+3CF8 */
  0x0000,   /* U+3CF9 */
  0x0000,   /* U+3CFA */
  0x0000,   /* U+3CFB */
  0x0000,   /* U+3CFC */
  0x0000,   /* U+3CFD */
  0x0000,   /* U+3CFE */
  0x0000,   /* U+3CFF */
};

uint16 zh3_han_p03D[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C52,   /* U+3D00 */
  0x1C52,   /* U+3D01 */
  0x1C52,   /* U+3D02 */
  0x1C52,   /* U+3D03 */
  0x1C52,   /* U+3D04 */
  0x1C53,   /* U+3D05 */
  0x1C52,   /* U+3D06 */
  0x1C53,   /* U+3D07 */
  0x1C52,   /* U+3D08 */
  0x1C52,   /* U+3D09 */
  0x1C52,   /* U+3D0A */
  0x1C52,   /* U+3D0B */
  0x1C52,   /* U+3D0C */
  0x1C52,   /* U+3D0D */
  0x1C52,   /* U+3D0E */
  0x1C53,   /* U+3D0F */
  0x1C53,   /* U+3D10 */
  0x1C53,   /* U+3D11 */
  0x1C53,   /* U+3D12 */
  0x1C53,   /* U+3D13 */
  0x1C53,   /* U+3D14 */
  0x1C53,   /* U+3D15 */
  0x1C53,   /* U+3D16 */
  0x1C53,   /* U+3D17 */
  0x1C53,   /* U+3D18 */
  0x1C53,   /* U+3D19 */
  0x1C53,   /* U+3D1A */
  0x1C53,   /* U+3D1B */
  0x1C53,   /* U+3D1C */
  0x1C53,   /* U+3D1D */
  0x1C53,   /* U+3D1E */
  0x1C53,   /* U+3D1F */
  0x1C53,   /* U+3D20 */
  0x1C53,   /* U+3D21 */
  0x1C53,   /* U+3D22 */
  0x1C53,   /* U+3D23 */
  0x1C53,   /* U+3D24 */
  0x1C54,   /* U+3D25 */
  0x1C54,   /* U+3D26 */
  0x1C54,   /* U+3D27 */
  0x1C54,   /* U+3D28 */
  0x1C54,   /* U+3D29 */
  0x1C54,   /* U+3D2A */
  0x1C54,   /* U+3D2B */
  0x1C54,   /* U+3D2C */
  0x1C54,   /* U+3D2D */
  0x1C54,   /* U+3D2E */
  0x1C54,   /* U+3D2F */
  0x1C54,   /* U+3D30 */
  0x1C54,   /* U+3D31 */
  0x1C54,   /* U+3D32 */
  0x1C54,   /* U+3D33 */
  0x1C54,   /* U+3D34 */
  0x1C54,   /* U+3D35 */
  0x1C54,   /* U+3D36 */
  0x1C54,   /* U+3D37 */
  0x1C54,   /* U+3D38 */
  0x1C54,   /* U+3D39 */
  0x1C54,   /* U+3D3A */
  0x1C54,   /* U+3D3B */
  0x1C55,   /* U+3D3C */
  0x1C55,   /* U+3D3D */
  0x1C55,   /* U+3D3E */
  0x1C55,   /* U+3D3F */
  0x1C55,   /* U+3D40 */
  0x1C55,   /* U+3D41 */
  0x1C55,   /* U+3D42 */
  0x1C55,   /* U+3D43 */
  0x1C55,   /* U+3D44 */
  0x1C55,   /* U+3D45 */
  0x1C55,   /* U+3D46 */
  0x1C55,   /* U+3D47 */
  0x1C55,   /* U+3D48 */
  0x1C55,   /* U+3D49 */
  0x1C56,   /* U+3D4A */
  0x1C56,   /* U+3D4B */
  0x1C56,   /* U+3D4C */
  0x1C56,   /* U+3D4D */
  0x1C56,   /* U+3D4E */
  0x1C56,   /* U+3D4F */
  0x1C56,   /* U+3D50 */
  0x1C56,   /* U+3D51 */
  0x1C56,   /* U+3D52 */
  0x1C56,   /* U+3D53 */
  0x1C56,   /* U+3D54 */
  0x1C56,   /* U+3D55 */
  0x1C56,   /* U+3D56 */
  0x1C56,   /* U+3D57 */
  0x1C57,   /* U+3D58 */
  0x1C56,   /* U+3D59 */
  0x1C56,   /* U+3D5A */
  0x1C56,   /* U+3D5B */
  0x1C56,   /* U+3D5C */
  0x1C57,   /* U+3D5D */
  0x1C57,   /* U+3D5E */
  0x1C57,   /* U+3D5F */
  0x1C57,   /* U+3D60 */
  0x1C57,   /* U+3D61 */
  0x1C57,   /* U+3D62 */
  0x1C57,   /* U+3D63 */
  0x1C57,   /* U+3D64 */
  0x1C57,   /* U+3D65 */
  0x1C57,   /* U+3D66 */
  0x1C57,   /* U+3D67 */
  0x1C58,   /* U+3D68 */
  0x1C57,   /* U+3D69 */
  0x1C57,   /* U+3D6A */
  0x1C57,   /* U+3D6B */
  0x1C57,   /* U+3D6C */
  0x1C57,   /* U+3D6D */
  0x1C57,   /* U+3D6E */
  0x1C58,   /* U+3D6F */
  0x1C58,   /* U+3D70 */
  0x1C58,   /* U+3D71 */
  0x1C58,   /* U+3D72 */
  0x1C58,   /* U+3D73 */
  0x1C58,   /* U+3D74 */
  0x1C58,   /* U+3D75 */
  0x1C58,   /* U+3D76 */
  0x1C58,   /* U+3D77 */
  0x1C58,   /* U+3D78 */
  0x1C58,   /* U+3D79 */
  0x1C58,   /* U+3D7A */
  0x1C58,   /* U+3D7B */
  0x1C58,   /* U+3D7C */
  0x1C59,   /* U+3D7D */
  0x1C59,   /* U+3D7E */
  0x1C59,   /* U+3D7F */
  0x1C59,   /* U+3D80 */
  0x1C59,   /* U+3D81 */
  0x1C59,   /* U+3D82 */
  0x1C59,   /* U+3D83 */
  0x1C5A,   /* U+3D84 */
  0x1C5A,   /* U+3D85 */
  0x1C5A,   /* U+3D86 */
  0x1C5A,   /* U+3D87 */
  0x1C5A,   /* U+3D88 */
  0x1C5A,   /* U+3D89 */
  0x1C5A,   /* U+3D8A */
  0x1C5A,   /* U+3D8B */
  0x1C5B,   /* U+3D8C */
  0x1C5B,   /* U+3D8D */
  0x1C5B,   /* U+3D8E */
  0x1C5B,   /* U+3D8F */
  0x1C5B,   /* U+3D90 */
  0x1C5B,   /* U+3D91 */
  0x1C5C,   /* U+3D92 */
  0x1C5C,   /* U+3D93 */
  0x1C5C,   /* U+3D94 */
  0x1C5C,   /* U+3D95 */
  0x1C5C,   /* U+3D96 */
  0x1C5D,   /* U+3D97 */
  0x1C5C,   /* U+3D98 */
  0x1C5D,   /* U+3D99 */
  0x1C5D,   /* U+3D9A */
  0x1C5E,   /* U+3D9B */
  0x1C5E,   /* U+3D9C */
  0x1C5E,   /* U+3D9D */
  0x1C5F,   /* U+3D9E */
  0x1C5F,   /* U+3D9F */
  0x1C61,   /* U+3DA0 */
  0x1C4D,   /* U+3DA1 */
  0x1C4D,   /* U+3DA2 */
  0x1C4E,   /* U+3DA3 */
  0x1C4E,   /* U+3DA4 */
  0x1C4E,   /* U+3DA5 */
  0x1C4F,   /* U+3DA6 */
  0x1C4F,   /* U+3DA7 */
  0x1C4F,   /* U+3DA8 */
  0x1C4F,   /* U+3DA9 */
  0x1C4F,   /* U+3DAA */
  0x1C50,   /* U+3DAB */
  0x1C50,   /* U+3DAC */
  0x1C50,   /* U+3DAD */
  0x1C50,   /* U+3DAE */
  0x1C50,   /* U+3DAF */
  0x1C50,   /* U+3DB0 */
  0x1C50,   /* U+3DB1 */
  0x1C50,   /* U+3DB2 */
  0x1C51,   /* U+3DB3 */
  0x1C51,   /* U+3DB4 */
  0x1C51,   /* U+3DB5 */
  0x1C51,   /* U+3DB6 */
  0x1C51,   /* U+3DB7 */
  0x1C51,   /* U+3DB8 */
  0x1C52,   /* U+3DB9 */
  0x1C52,   /* U+3DBA */
  0x1C52,   /* U+3DBB */
  0x1C52,   /* U+3DBC */
  0x1C52,   /* U+3DBD */
  0x1C52,   /* U+3DBE */
  0x1C52,   /* U+3DBF */
  0x1C52,   /* U+3DC0 */
  0x1C52,   /* U+3DC1 */
  0x1C53,   /* U+3DC2 */
  0x1C53,   /* U+3DC3 */
  0x1C53,   /* U+3DC4 */
  0x1C53,   /* U+3DC5 */
  0x1C53,   /* U+3DC6 */
  0x1C53,   /* U+3DC7 */
  0x1C53,   /* U+3DC8 */
  0x1C53,   /* U+3DC9 */
  0x1C53,   /* U+3DCA */
  0x1C53,   /* U+3DCB */
  0x1C53,   /* U+3DCC */
  0x1C53,   /* U+3DCD */
  0x1C54,   /* U+3DCE */
  0x1C54,   /* U+3DCF */
  0x1C54,   /* U+3DD0 */
  0x1C54,   /* U+3DD1 */
  0x1C54,   /* U+3DD2 */
  0x1C54,   /* U+3DD3 */
  0x1C54,   /* U+3DD4 */
  0x1C54,   /* U+3DD5 */
  0x1C54,   /* U+3DD6 */
  0x1C54,   /* U+3DD7 */
  0x1C54,   /* U+3DD8 */
  0x1C54,   /* U+3DD9 */
  0x1C54,   /* U+3DDA */
  0x1C54,   /* U+3DDB */
  0x1C54,   /* U+3DDC */
  0x1C54,   /* U+3DDD */
  0x1C54,   /* U+3DDE */
  0x1C55,   /* U+3DDF */
  0x1C55,   /* U+3DE0 */
  0x1C55,   /* U+3DE1 */
  0x1C55,   /* U+3DE2 */
  0x1C55,   /* U+3DE3 */
  0x1C55,   /* U+3DE4 */
  0x1C55,   /* U+3DE5 */
  0x1C55,   /* U+3DE6 */
  0x1C55,   /* U+3DE7 */
  0x1C55,   /* U+3DE8 */
  0x1C55,   /* U+3DE9 */
  0x1C55,   /* U+3DEA */
  0x1C56,   /* U+3DEB */
  0x1C56,   /* U+3DEC */
  0x1C56,   /* U+3DED */
  0x1C56,   /* U+3DEE */
  0x1C56,   /* U+3DEF */
  0x1C56,   /* U+3DF0 */
  0x1C56,   /* U+3DF1 */
  0x1C56,   /* U+3DF2 */
  0x1C57,   /* U+3DF3 */
  0x1C57,   /* U+3DF4 */
  0x1C57,   /* U+3DF5 */
  0x1C57,   /* U+3DF6 */
  0x1C57,   /* U+3DF7 */
  0x1C57,   /* U+3DF8 */
  0x1C57,   /* U+3DF9 */
  0x1C57,   /* U+3DFA */
  0x1C57,   /* U+3DFB */
  0x1C57,   /* U+3DFC */
  0x1C57,   /* U+3DFD */
  0x1C58,   /* U+3DFE */
  0x1C58,   /* U+3DFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3D00 */
  0x0020,   /* U+3D01 */
  0x0020,   /* U+3D02 */
  0x0020,   /* U+3D03 */
  0x0020,   /* U+3D04 */
  0x0020,   /* U+3D05 */
  0x0020,   /* U+3D06 */
  0x0020,   /* U+3D07 */
  0x0020,   /* U+3D08 */
  0x0020,   /* U+3D09 */
  0x0020,   /* U+3D0A */
  0x0020,   /* U+3D0B */
  0x0020,   /* U+3D0C */
  0x0020,   /* U+3D0D */
  0x0020,   /* U+3D0E */
  0x0020,   /* U+3D0F */
  0x0020,   /* U+3D10 */
  0x0020,   /* U+3D11 */
  0x0020,   /* U+3D12 */
  0x0020,   /* U+3D13 */
  0x0020,   /* U+3D14 */
  0x0020,   /* U+3D15 */
  0x0020,   /* U+3D16 */
  0x0020,   /* U+3D17 */
  0x0020,   /* U+3D18 */
  0x0020,   /* U+3D19 */
  0x0020,   /* U+3D1A */
  0x0020,   /* U+3D1B */
  0x0020,   /* U+3D1C */
  0x0020,   /* U+3D1D */
  0x0020,   /* U+3D1E */
  0x0020,   /* U+3D1F */
  0x0020,   /* U+3D20 */
  0x0020,   /* U+3D21 */
  0x0020,   /* U+3D22 */
  0x0020,   /* U+3D23 */
  0x0020,   /* U+3D24 */
  0x0020,   /* U+3D25 */
  0x0020,   /* U+3D26 */
  0x0020,   /* U+3D27 */
  0x0020,   /* U+3D28 */
  0x0020,   /* U+3D29 */
  0x0020,   /* U+3D2A */
  0x0020,   /* U+3D2B */
  0x0020,   /* U+3D2C */
  0x0020,   /* U+3D2D */
  0x0020,   /* U+3D2E */
  0x0020,   /* U+3D2F */
  0x0020,   /* U+3D30 */
  0x0020,   /* U+3D31 */
  0x0020,   /* U+3D32 */
  0x0020,   /* U+3D33 */
  0x0020,   /* U+3D34 */
  0x0020,   /* U+3D35 */
  0x0020,   /* U+3D36 */
  0x0020,   /* U+3D37 */
  0x0020,   /* U+3D38 */
  0x0020,   /* U+3D39 */
  0x0020,   /* U+3D3A */
  0x0020,   /* U+3D3B */
  0x0020,   /* U+3D3C */
  0x0020,   /* U+3D3D */
  0x0020,   /* U+3D3E */
  0x0020,   /* U+3D3F */
  0x0020,   /* U+3D40 */
  0x0020,   /* U+3D41 */
  0x0020,   /* U+3D42 */
  0x0020,   /* U+3D43 */
  0x0020,   /* U+3D44 */
  0x0020,   /* U+3D45 */
  0x0020,   /* U+3D46 */
  0x0020,   /* U+3D47 */
  0x0020,   /* U+3D48 */
  0x0020,   /* U+3D49 */
  0x0020,   /* U+3D4A */
  0x0020,   /* U+3D4B */
  0x0020,   /* U+3D4C */
  0x0020,   /* U+3D4D */
  0x0020,   /* U+3D4E */
  0x0020,   /* U+3D4F */
  0x0020,   /* U+3D50 */
  0x0020,   /* U+3D51 */
  0x0020,   /* U+3D52 */
  0x0020,   /* U+3D53 */
  0x0020,   /* U+3D54 */
  0x0020,   /* U+3D55 */
  0x0020,   /* U+3D56 */
  0x0020,   /* U+3D57 */
  0x0020,   /* U+3D58 */
  0x0020,   /* U+3D59 */
  0x0020,   /* U+3D5A */
  0x0020,   /* U+3D5B */
  0x0020,   /* U+3D5C */
  0x0020,   /* U+3D5D */
  0x0020,   /* U+3D5E */
  0x0020,   /* U+3D5F */
  0x0020,   /* U+3D60 */
  0x0020,   /* U+3D61 */
  0x0020,   /* U+3D62 */
  0x0020,   /* U+3D63 */
  0x0020,   /* U+3D64 */
  0x0020,   /* U+3D65 */
  0x0020,   /* U+3D66 */
  0x0020,   /* U+3D67 */
  0x0020,   /* U+3D68 */
  0x0020,   /* U+3D69 */
  0x0020,   /* U+3D6A */
  0x0020,   /* U+3D6B */
  0x0020,   /* U+3D6C */
  0x0020,   /* U+3D6D */
  0x0020,   /* U+3D6E */
  0x0020,   /* U+3D6F */
  0x0020,   /* U+3D70 */
  0x0020,   /* U+3D71 */
  0x0020,   /* U+3D72 */
  0x0020,   /* U+3D73 */
  0x0020,   /* U+3D74 */
  0x0020,   /* U+3D75 */
  0x0020,   /* U+3D76 */
  0x0020,   /* U+3D77 */
  0x0020,   /* U+3D78 */
  0x0020,   /* U+3D79 */
  0x0020,   /* U+3D7A */
  0x0020,   /* U+3D7B */
  0x0020,   /* U+3D7C */
  0x0020,   /* U+3D7D */
  0x0020,   /* U+3D7E */
  0x0020,   /* U+3D7F */
  0x0020,   /* U+3D80 */
  0x0020,   /* U+3D81 */
  0x0020,   /* U+3D82 */
  0x0020,   /* U+3D83 */
  0x0020,   /* U+3D84 */
  0x0020,   /* U+3D85 */
  0x0020,   /* U+3D86 */
  0x0020,   /* U+3D87 */
  0x0020,   /* U+3D88 */
  0x0020,   /* U+3D89 */
  0x0020,   /* U+3D8A */
  0x0020,   /* U+3D8B */
  0x0020,   /* U+3D8C */
  0x0020,   /* U+3D8D */
  0x0020,   /* U+3D8E */
  0x0020,   /* U+3D8F */
  0x0020,   /* U+3D90 */
  0x0020,   /* U+3D91 */
  0x0020,   /* U+3D92 */
  0x0020,   /* U+3D93 */
  0x0020,   /* U+3D94 */
  0x0020,   /* U+3D95 */
  0x0020,   /* U+3D96 */
  0x0020,   /* U+3D97 */
  0x0020,   /* U+3D98 */
  0x0020,   /* U+3D99 */
  0x0020,   /* U+3D9A */
  0x0020,   /* U+3D9B */
  0x0020,   /* U+3D9C */
  0x0020,   /* U+3D9D */
  0x0020,   /* U+3D9E */
  0x0020,   /* U+3D9F */
  0x0020,   /* U+3DA0 */
  0x0020,   /* U+3DA1 */
  0x0020,   /* U+3DA2 */
  0x0020,   /* U+3DA3 */
  0x0020,   /* U+3DA4 */
  0x0020,   /* U+3DA5 */
  0x0020,   /* U+3DA6 */
  0x0020,   /* U+3DA7 */
  0x0020,   /* U+3DA8 */
  0x0020,   /* U+3DA9 */
  0x0020,   /* U+3DAA */
  0x0020,   /* U+3DAB */
  0x0020,   /* U+3DAC */
  0x0020,   /* U+3DAD */
  0x0020,   /* U+3DAE */
  0x0020,   /* U+3DAF */
  0x0020,   /* U+3DB0 */
  0x0020,   /* U+3DB1 */
  0x0020,   /* U+3DB2 */
  0x0020,   /* U+3DB3 */
  0x0020,   /* U+3DB4 */
  0x0020,   /* U+3DB5 */
  0x0020,   /* U+3DB6 */
  0x0020,   /* U+3DB7 */
  0x0020,   /* U+3DB8 */
  0x0020,   /* U+3DB9 */
  0x0020,   /* U+3DBA */
  0x0020,   /* U+3DBB */
  0x0020,   /* U+3DBC */
  0x0020,   /* U+3DBD */
  0x0020,   /* U+3DBE */
  0x0020,   /* U+3DBF */
  0x0020,   /* U+3DC0 */
  0x0020,   /* U+3DC1 */
  0x0020,   /* U+3DC2 */
  0x0020,   /* U+3DC3 */
  0x0020,   /* U+3DC4 */
  0x0020,   /* U+3DC5 */
  0x0020,   /* U+3DC6 */
  0x0020,   /* U+3DC7 */
  0x0020,   /* U+3DC8 */
  0x0020,   /* U+3DC9 */
  0x0020,   /* U+3DCA */
  0x0020,   /* U+3DCB */
  0x0020,   /* U+3DCC */
  0x0020,   /* U+3DCD */
  0x0020,   /* U+3DCE */
  0x0020,   /* U+3DCF */
  0x0020,   /* U+3DD0 */
  0x0020,   /* U+3DD1 */
  0x0020,   /* U+3DD2 */
  0x0020,   /* U+3DD3 */
  0x0020,   /* U+3DD4 */
  0x0020,   /* U+3DD5 */
  0x0020,   /* U+3DD6 */
  0x0020,   /* U+3DD7 */
  0x0020,   /* U+3DD8 */
  0x0020,   /* U+3DD9 */
  0x0020,   /* U+3DDA */
  0x0020,   /* U+3DDB */
  0x0020,   /* U+3DDC */
  0x0020,   /* U+3DDD */
  0x0020,   /* U+3DDE */
  0x0020,   /* U+3DDF */
  0x0020,   /* U+3DE0 */
  0x0020,   /* U+3DE1 */
  0x0020,   /* U+3DE2 */
  0x0020,   /* U+3DE3 */
  0x0020,   /* U+3DE4 */
  0x0020,   /* U+3DE5 */
  0x0020,   /* U+3DE6 */
  0x0020,   /* U+3DE7 */
  0x0020,   /* U+3DE8 */
  0x0020,   /* U+3DE9 */
  0x0020,   /* U+3DEA */
  0x0020,   /* U+3DEB */
  0x0020,   /* U+3DEC */
  0x0020,   /* U+3DED */
  0x0020,   /* U+3DEE */
  0x0020,   /* U+3DEF */
  0x0020,   /* U+3DF0 */
  0x0020,   /* U+3DF1 */
  0x0020,   /* U+3DF2 */
  0x0020,   /* U+3DF3 */
  0x0020,   /* U+3DF4 */
  0x0020,   /* U+3DF5 */
  0x0020,   /* U+3DF6 */
  0x0020,   /* U+3DF7 */
  0x0020,   /* U+3DF8 */
  0x0020,   /* U+3DF9 */
  0x0020,   /* U+3DFA */
  0x0020,   /* U+3DFB */
  0x0020,   /* U+3DFC */
  0x0020,   /* U+3DFD */
  0x0020,   /* U+3DFE */
  0x0020,   /* U+3DFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3D00 */
  0x0002,   /* U+3D01 */
  0x0002,   /* U+3D02 */
  0x0002,   /* U+3D03 */
  0x0002,   /* U+3D04 */
  0x0002,   /* U+3D05 */
  0x0002,   /* U+3D06 */
  0x0002,   /* U+3D07 */
  0x0002,   /* U+3D08 */
  0x0002,   /* U+3D09 */
  0x0002,   /* U+3D0A */
  0x0002,   /* U+3D0B */
  0x0002,   /* U+3D0C */
  0x0002,   /* U+3D0D */
  0x0002,   /* U+3D0E */
  0x0002,   /* U+3D0F */
  0x0002,   /* U+3D10 */
  0x0002,   /* U+3D11 */
  0x0002,   /* U+3D12 */
  0x0002,   /* U+3D13 */
  0x0002,   /* U+3D14 */
  0x0002,   /* U+3D15 */
  0x0002,   /* U+3D16 */
  0x0002,   /* U+3D17 */
  0x0002,   /* U+3D18 */
  0x0002,   /* U+3D19 */
  0x0002,   /* U+3D1A */
  0x0002,   /* U+3D1B */
  0x0002,   /* U+3D1C */
  0x0002,   /* U+3D1D */
  0x0002,   /* U+3D1E */
  0x0002,   /* U+3D1F */
  0x0002,   /* U+3D20 */
  0x0002,   /* U+3D21 */
  0x0002,   /* U+3D22 */
  0x0002,   /* U+3D23 */
  0x0002,   /* U+3D24 */
  0x0002,   /* U+3D25 */
  0x0002,   /* U+3D26 */
  0x0002,   /* U+3D27 */
  0x0002,   /* U+3D28 */
  0x0002,   /* U+3D29 */
  0x0002,   /* U+3D2A */
  0x0002,   /* U+3D2B */
  0x0002,   /* U+3D2C */
  0x0002,   /* U+3D2D */
  0x0002,   /* U+3D2E */
  0x0002,   /* U+3D2F */
  0x0002,   /* U+3D30 */
  0x0002,   /* U+3D31 */
  0x0002,   /* U+3D32 */
  0x0002,   /* U+3D33 */
  0x0002,   /* U+3D34 */
  0x0002,   /* U+3D35 */
  0x0002,   /* U+3D36 */
  0x0002,   /* U+3D37 */
  0x0002,   /* U+3D38 */
  0x0002,   /* U+3D39 */
  0x0002,   /* U+3D3A */
  0x0002,   /* U+3D3B */
  0x0002,   /* U+3D3C */
  0x0002,   /* U+3D3D */
  0x0002,   /* U+3D3E */
  0x0002,   /* U+3D3F */
  0x0002,   /* U+3D40 */
  0x0002,   /* U+3D41 */
  0x0002,   /* U+3D42 */
  0x0002,   /* U+3D43 */
  0x0002,   /* U+3D44 */
  0x0002,   /* U+3D45 */
  0x0002,   /* U+3D46 */
  0x0002,   /* U+3D47 */
  0x0002,   /* U+3D48 */
  0x0002,   /* U+3D49 */
  0x0002,   /* U+3D4A */
  0x0002,   /* U+3D4B */
  0x0002,   /* U+3D4C */
  0x0002,   /* U+3D4D */
  0x0002,   /* U+3D4E */
  0x0002,   /* U+3D4F */
  0x0002,   /* U+3D50 */
  0x0002,   /* U+3D51 */
  0x0002,   /* U+3D52 */
  0x0002,   /* U+3D53 */
  0x0002,   /* U+3D54 */
  0x0002,   /* U+3D55 */
  0x0002,   /* U+3D56 */
  0x0002,   /* U+3D57 */
  0x0002,   /* U+3D58 */
  0x0002,   /* U+3D59 */
  0x0002,   /* U+3D5A */
  0x0002,   /* U+3D5B */
  0x0002,   /* U+3D5C */
  0x0002,   /* U+3D5D */
  0x0002,   /* U+3D5E */
  0x0002,   /* U+3D5F */
  0x0002,   /* U+3D60 */
  0x0002,   /* U+3D61 */
  0x0002,   /* U+3D62 */
  0x0002,   /* U+3D63 */
  0x0002,   /* U+3D64 */
  0x0002,   /* U+3D65 */
  0x0002,   /* U+3D66 */
  0x0002,   /* U+3D67 */
  0x0002,   /* U+3D68 */
  0x0002,   /* U+3D69 */
  0x0002,   /* U+3D6A */
  0x0002,   /* U+3D6B */
  0x0002,   /* U+3D6C */
  0x0002,   /* U+3D6D */
  0x0002,   /* U+3D6E */
  0x0002,   /* U+3D6F */
  0x0002,   /* U+3D70 */
  0x0002,   /* U+3D71 */
  0x0002,   /* U+3D72 */
  0x0002,   /* U+3D73 */
  0x0002,   /* U+3D74 */
  0x0002,   /* U+3D75 */
  0x0002,   /* U+3D76 */
  0x0002,   /* U+3D77 */
  0x0002,   /* U+3D78 */
  0x0002,   /* U+3D79 */
  0x0002,   /* U+3D7A */
  0x0002,   /* U+3D7B */
  0x0002,   /* U+3D7C */
  0x0002,   /* U+3D7D */
  0x0002,   /* U+3D7E */
  0x0002,   /* U+3D7F */
  0x0002,   /* U+3D80 */
  0x0002,   /* U+3D81 */
  0x0002,   /* U+3D82 */
  0x0002,   /* U+3D83 */
  0x0002,   /* U+3D84 */
  0x0002,   /* U+3D85 */
  0x0002,   /* U+3D86 */
  0x0002,   /* U+3D87 */
  0x0002,   /* U+3D88 */
  0x0002,   /* U+3D89 */
  0x0002,   /* U+3D8A */
  0x0002,   /* U+3D8B */
  0x0002,   /* U+3D8C */
  0x0002,   /* U+3D8D */
  0x0002,   /* U+3D8E */
  0x0002,   /* U+3D8F */
  0x0002,   /* U+3D90 */
  0x0002,   /* U+3D91 */
  0x0002,   /* U+3D92 */
  0x0002,   /* U+3D93 */
  0x0002,   /* U+3D94 */
  0x0002,   /* U+3D95 */
  0x0002,   /* U+3D96 */
  0x0002,   /* U+3D97 */
  0x0002,   /* U+3D98 */
  0x0002,   /* U+3D99 */
  0x0002,   /* U+3D9A */
  0x0002,   /* U+3D9B */
  0x0002,   /* U+3D9C */
  0x0002,   /* U+3D9D */
  0x0002,   /* U+3D9E */
  0x0002,   /* U+3D9F */
  0x0002,   /* U+3DA0 */
  0x0002,   /* U+3DA1 */
  0x0002,   /* U+3DA2 */
  0x0002,   /* U+3DA3 */
  0x0002,   /* U+3DA4 */
  0x0002,   /* U+3DA5 */
  0x0002,   /* U+3DA6 */
  0x0002,   /* U+3DA7 */
  0x0002,   /* U+3DA8 */
  0x0002,   /* U+3DA9 */
  0x0002,   /* U+3DAA */
  0x0002,   /* U+3DAB */
  0x0002,   /* U+3DAC */
  0x0002,   /* U+3DAD */
  0x0002,   /* U+3DAE */
  0x0002,   /* U+3DAF */
  0x0002,   /* U+3DB0 */
  0x0002,   /* U+3DB1 */
  0x0002,   /* U+3DB2 */
  0x0002,   /* U+3DB3 */
  0x0002,   /* U+3DB4 */
  0x0002,   /* U+3DB5 */
  0x0002,   /* U+3DB6 */
  0x0002,   /* U+3DB7 */
  0x0002,   /* U+3DB8 */
  0x0002,   /* U+3DB9 */
  0x0002,   /* U+3DBA */
  0x0002,   /* U+3DBB */
  0x0002,   /* U+3DBC */
  0x0002,   /* U+3DBD */
  0x0002,   /* U+3DBE */
  0x0002,   /* U+3DBF */
  0x0002,   /* U+3DC0 */
  0x0002,   /* U+3DC1 */
  0x0002,   /* U+3DC2 */
  0x0002,   /* U+3DC3 */
  0x0002,   /* U+3DC4 */
  0x0002,   /* U+3DC5 */
  0x0002,   /* U+3DC6 */
  0x0002,   /* U+3DC7 */
  0x0002,   /* U+3DC8 */
  0x0002,   /* U+3DC9 */
  0x0002,   /* U+3DCA */
  0x0002,   /* U+3DCB */
  0x0002,   /* U+3DCC */
  0x0002,   /* U+3DCD */
  0x0002,   /* U+3DCE */
  0x0002,   /* U+3DCF */
  0x0002,   /* U+3DD0 */
  0x0002,   /* U+3DD1 */
  0x0002,   /* U+3DD2 */
  0x0002,   /* U+3DD3 */
  0x0002,   /* U+3DD4 */
  0x0002,   /* U+3DD5 */
  0x0002,   /* U+3DD6 */
  0x0002,   /* U+3DD7 */
  0x0002,   /* U+3DD8 */
  0x0002,   /* U+3DD9 */
  0x0002,   /* U+3DDA */
  0x0002,   /* U+3DDB */
  0x0002,   /* U+3DDC */
  0x0002,   /* U+3DDD */
  0x0002,   /* U+3DDE */
  0x0002,   /* U+3DDF */
  0x0002,   /* U+3DE0 */
  0x0002,   /* U+3DE1 */
  0x0002,   /* U+3DE2 */
  0x0002,   /* U+3DE3 */
  0x0002,   /* U+3DE4 */
  0x0002,   /* U+3DE5 */
  0x0002,   /* U+3DE6 */
  0x0002,   /* U+3DE7 */
  0x0002,   /* U+3DE8 */
  0x0002,   /* U+3DE9 */
  0x0002,   /* U+3DEA */
  0x0002,   /* U+3DEB */
  0x0002,   /* U+3DEC */
  0x0002,   /* U+3DED */
  0x0002,   /* U+3DEE */
  0x0002,   /* U+3DEF */
  0x0002,   /* U+3DF0 */
  0x0002,   /* U+3DF1 */
  0x0002,   /* U+3DF2 */
  0x0002,   /* U+3DF3 */
  0x0002,   /* U+3DF4 */
  0x0002,   /* U+3DF5 */
  0x0002,   /* U+3DF6 */
  0x0002,   /* U+3DF7 */
  0x0002,   /* U+3DF8 */
  0x0002,   /* U+3DF9 */
  0x0002,   /* U+3DFA */
  0x0002,   /* U+3DFB */
  0x0002,   /* U+3DFC */
  0x0002,   /* U+3DFD */
  0x0002,   /* U+3DFE */
  0x0002,   /* U+3DFF */

  /* Primary weight 2 for each character. */
  0x8D0B,   /* U+3D00 */
  0x8D0C,   /* U+3D01 */
  0x8D0D,   /* U+3D02 */
  0x8D0E,   /* U+3D03 */
  0x8D0F,   /* U+3D04 */
  0x8D21,   /* U+3D05 */
  0x8D10,   /* U+3D06 */
  0x8D22,   /* U+3D07 */
  0x8D11,   /* U+3D08 */
  0x8D12,   /* U+3D09 */
  0x8D13,   /* U+3D0A */
  0x8D14,   /* U+3D0B */
  0x8D15,   /* U+3D0C */
  0x8D16,   /* U+3D0D */
  0x8D17,   /* U+3D0E */
  0x8DA4,   /* U+3D0F */
  0x8DA5,   /* U+3D10 */
  0x8DA6,   /* U+3D11 */
  0x8DA7,   /* U+3D12 */
  0x8DA8,   /* U+3D13 */
  0x8DA9,   /* U+3D14 */
  0x8DAA,   /* U+3D15 */
  0x8DAB,   /* U+3D16 */
  0x8DAC,   /* U+3D17 */
  0x8DAD,   /* U+3D18 */
  0x8DAE,   /* U+3D19 */
  0x8DAF,   /* U+3D1A */
  0x8DB0,   /* U+3D1B */
  0x8DB1,   /* U+3D1C */
  0x8DB2,   /* U+3D1D */
  0x8DB3,   /* U+3D1E */
  0x8DB4,   /* U+3D1F */
  0x8DB5,   /* U+3D20 */
  0x8DB6,   /* U+3D21 */
  0x8DB7,   /* U+3D22 */
  0x8DB8,   /* U+3D23 */
  0x8DB9,   /* U+3D24 */
  0x8B9A,   /* U+3D25 */
  0x8B9B,   /* U+3D26 */
  0x8B9C,   /* U+3D27 */
  0x8B9D,   /* U+3D28 */
  0x8B9E,   /* U+3D29 */
  0x8B9F,   /* U+3D2A */
  0x8BA0,   /* U+3D2B */
  0x8BA1,   /* U+3D2C */
  0x8BA2,   /* U+3D2D */
  0x8BA3,   /* U+3D2E */
  0x8BA4,   /* U+3D2F */
  0x8BA5,   /* U+3D30 */
  0x8BA6,   /* U+3D31 */
  0x8BA7,   /* U+3D32 */
  0x8BA8,   /* U+3D33 */
  0x8BA9,   /* U+3D34 */
  0x8BAA,   /* U+3D35 */
  0x8BAB,   /* U+3D36 */
  0x8BAC,   /* U+3D37 */
  0x8BAD,   /* U+3D38 */
  0x8BAE,   /* U+3D39 */
  0x8BAF,   /* U+3D3A */
  0x8BB0,   /* U+3D3B */
  0x8AEE,   /* U+3D3C */
  0x8AEF,   /* U+3D3D */
  0x8AF0,   /* U+3D3E */
  0x8AF1,   /* U+3D3F */
  0x8AF2,   /* U+3D40 */
  0x8AF3,   /* U+3D41 */
  0x8AF4,   /* U+3D42 */
  0x8AF5,   /* U+3D43 */
  0x8AF6,   /* U+3D44 */
  0x8AF7,   /* U+3D45 */
  0x8AF8,   /* U+3D46 */
  0x8AF9,   /* U+3D47 */
  0x8AFA,   /* U+3D48 */
  0x8AFB,   /* U+3D49 */
  0x89A1,   /* U+3D4A */
  0x89A2,   /* U+3D4B */
  0x89A3,   /* U+3D4C */
  0x89A4,   /* U+3D4D */
  0x89A5,   /* U+3D4E */
  0x89A6,   /* U+3D4F */
  0x89A7,   /* U+3D50 */
  0x89A8,   /* U+3D51 */
  0x89A9,   /* U+3D52 */
  0x89AA,   /* U+3D53 */
  0x89AB,   /* U+3D54 */
  0x89AC,   /* U+3D55 */
  0x89AD,   /* U+3D56 */
  0x89AE,   /* U+3D57 */
  0x8785,   /* U+3D58 */
  0x89AF,   /* U+3D59 */
  0x89B0,   /* U+3D5A */
  0x89B1,   /* U+3D5B */
  0x89B2,   /* U+3D5C */
  0x87BC,   /* U+3D5D */
  0x87BD,   /* U+3D5E */
  0x87BE,   /* U+3D5F */
  0x87BF,   /* U+3D60 */
  0x87C0,   /* U+3D61 */
  0x87C1,   /* U+3D62 */
  0x87C2,   /* U+3D63 */
  0x87C3,   /* U+3D64 */
  0x87C4,   /* U+3D65 */
  0x87C5,   /* U+3D66 */
  0x87C6,   /* U+3D67 */
  0x84F7,   /* U+3D68 */
  0x87C7,   /* U+3D69 */
  0x87C8,   /* U+3D6A */
  0x87C9,   /* U+3D6B */
  0x87CA,   /* U+3D6C */
  0x87CB,   /* U+3D6D */
  0x87CC,   /* U+3D6E */
  0x851B,   /* U+3D6F */
  0x851C,   /* U+3D70 */
  0x851D,   /* U+3D71 */
  0x851E,   /* U+3D72 */
  0x851F,   /* U+3D73 */
  0x8520,   /* U+3D74 */
  0x8521,   /* U+3D75 */
  0x8522,   /* U+3D76 */
  0x8523,   /* U+3D77 */
  0x8524,   /* U+3D78 */
  0x8525,   /* U+3D79 */
  0x8526,   /* U+3D7A */
  0x8527,   /* U+3D7B */
  0x8528,   /* U+3D7C */
  0x8472,   /* U+3D7D */
  0x8473,   /* U+3D7E */
  0x8474,   /* U+3D7F */
  0x8475,   /* U+3D80 */
  0x8476,   /* U+3D81 */
  0x8477,   /* U+3D82 */
  0x8478,   /* U+3D83 */
  0x8342,   /* U+3D84 */
  0x8343,   /* U+3D85 */
  0x8344,   /* U+3D86 */
  0x8345,   /* U+3D87 */
  0x8346,   /* U+3D88 */
  0x8347,   /* U+3D89 */
  0x8348,   /* U+3D8A */
  0x8349,   /* U+3D8B */
  0x8241,   /* U+3D8C */
  0x8242,   /* U+3D8D */
  0x8243,   /* U+3D8E */
  0x8244,   /* U+3D8F */
  0x8245,   /* U+3D90 */
  0x8246,   /* U+3D91 */
  0x81C0,   /* U+3D92 */
  0x81C1,   /* U+3D93 */
  0x81C2,   /* U+3D94 */
  0x81C3,   /* U+3D95 */
  0x81C4,   /* U+3D96 */
  0x8152,   /* U+3D97 */
  0x81C5,   /* U+3D98 */
  0x815A,   /* U+3D99 */
  0x815B,   /* U+3D9A */
  0x80E0,   /* U+3D9B */
  0x80E1,   /* U+3D9C */
  0x80E2,   /* U+3D9D */
  0x80B7,   /* U+3D9E */
  0x80B8,   /* U+3D9F */
  0x8046,   /* U+3DA0 */
  0x855C,   /* U+3DA1 */
  0x855D,   /* U+3DA2 */
  0x886D,   /* U+3DA3 */
  0x886E,   /* U+3DA4 */
  0x886F,   /* U+3DA5 */
  0x8ABD,   /* U+3DA6 */
  0x8ABE,   /* U+3DA7 */
  0x8ABF,   /* U+3DA8 */
  0x8AC0,   /* U+3DA9 */
  0x8AC1,   /* U+3DAA */
  0x8BC9,   /* U+3DAB */
  0x8BCA,   /* U+3DAC */
  0x8BCB,   /* U+3DAD */
  0x8BCC,   /* U+3DAE */
  0x8BCD,   /* U+3DAF */
  0x8BCE,   /* U+3DB0 */
  0x8BCF,   /* U+3DB1 */
  0x8BD0,   /* U+3DB2 */
  0x8D3E,   /* U+3DB3 */
  0x8D3F,   /* U+3DB4 */
  0x8D40,   /* U+3DB5 */
  0x8D41,   /* U+3DB6 */
  0x8D42,   /* U+3DB7 */
  0x8D43,   /* U+3DB8 */
  0x8DFC,   /* U+3DB9 */
  0x8DFD,   /* U+3DBA */
  0x8DFE,   /* U+3DBB */
  0x8DFF,   /* U+3DBC */
  0x8E00,   /* U+3DBD */
  0x8E01,   /* U+3DBE */
  0x8E02,   /* U+3DBF */
  0x8E03,   /* U+3DC0 */
  0x8E04,   /* U+3DC1 */
  0x8E9F,   /* U+3DC2 */
  0x8EA0,   /* U+3DC3 */
  0x8EA1,   /* U+3DC4 */
  0x8EA2,   /* U+3DC5 */
  0x8EA3,   /* U+3DC6 */
  0x8EA4,   /* U+3DC7 */
  0x8EA5,   /* U+3DC8 */
  0x8EA6,   /* U+3DC9 */
  0x8EA7,   /* U+3DCA */
  0x8EA8,   /* U+3DCB */
  0x8EA9,   /* U+3DCC */
  0x8EAA,   /* U+3DCD */
  0x8CA0,   /* U+3DCE */
  0x8CA1,   /* U+3DCF */
  0x8CA2,   /* U+3DD0 */
  0x8CA3,   /* U+3DD1 */
  0x8CA4,   /* U+3DD2 */
  0x8CA5,   /* U+3DD3 */
  0x8CA6,   /* U+3DD4 */
  0x8CA7,   /* U+3DD5 */
  0x8CA8,   /* U+3DD6 */
  0x8CA9,   /* U+3DD7 */
  0x8CAA,   /* U+3DD8 */
  0x8CAB,   /* U+3DD9 */
  0x8CAC,   /* U+3DDA */
  0x8CAD,   /* U+3DDB */
  0x8CAE,   /* U+3DDC */
  0x8CAF,   /* U+3DDD */
  0x8CB0,   /* U+3DDE */
  0x8BDB,   /* U+3DDF */
  0x8BDC,   /* U+3DE0 */
  0x8BDD,   /* U+3DE1 */
  0x8BDE,   /* U+3DE2 */
  0x8BDF,   /* U+3DE3 */
  0x8BE0,   /* U+3DE4 */
  0x8BE1,   /* U+3DE5 */
  0x8BE2,   /* U+3DE6 */
  0x8BE3,   /* U+3DE7 */
  0x8BE4,   /* U+3DE8 */
  0x8BE5,   /* U+3DE9 */
  0x8BE6,   /* U+3DEA */
  0x8A9F,   /* U+3DEB */
  0x8AA0,   /* U+3DEC */
  0x8AA1,   /* U+3DED */
  0x8AA2,   /* U+3DEE */
  0x8AA3,   /* U+3DEF */
  0x8AA4,   /* U+3DF0 */
  0x8AA5,   /* U+3DF1 */
  0x8AA6,   /* U+3DF2 */
  0x888B,   /* U+3DF3 */
  0x888C,   /* U+3DF4 */
  0x888D,   /* U+3DF5 */
  0x888E,   /* U+3DF6 */
  0x888F,   /* U+3DF7 */
  0x8890,   /* U+3DF8 */
  0x8891,   /* U+3DF9 */
  0x8892,   /* U+3DFA */
  0x8893,   /* U+3DFB */
  0x8894,   /* U+3DFC */
  0x8895,   /* U+3DFD */
  0x85AC,   /* U+3DFE */
  0x85AD,   /* U+3DFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3D00 */
  0x0000,   /* U+3D01 */
  0x0000,   /* U+3D02 */
  0x0000,   /* U+3D03 */
  0x0000,   /* U+3D04 */
  0x0000,   /* U+3D05 */
  0x0000,   /* U+3D06 */
  0x0000,   /* U+3D07 */
  0x0000,   /* U+3D08 */
  0x0000,   /* U+3D09 */
  0x0000,   /* U+3D0A */
  0x0000,   /* U+3D0B */
  0x0000,   /* U+3D0C */
  0x0000,   /* U+3D0D */
  0x0000,   /* U+3D0E */
  0x0000,   /* U+3D0F */
  0x0000,   /* U+3D10 */
  0x0000,   /* U+3D11 */
  0x0000,   /* U+3D12 */
  0x0000,   /* U+3D13 */
  0x0000,   /* U+3D14 */
  0x0000,   /* U+3D15 */
  0x0000,   /* U+3D16 */
  0x0000,   /* U+3D17 */
  0x0000,   /* U+3D18 */
  0x0000,   /* U+3D19 */
  0x0000,   /* U+3D1A */
  0x0000,   /* U+3D1B */
  0x0000,   /* U+3D1C */
  0x0000,   /* U+3D1D */
  0x0000,   /* U+3D1E */
  0x0000,   /* U+3D1F */
  0x0000,   /* U+3D20 */
  0x0000,   /* U+3D21 */
  0x0000,   /* U+3D22 */
  0x0000,   /* U+3D23 */
  0x0000,   /* U+3D24 */
  0x0000,   /* U+3D25 */
  0x0000,   /* U+3D26 */
  0x0000,   /* U+3D27 */
  0x0000,   /* U+3D28 */
  0x0000,   /* U+3D29 */
  0x0000,   /* U+3D2A */
  0x0000,   /* U+3D2B */
  0x0000,   /* U+3D2C */
  0x0000,   /* U+3D2D */
  0x0000,   /* U+3D2E */
  0x0000,   /* U+3D2F */
  0x0000,   /* U+3D30 */
  0x0000,   /* U+3D31 */
  0x0000,   /* U+3D32 */
  0x0000,   /* U+3D33 */
  0x0000,   /* U+3D34 */
  0x0000,   /* U+3D35 */
  0x0000,   /* U+3D36 */
  0x0000,   /* U+3D37 */
  0x0000,   /* U+3D38 */
  0x0000,   /* U+3D39 */
  0x0000,   /* U+3D3A */
  0x0000,   /* U+3D3B */
  0x0000,   /* U+3D3C */
  0x0000,   /* U+3D3D */
  0x0000,   /* U+3D3E */
  0x0000,   /* U+3D3F */
  0x0000,   /* U+3D40 */
  0x0000,   /* U+3D41 */
  0x0000,   /* U+3D42 */
  0x0000,   /* U+3D43 */
  0x0000,   /* U+3D44 */
  0x0000,   /* U+3D45 */
  0x0000,   /* U+3D46 */
  0x0000,   /* U+3D47 */
  0x0000,   /* U+3D48 */
  0x0000,   /* U+3D49 */
  0x0000,   /* U+3D4A */
  0x0000,   /* U+3D4B */
  0x0000,   /* U+3D4C */
  0x0000,   /* U+3D4D */
  0x0000,   /* U+3D4E */
  0x0000,   /* U+3D4F */
  0x0000,   /* U+3D50 */
  0x0000,   /* U+3D51 */
  0x0000,   /* U+3D52 */
  0x0000,   /* U+3D53 */
  0x0000,   /* U+3D54 */
  0x0000,   /* U+3D55 */
  0x0000,   /* U+3D56 */
  0x0000,   /* U+3D57 */
  0x0000,   /* U+3D58 */
  0x0000,   /* U+3D59 */
  0x0000,   /* U+3D5A */
  0x0000,   /* U+3D5B */
  0x0000,   /* U+3D5C */
  0x0000,   /* U+3D5D */
  0x0000,   /* U+3D5E */
  0x0000,   /* U+3D5F */
  0x0000,   /* U+3D60 */
  0x0000,   /* U+3D61 */
  0x0000,   /* U+3D62 */
  0x0000,   /* U+3D63 */
  0x0000,   /* U+3D64 */
  0x0000,   /* U+3D65 */
  0x0000,   /* U+3D66 */
  0x0000,   /* U+3D67 */
  0x0000,   /* U+3D68 */
  0x0000,   /* U+3D69 */
  0x0000,   /* U+3D6A */
  0x0000,   /* U+3D6B */
  0x0000,   /* U+3D6C */
  0x0000,   /* U+3D6D */
  0x0000,   /* U+3D6E */
  0x0000,   /* U+3D6F */
  0x0000,   /* U+3D70 */
  0x0000,   /* U+3D71 */
  0x0000,   /* U+3D72 */
  0x0000,   /* U+3D73 */
  0x0000,   /* U+3D74 */
  0x0000,   /* U+3D75 */
  0x0000,   /* U+3D76 */
  0x0000,   /* U+3D77 */
  0x0000,   /* U+3D78 */
  0x0000,   /* U+3D79 */
  0x0000,   /* U+3D7A */
  0x0000,   /* U+3D7B */
  0x0000,   /* U+3D7C */
  0x0000,   /* U+3D7D */
  0x0000,   /* U+3D7E */
  0x0000,   /* U+3D7F */
  0x0000,   /* U+3D80 */
  0x0000,   /* U+3D81 */
  0x0000,   /* U+3D82 */
  0x0000,   /* U+3D83 */
  0x0000,   /* U+3D84 */
  0x0000,   /* U+3D85 */
  0x0000,   /* U+3D86 */
  0x0000,   /* U+3D87 */
  0x0000,   /* U+3D88 */
  0x0000,   /* U+3D89 */
  0x0000,   /* U+3D8A */
  0x0000,   /* U+3D8B */
  0x0000,   /* U+3D8C */
  0x0000,   /* U+3D8D */
  0x0000,   /* U+3D8E */
  0x0000,   /* U+3D8F */
  0x0000,   /* U+3D90 */
  0x0000,   /* U+3D91 */
  0x0000,   /* U+3D92 */
  0x0000,   /* U+3D93 */
  0x0000,   /* U+3D94 */
  0x0000,   /* U+3D95 */
  0x0000,   /* U+3D96 */
  0x0000,   /* U+3D97 */
  0x0000,   /* U+3D98 */
  0x0000,   /* U+3D99 */
  0x0000,   /* U+3D9A */
  0x0000,   /* U+3D9B */
  0x0000,   /* U+3D9C */
  0x0000,   /* U+3D9D */
  0x0000,   /* U+3D9E */
  0x0000,   /* U+3D9F */
  0x0000,   /* U+3DA0 */
  0x0000,   /* U+3DA1 */
  0x0000,   /* U+3DA2 */
  0x0000,   /* U+3DA3 */
  0x0000,   /* U+3DA4 */
  0x0000,   /* U+3DA5 */
  0x0000,   /* U+3DA6 */
  0x0000,   /* U+3DA7 */
  0x0000,   /* U+3DA8 */
  0x0000,   /* U+3DA9 */
  0x0000,   /* U+3DAA */
  0x0000,   /* U+3DAB */
  0x0000,   /* U+3DAC */
  0x0000,   /* U+3DAD */
  0x0000,   /* U+3DAE */
  0x0000,   /* U+3DAF */
  0x0000,   /* U+3DB0 */
  0x0000,   /* U+3DB1 */
  0x0000,   /* U+3DB2 */
  0x0000,   /* U+3DB3 */
  0x0000,   /* U+3DB4 */
  0x0000,   /* U+3DB5 */
  0x0000,   /* U+3DB6 */
  0x0000,   /* U+3DB7 */
  0x0000,   /* U+3DB8 */
  0x0000,   /* U+3DB9 */
  0x0000,   /* U+3DBA */
  0x0000,   /* U+3DBB */
  0x0000,   /* U+3DBC */
  0x0000,   /* U+3DBD */
  0x0000,   /* U+3DBE */
  0x0000,   /* U+3DBF */
  0x0000,   /* U+3DC0 */
  0x0000,   /* U+3DC1 */
  0x0000,   /* U+3DC2 */
  0x0000,   /* U+3DC3 */
  0x0000,   /* U+3DC4 */
  0x0000,   /* U+3DC5 */
  0x0000,   /* U+3DC6 */
  0x0000,   /* U+3DC7 */
  0x0000,   /* U+3DC8 */
  0x0000,   /* U+3DC9 */
  0x0000,   /* U+3DCA */
  0x0000,   /* U+3DCB */
  0x0000,   /* U+3DCC */
  0x0000,   /* U+3DCD */
  0x0000,   /* U+3DCE */
  0x0000,   /* U+3DCF */
  0x0000,   /* U+3DD0 */
  0x0000,   /* U+3DD1 */
  0x0000,   /* U+3DD2 */
  0x0000,   /* U+3DD3 */
  0x0000,   /* U+3DD4 */
  0x0000,   /* U+3DD5 */
  0x0000,   /* U+3DD6 */
  0x0000,   /* U+3DD7 */
  0x0000,   /* U+3DD8 */
  0x0000,   /* U+3DD9 */
  0x0000,   /* U+3DDA */
  0x0000,   /* U+3DDB */
  0x0000,   /* U+3DDC */
  0x0000,   /* U+3DDD */
  0x0000,   /* U+3DDE */
  0x0000,   /* U+3DDF */
  0x0000,   /* U+3DE0 */
  0x0000,   /* U+3DE1 */
  0x0000,   /* U+3DE2 */
  0x0000,   /* U+3DE3 */
  0x0000,   /* U+3DE4 */
  0x0000,   /* U+3DE5 */
  0x0000,   /* U+3DE6 */
  0x0000,   /* U+3DE7 */
  0x0000,   /* U+3DE8 */
  0x0000,   /* U+3DE9 */
  0x0000,   /* U+3DEA */
  0x0000,   /* U+3DEB */
  0x0000,   /* U+3DEC */
  0x0000,   /* U+3DED */
  0x0000,   /* U+3DEE */
  0x0000,   /* U+3DEF */
  0x0000,   /* U+3DF0 */
  0x0000,   /* U+3DF1 */
  0x0000,   /* U+3DF2 */
  0x0000,   /* U+3DF3 */
  0x0000,   /* U+3DF4 */
  0x0000,   /* U+3DF5 */
  0x0000,   /* U+3DF6 */
  0x0000,   /* U+3DF7 */
  0x0000,   /* U+3DF8 */
  0x0000,   /* U+3DF9 */
  0x0000,   /* U+3DFA */
  0x0000,   /* U+3DFB */
  0x0000,   /* U+3DFC */
  0x0000,   /* U+3DFD */
  0x0000,   /* U+3DFE */
  0x0000,   /* U+3DFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3D00 */
  0x0000,   /* U+3D01 */
  0x0000,   /* U+3D02 */
  0x0000,   /* U+3D03 */
  0x0000,   /* U+3D04 */
  0x0000,   /* U+3D05 */
  0x0000,   /* U+3D06 */
  0x0000,   /* U+3D07 */
  0x0000,   /* U+3D08 */
  0x0000,   /* U+3D09 */
  0x0000,   /* U+3D0A */
  0x0000,   /* U+3D0B */
  0x0000,   /* U+3D0C */
  0x0000,   /* U+3D0D */
  0x0000,   /* U+3D0E */
  0x0000,   /* U+3D0F */
  0x0000,   /* U+3D10 */
  0x0000,   /* U+3D11 */
  0x0000,   /* U+3D12 */
  0x0000,   /* U+3D13 */
  0x0000,   /* U+3D14 */
  0x0000,   /* U+3D15 */
  0x0000,   /* U+3D16 */
  0x0000,   /* U+3D17 */
  0x0000,   /* U+3D18 */
  0x0000,   /* U+3D19 */
  0x0000,   /* U+3D1A */
  0x0000,   /* U+3D1B */
  0x0000,   /* U+3D1C */
  0x0000,   /* U+3D1D */
  0x0000,   /* U+3D1E */
  0x0000,   /* U+3D1F */
  0x0000,   /* U+3D20 */
  0x0000,   /* U+3D21 */
  0x0000,   /* U+3D22 */
  0x0000,   /* U+3D23 */
  0x0000,   /* U+3D24 */
  0x0000,   /* U+3D25 */
  0x0000,   /* U+3D26 */
  0x0000,   /* U+3D27 */
  0x0000,   /* U+3D28 */
  0x0000,   /* U+3D29 */
  0x0000,   /* U+3D2A */
  0x0000,   /* U+3D2B */
  0x0000,   /* U+3D2C */
  0x0000,   /* U+3D2D */
  0x0000,   /* U+3D2E */
  0x0000,   /* U+3D2F */
  0x0000,   /* U+3D30 */
  0x0000,   /* U+3D31 */
  0x0000,   /* U+3D32 */
  0x0000,   /* U+3D33 */
  0x0000,   /* U+3D34 */
  0x0000,   /* U+3D35 */
  0x0000,   /* U+3D36 */
  0x0000,   /* U+3D37 */
  0x0000,   /* U+3D38 */
  0x0000,   /* U+3D39 */
  0x0000,   /* U+3D3A */
  0x0000,   /* U+3D3B */
  0x0000,   /* U+3D3C */
  0x0000,   /* U+3D3D */
  0x0000,   /* U+3D3E */
  0x0000,   /* U+3D3F */
  0x0000,   /* U+3D40 */
  0x0000,   /* U+3D41 */
  0x0000,   /* U+3D42 */
  0x0000,   /* U+3D43 */
  0x0000,   /* U+3D44 */
  0x0000,   /* U+3D45 */
  0x0000,   /* U+3D46 */
  0x0000,   /* U+3D47 */
  0x0000,   /* U+3D48 */
  0x0000,   /* U+3D49 */
  0x0000,   /* U+3D4A */
  0x0000,   /* U+3D4B */
  0x0000,   /* U+3D4C */
  0x0000,   /* U+3D4D */
  0x0000,   /* U+3D4E */
  0x0000,   /* U+3D4F */
  0x0000,   /* U+3D50 */
  0x0000,   /* U+3D51 */
  0x0000,   /* U+3D52 */
  0x0000,   /* U+3D53 */
  0x0000,   /* U+3D54 */
  0x0000,   /* U+3D55 */
  0x0000,   /* U+3D56 */
  0x0000,   /* U+3D57 */
  0x0000,   /* U+3D58 */
  0x0000,   /* U+3D59 */
  0x0000,   /* U+3D5A */
  0x0000,   /* U+3D5B */
  0x0000,   /* U+3D5C */
  0x0000,   /* U+3D5D */
  0x0000,   /* U+3D5E */
  0x0000,   /* U+3D5F */
  0x0000,   /* U+3D60 */
  0x0000,   /* U+3D61 */
  0x0000,   /* U+3D62 */
  0x0000,   /* U+3D63 */
  0x0000,   /* U+3D64 */
  0x0000,   /* U+3D65 */
  0x0000,   /* U+3D66 */
  0x0000,   /* U+3D67 */
  0x0000,   /* U+3D68 */
  0x0000,   /* U+3D69 */
  0x0000,   /* U+3D6A */
  0x0000,   /* U+3D6B */
  0x0000,   /* U+3D6C */
  0x0000,   /* U+3D6D */
  0x0000,   /* U+3D6E */
  0x0000,   /* U+3D6F */
  0x0000,   /* U+3D70 */
  0x0000,   /* U+3D71 */
  0x0000,   /* U+3D72 */
  0x0000,   /* U+3D73 */
  0x0000,   /* U+3D74 */
  0x0000,   /* U+3D75 */
  0x0000,   /* U+3D76 */
  0x0000,   /* U+3D77 */
  0x0000,   /* U+3D78 */
  0x0000,   /* U+3D79 */
  0x0000,   /* U+3D7A */
  0x0000,   /* U+3D7B */
  0x0000,   /* U+3D7C */
  0x0000,   /* U+3D7D */
  0x0000,   /* U+3D7E */
  0x0000,   /* U+3D7F */
  0x0000,   /* U+3D80 */
  0x0000,   /* U+3D81 */
  0x0000,   /* U+3D82 */
  0x0000,   /* U+3D83 */
  0x0000,   /* U+3D84 */
  0x0000,   /* U+3D85 */
  0x0000,   /* U+3D86 */
  0x0000,   /* U+3D87 */
  0x0000,   /* U+3D88 */
  0x0000,   /* U+3D89 */
  0x0000,   /* U+3D8A */
  0x0000,   /* U+3D8B */
  0x0000,   /* U+3D8C */
  0x0000,   /* U+3D8D */
  0x0000,   /* U+3D8E */
  0x0000,   /* U+3D8F */
  0x0000,   /* U+3D90 */
  0x0000,   /* U+3D91 */
  0x0000,   /* U+3D92 */
  0x0000,   /* U+3D93 */
  0x0000,   /* U+3D94 */
  0x0000,   /* U+3D95 */
  0x0000,   /* U+3D96 */
  0x0000,   /* U+3D97 */
  0x0000,   /* U+3D98 */
  0x0000,   /* U+3D99 */
  0x0000,   /* U+3D9A */
  0x0000,   /* U+3D9B */
  0x0000,   /* U+3D9C */
  0x0000,   /* U+3D9D */
  0x0000,   /* U+3D9E */
  0x0000,   /* U+3D9F */
  0x0000,   /* U+3DA0 */
  0x0000,   /* U+3DA1 */
  0x0000,   /* U+3DA2 */
  0x0000,   /* U+3DA3 */
  0x0000,   /* U+3DA4 */
  0x0000,   /* U+3DA5 */
  0x0000,   /* U+3DA6 */
  0x0000,   /* U+3DA7 */
  0x0000,   /* U+3DA8 */
  0x0000,   /* U+3DA9 */
  0x0000,   /* U+3DAA */
  0x0000,   /* U+3DAB */
  0x0000,   /* U+3DAC */
  0x0000,   /* U+3DAD */
  0x0000,   /* U+3DAE */
  0x0000,   /* U+3DAF */
  0x0000,   /* U+3DB0 */
  0x0000,   /* U+3DB1 */
  0x0000,   /* U+3DB2 */
  0x0000,   /* U+3DB3 */
  0x0000,   /* U+3DB4 */
  0x0000,   /* U+3DB5 */
  0x0000,   /* U+3DB6 */
  0x0000,   /* U+3DB7 */
  0x0000,   /* U+3DB8 */
  0x0000,   /* U+3DB9 */
  0x0000,   /* U+3DBA */
  0x0000,   /* U+3DBB */
  0x0000,   /* U+3DBC */
  0x0000,   /* U+3DBD */
  0x0000,   /* U+3DBE */
  0x0000,   /* U+3DBF */
  0x0000,   /* U+3DC0 */
  0x0000,   /* U+3DC1 */
  0x0000,   /* U+3DC2 */
  0x0000,   /* U+3DC3 */
  0x0000,   /* U+3DC4 */
  0x0000,   /* U+3DC5 */
  0x0000,   /* U+3DC6 */
  0x0000,   /* U+3DC7 */
  0x0000,   /* U+3DC8 */
  0x0000,   /* U+3DC9 */
  0x0000,   /* U+3DCA */
  0x0000,   /* U+3DCB */
  0x0000,   /* U+3DCC */
  0x0000,   /* U+3DCD */
  0x0000,   /* U+3DCE */
  0x0000,   /* U+3DCF */
  0x0000,   /* U+3DD0 */
  0x0000,   /* U+3DD1 */
  0x0000,   /* U+3DD2 */
  0x0000,   /* U+3DD3 */
  0x0000,   /* U+3DD4 */
  0x0000,   /* U+3DD5 */
  0x0000,   /* U+3DD6 */
  0x0000,   /* U+3DD7 */
  0x0000,   /* U+3DD8 */
  0x0000,   /* U+3DD9 */
  0x0000,   /* U+3DDA */
  0x0000,   /* U+3DDB */
  0x0000,   /* U+3DDC */
  0x0000,   /* U+3DDD */
  0x0000,   /* U+3DDE */
  0x0000,   /* U+3DDF */
  0x0000,   /* U+3DE0 */
  0x0000,   /* U+3DE1 */
  0x0000,   /* U+3DE2 */
  0x0000,   /* U+3DE3 */
  0x0000,   /* U+3DE4 */
  0x0000,   /* U+3DE5 */
  0x0000,   /* U+3DE6 */
  0x0000,   /* U+3DE7 */
  0x0000,   /* U+3DE8 */
  0x0000,   /* U+3DE9 */
  0x0000,   /* U+3DEA */
  0x0000,   /* U+3DEB */
  0x0000,   /* U+3DEC */
  0x0000,   /* U+3DED */
  0x0000,   /* U+3DEE */
  0x0000,   /* U+3DEF */
  0x0000,   /* U+3DF0 */
  0x0000,   /* U+3DF1 */
  0x0000,   /* U+3DF2 */
  0x0000,   /* U+3DF3 */
  0x0000,   /* U+3DF4 */
  0x0000,   /* U+3DF5 */
  0x0000,   /* U+3DF6 */
  0x0000,   /* U+3DF7 */
  0x0000,   /* U+3DF8 */
  0x0000,   /* U+3DF9 */
  0x0000,   /* U+3DFA */
  0x0000,   /* U+3DFB */
  0x0000,   /* U+3DFC */
  0x0000,   /* U+3DFD */
  0x0000,   /* U+3DFE */
  0x0000,   /* U+3DFF */
};

uint16 zh3_han_p03E[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C58,   /* U+3E00 */
  0x1C58,   /* U+3E01 */
  0x1C58,   /* U+3E02 */
  0x1C58,   /* U+3E03 */
  0x1C59,   /* U+3E04 */
  0x1C59,   /* U+3E05 */
  0x1C5A,   /* U+3E06 */
  0x1C5A,   /* U+3E07 */
  0x1C5B,   /* U+3E08 */
  0x1C5A,   /* U+3E09 */
  0x1C5B,   /* U+3E0A */
  0x1C5B,   /* U+3E0B */
  0x1C5B,   /* U+3E0C */
  0x1C5C,   /* U+3E0D */
  0x1C5D,   /* U+3E0E */
  0x1C5E,   /* U+3E0F */
  0x1C5E,   /* U+3E10 */
  0x1C61,   /* U+3E11 */
  0x1C4F,   /* U+3E12 */
  0x1C4F,   /* U+3E13 */
  0x1C52,   /* U+3E14 */
  0x1C55,   /* U+3E15 */
  0x1C50,   /* U+3E16 */
  0x1C51,   /* U+3E17 */
  0x1C52,   /* U+3E18 */
  0x1C54,   /* U+3E19 */
  0x1C4F,   /* U+3E1A */
  0x1C50,   /* U+3E1B */
  0x1C53,   /* U+3E1C */
  0x1C4F,   /* U+3E1D */
  0x1C4F,   /* U+3E1E */
  0x1C51,   /* U+3E1F */
  0x1C51,   /* U+3E20 */
  0x1C51,   /* U+3E21 */
  0x1C55,   /* U+3E22 */
  0x1C58,   /* U+3E23 */
  0x1C59,   /* U+3E24 */
  0x1C5C,   /* U+3E25 */
  0x1C4B,   /* U+3E26 */
  0x1C51,   /* U+3E27 */
  0x1C4D,   /* U+3E28 */
  0x1C4E,   /* U+3E29 */
  0x1C4E,   /* U+3E2A */
  0x1C4F,   /* U+3E2B */
  0x1C4F,   /* U+3E2C */
  0x1C4F,   /* U+3E2D */
  0x1C4F,   /* U+3E2E */
  0x1C4F,   /* U+3E2F */
  0x1C50,   /* U+3E30 */
  0x1C50,   /* U+3E31 */
  0x1C50,   /* U+3E32 */
  0x1C50,   /* U+3E33 */
  0x1C50,   /* U+3E34 */
  0x1C51,   /* U+3E35 */
  0x1C51,   /* U+3E36 */
  0x1C51,   /* U+3E37 */
  0x1C51,   /* U+3E38 */
  0x1C52,   /* U+3E39 */
  0x1C52,   /* U+3E3A */
  0x1C52,   /* U+3E3B */
  0x1C52,   /* U+3E3C */
  0x1C52,   /* U+3E3D */
  0x1C52,   /* U+3E3E */
  0x1C52,   /* U+3E3F */
  0x1C52,   /* U+3E40 */
  0x1C53,   /* U+3E41 */
  0x1C53,   /* U+3E42 */
  0x1C53,   /* U+3E43 */
  0x1C55,   /* U+3E44 */
  0x1C54,   /* U+3E45 */
  0x1C54,   /* U+3E46 */
  0x1C54,   /* U+3E47 */
  0x1C54,   /* U+3E48 */
  0x1C55,   /* U+3E49 */
  0x1C55,   /* U+3E4A */
  0x1C55,   /* U+3E4B */
  0x1C56,   /* U+3E4C */
  0x1C56,   /* U+3E4D */
  0x1C56,   /* U+3E4E */
  0x1C56,   /* U+3E4F */
  0x1C56,   /* U+3E50 */
  0x1C57,   /* U+3E51 */
  0x1C57,   /* U+3E52 */
  0x1C57,   /* U+3E53 */
  0x1C58,   /* U+3E54 */
  0x1C58,   /* U+3E55 */
  0x1C58,   /* U+3E56 */
  0x1C59,   /* U+3E57 */
  0x1C59,   /* U+3E58 */
  0x1C5A,   /* U+3E59 */
  0x1C5C,   /* U+3E5A */
  0x1C5D,   /* U+3E5B */
  0x1C4F,   /* U+3E5C */
  0x1C4E,   /* U+3E5D */
  0x1C4E,   /* U+3E5E */
  0x1C4E,   /* U+3E5F */
  0x1C4E,   /* U+3E60 */
  0x1C4F,   /* U+3E61 */
  0x1C4F,   /* U+3E62 */
  0x1C4F,   /* U+3E63 */
  0x1C4F,   /* U+3E64 */
  0x1C4F,   /* U+3E65 */
  0x1C4F,   /* U+3E66 */
  0x1C4F,   /* U+3E67 */
  0x1C4F,   /* U+3E68 */
  0x1C4F,   /* U+3E69 */
  0x1C4F,   /* U+3E6A */
  0x1C50,   /* U+3E6B */
  0x1C50,   /* U+3E6C */
  0x1C50,   /* U+3E6D */
  0x1C50,   /* U+3E6E */
  0x1C50,   /* U+3E6F */
  0x1C50,   /* U+3E70 */
  0x1C51,   /* U+3E71 */
  0x1C51,   /* U+3E72 */
  0x1C51,   /* U+3E73 */
  0x1C51,   /* U+3E74 */
  0x1C51,   /* U+3E75 */
  0x1C51,   /* U+3E76 */
  0x1C51,   /* U+3E77 */
  0x1C51,   /* U+3E78 */
  0x1C52,   /* U+3E79 */
  0x1C52,   /* U+3E7A */
  0x1C52,   /* U+3E7B */
  0x1C52,   /* U+3E7C */
  0x1C52,   /* U+3E7D */
  0x1C52,   /* U+3E7E */
  0x1C52,   /* U+3E7F */
  0x1C52,   /* U+3E80 */
  0x1C53,   /* U+3E81 */
  0x1C53,   /* U+3E82 */
  0x1C53,   /* U+3E83 */
  0x1C53,   /* U+3E84 */
  0x1C53,   /* U+3E85 */
  0x1C53,   /* U+3E86 */
  0x1C54,   /* U+3E87 */
  0x1C54,   /* U+3E88 */
  0x1C54,   /* U+3E89 */
  0x1C54,   /* U+3E8A */
  0x1C54,   /* U+3E8B */
  0x1C54,   /* U+3E8C */
  0x1C54,   /* U+3E8D */
  0x1C55,   /* U+3E8E */
  0x1C55,   /* U+3E8F */
  0x1C55,   /* U+3E90 */
  0x1C55,   /* U+3E91 */
  0x1C55,   /* U+3E92 */
  0x1C55,   /* U+3E93 */
  0x1C56,   /* U+3E94 */
  0x1C56,   /* U+3E95 */
  0x1C56,   /* U+3E96 */
  0x1C56,   /* U+3E97 */
  0x1C56,   /* U+3E98 */
  0x1C56,   /* U+3E99 */
  0x1C57,   /* U+3E9A */
  0x1C57,   /* U+3E9B */
  0x1C57,   /* U+3E9C */
  0x1C58,   /* U+3E9D */
  0x1C58,   /* U+3E9E */
  0x1C58,   /* U+3E9F */
  0x1C59,   /* U+3EA0 */
  0x1C5A,   /* U+3EA1 */
  0x1C5A,   /* U+3EA2 */
  0x1C5B,   /* U+3EA3 */
  0x1C5B,   /* U+3EA4 */
  0x1C5B,   /* U+3EA5 */
  0x1C5B,   /* U+3EA6 */
  0x1C5F,   /* U+3EA7 */
  0x1C4D,   /* U+3EA8 */
  0x1C4D,   /* U+3EA9 */
  0x1C4D,   /* U+3EAA */
  0x1C4D,   /* U+3EAB */
  0x1C4E,   /* U+3EAC */
  0x1C4E,   /* U+3EAD */
  0x1C4E,   /* U+3EAE */
  0x1C4E,   /* U+3EAF */
  0x1C4F,   /* U+3EB0 */
  0x1C50,   /* U+3EB1 */
  0x1C4F,   /* U+3EB2 */
  0x1C4F,   /* U+3EB3 */
  0x1C4F,   /* U+3EB4 */
  0x1C4F,   /* U+3EB5 */
  0x1C4F,   /* U+3EB6 */
  0x1C50,   /* U+3EB7 */
  0x1C51,   /* U+3EB8 */
  0x1C50,   /* U+3EB9 */
  0x1C50,   /* U+3EBA */
  0x1C50,   /* U+3EBB */
  0x1C50,   /* U+3EBC */
  0x1C50,   /* U+3EBD */
  0x1C50,   /* U+3EBE */
  0x1C51,   /* U+3EBF */
  0x1C51,   /* U+3EC0 */
  0x1C51,   /* U+3EC1 */
  0x1C51,   /* U+3EC2 */
  0x1C51,   /* U+3EC3 */
  0x1C51,   /* U+3EC4 */
  0x1C51,   /* U+3EC5 */
  0x1C51,   /* U+3EC6 */
  0x1C51,   /* U+3EC7 */
  0x1C51,   /* U+3EC8 */
  0x1C52,   /* U+3EC9 */
  0x1C52,   /* U+3ECA */
  0x1C52,   /* U+3ECB */
  0x1C52,   /* U+3ECC */
  0x1C52,   /* U+3ECD */
  0x1C52,   /* U+3ECE */
  0x1C52,   /* U+3ECF */
  0x1C52,   /* U+3ED0 */
  0x1C53,   /* U+3ED1 */
  0x1C53,   /* U+3ED2 */
  0x1C53,   /* U+3ED3 */
  0x1C53,   /* U+3ED4 */
  0x1C53,   /* U+3ED5 */
  0x1C53,   /* U+3ED6 */
  0x1C54,   /* U+3ED7 */
  0x1C53,   /* U+3ED8 */
  0x1C53,   /* U+3ED9 */
  0x1C53,   /* U+3EDA */
  0x1C53,   /* U+3EDB */
  0x1C53,   /* U+3EDC */
  0x1C54,   /* U+3EDD */
  0x1C54,   /* U+3EDE */
  0x1C54,   /* U+3EDF */
  0x1C54,   /* U+3EE0 */
  0x1C54,   /* U+3EE1 */
  0x1C54,   /* U+3EE2 */
  0x1C54,   /* U+3EE3 */
  0x1C54,   /* U+3EE4 */
  0x1C54,   /* U+3EE5 */
  0x1C54,   /* U+3EE6 */
  0x1C55,   /* U+3EE7 */
  0x1C55,   /* U+3EE8 */
  0x1C55,   /* U+3EE9 */
  0x1C55,   /* U+3EEA */
  0x1C56,   /* U+3EEB */
  0x1C56,   /* U+3EEC */
  0x1C56,   /* U+3EED */
  0x1C56,   /* U+3EEE */
  0x1C56,   /* U+3EEF */
  0x1C56,   /* U+3EF0 */
  0x1C56,   /* U+3EF1 */
  0x1C56,   /* U+3EF2 */
  0x1C56,   /* U+3EF3 */
  0x1C56,   /* U+3EF4 */
  0x1C57,   /* U+3EF5 */
  0x1C57,   /* U+3EF6 */
  0x1C57,   /* U+3EF7 */
  0x1C57,   /* U+3EF8 */
  0x1C58,   /* U+3EF9 */
  0x1C58,   /* U+3EFA */
  0x1C57,   /* U+3EFB */
  0x1C57,   /* U+3EFC */
  0x1C58,   /* U+3EFD */
  0x1C59,   /* U+3EFE */
  0x1C58,   /* U+3EFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3E00 */
  0x0020,   /* U+3E01 */
  0x0020,   /* U+3E02 */
  0x0020,   /* U+3E03 */
  0x0020,   /* U+3E04 */
  0x0020,   /* U+3E05 */
  0x0020,   /* U+3E06 */
  0x0020,   /* U+3E07 */
  0x0020,   /* U+3E08 */
  0x0020,   /* U+3E09 */
  0x0020,   /* U+3E0A */
  0x0020,   /* U+3E0B */
  0x0020,   /* U+3E0C */
  0x0020,   /* U+3E0D */
  0x0020,   /* U+3E0E */
  0x0020,   /* U+3E0F */
  0x0020,   /* U+3E10 */
  0x0020,   /* U+3E11 */
  0x0020,   /* U+3E12 */
  0x0020,   /* U+3E13 */
  0x0020,   /* U+3E14 */
  0x0020,   /* U+3E15 */
  0x0020,   /* U+3E16 */
  0x0020,   /* U+3E17 */
  0x0020,   /* U+3E18 */
  0x0020,   /* U+3E19 */
  0x0020,   /* U+3E1A */
  0x0020,   /* U+3E1B */
  0x0020,   /* U+3E1C */
  0x0020,   /* U+3E1D */
  0x0020,   /* U+3E1E */
  0x0020,   /* U+3E1F */
  0x0020,   /* U+3E20 */
  0x0020,   /* U+3E21 */
  0x0020,   /* U+3E22 */
  0x0020,   /* U+3E23 */
  0x0020,   /* U+3E24 */
  0x0020,   /* U+3E25 */
  0x0020,   /* U+3E26 */
  0x0020,   /* U+3E27 */
  0x0020,   /* U+3E28 */
  0x0020,   /* U+3E29 */
  0x0020,   /* U+3E2A */
  0x0020,   /* U+3E2B */
  0x0020,   /* U+3E2C */
  0x0020,   /* U+3E2D */
  0x0020,   /* U+3E2E */
  0x0020,   /* U+3E2F */
  0x0020,   /* U+3E30 */
  0x0020,   /* U+3E31 */
  0x0020,   /* U+3E32 */
  0x0020,   /* U+3E33 */
  0x0020,   /* U+3E34 */
  0x0020,   /* U+3E35 */
  0x0020,   /* U+3E36 */
  0x0020,   /* U+3E37 */
  0x0020,   /* U+3E38 */
  0x0020,   /* U+3E39 */
  0x0020,   /* U+3E3A */
  0x0020,   /* U+3E3B */
  0x0020,   /* U+3E3C */
  0x0020,   /* U+3E3D */
  0x0020,   /* U+3E3E */
  0x0020,   /* U+3E3F */
  0x0020,   /* U+3E40 */
  0x0020,   /* U+3E41 */
  0x0020,   /* U+3E42 */
  0x0020,   /* U+3E43 */
  0x0020,   /* U+3E44 */
  0x0020,   /* U+3E45 */
  0x0020,   /* U+3E46 */
  0x0020,   /* U+3E47 */
  0x0020,   /* U+3E48 */
  0x0020,   /* U+3E49 */
  0x0020,   /* U+3E4A */
  0x0020,   /* U+3E4B */
  0x0020,   /* U+3E4C */
  0x0020,   /* U+3E4D */
  0x0020,   /* U+3E4E */
  0x0020,   /* U+3E4F */
  0x0020,   /* U+3E50 */
  0x0020,   /* U+3E51 */
  0x0020,   /* U+3E52 */
  0x0020,   /* U+3E53 */
  0x0020,   /* U+3E54 */
  0x0020,   /* U+3E55 */
  0x0020,   /* U+3E56 */
  0x0020,   /* U+3E57 */
  0x0020,   /* U+3E58 */
  0x0020,   /* U+3E59 */
  0x0020,   /* U+3E5A */
  0x0020,   /* U+3E5B */
  0x0020,   /* U+3E5C */
  0x0020,   /* U+3E5D */
  0x0020,   /* U+3E5E */
  0x0020,   /* U+3E5F */
  0x0020,   /* U+3E60 */
  0x0020,   /* U+3E61 */
  0x0020,   /* U+3E62 */
  0x0020,   /* U+3E63 */
  0x0020,   /* U+3E64 */
  0x0020,   /* U+3E65 */
  0x0020,   /* U+3E66 */
  0x0020,   /* U+3E67 */
  0x0020,   /* U+3E68 */
  0x0020,   /* U+3E69 */
  0x0020,   /* U+3E6A */
  0x0020,   /* U+3E6B */
  0x0020,   /* U+3E6C */
  0x0020,   /* U+3E6D */
  0x0020,   /* U+3E6E */
  0x0020,   /* U+3E6F */
  0x0020,   /* U+3E70 */
  0x0020,   /* U+3E71 */
  0x0020,   /* U+3E72 */
  0x0020,   /* U+3E73 */
  0x0020,   /* U+3E74 */
  0x0020,   /* U+3E75 */
  0x0020,   /* U+3E76 */
  0x0020,   /* U+3E77 */
  0x0020,   /* U+3E78 */
  0x0020,   /* U+3E79 */
  0x0020,   /* U+3E7A */
  0x0020,   /* U+3E7B */
  0x0020,   /* U+3E7C */
  0x0020,   /* U+3E7D */
  0x0020,   /* U+3E7E */
  0x0020,   /* U+3E7F */
  0x0020,   /* U+3E80 */
  0x0020,   /* U+3E81 */
  0x0020,   /* U+3E82 */
  0x0020,   /* U+3E83 */
  0x0020,   /* U+3E84 */
  0x0020,   /* U+3E85 */
  0x0020,   /* U+3E86 */
  0x0020,   /* U+3E87 */
  0x0020,   /* U+3E88 */
  0x0020,   /* U+3E89 */
  0x0020,   /* U+3E8A */
  0x0020,   /* U+3E8B */
  0x0020,   /* U+3E8C */
  0x0020,   /* U+3E8D */
  0x0020,   /* U+3E8E */
  0x0020,   /* U+3E8F */
  0x0020,   /* U+3E90 */
  0x0020,   /* U+3E91 */
  0x0020,   /* U+3E92 */
  0x0020,   /* U+3E93 */
  0x0020,   /* U+3E94 */
  0x0020,   /* U+3E95 */
  0x0020,   /* U+3E96 */
  0x0020,   /* U+3E97 */
  0x0020,   /* U+3E98 */
  0x0020,   /* U+3E99 */
  0x0020,   /* U+3E9A */
  0x0020,   /* U+3E9B */
  0x0020,   /* U+3E9C */
  0x0020,   /* U+3E9D */
  0x0020,   /* U+3E9E */
  0x0020,   /* U+3E9F */
  0x0020,   /* U+3EA0 */
  0x0020,   /* U+3EA1 */
  0x0020,   /* U+3EA2 */
  0x0020,   /* U+3EA3 */
  0x0020,   /* U+3EA4 */
  0x0020,   /* U+3EA5 */
  0x0020,   /* U+3EA6 */
  0x0020,   /* U+3EA7 */
  0x0020,   /* U+3EA8 */
  0x0020,   /* U+3EA9 */
  0x0020,   /* U+3EAA */
  0x0020,   /* U+3EAB */
  0x0020,   /* U+3EAC */
  0x0020,   /* U+3EAD */
  0x0020,   /* U+3EAE */
  0x0020,   /* U+3EAF */
  0x0020,   /* U+3EB0 */
  0x0020,   /* U+3EB1 */
  0x0020,   /* U+3EB2 */
  0x0020,   /* U+3EB3 */
  0x0020,   /* U+3EB4 */
  0x0020,   /* U+3EB5 */
  0x0020,   /* U+3EB6 */
  0x0020,   /* U+3EB7 */
  0x0020,   /* U+3EB8 */
  0x0020,   /* U+3EB9 */
  0x0020,   /* U+3EBA */
  0x0020,   /* U+3EBB */
  0x0020,   /* U+3EBC */
  0x0020,   /* U+3EBD */
  0x0020,   /* U+3EBE */
  0x0020,   /* U+3EBF */
  0x0020,   /* U+3EC0 */
  0x0020,   /* U+3EC1 */
  0x0020,   /* U+3EC2 */
  0x0020,   /* U+3EC3 */
  0x0020,   /* U+3EC4 */
  0x0020,   /* U+3EC5 */
  0x0020,   /* U+3EC6 */
  0x0020,   /* U+3EC7 */
  0x0020,   /* U+3EC8 */
  0x0020,   /* U+3EC9 */
  0x0020,   /* U+3ECA */
  0x0020,   /* U+3ECB */
  0x0020,   /* U+3ECC */
  0x0020,   /* U+3ECD */
  0x0020,   /* U+3ECE */
  0x0020,   /* U+3ECF */
  0x0020,   /* U+3ED0 */
  0x0020,   /* U+3ED1 */
  0x0020,   /* U+3ED2 */
  0x0020,   /* U+3ED3 */
  0x0020,   /* U+3ED4 */
  0x0020,   /* U+3ED5 */
  0x0020,   /* U+3ED6 */
  0x0020,   /* U+3ED7 */
  0x0020,   /* U+3ED8 */
  0x0020,   /* U+3ED9 */
  0x0020,   /* U+3EDA */
  0x0020,   /* U+3EDB */
  0x0020,   /* U+3EDC */
  0x0020,   /* U+3EDD */
  0x0020,   /* U+3EDE */
  0x0020,   /* U+3EDF */
  0x0020,   /* U+3EE0 */
  0x0020,   /* U+3EE1 */
  0x0020,   /* U+3EE2 */
  0x0020,   /* U+3EE3 */
  0x0020,   /* U+3EE4 */
  0x0020,   /* U+3EE5 */
  0x0020,   /* U+3EE6 */
  0x0020,   /* U+3EE7 */
  0x0020,   /* U+3EE8 */
  0x0020,   /* U+3EE9 */
  0x0020,   /* U+3EEA */
  0x0020,   /* U+3EEB */
  0x0020,   /* U+3EEC */
  0x0020,   /* U+3EED */
  0x0020,   /* U+3EEE */
  0x0020,   /* U+3EEF */
  0x0020,   /* U+3EF0 */
  0x0020,   /* U+3EF1 */
  0x0020,   /* U+3EF2 */
  0x0020,   /* U+3EF3 */
  0x0020,   /* U+3EF4 */
  0x0020,   /* U+3EF5 */
  0x0020,   /* U+3EF6 */
  0x0020,   /* U+3EF7 */
  0x0020,   /* U+3EF8 */
  0x0020,   /* U+3EF9 */
  0x0020,   /* U+3EFA */
  0x0020,   /* U+3EFB */
  0x0020,   /* U+3EFC */
  0x0020,   /* U+3EFD */
  0x0020,   /* U+3EFE */
  0x0020,   /* U+3EFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3E00 */
  0x0002,   /* U+3E01 */
  0x0002,   /* U+3E02 */
  0x0002,   /* U+3E03 */
  0x0002,   /* U+3E04 */
  0x0002,   /* U+3E05 */
  0x0002,   /* U+3E06 */
  0x0002,   /* U+3E07 */
  0x0002,   /* U+3E08 */
  0x0002,   /* U+3E09 */
  0x0002,   /* U+3E0A */
  0x0002,   /* U+3E0B */
  0x0002,   /* U+3E0C */
  0x0002,   /* U+3E0D */
  0x0002,   /* U+3E0E */
  0x0002,   /* U+3E0F */
  0x0002,   /* U+3E10 */
  0x0002,   /* U+3E11 */
  0x0002,   /* U+3E12 */
  0x0002,   /* U+3E13 */
  0x0002,   /* U+3E14 */
  0x0002,   /* U+3E15 */
  0x0002,   /* U+3E16 */
  0x0002,   /* U+3E17 */
  0x0002,   /* U+3E18 */
  0x0002,   /* U+3E19 */
  0x0002,   /* U+3E1A */
  0x0002,   /* U+3E1B */
  0x0002,   /* U+3E1C */
  0x0002,   /* U+3E1D */
  0x0002,   /* U+3E1E */
  0x0002,   /* U+3E1F */
  0x0002,   /* U+3E20 */
  0x0002,   /* U+3E21 */
  0x0002,   /* U+3E22 */
  0x0002,   /* U+3E23 */
  0x0002,   /* U+3E24 */
  0x0002,   /* U+3E25 */
  0x0002,   /* U+3E26 */
  0x0002,   /* U+3E27 */
  0x0002,   /* U+3E28 */
  0x0002,   /* U+3E29 */
  0x0002,   /* U+3E2A */
  0x0002,   /* U+3E2B */
  0x0002,   /* U+3E2C */
  0x0002,   /* U+3E2D */
  0x0002,   /* U+3E2E */
  0x0002,   /* U+3E2F */
  0x0002,   /* U+3E30 */
  0x0002,   /* U+3E31 */
  0x0002,   /* U+3E32 */
  0x0002,   /* U+3E33 */
  0x0002,   /* U+3E34 */
  0x0002,   /* U+3E35 */
  0x0002,   /* U+3E36 */
  0x0002,   /* U+3E37 */
  0x0002,   /* U+3E38 */
  0x0002,   /* U+3E39 */
  0x0002,   /* U+3E3A */
  0x0002,   /* U+3E3B */
  0x0002,   /* U+3E3C */
  0x0002,   /* U+3E3D */
  0x0002,   /* U+3E3E */
  0x0002,   /* U+3E3F */
  0x0002,   /* U+3E40 */
  0x0002,   /* U+3E41 */
  0x0002,   /* U+3E42 */
  0x0002,   /* U+3E43 */
  0x0002,   /* U+3E44 */
  0x0002,   /* U+3E45 */
  0x0002,   /* U+3E46 */
  0x0002,   /* U+3E47 */
  0x0002,   /* U+3E48 */
  0x0002,   /* U+3E49 */
  0x0002,   /* U+3E4A */
  0x0002,   /* U+3E4B */
  0x0002,   /* U+3E4C */
  0x0002,   /* U+3E4D */
  0x0002,   /* U+3E4E */
  0x0002,   /* U+3E4F */
  0x0002,   /* U+3E50 */
  0x0002,   /* U+3E51 */
  0x0002,   /* U+3E52 */
  0x0002,   /* U+3E53 */
  0x0002,   /* U+3E54 */
  0x0002,   /* U+3E55 */
  0x0002,   /* U+3E56 */
  0x0002,   /* U+3E57 */
  0x0002,   /* U+3E58 */
  0x0002,   /* U+3E59 */
  0x0002,   /* U+3E5A */
  0x0002,   /* U+3E5B */
  0x0002,   /* U+3E5C */
  0x0002,   /* U+3E5D */
  0x0002,   /* U+3E5E */
  0x0002,   /* U+3E5F */
  0x0002,   /* U+3E60 */
  0x0002,   /* U+3E61 */
  0x0002,   /* U+3E62 */
  0x0002,   /* U+3E63 */
  0x0002,   /* U+3E64 */
  0x0002,   /* U+3E65 */
  0x0002,   /* U+3E66 */
  0x0002,   /* U+3E67 */
  0x0002,   /* U+3E68 */
  0x0002,   /* U+3E69 */
  0x0002,   /* U+3E6A */
  0x0002,   /* U+3E6B */
  0x0002,   /* U+3E6C */
  0x0002,   /* U+3E6D */
  0x0002,   /* U+3E6E */
  0x0002,   /* U+3E6F */
  0x0002,   /* U+3E70 */
  0x0002,   /* U+3E71 */
  0x0002,   /* U+3E72 */
  0x0002,   /* U+3E73 */
  0x0002,   /* U+3E74 */
  0x0002,   /* U+3E75 */
  0x0002,   /* U+3E76 */
  0x0002,   /* U+3E77 */
  0x0002,   /* U+3E78 */
  0x0002,   /* U+3E79 */
  0x0002,   /* U+3E7A */
  0x0002,   /* U+3E7B */
  0x0002,   /* U+3E7C */
  0x0002,   /* U+3E7D */
  0x0002,   /* U+3E7E */
  0x0002,   /* U+3E7F */
  0x0002,   /* U+3E80 */
  0x0002,   /* U+3E81 */
  0x0002,   /* U+3E82 */
  0x0002,   /* U+3E83 */
  0x0002,   /* U+3E84 */
  0x0002,   /* U+3E85 */
  0x0002,   /* U+3E86 */
  0x0002,   /* U+3E87 */
  0x0002,   /* U+3E88 */
  0x0002,   /* U+3E89 */
  0x0002,   /* U+3E8A */
  0x0002,   /* U+3E8B */
  0x0002,   /* U+3E8C */
  0x0002,   /* U+3E8D */
  0x0002,   /* U+3E8E */
  0x0002,   /* U+3E8F */
  0x0002,   /* U+3E90 */
  0x0002,   /* U+3E91 */
  0x0002,   /* U+3E92 */
  0x0002,   /* U+3E93 */
  0x0002,   /* U+3E94 */
  0x0002,   /* U+3E95 */
  0x0002,   /* U+3E96 */
  0x0002,   /* U+3E97 */
  0x0002,   /* U+3E98 */
  0x0002,   /* U+3E99 */
  0x0002,   /* U+3E9A */
  0x0002,   /* U+3E9B */
  0x0002,   /* U+3E9C */
  0x0002,   /* U+3E9D */
  0x0002,   /* U+3E9E */
  0x0002,   /* U+3E9F */
  0x0002,   /* U+3EA0 */
  0x0002,   /* U+3EA1 */
  0x0002,   /* U+3EA2 */
  0x0002,   /* U+3EA3 */
  0x0002,   /* U+3EA4 */
  0x0002,   /* U+3EA5 */
  0x0002,   /* U+3EA6 */
  0x0002,   /* U+3EA7 */
  0x0002,   /* U+3EA8 */
  0x0002,   /* U+3EA9 */
  0x0002,   /* U+3EAA */
  0x0002,   /* U+3EAB */
  0x0002,   /* U+3EAC */
  0x0002,   /* U+3EAD */
  0x0002,   /* U+3EAE */
  0x0002,   /* U+3EAF */
  0x0002,   /* U+3EB0 */
  0x0002,   /* U+3EB1 */
  0x0002,   /* U+3EB2 */
  0x0002,   /* U+3EB3 */
  0x0002,   /* U+3EB4 */
  0x0002,   /* U+3EB5 */
  0x0002,   /* U+3EB6 */
  0x0002,   /* U+3EB7 */
  0x0002,   /* U+3EB8 */
  0x0002,   /* U+3EB9 */
  0x0002,   /* U+3EBA */
  0x0002,   /* U+3EBB */
  0x0002,   /* U+3EBC */
  0x0002,   /* U+3EBD */
  0x0002,   /* U+3EBE */
  0x0002,   /* U+3EBF */
  0x0002,   /* U+3EC0 */
  0x0002,   /* U+3EC1 */
  0x0002,   /* U+3EC2 */
  0x0002,   /* U+3EC3 */
  0x0002,   /* U+3EC4 */
  0x0002,   /* U+3EC5 */
  0x0002,   /* U+3EC6 */
  0x0002,   /* U+3EC7 */
  0x0002,   /* U+3EC8 */
  0x0002,   /* U+3EC9 */
  0x0002,   /* U+3ECA */
  0x0002,   /* U+3ECB */
  0x0002,   /* U+3ECC */
  0x0002,   /* U+3ECD */
  0x0002,   /* U+3ECE */
  0x0002,   /* U+3ECF */
  0x0002,   /* U+3ED0 */
  0x0002,   /* U+3ED1 */
  0x0002,   /* U+3ED2 */
  0x0002,   /* U+3ED3 */
  0x0002,   /* U+3ED4 */
  0x0002,   /* U+3ED5 */
  0x0002,   /* U+3ED6 */
  0x0002,   /* U+3ED7 */
  0x0002,   /* U+3ED8 */
  0x0002,   /* U+3ED9 */
  0x0002,   /* U+3EDA */
  0x0002,   /* U+3EDB */
  0x0002,   /* U+3EDC */
  0x0002,   /* U+3EDD */
  0x0002,   /* U+3EDE */
  0x0002,   /* U+3EDF */
  0x0002,   /* U+3EE0 */
  0x0002,   /* U+3EE1 */
  0x0002,   /* U+3EE2 */
  0x0002,   /* U+3EE3 */
  0x0002,   /* U+3EE4 */
  0x0002,   /* U+3EE5 */
  0x0002,   /* U+3EE6 */
  0x0002,   /* U+3EE7 */
  0x0002,   /* U+3EE8 */
  0x0002,   /* U+3EE9 */
  0x0002,   /* U+3EEA */
  0x0002,   /* U+3EEB */
  0x0002,   /* U+3EEC */
  0x0002,   /* U+3EED */
  0x0002,   /* U+3EEE */
  0x0002,   /* U+3EEF */
  0x0002,   /* U+3EF0 */
  0x0002,   /* U+3EF1 */
  0x0002,   /* U+3EF2 */
  0x0002,   /* U+3EF3 */
  0x0002,   /* U+3EF4 */
  0x0002,   /* U+3EF5 */
  0x0002,   /* U+3EF6 */
  0x0002,   /* U+3EF7 */
  0x0002,   /* U+3EF8 */
  0x0002,   /* U+3EF9 */
  0x0002,   /* U+3EFA */
  0x0002,   /* U+3EFB */
  0x0002,   /* U+3EFC */
  0x0002,   /* U+3EFD */
  0x0002,   /* U+3EFE */
  0x0002,   /* U+3EFF */

  /* Primary weight 2 for each character. */
  0x85AE,   /* U+3E00 */
  0x85AF,   /* U+3E01 */
  0x85B0,   /* U+3E02 */
  0x85B1,   /* U+3E03 */
  0x84F8,   /* U+3E04 */
  0x84F9,   /* U+3E05 */
  0x83A9,   /* U+3E06 */
  0x83AA,   /* U+3E07 */
  0x8287,   /* U+3E08 */
  0x83AB,   /* U+3E09 */
  0x8288,   /* U+3E0A */
  0x8289,   /* U+3E0B */
  0x828A,   /* U+3E0C */
  0x8202,   /* U+3E0D */
  0x817A,   /* U+3E0E */
  0x80FF,   /* U+3E0F */
  0x8100,   /* U+3E10 */
  0x804E,   /* U+3E11 */
  0x8AFF,   /* U+3E12 */
  0x8B00,   /* U+3E13 */
  0x8E79,   /* U+3E14 */
  0x8C64,   /* U+3E15 */
  0x8C37,   /* U+3E16 */
  0x8DB9,   /* U+3E17 */
  0x8E83,   /* U+3E18 */
  0x8D50,   /* U+3E19 */
  0x8B0F,   /* U+3E1A */
  0x8C3E,   /* U+3E1B */
  0x8F59,   /* U+3E1C */
  0x8B1C,   /* U+3E1D */
  0x8B1D,   /* U+3E1E */
  0x8DC9,   /* U+3E1F */
  0x8DCA,   /* U+3E20 */
  0x8DCB,   /* U+3E21 */
  0x8C7A,   /* U+3E22 */
  0x8615,   /* U+3E23 */
  0x8546,   /* U+3E24 */
  0x8220,   /* U+3E25 */
  0x81AE,   /* U+3E26 */
  0x8DD3,   /* U+3E27 */
  0x8574,   /* U+3E28 */
  0x88AB,   /* U+3E29 */
  0x88AC,   /* U+3E2A */
  0x8B33,   /* U+3E2B */
  0x8B34,   /* U+3E2C */
  0x8B35,   /* U+3E2D */
  0x8B36,   /* U+3E2E */
  0x8B37,   /* U+3E2F */
  0x8C64,   /* U+3E30 */
  0x8C65,   /* U+3E31 */
  0x8C66,   /* U+3E32 */
  0x8C67,   /* U+3E33 */
  0x8C68,   /* U+3E34 */
  0x8DDF,   /* U+3E35 */
  0x8DE0,   /* U+3E36 */
  0x8DE1,   /* U+3E37 */
  0x8DE2,   /* U+3E38 */
  0x8EAC,   /* U+3E39 */
  0x8EAD,   /* U+3E3A */
  0x8EAE,   /* U+3E3B */
  0x8EAF,   /* U+3E3C */
  0x8EB0,   /* U+3E3D */
  0x8EB1,   /* U+3E3E */
  0x8EB2,   /* U+3E3F */
  0x8EB3,   /* U+3E40 */
  0x8F93,   /* U+3E41 */
  0x8F94,   /* U+3E42 */
  0x8F95,   /* U+3E43 */
  0x8C89,   /* U+3E44 */
  0x8D6E,   /* U+3E45 */
  0x8D6F,   /* U+3E46 */
  0x8D70,   /* U+3E47 */
  0x8D71,   /* U+3E48 */
  0x8C8A,   /* U+3E49 */
  0x8C8B,   /* U+3E4A */
  0x8C8C,   /* U+3E4B */
  0x8B42,   /* U+3E4C */
  0x8B43,   /* U+3E4D */
  0x8B44,   /* U+3E4E */
  0x8B45,   /* U+3E4F */
  0x8B46,   /* U+3E50 */
  0x8939,   /* U+3E51 */
  0x893A,   /* U+3E52 */
  0x893B,   /* U+3E53 */
  0x861D,   /* U+3E54 */
  0x861E,   /* U+3E55 */
  0x861F,   /* U+3E56 */
  0x854D,   /* U+3E57 */
  0x854E,   /* U+3E58 */
  0x83EB,   /* U+3E59 */
  0x8222,   /* U+3E5A */
  0x818E,   /* U+3E5B */
  0x8B60,   /* U+3E5C */
  0x88C7,   /* U+3E5D */
  0x88C8,   /* U+3E5E */
  0x88C9,   /* U+3E5F */
  0x88CA,   /* U+3E60 */
  0x8B77,   /* U+3E61 */
  0x8B78,   /* U+3E62 */
  0x8B79,   /* U+3E63 */
  0x8B7A,   /* U+3E64 */
  0x8B7B,   /* U+3E65 */
  0x8B7C,   /* U+3E66 */
  0x8B7D,   /* U+3E67 */
  0x8B7E,   /* U+3E68 */
  0x8B7F,   /* U+3E69 */
  0x8B80,   /* U+3E6A */
  0x8CA9,   /* U+3E6B */
  0x8CAA,   /* U+3E6C */
  0x8CAB,   /* U+3E6D */
  0x8CAC,   /* U+3E6E */
  0x8CAD,   /* U+3E6F */
  0x8CAE,   /* U+3E70 */
  0x8E06,   /* U+3E71 */
  0x8E07,   /* U+3E72 */
  0x8E08,   /* U+3E73 */
  0x8E09,   /* U+3E74 */
  0x8E0A,   /* U+3E75 */
  0x8E0B,   /* U+3E76 */
  0x8E0C,   /* U+3E77 */
  0x8E0D,   /* U+3E78 */
  0x8EEC,   /* U+3E79 */
  0x8EED,   /* U+3E7A */
  0x8EEE,   /* U+3E7B */
  0x8EEF,   /* U+3E7C */
  0x8EF0,   /* U+3E7D */
  0x8EF1,   /* U+3E7E */
  0x8EF2,   /* U+3E7F */
  0x8EF3,   /* U+3E80 */
  0x8FDE,   /* U+3E81 */
  0x8FDF,   /* U+3E82 */
  0x8FE0,   /* U+3E83 */
  0x8FE1,   /* U+3E84 */
  0x8FE2,   /* U+3E85 */
  0x8FE3,   /* U+3E86 */
  0x8DA4,   /* U+3E87 */
  0x8DA5,   /* U+3E88 */
  0x8DA6,   /* U+3E89 */
  0x8DA7,   /* U+3E8A */
  0x8DA8,   /* U+3E8B */
  0x8DA9,   /* U+3E8C */
  0x8DAA,   /* U+3E8D */
  0x8CC3,   /* U+3E8E */
  0x8CC4,   /* U+3E8F */
  0x8CC5,   /* U+3E90 */
  0x8CC6,   /* U+3E91 */
  0x8CC7,   /* U+3E92 */
  0x8CC8,   /* U+3E93 */
  0x8B75,   /* U+3E94 */
  0x8B76,   /* U+3E95 */
  0x8B77,   /* U+3E96 */
  0x8B78,   /* U+3E97 */
  0x8B79,   /* U+3E98 */
  0x8B7A,   /* U+3E99 */
  0x895C,   /* U+3E9A */
  0x895D,   /* U+3E9B */
  0x895E,   /* U+3E9C */
  0x8633,   /* U+3E9D */
  0x8634,   /* U+3E9E */
  0x8635,   /* U+3E9F */
  0x8555,   /* U+3EA0 */
  0x83F7,   /* U+3EA1 */
  0x83F8,   /* U+3EA2 */
  0x82DC,   /* U+3EA3 */
  0x82DD,   /* U+3EA4 */
  0x82DE,   /* U+3EA5 */
  0x82DF,   /* U+3EA6 */
  0x80D4,   /* U+3EA7 */
  0x8597,   /* U+3EA8 */
  0x8598,   /* U+3EA9 */
  0x8599,   /* U+3EAA */
  0x859A,   /* U+3EAB */
  0x88FE,   /* U+3EAC */
  0x88FF,   /* U+3EAD */
  0x8900,   /* U+3EAE */
  0x8901,   /* U+3EAF */
  0x8BC4,   /* U+3EB0 */
  0x8CEC,   /* U+3EB1 */
  0x8BC5,   /* U+3EB2 */
  0x8BC6,   /* U+3EB3 */
  0x8BC7,   /* U+3EB4 */
  0x8BC8,   /* U+3EB5 */
  0x8BC9,   /* U+3EB6 */
  0x8D0D,   /* U+3EB7 */
  0x8E4B,   /* U+3EB8 */
  0x8D0E,   /* U+3EB9 */
  0x8D0F,   /* U+3EBA */
  0x8D10,   /* U+3EBB */
  0x8D11,   /* U+3EBC */
  0x8D12,   /* U+3EBD */
  0x8D13,   /* U+3EBE */
  0x8E6F,   /* U+3EBF */
  0x8E70,   /* U+3EC0 */
  0x8E71,   /* U+3EC1 */
  0x8E72,   /* U+3EC2 */
  0x8E73,   /* U+3EC3 */
  0x8E74,   /* U+3EC4 */
  0x8E75,   /* U+3EC5 */
  0x8E76,   /* U+3EC6 */
  0x8E77,   /* U+3EC7 */
  0x8E78,   /* U+3EC8 */
  0x8F49,   /* U+3EC9 */
  0x8F4A,   /* U+3ECA */
  0x8F4B,   /* U+3ECB */
  0x8F4C,   /* U+3ECC */
  0x8F4D,   /* U+3ECD */
  0x8F4E,   /* U+3ECE */
  0x8F4F,   /* U+3ECF */
  0x8F50,   /* U+3ED0 */
  0x9055,   /* U+3ED1 */
  0x9056,   /* U+3ED2 */
  0x9057,   /* U+3ED3 */
  0x9058,   /* U+3ED4 */
  0x9059,   /* U+3ED5 */
  0x905A,   /* U+3ED6 */
  0x8DE1,   /* U+3ED7 */
  0x905B,   /* U+3ED8 */
  0x905C,   /* U+3ED9 */
  0x905D,   /* U+3EDA */
  0x905E,   /* U+3EDB */
  0x905F,   /* U+3EDC */
  0x8E07,   /* U+3EDD */
  0x8E08,   /* U+3EDE */
  0x8E09,   /* U+3EDF */
  0x8E0A,   /* U+3EE0 */
  0x8E0B,   /* U+3EE1 */
  0x8E0C,   /* U+3EE2 */
  0x8E0D,   /* U+3EE3 */
  0x8E0E,   /* U+3EE4 */
  0x8E0F,   /* U+3EE5 */
  0x8E10,   /* U+3EE6 */
  0x8D17,   /* U+3EE7 */
  0x8D18,   /* U+3EE8 */
  0x8D19,   /* U+3EE9 */
  0x8D1A,   /* U+3EEA */
  0x8BC3,   /* U+3EEB */
  0x8BC4,   /* U+3EEC */
  0x8BC5,   /* U+3EED */
  0x8BC6,   /* U+3EEE */
  0x8BC7,   /* U+3EEF */
  0x8BC8,   /* U+3EF0 */
  0x8BC9,   /* U+3EF1 */
  0x8BCA,   /* U+3EF2 */
  0x8BCB,   /* U+3EF3 */
  0x8BCC,   /* U+3EF4 */
  0x8991,   /* U+3EF5 */
  0x8992,   /* U+3EF6 */
  0x8993,   /* U+3EF7 */
  0x8994,   /* U+3EF8 */
  0x8648,   /* U+3EF9 */
  0x8649,   /* U+3EFA */
  0x8995,   /* U+3EFB */
  0x8996,   /* U+3EFC */
  0x865A,   /* U+3EFD */
  0x856D,   /* U+3EFE */
  0x865B,   /* U+3EFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3E00 */
  0x0000,   /* U+3E01 */
  0x0000,   /* U+3E02 */
  0x0000,   /* U+3E03 */
  0x0000,   /* U+3E04 */
  0x0000,   /* U+3E05 */
  0x0000,   /* U+3E06 */
  0x0000,   /* U+3E07 */
  0x0000,   /* U+3E08 */
  0x0000,   /* U+3E09 */
  0x0000,   /* U+3E0A */
  0x0000,   /* U+3E0B */
  0x0000,   /* U+3E0C */
  0x0000,   /* U+3E0D */
  0x0000,   /* U+3E0E */
  0x0000,   /* U+3E0F */
  0x0000,   /* U+3E10 */
  0x0000,   /* U+3E11 */
  0x0000,   /* U+3E12 */
  0x0000,   /* U+3E13 */
  0x0000,   /* U+3E14 */
  0x0000,   /* U+3E15 */
  0x0000,   /* U+3E16 */
  0x0000,   /* U+3E17 */
  0x0000,   /* U+3E18 */
  0x0000,   /* U+3E19 */
  0x0000,   /* U+3E1A */
  0x0000,   /* U+3E1B */
  0x0000,   /* U+3E1C */
  0x0000,   /* U+3E1D */
  0x0000,   /* U+3E1E */
  0x0000,   /* U+3E1F */
  0x0000,   /* U+3E20 */
  0x0000,   /* U+3E21 */
  0x0000,   /* U+3E22 */
  0x0000,   /* U+3E23 */
  0x0000,   /* U+3E24 */
  0x0000,   /* U+3E25 */
  0x0000,   /* U+3E26 */
  0x0000,   /* U+3E27 */
  0x0000,   /* U+3E28 */
  0x0000,   /* U+3E29 */
  0x0000,   /* U+3E2A */
  0x0000,   /* U+3E2B */
  0x0000,   /* U+3E2C */
  0x0000,   /* U+3E2D */
  0x0000,   /* U+3E2E */
  0x0000,   /* U+3E2F */
  0x0000,   /* U+3E30 */
  0x0000,   /* U+3E31 */
  0x0000,   /* U+3E32 */
  0x0000,   /* U+3E33 */
  0x0000,   /* U+3E34 */
  0x0000,   /* U+3E35 */
  0x0000,   /* U+3E36 */
  0x0000,   /* U+3E37 */
  0x0000,   /* U+3E38 */
  0x0000,   /* U+3E39 */
  0x0000,   /* U+3E3A */
  0x0000,   /* U+3E3B */
  0x0000,   /* U+3E3C */
  0x0000,   /* U+3E3D */
  0x0000,   /* U+3E3E */
  0x0000,   /* U+3E3F */
  0x0000,   /* U+3E40 */
  0x0000,   /* U+3E41 */
  0x0000,   /* U+3E42 */
  0x0000,   /* U+3E43 */
  0x0000,   /* U+3E44 */
  0x0000,   /* U+3E45 */
  0x0000,   /* U+3E46 */
  0x0000,   /* U+3E47 */
  0x0000,   /* U+3E48 */
  0x0000,   /* U+3E49 */
  0x0000,   /* U+3E4A */
  0x0000,   /* U+3E4B */
  0x0000,   /* U+3E4C */
  0x0000,   /* U+3E4D */
  0x0000,   /* U+3E4E */
  0x0000,   /* U+3E4F */
  0x0000,   /* U+3E50 */
  0x0000,   /* U+3E51 */
  0x0000,   /* U+3E52 */
  0x0000,   /* U+3E53 */
  0x0000,   /* U+3E54 */
  0x0000,   /* U+3E55 */
  0x0000,   /* U+3E56 */
  0x0000,   /* U+3E57 */
  0x0000,   /* U+3E58 */
  0x0000,   /* U+3E59 */
  0x0000,   /* U+3E5A */
  0x0000,   /* U+3E5B */
  0x0000,   /* U+3E5C */
  0x0000,   /* U+3E5D */
  0x0000,   /* U+3E5E */
  0x0000,   /* U+3E5F */
  0x0000,   /* U+3E60 */
  0x0000,   /* U+3E61 */
  0x0000,   /* U+3E62 */
  0x0000,   /* U+3E63 */
  0x0000,   /* U+3E64 */
  0x0000,   /* U+3E65 */
  0x0000,   /* U+3E66 */
  0x0000,   /* U+3E67 */
  0x0000,   /* U+3E68 */
  0x0000,   /* U+3E69 */
  0x0000,   /* U+3E6A */
  0x0000,   /* U+3E6B */
  0x0000,   /* U+3E6C */
  0x0000,   /* U+3E6D */
  0x0000,   /* U+3E6E */
  0x0000,   /* U+3E6F */
  0x0000,   /* U+3E70 */
  0x0000,   /* U+3E71 */
  0x0000,   /* U+3E72 */
  0x0000,   /* U+3E73 */
  0x0000,   /* U+3E74 */
  0x0000,   /* U+3E75 */
  0x0000,   /* U+3E76 */
  0x0000,   /* U+3E77 */
  0x0000,   /* U+3E78 */
  0x0000,   /* U+3E79 */
  0x0000,   /* U+3E7A */
  0x0000,   /* U+3E7B */
  0x0000,   /* U+3E7C */
  0x0000,   /* U+3E7D */
  0x0000,   /* U+3E7E */
  0x0000,   /* U+3E7F */
  0x0000,   /* U+3E80 */
  0x0000,   /* U+3E81 */
  0x0000,   /* U+3E82 */
  0x0000,   /* U+3E83 */
  0x0000,   /* U+3E84 */
  0x0000,   /* U+3E85 */
  0x0000,   /* U+3E86 */
  0x0000,   /* U+3E87 */
  0x0000,   /* U+3E88 */
  0x0000,   /* U+3E89 */
  0x0000,   /* U+3E8A */
  0x0000,   /* U+3E8B */
  0x0000,   /* U+3E8C */
  0x0000,   /* U+3E8D */
  0x0000,   /* U+3E8E */
  0x0000,   /* U+3E8F */
  0x0000,   /* U+3E90 */
  0x0000,   /* U+3E91 */
  0x0000,   /* U+3E92 */
  0x0000,   /* U+3E93 */
  0x0000,   /* U+3E94 */
  0x0000,   /* U+3E95 */
  0x0000,   /* U+3E96 */
  0x0000,   /* U+3E97 */
  0x0000,   /* U+3E98 */
  0x0000,   /* U+3E99 */
  0x0000,   /* U+3E9A */
  0x0000,   /* U+3E9B */
  0x0000,   /* U+3E9C */
  0x0000,   /* U+3E9D */
  0x0000,   /* U+3E9E */
  0x0000,   /* U+3E9F */
  0x0000,   /* U+3EA0 */
  0x0000,   /* U+3EA1 */
  0x0000,   /* U+3EA2 */
  0x0000,   /* U+3EA3 */
  0x0000,   /* U+3EA4 */
  0x0000,   /* U+3EA5 */
  0x0000,   /* U+3EA6 */
  0x0000,   /* U+3EA7 */
  0x0000,   /* U+3EA8 */
  0x0000,   /* U+3EA9 */
  0x0000,   /* U+3EAA */
  0x0000,   /* U+3EAB */
  0x0000,   /* U+3EAC */
  0x0000,   /* U+3EAD */
  0x0000,   /* U+3EAE */
  0x0000,   /* U+3EAF */
  0x0000,   /* U+3EB0 */
  0x0000,   /* U+3EB1 */
  0x0000,   /* U+3EB2 */
  0x0000,   /* U+3EB3 */
  0x0000,   /* U+3EB4 */
  0x0000,   /* U+3EB5 */
  0x0000,   /* U+3EB6 */
  0x0000,   /* U+3EB7 */
  0x0000,   /* U+3EB8 */
  0x0000,   /* U+3EB9 */
  0x0000,   /* U+3EBA */
  0x0000,   /* U+3EBB */
  0x0000,   /* U+3EBC */
  0x0000,   /* U+3EBD */
  0x0000,   /* U+3EBE */
  0x0000,   /* U+3EBF */
  0x0000,   /* U+3EC0 */
  0x0000,   /* U+3EC1 */
  0x0000,   /* U+3EC2 */
  0x0000,   /* U+3EC3 */
  0x0000,   /* U+3EC4 */
  0x0000,   /* U+3EC5 */
  0x0000,   /* U+3EC6 */
  0x0000,   /* U+3EC7 */
  0x0000,   /* U+3EC8 */
  0x0000,   /* U+3EC9 */
  0x0000,   /* U+3ECA */
  0x0000,   /* U+3ECB */
  0x0000,   /* U+3ECC */
  0x0000,   /* U+3ECD */
  0x0000,   /* U+3ECE */
  0x0000,   /* U+3ECF */
  0x0000,   /* U+3ED0 */
  0x0000,   /* U+3ED1 */
  0x0000,   /* U+3ED2 */
  0x0000,   /* U+3ED3 */
  0x0000,   /* U+3ED4 */
  0x0000,   /* U+3ED5 */
  0x0000,   /* U+3ED6 */
  0x0000,   /* U+3ED7 */
  0x0000,   /* U+3ED8 */
  0x0000,   /* U+3ED9 */
  0x0000,   /* U+3EDA */
  0x0000,   /* U+3EDB */
  0x0000,   /* U+3EDC */
  0x0000,   /* U+3EDD */
  0x0000,   /* U+3EDE */
  0x0000,   /* U+3EDF */
  0x0000,   /* U+3EE0 */
  0x0000,   /* U+3EE1 */
  0x0000,   /* U+3EE2 */
  0x0000,   /* U+3EE3 */
  0x0000,   /* U+3EE4 */
  0x0000,   /* U+3EE5 */
  0x0000,   /* U+3EE6 */
  0x0000,   /* U+3EE7 */
  0x0000,   /* U+3EE8 */
  0x0000,   /* U+3EE9 */
  0x0000,   /* U+3EEA */
  0x0000,   /* U+3EEB */
  0x0000,   /* U+3EEC */
  0x0000,   /* U+3EED */
  0x0000,   /* U+3EEE */
  0x0000,   /* U+3EEF */
  0x0000,   /* U+3EF0 */
  0x0000,   /* U+3EF1 */
  0x0000,   /* U+3EF2 */
  0x0000,   /* U+3EF3 */
  0x0000,   /* U+3EF4 */
  0x0000,   /* U+3EF5 */
  0x0000,   /* U+3EF6 */
  0x0000,   /* U+3EF7 */
  0x0000,   /* U+3EF8 */
  0x0000,   /* U+3EF9 */
  0x0000,   /* U+3EFA */
  0x0000,   /* U+3EFB */
  0x0000,   /* U+3EFC */
  0x0000,   /* U+3EFD */
  0x0000,   /* U+3EFE */
  0x0000,   /* U+3EFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3E00 */
  0x0000,   /* U+3E01 */
  0x0000,   /* U+3E02 */
  0x0000,   /* U+3E03 */
  0x0000,   /* U+3E04 */
  0x0000,   /* U+3E05 */
  0x0000,   /* U+3E06 */
  0x0000,   /* U+3E07 */
  0x0000,   /* U+3E08 */
  0x0000,   /* U+3E09 */
  0x0000,   /* U+3E0A */
  0x0000,   /* U+3E0B */
  0x0000,   /* U+3E0C */
  0x0000,   /* U+3E0D */
  0x0000,   /* U+3E0E */
  0x0000,   /* U+3E0F */
  0x0000,   /* U+3E10 */
  0x0000,   /* U+3E11 */
  0x0000,   /* U+3E12 */
  0x0000,   /* U+3E13 */
  0x0000,   /* U+3E14 */
  0x0000,   /* U+3E15 */
  0x0000,   /* U+3E16 */
  0x0000,   /* U+3E17 */
  0x0000,   /* U+3E18 */
  0x0000,   /* U+3E19 */
  0x0000,   /* U+3E1A */
  0x0000,   /* U+3E1B */
  0x0000,   /* U+3E1C */
  0x0000,   /* U+3E1D */
  0x0000,   /* U+3E1E */
  0x0000,   /* U+3E1F */
  0x0000,   /* U+3E20 */
  0x0000,   /* U+3E21 */
  0x0000,   /* U+3E22 */
  0x0000,   /* U+3E23 */
  0x0000,   /* U+3E24 */
  0x0000,   /* U+3E25 */
  0x0000,   /* U+3E26 */
  0x0000,   /* U+3E27 */
  0x0000,   /* U+3E28 */
  0x0000,   /* U+3E29 */
  0x0000,   /* U+3E2A */
  0x0000,   /* U+3E2B */
  0x0000,   /* U+3E2C */
  0x0000,   /* U+3E2D */
  0x0000,   /* U+3E2E */
  0x0000,   /* U+3E2F */
  0x0000,   /* U+3E30 */
  0x0000,   /* U+3E31 */
  0x0000,   /* U+3E32 */
  0x0000,   /* U+3E33 */
  0x0000,   /* U+3E34 */
  0x0000,   /* U+3E35 */
  0x0000,   /* U+3E36 */
  0x0000,   /* U+3E37 */
  0x0000,   /* U+3E38 */
  0x0000,   /* U+3E39 */
  0x0000,   /* U+3E3A */
  0x0000,   /* U+3E3B */
  0x0000,   /* U+3E3C */
  0x0000,   /* U+3E3D */
  0x0000,   /* U+3E3E */
  0x0000,   /* U+3E3F */
  0x0000,   /* U+3E40 */
  0x0000,   /* U+3E41 */
  0x0000,   /* U+3E42 */
  0x0000,   /* U+3E43 */
  0x0000,   /* U+3E44 */
  0x0000,   /* U+3E45 */
  0x0000,   /* U+3E46 */
  0x0000,   /* U+3E47 */
  0x0000,   /* U+3E48 */
  0x0000,   /* U+3E49 */
  0x0000,   /* U+3E4A */
  0x0000,   /* U+3E4B */
  0x0000,   /* U+3E4C */
  0x0000,   /* U+3E4D */
  0x0000,   /* U+3E4E */
  0x0000,   /* U+3E4F */
  0x0000,   /* U+3E50 */
  0x0000,   /* U+3E51 */
  0x0000,   /* U+3E52 */
  0x0000,   /* U+3E53 */
  0x0000,   /* U+3E54 */
  0x0000,   /* U+3E55 */
  0x0000,   /* U+3E56 */
  0x0000,   /* U+3E57 */
  0x0000,   /* U+3E58 */
  0x0000,   /* U+3E59 */
  0x0000,   /* U+3E5A */
  0x0000,   /* U+3E5B */
  0x0000,   /* U+3E5C */
  0x0000,   /* U+3E5D */
  0x0000,   /* U+3E5E */
  0x0000,   /* U+3E5F */
  0x0000,   /* U+3E60 */
  0x0000,   /* U+3E61 */
  0x0000,   /* U+3E62 */
  0x0000,   /* U+3E63 */
  0x0000,   /* U+3E64 */
  0x0000,   /* U+3E65 */
  0x0000,   /* U+3E66 */
  0x0000,   /* U+3E67 */
  0x0000,   /* U+3E68 */
  0x0000,   /* U+3E69 */
  0x0000,   /* U+3E6A */
  0x0000,   /* U+3E6B */
  0x0000,   /* U+3E6C */
  0x0000,   /* U+3E6D */
  0x0000,   /* U+3E6E */
  0x0000,   /* U+3E6F */
  0x0000,   /* U+3E70 */
  0x0000,   /* U+3E71 */
  0x0000,   /* U+3E72 */
  0x0000,   /* U+3E73 */
  0x0000,   /* U+3E74 */
  0x0000,   /* U+3E75 */
  0x0000,   /* U+3E76 */
  0x0000,   /* U+3E77 */
  0x0000,   /* U+3E78 */
  0x0000,   /* U+3E79 */
  0x0000,   /* U+3E7A */
  0x0000,   /* U+3E7B */
  0x0000,   /* U+3E7C */
  0x0000,   /* U+3E7D */
  0x0000,   /* U+3E7E */
  0x0000,   /* U+3E7F */
  0x0000,   /* U+3E80 */
  0x0000,   /* U+3E81 */
  0x0000,   /* U+3E82 */
  0x0000,   /* U+3E83 */
  0x0000,   /* U+3E84 */
  0x0000,   /* U+3E85 */
  0x0000,   /* U+3E86 */
  0x0000,   /* U+3E87 */
  0x0000,   /* U+3E88 */
  0x0000,   /* U+3E89 */
  0x0000,   /* U+3E8A */
  0x0000,   /* U+3E8B */
  0x0000,   /* U+3E8C */
  0x0000,   /* U+3E8D */
  0x0000,   /* U+3E8E */
  0x0000,   /* U+3E8F */
  0x0000,   /* U+3E90 */
  0x0000,   /* U+3E91 */
  0x0000,   /* U+3E92 */
  0x0000,   /* U+3E93 */
  0x0000,   /* U+3E94 */
  0x0000,   /* U+3E95 */
  0x0000,   /* U+3E96 */
  0x0000,   /* U+3E97 */
  0x0000,   /* U+3E98 */
  0x0000,   /* U+3E99 */
  0x0000,   /* U+3E9A */
  0x0000,   /* U+3E9B */
  0x0000,   /* U+3E9C */
  0x0000,   /* U+3E9D */
  0x0000,   /* U+3E9E */
  0x0000,   /* U+3E9F */
  0x0000,   /* U+3EA0 */
  0x0000,   /* U+3EA1 */
  0x0000,   /* U+3EA2 */
  0x0000,   /* U+3EA3 */
  0x0000,   /* U+3EA4 */
  0x0000,   /* U+3EA5 */
  0x0000,   /* U+3EA6 */
  0x0000,   /* U+3EA7 */
  0x0000,   /* U+3EA8 */
  0x0000,   /* U+3EA9 */
  0x0000,   /* U+3EAA */
  0x0000,   /* U+3EAB */
  0x0000,   /* U+3EAC */
  0x0000,   /* U+3EAD */
  0x0000,   /* U+3EAE */
  0x0000,   /* U+3EAF */
  0x0000,   /* U+3EB0 */
  0x0000,   /* U+3EB1 */
  0x0000,   /* U+3EB2 */
  0x0000,   /* U+3EB3 */
  0x0000,   /* U+3EB4 */
  0x0000,   /* U+3EB5 */
  0x0000,   /* U+3EB6 */
  0x0000,   /* U+3EB7 */
  0x0000,   /* U+3EB8 */
  0x0000,   /* U+3EB9 */
  0x0000,   /* U+3EBA */
  0x0000,   /* U+3EBB */
  0x0000,   /* U+3EBC */
  0x0000,   /* U+3EBD */
  0x0000,   /* U+3EBE */
  0x0000,   /* U+3EBF */
  0x0000,   /* U+3EC0 */
  0x0000,   /* U+3EC1 */
  0x0000,   /* U+3EC2 */
  0x0000,   /* U+3EC3 */
  0x0000,   /* U+3EC4 */
  0x0000,   /* U+3EC5 */
  0x0000,   /* U+3EC6 */
  0x0000,   /* U+3EC7 */
  0x0000,   /* U+3EC8 */
  0x0000,   /* U+3EC9 */
  0x0000,   /* U+3ECA */
  0x0000,   /* U+3ECB */
  0x0000,   /* U+3ECC */
  0x0000,   /* U+3ECD */
  0x0000,   /* U+3ECE */
  0x0000,   /* U+3ECF */
  0x0000,   /* U+3ED0 */
  0x0000,   /* U+3ED1 */
  0x0000,   /* U+3ED2 */
  0x0000,   /* U+3ED3 */
  0x0000,   /* U+3ED4 */
  0x0000,   /* U+3ED5 */
  0x0000,   /* U+3ED6 */
  0x0000,   /* U+3ED7 */
  0x0000,   /* U+3ED8 */
  0x0000,   /* U+3ED9 */
  0x0000,   /* U+3EDA */
  0x0000,   /* U+3EDB */
  0x0000,   /* U+3EDC */
  0x0000,   /* U+3EDD */
  0x0000,   /* U+3EDE */
  0x0000,   /* U+3EDF */
  0x0000,   /* U+3EE0 */
  0x0000,   /* U+3EE1 */
  0x0000,   /* U+3EE2 */
  0x0000,   /* U+3EE3 */
  0x0000,   /* U+3EE4 */
  0x0000,   /* U+3EE5 */
  0x0000,   /* U+3EE6 */
  0x0000,   /* U+3EE7 */
  0x0000,   /* U+3EE8 */
  0x0000,   /* U+3EE9 */
  0x0000,   /* U+3EEA */
  0x0000,   /* U+3EEB */
  0x0000,   /* U+3EEC */
  0x0000,   /* U+3EED */
  0x0000,   /* U+3EEE */
  0x0000,   /* U+3EEF */
  0x0000,   /* U+3EF0 */
  0x0000,   /* U+3EF1 */
  0x0000,   /* U+3EF2 */
  0x0000,   /* U+3EF3 */
  0x0000,   /* U+3EF4 */
  0x0000,   /* U+3EF5 */
  0x0000,   /* U+3EF6 */
  0x0000,   /* U+3EF7 */
  0x0000,   /* U+3EF8 */
  0x0000,   /* U+3EF9 */
  0x0000,   /* U+3EFA */
  0x0000,   /* U+3EFB */
  0x0000,   /* U+3EFC */
  0x0000,   /* U+3EFD */
  0x0000,   /* U+3EFE */
  0x0000,   /* U+3EFF */
};

uint16 zh3_han_p03F[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C58,   /* U+3F00 */
  0x1C58,   /* U+3F01 */
  0x1C59,   /* U+3F02 */
  0x1C5A,   /* U+3F03 */
  0x1C5A,   /* U+3F04 */
  0x1C5A,   /* U+3F05 */
  0x1C5A,   /* U+3F06 */
  0x1C5B,   /* U+3F07 */
  0x1C5E,   /* U+3F08 */
  0x1C50,   /* U+3F09 */
  0x1C50,   /* U+3F0A */
  0x1C51,   /* U+3F0B */
  0x1C51,   /* U+3F0C */
  0x1C52,   /* U+3F0D */
  0x1C52,   /* U+3F0E */
  0x1C53,   /* U+3F0F */
  0x1C55,   /* U+3F10 */
  0x1C55,   /* U+3F11 */
  0x1C55,   /* U+3F12 */
  0x1C56,   /* U+3F13 */
  0x1C56,   /* U+3F14 */
  0x1C59,   /* U+3F15 */
  0x1C61,   /* U+3F16 */
  0x1C4E,   /* U+3F17 */
  0x1C4F,   /* U+3F18 */
  0x1C4F,   /* U+3F19 */
  0x1C50,   /* U+3F1A */
  0x1C50,   /* U+3F1B */
  0x1C51,   /* U+3F1C */
  0x1C51,   /* U+3F1D */
  0x1C51,   /* U+3F1E */
  0x1C51,   /* U+3F1F */
  0x1C51,   /* U+3F20 */
  0x1C52,   /* U+3F21 */
  0x1C52,   /* U+3F22 */
  0x1C52,   /* U+3F23 */
  0x1C52,   /* U+3F24 */
  0x1C52,   /* U+3F25 */
  0x1C52,   /* U+3F26 */
  0x1C53,   /* U+3F27 */
  0x1C53,   /* U+3F28 */
  0x1C53,   /* U+3F29 */
  0x1C53,   /* U+3F2A */
  0x1C54,   /* U+3F2B */
  0x1C54,   /* U+3F2C */
  0x1C54,   /* U+3F2D */
  0x1C54,   /* U+3F2E */
  0x1C54,   /* U+3F2F */
  0x1C54,   /* U+3F30 */
  0x1C54,   /* U+3F31 */
  0x1C55,   /* U+3F32 */
  0x1C55,   /* U+3F33 */
  0x1C55,   /* U+3F34 */
  0x1C55,   /* U+3F35 */
  0x1C55,   /* U+3F36 */
  0x1C55,   /* U+3F37 */
  0x1C56,   /* U+3F38 */
  0x1C56,   /* U+3F39 */
  0x1C56,   /* U+3F3A */
  0x1C57,   /* U+3F3B */
  0x1C57,   /* U+3F3C */
  0x1C57,   /* U+3F3D */
  0x1C57,   /* U+3F3E */
  0x1C58,   /* U+3F3F */
  0x1C58,   /* U+3F40 */
  0x1C58,   /* U+3F41 */
  0x1C58,   /* U+3F42 */
  0x1C58,   /* U+3F43 */
  0x1C58,   /* U+3F44 */
  0x1C58,   /* U+3F45 */
  0x1C59,   /* U+3F46 */
  0x1C59,   /* U+3F47 */
  0x1C5A,   /* U+3F48 */
  0x1C5A,   /* U+3F49 */
  0x1C5D,   /* U+3F4A */
  0x1C5F,   /* U+3F4B */
  0x1C60,   /* U+3F4C */
  0x1C51,   /* U+3F4D */
  0x1C54,   /* U+3F4E */
  0x1C55,   /* U+3F4F */
  0x1C56,   /* U+3F50 */
  0x1C58,   /* U+3F51 */
  0x1C53,   /* U+3F52 */
  0x1C56,   /* U+3F53 */
  0x1C57,   /* U+3F54 */
  0x1C4E,   /* U+3F55 */
  0x1C4E,   /* U+3F56 */
  0x1C4E,   /* U+3F57 */
  0x1C50,   /* U+3F58 */
  0x1C50,   /* U+3F59 */
  0x1C50,   /* U+3F5A */
  0x1C51,   /* U+3F5B */
  0x1C51,   /* U+3F5C */
  0x1C52,   /* U+3F5D */
  0x1C52,   /* U+3F5E */
  0x1C53,   /* U+3F5F */
  0x1C53,   /* U+3F60 */
  0x1C54,   /* U+3F61 */
  0x1C54,   /* U+3F62 */
  0x1C54,   /* U+3F63 */
  0x1C54,   /* U+3F64 */
  0x1C55,   /* U+3F65 */
  0x1C56,   /* U+3F66 */
  0x1C56,   /* U+3F67 */
  0x1C56,   /* U+3F68 */
  0x1C57,   /* U+3F69 */
  0x1C58,   /* U+3F6A */
  0x1C59,   /* U+3F6B */
  0x1C59,   /* U+3F6C */
  0x1C5A,   /* U+3F6D */
  0x1C5B,   /* U+3F6E */
  0x1C5E,   /* U+3F6F */
  0x1C54,   /* U+3F70 */
  0x1C4E,   /* U+3F71 */
  0x1C4E,   /* U+3F72 */
  0x1C4F,   /* U+3F73 */
  0x1C4F,   /* U+3F74 */
  0x1C4F,   /* U+3F75 */
  0x1C4F,   /* U+3F76 */
  0x1C50,   /* U+3F77 */
  0x1C50,   /* U+3F78 */
  0x1C50,   /* U+3F79 */
  0x1C50,   /* U+3F7A */
  0x1C50,   /* U+3F7B */
  0x1C50,   /* U+3F7C */
  0x1C51,   /* U+3F7D */
  0x1C51,   /* U+3F7E */
  0x1C51,   /* U+3F7F */
  0x1C51,   /* U+3F80 */
  0x1C51,   /* U+3F81 */
  0x1C51,   /* U+3F82 */
  0x1C51,   /* U+3F83 */
  0x1C51,   /* U+3F84 */
  0x1C51,   /* U+3F85 */
  0x1C51,   /* U+3F86 */
  0x1C51,   /* U+3F87 */
  0x1C51,   /* U+3F88 */
  0x1C51,   /* U+3F89 */
  0x1C52,   /* U+3F8A */
  0x1C52,   /* U+3F8B */
  0x1C52,   /* U+3F8C */
  0x1C52,   /* U+3F8D */
  0x1C52,   /* U+3F8E */
  0x1C52,   /* U+3F8F */
  0x1C52,   /* U+3F90 */
  0x1C52,   /* U+3F91 */
  0x1C52,   /* U+3F92 */
  0x1C53,   /* U+3F93 */
  0x1C53,   /* U+3F94 */
  0x1C53,   /* U+3F95 */
  0x1C53,   /* U+3F96 */
  0x1C53,   /* U+3F97 */
  0x1C53,   /* U+3F98 */
  0x1C53,   /* U+3F99 */
  0x1C53,   /* U+3F9A */
  0x1C53,   /* U+3F9B */
  0x1C53,   /* U+3F9C */
  0x1C53,   /* U+3F9D */
  0x1C53,   /* U+3F9E */
  0x1C53,   /* U+3F9F */
  0x1C53,   /* U+3FA0 */
  0x1C53,   /* U+3FA1 */
  0x1C54,   /* U+3FA2 */
  0x1C54,   /* U+3FA3 */
  0x1C54,   /* U+3FA4 */
  0x1C54,   /* U+3FA5 */
  0x1C54,   /* U+3FA6 */
  0x1C54,   /* U+3FA7 */
  0x1C54,   /* U+3FA8 */
  0x1C54,   /* U+3FA9 */
  0x1C55,   /* U+3FAA */
  0x1C55,   /* U+3FAB */
  0x1C55,   /* U+3FAC */
  0x1C55,   /* U+3FAD */
  0x1C55,   /* U+3FAE */
  0x1C55,   /* U+3FAF */
  0x1C55,   /* U+3FB0 */
  0x1C55,   /* U+3FB1 */
  0x1C55,   /* U+3FB2 */
  0x1C55,   /* U+3FB3 */
  0x1C55,   /* U+3FB4 */
  0x1C55,   /* U+3FB5 */
  0x1C56,   /* U+3FB6 */
  0x1C56,   /* U+3FB7 */
  0x1C56,   /* U+3FB8 */
  0x1C56,   /* U+3FB9 */
  0x1C56,   /* U+3FBA */
  0x1C56,   /* U+3FBB */
  0x1C56,   /* U+3FBC */
  0x1C56,   /* U+3FBD */
  0x1C56,   /* U+3FBE */
  0x1C56,   /* U+3FBF */
  0x1C56,   /* U+3FC0 */
  0x1C56,   /* U+3FC1 */
  0x1C57,   /* U+3FC2 */
  0x1C57,   /* U+3FC3 */
  0x1C57,   /* U+3FC4 */
  0x1C57,   /* U+3FC5 */
  0x1C57,   /* U+3FC6 */
  0x1C57,   /* U+3FC7 */
  0x1C57,   /* U+3FC8 */
  0x1C58,   /* U+3FC9 */
  0x1C58,   /* U+3FCA */
  0x1C59,   /* U+3FCB */
  0x1C59,   /* U+3FCC */
  0x1C59,   /* U+3FCD */
  0x1C59,   /* U+3FCE */
  0x1C59,   /* U+3FCF */
  0x1C59,   /* U+3FD0 */
  0x1C5A,   /* U+3FD1 */
  0x1C5A,   /* U+3FD2 */
  0x1C5A,   /* U+3FD3 */
  0x1C5B,   /* U+3FD4 */
  0x1C5C,   /* U+3FD5 */
  0x1C5C,   /* U+3FD6 */
  0x1C5C,   /* U+3FD7 */
  0x1C5D,   /* U+3FD8 */
  0x1C5E,   /* U+3FD9 */
  0x1C5F,   /* U+3FDA */
  0x1C5F,   /* U+3FDB */
  0x1C63,   /* U+3FDC */
  0x1C4E,   /* U+3FDD */
  0x1C50,   /* U+3FDE */
  0x1C51,   /* U+3FDF */
  0x1C52,   /* U+3FE0 */
  0x1C52,   /* U+3FE1 */
  0x1C54,   /* U+3FE2 */
  0x1C55,   /* U+3FE3 */
  0x1C55,   /* U+3FE4 */
  0x1C56,   /* U+3FE5 */
  0x1C57,   /* U+3FE6 */
  0x1C5A,   /* U+3FE7 */
  0x1C5C,   /* U+3FE8 */
  0x1C60,   /* U+3FE9 */
  0x1C4F,   /* U+3FEA */
  0x1C50,   /* U+3FEB */
  0x1C50,   /* U+3FEC */
  0x1C51,   /* U+3FED */
  0x1C51,   /* U+3FEE */
  0x1C52,   /* U+3FEF */
  0x1C52,   /* U+3FF0 */
  0x1C53,   /* U+3FF1 */
  0x1C54,   /* U+3FF2 */
  0x1C54,   /* U+3FF3 */
  0x1C55,   /* U+3FF4 */
  0x1C55,   /* U+3FF5 */
  0x1C56,   /* U+3FF6 */
  0x1C56,   /* U+3FF7 */
  0x1C57,   /* U+3FF8 */
  0x1C59,   /* U+3FF9 */
  0x1C5B,   /* U+3FFA */
  0x1C4F,   /* U+3FFB */
  0x1C50,   /* U+3FFC */
  0x1C50,   /* U+3FFD */
  0x1C51,   /* U+3FFE */
  0x1C51,   /* U+3FFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3F00 */
  0x0020,   /* U+3F01 */
  0x0020,   /* U+3F02 */
  0x0020,   /* U+3F03 */
  0x0020,   /* U+3F04 */
  0x0020,   /* U+3F05 */
  0x0020,   /* U+3F06 */
  0x0020,   /* U+3F07 */
  0x0020,   /* U+3F08 */
  0x0020,   /* U+3F09 */
  0x0020,   /* U+3F0A */
  0x0020,   /* U+3F0B */
  0x0020,   /* U+3F0C */
  0x0020,   /* U+3F0D */
  0x0020,   /* U+3F0E */
  0x0020,   /* U+3F0F */
  0x0020,   /* U+3F10 */
  0x0020,   /* U+3F11 */
  0x0020,   /* U+3F12 */
  0x0020,   /* U+3F13 */
  0x0020,   /* U+3F14 */
  0x0020,   /* U+3F15 */
  0x0020,   /* U+3F16 */
  0x0020,   /* U+3F17 */
  0x0020,   /* U+3F18 */
  0x0020,   /* U+3F19 */
  0x0020,   /* U+3F1A */
  0x0020,   /* U+3F1B */
  0x0020,   /* U+3F1C */
  0x0020,   /* U+3F1D */
  0x0020,   /* U+3F1E */
  0x0020,   /* U+3F1F */
  0x0020,   /* U+3F20 */
  0x0020,   /* U+3F21 */
  0x0020,   /* U+3F22 */
  0x0020,   /* U+3F23 */
  0x0020,   /* U+3F24 */
  0x0020,   /* U+3F25 */
  0x0020,   /* U+3F26 */
  0x0020,   /* U+3F27 */
  0x0020,   /* U+3F28 */
  0x0020,   /* U+3F29 */
  0x0020,   /* U+3F2A */
  0x0020,   /* U+3F2B */
  0x0020,   /* U+3F2C */
  0x0020,   /* U+3F2D */
  0x0020,   /* U+3F2E */
  0x0020,   /* U+3F2F */
  0x0020,   /* U+3F30 */
  0x0020,   /* U+3F31 */
  0x0020,   /* U+3F32 */
  0x0020,   /* U+3F33 */
  0x0020,   /* U+3F34 */
  0x0020,   /* U+3F35 */
  0x0020,   /* U+3F36 */
  0x0020,   /* U+3F37 */
  0x0020,   /* U+3F38 */
  0x0020,   /* U+3F39 */
  0x0020,   /* U+3F3A */
  0x0020,   /* U+3F3B */
  0x0020,   /* U+3F3C */
  0x0020,   /* U+3F3D */
  0x0020,   /* U+3F3E */
  0x0020,   /* U+3F3F */
  0x0020,   /* U+3F40 */
  0x0020,   /* U+3F41 */
  0x0020,   /* U+3F42 */
  0x0020,   /* U+3F43 */
  0x0020,   /* U+3F44 */
  0x0020,   /* U+3F45 */
  0x0020,   /* U+3F46 */
  0x0020,   /* U+3F47 */
  0x0020,   /* U+3F48 */
  0x0020,   /* U+3F49 */
  0x0020,   /* U+3F4A */
  0x0020,   /* U+3F4B */
  0x0020,   /* U+3F4C */
  0x0020,   /* U+3F4D */
  0x0020,   /* U+3F4E */
  0x0020,   /* U+3F4F */
  0x0020,   /* U+3F50 */
  0x0020,   /* U+3F51 */
  0x0020,   /* U+3F52 */
  0x0020,   /* U+3F53 */
  0x0020,   /* U+3F54 */
  0x0020,   /* U+3F55 */
  0x0020,   /* U+3F56 */
  0x0020,   /* U+3F57 */
  0x0020,   /* U+3F58 */
  0x0020,   /* U+3F59 */
  0x0020,   /* U+3F5A */
  0x0020,   /* U+3F5B */
  0x0020,   /* U+3F5C */
  0x0020,   /* U+3F5D */
  0x0020,   /* U+3F5E */
  0x0020,   /* U+3F5F */
  0x0020,   /* U+3F60 */
  0x0020,   /* U+3F61 */
  0x0020,   /* U+3F62 */
  0x0020,   /* U+3F63 */
  0x0020,   /* U+3F64 */
  0x0020,   /* U+3F65 */
  0x0020,   /* U+3F66 */
  0x0020,   /* U+3F67 */
  0x0020,   /* U+3F68 */
  0x0020,   /* U+3F69 */
  0x0020,   /* U+3F6A */
  0x0020,   /* U+3F6B */
  0x0020,   /* U+3F6C */
  0x0020,   /* U+3F6D */
  0x0020,   /* U+3F6E */
  0x0020,   /* U+3F6F */
  0x0020,   /* U+3F70 */
  0x0020,   /* U+3F71 */
  0x0020,   /* U+3F72 */
  0x0020,   /* U+3F73 */
  0x0020,   /* U+3F74 */
  0x0020,   /* U+3F75 */
  0x0020,   /* U+3F76 */
  0x0020,   /* U+3F77 */
  0x0020,   /* U+3F78 */
  0x0020,   /* U+3F79 */
  0x0020,   /* U+3F7A */
  0x0020,   /* U+3F7B */
  0x0020,   /* U+3F7C */
  0x0020,   /* U+3F7D */
  0x0020,   /* U+3F7E */
  0x0020,   /* U+3F7F */
  0x0020,   /* U+3F80 */
  0x0020,   /* U+3F81 */
  0x0020,   /* U+3F82 */
  0x0020,   /* U+3F83 */
  0x0020,   /* U+3F84 */
  0x0020,   /* U+3F85 */
  0x0020,   /* U+3F86 */
  0x0020,   /* U+3F87 */
  0x0020,   /* U+3F88 */
  0x0020,   /* U+3F89 */
  0x0020,   /* U+3F8A */
  0x0020,   /* U+3F8B */
  0x0020,   /* U+3F8C */
  0x0020,   /* U+3F8D */
  0x0020,   /* U+3F8E */
  0x0020,   /* U+3F8F */
  0x0020,   /* U+3F90 */
  0x0020,   /* U+3F91 */
  0x0020,   /* U+3F92 */
  0x0020,   /* U+3F93 */
  0x0020,   /* U+3F94 */
  0x0020,   /* U+3F95 */
  0x0020,   /* U+3F96 */
  0x0020,   /* U+3F97 */
  0x0020,   /* U+3F98 */
  0x0020,   /* U+3F99 */
  0x0020,   /* U+3F9A */
  0x0020,   /* U+3F9B */
  0x0020,   /* U+3F9C */
  0x0020,   /* U+3F9D */
  0x0020,   /* U+3F9E */
  0x0020,   /* U+3F9F */
  0x0020,   /* U+3FA0 */
  0x0020,   /* U+3FA1 */
  0x0020,   /* U+3FA2 */
  0x0020,   /* U+3FA3 */
  0x0020,   /* U+3FA4 */
  0x0020,   /* U+3FA5 */
  0x0020,   /* U+3FA6 */
  0x0020,   /* U+3FA7 */
  0x0020,   /* U+3FA8 */
  0x0020,   /* U+3FA9 */
  0x0020,   /* U+3FAA */
  0x0020,   /* U+3FAB */
  0x0020,   /* U+3FAC */
  0x0020,   /* U+3FAD */
  0x0020,   /* U+3FAE */
  0x0020,   /* U+3FAF */
  0x0020,   /* U+3FB0 */
  0x0020,   /* U+3FB1 */
  0x0020,   /* U+3FB2 */
  0x0020,   /* U+3FB3 */
  0x0020,   /* U+3FB4 */
  0x0020,   /* U+3FB5 */
  0x0020,   /* U+3FB6 */
  0x0020,   /* U+3FB7 */
  0x0020,   /* U+3FB8 */
  0x0020,   /* U+3FB9 */
  0x0020,   /* U+3FBA */
  0x0020,   /* U+3FBB */
  0x0020,   /* U+3FBC */
  0x0020,   /* U+3FBD */
  0x0020,   /* U+3FBE */
  0x0020,   /* U+3FBF */
  0x0020,   /* U+3FC0 */
  0x0020,   /* U+3FC1 */
  0x0020,   /* U+3FC2 */
  0x0020,   /* U+3FC3 */
  0x0020,   /* U+3FC4 */
  0x0020,   /* U+3FC5 */
  0x0020,   /* U+3FC6 */
  0x0020,   /* U+3FC7 */
  0x0020,   /* U+3FC8 */
  0x0020,   /* U+3FC9 */
  0x0020,   /* U+3FCA */
  0x0020,   /* U+3FCB */
  0x0020,   /* U+3FCC */
  0x0020,   /* U+3FCD */
  0x0020,   /* U+3FCE */
  0x0020,   /* U+3FCF */
  0x0020,   /* U+3FD0 */
  0x0020,   /* U+3FD1 */
  0x0020,   /* U+3FD2 */
  0x0020,   /* U+3FD3 */
  0x0020,   /* U+3FD4 */
  0x0020,   /* U+3FD5 */
  0x0020,   /* U+3FD6 */
  0x0020,   /* U+3FD7 */
  0x0020,   /* U+3FD8 */
  0x0020,   /* U+3FD9 */
  0x0020,   /* U+3FDA */
  0x0020,   /* U+3FDB */
  0x0020,   /* U+3FDC */
  0x0020,   /* U+3FDD */
  0x0020,   /* U+3FDE */
  0x0020,   /* U+3FDF */
  0x0020,   /* U+3FE0 */
  0x0020,   /* U+3FE1 */
  0x0020,   /* U+3FE2 */
  0x0020,   /* U+3FE3 */
  0x0020,   /* U+3FE4 */
  0x0020,   /* U+3FE5 */
  0x0020,   /* U+3FE6 */
  0x0020,   /* U+3FE7 */
  0x0020,   /* U+3FE8 */
  0x0020,   /* U+3FE9 */
  0x0020,   /* U+3FEA */
  0x0020,   /* U+3FEB */
  0x0020,   /* U+3FEC */
  0x0020,   /* U+3FED */
  0x0020,   /* U+3FEE */
  0x0020,   /* U+3FEF */
  0x0020,   /* U+3FF0 */
  0x0020,   /* U+3FF1 */
  0x0020,   /* U+3FF2 */
  0x0020,   /* U+3FF3 */
  0x0020,   /* U+3FF4 */
  0x0020,   /* U+3FF5 */
  0x0020,   /* U+3FF6 */
  0x0020,   /* U+3FF7 */
  0x0020,   /* U+3FF8 */
  0x0020,   /* U+3FF9 */
  0x0020,   /* U+3FFA */
  0x0020,   /* U+3FFB */
  0x0020,   /* U+3FFC */
  0x0020,   /* U+3FFD */
  0x0020,   /* U+3FFE */
  0x0020,   /* U+3FFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3F00 */
  0x0002,   /* U+3F01 */
  0x0002,   /* U+3F02 */
  0x0002,   /* U+3F03 */
  0x0002,   /* U+3F04 */
  0x0002,   /* U+3F05 */
  0x0002,   /* U+3F06 */
  0x0002,   /* U+3F07 */
  0x0002,   /* U+3F08 */
  0x0002,   /* U+3F09 */
  0x0002,   /* U+3F0A */
  0x0002,   /* U+3F0B */
  0x0002,   /* U+3F0C */
  0x0002,   /* U+3F0D */
  0x0002,   /* U+3F0E */
  0x0002,   /* U+3F0F */
  0x0002,   /* U+3F10 */
  0x0002,   /* U+3F11 */
  0x0002,   /* U+3F12 */
  0x0002,   /* U+3F13 */
  0x0002,   /* U+3F14 */
  0x0002,   /* U+3F15 */
  0x0002,   /* U+3F16 */
  0x0002,   /* U+3F17 */
  0x0002,   /* U+3F18 */
  0x0002,   /* U+3F19 */
  0x0002,   /* U+3F1A */
  0x0002,   /* U+3F1B */
  0x0002,   /* U+3F1C */
  0x0002,   /* U+3F1D */
  0x0002,   /* U+3F1E */
  0x0002,   /* U+3F1F */
  0x0002,   /* U+3F20 */
  0x0002,   /* U+3F21 */
  0x0002,   /* U+3F22 */
  0x0002,   /* U+3F23 */
  0x0002,   /* U+3F24 */
  0x0002,   /* U+3F25 */
  0x0002,   /* U+3F26 */
  0x0002,   /* U+3F27 */
  0x0002,   /* U+3F28 */
  0x0002,   /* U+3F29 */
  0x0002,   /* U+3F2A */
  0x0002,   /* U+3F2B */
  0x0002,   /* U+3F2C */
  0x0002,   /* U+3F2D */
  0x0002,   /* U+3F2E */
  0x0002,   /* U+3F2F */
  0x0002,   /* U+3F30 */
  0x0002,   /* U+3F31 */
  0x0002,   /* U+3F32 */
  0x0002,   /* U+3F33 */
  0x0002,   /* U+3F34 */
  0x0002,   /* U+3F35 */
  0x0002,   /* U+3F36 */
  0x0002,   /* U+3F37 */
  0x0002,   /* U+3F38 */
  0x0002,   /* U+3F39 */
  0x0002,   /* U+3F3A */
  0x0002,   /* U+3F3B */
  0x0002,   /* U+3F3C */
  0x0002,   /* U+3F3D */
  0x0002,   /* U+3F3E */
  0x0002,   /* U+3F3F */
  0x0002,   /* U+3F40 */
  0x0002,   /* U+3F41 */
  0x0002,   /* U+3F42 */
  0x0002,   /* U+3F43 */
  0x0002,   /* U+3F44 */
  0x0002,   /* U+3F45 */
  0x0002,   /* U+3F46 */
  0x0002,   /* U+3F47 */
  0x0002,   /* U+3F48 */
  0x0002,   /* U+3F49 */
  0x0002,   /* U+3F4A */
  0x0002,   /* U+3F4B */
  0x0002,   /* U+3F4C */
  0x0002,   /* U+3F4D */
  0x0002,   /* U+3F4E */
  0x0002,   /* U+3F4F */
  0x0002,   /* U+3F50 */
  0x0002,   /* U+3F51 */
  0x0002,   /* U+3F52 */
  0x0002,   /* U+3F53 */
  0x0002,   /* U+3F54 */
  0x0002,   /* U+3F55 */
  0x0002,   /* U+3F56 */
  0x0002,   /* U+3F57 */
  0x0002,   /* U+3F58 */
  0x0002,   /* U+3F59 */
  0x0002,   /* U+3F5A */
  0x0002,   /* U+3F5B */
  0x0002,   /* U+3F5C */
  0x0002,   /* U+3F5D */
  0x0002,   /* U+3F5E */
  0x0002,   /* U+3F5F */
  0x0002,   /* U+3F60 */
  0x0002,   /* U+3F61 */
  0x0002,   /* U+3F62 */
  0x0002,   /* U+3F63 */
  0x0002,   /* U+3F64 */
  0x0002,   /* U+3F65 */
  0x0002,   /* U+3F66 */
  0x0002,   /* U+3F67 */
  0x0002,   /* U+3F68 */
  0x0002,   /* U+3F69 */
  0x0002,   /* U+3F6A */
  0x0002,   /* U+3F6B */
  0x0002,   /* U+3F6C */
  0x0002,   /* U+3F6D */
  0x0002,   /* U+3F6E */
  0x0002,   /* U+3F6F */
  0x0002,   /* U+3F70 */
  0x0002,   /* U+3F71 */
  0x0002,   /* U+3F72 */
  0x0002,   /* U+3F73 */
  0x0002,   /* U+3F74 */
  0x0002,   /* U+3F75 */
  0x0002,   /* U+3F76 */
  0x0002,   /* U+3F77 */
  0x0002,   /* U+3F78 */
  0x0002,   /* U+3F79 */
  0x0002,   /* U+3F7A */
  0x0002,   /* U+3F7B */
  0x0002,   /* U+3F7C */
  0x0002,   /* U+3F7D */
  0x0002,   /* U+3F7E */
  0x0002,   /* U+3F7F */
  0x0002,   /* U+3F80 */
  0x0002,   /* U+3F81 */
  0x0002,   /* U+3F82 */
  0x0002,   /* U+3F83 */
  0x0002,   /* U+3F84 */
  0x0002,   /* U+3F85 */
  0x0002,   /* U+3F86 */
  0x0002,   /* U+3F87 */
  0x0002,   /* U+3F88 */
  0x0002,   /* U+3F89 */
  0x0002,   /* U+3F8A */
  0x0002,   /* U+3F8B */
  0x0002,   /* U+3F8C */
  0x0002,   /* U+3F8D */
  0x0002,   /* U+3F8E */
  0x0002,   /* U+3F8F */
  0x0002,   /* U+3F90 */
  0x0002,   /* U+3F91 */
  0x0002,   /* U+3F92 */
  0x0002,   /* U+3F93 */
  0x0002,   /* U+3F94 */
  0x0002,   /* U+3F95 */
  0x0002,   /* U+3F96 */
  0x0002,   /* U+3F97 */
  0x0002,   /* U+3F98 */
  0x0002,   /* U+3F99 */
  0x0002,   /* U+3F9A */
  0x0002,   /* U+3F9B */
  0x0002,   /* U+3F9C */
  0x0002,   /* U+3F9D */
  0x0002,   /* U+3F9E */
  0x0002,   /* U+3F9F */
  0x0002,   /* U+3FA0 */
  0x0002,   /* U+3FA1 */
  0x0002,   /* U+3FA2 */
  0x0002,   /* U+3FA3 */
  0x0002,   /* U+3FA4 */
  0x0002,   /* U+3FA5 */
  0x0002,   /* U+3FA6 */
  0x0002,   /* U+3FA7 */
  0x0002,   /* U+3FA8 */
  0x0002,   /* U+3FA9 */
  0x0002,   /* U+3FAA */
  0x0002,   /* U+3FAB */
  0x0002,   /* U+3FAC */
  0x0002,   /* U+3FAD */
  0x0002,   /* U+3FAE */
  0x0002,   /* U+3FAF */
  0x0002,   /* U+3FB0 */
  0x0002,   /* U+3FB1 */
  0x0002,   /* U+3FB2 */
  0x0002,   /* U+3FB3 */
  0x0002,   /* U+3FB4 */
  0x0002,   /* U+3FB5 */
  0x0002,   /* U+3FB6 */
  0x0002,   /* U+3FB7 */
  0x0002,   /* U+3FB8 */
  0x0002,   /* U+3FB9 */
  0x0002,   /* U+3FBA */
  0x0002,   /* U+3FBB */
  0x0002,   /* U+3FBC */
  0x0002,   /* U+3FBD */
  0x0002,   /* U+3FBE */
  0x0002,   /* U+3FBF */
  0x0002,   /* U+3FC0 */
  0x0002,   /* U+3FC1 */
  0x0002,   /* U+3FC2 */
  0x0002,   /* U+3FC3 */
  0x0002,   /* U+3FC4 */
  0x0002,   /* U+3FC5 */
  0x0002,   /* U+3FC6 */
  0x0002,   /* U+3FC7 */
  0x0002,   /* U+3FC8 */
  0x0002,   /* U+3FC9 */
  0x0002,   /* U+3FCA */
  0x0002,   /* U+3FCB */
  0x0002,   /* U+3FCC */
  0x0002,   /* U+3FCD */
  0x0002,   /* U+3FCE */
  0x0002,   /* U+3FCF */
  0x0002,   /* U+3FD0 */
  0x0002,   /* U+3FD1 */
  0x0002,   /* U+3FD2 */
  0x0002,   /* U+3FD3 */
  0x0002,   /* U+3FD4 */
  0x0002,   /* U+3FD5 */
  0x0002,   /* U+3FD6 */
  0x0002,   /* U+3FD7 */
  0x0002,   /* U+3FD8 */
  0x0002,   /* U+3FD9 */
  0x0002,   /* U+3FDA */
  0x0002,   /* U+3FDB */
  0x0002,   /* U+3FDC */
  0x0002,   /* U+3FDD */
  0x0002,   /* U+3FDE */
  0x0002,   /* U+3FDF */
  0x0002,   /* U+3FE0 */
  0x0002,   /* U+3FE1 */
  0x0002,   /* U+3FE2 */
  0x0002,   /* U+3FE3 */
  0x0002,   /* U+3FE4 */
  0x0002,   /* U+3FE5 */
  0x0002,   /* U+3FE6 */
  0x0002,   /* U+3FE7 */
  0x0002,   /* U+3FE8 */
  0x0002,   /* U+3FE9 */
  0x0002,   /* U+3FEA */
  0x0002,   /* U+3FEB */
  0x0002,   /* U+3FEC */
  0x0002,   /* U+3FED */
  0x0002,   /* U+3FEE */
  0x0002,   /* U+3FEF */
  0x0002,   /* U+3FF0 */
  0x0002,   /* U+3FF1 */
  0x0002,   /* U+3FF2 */
  0x0002,   /* U+3FF3 */
  0x0002,   /* U+3FF4 */
  0x0002,   /* U+3FF5 */
  0x0002,   /* U+3FF6 */
  0x0002,   /* U+3FF7 */
  0x0002,   /* U+3FF8 */
  0x0002,   /* U+3FF9 */
  0x0002,   /* U+3FFA */
  0x0002,   /* U+3FFB */
  0x0002,   /* U+3FFC */
  0x0002,   /* U+3FFD */
  0x0002,   /* U+3FFE */
  0x0002,   /* U+3FFF */

  /* Primary weight 2 for each character. */
  0x865C,   /* U+3F00 */
  0x865D,   /* U+3F01 */
  0x856E,   /* U+3F02 */
  0x8410,   /* U+3F03 */
  0x8411,   /* U+3F04 */
  0x8412,   /* U+3F05 */
  0x8413,   /* U+3F06 */
  0x82F0,   /* U+3F07 */
  0x8124,   /* U+3F08 */
  0x8D4D,   /* U+3F09 */
  0x8D4E,   /* U+3F0A */
  0x8EB6,   /* U+3F0B */
  0x8EB7,   /* U+3F0C */
  0x8F8E,   /* U+3F0D */
  0x8F8F,   /* U+3F0E */
  0x90BF,   /* U+3F0F */
  0x8D61,   /* U+3F10 */
  0x8D62,   /* U+3F11 */
  0x8D63,   /* U+3F12 */
  0x8C0F,   /* U+3F13 */
  0x8C10,   /* U+3F14 */
  0x85A3,   /* U+3F15 */
  0x8055,   /* U+3F16 */
  0x8911,   /* U+3F17 */
  0x8BFC,   /* U+3F18 */
  0x8BFD,   /* U+3F19 */
  0x8D60,   /* U+3F1A */
  0x8D61,   /* U+3F1B */
  0x8EC3,   /* U+3F1C */
  0x8EC4,   /* U+3F1D */
  0x8EC5,   /* U+3F1E */
  0x8EC6,   /* U+3F1F */
  0x8EC7,   /* U+3F20 */
  0x8F98,   /* U+3F21 */
  0x8F99,   /* U+3F22 */
  0x8F9A,   /* U+3F23 */
  0x8F9B,   /* U+3F24 */
  0x8F9C,   /* U+3F25 */
  0x8F9D,   /* U+3F26 */
  0x90CC,   /* U+3F27 */
  0x90CD,   /* U+3F28 */
  0x90CE,   /* U+3F29 */
  0x90CF,   /* U+3F2A */
  0x8E7E,   /* U+3F2B */
  0x8E7F,   /* U+3F2C */
  0x8E80,   /* U+3F2D */
  0x8E81,   /* U+3F2E */
  0x8E82,   /* U+3F2F */
  0x8E83,   /* U+3F30 */
  0x8E84,   /* U+3F31 */
  0x8D6F,   /* U+3F32 */
  0x8D70,   /* U+3F33 */
  0x8D71,   /* U+3F34 */
  0x8D72,   /* U+3F35 */
  0x8D73,   /* U+3F36 */
  0x8D74,   /* U+3F37 */
  0x8C1C,   /* U+3F38 */
  0x8C1D,   /* U+3F39 */
  0x8C1E,   /* U+3F3A */
  0x89EE,   /* U+3F3B */
  0x89EF,   /* U+3F3C */
  0x89F0,   /* U+3F3D */
  0x89F1,   /* U+3F3E */
  0x8696,   /* U+3F3F */
  0x8697,   /* U+3F40 */
  0x8698,   /* U+3F41 */
  0x8699,   /* U+3F42 */
  0x869A,   /* U+3F43 */
  0x869B,   /* U+3F44 */
  0x869C,   /* U+3F45 */
  0x85AB,   /* U+3F46 */
  0x85AC,   /* U+3F47 */
  0x8431,   /* U+3F48 */
  0x8432,   /* U+3F49 */
  0x81AA,   /* U+3F4A */
  0x80E2,   /* U+3F4B */
  0x808B,   /* U+3F4C */
  0x8EDB,   /* U+3F4D */
  0x8E9A,   /* U+3F4E */
  0x8D8B,   /* U+3F4F */
  0x8C2E,   /* U+3F50 */
  0x86A8,   /* U+3F51 */
  0x90E8,   /* U+3F52 */
  0x8C32,   /* U+3F53 */
  0x89FE,   /* U+3F54 */
  0x891E,   /* U+3F55 */
  0x891F,   /* U+3F56 */
  0x8920,   /* U+3F57 */
  0x8D90,   /* U+3F58 */
  0x8D91,   /* U+3F59 */
  0x8D92,   /* U+3F5A */
  0x8EF1,   /* U+3F5B */
  0x8EF2,   /* U+3F5C */
  0x8FCA,   /* U+3F5D */
  0x8FCB,   /* U+3F5E */
  0x90FE,   /* U+3F5F */
  0x90FF,   /* U+3F60 */
  0x8EB0,   /* U+3F61 */
  0x8EB1,   /* U+3F62 */
  0x8EB2,   /* U+3F63 */
  0x8EB3,   /* U+3F64 */
  0x8D9C,   /* U+3F65 */
  0x8C38,   /* U+3F66 */
  0x8C39,   /* U+3F67 */
  0x8C3A,   /* U+3F68 */
  0x8A03,   /* U+3F69 */
  0x86B1,   /* U+3F6A */
  0x85BA,   /* U+3F6B */
  0x85BB,   /* U+3F6C */
  0x843E,   /* U+3F6D */
  0x830C,   /* U+3F6E */
  0x8136,   /* U+3F6F */
  0x8ED9,   /* U+3F70 */
  0x8935,   /* U+3F71 */
  0x8936,   /* U+3F72 */
  0x8C42,   /* U+3F73 */
  0x8C43,   /* U+3F74 */
  0x8C44,   /* U+3F75 */
  0x8C45,   /* U+3F76 */
  0x8DDA,   /* U+3F77 */
  0x8DDB,   /* U+3F78 */
  0x8DDC,   /* U+3F79 */
  0x8DDD,   /* U+3F7A */
  0x8DDE,   /* U+3F7B */
  0x8DDF,   /* U+3F7C */
  0x8F38,   /* U+3F7D */
  0x8F39,   /* U+3F7E */
  0x8F3A,   /* U+3F7F */
  0x8F3B,   /* U+3F80 */
  0x8F3C,   /* U+3F81 */
  0x8F3D,   /* U+3F82 */
  0x8F3E,   /* U+3F83 */
  0x8F3F,   /* U+3F84 */
  0x8F40,   /* U+3F85 */
  0x8F41,   /* U+3F86 */
  0x8F42,   /* U+3F87 */
  0x8F43,   /* U+3F88 */
  0x8F44,   /* U+3F89 */
  0x9005,   /* U+3F8A */
  0x9006,   /* U+3F8B */
  0x9007,   /* U+3F8C */
  0x9008,   /* U+3F8D */
  0x9009,   /* U+3F8E */
  0x900A,   /* U+3F8F */
  0x900B,   /* U+3F90 */
  0x900C,   /* U+3F91 */
  0x900D,   /* U+3F92 */
  0x9142,   /* U+3F93 */
  0x9143,   /* U+3F94 */
  0x9144,   /* U+3F95 */
  0x9145,   /* U+3F96 */
  0x9146,   /* U+3F97 */
  0x9147,   /* U+3F98 */
  0x9148,   /* U+3F99 */
  0x9149,   /* U+3F9A */
  0x914A,   /* U+3F9B */
  0x914B,   /* U+3F9C */
  0x914C,   /* U+3F9D */
  0x914D,   /* U+3F9E */
  0x914E,   /* U+3F9F */
  0x914F,   /* U+3FA0 */
  0x9150,   /* U+3FA1 */
  0x8EFB,   /* U+3FA2 */
  0x8EFC,   /* U+3FA3 */
  0x8EFD,   /* U+3FA4 */
  0x8EFE,   /* U+3FA5 */
  0x8EFF,   /* U+3FA6 */
  0x8F00,   /* U+3FA7 */
  0x8F01,   /* U+3FA8 */
  0x8F02,   /* U+3FA9 */
  0x8DC5,   /* U+3FAA */
  0x8DC6,   /* U+3FAB */
  0x8DC7,   /* U+3FAC */
  0x8DC8,   /* U+3FAD */
  0x8DC9,   /* U+3FAE */
  0x8DCA,   /* U+3FAF */
  0x8DCB,   /* U+3FB0 */
  0x8DCC,   /* U+3FB1 */
  0x8DCD,   /* U+3FB2 */
  0x8DCE,   /* U+3FB3 */
  0x8DCF,   /* U+3FB4 */
  0x8DD0,   /* U+3FB5 */
  0x8C71,   /* U+3FB6 */
  0x8C72,   /* U+3FB7 */
  0x8C73,   /* U+3FB8 */
  0x8C74,   /* U+3FB9 */
  0x8C75,   /* U+3FBA */
  0x8C76,   /* U+3FBB */
  0x8C77,   /* U+3FBC */
  0x8C78,   /* U+3FBD */
  0x8C79,   /* U+3FBE */
  0x8C7A,   /* U+3FBF */
  0x8C7B,   /* U+3FC0 */
  0x8C7C,   /* U+3FC1 */
  0x8A33,   /* U+3FC2 */
  0x8A34,   /* U+3FC3 */
  0x8A35,   /* U+3FC4 */
  0x8A36,   /* U+3FC5 */
  0x8A37,   /* U+3FC6 */
  0x8A38,   /* U+3FC7 */
  0x8A39,   /* U+3FC8 */
  0x86DE,   /* U+3FC9 */
  0x86DF,   /* U+3FCA */
  0x85D8,   /* U+3FCB */
  0x85D9,   /* U+3FCC */
  0x85DA,   /* U+3FCD */
  0x85DB,   /* U+3FCE */
  0x85DC,   /* U+3FCF */
  0x85DD,   /* U+3FD0 */
  0x844F,   /* U+3FD1 */
  0x8450,   /* U+3FD2 */
  0x8451,   /* U+3FD3 */
  0x831D,   /* U+3FD4 */
  0x8260,   /* U+3FD5 */
  0x8261,   /* U+3FD6 */
  0x8262,   /* U+3FD7 */
  0x81BE,   /* U+3FD8 */
  0x813D,   /* U+3FD9 */
  0x80E7,   /* U+3FDA */
  0x80E8,   /* U+3FDB */
  0x8031,   /* U+3FDC */
  0x8946,   /* U+3FDD */
  0x8E1D,   /* U+3FDE */
  0x8F7C,   /* U+3FDF */
  0x9042,   /* U+3FE0 */
  0x9043,   /* U+3FE1 */
  0x8F54,   /* U+3FE2 */
  0x8E16,   /* U+3FE3 */
  0x8E17,   /* U+3FE4 */
  0x8CC3,   /* U+3FE5 */
  0x8A73,   /* U+3FE6 */
  0x8475,   /* U+3FE7 */
  0x8271,   /* U+3FE8 */
  0x8093,   /* U+3FE9 */
  0x8C62,   /* U+3FEA */
  0x8E36,   /* U+3FEB */
  0x8E37,   /* U+3FEC */
  0x8F96,   /* U+3FED */
  0x8F97,   /* U+3FEE */
  0x9055,   /* U+3FEF */
  0x9056,   /* U+3FF0 */
  0x91AE,   /* U+3FF1 */
  0x8F73,   /* U+3FF2 */
  0x8F74,   /* U+3FF3 */
  0x8E2E,   /* U+3FF4 */
  0x8E2F,   /* U+3FF5 */
  0x8CCF,   /* U+3FF6 */
  0x8CD0,   /* U+3FF7 */
  0x8A7A,   /* U+3FF8 */
  0x860B,   /* U+3FF9 */
  0x833A,   /* U+3FFA */
  0x8C6B,   /* U+3FFB */
  0x8E47,   /* U+3FFC */
  0x8E48,   /* U+3FFD */
  0x8FB3,   /* U+3FFE */
  0x8FB4,   /* U+3FFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3F00 */
  0x0000,   /* U+3F01 */
  0x0000,   /* U+3F02 */
  0x0000,   /* U+3F03 */
  0x0000,   /* U+3F04 */
  0x0000,   /* U+3F05 */
  0x0000,   /* U+3F06 */
  0x0000,   /* U+3F07 */
  0x0000,   /* U+3F08 */
  0x0000,   /* U+3F09 */
  0x0000,   /* U+3F0A */
  0x0000,   /* U+3F0B */
  0x0000,   /* U+3F0C */
  0x0000,   /* U+3F0D */
  0x0000,   /* U+3F0E */
  0x0000,   /* U+3F0F */
  0x0000,   /* U+3F10 */
  0x0000,   /* U+3F11 */
  0x0000,   /* U+3F12 */
  0x0000,   /* U+3F13 */
  0x0000,   /* U+3F14 */
  0x0000,   /* U+3F15 */
  0x0000,   /* U+3F16 */
  0x0000,   /* U+3F17 */
  0x0000,   /* U+3F18 */
  0x0000,   /* U+3F19 */
  0x0000,   /* U+3F1A */
  0x0000,   /* U+3F1B */
  0x0000,   /* U+3F1C */
  0x0000,   /* U+3F1D */
  0x0000,   /* U+3F1E */
  0x0000,   /* U+3F1F */
  0x0000,   /* U+3F20 */
  0x0000,   /* U+3F21 */
  0x0000,   /* U+3F22 */
  0x0000,   /* U+3F23 */
  0x0000,   /* U+3F24 */
  0x0000,   /* U+3F25 */
  0x0000,   /* U+3F26 */
  0x0000,   /* U+3F27 */
  0x0000,   /* U+3F28 */
  0x0000,   /* U+3F29 */
  0x0000,   /* U+3F2A */
  0x0000,   /* U+3F2B */
  0x0000,   /* U+3F2C */
  0x0000,   /* U+3F2D */
  0x0000,   /* U+3F2E */
  0x0000,   /* U+3F2F */
  0x0000,   /* U+3F30 */
  0x0000,   /* U+3F31 */
  0x0000,   /* U+3F32 */
  0x0000,   /* U+3F33 */
  0x0000,   /* U+3F34 */
  0x0000,   /* U+3F35 */
  0x0000,   /* U+3F36 */
  0x0000,   /* U+3F37 */
  0x0000,   /* U+3F38 */
  0x0000,   /* U+3F39 */
  0x0000,   /* U+3F3A */
  0x0000,   /* U+3F3B */
  0x0000,   /* U+3F3C */
  0x0000,   /* U+3F3D */
  0x0000,   /* U+3F3E */
  0x0000,   /* U+3F3F */
  0x0000,   /* U+3F40 */
  0x0000,   /* U+3F41 */
  0x0000,   /* U+3F42 */
  0x0000,   /* U+3F43 */
  0x0000,   /* U+3F44 */
  0x0000,   /* U+3F45 */
  0x0000,   /* U+3F46 */
  0x0000,   /* U+3F47 */
  0x0000,   /* U+3F48 */
  0x0000,   /* U+3F49 */
  0x0000,   /* U+3F4A */
  0x0000,   /* U+3F4B */
  0x0000,   /* U+3F4C */
  0x0000,   /* U+3F4D */
  0x0000,   /* U+3F4E */
  0x0000,   /* U+3F4F */
  0x0000,   /* U+3F50 */
  0x0000,   /* U+3F51 */
  0x0000,   /* U+3F52 */
  0x0000,   /* U+3F53 */
  0x0000,   /* U+3F54 */
  0x0000,   /* U+3F55 */
  0x0000,   /* U+3F56 */
  0x0000,   /* U+3F57 */
  0x0000,   /* U+3F58 */
  0x0000,   /* U+3F59 */
  0x0000,   /* U+3F5A */
  0x0000,   /* U+3F5B */
  0x0000,   /* U+3F5C */
  0x0000,   /* U+3F5D */
  0x0000,   /* U+3F5E */
  0x0000,   /* U+3F5F */
  0x0000,   /* U+3F60 */
  0x0000,   /* U+3F61 */
  0x0000,   /* U+3F62 */
  0x0000,   /* U+3F63 */
  0x0000,   /* U+3F64 */
  0x0000,   /* U+3F65 */
  0x0000,   /* U+3F66 */
  0x0000,   /* U+3F67 */
  0x0000,   /* U+3F68 */
  0x0000,   /* U+3F69 */
  0x0000,   /* U+3F6A */
  0x0000,   /* U+3F6B */
  0x0000,   /* U+3F6C */
  0x0000,   /* U+3F6D */
  0x0000,   /* U+3F6E */
  0x0000,   /* U+3F6F */
  0x0000,   /* U+3F70 */
  0x0000,   /* U+3F71 */
  0x0000,   /* U+3F72 */
  0x0000,   /* U+3F73 */
  0x0000,   /* U+3F74 */
  0x0000,   /* U+3F75 */
  0x0000,   /* U+3F76 */
  0x0000,   /* U+3F77 */
  0x0000,   /* U+3F78 */
  0x0000,   /* U+3F79 */
  0x0000,   /* U+3F7A */
  0x0000,   /* U+3F7B */
  0x0000,   /* U+3F7C */
  0x0000,   /* U+3F7D */
  0x0000,   /* U+3F7E */
  0x0000,   /* U+3F7F */
  0x0000,   /* U+3F80 */
  0x0000,   /* U+3F81 */
  0x0000,   /* U+3F82 */
  0x0000,   /* U+3F83 */
  0x0000,   /* U+3F84 */
  0x0000,   /* U+3F85 */
  0x0000,   /* U+3F86 */
  0x0000,   /* U+3F87 */
  0x0000,   /* U+3F88 */
  0x0000,   /* U+3F89 */
  0x0000,   /* U+3F8A */
  0x0000,   /* U+3F8B */
  0x0000,   /* U+3F8C */
  0x0000,   /* U+3F8D */
  0x0000,   /* U+3F8E */
  0x0000,   /* U+3F8F */
  0x0000,   /* U+3F90 */
  0x0000,   /* U+3F91 */
  0x0000,   /* U+3F92 */
  0x0000,   /* U+3F93 */
  0x0000,   /* U+3F94 */
  0x0000,   /* U+3F95 */
  0x0000,   /* U+3F96 */
  0x0000,   /* U+3F97 */
  0x0000,   /* U+3F98 */
  0x0000,   /* U+3F99 */
  0x0000,   /* U+3F9A */
  0x0000,   /* U+3F9B */
  0x0000,   /* U+3F9C */
  0x0000,   /* U+3F9D */
  0x0000,   /* U+3F9E */
  0x0000,   /* U+3F9F */
  0x0000,   /* U+3FA0 */
  0x0000,   /* U+3FA1 */
  0x0000,   /* U+3FA2 */
  0x0000,   /* U+3FA3 */
  0x0000,   /* U+3FA4 */
  0x0000,   /* U+3FA5 */
  0x0000,   /* U+3FA6 */
  0x0000,   /* U+3FA7 */
  0x0000,   /* U+3FA8 */
  0x0000,   /* U+3FA9 */
  0x0000,   /* U+3FAA */
  0x0000,   /* U+3FAB */
  0x0000,   /* U+3FAC */
  0x0000,   /* U+3FAD */
  0x0000,   /* U+3FAE */
  0x0000,   /* U+3FAF */
  0x0000,   /* U+3FB0 */
  0x0000,   /* U+3FB1 */
  0x0000,   /* U+3FB2 */
  0x0000,   /* U+3FB3 */
  0x0000,   /* U+3FB4 */
  0x0000,   /* U+3FB5 */
  0x0000,   /* U+3FB6 */
  0x0000,   /* U+3FB7 */
  0x0000,   /* U+3FB8 */
  0x0000,   /* U+3FB9 */
  0x0000,   /* U+3FBA */
  0x0000,   /* U+3FBB */
  0x0000,   /* U+3FBC */
  0x0000,   /* U+3FBD */
  0x0000,   /* U+3FBE */
  0x0000,   /* U+3FBF */
  0x0000,   /* U+3FC0 */
  0x0000,   /* U+3FC1 */
  0x0000,   /* U+3FC2 */
  0x0000,   /* U+3FC3 */
  0x0000,   /* U+3FC4 */
  0x0000,   /* U+3FC5 */
  0x0000,   /* U+3FC6 */
  0x0000,   /* U+3FC7 */
  0x0000,   /* U+3FC8 */
  0x0000,   /* U+3FC9 */
  0x0000,   /* U+3FCA */
  0x0000,   /* U+3FCB */
  0x0000,   /* U+3FCC */
  0x0000,   /* U+3FCD */
  0x0000,   /* U+3FCE */
  0x0000,   /* U+3FCF */
  0x0000,   /* U+3FD0 */
  0x0000,   /* U+3FD1 */
  0x0000,   /* U+3FD2 */
  0x0000,   /* U+3FD3 */
  0x0000,   /* U+3FD4 */
  0x0000,   /* U+3FD5 */
  0x0000,   /* U+3FD6 */
  0x0000,   /* U+3FD7 */
  0x0000,   /* U+3FD8 */
  0x0000,   /* U+3FD9 */
  0x0000,   /* U+3FDA */
  0x0000,   /* U+3FDB */
  0x0000,   /* U+3FDC */
  0x0000,   /* U+3FDD */
  0x0000,   /* U+3FDE */
  0x0000,   /* U+3FDF */
  0x0000,   /* U+3FE0 */
  0x0000,   /* U+3FE1 */
  0x0000,   /* U+3FE2 */
  0x0000,   /* U+3FE3 */
  0x0000,   /* U+3FE4 */
  0x0000,   /* U+3FE5 */
  0x0000,   /* U+3FE6 */
  0x0000,   /* U+3FE7 */
  0x0000,   /* U+3FE8 */
  0x0000,   /* U+3FE9 */
  0x0000,   /* U+3FEA */
  0x0000,   /* U+3FEB */
  0x0000,   /* U+3FEC */
  0x0000,   /* U+3FED */
  0x0000,   /* U+3FEE */
  0x0000,   /* U+3FEF */
  0x0000,   /* U+3FF0 */
  0x0000,   /* U+3FF1 */
  0x0000,   /* U+3FF2 */
  0x0000,   /* U+3FF3 */
  0x0000,   /* U+3FF4 */
  0x0000,   /* U+3FF5 */
  0x0000,   /* U+3FF6 */
  0x0000,   /* U+3FF7 */
  0x0000,   /* U+3FF8 */
  0x0000,   /* U+3FF9 */
  0x0000,   /* U+3FFA */
  0x0000,   /* U+3FFB */
  0x0000,   /* U+3FFC */
  0x0000,   /* U+3FFD */
  0x0000,   /* U+3FFE */
  0x0000,   /* U+3FFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3F00 */
  0x0000,   /* U+3F01 */
  0x0000,   /* U+3F02 */
  0x0000,   /* U+3F03 */
  0x0000,   /* U+3F04 */
  0x0000,   /* U+3F05 */
  0x0000,   /* U+3F06 */
  0x0000,   /* U+3F07 */
  0x0000,   /* U+3F08 */
  0x0000,   /* U+3F09 */
  0x0000,   /* U+3F0A */
  0x0000,   /* U+3F0B */
  0x0000,   /* U+3F0C */
  0x0000,   /* U+3F0D */
  0x0000,   /* U+3F0E */
  0x0000,   /* U+3F0F */
  0x0000,   /* U+3F10 */
  0x0000,   /* U+3F11 */
  0x0000,   /* U+3F12 */
  0x0000,   /* U+3F13 */
  0x0000,   /* U+3F14 */
  0x0000,   /* U+3F15 */
  0x0000,   /* U+3F16 */
  0x0000,   /* U+3F17 */
  0x0000,   /* U+3F18 */
  0x0000,   /* U+3F19 */
  0x0000,   /* U+3F1A */
  0x0000,   /* U+3F1B */
  0x0000,   /* U+3F1C */
  0x0000,   /* U+3F1D */
  0x0000,   /* U+3F1E */
  0x0000,   /* U+3F1F */
  0x0000,   /* U+3F20 */
  0x0000,   /* U+3F21 */
  0x0000,   /* U+3F22 */
  0x0000,   /* U+3F23 */
  0x0000,   /* U+3F24 */
  0x0000,   /* U+3F25 */
  0x0000,   /* U+3F26 */
  0x0000,   /* U+3F27 */
  0x0000,   /* U+3F28 */
  0x0000,   /* U+3F29 */
  0x0000,   /* U+3F2A */
  0x0000,   /* U+3F2B */
  0x0000,   /* U+3F2C */
  0x0000,   /* U+3F2D */
  0x0000,   /* U+3F2E */
  0x0000,   /* U+3F2F */
  0x0000,   /* U+3F30 */
  0x0000,   /* U+3F31 */
  0x0000,   /* U+3F32 */
  0x0000,   /* U+3F33 */
  0x0000,   /* U+3F34 */
  0x0000,   /* U+3F35 */
  0x0000,   /* U+3F36 */
  0x0000,   /* U+3F37 */
  0x0000,   /* U+3F38 */
  0x0000,   /* U+3F39 */
  0x0000,   /* U+3F3A */
  0x0000,   /* U+3F3B */
  0x0000,   /* U+3F3C */
  0x0000,   /* U+3F3D */
  0x0000,   /* U+3F3E */
  0x0000,   /* U+3F3F */
  0x0000,   /* U+3F40 */
  0x0000,   /* U+3F41 */
  0x0000,   /* U+3F42 */
  0x0000,   /* U+3F43 */
  0x0000,   /* U+3F44 */
  0x0000,   /* U+3F45 */
  0x0000,   /* U+3F46 */
  0x0000,   /* U+3F47 */
  0x0000,   /* U+3F48 */
  0x0000,   /* U+3F49 */
  0x0000,   /* U+3F4A */
  0x0000,   /* U+3F4B */
  0x0000,   /* U+3F4C */
  0x0000,   /* U+3F4D */
  0x0000,   /* U+3F4E */
  0x0000,   /* U+3F4F */
  0x0000,   /* U+3F50 */
  0x0000,   /* U+3F51 */
  0x0000,   /* U+3F52 */
  0x0000,   /* U+3F53 */
  0x0000,   /* U+3F54 */
  0x0000,   /* U+3F55 */
  0x0000,   /* U+3F56 */
  0x0000,   /* U+3F57 */
  0x0000,   /* U+3F58 */
  0x0000,   /* U+3F59 */
  0x0000,   /* U+3F5A */
  0x0000,   /* U+3F5B */
  0x0000,   /* U+3F5C */
  0x0000,   /* U+3F5D */
  0x0000,   /* U+3F5E */
  0x0000,   /* U+3F5F */
  0x0000,   /* U+3F60 */
  0x0000,   /* U+3F61 */
  0x0000,   /* U+3F62 */
  0x0000,   /* U+3F63 */
  0x0000,   /* U+3F64 */
  0x0000,   /* U+3F65 */
  0x0000,   /* U+3F66 */
  0x0000,   /* U+3F67 */
  0x0000,   /* U+3F68 */
  0x0000,   /* U+3F69 */
  0x0000,   /* U+3F6A */
  0x0000,   /* U+3F6B */
  0x0000,   /* U+3F6C */
  0x0000,   /* U+3F6D */
  0x0000,   /* U+3F6E */
  0x0000,   /* U+3F6F */
  0x0000,   /* U+3F70 */
  0x0000,   /* U+3F71 */
  0x0000,   /* U+3F72 */
  0x0000,   /* U+3F73 */
  0x0000,   /* U+3F74 */
  0x0000,   /* U+3F75 */
  0x0000,   /* U+3F76 */
  0x0000,   /* U+3F77 */
  0x0000,   /* U+3F78 */
  0x0000,   /* U+3F79 */
  0x0000,   /* U+3F7A */
  0x0000,   /* U+3F7B */
  0x0000,   /* U+3F7C */
  0x0000,   /* U+3F7D */
  0x0000,   /* U+3F7E */
  0x0000,   /* U+3F7F */
  0x0000,   /* U+3F80 */
  0x0000,   /* U+3F81 */
  0x0000,   /* U+3F82 */
  0x0000,   /* U+3F83 */
  0x0000,   /* U+3F84 */
  0x0000,   /* U+3F85 */
  0x0000,   /* U+3F86 */
  0x0000,   /* U+3F87 */
  0x0000,   /* U+3F88 */
  0x0000,   /* U+3F89 */
  0x0000,   /* U+3F8A */
  0x0000,   /* U+3F8B */
  0x0000,   /* U+3F8C */
  0x0000,   /* U+3F8D */
  0x0000,   /* U+3F8E */
  0x0000,   /* U+3F8F */
  0x0000,   /* U+3F90 */
  0x0000,   /* U+3F91 */
  0x0000,   /* U+3F92 */
  0x0000,   /* U+3F93 */
  0x0000,   /* U+3F94 */
  0x0000,   /* U+3F95 */
  0x0000,   /* U+3F96 */
  0x0000,   /* U+3F97 */
  0x0000,   /* U+3F98 */
  0x0000,   /* U+3F99 */
  0x0000,   /* U+3F9A */
  0x0000,   /* U+3F9B */
  0x0000,   /* U+3F9C */
  0x0000,   /* U+3F9D */
  0x0000,   /* U+3F9E */
  0x0000,   /* U+3F9F */
  0x0000,   /* U+3FA0 */
  0x0000,   /* U+3FA1 */
  0x0000,   /* U+3FA2 */
  0x0000,   /* U+3FA3 */
  0x0000,   /* U+3FA4 */
  0x0000,   /* U+3FA5 */
  0x0000,   /* U+3FA6 */
  0x0000,   /* U+3FA7 */
  0x0000,   /* U+3FA8 */
  0x0000,   /* U+3FA9 */
  0x0000,   /* U+3FAA */
  0x0000,   /* U+3FAB */
  0x0000,   /* U+3FAC */
  0x0000,   /* U+3FAD */
  0x0000,   /* U+3FAE */
  0x0000,   /* U+3FAF */
  0x0000,   /* U+3FB0 */
  0x0000,   /* U+3FB1 */
  0x0000,   /* U+3FB2 */
  0x0000,   /* U+3FB3 */
  0x0000,   /* U+3FB4 */
  0x0000,   /* U+3FB5 */
  0x0000,   /* U+3FB6 */
  0x0000,   /* U+3FB7 */
  0x0000,   /* U+3FB8 */
  0x0000,   /* U+3FB9 */
  0x0000,   /* U+3FBA */
  0x0000,   /* U+3FBB */
  0x0000,   /* U+3FBC */
  0x0000,   /* U+3FBD */
  0x0000,   /* U+3FBE */
  0x0000,   /* U+3FBF */
  0x0000,   /* U+3FC0 */
  0x0000,   /* U+3FC1 */
  0x0000,   /* U+3FC2 */
  0x0000,   /* U+3FC3 */
  0x0000,   /* U+3FC4 */
  0x0000,   /* U+3FC5 */
  0x0000,   /* U+3FC6 */
  0x0000,   /* U+3FC7 */
  0x0000,   /* U+3FC8 */
  0x0000,   /* U+3FC9 */
  0x0000,   /* U+3FCA */
  0x0000,   /* U+3FCB */
  0x0000,   /* U+3FCC */
  0x0000,   /* U+3FCD */
  0x0000,   /* U+3FCE */
  0x0000,   /* U+3FCF */
  0x0000,   /* U+3FD0 */
  0x0000,   /* U+3FD1 */
  0x0000,   /* U+3FD2 */
  0x0000,   /* U+3FD3 */
  0x0000,   /* U+3FD4 */
  0x0000,   /* U+3FD5 */
  0x0000,   /* U+3FD6 */
  0x0000,   /* U+3FD7 */
  0x0000,   /* U+3FD8 */
  0x0000,   /* U+3FD9 */
  0x0000,   /* U+3FDA */
  0x0000,   /* U+3FDB */
  0x0000,   /* U+3FDC */
  0x0000,   /* U+3FDD */
  0x0000,   /* U+3FDE */
  0x0000,   /* U+3FDF */
  0x0000,   /* U+3FE0 */
  0x0000,   /* U+3FE1 */
  0x0000,   /* U+3FE2 */
  0x0000,   /* U+3FE3 */
  0x0000,   /* U+3FE4 */
  0x0000,   /* U+3FE5 */
  0x0000,   /* U+3FE6 */
  0x0000,   /* U+3FE7 */
  0x0000,   /* U+3FE8 */
  0x0000,   /* U+3FE9 */
  0x0000,   /* U+3FEA */
  0x0000,   /* U+3FEB */
  0x0000,   /* U+3FEC */
  0x0000,   /* U+3FED */
  0x0000,   /* U+3FEE */
  0x0000,   /* U+3FEF */
  0x0000,   /* U+3FF0 */
  0x0000,   /* U+3FF1 */
  0x0000,   /* U+3FF2 */
  0x0000,   /* U+3FF3 */
  0x0000,   /* U+3FF4 */
  0x0000,   /* U+3FF5 */
  0x0000,   /* U+3FF6 */
  0x0000,   /* U+3FF7 */
  0x0000,   /* U+3FF8 */
  0x0000,   /* U+3FF9 */
  0x0000,   /* U+3FFA */
  0x0000,   /* U+3FFB */
  0x0000,   /* U+3FFC */
  0x0000,   /* U+3FFD */
  0x0000,   /* U+3FFE */
  0x0000,   /* U+3FFF */
};

uint16 zh3_han_p040[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C51,   /* U+4000 */
  0x1C52,   /* U+4001 */
  0x1C52,   /* U+4002 */
  0x1C53,   /* U+4003 */
  0x1C54,   /* U+4004 */
  0x1C54,   /* U+4005 */
  0x1C55,   /* U+4006 */
  0x1C57,   /* U+4007 */
  0x1C57,   /* U+4008 */
  0x1C58,   /* U+4009 */
  0x1C5A,   /* U+400A */
  0x1C5C,   /* U+400B */
  0x1C5D,   /* U+400C */
  0x1C64,   /* U+400D */
  0x1C4E,   /* U+400E */
  0x1C4E,   /* U+400F */
  0x1C4F,   /* U+4010 */
  0x1C4F,   /* U+4011 */
  0x1C4F,   /* U+4012 */
  0x1C4F,   /* U+4013 */
  0x1C4F,   /* U+4014 */
  0x1C50,   /* U+4015 */
  0x1C50,   /* U+4016 */
  0x1C50,   /* U+4017 */
  0x1C50,   /* U+4018 */
  0x1C50,   /* U+4019 */
  0x1C50,   /* U+401A */
  0x1C50,   /* U+401B */
  0x1C50,   /* U+401C */
  0x1C50,   /* U+401D */
  0x1C50,   /* U+401E */
  0x1C51,   /* U+401F */
  0x1C51,   /* U+4020 */
  0x1C51,   /* U+4021 */
  0x1C51,   /* U+4022 */
  0x1C51,   /* U+4023 */
  0x1C51,   /* U+4024 */
  0x1C51,   /* U+4025 */
  0x1C51,   /* U+4026 */
  0x1C52,   /* U+4027 */
  0x1C52,   /* U+4028 */
  0x1C52,   /* U+4029 */
  0x1C52,   /* U+402A */
  0x1C52,   /* U+402B */
  0x1C52,   /* U+402C */
  0x1C52,   /* U+402D */
  0x1C52,   /* U+402E */
  0x1C53,   /* U+402F */
  0x1C53,   /* U+4030 */
  0x1C53,   /* U+4031 */
  0x1C53,   /* U+4032 */
  0x1C53,   /* U+4033 */
  0x1C53,   /* U+4034 */
  0x1C53,   /* U+4035 */
  0x1C53,   /* U+4036 */
  0x1C53,   /* U+4037 */
  0x1C53,   /* U+4038 */
  0x1C53,   /* U+4039 */
  0x1C53,   /* U+403A */
  0x1C53,   /* U+403B */
  0x1C53,   /* U+403C */
  0x1C53,   /* U+403D */
  0x1C53,   /* U+403E */
  0x1C53,   /* U+403F */
  0x1C53,   /* U+4040 */
  0x1C54,   /* U+4041 */
  0x1C54,   /* U+4042 */
  0x1C54,   /* U+4043 */
  0x1C54,   /* U+4044 */
  0x1C54,   /* U+4045 */
  0x1C54,   /* U+4046 */
  0x1C54,   /* U+4047 */
  0x1C54,   /* U+4048 */
  0x1C54,   /* U+4049 */
  0x1C55,   /* U+404A */
  0x1C55,   /* U+404B */
  0x1C55,   /* U+404C */
  0x1C55,   /* U+404D */
  0x1C55,   /* U+404E */
  0x1C55,   /* U+404F */
  0x1C55,   /* U+4050 */
  0x1C55,   /* U+4051 */
  0x1C55,   /* U+4052 */
  0x1C55,   /* U+4053 */
  0x1C55,   /* U+4054 */
  0x1C55,   /* U+4055 */
  0x1C55,   /* U+4056 */
  0x1C56,   /* U+4057 */
  0x1C56,   /* U+4058 */
  0x1C56,   /* U+4059 */
  0x1C56,   /* U+405A */
  0x1C56,   /* U+405B */
  0x1C56,   /* U+405C */
  0x1C56,   /* U+405D */
  0x1C56,   /* U+405E */
  0x1C56,   /* U+405F */
  0x1C56,   /* U+4060 */
  0x1C56,   /* U+4061 */
  0x1C57,   /* U+4062 */
  0x1C57,   /* U+4063 */
  0x1C57,   /* U+4064 */
  0x1C57,   /* U+4065 */
  0x1C57,   /* U+4066 */
  0x1C57,   /* U+4067 */
  0x1C57,   /* U+4068 */
  0x1C57,   /* U+4069 */
  0x1C57,   /* U+406A */
  0x1C58,   /* U+406B */
  0x1C58,   /* U+406C */
  0x1C58,   /* U+406D */
  0x1C58,   /* U+406E */
  0x1C58,   /* U+406F */
  0x1C58,   /* U+4070 */
  0x1C58,   /* U+4071 */
  0x1C58,   /* U+4072 */
  0x1C58,   /* U+4073 */
  0x1C59,   /* U+4074 */
  0x1C59,   /* U+4075 */
  0x1C59,   /* U+4076 */
  0x1C59,   /* U+4077 */
  0x1C59,   /* U+4078 */
  0x1C59,   /* U+4079 */
  0x1C59,   /* U+407A */
  0x1C5B,   /* U+407B */
  0x1C5B,   /* U+407C */
  0x1C5B,   /* U+407D */
  0x1C5B,   /* U+407E */
  0x1C5C,   /* U+407F */
  0x1C5C,   /* U+4080 */
  0x1C5D,   /* U+4081 */
  0x1C5E,   /* U+4082 */
  0x1C5E,   /* U+4083 */
  0x1C60,   /* U+4084 */
  0x1C65,   /* U+4085 */
  0x1C4F,   /* U+4086 */
  0x1C50,   /* U+4087 */
  0x1C52,   /* U+4088 */
  0x1C55,   /* U+4089 */
  0x1C58,   /* U+408A */
  0x1C58,   /* U+408B */
  0x1C58,   /* U+408C */
  0x1C5B,   /* U+408D */
  0x1C5F,   /* U+408E */
  0x1C51,   /* U+408F */
  0x1C51,   /* U+4090 */
  0x1C51,   /* U+4091 */
  0x1C52,   /* U+4092 */
  0x1C53,   /* U+4093 */
  0x1C54,   /* U+4094 */
  0x1C55,   /* U+4095 */
  0x1C4D,   /* U+4096 */
  0x1C4E,   /* U+4097 */
  0x1C4F,   /* U+4098 */
  0x1C4F,   /* U+4099 */
  0x1C50,   /* U+409A */
  0x1C50,   /* U+409B */
  0x1C50,   /* U+409C */
  0x1C50,   /* U+409D */
  0x1C50,   /* U+409E */
  0x1C51,   /* U+409F */
  0x1C51,   /* U+40A0 */
  0x1C51,   /* U+40A1 */
  0x1C51,   /* U+40A2 */
  0x1C51,   /* U+40A3 */
  0x1C51,   /* U+40A4 */
  0x1C51,   /* U+40A5 */
  0x1C51,   /* U+40A6 */
  0x1C51,   /* U+40A7 */
  0x1C51,   /* U+40A8 */
  0x1C52,   /* U+40A9 */
  0x1C52,   /* U+40AA */
  0x1C52,   /* U+40AB */
  0x1C52,   /* U+40AC */
  0x1C52,   /* U+40AD */
  0x1C52,   /* U+40AE */
  0x1C52,   /* U+40AF */
  0x1C53,   /* U+40B0 */
  0x1C53,   /* U+40B1 */
  0x1C53,   /* U+40B2 */
  0x1C53,   /* U+40B3 */
  0x1C53,   /* U+40B4 */
  0x1C53,   /* U+40B5 */
  0x1C53,   /* U+40B6 */
  0x1C54,   /* U+40B7 */
  0x1C54,   /* U+40B8 */
  0x1C54,   /* U+40B9 */
  0x1C54,   /* U+40BA */
  0x1C54,   /* U+40BB */
  0x1C54,   /* U+40BC */
  0x1C54,   /* U+40BD */
  0x1C54,   /* U+40BE */
  0x1C54,   /* U+40BF */
  0x1C54,   /* U+40C0 */
  0x1C54,   /* U+40C1 */
  0x1C54,   /* U+40C2 */
  0x1C54,   /* U+40C3 */
  0x1C54,   /* U+40C4 */
  0x1C54,   /* U+40C5 */
  0x1C54,   /* U+40C6 */
  0x1C54,   /* U+40C7 */
  0x1C55,   /* U+40C8 */
  0x1C55,   /* U+40C9 */
  0x1C55,   /* U+40CA */
  0x1C55,   /* U+40CB */
  0x1C55,   /* U+40CC */
  0x1C55,   /* U+40CD */
  0x1C55,   /* U+40CE */
  0x1C55,   /* U+40CF */
  0x1C55,   /* U+40D0 */
  0x1C56,   /* U+40D1 */
  0x1C56,   /* U+40D2 */
  0x1C56,   /* U+40D3 */
  0x1C56,   /* U+40D4 */
  0x1C56,   /* U+40D5 */
  0x1C56,   /* U+40D6 */
  0x1C56,   /* U+40D7 */
  0x1C57,   /* U+40D8 */
  0x1C57,   /* U+40D9 */
  0x1C57,   /* U+40DA */
  0x1C57,   /* U+40DB */
  0x1C57,   /* U+40DC */
  0x1C57,   /* U+40DD */
  0x1C57,   /* U+40DE */
  0x1C58,   /* U+40DF */
  0x1C57,   /* U+40E0 */
  0x1C58,   /* U+40E1 */
  0x1C58,   /* U+40E2 */
  0x1C58,   /* U+40E3 */
  0x1C58,   /* U+40E4 */
  0x1C58,   /* U+40E5 */
  0x1C58,   /* U+40E6 */
  0x1C58,   /* U+40E7 */
  0x1C58,   /* U+40E8 */
  0x1C59,   /* U+40E9 */
  0x1C59,   /* U+40EA */
  0x1C59,   /* U+40EB */
  0x1C59,   /* U+40EC */
  0x1C59,   /* U+40ED */
  0x1C59,   /* U+40EE */
  0x1C59,   /* U+40EF */
  0x1C5A,   /* U+40F0 */
  0x1C5B,   /* U+40F1 */
  0x1C5B,   /* U+40F2 */
  0x1C5B,   /* U+40F3 */
  0x1C5C,   /* U+40F4 */
  0x1C5C,   /* U+40F5 */
  0x1C5C,   /* U+40F6 */
  0x1C5C,   /* U+40F7 */
  0x1C5D,   /* U+40F8 */
  0x1C5D,   /* U+40F9 */
  0x1C5F,   /* U+40FA */
  0x1C61,   /* U+40FB */
  0x1C4E,   /* U+40FC */
  0x1C50,   /* U+40FD */
  0x1C50,   /* U+40FE */
  0x1C50,   /* U+40FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4000 */
  0x0020,   /* U+4001 */
  0x0020,   /* U+4002 */
  0x0020,   /* U+4003 */
  0x0020,   /* U+4004 */
  0x0020,   /* U+4005 */
  0x0020,   /* U+4006 */
  0x0020,   /* U+4007 */
  0x0020,   /* U+4008 */
  0x0020,   /* U+4009 */
  0x0020,   /* U+400A */
  0x0020,   /* U+400B */
  0x0020,   /* U+400C */
  0x0020,   /* U+400D */
  0x0020,   /* U+400E */
  0x0020,   /* U+400F */
  0x0020,   /* U+4010 */
  0x0020,   /* U+4011 */
  0x0020,   /* U+4012 */
  0x0020,   /* U+4013 */
  0x0020,   /* U+4014 */
  0x0020,   /* U+4015 */
  0x0020,   /* U+4016 */
  0x0020,   /* U+4017 */
  0x0020,   /* U+4018 */
  0x0020,   /* U+4019 */
  0x0020,   /* U+401A */
  0x0020,   /* U+401B */
  0x0020,   /* U+401C */
  0x0020,   /* U+401D */
  0x0020,   /* U+401E */
  0x0020,   /* U+401F */
  0x0020,   /* U+4020 */
  0x0020,   /* U+4021 */
  0x0020,   /* U+4022 */
  0x0020,   /* U+4023 */
  0x0020,   /* U+4024 */
  0x0020,   /* U+4025 */
  0x0020,   /* U+4026 */
  0x0020,   /* U+4027 */
  0x0020,   /* U+4028 */
  0x0020,   /* U+4029 */
  0x0020,   /* U+402A */
  0x0020,   /* U+402B */
  0x0020,   /* U+402C */
  0x0020,   /* U+402D */
  0x0020,   /* U+402E */
  0x0020,   /* U+402F */
  0x0020,   /* U+4030 */
  0x0020,   /* U+4031 */
  0x0020,   /* U+4032 */
  0x0020,   /* U+4033 */
  0x0020,   /* U+4034 */
  0x0020,   /* U+4035 */
  0x0020,   /* U+4036 */
  0x0020,   /* U+4037 */
  0x0020,   /* U+4038 */
  0x0020,   /* U+4039 */
  0x0020,   /* U+403A */
  0x0020,   /* U+403B */
  0x0020,   /* U+403C */
  0x0020,   /* U+403D */
  0x0020,   /* U+403E */
  0x0020,   /* U+403F */
  0x0020,   /* U+4040 */
  0x0020,   /* U+4041 */
  0x0020,   /* U+4042 */
  0x0020,   /* U+4043 */
  0x0020,   /* U+4044 */
  0x0020,   /* U+4045 */
  0x0020,   /* U+4046 */
  0x0020,   /* U+4047 */
  0x0020,   /* U+4048 */
  0x0020,   /* U+4049 */
  0x0020,   /* U+404A */
  0x0020,   /* U+404B */
  0x0020,   /* U+404C */
  0x0020,   /* U+404D */
  0x0020,   /* U+404E */
  0x0020,   /* U+404F */
  0x0020,   /* U+4050 */
  0x0020,   /* U+4051 */
  0x0020,   /* U+4052 */
  0x0020,   /* U+4053 */
  0x0020,   /* U+4054 */
  0x0020,   /* U+4055 */
  0x0020,   /* U+4056 */
  0x0020,   /* U+4057 */
  0x0020,   /* U+4058 */
  0x0020,   /* U+4059 */
  0x0020,   /* U+405A */
  0x0020,   /* U+405B */
  0x0020,   /* U+405C */
  0x0020,   /* U+405D */
  0x0020,   /* U+405E */
  0x0020,   /* U+405F */
  0x0020,   /* U+4060 */
  0x0020,   /* U+4061 */
  0x0020,   /* U+4062 */
  0x0020,   /* U+4063 */
  0x0020,   /* U+4064 */
  0x0020,   /* U+4065 */
  0x0020,   /* U+4066 */
  0x0020,   /* U+4067 */
  0x0020,   /* U+4068 */
  0x0020,   /* U+4069 */
  0x0020,   /* U+406A */
  0x0020,   /* U+406B */
  0x0020,   /* U+406C */
  0x0020,   /* U+406D */
  0x0020,   /* U+406E */
  0x0020,   /* U+406F */
  0x0020,   /* U+4070 */
  0x0020,   /* U+4071 */
  0x0020,   /* U+4072 */
  0x0020,   /* U+4073 */
  0x0020,   /* U+4074 */
  0x0020,   /* U+4075 */
  0x0020,   /* U+4076 */
  0x0020,   /* U+4077 */
  0x0020,   /* U+4078 */
  0x0020,   /* U+4079 */
  0x0020,   /* U+407A */
  0x0020,   /* U+407B */
  0x0020,   /* U+407C */
  0x0020,   /* U+407D */
  0x0020,   /* U+407E */
  0x0020,   /* U+407F */
  0x0020,   /* U+4080 */
  0x0020,   /* U+4081 */
  0x0020,   /* U+4082 */
  0x0020,   /* U+4083 */
  0x0020,   /* U+4084 */
  0x0020,   /* U+4085 */
  0x0020,   /* U+4086 */
  0x0020,   /* U+4087 */
  0x0020,   /* U+4088 */
  0x0020,   /* U+4089 */
  0x0020,   /* U+408A */
  0x0020,   /* U+408B */
  0x0020,   /* U+408C */
  0x0020,   /* U+408D */
  0x0020,   /* U+408E */
  0x0020,   /* U+408F */
  0x0020,   /* U+4090 */
  0x0020,   /* U+4091 */
  0x0020,   /* U+4092 */
  0x0020,   /* U+4093 */
  0x0020,   /* U+4094 */
  0x0020,   /* U+4095 */
  0x0020,   /* U+4096 */
  0x0020,   /* U+4097 */
  0x0020,   /* U+4098 */
  0x0020,   /* U+4099 */
  0x0020,   /* U+409A */
  0x0020,   /* U+409B */
  0x0020,   /* U+409C */
  0x0020,   /* U+409D */
  0x0020,   /* U+409E */
  0x0020,   /* U+409F */
  0x0020,   /* U+40A0 */
  0x0020,   /* U+40A1 */
  0x0020,   /* U+40A2 */
  0x0020,   /* U+40A3 */
  0x0020,   /* U+40A4 */
  0x0020,   /* U+40A5 */
  0x0020,   /* U+40A6 */
  0x0020,   /* U+40A7 */
  0x0020,   /* U+40A8 */
  0x0020,   /* U+40A9 */
  0x0020,   /* U+40AA */
  0x0020,   /* U+40AB */
  0x0020,   /* U+40AC */
  0x0020,   /* U+40AD */
  0x0020,   /* U+40AE */
  0x0020,   /* U+40AF */
  0x0020,   /* U+40B0 */
  0x0020,   /* U+40B1 */
  0x0020,   /* U+40B2 */
  0x0020,   /* U+40B3 */
  0x0020,   /* U+40B4 */
  0x0020,   /* U+40B5 */
  0x0020,   /* U+40B6 */
  0x0020,   /* U+40B7 */
  0x0020,   /* U+40B8 */
  0x0020,   /* U+40B9 */
  0x0020,   /* U+40BA */
  0x0020,   /* U+40BB */
  0x0020,   /* U+40BC */
  0x0020,   /* U+40BD */
  0x0020,   /* U+40BE */
  0x0020,   /* U+40BF */
  0x0020,   /* U+40C0 */
  0x0020,   /* U+40C1 */
  0x0020,   /* U+40C2 */
  0x0020,   /* U+40C3 */
  0x0020,   /* U+40C4 */
  0x0020,   /* U+40C5 */
  0x0020,   /* U+40C6 */
  0x0020,   /* U+40C7 */
  0x0020,   /* U+40C8 */
  0x0020,   /* U+40C9 */
  0x0020,   /* U+40CA */
  0x0020,   /* U+40CB */
  0x0020,   /* U+40CC */
  0x0020,   /* U+40CD */
  0x0020,   /* U+40CE */
  0x0020,   /* U+40CF */
  0x0020,   /* U+40D0 */
  0x0020,   /* U+40D1 */
  0x0020,   /* U+40D2 */
  0x0020,   /* U+40D3 */
  0x0020,   /* U+40D4 */
  0x0020,   /* U+40D5 */
  0x0020,   /* U+40D6 */
  0x0020,   /* U+40D7 */
  0x0020,   /* U+40D8 */
  0x0020,   /* U+40D9 */
  0x0020,   /* U+40DA */
  0x0020,   /* U+40DB */
  0x0020,   /* U+40DC */
  0x0020,   /* U+40DD */
  0x0020,   /* U+40DE */
  0x0020,   /* U+40DF */
  0x0020,   /* U+40E0 */
  0x0020,   /* U+40E1 */
  0x0020,   /* U+40E2 */
  0x0020,   /* U+40E3 */
  0x0020,   /* U+40E4 */
  0x0020,   /* U+40E5 */
  0x0020,   /* U+40E6 */
  0x0020,   /* U+40E7 */
  0x0020,   /* U+40E8 */
  0x0020,   /* U+40E9 */
  0x0020,   /* U+40EA */
  0x0020,   /* U+40EB */
  0x0020,   /* U+40EC */
  0x0020,   /* U+40ED */
  0x0020,   /* U+40EE */
  0x0020,   /* U+40EF */
  0x0020,   /* U+40F0 */
  0x0020,   /* U+40F1 */
  0x0020,   /* U+40F2 */
  0x0020,   /* U+40F3 */
  0x0020,   /* U+40F4 */
  0x0020,   /* U+40F5 */
  0x0020,   /* U+40F6 */
  0x0020,   /* U+40F7 */
  0x0020,   /* U+40F8 */
  0x0020,   /* U+40F9 */
  0x0020,   /* U+40FA */
  0x0020,   /* U+40FB */
  0x0020,   /* U+40FC */
  0x0020,   /* U+40FD */
  0x0020,   /* U+40FE */
  0x0020,   /* U+40FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4000 */
  0x0002,   /* U+4001 */
  0x0002,   /* U+4002 */
  0x0002,   /* U+4003 */
  0x0002,   /* U+4004 */
  0x0002,   /* U+4005 */
  0x0002,   /* U+4006 */
  0x0002,   /* U+4007 */
  0x0002,   /* U+4008 */
  0x0002,   /* U+4009 */
  0x0002,   /* U+400A */
  0x0002,   /* U+400B */
  0x0002,   /* U+400C */
  0x0002,   /* U+400D */
  0x0002,   /* U+400E */
  0x0002,   /* U+400F */
  0x0002,   /* U+4010 */
  0x0002,   /* U+4011 */
  0x0002,   /* U+4012 */
  0x0002,   /* U+4013 */
  0x0002,   /* U+4014 */
  0x0002,   /* U+4015 */
  0x0002,   /* U+4016 */
  0x0002,   /* U+4017 */
  0x0002,   /* U+4018 */
  0x0002,   /* U+4019 */
  0x0002,   /* U+401A */
  0x0002,   /* U+401B */
  0x0002,   /* U+401C */
  0x0002,   /* U+401D */
  0x0002,   /* U+401E */
  0x0002,   /* U+401F */
  0x0002,   /* U+4020 */
  0x0002,   /* U+4021 */
  0x0002,   /* U+4022 */
  0x0002,   /* U+4023 */
  0x0002,   /* U+4024 */
  0x0002,   /* U+4025 */
  0x0002,   /* U+4026 */
  0x0002,   /* U+4027 */
  0x0002,   /* U+4028 */
  0x0002,   /* U+4029 */
  0x0002,   /* U+402A */
  0x0002,   /* U+402B */
  0x0002,   /* U+402C */
  0x0002,   /* U+402D */
  0x0002,   /* U+402E */
  0x0002,   /* U+402F */
  0x0002,   /* U+4030 */
  0x0002,   /* U+4031 */
  0x0002,   /* U+4032 */
  0x0002,   /* U+4033 */
  0x0002,   /* U+4034 */
  0x0002,   /* U+4035 */
  0x0002,   /* U+4036 */
  0x0002,   /* U+4037 */
  0x0002,   /* U+4038 */
  0x0002,   /* U+4039 */
  0x0002,   /* U+403A */
  0x0002,   /* U+403B */
  0x0002,   /* U+403C */
  0x0002,   /* U+403D */
  0x0002,   /* U+403E */
  0x0002,   /* U+403F */
  0x0002,   /* U+4040 */
  0x0002,   /* U+4041 */
  0x0002,   /* U+4042 */
  0x0002,   /* U+4043 */
  0x0002,   /* U+4044 */
  0x0002,   /* U+4045 */
  0x0002,   /* U+4046 */
  0x0002,   /* U+4047 */
  0x0002,   /* U+4048 */
  0x0002,   /* U+4049 */
  0x0002,   /* U+404A */
  0x0002,   /* U+404B */
  0x0002,   /* U+404C */
  0x0002,   /* U+404D */
  0x0002,   /* U+404E */
  0x0002,   /* U+404F */
  0x0002,   /* U+4050 */
  0x0002,   /* U+4051 */
  0x0002,   /* U+4052 */
  0x0002,   /* U+4053 */
  0x0002,   /* U+4054 */
  0x0002,   /* U+4055 */
  0x0002,   /* U+4056 */
  0x0002,   /* U+4057 */
  0x0002,   /* U+4058 */
  0x0002,   /* U+4059 */
  0x0002,   /* U+405A */
  0x0002,   /* U+405B */
  0x0002,   /* U+405C */
  0x0002,   /* U+405D */
  0x0002,   /* U+405E */
  0x0002,   /* U+405F */
  0x0002,   /* U+4060 */
  0x0002,   /* U+4061 */
  0x0002,   /* U+4062 */
  0x0002,   /* U+4063 */
  0x0002,   /* U+4064 */
  0x0002,   /* U+4065 */
  0x0002,   /* U+4066 */
  0x0002,   /* U+4067 */
  0x0002,   /* U+4068 */
  0x0002,   /* U+4069 */
  0x0002,   /* U+406A */
  0x0002,   /* U+406B */
  0x0002,   /* U+406C */
  0x0002,   /* U+406D */
  0x0002,   /* U+406E */
  0x0002,   /* U+406F */
  0x0002,   /* U+4070 */
  0x0002,   /* U+4071 */
  0x0002,   /* U+4072 */
  0x0002,   /* U+4073 */
  0x0002,   /* U+4074 */
  0x0002,   /* U+4075 */
  0x0002,   /* U+4076 */
  0x0002,   /* U+4077 */
  0x0002,   /* U+4078 */
  0x0002,   /* U+4079 */
  0x0002,   /* U+407A */
  0x0002,   /* U+407B */
  0x0002,   /* U+407C */
  0x0002,   /* U+407D */
  0x0002,   /* U+407E */
  0x0002,   /* U+407F */
  0x0002,   /* U+4080 */
  0x0002,   /* U+4081 */
  0x0002,   /* U+4082 */
  0x0002,   /* U+4083 */
  0x0002,   /* U+4084 */
  0x0002,   /* U+4085 */
  0x0002,   /* U+4086 */
  0x0002,   /* U+4087 */
  0x0002,   /* U+4088 */
  0x0002,   /* U+4089 */
  0x0002,   /* U+408A */
  0x0002,   /* U+408B */
  0x0002,   /* U+408C */
  0x0002,   /* U+408D */
  0x0002,   /* U+408E */
  0x0002,   /* U+408F */
  0x0002,   /* U+4090 */
  0x0002,   /* U+4091 */
  0x0002,   /* U+4092 */
  0x0002,   /* U+4093 */
  0x0002,   /* U+4094 */
  0x0002,   /* U+4095 */
  0x0002,   /* U+4096 */
  0x0002,   /* U+4097 */
  0x0002,   /* U+4098 */
  0x0002,   /* U+4099 */
  0x0002,   /* U+409A */
  0x0002,   /* U+409B */
  0x0002,   /* U+409C */
  0x0002,   /* U+409D */
  0x0002,   /* U+409E */
  0x0002,   /* U+409F */
  0x0002,   /* U+40A0 */
  0x0002,   /* U+40A1 */
  0x0002,   /* U+40A2 */
  0x0002,   /* U+40A3 */
  0x0002,   /* U+40A4 */
  0x0002,   /* U+40A5 */
  0x0002,   /* U+40A6 */
  0x0002,   /* U+40A7 */
  0x0002,   /* U+40A8 */
  0x0002,   /* U+40A9 */
  0x0002,   /* U+40AA */
  0x0002,   /* U+40AB */
  0x0002,   /* U+40AC */
  0x0002,   /* U+40AD */
  0x0002,   /* U+40AE */
  0x0002,   /* U+40AF */
  0x0002,   /* U+40B0 */
  0x0002,   /* U+40B1 */
  0x0002,   /* U+40B2 */
  0x0002,   /* U+40B3 */
  0x0002,   /* U+40B4 */
  0x0002,   /* U+40B5 */
  0x0002,   /* U+40B6 */
  0x0002,   /* U+40B7 */
  0x0002,   /* U+40B8 */
  0x0002,   /* U+40B9 */
  0x0002,   /* U+40BA */
  0x0002,   /* U+40BB */
  0x0002,   /* U+40BC */
  0x0002,   /* U+40BD */
  0x0002,   /* U+40BE */
  0x0002,   /* U+40BF */
  0x0002,   /* U+40C0 */
  0x0002,   /* U+40C1 */
  0x0002,   /* U+40C2 */
  0x0002,   /* U+40C3 */
  0x0002,   /* U+40C4 */
  0x0002,   /* U+40C5 */
  0x0002,   /* U+40C6 */
  0x0002,   /* U+40C7 */
  0x0002,   /* U+40C8 */
  0x0002,   /* U+40C9 */
  0x0002,   /* U+40CA */
  0x0002,   /* U+40CB */
  0x0002,   /* U+40CC */
  0x0002,   /* U+40CD */
  0x0002,   /* U+40CE */
  0x0002,   /* U+40CF */
  0x0002,   /* U+40D0 */
  0x0002,   /* U+40D1 */
  0x0002,   /* U+40D2 */
  0x0002,   /* U+40D3 */
  0x0002,   /* U+40D4 */
  0x0002,   /* U+40D5 */
  0x0002,   /* U+40D6 */
  0x0002,   /* U+40D7 */
  0x0002,   /* U+40D8 */
  0x0002,   /* U+40D9 */
  0x0002,   /* U+40DA */
  0x0002,   /* U+40DB */
  0x0002,   /* U+40DC */
  0x0002,   /* U+40DD */
  0x0002,   /* U+40DE */
  0x0002,   /* U+40DF */
  0x0002,   /* U+40E0 */
  0x0002,   /* U+40E1 */
  0x0002,   /* U+40E2 */
  0x0002,   /* U+40E3 */
  0x0002,   /* U+40E4 */
  0x0002,   /* U+40E5 */
  0x0002,   /* U+40E6 */
  0x0002,   /* U+40E7 */
  0x0002,   /* U+40E8 */
  0x0002,   /* U+40E9 */
  0x0002,   /* U+40EA */
  0x0002,   /* U+40EB */
  0x0002,   /* U+40EC */
  0x0002,   /* U+40ED */
  0x0002,   /* U+40EE */
  0x0002,   /* U+40EF */
  0x0002,   /* U+40F0 */
  0x0002,   /* U+40F1 */
  0x0002,   /* U+40F2 */
  0x0002,   /* U+40F3 */
  0x0002,   /* U+40F4 */
  0x0002,   /* U+40F5 */
  0x0002,   /* U+40F6 */
  0x0002,   /* U+40F7 */
  0x0002,   /* U+40F8 */
  0x0002,   /* U+40F9 */
  0x0002,   /* U+40FA */
  0x0002,   /* U+40FB */
  0x0002,   /* U+40FC */
  0x0002,   /* U+40FD */
  0x0002,   /* U+40FE */
  0x0002,   /* U+40FF */

  /* Primary weight 2 for each character. */
  0x8FB5,   /* U+4000 */
  0x9072,   /* U+4001 */
  0x9073,   /* U+4002 */
  0x91C2,   /* U+4003 */
  0x8F8D,   /* U+4004 */
  0x8F8E,   /* U+4005 */
  0x8E47,   /* U+4006 */
  0x8A8B,   /* U+4007 */
  0x8A8C,   /* U+4008 */
  0x8736,   /* U+4009 */
  0x8485,   /* U+400A */
  0x8278,   /* U+400B */
  0x81CD,   /* U+400C */
  0x8014,   /* U+400D */
  0x8956,   /* U+400E */
  0x8957,   /* U+400F */
  0x8C7A,   /* U+4010 */
  0x8C7B,   /* U+4011 */
  0x8C7C,   /* U+4012 */
  0x8C7D,   /* U+4013 */
  0x8C7E,   /* U+4014 */
  0x8E6F,   /* U+4015 */
  0x8E70,   /* U+4016 */
  0x8E71,   /* U+4017 */
  0x8E72,   /* U+4018 */
  0x8E73,   /* U+4019 */
  0x8E74,   /* U+401A */
  0x8E75,   /* U+401B */
  0x8E76,   /* U+401C */
  0x8E77,   /* U+401D */
  0x8E78,   /* U+401E */
  0x8FF0,   /* U+401F */
  0x8FF1,   /* U+4020 */
  0x8FF2,   /* U+4021 */
  0x8FF3,   /* U+4022 */
  0x8FF4,   /* U+4023 */
  0x8FF5,   /* U+4024 */
  0x8FF6,   /* U+4025 */
  0x8FF7,   /* U+4026 */
  0x909C,   /* U+4027 */
  0x909D,   /* U+4028 */
  0x909E,   /* U+4029 */
  0x909F,   /* U+402A */
  0x90A0,   /* U+402B */
  0x90A1,   /* U+402C */
  0x90A2,   /* U+402D */
  0x90A3,   /* U+402E */
  0x91E8,   /* U+402F */
  0x91E9,   /* U+4030 */
  0x91EA,   /* U+4031 */
  0x91EB,   /* U+4032 */
  0x91EC,   /* U+4033 */
  0x91ED,   /* U+4034 */
  0x91EE,   /* U+4035 */
  0x91EF,   /* U+4036 */
  0x91F0,   /* U+4037 */
  0x91F1,   /* U+4038 */
  0x91F2,   /* U+4039 */
  0x91F3,   /* U+403A */
  0x91F4,   /* U+403B */
  0x91F5,   /* U+403C */
  0x91F6,   /* U+403D */
  0x91F7,   /* U+403E */
  0x91F8,   /* U+403F */
  0x91F9,   /* U+4040 */
  0x8FC3,   /* U+4041 */
  0x8FC4,   /* U+4042 */
  0x8FC5,   /* U+4043 */
  0x8FC6,   /* U+4044 */
  0x8FC7,   /* U+4045 */
  0x8FC8,   /* U+4046 */
  0x8FC9,   /* U+4047 */
  0x8FCA,   /* U+4048 */
  0x8FCB,   /* U+4049 */
  0x8E76,   /* U+404A */
  0x8E77,   /* U+404B */
  0x8E78,   /* U+404C */
  0x8E79,   /* U+404D */
  0x8E7A,   /* U+404E */
  0x8E7B,   /* U+404F */
  0x8E7C,   /* U+4050 */
  0x8E7D,   /* U+4051 */
  0x8E7E,   /* U+4052 */
  0x8E7F,   /* U+4053 */
  0x8E80,   /* U+4054 */
  0x8E81,   /* U+4055 */
  0x8E82,   /* U+4056 */
  0x8D00,   /* U+4057 */
  0x8D01,   /* U+4058 */
  0x8D02,   /* U+4059 */
  0x8D03,   /* U+405A */
  0x8D04,   /* U+405B */
  0x8D05,   /* U+405C */
  0x8D06,   /* U+405D */
  0x8D07,   /* U+405E */
  0x8D08,   /* U+405F */
  0x8D09,   /* U+4060 */
  0x8D0A,   /* U+4061 */
  0x8AB5,   /* U+4062 */
  0x8AB6,   /* U+4063 */
  0x8AB7,   /* U+4064 */
  0x8AB8,   /* U+4065 */
  0x8AB9,   /* U+4066 */
  0x8ABA,   /* U+4067 */
  0x8ABB,   /* U+4068 */
  0x8ABC,   /* U+4069 */
  0x8ABD,   /* U+406A */
  0x8763,   /* U+406B */
  0x8764,   /* U+406C */
  0x8765,   /* U+406D */
  0x8766,   /* U+406E */
  0x8767,   /* U+406F */
  0x8768,   /* U+4070 */
  0x8769,   /* U+4071 */
  0x876A,   /* U+4072 */
  0x876B,   /* U+4073 */
  0x8630,   /* U+4074 */
  0x8631,   /* U+4075 */
  0x8632,   /* U+4076 */
  0x8633,   /* U+4077 */
  0x8634,   /* U+4078 */
  0x8635,   /* U+4079 */
  0x8636,   /* U+407A */
  0x8352,   /* U+407B */
  0x8353,   /* U+407C */
  0x8354,   /* U+407D */
  0x8355,   /* U+407E */
  0x8285,   /* U+407F */
  0x8286,   /* U+4080 */
  0x81D7,   /* U+4081 */
  0x8150,   /* U+4082 */
  0x8151,   /* U+4083 */
  0x809C,   /* U+4084 */
  0x8012,   /* U+4085 */
  0x8C9D,   /* U+4086 */
  0x8EB8,   /* U+4087 */
  0x90EE,   /* U+4088 */
  0x8ED2,   /* U+4089 */
  0x87A9,   /* U+408A */
  0x87AA,   /* U+408B */
  0x87AB,   /* U+408C */
  0x836C,   /* U+408D */
  0x8103,   /* U+408E */
  0x9046,   /* U+408F */
  0x9047,   /* U+4090 */
  0x9055,   /* U+4091 */
  0x90F7,   /* U+4092 */
  0x9257,   /* U+4093 */
  0x9031,   /* U+4094 */
  0x8EE0,   /* U+4095 */
  0x85BB,   /* U+4096 */
  0x8970,   /* U+4097 */
  0x8CAE,   /* U+4098 */
  0x8CAF,   /* U+4099 */
  0x8EE9,   /* U+409A */
  0x8EEA,   /* U+409B */
  0x8EEB,   /* U+409C */
  0x8EEC,   /* U+409D */
  0x8EED,   /* U+409E */
  0x907B,   /* U+409F */
  0x907C,   /* U+40A0 */
  0x907D,   /* U+40A1 */
  0x907E,   /* U+40A2 */
  0x907F,   /* U+40A3 */
  0x9080,   /* U+40A4 */
  0x9081,   /* U+40A5 */
  0x9082,   /* U+40A6 */
  0x9083,   /* U+40A7 */
  0x9084,   /* U+40A8 */
  0x912C,   /* U+40A9 */
  0x912D,   /* U+40AA */
  0x912E,   /* U+40AB */
  0x912F,   /* U+40AC */
  0x9130,   /* U+40AD */
  0x9131,   /* U+40AE */
  0x9132,   /* U+40AF */
  0x9282,   /* U+40B0 */
  0x9283,   /* U+40B1 */
  0x9284,   /* U+40B2 */
  0x9285,   /* U+40B3 */
  0x9286,   /* U+40B4 */
  0x9287,   /* U+40B5 */
  0x9288,   /* U+40B6 */
  0x906F,   /* U+40B7 */
  0x9070,   /* U+40B8 */
  0x9071,   /* U+40B9 */
  0x9072,   /* U+40BA */
  0x9073,   /* U+40BB */
  0x9074,   /* U+40BC */
  0x9075,   /* U+40BD */
  0x9076,   /* U+40BE */
  0x9077,   /* U+40BF */
  0x9078,   /* U+40C0 */
  0x9079,   /* U+40C1 */
  0x907A,   /* U+40C2 */
  0x907B,   /* U+40C3 */
  0x907C,   /* U+40C4 */
  0x907D,   /* U+40C5 */
  0x907E,   /* U+40C6 */
  0x907F,   /* U+40C7 */
  0x8F0B,   /* U+40C8 */
  0x8F0C,   /* U+40C9 */
  0x8F0D,   /* U+40CA */
  0x8F0E,   /* U+40CB */
  0x8F0F,   /* U+40CC */
  0x8F10,   /* U+40CD */
  0x8F11,   /* U+40CE */
  0x8F12,   /* U+40CF */
  0x8F13,   /* U+40D0 */
  0x8D92,   /* U+40D1 */
  0x8D93,   /* U+40D2 */
  0x8D94,   /* U+40D3 */
  0x8D95,   /* U+40D4 */
  0x8D96,   /* U+40D5 */
  0x8D97,   /* U+40D6 */
  0x8D98,   /* U+40D7 */
  0x8B2C,   /* U+40D8 */
  0x8B2D,   /* U+40D9 */
  0x8B2E,   /* U+40DA */
  0x8B2F,   /* U+40DB */
  0x8B30,   /* U+40DC */
  0x8B31,   /* U+40DD */
  0x8B32,   /* U+40DE */
  0x87D1,   /* U+40DF */
  0x8B33,   /* U+40E0 */
  0x87D2,   /* U+40E1 */
  0x87D3,   /* U+40E2 */
  0x87D4,   /* U+40E3 */
  0x87D5,   /* U+40E4 */
  0x87D6,   /* U+40E5 */
  0x87D7,   /* U+40E6 */
  0x87D8,   /* U+40E7 */
  0x87D9,   /* U+40E8 */
  0x8682,   /* U+40E9 */
  0x8683,   /* U+40EA */
  0x8684,   /* U+40EB */
  0x8685,   /* U+40EC */
  0x8686,   /* U+40ED */
  0x8687,   /* U+40EE */
  0x8688,   /* U+40EF */
  0x84D8,   /* U+40F0 */
  0x837E,   /* U+40F1 */
  0x837F,   /* U+40F2 */
  0x8380,   /* U+40F3 */
  0x82A8,   /* U+40F4 */
  0x82A9,   /* U+40F5 */
  0x82AA,   /* U+40F6 */
  0x82AB,   /* U+40F7 */
  0x81E9,   /* U+40F8 */
  0x81EA,   /* U+40F9 */
  0x8105,   /* U+40FA */
  0x8069,   /* U+40FB */
  0x8979,   /* U+40FC */
  0x8F2A,   /* U+40FD */
  0x8F2B,   /* U+40FE */
  0x8F2C,   /* U+40FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4000 */
  0x0000,   /* U+4001 */
  0x0000,   /* U+4002 */
  0x0000,   /* U+4003 */
  0x0000,   /* U+4004 */
  0x0000,   /* U+4005 */
  0x0000,   /* U+4006 */
  0x0000,   /* U+4007 */
  0x0000,   /* U+4008 */
  0x0000,   /* U+4009 */
  0x0000,   /* U+400A */
  0x0000,   /* U+400B */
  0x0000,   /* U+400C */
  0x0000,   /* U+400D */
  0x0000,   /* U+400E */
  0x0000,   /* U+400F */
  0x0000,   /* U+4010 */
  0x0000,   /* U+4011 */
  0x0000,   /* U+4012 */
  0x0000,   /* U+4013 */
  0x0000,   /* U+4014 */
  0x0000,   /* U+4015 */
  0x0000,   /* U+4016 */
  0x0000,   /* U+4017 */
  0x0000,   /* U+4018 */
  0x0000,   /* U+4019 */
  0x0000,   /* U+401A */
  0x0000,   /* U+401B */
  0x0000,   /* U+401C */
  0x0000,   /* U+401D */
  0x0000,   /* U+401E */
  0x0000,   /* U+401F */
  0x0000,   /* U+4020 */
  0x0000,   /* U+4021 */
  0x0000,   /* U+4022 */
  0x0000,   /* U+4023 */
  0x0000,   /* U+4024 */
  0x0000,   /* U+4025 */
  0x0000,   /* U+4026 */
  0x0000,   /* U+4027 */
  0x0000,   /* U+4028 */
  0x0000,   /* U+4029 */
  0x0000,   /* U+402A */
  0x0000,   /* U+402B */
  0x0000,   /* U+402C */
  0x0000,   /* U+402D */
  0x0000,   /* U+402E */
  0x0000,   /* U+402F */
  0x0000,   /* U+4030 */
  0x0000,   /* U+4031 */
  0x0000,   /* U+4032 */
  0x0000,   /* U+4033 */
  0x0000,   /* U+4034 */
  0x0000,   /* U+4035 */
  0x0000,   /* U+4036 */
  0x0000,   /* U+4037 */
  0x0000,   /* U+4038 */
  0x0000,   /* U+4039 */
  0x0000,   /* U+403A */
  0x0000,   /* U+403B */
  0x0000,   /* U+403C */
  0x0000,   /* U+403D */
  0x0000,   /* U+403E */
  0x0000,   /* U+403F */
  0x0000,   /* U+4040 */
  0x0000,   /* U+4041 */
  0x0000,   /* U+4042 */
  0x0000,   /* U+4043 */
  0x0000,   /* U+4044 */
  0x0000,   /* U+4045 */
  0x0000,   /* U+4046 */
  0x0000,   /* U+4047 */
  0x0000,   /* U+4048 */
  0x0000,   /* U+4049 */
  0x0000,   /* U+404A */
  0x0000,   /* U+404B */
  0x0000,   /* U+404C */
  0x0000,   /* U+404D */
  0x0000,   /* U+404E */
  0x0000,   /* U+404F */
  0x0000,   /* U+4050 */
  0x0000,   /* U+4051 */
  0x0000,   /* U+4052 */
  0x0000,   /* U+4053 */
  0x0000,   /* U+4054 */
  0x0000,   /* U+4055 */
  0x0000,   /* U+4056 */
  0x0000,   /* U+4057 */
  0x0000,   /* U+4058 */
  0x0000,   /* U+4059 */
  0x0000,   /* U+405A */
  0x0000,   /* U+405B */
  0x0000,   /* U+405C */
  0x0000,   /* U+405D */
  0x0000,   /* U+405E */
  0x0000,   /* U+405F */
  0x0000,   /* U+4060 */
  0x0000,   /* U+4061 */
  0x0000,   /* U+4062 */
  0x0000,   /* U+4063 */
  0x0000,   /* U+4064 */
  0x0000,   /* U+4065 */
  0x0000,   /* U+4066 */
  0x0000,   /* U+4067 */
  0x0000,   /* U+4068 */
  0x0000,   /* U+4069 */
  0x0000,   /* U+406A */
  0x0000,   /* U+406B */
  0x0000,   /* U+406C */
  0x0000,   /* U+406D */
  0x0000,   /* U+406E */
  0x0000,   /* U+406F */
  0x0000,   /* U+4070 */
  0x0000,   /* U+4071 */
  0x0000,   /* U+4072 */
  0x0000,   /* U+4073 */
  0x0000,   /* U+4074 */
  0x0000,   /* U+4075 */
  0x0000,   /* U+4076 */
  0x0000,   /* U+4077 */
  0x0000,   /* U+4078 */
  0x0000,   /* U+4079 */
  0x0000,   /* U+407A */
  0x0000,   /* U+407B */
  0x0000,   /* U+407C */
  0x0000,   /* U+407D */
  0x0000,   /* U+407E */
  0x0000,   /* U+407F */
  0x0000,   /* U+4080 */
  0x0000,   /* U+4081 */
  0x0000,   /* U+4082 */
  0x0000,   /* U+4083 */
  0x0000,   /* U+4084 */
  0x0000,   /* U+4085 */
  0x0000,   /* U+4086 */
  0x0000,   /* U+4087 */
  0x0000,   /* U+4088 */
  0x0000,   /* U+4089 */
  0x0000,   /* U+408A */
  0x0000,   /* U+408B */
  0x0000,   /* U+408C */
  0x0000,   /* U+408D */
  0x0000,   /* U+408E */
  0x0000,   /* U+408F */
  0x0000,   /* U+4090 */
  0x0000,   /* U+4091 */
  0x0000,   /* U+4092 */
  0x0000,   /* U+4093 */
  0x0000,   /* U+4094 */
  0x0000,   /* U+4095 */
  0x0000,   /* U+4096 */
  0x0000,   /* U+4097 */
  0x0000,   /* U+4098 */
  0x0000,   /* U+4099 */
  0x0000,   /* U+409A */
  0x0000,   /* U+409B */
  0x0000,   /* U+409C */
  0x0000,   /* U+409D */
  0x0000,   /* U+409E */
  0x0000,   /* U+409F */
  0x0000,   /* U+40A0 */
  0x0000,   /* U+40A1 */
  0x0000,   /* U+40A2 */
  0x0000,   /* U+40A3 */
  0x0000,   /* U+40A4 */
  0x0000,   /* U+40A5 */
  0x0000,   /* U+40A6 */
  0x0000,   /* U+40A7 */
  0x0000,   /* U+40A8 */
  0x0000,   /* U+40A9 */
  0x0000,   /* U+40AA */
  0x0000,   /* U+40AB */
  0x0000,   /* U+40AC */
  0x0000,   /* U+40AD */
  0x0000,   /* U+40AE */
  0x0000,   /* U+40AF */
  0x0000,   /* U+40B0 */
  0x0000,   /* U+40B1 */
  0x0000,   /* U+40B2 */
  0x0000,   /* U+40B3 */
  0x0000,   /* U+40B4 */
  0x0000,   /* U+40B5 */
  0x0000,   /* U+40B6 */
  0x0000,   /* U+40B7 */
  0x0000,   /* U+40B8 */
  0x0000,   /* U+40B9 */
  0x0000,   /* U+40BA */
  0x0000,   /* U+40BB */
  0x0000,   /* U+40BC */
  0x0000,   /* U+40BD */
  0x0000,   /* U+40BE */
  0x0000,   /* U+40BF */
  0x0000,   /* U+40C0 */
  0x0000,   /* U+40C1 */
  0x0000,   /* U+40C2 */
  0x0000,   /* U+40C3 */
  0x0000,   /* U+40C4 */
  0x0000,   /* U+40C5 */
  0x0000,   /* U+40C6 */
  0x0000,   /* U+40C7 */
  0x0000,   /* U+40C8 */
  0x0000,   /* U+40C9 */
  0x0000,   /* U+40CA */
  0x0000,   /* U+40CB */
  0x0000,   /* U+40CC */
  0x0000,   /* U+40CD */
  0x0000,   /* U+40CE */
  0x0000,   /* U+40CF */
  0x0000,   /* U+40D0 */
  0x0000,   /* U+40D1 */
  0x0000,   /* U+40D2 */
  0x0000,   /* U+40D3 */
  0x0000,   /* U+40D4 */
  0x0000,   /* U+40D5 */
  0x0000,   /* U+40D6 */
  0x0000,   /* U+40D7 */
  0x0000,   /* U+40D8 */
  0x0000,   /* U+40D9 */
  0x0000,   /* U+40DA */
  0x0000,   /* U+40DB */
  0x0000,   /* U+40DC */
  0x0000,   /* U+40DD */
  0x0000,   /* U+40DE */
  0x0000,   /* U+40DF */
  0x0000,   /* U+40E0 */
  0x0000,   /* U+40E1 */
  0x0000,   /* U+40E2 */
  0x0000,   /* U+40E3 */
  0x0000,   /* U+40E4 */
  0x0000,   /* U+40E5 */
  0x0000,   /* U+40E6 */
  0x0000,   /* U+40E7 */
  0x0000,   /* U+40E8 */
  0x0000,   /* U+40E9 */
  0x0000,   /* U+40EA */
  0x0000,   /* U+40EB */
  0x0000,   /* U+40EC */
  0x0000,   /* U+40ED */
  0x0000,   /* U+40EE */
  0x0000,   /* U+40EF */
  0x0000,   /* U+40F0 */
  0x0000,   /* U+40F1 */
  0x0000,   /* U+40F2 */
  0x0000,   /* U+40F3 */
  0x0000,   /* U+40F4 */
  0x0000,   /* U+40F5 */
  0x0000,   /* U+40F6 */
  0x0000,   /* U+40F7 */
  0x0000,   /* U+40F8 */
  0x0000,   /* U+40F9 */
  0x0000,   /* U+40FA */
  0x0000,   /* U+40FB */
  0x0000,   /* U+40FC */
  0x0000,   /* U+40FD */
  0x0000,   /* U+40FE */
  0x0000,   /* U+40FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4000 */
  0x0000,   /* U+4001 */
  0x0000,   /* U+4002 */
  0x0000,   /* U+4003 */
  0x0000,   /* U+4004 */
  0x0000,   /* U+4005 */
  0x0000,   /* U+4006 */
  0x0000,   /* U+4007 */
  0x0000,   /* U+4008 */
  0x0000,   /* U+4009 */
  0x0000,   /* U+400A */
  0x0000,   /* U+400B */
  0x0000,   /* U+400C */
  0x0000,   /* U+400D */
  0x0000,   /* U+400E */
  0x0000,   /* U+400F */
  0x0000,   /* U+4010 */
  0x0000,   /* U+4011 */
  0x0000,   /* U+4012 */
  0x0000,   /* U+4013 */
  0x0000,   /* U+4014 */
  0x0000,   /* U+4015 */
  0x0000,   /* U+4016 */
  0x0000,   /* U+4017 */
  0x0000,   /* U+4018 */
  0x0000,   /* U+4019 */
  0x0000,   /* U+401A */
  0x0000,   /* U+401B */
  0x0000,   /* U+401C */
  0x0000,   /* U+401D */
  0x0000,   /* U+401E */
  0x0000,   /* U+401F */
  0x0000,   /* U+4020 */
  0x0000,   /* U+4021 */
  0x0000,   /* U+4022 */
  0x0000,   /* U+4023 */
  0x0000,   /* U+4024 */
  0x0000,   /* U+4025 */
  0x0000,   /* U+4026 */
  0x0000,   /* U+4027 */
  0x0000,   /* U+4028 */
  0x0000,   /* U+4029 */
  0x0000,   /* U+402A */
  0x0000,   /* U+402B */
  0x0000,   /* U+402C */
  0x0000,   /* U+402D */
  0x0000,   /* U+402E */
  0x0000,   /* U+402F */
  0x0000,   /* U+4030 */
  0x0000,   /* U+4031 */
  0x0000,   /* U+4032 */
  0x0000,   /* U+4033 */
  0x0000,   /* U+4034 */
  0x0000,   /* U+4035 */
  0x0000,   /* U+4036 */
  0x0000,   /* U+4037 */
  0x0000,   /* U+4038 */
  0x0000,   /* U+4039 */
  0x0000,   /* U+403A */
  0x0000,   /* U+403B */
  0x0000,   /* U+403C */
  0x0000,   /* U+403D */
  0x0000,   /* U+403E */
  0x0000,   /* U+403F */
  0x0000,   /* U+4040 */
  0x0000,   /* U+4041 */
  0x0000,   /* U+4042 */
  0x0000,   /* U+4043 */
  0x0000,   /* U+4044 */
  0x0000,   /* U+4045 */
  0x0000,   /* U+4046 */
  0x0000,   /* U+4047 */
  0x0000,   /* U+4048 */
  0x0000,   /* U+4049 */
  0x0000,   /* U+404A */
  0x0000,   /* U+404B */
  0x0000,   /* U+404C */
  0x0000,   /* U+404D */
  0x0000,   /* U+404E */
  0x0000,   /* U+404F */
  0x0000,   /* U+4050 */
  0x0000,   /* U+4051 */
  0x0000,   /* U+4052 */
  0x0000,   /* U+4053 */
  0x0000,   /* U+4054 */
  0x0000,   /* U+4055 */
  0x0000,   /* U+4056 */
  0x0000,   /* U+4057 */
  0x0000,   /* U+4058 */
  0x0000,   /* U+4059 */
  0x0000,   /* U+405A */
  0x0000,   /* U+405B */
  0x0000,   /* U+405C */
  0x0000,   /* U+405D */
  0x0000,   /* U+405E */
  0x0000,   /* U+405F */
  0x0000,   /* U+4060 */
  0x0000,   /* U+4061 */
  0x0000,   /* U+4062 */
  0x0000,   /* U+4063 */
  0x0000,   /* U+4064 */
  0x0000,   /* U+4065 */
  0x0000,   /* U+4066 */
  0x0000,   /* U+4067 */
  0x0000,   /* U+4068 */
  0x0000,   /* U+4069 */
  0x0000,   /* U+406A */
  0x0000,   /* U+406B */
  0x0000,   /* U+406C */
  0x0000,   /* U+406D */
  0x0000,   /* U+406E */
  0x0000,   /* U+406F */
  0x0000,   /* U+4070 */
  0x0000,   /* U+4071 */
  0x0000,   /* U+4072 */
  0x0000,   /* U+4073 */
  0x0000,   /* U+4074 */
  0x0000,   /* U+4075 */
  0x0000,   /* U+4076 */
  0x0000,   /* U+4077 */
  0x0000,   /* U+4078 */
  0x0000,   /* U+4079 */
  0x0000,   /* U+407A */
  0x0000,   /* U+407B */
  0x0000,   /* U+407C */
  0x0000,   /* U+407D */
  0x0000,   /* U+407E */
  0x0000,   /* U+407F */
  0x0000,   /* U+4080 */
  0x0000,   /* U+4081 */
  0x0000,   /* U+4082 */
  0x0000,   /* U+4083 */
  0x0000,   /* U+4084 */
  0x0000,   /* U+4085 */
  0x0000,   /* U+4086 */
  0x0000,   /* U+4087 */
  0x0000,   /* U+4088 */
  0x0000,   /* U+4089 */
  0x0000,   /* U+408A */
  0x0000,   /* U+408B */
  0x0000,   /* U+408C */
  0x0000,   /* U+408D */
  0x0000,   /* U+408E */
  0x0000,   /* U+408F */
  0x0000,   /* U+4090 */
  0x0000,   /* U+4091 */
  0x0000,   /* U+4092 */
  0x0000,   /* U+4093 */
  0x0000,   /* U+4094 */
  0x0000,   /* U+4095 */
  0x0000,   /* U+4096 */
  0x0000,   /* U+4097 */
  0x0000,   /* U+4098 */
  0x0000,   /* U+4099 */
  0x0000,   /* U+409A */
  0x0000,   /* U+409B */
  0x0000,   /* U+409C */
  0x0000,   /* U+409D */
  0x0000,   /* U+409E */
  0x0000,   /* U+409F */
  0x0000,   /* U+40A0 */
  0x0000,   /* U+40A1 */
  0x0000,   /* U+40A2 */
  0x0000,   /* U+40A3 */
  0x0000,   /* U+40A4 */
  0x0000,   /* U+40A5 */
  0x0000,   /* U+40A6 */
  0x0000,   /* U+40A7 */
  0x0000,   /* U+40A8 */
  0x0000,   /* U+40A9 */
  0x0000,   /* U+40AA */
  0x0000,   /* U+40AB */
  0x0000,   /* U+40AC */
  0x0000,   /* U+40AD */
  0x0000,   /* U+40AE */
  0x0000,   /* U+40AF */
  0x0000,   /* U+40B0 */
  0x0000,   /* U+40B1 */
  0x0000,   /* U+40B2 */
  0x0000,   /* U+40B3 */
  0x0000,   /* U+40B4 */
  0x0000,   /* U+40B5 */
  0x0000,   /* U+40B6 */
  0x0000,   /* U+40B7 */
  0x0000,   /* U+40B8 */
  0x0000,   /* U+40B9 */
  0x0000,   /* U+40BA */
  0x0000,   /* U+40BB */
  0x0000,   /* U+40BC */
  0x0000,   /* U+40BD */
  0x0000,   /* U+40BE */
  0x0000,   /* U+40BF */
  0x0000,   /* U+40C0 */
  0x0000,   /* U+40C1 */
  0x0000,   /* U+40C2 */
  0x0000,   /* U+40C3 */
  0x0000,   /* U+40C4 */
  0x0000,   /* U+40C5 */
  0x0000,   /* U+40C6 */
  0x0000,   /* U+40C7 */
  0x0000,   /* U+40C8 */
  0x0000,   /* U+40C9 */
  0x0000,   /* U+40CA */
  0x0000,   /* U+40CB */
  0x0000,   /* U+40CC */
  0x0000,   /* U+40CD */
  0x0000,   /* U+40CE */
  0x0000,   /* U+40CF */
  0x0000,   /* U+40D0 */
  0x0000,   /* U+40D1 */
  0x0000,   /* U+40D2 */
  0x0000,   /* U+40D3 */
  0x0000,   /* U+40D4 */
  0x0000,   /* U+40D5 */
  0x0000,   /* U+40D6 */
  0x0000,   /* U+40D7 */
  0x0000,   /* U+40D8 */
  0x0000,   /* U+40D9 */
  0x0000,   /* U+40DA */
  0x0000,   /* U+40DB */
  0x0000,   /* U+40DC */
  0x0000,   /* U+40DD */
  0x0000,   /* U+40DE */
  0x0000,   /* U+40DF */
  0x0000,   /* U+40E0 */
  0x0000,   /* U+40E1 */
  0x0000,   /* U+40E2 */
  0x0000,   /* U+40E3 */
  0x0000,   /* U+40E4 */
  0x0000,   /* U+40E5 */
  0x0000,   /* U+40E6 */
  0x0000,   /* U+40E7 */
  0x0000,   /* U+40E8 */
  0x0000,   /* U+40E9 */
  0x0000,   /* U+40EA */
  0x0000,   /* U+40EB */
  0x0000,   /* U+40EC */
  0x0000,   /* U+40ED */
  0x0000,   /* U+40EE */
  0x0000,   /* U+40EF */
  0x0000,   /* U+40F0 */
  0x0000,   /* U+40F1 */
  0x0000,   /* U+40F2 */
  0x0000,   /* U+40F3 */
  0x0000,   /* U+40F4 */
  0x0000,   /* U+40F5 */
  0x0000,   /* U+40F6 */
  0x0000,   /* U+40F7 */
  0x0000,   /* U+40F8 */
  0x0000,   /* U+40F9 */
  0x0000,   /* U+40FA */
  0x0000,   /* U+40FB */
  0x0000,   /* U+40FC */
  0x0000,   /* U+40FD */
  0x0000,   /* U+40FE */
  0x0000,   /* U+40FF */
};

uint16 zh3_han_p041[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C50,   /* U+4100 */
  0x1C51,   /* U+4101 */
  0x1C51,   /* U+4102 */
  0x1C51,   /* U+4103 */
  0x1C52,   /* U+4104 */
  0x1C52,   /* U+4105 */
  0x1C52,   /* U+4106 */
  0x1C53,   /* U+4107 */
  0x1C53,   /* U+4108 */
  0x1C53,   /* U+4109 */
  0x1C53,   /* U+410A */
  0x1C54,   /* U+410B */
  0x1C54,   /* U+410C */
  0x1C54,   /* U+410D */
  0x1C54,   /* U+410E */
  0x1C54,   /* U+410F */
  0x1C54,   /* U+4110 */
  0x1C54,   /* U+4111 */
  0x1C54,   /* U+4112 */
  0x1C55,   /* U+4113 */
  0x1C55,   /* U+4114 */
  0x1C55,   /* U+4115 */
  0x1C55,   /* U+4116 */
  0x1C55,   /* U+4117 */
  0x1C56,   /* U+4118 */
  0x1C56,   /* U+4119 */
  0x1C57,   /* U+411A */
  0x1C57,   /* U+411B */
  0x1C57,   /* U+411C */
  0x1C57,   /* U+411D */
  0x1C57,   /* U+411E */
  0x1C58,   /* U+411F */
  0x1C59,   /* U+4120 */
  0x1C59,   /* U+4121 */
  0x1C5A,   /* U+4122 */
  0x1C5B,   /* U+4123 */
  0x1C5C,   /* U+4124 */
  0x1C64,   /* U+4125 */
  0x1C4E,   /* U+4126 */
  0x1C4E,   /* U+4127 */
  0x1C4F,   /* U+4128 */
  0x1C4F,   /* U+4129 */
  0x1C4F,   /* U+412A */
  0x1C4F,   /* U+412B */
  0x1C4F,   /* U+412C */
  0x1C4F,   /* U+412D */
  0x1C50,   /* U+412E */
  0x1C50,   /* U+412F */
  0x1C50,   /* U+4130 */
  0x1C50,   /* U+4131 */
  0x1C50,   /* U+4132 */
  0x1C50,   /* U+4133 */
  0x1C50,   /* U+4134 */
  0x1C50,   /* U+4135 */
  0x1C51,   /* U+4136 */
  0x1C51,   /* U+4137 */
  0x1C51,   /* U+4138 */
  0x1C51,   /* U+4139 */
  0x1C52,   /* U+413A */
  0x1C52,   /* U+413B */
  0x1C52,   /* U+413C */
  0x1C52,   /* U+413D */
  0x1C52,   /* U+413E */
  0x1C52,   /* U+413F */
  0x1C52,   /* U+4140 */
  0x1C52,   /* U+4141 */
  0x1C52,   /* U+4142 */
  0x1C52,   /* U+4143 */
  0x1C52,   /* U+4144 */
  0x1C52,   /* U+4145 */
  0x1C52,   /* U+4146 */
  0x1C52,   /* U+4147 */
  0x1C52,   /* U+4148 */
  0x1C52,   /* U+4149 */
  0x1C52,   /* U+414A */
  0x1C53,   /* U+414B */
  0x1C53,   /* U+414C */
  0x1C53,   /* U+414D */
  0x1C53,   /* U+414E */
  0x1C53,   /* U+414F */
  0x1C53,   /* U+4150 */
  0x1C53,   /* U+4151 */
  0x1C53,   /* U+4152 */
  0x1C53,   /* U+4153 */
  0x1C54,   /* U+4154 */
  0x1C54,   /* U+4155 */
  0x1C54,   /* U+4156 */
  0x1C54,   /* U+4157 */
  0x1C54,   /* U+4158 */
  0x1C54,   /* U+4159 */
  0x1C54,   /* U+415A */
  0x1C54,   /* U+415B */
  0x1C54,   /* U+415C */
  0x1C54,   /* U+415D */
  0x1C54,   /* U+415E */
  0x1C54,   /* U+415F */
  0x1C55,   /* U+4160 */
  0x1C55,   /* U+4161 */
  0x1C55,   /* U+4162 */
  0x1C55,   /* U+4163 */
  0x1C55,   /* U+4164 */
  0x1C55,   /* U+4165 */
  0x1C55,   /* U+4166 */
  0x1C55,   /* U+4167 */
  0x1C55,   /* U+4168 */
  0x1C55,   /* U+4169 */
  0x1C55,   /* U+416A */
  0x1C55,   /* U+416B */
  0x1C56,   /* U+416C */
  0x1C56,   /* U+416D */
  0x1C56,   /* U+416E */
  0x1C56,   /* U+416F */
  0x1C56,   /* U+4170 */
  0x1C56,   /* U+4171 */
  0x1C56,   /* U+4172 */
  0x1C56,   /* U+4173 */
  0x1C56,   /* U+4174 */
  0x1C56,   /* U+4175 */
  0x1C56,   /* U+4176 */
  0x1C57,   /* U+4177 */
  0x1C57,   /* U+4178 */
  0x1C57,   /* U+4179 */
  0x1C57,   /* U+417A */
  0x1C57,   /* U+417B */
  0x1C57,   /* U+417C */
  0x1C57,   /* U+417D */
  0x1C58,   /* U+417E */
  0x1C58,   /* U+417F */
  0x1C58,   /* U+4180 */
  0x1C59,   /* U+4181 */
  0x1C59,   /* U+4182 */
  0x1C59,   /* U+4183 */
  0x1C59,   /* U+4184 */
  0x1C59,   /* U+4185 */
  0x1C59,   /* U+4186 */
  0x1C59,   /* U+4187 */
  0x1C5B,   /* U+4188 */
  0x1C5B,   /* U+4189 */
  0x1C5C,   /* U+418A */
  0x1C5C,   /* U+418B */
  0x1C5C,   /* U+418C */
  0x1C5C,   /* U+418D */
  0x1C5D,   /* U+418E */
  0x1C5D,   /* U+418F */
  0x1C65,   /* U+4190 */
  0x1C4E,   /* U+4191 */
  0x1C4F,   /* U+4192 */
  0x1C50,   /* U+4193 */
  0x1C50,   /* U+4194 */
  0x1C50,   /* U+4195 */
  0x1C50,   /* U+4196 */
  0x1C51,   /* U+4197 */
  0x1C51,   /* U+4198 */
  0x1C51,   /* U+4199 */
  0x1C52,   /* U+419A */
  0x1C52,   /* U+419B */
  0x1C52,   /* U+419C */
  0x1C52,   /* U+419D */
  0x1C52,   /* U+419E */
  0x1C52,   /* U+419F */
  0x1C52,   /* U+41A0 */
  0x1C53,   /* U+41A1 */
  0x1C53,   /* U+41A2 */
  0x1C53,   /* U+41A3 */
  0x1C53,   /* U+41A4 */
  0x1C53,   /* U+41A5 */
  0x1C54,   /* U+41A6 */
  0x1C54,   /* U+41A7 */
  0x1C54,   /* U+41A8 */
  0x1C54,   /* U+41A9 */
  0x1C55,   /* U+41AA */
  0x1C55,   /* U+41AB */
  0x1C56,   /* U+41AC */
  0x1C56,   /* U+41AD */
  0x1C56,   /* U+41AE */
  0x1C57,   /* U+41AF */
  0x1C57,   /* U+41B0 */
  0x1C57,   /* U+41B1 */
  0x1C57,   /* U+41B2 */
  0x1C57,   /* U+41B3 */
  0x1C57,   /* U+41B4 */
  0x1C58,   /* U+41B5 */
  0x1C58,   /* U+41B6 */
  0x1C58,   /* U+41B7 */
  0x1C58,   /* U+41B8 */
  0x1C58,   /* U+41B9 */
  0x1C58,   /* U+41BA */
  0x1C58,   /* U+41BB */
  0x1C59,   /* U+41BC */
  0x1C59,   /* U+41BD */
  0x1C5A,   /* U+41BE */
  0x1C5A,   /* U+41BF */
  0x1C5B,   /* U+41C0 */
  0x1C5D,   /* U+41C1 */
  0x1C4D,   /* U+41C2 */
  0x1C4F,   /* U+41C3 */
  0x1C4F,   /* U+41C4 */
  0x1C50,   /* U+41C5 */
  0x1C50,   /* U+41C6 */
  0x1C51,   /* U+41C7 */
  0x1C51,   /* U+41C8 */
  0x1C51,   /* U+41C9 */
  0x1C51,   /* U+41CA */
  0x1C52,   /* U+41CB */
  0x1C53,   /* U+41CC */
  0x1C53,   /* U+41CD */
  0x1C54,   /* U+41CE */
  0x1C54,   /* U+41CF */
  0x1C54,   /* U+41D0 */
  0x1C54,   /* U+41D1 */
  0x1C57,   /* U+41D2 */
  0x1C58,   /* U+41D3 */
  0x1C59,   /* U+41D4 */
  0x1C5A,   /* U+41D5 */
  0x1C50,   /* U+41D6 */
  0x1C51,   /* U+41D7 */
  0x1C51,   /* U+41D8 */
  0x1C51,   /* U+41D9 */
  0x1C51,   /* U+41DA */
  0x1C51,   /* U+41DB */
  0x1C51,   /* U+41DC */
  0x1C51,   /* U+41DD */
  0x1C52,   /* U+41DE */
  0x1C52,   /* U+41DF */
  0x1C52,   /* U+41E0 */
  0x1C52,   /* U+41E1 */
  0x1C52,   /* U+41E2 */
  0x1C52,   /* U+41E3 */
  0x1C52,   /* U+41E4 */
  0x1C52,   /* U+41E5 */
  0x1C52,   /* U+41E6 */
  0x1C53,   /* U+41E7 */
  0x1C53,   /* U+41E8 */
  0x1C53,   /* U+41E9 */
  0x1C53,   /* U+41EA */
  0x1C53,   /* U+41EB */
  0x1C53,   /* U+41EC */
  0x1C53,   /* U+41ED */
  0x1C53,   /* U+41EE */
  0x1C53,   /* U+41EF */
  0x1C53,   /* U+41F0 */
  0x1C53,   /* U+41F1 */
  0x1C53,   /* U+41F2 */
  0x1C53,   /* U+41F3 */
  0x1C53,   /* U+41F4 */
  0x1C54,   /* U+41F5 */
  0x1C54,   /* U+41F6 */
  0x1C54,   /* U+41F7 */
  0x1C54,   /* U+41F8 */
  0x1C54,   /* U+41F9 */
  0x1C54,   /* U+41FA */
  0x1C54,   /* U+41FB */
  0x1C54,   /* U+41FC */
  0x1C54,   /* U+41FD */
  0x1C54,   /* U+41FE */
  0x1C54,   /* U+41FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4100 */
  0x0020,   /* U+4101 */
  0x0020,   /* U+4102 */
  0x0020,   /* U+4103 */
  0x0020,   /* U+4104 */
  0x0020,   /* U+4105 */
  0x0020,   /* U+4106 */
  0x0020,   /* U+4107 */
  0x0020,   /* U+4108 */
  0x0020,   /* U+4109 */
  0x0020,   /* U+410A */
  0x0020,   /* U+410B */
  0x0020,   /* U+410C */
  0x0020,   /* U+410D */
  0x0020,   /* U+410E */
  0x0020,   /* U+410F */
  0x0020,   /* U+4110 */
  0x0020,   /* U+4111 */
  0x0020,   /* U+4112 */
  0x0020,   /* U+4113 */
  0x0020,   /* U+4114 */
  0x0020,   /* U+4115 */
  0x0020,   /* U+4116 */
  0x0020,   /* U+4117 */
  0x0020,   /* U+4118 */
  0x0020,   /* U+4119 */
  0x0020,   /* U+411A */
  0x0020,   /* U+411B */
  0x0020,   /* U+411C */
  0x0020,   /* U+411D */
  0x0020,   /* U+411E */
  0x0020,   /* U+411F */
  0x0020,   /* U+4120 */
  0x0020,   /* U+4121 */
  0x0020,   /* U+4122 */
  0x0020,   /* U+4123 */
  0x0020,   /* U+4124 */
  0x0020,   /* U+4125 */
  0x0020,   /* U+4126 */
  0x0020,   /* U+4127 */
  0x0020,   /* U+4128 */
  0x0020,   /* U+4129 */
  0x0020,   /* U+412A */
  0x0020,   /* U+412B */
  0x0020,   /* U+412C */
  0x0020,   /* U+412D */
  0x0020,   /* U+412E */
  0x0020,   /* U+412F */
  0x0020,   /* U+4130 */
  0x0020,   /* U+4131 */
  0x0020,   /* U+4132 */
  0x0020,   /* U+4133 */
  0x0020,   /* U+4134 */
  0x0020,   /* U+4135 */
  0x0020,   /* U+4136 */
  0x0020,   /* U+4137 */
  0x0020,   /* U+4138 */
  0x0020,   /* U+4139 */
  0x0020,   /* U+413A */
  0x0020,   /* U+413B */
  0x0020,   /* U+413C */
  0x0020,   /* U+413D */
  0x0020,   /* U+413E */
  0x0020,   /* U+413F */
  0x0020,   /* U+4140 */
  0x0020,   /* U+4141 */
  0x0020,   /* U+4142 */
  0x0020,   /* U+4143 */
  0x0020,   /* U+4144 */
  0x0020,   /* U+4145 */
  0x0020,   /* U+4146 */
  0x0020,   /* U+4147 */
  0x0020,   /* U+4148 */
  0x0020,   /* U+4149 */
  0x0020,   /* U+414A */
  0x0020,   /* U+414B */
  0x0020,   /* U+414C */
  0x0020,   /* U+414D */
  0x0020,   /* U+414E */
  0x0020,   /* U+414F */
  0x0020,   /* U+4150 */
  0x0020,   /* U+4151 */
  0x0020,   /* U+4152 */
  0x0020,   /* U+4153 */
  0x0020,   /* U+4154 */
  0x0020,   /* U+4155 */
  0x0020,   /* U+4156 */
  0x0020,   /* U+4157 */
  0x0020,   /* U+4158 */
  0x0020,   /* U+4159 */
  0x0020,   /* U+415A */
  0x0020,   /* U+415B */
  0x0020,   /* U+415C */
  0x0020,   /* U+415D */
  0x0020,   /* U+415E */
  0x0020,   /* U+415F */
  0x0020,   /* U+4160 */
  0x0020,   /* U+4161 */
  0x0020,   /* U+4162 */
  0x0020,   /* U+4163 */
  0x0020,   /* U+4164 */
  0x0020,   /* U+4165 */
  0x0020,   /* U+4166 */
  0x0020,   /* U+4167 */
  0x0020,   /* U+4168 */
  0x0020,   /* U+4169 */
  0x0020,   /* U+416A */
  0x0020,   /* U+416B */
  0x0020,   /* U+416C */
  0x0020,   /* U+416D */
  0x0020,   /* U+416E */
  0x0020,   /* U+416F */
  0x0020,   /* U+4170 */
  0x0020,   /* U+4171 */
  0x0020,   /* U+4172 */
  0x0020,   /* U+4173 */
  0x0020,   /* U+4174 */
  0x0020,   /* U+4175 */
  0x0020,   /* U+4176 */
  0x0020,   /* U+4177 */
  0x0020,   /* U+4178 */
  0x0020,   /* U+4179 */
  0x0020,   /* U+417A */
  0x0020,   /* U+417B */
  0x0020,   /* U+417C */
  0x0020,   /* U+417D */
  0x0020,   /* U+417E */
  0x0020,   /* U+417F */
  0x0020,   /* U+4180 */
  0x0020,   /* U+4181 */
  0x0020,   /* U+4182 */
  0x0020,   /* U+4183 */
  0x0020,   /* U+4184 */
  0x0020,   /* U+4185 */
  0x0020,   /* U+4186 */
  0x0020,   /* U+4187 */
  0x0020,   /* U+4188 */
  0x0020,   /* U+4189 */
  0x0020,   /* U+418A */
  0x0020,   /* U+418B */
  0x0020,   /* U+418C */
  0x0020,   /* U+418D */
  0x0020,   /* U+418E */
  0x0020,   /* U+418F */
  0x0020,   /* U+4190 */
  0x0020,   /* U+4191 */
  0x0020,   /* U+4192 */
  0x0020,   /* U+4193 */
  0x0020,   /* U+4194 */
  0x0020,   /* U+4195 */
  0x0020,   /* U+4196 */
  0x0020,   /* U+4197 */
  0x0020,   /* U+4198 */
  0x0020,   /* U+4199 */
  0x0020,   /* U+419A */
  0x0020,   /* U+419B */
  0x0020,   /* U+419C */
  0x0020,   /* U+419D */
  0x0020,   /* U+419E */
  0x0020,   /* U+419F */
  0x0020,   /* U+41A0 */
  0x0020,   /* U+41A1 */
  0x0020,   /* U+41A2 */
  0x0020,   /* U+41A3 */
  0x0020,   /* U+41A4 */
  0x0020,   /* U+41A5 */
  0x0020,   /* U+41A6 */
  0x0020,   /* U+41A7 */
  0x0020,   /* U+41A8 */
  0x0020,   /* U+41A9 */
  0x0020,   /* U+41AA */
  0x0020,   /* U+41AB */
  0x0020,   /* U+41AC */
  0x0020,   /* U+41AD */
  0x0020,   /* U+41AE */
  0x0020,   /* U+41AF */
  0x0020,   /* U+41B0 */
  0x0020,   /* U+41B1 */
  0x0020,   /* U+41B2 */
  0x0020,   /* U+41B3 */
  0x0020,   /* U+41B4 */
  0x0020,   /* U+41B5 */
  0x0020,   /* U+41B6 */
  0x0020,   /* U+41B7 */
  0x0020,   /* U+41B8 */
  0x0020,   /* U+41B9 */
  0x0020,   /* U+41BA */
  0x0020,   /* U+41BB */
  0x0020,   /* U+41BC */
  0x0020,   /* U+41BD */
  0x0020,   /* U+41BE */
  0x0020,   /* U+41BF */
  0x0020,   /* U+41C0 */
  0x0020,   /* U+41C1 */
  0x0020,   /* U+41C2 */
  0x0020,   /* U+41C3 */
  0x0020,   /* U+41C4 */
  0x0020,   /* U+41C5 */
  0x0020,   /* U+41C6 */
  0x0020,   /* U+41C7 */
  0x0020,   /* U+41C8 */
  0x0020,   /* U+41C9 */
  0x0020,   /* U+41CA */
  0x0020,   /* U+41CB */
  0x0020,   /* U+41CC */
  0x0020,   /* U+41CD */
  0x0020,   /* U+41CE */
  0x0020,   /* U+41CF */
  0x0020,   /* U+41D0 */
  0x0020,   /* U+41D1 */
  0x0020,   /* U+41D2 */
  0x0020,   /* U+41D3 */
  0x0020,   /* U+41D4 */
  0x0020,   /* U+41D5 */
  0x0020,   /* U+41D6 */
  0x0020,   /* U+41D7 */
  0x0020,   /* U+41D8 */
  0x0020,   /* U+41D9 */
  0x0020,   /* U+41DA */
  0x0020,   /* U+41DB */
  0x0020,   /* U+41DC */
  0x0020,   /* U+41DD */
  0x0020,   /* U+41DE */
  0x0020,   /* U+41DF */
  0x0020,   /* U+41E0 */
  0x0020,   /* U+41E1 */
  0x0020,   /* U+41E2 */
  0x0020,   /* U+41E3 */
  0x0020,   /* U+41E4 */
  0x0020,   /* U+41E5 */
  0x0020,   /* U+41E6 */
  0x0020,   /* U+41E7 */
  0x0020,   /* U+41E8 */
  0x0020,   /* U+41E9 */
  0x0020,   /* U+41EA */
  0x0020,   /* U+41EB */
  0x0020,   /* U+41EC */
  0x0020,   /* U+41ED */
  0x0020,   /* U+41EE */
  0x0020,   /* U+41EF */
  0x0020,   /* U+41F0 */
  0x0020,   /* U+41F1 */
  0x0020,   /* U+41F2 */
  0x0020,   /* U+41F3 */
  0x0020,   /* U+41F4 */
  0x0020,   /* U+41F5 */
  0x0020,   /* U+41F6 */
  0x0020,   /* U+41F7 */
  0x0020,   /* U+41F8 */
  0x0020,   /* U+41F9 */
  0x0020,   /* U+41FA */
  0x0020,   /* U+41FB */
  0x0020,   /* U+41FC */
  0x0020,   /* U+41FD */
  0x0020,   /* U+41FE */
  0x0020,   /* U+41FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4100 */
  0x0002,   /* U+4101 */
  0x0002,   /* U+4102 */
  0x0002,   /* U+4103 */
  0x0002,   /* U+4104 */
  0x0002,   /* U+4105 */
  0x0002,   /* U+4106 */
  0x0002,   /* U+4107 */
  0x0002,   /* U+4108 */
  0x0002,   /* U+4109 */
  0x0002,   /* U+410A */
  0x0002,   /* U+410B */
  0x0002,   /* U+410C */
  0x0002,   /* U+410D */
  0x0002,   /* U+410E */
  0x0002,   /* U+410F */
  0x0002,   /* U+4110 */
  0x0002,   /* U+4111 */
  0x0002,   /* U+4112 */
  0x0002,   /* U+4113 */
  0x0002,   /* U+4114 */
  0x0002,   /* U+4115 */
  0x0002,   /* U+4116 */
  0x0002,   /* U+4117 */
  0x0002,   /* U+4118 */
  0x0002,   /* U+4119 */
  0x0002,   /* U+411A */
  0x0002,   /* U+411B */
  0x0002,   /* U+411C */
  0x0002,   /* U+411D */
  0x0002,   /* U+411E */
  0x0002,   /* U+411F */
  0x0002,   /* U+4120 */
  0x0002,   /* U+4121 */
  0x0002,   /* U+4122 */
  0x0002,   /* U+4123 */
  0x0002,   /* U+4124 */
  0x0002,   /* U+4125 */
  0x0002,   /* U+4126 */
  0x0002,   /* U+4127 */
  0x0002,   /* U+4128 */
  0x0002,   /* U+4129 */
  0x0002,   /* U+412A */
  0x0002,   /* U+412B */
  0x0002,   /* U+412C */
  0x0002,   /* U+412D */
  0x0002,   /* U+412E */
  0x0002,   /* U+412F */
  0x0002,   /* U+4130 */
  0x0002,   /* U+4131 */
  0x0002,   /* U+4132 */
  0x0002,   /* U+4133 */
  0x0002,   /* U+4134 */
  0x0002,   /* U+4135 */
  0x0002,   /* U+4136 */
  0x0002,   /* U+4137 */
  0x0002,   /* U+4138 */
  0x0002,   /* U+4139 */
  0x0002,   /* U+413A */
  0x0002,   /* U+413B */
  0x0002,   /* U+413C */
  0x0002,   /* U+413D */
  0x0002,   /* U+413E */
  0x0002,   /* U+413F */
  0x0002,   /* U+4140 */
  0x0002,   /* U+4141 */
  0x0002,   /* U+4142 */
  0x0002,   /* U+4143 */
  0x0002,   /* U+4144 */
  0x0002,   /* U+4145 */
  0x0002,   /* U+4146 */
  0x0002,   /* U+4147 */
  0x0002,   /* U+4148 */
  0x0002,   /* U+4149 */
  0x0002,   /* U+414A */
  0x0002,   /* U+414B */
  0x0002,   /* U+414C */
  0x0002,   /* U+414D */
  0x0002,   /* U+414E */
  0x0002,   /* U+414F */
  0x0002,   /* U+4150 */
  0x0002,   /* U+4151 */
  0x0002,   /* U+4152 */
  0x0002,   /* U+4153 */
  0x0002,   /* U+4154 */
  0x0002,   /* U+4155 */
  0x0002,   /* U+4156 */
  0x0002,   /* U+4157 */
  0x0002,   /* U+4158 */
  0x0002,   /* U+4159 */
  0x0002,   /* U+415A */
  0x0002,   /* U+415B */
  0x0002,   /* U+415C */
  0x0002,   /* U+415D */
  0x0002,   /* U+415E */
  0x0002,   /* U+415F */
  0x0002,   /* U+4160 */
  0x0002,   /* U+4161 */
  0x0002,   /* U+4162 */
  0x0002,   /* U+4163 */
  0x0002,   /* U+4164 */
  0x0002,   /* U+4165 */
  0x0002,   /* U+4166 */
  0x0002,   /* U+4167 */
  0x0002,   /* U+4168 */
  0x0002,   /* U+4169 */
  0x0002,   /* U+416A */
  0x0002,   /* U+416B */
  0x0002,   /* U+416C */
  0x0002,   /* U+416D */
  0x0002,   /* U+416E */
  0x0002,   /* U+416F */
  0x0002,   /* U+4170 */
  0x0002,   /* U+4171 */
  0x0002,   /* U+4172 */
  0x0002,   /* U+4173 */
  0x0002,   /* U+4174 */
  0x0002,   /* U+4175 */
  0x0002,   /* U+4176 */
  0x0002,   /* U+4177 */
  0x0002,   /* U+4178 */
  0x0002,   /* U+4179 */
  0x0002,   /* U+417A */
  0x0002,   /* U+417B */
  0x0002,   /* U+417C */
  0x0002,   /* U+417D */
  0x0002,   /* U+417E */
  0x0002,   /* U+417F */
  0x0002,   /* U+4180 */
  0x0002,   /* U+4181 */
  0x0002,   /* U+4182 */
  0x0002,   /* U+4183 */
  0x0002,   /* U+4184 */
  0x0002,   /* U+4185 */
  0x0002,   /* U+4186 */
  0x0002,   /* U+4187 */
  0x0002,   /* U+4188 */
  0x0002,   /* U+4189 */
  0x0002,   /* U+418A */
  0x0002,   /* U+418B */
  0x0002,   /* U+418C */
  0x0002,   /* U+418D */
  0x0002,   /* U+418E */
  0x0002,   /* U+418F */
  0x0002,   /* U+4190 */
  0x0002,   /* U+4191 */
  0x0002,   /* U+4192 */
  0x0002,   /* U+4193 */
  0x0002,   /* U+4194 */
  0x0002,   /* U+4195 */
  0x0002,   /* U+4196 */
  0x0002,   /* U+4197 */
  0x0002,   /* U+4198 */
  0x0002,   /* U+4199 */
  0x0002,   /* U+419A */
  0x0002,   /* U+419B */
  0x0002,   /* U+419C */
  0x0002,   /* U+419D */
  0x0002,   /* U+419E */
  0x0002,   /* U+419F */
  0x0002,   /* U+41A0 */
  0x0002,   /* U+41A1 */
  0x0002,   /* U+41A2 */
  0x0002,   /* U+41A3 */
  0x0002,   /* U+41A4 */
  0x0002,   /* U+41A5 */
  0x0002,   /* U+41A6 */
  0x0002,   /* U+41A7 */
  0x0002,   /* U+41A8 */
  0x0002,   /* U+41A9 */
  0x0002,   /* U+41AA */
  0x0002,   /* U+41AB */
  0x0002,   /* U+41AC */
  0x0002,   /* U+41AD */
  0x0002,   /* U+41AE */
  0x0002,   /* U+41AF */
  0x0002,   /* U+41B0 */
  0x0002,   /* U+41B1 */
  0x0002,   /* U+41B2 */
  0x0002,   /* U+41B3 */
  0x0002,   /* U+41B4 */
  0x0002,   /* U+41B5 */
  0x0002,   /* U+41B6 */
  0x0002,   /* U+41B7 */
  0x0002,   /* U+41B8 */
  0x0002,   /* U+41B9 */
  0x0002,   /* U+41BA */
  0x0002,   /* U+41BB */
  0x0002,   /* U+41BC */
  0x0002,   /* U+41BD */
  0x0002,   /* U+41BE */
  0x0002,   /* U+41BF */
  0x0002,   /* U+41C0 */
  0x0002,   /* U+41C1 */
  0x0002,   /* U+41C2 */
  0x0002,   /* U+41C3 */
  0x0002,   /* U+41C4 */
  0x0002,   /* U+41C5 */
  0x0002,   /* U+41C6 */
  0x0002,   /* U+41C7 */
  0x0002,   /* U+41C8 */
  0x0002,   /* U+41C9 */
  0x0002,   /* U+41CA */
  0x0002,   /* U+41CB */
  0x0002,   /* U+41CC */
  0x0002,   /* U+41CD */
  0x0002,   /* U+41CE */
  0x0002,   /* U+41CF */
  0x0002,   /* U+41D0 */
  0x0002,   /* U+41D1 */
  0x0002,   /* U+41D2 */
  0x0002,   /* U+41D3 */
  0x0002,   /* U+41D4 */
  0x0002,   /* U+41D5 */
  0x0002,   /* U+41D6 */
  0x0002,   /* U+41D7 */
  0x0002,   /* U+41D8 */
  0x0002,   /* U+41D9 */
  0x0002,   /* U+41DA */
  0x0002,   /* U+41DB */
  0x0002,   /* U+41DC */
  0x0002,   /* U+41DD */
  0x0002,   /* U+41DE */
  0x0002,   /* U+41DF */
  0x0002,   /* U+41E0 */
  0x0002,   /* U+41E1 */
  0x0002,   /* U+41E2 */
  0x0002,   /* U+41E3 */
  0x0002,   /* U+41E4 */
  0x0002,   /* U+41E5 */
  0x0002,   /* U+41E6 */
  0x0002,   /* U+41E7 */
  0x0002,   /* U+41E8 */
  0x0002,   /* U+41E9 */
  0x0002,   /* U+41EA */
  0x0002,   /* U+41EB */
  0x0002,   /* U+41EC */
  0x0002,   /* U+41ED */
  0x0002,   /* U+41EE */
  0x0002,   /* U+41EF */
  0x0002,   /* U+41F0 */
  0x0002,   /* U+41F1 */
  0x0002,   /* U+41F2 */
  0x0002,   /* U+41F3 */
  0x0002,   /* U+41F4 */
  0x0002,   /* U+41F5 */
  0x0002,   /* U+41F6 */
  0x0002,   /* U+41F7 */
  0x0002,   /* U+41F8 */
  0x0002,   /* U+41F9 */
  0x0002,   /* U+41FA */
  0x0002,   /* U+41FB */
  0x0002,   /* U+41FC */
  0x0002,   /* U+41FD */
  0x0002,   /* U+41FE */
  0x0002,   /* U+41FF */

  /* Primary weight 2 for each character. */
  0x8F2D,   /* U+4100 */
  0x90DD,   /* U+4101 */
  0x90DE,   /* U+4102 */
  0x90DF,   /* U+4103 */
  0x918C,   /* U+4104 */
  0x918D,   /* U+4105 */
  0x918E,   /* U+4106 */
  0x92D5,   /* U+4107 */
  0x92D6,   /* U+4108 */
  0x92D7,   /* U+4109 */
  0x92D8,   /* U+410A */
  0x90D4,   /* U+410B */
  0x90D5,   /* U+410C */
  0x90D6,   /* U+410D */
  0x90D7,   /* U+410E */
  0x90D8,   /* U+410F */
  0x90D9,   /* U+4110 */
  0x90DA,   /* U+4111 */
  0x90DB,   /* U+4112 */
  0x8F70,   /* U+4113 */
  0x8F71,   /* U+4114 */
  0x8F72,   /* U+4115 */
  0x8F73,   /* U+4116 */
  0x8F74,   /* U+4117 */
  0x8DD8,   /* U+4118 */
  0x8DD9,   /* U+4119 */
  0x8B72,   /* U+411A */
  0x8B73,   /* U+411B */
  0x8B74,   /* U+411C */
  0x8B75,   /* U+411D */
  0x8B76,   /* U+411E */
  0x881B,   /* U+411F */
  0x86AC,   /* U+4120 */
  0x86AD,   /* U+4121 */
  0x84F5,   /* U+4122 */
  0x839C,   /* U+4123 */
  0x82B9,   /* U+4124 */
  0x8019,   /* U+4125 */
  0x898C,   /* U+4126 */
  0x898D,   /* U+4127 */
  0x8CF2,   /* U+4128 */
  0x8CF3,   /* U+4129 */
  0x8CF4,   /* U+412A */
  0x8CF5,   /* U+412B */
  0x8CF6,   /* U+412C */
  0x8CF7,   /* U+412D */
  0x8F6D,   /* U+412E */
  0x8F6E,   /* U+412F */
  0x8F6F,   /* U+4130 */
  0x8F70,   /* U+4131 */
  0x8F71,   /* U+4132 */
  0x8F72,   /* U+4133 */
  0x8F73,   /* U+4134 */
  0x8F74,   /* U+4135 */
  0x912C,   /* U+4136 */
  0x912D,   /* U+4137 */
  0x912E,   /* U+4138 */
  0x912F,   /* U+4139 */
  0x91E2,   /* U+413A */
  0x91E3,   /* U+413B */
  0x91E4,   /* U+413C */
  0x91E5,   /* U+413D */
  0x91E6,   /* U+413E */
  0x91E7,   /* U+413F */
  0x91E8,   /* U+4140 */
  0x91E9,   /* U+4141 */
  0x91EA,   /* U+4142 */
  0x91EB,   /* U+4143 */
  0x91EC,   /* U+4144 */
  0x91ED,   /* U+4145 */
  0x91EE,   /* U+4146 */
  0x91EF,   /* U+4147 */
  0x91F0,   /* U+4148 */
  0x91F1,   /* U+4149 */
  0x91F2,   /* U+414A */
  0x932C,   /* U+414B */
  0x932D,   /* U+414C */
  0x932E,   /* U+414D */
  0x932F,   /* U+414E */
  0x9330,   /* U+414F */
  0x9331,   /* U+4150 */
  0x9332,   /* U+4151 */
  0x9333,   /* U+4152 */
  0x9334,   /* U+4153 */
  0x9128,   /* U+4154 */
  0x9129,   /* U+4155 */
  0x912A,   /* U+4156 */
  0x912B,   /* U+4157 */
  0x912C,   /* U+4158 */
  0x912D,   /* U+4159 */
  0x912E,   /* U+415A */
  0x912F,   /* U+415B */
  0x9130,   /* U+415C */
  0x9131,   /* U+415D */
  0x9132,   /* U+415E */
  0x9133,   /* U+415F */
  0x8FAD,   /* U+4160 */
  0x8FAE,   /* U+4161 */
  0x8FAF,   /* U+4162 */
  0x8FB0,   /* U+4163 */
  0x8FB1,   /* U+4164 */
  0x8FB2,   /* U+4165 */
  0x8FB3,   /* U+4166 */
  0x8FB4,   /* U+4167 */
  0x8FB5,   /* U+4168 */
  0x8FB6,   /* U+4169 */
  0x8FB7,   /* U+416A */
  0x8FB8,   /* U+416B */
  0x8E17,   /* U+416C */
  0x8E18,   /* U+416D */
  0x8E19,   /* U+416E */
  0x8E1A,   /* U+416F */
  0x8E1B,   /* U+4170 */
  0x8E1C,   /* U+4171 */
  0x8E1D,   /* U+4172 */
  0x8E1E,   /* U+4173 */
  0x8E1F,   /* U+4174 */
  0x8E20,   /* U+4175 */
  0x8E21,   /* U+4176 */
  0x8BA7,   /* U+4177 */
  0x8BA8,   /* U+4178 */
  0x8BA9,   /* U+4179 */
  0x8BAA,   /* U+417A */
  0x8BAB,   /* U+417B */
  0x8BAC,   /* U+417C */
  0x8BAD,   /* U+417D */
  0x8842,   /* U+417E */
  0x8843,   /* U+417F */
  0x8844,   /* U+4180 */
  0x86BF,   /* U+4181 */
  0x86C0,   /* U+4182 */
  0x86C1,   /* U+4183 */
  0x86C2,   /* U+4184 */
  0x86C3,   /* U+4185 */
  0x86C4,   /* U+4186 */
  0x86C5,   /* U+4187 */
  0x83AB,   /* U+4188 */
  0x83AC,   /* U+4189 */
  0x82C9,   /* U+418A */
  0x82CA,   /* U+418B */
  0x82CB,   /* U+418C */
  0x82CC,   /* U+418D */
  0x8208,   /* U+418E */
  0x8209,   /* U+418F */
  0x8014,   /* U+4190 */
  0x8997,   /* U+4191 */
  0x8D0E,   /* U+4192 */
  0x8FA9,   /* U+4193 */
  0x8FAA,   /* U+4194 */
  0x8FAB,   /* U+4195 */
  0x8FAC,   /* U+4196 */
  0x9168,   /* U+4197 */
  0x9169,   /* U+4198 */
  0x916A,   /* U+4199 */
  0x9225,   /* U+419A */
  0x9226,   /* U+419B */
  0x9227,   /* U+419C */
  0x9228,   /* U+419D */
  0x9229,   /* U+419E */
  0x922A,   /* U+419F */
  0x922B,   /* U+41A0 */
  0x9367,   /* U+41A1 */
  0x9368,   /* U+41A2 */
  0x9369,   /* U+41A3 */
  0x936A,   /* U+41A4 */
  0x936B,   /* U+41A5 */
  0x9186,   /* U+41A6 */
  0x9187,   /* U+41A7 */
  0x9188,   /* U+41A8 */
  0x9189,   /* U+41A9 */
  0x9005,   /* U+41AA */
  0x9006,   /* U+41AB */
  0x8E6B,   /* U+41AC */
  0x8E6C,   /* U+41AD */
  0x8E6D,   /* U+41AE */
  0x8BF5,   /* U+41AF */
  0x8BF6,   /* U+41B0 */
  0x8BF7,   /* U+41B1 */
  0x8BF8,   /* U+41B2 */
  0x8BF9,   /* U+41B3 */
  0x8BFA,   /* U+41B4 */
  0x8882,   /* U+41B5 */
  0x8883,   /* U+41B6 */
  0x8884,   /* U+41B7 */
  0x8885,   /* U+41B8 */
  0x8886,   /* U+41B9 */
  0x8887,   /* U+41BA */
  0x8888,   /* U+41BB */
  0x86ED,   /* U+41BC */
  0x86EE,   /* U+41BD */
  0x851C,   /* U+41BE */
  0x851D,   /* U+41BF */
  0x83CD,   /* U+41C0 */
  0x8211,   /* U+41C1 */
  0x85CB,   /* U+41C2 */
  0x8D1F,   /* U+41C3 */
  0x8D20,   /* U+41C4 */
  0x8FCD,   /* U+41C5 */
  0x8FCE,   /* U+41C6 */
  0x9194,   /* U+41C7 */
  0x9195,   /* U+41C8 */
  0x9196,   /* U+41C9 */
  0x9197,   /* U+41CA */
  0x924B,   /* U+41CB */
  0x93A4,   /* U+41CC */
  0x93A5,   /* U+41CD */
  0x91B9,   /* U+41CE */
  0x91BA,   /* U+41CF */
  0x91BB,   /* U+41D0 */
  0x91BC,   /* U+41D1 */
  0x8C2B,   /* U+41D2 */
  0x88AA,   /* U+41D3 */
  0x8700,   /* U+41D4 */
  0x8529,   /* U+41D5 */
  0x8FE5,   /* U+41D6 */
  0x91C3,   /* U+41D7 */
  0x91C4,   /* U+41D8 */
  0x91C5,   /* U+41D9 */
  0x91C6,   /* U+41DA */
  0x91C7,   /* U+41DB */
  0x91C8,   /* U+41DC */
  0x91C9,   /* U+41DD */
  0x9289,   /* U+41DE */
  0x928A,   /* U+41DF */
  0x928B,   /* U+41E0 */
  0x928C,   /* U+41E1 */
  0x928D,   /* U+41E2 */
  0x928E,   /* U+41E3 */
  0x928F,   /* U+41E4 */
  0x9290,   /* U+41E5 */
  0x9291,   /* U+41E6 */
  0x93D8,   /* U+41E7 */
  0x93D9,   /* U+41E8 */
  0x93DA,   /* U+41E9 */
  0x93DB,   /* U+41EA */
  0x93DC,   /* U+41EB */
  0x93DD,   /* U+41EC */
  0x93DE,   /* U+41ED */
  0x93DF,   /* U+41EE */
  0x93E0,   /* U+41EF */
  0x93E1,   /* U+41F0 */
  0x93E2,   /* U+41F1 */
  0x93E3,   /* U+41F2 */
  0x93E4,   /* U+41F3 */
  0x93E5,   /* U+41F4 */
  0x91F5,   /* U+41F5 */
  0x91F6,   /* U+41F6 */
  0x91F7,   /* U+41F7 */
  0x91F8,   /* U+41F8 */
  0x91F9,   /* U+41F9 */
  0x91FA,   /* U+41FA */
  0x91FB,   /* U+41FB */
  0x91FC,   /* U+41FC */
  0x91FD,   /* U+41FD */
  0x91FE,   /* U+41FE */
  0x91FF,   /* U+41FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4100 */
  0x0000,   /* U+4101 */
  0x0000,   /* U+4102 */
  0x0000,   /* U+4103 */
  0x0000,   /* U+4104 */
  0x0000,   /* U+4105 */
  0x0000,   /* U+4106 */
  0x0000,   /* U+4107 */
  0x0000,   /* U+4108 */
  0x0000,   /* U+4109 */
  0x0000,   /* U+410A */
  0x0000,   /* U+410B */
  0x0000,   /* U+410C */
  0x0000,   /* U+410D */
  0x0000,   /* U+410E */
  0x0000,   /* U+410F */
  0x0000,   /* U+4110 */
  0x0000,   /* U+4111 */
  0x0000,   /* U+4112 */
  0x0000,   /* U+4113 */
  0x0000,   /* U+4114 */
  0x0000,   /* U+4115 */
  0x0000,   /* U+4116 */
  0x0000,   /* U+4117 */
  0x0000,   /* U+4118 */
  0x0000,   /* U+4119 */
  0x0000,   /* U+411A */
  0x0000,   /* U+411B */
  0x0000,   /* U+411C */
  0x0000,   /* U+411D */
  0x0000,   /* U+411E */
  0x0000,   /* U+411F */
  0x0000,   /* U+4120 */
  0x0000,   /* U+4121 */
  0x0000,   /* U+4122 */
  0x0000,   /* U+4123 */
  0x0000,   /* U+4124 */
  0x0000,   /* U+4125 */
  0x0000,   /* U+4126 */
  0x0000,   /* U+4127 */
  0x0000,   /* U+4128 */
  0x0000,   /* U+4129 */
  0x0000,   /* U+412A */
  0x0000,   /* U+412B */
  0x0000,   /* U+412C */
  0x0000,   /* U+412D */
  0x0000,   /* U+412E */
  0x0000,   /* U+412F */
  0x0000,   /* U+4130 */
  0x0000,   /* U+4131 */
  0x0000,   /* U+4132 */
  0x0000,   /* U+4133 */
  0x0000,   /* U+4134 */
  0x0000,   /* U+4135 */
  0x0000,   /* U+4136 */
  0x0000,   /* U+4137 */
  0x0000,   /* U+4138 */
  0x0000,   /* U+4139 */
  0x0000,   /* U+413A */
  0x0000,   /* U+413B */
  0x0000,   /* U+413C */
  0x0000,   /* U+413D */
  0x0000,   /* U+413E */
  0x0000,   /* U+413F */
  0x0000,   /* U+4140 */
  0x0000,   /* U+4141 */
  0x0000,   /* U+4142 */
  0x0000,   /* U+4143 */
  0x0000,   /* U+4144 */
  0x0000,   /* U+4145 */
  0x0000,   /* U+4146 */
  0x0000,   /* U+4147 */
  0x0000,   /* U+4148 */
  0x0000,   /* U+4149 */
  0x0000,   /* U+414A */
  0x0000,   /* U+414B */
  0x0000,   /* U+414C */
  0x0000,   /* U+414D */
  0x0000,   /* U+414E */
  0x0000,   /* U+414F */
  0x0000,   /* U+4150 */
  0x0000,   /* U+4151 */
  0x0000,   /* U+4152 */
  0x0000,   /* U+4153 */
  0x0000,   /* U+4154 */
  0x0000,   /* U+4155 */
  0x0000,   /* U+4156 */
  0x0000,   /* U+4157 */
  0x0000,   /* U+4158 */
  0x0000,   /* U+4159 */
  0x0000,   /* U+415A */
  0x0000,   /* U+415B */
  0x0000,   /* U+415C */
  0x0000,   /* U+415D */
  0x0000,   /* U+415E */
  0x0000,   /* U+415F */
  0x0000,   /* U+4160 */
  0x0000,   /* U+4161 */
  0x0000,   /* U+4162 */
  0x0000,   /* U+4163 */
  0x0000,   /* U+4164 */
  0x0000,   /* U+4165 */
  0x0000,   /* U+4166 */
  0x0000,   /* U+4167 */
  0x0000,   /* U+4168 */
  0x0000,   /* U+4169 */
  0x0000,   /* U+416A */
  0x0000,   /* U+416B */
  0x0000,   /* U+416C */
  0x0000,   /* U+416D */
  0x0000,   /* U+416E */
  0x0000,   /* U+416F */
  0x0000,   /* U+4170 */
  0x0000,   /* U+4171 */
  0x0000,   /* U+4172 */
  0x0000,   /* U+4173 */
  0x0000,   /* U+4174 */
  0x0000,   /* U+4175 */
  0x0000,   /* U+4176 */
  0x0000,   /* U+4177 */
  0x0000,   /* U+4178 */
  0x0000,   /* U+4179 */
  0x0000,   /* U+417A */
  0x0000,   /* U+417B */
  0x0000,   /* U+417C */
  0x0000,   /* U+417D */
  0x0000,   /* U+417E */
  0x0000,   /* U+417F */
  0x0000,   /* U+4180 */
  0x0000,   /* U+4181 */
  0x0000,   /* U+4182 */
  0x0000,   /* U+4183 */
  0x0000,   /* U+4184 */
  0x0000,   /* U+4185 */
  0x0000,   /* U+4186 */
  0x0000,   /* U+4187 */
  0x0000,   /* U+4188 */
  0x0000,   /* U+4189 */
  0x0000,   /* U+418A */
  0x0000,   /* U+418B */
  0x0000,   /* U+418C */
  0x0000,   /* U+418D */
  0x0000,   /* U+418E */
  0x0000,   /* U+418F */
  0x0000,   /* U+4190 */
  0x0000,   /* U+4191 */
  0x0000,   /* U+4192 */
  0x0000,   /* U+4193 */
  0x0000,   /* U+4194 */
  0x0000,   /* U+4195 */
  0x0000,   /* U+4196 */
  0x0000,   /* U+4197 */
  0x0000,   /* U+4198 */
  0x0000,   /* U+4199 */
  0x0000,   /* U+419A */
  0x0000,   /* U+419B */
  0x0000,   /* U+419C */
  0x0000,   /* U+419D */
  0x0000,   /* U+419E */
  0x0000,   /* U+419F */
  0x0000,   /* U+41A0 */
  0x0000,   /* U+41A1 */
  0x0000,   /* U+41A2 */
  0x0000,   /* U+41A3 */
  0x0000,   /* U+41A4 */
  0x0000,   /* U+41A5 */
  0x0000,   /* U+41A6 */
  0x0000,   /* U+41A7 */
  0x0000,   /* U+41A8 */
  0x0000,   /* U+41A9 */
  0x0000,   /* U+41AA */
  0x0000,   /* U+41AB */
  0x0000,   /* U+41AC */
  0x0000,   /* U+41AD */
  0x0000,   /* U+41AE */
  0x0000,   /* U+41AF */
  0x0000,   /* U+41B0 */
  0x0000,   /* U+41B1 */
  0x0000,   /* U+41B2 */
  0x0000,   /* U+41B3 */
  0x0000,   /* U+41B4 */
  0x0000,   /* U+41B5 */
  0x0000,   /* U+41B6 */
  0x0000,   /* U+41B7 */
  0x0000,   /* U+41B8 */
  0x0000,   /* U+41B9 */
  0x0000,   /* U+41BA */
  0x0000,   /* U+41BB */
  0x0000,   /* U+41BC */
  0x0000,   /* U+41BD */
  0x0000,   /* U+41BE */
  0x0000,   /* U+41BF */
  0x0000,   /* U+41C0 */
  0x0000,   /* U+41C1 */
  0x0000,   /* U+41C2 */
  0x0000,   /* U+41C3 */
  0x0000,   /* U+41C4 */
  0x0000,   /* U+41C5 */
  0x0000,   /* U+41C6 */
  0x0000,   /* U+41C7 */
  0x0000,   /* U+41C8 */
  0x0000,   /* U+41C9 */
  0x0000,   /* U+41CA */
  0x0000,   /* U+41CB */
  0x0000,   /* U+41CC */
  0x0000,   /* U+41CD */
  0x0000,   /* U+41CE */
  0x0000,   /* U+41CF */
  0x0000,   /* U+41D0 */
  0x0000,   /* U+41D1 */
  0x0000,   /* U+41D2 */
  0x0000,   /* U+41D3 */
  0x0000,   /* U+41D4 */
  0x0000,   /* U+41D5 */
  0x0000,   /* U+41D6 */
  0x0000,   /* U+41D7 */
  0x0000,   /* U+41D8 */
  0x0000,   /* U+41D9 */
  0x0000,   /* U+41DA */
  0x0000,   /* U+41DB */
  0x0000,   /* U+41DC */
  0x0000,   /* U+41DD */
  0x0000,   /* U+41DE */
  0x0000,   /* U+41DF */
  0x0000,   /* U+41E0 */
  0x0000,   /* U+41E1 */
  0x0000,   /* U+41E2 */
  0x0000,   /* U+41E3 */
  0x0000,   /* U+41E4 */
  0x0000,   /* U+41E5 */
  0x0000,   /* U+41E6 */
  0x0000,   /* U+41E7 */
  0x0000,   /* U+41E8 */
  0x0000,   /* U+41E9 */
  0x0000,   /* U+41EA */
  0x0000,   /* U+41EB */
  0x0000,   /* U+41EC */
  0x0000,   /* U+41ED */
  0x0000,   /* U+41EE */
  0x0000,   /* U+41EF */
  0x0000,   /* U+41F0 */
  0x0000,   /* U+41F1 */
  0x0000,   /* U+41F2 */
  0x0000,   /* U+41F3 */
  0x0000,   /* U+41F4 */
  0x0000,   /* U+41F5 */
  0x0000,   /* U+41F6 */
  0x0000,   /* U+41F7 */
  0x0000,   /* U+41F8 */
  0x0000,   /* U+41F9 */
  0x0000,   /* U+41FA */
  0x0000,   /* U+41FB */
  0x0000,   /* U+41FC */
  0x0000,   /* U+41FD */
  0x0000,   /* U+41FE */
  0x0000,   /* U+41FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4100 */
  0x0000,   /* U+4101 */
  0x0000,   /* U+4102 */
  0x0000,   /* U+4103 */
  0x0000,   /* U+4104 */
  0x0000,   /* U+4105 */
  0x0000,   /* U+4106 */
  0x0000,   /* U+4107 */
  0x0000,   /* U+4108 */
  0x0000,   /* U+4109 */
  0x0000,   /* U+410A */
  0x0000,   /* U+410B */
  0x0000,   /* U+410C */
  0x0000,   /* U+410D */
  0x0000,   /* U+410E */
  0x0000,   /* U+410F */
  0x0000,   /* U+4110 */
  0x0000,   /* U+4111 */
  0x0000,   /* U+4112 */
  0x0000,   /* U+4113 */
  0x0000,   /* U+4114 */
  0x0000,   /* U+4115 */
  0x0000,   /* U+4116 */
  0x0000,   /* U+4117 */
  0x0000,   /* U+4118 */
  0x0000,   /* U+4119 */
  0x0000,   /* U+411A */
  0x0000,   /* U+411B */
  0x0000,   /* U+411C */
  0x0000,   /* U+411D */
  0x0000,   /* U+411E */
  0x0000,   /* U+411F */
  0x0000,   /* U+4120 */
  0x0000,   /* U+4121 */
  0x0000,   /* U+4122 */
  0x0000,   /* U+4123 */
  0x0000,   /* U+4124 */
  0x0000,   /* U+4125 */
  0x0000,   /* U+4126 */
  0x0000,   /* U+4127 */
  0x0000,   /* U+4128 */
  0x0000,   /* U+4129 */
  0x0000,   /* U+412A */
  0x0000,   /* U+412B */
  0x0000,   /* U+412C */
  0x0000,   /* U+412D */
  0x0000,   /* U+412E */
  0x0000,   /* U+412F */
  0x0000,   /* U+4130 */
  0x0000,   /* U+4131 */
  0x0000,   /* U+4132 */
  0x0000,   /* U+4133 */
  0x0000,   /* U+4134 */
  0x0000,   /* U+4135 */
  0x0000,   /* U+4136 */
  0x0000,   /* U+4137 */
  0x0000,   /* U+4138 */
  0x0000,   /* U+4139 */
  0x0000,   /* U+413A */
  0x0000,   /* U+413B */
  0x0000,   /* U+413C */
  0x0000,   /* U+413D */
  0x0000,   /* U+413E */
  0x0000,   /* U+413F */
  0x0000,   /* U+4140 */
  0x0000,   /* U+4141 */
  0x0000,   /* U+4142 */
  0x0000,   /* U+4143 */
  0x0000,   /* U+4144 */
  0x0000,   /* U+4145 */
  0x0000,   /* U+4146 */
  0x0000,   /* U+4147 */
  0x0000,   /* U+4148 */
  0x0000,   /* U+4149 */
  0x0000,   /* U+414A */
  0x0000,   /* U+414B */
  0x0000,   /* U+414C */
  0x0000,   /* U+414D */
  0x0000,   /* U+414E */
  0x0000,   /* U+414F */
  0x0000,   /* U+4150 */
  0x0000,   /* U+4151 */
  0x0000,   /* U+4152 */
  0x0000,   /* U+4153 */
  0x0000,   /* U+4154 */
  0x0000,   /* U+4155 */
  0x0000,   /* U+4156 */
  0x0000,   /* U+4157 */
  0x0000,   /* U+4158 */
  0x0000,   /* U+4159 */
  0x0000,   /* U+415A */
  0x0000,   /* U+415B */
  0x0000,   /* U+415C */
  0x0000,   /* U+415D */
  0x0000,   /* U+415E */
  0x0000,   /* U+415F */
  0x0000,   /* U+4160 */
  0x0000,   /* U+4161 */
  0x0000,   /* U+4162 */
  0x0000,   /* U+4163 */
  0x0000,   /* U+4164 */
  0x0000,   /* U+4165 */
  0x0000,   /* U+4166 */
  0x0000,   /* U+4167 */
  0x0000,   /* U+4168 */
  0x0000,   /* U+4169 */
  0x0000,   /* U+416A */
  0x0000,   /* U+416B */
  0x0000,   /* U+416C */
  0x0000,   /* U+416D */
  0x0000,   /* U+416E */
  0x0000,   /* U+416F */
  0x0000,   /* U+4170 */
  0x0000,   /* U+4171 */
  0x0000,   /* U+4172 */
  0x0000,   /* U+4173 */
  0x0000,   /* U+4174 */
  0x0000,   /* U+4175 */
  0x0000,   /* U+4176 */
  0x0000,   /* U+4177 */
  0x0000,   /* U+4178 */
  0x0000,   /* U+4179 */
  0x0000,   /* U+417A */
  0x0000,   /* U+417B */
  0x0000,   /* U+417C */
  0x0000,   /* U+417D */
  0x0000,   /* U+417E */
  0x0000,   /* U+417F */
  0x0000,   /* U+4180 */
  0x0000,   /* U+4181 */
  0x0000,   /* U+4182 */
  0x0000,   /* U+4183 */
  0x0000,   /* U+4184 */
  0x0000,   /* U+4185 */
  0x0000,   /* U+4186 */
  0x0000,   /* U+4187 */
  0x0000,   /* U+4188 */
  0x0000,   /* U+4189 */
  0x0000,   /* U+418A */
  0x0000,   /* U+418B */
  0x0000,   /* U+418C */
  0x0000,   /* U+418D */
  0x0000,   /* U+418E */
  0x0000,   /* U+418F */
  0x0000,   /* U+4190 */
  0x0000,   /* U+4191 */
  0x0000,   /* U+4192 */
  0x0000,   /* U+4193 */
  0x0000,   /* U+4194 */
  0x0000,   /* U+4195 */
  0x0000,   /* U+4196 */
  0x0000,   /* U+4197 */
  0x0000,   /* U+4198 */
  0x0000,   /* U+4199 */
  0x0000,   /* U+419A */
  0x0000,   /* U+419B */
  0x0000,   /* U+419C */
  0x0000,   /* U+419D */
  0x0000,   /* U+419E */
  0x0000,   /* U+419F */
  0x0000,   /* U+41A0 */
  0x0000,   /* U+41A1 */
  0x0000,   /* U+41A2 */
  0x0000,   /* U+41A3 */
  0x0000,   /* U+41A4 */
  0x0000,   /* U+41A5 */
  0x0000,   /* U+41A6 */
  0x0000,   /* U+41A7 */
  0x0000,   /* U+41A8 */
  0x0000,   /* U+41A9 */
  0x0000,   /* U+41AA */
  0x0000,   /* U+41AB */
  0x0000,   /* U+41AC */
  0x0000,   /* U+41AD */
  0x0000,   /* U+41AE */
  0x0000,   /* U+41AF */
  0x0000,   /* U+41B0 */
  0x0000,   /* U+41B1 */
  0x0000,   /* U+41B2 */
  0x0000,   /* U+41B3 */
  0x0000,   /* U+41B4 */
  0x0000,   /* U+41B5 */
  0x0000,   /* U+41B6 */
  0x0000,   /* U+41B7 */
  0x0000,   /* U+41B8 */
  0x0000,   /* U+41B9 */
  0x0000,   /* U+41BA */
  0x0000,   /* U+41BB */
  0x0000,   /* U+41BC */
  0x0000,   /* U+41BD */
  0x0000,   /* U+41BE */
  0x0000,   /* U+41BF */
  0x0000,   /* U+41C0 */
  0x0000,   /* U+41C1 */
  0x0000,   /* U+41C2 */
  0x0000,   /* U+41C3 */
  0x0000,   /* U+41C4 */
  0x0000,   /* U+41C5 */
  0x0000,   /* U+41C6 */
  0x0000,   /* U+41C7 */
  0x0000,   /* U+41C8 */
  0x0000,   /* U+41C9 */
  0x0000,   /* U+41CA */
  0x0000,   /* U+41CB */
  0x0000,   /* U+41CC */
  0x0000,   /* U+41CD */
  0x0000,   /* U+41CE */
  0x0000,   /* U+41CF */
  0x0000,   /* U+41D0 */
  0x0000,   /* U+41D1 */
  0x0000,   /* U+41D2 */
  0x0000,   /* U+41D3 */
  0x0000,   /* U+41D4 */
  0x0000,   /* U+41D5 */
  0x0000,   /* U+41D6 */
  0x0000,   /* U+41D7 */
  0x0000,   /* U+41D8 */
  0x0000,   /* U+41D9 */
  0x0000,   /* U+41DA */
  0x0000,   /* U+41DB */
  0x0000,   /* U+41DC */
  0x0000,   /* U+41DD */
  0x0000,   /* U+41DE */
  0x0000,   /* U+41DF */
  0x0000,   /* U+41E0 */
  0x0000,   /* U+41E1 */
  0x0000,   /* U+41E2 */
  0x0000,   /* U+41E3 */
  0x0000,   /* U+41E4 */
  0x0000,   /* U+41E5 */
  0x0000,   /* U+41E6 */
  0x0000,   /* U+41E7 */
  0x0000,   /* U+41E8 */
  0x0000,   /* U+41E9 */
  0x0000,   /* U+41EA */
  0x0000,   /* U+41EB */
  0x0000,   /* U+41EC */
  0x0000,   /* U+41ED */
  0x0000,   /* U+41EE */
  0x0000,   /* U+41EF */
  0x0000,   /* U+41F0 */
  0x0000,   /* U+41F1 */
  0x0000,   /* U+41F2 */
  0x0000,   /* U+41F3 */
  0x0000,   /* U+41F4 */
  0x0000,   /* U+41F5 */
  0x0000,   /* U+41F6 */
  0x0000,   /* U+41F7 */
  0x0000,   /* U+41F8 */
  0x0000,   /* U+41F9 */
  0x0000,   /* U+41FA */
  0x0000,   /* U+41FB */
  0x0000,   /* U+41FC */
  0x0000,   /* U+41FD */
  0x0000,   /* U+41FE */
  0x0000,   /* U+41FF */
};

uint16 zh3_han_p042[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C54,   /* U+4200 */
  0x1C55,   /* U+4201 */
  0x1C55,   /* U+4202 */
  0x1C55,   /* U+4203 */
  0x1C55,   /* U+4204 */
  0x1C55,   /* U+4205 */
  0x1C55,   /* U+4206 */
  0x1C55,   /* U+4207 */
  0x1C55,   /* U+4208 */
  0x1C55,   /* U+4209 */
  0x1C55,   /* U+420A */
  0x1C55,   /* U+420B */
  0x1C55,   /* U+420C */
  0x1C55,   /* U+420D */
  0x1C56,   /* U+420E */
  0x1C56,   /* U+420F */
  0x1C56,   /* U+4210 */
  0x1C56,   /* U+4211 */
  0x1C56,   /* U+4212 */
  0x1C56,   /* U+4213 */
  0x1C56,   /* U+4214 */
  0x1C56,   /* U+4215 */
  0x1C56,   /* U+4216 */
  0x1C56,   /* U+4217 */
  0x1C56,   /* U+4218 */
  0x1C56,   /* U+4219 */
  0x1C56,   /* U+421A */
  0x1C56,   /* U+421B */
  0x1C56,   /* U+421C */
  0x1C56,   /* U+421D */
  0x1C56,   /* U+421E */
  0x1C56,   /* U+421F */
  0x1C56,   /* U+4220 */
  0x1C56,   /* U+4221 */
  0x1C56,   /* U+4222 */
  0x1C56,   /* U+4223 */
  0x1C56,   /* U+4224 */
  0x1C56,   /* U+4225 */
  0x1C56,   /* U+4226 */
  0x1C56,   /* U+4227 */
  0x1C56,   /* U+4228 */
  0x1C56,   /* U+4229 */
  0x1C57,   /* U+422A */
  0x1C57,   /* U+422B */
  0x1C57,   /* U+422C */
  0x1C57,   /* U+422D */
  0x1C57,   /* U+422E */
  0x1C57,   /* U+422F */
  0x1C57,   /* U+4230 */
  0x1C57,   /* U+4231 */
  0x1C57,   /* U+4232 */
  0x1C57,   /* U+4233 */
  0x1C57,   /* U+4234 */
  0x1C57,   /* U+4235 */
  0x1C57,   /* U+4236 */
  0x1C57,   /* U+4237 */
  0x1C58,   /* U+4238 */
  0x1C58,   /* U+4239 */
  0x1C58,   /* U+423A */
  0x1C58,   /* U+423B */
  0x1C58,   /* U+423C */
  0x1C58,   /* U+423D */
  0x1C58,   /* U+423E */
  0x1C58,   /* U+423F */
  0x1C58,   /* U+4240 */
  0x1C58,   /* U+4241 */
  0x1C58,   /* U+4242 */
  0x1C58,   /* U+4243 */
  0x1C58,   /* U+4244 */
  0x1C58,   /* U+4245 */
  0x1C58,   /* U+4246 */
  0x1C58,   /* U+4247 */
  0x1C59,   /* U+4248 */
  0x1C59,   /* U+4249 */
  0x1C59,   /* U+424A */
  0x1C59,   /* U+424B */
  0x1C59,   /* U+424C */
  0x1C59,   /* U+424D */
  0x1C59,   /* U+424E */
  0x1C5A,   /* U+424F */
  0x1C59,   /* U+4250 */
  0x1C59,   /* U+4251 */
  0x1C59,   /* U+4252 */
  0x1C59,   /* U+4253 */
  0x1C59,   /* U+4254 */
  0x1C59,   /* U+4255 */
  0x1C59,   /* U+4256 */
  0x1C59,   /* U+4257 */
  0x1C59,   /* U+4258 */
  0x1C59,   /* U+4259 */
  0x1C59,   /* U+425A */
  0x1C5A,   /* U+425B */
  0x1C5A,   /* U+425C */
  0x1C5A,   /* U+425D */
  0x1C5A,   /* U+425E */
  0x1C5A,   /* U+425F */
  0x1C5A,   /* U+4260 */
  0x1C5A,   /* U+4261 */
  0x1C5A,   /* U+4262 */
  0x1C59,   /* U+4263 */
  0x1C5A,   /* U+4264 */
  0x1C5B,   /* U+4265 */
  0x1C5C,   /* U+4266 */
  0x1C5C,   /* U+4267 */
  0x1C5C,   /* U+4268 */
  0x1C5C,   /* U+4269 */
  0x1C5C,   /* U+426A */
  0x1C5C,   /* U+426B */
  0x1C5C,   /* U+426C */
  0x1C5C,   /* U+426D */
  0x1C5D,   /* U+426E */
  0x1C5D,   /* U+426F */
  0x1C5D,   /* U+4270 */
  0x1C5D,   /* U+4271 */
  0x1C5E,   /* U+4272 */
  0x1C5E,   /* U+4273 */
  0x1C5E,   /* U+4274 */
  0x1C5E,   /* U+4275 */
  0x1C5F,   /* U+4276 */
  0x1C61,   /* U+4277 */
  0x1C62,   /* U+4278 */
  0x1C65,   /* U+4279 */
  0x1C50,   /* U+427A */
  0x1C51,   /* U+427B */
  0x1C51,   /* U+427C */
  0x1C52,   /* U+427D */
  0x1C52,   /* U+427E */
  0x1C52,   /* U+427F */
  0x1C52,   /* U+4280 */
  0x1C53,   /* U+4281 */
  0x1C53,   /* U+4282 */
  0x1C53,   /* U+4283 */
  0x1C53,   /* U+4284 */
  0x1C53,   /* U+4285 */
  0x1C53,   /* U+4286 */
  0x1C54,   /* U+4287 */
  0x1C54,   /* U+4288 */
  0x1C54,   /* U+4289 */
  0x1C54,   /* U+428A */
  0x1C54,   /* U+428B */
  0x1C54,   /* U+428C */
  0x1C55,   /* U+428D */
  0x1C55,   /* U+428E */
  0x1C55,   /* U+428F */
  0x1C55,   /* U+4290 */
  0x1C55,   /* U+4291 */
  0x1C55,   /* U+4292 */
  0x1C56,   /* U+4293 */
  0x1C56,   /* U+4294 */
  0x1C56,   /* U+4295 */
  0x1C56,   /* U+4296 */
  0x1C56,   /* U+4297 */
  0x1C56,   /* U+4298 */
  0x1C56,   /* U+4299 */
  0x1C57,   /* U+429A */
  0x1C57,   /* U+429B */
  0x1C58,   /* U+429C */
  0x1C58,   /* U+429D */
  0x1C58,   /* U+429E */
  0x1C58,   /* U+429F */
  0x1C58,   /* U+42A0 */
  0x1C58,   /* U+42A1 */
  0x1C58,   /* U+42A2 */
  0x1C59,   /* U+42A3 */
  0x1C59,   /* U+42A4 */
  0x1C59,   /* U+42A5 */
  0x1C59,   /* U+42A6 */
  0x1C59,   /* U+42A7 */
  0x1C59,   /* U+42A8 */
  0x1C59,   /* U+42A9 */
  0x1C5A,   /* U+42AA */
  0x1C5A,   /* U+42AB */
  0x1C5A,   /* U+42AC */
  0x1C5B,   /* U+42AD */
  0x1C5B,   /* U+42AE */
  0x1C5C,   /* U+42AF */
  0x1C5D,   /* U+42B0 */
  0x1C5E,   /* U+42B1 */
  0x1C5E,   /* U+42B2 */
  0x1C60,   /* U+42B3 */
  0x1C60,   /* U+42B4 */
  0x1C4F,   /* U+42B5 */
  0x1C50,   /* U+42B6 */
  0x1C50,   /* U+42B7 */
  0x1C50,   /* U+42B8 */
  0x1C50,   /* U+42B9 */
  0x1C51,   /* U+42BA */
  0x1C51,   /* U+42BB */
  0x1C51,   /* U+42BC */
  0x1C51,   /* U+42BD */
  0x1C51,   /* U+42BE */
  0x1C51,   /* U+42BF */
  0x1C51,   /* U+42C0 */
  0x1C51,   /* U+42C1 */
  0x1C51,   /* U+42C2 */
  0x1C51,   /* U+42C3 */
  0x1C51,   /* U+42C4 */
  0x1C51,   /* U+42C5 */
  0x1C51,   /* U+42C6 */
  0x1C51,   /* U+42C7 */
  0x1C52,   /* U+42C8 */
  0x1C52,   /* U+42C9 */
  0x1C52,   /* U+42CA */
  0x1C52,   /* U+42CB */
  0x1C52,   /* U+42CC */
  0x1C52,   /* U+42CD */
  0x1C52,   /* U+42CE */
  0x1C52,   /* U+42CF */
  0x1C52,   /* U+42D0 */
  0x1C52,   /* U+42D1 */
  0x1C52,   /* U+42D2 */
  0x1C52,   /* U+42D3 */
  0x1C52,   /* U+42D4 */
  0x1C53,   /* U+42D5 */
  0x1C53,   /* U+42D6 */
  0x1C53,   /* U+42D7 */
  0x1C53,   /* U+42D8 */
  0x1C53,   /* U+42D9 */
  0x1C53,   /* U+42DA */
  0x1C53,   /* U+42DB */
  0x1C53,   /* U+42DC */
  0x1C53,   /* U+42DD */
  0x1C53,   /* U+42DE */
  0x1C54,   /* U+42DF */
  0x1C54,   /* U+42E0 */
  0x1C54,   /* U+42E1 */
  0x1C54,   /* U+42E2 */
  0x1C54,   /* U+42E3 */
  0x1C54,   /* U+42E4 */
  0x1C54,   /* U+42E5 */
  0x1C54,   /* U+42E6 */
  0x1C55,   /* U+42E7 */
  0x1C55,   /* U+42E8 */
  0x1C55,   /* U+42E9 */
  0x1C55,   /* U+42EA */
  0x1C55,   /* U+42EB */
  0x1C55,   /* U+42EC */
  0x1C55,   /* U+42ED */
  0x1C55,   /* U+42EE */
  0x1C55,   /* U+42EF */
  0x1C55,   /* U+42F0 */
  0x1C55,   /* U+42F1 */
  0x1C55,   /* U+42F2 */
  0x1C56,   /* U+42F3 */
  0x1C56,   /* U+42F4 */
  0x1C56,   /* U+42F5 */
  0x1C56,   /* U+42F6 */
  0x1C56,   /* U+42F7 */
  0x1C56,   /* U+42F8 */
  0x1C56,   /* U+42F9 */
  0x1C56,   /* U+42FA */
  0x1C56,   /* U+42FB */
  0x1C56,   /* U+42FC */
  0x1C56,   /* U+42FD */
  0x1C56,   /* U+42FE */
  0x1C56,   /* U+42FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4200 */
  0x0020,   /* U+4201 */
  0x0020,   /* U+4202 */
  0x0020,   /* U+4203 */
  0x0020,   /* U+4204 */
  0x0020,   /* U+4205 */
  0x0020,   /* U+4206 */
  0x0020,   /* U+4207 */
  0x0020,   /* U+4208 */
  0x0020,   /* U+4209 */
  0x0020,   /* U+420A */
  0x0020,   /* U+420B */
  0x0020,   /* U+420C */
  0x0020,   /* U+420D */
  0x0020,   /* U+420E */
  0x0020,   /* U+420F */
  0x0020,   /* U+4210 */
  0x0020,   /* U+4211 */
  0x0020,   /* U+4212 */
  0x0020,   /* U+4213 */
  0x0020,   /* U+4214 */
  0x0020,   /* U+4215 */
  0x0020,   /* U+4216 */
  0x0020,   /* U+4217 */
  0x0020,   /* U+4218 */
  0x0020,   /* U+4219 */
  0x0020,   /* U+421A */
  0x0020,   /* U+421B */
  0x0020,   /* U+421C */
  0x0020,   /* U+421D */
  0x0020,   /* U+421E */
  0x0020,   /* U+421F */
  0x0020,   /* U+4220 */
  0x0020,   /* U+4221 */
  0x0020,   /* U+4222 */
  0x0020,   /* U+4223 */
  0x0020,   /* U+4224 */
  0x0020,   /* U+4225 */
  0x0020,   /* U+4226 */
  0x0020,   /* U+4227 */
  0x0020,   /* U+4228 */
  0x0020,   /* U+4229 */
  0x0020,   /* U+422A */
  0x0020,   /* U+422B */
  0x0020,   /* U+422C */
  0x0020,   /* U+422D */
  0x0020,   /* U+422E */
  0x0020,   /* U+422F */
  0x0020,   /* U+4230 */
  0x0020,   /* U+4231 */
  0x0020,   /* U+4232 */
  0x0020,   /* U+4233 */
  0x0020,   /* U+4234 */
  0x0020,   /* U+4235 */
  0x0020,   /* U+4236 */
  0x0020,   /* U+4237 */
  0x0020,   /* U+4238 */
  0x0020,   /* U+4239 */
  0x0020,   /* U+423A */
  0x0020,   /* U+423B */
  0x0020,   /* U+423C */
  0x0020,   /* U+423D */
  0x0020,   /* U+423E */
  0x0020,   /* U+423F */
  0x0020,   /* U+4240 */
  0x0020,   /* U+4241 */
  0x0020,   /* U+4242 */
  0x0020,   /* U+4243 */
  0x0020,   /* U+4244 */
  0x0020,   /* U+4245 */
  0x0020,   /* U+4246 */
  0x0020,   /* U+4247 */
  0x0020,   /* U+4248 */
  0x0020,   /* U+4249 */
  0x0020,   /* U+424A */
  0x0020,   /* U+424B */
  0x0020,   /* U+424C */
  0x0020,   /* U+424D */
  0x0020,   /* U+424E */
  0x0020,   /* U+424F */
  0x0020,   /* U+4250 */
  0x0020,   /* U+4251 */
  0x0020,   /* U+4252 */
  0x0020,   /* U+4253 */
  0x0020,   /* U+4254 */
  0x0020,   /* U+4255 */
  0x0020,   /* U+4256 */
  0x0020,   /* U+4257 */
  0x0020,   /* U+4258 */
  0x0020,   /* U+4259 */
  0x0020,   /* U+425A */
  0x0020,   /* U+425B */
  0x0020,   /* U+425C */
  0x0020,   /* U+425D */
  0x0020,   /* U+425E */
  0x0020,   /* U+425F */
  0x0020,   /* U+4260 */
  0x0020,   /* U+4261 */
  0x0020,   /* U+4262 */
  0x0020,   /* U+4263 */
  0x0020,   /* U+4264 */
  0x0020,   /* U+4265 */
  0x0020,   /* U+4266 */
  0x0020,   /* U+4267 */
  0x0020,   /* U+4268 */
  0x0020,   /* U+4269 */
  0x0020,   /* U+426A */
  0x0020,   /* U+426B */
  0x0020,   /* U+426C */
  0x0020,   /* U+426D */
  0x0020,   /* U+426E */
  0x0020,   /* U+426F */
  0x0020,   /* U+4270 */
  0x0020,   /* U+4271 */
  0x0020,   /* U+4272 */
  0x0020,   /* U+4273 */
  0x0020,   /* U+4274 */
  0x0020,   /* U+4275 */
  0x0020,   /* U+4276 */
  0x0020,   /* U+4277 */
  0x0020,   /* U+4278 */
  0x0020,   /* U+4279 */
  0x0020,   /* U+427A */
  0x0020,   /* U+427B */
  0x0020,   /* U+427C */
  0x0020,   /* U+427D */
  0x0020,   /* U+427E */
  0x0020,   /* U+427F */
  0x0020,   /* U+4280 */
  0x0020,   /* U+4281 */
  0x0020,   /* U+4282 */
  0x0020,   /* U+4283 */
  0x0020,   /* U+4284 */
  0x0020,   /* U+4285 */
  0x0020,   /* U+4286 */
  0x0020,   /* U+4287 */
  0x0020,   /* U+4288 */
  0x0020,   /* U+4289 */
  0x0020,   /* U+428A */
  0x0020,   /* U+428B */
  0x0020,   /* U+428C */
  0x0020,   /* U+428D */
  0x0020,   /* U+428E */
  0x0020,   /* U+428F */
  0x0020,   /* U+4290 */
  0x0020,   /* U+4291 */
  0x0020,   /* U+4292 */
  0x0020,   /* U+4293 */
  0x0020,   /* U+4294 */
  0x0020,   /* U+4295 */
  0x0020,   /* U+4296 */
  0x0020,   /* U+4297 */
  0x0020,   /* U+4298 */
  0x0020,   /* U+4299 */
  0x0020,   /* U+429A */
  0x0020,   /* U+429B */
  0x0020,   /* U+429C */
  0x0020,   /* U+429D */
  0x0020,   /* U+429E */
  0x0020,   /* U+429F */
  0x0020,   /* U+42A0 */
  0x0020,   /* U+42A1 */
  0x0020,   /* U+42A2 */
  0x0020,   /* U+42A3 */
  0x0020,   /* U+42A4 */
  0x0020,   /* U+42A5 */
  0x0020,   /* U+42A6 */
  0x0020,   /* U+42A7 */
  0x0020,   /* U+42A8 */
  0x0020,   /* U+42A9 */
  0x0020,   /* U+42AA */
  0x0020,   /* U+42AB */
  0x0020,   /* U+42AC */
  0x0020,   /* U+42AD */
  0x0020,   /* U+42AE */
  0x0020,   /* U+42AF */
  0x0020,   /* U+42B0 */
  0x0020,   /* U+42B1 */
  0x0020,   /* U+42B2 */
  0x0020,   /* U+42B3 */
  0x0020,   /* U+42B4 */
  0x0020,   /* U+42B5 */
  0x0020,   /* U+42B6 */
  0x0020,   /* U+42B7 */
  0x0020,   /* U+42B8 */
  0x0020,   /* U+42B9 */
  0x0020,   /* U+42BA */
  0x0020,   /* U+42BB */
  0x0020,   /* U+42BC */
  0x0020,   /* U+42BD */
  0x0020,   /* U+42BE */
  0x0020,   /* U+42BF */
  0x0020,   /* U+42C0 */
  0x0020,   /* U+42C1 */
  0x0020,   /* U+42C2 */
  0x0020,   /* U+42C3 */
  0x0020,   /* U+42C4 */
  0x0020,   /* U+42C5 */
  0x0020,   /* U+42C6 */
  0x0020,   /* U+42C7 */
  0x0020,   /* U+42C8 */
  0x0020,   /* U+42C9 */
  0x0020,   /* U+42CA */
  0x0020,   /* U+42CB */
  0x0020,   /* U+42CC */
  0x0020,   /* U+42CD */
  0x0020,   /* U+42CE */
  0x0020,   /* U+42CF */
  0x0020,   /* U+42D0 */
  0x0020,   /* U+42D1 */
  0x0020,   /* U+42D2 */
  0x0020,   /* U+42D3 */
  0x0020,   /* U+42D4 */
  0x0020,   /* U+42D5 */
  0x0020,   /* U+42D6 */
  0x0020,   /* U+42D7 */
  0x0020,   /* U+42D8 */
  0x0020,   /* U+42D9 */
  0x0020,   /* U+42DA */
  0x0020,   /* U+42DB */
  0x0020,   /* U+42DC */
  0x0020,   /* U+42DD */
  0x0020,   /* U+42DE */
  0x0020,   /* U+42DF */
  0x0020,   /* U+42E0 */
  0x0020,   /* U+42E1 */
  0x0020,   /* U+42E2 */
  0x0020,   /* U+42E3 */
  0x0020,   /* U+42E4 */
  0x0020,   /* U+42E5 */
  0x0020,   /* U+42E6 */
  0x0020,   /* U+42E7 */
  0x0020,   /* U+42E8 */
  0x0020,   /* U+42E9 */
  0x0020,   /* U+42EA */
  0x0020,   /* U+42EB */
  0x0020,   /* U+42EC */
  0x0020,   /* U+42ED */
  0x0020,   /* U+42EE */
  0x0020,   /* U+42EF */
  0x0020,   /* U+42F0 */
  0x0020,   /* U+42F1 */
  0x0020,   /* U+42F2 */
  0x0020,   /* U+42F3 */
  0x0020,   /* U+42F4 */
  0x0020,   /* U+42F5 */
  0x0020,   /* U+42F6 */
  0x0020,   /* U+42F7 */
  0x0020,   /* U+42F8 */
  0x0020,   /* U+42F9 */
  0x0020,   /* U+42FA */
  0x0020,   /* U+42FB */
  0x0020,   /* U+42FC */
  0x0020,   /* U+42FD */
  0x0020,   /* U+42FE */
  0x0020,   /* U+42FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4200 */
  0x0002,   /* U+4201 */
  0x0002,   /* U+4202 */
  0x0002,   /* U+4203 */
  0x0002,   /* U+4204 */
  0x0002,   /* U+4205 */
  0x0002,   /* U+4206 */
  0x0002,   /* U+4207 */
  0x0002,   /* U+4208 */
  0x0002,   /* U+4209 */
  0x0002,   /* U+420A */
  0x0002,   /* U+420B */
  0x0002,   /* U+420C */
  0x0002,   /* U+420D */
  0x0002,   /* U+420E */
  0x0002,   /* U+420F */
  0x0002,   /* U+4210 */
  0x0002,   /* U+4211 */
  0x0002,   /* U+4212 */
  0x0002,   /* U+4213 */
  0x0002,   /* U+4214 */
  0x0002,   /* U+4215 */
  0x0002,   /* U+4216 */
  0x0002,   /* U+4217 */
  0x0002,   /* U+4218 */
  0x0002,   /* U+4219 */
  0x0002,   /* U+421A */
  0x0002,   /* U+421B */
  0x0002,   /* U+421C */
  0x0002,   /* U+421D */
  0x0002,   /* U+421E */
  0x0002,   /* U+421F */
  0x0002,   /* U+4220 */
  0x0002,   /* U+4221 */
  0x0002,   /* U+4222 */
  0x0002,   /* U+4223 */
  0x0002,   /* U+4224 */
  0x0002,   /* U+4225 */
  0x0002,   /* U+4226 */
  0x0002,   /* U+4227 */
  0x0002,   /* U+4228 */
  0x0002,   /* U+4229 */
  0x0002,   /* U+422A */
  0x0002,   /* U+422B */
  0x0002,   /* U+422C */
  0x0002,   /* U+422D */
  0x0002,   /* U+422E */
  0x0002,   /* U+422F */
  0x0002,   /* U+4230 */
  0x0002,   /* U+4231 */
  0x0002,   /* U+4232 */
  0x0002,   /* U+4233 */
  0x0002,   /* U+4234 */
  0x0002,   /* U+4235 */
  0x0002,   /* U+4236 */
  0x0002,   /* U+4237 */
  0x0002,   /* U+4238 */
  0x0002,   /* U+4239 */
  0x0002,   /* U+423A */
  0x0002,   /* U+423B */
  0x0002,   /* U+423C */
  0x0002,   /* U+423D */
  0x0002,   /* U+423E */
  0x0002,   /* U+423F */
  0x0002,   /* U+4240 */
  0x0002,   /* U+4241 */
  0x0002,   /* U+4242 */
  0x0002,   /* U+4243 */
  0x0002,   /* U+4244 */
  0x0002,   /* U+4245 */
  0x0002,   /* U+4246 */
  0x0002,   /* U+4247 */
  0x0002,   /* U+4248 */
  0x0002,   /* U+4249 */
  0x0002,   /* U+424A */
  0x0002,   /* U+424B */
  0x0002,   /* U+424C */
  0x0002,   /* U+424D */
  0x0002,   /* U+424E */
  0x0002,   /* U+424F */
  0x0002,   /* U+4250 */
  0x0002,   /* U+4251 */
  0x0002,   /* U+4252 */
  0x0002,   /* U+4253 */
  0x0002,   /* U+4254 */
  0x0002,   /* U+4255 */
  0x0002,   /* U+4256 */
  0x0002,   /* U+4257 */
  0x0002,   /* U+4258 */
  0x0002,   /* U+4259 */
  0x0002,   /* U+425A */
  0x0002,   /* U+425B */
  0x0002,   /* U+425C */
  0x0002,   /* U+425D */
  0x0002,   /* U+425E */
  0x0002,   /* U+425F */
  0x0002,   /* U+4260 */
  0x0002,   /* U+4261 */
  0x0002,   /* U+4262 */
  0x0002,   /* U+4263 */
  0x0002,   /* U+4264 */
  0x0002,   /* U+4265 */
  0x0002,   /* U+4266 */
  0x0002,   /* U+4267 */
  0x0002,   /* U+4268 */
  0x0002,   /* U+4269 */
  0x0002,   /* U+426A */
  0x0002,   /* U+426B */
  0x0002,   /* U+426C */
  0x0002,   /* U+426D */
  0x0002,   /* U+426E */
  0x0002,   /* U+426F */
  0x0002,   /* U+4270 */
  0x0002,   /* U+4271 */
  0x0002,   /* U+4272 */
  0x0002,   /* U+4273 */
  0x0002,   /* U+4274 */
  0x0002,   /* U+4275 */
  0x0002,   /* U+4276 */
  0x0002,   /* U+4277 */
  0x0002,   /* U+4278 */
  0x0002,   /* U+4279 */
  0x0002,   /* U+427A */
  0x0002,   /* U+427B */
  0x0002,   /* U+427C */
  0x0002,   /* U+427D */
  0x0002,   /* U+427E */
  0x0002,   /* U+427F */
  0x0002,   /* U+4280 */
  0x0002,   /* U+4281 */
  0x0002,   /* U+4282 */
  0x0002,   /* U+4283 */
  0x0002,   /* U+4284 */
  0x0002,   /* U+4285 */
  0x0002,   /* U+4286 */
  0x0002,   /* U+4287 */
  0x0002,   /* U+4288 */
  0x0002,   /* U+4289 */
  0x0002,   /* U+428A */
  0x0002,   /* U+428B */
  0x0002,   /* U+428C */
  0x0002,   /* U+428D */
  0x0002,   /* U+428E */
  0x0002,   /* U+428F */
  0x0002,   /* U+4290 */
  0x0002,   /* U+4291 */
  0x0002,   /* U+4292 */
  0x0002,   /* U+4293 */
  0x0002,   /* U+4294 */
  0x0002,   /* U+4295 */
  0x0002,   /* U+4296 */
  0x0002,   /* U+4297 */
  0x0002,   /* U+4298 */
  0x0002,   /* U+4299 */
  0x0002,   /* U+429A */
  0x0002,   /* U+429B */
  0x0002,   /* U+429C */
  0x0002,   /* U+429D */
  0x0002,   /* U+429E */
  0x0002,   /* U+429F */
  0x0002,   /* U+42A0 */
  0x0002,   /* U+42A1 */
  0x0002,   /* U+42A2 */
  0x0002,   /* U+42A3 */
  0x0002,   /* U+42A4 */
  0x0002,   /* U+42A5 */
  0x0002,   /* U+42A6 */
  0x0002,   /* U+42A7 */
  0x0002,   /* U+42A8 */
  0x0002,   /* U+42A9 */
  0x0002,   /* U+42AA */
  0x0002,   /* U+42AB */
  0x0002,   /* U+42AC */
  0x0002,   /* U+42AD */
  0x0002,   /* U+42AE */
  0x0002,   /* U+42AF */
  0x0002,   /* U+42B0 */
  0x0002,   /* U+42B1 */
  0x0002,   /* U+42B2 */
  0x0002,   /* U+42B3 */
  0x0002,   /* U+42B4 */
  0x0002,   /* U+42B5 */
  0x0002,   /* U+42B6 */
  0x0002,   /* U+42B7 */
  0x0002,   /* U+42B8 */
  0x0002,   /* U+42B9 */
  0x0002,   /* U+42BA */
  0x0002,   /* U+42BB */
  0x0002,   /* U+42BC */
  0x0002,   /* U+42BD */
  0x0002,   /* U+42BE */
  0x0002,   /* U+42BF */
  0x0002,   /* U+42C0 */
  0x0002,   /* U+42C1 */
  0x0002,   /* U+42C2 */
  0x0002,   /* U+42C3 */
  0x0002,   /* U+42C4 */
  0x0002,   /* U+42C5 */
  0x0002,   /* U+42C6 */
  0x0002,   /* U+42C7 */
  0x0002,   /* U+42C8 */
  0x0002,   /* U+42C9 */
  0x0002,   /* U+42CA */
  0x0002,   /* U+42CB */
  0x0002,   /* U+42CC */
  0x0002,   /* U+42CD */
  0x0002,   /* U+42CE */
  0x0002,   /* U+42CF */
  0x0002,   /* U+42D0 */
  0x0002,   /* U+42D1 */
  0x0002,   /* U+42D2 */
  0x0002,   /* U+42D3 */
  0x0002,   /* U+42D4 */
  0x0002,   /* U+42D5 */
  0x0002,   /* U+42D6 */
  0x0002,   /* U+42D7 */
  0x0002,   /* U+42D8 */
  0x0002,   /* U+42D9 */
  0x0002,   /* U+42DA */
  0x0002,   /* U+42DB */
  0x0002,   /* U+42DC */
  0x0002,   /* U+42DD */
  0x0002,   /* U+42DE */
  0x0002,   /* U+42DF */
  0x0002,   /* U+42E0 */
  0x0002,   /* U+42E1 */
  0x0002,   /* U+42E2 */
  0x0002,   /* U+42E3 */
  0x0002,   /* U+42E4 */
  0x0002,   /* U+42E5 */
  0x0002,   /* U+42E6 */
  0x0002,   /* U+42E7 */
  0x0002,   /* U+42E8 */
  0x0002,   /* U+42E9 */
  0x0002,   /* U+42EA */
  0x0002,   /* U+42EB */
  0x0002,   /* U+42EC */
  0x0002,   /* U+42ED */
  0x0002,   /* U+42EE */
  0x0002,   /* U+42EF */
  0x0002,   /* U+42F0 */
  0x0002,   /* U+42F1 */
  0x0002,   /* U+42F2 */
  0x0002,   /* U+42F3 */
  0x0002,   /* U+42F4 */
  0x0002,   /* U+42F5 */
  0x0002,   /* U+42F6 */
  0x0002,   /* U+42F7 */
  0x0002,   /* U+42F8 */
  0x0002,   /* U+42F9 */
  0x0002,   /* U+42FA */
  0x0002,   /* U+42FB */
  0x0002,   /* U+42FC */
  0x0002,   /* U+42FD */
  0x0002,   /* U+42FE */
  0x0002,   /* U+42FF */

  /* Primary weight 2 for each character. */
  0x9200,   /* U+4200 */
  0x9072,   /* U+4201 */
  0x9073,   /* U+4202 */
  0x9074,   /* U+4203 */
  0x9075,   /* U+4204 */
  0x9076,   /* U+4205 */
  0x9077,   /* U+4206 */
  0x9078,   /* U+4207 */
  0x9079,   /* U+4208 */
  0x907A,   /* U+4209 */
  0x907B,   /* U+420A */
  0x907C,   /* U+420B */
  0x907D,   /* U+420C */
  0x907E,   /* U+420D */
  0x8EC5,   /* U+420E */
  0x8EC6,   /* U+420F */
  0x8EC7,   /* U+4210 */
  0x8EC8,   /* U+4211 */
  0x8EC9,   /* U+4212 */
  0x8ECA,   /* U+4213 */
  0x8ECB,   /* U+4214 */
  0x8ECC,   /* U+4215 */
  0x8ECD,   /* U+4216 */
  0x8ECE,   /* U+4217 */
  0x8ECF,   /* U+4218 */
  0x8ED0,   /* U+4219 */
  0x8ED1,   /* U+421A */
  0x8ED2,   /* U+421B */
  0x8ED3,   /* U+421C */
  0x8ED4,   /* U+421D */
  0x8ED5,   /* U+421E */
  0x8ED6,   /* U+421F */
  0x8ED7,   /* U+4220 */
  0x8ED8,   /* U+4221 */
  0x8ED9,   /* U+4222 */
  0x8EDA,   /* U+4223 */
  0x8EDB,   /* U+4224 */
  0x8EDC,   /* U+4225 */
  0x8EDD,   /* U+4226 */
  0x8EDE,   /* U+4227 */
  0x8EDF,   /* U+4228 */
  0x8EE0,   /* U+4229 */
  0x8C56,   /* U+422A */
  0x8C57,   /* U+422B */
  0x8C58,   /* U+422C */
  0x8C59,   /* U+422D */
  0x8C5A,   /* U+422E */
  0x8C5B,   /* U+422F */
  0x8C5C,   /* U+4230 */
  0x8C5D,   /* U+4231 */
  0x8C5E,   /* U+4232 */
  0x8C5F,   /* U+4233 */
  0x8C60,   /* U+4234 */
  0x8C61,   /* U+4235 */
  0x8C62,   /* U+4236 */
  0x8C63,   /* U+4237 */
  0x88DF,   /* U+4238 */
  0x88E0,   /* U+4239 */
  0x88E1,   /* U+423A */
  0x88E2,   /* U+423B */
  0x88E3,   /* U+423C */
  0x88E4,   /* U+423D */
  0x88E5,   /* U+423E */
  0x88E6,   /* U+423F */
  0x88E7,   /* U+4240 */
  0x88E8,   /* U+4241 */
  0x88E9,   /* U+4242 */
  0x88EA,   /* U+4243 */
  0x88EB,   /* U+4244 */
  0x88EC,   /* U+4245 */
  0x88ED,   /* U+4246 */
  0x88EE,   /* U+4247 */
  0x8722,   /* U+4248 */
  0x8723,   /* U+4249 */
  0x8724,   /* U+424A */
  0x8725,   /* U+424B */
  0x8726,   /* U+424C */
  0x8727,   /* U+424D */
  0x8728,   /* U+424E */
  0x8543,   /* U+424F */
  0x8729,   /* U+4250 */
  0x872A,   /* U+4251 */
  0x872B,   /* U+4252 */
  0x872C,   /* U+4253 */
  0x872D,   /* U+4254 */
  0x872E,   /* U+4255 */
  0x872F,   /* U+4256 */
  0x8730,   /* U+4257 */
  0x8731,   /* U+4258 */
  0x8732,   /* U+4259 */
  0x8733,   /* U+425A */
  0x8544,   /* U+425B */
  0x8545,   /* U+425C */
  0x8546,   /* U+425D */
  0x8547,   /* U+425E */
  0x8548,   /* U+425F */
  0x8549,   /* U+4260 */
  0x854A,   /* U+4261 */
  0x854B,   /* U+4262 */
  0x8734,   /* U+4263 */
  0x854C,   /* U+4264 */
  0x83EE,   /* U+4265 */
  0x82F3,   /* U+4266 */
  0x82F4,   /* U+4267 */
  0x82F5,   /* U+4268 */
  0x82F6,   /* U+4269 */
  0x82F7,   /* U+426A */
  0x82F8,   /* U+426B */
  0x82F9,   /* U+426C */
  0x82FA,   /* U+426D */
  0x8224,   /* U+426E */
  0x8225,   /* U+426F */
  0x8226,   /* U+4270 */
  0x8227,   /* U+4271 */
  0x818F,   /* U+4272 */
  0x8190,   /* U+4273 */
  0x8191,   /* U+4274 */
  0x83A1,   /* U+4275 */
  0x8123,   /* U+4276 */
  0x8077,   /* U+4277 */
  0x8051,   /* U+4278 */
  0x8017,   /* U+4279 */
  0x900A,   /* U+427A */
  0x9209,   /* U+427B */
  0x920A,   /* U+427C */
  0x92D5,   /* U+427D */
  0x92D6,   /* U+427E */
  0x92D7,   /* U+427F */
  0x92D8,   /* U+4280 */
  0x9430,   /* U+4281 */
  0x9431,   /* U+4282 */
  0x9432,   /* U+4283 */
  0x9433,   /* U+4284 */
  0x9434,   /* U+4285 */
  0x9435,   /* U+4286 */
  0x9262,   /* U+4287 */
  0x9263,   /* U+4288 */
  0x9264,   /* U+4289 */
  0x9265,   /* U+428A */
  0x9266,   /* U+428B */
  0x9267,   /* U+428C */
  0x90F4,   /* U+428D */
  0x90F5,   /* U+428E */
  0x90F6,   /* U+428F */
  0x90F7,   /* U+4290 */
  0x90F8,   /* U+4291 */
  0x90F9,   /* U+4292 */
  0x8F5E,   /* U+4293 */
  0x8F5F,   /* U+4294 */
  0x8F60,   /* U+4295 */
  0x8F61,   /* U+4296 */
  0x8F62,   /* U+4297 */
  0x8F63,   /* U+4298 */
  0x8F64,   /* U+4299 */
  0x8CEB,   /* U+429A */
  0x8CEC,   /* U+429B */
  0x896D,   /* U+429C */
  0x896E,   /* U+429D */
  0x896F,   /* U+429E */
  0x8970,   /* U+429F */
  0x8971,   /* U+42A0 */
  0x8972,   /* U+42A1 */
  0x8973,   /* U+42A2 */
  0x87AE,   /* U+42A3 */
  0x87AF,   /* U+42A4 */
  0x87B0,   /* U+42A5 */
  0x87B1,   /* U+42A6 */
  0x87B2,   /* U+42A7 */
  0x87B3,   /* U+42A8 */
  0x87B4,   /* U+42A9 */
  0x85A5,   /* U+42AA */
  0x85A6,   /* U+42AB */
  0x85A7,   /* U+42AC */
  0x8426,   /* U+42AD */
  0x8427,   /* U+42AE */
  0x8345,   /* U+42AF */
  0x8257,   /* U+42B0 */
  0x81AA,   /* U+42B1 */
  0x81AB,   /* U+42B2 */
  0x80C4,   /* U+42B3 */
  0x80C5,   /* U+42B4 */
  0x8D41,   /* U+42B5 */
  0x9025,   /* U+42B6 */
  0x9026,   /* U+42B7 */
  0x9027,   /* U+42B8 */
  0x9028,   /* U+42B9 */
  0x9248,   /* U+42BA */
  0x9249,   /* U+42BB */
  0x924A,   /* U+42BC */
  0x924B,   /* U+42BD */
  0x924C,   /* U+42BE */
  0x924D,   /* U+42BF */
  0x924E,   /* U+42C0 */
  0x924F,   /* U+42C1 */
  0x9250,   /* U+42C2 */
  0x9251,   /* U+42C3 */
  0x9252,   /* U+42C4 */
  0x9253,   /* U+42C5 */
  0x9254,   /* U+42C6 */
  0x9255,   /* U+42C7 */
  0x932E,   /* U+42C8 */
  0x932F,   /* U+42C9 */
  0x9330,   /* U+42CA */
  0x9331,   /* U+42CB */
  0x9332,   /* U+42CC */
  0x9333,   /* U+42CD */
  0x9334,   /* U+42CE */
  0x9335,   /* U+42CF */
  0x9336,   /* U+42D0 */
  0x9337,   /* U+42D1 */
  0x9338,   /* U+42D2 */
  0x9339,   /* U+42D3 */
  0x933A,   /* U+42D4 */
  0x9493,   /* U+42D5 */
  0x9494,   /* U+42D6 */
  0x9495,   /* U+42D7 */
  0x9496,   /* U+42D8 */
  0x9497,   /* U+42D9 */
  0x9498,   /* U+42DA */
  0x9499,   /* U+42DB */
  0x949A,   /* U+42DC */
  0x949B,   /* U+42DD */
  0x949C,   /* U+42DE */
  0x92BF,   /* U+42DF */
  0x92C0,   /* U+42E0 */
  0x92C1,   /* U+42E1 */
  0x92C2,   /* U+42E2 */
  0x92C3,   /* U+42E3 */
  0x92C4,   /* U+42E4 */
  0x92C5,   /* U+42E5 */
  0x92C6,   /* U+42E6 */
  0x9172,   /* U+42E7 */
  0x9173,   /* U+42E8 */
  0x9174,   /* U+42E9 */
  0x9175,   /* U+42EA */
  0x9176,   /* U+42EB */
  0x9177,   /* U+42EC */
  0x9178,   /* U+42ED */
  0x9179,   /* U+42EE */
  0x917A,   /* U+42EF */
  0x917B,   /* U+42F0 */
  0x917C,   /* U+42F1 */
  0x917D,   /* U+42F2 */
  0x8FCE,   /* U+42F3 */
  0x8FCF,   /* U+42F4 */
  0x8FD0,   /* U+42F5 */
  0x8FD1,   /* U+42F6 */
  0x8FD2,   /* U+42F7 */
  0x8FD3,   /* U+42F8 */
  0x8FD4,   /* U+42F9 */
  0x8FD5,   /* U+42FA */
  0x8FD6,   /* U+42FB */
  0x8FD7,   /* U+42FC */
  0x8FD8,   /* U+42FD */
  0x8FD9,   /* U+42FE */
  0x8FDA,   /* U+42FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4200 */
  0x0000,   /* U+4201 */
  0x0000,   /* U+4202 */
  0x0000,   /* U+4203 */
  0x0000,   /* U+4204 */
  0x0000,   /* U+4205 */
  0x0000,   /* U+4206 */
  0x0000,   /* U+4207 */
  0x0000,   /* U+4208 */
  0x0000,   /* U+4209 */
  0x0000,   /* U+420A */
  0x0000,   /* U+420B */
  0x0000,   /* U+420C */
  0x0000,   /* U+420D */
  0x0000,   /* U+420E */
  0x0000,   /* U+420F */
  0x0000,   /* U+4210 */
  0x0000,   /* U+4211 */
  0x0000,   /* U+4212 */
  0x0000,   /* U+4213 */
  0x0000,   /* U+4214 */
  0x0000,   /* U+4215 */
  0x0000,   /* U+4216 */
  0x0000,   /* U+4217 */
  0x0000,   /* U+4218 */
  0x0000,   /* U+4219 */
  0x0000,   /* U+421A */
  0x0000,   /* U+421B */
  0x0000,   /* U+421C */
  0x0000,   /* U+421D */
  0x0000,   /* U+421E */
  0x0000,   /* U+421F */
  0x0000,   /* U+4220 */
  0x0000,   /* U+4221 */
  0x0000,   /* U+4222 */
  0x0000,   /* U+4223 */
  0x0000,   /* U+4224 */
  0x0000,   /* U+4225 */
  0x0000,   /* U+4226 */
  0x0000,   /* U+4227 */
  0x0000,   /* U+4228 */
  0x0000,   /* U+4229 */
  0x0000,   /* U+422A */
  0x0000,   /* U+422B */
  0x0000,   /* U+422C */
  0x0000,   /* U+422D */
  0x0000,   /* U+422E */
  0x0000,   /* U+422F */
  0x0000,   /* U+4230 */
  0x0000,   /* U+4231 */
  0x0000,   /* U+4232 */
  0x0000,   /* U+4233 */
  0x0000,   /* U+4234 */
  0x0000,   /* U+4235 */
  0x0000,   /* U+4236 */
  0x0000,   /* U+4237 */
  0x0000,   /* U+4238 */
  0x0000,   /* U+4239 */
  0x0000,   /* U+423A */
  0x0000,   /* U+423B */
  0x0000,   /* U+423C */
  0x0000,   /* U+423D */
  0x0000,   /* U+423E */
  0x0000,   /* U+423F */
  0x0000,   /* U+4240 */
  0x0000,   /* U+4241 */
  0x0000,   /* U+4242 */
  0x0000,   /* U+4243 */
  0x0000,   /* U+4244 */
  0x0000,   /* U+4245 */
  0x0000,   /* U+4246 */
  0x0000,   /* U+4247 */
  0x0000,   /* U+4248 */
  0x0000,   /* U+4249 */
  0x0000,   /* U+424A */
  0x0000,   /* U+424B */
  0x0000,   /* U+424C */
  0x0000,   /* U+424D */
  0x0000,   /* U+424E */
  0x0000,   /* U+424F */
  0x0000,   /* U+4250 */
  0x0000,   /* U+4251 */
  0x0000,   /* U+4252 */
  0x0000,   /* U+4253 */
  0x0000,   /* U+4254 */
  0x0000,   /* U+4255 */
  0x0000,   /* U+4256 */
  0x0000,   /* U+4257 */
  0x0000,   /* U+4258 */
  0x0000,   /* U+4259 */
  0x0000,   /* U+425A */
  0x0000,   /* U+425B */
  0x0000,   /* U+425C */
  0x0000,   /* U+425D */
  0x0000,   /* U+425E */
  0x0000,   /* U+425F */
  0x0000,   /* U+4260 */
  0x0000,   /* U+4261 */
  0x0000,   /* U+4262 */
  0x0000,   /* U+4263 */
  0x0000,   /* U+4264 */
  0x0000,   /* U+4265 */
  0x0000,   /* U+4266 */
  0x0000,   /* U+4267 */
  0x0000,   /* U+4268 */
  0x0000,   /* U+4269 */
  0x0000,   /* U+426A */
  0x0000,   /* U+426B */
  0x0000,   /* U+426C */
  0x0000,   /* U+426D */
  0x0000,   /* U+426E */
  0x0000,   /* U+426F */
  0x0000,   /* U+4270 */
  0x0000,   /* U+4271 */
  0x0000,   /* U+4272 */
  0x0000,   /* U+4273 */
  0x0000,   /* U+4274 */
  0x0000,   /* U+4275 */
  0x0000,   /* U+4276 */
  0x0000,   /* U+4277 */
  0x0000,   /* U+4278 */
  0x0000,   /* U+4279 */
  0x0000,   /* U+427A */
  0x0000,   /* U+427B */
  0x0000,   /* U+427C */
  0x0000,   /* U+427D */
  0x0000,   /* U+427E */
  0x0000,   /* U+427F */
  0x0000,   /* U+4280 */
  0x0000,   /* U+4281 */
  0x0000,   /* U+4282 */
  0x0000,   /* U+4283 */
  0x0000,   /* U+4284 */
  0x0000,   /* U+4285 */
  0x0000,   /* U+4286 */
  0x0000,   /* U+4287 */
  0x0000,   /* U+4288 */
  0x0000,   /* U+4289 */
  0x0000,   /* U+428A */
  0x0000,   /* U+428B */
  0x0000,   /* U+428C */
  0x0000,   /* U+428D */
  0x0000,   /* U+428E */
  0x0000,   /* U+428F */
  0x0000,   /* U+4290 */
  0x0000,   /* U+4291 */
  0x0000,   /* U+4292 */
  0x0000,   /* U+4293 */
  0x0000,   /* U+4294 */
  0x0000,   /* U+4295 */
  0x0000,   /* U+4296 */
  0x0000,   /* U+4297 */
  0x0000,   /* U+4298 */
  0x0000,   /* U+4299 */
  0x0000,   /* U+429A */
  0x0000,   /* U+429B */
  0x0000,   /* U+429C */
  0x0000,   /* U+429D */
  0x0000,   /* U+429E */
  0x0000,   /* U+429F */
  0x0000,   /* U+42A0 */
  0x0000,   /* U+42A1 */
  0x0000,   /* U+42A2 */
  0x0000,   /* U+42A3 */
  0x0000,   /* U+42A4 */
  0x0000,   /* U+42A5 */
  0x0000,   /* U+42A6 */
  0x0000,   /* U+42A7 */
  0x0000,   /* U+42A8 */
  0x0000,   /* U+42A9 */
  0x0000,   /* U+42AA */
  0x0000,   /* U+42AB */
  0x0000,   /* U+42AC */
  0x0000,   /* U+42AD */
  0x0000,   /* U+42AE */
  0x0000,   /* U+42AF */
  0x0000,   /* U+42B0 */
  0x0000,   /* U+42B1 */
  0x0000,   /* U+42B2 */
  0x0000,   /* U+42B3 */
  0x0000,   /* U+42B4 */
  0x0000,   /* U+42B5 */
  0x0000,   /* U+42B6 */
  0x0000,   /* U+42B7 */
  0x0000,   /* U+42B8 */
  0x0000,   /* U+42B9 */
  0x0000,   /* U+42BA */
  0x0000,   /* U+42BB */
  0x0000,   /* U+42BC */
  0x0000,   /* U+42BD */
  0x0000,   /* U+42BE */
  0x0000,   /* U+42BF */
  0x0000,   /* U+42C0 */
  0x0000,   /* U+42C1 */
  0x0000,   /* U+42C2 */
  0x0000,   /* U+42C3 */
  0x0000,   /* U+42C4 */
  0x0000,   /* U+42C5 */
  0x0000,   /* U+42C6 */
  0x0000,   /* U+42C7 */
  0x0000,   /* U+42C8 */
  0x0000,   /* U+42C9 */
  0x0000,   /* U+42CA */
  0x0000,   /* U+42CB */
  0x0000,   /* U+42CC */
  0x0000,   /* U+42CD */
  0x0000,   /* U+42CE */
  0x0000,   /* U+42CF */
  0x0000,   /* U+42D0 */
  0x0000,   /* U+42D1 */
  0x0000,   /* U+42D2 */
  0x0000,   /* U+42D3 */
  0x0000,   /* U+42D4 */
  0x0000,   /* U+42D5 */
  0x0000,   /* U+42D6 */
  0x0000,   /* U+42D7 */
  0x0000,   /* U+42D8 */
  0x0000,   /* U+42D9 */
  0x0000,   /* U+42DA */
  0x0000,   /* U+42DB */
  0x0000,   /* U+42DC */
  0x0000,   /* U+42DD */
  0x0000,   /* U+42DE */
  0x0000,   /* U+42DF */
  0x0000,   /* U+42E0 */
  0x0000,   /* U+42E1 */
  0x0000,   /* U+42E2 */
  0x0000,   /* U+42E3 */
  0x0000,   /* U+42E4 */
  0x0000,   /* U+42E5 */
  0x0000,   /* U+42E6 */
  0x0000,   /* U+42E7 */
  0x0000,   /* U+42E8 */
  0x0000,   /* U+42E9 */
  0x0000,   /* U+42EA */
  0x0000,   /* U+42EB */
  0x0000,   /* U+42EC */
  0x0000,   /* U+42ED */
  0x0000,   /* U+42EE */
  0x0000,   /* U+42EF */
  0x0000,   /* U+42F0 */
  0x0000,   /* U+42F1 */
  0x0000,   /* U+42F2 */
  0x0000,   /* U+42F3 */
  0x0000,   /* U+42F4 */
  0x0000,   /* U+42F5 */
  0x0000,   /* U+42F6 */
  0x0000,   /* U+42F7 */
  0x0000,   /* U+42F8 */
  0x0000,   /* U+42F9 */
  0x0000,   /* U+42FA */
  0x0000,   /* U+42FB */
  0x0000,   /* U+42FC */
  0x0000,   /* U+42FD */
  0x0000,   /* U+42FE */
  0x0000,   /* U+42FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4200 */
  0x0000,   /* U+4201 */
  0x0000,   /* U+4202 */
  0x0000,   /* U+4203 */
  0x0000,   /* U+4204 */
  0x0000,   /* U+4205 */
  0x0000,   /* U+4206 */
  0x0000,   /* U+4207 */
  0x0000,   /* U+4208 */
  0x0000,   /* U+4209 */
  0x0000,   /* U+420A */
  0x0000,   /* U+420B */
  0x0000,   /* U+420C */
  0x0000,   /* U+420D */
  0x0000,   /* U+420E */
  0x0000,   /* U+420F */
  0x0000,   /* U+4210 */
  0x0000,   /* U+4211 */
  0x0000,   /* U+4212 */
  0x0000,   /* U+4213 */
  0x0000,   /* U+4214 */
  0x0000,   /* U+4215 */
  0x0000,   /* U+4216 */
  0x0000,   /* U+4217 */
  0x0000,   /* U+4218 */
  0x0000,   /* U+4219 */
  0x0000,   /* U+421A */
  0x0000,   /* U+421B */
  0x0000,   /* U+421C */
  0x0000,   /* U+421D */
  0x0000,   /* U+421E */
  0x0000,   /* U+421F */
  0x0000,   /* U+4220 */
  0x0000,   /* U+4221 */
  0x0000,   /* U+4222 */
  0x0000,   /* U+4223 */
  0x0000,   /* U+4224 */
  0x0000,   /* U+4225 */
  0x0000,   /* U+4226 */
  0x0000,   /* U+4227 */
  0x0000,   /* U+4228 */
  0x0000,   /* U+4229 */
  0x0000,   /* U+422A */
  0x0000,   /* U+422B */
  0x0000,   /* U+422C */
  0x0000,   /* U+422D */
  0x0000,   /* U+422E */
  0x0000,   /* U+422F */
  0x0000,   /* U+4230 */
  0x0000,   /* U+4231 */
  0x0000,   /* U+4232 */
  0x0000,   /* U+4233 */
  0x0000,   /* U+4234 */
  0x0000,   /* U+4235 */
  0x0000,   /* U+4236 */
  0x0000,   /* U+4237 */
  0x0000,   /* U+4238 */
  0x0000,   /* U+4239 */
  0x0000,   /* U+423A */
  0x0000,   /* U+423B */
  0x0000,   /* U+423C */
  0x0000,   /* U+423D */
  0x0000,   /* U+423E */
  0x0000,   /* U+423F */
  0x0000,   /* U+4240 */
  0x0000,   /* U+4241 */
  0x0000,   /* U+4242 */
  0x0000,   /* U+4243 */
  0x0000,   /* U+4244 */
  0x0000,   /* U+4245 */
  0x0000,   /* U+4246 */
  0x0000,   /* U+4247 */
  0x0000,   /* U+4248 */
  0x0000,   /* U+4249 */
  0x0000,   /* U+424A */
  0x0000,   /* U+424B */
  0x0000,   /* U+424C */
  0x0000,   /* U+424D */
  0x0000,   /* U+424E */
  0x0000,   /* U+424F */
  0x0000,   /* U+4250 */
  0x0000,   /* U+4251 */
  0x0000,   /* U+4252 */
  0x0000,   /* U+4253 */
  0x0000,   /* U+4254 */
  0x0000,   /* U+4255 */
  0x0000,   /* U+4256 */
  0x0000,   /* U+4257 */
  0x0000,   /* U+4258 */
  0x0000,   /* U+4259 */
  0x0000,   /* U+425A */
  0x0000,   /* U+425B */
  0x0000,   /* U+425C */
  0x0000,   /* U+425D */
  0x0000,   /* U+425E */
  0x0000,   /* U+425F */
  0x0000,   /* U+4260 */
  0x0000,   /* U+4261 */
  0x0000,   /* U+4262 */
  0x0000,   /* U+4263 */
  0x0000,   /* U+4264 */
  0x0000,   /* U+4265 */
  0x0000,   /* U+4266 */
  0x0000,   /* U+4267 */
  0x0000,   /* U+4268 */
  0x0000,   /* U+4269 */
  0x0000,   /* U+426A */
  0x0000,   /* U+426B */
  0x0000,   /* U+426C */
  0x0000,   /* U+426D */
  0x0000,   /* U+426E */
  0x0000,   /* U+426F */
  0x0000,   /* U+4270 */
  0x0000,   /* U+4271 */
  0x0000,   /* U+4272 */
  0x0000,   /* U+4273 */
  0x0000,   /* U+4274 */
  0x0000,   /* U+4275 */
  0x0000,   /* U+4276 */
  0x0000,   /* U+4277 */
  0x0000,   /* U+4278 */
  0x0000,   /* U+4279 */
  0x0000,   /* U+427A */
  0x0000,   /* U+427B */
  0x0000,   /* U+427C */
  0x0000,   /* U+427D */
  0x0000,   /* U+427E */
  0x0000,   /* U+427F */
  0x0000,   /* U+4280 */
  0x0000,   /* U+4281 */
  0x0000,   /* U+4282 */
  0x0000,   /* U+4283 */
  0x0000,   /* U+4284 */
  0x0000,   /* U+4285 */
  0x0000,   /* U+4286 */
  0x0000,   /* U+4287 */
  0x0000,   /* U+4288 */
  0x0000,   /* U+4289 */
  0x0000,   /* U+428A */
  0x0000,   /* U+428B */
  0x0000,   /* U+428C */
  0x0000,   /* U+428D */
  0x0000,   /* U+428E */
  0x0000,   /* U+428F */
  0x0000,   /* U+4290 */
  0x0000,   /* U+4291 */
  0x0000,   /* U+4292 */
  0x0000,   /* U+4293 */
  0x0000,   /* U+4294 */
  0x0000,   /* U+4295 */
  0x0000,   /* U+4296 */
  0x0000,   /* U+4297 */
  0x0000,   /* U+4298 */
  0x0000,   /* U+4299 */
  0x0000,   /* U+429A */
  0x0000,   /* U+429B */
  0x0000,   /* U+429C */
  0x0000,   /* U+429D */
  0x0000,   /* U+429E */
  0x0000,   /* U+429F */
  0x0000,   /* U+42A0 */
  0x0000,   /* U+42A1 */
  0x0000,   /* U+42A2 */
  0x0000,   /* U+42A3 */
  0x0000,   /* U+42A4 */
  0x0000,   /* U+42A5 */
  0x0000,   /* U+42A6 */
  0x0000,   /* U+42A7 */
  0x0000,   /* U+42A8 */
  0x0000,   /* U+42A9 */
  0x0000,   /* U+42AA */
  0x0000,   /* U+42AB */
  0x0000,   /* U+42AC */
  0x0000,   /* U+42AD */
  0x0000,   /* U+42AE */
  0x0000,   /* U+42AF */
  0x0000,   /* U+42B0 */
  0x0000,   /* U+42B1 */
  0x0000,   /* U+42B2 */
  0x0000,   /* U+42B3 */
  0x0000,   /* U+42B4 */
  0x0000,   /* U+42B5 */
  0x0000,   /* U+42B6 */
  0x0000,   /* U+42B7 */
  0x0000,   /* U+42B8 */
  0x0000,   /* U+42B9 */
  0x0000,   /* U+42BA */
  0x0000,   /* U+42BB */
  0x0000,   /* U+42BC */
  0x0000,   /* U+42BD */
  0x0000,   /* U+42BE */
  0x0000,   /* U+42BF */
  0x0000,   /* U+42C0 */
  0x0000,   /* U+42C1 */
  0x0000,   /* U+42C2 */
  0x0000,   /* U+42C3 */
  0x0000,   /* U+42C4 */
  0x0000,   /* U+42C5 */
  0x0000,   /* U+42C6 */
  0x0000,   /* U+42C7 */
  0x0000,   /* U+42C8 */
  0x0000,   /* U+42C9 */
  0x0000,   /* U+42CA */
  0x0000,   /* U+42CB */
  0x0000,   /* U+42CC */
  0x0000,   /* U+42CD */
  0x0000,   /* U+42CE */
  0x0000,   /* U+42CF */
  0x0000,   /* U+42D0 */
  0x0000,   /* U+42D1 */
  0x0000,   /* U+42D2 */
  0x0000,   /* U+42D3 */
  0x0000,   /* U+42D4 */
  0x0000,   /* U+42D5 */
  0x0000,   /* U+42D6 */
  0x0000,   /* U+42D7 */
  0x0000,   /* U+42D8 */
  0x0000,   /* U+42D9 */
  0x0000,   /* U+42DA */
  0x0000,   /* U+42DB */
  0x0000,   /* U+42DC */
  0x0000,   /* U+42DD */
  0x0000,   /* U+42DE */
  0x0000,   /* U+42DF */
  0x0000,   /* U+42E0 */
  0x0000,   /* U+42E1 */
  0x0000,   /* U+42E2 */
  0x0000,   /* U+42E3 */
  0x0000,   /* U+42E4 */
  0x0000,   /* U+42E5 */
  0x0000,   /* U+42E6 */
  0x0000,   /* U+42E7 */
  0x0000,   /* U+42E8 */
  0x0000,   /* U+42E9 */
  0x0000,   /* U+42EA */
  0x0000,   /* U+42EB */
  0x0000,   /* U+42EC */
  0x0000,   /* U+42ED */
  0x0000,   /* U+42EE */
  0x0000,   /* U+42EF */
  0x0000,   /* U+42F0 */
  0x0000,   /* U+42F1 */
  0x0000,   /* U+42F2 */
  0x0000,   /* U+42F3 */
  0x0000,   /* U+42F4 */
  0x0000,   /* U+42F5 */
  0x0000,   /* U+42F6 */
  0x0000,   /* U+42F7 */
  0x0000,   /* U+42F8 */
  0x0000,   /* U+42F9 */
  0x0000,   /* U+42FA */
  0x0000,   /* U+42FB */
  0x0000,   /* U+42FC */
  0x0000,   /* U+42FD */
  0x0000,   /* U+42FE */
  0x0000,   /* U+42FF */
};

uint16 zh3_han_p043[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C56,   /* U+4300 */
  0x1C56,   /* U+4301 */
  0x1C56,   /* U+4302 */
  0x1C56,   /* U+4303 */
  0x1C56,   /* U+4304 */
  0x1C57,   /* U+4305 */
  0x1C57,   /* U+4306 */
  0x1C57,   /* U+4307 */
  0x1C57,   /* U+4308 */
  0x1C57,   /* U+4309 */
  0x1C57,   /* U+430A */
  0x1C57,   /* U+430B */
  0x1C58,   /* U+430C */
  0x1C58,   /* U+430D */
  0x1C58,   /* U+430E */
  0x1C58,   /* U+430F */
  0x1C58,   /* U+4310 */
  0x1C58,   /* U+4311 */
  0x1C58,   /* U+4312 */
  0x1C58,   /* U+4313 */
  0x1C58,   /* U+4314 */
  0x1C58,   /* U+4315 */
  0x1C59,   /* U+4316 */
  0x1C59,   /* U+4317 */
  0x1C59,   /* U+4318 */
  0x1C59,   /* U+4319 */
  0x1C59,   /* U+431A */
  0x1C59,   /* U+431B */
  0x1C5A,   /* U+431C */
  0x1C5A,   /* U+431D */
  0x1C5A,   /* U+431E */
  0x1C5A,   /* U+431F */
  0x1C5A,   /* U+4320 */
  0x1C5A,   /* U+4321 */
  0x1C5A,   /* U+4322 */
  0x1C5B,   /* U+4323 */
  0x1C5B,   /* U+4324 */
  0x1C5B,   /* U+4325 */
  0x1C5B,   /* U+4326 */
  0x1C5B,   /* U+4327 */
  0x1C5C,   /* U+4328 */
  0x1C5C,   /* U+4329 */
  0x1C5D,   /* U+432A */
  0x1C5D,   /* U+432B */
  0x1C5D,   /* U+432C */
  0x1C5D,   /* U+432D */
  0x1C5E,   /* U+432E */
  0x1C5F,   /* U+432F */
  0x1C5F,   /* U+4330 */
  0x1C5F,   /* U+4331 */
  0x1C5F,   /* U+4332 */
  0x1C60,   /* U+4333 */
  0x1C60,   /* U+4334 */
  0x1C62,   /* U+4335 */
  0x1C50,   /* U+4336 */
  0x1C52,   /* U+4337 */
  0x1C51,   /* U+4338 */
  0x1C52,   /* U+4339 */
  0x1C53,   /* U+433A */
  0x1C53,   /* U+433B */
  0x1C54,   /* U+433C */
  0x1C55,   /* U+433D */
  0x1C56,   /* U+433E */
  0x1C56,   /* U+433F */
  0x1C57,   /* U+4340 */
  0x1C5A,   /* U+4341 */
  0x1C50,   /* U+4342 */
  0x1C51,   /* U+4343 */
  0x1C52,   /* U+4344 */
  0x1C52,   /* U+4345 */
  0x1C52,   /* U+4346 */
  0x1C52,   /* U+4347 */
  0x1C52,   /* U+4348 */
  0x1C52,   /* U+4349 */
  0x1C53,   /* U+434A */
  0x1C55,   /* U+434B */
  0x1C55,   /* U+434C */
  0x1C57,   /* U+434D */
  0x1C5E,   /* U+434E */
  0x1C4C,   /* U+434F */
  0x1C4F,   /* U+4350 */
  0x1C50,   /* U+4351 */
  0x1C50,   /* U+4352 */
  0x1C50,   /* U+4353 */
  0x1C50,   /* U+4354 */
  0x1C51,   /* U+4355 */
  0x1C51,   /* U+4356 */
  0x1C51,   /* U+4357 */
  0x1C52,   /* U+4358 */
  0x1C53,   /* U+4359 */
  0x1C53,   /* U+435A */
  0x1C54,   /* U+435B */
  0x1C54,   /* U+435C */
  0x1C54,   /* U+435D */
  0x1C55,   /* U+435E */
  0x1C55,   /* U+435F */
  0x1C57,   /* U+4360 */
  0x1C57,   /* U+4361 */
  0x1C58,   /* U+4362 */
  0x1C59,   /* U+4363 */
  0x1C5A,   /* U+4364 */
  0x1C5C,   /* U+4365 */
  0x1C5F,   /* U+4366 */
  0x1C51,   /* U+4367 */
  0x1C51,   /* U+4368 */
  0x1C51,   /* U+4369 */
  0x1C52,   /* U+436A */
  0x1C52,   /* U+436B */
  0x1C52,   /* U+436C */
  0x1C52,   /* U+436D */
  0x1C53,   /* U+436E */
  0x1C53,   /* U+436F */
  0x1C53,   /* U+4370 */
  0x1C54,   /* U+4371 */
  0x1C55,   /* U+4372 */
  0x1C55,   /* U+4373 */
  0x1C55,   /* U+4374 */
  0x1C55,   /* U+4375 */
  0x1C55,   /* U+4376 */
  0x1C56,   /* U+4377 */
  0x1C57,   /* U+4378 */
  0x1C57,   /* U+4379 */
  0x1C58,   /* U+437A */
  0x1C59,   /* U+437B */
  0x1C59,   /* U+437C */
  0x1C5D,   /* U+437D */
  0x1C51,   /* U+437E */
  0x1C51,   /* U+437F */
  0x1C52,   /* U+4380 */
  0x1C52,   /* U+4381 */
  0x1C52,   /* U+4382 */
  0x1C52,   /* U+4383 */
  0x1C52,   /* U+4384 */
  0x1C52,   /* U+4385 */
  0x1C52,   /* U+4386 */
  0x1C53,   /* U+4387 */
  0x1C53,   /* U+4388 */
  0x1C53,   /* U+4389 */
  0x1C53,   /* U+438A */
  0x1C54,   /* U+438B */
  0x1C54,   /* U+438C */
  0x1C54,   /* U+438D */
  0x1C54,   /* U+438E */
  0x1C55,   /* U+438F */
  0x1C55,   /* U+4390 */
  0x1C55,   /* U+4391 */
  0x1C55,   /* U+4392 */
  0x1C55,   /* U+4393 */
  0x1C57,   /* U+4394 */
  0x1C57,   /* U+4395 */
  0x1C59,   /* U+4396 */
  0x1C59,   /* U+4397 */
  0x1C59,   /* U+4398 */
  0x1C5B,   /* U+4399 */
  0x1C5C,   /* U+439A */
  0x1C50,   /* U+439B */
  0x1C53,   /* U+439C */
  0x1C53,   /* U+439D */
  0x1C53,   /* U+439E */
  0x1C50,   /* U+439F */
  0x1C50,   /* U+43A0 */
  0x1C51,   /* U+43A1 */
  0x1C50,   /* U+43A2 */
  0x1C52,   /* U+43A3 */
  0x1C54,   /* U+43A4 */
  0x1C54,   /* U+43A5 */
  0x1C55,   /* U+43A6 */
  0x1C55,   /* U+43A7 */
  0x1C55,   /* U+43A8 */
  0x1C55,   /* U+43A9 */
  0x1C55,   /* U+43AA */
  0x1C56,   /* U+43AB */
  0x1C56,   /* U+43AC */
  0x1C58,   /* U+43AD */
  0x1C58,   /* U+43AE */
  0x1C58,   /* U+43AF */
  0x1C59,   /* U+43B0 */
  0x1C5C,   /* U+43B1 */
  0x1C4E,   /* U+43B2 */
  0x1C51,   /* U+43B3 */
  0x1C51,   /* U+43B4 */
  0x1C52,   /* U+43B5 */
  0x1C52,   /* U+43B6 */
  0x1C53,   /* U+43B7 */
  0x1C54,   /* U+43B8 */
  0x1C54,   /* U+43B9 */
  0x1C55,   /* U+43BA */
  0x1C55,   /* U+43BB */
  0x1C55,   /* U+43BC */
  0x1C55,   /* U+43BD */
  0x1C55,   /* U+43BE */
  0x1C56,   /* U+43BF */
  0x1C56,   /* U+43C0 */
  0x1C57,   /* U+43C1 */
  0x1C57,   /* U+43C2 */
  0x1C57,   /* U+43C3 */
  0x1C58,   /* U+43C4 */
  0x1C58,   /* U+43C5 */
  0x1C58,   /* U+43C6 */
  0x1C58,   /* U+43C7 */
  0x1C59,   /* U+43C8 */
  0x1C5B,   /* U+43C9 */
  0x1C5D,   /* U+43CA */
  0x1C54,   /* U+43CB */
  0x1C4D,   /* U+43CC */
  0x1C4D,   /* U+43CD */
  0x1C4E,   /* U+43CE */
  0x1C4E,   /* U+43CF */
  0x1C4F,   /* U+43D0 */
  0x1C51,   /* U+43D1 */
  0x1C4F,   /* U+43D2 */
  0x1C4F,   /* U+43D3 */
  0x1C4F,   /* U+43D4 */
  0x1C4F,   /* U+43D5 */
  0x1C4F,   /* U+43D6 */
  0x1C4F,   /* U+43D7 */
  0x1C4F,   /* U+43D8 */
  0x1C4F,   /* U+43D9 */
  0x1C4F,   /* U+43DA */
  0x1C4F,   /* U+43DB */
  0x1C4F,   /* U+43DC */
  0x1C4F,   /* U+43DD */
  0x1C50,   /* U+43DE */
  0x1C50,   /* U+43DF */
  0x1C50,   /* U+43E0 */
  0x1C50,   /* U+43E1 */
  0x1C50,   /* U+43E2 */
  0x1C50,   /* U+43E3 */
  0x1C50,   /* U+43E4 */
  0x1C50,   /* U+43E5 */
  0x1C51,   /* U+43E6 */
  0x1C51,   /* U+43E7 */
  0x1C51,   /* U+43E8 */
  0x1C51,   /* U+43E9 */
  0x1C51,   /* U+43EA */
  0x1C51,   /* U+43EB */
  0x1C51,   /* U+43EC */
  0x1C51,   /* U+43ED */
  0x1C51,   /* U+43EE */
  0x1C52,   /* U+43EF */
  0x1C52,   /* U+43F0 */
  0x1C52,   /* U+43F1 */
  0x1C52,   /* U+43F2 */
  0x1C52,   /* U+43F3 */
  0x1C52,   /* U+43F4 */
  0x1C52,   /* U+43F5 */
  0x1C52,   /* U+43F6 */
  0x1C52,   /* U+43F7 */
  0x1C52,   /* U+43F8 */
  0x1C52,   /* U+43F9 */
  0x1C52,   /* U+43FA */
  0x1C52,   /* U+43FB */
  0x1C53,   /* U+43FC */
  0x1C53,   /* U+43FD */
  0x1C53,   /* U+43FE */
  0x1C53,   /* U+43FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4300 */
  0x0020,   /* U+4301 */
  0x0020,   /* U+4302 */
  0x0020,   /* U+4303 */
  0x0020,   /* U+4304 */
  0x0020,   /* U+4305 */
  0x0020,   /* U+4306 */
  0x0020,   /* U+4307 */
  0x0020,   /* U+4308 */
  0x0020,   /* U+4309 */
  0x0020,   /* U+430A */
  0x0020,   /* U+430B */
  0x0020,   /* U+430C */
  0x0020,   /* U+430D */
  0x0020,   /* U+430E */
  0x0020,   /* U+430F */
  0x0020,   /* U+4310 */
  0x0020,   /* U+4311 */
  0x0020,   /* U+4312 */
  0x0020,   /* U+4313 */
  0x0020,   /* U+4314 */
  0x0020,   /* U+4315 */
  0x0020,   /* U+4316 */
  0x0020,   /* U+4317 */
  0x0020,   /* U+4318 */
  0x0020,   /* U+4319 */
  0x0020,   /* U+431A */
  0x0020,   /* U+431B */
  0x0020,   /* U+431C */
  0x0020,   /* U+431D */
  0x0020,   /* U+431E */
  0x0020,   /* U+431F */
  0x0020,   /* U+4320 */
  0x0020,   /* U+4321 */
  0x0020,   /* U+4322 */
  0x0020,   /* U+4323 */
  0x0020,   /* U+4324 */
  0x0020,   /* U+4325 */
  0x0020,   /* U+4326 */
  0x0020,   /* U+4327 */
  0x0020,   /* U+4328 */
  0x0020,   /* U+4329 */
  0x0020,   /* U+432A */
  0x0020,   /* U+432B */
  0x0020,   /* U+432C */
  0x0020,   /* U+432D */
  0x0020,   /* U+432E */
  0x0020,   /* U+432F */
  0x0020,   /* U+4330 */
  0x0020,   /* U+4331 */
  0x0020,   /* U+4332 */
  0x0020,   /* U+4333 */
  0x0020,   /* U+4334 */
  0x0020,   /* U+4335 */
  0x0020,   /* U+4336 */
  0x0020,   /* U+4337 */
  0x0020,   /* U+4338 */
  0x0020,   /* U+4339 */
  0x0020,   /* U+433A */
  0x0020,   /* U+433B */
  0x0020,   /* U+433C */
  0x0020,   /* U+433D */
  0x0020,   /* U+433E */
  0x0020,   /* U+433F */
  0x0020,   /* U+4340 */
  0x0020,   /* U+4341 */
  0x0020,   /* U+4342 */
  0x0020,   /* U+4343 */
  0x0020,   /* U+4344 */
  0x0020,   /* U+4345 */
  0x0020,   /* U+4346 */
  0x0020,   /* U+4347 */
  0x0020,   /* U+4348 */
  0x0020,   /* U+4349 */
  0x0020,   /* U+434A */
  0x0020,   /* U+434B */
  0x0020,   /* U+434C */
  0x0020,   /* U+434D */
  0x0020,   /* U+434E */
  0x0020,   /* U+434F */
  0x0020,   /* U+4350 */
  0x0020,   /* U+4351 */
  0x0020,   /* U+4352 */
  0x0020,   /* U+4353 */
  0x0020,   /* U+4354 */
  0x0020,   /* U+4355 */
  0x0020,   /* U+4356 */
  0x0020,   /* U+4357 */
  0x0020,   /* U+4358 */
  0x0020,   /* U+4359 */
  0x0020,   /* U+435A */
  0x0020,   /* U+435B */
  0x0020,   /* U+435C */
  0x0020,   /* U+435D */
  0x0020,   /* U+435E */
  0x0020,   /* U+435F */
  0x0020,   /* U+4360 */
  0x0020,   /* U+4361 */
  0x0020,   /* U+4362 */
  0x0020,   /* U+4363 */
  0x0020,   /* U+4364 */
  0x0020,   /* U+4365 */
  0x0020,   /* U+4366 */
  0x0020,   /* U+4367 */
  0x0020,   /* U+4368 */
  0x0020,   /* U+4369 */
  0x0020,   /* U+436A */
  0x0020,   /* U+436B */
  0x0020,   /* U+436C */
  0x0020,   /* U+436D */
  0x0020,   /* U+436E */
  0x0020,   /* U+436F */
  0x0020,   /* U+4370 */
  0x0020,   /* U+4371 */
  0x0020,   /* U+4372 */
  0x0020,   /* U+4373 */
  0x0020,   /* U+4374 */
  0x0020,   /* U+4375 */
  0x0020,   /* U+4376 */
  0x0020,   /* U+4377 */
  0x0020,   /* U+4378 */
  0x0020,   /* U+4379 */
  0x0020,   /* U+437A */
  0x0020,   /* U+437B */
  0x0020,   /* U+437C */
  0x0020,   /* U+437D */
  0x0020,   /* U+437E */
  0x0020,   /* U+437F */
  0x0020,   /* U+4380 */
  0x0020,   /* U+4381 */
  0x0020,   /* U+4382 */
  0x0020,   /* U+4383 */
  0x0020,   /* U+4384 */
  0x0020,   /* U+4385 */
  0x0020,   /* U+4386 */
  0x0020,   /* U+4387 */
  0x0020,   /* U+4388 */
  0x0020,   /* U+4389 */
  0x0020,   /* U+438A */
  0x0020,   /* U+438B */
  0x0020,   /* U+438C */
  0x0020,   /* U+438D */
  0x0020,   /* U+438E */
  0x0020,   /* U+438F */
  0x0020,   /* U+4390 */
  0x0020,   /* U+4391 */
  0x0020,   /* U+4392 */
  0x0020,   /* U+4393 */
  0x0020,   /* U+4394 */
  0x0020,   /* U+4395 */
  0x0020,   /* U+4396 */
  0x0020,   /* U+4397 */
  0x0020,   /* U+4398 */
  0x0020,   /* U+4399 */
  0x0020,   /* U+439A */
  0x0020,   /* U+439B */
  0x0020,   /* U+439C */
  0x0020,   /* U+439D */
  0x0020,   /* U+439E */
  0x0020,   /* U+439F */
  0x0020,   /* U+43A0 */
  0x0020,   /* U+43A1 */
  0x0020,   /* U+43A2 */
  0x0020,   /* U+43A3 */
  0x0020,   /* U+43A4 */
  0x0020,   /* U+43A5 */
  0x0020,   /* U+43A6 */
  0x0020,   /* U+43A7 */
  0x0020,   /* U+43A8 */
  0x0020,   /* U+43A9 */
  0x0020,   /* U+43AA */
  0x0020,   /* U+43AB */
  0x0020,   /* U+43AC */
  0x0020,   /* U+43AD */
  0x0020,   /* U+43AE */
  0x0020,   /* U+43AF */
  0x0020,   /* U+43B0 */
  0x0020,   /* U+43B1 */
  0x0020,   /* U+43B2 */
  0x0020,   /* U+43B3 */
  0x0020,   /* U+43B4 */
  0x0020,   /* U+43B5 */
  0x0020,   /* U+43B6 */
  0x0020,   /* U+43B7 */
  0x0020,   /* U+43B8 */
  0x0020,   /* U+43B9 */
  0x0020,   /* U+43BA */
  0x0020,   /* U+43BB */
  0x0020,   /* U+43BC */
  0x0020,   /* U+43BD */
  0x0020,   /* U+43BE */
  0x0020,   /* U+43BF */
  0x0020,   /* U+43C0 */
  0x0020,   /* U+43C1 */
  0x0020,   /* U+43C2 */
  0x0020,   /* U+43C3 */
  0x0020,   /* U+43C4 */
  0x0020,   /* U+43C5 */
  0x0020,   /* U+43C6 */
  0x0020,   /* U+43C7 */
  0x0020,   /* U+43C8 */
  0x0020,   /* U+43C9 */
  0x0020,   /* U+43CA */
  0x0020,   /* U+43CB */
  0x0020,   /* U+43CC */
  0x0020,   /* U+43CD */
  0x0020,   /* U+43CE */
  0x0020,   /* U+43CF */
  0x0020,   /* U+43D0 */
  0x0020,   /* U+43D1 */
  0x0020,   /* U+43D2 */
  0x0020,   /* U+43D3 */
  0x0020,   /* U+43D4 */
  0x0020,   /* U+43D5 */
  0x0020,   /* U+43D6 */
  0x0020,   /* U+43D7 */
  0x0020,   /* U+43D8 */
  0x0020,   /* U+43D9 */
  0x0020,   /* U+43DA */
  0x0020,   /* U+43DB */
  0x0020,   /* U+43DC */
  0x0020,   /* U+43DD */
  0x0020,   /* U+43DE */
  0x0020,   /* U+43DF */
  0x0020,   /* U+43E0 */
  0x0020,   /* U+43E1 */
  0x0020,   /* U+43E2 */
  0x0020,   /* U+43E3 */
  0x0020,   /* U+43E4 */
  0x0020,   /* U+43E5 */
  0x0020,   /* U+43E6 */
  0x0020,   /* U+43E7 */
  0x0020,   /* U+43E8 */
  0x0020,   /* U+43E9 */
  0x0020,   /* U+43EA */
  0x0020,   /* U+43EB */
  0x0020,   /* U+43EC */
  0x0020,   /* U+43ED */
  0x0020,   /* U+43EE */
  0x0020,   /* U+43EF */
  0x0020,   /* U+43F0 */
  0x0020,   /* U+43F1 */
  0x0020,   /* U+43F2 */
  0x0020,   /* U+43F3 */
  0x0020,   /* U+43F4 */
  0x0020,   /* U+43F5 */
  0x0020,   /* U+43F6 */
  0x0020,   /* U+43F7 */
  0x0020,   /* U+43F8 */
  0x0020,   /* U+43F9 */
  0x0020,   /* U+43FA */
  0x0020,   /* U+43FB */
  0x0020,   /* U+43FC */
  0x0020,   /* U+43FD */
  0x0020,   /* U+43FE */
  0x0020,   /* U+43FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4300 */
  0x0002,   /* U+4301 */
  0x0002,   /* U+4302 */
  0x0002,   /* U+4303 */
  0x0002,   /* U+4304 */
  0x0002,   /* U+4305 */
  0x0002,   /* U+4306 */
  0x0002,   /* U+4307 */
  0x0002,   /* U+4308 */
  0x0002,   /* U+4309 */
  0x0002,   /* U+430A */
  0x0002,   /* U+430B */
  0x0002,   /* U+430C */
  0x0002,   /* U+430D */
  0x0002,   /* U+430E */
  0x0002,   /* U+430F */
  0x0002,   /* U+4310 */
  0x0002,   /* U+4311 */
  0x0002,   /* U+4312 */
  0x0002,   /* U+4313 */
  0x0002,   /* U+4314 */
  0x0002,   /* U+4315 */
  0x0002,   /* U+4316 */
  0x0002,   /* U+4317 */
  0x0002,   /* U+4318 */
  0x0002,   /* U+4319 */
  0x0002,   /* U+431A */
  0x0002,   /* U+431B */
  0x0002,   /* U+431C */
  0x0002,   /* U+431D */
  0x0002,   /* U+431E */
  0x0002,   /* U+431F */
  0x0002,   /* U+4320 */
  0x0002,   /* U+4321 */
  0x0002,   /* U+4322 */
  0x0002,   /* U+4323 */
  0x0002,   /* U+4324 */
  0x0002,   /* U+4325 */
  0x0002,   /* U+4326 */
  0x0002,   /* U+4327 */
  0x0002,   /* U+4328 */
  0x0002,   /* U+4329 */
  0x0002,   /* U+432A */
  0x0002,   /* U+432B */
  0x0002,   /* U+432C */
  0x0002,   /* U+432D */
  0x0002,   /* U+432E */
  0x0002,   /* U+432F */
  0x0002,   /* U+4330 */
  0x0002,   /* U+4331 */
  0x0002,   /* U+4332 */
  0x0002,   /* U+4333 */
  0x0002,   /* U+4334 */
  0x0002,   /* U+4335 */
  0x0002,   /* U+4336 */
  0x0002,   /* U+4337 */
  0x0002,   /* U+4338 */
  0x0002,   /* U+4339 */
  0x0002,   /* U+433A */
  0x0002,   /* U+433B */
  0x0002,   /* U+433C */
  0x0002,   /* U+433D */
  0x0002,   /* U+433E */
  0x0002,   /* U+433F */
  0x0002,   /* U+4340 */
  0x0002,   /* U+4341 */
  0x0002,   /* U+4342 */
  0x0002,   /* U+4343 */
  0x0002,   /* U+4344 */
  0x0002,   /* U+4345 */
  0x0002,   /* U+4346 */
  0x0002,   /* U+4347 */
  0x0002,   /* U+4348 */
  0x0002,   /* U+4349 */
  0x0002,   /* U+434A */
  0x0002,   /* U+434B */
  0x0002,   /* U+434C */
  0x0002,   /* U+434D */
  0x0002,   /* U+434E */
  0x0002,   /* U+434F */
  0x0002,   /* U+4350 */
  0x0002,   /* U+4351 */
  0x0002,   /* U+4352 */
  0x0002,   /* U+4353 */
  0x0002,   /* U+4354 */
  0x0002,   /* U+4355 */
  0x0002,   /* U+4356 */
  0x0002,   /* U+4357 */
  0x0002,   /* U+4358 */
  0x0002,   /* U+4359 */
  0x0002,   /* U+435A */
  0x0002,   /* U+435B */
  0x0002,   /* U+435C */
  0x0002,   /* U+435D */
  0x0002,   /* U+435E */
  0x0002,   /* U+435F */
  0x0002,   /* U+4360 */
  0x0002,   /* U+4361 */
  0x0002,   /* U+4362 */
  0x0002,   /* U+4363 */
  0x0002,   /* U+4364 */
  0x0002,   /* U+4365 */
  0x0002,   /* U+4366 */
  0x0002,   /* U+4367 */
  0x0002,   /* U+4368 */
  0x0002,   /* U+4369 */
  0x0002,   /* U+436A */
  0x0002,   /* U+436B */
  0x0002,   /* U+436C */
  0x0002,   /* U+436D */
  0x0002,   /* U+436E */
  0x0002,   /* U+436F */
  0x0002,   /* U+4370 */
  0x0002,   /* U+4371 */
  0x0002,   /* U+4372 */
  0x0002,   /* U+4373 */
  0x0002,   /* U+4374 */
  0x0002,   /* U+4375 */
  0x0002,   /* U+4376 */
  0x0002,   /* U+4377 */
  0x0002,   /* U+4378 */
  0x0002,   /* U+4379 */
  0x0002,   /* U+437A */
  0x0002,   /* U+437B */
  0x0002,   /* U+437C */
  0x0002,   /* U+437D */
  0x0002,   /* U+437E */
  0x0002,   /* U+437F */
  0x0002,   /* U+4380 */
  0x0002,   /* U+4381 */
  0x0002,   /* U+4382 */
  0x0002,   /* U+4383 */
  0x0002,   /* U+4384 */
  0x0002,   /* U+4385 */
  0x0002,   /* U+4386 */
  0x0002,   /* U+4387 */
  0x0002,   /* U+4388 */
  0x0002,   /* U+4389 */
  0x0002,   /* U+438A */
  0x0002,   /* U+438B */
  0x0002,   /* U+438C */
  0x0002,   /* U+438D */
  0x0002,   /* U+438E */
  0x0002,   /* U+438F */
  0x0002,   /* U+4390 */
  0x0002,   /* U+4391 */
  0x0002,   /* U+4392 */
  0x0002,   /* U+4393 */
  0x0002,   /* U+4394 */
  0x0002,   /* U+4395 */
  0x0002,   /* U+4396 */
  0x0002,   /* U+4397 */
  0x0002,   /* U+4398 */
  0x0002,   /* U+4399 */
  0x0002,   /* U+439A */
  0x0002,   /* U+439B */
  0x0002,   /* U+439C */
  0x0002,   /* U+439D */
  0x0002,   /* U+439E */
  0x0002,   /* U+439F */
  0x0002,   /* U+43A0 */
  0x0002,   /* U+43A1 */
  0x0002,   /* U+43A2 */
  0x0002,   /* U+43A3 */
  0x0002,   /* U+43A4 */
  0x0002,   /* U+43A5 */
  0x0002,   /* U+43A6 */
  0x0002,   /* U+43A7 */
  0x0002,   /* U+43A8 */
  0x0002,   /* U+43A9 */
  0x0002,   /* U+43AA */
  0x0002,   /* U+43AB */
  0x0002,   /* U+43AC */
  0x0002,   /* U+43AD */
  0x0002,   /* U+43AE */
  0x0002,   /* U+43AF */
  0x0002,   /* U+43B0 */
  0x0002,   /* U+43B1 */
  0x0002,   /* U+43B2 */
  0x0002,   /* U+43B3 */
  0x0002,   /* U+43B4 */
  0x0002,   /* U+43B5 */
  0x0002,   /* U+43B6 */
  0x0002,   /* U+43B7 */
  0x0002,   /* U+43B8 */
  0x0002,   /* U+43B9 */
  0x0002,   /* U+43BA */
  0x0002,   /* U+43BB */
  0x0002,   /* U+43BC */
  0x0002,   /* U+43BD */
  0x0002,   /* U+43BE */
  0x0002,   /* U+43BF */
  0x0002,   /* U+43C0 */
  0x0002,   /* U+43C1 */
  0x0002,   /* U+43C2 */
  0x0002,   /* U+43C3 */
  0x0002,   /* U+43C4 */
  0x0002,   /* U+43C5 */
  0x0002,   /* U+43C6 */
  0x0002,   /* U+43C7 */
  0x0002,   /* U+43C8 */
  0x0002,   /* U+43C9 */
  0x0002,   /* U+43CA */
  0x0002,   /* U+43CB */
  0x0002,   /* U+43CC */
  0x0002,   /* U+43CD */
  0x0002,   /* U+43CE */
  0x0002,   /* U+43CF */
  0x0002,   /* U+43D0 */
  0x0002,   /* U+43D1 */
  0x0002,   /* U+43D2 */
  0x0002,   /* U+43D3 */
  0x0002,   /* U+43D4 */
  0x0002,   /* U+43D5 */
  0x0002,   /* U+43D6 */
  0x0002,   /* U+43D7 */
  0x0002,   /* U+43D8 */
  0x0002,   /* U+43D9 */
  0x0002,   /* U+43DA */
  0x0002,   /* U+43DB */
  0x0002,   /* U+43DC */
  0x0002,   /* U+43DD */
  0x0002,   /* U+43DE */
  0x0002,   /* U+43DF */
  0x0002,   /* U+43E0 */
  0x0002,   /* U+43E1 */
  0x0002,   /* U+43E2 */
  0x0002,   /* U+43E3 */
  0x0002,   /* U+43E4 */
  0x0002,   /* U+43E5 */
  0x0002,   /* U+43E6 */
  0x0002,   /* U+43E7 */
  0x0002,   /* U+43E8 */
  0x0002,   /* U+43E9 */
  0x0002,   /* U+43EA */
  0x0002,   /* U+43EB */
  0x0002,   /* U+43EC */
  0x0002,   /* U+43ED */
  0x0002,   /* U+43EE */
  0x0002,   /* U+43EF */
  0x0002,   /* U+43F0 */
  0x0002,   /* U+43F1 */
  0x0002,   /* U+43F2 */
  0x0002,   /* U+43F3 */
  0x0002,   /* U+43F4 */
  0x0002,   /* U+43F5 */
  0x0002,   /* U+43F6 */
  0x0002,   /* U+43F7 */
  0x0002,   /* U+43F8 */
  0x0002,   /* U+43F9 */
  0x0002,   /* U+43FA */
  0x0002,   /* U+43FB */
  0x0002,   /* U+43FC */
  0x0002,   /* U+43FD */
  0x0002,   /* U+43FE */
  0x0002,   /* U+43FF */

  /* Primary weight 2 for each character. */
  0x8FDB,   /* U+4300 */
  0x8FDC,   /* U+4301 */
  0x8FDD,   /* U+4302 */
  0x8FDE,   /* U+4303 */
  0x8FDF,   /* U+4304 */
  0x8D41,   /* U+4305 */
  0x8D42,   /* U+4306 */
  0x8D43,   /* U+4307 */
  0x8D44,   /* U+4308 */
  0x8D45,   /* U+4309 */
  0x8D46,   /* U+430A */
  0x8D47,   /* U+430B */
  0x89BD,   /* U+430C */
  0x89BE,   /* U+430D */
  0x89BF,   /* U+430E */
  0x89C0,   /* U+430F */
  0x89C1,   /* U+4310 */
  0x89C2,   /* U+4311 */
  0x89C3,   /* U+4312 */
  0x89C4,   /* U+4313 */
  0x89C5,   /* U+4314 */
  0x89C6,   /* U+4315 */
  0x87FB,   /* U+4316 */
  0x87FC,   /* U+4317 */
  0x87FD,   /* U+4318 */
  0x87FE,   /* U+4319 */
  0x87FF,   /* U+431A */
  0x8800,   /* U+431B */
  0x85DC,   /* U+431C */
  0x85DD,   /* U+431D */
  0x85DE,   /* U+431E */
  0x85DF,   /* U+431F */
  0x85E0,   /* U+4320 */
  0x85E1,   /* U+4321 */
  0x85E2,   /* U+4322 */
  0x843E,   /* U+4323 */
  0x843F,   /* U+4324 */
  0x8440,   /* U+4325 */
  0x8441,   /* U+4326 */
  0x8442,   /* U+4327 */
  0x8362,   /* U+4328 */
  0x8363,   /* U+4329 */
  0x8268,   /* U+432A */
  0x8269,   /* U+432B */
  0x826A,   /* U+432C */
  0x826B,   /* U+432D */
  0x81B5,   /* U+432E */
  0x8142,   /* U+432F */
  0x8143,   /* U+4330 */
  0x8144,   /* U+4331 */
  0x8145,   /* U+4332 */
  0x80D0,   /* U+4333 */
  0x80D1,   /* U+4334 */
  0x8063,   /* U+4335 */
  0x903E,   /* U+4336 */
  0x936F,   /* U+4337 */
  0x928A,   /* U+4338 */
  0x9370,   /* U+4339 */
  0x94DE,   /* U+433A */
  0x94DF,   /* U+433B */
  0x9313,   /* U+433C */
  0x91DB,   /* U+433D */
  0x9042,   /* U+433E */
  0x9043,   /* U+433F */
  0x8D9E,   /* U+4340 */
  0x8616,   /* U+4341 */
  0x906C,   /* U+4342 */
  0x92B0,   /* U+4343 */
  0x93A6,   /* U+4344 */
  0x93A7,   /* U+4345 */
  0x93A8,   /* U+4346 */
  0x93A9,   /* U+4347 */
  0x93AA,   /* U+4348 */
  0x93AB,   /* U+4349 */
  0x9512,   /* U+434A */
  0x91F4,   /* U+434B */
  0x91F5,   /* U+434C */
  0x8DAC,   /* U+434D */
  0x81C5,   /* U+434E */
  0x831F,   /* U+434F */
  0x8D7A,   /* U+4350 */
  0x9071,   /* U+4351 */
  0x9074,   /* U+4352 */
  0x9075,   /* U+4353 */
  0x9076,   /* U+4354 */
  0x92C0,   /* U+4355 */
  0x92C1,   /* U+4356 */
  0x92C2,   /* U+4357 */
  0x93B5,   /* U+4358 */
  0x951C,   /* U+4359 */
  0x951D,   /* U+435A */
  0x9340,   /* U+435B */
  0x9341,   /* U+435C */
  0x9342,   /* U+435D */
  0x9203,   /* U+435E */
  0x920A,   /* U+435F */
  0x8DBB,   /* U+4360 */
  0x8DBC,   /* U+4361 */
  0x8A2F,   /* U+4362 */
  0x885D,   /* U+4363 */
  0x8625,   /* U+4364 */
  0x8393,   /* U+4365 */
  0x8159,   /* U+4366 */
  0x92EF,   /* U+4367 */
  0x92F0,   /* U+4368 */
  0x92F1,   /* U+4369 */
  0x93D5,   /* U+436A */
  0x93D6,   /* U+436B */
  0x93D7,   /* U+436C */
  0x93D8,   /* U+436D */
  0x9532,   /* U+436E */
  0x9533,   /* U+436F */
  0x9534,   /* U+4370 */
  0x936B,   /* U+4371 */
  0x9224,   /* U+4372 */
  0x9225,   /* U+4373 */
  0x9226,   /* U+4374 */
  0x9227,   /* U+4375 */
  0x9228,   /* U+4376 */
  0x9087,   /* U+4377 */
  0x8DD7,   /* U+4378 */
  0x8DD8,   /* U+4379 */
  0x8A42,   /* U+437A */
  0x8870,   /* U+437B */
  0x8871,   /* U+437C */
  0x828C,   /* U+437D */
  0x930C,   /* U+437E */
  0x930D,   /* U+437F */
  0x93FF,   /* U+4380 */
  0x9400,   /* U+4381 */
  0x9401,   /* U+4382 */
  0x9402,   /* U+4383 */
  0x9403,   /* U+4384 */
  0x9404,   /* U+4385 */
  0x9405,   /* U+4386 */
  0x9551,   /* U+4387 */
  0x9552,   /* U+4388 */
  0x9553,   /* U+4389 */
  0x9554,   /* U+438A */
  0x9383,   /* U+438B */
  0x9384,   /* U+438C */
  0x9385,   /* U+438D */
  0x9386,   /* U+438E */
  0x9241,   /* U+438F */
  0x9242,   /* U+4390 */
  0x9243,   /* U+4391 */
  0x9244,   /* U+4392 */
  0x9245,   /* U+4393 */
  0x8DEE,   /* U+4394 */
  0x8DEF,   /* U+4395 */
  0x888D,   /* U+4396 */
  0x888E,   /* U+4397 */
  0x888F,   /* U+4398 */
  0x847F,   /* U+4399 */
  0x83A5,   /* U+439A */
  0x90AB,   /* U+439B */
  0x9575,   /* U+439C */
  0x9576,   /* U+439D */
  0x9577,   /* U+439E */
  0x90B8,   /* U+439F */
  0x90B9,   /* U+43A0 */
  0x9334,   /* U+43A1 */
  0x90BC,   /* U+43A2 */
  0x9424,   /* U+43A3 */
  0x93A0,   /* U+43A4 */
  0x93A1,   /* U+43A5 */
  0x926A,   /* U+43A6 */
  0x926B,   /* U+43A7 */
  0x926C,   /* U+43A8 */
  0x926D,   /* U+43A9 */
  0x926E,   /* U+43AA */
  0x90D1,   /* U+43AB */
  0x90D2,   /* U+43AC */
  0x8A74,   /* U+43AD */
  0x8A75,   /* U+43AE */
  0x8A76,   /* U+43AF */
  0x88A7,   /* U+43B0 */
  0x83AD,   /* U+43B1 */
  0x89DC,   /* U+43B2 */
  0x934A,   /* U+43B3 */
  0x934B,   /* U+43B4 */
  0x9437,   /* U+43B5 */
  0x9438,   /* U+43B6 */
  0x958E,   /* U+43B7 */
  0x93AB,   /* U+43B8 */
  0x93AC,   /* U+43B9 */
  0x9285,   /* U+43BA */
  0x9286,   /* U+43BB */
  0x9287,   /* U+43BC */
  0x9288,   /* U+43BD */
  0x9289,   /* U+43BE */
  0x90E7,   /* U+43BF */
  0x90E8,   /* U+43C0 */
  0x8E20,   /* U+43C1 */
  0x8E21,   /* U+43C2 */
  0x8E22,   /* U+43C3 */
  0x8A86,   /* U+43C4 */
  0x8A87,   /* U+43C5 */
  0x8A88,   /* U+43C6 */
  0x8A89,   /* U+43C7 */
  0x88B7,   /* U+43C8 */
  0x848D,   /* U+43C9 */
  0x829D,   /* U+43CA */
  0x93CE,   /* U+43CB */
  0x85F8,   /* U+43CC */
  0x85F9,   /* U+43CD */
  0x89F2,   /* U+43CE */
  0x89F3,   /* U+43CF */
  0x8DD3,   /* U+43D0 */
  0x9368,   /* U+43D1 */
  0x8DD4,   /* U+43D2 */
  0x8DD5,   /* U+43D3 */
  0x8DD6,   /* U+43D4 */
  0x8DD7,   /* U+43D5 */
  0x8DD8,   /* U+43D6 */
  0x8DD9,   /* U+43D7 */
  0x8DDA,   /* U+43D8 */
  0x8DDB,   /* U+43D9 */
  0x8DDC,   /* U+43DA */
  0x8DDD,   /* U+43DB */
  0x8DDE,   /* U+43DC */
  0x8DDF,   /* U+43DD */
  0x90FD,   /* U+43DE */
  0x90FE,   /* U+43DF */
  0x90FF,   /* U+43E0 */
  0x9100,   /* U+43E1 */
  0x9101,   /* U+43E2 */
  0x9102,   /* U+43E3 */
  0x9103,   /* U+43E4 */
  0x9104,   /* U+43E5 */
  0x9396,   /* U+43E6 */
  0x9397,   /* U+43E7 */
  0x9398,   /* U+43E8 */
  0x9399,   /* U+43E9 */
  0x939A,   /* U+43EA */
  0x939B,   /* U+43EB */
  0x939C,   /* U+43EC */
  0x939D,   /* U+43ED */
  0x939E,   /* U+43EE */
  0x9480,   /* U+43EF */
  0x9481,   /* U+43F0 */
  0x9482,   /* U+43F1 */
  0x9483,   /* U+43F2 */
  0x9484,   /* U+43F3 */
  0x9485,   /* U+43F4 */
  0x9486,   /* U+43F5 */
  0x9487,   /* U+43F6 */
  0x9488,   /* U+43F7 */
  0x9489,   /* U+43F8 */
  0x948A,   /* U+43F9 */
  0x948B,   /* U+43FA */
  0x948C,   /* U+43FB */
  0x95D8,   /* U+43FC */
  0x95D9,   /* U+43FD */
  0x95DA,   /* U+43FE */
  0x95DB,   /* U+43FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4300 */
  0x0000,   /* U+4301 */
  0x0000,   /* U+4302 */
  0x0000,   /* U+4303 */
  0x0000,   /* U+4304 */
  0x0000,   /* U+4305 */
  0x0000,   /* U+4306 */
  0x0000,   /* U+4307 */
  0x0000,   /* U+4308 */
  0x0000,   /* U+4309 */
  0x0000,   /* U+430A */
  0x0000,   /* U+430B */
  0x0000,   /* U+430C */
  0x0000,   /* U+430D */
  0x0000,   /* U+430E */
  0x0000,   /* U+430F */
  0x0000,   /* U+4310 */
  0x0000,   /* U+4311 */
  0x0000,   /* U+4312 */
  0x0000,   /* U+4313 */
  0x0000,   /* U+4314 */
  0x0000,   /* U+4315 */
  0x0000,   /* U+4316 */
  0x0000,   /* U+4317 */
  0x0000,   /* U+4318 */
  0x0000,   /* U+4319 */
  0x0000,   /* U+431A */
  0x0000,   /* U+431B */
  0x0000,   /* U+431C */
  0x0000,   /* U+431D */
  0x0000,   /* U+431E */
  0x0000,   /* U+431F */
  0x0000,   /* U+4320 */
  0x0000,   /* U+4321 */
  0x0000,   /* U+4322 */
  0x0000,   /* U+4323 */
  0x0000,   /* U+4324 */
  0x0000,   /* U+4325 */
  0x0000,   /* U+4326 */
  0x0000,   /* U+4327 */
  0x0000,   /* U+4328 */
  0x0000,   /* U+4329 */
  0x0000,   /* U+432A */
  0x0000,   /* U+432B */
  0x0000,   /* U+432C */
  0x0000,   /* U+432D */
  0x0000,   /* U+432E */
  0x0000,   /* U+432F */
  0x0000,   /* U+4330 */
  0x0000,   /* U+4331 */
  0x0000,   /* U+4332 */
  0x0000,   /* U+4333 */
  0x0000,   /* U+4334 */
  0x0000,   /* U+4335 */
  0x0000,   /* U+4336 */
  0x0000,   /* U+4337 */
  0x0000,   /* U+4338 */
  0x0000,   /* U+4339 */
  0x0000,   /* U+433A */
  0x0000,   /* U+433B */
  0x0000,   /* U+433C */
  0x0000,   /* U+433D */
  0x0000,   /* U+433E */
  0x0000,   /* U+433F */
  0x0000,   /* U+4340 */
  0x0000,   /* U+4341 */
  0x0000,   /* U+4342 */
  0x0000,   /* U+4343 */
  0x0000,   /* U+4344 */
  0x0000,   /* U+4345 */
  0x0000,   /* U+4346 */
  0x0000,   /* U+4347 */
  0x0000,   /* U+4348 */
  0x0000,   /* U+4349 */
  0x0000,   /* U+434A */
  0x0000,   /* U+434B */
  0x0000,   /* U+434C */
  0x0000,   /* U+434D */
  0x0000,   /* U+434E */
  0x0000,   /* U+434F */
  0x0000,   /* U+4350 */
  0x0000,   /* U+4351 */
  0x0000,   /* U+4352 */
  0x0000,   /* U+4353 */
  0x0000,   /* U+4354 */
  0x0000,   /* U+4355 */
  0x0000,   /* U+4356 */
  0x0000,   /* U+4357 */
  0x0000,   /* U+4358 */
  0x0000,   /* U+4359 */
  0x0000,   /* U+435A */
  0x0000,   /* U+435B */
  0x0000,   /* U+435C */
  0x0000,   /* U+435D */
  0x0000,   /* U+435E */
  0x0000,   /* U+435F */
  0x0000,   /* U+4360 */
  0x0000,   /* U+4361 */
  0x0000,   /* U+4362 */
  0x0000,   /* U+4363 */
  0x0000,   /* U+4364 */
  0x0000,   /* U+4365 */
  0x0000,   /* U+4366 */
  0x0000,   /* U+4367 */
  0x0000,   /* U+4368 */
  0x0000,   /* U+4369 */
  0x0000,   /* U+436A */
  0x0000,   /* U+436B */
  0x0000,   /* U+436C */
  0x0000,   /* U+436D */
  0x0000,   /* U+436E */
  0x0000,   /* U+436F */
  0x0000,   /* U+4370 */
  0x0000,   /* U+4371 */
  0x0000,   /* U+4372 */
  0x0000,   /* U+4373 */
  0x0000,   /* U+4374 */
  0x0000,   /* U+4375 */
  0x0000,   /* U+4376 */
  0x0000,   /* U+4377 */
  0x0000,   /* U+4378 */
  0x0000,   /* U+4379 */
  0x0000,   /* U+437A */
  0x0000,   /* U+437B */
  0x0000,   /* U+437C */
  0x0000,   /* U+437D */
  0x0000,   /* U+437E */
  0x0000,   /* U+437F */
  0x0000,   /* U+4380 */
  0x0000,   /* U+4381 */
  0x0000,   /* U+4382 */
  0x0000,   /* U+4383 */
  0x0000,   /* U+4384 */
  0x0000,   /* U+4385 */
  0x0000,   /* U+4386 */
  0x0000,   /* U+4387 */
  0x0000,   /* U+4388 */
  0x0000,   /* U+4389 */
  0x0000,   /* U+438A */
  0x0000,   /* U+438B */
  0x0000,   /* U+438C */
  0x0000,   /* U+438D */
  0x0000,   /* U+438E */
  0x0000,   /* U+438F */
  0x0000,   /* U+4390 */
  0x0000,   /* U+4391 */
  0x0000,   /* U+4392 */
  0x0000,   /* U+4393 */
  0x0000,   /* U+4394 */
  0x0000,   /* U+4395 */
  0x0000,   /* U+4396 */
  0x0000,   /* U+4397 */
  0x0000,   /* U+4398 */
  0x0000,   /* U+4399 */
  0x0000,   /* U+439A */
  0x0000,   /* U+439B */
  0x0000,   /* U+439C */
  0x0000,   /* U+439D */
  0x0000,   /* U+439E */
  0x0000,   /* U+439F */
  0x0000,   /* U+43A0 */
  0x0000,   /* U+43A1 */
  0x0000,   /* U+43A2 */
  0x0000,   /* U+43A3 */
  0x0000,   /* U+43A4 */
  0x0000,   /* U+43A5 */
  0x0000,   /* U+43A6 */
  0x0000,   /* U+43A7 */
  0x0000,   /* U+43A8 */
  0x0000,   /* U+43A9 */
  0x0000,   /* U+43AA */
  0x0000,   /* U+43AB */
  0x0000,   /* U+43AC */
  0x0000,   /* U+43AD */
  0x0000,   /* U+43AE */
  0x0000,   /* U+43AF */
  0x0000,   /* U+43B0 */
  0x0000,   /* U+43B1 */
  0x0000,   /* U+43B2 */
  0x0000,   /* U+43B3 */
  0x0000,   /* U+43B4 */
  0x0000,   /* U+43B5 */
  0x0000,   /* U+43B6 */
  0x0000,   /* U+43B7 */
  0x0000,   /* U+43B8 */
  0x0000,   /* U+43B9 */
  0x0000,   /* U+43BA */
  0x0000,   /* U+43BB */
  0x0000,   /* U+43BC */
  0x0000,   /* U+43BD */
  0x0000,   /* U+43BE */
  0x0000,   /* U+43BF */
  0x0000,   /* U+43C0 */
  0x0000,   /* U+43C1 */
  0x0000,   /* U+43C2 */
  0x0000,   /* U+43C3 */
  0x0000,   /* U+43C4 */
  0x0000,   /* U+43C5 */
  0x0000,   /* U+43C6 */
  0x0000,   /* U+43C7 */
  0x0000,   /* U+43C8 */
  0x0000,   /* U+43C9 */
  0x0000,   /* U+43CA */
  0x0000,   /* U+43CB */
  0x0000,   /* U+43CC */
  0x0000,   /* U+43CD */
  0x0000,   /* U+43CE */
  0x0000,   /* U+43CF */
  0x0000,   /* U+43D0 */
  0x0000,   /* U+43D1 */
  0x0000,   /* U+43D2 */
  0x0000,   /* U+43D3 */
  0x0000,   /* U+43D4 */
  0x0000,   /* U+43D5 */
  0x0000,   /* U+43D6 */
  0x0000,   /* U+43D7 */
  0x0000,   /* U+43D8 */
  0x0000,   /* U+43D9 */
  0x0000,   /* U+43DA */
  0x0000,   /* U+43DB */
  0x0000,   /* U+43DC */
  0x0000,   /* U+43DD */
  0x0000,   /* U+43DE */
  0x0000,   /* U+43DF */
  0x0000,   /* U+43E0 */
  0x0000,   /* U+43E1 */
  0x0000,   /* U+43E2 */
  0x0000,   /* U+43E3 */
  0x0000,   /* U+43E4 */
  0x0000,   /* U+43E5 */
  0x0000,   /* U+43E6 */
  0x0000,   /* U+43E7 */
  0x0000,   /* U+43E8 */
  0x0000,   /* U+43E9 */
  0x0000,   /* U+43EA */
  0x0000,   /* U+43EB */
  0x0000,   /* U+43EC */
  0x0000,   /* U+43ED */
  0x0000,   /* U+43EE */
  0x0000,   /* U+43EF */
  0x0000,   /* U+43F0 */
  0x0000,   /* U+43F1 */
  0x0000,   /* U+43F2 */
  0x0000,   /* U+43F3 */
  0x0000,   /* U+43F4 */
  0x0000,   /* U+43F5 */
  0x0000,   /* U+43F6 */
  0x0000,   /* U+43F7 */
  0x0000,   /* U+43F8 */
  0x0000,   /* U+43F9 */
  0x0000,   /* U+43FA */
  0x0000,   /* U+43FB */
  0x0000,   /* U+43FC */
  0x0000,   /* U+43FD */
  0x0000,   /* U+43FE */
  0x0000,   /* U+43FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4300 */
  0x0000,   /* U+4301 */
  0x0000,   /* U+4302 */
  0x0000,   /* U+4303 */
  0x0000,   /* U+4304 */
  0x0000,   /* U+4305 */
  0x0000,   /* U+4306 */
  0x0000,   /* U+4307 */
  0x0000,   /* U+4308 */
  0x0000,   /* U+4309 */
  0x0000,   /* U+430A */
  0x0000,   /* U+430B */
  0x0000,   /* U+430C */
  0x0000,   /* U+430D */
  0x0000,   /* U+430E */
  0x0000,   /* U+430F */
  0x0000,   /* U+4310 */
  0x0000,   /* U+4311 */
  0x0000,   /* U+4312 */
  0x0000,   /* U+4313 */
  0x0000,   /* U+4314 */
  0x0000,   /* U+4315 */
  0x0000,   /* U+4316 */
  0x0000,   /* U+4317 */
  0x0000,   /* U+4318 */
  0x0000,   /* U+4319 */
  0x0000,   /* U+431A */
  0x0000,   /* U+431B */
  0x0000,   /* U+431C */
  0x0000,   /* U+431D */
  0x0000,   /* U+431E */
  0x0000,   /* U+431F */
  0x0000,   /* U+4320 */
  0x0000,   /* U+4321 */
  0x0000,   /* U+4322 */
  0x0000,   /* U+4323 */
  0x0000,   /* U+4324 */
  0x0000,   /* U+4325 */
  0x0000,   /* U+4326 */
  0x0000,   /* U+4327 */
  0x0000,   /* U+4328 */
  0x0000,   /* U+4329 */
  0x0000,   /* U+432A */
  0x0000,   /* U+432B */
  0x0000,   /* U+432C */
  0x0000,   /* U+432D */
  0x0000,   /* U+432E */
  0x0000,   /* U+432F */
  0x0000,   /* U+4330 */
  0x0000,   /* U+4331 */
  0x0000,   /* U+4332 */
  0x0000,   /* U+4333 */
  0x0000,   /* U+4334 */
  0x0000,   /* U+4335 */
  0x0000,   /* U+4336 */
  0x0000,   /* U+4337 */
  0x0000,   /* U+4338 */
  0x0000,   /* U+4339 */
  0x0000,   /* U+433A */
  0x0000,   /* U+433B */
  0x0000,   /* U+433C */
  0x0000,   /* U+433D */
  0x0000,   /* U+433E */
  0x0000,   /* U+433F */
  0x0000,   /* U+4340 */
  0x0000,   /* U+4341 */
  0x0000,   /* U+4342 */
  0x0000,   /* U+4343 */
  0x0000,   /* U+4344 */
  0x0000,   /* U+4345 */
  0x0000,   /* U+4346 */
  0x0000,   /* U+4347 */
  0x0000,   /* U+4348 */
  0x0000,   /* U+4349 */
  0x0000,   /* U+434A */
  0x0000,   /* U+434B */
  0x0000,   /* U+434C */
  0x0000,   /* U+434D */
  0x0000,   /* U+434E */
  0x0000,   /* U+434F */
  0x0000,   /* U+4350 */
  0x0000,   /* U+4351 */
  0x0000,   /* U+4352 */
  0x0000,   /* U+4353 */
  0x0000,   /* U+4354 */
  0x0000,   /* U+4355 */
  0x0000,   /* U+4356 */
  0x0000,   /* U+4357 */
  0x0000,   /* U+4358 */
  0x0000,   /* U+4359 */
  0x0000,   /* U+435A */
  0x0000,   /* U+435B */
  0x0000,   /* U+435C */
  0x0000,   /* U+435D */
  0x0000,   /* U+435E */
  0x0000,   /* U+435F */
  0x0000,   /* U+4360 */
  0x0000,   /* U+4361 */
  0x0000,   /* U+4362 */
  0x0000,   /* U+4363 */
  0x0000,   /* U+4364 */
  0x0000,   /* U+4365 */
  0x0000,   /* U+4366 */
  0x0000,   /* U+4367 */
  0x0000,   /* U+4368 */
  0x0000,   /* U+4369 */
  0x0000,   /* U+436A */
  0x0000,   /* U+436B */
  0x0000,   /* U+436C */
  0x0000,   /* U+436D */
  0x0000,   /* U+436E */
  0x0000,   /* U+436F */
  0x0000,   /* U+4370 */
  0x0000,   /* U+4371 */
  0x0000,   /* U+4372 */
  0x0000,   /* U+4373 */
  0x0000,   /* U+4374 */
  0x0000,   /* U+4375 */
  0x0000,   /* U+4376 */
  0x0000,   /* U+4377 */
  0x0000,   /* U+4378 */
  0x0000,   /* U+4379 */
  0x0000,   /* U+437A */
  0x0000,   /* U+437B */
  0x0000,   /* U+437C */
  0x0000,   /* U+437D */
  0x0000,   /* U+437E */
  0x0000,   /* U+437F */
  0x0000,   /* U+4380 */
  0x0000,   /* U+4381 */
  0x0000,   /* U+4382 */
  0x0000,   /* U+4383 */
  0x0000,   /* U+4384 */
  0x0000,   /* U+4385 */
  0x0000,   /* U+4386 */
  0x0000,   /* U+4387 */
  0x0000,   /* U+4388 */
  0x0000,   /* U+4389 */
  0x0000,   /* U+438A */
  0x0000,   /* U+438B */
  0x0000,   /* U+438C */
  0x0000,   /* U+438D */
  0x0000,   /* U+438E */
  0x0000,   /* U+438F */
  0x0000,   /* U+4390 */
  0x0000,   /* U+4391 */
  0x0000,   /* U+4392 */
  0x0000,   /* U+4393 */
  0x0000,   /* U+4394 */
  0x0000,   /* U+4395 */
  0x0000,   /* U+4396 */
  0x0000,   /* U+4397 */
  0x0000,   /* U+4398 */
  0x0000,   /* U+4399 */
  0x0000,   /* U+439A */
  0x0000,   /* U+439B */
  0x0000,   /* U+439C */
  0x0000,   /* U+439D */
  0x0000,   /* U+439E */
  0x0000,   /* U+439F */
  0x0000,   /* U+43A0 */
  0x0000,   /* U+43A1 */
  0x0000,   /* U+43A2 */
  0x0000,   /* U+43A3 */
  0x0000,   /* U+43A4 */
  0x0000,   /* U+43A5 */
  0x0000,   /* U+43A6 */
  0x0000,   /* U+43A7 */
  0x0000,   /* U+43A8 */
  0x0000,   /* U+43A9 */
  0x0000,   /* U+43AA */
  0x0000,   /* U+43AB */
  0x0000,   /* U+43AC */
  0x0000,   /* U+43AD */
  0x0000,   /* U+43AE */
  0x0000,   /* U+43AF */
  0x0000,   /* U+43B0 */
  0x0000,   /* U+43B1 */
  0x0000,   /* U+43B2 */
  0x0000,   /* U+43B3 */
  0x0000,   /* U+43B4 */
  0x0000,   /* U+43B5 */
  0x0000,   /* U+43B6 */
  0x0000,   /* U+43B7 */
  0x0000,   /* U+43B8 */
  0x0000,   /* U+43B9 */
  0x0000,   /* U+43BA */
  0x0000,   /* U+43BB */
  0x0000,   /* U+43BC */
  0x0000,   /* U+43BD */
  0x0000,   /* U+43BE */
  0x0000,   /* U+43BF */
  0x0000,   /* U+43C0 */
  0x0000,   /* U+43C1 */
  0x0000,   /* U+43C2 */
  0x0000,   /* U+43C3 */
  0x0000,   /* U+43C4 */
  0x0000,   /* U+43C5 */
  0x0000,   /* U+43C6 */
  0x0000,   /* U+43C7 */
  0x0000,   /* U+43C8 */
  0x0000,   /* U+43C9 */
  0x0000,   /* U+43CA */
  0x0000,   /* U+43CB */
  0x0000,   /* U+43CC */
  0x0000,   /* U+43CD */
  0x0000,   /* U+43CE */
  0x0000,   /* U+43CF */
  0x0000,   /* U+43D0 */
  0x0000,   /* U+43D1 */
  0x0000,   /* U+43D2 */
  0x0000,   /* U+43D3 */
  0x0000,   /* U+43D4 */
  0x0000,   /* U+43D5 */
  0x0000,   /* U+43D6 */
  0x0000,   /* U+43D7 */
  0x0000,   /* U+43D8 */
  0x0000,   /* U+43D9 */
  0x0000,   /* U+43DA */
  0x0000,   /* U+43DB */
  0x0000,   /* U+43DC */
  0x0000,   /* U+43DD */
  0x0000,   /* U+43DE */
  0x0000,   /* U+43DF */
  0x0000,   /* U+43E0 */
  0x0000,   /* U+43E1 */
  0x0000,   /* U+43E2 */
  0x0000,   /* U+43E3 */
  0x0000,   /* U+43E4 */
  0x0000,   /* U+43E5 */
  0x0000,   /* U+43E6 */
  0x0000,   /* U+43E7 */
  0x0000,   /* U+43E8 */
  0x0000,   /* U+43E9 */
  0x0000,   /* U+43EA */
  0x0000,   /* U+43EB */
  0x0000,   /* U+43EC */
  0x0000,   /* U+43ED */
  0x0000,   /* U+43EE */
  0x0000,   /* U+43EF */
  0x0000,   /* U+43F0 */
  0x0000,   /* U+43F1 */
  0x0000,   /* U+43F2 */
  0x0000,   /* U+43F3 */
  0x0000,   /* U+43F4 */
  0x0000,   /* U+43F5 */
  0x0000,   /* U+43F6 */
  0x0000,   /* U+43F7 */
  0x0000,   /* U+43F8 */
  0x0000,   /* U+43F9 */
  0x0000,   /* U+43FA */
  0x0000,   /* U+43FB */
  0x0000,   /* U+43FC */
  0x0000,   /* U+43FD */
  0x0000,   /* U+43FE */
  0x0000,   /* U+43FF */
};

uint16 zh3_han_p044[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C53,   /* U+4400 */
  0x1C53,   /* U+4401 */
  0x1C53,   /* U+4402 */
  0x1C53,   /* U+4403 */
  0x1C53,   /* U+4404 */
  0x1C53,   /* U+4405 */
  0x1C53,   /* U+4406 */
  0x1C53,   /* U+4407 */
  0x1C53,   /* U+4408 */
  0x1C53,   /* U+4409 */
  0x1C53,   /* U+440A */
  0x1C53,   /* U+440B */
  0x1C53,   /* U+440C */
  0x1C54,   /* U+440D */
  0x1C54,   /* U+440E */
  0x1C54,   /* U+440F */
  0x1C54,   /* U+4410 */
  0x1C54,   /* U+4411 */
  0x1C54,   /* U+4412 */
  0x1C54,   /* U+4413 */
  0x1C54,   /* U+4414 */
  0x1C54,   /* U+4415 */
  0x1C54,   /* U+4416 */
  0x1C54,   /* U+4417 */
  0x1C54,   /* U+4418 */
  0x1C54,   /* U+4419 */
  0x1C54,   /* U+441A */
  0x1C54,   /* U+441B */
  0x1C55,   /* U+441C */
  0x1C55,   /* U+441D */
  0x1C55,   /* U+441E */
  0x1C55,   /* U+441F */
  0x1C55,   /* U+4420 */
  0x1C57,   /* U+4421 */
  0x1C55,   /* U+4422 */
  0x1C55,   /* U+4423 */
  0x1C55,   /* U+4424 */
  0x1C55,   /* U+4425 */
  0x1C55,   /* U+4426 */
  0x1C55,   /* U+4427 */
  0x1C55,   /* U+4428 */
  0x1C55,   /* U+4429 */
  0x1C55,   /* U+442A */
  0x1C56,   /* U+442B */
  0x1C56,   /* U+442C */
  0x1C56,   /* U+442D */
  0x1C56,   /* U+442E */
  0x1C56,   /* U+442F */
  0x1C56,   /* U+4430 */
  0x1C56,   /* U+4431 */
  0x1C56,   /* U+4432 */
  0x1C56,   /* U+4433 */
  0x1C56,   /* U+4434 */
  0x1C57,   /* U+4435 */
  0x1C57,   /* U+4436 */
  0x1C57,   /* U+4437 */
  0x1C57,   /* U+4438 */
  0x1C57,   /* U+4439 */
  0x1C57,   /* U+443A */
  0x1C57,   /* U+443B */
  0x1C57,   /* U+443C */
  0x1C57,   /* U+443D */
  0x1C58,   /* U+443E */
  0x1C58,   /* U+443F */
  0x1C58,   /* U+4440 */
  0x1C58,   /* U+4441 */
  0x1C59,   /* U+4442 */
  0x1C59,   /* U+4443 */
  0x1C59,   /* U+4444 */
  0x1C59,   /* U+4445 */
  0x1C5A,   /* U+4446 */
  0x1C5A,   /* U+4447 */
  0x1C5A,   /* U+4448 */
  0x1C5B,   /* U+4449 */
  0x1C5B,   /* U+444A */
  0x1C5C,   /* U+444B */
  0x1C5C,   /* U+444C */
  0x1C5C,   /* U+444D */
  0x1C5C,   /* U+444E */
  0x1C5D,   /* U+444F */
  0x1C52,   /* U+4450 */
  0x1C59,   /* U+4451 */
  0x1C50,   /* U+4452 */
  0x1C54,   /* U+4453 */
  0x1C51,   /* U+4454 */
  0x1C52,   /* U+4455 */
  0x1C55,   /* U+4456 */
  0x1C56,   /* U+4457 */
  0x1C57,   /* U+4458 */
  0x1C51,   /* U+4459 */
  0x1C51,   /* U+445A */
  0x1C52,   /* U+445B */
  0x1C56,   /* U+445C */
  0x1C55,   /* U+445D */
  0x1C57,   /* U+445E */
  0x1C5C,   /* U+445F */
  0x1C4F,   /* U+4460 */
  0x1C50,   /* U+4461 */
  0x1C50,   /* U+4462 */
  0x1C50,   /* U+4463 */
  0x1C51,   /* U+4464 */
  0x1C51,   /* U+4465 */
  0x1C52,   /* U+4466 */
  0x1C52,   /* U+4467 */
  0x1C52,   /* U+4468 */
  0x1C52,   /* U+4469 */
  0x1C53,   /* U+446A */
  0x1C53,   /* U+446B */
  0x1C53,   /* U+446C */
  0x1C53,   /* U+446D */
  0x1C53,   /* U+446E */
  0x1C54,   /* U+446F */
  0x1C54,   /* U+4470 */
  0x1C55,   /* U+4471 */
  0x1C55,   /* U+4472 */
  0x1C55,   /* U+4473 */
  0x1C55,   /* U+4474 */
  0x1C55,   /* U+4475 */
  0x1C55,   /* U+4476 */
  0x1C55,   /* U+4477 */
  0x1C55,   /* U+4478 */
  0x1C56,   /* U+4479 */
  0x1C56,   /* U+447A */
  0x1C56,   /* U+447B */
  0x1C57,   /* U+447C */
  0x1C57,   /* U+447D */
  0x1C57,   /* U+447E */
  0x1C58,   /* U+447F */
  0x1C58,   /* U+4480 */
  0x1C58,   /* U+4481 */
  0x1C58,   /* U+4482 */
  0x1C58,   /* U+4483 */
  0x1C58,   /* U+4484 */
  0x1C58,   /* U+4485 */
  0x1C59,   /* U+4486 */
  0x1C59,   /* U+4487 */
  0x1C59,   /* U+4488 */
  0x1C5B,   /* U+4489 */
  0x1C50,   /* U+448A */
  0x1C52,   /* U+448B */
  0x1C57,   /* U+448C */
  0x1C57,   /* U+448D */
  0x1C59,   /* U+448E */
  0x1C59,   /* U+448F */
  0x1C5D,   /* U+4490 */
  0x1C4D,   /* U+4491 */
  0x1C4F,   /* U+4492 */
  0x1C4F,   /* U+4493 */
  0x1C4F,   /* U+4494 */
  0x1C50,   /* U+4495 */
  0x1C50,   /* U+4496 */
  0x1C50,   /* U+4497 */
  0x1C50,   /* U+4498 */
  0x1C50,   /* U+4499 */
  0x1C51,   /* U+449A */
  0x1C51,   /* U+449B */
  0x1C51,   /* U+449C */
  0x1C51,   /* U+449D */
  0x1C51,   /* U+449E */
  0x1C51,   /* U+449F */
  0x1C51,   /* U+44A0 */
  0x1C51,   /* U+44A1 */
  0x1C51,   /* U+44A2 */
  0x1C51,   /* U+44A3 */
  0x1C51,   /* U+44A4 */
  0x1C51,   /* U+44A5 */
  0x1C52,   /* U+44A6 */
  0x1C52,   /* U+44A7 */
  0x1C52,   /* U+44A8 */
  0x1C52,   /* U+44A9 */
  0x1C52,   /* U+44AA */
  0x1C52,   /* U+44AB */
  0x1C52,   /* U+44AC */
  0x1C52,   /* U+44AD */
  0x1C52,   /* U+44AE */
  0x1C52,   /* U+44AF */
  0x1C53,   /* U+44B0 */
  0x1C53,   /* U+44B1 */
  0x1C53,   /* U+44B2 */
  0x1C53,   /* U+44B3 */
  0x1C53,   /* U+44B4 */
  0x1C53,   /* U+44B5 */
  0x1C53,   /* U+44B6 */
  0x1C53,   /* U+44B7 */
  0x1C53,   /* U+44B8 */
  0x1C53,   /* U+44B9 */
  0x1C53,   /* U+44BA */
  0x1C53,   /* U+44BB */
  0x1C53,   /* U+44BC */
  0x1C53,   /* U+44BD */
  0x1C53,   /* U+44BE */
  0x1C53,   /* U+44BF */
  0x1C53,   /* U+44C0 */
  0x1C53,   /* U+44C1 */
  0x1C54,   /* U+44C2 */
  0x1C54,   /* U+44C3 */
  0x1C54,   /* U+44C4 */
  0x1C54,   /* U+44C5 */
  0x1C54,   /* U+44C6 */
  0x1C54,   /* U+44C7 */
  0x1C54,   /* U+44C8 */
  0x1C54,   /* U+44C9 */
  0x1C54,   /* U+44CA */
  0x1C54,   /* U+44CB */
  0x1C54,   /* U+44CC */
  0x1C54,   /* U+44CD */
  0x1C54,   /* U+44CE */
  0x1C54,   /* U+44CF */
  0x1C54,   /* U+44D0 */
  0x1C54,   /* U+44D1 */
  0x1C54,   /* U+44D2 */
  0x1C54,   /* U+44D3 */
  0x1C54,   /* U+44D4 */
  0x1C55,   /* U+44D5 */
  0x1C54,   /* U+44D6 */
  0x1C55,   /* U+44D7 */
  0x1C55,   /* U+44D8 */
  0x1C55,   /* U+44D9 */
  0x1C55,   /* U+44DA */
  0x1C55,   /* U+44DB */
  0x1C55,   /* U+44DC */
  0x1C55,   /* U+44DD */
  0x1C55,   /* U+44DE */
  0x1C55,   /* U+44DF */
  0x1C55,   /* U+44E0 */
  0x1C55,   /* U+44E1 */
  0x1C55,   /* U+44E2 */
  0x1C55,   /* U+44E3 */
  0x1C55,   /* U+44E4 */
  0x1C55,   /* U+44E5 */
  0x1C55,   /* U+44E6 */
  0x1C55,   /* U+44E7 */
  0x1C55,   /* U+44E8 */
  0x1C55,   /* U+44E9 */
  0x1C55,   /* U+44EA */
  0x1C55,   /* U+44EB */
  0x1C55,   /* U+44EC */
  0x1C55,   /* U+44ED */
  0x1C56,   /* U+44EE */
  0x1C56,   /* U+44EF */
  0x1C56,   /* U+44F0 */
  0x1C56,   /* U+44F1 */
  0x1C56,   /* U+44F2 */
  0x1C56,   /* U+44F3 */
  0x1C56,   /* U+44F4 */
  0x1C56,   /* U+44F5 */
  0x1C56,   /* U+44F6 */
  0x1C56,   /* U+44F7 */
  0x1C56,   /* U+44F8 */
  0x1C56,   /* U+44F9 */
  0x1C56,   /* U+44FA */
  0x1C56,   /* U+44FB */
  0x1C57,   /* U+44FC */
  0x1C57,   /* U+44FD */
  0x1C57,   /* U+44FE */
  0x1C57,   /* U+44FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4400 */
  0x0020,   /* U+4401 */
  0x0020,   /* U+4402 */
  0x0020,   /* U+4403 */
  0x0020,   /* U+4404 */
  0x0020,   /* U+4405 */
  0x0020,   /* U+4406 */
  0x0020,   /* U+4407 */
  0x0020,   /* U+4408 */
  0x0020,   /* U+4409 */
  0x0020,   /* U+440A */
  0x0020,   /* U+440B */
  0x0020,   /* U+440C */
  0x0020,   /* U+440D */
  0x0020,   /* U+440E */
  0x0020,   /* U+440F */
  0x0020,   /* U+4410 */
  0x0020,   /* U+4411 */
  0x0020,   /* U+4412 */
  0x0020,   /* U+4413 */
  0x0020,   /* U+4414 */
  0x0020,   /* U+4415 */
  0x0020,   /* U+4416 */
  0x0020,   /* U+4417 */
  0x0020,   /* U+4418 */
  0x0020,   /* U+4419 */
  0x0020,   /* U+441A */
  0x0020,   /* U+441B */
  0x0020,   /* U+441C */
  0x0020,   /* U+441D */
  0x0020,   /* U+441E */
  0x0020,   /* U+441F */
  0x0020,   /* U+4420 */
  0x0020,   /* U+4421 */
  0x0020,   /* U+4422 */
  0x0020,   /* U+4423 */
  0x0020,   /* U+4424 */
  0x0020,   /* U+4425 */
  0x0020,   /* U+4426 */
  0x0020,   /* U+4427 */
  0x0020,   /* U+4428 */
  0x0020,   /* U+4429 */
  0x0020,   /* U+442A */
  0x0020,   /* U+442B */
  0x0020,   /* U+442C */
  0x0020,   /* U+442D */
  0x0020,   /* U+442E */
  0x0020,   /* U+442F */
  0x0020,   /* U+4430 */
  0x0020,   /* U+4431 */
  0x0020,   /* U+4432 */
  0x0020,   /* U+4433 */
  0x0020,   /* U+4434 */
  0x0020,   /* U+4435 */
  0x0020,   /* U+4436 */
  0x0020,   /* U+4437 */
  0x0020,   /* U+4438 */
  0x0020,   /* U+4439 */
  0x0020,   /* U+443A */
  0x0020,   /* U+443B */
  0x0020,   /* U+443C */
  0x0020,   /* U+443D */
  0x0020,   /* U+443E */
  0x0020,   /* U+443F */
  0x0020,   /* U+4440 */
  0x0020,   /* U+4441 */
  0x0020,   /* U+4442 */
  0x0020,   /* U+4443 */
  0x0020,   /* U+4444 */
  0x0020,   /* U+4445 */
  0x0020,   /* U+4446 */
  0x0020,   /* U+4447 */
  0x0020,   /* U+4448 */
  0x0020,   /* U+4449 */
  0x0020,   /* U+444A */
  0x0020,   /* U+444B */
  0x0020,   /* U+444C */
  0x0020,   /* U+444D */
  0x0020,   /* U+444E */
  0x0020,   /* U+444F */
  0x0020,   /* U+4450 */
  0x0020,   /* U+4451 */
  0x0020,   /* U+4452 */
  0x0020,   /* U+4453 */
  0x0020,   /* U+4454 */
  0x0020,   /* U+4455 */
  0x0020,   /* U+4456 */
  0x0020,   /* U+4457 */
  0x0020,   /* U+4458 */
  0x0020,   /* U+4459 */
  0x0020,   /* U+445A */
  0x0020,   /* U+445B */
  0x0020,   /* U+445C */
  0x0020,   /* U+445D */
  0x0020,   /* U+445E */
  0x0020,   /* U+445F */
  0x0020,   /* U+4460 */
  0x0020,   /* U+4461 */
  0x0020,   /* U+4462 */
  0x0020,   /* U+4463 */
  0x0020,   /* U+4464 */
  0x0020,   /* U+4465 */
  0x0020,   /* U+4466 */
  0x0020,   /* U+4467 */
  0x0020,   /* U+4468 */
  0x0020,   /* U+4469 */
  0x0020,   /* U+446A */
  0x0020,   /* U+446B */
  0x0020,   /* U+446C */
  0x0020,   /* U+446D */
  0x0020,   /* U+446E */
  0x0020,   /* U+446F */
  0x0020,   /* U+4470 */
  0x0020,   /* U+4471 */
  0x0020,   /* U+4472 */
  0x0020,   /* U+4473 */
  0x0020,   /* U+4474 */
  0x0020,   /* U+4475 */
  0x0020,   /* U+4476 */
  0x0020,   /* U+4477 */
  0x0020,   /* U+4478 */
  0x0020,   /* U+4479 */
  0x0020,   /* U+447A */
  0x0020,   /* U+447B */
  0x0020,   /* U+447C */
  0x0020,   /* U+447D */
  0x0020,   /* U+447E */
  0x0020,   /* U+447F */
  0x0020,   /* U+4480 */
  0x0020,   /* U+4481 */
  0x0020,   /* U+4482 */
  0x0020,   /* U+4483 */
  0x0020,   /* U+4484 */
  0x0020,   /* U+4485 */
  0x0020,   /* U+4486 */
  0x0020,   /* U+4487 */
  0x0020,   /* U+4488 */
  0x0020,   /* U+4489 */
  0x0020,   /* U+448A */
  0x0020,   /* U+448B */
  0x0020,   /* U+448C */
  0x0020,   /* U+448D */
  0x0020,   /* U+448E */
  0x0020,   /* U+448F */
  0x0020,   /* U+4490 */
  0x0020,   /* U+4491 */
  0x0020,   /* U+4492 */
  0x0020,   /* U+4493 */
  0x0020,   /* U+4494 */
  0x0020,   /* U+4495 */
  0x0020,   /* U+4496 */
  0x0020,   /* U+4497 */
  0x0020,   /* U+4498 */
  0x0020,   /* U+4499 */
  0x0020,   /* U+449A */
  0x0020,   /* U+449B */
  0x0020,   /* U+449C */
  0x0020,   /* U+449D */
  0x0020,   /* U+449E */
  0x0020,   /* U+449F */
  0x0020,   /* U+44A0 */
  0x0020,   /* U+44A1 */
  0x0020,   /* U+44A2 */
  0x0020,   /* U+44A3 */
  0x0020,   /* U+44A4 */
  0x0020,   /* U+44A5 */
  0x0020,   /* U+44A6 */
  0x0020,   /* U+44A7 */
  0x0020,   /* U+44A8 */
  0x0020,   /* U+44A9 */
  0x0020,   /* U+44AA */
  0x0020,   /* U+44AB */
  0x0020,   /* U+44AC */
  0x0020,   /* U+44AD */
  0x0020,   /* U+44AE */
  0x0020,   /* U+44AF */
  0x0020,   /* U+44B0 */
  0x0020,   /* U+44B1 */
  0x0020,   /* U+44B2 */
  0x0020,   /* U+44B3 */
  0x0020,   /* U+44B4 */
  0x0020,   /* U+44B5 */
  0x0020,   /* U+44B6 */
  0x0020,   /* U+44B7 */
  0x0020,   /* U+44B8 */
  0x0020,   /* U+44B9 */
  0x0020,   /* U+44BA */
  0x0020,   /* U+44BB */
  0x0020,   /* U+44BC */
  0x0020,   /* U+44BD */
  0x0020,   /* U+44BE */
  0x0020,   /* U+44BF */
  0x0020,   /* U+44C0 */
  0x0020,   /* U+44C1 */
  0x0020,   /* U+44C2 */
  0x0020,   /* U+44C3 */
  0x0020,   /* U+44C4 */
  0x0020,   /* U+44C5 */
  0x0020,   /* U+44C6 */
  0x0020,   /* U+44C7 */
  0x0020,   /* U+44C8 */
  0x0020,   /* U+44C9 */
  0x0020,   /* U+44CA */
  0x0020,   /* U+44CB */
  0x0020,   /* U+44CC */
  0x0020,   /* U+44CD */
  0x0020,   /* U+44CE */
  0x0020,   /* U+44CF */
  0x0020,   /* U+44D0 */
  0x0020,   /* U+44D1 */
  0x0020,   /* U+44D2 */
  0x0020,   /* U+44D3 */
  0x0020,   /* U+44D4 */
  0x0020,   /* U+44D5 */
  0x0020,   /* U+44D6 */
  0x0020,   /* U+44D7 */
  0x0020,   /* U+44D8 */
  0x0020,   /* U+44D9 */
  0x0020,   /* U+44DA */
  0x0020,   /* U+44DB */
  0x0020,   /* U+44DC */
  0x0020,   /* U+44DD */
  0x0020,   /* U+44DE */
  0x0020,   /* U+44DF */
  0x0020,   /* U+44E0 */
  0x0020,   /* U+44E1 */
  0x0020,   /* U+44E2 */
  0x0020,   /* U+44E3 */
  0x0020,   /* U+44E4 */
  0x0020,   /* U+44E5 */
  0x0020,   /* U+44E6 */
  0x0020,   /* U+44E7 */
  0x0020,   /* U+44E8 */
  0x0020,   /* U+44E9 */
  0x0020,   /* U+44EA */
  0x0020,   /* U+44EB */
  0x0020,   /* U+44EC */
  0x0020,   /* U+44ED */
  0x0020,   /* U+44EE */
  0x0020,   /* U+44EF */
  0x0020,   /* U+44F0 */
  0x0020,   /* U+44F1 */
  0x0020,   /* U+44F2 */
  0x0020,   /* U+44F3 */
  0x0020,   /* U+44F4 */
  0x0020,   /* U+44F5 */
  0x0020,   /* U+44F6 */
  0x0020,   /* U+44F7 */
  0x0020,   /* U+44F8 */
  0x0020,   /* U+44F9 */
  0x0020,   /* U+44FA */
  0x0020,   /* U+44FB */
  0x0020,   /* U+44FC */
  0x0020,   /* U+44FD */
  0x0020,   /* U+44FE */
  0x0020,   /* U+44FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4400 */
  0x0002,   /* U+4401 */
  0x0002,   /* U+4402 */
  0x0002,   /* U+4403 */
  0x0002,   /* U+4404 */
  0x0002,   /* U+4405 */
  0x0002,   /* U+4406 */
  0x0002,   /* U+4407 */
  0x0002,   /* U+4408 */
  0x0002,   /* U+4409 */
  0x0002,   /* U+440A */
  0x0002,   /* U+440B */
  0x0002,   /* U+440C */
  0x0002,   /* U+440D */
  0x0002,   /* U+440E */
  0x0002,   /* U+440F */
  0x0002,   /* U+4410 */
  0x0002,   /* U+4411 */
  0x0002,   /* U+4412 */
  0x0002,   /* U+4413 */
  0x0002,   /* U+4414 */
  0x0002,   /* U+4415 */
  0x0002,   /* U+4416 */
  0x0002,   /* U+4417 */
  0x0002,   /* U+4418 */
  0x0002,   /* U+4419 */
  0x0002,   /* U+441A */
  0x0002,   /* U+441B */
  0x0002,   /* U+441C */
  0x0002,   /* U+441D */
  0x0002,   /* U+441E */
  0x0002,   /* U+441F */
  0x0002,   /* U+4420 */
  0x0002,   /* U+4421 */
  0x0002,   /* U+4422 */
  0x0002,   /* U+4423 */
  0x0002,   /* U+4424 */
  0x0002,   /* U+4425 */
  0x0002,   /* U+4426 */
  0x0002,   /* U+4427 */
  0x0002,   /* U+4428 */
  0x0002,   /* U+4429 */
  0x0002,   /* U+442A */
  0x0002,   /* U+442B */
  0x0002,   /* U+442C */
  0x0002,   /* U+442D */
  0x0002,   /* U+442E */
  0x0002,   /* U+442F */
  0x0002,   /* U+4430 */
  0x0002,   /* U+4431 */
  0x0002,   /* U+4432 */
  0x0002,   /* U+4433 */
  0x0002,   /* U+4434 */
  0x0002,   /* U+4435 */
  0x0002,   /* U+4436 */
  0x0002,   /* U+4437 */
  0x0002,   /* U+4438 */
  0x0002,   /* U+4439 */
  0x0002,   /* U+443A */
  0x0002,   /* U+443B */
  0x0002,   /* U+443C */
  0x0002,   /* U+443D */
  0x0002,   /* U+443E */
  0x0002,   /* U+443F */
  0x0002,   /* U+4440 */
  0x0002,   /* U+4441 */
  0x0002,   /* U+4442 */
  0x0002,   /* U+4443 */
  0x0002,   /* U+4444 */
  0x0002,   /* U+4445 */
  0x0002,   /* U+4446 */
  0x0002,   /* U+4447 */
  0x0002,   /* U+4448 */
  0x0002,   /* U+4449 */
  0x0002,   /* U+444A */
  0x0002,   /* U+444B */
  0x0002,   /* U+444C */
  0x0002,   /* U+444D */
  0x0002,   /* U+444E */
  0x0002,   /* U+444F */
  0x0002,   /* U+4450 */
  0x0002,   /* U+4451 */
  0x0002,   /* U+4452 */
  0x0002,   /* U+4453 */
  0x0002,   /* U+4454 */
  0x0002,   /* U+4455 */
  0x0002,   /* U+4456 */
  0x0002,   /* U+4457 */
  0x0002,   /* U+4458 */
  0x0002,   /* U+4459 */
  0x0002,   /* U+445A */
  0x0002,   /* U+445B */
  0x0002,   /* U+445C */
  0x0002,   /* U+445D */
  0x0002,   /* U+445E */
  0x0002,   /* U+445F */
  0x0002,   /* U+4460 */
  0x0002,   /* U+4461 */
  0x0002,   /* U+4462 */
  0x0002,   /* U+4463 */
  0x0002,   /* U+4464 */
  0x0002,   /* U+4465 */
  0x0002,   /* U+4466 */
  0x0002,   /* U+4467 */
  0x0002,   /* U+4468 */
  0x0002,   /* U+4469 */
  0x0002,   /* U+446A */
  0x0002,   /* U+446B */
  0x0002,   /* U+446C */
  0x0002,   /* U+446D */
  0x0002,   /* U+446E */
  0x0002,   /* U+446F */
  0x0002,   /* U+4470 */
  0x0002,   /* U+4471 */
  0x0002,   /* U+4472 */
  0x0002,   /* U+4473 */
  0x0002,   /* U+4474 */
  0x0002,   /* U+4475 */
  0x0002,   /* U+4476 */
  0x0002,   /* U+4477 */
  0x0002,   /* U+4478 */
  0x0002,   /* U+4479 */
  0x0002,   /* U+447A */
  0x0002,   /* U+447B */
  0x0002,   /* U+447C */
  0x0002,   /* U+447D */
  0x0002,   /* U+447E */
  0x0002,   /* U+447F */
  0x0002,   /* U+4480 */
  0x0002,   /* U+4481 */
  0x0002,   /* U+4482 */
  0x0002,   /* U+4483 */
  0x0002,   /* U+4484 */
  0x0002,   /* U+4485 */
  0x0002,   /* U+4486 */
  0x0002,   /* U+4487 */
  0x0002,   /* U+4488 */
  0x0002,   /* U+4489 */
  0x0002,   /* U+448A */
  0x0002,   /* U+448B */
  0x0002,   /* U+448C */
  0x0002,   /* U+448D */
  0x0002,   /* U+448E */
  0x0002,   /* U+448F */
  0x0002,   /* U+4490 */
  0x0002,   /* U+4491 */
  0x0002,   /* U+4492 */
  0x0002,   /* U+4493 */
  0x0002,   /* U+4494 */
  0x0002,   /* U+4495 */
  0x0002,   /* U+4496 */
  0x0002,   /* U+4497 */
  0x0002,   /* U+4498 */
  0x0002,   /* U+4499 */
  0x0002,   /* U+449A */
  0x0002,   /* U+449B */
  0x0002,   /* U+449C */
  0x0002,   /* U+449D */
  0x0002,   /* U+449E */
  0x0002,   /* U+449F */
  0x0002,   /* U+44A0 */
  0x0002,   /* U+44A1 */
  0x0002,   /* U+44A2 */
  0x0002,   /* U+44A3 */
  0x0002,   /* U+44A4 */
  0x0002,   /* U+44A5 */
  0x0002,   /* U+44A6 */
  0x0002,   /* U+44A7 */
  0x0002,   /* U+44A8 */
  0x0002,   /* U+44A9 */
  0x0002,   /* U+44AA */
  0x0002,   /* U+44AB */
  0x0002,   /* U+44AC */
  0x0002,   /* U+44AD */
  0x0002,   /* U+44AE */
  0x0002,   /* U+44AF */
  0x0002,   /* U+44B0 */
  0x0002,   /* U+44B1 */
  0x0002,   /* U+44B2 */
  0x0002,   /* U+44B3 */
  0x0002,   /* U+44B4 */
  0x0002,   /* U+44B5 */
  0x0002,   /* U+44B6 */
  0x0002,   /* U+44B7 */
  0x0002,   /* U+44B8 */
  0x0002,   /* U+44B9 */
  0x0002,   /* U+44BA */
  0x0002,   /* U+44BB */
  0x0002,   /* U+44BC */
  0x0002,   /* U+44BD */
  0x0002,   /* U+44BE */
  0x0002,   /* U+44BF */
  0x0002,   /* U+44C0 */
  0x0002,   /* U+44C1 */
  0x0002,   /* U+44C2 */
  0x0002,   /* U+44C3 */
  0x0002,   /* U+44C4 */
  0x0002,   /* U+44C5 */
  0x0002,   /* U+44C6 */
  0x0002,   /* U+44C7 */
  0x0002,   /* U+44C8 */
  0x0002,   /* U+44C9 */
  0x0002,   /* U+44CA */
  0x0002,   /* U+44CB */
  0x0002,   /* U+44CC */
  0x0002,   /* U+44CD */
  0x0002,   /* U+44CE */
  0x0002,   /* U+44CF */
  0x0002,   /* U+44D0 */
  0x0002,   /* U+44D1 */
  0x0002,   /* U+44D2 */
  0x0002,   /* U+44D3 */
  0x0002,   /* U+44D4 */
  0x0002,   /* U+44D5 */
  0x0002,   /* U+44D6 */
  0x0002,   /* U+44D7 */
  0x0002,   /* U+44D8 */
  0x0002,   /* U+44D9 */
  0x0002,   /* U+44DA */
  0x0002,   /* U+44DB */
  0x0002,   /* U+44DC */
  0x0002,   /* U+44DD */
  0x0002,   /* U+44DE */
  0x0002,   /* U+44DF */
  0x0002,   /* U+44E0 */
  0x0002,   /* U+44E1 */
  0x0002,   /* U+44E2 */
  0x0002,   /* U+44E3 */
  0x0002,   /* U+44E4 */
  0x0002,   /* U+44E5 */
  0x0002,   /* U+44E6 */
  0x0002,   /* U+44E7 */
  0x0002,   /* U+44E8 */
  0x0002,   /* U+44E9 */
  0x0002,   /* U+44EA */
  0x0002,   /* U+44EB */
  0x0002,   /* U+44EC */
  0x0002,   /* U+44ED */
  0x0002,   /* U+44EE */
  0x0002,   /* U+44EF */
  0x0002,   /* U+44F0 */
  0x0002,   /* U+44F1 */
  0x0002,   /* U+44F2 */
  0x0002,   /* U+44F3 */
  0x0002,   /* U+44F4 */
  0x0002,   /* U+44F5 */
  0x0002,   /* U+44F6 */
  0x0002,   /* U+44F7 */
  0x0002,   /* U+44F8 */
  0x0002,   /* U+44F9 */
  0x0002,   /* U+44FA */
  0x0002,   /* U+44FB */
  0x0002,   /* U+44FC */
  0x0002,   /* U+44FD */
  0x0002,   /* U+44FE */
  0x0002,   /* U+44FF */

  /* Primary weight 2 for each character. */
  0x95DC,   /* U+4400 */
  0x95DD,   /* U+4401 */
  0x95DE,   /* U+4402 */
  0x95DF,   /* U+4403 */
  0x95E0,   /* U+4404 */
  0x95E1,   /* U+4405 */
  0x95E2,   /* U+4406 */
  0x95E3,   /* U+4407 */
  0x95E4,   /* U+4408 */
  0x95E5,   /* U+4409 */
  0x95E6,   /* U+440A */
  0x95E7,   /* U+440B */
  0x95E8,   /* U+440C */
  0x93FD,   /* U+440D */
  0x93FE,   /* U+440E */
  0x93FF,   /* U+440F */
  0x9400,   /* U+4410 */
  0x9401,   /* U+4411 */
  0x9402,   /* U+4412 */
  0x9403,   /* U+4413 */
  0x9404,   /* U+4414 */
  0x9405,   /* U+4415 */
  0x9406,   /* U+4416 */
  0x9407,   /* U+4417 */
  0x9408,   /* U+4418 */
  0x9409,   /* U+4419 */
  0x940A,   /* U+441A */
  0x940B,   /* U+441B */
  0x92C9,   /* U+441C */
  0x92CA,   /* U+441D */
  0x92CB,   /* U+441E */
  0x92CC,   /* U+441F */
  0x92CD,   /* U+4420 */
  0x8E42,   /* U+4421 */
  0x92CE,   /* U+4422 */
  0x92CF,   /* U+4423 */
  0x92D0,   /* U+4424 */
  0x92D1,   /* U+4425 */
  0x92D2,   /* U+4426 */
  0x92D3,   /* U+4427 */
  0x92D4,   /* U+4428 */
  0x92D5,   /* U+4429 */
  0x92D6,   /* U+442A */
  0x9126,   /* U+442B */
  0x9127,   /* U+442C */
  0x9128,   /* U+442D */
  0x9129,   /* U+442E */
  0x912A,   /* U+442F */
  0x912B,   /* U+4430 */
  0x912C,   /* U+4431 */
  0x912D,   /* U+4432 */
  0x912E,   /* U+4433 */
  0x912F,   /* U+4434 */
  0x8E59,   /* U+4435 */
  0x8E5A,   /* U+4436 */
  0x8E5B,   /* U+4437 */
  0x8E5C,   /* U+4438 */
  0x8E5D,   /* U+4439 */
  0x8E5E,   /* U+443A */
  0x8E5F,   /* U+443B */
  0x8E60,   /* U+443C */
  0x8E61,   /* U+443D */
  0x8AB4,   /* U+443E */
  0x8AB5,   /* U+443F */
  0x8AB6,   /* U+4440 */
  0x8AB7,   /* U+4441 */
  0x88DB,   /* U+4442 */
  0x88DC,   /* U+4443 */
  0x88DD,   /* U+4444 */
  0x88DE,   /* U+4445 */
  0x8662,   /* U+4446 */
  0x8663,   /* U+4447 */
  0x8664,   /* U+4448 */
  0x84A0,   /* U+4449 */
  0x84A1,   /* U+444A */
  0x83BB,   /* U+444B */
  0x83BC,   /* U+444C */
  0x83BD,   /* U+444D */
  0x83BE,   /* U+444E */
  0x82A3,   /* U+444F */
  0x94D2,   /* U+4450 */
  0x8903,   /* U+4451 */
  0x914F,   /* U+4452 */
  0x946A,   /* U+4453 */
  0x9400,   /* U+4454 */
  0x94E7,   /* U+4455 */
  0x9346,   /* U+4456 */
  0x9183,   /* U+4457 */
  0x8ECA,   /* U+4458 */
  0x940C,   /* U+4459 */
  0x940D,   /* U+445A */
  0x94F0,   /* U+445B */
  0x9194,   /* U+445C */
  0x9363,   /* U+445D */
  0x8EDB,   /* U+445E */
  0x83CF,   /* U+445F */
  0x8E25,   /* U+4460 */
  0x9163,   /* U+4461 */
  0x9164,   /* U+4462 */
  0x9165,   /* U+4463 */
  0x9426,   /* U+4464 */
  0x9427,   /* U+4465 */
  0x9506,   /* U+4466 */
  0x9507,   /* U+4467 */
  0x9508,   /* U+4468 */
  0x9509,   /* U+4469 */
  0x968C,   /* U+446A */
  0x968D,   /* U+446B */
  0x968E,   /* U+446C */
  0x968F,   /* U+446D */
  0x9690,   /* U+446E */
  0x948F,   /* U+446F */
  0x9490,   /* U+4470 */
  0x9368,   /* U+4471 */
  0x9369,   /* U+4472 */
  0x936A,   /* U+4473 */
  0x936B,   /* U+4474 */
  0x936C,   /* U+4475 */
  0x936D,   /* U+4476 */
  0x936E,   /* U+4477 */
  0x936F,   /* U+4478 */
  0x91AE,   /* U+4479 */
  0x91AF,   /* U+447A */
  0x91B0,   /* U+447B */
  0x8EE1,   /* U+447C */
  0x8EE2,   /* U+447D */
  0x8EE3,   /* U+447E */
  0x8B10,   /* U+447F */
  0x8B11,   /* U+4480 */
  0x8B12,   /* U+4481 */
  0x8B13,   /* U+4482 */
  0x8B14,   /* U+4483 */
  0x8B15,   /* U+4484 */
  0x8B16,   /* U+4485 */
  0x891F,   /* U+4486 */
  0x8920,   /* U+4487 */
  0x8921,   /* U+4488 */
  0x84D3,   /* U+4489 */
  0x9171,   /* U+448A */
  0x9521,   /* U+448B */
  0x8EF9,   /* U+448C */
  0x8EFA,   /* U+448D */
  0x893B,   /* U+448E */
  0x893C,   /* U+448F */
  0x82BF,   /* U+4490 */
  0x8619,   /* U+4491 */
  0x8E2F,   /* U+4492 */
  0x8E30,   /* U+4493 */
  0x8E31,   /* U+4494 */
  0x9174,   /* U+4495 */
  0x9175,   /* U+4496 */
  0x9176,   /* U+4497 */
  0x9177,   /* U+4498 */
  0x9178,   /* U+4499 */
  0x943A,   /* U+449A */
  0x943B,   /* U+449B */
  0x943C,   /* U+449C */
  0x943D,   /* U+449D */
  0x943E,   /* U+449E */
  0x943F,   /* U+449F */
  0x9440,   /* U+44A0 */
  0x9441,   /* U+44A1 */
  0x9442,   /* U+44A2 */
  0x9443,   /* U+44A3 */
  0x9444,   /* U+44A4 */
  0x9445,   /* U+44A5 */
  0x952A,   /* U+44A6 */
  0x952B,   /* U+44A7 */
  0x952C,   /* U+44A8 */
  0x952D,   /* U+44A9 */
  0x952E,   /* U+44AA */
  0x952F,   /* U+44AB */
  0x9530,   /* U+44AC */
  0x9531,   /* U+44AD */
  0x9532,   /* U+44AE */
  0x9533,   /* U+44AF */
  0x96AA,   /* U+44B0 */
  0x96AB,   /* U+44B1 */
  0x96AC,   /* U+44B2 */
  0x96AD,   /* U+44B3 */
  0x96AE,   /* U+44B4 */
  0x96AF,   /* U+44B5 */
  0x96B0,   /* U+44B6 */
  0x96B1,   /* U+44B7 */
  0x96B2,   /* U+44B8 */
  0x96B3,   /* U+44B9 */
  0x96B4,   /* U+44BA */
  0x96B5,   /* U+44BB */
  0x96B6,   /* U+44BC */
  0x96B7,   /* U+44BD */
  0x96B8,   /* U+44BE */
  0x96B9,   /* U+44BF */
  0x96BA,   /* U+44C0 */
  0x96BB,   /* U+44C1 */
  0x94AB,   /* U+44C2 */
  0x94AC,   /* U+44C3 */
  0x94AD,   /* U+44C4 */
  0x94AE,   /* U+44C5 */
  0x94AF,   /* U+44C6 */
  0x94B0,   /* U+44C7 */
  0x94B1,   /* U+44C8 */
  0x94B2,   /* U+44C9 */
  0x94B3,   /* U+44CA */
  0x94B4,   /* U+44CB */
  0x94B5,   /* U+44CC */
  0x94B6,   /* U+44CD */
  0x94B7,   /* U+44CE */
  0x94B8,   /* U+44CF */
  0x94B9,   /* U+44D0 */
  0x94BA,   /* U+44D1 */
  0x94BB,   /* U+44D2 */
  0x94BC,   /* U+44D3 */
  0x94BD,   /* U+44D4 */
  0x9393,   /* U+44D5 */
  0x94BE,   /* U+44D6 */
  0x9394,   /* U+44D7 */
  0x9395,   /* U+44D8 */
  0x9396,   /* U+44D9 */
  0x9397,   /* U+44DA */
  0x9398,   /* U+44DB */
  0x9399,   /* U+44DC */
  0x939A,   /* U+44DD */
  0x939B,   /* U+44DE */
  0x939C,   /* U+44DF */
  0x939D,   /* U+44E0 */
  0x939E,   /* U+44E1 */
  0x939F,   /* U+44E2 */
  0x93A0,   /* U+44E3 */
  0x93A1,   /* U+44E4 */
  0x93A2,   /* U+44E5 */
  0x93A3,   /* U+44E6 */
  0x93A4,   /* U+44E7 */
  0x93A5,   /* U+44E8 */
  0x93A6,   /* U+44E9 */
  0x93A7,   /* U+44EA */
  0x93A8,   /* U+44EB */
  0x93A9,   /* U+44EC */
  0x93AA,   /* U+44ED */
  0x91D8,   /* U+44EE */
  0x91D9,   /* U+44EF */
  0x91DA,   /* U+44F0 */
  0x91DB,   /* U+44F1 */
  0x91DC,   /* U+44F2 */
  0x91DD,   /* U+44F3 */
  0x91DE,   /* U+44F4 */
  0x91DF,   /* U+44F5 */
  0x91E0,   /* U+44F6 */
  0x91E1,   /* U+44F7 */
  0x91E2,   /* U+44F8 */
  0x91E3,   /* U+44F9 */
  0x91E4,   /* U+44FA */
  0x91E5,   /* U+44FB */
  0x8F03,   /* U+44FC */
  0x8F04,   /* U+44FD */
  0x8F05,   /* U+44FE */
  0x8F06,   /* U+44FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4400 */
  0x0000,   /* U+4401 */
  0x0000,   /* U+4402 */
  0x0000,   /* U+4403 */
  0x0000,   /* U+4404 */
  0x0000,   /* U+4405 */
  0x0000,   /* U+4406 */
  0x0000,   /* U+4407 */
  0x0000,   /* U+4408 */
  0x0000,   /* U+4409 */
  0x0000,   /* U+440A */
  0x0000,   /* U+440B */
  0x0000,   /* U+440C */
  0x0000,   /* U+440D */
  0x0000,   /* U+440E */
  0x0000,   /* U+440F */
  0x0000,   /* U+4410 */
  0x0000,   /* U+4411 */
  0x0000,   /* U+4412 */
  0x0000,   /* U+4413 */
  0x0000,   /* U+4414 */
  0x0000,   /* U+4415 */
  0x0000,   /* U+4416 */
  0x0000,   /* U+4417 */
  0x0000,   /* U+4418 */
  0x0000,   /* U+4419 */
  0x0000,   /* U+441A */
  0x0000,   /* U+441B */
  0x0000,   /* U+441C */
  0x0000,   /* U+441D */
  0x0000,   /* U+441E */
  0x0000,   /* U+441F */
  0x0000,   /* U+4420 */
  0x0000,   /* U+4421 */
  0x0000,   /* U+4422 */
  0x0000,   /* U+4423 */
  0x0000,   /* U+4424 */
  0x0000,   /* U+4425 */
  0x0000,   /* U+4426 */
  0x0000,   /* U+4427 */
  0x0000,   /* U+4428 */
  0x0000,   /* U+4429 */
  0x0000,   /* U+442A */
  0x0000,   /* U+442B */
  0x0000,   /* U+442C */
  0x0000,   /* U+442D */
  0x0000,   /* U+442E */
  0x0000,   /* U+442F */
  0x0000,   /* U+4430 */
  0x0000,   /* U+4431 */
  0x0000,   /* U+4432 */
  0x0000,   /* U+4433 */
  0x0000,   /* U+4434 */
  0x0000,   /* U+4435 */
  0x0000,   /* U+4436 */
  0x0000,   /* U+4437 */
  0x0000,   /* U+4438 */
  0x0000,   /* U+4439 */
  0x0000,   /* U+443A */
  0x0000,   /* U+443B */
  0x0000,   /* U+443C */
  0x0000,   /* U+443D */
  0x0000,   /* U+443E */
  0x0000,   /* U+443F */
  0x0000,   /* U+4440 */
  0x0000,   /* U+4441 */
  0x0000,   /* U+4442 */
  0x0000,   /* U+4443 */
  0x0000,   /* U+4444 */
  0x0000,   /* U+4445 */
  0x0000,   /* U+4446 */
  0x0000,   /* U+4447 */
  0x0000,   /* U+4448 */
  0x0000,   /* U+4449 */
  0x0000,   /* U+444A */
  0x0000,   /* U+444B */
  0x0000,   /* U+444C */
  0x0000,   /* U+444D */
  0x0000,   /* U+444E */
  0x0000,   /* U+444F */
  0x0000,   /* U+4450 */
  0x0000,   /* U+4451 */
  0x0000,   /* U+4452 */
  0x0000,   /* U+4453 */
  0x0000,   /* U+4454 */
  0x0000,   /* U+4455 */
  0x0000,   /* U+4456 */
  0x0000,   /* U+4457 */
  0x0000,   /* U+4458 */
  0x0000,   /* U+4459 */
  0x0000,   /* U+445A */
  0x0000,   /* U+445B */
  0x0000,   /* U+445C */
  0x0000,   /* U+445D */
  0x0000,   /* U+445E */
  0x0000,   /* U+445F */
  0x0000,   /* U+4460 */
  0x0000,   /* U+4461 */
  0x0000,   /* U+4462 */
  0x0000,   /* U+4463 */
  0x0000,   /* U+4464 */
  0x0000,   /* U+4465 */
  0x0000,   /* U+4466 */
  0x0000,   /* U+4467 */
  0x0000,   /* U+4468 */
  0x0000,   /* U+4469 */
  0x0000,   /* U+446A */
  0x0000,   /* U+446B */
  0x0000,   /* U+446C */
  0x0000,   /* U+446D */
  0x0000,   /* U+446E */
  0x0000,   /* U+446F */
  0x0000,   /* U+4470 */
  0x0000,   /* U+4471 */
  0x0000,   /* U+4472 */
  0x0000,   /* U+4473 */
  0x0000,   /* U+4474 */
  0x0000,   /* U+4475 */
  0x0000,   /* U+4476 */
  0x0000,   /* U+4477 */
  0x0000,   /* U+4478 */
  0x0000,   /* U+4479 */
  0x0000,   /* U+447A */
  0x0000,   /* U+447B */
  0x0000,   /* U+447C */
  0x0000,   /* U+447D */
  0x0000,   /* U+447E */
  0x0000,   /* U+447F */
  0x0000,   /* U+4480 */
  0x0000,   /* U+4481 */
  0x0000,   /* U+4482 */
  0x0000,   /* U+4483 */
  0x0000,   /* U+4484 */
  0x0000,   /* U+4485 */
  0x0000,   /* U+4486 */
  0x0000,   /* U+4487 */
  0x0000,   /* U+4488 */
  0x0000,   /* U+4489 */
  0x0000,   /* U+448A */
  0x0000,   /* U+448B */
  0x0000,   /* U+448C */
  0x0000,   /* U+448D */
  0x0000,   /* U+448E */
  0x0000,   /* U+448F */
  0x0000,   /* U+4490 */
  0x0000,   /* U+4491 */
  0x0000,   /* U+4492 */
  0x0000,   /* U+4493 */
  0x0000,   /* U+4494 */
  0x0000,   /* U+4495 */
  0x0000,   /* U+4496 */
  0x0000,   /* U+4497 */
  0x0000,   /* U+4498 */
  0x0000,   /* U+4499 */
  0x0000,   /* U+449A */
  0x0000,   /* U+449B */
  0x0000,   /* U+449C */
  0x0000,   /* U+449D */
  0x0000,   /* U+449E */
  0x0000,   /* U+449F */
  0x0000,   /* U+44A0 */
  0x0000,   /* U+44A1 */
  0x0000,   /* U+44A2 */
  0x0000,   /* U+44A3 */
  0x0000,   /* U+44A4 */
  0x0000,   /* U+44A5 */
  0x0000,   /* U+44A6 */
  0x0000,   /* U+44A7 */
  0x0000,   /* U+44A8 */
  0x0000,   /* U+44A9 */
  0x0000,   /* U+44AA */
  0x0000,   /* U+44AB */
  0x0000,   /* U+44AC */
  0x0000,   /* U+44AD */
  0x0000,   /* U+44AE */
  0x0000,   /* U+44AF */
  0x0000,   /* U+44B0 */
  0x0000,   /* U+44B1 */
  0x0000,   /* U+44B2 */
  0x0000,   /* U+44B3 */
  0x0000,   /* U+44B4 */
  0x0000,   /* U+44B5 */
  0x0000,   /* U+44B6 */
  0x0000,   /* U+44B7 */
  0x0000,   /* U+44B8 */
  0x0000,   /* U+44B9 */
  0x0000,   /* U+44BA */
  0x0000,   /* U+44BB */
  0x0000,   /* U+44BC */
  0x0000,   /* U+44BD */
  0x0000,   /* U+44BE */
  0x0000,   /* U+44BF */
  0x0000,   /* U+44C0 */
  0x0000,   /* U+44C1 */
  0x0000,   /* U+44C2 */
  0x0000,   /* U+44C3 */
  0x0000,   /* U+44C4 */
  0x0000,   /* U+44C5 */
  0x0000,   /* U+44C6 */
  0x0000,   /* U+44C7 */
  0x0000,   /* U+44C8 */
  0x0000,   /* U+44C9 */
  0x0000,   /* U+44CA */
  0x0000,   /* U+44CB */
  0x0000,   /* U+44CC */
  0x0000,   /* U+44CD */
  0x0000,   /* U+44CE */
  0x0000,   /* U+44CF */
  0x0000,   /* U+44D0 */
  0x0000,   /* U+44D1 */
  0x0000,   /* U+44D2 */
  0x0000,   /* U+44D3 */
  0x0000,   /* U+44D4 */
  0x0000,   /* U+44D5 */
  0x0000,   /* U+44D6 */
  0x0000,   /* U+44D7 */
  0x0000,   /* U+44D8 */
  0x0000,   /* U+44D9 */
  0x0000,   /* U+44DA */
  0x0000,   /* U+44DB */
  0x0000,   /* U+44DC */
  0x0000,   /* U+44DD */
  0x0000,   /* U+44DE */
  0x0000,   /* U+44DF */
  0x0000,   /* U+44E0 */
  0x0000,   /* U+44E1 */
  0x0000,   /* U+44E2 */
  0x0000,   /* U+44E3 */
  0x0000,   /* U+44E4 */
  0x0000,   /* U+44E5 */
  0x0000,   /* U+44E6 */
  0x0000,   /* U+44E7 */
  0x0000,   /* U+44E8 */
  0x0000,   /* U+44E9 */
  0x0000,   /* U+44EA */
  0x0000,   /* U+44EB */
  0x0000,   /* U+44EC */
  0x0000,   /* U+44ED */
  0x0000,   /* U+44EE */
  0x0000,   /* U+44EF */
  0x0000,   /* U+44F0 */
  0x0000,   /* U+44F1 */
  0x0000,   /* U+44F2 */
  0x0000,   /* U+44F3 */
  0x0000,   /* U+44F4 */
  0x0000,   /* U+44F5 */
  0x0000,   /* U+44F6 */
  0x0000,   /* U+44F7 */
  0x0000,   /* U+44F8 */
  0x0000,   /* U+44F9 */
  0x0000,   /* U+44FA */
  0x0000,   /* U+44FB */
  0x0000,   /* U+44FC */
  0x0000,   /* U+44FD */
  0x0000,   /* U+44FE */
  0x0000,   /* U+44FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4400 */
  0x0000,   /* U+4401 */
  0x0000,   /* U+4402 */
  0x0000,   /* U+4403 */
  0x0000,   /* U+4404 */
  0x0000,   /* U+4405 */
  0x0000,   /* U+4406 */
  0x0000,   /* U+4407 */
  0x0000,   /* U+4408 */
  0x0000,   /* U+4409 */
  0x0000,   /* U+440A */
  0x0000,   /* U+440B */
  0x0000,   /* U+440C */
  0x0000,   /* U+440D */
  0x0000,   /* U+440E */
  0x0000,   /* U+440F */
  0x0000,   /* U+4410 */
  0x0000,   /* U+4411 */
  0x0000,   /* U+4412 */
  0x0000,   /* U+4413 */
  0x0000,   /* U+4414 */
  0x0000,   /* U+4415 */
  0x0000,   /* U+4416 */
  0x0000,   /* U+4417 */
  0x0000,   /* U+4418 */
  0x0000,   /* U+4419 */
  0x0000,   /* U+441A */
  0x0000,   /* U+441B */
  0x0000,   /* U+441C */
  0x0000,   /* U+441D */
  0x0000,   /* U+441E */
  0x0000,   /* U+441F */
  0x0000,   /* U+4420 */
  0x0000,   /* U+4421 */
  0x0000,   /* U+4422 */
  0x0000,   /* U+4423 */
  0x0000,   /* U+4424 */
  0x0000,   /* U+4425 */
  0x0000,   /* U+4426 */
  0x0000,   /* U+4427 */
  0x0000,   /* U+4428 */
  0x0000,   /* U+4429 */
  0x0000,   /* U+442A */
  0x0000,   /* U+442B */
  0x0000,   /* U+442C */
  0x0000,   /* U+442D */
  0x0000,   /* U+442E */
  0x0000,   /* U+442F */
  0x0000,   /* U+4430 */
  0x0000,   /* U+4431 */
  0x0000,   /* U+4432 */
  0x0000,   /* U+4433 */
  0x0000,   /* U+4434 */
  0x0000,   /* U+4435 */
  0x0000,   /* U+4436 */
  0x0000,   /* U+4437 */
  0x0000,   /* U+4438 */
  0x0000,   /* U+4439 */
  0x0000,   /* U+443A */
  0x0000,   /* U+443B */
  0x0000,   /* U+443C */
  0x0000,   /* U+443D */
  0x0000,   /* U+443E */
  0x0000,   /* U+443F */
  0x0000,   /* U+4440 */
  0x0000,   /* U+4441 */
  0x0000,   /* U+4442 */
  0x0000,   /* U+4443 */
  0x0000,   /* U+4444 */
  0x0000,   /* U+4445 */
  0x0000,   /* U+4446 */
  0x0000,   /* U+4447 */
  0x0000,   /* U+4448 */
  0x0000,   /* U+4449 */
  0x0000,   /* U+444A */
  0x0000,   /* U+444B */
  0x0000,   /* U+444C */
  0x0000,   /* U+444D */
  0x0000,   /* U+444E */
  0x0000,   /* U+444F */
  0x0000,   /* U+4450 */
  0x0000,   /* U+4451 */
  0x0000,   /* U+4452 */
  0x0000,   /* U+4453 */
  0x0000,   /* U+4454 */
  0x0000,   /* U+4455 */
  0x0000,   /* U+4456 */
  0x0000,   /* U+4457 */
  0x0000,   /* U+4458 */
  0x0000,   /* U+4459 */
  0x0000,   /* U+445A */
  0x0000,   /* U+445B */
  0x0000,   /* U+445C */
  0x0000,   /* U+445D */
  0x0000,   /* U+445E */
  0x0000,   /* U+445F */
  0x0000,   /* U+4460 */
  0x0000,   /* U+4461 */
  0x0000,   /* U+4462 */
  0x0000,   /* U+4463 */
  0x0000,   /* U+4464 */
  0x0000,   /* U+4465 */
  0x0000,   /* U+4466 */
  0x0000,   /* U+4467 */
  0x0000,   /* U+4468 */
  0x0000,   /* U+4469 */
  0x0000,   /* U+446A */
  0x0000,   /* U+446B */
  0x0000,   /* U+446C */
  0x0000,   /* U+446D */
  0x0000,   /* U+446E */
  0x0000,   /* U+446F */
  0x0000,   /* U+4470 */
  0x0000,   /* U+4471 */
  0x0000,   /* U+4472 */
  0x0000,   /* U+4473 */
  0x0000,   /* U+4474 */
  0x0000,   /* U+4475 */
  0x0000,   /* U+4476 */
  0x0000,   /* U+4477 */
  0x0000,   /* U+4478 */
  0x0000,   /* U+4479 */
  0x0000,   /* U+447A */
  0x0000,   /* U+447B */
  0x0000,   /* U+447C */
  0x0000,   /* U+447D */
  0x0000,   /* U+447E */
  0x0000,   /* U+447F */
  0x0000,   /* U+4480 */
  0x0000,   /* U+4481 */
  0x0000,   /* U+4482 */
  0x0000,   /* U+4483 */
  0x0000,   /* U+4484 */
  0x0000,   /* U+4485 */
  0x0000,   /* U+4486 */
  0x0000,   /* U+4487 */
  0x0000,   /* U+4488 */
  0x0000,   /* U+4489 */
  0x0000,   /* U+448A */
  0x0000,   /* U+448B */
  0x0000,   /* U+448C */
  0x0000,   /* U+448D */
  0x0000,   /* U+448E */
  0x0000,   /* U+448F */
  0x0000,   /* U+4490 */
  0x0000,   /* U+4491 */
  0x0000,   /* U+4492 */
  0x0000,   /* U+4493 */
  0x0000,   /* U+4494 */
  0x0000,   /* U+4495 */
  0x0000,   /* U+4496 */
  0x0000,   /* U+4497 */
  0x0000,   /* U+4498 */
  0x0000,   /* U+4499 */
  0x0000,   /* U+449A */
  0x0000,   /* U+449B */
  0x0000,   /* U+449C */
  0x0000,   /* U+449D */
  0x0000,   /* U+449E */
  0x0000,   /* U+449F */
  0x0000,   /* U+44A0 */
  0x0000,   /* U+44A1 */
  0x0000,   /* U+44A2 */
  0x0000,   /* U+44A3 */
  0x0000,   /* U+44A4 */
  0x0000,   /* U+44A5 */
  0x0000,   /* U+44A6 */
  0x0000,   /* U+44A7 */
  0x0000,   /* U+44A8 */
  0x0000,   /* U+44A9 */
  0x0000,   /* U+44AA */
  0x0000,   /* U+44AB */
  0x0000,   /* U+44AC */
  0x0000,   /* U+44AD */
  0x0000,   /* U+44AE */
  0x0000,   /* U+44AF */
  0x0000,   /* U+44B0 */
  0x0000,   /* U+44B1 */
  0x0000,   /* U+44B2 */
  0x0000,   /* U+44B3 */
  0x0000,   /* U+44B4 */
  0x0000,   /* U+44B5 */
  0x0000,   /* U+44B6 */
  0x0000,   /* U+44B7 */
  0x0000,   /* U+44B8 */
  0x0000,   /* U+44B9 */
  0x0000,   /* U+44BA */
  0x0000,   /* U+44BB */
  0x0000,   /* U+44BC */
  0x0000,   /* U+44BD */
  0x0000,   /* U+44BE */
  0x0000,   /* U+44BF */
  0x0000,   /* U+44C0 */
  0x0000,   /* U+44C1 */
  0x0000,   /* U+44C2 */
  0x0000,   /* U+44C3 */
  0x0000,   /* U+44C4 */
  0x0000,   /* U+44C5 */
  0x0000,   /* U+44C6 */
  0x0000,   /* U+44C7 */
  0x0000,   /* U+44C8 */
  0x0000,   /* U+44C9 */
  0x0000,   /* U+44CA */
  0x0000,   /* U+44CB */
  0x0000,   /* U+44CC */
  0x0000,   /* U+44CD */
  0x0000,   /* U+44CE */
  0x0000,   /* U+44CF */
  0x0000,   /* U+44D0 */
  0x0000,   /* U+44D1 */
  0x0000,   /* U+44D2 */
  0x0000,   /* U+44D3 */
  0x0000,   /* U+44D4 */
  0x0000,   /* U+44D5 */
  0x0000,   /* U+44D6 */
  0x0000,   /* U+44D7 */
  0x0000,   /* U+44D8 */
  0x0000,   /* U+44D9 */
  0x0000,   /* U+44DA */
  0x0000,   /* U+44DB */
  0x0000,   /* U+44DC */
  0x0000,   /* U+44DD */
  0x0000,   /* U+44DE */
  0x0000,   /* U+44DF */
  0x0000,   /* U+44E0 */
  0x0000,   /* U+44E1 */
  0x0000,   /* U+44E2 */
  0x0000,   /* U+44E3 */
  0x0000,   /* U+44E4 */
  0x0000,   /* U+44E5 */
  0x0000,   /* U+44E6 */
  0x0000,   /* U+44E7 */
  0x0000,   /* U+44E8 */
  0x0000,   /* U+44E9 */
  0x0000,   /* U+44EA */
  0x0000,   /* U+44EB */
  0x0000,   /* U+44EC */
  0x0000,   /* U+44ED */
  0x0000,   /* U+44EE */
  0x0000,   /* U+44EF */
  0x0000,   /* U+44F0 */
  0x0000,   /* U+44F1 */
  0x0000,   /* U+44F2 */
  0x0000,   /* U+44F3 */
  0x0000,   /* U+44F4 */
  0x0000,   /* U+44F5 */
  0x0000,   /* U+44F6 */
  0x0000,   /* U+44F7 */
  0x0000,   /* U+44F8 */
  0x0000,   /* U+44F9 */
  0x0000,   /* U+44FA */
  0x0000,   /* U+44FB */
  0x0000,   /* U+44FC */
  0x0000,   /* U+44FD */
  0x0000,   /* U+44FE */
  0x0000,   /* U+44FF */
};

uint16 zh3_han_p045[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C57,   /* U+4500 */
  0x1C57,   /* U+4501 */
  0x1C57,   /* U+4502 */
  0x1C57,   /* U+4503 */
  0x1C57,   /* U+4504 */
  0x1C57,   /* U+4505 */
  0x1C57,   /* U+4506 */
  0x1C57,   /* U+4507 */
  0x1C57,   /* U+4508 */
  0x1C57,   /* U+4509 */
  0x1C57,   /* U+450A */
  0x1C57,   /* U+450B */
  0x1C57,   /* U+450C */
  0x1C57,   /* U+450D */
  0x1C58,   /* U+450E */
  0x1C58,   /* U+450F */
  0x1C58,   /* U+4510 */
  0x1C58,   /* U+4511 */
  0x1C58,   /* U+4512 */
  0x1C58,   /* U+4513 */
  0x1C58,   /* U+4514 */
  0x1C58,   /* U+4515 */
  0x1C58,   /* U+4516 */
  0x1C58,   /* U+4517 */
  0x1C58,   /* U+4518 */
  0x1C58,   /* U+4519 */
  0x1C58,   /* U+451A */
  0x1C58,   /* U+451B */
  0x1C58,   /* U+451C */
  0x1C58,   /* U+451D */
  0x1C58,   /* U+451E */
  0x1C58,   /* U+451F */
  0x1C58,   /* U+4520 */
  0x1C58,   /* U+4521 */
  0x1C58,   /* U+4522 */
  0x1C58,   /* U+4523 */
  0x1C58,   /* U+4524 */
  0x1C58,   /* U+4525 */
  0x1C58,   /* U+4526 */
  0x1C58,   /* U+4527 */
  0x1C58,   /* U+4528 */
  0x1C58,   /* U+4529 */
  0x1C58,   /* U+452A */
  0x1C58,   /* U+452B */
  0x1C58,   /* U+452C */
  0x1C59,   /* U+452D */
  0x1C59,   /* U+452E */
  0x1C59,   /* U+452F */
  0x1C59,   /* U+4530 */
  0x1C59,   /* U+4531 */
  0x1C59,   /* U+4532 */
  0x1C59,   /* U+4533 */
  0x1C59,   /* U+4534 */
  0x1C59,   /* U+4535 */
  0x1C59,   /* U+4536 */
  0x1C59,   /* U+4537 */
  0x1C59,   /* U+4538 */
  0x1C59,   /* U+4539 */
  0x1C59,   /* U+453A */
  0x1C59,   /* U+453B */
  0x1C59,   /* U+453C */
  0x1C59,   /* U+453D */
  0x1C59,   /* U+453E */
  0x1C59,   /* U+453F */
  0x1C59,   /* U+4540 */
  0x1C59,   /* U+4541 */
  0x1C59,   /* U+4542 */
  0x1C59,   /* U+4543 */
  0x1C59,   /* U+4544 */
  0x1C5A,   /* U+4545 */
  0x1C5A,   /* U+4546 */
  0x1C5A,   /* U+4547 */
  0x1C5A,   /* U+4548 */
  0x1C5A,   /* U+4549 */
  0x1C5A,   /* U+454A */
  0x1C5A,   /* U+454B */
  0x1C5A,   /* U+454C */
  0x1C5A,   /* U+454D */
  0x1C5A,   /* U+454E */
  0x1C5A,   /* U+454F */
  0x1C5A,   /* U+4550 */
  0x1C5A,   /* U+4551 */
  0x1C5B,   /* U+4552 */
  0x1C5B,   /* U+4553 */
  0x1C5B,   /* U+4554 */
  0x1C5B,   /* U+4555 */
  0x1C5B,   /* U+4556 */
  0x1C5B,   /* U+4557 */
  0x1C5B,   /* U+4558 */
  0x1C5B,   /* U+4559 */
  0x1C5B,   /* U+455A */
  0x1C5B,   /* U+455B */
  0x1C5B,   /* U+455C */
  0x1C5B,   /* U+455D */
  0x1C5C,   /* U+455E */
  0x1C5C,   /* U+455F */
  0x1C5C,   /* U+4560 */
  0x1C5C,   /* U+4561 */
  0x1C5C,   /* U+4562 */
  0x1C5C,   /* U+4563 */
  0x1C5C,   /* U+4564 */
  0x1C5C,   /* U+4565 */
  0x1C5D,   /* U+4566 */
  0x1C5D,   /* U+4567 */
  0x1C5D,   /* U+4568 */
  0x1C5D,   /* U+4569 */
  0x1C5D,   /* U+456A */
  0x1C5D,   /* U+456B */
  0x1C5D,   /* U+456C */
  0x1C5D,   /* U+456D */
  0x1C5D,   /* U+456E */
  0x1C5D,   /* U+456F */
  0x1C5D,   /* U+4570 */
  0x1C5D,   /* U+4571 */
  0x1C5D,   /* U+4572 */
  0x1C5E,   /* U+4573 */
  0x1C5E,   /* U+4574 */
  0x1C5E,   /* U+4575 */
  0x1C5E,   /* U+4576 */
  0x1C5E,   /* U+4577 */
  0x1C5F,   /* U+4578 */
  0x1C5F,   /* U+4579 */
  0x1C5F,   /* U+457A */
  0x1C60,   /* U+457B */
  0x1C60,   /* U+457C */
  0x1C60,   /* U+457D */
  0x1C61,   /* U+457E */
  0x1C62,   /* U+457F */
  0x1C62,   /* U+4580 */
  0x1C63,   /* U+4581 */
  0x1C64,   /* U+4582 */
  0x1C64,   /* U+4583 */
  0x1C64,   /* U+4584 */
  0x1C65,   /* U+4585 */
  0x1C65,   /* U+4586 */
  0x1C6A,   /* U+4587 */
  0x1C4F,   /* U+4588 */
  0x1C50,   /* U+4589 */
  0x1C51,   /* U+458A */
  0x1C51,   /* U+458B */
  0x1C51,   /* U+458C */
  0x1C51,   /* U+458D */
  0x1C52,   /* U+458E */
  0x1C52,   /* U+458F */
  0x1C53,   /* U+4590 */
  0x1C53,   /* U+4591 */
  0x1C54,   /* U+4592 */
  0x1C54,   /* U+4593 */
  0x1C54,   /* U+4594 */
  0x1C54,   /* U+4595 */
  0x1C54,   /* U+4596 */
  0x1C56,   /* U+4597 */
  0x1C57,   /* U+4598 */
  0x1C58,   /* U+4599 */
  0x1C59,   /* U+459A */
  0x1C59,   /* U+459B */
  0x1C5A,   /* U+459C */
  0x1C4E,   /* U+459D */
  0x1C50,   /* U+459E */
  0x1C50,   /* U+459F */
  0x1C50,   /* U+45A0 */
  0x1C51,   /* U+45A1 */
  0x1C51,   /* U+45A2 */
  0x1C51,   /* U+45A3 */
  0x1C52,   /* U+45A4 */
  0x1C52,   /* U+45A5 */
  0x1C52,   /* U+45A6 */
  0x1C52,   /* U+45A7 */
  0x1C52,   /* U+45A8 */
  0x1C52,   /* U+45A9 */
  0x1C52,   /* U+45AA */
  0x1C52,   /* U+45AB */
  0x1C52,   /* U+45AC */
  0x1C53,   /* U+45AD */
  0x1C53,   /* U+45AE */
  0x1C53,   /* U+45AF */
  0x1C53,   /* U+45B0 */
  0x1C53,   /* U+45B1 */
  0x1C53,   /* U+45B2 */
  0x1C53,   /* U+45B3 */
  0x1C53,   /* U+45B4 */
  0x1C53,   /* U+45B5 */
  0x1C54,   /* U+45B6 */
  0x1C54,   /* U+45B7 */
  0x1C54,   /* U+45B8 */
  0x1C54,   /* U+45B9 */
  0x1C54,   /* U+45BA */
  0x1C54,   /* U+45BB */
  0x1C54,   /* U+45BC */
  0x1C54,   /* U+45BD */
  0x1C54,   /* U+45BE */
  0x1C55,   /* U+45BF */
  0x1C55,   /* U+45C0 */
  0x1C55,   /* U+45C1 */
  0x1C55,   /* U+45C2 */
  0x1C55,   /* U+45C3 */
  0x1C55,   /* U+45C4 */
  0x1C55,   /* U+45C5 */
  0x1C55,   /* U+45C6 */
  0x1C55,   /* U+45C7 */
  0x1C55,   /* U+45C8 */
  0x1C55,   /* U+45C9 */
  0x1C55,   /* U+45CA */
  0x1C56,   /* U+45CB */
  0x1C56,   /* U+45CC */
  0x1C56,   /* U+45CD */
  0x1C56,   /* U+45CE */
  0x1C56,   /* U+45CF */
  0x1C56,   /* U+45D0 */
  0x1C56,   /* U+45D1 */
  0x1C56,   /* U+45D2 */
  0x1C56,   /* U+45D3 */
  0x1C56,   /* U+45D4 */
  0x1C55,   /* U+45D5 */
  0x1C56,   /* U+45D6 */
  0x1C57,   /* U+45D7 */
  0x1C57,   /* U+45D8 */
  0x1C57,   /* U+45D9 */
  0x1C57,   /* U+45DA */
  0x1C57,   /* U+45DB */
  0x1C57,   /* U+45DC */
  0x1C57,   /* U+45DD */
  0x1C57,   /* U+45DE */
  0x1C58,   /* U+45DF */
  0x1C58,   /* U+45E0 */
  0x1C58,   /* U+45E1 */
  0x1C58,   /* U+45E2 */
  0x1C58,   /* U+45E3 */
  0x1C58,   /* U+45E4 */
  0x1C58,   /* U+45E5 */
  0x1C58,   /* U+45E6 */
  0x1C58,   /* U+45E7 */
  0x1C58,   /* U+45E8 */
  0x1C58,   /* U+45E9 */
  0x1C58,   /* U+45EA */
  0x1C58,   /* U+45EB */
  0x1C58,   /* U+45EC */
  0x1C58,   /* U+45ED */
  0x1C58,   /* U+45EE */
  0x1C59,   /* U+45EF */
  0x1C59,   /* U+45F0 */
  0x1C59,   /* U+45F1 */
  0x1C59,   /* U+45F2 */
  0x1C59,   /* U+45F3 */
  0x1C5A,   /* U+45F4 */
  0x1C5A,   /* U+45F5 */
  0x1C5A,   /* U+45F6 */
  0x1C5A,   /* U+45F7 */
  0x1C5A,   /* U+45F8 */
  0x1C5A,   /* U+45F9 */
  0x1C5A,   /* U+45FA */
  0x1C5A,   /* U+45FB */
  0x1C5B,   /* U+45FC */
  0x1C5B,   /* U+45FD */
  0x1C5B,   /* U+45FE */
  0x1C5B,   /* U+45FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4500 */
  0x0020,   /* U+4501 */
  0x0020,   /* U+4502 */
  0x0020,   /* U+4503 */
  0x0020,   /* U+4504 */
  0x0020,   /* U+4505 */
  0x0020,   /* U+4506 */
  0x0020,   /* U+4507 */
  0x0020,   /* U+4508 */
  0x0020,   /* U+4509 */
  0x0020,   /* U+450A */
  0x0020,   /* U+450B */
  0x0020,   /* U+450C */
  0x0020,   /* U+450D */
  0x0020,   /* U+450E */
  0x0020,   /* U+450F */
  0x0020,   /* U+4510 */
  0x0020,   /* U+4511 */
  0x0020,   /* U+4512 */
  0x0020,   /* U+4513 */
  0x0020,   /* U+4514 */
  0x0020,   /* U+4515 */
  0x0020,   /* U+4516 */
  0x0020,   /* U+4517 */
  0x0020,   /* U+4518 */
  0x0020,   /* U+4519 */
  0x0020,   /* U+451A */
  0x0020,   /* U+451B */
  0x0020,   /* U+451C */
  0x0020,   /* U+451D */
  0x0020,   /* U+451E */
  0x0020,   /* U+451F */
  0x0020,   /* U+4520 */
  0x0020,   /* U+4521 */
  0x0020,   /* U+4522 */
  0x0020,   /* U+4523 */
  0x0020,   /* U+4524 */
  0x0020,   /* U+4525 */
  0x0020,   /* U+4526 */
  0x0020,   /* U+4527 */
  0x0020,   /* U+4528 */
  0x0020,   /* U+4529 */
  0x0020,   /* U+452A */
  0x0020,   /* U+452B */
  0x0020,   /* U+452C */
  0x0020,   /* U+452D */
  0x0020,   /* U+452E */
  0x0020,   /* U+452F */
  0x0020,   /* U+4530 */
  0x0020,   /* U+4531 */
  0x0020,   /* U+4532 */
  0x0020,   /* U+4533 */
  0x0020,   /* U+4534 */
  0x0020,   /* U+4535 */
  0x0020,   /* U+4536 */
  0x0020,   /* U+4537 */
  0x0020,   /* U+4538 */
  0x0020,   /* U+4539 */
  0x0020,   /* U+453A */
  0x0020,   /* U+453B */
  0x0020,   /* U+453C */
  0x0020,   /* U+453D */
  0x0020,   /* U+453E */
  0x0020,   /* U+453F */
  0x0020,   /* U+4540 */
  0x0020,   /* U+4541 */
  0x0020,   /* U+4542 */
  0x0020,   /* U+4543 */
  0x0020,   /* U+4544 */
  0x0020,   /* U+4545 */
  0x0020,   /* U+4546 */
  0x0020,   /* U+4547 */
  0x0020,   /* U+4548 */
  0x0020,   /* U+4549 */
  0x0020,   /* U+454A */
  0x0020,   /* U+454B */
  0x0020,   /* U+454C */
  0x0020,   /* U+454D */
  0x0020,   /* U+454E */
  0x0020,   /* U+454F */
  0x0020,   /* U+4550 */
  0x0020,   /* U+4551 */
  0x0020,   /* U+4552 */
  0x0020,   /* U+4553 */
  0x0020,   /* U+4554 */
  0x0020,   /* U+4555 */
  0x0020,   /* U+4556 */
  0x0020,   /* U+4557 */
  0x0020,   /* U+4558 */
  0x0020,   /* U+4559 */
  0x0020,   /* U+455A */
  0x0020,   /* U+455B */
  0x0020,   /* U+455C */
  0x0020,   /* U+455D */
  0x0020,   /* U+455E */
  0x0020,   /* U+455F */
  0x0020,   /* U+4560 */
  0x0020,   /* U+4561 */
  0x0020,   /* U+4562 */
  0x0020,   /* U+4563 */
  0x0020,   /* U+4564 */
  0x0020,   /* U+4565 */
  0x0020,   /* U+4566 */
  0x0020,   /* U+4567 */
  0x0020,   /* U+4568 */
  0x0020,   /* U+4569 */
  0x0020,   /* U+456A */
  0x0020,   /* U+456B */
  0x0020,   /* U+456C */
  0x0020,   /* U+456D */
  0x0020,   /* U+456E */
  0x0020,   /* U+456F */
  0x0020,   /* U+4570 */
  0x0020,   /* U+4571 */
  0x0020,   /* U+4572 */
  0x0020,   /* U+4573 */
  0x0020,   /* U+4574 */
  0x0020,   /* U+4575 */
  0x0020,   /* U+4576 */
  0x0020,   /* U+4577 */
  0x0020,   /* U+4578 */
  0x0020,   /* U+4579 */
  0x0020,   /* U+457A */
  0x0020,   /* U+457B */
  0x0020,   /* U+457C */
  0x0020,   /* U+457D */
  0x0020,   /* U+457E */
  0x0020,   /* U+457F */
  0x0020,   /* U+4580 */
  0x0020,   /* U+4581 */
  0x0020,   /* U+4582 */
  0x0020,   /* U+4583 */
  0x0020,   /* U+4584 */
  0x0020,   /* U+4585 */
  0x0020,   /* U+4586 */
  0x0020,   /* U+4587 */
  0x0020,   /* U+4588 */
  0x0020,   /* U+4589 */
  0x0020,   /* U+458A */
  0x0020,   /* U+458B */
  0x0020,   /* U+458C */
  0x0020,   /* U+458D */
  0x0020,   /* U+458E */
  0x0020,   /* U+458F */
  0x0020,   /* U+4590 */
  0x0020,   /* U+4591 */
  0x0020,   /* U+4592 */
  0x0020,   /* U+4593 */
  0x0020,   /* U+4594 */
  0x0020,   /* U+4595 */
  0x0020,   /* U+4596 */
  0x0020,   /* U+4597 */
  0x0020,   /* U+4598 */
  0x0020,   /* U+4599 */
  0x0020,   /* U+459A */
  0x0020,   /* U+459B */
  0x0020,   /* U+459C */
  0x0020,   /* U+459D */
  0x0020,   /* U+459E */
  0x0020,   /* U+459F */
  0x0020,   /* U+45A0 */
  0x0020,   /* U+45A1 */
  0x0020,   /* U+45A2 */
  0x0020,   /* U+45A3 */
  0x0020,   /* U+45A4 */
  0x0020,   /* U+45A5 */
  0x0020,   /* U+45A6 */
  0x0020,   /* U+45A7 */
  0x0020,   /* U+45A8 */
  0x0020,   /* U+45A9 */
  0x0020,   /* U+45AA */
  0x0020,   /* U+45AB */
  0x0020,   /* U+45AC */
  0x0020,   /* U+45AD */
  0x0020,   /* U+45AE */
  0x0020,   /* U+45AF */
  0x0020,   /* U+45B0 */
  0x0020,   /* U+45B1 */
  0x0020,   /* U+45B2 */
  0x0020,   /* U+45B3 */
  0x0020,   /* U+45B4 */
  0x0020,   /* U+45B5 */
  0x0020,   /* U+45B6 */
  0x0020,   /* U+45B7 */
  0x0020,   /* U+45B8 */
  0x0020,   /* U+45B9 */
  0x0020,   /* U+45BA */
  0x0020,   /* U+45BB */
  0x0020,   /* U+45BC */
  0x0020,   /* U+45BD */
  0x0020,   /* U+45BE */
  0x0020,   /* U+45BF */
  0x0020,   /* U+45C0 */
  0x0020,   /* U+45C1 */
  0x0020,   /* U+45C2 */
  0x0020,   /* U+45C3 */
  0x0020,   /* U+45C4 */
  0x0020,   /* U+45C5 */
  0x0020,   /* U+45C6 */
  0x0020,   /* U+45C7 */
  0x0020,   /* U+45C8 */
  0x0020,   /* U+45C9 */
  0x0020,   /* U+45CA */
  0x0020,   /* U+45CB */
  0x0020,   /* U+45CC */
  0x0020,   /* U+45CD */
  0x0020,   /* U+45CE */
  0x0020,   /* U+45CF */
  0x0020,   /* U+45D0 */
  0x0020,   /* U+45D1 */
  0x0020,   /* U+45D2 */
  0x0020,   /* U+45D3 */
  0x0020,   /* U+45D4 */
  0x0020,   /* U+45D5 */
  0x0020,   /* U+45D6 */
  0x0020,   /* U+45D7 */
  0x0020,   /* U+45D8 */
  0x0020,   /* U+45D9 */
  0x0020,   /* U+45DA */
  0x0020,   /* U+45DB */
  0x0020,   /* U+45DC */
  0x0020,   /* U+45DD */
  0x0020,   /* U+45DE */
  0x0020,   /* U+45DF */
  0x0020,   /* U+45E0 */
  0x0020,   /* U+45E1 */
  0x0020,   /* U+45E2 */
  0x0020,   /* U+45E3 */
  0x0020,   /* U+45E4 */
  0x0020,   /* U+45E5 */
  0x0020,   /* U+45E6 */
  0x0020,   /* U+45E7 */
  0x0020,   /* U+45E8 */
  0x0020,   /* U+45E9 */
  0x0020,   /* U+45EA */
  0x0020,   /* U+45EB */
  0x0020,   /* U+45EC */
  0x0020,   /* U+45ED */
  0x0020,   /* U+45EE */
  0x0020,   /* U+45EF */
  0x0020,   /* U+45F0 */
  0x0020,   /* U+45F1 */
  0x0020,   /* U+45F2 */
  0x0020,   /* U+45F3 */
  0x0020,   /* U+45F4 */
  0x0020,   /* U+45F5 */
  0x0020,   /* U+45F6 */
  0x0020,   /* U+45F7 */
  0x0020,   /* U+45F8 */
  0x0020,   /* U+45F9 */
  0x0020,   /* U+45FA */
  0x0020,   /* U+45FB */
  0x0020,   /* U+45FC */
  0x0020,   /* U+45FD */
  0x0020,   /* U+45FE */
  0x0020,   /* U+45FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4500 */
  0x0002,   /* U+4501 */
  0x0002,   /* U+4502 */
  0x0002,   /* U+4503 */
  0x0002,   /* U+4504 */
  0x0002,   /* U+4505 */
  0x0002,   /* U+4506 */
  0x0002,   /* U+4507 */
  0x0002,   /* U+4508 */
  0x0002,   /* U+4509 */
  0x0002,   /* U+450A */
  0x0002,   /* U+450B */
  0x0002,   /* U+450C */
  0x0002,   /* U+450D */
  0x0002,   /* U+450E */
  0x0002,   /* U+450F */
  0x0002,   /* U+4510 */
  0x0002,   /* U+4511 */
  0x0002,   /* U+4512 */
  0x0002,   /* U+4513 */
  0x0002,   /* U+4514 */
  0x0002,   /* U+4515 */
  0x0002,   /* U+4516 */
  0x0002,   /* U+4517 */
  0x0002,   /* U+4518 */
  0x0002,   /* U+4519 */
  0x0002,   /* U+451A */
  0x0002,   /* U+451B */
  0x0002,   /* U+451C */
  0x0002,   /* U+451D */
  0x0002,   /* U+451E */
  0x0002,   /* U+451F */
  0x0002,   /* U+4520 */
  0x0002,   /* U+4521 */
  0x0002,   /* U+4522 */
  0x0002,   /* U+4523 */
  0x0002,   /* U+4524 */
  0x0002,   /* U+4525 */
  0x0002,   /* U+4526 */
  0x0002,   /* U+4527 */
  0x0002,   /* U+4528 */
  0x0002,   /* U+4529 */
  0x0002,   /* U+452A */
  0x0002,   /* U+452B */
  0x0002,   /* U+452C */
  0x0002,   /* U+452D */
  0x0002,   /* U+452E */
  0x0002,   /* U+452F */
  0x0002,   /* U+4530 */
  0x0002,   /* U+4531 */
  0x0002,   /* U+4532 */
  0x0002,   /* U+4533 */
  0x0002,   /* U+4534 */
  0x0002,   /* U+4535 */
  0x0002,   /* U+4536 */
  0x0002,   /* U+4537 */
  0x0002,   /* U+4538 */
  0x0002,   /* U+4539 */
  0x0002,   /* U+453A */
  0x0002,   /* U+453B */
  0x0002,   /* U+453C */
  0x0002,   /* U+453D */
  0x0002,   /* U+453E */
  0x0002,   /* U+453F */
  0x0002,   /* U+4540 */
  0x0002,   /* U+4541 */
  0x0002,   /* U+4542 */
  0x0002,   /* U+4543 */
  0x0002,   /* U+4544 */
  0x0002,   /* U+4545 */
  0x0002,   /* U+4546 */
  0x0002,   /* U+4547 */
  0x0002,   /* U+4548 */
  0x0002,   /* U+4549 */
  0x0002,   /* U+454A */
  0x0002,   /* U+454B */
  0x0002,   /* U+454C */
  0x0002,   /* U+454D */
  0x0002,   /* U+454E */
  0x0002,   /* U+454F */
  0x0002,   /* U+4550 */
  0x0002,   /* U+4551 */
  0x0002,   /* U+4552 */
  0x0002,   /* U+4553 */
  0x0002,   /* U+4554 */
  0x0002,   /* U+4555 */
  0x0002,   /* U+4556 */
  0x0002,   /* U+4557 */
  0x0002,   /* U+4558 */
  0x0002,   /* U+4559 */
  0x0002,   /* U+455A */
  0x0002,   /* U+455B */
  0x0002,   /* U+455C */
  0x0002,   /* U+455D */
  0x0002,   /* U+455E */
  0x0002,   /* U+455F */
  0x0002,   /* U+4560 */
  0x0002,   /* U+4561 */
  0x0002,   /* U+4562 */
  0x0002,   /* U+4563 */
  0x0002,   /* U+4564 */
  0x0002,   /* U+4565 */
  0x0002,   /* U+4566 */
  0x0002,   /* U+4567 */
  0x0002,   /* U+4568 */
  0x0002,   /* U+4569 */
  0x0002,   /* U+456A */
  0x0002,   /* U+456B */
  0x0002,   /* U+456C */
  0x0002,   /* U+456D */
  0x0002,   /* U+456E */
  0x0002,   /* U+456F */
  0x0002,   /* U+4570 */
  0x0002,   /* U+4571 */
  0x0002,   /* U+4572 */
  0x0002,   /* U+4573 */
  0x0002,   /* U+4574 */
  0x0002,   /* U+4575 */
  0x0002,   /* U+4576 */
  0x0002,   /* U+4577 */
  0x0002,   /* U+4578 */
  0x0002,   /* U+4579 */
  0x0002,   /* U+457A */
  0x0002,   /* U+457B */
  0x0002,   /* U+457C */
  0x0002,   /* U+457D */
  0x0002,   /* U+457E */
  0x0002,   /* U+457F */
  0x0002,   /* U+4580 */
  0x0002,   /* U+4581 */
  0x0002,   /* U+4582 */
  0x0002,   /* U+4583 */
  0x0002,   /* U+4584 */
  0x0002,   /* U+4585 */
  0x0002,   /* U+4586 */
  0x0002,   /* U+4587 */
  0x0002,   /* U+4588 */
  0x0002,   /* U+4589 */
  0x0002,   /* U+458A */
  0x0002,   /* U+458B */
  0x0002,   /* U+458C */
  0x0002,   /* U+458D */
  0x0002,   /* U+458E */
  0x0002,   /* U+458F */
  0x0002,   /* U+4590 */
  0x0002,   /* U+4591 */
  0x0002,   /* U+4592 */
  0x0002,   /* U+4593 */
  0x0002,   /* U+4594 */
  0x0002,   /* U+4595 */
  0x0002,   /* U+4596 */
  0x0002,   /* U+4597 */
  0x0002,   /* U+4598 */
  0x0002,   /* U+4599 */
  0x0002,   /* U+459A */
  0x0002,   /* U+459B */
  0x0002,   /* U+459C */
  0x0002,   /* U+459D */
  0x0002,   /* U+459E */
  0x0002,   /* U+459F */
  0x0002,   /* U+45A0 */
  0x0002,   /* U+45A1 */
  0x0002,   /* U+45A2 */
  0x0002,   /* U+45A3 */
  0x0002,   /* U+45A4 */
  0x0002,   /* U+45A5 */
  0x0002,   /* U+45A6 */
  0x0002,   /* U+45A7 */
  0x0002,   /* U+45A8 */
  0x0002,   /* U+45A9 */
  0x0002,   /* U+45AA */
  0x0002,   /* U+45AB */
  0x0002,   /* U+45AC */
  0x0002,   /* U+45AD */
  0x0002,   /* U+45AE */
  0x0002,   /* U+45AF */
  0x0002,   /* U+45B0 */
  0x0002,   /* U+45B1 */
  0x0002,   /* U+45B2 */
  0x0002,   /* U+45B3 */
  0x0002,   /* U+45B4 */
  0x0002,   /* U+45B5 */
  0x0002,   /* U+45B6 */
  0x0002,   /* U+45B7 */
  0x0002,   /* U+45B8 */
  0x0002,   /* U+45B9 */
  0x0002,   /* U+45BA */
  0x0002,   /* U+45BB */
  0x0002,   /* U+45BC */
  0x0002,   /* U+45BD */
  0x0002,   /* U+45BE */
  0x0002,   /* U+45BF */
  0x0002,   /* U+45C0 */
  0x0002,   /* U+45C1 */
  0x0002,   /* U+45C2 */
  0x0002,   /* U+45C3 */
  0x0002,   /* U+45C4 */
  0x0002,   /* U+45C5 */
  0x0002,   /* U+45C6 */
  0x0002,   /* U+45C7 */
  0x0002,   /* U+45C8 */
  0x0002,   /* U+45C9 */
  0x0002,   /* U+45CA */
  0x0002,   /* U+45CB */
  0x0002,   /* U+45CC */
  0x0002,   /* U+45CD */
  0x0002,   /* U+45CE */
  0x0002,   /* U+45CF */
  0x0002,   /* U+45D0 */
  0x0002,   /* U+45D1 */
  0x0002,   /* U+45D2 */
  0x0002,   /* U+45D3 */
  0x0002,   /* U+45D4 */
  0x0002,   /* U+45D5 */
  0x0002,   /* U+45D6 */
  0x0002,   /* U+45D7 */
  0x0002,   /* U+45D8 */
  0x0002,   /* U+45D9 */
  0x0002,   /* U+45DA */
  0x0002,   /* U+45DB */
  0x0002,   /* U+45DC */
  0x0002,   /* U+45DD */
  0x0002,   /* U+45DE */
  0x0002,   /* U+45DF */
  0x0002,   /* U+45E0 */
  0x0002,   /* U+45E1 */
  0x0002,   /* U+45E2 */
  0x0002,   /* U+45E3 */
  0x0002,   /* U+45E4 */
  0x0002,   /* U+45E5 */
  0x0002,   /* U+45E6 */
  0x0002,   /* U+45E7 */
  0x0002,   /* U+45E8 */
  0x0002,   /* U+45E9 */
  0x0002,   /* U+45EA */
  0x0002,   /* U+45EB */
  0x0002,   /* U+45EC */
  0x0002,   /* U+45ED */
  0x0002,   /* U+45EE */
  0x0002,   /* U+45EF */
  0x0002,   /* U+45F0 */
  0x0002,   /* U+45F1 */
  0x0002,   /* U+45F2 */
  0x0002,   /* U+45F3 */
  0x0002,   /* U+45F4 */
  0x0002,   /* U+45F5 */
  0x0002,   /* U+45F6 */
  0x0002,   /* U+45F7 */
  0x0002,   /* U+45F8 */
  0x0002,   /* U+45F9 */
  0x0002,   /* U+45FA */
  0x0002,   /* U+45FB */
  0x0002,   /* U+45FC */
  0x0002,   /* U+45FD */
  0x0002,   /* U+45FE */
  0x0002,   /* U+45FF */

  /* Primary weight 2 for each character. */
  0x8F07,   /* U+4500 */
  0x8F08,   /* U+4501 */
  0x8F09,   /* U+4502 */
  0x8F0A,   /* U+4503 */
  0x8F0B,   /* U+4504 */
  0x8F0C,   /* U+4505 */
  0x8F0D,   /* U+4506 */
  0x8F0E,   /* U+4507 */
  0x8F0F,   /* U+4508 */
  0x8F10,   /* U+4509 */
  0x8F11,   /* U+450A */
  0x8F12,   /* U+450B */
  0x8F13,   /* U+450C */
  0x8F14,   /* U+450D */
  0x8B28,   /* U+450E */
  0x8B29,   /* U+450F */
  0x8B2A,   /* U+4510 */
  0x8B2B,   /* U+4511 */
  0x8B2C,   /* U+4512 */
  0x8B2D,   /* U+4513 */
  0x8B2E,   /* U+4514 */
  0x8B2F,   /* U+4515 */
  0x8B30,   /* U+4516 */
  0x8B31,   /* U+4517 */
  0x8B32,   /* U+4518 */
  0x8B33,   /* U+4519 */
  0x8B34,   /* U+451A */
  0x8B35,   /* U+451B */
  0x8B36,   /* U+451C */
  0x8B37,   /* U+451D */
  0x8B38,   /* U+451E */
  0x8B39,   /* U+451F */
  0x8B3A,   /* U+4520 */
  0x8B3B,   /* U+4521 */
  0x8B3C,   /* U+4522 */
  0x8B3D,   /* U+4523 */
  0x8B3E,   /* U+4524 */
  0x8B3F,   /* U+4525 */
  0x8B40,   /* U+4526 */
  0x8B41,   /* U+4527 */
  0x8B42,   /* U+4528 */
  0x8B43,   /* U+4529 */
  0x8B44,   /* U+452A */
  0x8B45,   /* U+452B */
  0x8B46,   /* U+452C */
  0x893E,   /* U+452D */
  0x893F,   /* U+452E */
  0x8940,   /* U+452F */
  0x8941,   /* U+4530 */
  0x8942,   /* U+4531 */
  0x8943,   /* U+4532 */
  0x8944,   /* U+4533 */
  0x8945,   /* U+4534 */
  0x8946,   /* U+4535 */
  0x8947,   /* U+4536 */
  0x8948,   /* U+4537 */
  0x8949,   /* U+4538 */
  0x894A,   /* U+4539 */
  0x894B,   /* U+453A */
  0x894C,   /* U+453B */
  0x894D,   /* U+453C */
  0x894E,   /* U+453D */
  0x894F,   /* U+453E */
  0x8950,   /* U+453F */
  0x8951,   /* U+4540 */
  0x8952,   /* U+4541 */
  0x8953,   /* U+4542 */
  0x8954,   /* U+4543 */
  0x8955,   /* U+4544 */
  0x86AB,   /* U+4545 */
  0x86AC,   /* U+4546 */
  0x86AD,   /* U+4547 */
  0x86AE,   /* U+4548 */
  0x86AF,   /* U+4549 */
  0x86B0,   /* U+454A */
  0x86B1,   /* U+454B */
  0x86B2,   /* U+454C */
  0x86B3,   /* U+454D */
  0x86B4,   /* U+454E */
  0x86B5,   /* U+454F */
  0x86B6,   /* U+4550 */
  0x86B7,   /* U+4551 */
  0x84E0,   /* U+4552 */
  0x84E1,   /* U+4553 */
  0x84E2,   /* U+4554 */
  0x84E3,   /* U+4555 */
  0x84E4,   /* U+4556 */
  0x84E5,   /* U+4557 */
  0x84E6,   /* U+4558 */
  0x84E7,   /* U+4559 */
  0x84E8,   /* U+455A */
  0x84E9,   /* U+455B */
  0x84EA,   /* U+455C */
  0x84EB,   /* U+455D */
  0x83DA,   /* U+455E */
  0x83DB,   /* U+455F */
  0x83DC,   /* U+4560 */
  0x83DD,   /* U+4561 */
  0x83DE,   /* U+4562 */
  0x83DF,   /* U+4563 */
  0x83E0,   /* U+4564 */
  0x83E1,   /* U+4565 */
  0x82C0,   /* U+4566 */
  0x82C1,   /* U+4567 */
  0x82C2,   /* U+4568 */
  0x82C3,   /* U+4569 */
  0x82C4,   /* U+456A */
  0x82C5,   /* U+456B */
  0x82C6,   /* U+456C */
  0x82C7,   /* U+456D */
  0x82C8,   /* U+456E */
  0x82C9,   /* U+456F */
  0x82CA,   /* U+4570 */
  0x82CB,   /* U+4571 */
  0x82CC,   /* U+4572 */
  0x81EF,   /* U+4573 */
  0x81F0,   /* U+4574 */
  0x81F1,   /* U+4575 */
  0x81F2,   /* U+4576 */
  0x81F3,   /* U+4577 */
  0x8178,   /* U+4578 */
  0x8179,   /* U+4579 */
  0x817A,   /* U+457A */
  0x80EB,   /* U+457B */
  0x80EC,   /* U+457C */
  0x80ED,   /* U+457D */
  0x809E,   /* U+457E */
  0x8075,   /* U+457F */
  0x8076,   /* U+4580 */
  0x8048,   /* U+4581 */
  0x8025,   /* U+4582 */
  0x8026,   /* U+4583 */
  0x8027,   /* U+4584 */
  0x8021,   /* U+4585 */
  0x8022,   /* U+4586 */
  0x8005,   /* U+4587 */
  0x8EA1,   /* U+4588 */
  0x9220,   /* U+4589 */
  0x951E,   /* U+458A */
  0x951F,   /* U+458B */
  0x9520,   /* U+458C */
  0x9521,   /* U+458D */
  0x9647,   /* U+458E */
  0x9648,   /* U+458F */
  0x9814,   /* U+4590 */
  0x9815,   /* U+4591 */
  0x9629,   /* U+4592 */
  0x962A,   /* U+4593 */
  0x962B,   /* U+4594 */
  0x962C,   /* U+4595 */
  0x962D,   /* U+4596 */
  0x9309,   /* U+4597 */
  0x9033,   /* U+4598 */
  0x8C49,   /* U+4599 */
  0x8A27,   /* U+459A */
  0x8A28,   /* U+459B */
  0x875E,   /* U+459C */
  0x8A45,   /* U+459D */
  0x923A,   /* U+459E */
  0x923B,   /* U+459F */
  0x923C,   /* U+45A0 */
  0x9558,   /* U+45A1 */
  0x9559,   /* U+45A2 */
  0x955A,   /* U+45A3 */
  0x9680,   /* U+45A4 */
  0x9681,   /* U+45A5 */
  0x9682,   /* U+45A6 */
  0x9683,   /* U+45A7 */
  0x9684,   /* U+45A8 */
  0x9685,   /* U+45A9 */
  0x9686,   /* U+45AA */
  0x9687,   /* U+45AB */
  0x9688,   /* U+45AC */
  0x984B,   /* U+45AD */
  0x984C,   /* U+45AE */
  0x984D,   /* U+45AF */
  0x984E,   /* U+45B0 */
  0x984F,   /* U+45B1 */
  0x9850,   /* U+45B2 */
  0x9851,   /* U+45B3 */
  0x9852,   /* U+45B4 */
  0x9853,   /* U+45B5 */
  0x9661,   /* U+45B6 */
  0x9662,   /* U+45B7 */
  0x9663,   /* U+45B8 */
  0x9664,   /* U+45B9 */
  0x9665,   /* U+45BA */
  0x9666,   /* U+45BB */
  0x9667,   /* U+45BC */
  0x9668,   /* U+45BD */
  0x9669,   /* U+45BE */
  0x9533,   /* U+45BF */
  0x9534,   /* U+45C0 */
  0x9535,   /* U+45C1 */
  0x9536,   /* U+45C2 */
  0x9537,   /* U+45C3 */
  0x9538,   /* U+45C4 */
  0x9539,   /* U+45C5 */
  0x953A,   /* U+45C6 */
  0x953B,   /* U+45C7 */
  0x953C,   /* U+45C8 */
  0x953D,   /* U+45C9 */
  0x953E,   /* U+45CA */
  0x934C,   /* U+45CB */
  0x934D,   /* U+45CC */
  0x934E,   /* U+45CD */
  0x934F,   /* U+45CE */
  0x9350,   /* U+45CF */
  0x9351,   /* U+45D0 */
  0x9352,   /* U+45D1 */
  0x9353,   /* U+45D2 */
  0x9354,   /* U+45D3 */
  0x9355,   /* U+45D4 */
  0x953F,   /* U+45D5 */
  0x9356,   /* U+45D6 */
  0x9078,   /* U+45D7 */
  0x9079,   /* U+45D8 */
  0x907A,   /* U+45D9 */
  0x907B,   /* U+45DA */
  0x907C,   /* U+45DB */
  0x907D,   /* U+45DC */
  0x907E,   /* U+45DD */
  0x907F,   /* U+45DE */
  0x8C7F,   /* U+45DF */
  0x8C80,   /* U+45E0 */
  0x8C81,   /* U+45E1 */
  0x8C82,   /* U+45E2 */
  0x8C83,   /* U+45E3 */
  0x8C84,   /* U+45E4 */
  0x8C85,   /* U+45E5 */
  0x8C86,   /* U+45E6 */
  0x8C87,   /* U+45E7 */
  0x8C88,   /* U+45E8 */
  0x8C89,   /* U+45E9 */
  0x8C8A,   /* U+45EA */
  0x8C8B,   /* U+45EB */
  0x8C8C,   /* U+45EC */
  0x8C8D,   /* U+45ED */
  0x8C8E,   /* U+45EE */
  0x8A55,   /* U+45EF */
  0x8A56,   /* U+45F0 */
  0x8A57,   /* U+45F1 */
  0x8A58,   /* U+45F2 */
  0x8A59,   /* U+45F3 */
  0x8782,   /* U+45F4 */
  0x8783,   /* U+45F5 */
  0x8784,   /* U+45F6 */
  0x8785,   /* U+45F7 */
  0x8786,   /* U+45F8 */
  0x8787,   /* U+45F9 */
  0x8788,   /* U+45FA */
  0x8789,   /* U+45FB */
  0x8586,   /* U+45FC */
  0x8587,   /* U+45FD */
  0x8588,   /* U+45FE */
  0x8589,   /* U+45FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4500 */
  0x0000,   /* U+4501 */
  0x0000,   /* U+4502 */
  0x0000,   /* U+4503 */
  0x0000,   /* U+4504 */
  0x0000,   /* U+4505 */
  0x0000,   /* U+4506 */
  0x0000,   /* U+4507 */
  0x0000,   /* U+4508 */
  0x0000,   /* U+4509 */
  0x0000,   /* U+450A */
  0x0000,   /* U+450B */
  0x0000,   /* U+450C */
  0x0000,   /* U+450D */
  0x0000,   /* U+450E */
  0x0000,   /* U+450F */
  0x0000,   /* U+4510 */
  0x0000,   /* U+4511 */
  0x0000,   /* U+4512 */
  0x0000,   /* U+4513 */
  0x0000,   /* U+4514 */
  0x0000,   /* U+4515 */
  0x0000,   /* U+4516 */
  0x0000,   /* U+4517 */
  0x0000,   /* U+4518 */
  0x0000,   /* U+4519 */
  0x0000,   /* U+451A */
  0x0000,   /* U+451B */
  0x0000,   /* U+451C */
  0x0000,   /* U+451D */
  0x0000,   /* U+451E */
  0x0000,   /* U+451F */
  0x0000,   /* U+4520 */
  0x0000,   /* U+4521 */
  0x0000,   /* U+4522 */
  0x0000,   /* U+4523 */
  0x0000,   /* U+4524 */
  0x0000,   /* U+4525 */
  0x0000,   /* U+4526 */
  0x0000,   /* U+4527 */
  0x0000,   /* U+4528 */
  0x0000,   /* U+4529 */
  0x0000,   /* U+452A */
  0x0000,   /* U+452B */
  0x0000,   /* U+452C */
  0x0000,   /* U+452D */
  0x0000,   /* U+452E */
  0x0000,   /* U+452F */
  0x0000,   /* U+4530 */
  0x0000,   /* U+4531 */
  0x0000,   /* U+4532 */
  0x0000,   /* U+4533 */
  0x0000,   /* U+4534 */
  0x0000,   /* U+4535 */
  0x0000,   /* U+4536 */
  0x0000,   /* U+4537 */
  0x0000,   /* U+4538 */
  0x0000,   /* U+4539 */
  0x0000,   /* U+453A */
  0x0000,   /* U+453B */
  0x0000,   /* U+453C */
  0x0000,   /* U+453D */
  0x0000,   /* U+453E */
  0x0000,   /* U+453F */
  0x0000,   /* U+4540 */
  0x0000,   /* U+4541 */
  0x0000,   /* U+4542 */
  0x0000,   /* U+4543 */
  0x0000,   /* U+4544 */
  0x0000,   /* U+4545 */
  0x0000,   /* U+4546 */
  0x0000,   /* U+4547 */
  0x0000,   /* U+4548 */
  0x0000,   /* U+4549 */
  0x0000,   /* U+454A */
  0x0000,   /* U+454B */
  0x0000,   /* U+454C */
  0x0000,   /* U+454D */
  0x0000,   /* U+454E */
  0x0000,   /* U+454F */
  0x0000,   /* U+4550 */
  0x0000,   /* U+4551 */
  0x0000,   /* U+4552 */
  0x0000,   /* U+4553 */
  0x0000,   /* U+4554 */
  0x0000,   /* U+4555 */
  0x0000,   /* U+4556 */
  0x0000,   /* U+4557 */
  0x0000,   /* U+4558 */
  0x0000,   /* U+4559 */
  0x0000,   /* U+455A */
  0x0000,   /* U+455B */
  0x0000,   /* U+455C */
  0x0000,   /* U+455D */
  0x0000,   /* U+455E */
  0x0000,   /* U+455F */
  0x0000,   /* U+4560 */
  0x0000,   /* U+4561 */
  0x0000,   /* U+4562 */
  0x0000,   /* U+4563 */
  0x0000,   /* U+4564 */
  0x0000,   /* U+4565 */
  0x0000,   /* U+4566 */
  0x0000,   /* U+4567 */
  0x0000,   /* U+4568 */
  0x0000,   /* U+4569 */
  0x0000,   /* U+456A */
  0x0000,   /* U+456B */
  0x0000,   /* U+456C */
  0x0000,   /* U+456D */
  0x0000,   /* U+456E */
  0x0000,   /* U+456F */
  0x0000,   /* U+4570 */
  0x0000,   /* U+4571 */
  0x0000,   /* U+4572 */
  0x0000,   /* U+4573 */
  0x0000,   /* U+4574 */
  0x0000,   /* U+4575 */
  0x0000,   /* U+4576 */
  0x0000,   /* U+4577 */
  0x0000,   /* U+4578 */
  0x0000,   /* U+4579 */
  0x0000,   /* U+457A */
  0x0000,   /* U+457B */
  0x0000,   /* U+457C */
  0x0000,   /* U+457D */
  0x0000,   /* U+457E */
  0x0000,   /* U+457F */
  0x0000,   /* U+4580 */
  0x0000,   /* U+4581 */
  0x0000,   /* U+4582 */
  0x0000,   /* U+4583 */
  0x0000,   /* U+4584 */
  0x0000,   /* U+4585 */
  0x0000,   /* U+4586 */
  0x0000,   /* U+4587 */
  0x0000,   /* U+4588 */
  0x0000,   /* U+4589 */
  0x0000,   /* U+458A */
  0x0000,   /* U+458B */
  0x0000,   /* U+458C */
  0x0000,   /* U+458D */
  0x0000,   /* U+458E */
  0x0000,   /* U+458F */
  0x0000,   /* U+4590 */
  0x0000,   /* U+4591 */
  0x0000,   /* U+4592 */
  0x0000,   /* U+4593 */
  0x0000,   /* U+4594 */
  0x0000,   /* U+4595 */
  0x0000,   /* U+4596 */
  0x0000,   /* U+4597 */
  0x0000,   /* U+4598 */
  0x0000,   /* U+4599 */
  0x0000,   /* U+459A */
  0x0000,   /* U+459B */
  0x0000,   /* U+459C */
  0x0000,   /* U+459D */
  0x0000,   /* U+459E */
  0x0000,   /* U+459F */
  0x0000,   /* U+45A0 */
  0x0000,   /* U+45A1 */
  0x0000,   /* U+45A2 */
  0x0000,   /* U+45A3 */
  0x0000,   /* U+45A4 */
  0x0000,   /* U+45A5 */
  0x0000,   /* U+45A6 */
  0x0000,   /* U+45A7 */
  0x0000,   /* U+45A8 */
  0x0000,   /* U+45A9 */
  0x0000,   /* U+45AA */
  0x0000,   /* U+45AB */
  0x0000,   /* U+45AC */
  0x0000,   /* U+45AD */
  0x0000,   /* U+45AE */
  0x0000,   /* U+45AF */
  0x0000,   /* U+45B0 */
  0x0000,   /* U+45B1 */
  0x0000,   /* U+45B2 */
  0x0000,   /* U+45B3 */
  0x0000,   /* U+45B4 */
  0x0000,   /* U+45B5 */
  0x0000,   /* U+45B6 */
  0x0000,   /* U+45B7 */
  0x0000,   /* U+45B8 */
  0x0000,   /* U+45B9 */
  0x0000,   /* U+45BA */
  0x0000,   /* U+45BB */
  0x0000,   /* U+45BC */
  0x0000,   /* U+45BD */
  0x0000,   /* U+45BE */
  0x0000,   /* U+45BF */
  0x0000,   /* U+45C0 */
  0x0000,   /* U+45C1 */
  0x0000,   /* U+45C2 */
  0x0000,   /* U+45C3 */
  0x0000,   /* U+45C4 */
  0x0000,   /* U+45C5 */
  0x0000,   /* U+45C6 */
  0x0000,   /* U+45C7 */
  0x0000,   /* U+45C8 */
  0x0000,   /* U+45C9 */
  0x0000,   /* U+45CA */
  0x0000,   /* U+45CB */
  0x0000,   /* U+45CC */
  0x0000,   /* U+45CD */
  0x0000,   /* U+45CE */
  0x0000,   /* U+45CF */
  0x0000,   /* U+45D0 */
  0x0000,   /* U+45D1 */
  0x0000,   /* U+45D2 */
  0x0000,   /* U+45D3 */
  0x0000,   /* U+45D4 */
  0x0000,   /* U+45D5 */
  0x0000,   /* U+45D6 */
  0x0000,   /* U+45D7 */
  0x0000,   /* U+45D8 */
  0x0000,   /* U+45D9 */
  0x0000,   /* U+45DA */
  0x0000,   /* U+45DB */
  0x0000,   /* U+45DC */
  0x0000,   /* U+45DD */
  0x0000,   /* U+45DE */
  0x0000,   /* U+45DF */
  0x0000,   /* U+45E0 */
  0x0000,   /* U+45E1 */
  0x0000,   /* U+45E2 */
  0x0000,   /* U+45E3 */
  0x0000,   /* U+45E4 */
  0x0000,   /* U+45E5 */
  0x0000,   /* U+45E6 */
  0x0000,   /* U+45E7 */
  0x0000,   /* U+45E8 */
  0x0000,   /* U+45E9 */
  0x0000,   /* U+45EA */
  0x0000,   /* U+45EB */
  0x0000,   /* U+45EC */
  0x0000,   /* U+45ED */
  0x0000,   /* U+45EE */
  0x0000,   /* U+45EF */
  0x0000,   /* U+45F0 */
  0x0000,   /* U+45F1 */
  0x0000,   /* U+45F2 */
  0x0000,   /* U+45F3 */
  0x0000,   /* U+45F4 */
  0x0000,   /* U+45F5 */
  0x0000,   /* U+45F6 */
  0x0000,   /* U+45F7 */
  0x0000,   /* U+45F8 */
  0x0000,   /* U+45F9 */
  0x0000,   /* U+45FA */
  0x0000,   /* U+45FB */
  0x0000,   /* U+45FC */
  0x0000,   /* U+45FD */
  0x0000,   /* U+45FE */
  0x0000,   /* U+45FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4500 */
  0x0000,   /* U+4501 */
  0x0000,   /* U+4502 */
  0x0000,   /* U+4503 */
  0x0000,   /* U+4504 */
  0x0000,   /* U+4505 */
  0x0000,   /* U+4506 */
  0x0000,   /* U+4507 */
  0x0000,   /* U+4508 */
  0x0000,   /* U+4509 */
  0x0000,   /* U+450A */
  0x0000,   /* U+450B */
  0x0000,   /* U+450C */
  0x0000,   /* U+450D */
  0x0000,   /* U+450E */
  0x0000,   /* U+450F */
  0x0000,   /* U+4510 */
  0x0000,   /* U+4511 */
  0x0000,   /* U+4512 */
  0x0000,   /* U+4513 */
  0x0000,   /* U+4514 */
  0x0000,   /* U+4515 */
  0x0000,   /* U+4516 */
  0x0000,   /* U+4517 */
  0x0000,   /* U+4518 */
  0x0000,   /* U+4519 */
  0x0000,   /* U+451A */
  0x0000,   /* U+451B */
  0x0000,   /* U+451C */
  0x0000,   /* U+451D */
  0x0000,   /* U+451E */
  0x0000,   /* U+451F */
  0x0000,   /* U+4520 */
  0x0000,   /* U+4521 */
  0x0000,   /* U+4522 */
  0x0000,   /* U+4523 */
  0x0000,   /* U+4524 */
  0x0000,   /* U+4525 */
  0x0000,   /* U+4526 */
  0x0000,   /* U+4527 */
  0x0000,   /* U+4528 */
  0x0000,   /* U+4529 */
  0x0000,   /* U+452A */
  0x0000,   /* U+452B */
  0x0000,   /* U+452C */
  0x0000,   /* U+452D */
  0x0000,   /* U+452E */
  0x0000,   /* U+452F */
  0x0000,   /* U+4530 */
  0x0000,   /* U+4531 */
  0x0000,   /* U+4532 */
  0x0000,   /* U+4533 */
  0x0000,   /* U+4534 */
  0x0000,   /* U+4535 */
  0x0000,   /* U+4536 */
  0x0000,   /* U+4537 */
  0x0000,   /* U+4538 */
  0x0000,   /* U+4539 */
  0x0000,   /* U+453A */
  0x0000,   /* U+453B */
  0x0000,   /* U+453C */
  0x0000,   /* U+453D */
  0x0000,   /* U+453E */
  0x0000,   /* U+453F */
  0x0000,   /* U+4540 */
  0x0000,   /* U+4541 */
  0x0000,   /* U+4542 */
  0x0000,   /* U+4543 */
  0x0000,   /* U+4544 */
  0x0000,   /* U+4545 */
  0x0000,   /* U+4546 */
  0x0000,   /* U+4547 */
  0x0000,   /* U+4548 */
  0x0000,   /* U+4549 */
  0x0000,   /* U+454A */
  0x0000,   /* U+454B */
  0x0000,   /* U+454C */
  0x0000,   /* U+454D */
  0x0000,   /* U+454E */
  0x0000,   /* U+454F */
  0x0000,   /* U+4550 */
  0x0000,   /* U+4551 */
  0x0000,   /* U+4552 */
  0x0000,   /* U+4553 */
  0x0000,   /* U+4554 */
  0x0000,   /* U+4555 */
  0x0000,   /* U+4556 */
  0x0000,   /* U+4557 */
  0x0000,   /* U+4558 */
  0x0000,   /* U+4559 */
  0x0000,   /* U+455A */
  0x0000,   /* U+455B */
  0x0000,   /* U+455C */
  0x0000,   /* U+455D */
  0x0000,   /* U+455E */
  0x0000,   /* U+455F */
  0x0000,   /* U+4560 */
  0x0000,   /* U+4561 */
  0x0000,   /* U+4562 */
  0x0000,   /* U+4563 */
  0x0000,   /* U+4564 */
  0x0000,   /* U+4565 */
  0x0000,   /* U+4566 */
  0x0000,   /* U+4567 */
  0x0000,   /* U+4568 */
  0x0000,   /* U+4569 */
  0x0000,   /* U+456A */
  0x0000,   /* U+456B */
  0x0000,   /* U+456C */
  0x0000,   /* U+456D */
  0x0000,   /* U+456E */
  0x0000,   /* U+456F */
  0x0000,   /* U+4570 */
  0x0000,   /* U+4571 */
  0x0000,   /* U+4572 */
  0x0000,   /* U+4573 */
  0x0000,   /* U+4574 */
  0x0000,   /* U+4575 */
  0x0000,   /* U+4576 */
  0x0000,   /* U+4577 */
  0x0000,   /* U+4578 */
  0x0000,   /* U+4579 */
  0x0000,   /* U+457A */
  0x0000,   /* U+457B */
  0x0000,   /* U+457C */
  0x0000,   /* U+457D */
  0x0000,   /* U+457E */
  0x0000,   /* U+457F */
  0x0000,   /* U+4580 */
  0x0000,   /* U+4581 */
  0x0000,   /* U+4582 */
  0x0000,   /* U+4583 */
  0x0000,   /* U+4584 */
  0x0000,   /* U+4585 */
  0x0000,   /* U+4586 */
  0x0000,   /* U+4587 */
  0x0000,   /* U+4588 */
  0x0000,   /* U+4589 */
  0x0000,   /* U+458A */
  0x0000,   /* U+458B */
  0x0000,   /* U+458C */
  0x0000,   /* U+458D */
  0x0000,   /* U+458E */
  0x0000,   /* U+458F */
  0x0000,   /* U+4590 */
  0x0000,   /* U+4591 */
  0x0000,   /* U+4592 */
  0x0000,   /* U+4593 */
  0x0000,   /* U+4594 */
  0x0000,   /* U+4595 */
  0x0000,   /* U+4596 */
  0x0000,   /* U+4597 */
  0x0000,   /* U+4598 */
  0x0000,   /* U+4599 */
  0x0000,   /* U+459A */
  0x0000,   /* U+459B */
  0x0000,   /* U+459C */
  0x0000,   /* U+459D */
  0x0000,   /* U+459E */
  0x0000,   /* U+459F */
  0x0000,   /* U+45A0 */
  0x0000,   /* U+45A1 */
  0x0000,   /* U+45A2 */
  0x0000,   /* U+45A3 */
  0x0000,   /* U+45A4 */
  0x0000,   /* U+45A5 */
  0x0000,   /* U+45A6 */
  0x0000,   /* U+45A7 */
  0x0000,   /* U+45A8 */
  0x0000,   /* U+45A9 */
  0x0000,   /* U+45AA */
  0x0000,   /* U+45AB */
  0x0000,   /* U+45AC */
  0x0000,   /* U+45AD */
  0x0000,   /* U+45AE */
  0x0000,   /* U+45AF */
  0x0000,   /* U+45B0 */
  0x0000,   /* U+45B1 */
  0x0000,   /* U+45B2 */
  0x0000,   /* U+45B3 */
  0x0000,   /* U+45B4 */
  0x0000,   /* U+45B5 */
  0x0000,   /* U+45B6 */
  0x0000,   /* U+45B7 */
  0x0000,   /* U+45B8 */
  0x0000,   /* U+45B9 */
  0x0000,   /* U+45BA */
  0x0000,   /* U+45BB */
  0x0000,   /* U+45BC */
  0x0000,   /* U+45BD */
  0x0000,   /* U+45BE */
  0x0000,   /* U+45BF */
  0x0000,   /* U+45C0 */
  0x0000,   /* U+45C1 */
  0x0000,   /* U+45C2 */
  0x0000,   /* U+45C3 */
  0x0000,   /* U+45C4 */
  0x0000,   /* U+45C5 */
  0x0000,   /* U+45C6 */
  0x0000,   /* U+45C7 */
  0x0000,   /* U+45C8 */
  0x0000,   /* U+45C9 */
  0x0000,   /* U+45CA */
  0x0000,   /* U+45CB */
  0x0000,   /* U+45CC */
  0x0000,   /* U+45CD */
  0x0000,   /* U+45CE */
  0x0000,   /* U+45CF */
  0x0000,   /* U+45D0 */
  0x0000,   /* U+45D1 */
  0x0000,   /* U+45D2 */
  0x0000,   /* U+45D3 */
  0x0000,   /* U+45D4 */
  0x0000,   /* U+45D5 */
  0x0000,   /* U+45D6 */
  0x0000,   /* U+45D7 */
  0x0000,   /* U+45D8 */
  0x0000,   /* U+45D9 */
  0x0000,   /* U+45DA */
  0x0000,   /* U+45DB */
  0x0000,   /* U+45DC */
  0x0000,   /* U+45DD */
  0x0000,   /* U+45DE */
  0x0000,   /* U+45DF */
  0x0000,   /* U+45E0 */
  0x0000,   /* U+45E1 */
  0x0000,   /* U+45E2 */
  0x0000,   /* U+45E3 */
  0x0000,   /* U+45E4 */
  0x0000,   /* U+45E5 */
  0x0000,   /* U+45E6 */
  0x0000,   /* U+45E7 */
  0x0000,   /* U+45E8 */
  0x0000,   /* U+45E9 */
  0x0000,   /* U+45EA */
  0x0000,   /* U+45EB */
  0x0000,   /* U+45EC */
  0x0000,   /* U+45ED */
  0x0000,   /* U+45EE */
  0x0000,   /* U+45EF */
  0x0000,   /* U+45F0 */
  0x0000,   /* U+45F1 */
  0x0000,   /* U+45F2 */
  0x0000,   /* U+45F3 */
  0x0000,   /* U+45F4 */
  0x0000,   /* U+45F5 */
  0x0000,   /* U+45F6 */
  0x0000,   /* U+45F7 */
  0x0000,   /* U+45F8 */
  0x0000,   /* U+45F9 */
  0x0000,   /* U+45FA */
  0x0000,   /* U+45FB */
  0x0000,   /* U+45FC */
  0x0000,   /* U+45FD */
  0x0000,   /* U+45FE */
  0x0000,   /* U+45FF */
};

uint16 zh3_han_p046[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C5B,   /* U+4600 */
  0x1C5B,   /* U+4601 */
  0x1C5C,   /* U+4602 */
  0x1C5C,   /* U+4603 */
  0x1C5C,   /* U+4604 */
  0x1C5D,   /* U+4605 */
  0x1C5D,   /* U+4606 */
  0x1C5D,   /* U+4607 */
  0x1C5D,   /* U+4608 */
  0x1C5D,   /* U+4609 */
  0x1C5E,   /* U+460A */
  0x1C5E,   /* U+460B */
  0x1C5E,   /* U+460C */
  0x1C60,   /* U+460D */
  0x1C63,   /* U+460E */
  0x1C50,   /* U+460F */
  0x1C51,   /* U+4610 */
  0x1C52,   /* U+4611 */
  0x1C54,   /* U+4612 */
  0x1C55,   /* U+4613 */
  0x1C56,   /* U+4614 */
  0x1C51,   /* U+4615 */
  0x1C53,   /* U+4616 */
  0x1C57,   /* U+4617 */
  0x1C57,   /* U+4618 */
  0x1C5B,   /* U+4619 */
  0x1C4F,   /* U+461A */
  0x1C4F,   /* U+461B */
  0x1C50,   /* U+461C */
  0x1C50,   /* U+461D */
  0x1C50,   /* U+461E */
  0x1C51,   /* U+461F */
  0x1C51,   /* U+4620 */
  0x1C51,   /* U+4621 */
  0x1C52,   /* U+4622 */
  0x1C52,   /* U+4623 */
  0x1C52,   /* U+4624 */
  0x1C52,   /* U+4625 */
  0x1C52,   /* U+4626 */
  0x1C52,   /* U+4627 */
  0x1C53,   /* U+4628 */
  0x1C53,   /* U+4629 */
  0x1C53,   /* U+462A */
  0x1C53,   /* U+462B */
  0x1C53,   /* U+462C */
  0x1C53,   /* U+462D */
  0x1C53,   /* U+462E */
  0x1C54,   /* U+462F */
  0x1C54,   /* U+4630 */
  0x1C54,   /* U+4631 */
  0x1C54,   /* U+4632 */
  0x1C55,   /* U+4633 */
  0x1C55,   /* U+4634 */
  0x1C55,   /* U+4635 */
  0x1C55,   /* U+4636 */
  0x1C55,   /* U+4637 */
  0x1C55,   /* U+4638 */
  0x1C55,   /* U+4639 */
  0x1C55,   /* U+463A */
  0x1C55,   /* U+463B */
  0x1C55,   /* U+463C */
  0x1C55,   /* U+463D */
  0x1C55,   /* U+463E */
  0x1C55,   /* U+463F */
  0x1C55,   /* U+4640 */
  0x1C55,   /* U+4641 */
  0x1C55,   /* U+4642 */
  0x1C56,   /* U+4643 */
  0x1C56,   /* U+4644 */
  0x1C56,   /* U+4645 */
  0x1C56,   /* U+4646 */
  0x1C56,   /* U+4647 */
  0x1C56,   /* U+4648 */
  0x1C56,   /* U+4649 */
  0x1C56,   /* U+464A */
  0x1C56,   /* U+464B */
  0x1C56,   /* U+464C */
  0x1C56,   /* U+464D */
  0x1C57,   /* U+464E */
  0x1C57,   /* U+464F */
  0x1C57,   /* U+4650 */
  0x1C57,   /* U+4651 */
  0x1C57,   /* U+4652 */
  0x1C57,   /* U+4653 */
  0x1C58,   /* U+4654 */
  0x1C58,   /* U+4655 */
  0x1C58,   /* U+4656 */
  0x1C58,   /* U+4657 */
  0x1C58,   /* U+4658 */
  0x1C58,   /* U+4659 */
  0x1C58,   /* U+465A */
  0x1C58,   /* U+465B */
  0x1C58,   /* U+465C */
  0x1C58,   /* U+465D */
  0x1C59,   /* U+465E */
  0x1C59,   /* U+465F */
  0x1C59,   /* U+4660 */
  0x1C59,   /* U+4661 */
  0x1C59,   /* U+4662 */
  0x1C59,   /* U+4663 */
  0x1C5A,   /* U+4664 */
  0x1C5A,   /* U+4665 */
  0x1C5B,   /* U+4666 */
  0x1C5B,   /* U+4667 */
  0x1C5B,   /* U+4668 */
  0x1C5B,   /* U+4669 */
  0x1C5C,   /* U+466A */
  0x1C5D,   /* U+466B */
  0x1C5E,   /* U+466C */
  0x1C5E,   /* U+466D */
  0x1C5F,   /* U+466E */
  0x1C5F,   /* U+466F */
  0x1C60,   /* U+4670 */
  0x1C62,   /* U+4671 */
  0x1C50,   /* U+4672 */
  0x1C51,   /* U+4673 */
  0x1C52,   /* U+4674 */
  0x1C53,   /* U+4675 */
  0x1C53,   /* U+4676 */
  0x1C51,   /* U+4677 */
  0x1C51,   /* U+4678 */
  0x1C52,   /* U+4679 */
  0x1C52,   /* U+467A */
  0x1C52,   /* U+467B */
  0x1C53,   /* U+467C */
  0x1C53,   /* U+467D */
  0x1C53,   /* U+467E */
  0x1C53,   /* U+467F */
  0x1C54,   /* U+4680 */
  0x1C54,   /* U+4681 */
  0x1C55,   /* U+4682 */
  0x1C55,   /* U+4683 */
  0x1C56,   /* U+4684 */
  0x1C56,   /* U+4685 */
  0x1C57,   /* U+4686 */
  0x1C57,   /* U+4687 */
  0x1C57,   /* U+4688 */
  0x1C57,   /* U+4689 */
  0x1C58,   /* U+468A */
  0x1C58,   /* U+468B */
  0x1C58,   /* U+468C */
  0x1C59,   /* U+468D */
  0x1C59,   /* U+468E */
  0x1C5A,   /* U+468F */
  0x1C5A,   /* U+4690 */
  0x1C5A,   /* U+4691 */
  0x1C5A,   /* U+4692 */
  0x1C5A,   /* U+4693 */
  0x1C5C,   /* U+4694 */
  0x1C61,   /* U+4695 */
  0x1C66,   /* U+4696 */
  0x1C52,   /* U+4697 */
  0x1C54,   /* U+4698 */
  0x1C54,   /* U+4699 */
  0x1C54,   /* U+469A */
  0x1C55,   /* U+469B */
  0x1C56,   /* U+469C */
  0x1C56,   /* U+469D */
  0x1C56,   /* U+469E */
  0x1C56,   /* U+469F */
  0x1C56,   /* U+46A0 */
  0x1C57,   /* U+46A1 */
  0x1C57,   /* U+46A2 */
  0x1C57,   /* U+46A3 */
  0x1C57,   /* U+46A4 */
  0x1C58,   /* U+46A5 */
  0x1C58,   /* U+46A6 */
  0x1C59,   /* U+46A7 */
  0x1C5A,   /* U+46A8 */
  0x1C5A,   /* U+46A9 */
  0x1C5B,   /* U+46AA */
  0x1C5B,   /* U+46AB */
  0x1C5A,   /* U+46AC */
  0x1C60,   /* U+46AD */
  0x1C50,   /* U+46AE */
  0x1C50,   /* U+46AF */
  0x1C50,   /* U+46B0 */
  0x1C51,   /* U+46B1 */
  0x1C51,   /* U+46B2 */
  0x1C52,   /* U+46B3 */
  0x1C52,   /* U+46B4 */
  0x1C52,   /* U+46B5 */
  0x1C52,   /* U+46B6 */
  0x1C52,   /* U+46B7 */
  0x1C52,   /* U+46B8 */
  0x1C52,   /* U+46B9 */
  0x1C52,   /* U+46BA */
  0x1C52,   /* U+46BB */
  0x1C52,   /* U+46BC */
  0x1C52,   /* U+46BD */
  0x1C52,   /* U+46BE */
  0x1C52,   /* U+46BF */
  0x1C52,   /* U+46C0 */
  0x1C52,   /* U+46C1 */
  0x1C52,   /* U+46C2 */
  0x1C52,   /* U+46C3 */
  0x1C53,   /* U+46C4 */
  0x1C53,   /* U+46C5 */
  0x1C53,   /* U+46C6 */
  0x1C53,   /* U+46C7 */
  0x1C53,   /* U+46C8 */
  0x1C53,   /* U+46C9 */
  0x1C53,   /* U+46CA */
  0x1C53,   /* U+46CB */
  0x1C53,   /* U+46CC */
  0x1C53,   /* U+46CD */
  0x1C53,   /* U+46CE */
  0x1C53,   /* U+46CF */
  0x1C53,   /* U+46D0 */
  0x1C53,   /* U+46D1 */
  0x1C53,   /* U+46D2 */
  0x1C53,   /* U+46D3 */
  0x1C54,   /* U+46D4 */
  0x1C54,   /* U+46D5 */
  0x1C54,   /* U+46D6 */
  0x1C54,   /* U+46D7 */
  0x1C54,   /* U+46D8 */
  0x1C54,   /* U+46D9 */
  0x1C54,   /* U+46DA */
  0x1C54,   /* U+46DB */
  0x1C54,   /* U+46DC */
  0x1C55,   /* U+46DD */
  0x1C55,   /* U+46DE */
  0x1C55,   /* U+46DF */
  0x1C55,   /* U+46E0 */
  0x1C55,   /* U+46E1 */
  0x1C55,   /* U+46E2 */
  0x1C55,   /* U+46E3 */
  0x1C55,   /* U+46E4 */
  0x1C55,   /* U+46E5 */
  0x1C55,   /* U+46E6 */
  0x1C55,   /* U+46E7 */
  0x1C55,   /* U+46E8 */
  0x1C56,   /* U+46E9 */
  0x1C56,   /* U+46EA */
  0x1C56,   /* U+46EB */
  0x1C56,   /* U+46EC */
  0x1C56,   /* U+46ED */
  0x1C56,   /* U+46EE */
  0x1C56,   /* U+46EF */
  0x1C56,   /* U+46F0 */
  0x1C56,   /* U+46F1 */
  0x1C56,   /* U+46F2 */
  0x1C56,   /* U+46F3 */
  0x1C56,   /* U+46F4 */
  0x1C56,   /* U+46F5 */
  0x1C56,   /* U+46F6 */
  0x1C56,   /* U+46F7 */
  0x1C56,   /* U+46F8 */
  0x1C57,   /* U+46F9 */
  0x1C57,   /* U+46FA */
  0x1C57,   /* U+46FB */
  0x1C57,   /* U+46FC */
  0x1C57,   /* U+46FD */
  0x1C58,   /* U+46FE */
  0x1C58,   /* U+46FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4600 */
  0x0020,   /* U+4601 */
  0x0020,   /* U+4602 */
  0x0020,   /* U+4603 */
  0x0020,   /* U+4604 */
  0x0020,   /* U+4605 */
  0x0020,   /* U+4606 */
  0x0020,   /* U+4607 */
  0x0020,   /* U+4608 */
  0x0020,   /* U+4609 */
  0x0020,   /* U+460A */
  0x0020,   /* U+460B */
  0x0020,   /* U+460C */
  0x0020,   /* U+460D */
  0x0020,   /* U+460E */
  0x0020,   /* U+460F */
  0x0020,   /* U+4610 */
  0x0020,   /* U+4611 */
  0x0020,   /* U+4612 */
  0x0020,   /* U+4613 */
  0x0020,   /* U+4614 */
  0x0020,   /* U+4615 */
  0x0020,   /* U+4616 */
  0x0020,   /* U+4617 */
  0x0020,   /* U+4618 */
  0x0020,   /* U+4619 */
  0x0020,   /* U+461A */
  0x0020,   /* U+461B */
  0x0020,   /* U+461C */
  0x0020,   /* U+461D */
  0x0020,   /* U+461E */
  0x0020,   /* U+461F */
  0x0020,   /* U+4620 */
  0x0020,   /* U+4621 */
  0x0020,   /* U+4622 */
  0x0020,   /* U+4623 */
  0x0020,   /* U+4624 */
  0x0020,   /* U+4625 */
  0x0020,   /* U+4626 */
  0x0020,   /* U+4627 */
  0x0020,   /* U+4628 */
  0x0020,   /* U+4629 */
  0x0020,   /* U+462A */
  0x0020,   /* U+462B */
  0x0020,   /* U+462C */
  0x0020,   /* U+462D */
  0x0020,   /* U+462E */
  0x0020,   /* U+462F */
  0x0020,   /* U+4630 */
  0x0020,   /* U+4631 */
  0x0020,   /* U+4632 */
  0x0020,   /* U+4633 */
  0x0020,   /* U+4634 */
  0x0020,   /* U+4635 */
  0x0020,   /* U+4636 */
  0x0020,   /* U+4637 */
  0x0020,   /* U+4638 */
  0x0020,   /* U+4639 */
  0x0020,   /* U+463A */
  0x0020,   /* U+463B */
  0x0020,   /* U+463C */
  0x0020,   /* U+463D */
  0x0020,   /* U+463E */
  0x0020,   /* U+463F */
  0x0020,   /* U+4640 */
  0x0020,   /* U+4641 */
  0x0020,   /* U+4642 */
  0x0020,   /* U+4643 */
  0x0020,   /* U+4644 */
  0x0020,   /* U+4645 */
  0x0020,   /* U+4646 */
  0x0020,   /* U+4647 */
  0x0020,   /* U+4648 */
  0x0020,   /* U+4649 */
  0x0020,   /* U+464A */
  0x0020,   /* U+464B */
  0x0020,   /* U+464C */
  0x0020,   /* U+464D */
  0x0020,   /* U+464E */
  0x0020,   /* U+464F */
  0x0020,   /* U+4650 */
  0x0020,   /* U+4651 */
  0x0020,   /* U+4652 */
  0x0020,   /* U+4653 */
  0x0020,   /* U+4654 */
  0x0020,   /* U+4655 */
  0x0020,   /* U+4656 */
  0x0020,   /* U+4657 */
  0x0020,   /* U+4658 */
  0x0020,   /* U+4659 */
  0x0020,   /* U+465A */
  0x0020,   /* U+465B */
  0x0020,   /* U+465C */
  0x0020,   /* U+465D */
  0x0020,   /* U+465E */
  0x0020,   /* U+465F */
  0x0020,   /* U+4660 */
  0x0020,   /* U+4661 */
  0x0020,   /* U+4662 */
  0x0020,   /* U+4663 */
  0x0020,   /* U+4664 */
  0x0020,   /* U+4665 */
  0x0020,   /* U+4666 */
  0x0020,   /* U+4667 */
  0x0020,   /* U+4668 */
  0x0020,   /* U+4669 */
  0x0020,   /* U+466A */
  0x0020,   /* U+466B */
  0x0020,   /* U+466C */
  0x0020,   /* U+466D */
  0x0020,   /* U+466E */
  0x0020,   /* U+466F */
  0x0020,   /* U+4670 */
  0x0020,   /* U+4671 */
  0x0020,   /* U+4672 */
  0x0020,   /* U+4673 */
  0x0020,   /* U+4674 */
  0x0020,   /* U+4675 */
  0x0020,   /* U+4676 */
  0x0020,   /* U+4677 */
  0x0020,   /* U+4678 */
  0x0020,   /* U+4679 */
  0x0020,   /* U+467A */
  0x0020,   /* U+467B */
  0x0020,   /* U+467C */
  0x0020,   /* U+467D */
  0x0020,   /* U+467E */
  0x0020,   /* U+467F */
  0x0020,   /* U+4680 */
  0x0020,   /* U+4681 */
  0x0020,   /* U+4682 */
  0x0020,   /* U+4683 */
  0x0020,   /* U+4684 */
  0x0020,   /* U+4685 */
  0x0020,   /* U+4686 */
  0x0020,   /* U+4687 */
  0x0020,   /* U+4688 */
  0x0020,   /* U+4689 */
  0x0020,   /* U+468A */
  0x0020,   /* U+468B */
  0x0020,   /* U+468C */
  0x0020,   /* U+468D */
  0x0020,   /* U+468E */
  0x0020,   /* U+468F */
  0x0020,   /* U+4690 */
  0x0020,   /* U+4691 */
  0x0020,   /* U+4692 */
  0x0020,   /* U+4693 */
  0x0020,   /* U+4694 */
  0x0020,   /* U+4695 */
  0x0020,   /* U+4696 */
  0x0020,   /* U+4697 */
  0x0020,   /* U+4698 */
  0x0020,   /* U+4699 */
  0x0020,   /* U+469A */
  0x0020,   /* U+469B */
  0x0020,   /* U+469C */
  0x0020,   /* U+469D */
  0x0020,   /* U+469E */
  0x0020,   /* U+469F */
  0x0020,   /* U+46A0 */
  0x0020,   /* U+46A1 */
  0x0020,   /* U+46A2 */
  0x0020,   /* U+46A3 */
  0x0020,   /* U+46A4 */
  0x0020,   /* U+46A5 */
  0x0020,   /* U+46A6 */
  0x0020,   /* U+46A7 */
  0x0020,   /* U+46A8 */
  0x0020,   /* U+46A9 */
  0x0020,   /* U+46AA */
  0x0020,   /* U+46AB */
  0x0020,   /* U+46AC */
  0x0020,   /* U+46AD */
  0x0020,   /* U+46AE */
  0x0020,   /* U+46AF */
  0x0020,   /* U+46B0 */
  0x0020,   /* U+46B1 */
  0x0020,   /* U+46B2 */
  0x0020,   /* U+46B3 */
  0x0020,   /* U+46B4 */
  0x0020,   /* U+46B5 */
  0x0020,   /* U+46B6 */
  0x0020,   /* U+46B7 */
  0x0020,   /* U+46B8 */
  0x0020,   /* U+46B9 */
  0x0020,   /* U+46BA */
  0x0020,   /* U+46BB */
  0x0020,   /* U+46BC */
  0x0020,   /* U+46BD */
  0x0020,   /* U+46BE */
  0x0020,   /* U+46BF */
  0x0020,   /* U+46C0 */
  0x0020,   /* U+46C1 */
  0x0020,   /* U+46C2 */
  0x0020,   /* U+46C3 */
  0x0020,   /* U+46C4 */
  0x0020,   /* U+46C5 */
  0x0020,   /* U+46C6 */
  0x0020,   /* U+46C7 */
  0x0020,   /* U+46C8 */
  0x0020,   /* U+46C9 */
  0x0020,   /* U+46CA */
  0x0020,   /* U+46CB */
  0x0020,   /* U+46CC */
  0x0020,   /* U+46CD */
  0x0020,   /* U+46CE */
  0x0020,   /* U+46CF */
  0x0020,   /* U+46D0 */
  0x0020,   /* U+46D1 */
  0x0020,   /* U+46D2 */
  0x0020,   /* U+46D3 */
  0x0020,   /* U+46D4 */
  0x0020,   /* U+46D5 */
  0x0020,   /* U+46D6 */
  0x0020,   /* U+46D7 */
  0x0020,   /* U+46D8 */
  0x0020,   /* U+46D9 */
  0x0020,   /* U+46DA */
  0x0020,   /* U+46DB */
  0x0020,   /* U+46DC */
  0x0020,   /* U+46DD */
  0x0020,   /* U+46DE */
  0x0020,   /* U+46DF */
  0x0020,   /* U+46E0 */
  0x0020,   /* U+46E1 */
  0x0020,   /* U+46E2 */
  0x0020,   /* U+46E3 */
  0x0020,   /* U+46E4 */
  0x0020,   /* U+46E5 */
  0x0020,   /* U+46E6 */
  0x0020,   /* U+46E7 */
  0x0020,   /* U+46E8 */
  0x0020,   /* U+46E9 */
  0x0020,   /* U+46EA */
  0x0020,   /* U+46EB */
  0x0020,   /* U+46EC */
  0x0020,   /* U+46ED */
  0x0020,   /* U+46EE */
  0x0020,   /* U+46EF */
  0x0020,   /* U+46F0 */
  0x0020,   /* U+46F1 */
  0x0020,   /* U+46F2 */
  0x0020,   /* U+46F3 */
  0x0020,   /* U+46F4 */
  0x0020,   /* U+46F5 */
  0x0020,   /* U+46F6 */
  0x0020,   /* U+46F7 */
  0x0020,   /* U+46F8 */
  0x0020,   /* U+46F9 */
  0x0020,   /* U+46FA */
  0x0020,   /* U+46FB */
  0x0020,   /* U+46FC */
  0x0020,   /* U+46FD */
  0x0020,   /* U+46FE */
  0x0020,   /* U+46FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4600 */
  0x0002,   /* U+4601 */
  0x0002,   /* U+4602 */
  0x0002,   /* U+4603 */
  0x0002,   /* U+4604 */
  0x0002,   /* U+4605 */
  0x0002,   /* U+4606 */
  0x0002,   /* U+4607 */
  0x0002,   /* U+4608 */
  0x0002,   /* U+4609 */
  0x0002,   /* U+460A */
  0x0002,   /* U+460B */
  0x0002,   /* U+460C */
  0x0002,   /* U+460D */
  0x0002,   /* U+460E */
  0x0002,   /* U+460F */
  0x0002,   /* U+4610 */
  0x0002,   /* U+4611 */
  0x0002,   /* U+4612 */
  0x0002,   /* U+4613 */
  0x0002,   /* U+4614 */
  0x0002,   /* U+4615 */
  0x0002,   /* U+4616 */
  0x0002,   /* U+4617 */
  0x0002,   /* U+4618 */
  0x0002,   /* U+4619 */
  0x0002,   /* U+461A */
  0x0002,   /* U+461B */
  0x0002,   /* U+461C */
  0x0002,   /* U+461D */
  0x0002,   /* U+461E */
  0x0002,   /* U+461F */
  0x0002,   /* U+4620 */
  0x0002,   /* U+4621 */
  0x0002,   /* U+4622 */
  0x0002,   /* U+4623 */
  0x0002,   /* U+4624 */
  0x0002,   /* U+4625 */
  0x0002,   /* U+4626 */
  0x0002,   /* U+4627 */
  0x0002,   /* U+4628 */
  0x0002,   /* U+4629 */
  0x0002,   /* U+462A */
  0x0002,   /* U+462B */
  0x0002,   /* U+462C */
  0x0002,   /* U+462D */
  0x0002,   /* U+462E */
  0x0002,   /* U+462F */
  0x0002,   /* U+4630 */
  0x0002,   /* U+4631 */
  0x0002,   /* U+4632 */
  0x0002,   /* U+4633 */
  0x0002,   /* U+4634 */
  0x0002,   /* U+4635 */
  0x0002,   /* U+4636 */
  0x0002,   /* U+4637 */
  0x0002,   /* U+4638 */
  0x0002,   /* U+4639 */
  0x0002,   /* U+463A */
  0x0002,   /* U+463B */
  0x0002,   /* U+463C */
  0x0002,   /* U+463D */
  0x0002,   /* U+463E */
  0x0002,   /* U+463F */
  0x0002,   /* U+4640 */
  0x0002,   /* U+4641 */
  0x0002,   /* U+4642 */
  0x0002,   /* U+4643 */
  0x0002,   /* U+4644 */
  0x0002,   /* U+4645 */
  0x0002,   /* U+4646 */
  0x0002,   /* U+4647 */
  0x0002,   /* U+4648 */
  0x0002,   /* U+4649 */
  0x0002,   /* U+464A */
  0x0002,   /* U+464B */
  0x0002,   /* U+464C */
  0x0002,   /* U+464D */
  0x0002,   /* U+464E */
  0x0002,   /* U+464F */
  0x0002,   /* U+4650 */
  0x0002,   /* U+4651 */
  0x0002,   /* U+4652 */
  0x0002,   /* U+4653 */
  0x0002,   /* U+4654 */
  0x0002,   /* U+4655 */
  0x0002,   /* U+4656 */
  0x0002,   /* U+4657 */
  0x0002,   /* U+4658 */
  0x0002,   /* U+4659 */
  0x0002,   /* U+465A */
  0x0002,   /* U+465B */
  0x0002,   /* U+465C */
  0x0002,   /* U+465D */
  0x0002,   /* U+465E */
  0x0002,   /* U+465F */
  0x0002,   /* U+4660 */
  0x0002,   /* U+4661 */
  0x0002,   /* U+4662 */
  0x0002,   /* U+4663 */
  0x0002,   /* U+4664 */
  0x0002,   /* U+4665 */
  0x0002,   /* U+4666 */
  0x0002,   /* U+4667 */
  0x0002,   /* U+4668 */
  0x0002,   /* U+4669 */
  0x0002,   /* U+466A */
  0x0002,   /* U+466B */
  0x0002,   /* U+466C */
  0x0002,   /* U+466D */
  0x0002,   /* U+466E */
  0x0002,   /* U+466F */
  0x0002,   /* U+4670 */
  0x0002,   /* U+4671 */
  0x0002,   /* U+4672 */
  0x0002,   /* U+4673 */
  0x0002,   /* U+4674 */
  0x0002,   /* U+4675 */
  0x0002,   /* U+4676 */
  0x0002,   /* U+4677 */
  0x0002,   /* U+4678 */
  0x0002,   /* U+4679 */
  0x0002,   /* U+467A */
  0x0002,   /* U+467B */
  0x0002,   /* U+467C */
  0x0002,   /* U+467D */
  0x0002,   /* U+467E */
  0x0002,   /* U+467F */
  0x0002,   /* U+4680 */
  0x0002,   /* U+4681 */
  0x0002,   /* U+4682 */
  0x0002,   /* U+4683 */
  0x0002,   /* U+4684 */
  0x0002,   /* U+4685 */
  0x0002,   /* U+4686 */
  0x0002,   /* U+4687 */
  0x0002,   /* U+4688 */
  0x0002,   /* U+4689 */
  0x0002,   /* U+468A */
  0x0002,   /* U+468B */
  0x0002,   /* U+468C */
  0x0002,   /* U+468D */
  0x0002,   /* U+468E */
  0x0002,   /* U+468F */
  0x0002,   /* U+4690 */
  0x0002,   /* U+4691 */
  0x0002,   /* U+4692 */
  0x0002,   /* U+4693 */
  0x0002,   /* U+4694 */
  0x0002,   /* U+4695 */
  0x0002,   /* U+4696 */
  0x0002,   /* U+4697 */
  0x0002,   /* U+4698 */
  0x0002,   /* U+4699 */
  0x0002,   /* U+469A */
  0x0002,   /* U+469B */
  0x0002,   /* U+469C */
  0x0002,   /* U+469D */
  0x0002,   /* U+469E */
  0x0002,   /* U+469F */
  0x0002,   /* U+46A0 */
  0x0002,   /* U+46A1 */
  0x0002,   /* U+46A2 */
  0x0002,   /* U+46A3 */
  0x0002,   /* U+46A4 */
  0x0002,   /* U+46A5 */
  0x0002,   /* U+46A6 */
  0x0002,   /* U+46A7 */
  0x0002,   /* U+46A8 */
  0x0002,   /* U+46A9 */
  0x0002,   /* U+46AA */
  0x0002,   /* U+46AB */
  0x0002,   /* U+46AC */
  0x0002,   /* U+46AD */
  0x0002,   /* U+46AE */
  0x0002,   /* U+46AF */
  0x0002,   /* U+46B0 */
  0x0002,   /* U+46B1 */
  0x0002,   /* U+46B2 */
  0x0002,   /* U+46B3 */
  0x0002,   /* U+46B4 */
  0x0002,   /* U+46B5 */
  0x0002,   /* U+46B6 */
  0x0002,   /* U+46B7 */
  0x0002,   /* U+46B8 */
  0x0002,   /* U+46B9 */
  0x0002,   /* U+46BA */
  0x0002,   /* U+46BB */
  0x0002,   /* U+46BC */
  0x0002,   /* U+46BD */
  0x0002,   /* U+46BE */
  0x0002,   /* U+46BF */
  0x0002,   /* U+46C0 */
  0x0002,   /* U+46C1 */
  0x0002,   /* U+46C2 */
  0x0002,   /* U+46C3 */
  0x0002,   /* U+46C4 */
  0x0002,   /* U+46C5 */
  0x0002,   /* U+46C6 */
  0x0002,   /* U+46C7 */
  0x0002,   /* U+46C8 */
  0x0002,   /* U+46C9 */
  0x0002,   /* U+46CA */
  0x0002,   /* U+46CB */
  0x0002,   /* U+46CC */
  0x0002,   /* U+46CD */
  0x0002,   /* U+46CE */
  0x0002,   /* U+46CF */
  0x0002,   /* U+46D0 */
  0x0002,   /* U+46D1 */
  0x0002,   /* U+46D2 */
  0x0002,   /* U+46D3 */
  0x0002,   /* U+46D4 */
  0x0002,   /* U+46D5 */
  0x0002,   /* U+46D6 */
  0x0002,   /* U+46D7 */
  0x0002,   /* U+46D8 */
  0x0002,   /* U+46D9 */
  0x0002,   /* U+46DA */
  0x0002,   /* U+46DB */
  0x0002,   /* U+46DC */
  0x0002,   /* U+46DD */
  0x0002,   /* U+46DE */
  0x0002,   /* U+46DF */
  0x0002,   /* U+46E0 */
  0x0002,   /* U+46E1 */
  0x0002,   /* U+46E2 */
  0x0002,   /* U+46E3 */
  0x0002,   /* U+46E4 */
  0x0002,   /* U+46E5 */
  0x0002,   /* U+46E6 */
  0x0002,   /* U+46E7 */
  0x0002,   /* U+46E8 */
  0x0002,   /* U+46E9 */
  0x0002,   /* U+46EA */
  0x0002,   /* U+46EB */
  0x0002,   /* U+46EC */
  0x0002,   /* U+46ED */
  0x0002,   /* U+46EE */
  0x0002,   /* U+46EF */
  0x0002,   /* U+46F0 */
  0x0002,   /* U+46F1 */
  0x0002,   /* U+46F2 */
  0x0002,   /* U+46F3 */
  0x0002,   /* U+46F4 */
  0x0002,   /* U+46F5 */
  0x0002,   /* U+46F6 */
  0x0002,   /* U+46F7 */
  0x0002,   /* U+46F8 */
  0x0002,   /* U+46F9 */
  0x0002,   /* U+46FA */
  0x0002,   /* U+46FB */
  0x0002,   /* U+46FC */
  0x0002,   /* U+46FD */
  0x0002,   /* U+46FE */
  0x0002,   /* U+46FF */

  /* Primary weight 2 for each character. */
  0x858A,   /* U+4600 */
  0x858B,   /* U+4601 */
  0x8461,   /* U+4602 */
  0x8462,   /* U+4603 */
  0x8463,   /* U+4604 */
  0x8313,   /* U+4605 */
  0x8314,   /* U+4606 */
  0x8315,   /* U+4607 */
  0x8316,   /* U+4608 */
  0x8317,   /* U+4609 */
  0x822E,   /* U+460A */
  0x822F,   /* U+460B */
  0x8230,   /* U+460C */
  0x80FF,   /* U+460D */
  0x804F,   /* U+460E */
  0x925D,   /* U+460F */
  0x9598,   /* U+4610 */
  0x96D2,   /* U+4611 */
  0x96C6,   /* U+4612 */
  0x95B7,   /* U+4613 */
  0x93C2,   /* U+4614 */
  0x95A0,   /* U+4615 */
  0x98B1,   /* U+4616 */
  0x90FC,   /* U+4617 */
  0x90FD,   /* U+4618 */
  0x85C8,   /* U+4619 */
  0x8EC1,   /* U+461A */
  0x8EC2,   /* U+461B */
  0x926D,   /* U+461C */
  0x926E,   /* U+461D */
  0x926F,   /* U+461E */
  0x95C2,   /* U+461F */
  0x95C3,   /* U+4620 */
  0x95C4,   /* U+4621 */
  0x9709,   /* U+4622 */
  0x970A,   /* U+4623 */
  0x970B,   /* U+4624 */
  0x970C,   /* U+4625 */
  0x970D,   /* U+4626 */
  0x970E,   /* U+4627 */
  0x98D5,   /* U+4628 */
  0x98D6,   /* U+4629 */
  0x98D7,   /* U+462A */
  0x98D8,   /* U+462B */
  0x98D9,   /* U+462C */
  0x98DA,   /* U+462D */
  0x98DB,   /* U+462E */
  0x96F2,   /* U+462F */
  0x96F3,   /* U+4630 */
  0x96F4,   /* U+4631 */
  0x96F5,   /* U+4632 */
  0x95E1,   /* U+4633 */
  0x95E2,   /* U+4634 */
  0x95E3,   /* U+4635 */
  0x95E4,   /* U+4636 */
  0x95E5,   /* U+4637 */
  0x95E6,   /* U+4638 */
  0x95E7,   /* U+4639 */
  0x95E8,   /* U+463A */
  0x95E9,   /* U+463B */
  0x95EA,   /* U+463C */
  0x95EB,   /* U+463D */
  0x95EC,   /* U+463E */
  0x95ED,   /* U+463F */
  0x95EE,   /* U+4640 */
  0x95EF,   /* U+4641 */
  0x95F0,   /* U+4642 */
  0x93EB,   /* U+4643 */
  0x93EC,   /* U+4644 */
  0x93ED,   /* U+4645 */
  0x93EE,   /* U+4646 */
  0x93EF,   /* U+4647 */
  0x93F0,   /* U+4648 */
  0x93F1,   /* U+4649 */
  0x93F2,   /* U+464A */
  0x93F3,   /* U+464B */
  0x93F4,   /* U+464C */
  0x93F5,   /* U+464D */
  0x9116,   /* U+464E */
  0x9117,   /* U+464F */
  0x9118,   /* U+4650 */
  0x9119,   /* U+4651 */
  0x911A,   /* U+4652 */
  0x911B,   /* U+4653 */
  0x8D11,   /* U+4654 */
  0x8D12,   /* U+4655 */
  0x8D13,   /* U+4656 */
  0x8D14,   /* U+4657 */
  0x8D15,   /* U+4658 */
  0x8D16,   /* U+4659 */
  0x8D17,   /* U+465A */
  0x8D18,   /* U+465B */
  0x8D19,   /* U+465C */
  0x8D1A,   /* U+465D */
  0x8AD0,   /* U+465E */
  0x8AD1,   /* U+465F */
  0x8AD2,   /* U+4660 */
  0x8AD3,   /* U+4661 */
  0x8AD4,   /* U+4662 */
  0x8AD5,   /* U+4663 */
  0x87E4,   /* U+4664 */
  0x87E5,   /* U+4665 */
  0x85D0,   /* U+4666 */
  0x85D1,   /* U+4667 */
  0x85D2,   /* U+4668 */
  0x85D3,   /* U+4669 */
  0x84A5,   /* U+466A */
  0x834A,   /* U+466B */
  0x8250,   /* U+466C */
  0x8251,   /* U+466D */
  0x81BE,   /* U+466E */
  0x81BF,   /* U+466F */
  0x8114,   /* U+4670 */
  0x8090,   /* U+4671 */
  0x929D,   /* U+4672 */
  0x95F5,   /* U+4673 */
  0x9751,   /* U+4674 */
  0x991A,   /* U+4675 */
  0x991B,   /* U+4676 */
  0x95FC,   /* U+4677 */
  0x95FD,   /* U+4678 */
  0x975E,   /* U+4679 */
  0x975F,   /* U+467A */
  0x9760,   /* U+467B */
  0x9927,   /* U+467C */
  0x9928,   /* U+467D */
  0x9929,   /* U+467E */
  0x992A,   /* U+467F */
  0x9740,   /* U+4680 */
  0x9741,   /* U+4681 */
  0x9640,   /* U+4682 */
  0x9641,   /* U+4683 */
  0x9436,   /* U+4684 */
  0x9437,   /* U+4685 */
  0x9158,   /* U+4686 */
  0x9159,   /* U+4687 */
  0x915A,   /* U+4688 */
  0x915B,   /* U+4689 */
  0x8D66,   /* U+468A */
  0x8D67,   /* U+468B */
  0x8D68,   /* U+468C */
  0x8B03,   /* U+468D */
  0x8B04,   /* U+468E */
  0x880E,   /* U+468F */
  0x880F,   /* U+4690 */
  0x8810,   /* U+4691 */
  0x8811,   /* U+4692 */
  0x8812,   /* U+4693 */
  0x84B9,   /* U+4694 */
  0x80BE,   /* U+4695 */
  0x8011,   /* U+4696 */
  0x977D,   /* U+4697 */
  0x9768,   /* U+4698 */
  0x9769,   /* U+4699 */
  0x976A,   /* U+469A */
  0x965F,   /* U+469B */
  0x9460,   /* U+469C */
  0x9461,   /* U+469D */
  0x9462,   /* U+469E */
  0x9463,   /* U+469F */
  0x9464,   /* U+46A0 */
  0x917A,   /* U+46A1 */
  0x917B,   /* U+46A2 */
  0x917C,   /* U+46A3 */
  0x917D,   /* U+46A4 */
  0x8D7A,   /* U+46A5 */
  0x8D7B,   /* U+46A6 */
  0x8B16,   /* U+46A7 */
  0x881E,   /* U+46A8 */
  0x881F,   /* U+46A9 */
  0x85F8,   /* U+46AA */
  0x85F9,   /* U+46AB */
  0x8820,   /* U+46AC */
  0x8128,   /* U+46AD */
  0x92BA,   /* U+46AE */
  0x92BB,   /* U+46AF */
  0x92BC,   /* U+46B0 */
  0x9620,   /* U+46B1 */
  0x9621,   /* U+46B2 */
  0x97B3,   /* U+46B3 */
  0x97B4,   /* U+46B4 */
  0x97B5,   /* U+46B5 */
  0x97B6,   /* U+46B6 */
  0x97B7,   /* U+46B7 */
  0x97B8,   /* U+46B8 */
  0x97B9,   /* U+46B9 */
  0x97BA,   /* U+46BA */
  0x97BB,   /* U+46BB */
  0x97BC,   /* U+46BC */
  0x97BD,   /* U+46BD */
  0x97BE,   /* U+46BE */
  0x97BF,   /* U+46BF */
  0x97C0,   /* U+46C0 */
  0x97C1,   /* U+46C1 */
  0x97C2,   /* U+46C2 */
  0x97C3,   /* U+46C3 */
  0x9984,   /* U+46C4 */
  0x9985,   /* U+46C5 */
  0x9986,   /* U+46C6 */
  0x9987,   /* U+46C7 */
  0x9988,   /* U+46C8 */
  0x9989,   /* U+46C9 */
  0x998A,   /* U+46CA */
  0x998B,   /* U+46CB */
  0x998C,   /* U+46CC */
  0x998D,   /* U+46CD */
  0x998E,   /* U+46CE */
  0x998F,   /* U+46CF */
  0x9990,   /* U+46D0 */
  0x9991,   /* U+46D1 */
  0x9992,   /* U+46D2 */
  0x9993,   /* U+46D3 */
  0x97AA,   /* U+46D4 */
  0x97AB,   /* U+46D5 */
  0x97AC,   /* U+46D6 */
  0x97AD,   /* U+46D7 */
  0x97AE,   /* U+46D8 */
  0x97AF,   /* U+46D9 */
  0x97B0,   /* U+46DA */
  0x97B1,   /* U+46DB */
  0x97B2,   /* U+46DC */
  0x9692,   /* U+46DD */
  0x9693,   /* U+46DE */
  0x9694,   /* U+46DF */
  0x9695,   /* U+46E0 */
  0x9696,   /* U+46E1 */
  0x9697,   /* U+46E2 */
  0x9698,   /* U+46E3 */
  0x9699,   /* U+46E4 */
  0x969A,   /* U+46E5 */
  0x969B,   /* U+46E6 */
  0x969C,   /* U+46E7 */
  0x969D,   /* U+46E8 */
  0x94AC,   /* U+46E9 */
  0x94AD,   /* U+46EA */
  0x94AE,   /* U+46EB */
  0x94AF,   /* U+46EC */
  0x94B0,   /* U+46ED */
  0x94B1,   /* U+46EE */
  0x94B2,   /* U+46EF */
  0x94B3,   /* U+46F0 */
  0x94B4,   /* U+46F1 */
  0x94B5,   /* U+46F2 */
  0x94B6,   /* U+46F3 */
  0x94B7,   /* U+46F4 */
  0x94B8,   /* U+46F5 */
  0x94B9,   /* U+46F6 */
  0x94BA,   /* U+46F7 */
  0x94BB,   /* U+46F8 */
  0x91B8,   /* U+46F9 */
  0x91B9,   /* U+46FA */
  0x91BA,   /* U+46FB */
  0x91BB,   /* U+46FC */
  0x91BC,   /* U+46FD */
  0x8DAE,   /* U+46FE */
  0x8DAF,   /* U+46FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4600 */
  0x0000,   /* U+4601 */
  0x0000,   /* U+4602 */
  0x0000,   /* U+4603 */
  0x0000,   /* U+4604 */
  0x0000,   /* U+4605 */
  0x0000,   /* U+4606 */
  0x0000,   /* U+4607 */
  0x0000,   /* U+4608 */
  0x0000,   /* U+4609 */
  0x0000,   /* U+460A */
  0x0000,   /* U+460B */
  0x0000,   /* U+460C */
  0x0000,   /* U+460D */
  0x0000,   /* U+460E */
  0x0000,   /* U+460F */
  0x0000,   /* U+4610 */
  0x0000,   /* U+4611 */
  0x0000,   /* U+4612 */
  0x0000,   /* U+4613 */
  0x0000,   /* U+4614 */
  0x0000,   /* U+4615 */
  0x0000,   /* U+4616 */
  0x0000,   /* U+4617 */
  0x0000,   /* U+4618 */
  0x0000,   /* U+4619 */
  0x0000,   /* U+461A */
  0x0000,   /* U+461B */
  0x0000,   /* U+461C */
  0x0000,   /* U+461D */
  0x0000,   /* U+461E */
  0x0000,   /* U+461F */
  0x0000,   /* U+4620 */
  0x0000,   /* U+4621 */
  0x0000,   /* U+4622 */
  0x0000,   /* U+4623 */
  0x0000,   /* U+4624 */
  0x0000,   /* U+4625 */
  0x0000,   /* U+4626 */
  0x0000,   /* U+4627 */
  0x0000,   /* U+4628 */
  0x0000,   /* U+4629 */
  0x0000,   /* U+462A */
  0x0000,   /* U+462B */
  0x0000,   /* U+462C */
  0x0000,   /* U+462D */
  0x0000,   /* U+462E */
  0x0000,   /* U+462F */
  0x0000,   /* U+4630 */
  0x0000,   /* U+4631 */
  0x0000,   /* U+4632 */
  0x0000,   /* U+4633 */
  0x0000,   /* U+4634 */
  0x0000,   /* U+4635 */
  0x0000,   /* U+4636 */
  0x0000,   /* U+4637 */
  0x0000,   /* U+4638 */
  0x0000,   /* U+4639 */
  0x0000,   /* U+463A */
  0x0000,   /* U+463B */
  0x0000,   /* U+463C */
  0x0000,   /* U+463D */
  0x0000,   /* U+463E */
  0x0000,   /* U+463F */
  0x0000,   /* U+4640 */
  0x0000,   /* U+4641 */
  0x0000,   /* U+4642 */
  0x0000,   /* U+4643 */
  0x0000,   /* U+4644 */
  0x0000,   /* U+4645 */
  0x0000,   /* U+4646 */
  0x0000,   /* U+4647 */
  0x0000,   /* U+4648 */
  0x0000,   /* U+4649 */
  0x0000,   /* U+464A */
  0x0000,   /* U+464B */
  0x0000,   /* U+464C */
  0x0000,   /* U+464D */
  0x0000,   /* U+464E */
  0x0000,   /* U+464F */
  0x0000,   /* U+4650 */
  0x0000,   /* U+4651 */
  0x0000,   /* U+4652 */
  0x0000,   /* U+4653 */
  0x0000,   /* U+4654 */
  0x0000,   /* U+4655 */
  0x0000,   /* U+4656 */
  0x0000,   /* U+4657 */
  0x0000,   /* U+4658 */
  0x0000,   /* U+4659 */
  0x0000,   /* U+465A */
  0x0000,   /* U+465B */
  0x0000,   /* U+465C */
  0x0000,   /* U+465D */
  0x0000,   /* U+465E */
  0x0000,   /* U+465F */
  0x0000,   /* U+4660 */
  0x0000,   /* U+4661 */
  0x0000,   /* U+4662 */
  0x0000,   /* U+4663 */
  0x0000,   /* U+4664 */
  0x0000,   /* U+4665 */
  0x0000,   /* U+4666 */
  0x0000,   /* U+4667 */
  0x0000,   /* U+4668 */
  0x0000,   /* U+4669 */
  0x0000,   /* U+466A */
  0x0000,   /* U+466B */
  0x0000,   /* U+466C */
  0x0000,   /* U+466D */
  0x0000,   /* U+466E */
  0x0000,   /* U+466F */
  0x0000,   /* U+4670 */
  0x0000,   /* U+4671 */
  0x0000,   /* U+4672 */
  0x0000,   /* U+4673 */
  0x0000,   /* U+4674 */
  0x0000,   /* U+4675 */
  0x0000,   /* U+4676 */
  0x0000,   /* U+4677 */
  0x0000,   /* U+4678 */
  0x0000,   /* U+4679 */
  0x0000,   /* U+467A */
  0x0000,   /* U+467B */
  0x0000,   /* U+467C */
  0x0000,   /* U+467D */
  0x0000,   /* U+467E */
  0x0000,   /* U+467F */
  0x0000,   /* U+4680 */
  0x0000,   /* U+4681 */
  0x0000,   /* U+4682 */
  0x0000,   /* U+4683 */
  0x0000,   /* U+4684 */
  0x0000,   /* U+4685 */
  0x0000,   /* U+4686 */
  0x0000,   /* U+4687 */
  0x0000,   /* U+4688 */
  0x0000,   /* U+4689 */
  0x0000,   /* U+468A */
  0x0000,   /* U+468B */
  0x0000,   /* U+468C */
  0x0000,   /* U+468D */
  0x0000,   /* U+468E */
  0x0000,   /* U+468F */
  0x0000,   /* U+4690 */
  0x0000,   /* U+4691 */
  0x0000,   /* U+4692 */
  0x0000,   /* U+4693 */
  0x0000,   /* U+4694 */
  0x0000,   /* U+4695 */
  0x0000,   /* U+4696 */
  0x0000,   /* U+4697 */
  0x0000,   /* U+4698 */
  0x0000,   /* U+4699 */
  0x0000,   /* U+469A */
  0x0000,   /* U+469B */
  0x0000,   /* U+469C */
  0x0000,   /* U+469D */
  0x0000,   /* U+469E */
  0x0000,   /* U+469F */
  0x0000,   /* U+46A0 */
  0x0000,   /* U+46A1 */
  0x0000,   /* U+46A2 */
  0x0000,   /* U+46A3 */
  0x0000,   /* U+46A4 */
  0x0000,   /* U+46A5 */
  0x0000,   /* U+46A6 */
  0x0000,   /* U+46A7 */
  0x0000,   /* U+46A8 */
  0x0000,   /* U+46A9 */
  0x0000,   /* U+46AA */
  0x0000,   /* U+46AB */
  0x0000,   /* U+46AC */
  0x0000,   /* U+46AD */
  0x0000,   /* U+46AE */
  0x0000,   /* U+46AF */
  0x0000,   /* U+46B0 */
  0x0000,   /* U+46B1 */
  0x0000,   /* U+46B2 */
  0x0000,   /* U+46B3 */
  0x0000,   /* U+46B4 */
  0x0000,   /* U+46B5 */
  0x0000,   /* U+46B6 */
  0x0000,   /* U+46B7 */
  0x0000,   /* U+46B8 */
  0x0000,   /* U+46B9 */
  0x0000,   /* U+46BA */
  0x0000,   /* U+46BB */
  0x0000,   /* U+46BC */
  0x0000,   /* U+46BD */
  0x0000,   /* U+46BE */
  0x0000,   /* U+46BF */
  0x0000,   /* U+46C0 */
  0x0000,   /* U+46C1 */
  0x0000,   /* U+46C2 */
  0x0000,   /* U+46C3 */
  0x0000,   /* U+46C4 */
  0x0000,   /* U+46C5 */
  0x0000,   /* U+46C6 */
  0x0000,   /* U+46C7 */
  0x0000,   /* U+46C8 */
  0x0000,   /* U+46C9 */
  0x0000,   /* U+46CA */
  0x0000,   /* U+46CB */
  0x0000,   /* U+46CC */
  0x0000,   /* U+46CD */
  0x0000,   /* U+46CE */
  0x0000,   /* U+46CF */
  0x0000,   /* U+46D0 */
  0x0000,   /* U+46D1 */
  0x0000,   /* U+46D2 */
  0x0000,   /* U+46D3 */
  0x0000,   /* U+46D4 */
  0x0000,   /* U+46D5 */
  0x0000,   /* U+46D6 */
  0x0000,   /* U+46D7 */
  0x0000,   /* U+46D8 */
  0x0000,   /* U+46D9 */
  0x0000,   /* U+46DA */
  0x0000,   /* U+46DB */
  0x0000,   /* U+46DC */
  0x0000,   /* U+46DD */
  0x0000,   /* U+46DE */
  0x0000,   /* U+46DF */
  0x0000,   /* U+46E0 */
  0x0000,   /* U+46E1 */
  0x0000,   /* U+46E2 */
  0x0000,   /* U+46E3 */
  0x0000,   /* U+46E4 */
  0x0000,   /* U+46E5 */
  0x0000,   /* U+46E6 */
  0x0000,   /* U+46E7 */
  0x0000,   /* U+46E8 */
  0x0000,   /* U+46E9 */
  0x0000,   /* U+46EA */
  0x0000,   /* U+46EB */
  0x0000,   /* U+46EC */
  0x0000,   /* U+46ED */
  0x0000,   /* U+46EE */
  0x0000,   /* U+46EF */
  0x0000,   /* U+46F0 */
  0x0000,   /* U+46F1 */
  0x0000,   /* U+46F2 */
  0x0000,   /* U+46F3 */
  0x0000,   /* U+46F4 */
  0x0000,   /* U+46F5 */
  0x0000,   /* U+46F6 */
  0x0000,   /* U+46F7 */
  0x0000,   /* U+46F8 */
  0x0000,   /* U+46F9 */
  0x0000,   /* U+46FA */
  0x0000,   /* U+46FB */
  0x0000,   /* U+46FC */
  0x0000,   /* U+46FD */
  0x0000,   /* U+46FE */
  0x0000,   /* U+46FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4600 */
  0x0000,   /* U+4601 */
  0x0000,   /* U+4602 */
  0x0000,   /* U+4603 */
  0x0000,   /* U+4604 */
  0x0000,   /* U+4605 */
  0x0000,   /* U+4606 */
  0x0000,   /* U+4607 */
  0x0000,   /* U+4608 */
  0x0000,   /* U+4609 */
  0x0000,   /* U+460A */
  0x0000,   /* U+460B */
  0x0000,   /* U+460C */
  0x0000,   /* U+460D */
  0x0000,   /* U+460E */
  0x0000,   /* U+460F */
  0x0000,   /* U+4610 */
  0x0000,   /* U+4611 */
  0x0000,   /* U+4612 */
  0x0000,   /* U+4613 */
  0x0000,   /* U+4614 */
  0x0000,   /* U+4615 */
  0x0000,   /* U+4616 */
  0x0000,   /* U+4617 */
  0x0000,   /* U+4618 */
  0x0000,   /* U+4619 */
  0x0000,   /* U+461A */
  0x0000,   /* U+461B */
  0x0000,   /* U+461C */
  0x0000,   /* U+461D */
  0x0000,   /* U+461E */
  0x0000,   /* U+461F */
  0x0000,   /* U+4620 */
  0x0000,   /* U+4621 */
  0x0000,   /* U+4622 */
  0x0000,   /* U+4623 */
  0x0000,   /* U+4624 */
  0x0000,   /* U+4625 */
  0x0000,   /* U+4626 */
  0x0000,   /* U+4627 */
  0x0000,   /* U+4628 */
  0x0000,   /* U+4629 */
  0x0000,   /* U+462A */
  0x0000,   /* U+462B */
  0x0000,   /* U+462C */
  0x0000,   /* U+462D */
  0x0000,   /* U+462E */
  0x0000,   /* U+462F */
  0x0000,   /* U+4630 */
  0x0000,   /* U+4631 */
  0x0000,   /* U+4632 */
  0x0000,   /* U+4633 */
  0x0000,   /* U+4634 */
  0x0000,   /* U+4635 */
  0x0000,   /* U+4636 */
  0x0000,   /* U+4637 */
  0x0000,   /* U+4638 */
  0x0000,   /* U+4639 */
  0x0000,   /* U+463A */
  0x0000,   /* U+463B */
  0x0000,   /* U+463C */
  0x0000,   /* U+463D */
  0x0000,   /* U+463E */
  0x0000,   /* U+463F */
  0x0000,   /* U+4640 */
  0x0000,   /* U+4641 */
  0x0000,   /* U+4642 */
  0x0000,   /* U+4643 */
  0x0000,   /* U+4644 */
  0x0000,   /* U+4645 */
  0x0000,   /* U+4646 */
  0x0000,   /* U+4647 */
  0x0000,   /* U+4648 */
  0x0000,   /* U+4649 */
  0x0000,   /* U+464A */
  0x0000,   /* U+464B */
  0x0000,   /* U+464C */
  0x0000,   /* U+464D */
  0x0000,   /* U+464E */
  0x0000,   /* U+464F */
  0x0000,   /* U+4650 */
  0x0000,   /* U+4651 */
  0x0000,   /* U+4652 */
  0x0000,   /* U+4653 */
  0x0000,   /* U+4654 */
  0x0000,   /* U+4655 */
  0x0000,   /* U+4656 */
  0x0000,   /* U+4657 */
  0x0000,   /* U+4658 */
  0x0000,   /* U+4659 */
  0x0000,   /* U+465A */
  0x0000,   /* U+465B */
  0x0000,   /* U+465C */
  0x0000,   /* U+465D */
  0x0000,   /* U+465E */
  0x0000,   /* U+465F */
  0x0000,   /* U+4660 */
  0x0000,   /* U+4661 */
  0x0000,   /* U+4662 */
  0x0000,   /* U+4663 */
  0x0000,   /* U+4664 */
  0x0000,   /* U+4665 */
  0x0000,   /* U+4666 */
  0x0000,   /* U+4667 */
  0x0000,   /* U+4668 */
  0x0000,   /* U+4669 */
  0x0000,   /* U+466A */
  0x0000,   /* U+466B */
  0x0000,   /* U+466C */
  0x0000,   /* U+466D */
  0x0000,   /* U+466E */
  0x0000,   /* U+466F */
  0x0000,   /* U+4670 */
  0x0000,   /* U+4671 */
  0x0000,   /* U+4672 */
  0x0000,   /* U+4673 */
  0x0000,   /* U+4674 */
  0x0000,   /* U+4675 */
  0x0000,   /* U+4676 */
  0x0000,   /* U+4677 */
  0x0000,   /* U+4678 */
  0x0000,   /* U+4679 */
  0x0000,   /* U+467A */
  0x0000,   /* U+467B */
  0x0000,   /* U+467C */
  0x0000,   /* U+467D */
  0x0000,   /* U+467E */
  0x0000,   /* U+467F */
  0x0000,   /* U+4680 */
  0x0000,   /* U+4681 */
  0x0000,   /* U+4682 */
  0x0000,   /* U+4683 */
  0x0000,   /* U+4684 */
  0x0000,   /* U+4685 */
  0x0000,   /* U+4686 */
  0x0000,   /* U+4687 */
  0x0000,   /* U+4688 */
  0x0000,   /* U+4689 */
  0x0000,   /* U+468A */
  0x0000,   /* U+468B */
  0x0000,   /* U+468C */
  0x0000,   /* U+468D */
  0x0000,   /* U+468E */
  0x0000,   /* U+468F */
  0x0000,   /* U+4690 */
  0x0000,   /* U+4691 */
  0x0000,   /* U+4692 */
  0x0000,   /* U+4693 */
  0x0000,   /* U+4694 */
  0x0000,   /* U+4695 */
  0x0000,   /* U+4696 */
  0x0000,   /* U+4697 */
  0x0000,   /* U+4698 */
  0x0000,   /* U+4699 */
  0x0000,   /* U+469A */
  0x0000,   /* U+469B */
  0x0000,   /* U+469C */
  0x0000,   /* U+469D */
  0x0000,   /* U+469E */
  0x0000,   /* U+469F */
  0x0000,   /* U+46A0 */
  0x0000,   /* U+46A1 */
  0x0000,   /* U+46A2 */
  0x0000,   /* U+46A3 */
  0x0000,   /* U+46A4 */
  0x0000,   /* U+46A5 */
  0x0000,   /* U+46A6 */
  0x0000,   /* U+46A7 */
  0x0000,   /* U+46A8 */
  0x0000,   /* U+46A9 */
  0x0000,   /* U+46AA */
  0x0000,   /* U+46AB */
  0x0000,   /* U+46AC */
  0x0000,   /* U+46AD */
  0x0000,   /* U+46AE */
  0x0000,   /* U+46AF */
  0x0000,   /* U+46B0 */
  0x0000,   /* U+46B1 */
  0x0000,   /* U+46B2 */
  0x0000,   /* U+46B3 */
  0x0000,   /* U+46B4 */
  0x0000,   /* U+46B5 */
  0x0000,   /* U+46B6 */
  0x0000,   /* U+46B7 */
  0x0000,   /* U+46B8 */
  0x0000,   /* U+46B9 */
  0x0000,   /* U+46BA */
  0x0000,   /* U+46BB */
  0x0000,   /* U+46BC */
  0x0000,   /* U+46BD */
  0x0000,   /* U+46BE */
  0x0000,   /* U+46BF */
  0x0000,   /* U+46C0 */
  0x0000,   /* U+46C1 */
  0x0000,   /* U+46C2 */
  0x0000,   /* U+46C3 */
  0x0000,   /* U+46C4 */
  0x0000,   /* U+46C5 */
  0x0000,   /* U+46C6 */
  0x0000,   /* U+46C7 */
  0x0000,   /* U+46C8 */
  0x0000,   /* U+46C9 */
  0x0000,   /* U+46CA */
  0x0000,   /* U+46CB */
  0x0000,   /* U+46CC */
  0x0000,   /* U+46CD */
  0x0000,   /* U+46CE */
  0x0000,   /* U+46CF */
  0x0000,   /* U+46D0 */
  0x0000,   /* U+46D1 */
  0x0000,   /* U+46D2 */
  0x0000,   /* U+46D3 */
  0x0000,   /* U+46D4 */
  0x0000,   /* U+46D5 */
  0x0000,   /* U+46D6 */
  0x0000,   /* U+46D7 */
  0x0000,   /* U+46D8 */
  0x0000,   /* U+46D9 */
  0x0000,   /* U+46DA */
  0x0000,   /* U+46DB */
  0x0000,   /* U+46DC */
  0x0000,   /* U+46DD */
  0x0000,   /* U+46DE */
  0x0000,   /* U+46DF */
  0x0000,   /* U+46E0 */
  0x0000,   /* U+46E1 */
  0x0000,   /* U+46E2 */
  0x0000,   /* U+46E3 */
  0x0000,   /* U+46E4 */
  0x0000,   /* U+46E5 */
  0x0000,   /* U+46E6 */
  0x0000,   /* U+46E7 */
  0x0000,   /* U+46E8 */
  0x0000,   /* U+46E9 */
  0x0000,   /* U+46EA */
  0x0000,   /* U+46EB */
  0x0000,   /* U+46EC */
  0x0000,   /* U+46ED */
  0x0000,   /* U+46EE */
  0x0000,   /* U+46EF */
  0x0000,   /* U+46F0 */
  0x0000,   /* U+46F1 */
  0x0000,   /* U+46F2 */
  0x0000,   /* U+46F3 */
  0x0000,   /* U+46F4 */
  0x0000,   /* U+46F5 */
  0x0000,   /* U+46F6 */
  0x0000,   /* U+46F7 */
  0x0000,   /* U+46F8 */
  0x0000,   /* U+46F9 */
  0x0000,   /* U+46FA */
  0x0000,   /* U+46FB */
  0x0000,   /* U+46FC */
  0x0000,   /* U+46FD */
  0x0000,   /* U+46FE */
  0x0000,   /* U+46FF */
};

uint16 zh3_han_p047[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C58,   /* U+4700 */
  0x1C58,   /* U+4701 */
  0x1C58,   /* U+4702 */
  0x1C59,   /* U+4703 */
  0x1C59,   /* U+4704 */
  0x1C59,   /* U+4705 */
  0x1C59,   /* U+4706 */
  0x1C59,   /* U+4707 */
  0x1C59,   /* U+4708 */
  0x1C59,   /* U+4709 */
  0x1C59,   /* U+470A */
  0x1C5A,   /* U+470B */
  0x1C5A,   /* U+470C */
  0x1C5A,   /* U+470D */
  0x1C5A,   /* U+470E */
  0x1C5A,   /* U+470F */
  0x1C5A,   /* U+4710 */
  0x1C5A,   /* U+4711 */
  0x1C5B,   /* U+4712 */
  0x1C5B,   /* U+4713 */
  0x1C5B,   /* U+4714 */
  0x1C5B,   /* U+4715 */
  0x1C5B,   /* U+4716 */
  0x1C5B,   /* U+4717 */
  0x1C5B,   /* U+4718 */
  0x1C5C,   /* U+4719 */
  0x1C5C,   /* U+471A */
  0x1C5C,   /* U+471B */
  0x1C5C,   /* U+471C */
  0x1C5C,   /* U+471D */
  0x1C5C,   /* U+471E */
  0x1C5D,   /* U+471F */
  0x1C5D,   /* U+4720 */
  0x1C5D,   /* U+4721 */
  0x1C5E,   /* U+4722 */
  0x1C52,   /* U+4723 */
  0x1C54,   /* U+4724 */
  0x1C56,   /* U+4725 */
  0x1C58,   /* U+4726 */
  0x1C58,   /* U+4727 */
  0x1C59,   /* U+4728 */
  0x1C5E,   /* U+4729 */
  0x1C50,   /* U+472A */
  0x1C51,   /* U+472B */
  0x1C53,   /* U+472C */
  0x1C53,   /* U+472D */
  0x1C55,   /* U+472E */
  0x1C56,   /* U+472F */
  0x1C58,   /* U+4730 */
  0x1C59,   /* U+4731 */
  0x1C5D,   /* U+4732 */
  0x1C4F,   /* U+4733 */
  0x1C52,   /* U+4734 */
  0x1C53,   /* U+4735 */
  0x1C54,   /* U+4736 */
  0x1C55,   /* U+4737 */
  0x1C55,   /* U+4738 */
  0x1C55,   /* U+4739 */
  0x1C56,   /* U+473A */
  0x1C57,   /* U+473B */
  0x1C57,   /* U+473C */
  0x1C57,   /* U+473D */
  0x1C57,   /* U+473E */
  0x1C57,   /* U+473F */
  0x1C58,   /* U+4740 */
  0x1C58,   /* U+4741 */
  0x1C58,   /* U+4742 */
  0x1C5C,   /* U+4743 */
  0x1C60,   /* U+4744 */
  0x1C51,   /* U+4745 */
  0x1C52,   /* U+4746 */
  0x1C52,   /* U+4747 */
  0x1C53,   /* U+4748 */
  0x1C54,   /* U+4749 */
  0x1C56,   /* U+474A */
  0x1C56,   /* U+474B */
  0x1C56,   /* U+474C */
  0x1C57,   /* U+474D */
  0x1C57,   /* U+474E */
  0x1C59,   /* U+474F */
  0x1C5A,   /* U+4750 */
  0x1C5A,   /* U+4751 */
  0x1C5C,   /* U+4752 */
  0x1C5D,   /* U+4753 */
  0x1C60,   /* U+4754 */
  0x1C60,   /* U+4755 */
  0x1C52,   /* U+4756 */
  0x1C52,   /* U+4757 */
  0x1C52,   /* U+4758 */
  0x1C52,   /* U+4759 */
  0x1C53,   /* U+475A */
  0x1C53,   /* U+475B */
  0x1C55,   /* U+475C */
  0x1C56,   /* U+475D */
  0x1C56,   /* U+475E */
  0x1C57,   /* U+475F */
  0x1C58,   /* U+4760 */
  0x1C59,   /* U+4761 */
  0x1C59,   /* U+4762 */
  0x1C5A,   /* U+4763 */
  0x1C5A,   /* U+4764 */
  0x1C5A,   /* U+4765 */
  0x1C5A,   /* U+4766 */
  0x1C52,   /* U+4767 */
  0x1C52,   /* U+4768 */
  0x1C53,   /* U+4769 */
  0x1C53,   /* U+476A */
  0x1C53,   /* U+476B */
  0x1C53,   /* U+476C */
  0x1C53,   /* U+476D */
  0x1C53,   /* U+476E */
  0x1C53,   /* U+476F */
  0x1C54,   /* U+4770 */
  0x1C54,   /* U+4771 */
  0x1C54,   /* U+4772 */
  0x1C55,   /* U+4773 */
  0x1C55,   /* U+4774 */
  0x1C55,   /* U+4775 */
  0x1C56,   /* U+4776 */
  0x1C56,   /* U+4777 */
  0x1C56,   /* U+4778 */
  0x1C56,   /* U+4779 */
  0x1C56,   /* U+477A */
  0x1C56,   /* U+477B */
  0x1C56,   /* U+477C */
  0x1C56,   /* U+477D */
  0x1C56,   /* U+477E */
  0x1C56,   /* U+477F */
  0x1C57,   /* U+4780 */
  0x1C57,   /* U+4781 */
  0x1C57,   /* U+4782 */
  0x1C57,   /* U+4783 */
  0x1C57,   /* U+4784 */
  0x1C58,   /* U+4785 */
  0x1C58,   /* U+4786 */
  0x1C59,   /* U+4787 */
  0x1C5A,   /* U+4788 */
  0x1C5B,   /* U+4789 */
  0x1C5D,   /* U+478A */
  0x1C5E,   /* U+478B */
  0x1C54,   /* U+478C */
  0x1C56,   /* U+478D */
  0x1C56,   /* U+478E */
  0x1C57,   /* U+478F */
  0x1C57,   /* U+4790 */
  0x1C51,   /* U+4791 */
  0x1C54,   /* U+4792 */
  0x1C55,   /* U+4793 */
  0x1C55,   /* U+4794 */
  0x1C5C,   /* U+4795 */
  0x1C51,   /* U+4796 */
  0x1C51,   /* U+4797 */
  0x1C51,   /* U+4798 */
  0x1C52,   /* U+4799 */
  0x1C52,   /* U+479A */
  0x1C52,   /* U+479B */
  0x1C52,   /* U+479C */
  0x1C53,   /* U+479D */
  0x1C53,   /* U+479E */
  0x1C53,   /* U+479F */
  0x1C53,   /* U+47A0 */
  0x1C53,   /* U+47A1 */
  0x1C53,   /* U+47A2 */
  0x1C53,   /* U+47A3 */
  0x1C53,   /* U+47A4 */
  0x1C54,   /* U+47A5 */
  0x1C54,   /* U+47A6 */
  0x1C54,   /* U+47A7 */
  0x1C54,   /* U+47A8 */
  0x1C54,   /* U+47A9 */
  0x1C54,   /* U+47AA */
  0x1C55,   /* U+47AB */
  0x1C55,   /* U+47AC */
  0x1C55,   /* U+47AD */
  0x1C55,   /* U+47AE */
  0x1C55,   /* U+47AF */
  0x1C55,   /* U+47B0 */
  0x1C55,   /* U+47B1 */
  0x1C55,   /* U+47B2 */
  0x1C56,   /* U+47B3 */
  0x1C56,   /* U+47B4 */
  0x1C56,   /* U+47B5 */
  0x1C56,   /* U+47B6 */
  0x1C56,   /* U+47B7 */
  0x1C56,   /* U+47B8 */
  0x1C57,   /* U+47B9 */
  0x1C57,   /* U+47BA */
  0x1C57,   /* U+47BB */
  0x1C57,   /* U+47BC */
  0x1C58,   /* U+47BD */
  0x1C58,   /* U+47BE */
  0x1C58,   /* U+47BF */
  0x1C58,   /* U+47C0 */
  0x1C59,   /* U+47C1 */
  0x1C59,   /* U+47C2 */
  0x1C59,   /* U+47C3 */
  0x1C59,   /* U+47C4 */
  0x1C59,   /* U+47C5 */
  0x1C59,   /* U+47C6 */
  0x1C5A,   /* U+47C7 */
  0x1C5B,   /* U+47C8 */
  0x1C5B,   /* U+47C9 */
  0x1C5B,   /* U+47CA */
  0x1C5B,   /* U+47CB */
  0x1C5C,   /* U+47CC */
  0x1C5D,   /* U+47CD */
  0x1C5D,   /* U+47CE */
  0x1C5D,   /* U+47CF */
  0x1C5E,   /* U+47D0 */
  0x1C5F,   /* U+47D1 */
  0x1C60,   /* U+47D2 */
  0x1C50,   /* U+47D3 */
  0x1C50,   /* U+47D4 */
  0x1C51,   /* U+47D5 */
  0x1C51,   /* U+47D6 */
  0x1C52,   /* U+47D7 */
  0x1C52,   /* U+47D8 */
  0x1C52,   /* U+47D9 */
  0x1C52,   /* U+47DA */
  0x1C52,   /* U+47DB */
  0x1C52,   /* U+47DC */
  0x1C52,   /* U+47DD */
  0x1C52,   /* U+47DE */
  0x1C53,   /* U+47DF */
  0x1C53,   /* U+47E0 */
  0x1C53,   /* U+47E1 */
  0x1C53,   /* U+47E2 */
  0x1C53,   /* U+47E3 */
  0x1C53,   /* U+47E4 */
  0x1C53,   /* U+47E5 */
  0x1C53,   /* U+47E6 */
  0x1C53,   /* U+47E7 */
  0x1C53,   /* U+47E8 */
  0x1C53,   /* U+47E9 */
  0x1C53,   /* U+47EA */
  0x1C53,   /* U+47EB */
  0x1C53,   /* U+47EC */
  0x1C53,   /* U+47ED */
  0x1C54,   /* U+47EE */
  0x1C54,   /* U+47EF */
  0x1C54,   /* U+47F0 */
  0x1C54,   /* U+47F1 */
  0x1C54,   /* U+47F2 */
  0x1C54,   /* U+47F3 */
  0x1C55,   /* U+47F4 */
  0x1C55,   /* U+47F5 */
  0x1C55,   /* U+47F6 */
  0x1C55,   /* U+47F7 */
  0x1C55,   /* U+47F8 */
  0x1C55,   /* U+47F9 */
  0x1C55,   /* U+47FA */
  0x1C55,   /* U+47FB */
  0x1C56,   /* U+47FC */
  0x1C55,   /* U+47FD */
  0x1C56,   /* U+47FE */
  0x1C56,   /* U+47FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4700 */
  0x0020,   /* U+4701 */
  0x0020,   /* U+4702 */
  0x0020,   /* U+4703 */
  0x0020,   /* U+4704 */
  0x0020,   /* U+4705 */
  0x0020,   /* U+4706 */
  0x0020,   /* U+4707 */
  0x0020,   /* U+4708 */
  0x0020,   /* U+4709 */
  0x0020,   /* U+470A */
  0x0020,   /* U+470B */
  0x0020,   /* U+470C */
  0x0020,   /* U+470D */
  0x0020,   /* U+470E */
  0x0020,   /* U+470F */
  0x0020,   /* U+4710 */
  0x0020,   /* U+4711 */
  0x0020,   /* U+4712 */
  0x0020,   /* U+4713 */
  0x0020,   /* U+4714 */
  0x0020,   /* U+4715 */
  0x0020,   /* U+4716 */
  0x0020,   /* U+4717 */
  0x0020,   /* U+4718 */
  0x0020,   /* U+4719 */
  0x0020,   /* U+471A */
  0x0020,   /* U+471B */
  0x0020,   /* U+471C */
  0x0020,   /* U+471D */
  0x0020,   /* U+471E */
  0x0020,   /* U+471F */
  0x0020,   /* U+4720 */
  0x0020,   /* U+4721 */
  0x0020,   /* U+4722 */
  0x0020,   /* U+4723 */
  0x0020,   /* U+4724 */
  0x0020,   /* U+4725 */
  0x0020,   /* U+4726 */
  0x0020,   /* U+4727 */
  0x0020,   /* U+4728 */
  0x0020,   /* U+4729 */
  0x0020,   /* U+472A */
  0x0020,   /* U+472B */
  0x0020,   /* U+472C */
  0x0020,   /* U+472D */
  0x0020,   /* U+472E */
  0x0020,   /* U+472F */
  0x0020,   /* U+4730 */
  0x0020,   /* U+4731 */
  0x0020,   /* U+4732 */
  0x0020,   /* U+4733 */
  0x0020,   /* U+4734 */
  0x0020,   /* U+4735 */
  0x0020,   /* U+4736 */
  0x0020,   /* U+4737 */
  0x0020,   /* U+4738 */
  0x0020,   /* U+4739 */
  0x0020,   /* U+473A */
  0x0020,   /* U+473B */
  0x0020,   /* U+473C */
  0x0020,   /* U+473D */
  0x0020,   /* U+473E */
  0x0020,   /* U+473F */
  0x0020,   /* U+4740 */
  0x0020,   /* U+4741 */
  0x0020,   /* U+4742 */
  0x0020,   /* U+4743 */
  0x0020,   /* U+4744 */
  0x0020,   /* U+4745 */
  0x0020,   /* U+4746 */
  0x0020,   /* U+4747 */
  0x0020,   /* U+4748 */
  0x0020,   /* U+4749 */
  0x0020,   /* U+474A */
  0x0020,   /* U+474B */
  0x0020,   /* U+474C */
  0x0020,   /* U+474D */
  0x0020,   /* U+474E */
  0x0020,   /* U+474F */
  0x0020,   /* U+4750 */
  0x0020,   /* U+4751 */
  0x0020,   /* U+4752 */
  0x0020,   /* U+4753 */
  0x0020,   /* U+4754 */
  0x0020,   /* U+4755 */
  0x0020,   /* U+4756 */
  0x0020,   /* U+4757 */
  0x0020,   /* U+4758 */
  0x0020,   /* U+4759 */
  0x0020,   /* U+475A */
  0x0020,   /* U+475B */
  0x0020,   /* U+475C */
  0x0020,   /* U+475D */
  0x0020,   /* U+475E */
  0x0020,   /* U+475F */
  0x0020,   /* U+4760 */
  0x0020,   /* U+4761 */
  0x0020,   /* U+4762 */
  0x0020,   /* U+4763 */
  0x0020,   /* U+4764 */
  0x0020,   /* U+4765 */
  0x0020,   /* U+4766 */
  0x0020,   /* U+4767 */
  0x0020,   /* U+4768 */
  0x0020,   /* U+4769 */
  0x0020,   /* U+476A */
  0x0020,   /* U+476B */
  0x0020,   /* U+476C */
  0x0020,   /* U+476D */
  0x0020,   /* U+476E */
  0x0020,   /* U+476F */
  0x0020,   /* U+4770 */
  0x0020,   /* U+4771 */
  0x0020,   /* U+4772 */
  0x0020,   /* U+4773 */
  0x0020,   /* U+4774 */
  0x0020,   /* U+4775 */
  0x0020,   /* U+4776 */
  0x0020,   /* U+4777 */
  0x0020,   /* U+4778 */
  0x0020,   /* U+4779 */
  0x0020,   /* U+477A */
  0x0020,   /* U+477B */
  0x0020,   /* U+477C */
  0x0020,   /* U+477D */
  0x0020,   /* U+477E */
  0x0020,   /* U+477F */
  0x0020,   /* U+4780 */
  0x0020,   /* U+4781 */
  0x0020,   /* U+4782 */
  0x0020,   /* U+4783 */
  0x0020,   /* U+4784 */
  0x0020,   /* U+4785 */
  0x0020,   /* U+4786 */
  0x0020,   /* U+4787 */
  0x0020,   /* U+4788 */
  0x0020,   /* U+4789 */
  0x0020,   /* U+478A */
  0x0020,   /* U+478B */
  0x0020,   /* U+478C */
  0x0020,   /* U+478D */
  0x0020,   /* U+478E */
  0x0020,   /* U+478F */
  0x0020,   /* U+4790 */
  0x0020,   /* U+4791 */
  0x0020,   /* U+4792 */
  0x0020,   /* U+4793 */
  0x0020,   /* U+4794 */
  0x0020,   /* U+4795 */
  0x0020,   /* U+4796 */
  0x0020,   /* U+4797 */
  0x0020,   /* U+4798 */
  0x0020,   /* U+4799 */
  0x0020,   /* U+479A */
  0x0020,   /* U+479B */
  0x0020,   /* U+479C */
  0x0020,   /* U+479D */
  0x0020,   /* U+479E */
  0x0020,   /* U+479F */
  0x0020,   /* U+47A0 */
  0x0020,   /* U+47A1 */
  0x0020,   /* U+47A2 */
  0x0020,   /* U+47A3 */
  0x0020,   /* U+47A4 */
  0x0020,   /* U+47A5 */
  0x0020,   /* U+47A6 */
  0x0020,   /* U+47A7 */
  0x0020,   /* U+47A8 */
  0x0020,   /* U+47A9 */
  0x0020,   /* U+47AA */
  0x0020,   /* U+47AB */
  0x0020,   /* U+47AC */
  0x0020,   /* U+47AD */
  0x0020,   /* U+47AE */
  0x0020,   /* U+47AF */
  0x0020,   /* U+47B0 */
  0x0020,   /* U+47B1 */
  0x0020,   /* U+47B2 */
  0x0020,   /* U+47B3 */
  0x0020,   /* U+47B4 */
  0x0020,   /* U+47B5 */
  0x0020,   /* U+47B6 */
  0x0020,   /* U+47B7 */
  0x0020,   /* U+47B8 */
  0x0020,   /* U+47B9 */
  0x0020,   /* U+47BA */
  0x0020,   /* U+47BB */
  0x0020,   /* U+47BC */
  0x0020,   /* U+47BD */
  0x0020,   /* U+47BE */
  0x0020,   /* U+47BF */
  0x0020,   /* U+47C0 */
  0x0020,   /* U+47C1 */
  0x0020,   /* U+47C2 */
  0x0020,   /* U+47C3 */
  0x0020,   /* U+47C4 */
  0x0020,   /* U+47C5 */
  0x0020,   /* U+47C6 */
  0x0020,   /* U+47C7 */
  0x0020,   /* U+47C8 */
  0x0020,   /* U+47C9 */
  0x0020,   /* U+47CA */
  0x0020,   /* U+47CB */
  0x0020,   /* U+47CC */
  0x0020,   /* U+47CD */
  0x0020,   /* U+47CE */
  0x0020,   /* U+47CF */
  0x0020,   /* U+47D0 */
  0x0020,   /* U+47D1 */
  0x0020,   /* U+47D2 */
  0x0020,   /* U+47D3 */
  0x0020,   /* U+47D4 */
  0x0020,   /* U+47D5 */
  0x0020,   /* U+47D6 */
  0x0020,   /* U+47D7 */
  0x0020,   /* U+47D8 */
  0x0020,   /* U+47D9 */
  0x0020,   /* U+47DA */
  0x0020,   /* U+47DB */
  0x0020,   /* U+47DC */
  0x0020,   /* U+47DD */
  0x0020,   /* U+47DE */
  0x0020,   /* U+47DF */
  0x0020,   /* U+47E0 */
  0x0020,   /* U+47E1 */
  0x0020,   /* U+47E2 */
  0x0020,   /* U+47E3 */
  0x0020,   /* U+47E4 */
  0x0020,   /* U+47E5 */
  0x0020,   /* U+47E6 */
  0x0020,   /* U+47E7 */
  0x0020,   /* U+47E8 */
  0x0020,   /* U+47E9 */
  0x0020,   /* U+47EA */
  0x0020,   /* U+47EB */
  0x0020,   /* U+47EC */
  0x0020,   /* U+47ED */
  0x0020,   /* U+47EE */
  0x0020,   /* U+47EF */
  0x0020,   /* U+47F0 */
  0x0020,   /* U+47F1 */
  0x0020,   /* U+47F2 */
  0x0020,   /* U+47F3 */
  0x0020,   /* U+47F4 */
  0x0020,   /* U+47F5 */
  0x0020,   /* U+47F6 */
  0x0020,   /* U+47F7 */
  0x0020,   /* U+47F8 */
  0x0020,   /* U+47F9 */
  0x0020,   /* U+47FA */
  0x0020,   /* U+47FB */
  0x0020,   /* U+47FC */
  0x0020,   /* U+47FD */
  0x0020,   /* U+47FE */
  0x0020,   /* U+47FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4700 */
  0x0002,   /* U+4701 */
  0x0002,   /* U+4702 */
  0x0002,   /* U+4703 */
  0x0002,   /* U+4704 */
  0x0002,   /* U+4705 */
  0x0002,   /* U+4706 */
  0x0002,   /* U+4707 */
  0x0002,   /* U+4708 */
  0x0002,   /* U+4709 */
  0x0002,   /* U+470A */
  0x0002,   /* U+470B */
  0x0002,   /* U+470C */
  0x0002,   /* U+470D */
  0x0002,   /* U+470E */
  0x0002,   /* U+470F */
  0x0002,   /* U+4710 */
  0x0002,   /* U+4711 */
  0x0002,   /* U+4712 */
  0x0002,   /* U+4713 */
  0x0002,   /* U+4714 */
  0x0002,   /* U+4715 */
  0x0002,   /* U+4716 */
  0x0002,   /* U+4717 */
  0x0002,   /* U+4718 */
  0x0002,   /* U+4719 */
  0x0002,   /* U+471A */
  0x0002,   /* U+471B */
  0x0002,   /* U+471C */
  0x0002,   /* U+471D */
  0x0002,   /* U+471E */
  0x0002,   /* U+471F */
  0x0002,   /* U+4720 */
  0x0002,   /* U+4721 */
  0x0002,   /* U+4722 */
  0x0002,   /* U+4723 */
  0x0002,   /* U+4724 */
  0x0002,   /* U+4725 */
  0x0002,   /* U+4726 */
  0x0002,   /* U+4727 */
  0x0002,   /* U+4728 */
  0x0002,   /* U+4729 */
  0x0002,   /* U+472A */
  0x0002,   /* U+472B */
  0x0002,   /* U+472C */
  0x0002,   /* U+472D */
  0x0002,   /* U+472E */
  0x0002,   /* U+472F */
  0x0002,   /* U+4730 */
  0x0002,   /* U+4731 */
  0x0002,   /* U+4732 */
  0x0002,   /* U+4733 */
  0x0002,   /* U+4734 */
  0x0002,   /* U+4735 */
  0x0002,   /* U+4736 */
  0x0002,   /* U+4737 */
  0x0002,   /* U+4738 */
  0x0002,   /* U+4739 */
  0x0002,   /* U+473A */
  0x0002,   /* U+473B */
  0x0002,   /* U+473C */
  0x0002,   /* U+473D */
  0x0002,   /* U+473E */
  0x0002,   /* U+473F */
  0x0002,   /* U+4740 */
  0x0002,   /* U+4741 */
  0x0002,   /* U+4742 */
  0x0002,   /* U+4743 */
  0x0002,   /* U+4744 */
  0x0002,   /* U+4745 */
  0x0002,   /* U+4746 */
  0x0002,   /* U+4747 */
  0x0002,   /* U+4748 */
  0x0002,   /* U+4749 */
  0x0002,   /* U+474A */
  0x0002,   /* U+474B */
  0x0002,   /* U+474C */
  0x0002,   /* U+474D */
  0x0002,   /* U+474E */
  0x0002,   /* U+474F */
  0x0002,   /* U+4750 */
  0x0002,   /* U+4751 */
  0x0002,   /* U+4752 */
  0x0002,   /* U+4753 */
  0x0002,   /* U+4754 */
  0x0002,   /* U+4755 */
  0x0002,   /* U+4756 */
  0x0002,   /* U+4757 */
  0x0002,   /* U+4758 */
  0x0002,   /* U+4759 */
  0x0002,   /* U+475A */
  0x0002,   /* U+475B */
  0x0002,   /* U+475C */
  0x0002,   /* U+475D */
  0x0002,   /* U+475E */
  0x0002,   /* U+475F */
  0x0002,   /* U+4760 */
  0x0002,   /* U+4761 */
  0x0002,   /* U+4762 */
  0x0002,   /* U+4763 */
  0x0002,   /* U+4764 */
  0x0002,   /* U+4765 */
  0x0002,   /* U+4766 */
  0x0002,   /* U+4767 */
  0x0002,   /* U+4768 */
  0x0002,   /* U+4769 */
  0x0002,   /* U+476A */
  0x0002,   /* U+476B */
  0x0002,   /* U+476C */
  0x0002,   /* U+476D */
  0x0002,   /* U+476E */
  0x0002,   /* U+476F */
  0x0002,   /* U+4770 */
  0x0002,   /* U+4771 */
  0x0002,   /* U+4772 */
  0x0002,   /* U+4773 */
  0x0002,   /* U+4774 */
  0x0002,   /* U+4775 */
  0x0002,   /* U+4776 */
  0x0002,   /* U+4777 */
  0x0002,   /* U+4778 */
  0x0002,   /* U+4779 */
  0x0002,   /* U+477A */
  0x0002,   /* U+477B */
  0x0002,   /* U+477C */
  0x0002,   /* U+477D */
  0x0002,   /* U+477E */
  0x0002,   /* U+477F */
  0x0002,   /* U+4780 */
  0x0002,   /* U+4781 */
  0x0002,   /* U+4782 */
  0x0002,   /* U+4783 */
  0x0002,   /* U+4784 */
  0x0002,   /* U+4785 */
  0x0002,   /* U+4786 */
  0x0002,   /* U+4787 */
  0x0002,   /* U+4788 */
  0x0002,   /* U+4789 */
  0x0002,   /* U+478A */
  0x0002,   /* U+478B */
  0x0002,   /* U+478C */
  0x0002,   /* U+478D */
  0x0002,   /* U+478E */
  0x0002,   /* U+478F */
  0x0002,   /* U+4790 */
  0x0002,   /* U+4791 */
  0x0002,   /* U+4792 */
  0x0002,   /* U+4793 */
  0x0002,   /* U+4794 */
  0x0002,   /* U+4795 */
  0x0002,   /* U+4796 */
  0x0002,   /* U+4797 */
  0x0002,   /* U+4798 */
  0x0002,   /* U+4799 */
  0x0002,   /* U+479A */
  0x0002,   /* U+479B */
  0x0002,   /* U+479C */
  0x0002,   /* U+479D */
  0x0002,   /* U+479E */
  0x0002,   /* U+479F */
  0x0002,   /* U+47A0 */
  0x0002,   /* U+47A1 */
  0x0002,   /* U+47A2 */
  0x0002,   /* U+47A3 */
  0x0002,   /* U+47A4 */
  0x0002,   /* U+47A5 */
  0x0002,   /* U+47A6 */
  0x0002,   /* U+47A7 */
  0x0002,   /* U+47A8 */
  0x0002,   /* U+47A9 */
  0x0002,   /* U+47AA */
  0x0002,   /* U+47AB */
  0x0002,   /* U+47AC */
  0x0002,   /* U+47AD */
  0x0002,   /* U+47AE */
  0x0002,   /* U+47AF */
  0x0002,   /* U+47B0 */
  0x0002,   /* U+47B1 */
  0x0002,   /* U+47B2 */
  0x0002,   /* U+47B3 */
  0x0002,   /* U+47B4 */
  0x0002,   /* U+47B5 */
  0x0002,   /* U+47B6 */
  0x0002,   /* U+47B7 */
  0x0002,   /* U+47B8 */
  0x0002,   /* U+47B9 */
  0x0002,   /* U+47BA */
  0x0002,   /* U+47BB */
  0x0002,   /* U+47BC */
  0x0002,   /* U+47BD */
  0x0002,   /* U+47BE */
  0x0002,   /* U+47BF */
  0x0002,   /* U+47C0 */
  0x0002,   /* U+47C1 */
  0x0002,   /* U+47C2 */
  0x0002,   /* U+47C3 */
  0x0002,   /* U+47C4 */
  0x0002,   /* U+47C5 */
  0x0002,   /* U+47C6 */
  0x0002,   /* U+47C7 */
  0x0002,   /* U+47C8 */
  0x0002,   /* U+47C9 */
  0x0002,   /* U+47CA */
  0x0002,   /* U+47CB */
  0x0002,   /* U+47CC */
  0x0002,   /* U+47CD */
  0x0002,   /* U+47CE */
  0x0002,   /* U+47CF */
  0x0002,   /* U+47D0 */
  0x0002,   /* U+47D1 */
  0x0002,   /* U+47D2 */
  0x0002,   /* U+47D3 */
  0x0002,   /* U+47D4 */
  0x0002,   /* U+47D5 */
  0x0002,   /* U+47D6 */
  0x0002,   /* U+47D7 */
  0x0002,   /* U+47D8 */
  0x0002,   /* U+47D9 */
  0x0002,   /* U+47DA */
  0x0002,   /* U+47DB */
  0x0002,   /* U+47DC */
  0x0002,   /* U+47DD */
  0x0002,   /* U+47DE */
  0x0002,   /* U+47DF */
  0x0002,   /* U+47E0 */
  0x0002,   /* U+47E1 */
  0x0002,   /* U+47E2 */
  0x0002,   /* U+47E3 */
  0x0002,   /* U+47E4 */
  0x0002,   /* U+47E5 */
  0x0002,   /* U+47E6 */
  0x0002,   /* U+47E7 */
  0x0002,   /* U+47E8 */
  0x0002,   /* U+47E9 */
  0x0002,   /* U+47EA */
  0x0002,   /* U+47EB */
  0x0002,   /* U+47EC */
  0x0002,   /* U+47ED */
  0x0002,   /* U+47EE */
  0x0002,   /* U+47EF */
  0x0002,   /* U+47F0 */
  0x0002,   /* U+47F1 */
  0x0002,   /* U+47F2 */
  0x0002,   /* U+47F3 */
  0x0002,   /* U+47F4 */
  0x0002,   /* U+47F5 */
  0x0002,   /* U+47F6 */
  0x0002,   /* U+47F7 */
  0x0002,   /* U+47F8 */
  0x0002,   /* U+47F9 */
  0x0002,   /* U+47FA */
  0x0002,   /* U+47FB */
  0x0002,   /* U+47FC */
  0x0002,   /* U+47FD */
  0x0002,   /* U+47FE */
  0x0002,   /* U+47FF */

  /* Primary weight 2 for each character. */
  0x8DB0,   /* U+4700 */
  0x8DB1,   /* U+4701 */
  0x8DB2,   /* U+4702 */
  0x8B3E,   /* U+4703 */
  0x8B3F,   /* U+4704 */
  0x8B40,   /* U+4705 */
  0x8B41,   /* U+4706 */
  0x8B42,   /* U+4707 */
  0x8B43,   /* U+4708 */
  0x8B44,   /* U+4709 */
  0x8B45,   /* U+470A */
  0x8849,   /* U+470B */
  0x884A,   /* U+470C */
  0x884B,   /* U+470D */
  0x884C,   /* U+470E */
  0x884D,   /* U+470F */
  0x884E,   /* U+4710 */
  0x884F,   /* U+4711 */
  0x8616,   /* U+4712 */
  0x8617,   /* U+4713 */
  0x8618,   /* U+4714 */
  0x8619,   /* U+4715 */
  0x861A,   /* U+4716 */
  0x861B,   /* U+4717 */
  0x861C,   /* U+4718 */
  0x84D0,   /* U+4719 */
  0x84D1,   /* U+471A */
  0x84D2,   /* U+471B */
  0x84D3,   /* U+471C */
  0x84D4,   /* U+471D */
  0x84D5,   /* U+471E */
  0x836C,   /* U+471F */
  0x836D,   /* U+4720 */
  0x836E,   /* U+4721 */
  0x826A,   /* U+4722 */
  0x97FB,   /* U+4723 */
  0x9802,   /* U+4724 */
  0x9511,   /* U+4725 */
  0x8E02,   /* U+4726 */
  0x8E03,   /* U+4727 */
  0x8B85,   /* U+4728 */
  0x827A,   /* U+4729 */
  0x92E6,   /* U+472A */
  0x9663,   /* U+472B */
  0x99E8,   /* U+472C */
  0x99E9,   /* U+472D */
  0x96F9,   /* U+472E */
  0x951D,   /* U+472F */
  0x8E0A,   /* U+4730 */
  0x8B88,   /* U+4731 */
  0x8393,   /* U+4732 */
  0x8F17,   /* U+4733 */
  0x9829,   /* U+4734 */
  0x99EF,   /* U+4735 */
  0x981B,   /* U+4736 */
  0x96FE,   /* U+4737 */
  0x96FF,   /* U+4738 */
  0x9700,   /* U+4739 */
  0x952B,   /* U+473A */
  0x921D,   /* U+473B */
  0x921E,   /* U+473C */
  0x921F,   /* U+473D */
  0x9220,   /* U+473E */
  0x9221,   /* U+473F */
  0x8E11,   /* U+4740 */
  0x8E12,   /* U+4741 */
  0x8E13,   /* U+4742 */
  0x84FB,   /* U+4743 */
  0x8137,   /* U+4744 */
  0x966D,   /* U+4745 */
  0x9834,   /* U+4746 */
  0x9835,   /* U+4747 */
  0x99FC,   /* U+4748 */
  0x9826,   /* U+4749 */
  0x9538,   /* U+474A */
  0x9539,   /* U+474B */
  0x953A,   /* U+474C */
  0x922B,   /* U+474D */
  0x922C,   /* U+474E */
  0x8B96,   /* U+474F */
  0x88A4,   /* U+4750 */
  0x88A5,   /* U+4751 */
  0x84FF,   /* U+4752 */
  0x8399,   /* U+4753 */
  0x813A,   /* U+4754 */
  0x813B,   /* U+4755 */
  0x9843,   /* U+4756 */
  0x9844,   /* U+4757 */
  0x9845,   /* U+4758 */
  0x9846,   /* U+4759 */
  0x9A11,   /* U+475A */
  0x9A12,   /* U+475B */
  0x971F,   /* U+475C */
  0x9554,   /* U+475D */
  0x9555,   /* U+475E */
  0x9243,   /* U+475F */
  0x8E31,   /* U+4760 */
  0x8BA1,   /* U+4761 */
  0x8BA2,   /* U+4762 */
  0x88AD,   /* U+4763 */
  0x88AE,   /* U+4764 */
  0x88AF,   /* U+4765 */
  0x88B0,   /* U+4766 */
  0x985B,   /* U+4767 */
  0x985C,   /* U+4768 */
  0x9A39,   /* U+4769 */
  0x9A3A,   /* U+476A */
  0x9A3B,   /* U+476B */
  0x9A3C,   /* U+476C */
  0x9A3D,   /* U+476D */
  0x9A3E,   /* U+476E */
  0x9A3F,   /* U+476F */
  0x985A,   /* U+4770 */
  0x985B,   /* U+4771 */
  0x985C,   /* U+4772 */
  0x973B,   /* U+4773 */
  0x973C,   /* U+4774 */
  0x973D,   /* U+4775 */
  0x9579,   /* U+4776 */
  0x957A,   /* U+4777 */
  0x957B,   /* U+4778 */
  0x957C,   /* U+4779 */
  0x957D,   /* U+477A */
  0x957E,   /* U+477B */
  0x957F,   /* U+477C */
  0x9580,   /* U+477D */
  0x9581,   /* U+477E */
  0x9582,   /* U+477F */
  0x925C,   /* U+4780 */
  0x925D,   /* U+4781 */
  0x925E,   /* U+4782 */
  0x925F,   /* U+4783 */
  0x9260,   /* U+4784 */
  0x8E48,   /* U+4785 */
  0x8E49,   /* U+4786 */
  0x8BB5,   /* U+4787 */
  0x88C4,   /* U+4788 */
  0x865F,   /* U+4789 */
  0x83A5,   /* U+478A */
  0x8288,   /* U+478B */
  0x988C,   /* U+478C */
  0x95AF,   /* U+478D */
  0x95B0,   /* U+478E */
  0x9288,   /* U+478F */
  0x9289,   /* U+4790 */
  0x9699,   /* U+4791 */
  0x9899,   /* U+4792 */
  0x976C,   /* U+4793 */
  0x976D,   /* U+4794 */
  0x8522,   /* U+4795 */
  0x969D,   /* U+4796 */
  0x969E,   /* U+4797 */
  0x969F,   /* U+4798 */
  0x989E,   /* U+4799 */
  0x989F,   /* U+479A */
  0x98A0,   /* U+479B */
  0x98A1,   /* U+479C */
  0x9A8C,   /* U+479D */
  0x9A8D,   /* U+479E */
  0x9A8E,   /* U+479F */
  0x9A8F,   /* U+47A0 */
  0x9A90,   /* U+47A1 */
  0x9A91,   /* U+47A2 */
  0x9A92,   /* U+47A3 */
  0x9A93,   /* U+47A4 */
  0x98AA,   /* U+47A5 */
  0x98AB,   /* U+47A6 */
  0x98AC,   /* U+47A7 */
  0x98AD,   /* U+47A8 */
  0x98AE,   /* U+47A9 */
  0x98AF,   /* U+47AA */
  0x9778,   /* U+47AB */
  0x9779,   /* U+47AC */
  0x977A,   /* U+47AD */
  0x977B,   /* U+47AE */
  0x977C,   /* U+47AF */
  0x977D,   /* U+47B0 */
  0x977E,   /* U+47B1 */
  0x977F,   /* U+47B2 */
  0x95C4,   /* U+47B3 */
  0x95C5,   /* U+47B4 */
  0x95C6,   /* U+47B5 */
  0x95C7,   /* U+47B6 */
  0x95C8,   /* U+47B7 */
  0x95C9,   /* U+47B8 */
  0x929D,   /* U+47B9 */
  0x929E,   /* U+47BA */
  0x929F,   /* U+47BB */
  0x92A0,   /* U+47BC */
  0x8E71,   /* U+47BD */
  0x8E72,   /* U+47BE */
  0x8E73,   /* U+47BF */
  0x8E74,   /* U+47C0 */
  0x8BE6,   /* U+47C1 */
  0x8BE7,   /* U+47C2 */
  0x8BE8,   /* U+47C3 */
  0x8BE9,   /* U+47C4 */
  0x8BEA,   /* U+47C5 */
  0x8BEB,   /* U+47C6 */
  0x88F6,   /* U+47C7 */
  0x8677,   /* U+47C8 */
  0x8678,   /* U+47C9 */
  0x8679,   /* U+47CA */
  0x867A,   /* U+47CB */
  0x8528,   /* U+47CC */
  0x83BE,   /* U+47CD */
  0x83BF,   /* U+47CE */
  0x83C0,   /* U+47CF */
  0x8299,   /* U+47D0 */
  0x81ED,   /* U+47D1 */
  0x8145,   /* U+47D2 */
  0x9320,   /* U+47D3 */
  0x9321,   /* U+47D4 */
  0x96B5,   /* U+47D5 */
  0x96B6,   /* U+47D6 */
  0x98CD,   /* U+47D7 */
  0x98CE,   /* U+47D8 */
  0x98CF,   /* U+47D9 */
  0x98D0,   /* U+47DA */
  0x98D1,   /* U+47DB */
  0x98D2,   /* U+47DC */
  0x98D3,   /* U+47DD */
  0x98D4,   /* U+47DE */
  0x9ACF,   /* U+47DF */
  0x9AD0,   /* U+47E0 */
  0x9AD1,   /* U+47E1 */
  0x9AD2,   /* U+47E2 */
  0x9AD3,   /* U+47E3 */
  0x9AD4,   /* U+47E4 */
  0x9AD5,   /* U+47E5 */
  0x9AD6,   /* U+47E6 */
  0x9AD7,   /* U+47E7 */
  0x9AD8,   /* U+47E8 */
  0x9AD9,   /* U+47E9 */
  0x9ADA,   /* U+47EA */
  0x9ADB,   /* U+47EB */
  0x9ADC,   /* U+47EC */
  0x9ADD,   /* U+47ED */
  0x98F6,   /* U+47EE */
  0x98F7,   /* U+47EF */
  0x98F8,   /* U+47F0 */
  0x98F9,   /* U+47F1 */
  0x98FA,   /* U+47F2 */
  0x98FB,   /* U+47F3 */
  0x97BC,   /* U+47F4 */
  0x97BD,   /* U+47F5 */
  0x97BE,   /* U+47F6 */
  0x97BF,   /* U+47F7 */
  0x97C0,   /* U+47F8 */
  0x97C1,   /* U+47F9 */
  0x97C2,   /* U+47FA */
  0x97C3,   /* U+47FB */
  0x960A,   /* U+47FC */
  0x97C4,   /* U+47FD */
  0x960B,   /* U+47FE */
  0x960C,   /* U+47FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4700 */
  0x0000,   /* U+4701 */
  0x0000,   /* U+4702 */
  0x0000,   /* U+4703 */
  0x0000,   /* U+4704 */
  0x0000,   /* U+4705 */
  0x0000,   /* U+4706 */
  0x0000,   /* U+4707 */
  0x0000,   /* U+4708 */
  0x0000,   /* U+4709 */
  0x0000,   /* U+470A */
  0x0000,   /* U+470B */
  0x0000,   /* U+470C */
  0x0000,   /* U+470D */
  0x0000,   /* U+470E */
  0x0000,   /* U+470F */
  0x0000,   /* U+4710 */
  0x0000,   /* U+4711 */
  0x0000,   /* U+4712 */
  0x0000,   /* U+4713 */
  0x0000,   /* U+4714 */
  0x0000,   /* U+4715 */
  0x0000,   /* U+4716 */
  0x0000,   /* U+4717 */
  0x0000,   /* U+4718 */
  0x0000,   /* U+4719 */
  0x0000,   /* U+471A */
  0x0000,   /* U+471B */
  0x0000,   /* U+471C */
  0x0000,   /* U+471D */
  0x0000,   /* U+471E */
  0x0000,   /* U+471F */
  0x0000,   /* U+4720 */
  0x0000,   /* U+4721 */
  0x0000,   /* U+4722 */
  0x0000,   /* U+4723 */
  0x0000,   /* U+4724 */
  0x0000,   /* U+4725 */
  0x0000,   /* U+4726 */
  0x0000,   /* U+4727 */
  0x0000,   /* U+4728 */
  0x0000,   /* U+4729 */
  0x0000,   /* U+472A */
  0x0000,   /* U+472B */
  0x0000,   /* U+472C */
  0x0000,   /* U+472D */
  0x0000,   /* U+472E */
  0x0000,   /* U+472F */
  0x0000,   /* U+4730 */
  0x0000,   /* U+4731 */
  0x0000,   /* U+4732 */
  0x0000,   /* U+4733 */
  0x0000,   /* U+4734 */
  0x0000,   /* U+4735 */
  0x0000,   /* U+4736 */
  0x0000,   /* U+4737 */
  0x0000,   /* U+4738 */
  0x0000,   /* U+4739 */
  0x0000,   /* U+473A */
  0x0000,   /* U+473B */
  0x0000,   /* U+473C */
  0x0000,   /* U+473D */
  0x0000,   /* U+473E */
  0x0000,   /* U+473F */
  0x0000,   /* U+4740 */
  0x0000,   /* U+4741 */
  0x0000,   /* U+4742 */
  0x0000,   /* U+4743 */
  0x0000,   /* U+4744 */
  0x0000,   /* U+4745 */
  0x0000,   /* U+4746 */
  0x0000,   /* U+4747 */
  0x0000,   /* U+4748 */
  0x0000,   /* U+4749 */
  0x0000,   /* U+474A */
  0x0000,   /* U+474B */
  0x0000,   /* U+474C */
  0x0000,   /* U+474D */
  0x0000,   /* U+474E */
  0x0000,   /* U+474F */
  0x0000,   /* U+4750 */
  0x0000,   /* U+4751 */
  0x0000,   /* U+4752 */
  0x0000,   /* U+4753 */
  0x0000,   /* U+4754 */
  0x0000,   /* U+4755 */
  0x0000,   /* U+4756 */
  0x0000,   /* U+4757 */
  0x0000,   /* U+4758 */
  0x0000,   /* U+4759 */
  0x0000,   /* U+475A */
  0x0000,   /* U+475B */
  0x0000,   /* U+475C */
  0x0000,   /* U+475D */
  0x0000,   /* U+475E */
  0x0000,   /* U+475F */
  0x0000,   /* U+4760 */
  0x0000,   /* U+4761 */
  0x0000,   /* U+4762 */
  0x0000,   /* U+4763 */
  0x0000,   /* U+4764 */
  0x0000,   /* U+4765 */
  0x0000,   /* U+4766 */
  0x0000,   /* U+4767 */
  0x0000,   /* U+4768 */
  0x0000,   /* U+4769 */
  0x0000,   /* U+476A */
  0x0000,   /* U+476B */
  0x0000,   /* U+476C */
  0x0000,   /* U+476D */
  0x0000,   /* U+476E */
  0x0000,   /* U+476F */
  0x0000,   /* U+4770 */
  0x0000,   /* U+4771 */
  0x0000,   /* U+4772 */
  0x0000,   /* U+4773 */
  0x0000,   /* U+4774 */
  0x0000,   /* U+4775 */
  0x0000,   /* U+4776 */
  0x0000,   /* U+4777 */
  0x0000,   /* U+4778 */
  0x0000,   /* U+4779 */
  0x0000,   /* U+477A */
  0x0000,   /* U+477B */
  0x0000,   /* U+477C */
  0x0000,   /* U+477D */
  0x0000,   /* U+477E */
  0x0000,   /* U+477F */
  0x0000,   /* U+4780 */
  0x0000,   /* U+4781 */
  0x0000,   /* U+4782 */
  0x0000,   /* U+4783 */
  0x0000,   /* U+4784 */
  0x0000,   /* U+4785 */
  0x0000,   /* U+4786 */
  0x0000,   /* U+4787 */
  0x0000,   /* U+4788 */
  0x0000,   /* U+4789 */
  0x0000,   /* U+478A */
  0x0000,   /* U+478B */
  0x0000,   /* U+478C */
  0x0000,   /* U+478D */
  0x0000,   /* U+478E */
  0x0000,   /* U+478F */
  0x0000,   /* U+4790 */
  0x0000,   /* U+4791 */
  0x0000,   /* U+4792 */
  0x0000,   /* U+4793 */
  0x0000,   /* U+4794 */
  0x0000,   /* U+4795 */
  0x0000,   /* U+4796 */
  0x0000,   /* U+4797 */
  0x0000,   /* U+4798 */
  0x0000,   /* U+4799 */
  0x0000,   /* U+479A */
  0x0000,   /* U+479B */
  0x0000,   /* U+479C */
  0x0000,   /* U+479D */
  0x0000,   /* U+479E */
  0x0000,   /* U+479F */
  0x0000,   /* U+47A0 */
  0x0000,   /* U+47A1 */
  0x0000,   /* U+47A2 */
  0x0000,   /* U+47A3 */
  0x0000,   /* U+47A4 */
  0x0000,   /* U+47A5 */
  0x0000,   /* U+47A6 */
  0x0000,   /* U+47A7 */
  0x0000,   /* U+47A8 */
  0x0000,   /* U+47A9 */
  0x0000,   /* U+47AA */
  0x0000,   /* U+47AB */
  0x0000,   /* U+47AC */
  0x0000,   /* U+47AD */
  0x0000,   /* U+47AE */
  0x0000,   /* U+47AF */
  0x0000,   /* U+47B0 */
  0x0000,   /* U+47B1 */
  0x0000,   /* U+47B2 */
  0x0000,   /* U+47B3 */
  0x0000,   /* U+47B4 */
  0x0000,   /* U+47B5 */
  0x0000,   /* U+47B6 */
  0x0000,   /* U+47B7 */
  0x0000,   /* U+47B8 */
  0x0000,   /* U+47B9 */
  0x0000,   /* U+47BA */
  0x0000,   /* U+47BB */
  0x0000,   /* U+47BC */
  0x0000,   /* U+47BD */
  0x0000,   /* U+47BE */
  0x0000,   /* U+47BF */
  0x0000,   /* U+47C0 */
  0x0000,   /* U+47C1 */
  0x0000,   /* U+47C2 */
  0x0000,   /* U+47C3 */
  0x0000,   /* U+47C4 */
  0x0000,   /* U+47C5 */
  0x0000,   /* U+47C6 */
  0x0000,   /* U+47C7 */
  0x0000,   /* U+47C8 */
  0x0000,   /* U+47C9 */
  0x0000,   /* U+47CA */
  0x0000,   /* U+47CB */
  0x0000,   /* U+47CC */
  0x0000,   /* U+47CD */
  0x0000,   /* U+47CE */
  0x0000,   /* U+47CF */
  0x0000,   /* U+47D0 */
  0x0000,   /* U+47D1 */
  0x0000,   /* U+47D2 */
  0x0000,   /* U+47D3 */
  0x0000,   /* U+47D4 */
  0x0000,   /* U+47D5 */
  0x0000,   /* U+47D6 */
  0x0000,   /* U+47D7 */
  0x0000,   /* U+47D8 */
  0x0000,   /* U+47D9 */
  0x0000,   /* U+47DA */
  0x0000,   /* U+47DB */
  0x0000,   /* U+47DC */
  0x0000,   /* U+47DD */
  0x0000,   /* U+47DE */
  0x0000,   /* U+47DF */
  0x0000,   /* U+47E0 */
  0x0000,   /* U+47E1 */
  0x0000,   /* U+47E2 */
  0x0000,   /* U+47E3 */
  0x0000,   /* U+47E4 */
  0x0000,   /* U+47E5 */
  0x0000,   /* U+47E6 */
  0x0000,   /* U+47E7 */
  0x0000,   /* U+47E8 */
  0x0000,   /* U+47E9 */
  0x0000,   /* U+47EA */
  0x0000,   /* U+47EB */
  0x0000,   /* U+47EC */
  0x0000,   /* U+47ED */
  0x0000,   /* U+47EE */
  0x0000,   /* U+47EF */
  0x0000,   /* U+47F0 */
  0x0000,   /* U+47F1 */
  0x0000,   /* U+47F2 */
  0x0000,   /* U+47F3 */
  0x0000,   /* U+47F4 */
  0x0000,   /* U+47F5 */
  0x0000,   /* U+47F6 */
  0x0000,   /* U+47F7 */
  0x0000,   /* U+47F8 */
  0x0000,   /* U+47F9 */
  0x0000,   /* U+47FA */
  0x0000,   /* U+47FB */
  0x0000,   /* U+47FC */
  0x0000,   /* U+47FD */
  0x0000,   /* U+47FE */
  0x0000,   /* U+47FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4700 */
  0x0000,   /* U+4701 */
  0x0000,   /* U+4702 */
  0x0000,   /* U+4703 */
  0x0000,   /* U+4704 */
  0x0000,   /* U+4705 */
  0x0000,   /* U+4706 */
  0x0000,   /* U+4707 */
  0x0000,   /* U+4708 */
  0x0000,   /* U+4709 */
  0x0000,   /* U+470A */
  0x0000,   /* U+470B */
  0x0000,   /* U+470C */
  0x0000,   /* U+470D */
  0x0000,   /* U+470E */
  0x0000,   /* U+470F */
  0x0000,   /* U+4710 */
  0x0000,   /* U+4711 */
  0x0000,   /* U+4712 */
  0x0000,   /* U+4713 */
  0x0000,   /* U+4714 */
  0x0000,   /* U+4715 */
  0x0000,   /* U+4716 */
  0x0000,   /* U+4717 */
  0x0000,   /* U+4718 */
  0x0000,   /* U+4719 */
  0x0000,   /* U+471A */
  0x0000,   /* U+471B */
  0x0000,   /* U+471C */
  0x0000,   /* U+471D */
  0x0000,   /* U+471E */
  0x0000,   /* U+471F */
  0x0000,   /* U+4720 */
  0x0000,   /* U+4721 */
  0x0000,   /* U+4722 */
  0x0000,   /* U+4723 */
  0x0000,   /* U+4724 */
  0x0000,   /* U+4725 */
  0x0000,   /* U+4726 */
  0x0000,   /* U+4727 */
  0x0000,   /* U+4728 */
  0x0000,   /* U+4729 */
  0x0000,   /* U+472A */
  0x0000,   /* U+472B */
  0x0000,   /* U+472C */
  0x0000,   /* U+472D */
  0x0000,   /* U+472E */
  0x0000,   /* U+472F */
  0x0000,   /* U+4730 */
  0x0000,   /* U+4731 */
  0x0000,   /* U+4732 */
  0x0000,   /* U+4733 */
  0x0000,   /* U+4734 */
  0x0000,   /* U+4735 */
  0x0000,   /* U+4736 */
  0x0000,   /* U+4737 */
  0x0000,   /* U+4738 */
  0x0000,   /* U+4739 */
  0x0000,   /* U+473A */
  0x0000,   /* U+473B */
  0x0000,   /* U+473C */
  0x0000,   /* U+473D */
  0x0000,   /* U+473E */
  0x0000,   /* U+473F */
  0x0000,   /* U+4740 */
  0x0000,   /* U+4741 */
  0x0000,   /* U+4742 */
  0x0000,   /* U+4743 */
  0x0000,   /* U+4744 */
  0x0000,   /* U+4745 */
  0x0000,   /* U+4746 */
  0x0000,   /* U+4747 */
  0x0000,   /* U+4748 */
  0x0000,   /* U+4749 */
  0x0000,   /* U+474A */
  0x0000,   /* U+474B */
  0x0000,   /* U+474C */
  0x0000,   /* U+474D */
  0x0000,   /* U+474E */
  0x0000,   /* U+474F */
  0x0000,   /* U+4750 */
  0x0000,   /* U+4751 */
  0x0000,   /* U+4752 */
  0x0000,   /* U+4753 */
  0x0000,   /* U+4754 */
  0x0000,   /* U+4755 */
  0x0000,   /* U+4756 */
  0x0000,   /* U+4757 */
  0x0000,   /* U+4758 */
  0x0000,   /* U+4759 */
  0x0000,   /* U+475A */
  0x0000,   /* U+475B */
  0x0000,   /* U+475C */
  0x0000,   /* U+475D */
  0x0000,   /* U+475E */
  0x0000,   /* U+475F */
  0x0000,   /* U+4760 */
  0x0000,   /* U+4761 */
  0x0000,   /* U+4762 */
  0x0000,   /* U+4763 */
  0x0000,   /* U+4764 */
  0x0000,   /* U+4765 */
  0x0000,   /* U+4766 */
  0x0000,   /* U+4767 */
  0x0000,   /* U+4768 */
  0x0000,   /* U+4769 */
  0x0000,   /* U+476A */
  0x0000,   /* U+476B */
  0x0000,   /* U+476C */
  0x0000,   /* U+476D */
  0x0000,   /* U+476E */
  0x0000,   /* U+476F */
  0x0000,   /* U+4770 */
  0x0000,   /* U+4771 */
  0x0000,   /* U+4772 */
  0x0000,   /* U+4773 */
  0x0000,   /* U+4774 */
  0x0000,   /* U+4775 */
  0x0000,   /* U+4776 */
  0x0000,   /* U+4777 */
  0x0000,   /* U+4778 */
  0x0000,   /* U+4779 */
  0x0000,   /* U+477A */
  0x0000,   /* U+477B */
  0x0000,   /* U+477C */
  0x0000,   /* U+477D */
  0x0000,   /* U+477E */
  0x0000,   /* U+477F */
  0x0000,   /* U+4780 */
  0x0000,   /* U+4781 */
  0x0000,   /* U+4782 */
  0x0000,   /* U+4783 */
  0x0000,   /* U+4784 */
  0x0000,   /* U+4785 */
  0x0000,   /* U+4786 */
  0x0000,   /* U+4787 */
  0x0000,   /* U+4788 */
  0x0000,   /* U+4789 */
  0x0000,   /* U+478A */
  0x0000,   /* U+478B */
  0x0000,   /* U+478C */
  0x0000,   /* U+478D */
  0x0000,   /* U+478E */
  0x0000,   /* U+478F */
  0x0000,   /* U+4790 */
  0x0000,   /* U+4791 */
  0x0000,   /* U+4792 */
  0x0000,   /* U+4793 */
  0x0000,   /* U+4794 */
  0x0000,   /* U+4795 */
  0x0000,   /* U+4796 */
  0x0000,   /* U+4797 */
  0x0000,   /* U+4798 */
  0x0000,   /* U+4799 */
  0x0000,   /* U+479A */
  0x0000,   /* U+479B */
  0x0000,   /* U+479C */
  0x0000,   /* U+479D */
  0x0000,   /* U+479E */
  0x0000,   /* U+479F */
  0x0000,   /* U+47A0 */
  0x0000,   /* U+47A1 */
  0x0000,   /* U+47A2 */
  0x0000,   /* U+47A3 */
  0x0000,   /* U+47A4 */
  0x0000,   /* U+47A5 */
  0x0000,   /* U+47A6 */
  0x0000,   /* U+47A7 */
  0x0000,   /* U+47A8 */
  0x0000,   /* U+47A9 */
  0x0000,   /* U+47AA */
  0x0000,   /* U+47AB */
  0x0000,   /* U+47AC */
  0x0000,   /* U+47AD */
  0x0000,   /* U+47AE */
  0x0000,   /* U+47AF */
  0x0000,   /* U+47B0 */
  0x0000,   /* U+47B1 */
  0x0000,   /* U+47B2 */
  0x0000,   /* U+47B3 */
  0x0000,   /* U+47B4 */
  0x0000,   /* U+47B5 */
  0x0000,   /* U+47B6 */
  0x0000,   /* U+47B7 */
  0x0000,   /* U+47B8 */
  0x0000,   /* U+47B9 */
  0x0000,   /* U+47BA */
  0x0000,   /* U+47BB */
  0x0000,   /* U+47BC */
  0x0000,   /* U+47BD */
  0x0000,   /* U+47BE */
  0x0000,   /* U+47BF */
  0x0000,   /* U+47C0 */
  0x0000,   /* U+47C1 */
  0x0000,   /* U+47C2 */
  0x0000,   /* U+47C3 */
  0x0000,   /* U+47C4 */
  0x0000,   /* U+47C5 */
  0x0000,   /* U+47C6 */
  0x0000,   /* U+47C7 */
  0x0000,   /* U+47C8 */
  0x0000,   /* U+47C9 */
  0x0000,   /* U+47CA */
  0x0000,   /* U+47CB */
  0x0000,   /* U+47CC */
  0x0000,   /* U+47CD */
  0x0000,   /* U+47CE */
  0x0000,   /* U+47CF */
  0x0000,   /* U+47D0 */
  0x0000,   /* U+47D1 */
  0x0000,   /* U+47D2 */
  0x0000,   /* U+47D3 */
  0x0000,   /* U+47D4 */
  0x0000,   /* U+47D5 */
  0x0000,   /* U+47D6 */
  0x0000,   /* U+47D7 */
  0x0000,   /* U+47D8 */
  0x0000,   /* U+47D9 */
  0x0000,   /* U+47DA */
  0x0000,   /* U+47DB */
  0x0000,   /* U+47DC */
  0x0000,   /* U+47DD */
  0x0000,   /* U+47DE */
  0x0000,   /* U+47DF */
  0x0000,   /* U+47E0 */
  0x0000,   /* U+47E1 */
  0x0000,   /* U+47E2 */
  0x0000,   /* U+47E3 */
  0x0000,   /* U+47E4 */
  0x0000,   /* U+47E5 */
  0x0000,   /* U+47E6 */
  0x0000,   /* U+47E7 */
  0x0000,   /* U+47E8 */
  0x0000,   /* U+47E9 */
  0x0000,   /* U+47EA */
  0x0000,   /* U+47EB */
  0x0000,   /* U+47EC */
  0x0000,   /* U+47ED */
  0x0000,   /* U+47EE */
  0x0000,   /* U+47EF */
  0x0000,   /* U+47F0 */
  0x0000,   /* U+47F1 */
  0x0000,   /* U+47F2 */
  0x0000,   /* U+47F3 */
  0x0000,   /* U+47F4 */
  0x0000,   /* U+47F5 */
  0x0000,   /* U+47F6 */
  0x0000,   /* U+47F7 */
  0x0000,   /* U+47F8 */
  0x0000,   /* U+47F9 */
  0x0000,   /* U+47FA */
  0x0000,   /* U+47FB */
  0x0000,   /* U+47FC */
  0x0000,   /* U+47FD */
  0x0000,   /* U+47FE */
  0x0000,   /* U+47FF */
};

uint16 zh3_han_p048[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C56,   /* U+4800 */
  0x1C56,   /* U+4801 */
  0x1C56,   /* U+4802 */
  0x1C56,   /* U+4803 */
  0x1C56,   /* U+4804 */
  0x1C56,   /* U+4805 */
  0x1C56,   /* U+4806 */
  0x1C56,   /* U+4807 */
  0x1C56,   /* U+4808 */
  0x1C56,   /* U+4809 */
  0x1C56,   /* U+480A */
  0x1C56,   /* U+480B */
  0x1C56,   /* U+480C */
  0x1C57,   /* U+480D */
  0x1C57,   /* U+480E */
  0x1C57,   /* U+480F */
  0x1C57,   /* U+4810 */
  0x1C57,   /* U+4811 */
  0x1C57,   /* U+4812 */
  0x1C57,   /* U+4813 */
  0x1C57,   /* U+4814 */
  0x1C57,   /* U+4815 */
  0x1C57,   /* U+4816 */
  0x1C58,   /* U+4817 */
  0x1C58,   /* U+4818 */
  0x1C58,   /* U+4819 */
  0x1C58,   /* U+481A */
  0x1C58,   /* U+481B */
  0x1C58,   /* U+481C */
  0x1C58,   /* U+481D */
  0x1C59,   /* U+481E */
  0x1C59,   /* U+481F */
  0x1C59,   /* U+4820 */
  0x1C59,   /* U+4821 */
  0x1C59,   /* U+4822 */
  0x1C5A,   /* U+4823 */
  0x1C5A,   /* U+4824 */
  0x1C5A,   /* U+4825 */
  0x1C5A,   /* U+4826 */
  0x1C5A,   /* U+4827 */
  0x1C5B,   /* U+4828 */
  0x1C5B,   /* U+4829 */
  0x1C5C,   /* U+482A */
  0x1C5C,   /* U+482B */
  0x1C5D,   /* U+482C */
  0x1C5E,   /* U+482D */
  0x1C5E,   /* U+482E */
  0x1C5F,   /* U+482F */
  0x1C60,   /* U+4830 */
  0x1C63,   /* U+4831 */
  0x1C53,   /* U+4832 */
  0x1C53,   /* U+4833 */
  0x1C53,   /* U+4834 */
  0x1C53,   /* U+4835 */
  0x1C53,   /* U+4836 */
  0x1C54,   /* U+4837 */
  0x1C54,   /* U+4838 */
  0x1C54,   /* U+4839 */
  0x1C54,   /* U+483A */
  0x1C56,   /* U+483B */
  0x1C57,   /* U+483C */
  0x1C58,   /* U+483D */
  0x1C58,   /* U+483E */
  0x1C5A,   /* U+483F */
  0x1C5B,   /* U+4840 */
  0x1C5E,   /* U+4841 */
  0x1C50,   /* U+4842 */
  0x1C50,   /* U+4843 */
  0x1C50,   /* U+4844 */
  0x1C51,   /* U+4845 */
  0x1C52,   /* U+4846 */
  0x1C52,   /* U+4847 */
  0x1C52,   /* U+4848 */
  0x1C52,   /* U+4849 */
  0x1C52,   /* U+484A */
  0x1C52,   /* U+484B */
  0x1C52,   /* U+484C */
  0x1C52,   /* U+484D */
  0x1C52,   /* U+484E */
  0x1C53,   /* U+484F */
  0x1C53,   /* U+4850 */
  0x1C53,   /* U+4851 */
  0x1C53,   /* U+4852 */
  0x1C54,   /* U+4853 */
  0x1C54,   /* U+4854 */
  0x1C54,   /* U+4855 */
  0x1C54,   /* U+4856 */
  0x1C54,   /* U+4857 */
  0x1C55,   /* U+4858 */
  0x1C55,   /* U+4859 */
  0x1C55,   /* U+485A */
  0x1C55,   /* U+485B */
  0x1C56,   /* U+485C */
  0x1C56,   /* U+485D */
  0x1C56,   /* U+485E */
  0x1C56,   /* U+485F */
  0x1C57,   /* U+4860 */
  0x1C57,   /* U+4861 */
  0x1C57,   /* U+4862 */
  0x1C57,   /* U+4863 */
  0x1C57,   /* U+4864 */
  0x1C58,   /* U+4865 */
  0x1C58,   /* U+4866 */
  0x1C58,   /* U+4867 */
  0x1C58,   /* U+4868 */
  0x1C58,   /* U+4869 */
  0x1C58,   /* U+486A */
  0x1C59,   /* U+486B */
  0x1C59,   /* U+486C */
  0x1C59,   /* U+486D */
  0x1C59,   /* U+486E */
  0x1C59,   /* U+486F */
  0x1C59,   /* U+4870 */
  0x1C59,   /* U+4871 */
  0x1C5A,   /* U+4872 */
  0x1C5A,   /* U+4873 */
  0x1C5A,   /* U+4874 */
  0x1C5A,   /* U+4875 */
  0x1C5B,   /* U+4876 */
  0x1C5C,   /* U+4877 */
  0x1C5C,   /* U+4878 */
  0x1C5C,   /* U+4879 */
  0x1C5D,   /* U+487A */
  0x1C5D,   /* U+487B */
  0x1C5F,   /* U+487C */
  0x1C61,   /* U+487D */
  0x1C62,   /* U+487E */
  0x1C66,   /* U+487F */
  0x1C51,   /* U+4880 */
  0x1C52,   /* U+4881 */
  0x1C50,   /* U+4882 */
  0x1C56,   /* U+4883 */
  0x1C5B,   /* U+4884 */
  0x1C54,   /* U+4885 */
  0x1C55,   /* U+4886 */
  0x1C56,   /* U+4887 */
  0x1C5B,   /* U+4888 */
  0x1C5B,   /* U+4889 */
  0x1C4E,   /* U+488A */
  0x1C4E,   /* U+488B */
  0x1C4F,   /* U+488C */
  0x1C4F,   /* U+488D */
  0x1C4F,   /* U+488E */
  0x1C4F,   /* U+488F */
  0x1C50,   /* U+4890 */
  0x1C50,   /* U+4891 */
  0x1C51,   /* U+4892 */
  0x1C51,   /* U+4893 */
  0x1C51,   /* U+4894 */
  0x1C51,   /* U+4895 */
  0x1C51,   /* U+4896 */
  0x1C51,   /* U+4897 */
  0x1C51,   /* U+4898 */
  0x1C52,   /* U+4899 */
  0x1C52,   /* U+489A */
  0x1C52,   /* U+489B */
  0x1C53,   /* U+489C */
  0x1C53,   /* U+489D */
  0x1C53,   /* U+489E */
  0x1C53,   /* U+489F */
  0x1C53,   /* U+48A0 */
  0x1C54,   /* U+48A1 */
  0x1C55,   /* U+48A2 */
  0x1C55,   /* U+48A3 */
  0x1C55,   /* U+48A4 */
  0x1C55,   /* U+48A5 */
  0x1C56,   /* U+48A6 */
  0x1C56,   /* U+48A7 */
  0x1C56,   /* U+48A8 */
  0x1C56,   /* U+48A9 */
  0x1C57,   /* U+48AA */
  0x1C57,   /* U+48AB */
  0x1C57,   /* U+48AC */
  0x1C57,   /* U+48AD */
  0x1C58,   /* U+48AE */
  0x1C59,   /* U+48AF */
  0x1C59,   /* U+48B0 */
  0x1C5A,   /* U+48B1 */
  0x1C5F,   /* U+48B2 */
  0x1C4C,   /* U+48B3 */
  0x1C4D,   /* U+48B4 */
  0x1C4E,   /* U+48B5 */
  0x1C4E,   /* U+48B6 */
  0x1C4E,   /* U+48B7 */
  0x1C4F,   /* U+48B8 */
  0x1C4F,   /* U+48B9 */
  0x1C4F,   /* U+48BA */
  0x1C50,   /* U+48BB */
  0x1C50,   /* U+48BC */
  0x1C54,   /* U+48BD */
  0x1C50,   /* U+48BE */
  0x1C50,   /* U+48BF */
  0x1C50,   /* U+48C0 */
  0x1C50,   /* U+48C1 */
  0x1C50,   /* U+48C2 */
  0x1C51,   /* U+48C3 */
  0x1C51,   /* U+48C4 */
  0x1C51,   /* U+48C5 */
  0x1C51,   /* U+48C6 */
  0x1C51,   /* U+48C7 */
  0x1C55,   /* U+48C8 */
  0x1C55,   /* U+48C9 */
  0x1C52,   /* U+48CA */
  0x1C52,   /* U+48CB */
  0x1C52,   /* U+48CC */
  0x1C52,   /* U+48CD */
  0x1C52,   /* U+48CE */
  0x1C52,   /* U+48CF */
  0x1C53,   /* U+48D0 */
  0x1C53,   /* U+48D1 */
  0x1C53,   /* U+48D2 */
  0x1C54,   /* U+48D3 */
  0x1C54,   /* U+48D4 */
  0x1C54,   /* U+48D5 */
  0x1C58,   /* U+48D6 */
  0x1C54,   /* U+48D7 */
  0x1C55,   /* U+48D8 */
  0x1C55,   /* U+48D9 */
  0x1C55,   /* U+48DA */
  0x1C55,   /* U+48DB */
  0x1C55,   /* U+48DC */
  0x1C56,   /* U+48DD */
  0x1C56,   /* U+48DE */
  0x1C56,   /* U+48DF */
  0x1C56,   /* U+48E0 */
  0x1C57,   /* U+48E1 */
  0x1C58,   /* U+48E2 */
  0x1C5E,   /* U+48E3 */
  0x1C5E,   /* U+48E4 */
  0x1C50,   /* U+48E5 */
  0x1C50,   /* U+48E6 */
  0x1C51,   /* U+48E7 */
  0x1C51,   /* U+48E8 */
  0x1C52,   /* U+48E9 */
  0x1C52,   /* U+48EA */
  0x1C52,   /* U+48EB */
  0x1C52,   /* U+48EC */
  0x1C52,   /* U+48ED */
  0x1C53,   /* U+48EE */
  0x1C53,   /* U+48EF */
  0x1C53,   /* U+48F0 */
  0x1C54,   /* U+48F1 */
  0x1C53,   /* U+48F2 */
  0x1C53,   /* U+48F3 */
  0x1C54,   /* U+48F4 */
  0x1C54,   /* U+48F5 */
  0x1C54,   /* U+48F6 */
  0x1C54,   /* U+48F7 */
  0x1C54,   /* U+48F8 */
  0x1C54,   /* U+48F9 */
  0x1C55,   /* U+48FA */
  0x1C55,   /* U+48FB */
  0x1C56,   /* U+48FC */
  0x1C56,   /* U+48FD */
  0x1C56,   /* U+48FE */
  0x1C56,   /* U+48FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4800 */
  0x0020,   /* U+4801 */
  0x0020,   /* U+4802 */
  0x0020,   /* U+4803 */
  0x0020,   /* U+4804 */
  0x0020,   /* U+4805 */
  0x0020,   /* U+4806 */
  0x0020,   /* U+4807 */
  0x0020,   /* U+4808 */
  0x0020,   /* U+4809 */
  0x0020,   /* U+480A */
  0x0020,   /* U+480B */
  0x0020,   /* U+480C */
  0x0020,   /* U+480D */
  0x0020,   /* U+480E */
  0x0020,   /* U+480F */
  0x0020,   /* U+4810 */
  0x0020,   /* U+4811 */
  0x0020,   /* U+4812 */
  0x0020,   /* U+4813 */
  0x0020,   /* U+4814 */
  0x0020,   /* U+4815 */
  0x0020,   /* U+4816 */
  0x0020,   /* U+4817 */
  0x0020,   /* U+4818 */
  0x0020,   /* U+4819 */
  0x0020,   /* U+481A */
  0x0020,   /* U+481B */
  0x0020,   /* U+481C */
  0x0020,   /* U+481D */
  0x0020,   /* U+481E */
  0x0020,   /* U+481F */
  0x0020,   /* U+4820 */
  0x0020,   /* U+4821 */
  0x0020,   /* U+4822 */
  0x0020,   /* U+4823 */
  0x0020,   /* U+4824 */
  0x0020,   /* U+4825 */
  0x0020,   /* U+4826 */
  0x0020,   /* U+4827 */
  0x0020,   /* U+4828 */
  0x0020,   /* U+4829 */
  0x0020,   /* U+482A */
  0x0020,   /* U+482B */
  0x0020,   /* U+482C */
  0x0020,   /* U+482D */
  0x0020,   /* U+482E */
  0x0020,   /* U+482F */
  0x0020,   /* U+4830 */
  0x0020,   /* U+4831 */
  0x0020,   /* U+4832 */
  0x0020,   /* U+4833 */
  0x0020,   /* U+4834 */
  0x0020,   /* U+4835 */
  0x0020,   /* U+4836 */
  0x0020,   /* U+4837 */
  0x0020,   /* U+4838 */
  0x0020,   /* U+4839 */
  0x0020,   /* U+483A */
  0x0020,   /* U+483B */
  0x0020,   /* U+483C */
  0x0020,   /* U+483D */
  0x0020,   /* U+483E */
  0x0020,   /* U+483F */
  0x0020,   /* U+4840 */
  0x0020,   /* U+4841 */
  0x0020,   /* U+4842 */
  0x0020,   /* U+4843 */
  0x0020,   /* U+4844 */
  0x0020,   /* U+4845 */
  0x0020,   /* U+4846 */
  0x0020,   /* U+4847 */
  0x0020,   /* U+4848 */
  0x0020,   /* U+4849 */
  0x0020,   /* U+484A */
  0x0020,   /* U+484B */
  0x0020,   /* U+484C */
  0x0020,   /* U+484D */
  0x0020,   /* U+484E */
  0x0020,   /* U+484F */
  0x0020,   /* U+4850 */
  0x0020,   /* U+4851 */
  0x0020,   /* U+4852 */
  0x0020,   /* U+4853 */
  0x0020,   /* U+4854 */
  0x0020,   /* U+4855 */
  0x0020,   /* U+4856 */
  0x0020,   /* U+4857 */
  0x0020,   /* U+4858 */
  0x0020,   /* U+4859 */
  0x0020,   /* U+485A */
  0x0020,   /* U+485B */
  0x0020,   /* U+485C */
  0x0020,   /* U+485D */
  0x0020,   /* U+485E */
  0x0020,   /* U+485F */
  0x0020,   /* U+4860 */
  0x0020,   /* U+4861 */
  0x0020,   /* U+4862 */
  0x0020,   /* U+4863 */
  0x0020,   /* U+4864 */
  0x0020,   /* U+4865 */
  0x0020,   /* U+4866 */
  0x0020,   /* U+4867 */
  0x0020,   /* U+4868 */
  0x0020,   /* U+4869 */
  0x0020,   /* U+486A */
  0x0020,   /* U+486B */
  0x0020,   /* U+486C */
  0x0020,   /* U+486D */
  0x0020,   /* U+486E */
  0x0020,   /* U+486F */
  0x0020,   /* U+4870 */
  0x0020,   /* U+4871 */
  0x0020,   /* U+4872 */
  0x0020,   /* U+4873 */
  0x0020,   /* U+4874 */
  0x0020,   /* U+4875 */
  0x0020,   /* U+4876 */
  0x0020,   /* U+4877 */
  0x0020,   /* U+4878 */
  0x0020,   /* U+4879 */
  0x0020,   /* U+487A */
  0x0020,   /* U+487B */
  0x0020,   /* U+487C */
  0x0020,   /* U+487D */
  0x0020,   /* U+487E */
  0x0020,   /* U+487F */
  0x0020,   /* U+4880 */
  0x0020,   /* U+4881 */
  0x0020,   /* U+4882 */
  0x0020,   /* U+4883 */
  0x0020,   /* U+4884 */
  0x0020,   /* U+4885 */
  0x0020,   /* U+4886 */
  0x0020,   /* U+4887 */
  0x0020,   /* U+4888 */
  0x0020,   /* U+4889 */
  0x0020,   /* U+488A */
  0x0020,   /* U+488B */
  0x0020,   /* U+488C */
  0x0020,   /* U+488D */
  0x0020,   /* U+488E */
  0x0020,   /* U+488F */
  0x0020,   /* U+4890 */
  0x0020,   /* U+4891 */
  0x0020,   /* U+4892 */
  0x0020,   /* U+4893 */
  0x0020,   /* U+4894 */
  0x0020,   /* U+4895 */
  0x0020,   /* U+4896 */
  0x0020,   /* U+4897 */
  0x0020,   /* U+4898 */
  0x0020,   /* U+4899 */
  0x0020,   /* U+489A */
  0x0020,   /* U+489B */
  0x0020,   /* U+489C */
  0x0020,   /* U+489D */
  0x0020,   /* U+489E */
  0x0020,   /* U+489F */
  0x0020,   /* U+48A0 */
  0x0020,   /* U+48A1 */
  0x0020,   /* U+48A2 */
  0x0020,   /* U+48A3 */
  0x0020,   /* U+48A4 */
  0x0020,   /* U+48A5 */
  0x0020,   /* U+48A6 */
  0x0020,   /* U+48A7 */
  0x0020,   /* U+48A8 */
  0x0020,   /* U+48A9 */
  0x0020,   /* U+48AA */
  0x0020,   /* U+48AB */
  0x0020,   /* U+48AC */
  0x0020,   /* U+48AD */
  0x0020,   /* U+48AE */
  0x0020,   /* U+48AF */
  0x0020,   /* U+48B0 */
  0x0020,   /* U+48B1 */
  0x0020,   /* U+48B2 */
  0x0020,   /* U+48B3 */
  0x0020,   /* U+48B4 */
  0x0020,   /* U+48B5 */
  0x0020,   /* U+48B6 */
  0x0020,   /* U+48B7 */
  0x0020,   /* U+48B8 */
  0x0020,   /* U+48B9 */
  0x0020,   /* U+48BA */
  0x0020,   /* U+48BB */
  0x0020,   /* U+48BC */
  0x0020,   /* U+48BD */
  0x0020,   /* U+48BE */
  0x0020,   /* U+48BF */
  0x0020,   /* U+48C0 */
  0x0020,   /* U+48C1 */
  0x0020,   /* U+48C2 */
  0x0020,   /* U+48C3 */
  0x0020,   /* U+48C4 */
  0x0020,   /* U+48C5 */
  0x0020,   /* U+48C6 */
  0x0020,   /* U+48C7 */
  0x0020,   /* U+48C8 */
  0x0020,   /* U+48C9 */
  0x0020,   /* U+48CA */
  0x0020,   /* U+48CB */
  0x0020,   /* U+48CC */
  0x0020,   /* U+48CD */
  0x0020,   /* U+48CE */
  0x0020,   /* U+48CF */
  0x0020,   /* U+48D0 */
  0x0020,   /* U+48D1 */
  0x0020,   /* U+48D2 */
  0x0020,   /* U+48D3 */
  0x0020,   /* U+48D4 */
  0x0020,   /* U+48D5 */
  0x0020,   /* U+48D6 */
  0x0020,   /* U+48D7 */
  0x0020,   /* U+48D8 */
  0x0020,   /* U+48D9 */
  0x0020,   /* U+48DA */
  0x0020,   /* U+48DB */
  0x0020,   /* U+48DC */
  0x0020,   /* U+48DD */
  0x0020,   /* U+48DE */
  0x0020,   /* U+48DF */
  0x0020,   /* U+48E0 */
  0x0020,   /* U+48E1 */
  0x0020,   /* U+48E2 */
  0x0020,   /* U+48E3 */
  0x0020,   /* U+48E4 */
  0x0020,   /* U+48E5 */
  0x0020,   /* U+48E6 */
  0x0020,   /* U+48E7 */
  0x0020,   /* U+48E8 */
  0x0020,   /* U+48E9 */
  0x0020,   /* U+48EA */
  0x0020,   /* U+48EB */
  0x0020,   /* U+48EC */
  0x0020,   /* U+48ED */
  0x0020,   /* U+48EE */
  0x0020,   /* U+48EF */
  0x0020,   /* U+48F0 */
  0x0020,   /* U+48F1 */
  0x0020,   /* U+48F2 */
  0x0020,   /* U+48F3 */
  0x0020,   /* U+48F4 */
  0x0020,   /* U+48F5 */
  0x0020,   /* U+48F6 */
  0x0020,   /* U+48F7 */
  0x0020,   /* U+48F8 */
  0x0020,   /* U+48F9 */
  0x0020,   /* U+48FA */
  0x0020,   /* U+48FB */
  0x0020,   /* U+48FC */
  0x0020,   /* U+48FD */
  0x0020,   /* U+48FE */
  0x0020,   /* U+48FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4800 */
  0x0002,   /* U+4801 */
  0x0002,   /* U+4802 */
  0x0002,   /* U+4803 */
  0x0002,   /* U+4804 */
  0x0002,   /* U+4805 */
  0x0002,   /* U+4806 */
  0x0002,   /* U+4807 */
  0x0002,   /* U+4808 */
  0x0002,   /* U+4809 */
  0x0002,   /* U+480A */
  0x0002,   /* U+480B */
  0x0002,   /* U+480C */
  0x0002,   /* U+480D */
  0x0002,   /* U+480E */
  0x0002,   /* U+480F */
  0x0002,   /* U+4810 */
  0x0002,   /* U+4811 */
  0x0002,   /* U+4812 */
  0x0002,   /* U+4813 */
  0x0002,   /* U+4814 */
  0x0002,   /* U+4815 */
  0x0002,   /* U+4816 */
  0x0002,   /* U+4817 */
  0x0002,   /* U+4818 */
  0x0002,   /* U+4819 */
  0x0002,   /* U+481A */
  0x0002,   /* U+481B */
  0x0002,   /* U+481C */
  0x0002,   /* U+481D */
  0x0002,   /* U+481E */
  0x0002,   /* U+481F */
  0x0002,   /* U+4820 */
  0x0002,   /* U+4821 */
  0x0002,   /* U+4822 */
  0x0002,   /* U+4823 */
  0x0002,   /* U+4824 */
  0x0002,   /* U+4825 */
  0x0002,   /* U+4826 */
  0x0002,   /* U+4827 */
  0x0002,   /* U+4828 */
  0x0002,   /* U+4829 */
  0x0002,   /* U+482A */
  0x0002,   /* U+482B */
  0x0002,   /* U+482C */
  0x0002,   /* U+482D */
  0x0002,   /* U+482E */
  0x0002,   /* U+482F */
  0x0002,   /* U+4830 */
  0x0002,   /* U+4831 */
  0x0002,   /* U+4832 */
  0x0002,   /* U+4833 */
  0x0002,   /* U+4834 */
  0x0002,   /* U+4835 */
  0x0002,   /* U+4836 */
  0x0002,   /* U+4837 */
  0x0002,   /* U+4838 */
  0x0002,   /* U+4839 */
  0x0002,   /* U+483A */
  0x0002,   /* U+483B */
  0x0002,   /* U+483C */
  0x0002,   /* U+483D */
  0x0002,   /* U+483E */
  0x0002,   /* U+483F */
  0x0002,   /* U+4840 */
  0x0002,   /* U+4841 */
  0x0002,   /* U+4842 */
  0x0002,   /* U+4843 */
  0x0002,   /* U+4844 */
  0x0002,   /* U+4845 */
  0x0002,   /* U+4846 */
  0x0002,   /* U+4847 */
  0x0002,   /* U+4848 */
  0x0002,   /* U+4849 */
  0x0002,   /* U+484A */
  0x0002,   /* U+484B */
  0x0002,   /* U+484C */
  0x0002,   /* U+484D */
  0x0002,   /* U+484E */
  0x0002,   /* U+484F */
  0x0002,   /* U+4850 */
  0x0002,   /* U+4851 */
  0x0002,   /* U+4852 */
  0x0002,   /* U+4853 */
  0x0002,   /* U+4854 */
  0x0002,   /* U+4855 */
  0x0002,   /* U+4856 */
  0x0002,   /* U+4857 */
  0x0002,   /* U+4858 */
  0x0002,   /* U+4859 */
  0x0002,   /* U+485A */
  0x0002,   /* U+485B */
  0x0002,   /* U+485C */
  0x0002,   /* U+485D */
  0x0002,   /* U+485E */
  0x0002,   /* U+485F */
  0x0002,   /* U+4860 */
  0x0002,   /* U+4861 */
  0x0002,   /* U+4862 */
  0x0002,   /* U+4863 */
  0x0002,   /* U+4864 */
  0x0002,   /* U+4865 */
  0x0002,   /* U+4866 */
  0x0002,   /* U+4867 */
  0x0002,   /* U+4868 */
  0x0002,   /* U+4869 */
  0x0002,   /* U+486A */
  0x0002,   /* U+486B */
  0x0002,   /* U+486C */
  0x0002,   /* U+486D */
  0x0002,   /* U+486E */
  0x0002,   /* U+486F */
  0x0002,   /* U+4870 */
  0x0002,   /* U+4871 */
  0x0002,   /* U+4872 */
  0x0002,   /* U+4873 */
  0x0002,   /* U+4874 */
  0x0002,   /* U+4875 */
  0x0002,   /* U+4876 */
  0x0002,   /* U+4877 */
  0x0002,   /* U+4878 */
  0x0002,   /* U+4879 */
  0x0002,   /* U+487A */
  0x0002,   /* U+487B */
  0x0002,   /* U+487C */
  0x0002,   /* U+487D */
  0x0002,   /* U+487E */
  0x0002,   /* U+487F */
  0x0002,   /* U+4880 */
  0x0002,   /* U+4881 */
  0x0002,   /* U+4882 */
  0x0002,   /* U+4883 */
  0x0002,   /* U+4884 */
  0x0002,   /* U+4885 */
  0x0002,   /* U+4886 */
  0x0002,   /* U+4887 */
  0x0002,   /* U+4888 */
  0x0002,   /* U+4889 */
  0x0002,   /* U+488A */
  0x0002,   /* U+488B */
  0x0002,   /* U+488C */
  0x0002,   /* U+488D */
  0x0002,   /* U+488E */
  0x0002,   /* U+488F */
  0x0002,   /* U+4890 */
  0x0002,   /* U+4891 */
  0x0002,   /* U+4892 */
  0x0002,   /* U+4893 */
  0x0002,   /* U+4894 */
  0x0002,   /* U+4895 */
  0x0002,   /* U+4896 */
  0x0002,   /* U+4897 */
  0x0002,   /* U+4898 */
  0x0002,   /* U+4899 */
  0x0002,   /* U+489A */
  0x0002,   /* U+489B */
  0x0002,   /* U+489C */
  0x0002,   /* U+489D */
  0x0002,   /* U+489E */
  0x0002,   /* U+489F */
  0x0002,   /* U+48A0 */
  0x0002,   /* U+48A1 */
  0x0002,   /* U+48A2 */
  0x0002,   /* U+48A3 */
  0x0002,   /* U+48A4 */
  0x0002,   /* U+48A5 */
  0x0002,   /* U+48A6 */
  0x0002,   /* U+48A7 */
  0x0002,   /* U+48A8 */
  0x0002,   /* U+48A9 */
  0x0002,   /* U+48AA */
  0x0002,   /* U+48AB */
  0x0002,   /* U+48AC */
  0x0002,   /* U+48AD */
  0x0002,   /* U+48AE */
  0x0002,   /* U+48AF */
  0x0002,   /* U+48B0 */
  0x0002,   /* U+48B1 */
  0x0002,   /* U+48B2 */
  0x0002,   /* U+48B3 */
  0x0002,   /* U+48B4 */
  0x0002,   /* U+48B5 */
  0x0002,   /* U+48B6 */
  0x0002,   /* U+48B7 */
  0x0002,   /* U+48B8 */
  0x0002,   /* U+48B9 */
  0x0002,   /* U+48BA */
  0x0002,   /* U+48BB */
  0x0002,   /* U+48BC */
  0x0002,   /* U+48BD */
  0x0002,   /* U+48BE */
  0x0002,   /* U+48BF */
  0x0002,   /* U+48C0 */
  0x0002,   /* U+48C1 */
  0x0002,   /* U+48C2 */
  0x0002,   /* U+48C3 */
  0x0002,   /* U+48C4 */
  0x0002,   /* U+48C5 */
  0x0002,   /* U+48C6 */
  0x0002,   /* U+48C7 */
  0x0002,   /* U+48C8 */
  0x0002,   /* U+48C9 */
  0x0002,   /* U+48CA */
  0x0002,   /* U+48CB */
  0x0002,   /* U+48CC */
  0x0002,   /* U+48CD */
  0x0002,   /* U+48CE */
  0x0002,   /* U+48CF */
  0x0002,   /* U+48D0 */
  0x0002,   /* U+48D1 */
  0x0002,   /* U+48D2 */
  0x0002,   /* U+48D3 */
  0x0002,   /* U+48D4 */
  0x0002,   /* U+48D5 */
  0x0002,   /* U+48D6 */
  0x0002,   /* U+48D7 */
  0x0002,   /* U+48D8 */
  0x0002,   /* U+48D9 */
  0x0002,   /* U+48DA */
  0x0002,   /* U+48DB */
  0x0002,   /* U+48DC */
  0x0002,   /* U+48DD */
  0x0002,   /* U+48DE */
  0x0002,   /* U+48DF */
  0x0002,   /* U+48E0 */
  0x0002,   /* U+48E1 */
  0x0002,   /* U+48E2 */
  0x0002,   /* U+48E3 */
  0x0002,   /* U+48E4 */
  0x0002,   /* U+48E5 */
  0x0002,   /* U+48E6 */
  0x0002,   /* U+48E7 */
  0x0002,   /* U+48E8 */
  0x0002,   /* U+48E9 */
  0x0002,   /* U+48EA */
  0x0002,   /* U+48EB */
  0x0002,   /* U+48EC */
  0x0002,   /* U+48ED */
  0x0002,   /* U+48EE */
  0x0002,   /* U+48EF */
  0x0002,   /* U+48F0 */
  0x0002,   /* U+48F1 */
  0x0002,   /* U+48F2 */
  0x0002,   /* U+48F3 */
  0x0002,   /* U+48F4 */
  0x0002,   /* U+48F5 */
  0x0002,   /* U+48F6 */
  0x0002,   /* U+48F7 */
  0x0002,   /* U+48F8 */
  0x0002,   /* U+48F9 */
  0x0002,   /* U+48FA */
  0x0002,   /* U+48FB */
  0x0002,   /* U+48FC */
  0x0002,   /* U+48FD */
  0x0002,   /* U+48FE */
  0x0002,   /* U+48FF */

  /* Primary weight 2 for each character. */
  0x960D,   /* U+4800 */
  0x960E,   /* U+4801 */
  0x960F,   /* U+4802 */
  0x9610,   /* U+4803 */
  0x9611,   /* U+4804 */
  0x9612,   /* U+4805 */
  0x9613,   /* U+4806 */
  0x9614,   /* U+4807 */
  0x9615,   /* U+4808 */
  0x9616,   /* U+4809 */
  0x9617,   /* U+480A */
  0x9618,   /* U+480B */
  0x9619,   /* U+480C */
  0x92DF,   /* U+480D */
  0x92E0,   /* U+480E */
  0x92E1,   /* U+480F */
  0x92E2,   /* U+4810 */
  0x92E3,   /* U+4811 */
  0x92E4,   /* U+4812 */
  0x92E5,   /* U+4813 */
  0x92E6,   /* U+4814 */
  0x92E7,   /* U+4815 */
  0x92E8,   /* U+4816 */
  0x8EA2,   /* U+4817 */
  0x8EA3,   /* U+4818 */
  0x8EA4,   /* U+4819 */
  0x8EA5,   /* U+481A */
  0x8EA6,   /* U+481B */
  0x8EA7,   /* U+481C */
  0x8EA8,   /* U+481D */
  0x8C20,   /* U+481E */
  0x8C21,   /* U+481F */
  0x8C22,   /* U+4820 */
  0x8C23,   /* U+4821 */
  0x8C24,   /* U+4822 */
  0x8926,   /* U+4823 */
  0x8927,   /* U+4824 */
  0x8928,   /* U+4825 */
  0x8929,   /* U+4826 */
  0x892A,   /* U+4827 */
  0x8690,   /* U+4828 */
  0x8691,   /* U+4829 */
  0x8538,   /* U+482A */
  0x8539,   /* U+482B */
  0x83D0,   /* U+482C */
  0x82A4,   /* U+482D */
  0x82A5,   /* U+482E */
  0x81F4,   /* U+482F */
  0x8150,   /* U+4830 */
  0x8064,   /* U+4831 */
  0x9B11,   /* U+4832 */
  0x9B12,   /* U+4833 */
  0x9B13,   /* U+4834 */
  0x9B14,   /* U+4835 */
  0x9B15,   /* U+4836 */
  0x993E,   /* U+4837 */
  0x993F,   /* U+4838 */
  0x9940,   /* U+4839 */
  0x9941,   /* U+483A */
  0x966A,   /* U+483B */
  0x934B,   /* U+483C */
  0x8EF0,   /* U+483D */
  0x8EF1,   /* U+483E */
  0x8979,   /* U+483F */
  0x86C9,   /* U+4840 */
  0x82BB,   /* U+4841 */
  0x932F,   /* U+4842 */
  0x9330,   /* U+4843 */
  0x9331,   /* U+4844 */
  0x96E3,   /* U+4845 */
  0x992B,   /* U+4846 */
  0x992C,   /* U+4847 */
  0x992D,   /* U+4848 */
  0x992E,   /* U+4849 */
  0x992F,   /* U+484A */
  0x9930,   /* U+484B */
  0x9931,   /* U+484C */
  0x9932,   /* U+484D */
  0x9933,   /* U+484E */
  0x9B44,   /* U+484F */
  0x9B45,   /* U+4850 */
  0x9B46,   /* U+4851 */
  0x9B47,   /* U+4852 */
  0x996A,   /* U+4853 */
  0x996B,   /* U+4854 */
  0x996C,   /* U+4855 */
  0x996D,   /* U+4856 */
  0x996E,   /* U+4857 */
  0x982E,   /* U+4858 */
  0x982F,   /* U+4859 */
  0x9830,   /* U+485A */
  0x9831,   /* U+485B */
  0x9697,   /* U+485C */
  0x9698,   /* U+485D */
  0x9699,   /* U+485E */
  0x969A,   /* U+485F */
  0x936D,   /* U+4860 */
  0x936E,   /* U+4861 */
  0x936F,   /* U+4862 */
  0x9370,   /* U+4863 */
  0x9371,   /* U+4864 */
  0x8F0E,   /* U+4865 */
  0x8F0F,   /* U+4866 */
  0x8F10,   /* U+4867 */
  0x8F11,   /* U+4868 */
  0x8F12,   /* U+4869 */
  0x8F13,   /* U+486A */
  0x8C96,   /* U+486B */
  0x8C97,   /* U+486C */
  0x8C98,   /* U+486D */
  0x8C99,   /* U+486E */
  0x8C9A,   /* U+486F */
  0x8C9B,   /* U+4870 */
  0x8C9C,   /* U+4871 */
  0x8993,   /* U+4872 */
  0x8994,   /* U+4873 */
  0x8995,   /* U+4874 */
  0x8996,   /* U+4875 */
  0x86D9,   /* U+4876 */
  0x8569,   /* U+4877 */
  0x856A,   /* U+4878 */
  0x856B,   /* U+4879 */
  0x83F5,   /* U+487A */
  0x83F6,   /* U+487B */
  0x8203,   /* U+487C */
  0x80D9,   /* U+487D */
  0x80AD,   /* U+487E */
  0x8015,   /* U+487F */
  0x96F4,   /* U+4880 */
  0x9958,   /* U+4881 */
  0x9344,   /* U+4882 */
  0x96DE,   /* U+4883 */
  0x86F9,   /* U+4884 */
  0x99AB,   /* U+4885 */
  0x9868,   /* U+4886 */
  0x96E6,   /* U+4887 */
  0x86FE,   /* U+4888 */
  0x86FF,   /* U+4889 */
  0x8AC4,   /* U+488A */
  0x8AC5,   /* U+488B */
  0x8F63,   /* U+488C */
  0x8F64,   /* U+488D */
  0x8F65,   /* U+488E */
  0x8F66,   /* U+488F */
  0x9369,   /* U+4890 */
  0x936A,   /* U+4891 */
  0x9722,   /* U+4892 */
  0x9723,   /* U+4893 */
  0x9724,   /* U+4894 */
  0x9725,   /* U+4895 */
  0x9726,   /* U+4896 */
  0x9727,   /* U+4897 */
  0x9728,   /* U+4898 */
  0x9986,   /* U+4899 */
  0x9987,   /* U+489A */
  0x9988,   /* U+489B */
  0x9BA4,   /* U+489C */
  0x9BA5,   /* U+489D */
  0x9BA6,   /* U+489E */
  0x9BA7,   /* U+489F */
  0x9BA8,   /* U+48A0 */
  0x99CC,   /* U+48A1 */
  0x9879,   /* U+48A2 */
  0x987A,   /* U+48A3 */
  0x987B,   /* U+48A4 */
  0x987C,   /* U+48A5 */
  0x96F5,   /* U+48A6 */
  0x96F6,   /* U+48A7 */
  0x96F7,   /* U+48A8 */
  0x96F8,   /* U+48A9 */
  0x93C4,   /* U+48AA */
  0x93C5,   /* U+48AB */
  0x93C6,   /* U+48AC */
  0x93C7,   /* U+48AD */
  0x8F5A,   /* U+48AE */
  0x8CCA,   /* U+48AF */
  0x8CCB,   /* U+48B0 */
  0x89BE,   /* U+48B1 */
  0x820F,   /* U+48B2 */
  0x834E,   /* U+48B3 */
  0x868A,   /* U+48B4 */
  0x8B02,   /* U+48B5 */
  0x8B03,   /* U+48B6 */
  0x8B04,   /* U+48B7 */
  0x8FA9,   /* U+48B8 */
  0x8FAA,   /* U+48B9 */
  0x8FAB,   /* U+48BA */
  0x93A9,   /* U+48BB */
  0x93AA,   /* U+48BC */
  0x9A0A,   /* U+48BD */
  0x93AB,   /* U+48BE */
  0x93AC,   /* U+48BF */
  0x93AD,   /* U+48C0 */
  0x93AE,   /* U+48C1 */
  0x93AF,   /* U+48C2 */
  0x9779,   /* U+48C3 */
  0x977A,   /* U+48C4 */
  0x977B,   /* U+48C5 */
  0x977C,   /* U+48C6 */
  0x977D,   /* U+48C7 */
  0x98CE,   /* U+48C8 */
  0x98CF,   /* U+48C9 */
  0x99EF,   /* U+48CA */
  0x99F0,   /* U+48CB */
  0x99F1,   /* U+48CC */
  0x99F2,   /* U+48CD */
  0x99F3,   /* U+48CE */
  0x99F4,   /* U+48CF */
  0x9C1D,   /* U+48D0 */
  0x9C1E,   /* U+48D1 */
  0x9C1F,   /* U+48D2 */
  0x9A1C,   /* U+48D3 */
  0x9A1D,   /* U+48D4 */
  0x9A1E,   /* U+48D5 */
  0x8F8D,   /* U+48D6 */
  0x9A1F,   /* U+48D7 */
  0x98DF,   /* U+48D8 */
  0x98E0,   /* U+48D9 */
  0x98E1,   /* U+48DA */
  0x98E2,   /* U+48DB */
  0x98E3,   /* U+48DC */
  0x9753,   /* U+48DD */
  0x9754,   /* U+48DE */
  0x9755,   /* U+48DF */
  0x9756,   /* U+48E0 */
  0x9408,   /* U+48E1 */
  0x8F93,   /* U+48E2 */
  0x82D5,   /* U+48E3 */
  0x82D6,   /* U+48E4 */
  0x93DC,   /* U+48E5 */
  0x93DD,   /* U+48E6 */
  0x97B8,   /* U+48E7 */
  0x97B9,   /* U+48E8 */
  0x9A34,   /* U+48E9 */
  0x9A35,   /* U+48EA */
  0x9A36,   /* U+48EB */
  0x9A37,   /* U+48EC */
  0x9A38,   /* U+48ED */
  0x9C4E,   /* U+48EE */
  0x9C4F,   /* U+48EF */
  0x9C50,   /* U+48F0 */
  0x9A4A,   /* U+48F1 */
  0x9C51,   /* U+48F2 */
  0x9C52,   /* U+48F3 */
  0x9A57,   /* U+48F4 */
  0x9A58,   /* U+48F5 */
  0x9A59,   /* U+48F6 */
  0x9A5A,   /* U+48F7 */
  0x9A5B,   /* U+48F8 */
  0x9A5C,   /* U+48F9 */
  0x991F,   /* U+48FA */
  0x9920,   /* U+48FB */
  0x9782,   /* U+48FC */
  0x9783,   /* U+48FD */
  0x9784,   /* U+48FE */
  0x9785,   /* U+48FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4800 */
  0x0000,   /* U+4801 */
  0x0000,   /* U+4802 */
  0x0000,   /* U+4803 */
  0x0000,   /* U+4804 */
  0x0000,   /* U+4805 */
  0x0000,   /* U+4806 */
  0x0000,   /* U+4807 */
  0x0000,   /* U+4808 */
  0x0000,   /* U+4809 */
  0x0000,   /* U+480A */
  0x0000,   /* U+480B */
  0x0000,   /* U+480C */
  0x0000,   /* U+480D */
  0x0000,   /* U+480E */
  0x0000,   /* U+480F */
  0x0000,   /* U+4810 */
  0x0000,   /* U+4811 */
  0x0000,   /* U+4812 */
  0x0000,   /* U+4813 */
  0x0000,   /* U+4814 */
  0x0000,   /* U+4815 */
  0x0000,   /* U+4816 */
  0x0000,   /* U+4817 */
  0x0000,   /* U+4818 */
  0x0000,   /* U+4819 */
  0x0000,   /* U+481A */
  0x0000,   /* U+481B */
  0x0000,   /* U+481C */
  0x0000,   /* U+481D */
  0x0000,   /* U+481E */
  0x0000,   /* U+481F */
  0x0000,   /* U+4820 */
  0x0000,   /* U+4821 */
  0x0000,   /* U+4822 */
  0x0000,   /* U+4823 */
  0x0000,   /* U+4824 */
  0x0000,   /* U+4825 */
  0x0000,   /* U+4826 */
  0x0000,   /* U+4827 */
  0x0000,   /* U+4828 */
  0x0000,   /* U+4829 */
  0x0000,   /* U+482A */
  0x0000,   /* U+482B */
  0x0000,   /* U+482C */
  0x0000,   /* U+482D */
  0x0000,   /* U+482E */
  0x0000,   /* U+482F */
  0x0000,   /* U+4830 */
  0x0000,   /* U+4831 */
  0x0000,   /* U+4832 */
  0x0000,   /* U+4833 */
  0x0000,   /* U+4834 */
  0x0000,   /* U+4835 */
  0x0000,   /* U+4836 */
  0x0000,   /* U+4837 */
  0x0000,   /* U+4838 */
  0x0000,   /* U+4839 */
  0x0000,   /* U+483A */
  0x0000,   /* U+483B */
  0x0000,   /* U+483C */
  0x0000,   /* U+483D */
  0x0000,   /* U+483E */
  0x0000,   /* U+483F */
  0x0000,   /* U+4840 */
  0x0000,   /* U+4841 */
  0x0000,   /* U+4842 */
  0x0000,   /* U+4843 */
  0x0000,   /* U+4844 */
  0x0000,   /* U+4845 */
  0x0000,   /* U+4846 */
  0x0000,   /* U+4847 */
  0x0000,   /* U+4848 */
  0x0000,   /* U+4849 */
  0x0000,   /* U+484A */
  0x0000,   /* U+484B */
  0x0000,   /* U+484C */
  0x0000,   /* U+484D */
  0x0000,   /* U+484E */
  0x0000,   /* U+484F */
  0x0000,   /* U+4850 */
  0x0000,   /* U+4851 */
  0x0000,   /* U+4852 */
  0x0000,   /* U+4853 */
  0x0000,   /* U+4854 */
  0x0000,   /* U+4855 */
  0x0000,   /* U+4856 */
  0x0000,   /* U+4857 */
  0x0000,   /* U+4858 */
  0x0000,   /* U+4859 */
  0x0000,   /* U+485A */
  0x0000,   /* U+485B */
  0x0000,   /* U+485C */
  0x0000,   /* U+485D */
  0x0000,   /* U+485E */
  0x0000,   /* U+485F */
  0x0000,   /* U+4860 */
  0x0000,   /* U+4861 */
  0x0000,   /* U+4862 */
  0x0000,   /* U+4863 */
  0x0000,   /* U+4864 */
  0x0000,   /* U+4865 */
  0x0000,   /* U+4866 */
  0x0000,   /* U+4867 */
  0x0000,   /* U+4868 */
  0x0000,   /* U+4869 */
  0x0000,   /* U+486A */
  0x0000,   /* U+486B */
  0x0000,   /* U+486C */
  0x0000,   /* U+486D */
  0x0000,   /* U+486E */
  0x0000,   /* U+486F */
  0x0000,   /* U+4870 */
  0x0000,   /* U+4871 */
  0x0000,   /* U+4872 */
  0x0000,   /* U+4873 */
  0x0000,   /* U+4874 */
  0x0000,   /* U+4875 */
  0x0000,   /* U+4876 */
  0x0000,   /* U+4877 */
  0x0000,   /* U+4878 */
  0x0000,   /* U+4879 */
  0x0000,   /* U+487A */
  0x0000,   /* U+487B */
  0x0000,   /* U+487C */
  0x0000,   /* U+487D */
  0x0000,   /* U+487E */
  0x0000,   /* U+487F */
  0x0000,   /* U+4880 */
  0x0000,   /* U+4881 */
  0x0000,   /* U+4882 */
  0x0000,   /* U+4883 */
  0x0000,   /* U+4884 */
  0x0000,   /* U+4885 */
  0x0000,   /* U+4886 */
  0x0000,   /* U+4887 */
  0x0000,   /* U+4888 */
  0x0000,   /* U+4889 */
  0x0000,   /* U+488A */
  0x0000,   /* U+488B */
  0x0000,   /* U+488C */
  0x0000,   /* U+488D */
  0x0000,   /* U+488E */
  0x0000,   /* U+488F */
  0x0000,   /* U+4890 */
  0x0000,   /* U+4891 */
  0x0000,   /* U+4892 */
  0x0000,   /* U+4893 */
  0x0000,   /* U+4894 */
  0x0000,   /* U+4895 */
  0x0000,   /* U+4896 */
  0x0000,   /* U+4897 */
  0x0000,   /* U+4898 */
  0x0000,   /* U+4899 */
  0x0000,   /* U+489A */
  0x0000,   /* U+489B */
  0x0000,   /* U+489C */
  0x0000,   /* U+489D */
  0x0000,   /* U+489E */
  0x0000,   /* U+489F */
  0x0000,   /* U+48A0 */
  0x0000,   /* U+48A1 */
  0x0000,   /* U+48A2 */
  0x0000,   /* U+48A3 */
  0x0000,   /* U+48A4 */
  0x0000,   /* U+48A5 */
  0x0000,   /* U+48A6 */
  0x0000,   /* U+48A7 */
  0x0000,   /* U+48A8 */
  0x0000,   /* U+48A9 */
  0x0000,   /* U+48AA */
  0x0000,   /* U+48AB */
  0x0000,   /* U+48AC */
  0x0000,   /* U+48AD */
  0x0000,   /* U+48AE */
  0x0000,   /* U+48AF */
  0x0000,   /* U+48B0 */
  0x0000,   /* U+48B1 */
  0x0000,   /* U+48B2 */
  0x0000,   /* U+48B3 */
  0x0000,   /* U+48B4 */
  0x0000,   /* U+48B5 */
  0x0000,   /* U+48B6 */
  0x0000,   /* U+48B7 */
  0x0000,   /* U+48B8 */
  0x0000,   /* U+48B9 */
  0x0000,   /* U+48BA */
  0x0000,   /* U+48BB */
  0x0000,   /* U+48BC */
  0x0000,   /* U+48BD */
  0x0000,   /* U+48BE */
  0x0000,   /* U+48BF */
  0x0000,   /* U+48C0 */
  0x0000,   /* U+48C1 */
  0x0000,   /* U+48C2 */
  0x0000,   /* U+48C3 */
  0x0000,   /* U+48C4 */
  0x0000,   /* U+48C5 */
  0x0000,   /* U+48C6 */
  0x0000,   /* U+48C7 */
  0x0000,   /* U+48C8 */
  0x0000,   /* U+48C9 */
  0x0000,   /* U+48CA */
  0x0000,   /* U+48CB */
  0x0000,   /* U+48CC */
  0x0000,   /* U+48CD */
  0x0000,   /* U+48CE */
  0x0000,   /* U+48CF */
  0x0000,   /* U+48D0 */
  0x0000,   /* U+48D1 */
  0x0000,   /* U+48D2 */
  0x0000,   /* U+48D3 */
  0x0000,   /* U+48D4 */
  0x0000,   /* U+48D5 */
  0x0000,   /* U+48D6 */
  0x0000,   /* U+48D7 */
  0x0000,   /* U+48D8 */
  0x0000,   /* U+48D9 */
  0x0000,   /* U+48DA */
  0x0000,   /* U+48DB */
  0x0000,   /* U+48DC */
  0x0000,   /* U+48DD */
  0x0000,   /* U+48DE */
  0x0000,   /* U+48DF */
  0x0000,   /* U+48E0 */
  0x0000,   /* U+48E1 */
  0x0000,   /* U+48E2 */
  0x0000,   /* U+48E3 */
  0x0000,   /* U+48E4 */
  0x0000,   /* U+48E5 */
  0x0000,   /* U+48E6 */
  0x0000,   /* U+48E7 */
  0x0000,   /* U+48E8 */
  0x0000,   /* U+48E9 */
  0x0000,   /* U+48EA */
  0x0000,   /* U+48EB */
  0x0000,   /* U+48EC */
  0x0000,   /* U+48ED */
  0x0000,   /* U+48EE */
  0x0000,   /* U+48EF */
  0x0000,   /* U+48F0 */
  0x0000,   /* U+48F1 */
  0x0000,   /* U+48F2 */
  0x0000,   /* U+48F3 */
  0x0000,   /* U+48F4 */
  0x0000,   /* U+48F5 */
  0x0000,   /* U+48F6 */
  0x0000,   /* U+48F7 */
  0x0000,   /* U+48F8 */
  0x0000,   /* U+48F9 */
  0x0000,   /* U+48FA */
  0x0000,   /* U+48FB */
  0x0000,   /* U+48FC */
  0x0000,   /* U+48FD */
  0x0000,   /* U+48FE */
  0x0000,   /* U+48FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4800 */
  0x0000,   /* U+4801 */
  0x0000,   /* U+4802 */
  0x0000,   /* U+4803 */
  0x0000,   /* U+4804 */
  0x0000,   /* U+4805 */
  0x0000,   /* U+4806 */
  0x0000,   /* U+4807 */
  0x0000,   /* U+4808 */
  0x0000,   /* U+4809 */
  0x0000,   /* U+480A */
  0x0000,   /* U+480B */
  0x0000,   /* U+480C */
  0x0000,   /* U+480D */
  0x0000,   /* U+480E */
  0x0000,   /* U+480F */
  0x0000,   /* U+4810 */
  0x0000,   /* U+4811 */
  0x0000,   /* U+4812 */
  0x0000,   /* U+4813 */
  0x0000,   /* U+4814 */
  0x0000,   /* U+4815 */
  0x0000,   /* U+4816 */
  0x0000,   /* U+4817 */
  0x0000,   /* U+4818 */
  0x0000,   /* U+4819 */
  0x0000,   /* U+481A */
  0x0000,   /* U+481B */
  0x0000,   /* U+481C */
  0x0000,   /* U+481D */
  0x0000,   /* U+481E */
  0x0000,   /* U+481F */
  0x0000,   /* U+4820 */
  0x0000,   /* U+4821 */
  0x0000,   /* U+4822 */
  0x0000,   /* U+4823 */
  0x0000,   /* U+4824 */
  0x0000,   /* U+4825 */
  0x0000,   /* U+4826 */
  0x0000,   /* U+4827 */
  0x0000,   /* U+4828 */
  0x0000,   /* U+4829 */
  0x0000,   /* U+482A */
  0x0000,   /* U+482B */
  0x0000,   /* U+482C */
  0x0000,   /* U+482D */
  0x0000,   /* U+482E */
  0x0000,   /* U+482F */
  0x0000,   /* U+4830 */
  0x0000,   /* U+4831 */
  0x0000,   /* U+4832 */
  0x0000,   /* U+4833 */
  0x0000,   /* U+4834 */
  0x0000,   /* U+4835 */
  0x0000,   /* U+4836 */
  0x0000,   /* U+4837 */
  0x0000,   /* U+4838 */
  0x0000,   /* U+4839 */
  0x0000,   /* U+483A */
  0x0000,   /* U+483B */
  0x0000,   /* U+483C */
  0x0000,   /* U+483D */
  0x0000,   /* U+483E */
  0x0000,   /* U+483F */
  0x0000,   /* U+4840 */
  0x0000,   /* U+4841 */
  0x0000,   /* U+4842 */
  0x0000,   /* U+4843 */
  0x0000,   /* U+4844 */
  0x0000,   /* U+4845 */
  0x0000,   /* U+4846 */
  0x0000,   /* U+4847 */
  0x0000,   /* U+4848 */
  0x0000,   /* U+4849 */
  0x0000,   /* U+484A */
  0x0000,   /* U+484B */
  0x0000,   /* U+484C */
  0x0000,   /* U+484D */
  0x0000,   /* U+484E */
  0x0000,   /* U+484F */
  0x0000,   /* U+4850 */
  0x0000,   /* U+4851 */
  0x0000,   /* U+4852 */
  0x0000,   /* U+4853 */
  0x0000,   /* U+4854 */
  0x0000,   /* U+4855 */
  0x0000,   /* U+4856 */
  0x0000,   /* U+4857 */
  0x0000,   /* U+4858 */
  0x0000,   /* U+4859 */
  0x0000,   /* U+485A */
  0x0000,   /* U+485B */
  0x0000,   /* U+485C */
  0x0000,   /* U+485D */
  0x0000,   /* U+485E */
  0x0000,   /* U+485F */
  0x0000,   /* U+4860 */
  0x0000,   /* U+4861 */
  0x0000,   /* U+4862 */
  0x0000,   /* U+4863 */
  0x0000,   /* U+4864 */
  0x0000,   /* U+4865 */
  0x0000,   /* U+4866 */
  0x0000,   /* U+4867 */
  0x0000,   /* U+4868 */
  0x0000,   /* U+4869 */
  0x0000,   /* U+486A */
  0x0000,   /* U+486B */
  0x0000,   /* U+486C */
  0x0000,   /* U+486D */
  0x0000,   /* U+486E */
  0x0000,   /* U+486F */
  0x0000,   /* U+4870 */
  0x0000,   /* U+4871 */
  0x0000,   /* U+4872 */
  0x0000,   /* U+4873 */
  0x0000,   /* U+4874 */
  0x0000,   /* U+4875 */
  0x0000,   /* U+4876 */
  0x0000,   /* U+4877 */
  0x0000,   /* U+4878 */
  0x0000,   /* U+4879 */
  0x0000,   /* U+487A */
  0x0000,   /* U+487B */
  0x0000,   /* U+487C */
  0x0000,   /* U+487D */
  0x0000,   /* U+487E */
  0x0000,   /* U+487F */
  0x0000,   /* U+4880 */
  0x0000,   /* U+4881 */
  0x0000,   /* U+4882 */
  0x0000,   /* U+4883 */
  0x0000,   /* U+4884 */
  0x0000,   /* U+4885 */
  0x0000,   /* U+4886 */
  0x0000,   /* U+4887 */
  0x0000,   /* U+4888 */
  0x0000,   /* U+4889 */
  0x0000,   /* U+488A */
  0x0000,   /* U+488B */
  0x0000,   /* U+488C */
  0x0000,   /* U+488D */
  0x0000,   /* U+488E */
  0x0000,   /* U+488F */
  0x0000,   /* U+4890 */
  0x0000,   /* U+4891 */
  0x0000,   /* U+4892 */
  0x0000,   /* U+4893 */
  0x0000,   /* U+4894 */
  0x0000,   /* U+4895 */
  0x0000,   /* U+4896 */
  0x0000,   /* U+4897 */
  0x0000,   /* U+4898 */
  0x0000,   /* U+4899 */
  0x0000,   /* U+489A */
  0x0000,   /* U+489B */
  0x0000,   /* U+489C */
  0x0000,   /* U+489D */
  0x0000,   /* U+489E */
  0x0000,   /* U+489F */
  0x0000,   /* U+48A0 */
  0x0000,   /* U+48A1 */
  0x0000,   /* U+48A2 */
  0x0000,   /* U+48A3 */
  0x0000,   /* U+48A4 */
  0x0000,   /* U+48A5 */
  0x0000,   /* U+48A6 */
  0x0000,   /* U+48A7 */
  0x0000,   /* U+48A8 */
  0x0000,   /* U+48A9 */
  0x0000,   /* U+48AA */
  0x0000,   /* U+48AB */
  0x0000,   /* U+48AC */
  0x0000,   /* U+48AD */
  0x0000,   /* U+48AE */
  0x0000,   /* U+48AF */
  0x0000,   /* U+48B0 */
  0x0000,   /* U+48B1 */
  0x0000,   /* U+48B2 */
  0x0000,   /* U+48B3 */
  0x0000,   /* U+48B4 */
  0x0000,   /* U+48B5 */
  0x0000,   /* U+48B6 */
  0x0000,   /* U+48B7 */
  0x0000,   /* U+48B8 */
  0x0000,   /* U+48B9 */
  0x0000,   /* U+48BA */
  0x0000,   /* U+48BB */
  0x0000,   /* U+48BC */
  0x0000,   /* U+48BD */
  0x0000,   /* U+48BE */
  0x0000,   /* U+48BF */
  0x0000,   /* U+48C0 */
  0x0000,   /* U+48C1 */
  0x0000,   /* U+48C2 */
  0x0000,   /* U+48C3 */
  0x0000,   /* U+48C4 */
  0x0000,   /* U+48C5 */
  0x0000,   /* U+48C6 */
  0x0000,   /* U+48C7 */
  0x0000,   /* U+48C8 */
  0x0000,   /* U+48C9 */
  0x0000,   /* U+48CA */
  0x0000,   /* U+48CB */
  0x0000,   /* U+48CC */
  0x0000,   /* U+48CD */
  0x0000,   /* U+48CE */
  0x0000,   /* U+48CF */
  0x0000,   /* U+48D0 */
  0x0000,   /* U+48D1 */
  0x0000,   /* U+48D2 */
  0x0000,   /* U+48D3 */
  0x0000,   /* U+48D4 */
  0x0000,   /* U+48D5 */
  0x0000,   /* U+48D6 */
  0x0000,   /* U+48D7 */
  0x0000,   /* U+48D8 */
  0x0000,   /* U+48D9 */
  0x0000,   /* U+48DA */
  0x0000,   /* U+48DB */
  0x0000,   /* U+48DC */
  0x0000,   /* U+48DD */
  0x0000,   /* U+48DE */
  0x0000,   /* U+48DF */
  0x0000,   /* U+48E0 */
  0x0000,   /* U+48E1 */
  0x0000,   /* U+48E2 */
  0x0000,   /* U+48E3 */
  0x0000,   /* U+48E4 */
  0x0000,   /* U+48E5 */
  0x0000,   /* U+48E6 */
  0x0000,   /* U+48E7 */
  0x0000,   /* U+48E8 */
  0x0000,   /* U+48E9 */
  0x0000,   /* U+48EA */
  0x0000,   /* U+48EB */
  0x0000,   /* U+48EC */
  0x0000,   /* U+48ED */
  0x0000,   /* U+48EE */
  0x0000,   /* U+48EF */
  0x0000,   /* U+48F0 */
  0x0000,   /* U+48F1 */
  0x0000,   /* U+48F2 */
  0x0000,   /* U+48F3 */
  0x0000,   /* U+48F4 */
  0x0000,   /* U+48F5 */
  0x0000,   /* U+48F6 */
  0x0000,   /* U+48F7 */
  0x0000,   /* U+48F8 */
  0x0000,   /* U+48F9 */
  0x0000,   /* U+48FA */
  0x0000,   /* U+48FB */
  0x0000,   /* U+48FC */
  0x0000,   /* U+48FD */
  0x0000,   /* U+48FE */
  0x0000,   /* U+48FF */
};

uint16 zh3_han_p049[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C57,   /* U+4900 */
  0x1C57,   /* U+4901 */
  0x1C57,   /* U+4902 */
  0x1C57,   /* U+4903 */
  0x1C57,   /* U+4904 */
  0x1C57,   /* U+4905 */
  0x1C57,   /* U+4906 */
  0x1C57,   /* U+4907 */
  0x1C57,   /* U+4908 */
  0x1C58,   /* U+4909 */
  0x1C58,   /* U+490A */
  0x1C58,   /* U+490B */
  0x1C58,   /* U+490C */
  0x1C59,   /* U+490D */
  0x1C5A,   /* U+490E */
  0x1C5A,   /* U+490F */
  0x1C5A,   /* U+4910 */
  0x1C5A,   /* U+4911 */
  0x1C5A,   /* U+4912 */
  0x1C5C,   /* U+4913 */
  0x1C5C,   /* U+4914 */
  0x1C5D,   /* U+4915 */
  0x1C5D,   /* U+4916 */
  0x1C5F,   /* U+4917 */
  0x1C5F,   /* U+4918 */
  0x1C63,   /* U+4919 */
  0x1C52,   /* U+491A */
  0x1C51,   /* U+491B */
  0x1C52,   /* U+491C */
  0x1C53,   /* U+491D */
  0x1C53,   /* U+491E */
  0x1C53,   /* U+491F */
  0x1C53,   /* U+4920 */
  0x1C54,   /* U+4921 */
  0x1C54,   /* U+4922 */
  0x1C54,   /* U+4923 */
  0x1C55,   /* U+4924 */
  0x1C55,   /* U+4925 */
  0x1C55,   /* U+4926 */
  0x1C55,   /* U+4927 */
  0x1C55,   /* U+4928 */
  0x1C55,   /* U+4929 */
  0x1C55,   /* U+492A */
  0x1C56,   /* U+492B */
  0x1C56,   /* U+492C */
  0x1C56,   /* U+492D */
  0x1C56,   /* U+492E */
  0x1C56,   /* U+492F */
  0x1C56,   /* U+4930 */
  0x1C56,   /* U+4931 */
  0x1C56,   /* U+4932 */
  0x1C57,   /* U+4933 */
  0x1C57,   /* U+4934 */
  0x1C57,   /* U+4935 */
  0x1C57,   /* U+4936 */
  0x1C58,   /* U+4937 */
  0x1C58,   /* U+4938 */
  0x1C58,   /* U+4939 */
  0x1C58,   /* U+493A */
  0x1C58,   /* U+493B */
  0x1C58,   /* U+493C */
  0x1C59,   /* U+493D */
  0x1C59,   /* U+493E */
  0x1C59,   /* U+493F */
  0x1C59,   /* U+4940 */
  0x1C59,   /* U+4941 */
  0x1C59,   /* U+4942 */
  0x1C59,   /* U+4943 */
  0x1C59,   /* U+4944 */
  0x1C59,   /* U+4945 */
  0x1C59,   /* U+4946 */
  0x1C59,   /* U+4947 */
  0x1C5A,   /* U+4948 */
  0x1C5A,   /* U+4949 */
  0x1C5A,   /* U+494A */
  0x1C5A,   /* U+494B */
  0x1C5A,   /* U+494C */
  0x1C5A,   /* U+494D */
  0x1C5A,   /* U+494E */
  0x1C5A,   /* U+494F */
  0x1C5A,   /* U+4950 */
  0x1C5A,   /* U+4951 */
  0x1C5A,   /* U+4952 */
  0x1C5A,   /* U+4953 */
  0x1C5B,   /* U+4954 */
  0x1C5B,   /* U+4955 */
  0x1C5B,   /* U+4956 */
  0x1C5B,   /* U+4957 */
  0x1C5B,   /* U+4958 */
  0x1C5B,   /* U+4959 */
  0x1C5B,   /* U+495A */
  0x1C5B,   /* U+495B */
  0x1C5B,   /* U+495C */
  0x1C5C,   /* U+495D */
  0x1C5C,   /* U+495E */
  0x1C5C,   /* U+495F */
  0x1C5C,   /* U+4960 */
  0x1C5C,   /* U+4961 */
  0x1C5C,   /* U+4962 */
  0x1C5C,   /* U+4963 */
  0x1C5C,   /* U+4964 */
  0x1C5C,   /* U+4965 */
  0x1C5C,   /* U+4966 */
  0x1C5D,   /* U+4967 */
  0x1C5D,   /* U+4968 */
  0x1C5D,   /* U+4969 */
  0x1C5D,   /* U+496A */
  0x1C5D,   /* U+496B */
  0x1C5D,   /* U+496C */
  0x1C5D,   /* U+496D */
  0x1C5D,   /* U+496E */
  0x1C5E,   /* U+496F */
  0x1C5E,   /* U+4970 */
  0x1C5E,   /* U+4971 */
  0x1C5E,   /* U+4972 */
  0x1C5E,   /* U+4973 */
  0x1C5E,   /* U+4974 */
  0x1C5F,   /* U+4975 */
  0x1C5F,   /* U+4976 */
  0x1C5F,   /* U+4977 */
  0x1C60,   /* U+4978 */
  0x1C64,   /* U+4979 */
  0x1C53,   /* U+497A */
  0x1C53,   /* U+497B */
  0x1C53,   /* U+497C */
  0x1C54,   /* U+497D */
  0x1C54,   /* U+497E */
  0x1C54,   /* U+497F */
  0x1C55,   /* U+4980 */
  0x1C56,   /* U+4981 */
  0x1C59,   /* U+4982 */
  0x1C5B,   /* U+4983 */
  0x1C5B,   /* U+4984 */
  0x1C5B,   /* U+4985 */
  0x1C63,   /* U+4986 */
  0x1C52,   /* U+4987 */
  0x1C54,   /* U+4988 */
  0x1C54,   /* U+4989 */
  0x1C55,   /* U+498A */
  0x1C5A,   /* U+498B */
  0x1C52,   /* U+498C */
  0x1C52,   /* U+498D */
  0x1C53,   /* U+498E */
  0x1C53,   /* U+498F */
  0x1C53,   /* U+4990 */
  0x1C53,   /* U+4991 */
  0x1C54,   /* U+4992 */
  0x1C54,   /* U+4993 */
  0x1C54,   /* U+4994 */
  0x1C55,   /* U+4995 */
  0x1C55,   /* U+4996 */
  0x1C55,   /* U+4997 */
  0x1C55,   /* U+4998 */
  0x1C55,   /* U+4999 */
  0x1C55,   /* U+499A */
  0x1C55,   /* U+499B */
  0x1C56,   /* U+499C */
  0x1C56,   /* U+499D */
  0x1C56,   /* U+499E */
  0x1C56,   /* U+499F */
  0x1C57,   /* U+49A0 */
  0x1C57,   /* U+49A1 */
  0x1C57,   /* U+49A2 */
  0x1C57,   /* U+49A3 */
  0x1C57,   /* U+49A4 */
  0x1C57,   /* U+49A5 */
  0x1C57,   /* U+49A6 */
  0x1C57,   /* U+49A7 */
  0x1C57,   /* U+49A8 */
  0x1C58,   /* U+49A9 */
  0x1C58,   /* U+49AA */
  0x1C58,   /* U+49AB */
  0x1C58,   /* U+49AC */
  0x1C58,   /* U+49AD */
  0x1C58,   /* U+49AE */
  0x1C58,   /* U+49AF */
  0x1C5A,   /* U+49B0 */
  0x1C5B,   /* U+49B1 */
  0x1C5C,   /* U+49B2 */
  0x1C5C,   /* U+49B3 */
  0x1C5C,   /* U+49B4 */
  0x1C5D,   /* U+49B5 */
  0x1C55,   /* U+49B6 */
  0x1C56,   /* U+49B7 */
  0x1C58,   /* U+49B8 */
  0x1C4C,   /* U+49B9 */
  0x1C4C,   /* U+49BA */
  0x1C4D,   /* U+49BB */
  0x1C4E,   /* U+49BC */
  0x1C4E,   /* U+49BD */
  0x1C51,   /* U+49BE */
  0x1C4E,   /* U+49BF */
  0x1C4E,   /* U+49C0 */
  0x1C4F,   /* U+49C1 */
  0x1C4F,   /* U+49C2 */
  0x1C4F,   /* U+49C3 */
  0x1C50,   /* U+49C4 */
  0x1C50,   /* U+49C5 */
  0x1C50,   /* U+49C6 */
  0x1C50,   /* U+49C7 */
  0x1C50,   /* U+49C8 */
  0x1C51,   /* U+49C9 */
  0x1C51,   /* U+49CA */
  0x1C51,   /* U+49CB */
  0x1C51,   /* U+49CC */
  0x1C51,   /* U+49CD */
  0x1C51,   /* U+49CE */
  0x1C51,   /* U+49CF */
  0x1C52,   /* U+49D0 */
  0x1C52,   /* U+49D1 */
  0x1C52,   /* U+49D2 */
  0x1C52,   /* U+49D3 */
  0x1C52,   /* U+49D4 */
  0x1C52,   /* U+49D5 */
  0x1C52,   /* U+49D6 */
  0x1C53,   /* U+49D7 */
  0x1C53,   /* U+49D8 */
  0x1C53,   /* U+49D9 */
  0x1C54,   /* U+49DA */
  0x1C54,   /* U+49DB */
  0x1C54,   /* U+49DC */
  0x1C54,   /* U+49DD */
  0x1C54,   /* U+49DE */
  0x1C54,   /* U+49DF */
  0x1C55,   /* U+49E0 */
  0x1C55,   /* U+49E1 */
  0x1C55,   /* U+49E2 */
  0x1C55,   /* U+49E3 */
  0x1C56,   /* U+49E4 */
  0x1C56,   /* U+49E5 */
  0x1C56,   /* U+49E6 */
  0x1C57,   /* U+49E7 */
  0x1C57,   /* U+49E8 */
  0x1C56,   /* U+49E9 */
  0x1C57,   /* U+49EA */
  0x1C58,   /* U+49EB */
  0x1C58,   /* U+49EC */
  0x1C58,   /* U+49ED */
  0x1C5A,   /* U+49EE */
  0x1C5B,   /* U+49EF */
  0x1C5C,   /* U+49F0 */
  0x1C51,   /* U+49F1 */
  0x1C52,   /* U+49F2 */
  0x1C52,   /* U+49F3 */
  0x1C53,   /* U+49F4 */
  0x1C53,   /* U+49F5 */
  0x1C53,   /* U+49F6 */
  0x1C54,   /* U+49F7 */
  0x1C54,   /* U+49F8 */
  0x1C54,   /* U+49F9 */
  0x1C54,   /* U+49FA */
  0x1C55,   /* U+49FB */
  0x1C56,   /* U+49FC */
  0x1C56,   /* U+49FD */
  0x1C57,   /* U+49FE */
  0x1C57,   /* U+49FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4900 */
  0x0020,   /* U+4901 */
  0x0020,   /* U+4902 */
  0x0020,   /* U+4903 */
  0x0020,   /* U+4904 */
  0x0020,   /* U+4905 */
  0x0020,   /* U+4906 */
  0x0020,   /* U+4907 */
  0x0020,   /* U+4908 */
  0x0020,   /* U+4909 */
  0x0020,   /* U+490A */
  0x0020,   /* U+490B */
  0x0020,   /* U+490C */
  0x0020,   /* U+490D */
  0x0020,   /* U+490E */
  0x0020,   /* U+490F */
  0x0020,   /* U+4910 */
  0x0020,   /* U+4911 */
  0x0020,   /* U+4912 */
  0x0020,   /* U+4913 */
  0x0020,   /* U+4914 */
  0x0020,   /* U+4915 */
  0x0020,   /* U+4916 */
  0x0020,   /* U+4917 */
  0x0020,   /* U+4918 */
  0x0020,   /* U+4919 */
  0x0020,   /* U+491A */
  0x0020,   /* U+491B */
  0x0020,   /* U+491C */
  0x0020,   /* U+491D */
  0x0020,   /* U+491E */
  0x0020,   /* U+491F */
  0x0020,   /* U+4920 */
  0x0020,   /* U+4921 */
  0x0020,   /* U+4922 */
  0x0020,   /* U+4923 */
  0x0020,   /* U+4924 */
  0x0020,   /* U+4925 */
  0x0020,   /* U+4926 */
  0x0020,   /* U+4927 */
  0x0020,   /* U+4928 */
  0x0020,   /* U+4929 */
  0x0020,   /* U+492A */
  0x0020,   /* U+492B */
  0x0020,   /* U+492C */
  0x0020,   /* U+492D */
  0x0020,   /* U+492E */
  0x0020,   /* U+492F */
  0x0020,   /* U+4930 */
  0x0020,   /* U+4931 */
  0x0020,   /* U+4932 */
  0x0020,   /* U+4933 */
  0x0020,   /* U+4934 */
  0x0020,   /* U+4935 */
  0x0020,   /* U+4936 */
  0x0020,   /* U+4937 */
  0x0020,   /* U+4938 */
  0x0020,   /* U+4939 */
  0x0020,   /* U+493A */
  0x0020,   /* U+493B */
  0x0020,   /* U+493C */
  0x0020,   /* U+493D */
  0x0020,   /* U+493E */
  0x0020,   /* U+493F */
  0x0020,   /* U+4940 */
  0x0020,   /* U+4941 */
  0x0020,   /* U+4942 */
  0x0020,   /* U+4943 */
  0x0020,   /* U+4944 */
  0x0020,   /* U+4945 */
  0x0020,   /* U+4946 */
  0x0020,   /* U+4947 */
  0x0020,   /* U+4948 */
  0x0020,   /* U+4949 */
  0x0020,   /* U+494A */
  0x0020,   /* U+494B */
  0x0020,   /* U+494C */
  0x0020,   /* U+494D */
  0x0020,   /* U+494E */
  0x0020,   /* U+494F */
  0x0020,   /* U+4950 */
  0x0020,   /* U+4951 */
  0x0020,   /* U+4952 */
  0x0020,   /* U+4953 */
  0x0020,   /* U+4954 */
  0x0020,   /* U+4955 */
  0x0020,   /* U+4956 */
  0x0020,   /* U+4957 */
  0x0020,   /* U+4958 */
  0x0020,   /* U+4959 */
  0x0020,   /* U+495A */
  0x0020,   /* U+495B */
  0x0020,   /* U+495C */
  0x0020,   /* U+495D */
  0x0020,   /* U+495E */
  0x0020,   /* U+495F */
  0x0020,   /* U+4960 */
  0x0020,   /* U+4961 */
  0x0020,   /* U+4962 */
  0x0020,   /* U+4963 */
  0x0020,   /* U+4964 */
  0x0020,   /* U+4965 */
  0x0020,   /* U+4966 */
  0x0020,   /* U+4967 */
  0x0020,   /* U+4968 */
  0x0020,   /* U+4969 */
  0x0020,   /* U+496A */
  0x0020,   /* U+496B */
  0x0020,   /* U+496C */
  0x0020,   /* U+496D */
  0x0020,   /* U+496E */
  0x0020,   /* U+496F */
  0x0020,   /* U+4970 */
  0x0020,   /* U+4971 */
  0x0020,   /* U+4972 */
  0x0020,   /* U+4973 */
  0x0020,   /* U+4974 */
  0x0020,   /* U+4975 */
  0x0020,   /* U+4976 */
  0x0020,   /* U+4977 */
  0x0020,   /* U+4978 */
  0x0020,   /* U+4979 */
  0x0020,   /* U+497A */
  0x0020,   /* U+497B */
  0x0020,   /* U+497C */
  0x0020,   /* U+497D */
  0x0020,   /* U+497E */
  0x0020,   /* U+497F */
  0x0020,   /* U+4980 */
  0x0020,   /* U+4981 */
  0x0020,   /* U+4982 */
  0x0020,   /* U+4983 */
  0x0020,   /* U+4984 */
  0x0020,   /* U+4985 */
  0x0020,   /* U+4986 */
  0x0020,   /* U+4987 */
  0x0020,   /* U+4988 */
  0x0020,   /* U+4989 */
  0x0020,   /* U+498A */
  0x0020,   /* U+498B */
  0x0020,   /* U+498C */
  0x0020,   /* U+498D */
  0x0020,   /* U+498E */
  0x0020,   /* U+498F */
  0x0020,   /* U+4990 */
  0x0020,   /* U+4991 */
  0x0020,   /* U+4992 */
  0x0020,   /* U+4993 */
  0x0020,   /* U+4994 */
  0x0020,   /* U+4995 */
  0x0020,   /* U+4996 */
  0x0020,   /* U+4997 */
  0x0020,   /* U+4998 */
  0x0020,   /* U+4999 */
  0x0020,   /* U+499A */
  0x0020,   /* U+499B */
  0x0020,   /* U+499C */
  0x0020,   /* U+499D */
  0x0020,   /* U+499E */
  0x0020,   /* U+499F */
  0x0020,   /* U+49A0 */
  0x0020,   /* U+49A1 */
  0x0020,   /* U+49A2 */
  0x0020,   /* U+49A3 */
  0x0020,   /* U+49A4 */
  0x0020,   /* U+49A5 */
  0x0020,   /* U+49A6 */
  0x0020,   /* U+49A7 */
  0x0020,   /* U+49A8 */
  0x0020,   /* U+49A9 */
  0x0020,   /* U+49AA */
  0x0020,   /* U+49AB */
  0x0020,   /* U+49AC */
  0x0020,   /* U+49AD */
  0x0020,   /* U+49AE */
  0x0020,   /* U+49AF */
  0x0020,   /* U+49B0 */
  0x0020,   /* U+49B1 */
  0x0020,   /* U+49B2 */
  0x0020,   /* U+49B3 */
  0x0020,   /* U+49B4 */
  0x0020,   /* U+49B5 */
  0x0020,   /* U+49B6 */
  0x0020,   /* U+49B7 */
  0x0020,   /* U+49B8 */
  0x0020,   /* U+49B9 */
  0x0020,   /* U+49BA */
  0x0020,   /* U+49BB */
  0x0020,   /* U+49BC */
  0x0020,   /* U+49BD */
  0x0020,   /* U+49BE */
  0x0020,   /* U+49BF */
  0x0020,   /* U+49C0 */
  0x0020,   /* U+49C1 */
  0x0020,   /* U+49C2 */
  0x0020,   /* U+49C3 */
  0x0020,   /* U+49C4 */
  0x0020,   /* U+49C5 */
  0x0020,   /* U+49C6 */
  0x0020,   /* U+49C7 */
  0x0020,   /* U+49C8 */
  0x0020,   /* U+49C9 */
  0x0020,   /* U+49CA */
  0x0020,   /* U+49CB */
  0x0020,   /* U+49CC */
  0x0020,   /* U+49CD */
  0x0020,   /* U+49CE */
  0x0020,   /* U+49CF */
  0x0020,   /* U+49D0 */
  0x0020,   /* U+49D1 */
  0x0020,   /* U+49D2 */
  0x0020,   /* U+49D3 */
  0x0020,   /* U+49D4 */
  0x0020,   /* U+49D5 */
  0x0020,   /* U+49D6 */
  0x0020,   /* U+49D7 */
  0x0020,   /* U+49D8 */
  0x0020,   /* U+49D9 */
  0x0020,   /* U+49DA */
  0x0020,   /* U+49DB */
  0x0020,   /* U+49DC */
  0x0020,   /* U+49DD */
  0x0020,   /* U+49DE */
  0x0020,   /* U+49DF */
  0x0020,   /* U+49E0 */
  0x0020,   /* U+49E1 */
  0x0020,   /* U+49E2 */
  0x0020,   /* U+49E3 */
  0x0020,   /* U+49E4 */
  0x0020,   /* U+49E5 */
  0x0020,   /* U+49E6 */
  0x0020,   /* U+49E7 */
  0x0020,   /* U+49E8 */
  0x0020,   /* U+49E9 */
  0x0020,   /* U+49EA */
  0x0020,   /* U+49EB */
  0x0020,   /* U+49EC */
  0x0020,   /* U+49ED */
  0x0020,   /* U+49EE */
  0x0020,   /* U+49EF */
  0x0020,   /* U+49F0 */
  0x0020,   /* U+49F1 */
  0x0020,   /* U+49F2 */
  0x0020,   /* U+49F3 */
  0x0020,   /* U+49F4 */
  0x0020,   /* U+49F5 */
  0x0020,   /* U+49F6 */
  0x0020,   /* U+49F7 */
  0x0020,   /* U+49F8 */
  0x0020,   /* U+49F9 */
  0x0020,   /* U+49FA */
  0x0020,   /* U+49FB */
  0x0020,   /* U+49FC */
  0x0020,   /* U+49FD */
  0x0020,   /* U+49FE */
  0x0020,   /* U+49FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4900 */
  0x0002,   /* U+4901 */
  0x0002,   /* U+4902 */
  0x0002,   /* U+4903 */
  0x0002,   /* U+4904 */
  0x0002,   /* U+4905 */
  0x0002,   /* U+4906 */
  0x0002,   /* U+4907 */
  0x0002,   /* U+4908 */
  0x0002,   /* U+4909 */
  0x0002,   /* U+490A */
  0x0002,   /* U+490B */
  0x0002,   /* U+490C */
  0x0002,   /* U+490D */
  0x0002,   /* U+490E */
  0x0002,   /* U+490F */
  0x0002,   /* U+4910 */
  0x0002,   /* U+4911 */
  0x0002,   /* U+4912 */
  0x0002,   /* U+4913 */
  0x0002,   /* U+4914 */
  0x0002,   /* U+4915 */
  0x0002,   /* U+4916 */
  0x0002,   /* U+4917 */
  0x0002,   /* U+4918 */
  0x0002,   /* U+4919 */
  0x0002,   /* U+491A */
  0x0002,   /* U+491B */
  0x0002,   /* U+491C */
  0x0002,   /* U+491D */
  0x0002,   /* U+491E */
  0x0002,   /* U+491F */
  0x0002,   /* U+4920 */
  0x0002,   /* U+4921 */
  0x0002,   /* U+4922 */
  0x0002,   /* U+4923 */
  0x0002,   /* U+4924 */
  0x0002,   /* U+4925 */
  0x0002,   /* U+4926 */
  0x0002,   /* U+4927 */
  0x0002,   /* U+4928 */
  0x0002,   /* U+4929 */
  0x0002,   /* U+492A */
  0x0002,   /* U+492B */
  0x0002,   /* U+492C */
  0x0002,   /* U+492D */
  0x0002,   /* U+492E */
  0x0002,   /* U+492F */
  0x0002,   /* U+4930 */
  0x0002,   /* U+4931 */
  0x0002,   /* U+4932 */
  0x0002,   /* U+4933 */
  0x0002,   /* U+4934 */
  0x0002,   /* U+4935 */
  0x0002,   /* U+4936 */
  0x0002,   /* U+4937 */
  0x0002,   /* U+4938 */
  0x0002,   /* U+4939 */
  0x0002,   /* U+493A */
  0x0002,   /* U+493B */
  0x0002,   /* U+493C */
  0x0002,   /* U+493D */
  0x0002,   /* U+493E */
  0x0002,   /* U+493F */
  0x0002,   /* U+4940 */
  0x0002,   /* U+4941 */
  0x0002,   /* U+4942 */
  0x0002,   /* U+4943 */
  0x0002,   /* U+4944 */
  0x0002,   /* U+4945 */
  0x0002,   /* U+4946 */
  0x0002,   /* U+4947 */
  0x0002,   /* U+4948 */
  0x0002,   /* U+4949 */
  0x0002,   /* U+494A */
  0x0002,   /* U+494B */
  0x0002,   /* U+494C */
  0x0002,   /* U+494D */
  0x0002,   /* U+494E */
  0x0002,   /* U+494F */
  0x0002,   /* U+4950 */
  0x0002,   /* U+4951 */
  0x0002,   /* U+4952 */
  0x0002,   /* U+4953 */
  0x0002,   /* U+4954 */
  0x0002,   /* U+4955 */
  0x0002,   /* U+4956 */
  0x0002,   /* U+4957 */
  0x0002,   /* U+4958 */
  0x0002,   /* U+4959 */
  0x0002,   /* U+495A */
  0x0002,   /* U+495B */
  0x0002,   /* U+495C */
  0x0002,   /* U+495D */
  0x0002,   /* U+495E */
  0x0002,   /* U+495F */
  0x0002,   /* U+4960 */
  0x0002,   /* U+4961 */
  0x0002,   /* U+4962 */
  0x0002,   /* U+4963 */
  0x0002,   /* U+4964 */
  0x0002,   /* U+4965 */
  0x0002,   /* U+4966 */
  0x0002,   /* U+4967 */
  0x0002,   /* U+4968 */
  0x0002,   /* U+4969 */
  0x0002,   /* U+496A */
  0x0002,   /* U+496B */
  0x0002,   /* U+496C */
  0x0002,   /* U+496D */
  0x0002,   /* U+496E */
  0x0002,   /* U+496F */
  0x0002,   /* U+4970 */
  0x0002,   /* U+4971 */
  0x0002,   /* U+4972 */
  0x0002,   /* U+4973 */
  0x0002,   /* U+4974 */
  0x0002,   /* U+4975 */
  0x0002,   /* U+4976 */
  0x0002,   /* U+4977 */
  0x0002,   /* U+4978 */
  0x0002,   /* U+4979 */
  0x0002,   /* U+497A */
  0x0002,   /* U+497B */
  0x0002,   /* U+497C */
  0x0002,   /* U+497D */
  0x0002,   /* U+497E */
  0x0002,   /* U+497F */
  0x0002,   /* U+4980 */
  0x0002,   /* U+4981 */
  0x0002,   /* U+4982 */
  0x0002,   /* U+4983 */
  0x0002,   /* U+4984 */
  0x0002,   /* U+4985 */
  0x0002,   /* U+4986 */
  0x0002,   /* U+4987 */
  0x0002,   /* U+4988 */
  0x0002,   /* U+4989 */
  0x0002,   /* U+498A */
  0x0002,   /* U+498B */
  0x0002,   /* U+498C */
  0x0002,   /* U+498D */
  0x0002,   /* U+498E */
  0x0002,   /* U+498F */
  0x0002,   /* U+4990 */
  0x0002,   /* U+4991 */
  0x0002,   /* U+4992 */
  0x0002,   /* U+4993 */
  0x0002,   /* U+4994 */
  0x0002,   /* U+4995 */
  0x0002,   /* U+4996 */
  0x0002,   /* U+4997 */
  0x0002,   /* U+4998 */
  0x0002,   /* U+4999 */
  0x0002,   /* U+499A */
  0x0002,   /* U+499B */
  0x0002,   /* U+499C */
  0x0002,   /* U+499D */
  0x0002,   /* U+499E */
  0x0002,   /* U+499F */
  0x0002,   /* U+49A0 */
  0x0002,   /* U+49A1 */
  0x0002,   /* U+49A2 */
  0x0002,   /* U+49A3 */
  0x0002,   /* U+49A4 */
  0x0002,   /* U+49A5 */
  0x0002,   /* U+49A6 */
  0x0002,   /* U+49A7 */
  0x0002,   /* U+49A8 */
  0x0002,   /* U+49A9 */
  0x0002,   /* U+49AA */
  0x0002,   /* U+49AB */
  0x0002,   /* U+49AC */
  0x0002,   /* U+49AD */
  0x0002,   /* U+49AE */
  0x0002,   /* U+49AF */
  0x0002,   /* U+49B0 */
  0x0002,   /* U+49B1 */
  0x0002,   /* U+49B2 */
  0x0002,   /* U+49B3 */
  0x0002,   /* U+49B4 */
  0x0002,   /* U+49B5 */
  0x0002,   /* U+49B6 */
  0x0002,   /* U+49B7 */
  0x0002,   /* U+49B8 */
  0x0002,   /* U+49B9 */
  0x0002,   /* U+49BA */
  0x0002,   /* U+49BB */
  0x0002,   /* U+49BC */
  0x0002,   /* U+49BD */
  0x0002,   /* U+49BE */
  0x0002,   /* U+49BF */
  0x0002,   /* U+49C0 */
  0x0002,   /* U+49C1 */
  0x0002,   /* U+49C2 */
  0x0002,   /* U+49C3 */
  0x0002,   /* U+49C4 */
  0x0002,   /* U+49C5 */
  0x0002,   /* U+49C6 */
  0x0002,   /* U+49C7 */
  0x0002,   /* U+49C8 */
  0x0002,   /* U+49C9 */
  0x0002,   /* U+49CA */
  0x0002,   /* U+49CB */
  0x0002,   /* U+49CC */
  0x0002,   /* U+49CD */
  0x0002,   /* U+49CE */
  0x0002,   /* U+49CF */
  0x0002,   /* U+49D0 */
  0x0002,   /* U+49D1 */
  0x0002,   /* U+49D2 */
  0x0002,   /* U+49D3 */
  0x0002,   /* U+49D4 */
  0x0002,   /* U+49D5 */
  0x0002,   /* U+49D6 */
  0x0002,   /* U+49D7 */
  0x0002,   /* U+49D8 */
  0x0002,   /* U+49D9 */
  0x0002,   /* U+49DA */
  0x0002,   /* U+49DB */
  0x0002,   /* U+49DC */
  0x0002,   /* U+49DD */
  0x0002,   /* U+49DE */
  0x0002,   /* U+49DF */
  0x0002,   /* U+49E0 */
  0x0002,   /* U+49E1 */
  0x0002,   /* U+49E2 */
  0x0002,   /* U+49E3 */
  0x0002,   /* U+49E4 */
  0x0002,   /* U+49E5 */
  0x0002,   /* U+49E6 */
  0x0002,   /* U+49E7 */
  0x0002,   /* U+49E8 */
  0x0002,   /* U+49E9 */
  0x0002,   /* U+49EA */
  0x0002,   /* U+49EB */
  0x0002,   /* U+49EC */
  0x0002,   /* U+49ED */
  0x0002,   /* U+49EE */
  0x0002,   /* U+49EF */
  0x0002,   /* U+49F0 */
  0x0002,   /* U+49F1 */
  0x0002,   /* U+49F2 */
  0x0002,   /* U+49F3 */
  0x0002,   /* U+49F4 */
  0x0002,   /* U+49F5 */
  0x0002,   /* U+49F6 */
  0x0002,   /* U+49F7 */
  0x0002,   /* U+49F8 */
  0x0002,   /* U+49F9 */
  0x0002,   /* U+49FA */
  0x0002,   /* U+49FB */
  0x0002,   /* U+49FC */
  0x0002,   /* U+49FD */
  0x0002,   /* U+49FE */
  0x0002,   /* U+49FF */

  /* Primary weight 2 for each character. */
  0x9432,   /* U+4900 */
  0x9433,   /* U+4901 */
  0x9434,   /* U+4902 */
  0x9435,   /* U+4903 */
  0x9436,   /* U+4904 */
  0x9437,   /* U+4905 */
  0x9438,   /* U+4906 */
  0x9439,   /* U+4907 */
  0x943A,   /* U+4908 */
  0x8FB8,   /* U+4909 */
  0x8FB9,   /* U+490A */
  0x8FBA,   /* U+490B */
  0x8FBB,   /* U+490C */
  0x8D0E,   /* U+490D */
  0x89E1,   /* U+490E */
  0x89E2,   /* U+490F */
  0x89E3,   /* U+4910 */
  0x89E4,   /* U+4911 */
  0x89E5,   /* U+4912 */
  0x8597,   /* U+4913 */
  0x8598,   /* U+4914 */
  0x8419,   /* U+4915 */
  0x841A,   /* U+4916 */
  0x8218,   /* U+4917 */
  0x8219,   /* U+4918 */
  0x806F,   /* U+4919 */
  0x9A5F,   /* U+491A */
  0x97D6,   /* U+491B */
  0x9A7F,   /* U+491C */
  0x9CB0,   /* U+491D */
  0x9CB1,   /* U+491E */
  0x9CB2,   /* U+491F */
  0x9CB3,   /* U+4920 */
  0x9AC9,   /* U+4921 */
  0x9ACA,   /* U+4922 */
  0x9ACB,   /* U+4923 */
  0x9986,   /* U+4924 */
  0x9987,   /* U+4925 */
  0x9988,   /* U+4926 */
  0x9989,   /* U+4927 */
  0x998A,   /* U+4928 */
  0x998B,   /* U+4929 */
  0x998C,   /* U+492A */
  0x97F9,   /* U+492B */
  0x97FA,   /* U+492C */
  0x97FB,   /* U+492D */
  0x97FC,   /* U+492E */
  0x97FD,   /* U+492F */
  0x97FE,   /* U+4930 */
  0x97FF,   /* U+4931 */
  0x9800,   /* U+4932 */
  0x94C1,   /* U+4933 */
  0x94C2,   /* U+4934 */
  0x94C3,   /* U+4935 */
  0x94C4,   /* U+4936 */
  0x902B,   /* U+4937 */
  0x902C,   /* U+4938 */
  0x902D,   /* U+4939 */
  0x902E,   /* U+493A */
  0x902F,   /* U+493B */
  0x9030,   /* U+493C */
  0x8D73,   /* U+493D */
  0x8D74,   /* U+493E */
  0x8D75,   /* U+493F */
  0x8D76,   /* U+4940 */
  0x8D77,   /* U+4941 */
  0x8D78,   /* U+4942 */
  0x8D79,   /* U+4943 */
  0x8D7A,   /* U+4944 */
  0x8D7B,   /* U+4945 */
  0x8D7C,   /* U+4946 */
  0x8D7D,   /* U+4947 */
  0x8A3E,   /* U+4948 */
  0x8A3F,   /* U+4949 */
  0x8A40,   /* U+494A */
  0x8A41,   /* U+494B */
  0x8A42,   /* U+494C */
  0x8A43,   /* U+494D */
  0x8A44,   /* U+494E */
  0x8A45,   /* U+494F */
  0x8A46,   /* U+4950 */
  0x8A47,   /* U+4951 */
  0x8A48,   /* U+4952 */
  0x8A49,   /* U+4953 */
  0x877F,   /* U+4954 */
  0x8780,   /* U+4955 */
  0x8781,   /* U+4956 */
  0x8782,   /* U+4957 */
  0x8783,   /* U+4958 */
  0x8784,   /* U+4959 */
  0x8785,   /* U+495A */
  0x8786,   /* U+495B */
  0x8787,   /* U+495C */
  0x85C2,   /* U+495D */
  0x85C3,   /* U+495E */
  0x85C4,   /* U+495F */
  0x85C5,   /* U+4960 */
  0x85C6,   /* U+4961 */
  0x85C7,   /* U+4962 */
  0x85C8,   /* U+4963 */
  0x85C9,   /* U+4964 */
  0x85CA,   /* U+4965 */
  0x85CB,   /* U+4966 */
  0x843A,   /* U+4967 */
  0x843B,   /* U+4968 */
  0x843C,   /* U+4969 */
  0x843D,   /* U+496A */
  0x843E,   /* U+496B */
  0x843F,   /* U+496C */
  0x8440,   /* U+496D */
  0x8441,   /* U+496E */
  0x82FB,   /* U+496F */
  0x82FC,   /* U+4970 */
  0x82FD,   /* U+4971 */
  0x82FE,   /* U+4972 */
  0x82FF,   /* U+4973 */
  0x8300,   /* U+4974 */
  0x8226,   /* U+4975 */
  0x8227,   /* U+4976 */
  0x8228,   /* U+4977 */
  0x8171,   /* U+4978 */
  0x8043,   /* U+4979 */
  0x9CE2,   /* U+497A */
  0x9CE3,   /* U+497B */
  0x9CE4,   /* U+497C */
  0x9AFD,   /* U+497D */
  0x9AFE,   /* U+497E */
  0x9AFF,   /* U+497F */
  0x99D7,   /* U+4980 */
  0x9863,   /* U+4981 */
  0x8DE7,   /* U+4982 */
  0x87FB,   /* U+4983 */
  0x87FC,   /* U+4984 */
  0x87FD,   /* U+4985 */
  0x8080,   /* U+4986 */
  0x9AD9,   /* U+4987 */
  0x9B3F,   /* U+4988 */
  0x9B40,   /* U+4989 */
  0x9A0F,   /* U+498A */
  0x8AA3,   /* U+498B */
  0x9AF0,   /* U+498C */
  0x9AF1,   /* U+498D */
  0x9D3A,   /* U+498E */
  0x9D3B,   /* U+498F */
  0x9D3C,   /* U+4990 */
  0x9D3D,   /* U+4991 */
  0x9B5D,   /* U+4992 */
  0x9B5E,   /* U+4993 */
  0x9B5F,   /* U+4994 */
  0x9A27,   /* U+4995 */
  0x9A28,   /* U+4996 */
  0x9A29,   /* U+4997 */
  0x9A2A,   /* U+4998 */
  0x9A2B,   /* U+4999 */
  0x9A2C,   /* U+499A */
  0x9A2D,   /* U+499B */
  0x98A7,   /* U+499C */
  0x98A8,   /* U+499D */
  0x98A9,   /* U+499E */
  0x98AA,   /* U+499F */
  0x9574,   /* U+49A0 */
  0x9575,   /* U+49A1 */
  0x9576,   /* U+49A2 */
  0x9577,   /* U+49A3 */
  0x9578,   /* U+49A4 */
  0x9579,   /* U+49A5 */
  0x957A,   /* U+49A6 */
  0x957B,   /* U+49A7 */
  0x957C,   /* U+49A8 */
  0x90EB,   /* U+49A9 */
  0x90EC,   /* U+49AA */
  0x90ED,   /* U+49AB */
  0x90EE,   /* U+49AC */
  0x90EF,   /* U+49AD */
  0x90F0,   /* U+49AE */
  0x90F1,   /* U+49AF */
  0x8AB2,   /* U+49B0 */
  0x880F,   /* U+49B1 */
  0x862E,   /* U+49B2 */
  0x862F,   /* U+49B3 */
  0x8630,   /* U+49B4 */
  0x8488,   /* U+49B5 */
  0x9A4B,   /* U+49B6 */
  0x98D6,   /* U+49B7 */
  0x9115,   /* U+49B8 */
  0x8364,   /* U+49B9 */
  0x8365,   /* U+49BA */
  0x86C4,   /* U+49BB */
  0x8B66,   /* U+49BC */
  0x8B67,   /* U+49BD */
  0x9835,   /* U+49BE */
  0x8B68,   /* U+49BF */
  0x8B69,   /* U+49C0 */
  0x9016,   /* U+49C1 */
  0x9017,   /* U+49C2 */
  0x9018,   /* U+49C3 */
  0x9441,   /* U+49C4 */
  0x9442,   /* U+49C5 */
  0x9443,   /* U+49C6 */
  0x9444,   /* U+49C7 */
  0x9445,   /* U+49C8 */
  0x9849,   /* U+49C9 */
  0x984A,   /* U+49CA */
  0x984B,   /* U+49CB */
  0x984C,   /* U+49CC */
  0x984D,   /* U+49CD */
  0x984E,   /* U+49CE */
  0x984F,   /* U+49CF */
  0x9B29,   /* U+49D0 */
  0x9B2A,   /* U+49D1 */
  0x9B2B,   /* U+49D2 */
  0x9B2C,   /* U+49D3 */
  0x9B2D,   /* U+49D4 */
  0x9B2E,   /* U+49D5 */
  0x9B2F,   /* U+49D6 */
  0x9D8A,   /* U+49D7 */
  0x9D8B,   /* U+49D8 */
  0x9D8C,   /* U+49D9 */
  0x9B9B,   /* U+49DA */
  0x9B9C,   /* U+49DB */
  0x9B9D,   /* U+49DC */
  0x9B9E,   /* U+49DD */
  0x9B9F,   /* U+49DE */
  0x9BA0,   /* U+49DF */
  0x9A5D,   /* U+49E0 */
  0x9A5E,   /* U+49E1 */
  0x9A5F,   /* U+49E2 */
  0x9A60,   /* U+49E3 */
  0x98E4,   /* U+49E4 */
  0x98E5,   /* U+49E5 */
  0x98E6,   /* U+49E6 */
  0x95B5,   /* U+49E7 */
  0x95B6,   /* U+49E8 */
  0x98E7,   /* U+49E9 */
  0x95B7,   /* U+49EA */
  0x9121,   /* U+49EB */
  0x9122,   /* U+49EC */
  0x9123,   /* U+49ED */
  0x8ACB,   /* U+49EE */
  0x882E,   /* U+49EF */
  0x864C,   /* U+49F0 */
  0x988D,   /* U+49F1 */
  0x9B6F,   /* U+49F2 */
  0x9B70,   /* U+49F3 */
  0x9DD6,   /* U+49F4 */
  0x9DD7,   /* U+49F5 */
  0x9DD8,   /* U+49F6 */
  0x9BD6,   /* U+49F7 */
  0x9BD7,   /* U+49F8 */
  0x9BD8,   /* U+49F9 */
  0x9BD9,   /* U+49FA */
  0x9A95,   /* U+49FB */
  0x9913,   /* U+49FC */
  0x9914,   /* U+49FD */
  0x95D7,   /* U+49FE */
  0x95D8,   /* U+49FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4900 */
  0x0000,   /* U+4901 */
  0x0000,   /* U+4902 */
  0x0000,   /* U+4903 */
  0x0000,   /* U+4904 */
  0x0000,   /* U+4905 */
  0x0000,   /* U+4906 */
  0x0000,   /* U+4907 */
  0x0000,   /* U+4908 */
  0x0000,   /* U+4909 */
  0x0000,   /* U+490A */
  0x0000,   /* U+490B */
  0x0000,   /* U+490C */
  0x0000,   /* U+490D */
  0x0000,   /* U+490E */
  0x0000,   /* U+490F */
  0x0000,   /* U+4910 */
  0x0000,   /* U+4911 */
  0x0000,   /* U+4912 */
  0x0000,   /* U+4913 */
  0x0000,   /* U+4914 */
  0x0000,   /* U+4915 */
  0x0000,   /* U+4916 */
  0x0000,   /* U+4917 */
  0x0000,   /* U+4918 */
  0x0000,   /* U+4919 */
  0x0000,   /* U+491A */
  0x0000,   /* U+491B */
  0x0000,   /* U+491C */
  0x0000,   /* U+491D */
  0x0000,   /* U+491E */
  0x0000,   /* U+491F */
  0x0000,   /* U+4920 */
  0x0000,   /* U+4921 */
  0x0000,   /* U+4922 */
  0x0000,   /* U+4923 */
  0x0000,   /* U+4924 */
  0x0000,   /* U+4925 */
  0x0000,   /* U+4926 */
  0x0000,   /* U+4927 */
  0x0000,   /* U+4928 */
  0x0000,   /* U+4929 */
  0x0000,   /* U+492A */
  0x0000,   /* U+492B */
  0x0000,   /* U+492C */
  0x0000,   /* U+492D */
  0x0000,   /* U+492E */
  0x0000,   /* U+492F */
  0x0000,   /* U+4930 */
  0x0000,   /* U+4931 */
  0x0000,   /* U+4932 */
  0x0000,   /* U+4933 */
  0x0000,   /* U+4934 */
  0x0000,   /* U+4935 */
  0x0000,   /* U+4936 */
  0x0000,   /* U+4937 */
  0x0000,   /* U+4938 */
  0x0000,   /* U+4939 */
  0x0000,   /* U+493A */
  0x0000,   /* U+493B */
  0x0000,   /* U+493C */
  0x0000,   /* U+493D */
  0x0000,   /* U+493E */
  0x0000,   /* U+493F */
  0x0000,   /* U+4940 */
  0x0000,   /* U+4941 */
  0x0000,   /* U+4942 */
  0x0000,   /* U+4943 */
  0x0000,   /* U+4944 */
  0x0000,   /* U+4945 */
  0x0000,   /* U+4946 */
  0x0000,   /* U+4947 */
  0x0000,   /* U+4948 */
  0x0000,   /* U+4949 */
  0x0000,   /* U+494A */
  0x0000,   /* U+494B */
  0x0000,   /* U+494C */
  0x0000,   /* U+494D */
  0x0000,   /* U+494E */
  0x0000,   /* U+494F */
  0x0000,   /* U+4950 */
  0x0000,   /* U+4951 */
  0x0000,   /* U+4952 */
  0x0000,   /* U+4953 */
  0x0000,   /* U+4954 */
  0x0000,   /* U+4955 */
  0x0000,   /* U+4956 */
  0x0000,   /* U+4957 */
  0x0000,   /* U+4958 */
  0x0000,   /* U+4959 */
  0x0000,   /* U+495A */
  0x0000,   /* U+495B */
  0x0000,   /* U+495C */
  0x0000,   /* U+495D */
  0x0000,   /* U+495E */
  0x0000,   /* U+495F */
  0x0000,   /* U+4960 */
  0x0000,   /* U+4961 */
  0x0000,   /* U+4962 */
  0x0000,   /* U+4963 */
  0x0000,   /* U+4964 */
  0x0000,   /* U+4965 */
  0x0000,   /* U+4966 */
  0x0000,   /* U+4967 */
  0x0000,   /* U+4968 */
  0x0000,   /* U+4969 */
  0x0000,   /* U+496A */
  0x0000,   /* U+496B */
  0x0000,   /* U+496C */
  0x0000,   /* U+496D */
  0x0000,   /* U+496E */
  0x0000,   /* U+496F */
  0x0000,   /* U+4970 */
  0x0000,   /* U+4971 */
  0x0000,   /* U+4972 */
  0x0000,   /* U+4973 */
  0x0000,   /* U+4974 */
  0x0000,   /* U+4975 */
  0x0000,   /* U+4976 */
  0x0000,   /* U+4977 */
  0x0000,   /* U+4978 */
  0x0000,   /* U+4979 */
  0x0000,   /* U+497A */
  0x0000,   /* U+497B */
  0x0000,   /* U+497C */
  0x0000,   /* U+497D */
  0x0000,   /* U+497E */
  0x0000,   /* U+497F */
  0x0000,   /* U+4980 */
  0x0000,   /* U+4981 */
  0x0000,   /* U+4982 */
  0x0000,   /* U+4983 */
  0x0000,   /* U+4984 */
  0x0000,   /* U+4985 */
  0x0000,   /* U+4986 */
  0x0000,   /* U+4987 */
  0x0000,   /* U+4988 */
  0x0000,   /* U+4989 */
  0x0000,   /* U+498A */
  0x0000,   /* U+498B */
  0x0000,   /* U+498C */
  0x0000,   /* U+498D */
  0x0000,   /* U+498E */
  0x0000,   /* U+498F */
  0x0000,   /* U+4990 */
  0x0000,   /* U+4991 */
  0x0000,   /* U+4992 */
  0x0000,   /* U+4993 */
  0x0000,   /* U+4994 */
  0x0000,   /* U+4995 */
  0x0000,   /* U+4996 */
  0x0000,   /* U+4997 */
  0x0000,   /* U+4998 */
  0x0000,   /* U+4999 */
  0x0000,   /* U+499A */
  0x0000,   /* U+499B */
  0x0000,   /* U+499C */
  0x0000,   /* U+499D */
  0x0000,   /* U+499E */
  0x0000,   /* U+499F */
  0x0000,   /* U+49A0 */
  0x0000,   /* U+49A1 */
  0x0000,   /* U+49A2 */
  0x0000,   /* U+49A3 */
  0x0000,   /* U+49A4 */
  0x0000,   /* U+49A5 */
  0x0000,   /* U+49A6 */
  0x0000,   /* U+49A7 */
  0x0000,   /* U+49A8 */
  0x0000,   /* U+49A9 */
  0x0000,   /* U+49AA */
  0x0000,   /* U+49AB */
  0x0000,   /* U+49AC */
  0x0000,   /* U+49AD */
  0x0000,   /* U+49AE */
  0x0000,   /* U+49AF */
  0x0000,   /* U+49B0 */
  0x0000,   /* U+49B1 */
  0x0000,   /* U+49B2 */
  0x0000,   /* U+49B3 */
  0x0000,   /* U+49B4 */
  0x0000,   /* U+49B5 */
  0x0000,   /* U+49B6 */
  0x0000,   /* U+49B7 */
  0x0000,   /* U+49B8 */
  0x0000,   /* U+49B9 */
  0x0000,   /* U+49BA */
  0x0000,   /* U+49BB */
  0x0000,   /* U+49BC */
  0x0000,   /* U+49BD */
  0x0000,   /* U+49BE */
  0x0000,   /* U+49BF */
  0x0000,   /* U+49C0 */
  0x0000,   /* U+49C1 */
  0x0000,   /* U+49C2 */
  0x0000,   /* U+49C3 */
  0x0000,   /* U+49C4 */
  0x0000,   /* U+49C5 */
  0x0000,   /* U+49C6 */
  0x0000,   /* U+49C7 */
  0x0000,   /* U+49C8 */
  0x0000,   /* U+49C9 */
  0x0000,   /* U+49CA */
  0x0000,   /* U+49CB */
  0x0000,   /* U+49CC */
  0x0000,   /* U+49CD */
  0x0000,   /* U+49CE */
  0x0000,   /* U+49CF */
  0x0000,   /* U+49D0 */
  0x0000,   /* U+49D1 */
  0x0000,   /* U+49D2 */
  0x0000,   /* U+49D3 */
  0x0000,   /* U+49D4 */
  0x0000,   /* U+49D5 */
  0x0000,   /* U+49D6 */
  0x0000,   /* U+49D7 */
  0x0000,   /* U+49D8 */
  0x0000,   /* U+49D9 */
  0x0000,   /* U+49DA */
  0x0000,   /* U+49DB */
  0x0000,   /* U+49DC */
  0x0000,   /* U+49DD */
  0x0000,   /* U+49DE */
  0x0000,   /* U+49DF */
  0x0000,   /* U+49E0 */
  0x0000,   /* U+49E1 */
  0x0000,   /* U+49E2 */
  0x0000,   /* U+49E3 */
  0x0000,   /* U+49E4 */
  0x0000,   /* U+49E5 */
  0x0000,   /* U+49E6 */
  0x0000,   /* U+49E7 */
  0x0000,   /* U+49E8 */
  0x0000,   /* U+49E9 */
  0x0000,   /* U+49EA */
  0x0000,   /* U+49EB */
  0x0000,   /* U+49EC */
  0x0000,   /* U+49ED */
  0x0000,   /* U+49EE */
  0x0000,   /* U+49EF */
  0x0000,   /* U+49F0 */
  0x0000,   /* U+49F1 */
  0x0000,   /* U+49F2 */
  0x0000,   /* U+49F3 */
  0x0000,   /* U+49F4 */
  0x0000,   /* U+49F5 */
  0x0000,   /* U+49F6 */
  0x0000,   /* U+49F7 */
  0x0000,   /* U+49F8 */
  0x0000,   /* U+49F9 */
  0x0000,   /* U+49FA */
  0x0000,   /* U+49FB */
  0x0000,   /* U+49FC */
  0x0000,   /* U+49FD */
  0x0000,   /* U+49FE */
  0x0000,   /* U+49FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4900 */
  0x0000,   /* U+4901 */
  0x0000,   /* U+4902 */
  0x0000,   /* U+4903 */
  0x0000,   /* U+4904 */
  0x0000,   /* U+4905 */
  0x0000,   /* U+4906 */
  0x0000,   /* U+4907 */
  0x0000,   /* U+4908 */
  0x0000,   /* U+4909 */
  0x0000,   /* U+490A */
  0x0000,   /* U+490B */
  0x0000,   /* U+490C */
  0x0000,   /* U+490D */
  0x0000,   /* U+490E */
  0x0000,   /* U+490F */
  0x0000,   /* U+4910 */
  0x0000,   /* U+4911 */
  0x0000,   /* U+4912 */
  0x0000,   /* U+4913 */
  0x0000,   /* U+4914 */
  0x0000,   /* U+4915 */
  0x0000,   /* U+4916 */
  0x0000,   /* U+4917 */
  0x0000,   /* U+4918 */
  0x0000,   /* U+4919 */
  0x0000,   /* U+491A */
  0x0000,   /* U+491B */
  0x0000,   /* U+491C */
  0x0000,   /* U+491D */
  0x0000,   /* U+491E */
  0x0000,   /* U+491F */
  0x0000,   /* U+4920 */
  0x0000,   /* U+4921 */
  0x0000,   /* U+4922 */
  0x0000,   /* U+4923 */
  0x0000,   /* U+4924 */
  0x0000,   /* U+4925 */
  0x0000,   /* U+4926 */
  0x0000,   /* U+4927 */
  0x0000,   /* U+4928 */
  0x0000,   /* U+4929 */
  0x0000,   /* U+492A */
  0x0000,   /* U+492B */
  0x0000,   /* U+492C */
  0x0000,   /* U+492D */
  0x0000,   /* U+492E */
  0x0000,   /* U+492F */
  0x0000,   /* U+4930 */
  0x0000,   /* U+4931 */
  0x0000,   /* U+4932 */
  0x0000,   /* U+4933 */
  0x0000,   /* U+4934 */
  0x0000,   /* U+4935 */
  0x0000,   /* U+4936 */
  0x0000,   /* U+4937 */
  0x0000,   /* U+4938 */
  0x0000,   /* U+4939 */
  0x0000,   /* U+493A */
  0x0000,   /* U+493B */
  0x0000,   /* U+493C */
  0x0000,   /* U+493D */
  0x0000,   /* U+493E */
  0x0000,   /* U+493F */
  0x0000,   /* U+4940 */
  0x0000,   /* U+4941 */
  0x0000,   /* U+4942 */
  0x0000,   /* U+4943 */
  0x0000,   /* U+4944 */
  0x0000,   /* U+4945 */
  0x0000,   /* U+4946 */
  0x0000,   /* U+4947 */
  0x0000,   /* U+4948 */
  0x0000,   /* U+4949 */
  0x0000,   /* U+494A */
  0x0000,   /* U+494B */
  0x0000,   /* U+494C */
  0x0000,   /* U+494D */
  0x0000,   /* U+494E */
  0x0000,   /* U+494F */
  0x0000,   /* U+4950 */
  0x0000,   /* U+4951 */
  0x0000,   /* U+4952 */
  0x0000,   /* U+4953 */
  0x0000,   /* U+4954 */
  0x0000,   /* U+4955 */
  0x0000,   /* U+4956 */
  0x0000,   /* U+4957 */
  0x0000,   /* U+4958 */
  0x0000,   /* U+4959 */
  0x0000,   /* U+495A */
  0x0000,   /* U+495B */
  0x0000,   /* U+495C */
  0x0000,   /* U+495D */
  0x0000,   /* U+495E */
  0x0000,   /* U+495F */
  0x0000,   /* U+4960 */
  0x0000,   /* U+4961 */
  0x0000,   /* U+4962 */
  0x0000,   /* U+4963 */
  0x0000,   /* U+4964 */
  0x0000,   /* U+4965 */
  0x0000,   /* U+4966 */
  0x0000,   /* U+4967 */
  0x0000,   /* U+4968 */
  0x0000,   /* U+4969 */
  0x0000,   /* U+496A */
  0x0000,   /* U+496B */
  0x0000,   /* U+496C */
  0x0000,   /* U+496D */
  0x0000,   /* U+496E */
  0x0000,   /* U+496F */
  0x0000,   /* U+4970 */
  0x0000,   /* U+4971 */
  0x0000,   /* U+4972 */
  0x0000,   /* U+4973 */
  0x0000,   /* U+4974 */
  0x0000,   /* U+4975 */
  0x0000,   /* U+4976 */
  0x0000,   /* U+4977 */
  0x0000,   /* U+4978 */
  0x0000,   /* U+4979 */
  0x0000,   /* U+497A */
  0x0000,   /* U+497B */
  0x0000,   /* U+497C */
  0x0000,   /* U+497D */
  0x0000,   /* U+497E */
  0x0000,   /* U+497F */
  0x0000,   /* U+4980 */
  0x0000,   /* U+4981 */
  0x0000,   /* U+4982 */
  0x0000,   /* U+4983 */
  0x0000,   /* U+4984 */
  0x0000,   /* U+4985 */
  0x0000,   /* U+4986 */
  0x0000,   /* U+4987 */
  0x0000,   /* U+4988 */
  0x0000,   /* U+4989 */
  0x0000,   /* U+498A */
  0x0000,   /* U+498B */
  0x0000,   /* U+498C */
  0x0000,   /* U+498D */
  0x0000,   /* U+498E */
  0x0000,   /* U+498F */
  0x0000,   /* U+4990 */
  0x0000,   /* U+4991 */
  0x0000,   /* U+4992 */
  0x0000,   /* U+4993 */
  0x0000,   /* U+4994 */
  0x0000,   /* U+4995 */
  0x0000,   /* U+4996 */
  0x0000,   /* U+4997 */
  0x0000,   /* U+4998 */
  0x0000,   /* U+4999 */
  0x0000,   /* U+499A */
  0x0000,   /* U+499B */
  0x0000,   /* U+499C */
  0x0000,   /* U+499D */
  0x0000,   /* U+499E */
  0x0000,   /* U+499F */
  0x0000,   /* U+49A0 */
  0x0000,   /* U+49A1 */
  0x0000,   /* U+49A2 */
  0x0000,   /* U+49A3 */
  0x0000,   /* U+49A4 */
  0x0000,   /* U+49A5 */
  0x0000,   /* U+49A6 */
  0x0000,   /* U+49A7 */
  0x0000,   /* U+49A8 */
  0x0000,   /* U+49A9 */
  0x0000,   /* U+49AA */
  0x0000,   /* U+49AB */
  0x0000,   /* U+49AC */
  0x0000,   /* U+49AD */
  0x0000,   /* U+49AE */
  0x0000,   /* U+49AF */
  0x0000,   /* U+49B0 */
  0x0000,   /* U+49B1 */
  0x0000,   /* U+49B2 */
  0x0000,   /* U+49B3 */
  0x0000,   /* U+49B4 */
  0x0000,   /* U+49B5 */
  0x0000,   /* U+49B6 */
  0x0000,   /* U+49B7 */
  0x0000,   /* U+49B8 */
  0x0000,   /* U+49B9 */
  0x0000,   /* U+49BA */
  0x0000,   /* U+49BB */
  0x0000,   /* U+49BC */
  0x0000,   /* U+49BD */
  0x0000,   /* U+49BE */
  0x0000,   /* U+49BF */
  0x0000,   /* U+49C0 */
  0x0000,   /* U+49C1 */
  0x0000,   /* U+49C2 */
  0x0000,   /* U+49C3 */
  0x0000,   /* U+49C4 */
  0x0000,   /* U+49C5 */
  0x0000,   /* U+49C6 */
  0x0000,   /* U+49C7 */
  0x0000,   /* U+49C8 */
  0x0000,   /* U+49C9 */
  0x0000,   /* U+49CA */
  0x0000,   /* U+49CB */
  0x0000,   /* U+49CC */
  0x0000,   /* U+49CD */
  0x0000,   /* U+49CE */
  0x0000,   /* U+49CF */
  0x0000,   /* U+49D0 */
  0x0000,   /* U+49D1 */
  0x0000,   /* U+49D2 */
  0x0000,   /* U+49D3 */
  0x0000,   /* U+49D4 */
  0x0000,   /* U+49D5 */
  0x0000,   /* U+49D6 */
  0x0000,   /* U+49D7 */
  0x0000,   /* U+49D8 */
  0x0000,   /* U+49D9 */
  0x0000,   /* U+49DA */
  0x0000,   /* U+49DB */
  0x0000,   /* U+49DC */
  0x0000,   /* U+49DD */
  0x0000,   /* U+49DE */
  0x0000,   /* U+49DF */
  0x0000,   /* U+49E0 */
  0x0000,   /* U+49E1 */
  0x0000,   /* U+49E2 */
  0x0000,   /* U+49E3 */
  0x0000,   /* U+49E4 */
  0x0000,   /* U+49E5 */
  0x0000,   /* U+49E6 */
  0x0000,   /* U+49E7 */
  0x0000,   /* U+49E8 */
  0x0000,   /* U+49E9 */
  0x0000,   /* U+49EA */
  0x0000,   /* U+49EB */
  0x0000,   /* U+49EC */
  0x0000,   /* U+49ED */
  0x0000,   /* U+49EE */
  0x0000,   /* U+49EF */
  0x0000,   /* U+49F0 */
  0x0000,   /* U+49F1 */
  0x0000,   /* U+49F2 */
  0x0000,   /* U+49F3 */
  0x0000,   /* U+49F4 */
  0x0000,   /* U+49F5 */
  0x0000,   /* U+49F6 */
  0x0000,   /* U+49F7 */
  0x0000,   /* U+49F8 */
  0x0000,   /* U+49F9 */
  0x0000,   /* U+49FA */
  0x0000,   /* U+49FB */
  0x0000,   /* U+49FC */
  0x0000,   /* U+49FD */
  0x0000,   /* U+49FE */
  0x0000,   /* U+49FF */
};

uint16 zh3_han_p04A[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C57,   /* U+4A00 */
  0x1C58,   /* U+4A01 */
  0x1C58,   /* U+4A02 */
  0x1C59,   /* U+4A03 */
  0x1C5A,   /* U+4A04 */
  0x1C5B,   /* U+4A05 */
  0x1C5B,   /* U+4A06 */
  0x1C5B,   /* U+4A07 */
  0x1C5D,   /* U+4A08 */
  0x1C60,   /* U+4A09 */
  0x1C67,   /* U+4A0A */
  0x1C52,   /* U+4A0B */
  0x1C53,   /* U+4A0C */
  0x1C53,   /* U+4A0D */
  0x1C54,   /* U+4A0E */
  0x1C55,   /* U+4A0F */
  0x1C55,   /* U+4A10 */
  0x1C55,   /* U+4A11 */
  0x1C55,   /* U+4A12 */
  0x1C55,   /* U+4A13 */
  0x1C55,   /* U+4A14 */
  0x1C55,   /* U+4A15 */
  0x1C55,   /* U+4A16 */
  0x1C56,   /* U+4A17 */
  0x1C56,   /* U+4A18 */
  0x1C56,   /* U+4A19 */
  0x1C57,   /* U+4A1A */
  0x1C57,   /* U+4A1B */
  0x1C57,   /* U+4A1C */
  0x1C57,   /* U+4A1D */
  0x1C58,   /* U+4A1E */
  0x1C58,   /* U+4A1F */
  0x1C58,   /* U+4A20 */
  0x1C58,   /* U+4A21 */
  0x1C58,   /* U+4A22 */
  0x1C58,   /* U+4A23 */
  0x1C58,   /* U+4A24 */
  0x1C59,   /* U+4A25 */
  0x1C59,   /* U+4A26 */
  0x1C59,   /* U+4A27 */
  0x1C59,   /* U+4A28 */
  0x1C59,   /* U+4A29 */
  0x1C59,   /* U+4A2A */
  0x1C5A,   /* U+4A2B */
  0x1C5A,   /* U+4A2C */
  0x1C5A,   /* U+4A2D */
  0x1C5A,   /* U+4A2E */
  0x1C5A,   /* U+4A2F */
  0x1C5B,   /* U+4A30 */
  0x1C5B,   /* U+4A31 */
  0x1C5D,   /* U+4A32 */
  0x1C5D,   /* U+4A33 */
  0x1C5D,   /* U+4A34 */
  0x1C5E,   /* U+4A35 */
  0x1C5E,   /* U+4A36 */
  0x1C5F,   /* U+4A37 */
  0x1C60,   /* U+4A38 */
  0x1C62,   /* U+4A39 */
  0x1C6B,   /* U+4A3A */
  0x1C7B,   /* U+4A3B */
  0x1C5D,   /* U+4A3C */
  0x1C52,   /* U+4A3D */
  0x1C52,   /* U+4A3E */
  0x1C53,   /* U+4A3F */
  0x1C56,   /* U+4A40 */
  0x1C5B,   /* U+4A41 */
  0x1C54,   /* U+4A42 */
  0x1C54,   /* U+4A43 */
  0x1C54,   /* U+4A44 */
  0x1C55,   /* U+4A45 */
  0x1C55,   /* U+4A46 */
  0x1C55,   /* U+4A47 */
  0x1C57,   /* U+4A48 */
  0x1C57,   /* U+4A49 */
  0x1C58,   /* U+4A4A */
  0x1C5B,   /* U+4A4B */
  0x1C5C,   /* U+4A4C */
  0x1C5C,   /* U+4A4D */
  0x1C5D,   /* U+4A4E */
  0x1C5F,   /* U+4A4F */
  0x1C53,   /* U+4A50 */
  0x1C53,   /* U+4A51 */
  0x1C53,   /* U+4A52 */
  0x1C54,   /* U+4A53 */
  0x1C54,   /* U+4A54 */
  0x1C54,   /* U+4A55 */
  0x1C54,   /* U+4A56 */
  0x1C54,   /* U+4A57 */
  0x1C54,   /* U+4A58 */
  0x1C55,   /* U+4A59 */
  0x1C55,   /* U+4A5A */
  0x1C55,   /* U+4A5B */
  0x1C55,   /* U+4A5C */
  0x1C55,   /* U+4A5D */
  0x1C55,   /* U+4A5E */
  0x1C56,   /* U+4A5F */
  0x1C57,   /* U+4A60 */
  0x1C57,   /* U+4A61 */
  0x1C57,   /* U+4A62 */
  0x1C57,   /* U+4A63 */
  0x1C57,   /* U+4A64 */
  0x1C57,   /* U+4A65 */
  0x1C57,   /* U+4A66 */
  0x1C57,   /* U+4A67 */
  0x1C58,   /* U+4A68 */
  0x1C58,   /* U+4A69 */
  0x1C58,   /* U+4A6A */
  0x1C58,   /* U+4A6B */
  0x1C58,   /* U+4A6C */
  0x1C58,   /* U+4A6D */
  0x1C58,   /* U+4A6E */
  0x1C59,   /* U+4A6F */
  0x1C59,   /* U+4A70 */
  0x1C59,   /* U+4A71 */
  0x1C59,   /* U+4A72 */
  0x1C59,   /* U+4A73 */
  0x1C59,   /* U+4A74 */
  0x1C59,   /* U+4A75 */
  0x1C5A,   /* U+4A76 */
  0x1C5A,   /* U+4A77 */
  0x1C5A,   /* U+4A78 */
  0x1C5A,   /* U+4A79 */
  0x1C5A,   /* U+4A7A */
  0x1C5A,   /* U+4A7B */
  0x1C5B,   /* U+4A7C */
  0x1C5B,   /* U+4A7D */
  0x1C5B,   /* U+4A7E */
  0x1C5C,   /* U+4A7F */
  0x1C5C,   /* U+4A80 */
  0x1C5C,   /* U+4A81 */
  0x1C5C,   /* U+4A82 */
  0x1C5C,   /* U+4A83 */
  0x1C5C,   /* U+4A84 */
  0x1C5D,   /* U+4A85 */
  0x1C5D,   /* U+4A86 */
  0x1C5E,   /* U+4A87 */
  0x1C5E,   /* U+4A88 */
  0x1C5F,   /* U+4A89 */
  0x1C60,   /* U+4A8A */
  0x1C60,   /* U+4A8B */
  0x1C61,   /* U+4A8C */
  0x1C61,   /* U+4A8D */
  0x1C62,   /* U+4A8E */
  0x1C54,   /* U+4A8F */
  0x1C55,   /* U+4A90 */
  0x1C55,   /* U+4A91 */
  0x1C55,   /* U+4A92 */
  0x1C55,   /* U+4A93 */
  0x1C57,   /* U+4A94 */
  0x1C58,   /* U+4A95 */
  0x1C59,   /* U+4A96 */
  0x1C59,   /* U+4A97 */
  0x1C59,   /* U+4A98 */
  0x1C5A,   /* U+4A99 */
  0x1C5A,   /* U+4A9A */
  0x1C5C,   /* U+4A9B */
  0x1C5D,   /* U+4A9C */
  0x1C5E,   /* U+4A9D */
  0x1C54,   /* U+4A9E */
  0x1C56,   /* U+4A9F */
  0x1C58,   /* U+4AA0 */
  0x1C5A,   /* U+4AA1 */
  0x1C5A,   /* U+4AA2 */
  0x1C5B,   /* U+4AA3 */
  0x1C5C,   /* U+4AA4 */
  0x1C5E,   /* U+4AA5 */
  0x1C53,   /* U+4AA6 */
  0x1C53,   /* U+4AA7 */
  0x1C53,   /* U+4AA8 */
  0x1C54,   /* U+4AA9 */
  0x1C55,   /* U+4AAA */
  0x1C57,   /* U+4AAB */
  0x1C57,   /* U+4AAC */
  0x1C59,   /* U+4AAD */
  0x1C5A,   /* U+4AAE */
  0x1C5A,   /* U+4AAF */
  0x1C5D,   /* U+4AB0 */
  0x1C53,   /* U+4AB1 */
  0x1C53,   /* U+4AB2 */
  0x1C54,   /* U+4AB3 */
  0x1C54,   /* U+4AB4 */
  0x1C54,   /* U+4AB5 */
  0x1C55,   /* U+4AB6 */
  0x1C55,   /* U+4AB7 */
  0x1C55,   /* U+4AB8 */
  0x1C55,   /* U+4AB9 */
  0x1C55,   /* U+4ABA */
  0x1C55,   /* U+4ABB */
  0x1C55,   /* U+4ABC */
  0x1C55,   /* U+4ABD */
  0x1C55,   /* U+4ABE */
  0x1C56,   /* U+4ABF */
  0x1C56,   /* U+4AC0 */
  0x1C56,   /* U+4AC1 */
  0x1C56,   /* U+4AC2 */
  0x1C57,   /* U+4AC3 */
  0x1C57,   /* U+4AC4 */
  0x1C57,   /* U+4AC5 */
  0x1C57,   /* U+4AC6 */
  0x1C57,   /* U+4AC7 */
  0x1C57,   /* U+4AC8 */
  0x1C57,   /* U+4AC9 */
  0x1C57,   /* U+4ACA */
  0x1C58,   /* U+4ACB */
  0x1C58,   /* U+4ACC */
  0x1C58,   /* U+4ACD */
  0x1C58,   /* U+4ACE */
  0x1C58,   /* U+4ACF */
  0x1C58,   /* U+4AD0 */
  0x1C58,   /* U+4AD1 */
  0x1C58,   /* U+4AD2 */
  0x1C58,   /* U+4AD3 */
  0x1C59,   /* U+4AD4 */
  0x1C59,   /* U+4AD5 */
  0x1C59,   /* U+4AD6 */
  0x1C59,   /* U+4AD7 */
  0x1C59,   /* U+4AD8 */
  0x1C59,   /* U+4AD9 */
  0x1C59,   /* U+4ADA */
  0x1C59,   /* U+4ADB */
  0x1C59,   /* U+4ADC */
  0x1C59,   /* U+4ADD */
  0x1C5A,   /* U+4ADE */
  0x1C5A,   /* U+4ADF */
  0x1C5A,   /* U+4AE0 */
  0x1C5A,   /* U+4AE1 */
  0x1C5A,   /* U+4AE2 */
  0x1C5A,   /* U+4AE3 */
  0x1C5A,   /* U+4AE4 */
  0x1C5A,   /* U+4AE5 */
  0x1C5A,   /* U+4AE6 */
  0x1C5A,   /* U+4AE7 */
  0x1C5B,   /* U+4AE8 */
  0x1C5B,   /* U+4AE9 */
  0x1C5B,   /* U+4AEA */
  0x1C5B,   /* U+4AEB */
  0x1C5C,   /* U+4AEC */
  0x1C5C,   /* U+4AED */
  0x1C5C,   /* U+4AEE */
  0x1C5C,   /* U+4AEF */
  0x1C5C,   /* U+4AF0 */
  0x1C5C,   /* U+4AF1 */
  0x1C5D,   /* U+4AF2 */
  0x1C5D,   /* U+4AF3 */
  0x1C5D,   /* U+4AF4 */
  0x1C5F,   /* U+4AF5 */
  0x1C5F,   /* U+4AF6 */
  0x1C60,   /* U+4AF7 */
  0x1C52,   /* U+4AF8 */
  0x1C53,   /* U+4AF9 */
  0x1C54,   /* U+4AFA */
  0x1C54,   /* U+4AFB */
  0x1C54,   /* U+4AFC */
  0x1C54,   /* U+4AFD */
  0x1C55,   /* U+4AFE */
  0x1C55,   /* U+4AFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4A00 */
  0x0020,   /* U+4A01 */
  0x0020,   /* U+4A02 */
  0x0020,   /* U+4A03 */
  0x0020,   /* U+4A04 */
  0x0020,   /* U+4A05 */
  0x0020,   /* U+4A06 */
  0x0020,   /* U+4A07 */
  0x0020,   /* U+4A08 */
  0x0020,   /* U+4A09 */
  0x0020,   /* U+4A0A */
  0x0020,   /* U+4A0B */
  0x0020,   /* U+4A0C */
  0x0020,   /* U+4A0D */
  0x0020,   /* U+4A0E */
  0x0020,   /* U+4A0F */
  0x0020,   /* U+4A10 */
  0x0020,   /* U+4A11 */
  0x0020,   /* U+4A12 */
  0x0020,   /* U+4A13 */
  0x0020,   /* U+4A14 */
  0x0020,   /* U+4A15 */
  0x0020,   /* U+4A16 */
  0x0020,   /* U+4A17 */
  0x0020,   /* U+4A18 */
  0x0020,   /* U+4A19 */
  0x0020,   /* U+4A1A */
  0x0020,   /* U+4A1B */
  0x0020,   /* U+4A1C */
  0x0020,   /* U+4A1D */
  0x0020,   /* U+4A1E */
  0x0020,   /* U+4A1F */
  0x0020,   /* U+4A20 */
  0x0020,   /* U+4A21 */
  0x0020,   /* U+4A22 */
  0x0020,   /* U+4A23 */
  0x0020,   /* U+4A24 */
  0x0020,   /* U+4A25 */
  0x0020,   /* U+4A26 */
  0x0020,   /* U+4A27 */
  0x0020,   /* U+4A28 */
  0x0020,   /* U+4A29 */
  0x0020,   /* U+4A2A */
  0x0020,   /* U+4A2B */
  0x0020,   /* U+4A2C */
  0x0020,   /* U+4A2D */
  0x0020,   /* U+4A2E */
  0x0020,   /* U+4A2F */
  0x0020,   /* U+4A30 */
  0x0020,   /* U+4A31 */
  0x0020,   /* U+4A32 */
  0x0020,   /* U+4A33 */
  0x0020,   /* U+4A34 */
  0x0020,   /* U+4A35 */
  0x0020,   /* U+4A36 */
  0x0020,   /* U+4A37 */
  0x0020,   /* U+4A38 */
  0x0020,   /* U+4A39 */
  0x0020,   /* U+4A3A */
  0x0020,   /* U+4A3B */
  0x0020,   /* U+4A3C */
  0x0020,   /* U+4A3D */
  0x0020,   /* U+4A3E */
  0x0020,   /* U+4A3F */
  0x0020,   /* U+4A40 */
  0x0020,   /* U+4A41 */
  0x0020,   /* U+4A42 */
  0x0020,   /* U+4A43 */
  0x0020,   /* U+4A44 */
  0x0020,   /* U+4A45 */
  0x0020,   /* U+4A46 */
  0x0020,   /* U+4A47 */
  0x0020,   /* U+4A48 */
  0x0020,   /* U+4A49 */
  0x0020,   /* U+4A4A */
  0x0020,   /* U+4A4B */
  0x0020,   /* U+4A4C */
  0x0020,   /* U+4A4D */
  0x0020,   /* U+4A4E */
  0x0020,   /* U+4A4F */
  0x0020,   /* U+4A50 */
  0x0020,   /* U+4A51 */
  0x0020,   /* U+4A52 */
  0x0020,   /* U+4A53 */
  0x0020,   /* U+4A54 */
  0x0020,   /* U+4A55 */
  0x0020,   /* U+4A56 */
  0x0020,   /* U+4A57 */
  0x0020,   /* U+4A58 */
  0x0020,   /* U+4A59 */
  0x0020,   /* U+4A5A */
  0x0020,   /* U+4A5B */
  0x0020,   /* U+4A5C */
  0x0020,   /* U+4A5D */
  0x0020,   /* U+4A5E */
  0x0020,   /* U+4A5F */
  0x0020,   /* U+4A60 */
  0x0020,   /* U+4A61 */
  0x0020,   /* U+4A62 */
  0x0020,   /* U+4A63 */
  0x0020,   /* U+4A64 */
  0x0020,   /* U+4A65 */
  0x0020,   /* U+4A66 */
  0x0020,   /* U+4A67 */
  0x0020,   /* U+4A68 */
  0x0020,   /* U+4A69 */
  0x0020,   /* U+4A6A */
  0x0020,   /* U+4A6B */
  0x0020,   /* U+4A6C */
  0x0020,   /* U+4A6D */
  0x0020,   /* U+4A6E */
  0x0020,   /* U+4A6F */
  0x0020,   /* U+4A70 */
  0x0020,   /* U+4A71 */
  0x0020,   /* U+4A72 */
  0x0020,   /* U+4A73 */
  0x0020,   /* U+4A74 */
  0x0020,   /* U+4A75 */
  0x0020,   /* U+4A76 */
  0x0020,   /* U+4A77 */
  0x0020,   /* U+4A78 */
  0x0020,   /* U+4A79 */
  0x0020,   /* U+4A7A */
  0x0020,   /* U+4A7B */
  0x0020,   /* U+4A7C */
  0x0020,   /* U+4A7D */
  0x0020,   /* U+4A7E */
  0x0020,   /* U+4A7F */
  0x0020,   /* U+4A80 */
  0x0020,   /* U+4A81 */
  0x0020,   /* U+4A82 */
  0x0020,   /* U+4A83 */
  0x0020,   /* U+4A84 */
  0x0020,   /* U+4A85 */
  0x0020,   /* U+4A86 */
  0x0020,   /* U+4A87 */
  0x0020,   /* U+4A88 */
  0x0020,   /* U+4A89 */
  0x0020,   /* U+4A8A */
  0x0020,   /* U+4A8B */
  0x0020,   /* U+4A8C */
  0x0020,   /* U+4A8D */
  0x0020,   /* U+4A8E */
  0x0020,   /* U+4A8F */
  0x0020,   /* U+4A90 */
  0x0020,   /* U+4A91 */
  0x0020,   /* U+4A92 */
  0x0020,   /* U+4A93 */
  0x0020,   /* U+4A94 */
  0x0020,   /* U+4A95 */
  0x0020,   /* U+4A96 */
  0x0020,   /* U+4A97 */
  0x0020,   /* U+4A98 */
  0x0020,   /* U+4A99 */
  0x0020,   /* U+4A9A */
  0x0020,   /* U+4A9B */
  0x0020,   /* U+4A9C */
  0x0020,   /* U+4A9D */
  0x0020,   /* U+4A9E */
  0x0020,   /* U+4A9F */
  0x0020,   /* U+4AA0 */
  0x0020,   /* U+4AA1 */
  0x0020,   /* U+4AA2 */
  0x0020,   /* U+4AA3 */
  0x0020,   /* U+4AA4 */
  0x0020,   /* U+4AA5 */
  0x0020,   /* U+4AA6 */
  0x0020,   /* U+4AA7 */
  0x0020,   /* U+4AA8 */
  0x0020,   /* U+4AA9 */
  0x0020,   /* U+4AAA */
  0x0020,   /* U+4AAB */
  0x0020,   /* U+4AAC */
  0x0020,   /* U+4AAD */
  0x0020,   /* U+4AAE */
  0x0020,   /* U+4AAF */
  0x0020,   /* U+4AB0 */
  0x0020,   /* U+4AB1 */
  0x0020,   /* U+4AB2 */
  0x0020,   /* U+4AB3 */
  0x0020,   /* U+4AB4 */
  0x0020,   /* U+4AB5 */
  0x0020,   /* U+4AB6 */
  0x0020,   /* U+4AB7 */
  0x0020,   /* U+4AB8 */
  0x0020,   /* U+4AB9 */
  0x0020,   /* U+4ABA */
  0x0020,   /* U+4ABB */
  0x0020,   /* U+4ABC */
  0x0020,   /* U+4ABD */
  0x0020,   /* U+4ABE */
  0x0020,   /* U+4ABF */
  0x0020,   /* U+4AC0 */
  0x0020,   /* U+4AC1 */
  0x0020,   /* U+4AC2 */
  0x0020,   /* U+4AC3 */
  0x0020,   /* U+4AC4 */
  0x0020,   /* U+4AC5 */
  0x0020,   /* U+4AC6 */
  0x0020,   /* U+4AC7 */
  0x0020,   /* U+4AC8 */
  0x0020,   /* U+4AC9 */
  0x0020,   /* U+4ACA */
  0x0020,   /* U+4ACB */
  0x0020,   /* U+4ACC */
  0x0020,   /* U+4ACD */
  0x0020,   /* U+4ACE */
  0x0020,   /* U+4ACF */
  0x0020,   /* U+4AD0 */
  0x0020,   /* U+4AD1 */
  0x0020,   /* U+4AD2 */
  0x0020,   /* U+4AD3 */
  0x0020,   /* U+4AD4 */
  0x0020,   /* U+4AD5 */
  0x0020,   /* U+4AD6 */
  0x0020,   /* U+4AD7 */
  0x0020,   /* U+4AD8 */
  0x0020,   /* U+4AD9 */
  0x0020,   /* U+4ADA */
  0x0020,   /* U+4ADB */
  0x0020,   /* U+4ADC */
  0x0020,   /* U+4ADD */
  0x0020,   /* U+4ADE */
  0x0020,   /* U+4ADF */
  0x0020,   /* U+4AE0 */
  0x0020,   /* U+4AE1 */
  0x0020,   /* U+4AE2 */
  0x0020,   /* U+4AE3 */
  0x0020,   /* U+4AE4 */
  0x0020,   /* U+4AE5 */
  0x0020,   /* U+4AE6 */
  0x0020,   /* U+4AE7 */
  0x0020,   /* U+4AE8 */
  0x0020,   /* U+4AE9 */
  0x0020,   /* U+4AEA */
  0x0020,   /* U+4AEB */
  0x0020,   /* U+4AEC */
  0x0020,   /* U+4AED */
  0x0020,   /* U+4AEE */
  0x0020,   /* U+4AEF */
  0x0020,   /* U+4AF0 */
  0x0020,   /* U+4AF1 */
  0x0020,   /* U+4AF2 */
  0x0020,   /* U+4AF3 */
  0x0020,   /* U+4AF4 */
  0x0020,   /* U+4AF5 */
  0x0020,   /* U+4AF6 */
  0x0020,   /* U+4AF7 */
  0x0020,   /* U+4AF8 */
  0x0020,   /* U+4AF9 */
  0x0020,   /* U+4AFA */
  0x0020,   /* U+4AFB */
  0x0020,   /* U+4AFC */
  0x0020,   /* U+4AFD */
  0x0020,   /* U+4AFE */
  0x0020,   /* U+4AFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4A00 */
  0x0002,   /* U+4A01 */
  0x0002,   /* U+4A02 */
  0x0002,   /* U+4A03 */
  0x0002,   /* U+4A04 */
  0x0002,   /* U+4A05 */
  0x0002,   /* U+4A06 */
  0x0002,   /* U+4A07 */
  0x0002,   /* U+4A08 */
  0x0002,   /* U+4A09 */
  0x0002,   /* U+4A0A */
  0x0002,   /* U+4A0B */
  0x0002,   /* U+4A0C */
  0x0002,   /* U+4A0D */
  0x0002,   /* U+4A0E */
  0x0002,   /* U+4A0F */
  0x0002,   /* U+4A10 */
  0x0002,   /* U+4A11 */
  0x0002,   /* U+4A12 */
  0x0002,   /* U+4A13 */
  0x0002,   /* U+4A14 */
  0x0002,   /* U+4A15 */
  0x0002,   /* U+4A16 */
  0x0002,   /* U+4A17 */
  0x0002,   /* U+4A18 */
  0x0002,   /* U+4A19 */
  0x0002,   /* U+4A1A */
  0x0002,   /* U+4A1B */
  0x0002,   /* U+4A1C */
  0x0002,   /* U+4A1D */
  0x0002,   /* U+4A1E */
  0x0002,   /* U+4A1F */
  0x0002,   /* U+4A20 */
  0x0002,   /* U+4A21 */
  0x0002,   /* U+4A22 */
  0x0002,   /* U+4A23 */
  0x0002,   /* U+4A24 */
  0x0002,   /* U+4A25 */
  0x0002,   /* U+4A26 */
  0x0002,   /* U+4A27 */
  0x0002,   /* U+4A28 */
  0x0002,   /* U+4A29 */
  0x0002,   /* U+4A2A */
  0x0002,   /* U+4A2B */
  0x0002,   /* U+4A2C */
  0x0002,   /* U+4A2D */
  0x0002,   /* U+4A2E */
  0x0002,   /* U+4A2F */
  0x0002,   /* U+4A30 */
  0x0002,   /* U+4A31 */
  0x0002,   /* U+4A32 */
  0x0002,   /* U+4A33 */
  0x0002,   /* U+4A34 */
  0x0002,   /* U+4A35 */
  0x0002,   /* U+4A36 */
  0x0002,   /* U+4A37 */
  0x0002,   /* U+4A38 */
  0x0002,   /* U+4A39 */
  0x0002,   /* U+4A3A */
  0x0002,   /* U+4A3B */
  0x0002,   /* U+4A3C */
  0x0002,   /* U+4A3D */
  0x0002,   /* U+4A3E */
  0x0002,   /* U+4A3F */
  0x0002,   /* U+4A40 */
  0x0002,   /* U+4A41 */
  0x0002,   /* U+4A42 */
  0x0002,   /* U+4A43 */
  0x0002,   /* U+4A44 */
  0x0002,   /* U+4A45 */
  0x0002,   /* U+4A46 */
  0x0002,   /* U+4A47 */
  0x0002,   /* U+4A48 */
  0x0002,   /* U+4A49 */
  0x0002,   /* U+4A4A */
  0x0002,   /* U+4A4B */
  0x0002,   /* U+4A4C */
  0x0002,   /* U+4A4D */
  0x0002,   /* U+4A4E */
  0x0002,   /* U+4A4F */
  0x0002,   /* U+4A50 */
  0x0002,   /* U+4A51 */
  0x0002,   /* U+4A52 */
  0x0002,   /* U+4A53 */
  0x0002,   /* U+4A54 */
  0x0002,   /* U+4A55 */
  0x0002,   /* U+4A56 */
  0x0002,   /* U+4A57 */
  0x0002,   /* U+4A58 */
  0x0002,   /* U+4A59 */
  0x0002,   /* U+4A5A */
  0x0002,   /* U+4A5B */
  0x0002,   /* U+4A5C */
  0x0002,   /* U+4A5D */
  0x0002,   /* U+4A5E */
  0x0002,   /* U+4A5F */
  0x0002,   /* U+4A60 */
  0x0002,   /* U+4A61 */
  0x0002,   /* U+4A62 */
  0x0002,   /* U+4A63 */
  0x0002,   /* U+4A64 */
  0x0002,   /* U+4A65 */
  0x0002,   /* U+4A66 */
  0x0002,   /* U+4A67 */
  0x0002,   /* U+4A68 */
  0x0002,   /* U+4A69 */
  0x0002,   /* U+4A6A */
  0x0002,   /* U+4A6B */
  0x0002,   /* U+4A6C */
  0x0002,   /* U+4A6D */
  0x0002,   /* U+4A6E */
  0x0002,   /* U+4A6F */
  0x0002,   /* U+4A70 */
  0x0002,   /* U+4A71 */
  0x0002,   /* U+4A72 */
  0x0002,   /* U+4A73 */
  0x0002,   /* U+4A74 */
  0x0002,   /* U+4A75 */
  0x0002,   /* U+4A76 */
  0x0002,   /* U+4A77 */
  0x0002,   /* U+4A78 */
  0x0002,   /* U+4A79 */
  0x0002,   /* U+4A7A */
  0x0002,   /* U+4A7B */
  0x0002,   /* U+4A7C */
  0x0002,   /* U+4A7D */
  0x0002,   /* U+4A7E */
  0x0002,   /* U+4A7F */
  0x0002,   /* U+4A80 */
  0x0002,   /* U+4A81 */
  0x0002,   /* U+4A82 */
  0x0002,   /* U+4A83 */
  0x0002,   /* U+4A84 */
  0x0002,   /* U+4A85 */
  0x0002,   /* U+4A86 */
  0x0002,   /* U+4A87 */
  0x0002,   /* U+4A88 */
  0x0002,   /* U+4A89 */
  0x0002,   /* U+4A8A */
  0x0002,   /* U+4A8B */
  0x0002,   /* U+4A8C */
  0x0002,   /* U+4A8D */
  0x0002,   /* U+4A8E */
  0x0002,   /* U+4A8F */
  0x0002,   /* U+4A90 */
  0x0002,   /* U+4A91 */
  0x0002,   /* U+4A92 */
  0x0002,   /* U+4A93 */
  0x0002,   /* U+4A94 */
  0x0002,   /* U+4A95 */
  0x0002,   /* U+4A96 */
  0x0002,   /* U+4A97 */
  0x0002,   /* U+4A98 */
  0x0002,   /* U+4A99 */
  0x0002,   /* U+4A9A */
  0x0002,   /* U+4A9B */
  0x0002,   /* U+4A9C */
  0x0002,   /* U+4A9D */
  0x0002,   /* U+4A9E */
  0x0002,   /* U+4A9F */
  0x0002,   /* U+4AA0 */
  0x0002,   /* U+4AA1 */
  0x0002,   /* U+4AA2 */
  0x0002,   /* U+4AA3 */
  0x0002,   /* U+4AA4 */
  0x0002,   /* U+4AA5 */
  0x0002,   /* U+4AA6 */
  0x0002,   /* U+4AA7 */
  0x0002,   /* U+4AA8 */
  0x0002,   /* U+4AA9 */
  0x0002,   /* U+4AAA */
  0x0002,   /* U+4AAB */
  0x0002,   /* U+4AAC */
  0x0002,   /* U+4AAD */
  0x0002,   /* U+4AAE */
  0x0002,   /* U+4AAF */
  0x0002,   /* U+4AB0 */
  0x0002,   /* U+4AB1 */
  0x0002,   /* U+4AB2 */
  0x0002,   /* U+4AB3 */
  0x0002,   /* U+4AB4 */
  0x0002,   /* U+4AB5 */
  0x0002,   /* U+4AB6 */
  0x0002,   /* U+4AB7 */
  0x0002,   /* U+4AB8 */
  0x0002,   /* U+4AB9 */
  0x0002,   /* U+4ABA */
  0x0002,   /* U+4ABB */
  0x0002,   /* U+4ABC */
  0x0002,   /* U+4ABD */
  0x0002,   /* U+4ABE */
  0x0002,   /* U+4ABF */
  0x0002,   /* U+4AC0 */
  0x0002,   /* U+4AC1 */
  0x0002,   /* U+4AC2 */
  0x0002,   /* U+4AC3 */
  0x0002,   /* U+4AC4 */
  0x0002,   /* U+4AC5 */
  0x0002,   /* U+4AC6 */
  0x0002,   /* U+4AC7 */
  0x0002,   /* U+4AC8 */
  0x0002,   /* U+4AC9 */
  0x0002,   /* U+4ACA */
  0x0002,   /* U+4ACB */
  0x0002,   /* U+4ACC */
  0x0002,   /* U+4ACD */
  0x0002,   /* U+4ACE */
  0x0002,   /* U+4ACF */
  0x0002,   /* U+4AD0 */
  0x0002,   /* U+4AD1 */
  0x0002,   /* U+4AD2 */
  0x0002,   /* U+4AD3 */
  0x0002,   /* U+4AD4 */
  0x0002,   /* U+4AD5 */
  0x0002,   /* U+4AD6 */
  0x0002,   /* U+4AD7 */
  0x0002,   /* U+4AD8 */
  0x0002,   /* U+4AD9 */
  0x0002,   /* U+4ADA */
  0x0002,   /* U+4ADB */
  0x0002,   /* U+4ADC */
  0x0002,   /* U+4ADD */
  0x0002,   /* U+4ADE */
  0x0002,   /* U+4ADF */
  0x0002,   /* U+4AE0 */
  0x0002,   /* U+4AE1 */
  0x0002,   /* U+4AE2 */
  0x0002,   /* U+4AE3 */
  0x0002,   /* U+4AE4 */
  0x0002,   /* U+4AE5 */
  0x0002,   /* U+4AE6 */
  0x0002,   /* U+4AE7 */
  0x0002,   /* U+4AE8 */
  0x0002,   /* U+4AE9 */
  0x0002,   /* U+4AEA */
  0x0002,   /* U+4AEB */
  0x0002,   /* U+4AEC */
  0x0002,   /* U+4AED */
  0x0002,   /* U+4AEE */
  0x0002,   /* U+4AEF */
  0x0002,   /* U+4AF0 */
  0x0002,   /* U+4AF1 */
  0x0002,   /* U+4AF2 */
  0x0002,   /* U+4AF3 */
  0x0002,   /* U+4AF4 */
  0x0002,   /* U+4AF5 */
  0x0002,   /* U+4AF6 */
  0x0002,   /* U+4AF7 */
  0x0002,   /* U+4AF8 */
  0x0002,   /* U+4AF9 */
  0x0002,   /* U+4AFA */
  0x0002,   /* U+4AFB */
  0x0002,   /* U+4AFC */
  0x0002,   /* U+4AFD */
  0x0002,   /* U+4AFE */
  0x0002,   /* U+4AFF */

  /* Primary weight 2 for each character. */
  0x8CED,   /* U+4A00 */
  0x9138,   /* U+4A01 */
  0x9139,   /* U+4A02 */
  0x8E4E,   /* U+4A03 */
  0x8AD6,   /* U+4A04 */
  0x883C,   /* U+4A05 */
  0x883D,   /* U+4A06 */
  0x883E,   /* U+4A07 */
  0x8496,   /* U+4A08 */
  0x8195,   /* U+4A09 */
  0x8014,   /* U+4A0A */
  0x9B82,   /* U+4A0B */
  0x9DF6,   /* U+4A0C */
  0x9DF7,   /* U+4A0D */
  0x9BF9,   /* U+4A0E */
  0x9AB5,   /* U+4A0F */
  0x9AB6,   /* U+4A10 */
  0x9AB7,   /* U+4A11 */
  0x9AB8,   /* U+4A12 */
  0x9AB9,   /* U+4A13 */
  0x9ABA,   /* U+4A14 */
  0x9ABB,   /* U+4A15 */
  0x9ABC,   /* U+4A16 */
  0x9936,   /* U+4A17 */
  0x9937,   /* U+4A18 */
  0x9938,   /* U+4A19 */
  0x9609,   /* U+4A1A */
  0x960A,   /* U+4A1B */
  0x960B,   /* U+4A1C */
  0x960C,   /* U+4A1D */
  0x915E,   /* U+4A1E */
  0x915F,   /* U+4A1F */
  0x9160,   /* U+4A20 */
  0x9161,   /* U+4A21 */
  0x9162,   /* U+4A22 */
  0x9163,   /* U+4A23 */
  0x9164,   /* U+4A24 */
  0x8E64,   /* U+4A25 */
  0x8E65,   /* U+4A26 */
  0x8E66,   /* U+4A27 */
  0x8E67,   /* U+4A28 */
  0x8E68,   /* U+4A29 */
  0x8E69,   /* U+4A2A */
  0x8AF0,   /* U+4A2B */
  0x8AF1,   /* U+4A2C */
  0x8AF2,   /* U+4A2D */
  0x8AF3,   /* U+4A2E */
  0x8AF4,   /* U+4A2F */
  0x885C,   /* U+4A30 */
  0x885D,   /* U+4A31 */
  0x84A8,   /* U+4A32 */
  0x84A9,   /* U+4A33 */
  0x84AA,   /* U+4A34 */
  0x834F,   /* U+4A35 */
  0x8350,   /* U+4A36 */
  0x8271,   /* U+4A37 */
  0x819B,   /* U+4A38 */
  0x80CF,   /* U+4A39 */
  0x8007,   /* U+4A3A */
  0x8000,   /* U+4A3B */
  0x84CA,   /* U+4A3C */
  0x9B91,   /* U+4A3D */
  0x9B92,   /* U+4A3E */
  0x9E15,   /* U+4A3F */
  0x9967,   /* U+4A40 */
  0x888A,   /* U+4A41 */
  0x9C24,   /* U+4A42 */
  0x9C25,   /* U+4A43 */
  0x9C26,   /* U+4A44 */
  0x9ADE,   /* U+4A45 */
  0x9ADF,   /* U+4A46 */
  0x9AE0,   /* U+4A47 */
  0x964D,   /* U+4A48 */
  0x964E,   /* U+4A49 */
  0x919B,   /* U+4A4A */
  0x8890,   /* U+4A4B */
  0x8688,   /* U+4A4C */
  0x8689,   /* U+4A4D */
  0x84CB,   /* U+4A4E */
  0x827F,   /* U+4A4F */
  0x9E2A,   /* U+4A50 */
  0x9E2B,   /* U+4A51 */
  0x9E2C,   /* U+4A52 */
  0x9C36,   /* U+4A53 */
  0x9C37,   /* U+4A54 */
  0x9C38,   /* U+4A55 */
  0x9C39,   /* U+4A56 */
  0x9C3A,   /* U+4A57 */
  0x9C3B,   /* U+4A58 */
  0x9AFE,   /* U+4A59 */
  0x9AFF,   /* U+4A5A */
  0x9B00,   /* U+4A5B */
  0x9B01,   /* U+4A5C */
  0x9B02,   /* U+4A5D */
  0x9B03,   /* U+4A5E */
  0x9985,   /* U+4A5F */
  0x9662,   /* U+4A60 */
  0x9663,   /* U+4A61 */
  0x9664,   /* U+4A62 */
  0x9665,   /* U+4A63 */
  0x9666,   /* U+4A64 */
  0x9667,   /* U+4A65 */
  0x9668,   /* U+4A66 */
  0x9669,   /* U+4A67 */
  0x91AD,   /* U+4A68 */
  0x91AE,   /* U+4A69 */
  0x91AF,   /* U+4A6A */
  0x91B0,   /* U+4A6B */
  0x91B1,   /* U+4A6C */
  0x91B2,   /* U+4A6D */
  0x91B3,   /* U+4A6E */
  0x8EB2,   /* U+4A6F */
  0x8EB3,   /* U+4A70 */
  0x8EB4,   /* U+4A71 */
  0x8EB5,   /* U+4A72 */
  0x8EB6,   /* U+4A73 */
  0x8EB7,   /* U+4A74 */
  0x8EB8,   /* U+4A75 */
  0x8B2B,   /* U+4A76 */
  0x8B2C,   /* U+4A77 */
  0x8B2D,   /* U+4A78 */
  0x8B2E,   /* U+4A79 */
  0x8B2F,   /* U+4A7A */
  0x8B30,   /* U+4A7B */
  0x889E,   /* U+4A7C */
  0x889F,   /* U+4A7D */
  0x88A0,   /* U+4A7E */
  0x869A,   /* U+4A7F */
  0x869B,   /* U+4A80 */
  0x869C,   /* U+4A81 */
  0x869D,   /* U+4A82 */
  0x869E,   /* U+4A83 */
  0x869F,   /* U+4A84 */
  0x84D2,   /* U+4A85 */
  0x84D3,   /* U+4A86 */
  0x8368,   /* U+4A87 */
  0x8369,   /* U+4A88 */
  0x8285,   /* U+4A89 */
  0x81AA,   /* U+4A8A */
  0x81AB,   /* U+4A8B */
  0x8121,   /* U+4A8C */
  0x8122,   /* U+4A8D */
  0x80D6,   /* U+4A8E */
  0x9C55,   /* U+4A8F */
  0x9B24,   /* U+4A90 */
  0x9B25,   /* U+4A91 */
  0x9B26,   /* U+4A92 */
  0x9B27,   /* U+4A93 */
  0x9686,   /* U+4A94 */
  0x91DA,   /* U+4A95 */
  0x8EEA,   /* U+4A96 */
  0x8EEB,   /* U+4A97 */
  0x8EEC,   /* U+4A98 */
  0x8B60,   /* U+4A99 */
  0x8B61,   /* U+4A9A */
  0x86B8,   /* U+4A9B */
  0x84E9,   /* U+4A9C */
  0x8377,   /* U+4A9D */
  0x9C66,   /* U+4A9E */
  0x99BB,   /* U+4A9F */
  0x91EC,   /* U+4AA0 */
  0x8B6C,   /* U+4AA1 */
  0x8B6D,   /* U+4AA2 */
  0x88CE,   /* U+4AA3 */
  0x86C2,   /* U+4AA4 */
  0x837D,   /* U+4AA5 */
  0x9E37,   /* U+4AA6 */
  0x9E38,   /* U+4AA7 */
  0x9E39,   /* U+4AA8 */
  0x9C6B,   /* U+4AA9 */
  0x9B3B,   /* U+4AAA */
  0x9696,   /* U+4AAB */
  0x9697,   /* U+4AAC */
  0x8EFD,   /* U+4AAD */
  0x8B73,   /* U+4AAE */
  0x8B74,   /* U+4AAF */
  0x84F3,   /* U+4AB0 */
  0x9E42,   /* U+4AB1 */
  0x9E43,   /* U+4AB2 */
  0x9C7A,   /* U+4AB3 */
  0x9C7B,   /* U+4AB4 */
  0x9C7C,   /* U+4AB5 */
  0x9B4C,   /* U+4AB6 */
  0x9B4D,   /* U+4AB7 */
  0x9B4E,   /* U+4AB8 */
  0x9B4F,   /* U+4AB9 */
  0x9B50,   /* U+4ABA */
  0x9B51,   /* U+4ABB */
  0x9B52,   /* U+4ABC */
  0x9B53,   /* U+4ABD */
  0x9B54,   /* U+4ABE */
  0x99D9,   /* U+4ABF */
  0x99DA,   /* U+4AC0 */
  0x99DB,   /* U+4AC1 */
  0x99DC,   /* U+4AC2 */
  0x96B5,   /* U+4AC3 */
  0x96B6,   /* U+4AC4 */
  0x96B7,   /* U+4AC5 */
  0x96B8,   /* U+4AC6 */
  0x96B9,   /* U+4AC7 */
  0x96BA,   /* U+4AC8 */
  0x96BB,   /* U+4AC9 */
  0x96BC,   /* U+4ACA */
  0x91FF,   /* U+4ACB */
  0x9200,   /* U+4ACC */
  0x9201,   /* U+4ACD */
  0x9202,   /* U+4ACE */
  0x9203,   /* U+4ACF */
  0x9204,   /* U+4AD0 */
  0x9205,   /* U+4AD1 */
  0x9206,   /* U+4AD2 */
  0x9207,   /* U+4AD3 */
  0x8F12,   /* U+4AD4 */
  0x8F13,   /* U+4AD5 */
  0x8F14,   /* U+4AD6 */
  0x8F15,   /* U+4AD7 */
  0x8F16,   /* U+4AD8 */
  0x8F17,   /* U+4AD9 */
  0x8F18,   /* U+4ADA */
  0x8F19,   /* U+4ADB */
  0x8F1A,   /* U+4ADC */
  0x8F1B,   /* U+4ADD */
  0x8B83,   /* U+4ADE */
  0x8B84,   /* U+4ADF */
  0x8B85,   /* U+4AE0 */
  0x8B86,   /* U+4AE1 */
  0x8B87,   /* U+4AE2 */
  0x8B88,   /* U+4AE3 */
  0x8B89,   /* U+4AE4 */
  0x8B8A,   /* U+4AE5 */
  0x8B8B,   /* U+4AE6 */
  0x8B8C,   /* U+4AE7 */
  0x88E3,   /* U+4AE8 */
  0x88E4,   /* U+4AE9 */
  0x88E5,   /* U+4AEA */
  0x88E6,   /* U+4AEB */
  0x86CF,   /* U+4AEC */
  0x86D0,   /* U+4AED */
  0x86D1,   /* U+4AEE */
  0x86D2,   /* U+4AEF */
  0x86D3,   /* U+4AF0 */
  0x86D4,   /* U+4AF1 */
  0x84FD,   /* U+4AF2 */
  0x84FE,   /* U+4AF3 */
  0x84FF,   /* U+4AF4 */
  0x8293,   /* U+4AF5 */
  0x8294,   /* U+4AF6 */
  0x81B8,   /* U+4AF7 */
  0x9BB2,   /* U+4AF8 */
  0x9E69,   /* U+4AF9 */
  0x9CAC,   /* U+4AFA */
  0x9CAD,   /* U+4AFB */
  0x9CAE,   /* U+4AFC */
  0x9CAF,   /* U+4AFD */
  0x9B91,   /* U+4AFE */
  0x9B92,   /* U+4AFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4A00 */
  0x0000,   /* U+4A01 */
  0x0000,   /* U+4A02 */
  0x0000,   /* U+4A03 */
  0x0000,   /* U+4A04 */
  0x0000,   /* U+4A05 */
  0x0000,   /* U+4A06 */
  0x0000,   /* U+4A07 */
  0x0000,   /* U+4A08 */
  0x0000,   /* U+4A09 */
  0x0000,   /* U+4A0A */
  0x0000,   /* U+4A0B */
  0x0000,   /* U+4A0C */
  0x0000,   /* U+4A0D */
  0x0000,   /* U+4A0E */
  0x0000,   /* U+4A0F */
  0x0000,   /* U+4A10 */
  0x0000,   /* U+4A11 */
  0x0000,   /* U+4A12 */
  0x0000,   /* U+4A13 */
  0x0000,   /* U+4A14 */
  0x0000,   /* U+4A15 */
  0x0000,   /* U+4A16 */
  0x0000,   /* U+4A17 */
  0x0000,   /* U+4A18 */
  0x0000,   /* U+4A19 */
  0x0000,   /* U+4A1A */
  0x0000,   /* U+4A1B */
  0x0000,   /* U+4A1C */
  0x0000,   /* U+4A1D */
  0x0000,   /* U+4A1E */
  0x0000,   /* U+4A1F */
  0x0000,   /* U+4A20 */
  0x0000,   /* U+4A21 */
  0x0000,   /* U+4A22 */
  0x0000,   /* U+4A23 */
  0x0000,   /* U+4A24 */
  0x0000,   /* U+4A25 */
  0x0000,   /* U+4A26 */
  0x0000,   /* U+4A27 */
  0x0000,   /* U+4A28 */
  0x0000,   /* U+4A29 */
  0x0000,   /* U+4A2A */
  0x0000,   /* U+4A2B */
  0x0000,   /* U+4A2C */
  0x0000,   /* U+4A2D */
  0x0000,   /* U+4A2E */
  0x0000,   /* U+4A2F */
  0x0000,   /* U+4A30 */
  0x0000,   /* U+4A31 */
  0x0000,   /* U+4A32 */
  0x0000,   /* U+4A33 */
  0x0000,   /* U+4A34 */
  0x0000,   /* U+4A35 */
  0x0000,   /* U+4A36 */
  0x0000,   /* U+4A37 */
  0x0000,   /* U+4A38 */
  0x0000,   /* U+4A39 */
  0x0000,   /* U+4A3A */
  0x0000,   /* U+4A3B */
  0x0000,   /* U+4A3C */
  0x0000,   /* U+4A3D */
  0x0000,   /* U+4A3E */
  0x0000,   /* U+4A3F */
  0x0000,   /* U+4A40 */
  0x0000,   /* U+4A41 */
  0x0000,   /* U+4A42 */
  0x0000,   /* U+4A43 */
  0x0000,   /* U+4A44 */
  0x0000,   /* U+4A45 */
  0x0000,   /* U+4A46 */
  0x0000,   /* U+4A47 */
  0x0000,   /* U+4A48 */
  0x0000,   /* U+4A49 */
  0x0000,   /* U+4A4A */
  0x0000,   /* U+4A4B */
  0x0000,   /* U+4A4C */
  0x0000,   /* U+4A4D */
  0x0000,   /* U+4A4E */
  0x0000,   /* U+4A4F */
  0x0000,   /* U+4A50 */
  0x0000,   /* U+4A51 */
  0x0000,   /* U+4A52 */
  0x0000,   /* U+4A53 */
  0x0000,   /* U+4A54 */
  0x0000,   /* U+4A55 */
  0x0000,   /* U+4A56 */
  0x0000,   /* U+4A57 */
  0x0000,   /* U+4A58 */
  0x0000,   /* U+4A59 */
  0x0000,   /* U+4A5A */
  0x0000,   /* U+4A5B */
  0x0000,   /* U+4A5C */
  0x0000,   /* U+4A5D */
  0x0000,   /* U+4A5E */
  0x0000,   /* U+4A5F */
  0x0000,   /* U+4A60 */
  0x0000,   /* U+4A61 */
  0x0000,   /* U+4A62 */
  0x0000,   /* U+4A63 */
  0x0000,   /* U+4A64 */
  0x0000,   /* U+4A65 */
  0x0000,   /* U+4A66 */
  0x0000,   /* U+4A67 */
  0x0000,   /* U+4A68 */
  0x0000,   /* U+4A69 */
  0x0000,   /* U+4A6A */
  0x0000,   /* U+4A6B */
  0x0000,   /* U+4A6C */
  0x0000,   /* U+4A6D */
  0x0000,   /* U+4A6E */
  0x0000,   /* U+4A6F */
  0x0000,   /* U+4A70 */
  0x0000,   /* U+4A71 */
  0x0000,   /* U+4A72 */
  0x0000,   /* U+4A73 */
  0x0000,   /* U+4A74 */
  0x0000,   /* U+4A75 */
  0x0000,   /* U+4A76 */
  0x0000,   /* U+4A77 */
  0x0000,   /* U+4A78 */
  0x0000,   /* U+4A79 */
  0x0000,   /* U+4A7A */
  0x0000,   /* U+4A7B */
  0x0000,   /* U+4A7C */
  0x0000,   /* U+4A7D */
  0x0000,   /* U+4A7E */
  0x0000,   /* U+4A7F */
  0x0000,   /* U+4A80 */
  0x0000,   /* U+4A81 */
  0x0000,   /* U+4A82 */
  0x0000,   /* U+4A83 */
  0x0000,   /* U+4A84 */
  0x0000,   /* U+4A85 */
  0x0000,   /* U+4A86 */
  0x0000,   /* U+4A87 */
  0x0000,   /* U+4A88 */
  0x0000,   /* U+4A89 */
  0x0000,   /* U+4A8A */
  0x0000,   /* U+4A8B */
  0x0000,   /* U+4A8C */
  0x0000,   /* U+4A8D */
  0x0000,   /* U+4A8E */
  0x0000,   /* U+4A8F */
  0x0000,   /* U+4A90 */
  0x0000,   /* U+4A91 */
  0x0000,   /* U+4A92 */
  0x0000,   /* U+4A93 */
  0x0000,   /* U+4A94 */
  0x0000,   /* U+4A95 */
  0x0000,   /* U+4A96 */
  0x0000,   /* U+4A97 */
  0x0000,   /* U+4A98 */
  0x0000,   /* U+4A99 */
  0x0000,   /* U+4A9A */
  0x0000,   /* U+4A9B */
  0x0000,   /* U+4A9C */
  0x0000,   /* U+4A9D */
  0x0000,   /* U+4A9E */
  0x0000,   /* U+4A9F */
