; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefix=GFX7LESS %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX89,GFX8 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX89,GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=-wavefrontsize32,+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX10,GFX1064 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32,-wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX10,GFX1032 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX11,GFX1164 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX11,GFX1132 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=-wavefrontsize32,+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX12,GFX1264 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize32,-wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX12,GFX1232 %s

declare i32 @llvm.amdgcn.workitem.id.x()

; Show what the atomic optimization pass will do for global pointers.

define amdgpu_kernel void @add_i32_constant(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS-LABEL: add_i32_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB0_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_mul_i32 s6, s6, 5
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB0_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_mad_u32_u24 v0, v0, 5, s4
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX89-LABEL: add_i32_constant:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX89-NEXT:    s_mov_b64 s[6:7], exec
; GFX89-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX89-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX89-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX89-NEXT:    ; implicit-def: $vgpr1
; GFX89-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX89-NEXT:    s_cbranch_execz .LBB0_2
; GFX89-NEXT:  ; %bb.1:
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_mov_b32 s8, s2
; GFX89-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX89-NEXT:    s_mul_i32 s2, s2, 5
; GFX89-NEXT:    s_mov_b32 s11, 0xf000
; GFX89-NEXT:    s_mov_b32 s10, -1
; GFX89-NEXT:    s_mov_b32 s9, s3
; GFX89-NEXT:    v_mov_b32_e32 v1, s2
; GFX89-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    buffer_wbinvl1_vol
; GFX89-NEXT:  .LBB0_2:
; GFX89-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX89-NEXT:    v_readfirstlane_b32 s4, v1
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_mov_b32 s3, 0xf000
; GFX89-NEXT:    s_mov_b32 s2, -1
; GFX89-NEXT:    v_mad_u32_u24 v0, v0, 5, s4
; GFX89-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX89-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB0_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_mul_i32 s6, s6, 5
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s6
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  .LBB0_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s5, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s5, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB0_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_mul_i32 s5, s5, 5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s5
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  .LBB0_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i32_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB0_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    s_mul_i32 s6, s6, 5
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    v_mov_b32_e32 v1, s6
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mov_b32 s8, s2
; GFX1164-NEXT:    s_mov_b32 s9, s3
; GFX1164-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:  .LBB0_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_nop 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i32_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1132-NEXT:    s_mov_b32 s5, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s5, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB0_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_mul_i32 s5, s5, 5
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    v_mov_b32_e32 v1, s5
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:  .LBB0_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_nop 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: add_i32_constant:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1264-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-NEXT:    s_mov_b64 s[4:5], exec
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-NEXT:    ; implicit-def: $vgpr1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1264-NEXT:    s_cbranch_execz .LBB0_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    s_mul_i32 s6, s6, 5
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    v_mov_b32_e32 v1, s6
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mov_b32 s8, s2
; GFX1264-NEXT:    s_mov_b32 s9, s3
; GFX1264-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB0_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1264-NEXT:    s_nop 0
; GFX1264-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: add_i32_constant:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1232-NEXT:    s_mov_b32 s5, exec_lo
; GFX1232-NEXT:    s_mov_b32 s4, exec_lo
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v0, s5, 0
; GFX1232-NEXT:    ; implicit-def: $vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1232-NEXT:    s_cbranch_execz .LBB0_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_mul_i32 s5, s5, 5
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    v_mov_b32_e32 v1, s5
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mov_b32 s8, s2
; GFX1232-NEXT:    s_mov_b32 s9, s3
; GFX1232-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB0_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1232-NEXT:    s_nop 0
; GFX1232-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw add ptr addrspace(1) %inout, i32 5 syncscope("agent") acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i32_uniform(ptr addrspace(1) %out, ptr addrspace(1) %inout, i32 %additive) {
; GFX7LESS-LABEL: add_i32_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7LESS-NEXT:    s_load_dword s8, s[0:1], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB1_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s2, s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_mov_b32 s12, s6
; GFX7LESS-NEXT:    s_mov_b32 s13, s7
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-NEXT:    buffer_atomic_add v1, off, s[12:15], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB1_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s0, v1
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i32_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB1_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mul_i32 s2, s8, s2
; GFX8-NEXT:    s_mov_b32 s15, 0xf000
; GFX8-NEXT:    s_mov_b32 s14, -1
; GFX8-NEXT:    s_mov_b32 s12, s6
; GFX8-NEXT:    s_mov_b32 s13, s7
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    buffer_atomic_add v1, off, s[12:15], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB1_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v1
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i32_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB1_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s2, s8, s2
; GFX9-NEXT:    s_mov_b32 s15, 0xf000
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    buffer_atomic_add v1, off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB1_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v1
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1064-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB1_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s2, s8, s2
; GFX1064-NEXT:    s_mov_b32 s14, -1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s2
; GFX1064-NEXT:    s_mov_b32 s12, s6
; GFX1064-NEXT:    s_mov_b32 s13, s7
; GFX1064-NEXT:    buffer_atomic_add v1, off, s[12:15], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  .LBB1_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], s8, v0, s[0:1]
; GFX1064-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1032-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB1_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s3
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s1, s2, s1
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s1
; GFX1032-NEXT:    s_mov_b32 s8, s6
; GFX1032-NEXT:    s_mov_b32 s9, s7
; GFX1032-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  .LBB1_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s0, s2, v0, s[0:1]
; GFX1032-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i32_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1164-NEXT:    s_load_b32 s8, s[0:1], 0x34
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB1_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1164-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s2, s8, s2
; GFX1164-NEXT:    s_mov_b32 s14, -1
; GFX1164-NEXT:    v_mov_b32_e32 v1, s2
; GFX1164-NEXT:    s_mov_b32 s12, s6
; GFX1164-NEXT:    s_mov_b32 s13, s7
; GFX1164-NEXT:    buffer_atomic_add_u32 v1, off, s[12:15], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:  .LBB1_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s6, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u64_u32 v[1:2], null, s8, v0, s[0:1]
; GFX1164-NEXT:    buffer_store_b32 v1, off, s[4:7], 0
; GFX1164-NEXT:    s_nop 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i32_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1132-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB1_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s2, s2
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s2, s0, s2
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    v_mov_b32_e32 v1, s2
; GFX1132-NEXT:    s_mov_b32 s8, s6
; GFX1132-NEXT:    s_mov_b32 s9, s7
; GFX1132-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:  .LBB1_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s6, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u64_u32 v[1:2], null, s0, v0, s[2:3]
; GFX1132-NEXT:    buffer_store_b32 v1, off, s[4:7], 0
; GFX1132-NEXT:    s_nop 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: add_i32_uniform:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_clause 0x1
; GFX1264-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1264-NEXT:    s_load_b32 s8, s[0:1], 0x34
; GFX1264-NEXT:    s_mov_b64 s[2:3], exec
; GFX1264-NEXT:    s_mov_b64 s[0:1], exec
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1264-NEXT:    ; implicit-def: $vgpr1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1264-NEXT:    s_cbranch_execz .LBB1_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1264-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mul_i32 s2, s8, s2
; GFX1264-NEXT:    s_mov_b32 s14, -1
; GFX1264-NEXT:    v_mov_b32_e32 v1, s2
; GFX1264-NEXT:    s_mov_b32 s12, s6
; GFX1264-NEXT:    s_mov_b32 s13, s7
; GFX1264-NEXT:    buffer_atomic_add_u32 v1, off, s[12:15], null th:TH_ATOMIC_RETURN
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB1_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1264-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s6, -1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-NEXT:    v_mad_co_u64_u32 v[0:1], null, s8, v0, s[0:1]
; GFX1264-NEXT:    buffer_store_b32 v0, off, s[4:7], null
; GFX1264-NEXT:    s_nop 0
; GFX1264-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: add_i32_uniform:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_clause 0x1
; GFX1232-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1232-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX1232-NEXT:    s_mov_b32 s2, exec_lo
; GFX1232-NEXT:    s_mov_b32 s1, exec_lo
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1232-NEXT:    ; implicit-def: $vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1232-NEXT:    s_cbranch_execz .LBB1_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s2, s2
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mul_i32 s2, s0, s2
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    v_mov_b32_e32 v1, s2
; GFX1232-NEXT:    s_mov_b32 s8, s6
; GFX1232-NEXT:    s_mov_b32 s9, s7
; GFX1232-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB1_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s6, -1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_mad_co_u64_u32 v[0:1], null, s0, v0, s[2:3]
; GFX1232-NEXT:    buffer_store_b32 v0, off, s[4:7], null
; GFX1232-NEXT:    s_nop 0
; GFX1232-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw add ptr addrspace(1) %inout, i32 %additive syncscope("agent") acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i32_varying(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS-LABEL: add_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    s_mov_b32 s10, s6
; GFX7LESS-NEXT:    s_mov_b32 s11, s7
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:    s_mov_b32 s4, s0
; GFX7LESS-NEXT:    s_mov_b32 s5, s1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    s_mov_b32 s6, 0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_ff1_i32_b64 s4, s[2:3]
; GFX8-NEXT:    s_mov_b32 m0, s4
; GFX8-NEXT:    v_readlane_b32 s7, v0, s4
; GFX8-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX8-NEXT:    v_writelane_b32 v1, s6, m0
; GFX8-NEXT:    s_add_i32 s6, s6, s7
; GFX8-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[4:5]
; GFX8-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX8-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execz .LBB2_4
; GFX8-NEXT:  ; %bb.3:
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB2_4:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v1
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    s_mov_b32 s6, 0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s4, s[2:3]
; GFX9-NEXT:    s_mov_b32 m0, s4
; GFX9-NEXT:    v_readlane_b32 s7, v0, s4
; GFX9-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX9-NEXT:    v_writelane_b32 v1, s6, m0
; GFX9-NEXT:    s_add_i32 s6, s6, s7
; GFX9-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[4:5]
; GFX9-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB2_4
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB2_4:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_add_u32_e32 v0, s4, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    s_mov_b32 s6, 0
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s7, s[2:3]
; GFX1064-NEXT:    v_readlane_b32 s8, v0, s7
; GFX1064-NEXT:    s_lshl_b64 s[4:5], 1, s7
; GFX1064-NEXT:    v_writelane_b32 v1, s6, s7
; GFX1064-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[4:5]
; GFX1064-NEXT:    s_add_i32 s6, s6, s8
; GFX1064-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1064-NEXT:    s_cbranch_execz .LBB2_4
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  .LBB2_4:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_add_nc_u32_e32 v0, s2, v1
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032-NEXT:    s_mov_b32 s4, 0
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032-NEXT:    v_readlane_b32 s5, v0, s3
; GFX1032-NEXT:    s_lshl_b32 s6, 1, s3
; GFX1032-NEXT:    v_writelane_b32 v1, s4, s3
; GFX1032-NEXT:    s_andn2_b32 s2, s2, s6
; GFX1032-NEXT:    s_add_i32 s4, s4, s5
; GFX1032-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s5, exec_lo, s5
; GFX1032-NEXT:    s_cbranch_execz .LBB2_4
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    v_mov_b32_e32 v0, s4
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  .LBB2_4:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_add_nc_u32_e32 v0, s2, v1
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i32_varying:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b32 s6, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_ctz_i32_b64 s7, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_readlane_b32 s8, v0, s7
; GFX1164-NEXT:    s_lshl_b64 s[4:5], 1, s7
; GFX1164-NEXT:    v_writelane_b32 v1, s6, s7
; GFX1164-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[4:5]
; GFX1164-NEXT:    s_add_i32 s6, s6, s8
; GFX1164-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0
; GFX1164-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1164-NEXT:    s_cbranch_execz .LBB2_4
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mov_b32 s8, s2
; GFX1164-NEXT:    s_mov_b32 s9, s3
; GFX1164-NEXT:    buffer_atomic_add_u32 v0, off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:  .LBB2_4:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_nc_u32_e32 v0, s2, v1
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_nop 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i32_varying:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_readlane_b32 s5, v0, s3
; GFX1132-NEXT:    s_lshl_b32 s6, 1, s3
; GFX1132-NEXT:    v_writelane_b32 v1, s4, s3
; GFX1132-NEXT:    s_and_not1_b32 s2, s2, s6
; GFX1132-NEXT:    s_add_i32 s4, s4, s5
; GFX1132-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    ; implicit-def: $vgpr0
; GFX1132-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1132-NEXT:    s_xor_b32 s5, exec_lo, s5
; GFX1132-NEXT:    s_cbranch_execz .LBB2_4
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    v_mov_b32_e32 v0, s4
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_add_u32 v0, off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:  .LBB2_4:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_nc_u32_e32 v0, s2, v1
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_nop 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: add_i32_varying:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_mov_b64 s[2:3], exec
; GFX1264-NEXT:    s_mov_b32 s6, 0
; GFX1264-NEXT:    ; implicit-def: $vgpr1
; GFX1264-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1264-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-NEXT:    s_ctz_i32_b64 s7, s[2:3]
; GFX1264-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1264-NEXT:    v_readlane_b32 s8, v0, s7
; GFX1264-NEXT:    s_lshl_b64 s[4:5], 1, s7
; GFX1264-NEXT:    v_writelane_b32 v1, s6, s7
; GFX1264-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[4:5]
; GFX1264-NEXT:    s_add_co_i32 s6, s6, s8
; GFX1264-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1264-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1264-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1264-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1264-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1264-NEXT:    ; implicit-def: $vgpr0
; GFX1264-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1264-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1264-NEXT:    s_cbranch_execz .LBB2_4
; GFX1264-NEXT:  ; %bb.3:
; GFX1264-NEXT:    v_mov_b32_e32 v0, s6
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mov_b32 s8, s2
; GFX1264-NEXT:    s_mov_b32 s9, s3
; GFX1264-NEXT:    buffer_atomic_add_u32 v0, off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB2_4:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-NEXT:    v_add_nc_u32_e32 v0, s2, v1
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1264-NEXT:    s_nop 0
; GFX1264-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: add_i32_varying:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_mov_b32 s2, exec_lo
; GFX1232-NEXT:    s_mov_b32 s4, 0
; GFX1232-NEXT:    ; implicit-def: $vgpr1
; GFX1232-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1232-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1232-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1232-NEXT:    v_readlane_b32 s5, v0, s3
; GFX1232-NEXT:    s_lshl_b32 s6, 1, s3
; GFX1232-NEXT:    v_writelane_b32 v1, s4, s3
; GFX1232-NEXT:    s_and_not1_b32 s2, s2, s6
; GFX1232-NEXT:    s_add_co_i32 s4, s4, s5
; GFX1232-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1232-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1232-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1232-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1232-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1232-NEXT:    ; implicit-def: $vgpr0
; GFX1232-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1232-NEXT:    s_xor_b32 s5, exec_lo, s5
; GFX1232-NEXT:    s_cbranch_execz .LBB2_4
; GFX1232-NEXT:  ; %bb.3:
; GFX1232-NEXT:    v_mov_b32_e32 v0, s4
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mov_b32 s8, s2
; GFX1232-NEXT:    s_mov_b32 s9, s3
; GFX1232-NEXT:    buffer_atomic_add_u32 v0, off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB2_4:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_add_nc_u32_e32 v0, s2, v1
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1232-NEXT:    s_nop 0
; GFX1232-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1232-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw add ptr addrspace(1) %inout, i32 %lane  syncscope("agent") acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i64_constant(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS-LABEL: add_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB3_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_mul_i32 s6, s6, 5
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB3_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v1
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s5
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s4, v0
; GFX7LESS-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX89-LABEL: add_i64_constant:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX89-NEXT:    s_mov_b64 s[6:7], exec
; GFX89-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX89-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX89-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX89-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX89-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX89-NEXT:    s_cbranch_execz .LBB3_2
; GFX89-NEXT:  ; %bb.1:
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_mov_b32 s8, s2
; GFX89-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX89-NEXT:    s_mul_i32 s2, s2, 5
; GFX89-NEXT:    s_mov_b32 s11, 0xf000
; GFX89-NEXT:    s_mov_b32 s10, -1
; GFX89-NEXT:    s_mov_b32 s9, s3
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    v_mov_b32_e32 v1, 0
; GFX89-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    buffer_wbinvl1_vol
; GFX89-NEXT:  .LBB3_2:
; GFX89-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    v_readfirstlane_b32 s2, v0
; GFX89-NEXT:    v_readfirstlane_b32 s3, v1
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    v_mov_b32_e32 v1, s3
; GFX89-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v2, 5, v[0:1]
; GFX89-NEXT:    s_mov_b32 s3, 0xf000
; GFX89-NEXT:    s_mov_b32 s2, -1
; GFX89-NEXT:    s_nop 2
; GFX89-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX89-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB3_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_mul_i32 s6, s6, 5
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  .LBB3_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v2, 5, s[2:3]
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s5, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s5, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB3_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_mul_i32 s5, s5, 5
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    v_mov_b32_e32 v0, s5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  .LBB3_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s2, v2, 5, s[2:3]
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB3_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_mul_i32 s6, s6, 5
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mov_b32 s8, s2
; GFX1164-NEXT:    s_mov_b32 s9, s3
; GFX1164-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:  .LBB3_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u64_u32 v[0:1], null, v2, 5, s[2:3]
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_nop 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1132-NEXT:    s_mov_b32 s5, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s5, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB3_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_mul_i32 s5, s5, 5
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:  .LBB3_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u64_u32 v[0:1], null, v2, 5, s[2:3]
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_nop 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: add_i64_constant:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1264-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-NEXT:    s_mov_b32 s9, 0
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-NEXT:    s_mov_b64 s[4:5], exec
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1264-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1264-NEXT:    s_cbranch_execz .LBB3_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s8, s[6:7]
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    s_mul_u64 s[6:7], s[8:9], 5
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    v_mov_b32_e32 v0, s6
; GFX1264-NEXT:    v_mov_b32_e32 v1, s7
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mov_b32 s8, s2
; GFX1264-NEXT:    s_mov_b32 s9, s3
; GFX1264-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB3_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-NEXT:    v_mad_co_u64_u32 v[0:1], null, v2, 5, s[2:3]
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1264-NEXT:    s_nop 0
; GFX1264-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: add_i64_constant:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1232-NEXT:    s_mov_b32 s4, exec_lo
; GFX1232-NEXT:    s_mov_b32 s5, 0
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v2, s4, 0
; GFX1232-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1232-NEXT:    s_cbranch_execz .LBB3_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s4, s4
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_mul_u64 s[4:5], s[4:5], 5
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mov_b32 s8, s2
; GFX1232-NEXT:    s_mov_b32 s9, s3
; GFX1232-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB3_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s6
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_mad_co_u64_u32 v[0:1], null, v2, 5, s[2:3]
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1232-NEXT:    s_nop 0
; GFX1232-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw add ptr addrspace(1) %inout, i64 5  syncscope("agent") acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i64_uniform(ptr addrspace(1) %out, ptr addrspace(1) %inout, i64 %additive) {
; GFX7LESS-LABEL: add_i64_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[8:9], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s8, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s9, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB4_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s12, s6
; GFX7LESS-NEXT:    s_mov_b32 s13, s7
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[8:9]
; GFX7LESS-NEXT:    s_mul_i32 s7, s1, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    v_mul_hi_u32 v0, s0, v0
; GFX7LESS-NEXT:    s_mul_i32 s6, s0, s6
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, s7, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[12:15], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB4_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s2, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s3, v1
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s1, v2
; GFX7LESS-NEXT:    v_mul_hi_u32 v1, s0, v2
; GFX7LESS-NEXT:    v_mul_lo_u32 v2, s0, v2
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s3
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; GFX7LESS-NEXT:    v_addc_u32_e32 v1, vcc, v3, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i64_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    s_mov_b64 s[8:9], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB4_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s12, s6
; GFX8-NEXT:    s_bcnt1_i32_b64 s6, s[8:9]
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[8:9], s0, v0, 0
; GFX8-NEXT:    s_mul_i32 s6, s1, s6
; GFX8-NEXT:    s_mov_b32 s15, 0xf000
; GFX8-NEXT:    s_mov_b32 s14, -1
; GFX8-NEXT:    s_mov_b32 s13, s7
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, s6, v1
; GFX8-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[12:15], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB4_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_readfirstlane_b32 s3, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v3, s1, v2
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], s0, v2, v[0:1]
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i64_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[8:9], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB4_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_bcnt1_i32_b64 s6, s[8:9]
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    s_mul_i32 s7, s3, s6
; GFX9-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX9-NEXT:    s_add_i32 s8, s8, s7
; GFX9-NEXT:    s_mul_i32 s6, s2, s6
; GFX9-NEXT:    s_mov_b32 s15, 0xf000
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB4_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], s2, v2, v[0:1]
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_mad_u64_u32 v[1:2], s[0:1], s3, v2, v[1:2]
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i64_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1064-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX1064-NEXT:    s_mov_b64 s[8:9], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB4_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s8, s[8:9]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s9, s3, s8
; GFX1064-NEXT:    s_mul_hi_u32 s10, s2, s8
; GFX1064-NEXT:    s_mul_i32 s8, s2, s8
; GFX1064-NEXT:    s_add_i32 s10, s10, s9
; GFX1064-NEXT:    v_mov_b32_e32 v0, s8
; GFX1064-NEXT:    v_mov_b32_e32 v1, s10
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_mov_b32 s8, s6
; GFX1064-NEXT:    s_mov_b32 s9, s7
; GFX1064-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  .LBB4_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s1, v1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[0:1], s2, v2, s[0:1]
; GFX1064-NEXT:    v_mad_u64_u32 v[1:2], s[0:1], s3, v2, v[1:2]
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i64_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1032-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX1032-NEXT:    s_mov_b32 s8, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s8, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB4_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s8
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s8, s3, s1
; GFX1032-NEXT:    s_mul_hi_u32 s9, s2, s1
; GFX1032-NEXT:    s_mul_i32 s1, s2, s1
; GFX1032-NEXT:    s_add_i32 s9, s9, s8
; GFX1032-NEXT:    v_mov_b32_e32 v0, s1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s9
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_mov_b32 s8, s6
; GFX1032-NEXT:    s_mov_b32 s9, s7
; GFX1032-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  .LBB4_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s1, v1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s0, s2, v2, s[0:1]
; GFX1032-NEXT:    v_mad_u64_u32 v[1:2], s0, s3, v2, v[1:2]
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i64_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX1164-NEXT:    s_mov_b64 s[8:9], exec
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB4_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s8, s[8:9]
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s9, s1, s8
; GFX1164-NEXT:    s_mul_hi_u32 s10, s0, s8
; GFX1164-NEXT:    s_mul_i32 s8, s0, s8
; GFX1164-NEXT:    s_add_i32 s10, s10, s9
; GFX1164-NEXT:    v_mov_b32_e32 v0, s8
; GFX1164-NEXT:    v_mov_b32_e32 v1, s10
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    s_mov_b32 s8, s6
; GFX1164-NEXT:    s_mov_b32 s9, s7
; GFX1164-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:  .LBB4_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s6, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u64_u32 v[0:1], null, s0, v2, s[2:3]
; GFX1164-NEXT:    v_mad_u64_u32 v[3:4], null, s1, v2, v[1:2]
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v1, v3
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX1164-NEXT:    s_nop 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i64_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX1132-NEXT:    s_mov_b32 s3, exec_lo
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s3, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB4_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s8, s1, s3
; GFX1132-NEXT:    s_mul_hi_u32 s9, s0, s3
; GFX1132-NEXT:    s_mul_i32 s3, s0, s3
; GFX1132-NEXT:    s_add_i32 s9, s9, s8
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, s3 :: v_dual_mov_b32 v1, s9
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    s_mov_b32 s8, s6
; GFX1132-NEXT:    s_mov_b32 s9, s7
; GFX1132-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:  .LBB4_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s6, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u64_u32 v[0:1], null, s0, v2, s[2:3]
; GFX1132-NEXT:    v_mad_u64_u32 v[3:4], null, s1, v2, v[1:2]
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v1, v3
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX1132-NEXT:    s_nop 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: add_i64_uniform:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_clause 0x1
; GFX1264-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1264-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX1264-NEXT:    s_mov_b64 s[8:9], exec
; GFX1264-NEXT:    s_mov_b32 s11, 0
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1264-NEXT:    s_mov_b64 s[2:3], exec
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX1264-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1264-NEXT:    s_cbranch_execz .LBB4_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s10, s[8:9]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mul_u64 s[8:9], s[0:1], s[10:11]
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    v_mov_b32_e32 v0, s8
; GFX1264-NEXT:    v_mov_b32_e32 v1, s9
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    s_mov_b32 s8, s6
; GFX1264-NEXT:    s_mov_b32 s9, s7
; GFX1264-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB4_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s6, -1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mad_co_u64_u32 v[0:1], null, s0, v2, s[2:3]
; GFX1264-NEXT:    v_mad_co_u64_u32 v[1:2], null, s1, v2, v[1:2]
; GFX1264-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], null
; GFX1264-NEXT:    s_nop 0
; GFX1264-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: add_i64_uniform:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_clause 0x1
; GFX1232-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1232-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX1232-NEXT:    s_mov_b32 s2, exec_lo
; GFX1232-NEXT:    s_mov_b32 s3, 0
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v2, s2, 0
; GFX1232-NEXT:    s_mov_b32 s8, exec_lo
; GFX1232-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1232-NEXT:    s_cbranch_execz .LBB4_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s2, s2
; GFX1232-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mul_u64 s[2:3], s[0:1], s[2:3]
; GFX1232-NEXT:    s_mov_b32 s14, -1
; GFX1232-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX1232-NEXT:    s_mov_b32 s12, s6
; GFX1232-NEXT:    s_mov_b32 s13, s7
; GFX1232-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[12:15], null th:TH_ATOMIC_RETURN
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB4_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s6, -1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-NEXT:    v_mad_co_u64_u32 v[0:1], null, s0, v2, s[2:3]
; GFX1232-NEXT:    v_mad_co_u64_u32 v[1:2], null, s1, v2, v[1:2]
; GFX1232-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], null
; GFX1232-NEXT:    s_nop 0
; GFX1232-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw add ptr addrspace(1) %inout, i64 %additive  syncscope("agent") acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i64_varying(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS-LABEL: add_i64_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 s10, s6
; GFX7LESS-NEXT:    s_mov_b32 s11, s7
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:    s_mov_b32 s4, s0
; GFX7LESS-NEXT:    s_mov_b32 s5, s1
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX89-LABEL: add_i64_varying:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX89-NEXT:    s_mov_b32 s7, 0xf000
; GFX89-NEXT:    s_mov_b32 s6, -1
; GFX89-NEXT:    s_mov_b32 s10, s6
; GFX89-NEXT:    s_mov_b32 s11, s7
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_mov_b32 s8, s2
; GFX89-NEXT:    s_mov_b32 s9, s3
; GFX89-NEXT:    v_mov_b32_e32 v1, 0
; GFX89-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    buffer_wbinvl1_vol
; GFX89-NEXT:    s_mov_b32 s4, s0
; GFX89-NEXT:    s_mov_b32 s5, s1
; GFX89-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX89-NEXT:    s_endpgm
;
; GFX10-LABEL: add_i64_varying:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s8, s2
; GFX10-NEXT:    s_mov_b32 s9, s3
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: add_i64_varying:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s11, s7
; GFX11-NEXT:    s_mov_b32 s10, s6
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s2
; GFX11-NEXT:    s_mov_b32 s9, s3
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], 0 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: add_i64_varying:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-NEXT:    s_mov_b32 s7, 0x31016000
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    s_mov_b32 s11, s7
; GFX12-NEXT:    s_mov_b32 s10, s6
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s8, s2
; GFX12-NEXT:    s_mov_b32 s9, s3
; GFX12-NEXT:    s_mov_b32 s4, s0
; GFX12-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_mov_b32 s5, s1
; GFX12-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], null
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %zext = zext i32 %lane to i64
  %old = atomicrmw add ptr addrspace(1) %inout, i64 %zext syncscope("agent") acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i32_constant(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS-LABEL: sub_i32_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB6_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_mul_i32 s6, s6, 5
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB6_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s4, v0
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB6_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB6_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s4, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB6_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB6_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_sub_u32_e32 v0, s4, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB6_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_mul_i32 s6, s6, 5
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s6
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  .LBB6_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s5, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s5, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB6_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_mul_i32 s5, s5, 5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s5
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  .LBB6_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i32_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB6_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    s_mul_i32 s6, s6, 5
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    v_mov_b32_e32 v1, s6
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mov_b32 s8, s2
; GFX1164-NEXT:    s_mov_b32 s9, s3
; GFX1164-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:  .LBB6_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_nop 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i32_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1132-NEXT:    s_mov_b32 s5, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s5, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB6_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_mul_i32 s5, s5, 5
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    v_mov_b32_e32 v1, s5
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:  .LBB6_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_nop 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: sub_i32_constant:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1264-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-NEXT:    s_mov_b64 s[4:5], exec
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-NEXT:    ; implicit-def: $vgpr1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1264-NEXT:    s_cbranch_execz .LBB6_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    s_mul_i32 s6, s6, 5
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    v_mov_b32_e32 v1, s6
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mov_b32 s8, s2
; GFX1264-NEXT:    s_mov_b32 s9, s3
; GFX1264-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB6_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1264-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1264-NEXT:    s_nop 0
; GFX1264-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: sub_i32_constant:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1232-NEXT:    s_mov_b32 s5, exec_lo
; GFX1232-NEXT:    s_mov_b32 s4, exec_lo
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v0, s5, 0
; GFX1232-NEXT:    ; implicit-def: $vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1232-NEXT:    s_cbranch_execz .LBB6_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_mul_i32 s5, s5, 5
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    v_mov_b32_e32 v1, s5
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mov_b32 s8, s2
; GFX1232-NEXT:    s_mov_b32 s9, s3
; GFX1232-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB6_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1232-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1232-NEXT:    s_nop 0
; GFX1232-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub ptr addrspace(1) %inout, i32 5 syncscope("agent") acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i32_uniform(ptr addrspace(1) %out, ptr addrspace(1) %inout, i32 %subitive) {
; GFX7LESS-LABEL: sub_i32_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7LESS-NEXT:    s_load_dword s8, s[0:1], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB7_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s2, s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_mov_b32 s12, s6
; GFX7LESS-NEXT:    s_mov_b32 s13, s7
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-NEXT:    buffer_atomic_sub v1, off, s[12:15], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB7_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s0, v1
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s0, v0
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB7_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mul_i32 s2, s8, s2
; GFX8-NEXT:    s_mov_b32 s15, 0xf000
; GFX8-NEXT:    s_mov_b32 s14, -1
; GFX8-NEXT:    s_mov_b32 s12, s6
; GFX8-NEXT:    s_mov_b32 s13, s7
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    buffer_atomic_sub v1, off, s[12:15], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB7_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v1
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB7_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s2, s8, s2
; GFX9-NEXT:    s_mov_b32 s15, 0xf000
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    buffer_atomic_sub v1, off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB7_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v1
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_sub_u32_e32 v0, s0, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1064-NEXT:    s_load_dword s8, s[0:1], 0x34
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB7_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s2, s8, s2
; GFX1064-NEXT:    s_mov_b32 s14, -1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s2
; GFX1064-NEXT:    s_mov_b32 s12, s6
; GFX1064-NEXT:    s_mov_b32 s13, s7
; GFX1064-NEXT:    buffer_atomic_sub v1, off, s[12:15], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  .LBB7_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1064-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1032-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB7_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s3
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s1, s2, s1
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s1
; GFX1032-NEXT:    s_mov_b32 s8, s6
; GFX1032-NEXT:    s_mov_b32 s9, s7
; GFX1032-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  .LBB7_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mul_lo_u32 v0, s2, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1032-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i32_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1164-NEXT:    s_load_b32 s8, s[0:1], 0x34
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB7_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1164-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s2, s8, s2
; GFX1164-NEXT:    s_mov_b32 s14, -1
; GFX1164-NEXT:    v_mov_b32_e32 v1, s2
; GFX1164-NEXT:    s_mov_b32 s12, s6
; GFX1164-NEXT:    s_mov_b32 s13, s7
; GFX1164-NEXT:    buffer_atomic_sub_u32 v1, off, s[12:15], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:  .LBB7_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1164-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s6, -1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX1164-NEXT:    s_nop 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i32_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1132-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB7_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s2, s2
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s2, s0, s2
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    v_mov_b32_e32 v1, s2
; GFX1132-NEXT:    s_mov_b32 s8, s6
; GFX1132-NEXT:    s_mov_b32 s9, s7
; GFX1132-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:  .LBB7_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1132-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s6, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX1132-NEXT:    s_nop 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: sub_i32_uniform:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_clause 0x1
; GFX1264-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1264-NEXT:    s_load_b32 s8, s[0:1], 0x34
; GFX1264-NEXT:    s_mov_b64 s[2:3], exec
; GFX1264-NEXT:    s_mov_b64 s[0:1], exec
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1264-NEXT:    ; implicit-def: $vgpr1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1264-NEXT:    s_cbranch_execz .LBB7_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1264-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mul_i32 s2, s8, s2
; GFX1264-NEXT:    s_mov_b32 s14, -1
; GFX1264-NEXT:    v_mov_b32_e32 v1, s2
; GFX1264-NEXT:    s_mov_b32 s12, s6
; GFX1264-NEXT:    s_mov_b32 s13, s7
; GFX1264-NEXT:    buffer_atomic_sub_u32 v1, off, s[12:15], null th:TH_ATOMIC_RETURN
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB7_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX1264-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1264-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s6, -1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1264-NEXT:    buffer_store_b32 v0, off, s[4:7], null
; GFX1264-NEXT:    s_nop 0
; GFX1264-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: sub_i32_uniform:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_clause 0x1
; GFX1232-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1232-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX1232-NEXT:    s_mov_b32 s2, exec_lo
; GFX1232-NEXT:    s_mov_b32 s1, exec_lo
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1232-NEXT:    ; implicit-def: $vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1232-NEXT:    s_cbranch_execz .LBB7_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s2, s2
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mul_i32 s2, s0, s2
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    v_mov_b32_e32 v1, s2
; GFX1232-NEXT:    s_mov_b32 s8, s6
; GFX1232-NEXT:    s_mov_b32 s9, s7
; GFX1232-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB7_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_mul_lo_u32 v0, s0, v0
; GFX1232-NEXT:    v_readfirstlane_b32 s0, v1
; GFX1232-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s6, -1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1232-NEXT:    buffer_store_b32 v0, off, s[4:7], null
; GFX1232-NEXT:    s_nop 0
; GFX1232-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub ptr addrspace(1) %inout, i32 %subitive syncscope("agent") acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i32_varying(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS-LABEL: sub_i32_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    s_mov_b32 s10, s6
; GFX7LESS-NEXT:    s_mov_b32 s11, s7
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:    s_mov_b32 s4, s0
; GFX7LESS-NEXT:    s_mov_b32 s5, s1
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_varying:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_mov_b64 s[2:3], exec
; GFX8-NEXT:    s_mov_b32 s6, 0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_ff1_i32_b64 s4, s[2:3]
; GFX8-NEXT:    s_mov_b32 m0, s4
; GFX8-NEXT:    v_readlane_b32 s7, v0, s4
; GFX8-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX8-NEXT:    v_writelane_b32 v1, s6, m0
; GFX8-NEXT:    s_add_i32 s6, s6, s7
; GFX8-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[4:5]
; GFX8-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX8-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execz .LBB8_4
; GFX8-NEXT:  ; %bb.3:
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB8_4:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s4, v1
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_varying:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    s_mov_b32 s6, 0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s4, s[2:3]
; GFX9-NEXT:    s_mov_b32 m0, s4
; GFX9-NEXT:    v_readlane_b32 s7, v0, s4
; GFX9-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX9-NEXT:    v_writelane_b32 v1, s6, m0
; GFX9-NEXT:    s_add_i32 s6, s6, s7
; GFX9-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[4:5]
; GFX9-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB8_4
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB8_4:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_sub_u32_e32 v0, s4, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_varying:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    s_mov_b32 s6, 0
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s7, s[2:3]
; GFX1064-NEXT:    v_readlane_b32 s8, v0, s7
; GFX1064-NEXT:    s_lshl_b64 s[4:5], 1, s7
; GFX1064-NEXT:    v_writelane_b32 v1, s6, s7
; GFX1064-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[4:5]
; GFX1064-NEXT:    s_add_i32 s6, s6, s8
; GFX1064-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1064-NEXT:    s_cbranch_execz .LBB8_4
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  .LBB8_4:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s2, v1
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_varying:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032-NEXT:    s_mov_b32 s4, 0
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032-NEXT:    v_readlane_b32 s5, v0, s3
; GFX1032-NEXT:    s_lshl_b32 s6, 1, s3
; GFX1032-NEXT:    v_writelane_b32 v1, s4, s3
; GFX1032-NEXT:    s_andn2_b32 s2, s2, s6
; GFX1032-NEXT:    s_add_i32 s4, s4, s5
; GFX1032-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s5, exec_lo, s5
; GFX1032-NEXT:    s_cbranch_execz .LBB8_4
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    v_mov_b32_e32 v0, s4
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  .LBB8_4:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s2, v1
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i32_varying:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    s_mov_b32 s6, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_ctz_i32_b64 s7, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_readlane_b32 s8, v0, s7
; GFX1164-NEXT:    s_lshl_b64 s[4:5], 1, s7
; GFX1164-NEXT:    v_writelane_b32 v1, s6, s7
; GFX1164-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[4:5]
; GFX1164-NEXT:    s_add_i32 s6, s6, s8
; GFX1164-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0
; GFX1164-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1164-NEXT:    s_cbranch_execz .LBB8_4
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mov_b32 s8, s2
; GFX1164-NEXT:    s_mov_b32 s9, s3
; GFX1164-NEXT:    buffer_atomic_sub_u32 v0, off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:  .LBB8_4:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_sub_nc_u32_e32 v0, s2, v1
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_nop 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i32_varying:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_readlane_b32 s5, v0, s3
; GFX1132-NEXT:    s_lshl_b32 s6, 1, s3
; GFX1132-NEXT:    v_writelane_b32 v1, s4, s3
; GFX1132-NEXT:    s_and_not1_b32 s2, s2, s6
; GFX1132-NEXT:    s_add_i32 s4, s4, s5
; GFX1132-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-NEXT:    ; implicit-def: $vgpr0
; GFX1132-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1132-NEXT:    s_xor_b32 s5, exec_lo, s5
; GFX1132-NEXT:    s_cbranch_execz .LBB8_4
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    v_mov_b32_e32 v0, s4
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_sub_u32 v0, off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:  .LBB8_4:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_sub_nc_u32_e32 v0, s2, v1
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_nop 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: sub_i32_varying:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_mov_b64 s[2:3], exec
; GFX1264-NEXT:    s_mov_b32 s6, 0
; GFX1264-NEXT:    ; implicit-def: $vgpr1
; GFX1264-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1264-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-NEXT:    s_ctz_i32_b64 s7, s[2:3]
; GFX1264-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1264-NEXT:    v_readlane_b32 s8, v0, s7
; GFX1264-NEXT:    s_lshl_b64 s[4:5], 1, s7
; GFX1264-NEXT:    v_writelane_b32 v1, s6, s7
; GFX1264-NEXT:    s_and_not1_b64 s[2:3], s[2:3], s[4:5]
; GFX1264-NEXT:    s_add_co_i32 s6, s6, s8
; GFX1264-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1264-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1264-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1264-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1264-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1264-NEXT:    ; implicit-def: $vgpr0
; GFX1264-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1264-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1264-NEXT:    s_cbranch_execz .LBB8_4
; GFX1264-NEXT:  ; %bb.3:
; GFX1264-NEXT:    v_mov_b32_e32 v0, s6
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mov_b32 s8, s2
; GFX1264-NEXT:    s_mov_b32 s9, s3
; GFX1264-NEXT:    buffer_atomic_sub_u32 v0, off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB8_4:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-NEXT:    v_sub_nc_u32_e32 v0, s2, v1
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1264-NEXT:    s_nop 0
; GFX1264-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: sub_i32_varying:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_mov_b32 s2, exec_lo
; GFX1232-NEXT:    s_mov_b32 s4, 0
; GFX1232-NEXT:    ; implicit-def: $vgpr1
; GFX1232-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1232-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1232-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1232-NEXT:    v_readlane_b32 s5, v0, s3
; GFX1232-NEXT:    s_lshl_b32 s6, 1, s3
; GFX1232-NEXT:    v_writelane_b32 v1, s4, s3
; GFX1232-NEXT:    s_and_not1_b32 s2, s2, s6
; GFX1232-NEXT:    s_add_co_i32 s4, s4, s5
; GFX1232-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1232-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1232-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1232-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1232-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1232-NEXT:    ; implicit-def: $vgpr0
; GFX1232-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1232-NEXT:    s_xor_b32 s5, exec_lo, s5
; GFX1232-NEXT:    s_cbranch_execz .LBB8_4
; GFX1232-NEXT:  ; %bb.3:
; GFX1232-NEXT:    v_mov_b32_e32 v0, s4
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mov_b32 s8, s2
; GFX1232-NEXT:    s_mov_b32 s9, s3
; GFX1232-NEXT:    buffer_atomic_sub_u32 v0, off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB8_4:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_sub_nc_u32_e32 v0, s2, v1
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1232-NEXT:    s_nop 0
; GFX1232-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1232-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw sub ptr addrspace(1) %inout, i32 %lane syncscope("agent") acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i64_constant(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS-LABEL: sub_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB9_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_mul_i32 s6, s6, 5
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB9_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v1
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s5
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s4, v0
; GFX7LESS-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB9_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB9_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_readfirstlane_b32 s5, v1
; GFX8-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX8-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, s5
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s4, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB9_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB9_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_readfirstlane_b32 s5, v1
; GFX9-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX9-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, s4, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB9_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_mul_i32 s6, s6, 5
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  .LBB9_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1064-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1064-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s3, v1, vcc
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX1032-NEXT:    s_mov_b32 s5, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s5, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB9_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_mul_i32 s5, s5, 5
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    v_mov_b32_e32 v0, s5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  .LBB9_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1032-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1032-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s3, v1, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB9_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_mul_i32 s6, s6, 5
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mov_b32 s8, s2
; GFX1164-NEXT:    s_mov_b32 s9, s3
; GFX1164-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:  .LBB9_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1164-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s3, v1, vcc
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_nop 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1132-NEXT:    s_mov_b32 s5, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s5, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB9_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s5, s5
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_mul_i32 s5, s5, 5
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:  .LBB9_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1132-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s3, v1, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_nop 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: sub_i64_constant:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1264-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-NEXT:    s_mov_b32 s9, 0
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-NEXT:    s_mov_b64 s[4:5], exec
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1264-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1264-NEXT:    s_cbranch_execz .LBB9_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s8, s[6:7]
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    s_mul_u64 s[6:7], s[8:9], 5
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    v_mov_b32_e32 v0, s6
; GFX1264-NEXT:    v_mov_b32_e32 v1, s7
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mov_b32 s8, s2
; GFX1264-NEXT:    s_mov_b32 s9, s3
; GFX1264-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB9_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1264-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1264-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1264-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1264-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s3, v1, vcc
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1264-NEXT:    s_nop 0
; GFX1264-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: sub_i64_constant:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX1232-NEXT:    s_mov_b32 s4, exec_lo
; GFX1232-NEXT:    s_mov_b32 s5, 0
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v2, s4, 0
; GFX1232-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1232-NEXT:    s_cbranch_execz .LBB9_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s4, s4
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_mul_u64 s[4:5], s[4:5], 5
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mov_b32 s8, s2
; GFX1232-NEXT:    s_mov_b32 s9, s3
; GFX1232-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB9_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s6
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1232-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1232-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1232-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1232-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s3, v1, vcc_lo
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1232-NEXT:    s_nop 0
; GFX1232-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub ptr addrspace(1) %inout, i64 5 syncscope("agent") acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i64_uniform(ptr addrspace(1) %out, ptr addrspace(1) %inout, i64 %subitive) {
; GFX7LESS-LABEL: sub_i64_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[8:9], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s8, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s9, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB10_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s12, s6
; GFX7LESS-NEXT:    s_mov_b32 s13, s7
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[8:9]
; GFX7LESS-NEXT:    s_mul_i32 s7, s1, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    v_mul_hi_u32 v0, s0, v0
; GFX7LESS-NEXT:    s_mul_i32 s6, s0, s6
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, s7, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[12:15], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB10_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s2, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s3, v1
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s1, v2
; GFX7LESS-NEXT:    v_mul_hi_u32 v1, s0, v2
; GFX7LESS-NEXT:    v_mul_lo_u32 v2, s0, v2
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s3
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s2, v2
; GFX7LESS-NEXT:    v_subb_u32_e32 v1, vcc, v3, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i64_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    s_mov_b64 s[8:9], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB10_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s12, s6
; GFX8-NEXT:    s_bcnt1_i32_b64 s6, s[8:9]
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[8:9], s0, v0, 0
; GFX8-NEXT:    s_mul_i32 s6, s1, s6
; GFX8-NEXT:    s_mov_b32 s15, 0xf000
; GFX8-NEXT:    s_mov_b32 s14, -1
; GFX8-NEXT:    s_mov_b32 s13, s7
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, s6, v1
; GFX8-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[12:15], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB10_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v4, s1, v2
; GFX8-NEXT:    v_mad_u64_u32 v[2:3], s[0:1], s0, v2, 0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v3, v4
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    v_subb_u32_e32 v1, vcc, v3, v1, vcc
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i64_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    s_mov_b64 s[8:9], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB10_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s6
; GFX9-NEXT:    s_bcnt1_i32_b64 s6, s[8:9]
; GFX9-NEXT:    s_mov_b32 s13, s7
; GFX9-NEXT:    s_mul_i32 s7, s3, s6
; GFX9-NEXT:    s_mul_hi_u32 s8, s2, s6
; GFX9-NEXT:    s_add_i32 s8, s8, s7
; GFX9-NEXT:    s_mul_i32 s6, s2, s6
; GFX9-NEXT:    s_mov_b32 s15, 0xf000
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB10_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], s2, v2, 0
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    v_mad_u64_u32 v[4:5], s[0:1], s3, v2, v[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_mov_b32_e32 v1, v4
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, s0, v3
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i64_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1064-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX1064-NEXT:    s_mov_b64 s[8:9], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB10_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s8, s[8:9]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s9, s3, s8
; GFX1064-NEXT:    s_mul_hi_u32 s10, s2, s8
; GFX1064-NEXT:    s_mul_i32 s8, s2, s8
; GFX1064-NEXT:    s_add_i32 s10, s10, s9
; GFX1064-NEXT:    v_mov_b32_e32 v0, s8
; GFX1064-NEXT:    v_mov_b32_e32 v1, s10
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_mov_b32 s8, s6
; GFX1064-NEXT:    s_mov_b32 s9, s7
; GFX1064-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:  .LBB10_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mad_u64_u32 v[3:4], s[0:1], s2, v2, 0
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    v_mad_u64_u32 v[4:5], s[0:1], s3, v2, v[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s1, v1
; GFX1064-NEXT:    v_sub_co_u32 v0, vcc, s0, v3
; GFX1064-NEXT:    v_mov_b32_e32 v1, v4
; GFX1064-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s1, v1, vcc
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i64_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX1032-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX1032-NEXT:    s_mov_b32 s8, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s8, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB10_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s1, s8
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s8, s3, s1
; GFX1032-NEXT:    s_mul_hi_u32 s9, s2, s1
; GFX1032-NEXT:    s_mul_i32 s1, s2, s1
; GFX1032-NEXT:    s_add_i32 s9, s9, s8
; GFX1032-NEXT:    v_mov_b32_e32 v0, s1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s9
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_mov_b32 s8, s6
; GFX1032-NEXT:    s_mov_b32 s9, s7
; GFX1032-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:  .LBB10_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mad_u64_u32 v[3:4], s0, s2, v2, 0
; GFX1032-NEXT:    v_readfirstlane_b32 s1, v1
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    v_mad_u64_u32 v[4:5], s0, s3, v2, v[4:5]
; GFX1032-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1032-NEXT:    v_sub_co_u32 v0, vcc_lo, s0, v3
; GFX1032-NEXT:    v_mov_b32_e32 v1, v4
; GFX1032-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s1, v1, vcc_lo
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i64_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX1164-NEXT:    s_mov_b64 s[8:9], exec
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB10_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s8, s[8:9]
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s9, s1, s8
; GFX1164-NEXT:    s_mul_hi_u32 s10, s0, s8
; GFX1164-NEXT:    s_mul_i32 s8, s0, s8
; GFX1164-NEXT:    s_add_i32 s10, s10, s9
; GFX1164-NEXT:    v_mov_b32_e32 v0, s8
; GFX1164-NEXT:    v_mov_b32_e32 v1, s10
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    s_mov_b32 s8, s6
; GFX1164-NEXT:    s_mov_b32 s9, s7
; GFX1164-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:  .LBB10_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mad_u64_u32 v[3:4], null, s0, v2, 0
; GFX1164-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1164-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s6, -1
; GFX1164-NEXT:    s_waitcnt_depctr 0xfff
; GFX1164-NEXT:    v_mad_u64_u32 v[5:6], null, s1, v2, v[4:5]
; GFX1164-NEXT:    v_readfirstlane_b32 s1, v1
; GFX1164-NEXT:    v_sub_co_u32 v0, vcc, s0, v3
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mov_b32_e32 v1, v5
; GFX1164-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s1, v1, vcc
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX1164-NEXT:    s_nop 0
; GFX1164-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i64_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX1132-NEXT:    s_mov_b32 s3, exec_lo
; GFX1132-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s3, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB10_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s8, s1, s3
; GFX1132-NEXT:    s_mul_hi_u32 s9, s0, s3
; GFX1132-NEXT:    s_mul_i32 s3, s0, s3
; GFX1132-NEXT:    s_add_i32 s9, s9, s8
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, s3 :: v_dual_mov_b32 v1, s9
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    s_mov_b32 s8, s6
; GFX1132-NEXT:    s_mov_b32 s9, s7
; GFX1132-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:  .LBB10_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_mad_u64_u32 v[3:4], null, s0, v2, 0
; GFX1132-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1132-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s6, -1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX1132-NEXT:    v_mad_u64_u32 v[5:6], null, s1, v2, v[4:5]
; GFX1132-NEXT:    v_readfirstlane_b32 s1, v1
; GFX1132-NEXT:    v_sub_co_u32 v0, vcc_lo, s0, v3
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mov_b32_e32 v1, v5
; GFX1132-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s1, v1, vcc_lo
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX1132-NEXT:    s_nop 0
; GFX1132-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: sub_i64_uniform:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_clause 0x1
; GFX1264-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1264-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX1264-NEXT:    s_mov_b64 s[8:9], exec
; GFX1264-NEXT:    s_mov_b32 s11, 0
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1264-NEXT:    s_mov_b64 s[2:3], exec
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX1264-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1264-NEXT:    s_cbranch_execz .LBB10_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s10, s[8:9]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mul_u64 s[8:9], s[0:1], s[10:11]
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    v_mov_b32_e32 v0, s8
; GFX1264-NEXT:    v_mov_b32_e32 v1, s9
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    s_mov_b32 s8, s6
; GFX1264-NEXT:    s_mov_b32 s9, s7
; GFX1264-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB10_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_mad_co_u64_u32 v[3:4], null, s0, v2, 0
; GFX1264-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1264-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s6, -1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX1264-NEXT:    v_mad_co_u64_u32 v[4:5], null, s1, v2, v[4:5]
; GFX1264-NEXT:    v_readfirstlane_b32 s1, v1
; GFX1264-NEXT:    v_sub_co_u32 v0, vcc, s0, v3
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mov_b32_e32 v1, v4
; GFX1264-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s1, v1, vcc
; GFX1264-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], null
; GFX1264-NEXT:    s_nop 0
; GFX1264-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: sub_i64_uniform:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_clause 0x1
; GFX1232-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX1232-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX1232-NEXT:    s_mov_b32 s2, exec_lo
; GFX1232-NEXT:    s_mov_b32 s3, 0
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v2, s2, 0
; GFX1232-NEXT:    s_mov_b32 s8, exec_lo
; GFX1232-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1232-NEXT:    s_cbranch_execz .LBB10_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s2, s2
; GFX1232-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mul_u64 s[2:3], s[0:1], s[2:3]
; GFX1232-NEXT:    s_mov_b32 s14, -1
; GFX1232-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX1232-NEXT:    s_mov_b32 s12, s6
; GFX1232-NEXT:    s_mov_b32 s13, s7
; GFX1232-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[12:15], null th:TH_ATOMIC_RETURN
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB10_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_mad_co_u64_u32 v[3:4], null, s0, v2, 0
; GFX1232-NEXT:    v_readfirstlane_b32 s0, v0
; GFX1232-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s6, -1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX1232-NEXT:    v_mad_co_u64_u32 v[4:5], null, s1, v2, v[4:5]
; GFX1232-NEXT:    v_readfirstlane_b32 s1, v1
; GFX1232-NEXT:    v_sub_co_u32 v0, vcc_lo, s0, v3
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-NEXT:    v_mov_b32_e32 v1, v4
; GFX1232-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s1, v1, vcc_lo
; GFX1232-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], null
; GFX1232-NEXT:    s_nop 0
; GFX1232-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub ptr addrspace(1) %inout, i64 %subitive syncscope("agent") acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i64_varying(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS-LABEL: sub_i64_varying:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    s_mov_b32 s10, s6
; GFX7LESS-NEXT:    s_mov_b32 s11, s7
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:    s_mov_b32 s4, s0
; GFX7LESS-NEXT:    s_mov_b32 s5, s1
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX89-LABEL: sub_i64_varying:
; GFX89:       ; %bb.0: ; %entry
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX89-NEXT:    s_mov_b32 s7, 0xf000
; GFX89-NEXT:    s_mov_b32 s6, -1
; GFX89-NEXT:    s_mov_b32 s10, s6
; GFX89-NEXT:    s_mov_b32 s11, s7
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_mov_b32 s8, s2
; GFX89-NEXT:    s_mov_b32 s9, s3
; GFX89-NEXT:    v_mov_b32_e32 v1, 0
; GFX89-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    buffer_wbinvl1_vol
; GFX89-NEXT:    s_mov_b32 s4, s0
; GFX89-NEXT:    s_mov_b32 s5, s1
; GFX89-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX89-NEXT:    s_endpgm
;
; GFX10-LABEL: sub_i64_varying:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_mov_b32 s7, 0x31016000
; GFX10-NEXT:    s_mov_b32 s6, -1
; GFX10-NEXT:    s_mov_b32 s11, s7
; GFX10-NEXT:    s_mov_b32 s10, s6
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s8, s2
; GFX10-NEXT:    s_mov_b32 s9, s3
; GFX10-NEXT:    s_mov_b32 s4, s0
; GFX10-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    s_mov_b32 s5, s1
; GFX10-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: sub_i64_varying:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s11, s7
; GFX11-NEXT:    s_mov_b32 s10, s6
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s2
; GFX11-NEXT:    s_mov_b32 s9, s3
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], 0 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: sub_i64_varying:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v1, 0
; GFX12-NEXT:    s_mov_b32 s7, 0x31016000
; GFX12-NEXT:    s_mov_b32 s6, -1
; GFX12-NEXT:    s_mov_b32 s11, s7
; GFX12-NEXT:    s_mov_b32 s10, s6
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s8, s2
; GFX12-NEXT:    s_mov_b32 s9, s3
; GFX12-NEXT:    s_mov_b32 s4, s0
; GFX12-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_mov_b32 s5, s1
; GFX12-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], null
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %zext = zext i32 %lane to i64
  %old = atomicrmw sub ptr addrspace(1) %inout, i64 %zext syncscope("agent") acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}
