/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.javax.crypto;

import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.provider.javax.crypto.JSSTokenKeyManager;
import org.mozilla.jss.util.Password;

public class JSSKeyManagerFactory
extends KeyManagerFactorySpi {
    private KeyStore internalStorage;
    char[] password;

    @Override
    protected void engineInit(KeyStore ks, char[] password) throws KeyStoreException {
        if (password != null) {
            this.engineInitCryptoManager(password);
            this.password = password;
        }
        if (ks != null) {
            this.engineInitKeyStore(ks);
        }
    }

    protected void engineInitCryptoManager(char[] password) throws KeyStoreException {
        try {
            CryptoManager cm = CryptoManager.getInstance();
            if (cm.getPasswordCallback() == null && password != null) {
                Password callback = new Password(password);
                cm.setPasswordCallback(callback);
            }
        }
        catch (Exception e) {
            throw new KeyStoreException(e.getMessage(), e);
        }
    }

    protected void engineInitKeyStore(KeyStore ks) throws KeyStoreException {
        try {
            if (!ks.getProvider().getName().equals("Mozilla-JSS")) {
                Object msg = "Unable to initialize JSSKeyManagerFactory ";
                msg = (String)msg + "with key store from non-JSS provider.";
                throw new KeyStoreException((String)msg);
            }
            this.internalStorage = ks;
        }
        catch (Exception e) {
            throw new KeyStoreException(e.getMessage(), e);
        }
    }

    @Override
    protected void engineInit(ManagerFactoryParameters spec) {
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        KeyManager[] kms = new KeyManager[]{new JSSTokenKeyManager(this.internalStorage, this.password)};
        return kms;
    }
}

