/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import org.mozilla.jss.netscape.security.pkcs.ContentInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.pkcs.PKCS9Attribute;
import org.mozilla.jss.netscape.security.pkcs.PKCS9Attributes;
import org.mozilla.jss.netscape.security.pkcs.ParsingException;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerEncoder;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.X500Name;

public class SignerInfo
implements DerEncoder {
    BigInt version;
    X500Name issuerName;
    BigInt certificateSerialNumber;
    AlgorithmId digestAlgorithmId;
    AlgorithmId digestEncryptionAlgorithmId;
    byte[] encryptedDigest;
    PKCS9Attributes authenticatedAttributes;
    PKCS9Attributes unauthenticatedAttributes;

    public SignerInfo(X500Name issuerName, BigInt serial, AlgorithmId digestAlgorithmId, AlgorithmId digestEncryptionAlgorithmId, byte[] encryptedDigest) {
        this.version = new BigInt(1);
        this.issuerName = issuerName;
        this.certificateSerialNumber = serial;
        this.digestAlgorithmId = digestAlgorithmId;
        this.digestEncryptionAlgorithmId = digestEncryptionAlgorithmId;
        this.encryptedDigest = encryptedDigest;
    }

    public SignerInfo(X500Name issuerName, BigInt serial, AlgorithmId digestAlgorithmId, PKCS9Attributes authenticatedAttributes, AlgorithmId digestEncryptionAlgorithmId, byte[] encryptedDigest, PKCS9Attributes unauthenticatedAttributes) {
        this.version = new BigInt(1);
        this.issuerName = issuerName;
        this.certificateSerialNumber = serial;
        this.digestAlgorithmId = digestAlgorithmId;
        this.authenticatedAttributes = authenticatedAttributes;
        this.digestEncryptionAlgorithmId = digestEncryptionAlgorithmId;
        this.encryptedDigest = encryptedDigest;
        this.unauthenticatedAttributes = unauthenticatedAttributes;
    }

    public SignerInfo(DerInputStream derin) throws IOException, ParsingException {
        this.version = derin.getInteger();
        DerValue[] issuerAndSerialNumber = derin.getSequence(2);
        byte[] issuerBytes = issuerAndSerialNumber[0].toByteArray();
        this.issuerName = new X500Name(new DerValue(48, issuerBytes));
        this.certificateSerialNumber = issuerAndSerialNumber[1].getInteger();
        DerValue tmp = derin.getDerValue();
        this.digestAlgorithmId = AlgorithmId.parse(tmp);
        if ((byte)derin.peekByte() == -96) {
            this.authenticatedAttributes = new PKCS9Attributes(derin);
        }
        tmp = derin.getDerValue();
        this.digestEncryptionAlgorithmId = AlgorithmId.parse(tmp);
        this.encryptedDigest = derin.getOctetString();
        if (derin.available() != 0 && (byte)derin.peekByte() == -95) {
            this.unauthenticatedAttributes = new PKCS9Attributes(derin);
        }
        if (derin.available() != 0) {
            throw new ParsingException("extra data at the end");
        }
    }

    public void encode(DerOutputStream out) throws IOException {
        this.derEncode(out);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        try (DerOutputStream tmp = new DerOutputStream();){
            DerOutputStream seq = new DerOutputStream();
            seq.putInteger(this.version);
            DerOutputStream issuerAndSerialNumber = new DerOutputStream();
            this.issuerName.encode(issuerAndSerialNumber);
            issuerAndSerialNumber.putInteger(this.certificateSerialNumber);
            seq.write((byte)48, issuerAndSerialNumber);
            this.digestAlgorithmId.encode(seq);
            if (this.authenticatedAttributes != null) {
                this.authenticatedAttributes.encode((byte)-96, seq);
            }
            this.digestEncryptionAlgorithmId.encode(seq);
            seq.putOctetString(this.encryptedDigest);
            if (this.unauthenticatedAttributes != null) {
                this.unauthenticatedAttributes.encode((byte)-95, seq);
            }
            tmp.write((byte)48, seq);
            out.write(tmp.toByteArray());
        }
    }

    public X509Certificate getCertificate(PKCS7 block) throws IOException {
        return block.getCertificate(this.certificateSerialNumber, this.issuerName);
    }

    SignerInfo verify(PKCS7 block, byte[] data) throws NoSuchAlgorithmException, SignatureException {
        try {
            byte[] dataSigned;
            ContentInfo content = block.getContentInfo();
            if (data == null) {
                data = content.getContentBytes();
            }
            String digestAlgname = this.getDigestAlgorithmId().getName();
            if (this.authenticatedAttributes == null) {
                dataSigned = data;
            } else {
                ObjectIdentifier contentType = (ObjectIdentifier)this.authenticatedAttributes.getAttributeValue(PKCS9Attribute.CONTENT_TYPE_OID);
                if (contentType == null || !contentType.equals(content.contentType)) {
                    return null;
                }
                byte[] messageDigest = (byte[])this.authenticatedAttributes.getAttributeValue(PKCS9Attribute.MESSAGE_DIGEST_OID);
                if (messageDigest == null) {
                    return null;
                }
                MessageDigest md = MessageDigest.getInstance(digestAlgname);
                byte[] computedMessageDigest = md.digest(data);
                if (messageDigest.length != computedMessageDigest.length) {
                    return null;
                }
                for (int i = 0; i < messageDigest.length; ++i) {
                    if (messageDigest[i] == computedMessageDigest[i]) continue;
                    return null;
                }
                dataSigned = this.authenticatedAttributes.getDerEncoding();
            }
            String encryptionAlgname = this.getDigestEncryptionAlgorithmId().getName();
            Object algname = encryptionAlgname.equals("DSA") || encryptionAlgname.equals("SHA1withDSA") ? "DSA" : digestAlgname + "/" + encryptionAlgname;
            Signature sig = Signature.getInstance((String)algname);
            X509Certificate cert = this.getCertificate(block);
            if (cert == null) {
                return null;
            }
            PublicKey key = cert.getPublicKey();
            sig.initVerify(key);
            sig.update(dataSigned);
            if (sig.verify(this.encryptedDigest)) {
                return this;
            }
        }
        catch (IOException e) {
            throw new SignatureException("IO error verifying signature:\n" + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new SignatureException("InvalidKey: " + e.getMessage());
        }
        return null;
    }

    SignerInfo verify(PKCS7 block) throws NoSuchAlgorithmException, SignatureException {
        return this.verify(block, null);
    }

    public BigInt getVersion() {
        return this.version;
    }

    public X500Name getIssuerName() {
        return this.issuerName;
    }

    public BigInt getCertificateSerialNumber() {
        return this.certificateSerialNumber;
    }

    public AlgorithmId getDigestAlgorithmId() {
        return this.digestAlgorithmId;
    }

    public PKCS9Attributes getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AlgorithmId getDigestEncryptionAlgorithmId() {
        return this.digestEncryptionAlgorithmId;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public PKCS9Attributes getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public String toString() {
        PrettyPrintFormat pp = new PrettyPrintFormat(" ", 20);
        String digestbits = pp.toHexString(this.encryptedDigest);
        Object out = "";
        out = (String)out + "Signer Info for (issuer): " + this.issuerName + "\n";
        out = (String)out + "\tversion: " + this.version + "\n";
        out = (String)out + "\tcertificateSerialNumber: " + this.certificateSerialNumber + "\n";
        out = (String)out + "\tdigestAlgorithmId: " + this.digestAlgorithmId + "\n";
        if (this.authenticatedAttributes != null) {
            out = (String)out + "\tauthenticatedAttributes: " + this.authenticatedAttributes + "\n";
        }
        out = (String)out + "\tdigestEncryptionAlgorithmId: " + this.digestEncryptionAlgorithmId + "\n";
        out = (String)out + "\tencryptedDigest: \n" + digestbits + "\n";
        if (this.unauthenticatedAttributes != null) {
            out = (String)out + "\tunauthenticatedAttributes: " + this.unauthenticatedAttributes + "\n";
        }
        return out;
    }
}

