/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.pkcs11.attrs.CKAttribute;
import org.mozilla.jss.util.NativeEnclosure;

public class KBKDFDerivedKey
extends NativeEnclosure {
    private CKAttribute[] attrs;
    private long handle;

    public KBKDFDerivedKey() {
    }

    public KBKDFDerivedKey(CKAttribute[] attrs) throws IllegalArgumentException {
        this.setAttributes(attrs);
    }

    public void setAttributes(CKAttribute[] attrs) throws IllegalArgumentException {
        if (attrs == null) {
            Object msg = "Expected populated array of CKAttributes, but ";
            msg = (String)msg + "was null.";
            throw new IllegalArgumentException((String)msg);
        }
        this.attrs = attrs;
    }

    public void addAttribute(CKAttribute attr) throws IllegalArgumentException {
        if (attr == null) {
            String msg = "Expected non-null CKAttribute, but was null.";
            throw new IllegalArgumentException(msg);
        }
        ArrayList<Object> ck_attrs = this.attrs == null ? new ArrayList<CKAttribute>(1) : new ArrayList<CKAttribute>(Arrays.asList(this.attrs));
        ck_attrs.add(attr);
        this.attrs = ck_attrs.toArray(new CKAttribute[ck_attrs.size()]);
    }

    @Override
    protected void acquireNativeResources() throws Exception {
        if (this.attrs == null) {
            Object msg = "Expected non-null attributes when trying to ";
            msg = (String)msg + "acquire native resources. Call setAttributes(...) ";
            msg = (String)msg + "or addAttribute(...) before calling open().";
            throw new IllegalArgumentException((String)msg);
        }
        for (CKAttribute attr : this.attrs) {
            attr.open();
        }
        this.acquireNativeResourcesInternal();
    }

    @Override
    protected void releaseNativeResources() throws Exception {
        if (this.attrs != null) {
            for (CKAttribute attr : this.attrs) {
                attr.close();
            }
        }
        this.releaseNativeResourcesInternal();
    }

    public SecretKey getKey(SecretKey parent, long mech, boolean temporary) throws Exception {
        SecretKeyFactory skf = SecretKeyFactory.getInstance(parent.getAlgorithm(), "Mozilla-JSS");
        SecretKey translated = skf.translateKey(parent);
        SymmetricKey unwrapped = null;
        if (translated instanceof SymmetricKey) {
            unwrapped = (SymmetricKey)translated;
        } else if (translated instanceof SecretKeyFacade) {
            unwrapped = ((SecretKeyFacade)translated).key;
        } else {
            Object msg = "Expected key to become an instance of ";
            msg = (String)msg + "org.mozilla.jss.crypto.SymmetricKey or ";
            msg = (String)msg + "org.mozilla.jss.crypto.SecretKeyFacade after ";
            msg = (String)msg + "translation, but got: ";
            msg = (String)msg + translated.getClass().getName();
            throw new InvalidKeyException((String)msg);
        }
        SymmetricKey key = this.getKeyFromHandle(unwrapped, mech, temporary);
        return new SecretKeyFacade(key);
    }

    private native SymmetricKey getKeyFromHandle(SymmetricKey var1, long var2, boolean var4) throws Exception;

    protected native void acquireNativeResourcesInternal() throws Exception;

    protected native void releaseNativeResourcesInternal() throws Exception;
}

