#!/bin/bash

# Created by argbash-init v2.6.1
# ARG_POSITIONAL_SINGLE([first-subject],[The first (a.k.a. original) build directory/file.])
# ARG_POSITIONAL_SINGLE([second-subject],[The second (a.k.a. new) build directory/file.])
# ARG_POSITIONAL_SINGLE([target],[What to check - 'ovals' or bash 'fixes'?])
# ARG_TYPE_GROUP_SET([target],[TARGET],[target],[ovals,fixes])
# ARG_OPTIONAL_BOOLEAN([meld],[],[Whether to use meld.])
# DEFINE_SCRIPT_DIR([])
# ARG_DEFAULTS_POS([])
# ARG_HELP([Compare datastreams either in build directories, or directly. Either pass build directories with complied datastreams, or pass datastreams directly. Specify whether you want to compare OVAL checks, or bash fixes.])
# ARGBASH_GO()
# needed because of Argbash --> m4_ignore([
### START OF CODE GENERATED BY Argbash v2.6.1 one line above ###
# Argbash is a bash code generator used to get arguments parsing right.
# Argbash is FREE SOFTWARE, see https://argbash.io for more info

die()
{
	local _ret=$2
	test -n "$_ret" || _ret=1
	test "$_PRINT_HELP" = yes && print_help >&2
	echo "$1" >&2
	exit ${_ret}
}

begins_with_short_option()
{
	local first_option all_short_options
	all_short_options='h'
	first_option="${1:0:1}"
	test "$all_short_options" = "${all_short_options/$first_option/}" && return 1 || return 0
}


# validators
target()
{
	local _allowed=("ovals" "fixes")
	local _seeking="$1"
	for element in "${_allowed[@]}"
	do
		test "$element" = "$_seeking" && echo "$element" && return 0
	done
	die "Value '$_seeking' (of argument '$2') doesn't match the list of allowed values: 'ovals' and 'fixes'" 4
}

# THE DEFAULTS INITIALIZATION - POSITIONALS
_positionals=()
_arg_first_subject=
_arg_second_subject=
_arg_target=
# THE DEFAULTS INITIALIZATION - OPTIONALS
_arg_meld="off"

print_help ()
{
	printf '%s\n' "Compare datastreams either in build directories, or directly. Either pass build directories with complied datastreams, or pass datastreams directly. Specify whether you want to compare OVAL checks, or bash fixes."
	printf 'Usage: %s [--(no-)meld] [-h|--help] <first-subject> <second-subject> <target>\n' "$0"
	printf '\t%s\n' "<first-subject>: The first (a.k.a. original) build directory/file."
	printf '\t%s\n' "<second-subject>: The second (a.k.a. new) build directory/file."
	printf '\t%s\n' "<target>: What to check - 'ovals' or bash 'fixes'?"
	printf '\t%s\n' "--meld,--no-meld: Whether to use meld. (off by default)"
	printf '\t%s\n' "-h,--help: Prints help"
}

parse_commandline ()
{
	while test $# -gt 0
	do
		_key="$1"
		case "$_key" in
			--no-meld|--meld)
				_arg_meld="on"
				test "${1:0:5}" = "--no-" && _arg_meld="off"
				;;
			-h|--help)
				print_help
				exit 0
				;;
			-h*)
				print_help
				exit 0
				;;
			*)
				_positionals+=("$1")
				;;
		esac
		shift
	done
}


handle_passed_args_count ()
{
	_required_args_string="'first-subject', 'second-subject' and 'target'"
	test ${#_positionals[@]} -ge 3 || _PRINT_HELP=yes die "FATAL ERROR: Not enough positional arguments - we require exactly 3 (namely: $_required_args_string), but got only ${#_positionals[@]}." 1
	test ${#_positionals[@]} -le 3 || _PRINT_HELP=yes die "FATAL ERROR: There were spurious positional arguments --- we expect exactly 3 (namely: $_required_args_string), but got ${#_positionals[@]} (the last one was: '${_positionals[*]: -1}')." 1
}

assign_positional_args ()
{
	_positional_names=('_arg_first_subject' '_arg_second_subject' '_arg_target' )

	for (( ii = 0; ii < ${#_positionals[@]}; ii++))
	do
		eval "${_positional_names[ii]}=\${_positionals[ii]}" || die "Error during argument parsing, possibly an Argbash bug." 1
	done
}

parse_commandline "$@"
handle_passed_args_count
assign_positional_args

# OTHER STUFF GENERATED BY Argbash
script_dir="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)" || die "Couldn't determine the script's running directory, which probably matters, bailing out" 2
# Validation of values
_arg_target="$(target "$_arg_target" "target")" || exit 1


### END OF CODE GENERATED BY Argbash (sortof) ### ])
# [ <-- needed because of Argbash


first_tmp=/tmp/original
second_tmp=/tmp/new

function check_for_meld() {
	rpm --quiet -q meld || {
		die 'Please install "meld" package if you want to use meld'
	}
}

# Get list of entities in pretty & sorted xml
function extractContent() {
	local filename="$1"

	if [ "$TARGET" == "ovals" ];
	then
		xsltproc "$script_dir/../shared/transforms/xccdf-get-only-ovals-sorted.xslt" "$filename"
	else
		xsltproc "$script_dir/../shared/transforms/xccdf-get-only-remediations-sorted.xslt" "$filename"
	fi \
		| xmllint --c14n11 /dev/stdin \
		| xmllint -format /dev/stdin \
		| sed 's;^\s*#.*$;;g' \
		| sed '/^\s*$/d'
		# remove bash comments from output
		# remove empty lines
}


# $1: Filename
# $2: First directory
# $3: Second directory
function same_file_in_second_directory() {
	local filename="$1" first_directory="$2" second_directory="$3"
	other_filename=$(sed "s;^$first_directory;$second_directory;" <<< "$filename")
	test -f "$other_filename"
	printf "%s" "$other_filename"
}


# $1: Original file
# $2: File to compare it with.
function compareFile() {
	local originalFile="$1" toCompare=$2
	echo "-----------------------------------------------------------------"
	echo "$originalFile <=> $toCompare"
	echo "-----------------------------------------------------------------"

	extractContent "$originalFile" > "$first_tmp"
	extractContent "$toCompare"    > "$second_tmp"

	local ret=0
	if [ "$_arg_meld" == "on" ];
	then
		diff "$first_tmp" "$second_tmp" -q || {
			meld "$first_tmp" "$second_tmp"
		}
		ret=$?
	else
		diff "$first_tmp" "$second_tmp"
		ret=$?
	fi
	return $ret
}


# $1: Find location
# $2: Find pattern
# Take result of find, and use newline to make an array of file entries out of it.
function save_find_results_to_filenames_array() {
	local IFS=$'\n' where="$1" pattern="$2"
	filenames=( $(find "$where" -name "$pattern") )
}


# $1: First build directory
function operate_on_builddirs() {
	local first_directory="$1" second_directory="$2" first_file second_file rc
	save_find_results_to_filenames_array "$first_directory" "ssg-*-ds*.xml"

	for first_file in "${filenames[@]}"; do
		second_file="$(same_file_in_second_directory "$first_file" "$first_directory" "$second_directory")"
		test -f "$second_file" || { echo "File '$second_file' that is supposed to be twin of '$first_file' doesn't exist." >&2; continue; }
		compareFile "$first_file" "$second_file"
		rc=$?
		if [ "$rc" -ne 0 ]; then
			return 1
		fi
	done
	return 0
}


function operate_on_files() {
	local first_file="$1" second_file="$2" rc
	compareFile "$first_file" "$second_file"
	rc=$?
	if [ "$rc" -ne 0 ]; then
		return 1
	fi
	return 0
}


[ "$_arg_meld" == "on" ] && check_for_meld

# global variable
TARGET="$_arg_target"

if [ -d "$_arg_first_subject" ] && [ -d "$_arg_second_subject" ]; then
       processing_function=operate_on_builddirs
elif [ -f "$_arg_first_subject" ] && [ -f "$_arg_second_subject" ]; then
       processing_function=operate_on_files
else
	die "The supplied '$_arg_first_subject' and '$_arg_second_subject' either have to be both files, or both directories, which is not the case."
fi

"$processing_function" "$_arg_first_subject" "$_arg_second_subject"

# ] <-- needed because of Argbash
