/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authorization;

import com.netscape.certsrv.acls.ACLEntry;
import com.netscape.certsrv.acls.EACLsException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cms.authorization.AAclAuthz;
import com.netscape.cms.authorization.ACL;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.authorization.AuthzManagerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirAclAuthz
extends AAclAuthz
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(DirAclAuthz.class);
    protected static final String PROP_SEARCHBASE = "searchBase";
    private LdapBoundConnFactory mLdapConnFactory;
    private String mBaseDN = null;
    private boolean loaded;
    private static boolean needsFlush = false;
    private String searchBase = null;

    public DirAclAuthz() {
        mConfigParams = new String[]{"ldap.ldapconn.host", "ldap.ldapconn.port", "ldap.ldapconn.secureConn", "ldap.ldapconn.version", "ldap.basedn", "ldap.minConns", "ldap.maxConns"};
    }

    @Override
    public void init(String name, String implName, AuthzManagerConfig config) throws EBaseException {
        LDAPConfig ldapConfig;
        EngineConfig cs;
        block3: {
            super.init(name, implName, config);
            cs = this.engine.getConfig();
            this.searchBase = config.getString(PROP_SEARCHBASE, null);
            ldapConfig = config.getLDAPConfig();
            if (ldapConfig == null) {
                logger.warn("DirAclAuthz: failed to get config ldap info");
                return;
            }
            this.mBaseDN = ldapConfig.getBaseDN();
            LDAPConnectionConfig connConfig = ldapConfig.getConnectionConfig();
            try {
                String string = connConfig.getString("host");
            }
            catch (EBaseException e) {
                logger.warn("DirAclAuthz: " + e.getMessage(), (Throwable)e);
                if (!this.engine.isPreOpMode()) break block3;
                logger.warn("DirAclAuthz: Ignore exception in pre-op mode");
                return;
            }
        }
        PKISocketConfig socketConfig = cs.getSocketConfig();
        this.mLdapConnFactory = new LdapBoundConnFactory("DirAclAuthz");
        this.mLdapConnFactory.setCMSEngine(this.engine);
        this.mLdapConnFactory.init(socketConfig, ldapConfig, this.engine.getPasswordStore());
        logger.info("DirAclAuthz: initialization done");
    }

    public synchronized void loadACLs() throws EACLsException {
        if (this.loaded) {
            return;
        }
        logger.info("DirAclAuthz: Loading ACL resources");
        String baseDN = this.mBaseDN;
        String filter = "cn=aclResources";
        if (this.searchBase != null) {
            baseDN = String.join((CharSequence)",", this.searchBase, baseDN);
            filter = "objectclass=CertACLs";
        }
        logger.debug("DirAclAuthz: Searching " + baseDN + " for " + filter);
        LDAPConnection conn = null;
        try {
            conn = this.getConn();
            LDAPSearchResults res = conn.search(baseDN, 2, filter, null, false);
            if (!res.hasMoreElements()) {
                logger.info("DirAclAuthz: ACL resources not found");
                return;
            }
            LDAPEntry entry = (LDAPEntry)res.nextElement();
            logger.info("DirAclAuthz: ACL resources found: " + entry.getDN());
            LDAPAttribute aclRes = entry.getAttribute("resourceACLS");
            Enumeration en = aclRes.getStringValues();
            while (en.hasMoreElements()) {
                String resACLs = (String)en.nextElement();
                ACL acl = ACL.parseACL(resACLs);
                logger.info("DirAclAuthz: - " + acl.getName());
                super.addACLs(acl);
            }
        }
        catch (LDAPException e) {
            throw new EACLsException(CMS.getUserMessage("CMS_ACL_CONNECT_LDAP_FAIL", e.getMessage()), (Exception)((Object)e));
        }
        catch (ELdapException e) {
            throw new EACLsException(CMS.getUserMessage("CMS_ACL_CONNECT_LDAP_FAIL", e.getMessage()), (Exception)((Object)e));
        }
        finally {
            this.returnConn(conn);
        }
        this.loaded = true;
    }

    @Override
    public void addACLs(String resACLs) throws EACLsException {
        if (!this.loaded) {
            this.loadACLs();
        }
        super.addACLs(resACLs);
    }

    @Override
    public void addACLs(ACL acl) throws EACLsException {
        if (!this.loaded) {
            this.loadACLs();
        }
        super.addACLs(acl);
    }

    @Override
    public void accessInit(String accessInfo) throws EBaseException {
        if (!this.loaded) {
            this.loadACLs();
        }
        super.accessInit(accessInfo);
    }

    @Override
    public ACL getACL(String target) throws EACLsException {
        if (!this.loaded) {
            this.loadACLs();
        }
        return super.getACL(target);
    }

    @Override
    protected Set<String> getTargetNames() throws EACLsException {
        if (!this.loaded) {
            this.loadACLs();
        }
        return super.getTargetNames();
    }

    @Override
    public Collection<ACL> getACLs() throws EACLsException {
        if (!this.loaded) {
            this.loadACLs();
        }
        return super.getACLs();
    }

    @Override
    protected boolean checkACLs(String name, String perm) throws EACLsException {
        if (!this.loaded) {
            this.loadACLs();
        }
        return super.checkACLs(name, perm);
    }

    @Override
    protected Iterable<ACLEntry> getEntries(ACLEntry.Type entryType, Iterable<String> nodes, String operation) throws EACLsException {
        if (!this.loaded) {
            this.loadACLs();
        }
        return super.getEntries(entryType, nodes, operation);
    }

    @Override
    public boolean isTypeUnique(String type) throws EACLsException {
        if (!this.loaded) {
            this.loadACLs();
        }
        return super.isTypeUnique(type);
    }

    @Override
    public void updateACLs(String id, String rights, String strACLs, String desc) throws EACLsException {
        if (!this.loaded) {
            this.loadACLs();
        }
        try {
            super.updateACLs(id, rights, strACLs, desc);
            this.flushResourceACLs();
            needsFlush = false;
        }
        catch (EACLsException ex) {
            needsFlush = true;
            logger.error("DirAclAuthz: " + CMS.getLogMessage("AUTHZ_EVALUATOR_FLUSH_RESOURCES", ex.toString()), (Throwable)((Object)ex));
            throw ex;
        }
    }

    protected void flushResourceACLs() throws EACLsException {
        LDAPConnection conn = null;
        try {
            LDAPAttribute attrs = new LDAPAttribute("resourceACLS");
            LDAPModificationSet mod = new LDAPModificationSet();
            Collection<ACL> acls = this.getACLs();
            if (!acls.isEmpty()) {
                for (ACL a : acls) {
                    for (String s : a.getResourceACLs()) {
                        attrs.addValue(s);
                    }
                }
                mod.add(2, attrs);
                conn = this.getConn();
                conn.modify("cn=aclResources," + this.mBaseDN, mod);
            }
        }
        catch (LDAPException ex) {
            System.out.println(ex.toString());
            throw new EACLsException(CMS.getUserMessage("CMS_ACL_UPDATE_FAIL", new String[0]));
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            throw new EACLsException(CMS.getUserMessage("CMS_ACL_UPDATE_FAIL", new String[0]));
        }
        finally {
            this.returnConn(conn);
        }
    }

    protected LDAPConnection getConn() throws ELdapException {
        return this.mLdapConnFactory.getConn();
    }

    protected void returnConn(LDAPConnection conn) {
        this.mLdapConnFactory.returnConn(conn);
    }

    @Override
    public void shutdown() {
        if (needsFlush) {
            try {
                this.flushResourceACLs();
            }
            catch (EACLsException e) {
                logger.warn("DirAclAuthz: " + CMS.getLogMessage("AUTHZ_EVALUATOR_FLUSH_ERROR", e.toString()), (Throwable)((Object)e));
            }
        }
        try {
            if (this.mLdapConnFactory != null) {
                this.mLdapConnFactory.reset();
            }
        }
        catch (ELdapException e) {
            logger.warn("DirAclAuthz: " + CMS.getLogMessage("AUTHZ_EVALUATOR_LDAP_ERROR", e.toString()), (Throwable)e);
        }
    }

    static {
        mExtendedPluginInfo.add("ldap.ldapconn.host;string,required;LDAP host to connect to");
        mExtendedPluginInfo.add("ldap.ldapconn.port;number,required;LDAP port number (use 389, or 636 if SSL)");
        mExtendedPluginInfo.add("ldap.ldapconn.secureConn;boolean;Use SSL to connect to directory?");
        mExtendedPluginInfo.add("ldap.ldapconn.version;choice(3,2);LDAP protocol version");
        mExtendedPluginInfo.add("ldap.basedn;string,required;Base DN to start sarching under.");
        mExtendedPluginInfo.add("ldap.minConns;number;number of connections to keep open to directory server. Default 5.");
        mExtendedPluginInfo.add("ldap.maxConns;number;when needed, connection pool can grow to this many (multiplexed) connections. Default 1000");
    }
}

