/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.authentication.HashAuthData;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashAuthentication
extends AuthManager
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(HashAuthentication.class);
    public static final String SALT = "lala123";
    public static final String CRED_UID = "uid";
    public static final String CRED_FINGERPRINT = "fingerprint";
    public static final String CRED_PAGEID = "pageID";
    public static final String CRED_HOST = "hostname";
    protected static String[] mRequiredCreds = new String[]{"uid", "pageID", "fingerprint", "hostname"};
    public static final long DEFAULT_TIMEOUT = 600000L;
    private MessageDigest mSHADigest = null;
    private Hashtable<String, AuthToken> mData = null;
    private static Vector<String> mExtendedPluginInfo = null;
    private HashAuthData mHosts = null;

    @Override
    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        this.authenticationConfig = authenticationConfig;
        this.mName = name;
        this.mImplName = implName;
        this.mConfig = config;
        this.mData = new Hashtable();
        this.mHosts = new HashAuthData();
        try {
            this.mSHADigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", e.getMessage()));
        }
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
    }

    public AuthToken getAuthToken(String key) {
        return this.mData.remove(key);
    }

    public void addAuthToken(String pageID, AuthToken token) {
        this.mData.put(pageID, token);
    }

    public void deleteToken(String pageID) {
        this.mData.remove(pageID);
    }

    public HashAuthData getData() {
        return this.mHosts;
    }

    public void createEntry(String host, String dn, long timeout, String secret, long lastLogin) {
        Vector<Object> v = new Vector<Object>();
        v.addElement(dn);
        v.addElement(timeout);
        v.addElement(secret);
        v.addElement(lastLogin);
        this.mHosts.put(host, v);
    }

    public void disable(String hostname) {
        this.mHosts.remove(hostname);
    }

    public String getAgentName(String hostname) {
        return this.mHosts.getAgentName(hostname);
    }

    public void setAgentName(String hostname, String agentName) {
        this.mHosts.setAgentName(hostname, agentName);
    }

    public boolean isEnable(String hostname) {
        return this.mHosts.containsKey(hostname);
    }

    public long getTimeout(String hostname) {
        return this.mHosts.getTimeout(hostname);
    }

    public void setTimeout(String hostname, long timeout) {
        this.mHosts.setTimeout(hostname, timeout);
    }

    public String getSecret(String hostname) {
        return this.mHosts.getSecret(hostname);
    }

    public void setSecret(String hostname, String secret) {
        this.mHosts.setSecret(hostname, secret);
    }

    public long getLastLogin(String hostname) {
        return this.mHosts.getLastLogin(hostname);
    }

    public void setLastLogin(String hostname, long lastlogin) {
        this.mHosts.setLastLogin(hostname, lastlogin);
    }

    public long getPageID() {
        Date date = new Date();
        return date.getTime();
    }

    public boolean validFingerprint(String host, String pageID, String uid, String fingerprint) {
        String val = this.hashFingerprint(host, pageID, uid);
        return val.equals(fingerprint);
    }

    public Enumeration<String> getHosts() {
        return this.mHosts.keys();
    }

    public String hashFingerprint(String host, String pageID, String uid) {
        byte[] hash = this.mSHADigest.digest((SALT + pageID + this.getSecret(host) + uid).getBytes());
        String b64E = Utils.base64encode((byte[])hash, (boolean)true);
        return "{SHA}" + b64E;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public AuthToken authenticate(AuthCredentials authCreds) throws EBaseException {
        AuthToken token = new AuthToken(this);
        String fingerprint = (String)authCreds.get(CRED_FINGERPRINT);
        String pageID = (String)authCreds.get(CRED_PAGEID);
        String uid = (String)authCreds.get(CRED_UID);
        String host = (String)authCreds.get(CRED_HOST);
        if (fingerprint.equals("") || !this.validFingerprint(host, pageID, uid, fingerprint)) {
            logger.error("HashAuthentication: " + CMS.getLogMessage("CMS_AUTH_INVALID_FINGER_PRINT", new Object[0]));
            throw new EAuthException("Invalid Fingerprint");
        }
        token.set(CRED_UID, uid);
        return token;
    }

    @Override
    public void populate(AuthToken token, Request request) throws EProfileException {
    }

    @Override
    public String[] getRequiredCreds() {
        return mRequiredCreds;
    }

    @Override
    public String getText(Locale locale) {
        return null;
    }

    @Override
    public Enumeration<String> getValueNames() {
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        return null;
    }

    @Override
    public boolean isValueWriteable(String name) {
        return false;
    }

    @Override
    public boolean isSSLClientRequired() {
        return false;
    }

    public String[] getExtendedPluginInfo() {
        return Utils.getStringArrayFromVector(mExtendedPluginInfo);
    }

    static {
        mExtendedPluginInfo = new Vector();
        mExtendedPluginInfo.add("HELP_TEXT;Authenticate the username and password provided by the user against an LDAP directory. Works with the Dir Based Enrollment HTML form");
        mExtendedPluginInfo.add("HELP_TOKEN;configuration-authrules-uidpwddirauth");
    }
}

