/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SecurityDataExportEvent;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.kra.KeyRecoveryAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPk12
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(GetPk12.class);
    private static final long serialVersionUID = 8974964964333880697L;
    private static final String INFO = "getPk12";
    private static final String TPL_FILE = "finishRecovery.template";
    private static final String OUT_ERROR = "errorDetails";
    private KeyRecoveryAuthority mService;
    private String mFormPath = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/agent/kra/finishRecovery.template";
        KRAEngine engine = KRAEngine.getInstance();
        this.mService = engine.getKRA();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    public String getServletInfo() {
        return INFO;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        Object auditMessage = null;
        String recoveryID = null;
        String agent = null;
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "download");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        try {
            recoveryID = req.getParameter("recoveryID");
            header.addStringValue("recoveryID", recoveryID);
            Hashtable<String, Object> params = this.mService.getRecoveryParams(recoveryID);
            if (params == null) {
                logger.error(CMS.getLogMessage((String)"CMSGW_NO_RECOVERY_TOKEN_FOUND_1", (Object[])new Object[]{recoveryID}));
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NO_RECOVERY_TOKEN_FOUND", (String[])new String[]{recoveryID}));
            }
            SessionContext sContext = SessionContext.getContext();
            if (sContext != null) {
                agent = (String)sContext.get((Object)"userid");
            }
            if (agent == null) {
                logger.error("GetPk12::process() - agent is null!");
                throw new EBaseException("agent is null");
            }
            String initAgent = (String)params.get("agent");
            if (!agent.equals(initAgent)) {
                logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_AGENT_3", (Object[])new Object[]{recoveryID, initAgent}));
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_AGENT", (String[])new String[]{agent, initAgent, recoveryID}));
            }
            header.addStringValue("serialNumber", (String)params.get("keyID"));
            byte[] pkcs12 = this.mService.getPk12(recoveryID);
            if (pkcs12 != null) {
                this.mService.destroyRecoveryParams(recoveryID);
                try {
                    resp.setContentType("application/x-pkcs12");
                    resp.getOutputStream().write(pkcs12);
                    this.mRenderResult = false;
                    auditor.log((LogEvent)new SecurityDataExportEvent(agent, "Success", new RequestId(recoveryID), null, null, null));
                    return;
                }
                catch (IOException e) {
                    header.addStringValue(OUT_ERROR, CMS.getUserMessage((Locale)locale[0], (String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
                }
            } else if (this.mService.getError(recoveryID) != null) {
                header.addStringValue(OUT_ERROR, this.mService.getError(recoveryID));
            }
        }
        catch (EBaseException e) {
            header.addStringValue(OUT_ERROR, e.toString(locale[0]));
        }
        if (agent != null && recoveryID != null) {
            auditor.log((LogEvent)new SecurityDataExportEvent(agent, "Failure", new RequestId(recoveryID), null, null, null));
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            resp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }
}

