/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.rest;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.authorization.EAuthzException;
import com.netscape.certsrv.base.BadRequestDataException;
import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.ConflictingOperationException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.base.UnauthorizedException;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertRequestInfos;
import com.netscape.certsrv.cert.CertRequestResource;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfileDataInfo;
import com.netscape.certsrv.profile.ProfileDataInfos;
import com.netscape.certsrv.profile.ProfileInput;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestNotFoundException;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cmscore.profile.ProfileSubsystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.ws.rs.core.Response;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.rest.CertRequestDAO;
import org.dogtagpki.server.ca.rest.ProfileService;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertRequestService
extends PKIService
implements CertRequestResource {
    public static final Logger logger = LoggerFactory.getLogger(CertRequestService.class);
    public static final int DEFAULT_START = 0;
    public static final int DEFAULT_PAGESIZE = 20;

    public Response getRequestInfo(RequestId id) {
        CertRequestInfo info;
        if (id == null) {
            String message = "Unable to get certificate request info: Missing request ID";
            logger.error(message);
            throw new BadRequestException(message);
        }
        logger.info("CertRequestService: Retrieving certificate request " + id.toHexString());
        CertRequestDAO dao = new CertRequestDAO();
        try {
            info = dao.getRequest(id, this.uriInfo);
        }
        catch (EBaseException e) {
            String message = "Unable to get cert request info: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new PKIException(message, (Throwable)e);
        }
        if (info == null) {
            throw new RequestNotFoundException(id);
        }
        return this.createOKResponse(info);
    }

    public Response enrollCert(String enrollmentRequest, String aidString, String adnString) {
        CertRequestInfos infos;
        logger.info("CertRequestService: Receiving certificate request");
        CertEnrollmentRequest data = (CertEnrollmentRequest)this.unmarshall(enrollmentRequest, CertEnrollmentRequest.class);
        if (data == null) {
            String message = "Unable to create enrollment request: Missing input data";
            logger.error(message);
            throw new BadRequestException(message);
        }
        if (aidString != null && adnString != null) {
            throw new BadRequestException("Cannot provide both issuer-id and issuer-dn");
        }
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        AuthorityID aid = null;
        if (aidString != null) {
            try {
                aid = new AuthorityID(aidString);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("invalid AuthorityID: " + aidString, (Throwable)e);
            }
            ca = engine.getCA(aid);
            if (ca == null) {
                throw new ResourceNotFoundException("CA not found: " + aidString);
            }
        }
        if (adnString != null) {
            X500Name adn = null;
            try {
                adn = new X500Name(adnString);
            }
            catch (IOException e) {
                throw new BadRequestException("invalid DN: " + adnString, (Throwable)e);
            }
            ca = engine.getCA(adn);
            if (ca == null) {
                throw new ResourceNotFoundException("CA not found: " + adnString);
            }
            aid = ca.getAuthorityID();
        }
        if (!ca.getAuthorityEnabled()) {
            throw new ConflictingOperationException("CA not enabled: " + aid.toString());
        }
        data.setRemoteHost(this.servletRequest.getRemoteHost());
        data.setRemoteAddr(this.servletRequest.getRemoteAddr());
        CertRequestDAO dao = new CertRequestDAO();
        try {
            infos = dao.submitRequest(aid, data, this.servletRequest, this.uriInfo, this.getLocale(this.headers));
        }
        catch (EAuthException e) {
            String message = "Authentication failed: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new UnauthorizedException(message, (Throwable)e);
        }
        catch (EAuthzException e) {
            String message = "Authorization failed: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new UnauthorizedException(message, (Throwable)e);
        }
        catch (BadRequestDataException e) {
            String message = "Bad request data: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new BadRequestException(message, (Throwable)e);
        }
        catch (EBaseException e) {
            String message = "Unable to create enrollment request: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new PKIException(message, (Throwable)e);
        }
        catch (Exception e) {
            String message = "Unable to create enrollment request: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new PKIException(message, (Throwable)e);
        }
        return this.createOKResponse(infos);
    }

    public Response getEnrollmentTemplate(String profileId) {
        if (profileId == null) {
            String message = "Unable to get enrollment template: Missing Profile ID";
            logger.error(message);
            throw new BadRequestException(message);
        }
        CAEngine engine = CAEngine.getInstance();
        ProfileSubsystem ps = engine.getProfileSubsystem();
        if (ps == null) {
            String message = "Unable to get enrollment template: Profile Service not available";
            logger.error(message);
            throw new PKIException(message);
        }
        Profile profile = null;
        try {
            profile = ps.getProfile(profileId);
            if (profile == null) {
                String message = "Unable to get enrollment template for " + profileId + ": Profile not found";
                logger.error(message);
                throw new BadRequestException(message);
            }
        }
        catch (EBaseException e) {
            String message = "Unable to get enrollment template for " + profileId + ": " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new PKIException(message, (Throwable)e);
        }
        if (!profile.isVisible()) {
            logger.debug("getEnrollmentTemplate(): getting enrollment template for non-visible profile.");
        }
        CertEnrollmentRequest request = new CertEnrollmentRequest();
        request.setProfileId(profileId);
        request.setRenewal(Boolean.parseBoolean(profile.isRenewal()));
        request.setRemoteAddr("");
        request.setRemoteHost("");
        Enumeration<String> inputIds = profile.getProfileInputIds();
        while (inputIds.hasMoreElements()) {
            String id = inputIds.nextElement();
            try {
                ProfileInput input = ProfileService.createProfileInput(profile, id, this.getLocale(this.headers));
                for (ProfileAttribute attr : input.getAttributes()) {
                    attr.setValue("");
                }
                request.addInput(input);
            }
            catch (EBaseException e) {
                String message = "Unable to add input " + id + " to request template: " + e.getMessage();
                logger.error(message, (Throwable)e);
                throw new PKIException(message, (Throwable)e);
            }
        }
        return this.createOKResponse(request);
    }

    public Response listEnrollmentTemplates(Integer start, Integer size) {
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        CAEngine engine = CAEngine.getInstance();
        ProfileSubsystem ps = engine.getProfileSubsystem();
        if (ps == null) {
            throw new PKIException("Profile subsystem unavailable.");
        }
        ProfileDataInfos infos = new ProfileDataInfos();
        boolean visibleOnly = true;
        Enumeration<String> e = ps.getProfileIds();
        if (e == null) {
            return this.createOKResponse(infos);
        }
        ArrayList<ProfileDataInfo> results = new ArrayList<ProfileDataInfo>();
        while (e.hasMoreElements()) {
            try {
                String id = e.nextElement();
                ProfileDataInfo info = ProfileService.createProfileDataInfo(id, visibleOnly, this.uriInfo, this.getLocale(this.headers));
                if (info == null) continue;
                results.add(info);
            }
            catch (EBaseException ex) {
                logger.warn("CertRequestService: " + ex.getMessage());
            }
        }
        int total = results.size();
        infos.setTotal(total);
        for (int i = start.intValue(); i < start + size && i < total; ++i) {
            infos.addEntry((Object)((ProfileDataInfo)results.get(i)));
        }
        return this.createOKResponse(infos);
    }
}

