/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.extensions.CertificateRenewalWindowExtension;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class CertificateRenewalWindowExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    protected static final String PROP_END_TIME = "relativeEndTime";
    protected static final String PROP_BEGIN_TIME = "relativeBeginTime";
    protected static final String PROP_CRITICAL = "critical";
    protected boolean mCritical;
    protected String mBeginTime;
    protected String mEndTime;

    public CertificateRenewalWindowExt() {
        this.NAME = "CertificateRenewalWindowExt";
        this.DESC = "Sets non-critical Certificate Renewal Window extension in certs";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mCritical = config.getBoolean(PROP_CRITICAL, false);
        this.mBeginTime = config.getString(PROP_BEGIN_TIME, null);
        this.mEndTime = config.getString(PROP_END_TIME, null);
    }

    public PolicyResult apply(Request req) {
        PolicyResult res = PolicyResult.ACCEPTED;
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult r = this.applyCert(req, ci[i]);
            if (r != PolicyResult.REJECTED) continue;
            return r;
        }
        return res;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        CertificateExtensions extensions = null;
        try {
            extensions = (CertificateExtensions)certInfo.get("extensions");
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if (extensions == null) {
            extensions = new CertificateExtensions();
            try {
                certInfo.set("version", (Object)new CertificateVersion(2));
                certInfo.set("extensions", (Object)extensions);
            }
            catch (Exception exception) {}
        } else {
            try {
                extensions.delete("CertificateRenewalWindow");
            }
            catch (IOException e) {
                try {
                    extensions.delete("2.16.840.1.113730.1.15");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            Date now = new Date();
            CertificateRenewalWindowExtension crwExt = null;
            crwExt = this.mEndTime == null || this.mEndTime.equals("") ? new CertificateRenewalWindowExtension(this.mCritical, this.getDateValue(now, this.mBeginTime), null) : new CertificateRenewalWindowExtension(this.mCritical, this.getDateValue(now, this.mBeginTime), this.getDateValue(now, this.mEndTime));
            extensions.set("CertificateRenewalWindow", (Object)crwExt);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"POLICY_ERROR_CERTIFICATE_POLICIES_1", (Object[])new Object[]{this.NAME}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_CERTIFICATE_POLICIES_ERROR", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        return PolicyResult.ACCEPTED;
    }

    public Date getDateValue(Date relativeFrom, String s) {
        long time = s.endsWith("s") ? 1000L * Long.parseLong(s.substring(0, s.length() - 1)) : (s.endsWith("m") ? 60000L * Long.parseLong(s.substring(0, s.length() - 1)) : (s.endsWith("h") ? 3600000L * Long.parseLong(s.substring(0, s.length() - 1)) : (s.endsWith("D") ? 86400000L * Long.parseLong(s.substring(0, s.length() - 1)) : (s.endsWith("M") ? 108000000L * Long.parseLong(s.substring(0, s.length() - 1)) : 1000L * Long.parseLong(s)))));
        return new Date(relativeFrom.getTime() + time);
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"critical;boolean;Netscape recommendation: non-critical.", "relativeBeginTime;string;Start Time in seconds (Relative to the time of issuance). Optionally, time unit (s - seconds, m - minutes, h - hours, D - days, M - months) can be specified right after the value. For example, 5 days can be expressed as 5D.", "relativeEndTime;string;End Time in seconds (Optional, Relative to the time of issuance). Optionally, time unit (s - seconds, m - minutes, h - hours, D - days, M - months) can be specified right after the value. For example, 5 days can be expressed as 5D.", "HELP_TOKEN;configuration-policyrules-certificaterenewalwindow", "HELP_TEXT;Adds 'Certificate Renewal Window' extension. See manual"};
        return params;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> params = new Vector<String>();
        params.addElement("critical=" + this.mCritical);
        if (this.mBeginTime == null) {
            params.addElement("relativeBeginTime=");
        } else {
            params.addElement("relativeBeginTime=" + this.mBeginTime);
        }
        if (this.mEndTime == null) {
            params.addElement("relativeEndTime=");
        } else {
            params.addElement("relativeEndTime=" + this.mEndTime);
        }
        return params;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> defParams = new Vector<String>();
        defParams.addElement("critical=false");
        defParams.addElement("relativeBeginTime=");
        defParams.addElement("relativeEndTime=");
        return defParams;
    }
}

