/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.request.Request;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapEnrollmentListener
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(LdapEnrollmentListener.class);
    private CAPublisherProcessor processor;

    public LdapEnrollmentListener(CAPublisherProcessor processor) {
        this.processor = processor;
    }

    public void init(Subsystem sys, ConfigStore config) throws EBaseException {
    }

    public void set(String name, String val) {
    }

    public void accept(Request r) {
        logger.info("LdapEnrollmentListener: Handling enrollment request " + r.getRequestId().toHexString());
        String profileId = r.getExtDataInString("profileId");
        if (profileId == null) {
            if (r.getExtDataInInteger("Result") == null) {
                return;
            }
            if (r.getExtDataInInteger("Result").equals(Request.RES_ERROR)) {
                logger.warn("Nothing to publish for enrollment request " + r.getRequestId().toHexString());
                return;
            }
        }
        logger.debug("LdapEnrollmentListener: Checking publishing for request " + r.getRequestId().toHexString());
        Certificate[] certs = null;
        certs = profileId == null ? r.getExtDataInCertArray("issuedCerts") : new Certificate[]{r.getExtDataInCert("req_issued_cert")};
        if (certs == null || certs.length == 0 || certs[0] == null) {
            logger.warn("No certs to publish for request " + r.getRequestId().toHexString());
            return;
        }
        if (certs[0] instanceof X509CertImpl) {
            this.acceptX509(r, certs);
        }
    }

    public void acceptX509(Request r, Certificate[] certs) {
        Integer[] results = new Integer[certs.length];
        Integer status = Request.RES_SUCCESS;
        for (int i = 0; i < certs.length; ++i) {
            X509CertImpl xcert = (X509CertImpl)certs[i];
            if (xcert == null) continue;
            CertId certID = new CertId(xcert.getSerialNumber());
            try {
                this.processor.publishCert((X509Certificate)xcert, r);
                results[i] = Request.RES_SUCCESS;
                logger.debug("LdapEnrollmentListener: Published cert " + certID.toHexString());
                continue;
            }
            catch (ELdapException e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_LDAP_CERT_NOT_PUBLISH", (Object[])new Object[]{certID.toHexString(), e.toString()}), (Throwable)e);
                results[i] = Request.RES_ERROR;
                status = Request.RES_ERROR;
            }
        }
        r.setExtData("ldapPublishStatus", results);
        r.setExtData("ldapPublishOverAllStatus", status);
    }
}

