/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.ExtendedPluginInfo;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.base.Plugin;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.publish.EMapperNotFound;
import com.netscape.certsrv.publish.EMapperPluginNotFound;
import com.netscape.certsrv.publish.EPublisherNotFound;
import com.netscape.certsrv.publish.EPublisherPluginNotFound;
import com.netscape.certsrv.publish.ERuleNotFound;
import com.netscape.certsrv.publish.ERulePluginNotFound;
import com.netscape.certsrv.publish.Mapper;
import com.netscape.certsrv.publish.MapperPlugin;
import com.netscape.certsrv.publish.MapperProxy;
import com.netscape.certsrv.publish.Publisher;
import com.netscape.certsrv.publish.PublisherPlugin;
import com.netscape.certsrv.publish.PublisherProxy;
import com.netscape.certsrv.publish.RulePlugin;
import com.netscape.cms.servlet.admin.AdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.ldap.LdapRule;
import com.netscape.cmscore.ldap.PublishingConfig;
import com.netscape.cmscore.ldap.PublishingMapperConfig;
import com.netscape.cmscore.ldap.PublishingPublisherConfig;
import com.netscape.cmscore.ldap.PublishingRuleConfig;
import com.netscape.cmscore.ldapconn.LDAPAuthenticationConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmsutil.password.PasswordStore;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="capublisher", urlPatterns={"/capublisher"}, initParams={@WebInitParam(name="ID", value="capublisher"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca")})
public class PublisherAdminServlet
extends AdminServlet {
    public static Logger logger = LoggerFactory.getLogger(PublisherAdminServlet.class);
    private static final long serialVersionUID = 7055088618787207262L;
    public static final String PROP_AUTHORITY = "authority";
    private static final String INFO = "PublisherAdminServlet";
    public static final String NOMAPPER = "<NONE>";
    PublishingConfig publishingConfig;
    private CAPublisherProcessor mProcessor;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        CAEngine engine = CAEngine.getInstance();
        this.publishingConfig = engine.getConfig().getCAConfig().getPublishingConfig();
        this.mProcessor = engine.getPublisherProcessor();
    }

    public String getServletInfo() {
        return INFO;
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block50: {
            super.service(req, resp);
            logger.debug("PublisherAdminServlet: in service");
            String scope = req.getParameter("OP_SCOPE");
            String op = req.getParameter("OP_TYPE");
            if (op == null) {
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_INVALID_PROTOCOL", (String[])new String[0]), null, resp);
                return;
            }
            try {
                super.authenticate(req);
                if (op.equals("OP_AUTH")) {
                    this.sendResponse(SUCCESS, null, null, resp);
                    return;
                }
            }
            catch (IOException e) {
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHS_FAILED", (String[])new String[0]), null, resp);
                return;
            }
            try {
                AUTHZ_RES_NAME = "certServer.publisher.configuration";
                if (scope != null) {
                    if (op.equals("OP_READ")) {
                        this.mOp = "read";
                        this.mToken = super.authorize(req);
                        if (this.mToken == null) {
                            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                            return;
                        }
                        if (scope.equals("ldap")) {
                            this.getLDAPDest(req, resp);
                            return;
                        }
                        if (scope.equals("publisherImpls")) {
                            this.getConfig(req, resp);
                            return;
                        }
                        if (scope.equals("publisherRules")) {
                            this.getInstConfig(req, resp);
                            return;
                        }
                        if (scope.equals("mapperImpls")) {
                            this.getMapperConfig(req, resp);
                            return;
                        }
                        if (scope.equals("mapperRules")) {
                            this.getMapperInstConfig(req, resp);
                            return;
                        }
                        if (scope.equals("ruleImpls")) {
                            this.getRuleConfig(req, resp);
                            return;
                        }
                        if (scope.equals("extendedPluginInfo")) {
                            this.getExtendedPluginInfo(req, resp);
                            return;
                        }
                        if (scope.equals("ruleRules")) {
                            this.getRuleInstConfig(req, resp);
                            return;
                        }
                        break block50;
                    }
                    if (op.equals("OP_MODIFY")) {
                        this.mOp = "modify";
                        this.mToken = super.authorize(req);
                        if (this.mToken == null) {
                            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                            return;
                        }
                        if (scope.equals("ldap")) {
                            this.setLDAPDest(req, resp);
                            return;
                        }
                        if (scope.equals("publisherRules")) {
                            this.modPublisherInst(req, resp, scope);
                            return;
                        }
                        if (scope.equals("mapperRules")) {
                            this.modMapperInst(req, resp, scope);
                            return;
                        }
                        if (scope.equals("ruleRules")) {
                            this.modRuleInst(req, resp, scope);
                            return;
                        }
                        break block50;
                    }
                    if (op.equals("OP_PROCESS")) {
                        this.mOp = "modify";
                        this.mToken = super.authorize(req);
                        if (this.mToken == null) {
                            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                            return;
                        }
                        if (scope.equals("ldap")) {
                            this.testSetLDAPDest(req, resp);
                            return;
                        }
                        break block50;
                    }
                    if (op.equals("OP_SEARCH")) {
                        this.mOp = "read";
                        this.mToken = super.authorize(req);
                        if (this.mToken == null) {
                            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                            return;
                        }
                        if (scope.equals("publisherImpls")) {
                            this.listPublisherPlugins(req, resp);
                            return;
                        }
                        if (scope.equals("publisherRules")) {
                            this.listPublisherInsts(req, resp);
                            return;
                        }
                        if (scope.equals("mapperImpls")) {
                            this.listMapperPlugins(req, resp);
                            return;
                        }
                        if (scope.equals("mapperRules")) {
                            this.listMapperInsts(req, resp);
                            return;
                        }
                        if (scope.equals("ruleImpls")) {
                            this.listRulePlugins(req, resp);
                            return;
                        }
                        if (scope.equals("ruleRules")) {
                            this.listRuleInsts(req, resp);
                            return;
                        }
                        break block50;
                    }
                    if (op.equals("OP_ADD")) {
                        this.mOp = "modify";
                        this.mToken = super.authorize(req);
                        if (this.mToken == null) {
                            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                            return;
                        }
                        if (scope.equals("publisherImpls")) {
                            this.addPublisherPlugin(req, resp, scope);
                            return;
                        }
                        if (scope.equals("publisherRules")) {
                            this.addPublisherInst(req, resp, scope);
                            return;
                        }
                        if (scope.equals("mapperImpls")) {
                            this.addMapperPlugin(req, resp, scope);
                            return;
                        }
                        if (scope.equals("mapperRules")) {
                            this.addMapperInst(req, resp, scope);
                            return;
                        }
                        if (scope.equals("ruleImpls")) {
                            this.addRulePlugin(req, resp, scope);
                            return;
                        }
                        if (scope.equals("ruleRules")) {
                            this.addRuleInst(req, resp, scope);
                            return;
                        }
                        break block50;
                    }
                    if (op.equals("OP_DELETE")) {
                        this.mOp = "modify";
                        this.mToken = super.authorize(req);
                        if (this.mToken == null) {
                            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                            return;
                        }
                        if (scope.equals("publisherImpls")) {
                            this.delPublisherPlugin(req, resp, scope);
                            return;
                        }
                        if (scope.equals("publisherRules")) {
                            this.delPublisherInst(req, resp, scope);
                            return;
                        }
                        if (scope.equals("mapperImpls")) {
                            this.delMapperPlugin(req, resp, scope);
                            return;
                        }
                        if (scope.equals("mapperRules")) {
                            this.delMapperInst(req, resp, scope);
                            return;
                        }
                        if (scope.equals("ruleImpls")) {
                            this.delRulePlugin(req, resp, scope);
                            return;
                        }
                        if (scope.equals("ruleRules")) {
                            this.delRuleInst(req, resp, scope);
                            return;
                        }
                        break block50;
                    }
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_INVALID_OP_TYPE", (String[])new String[]{op}), null, resp);
                    return;
                }
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", (String[])new String[0]), null, resp);
                return;
            }
            catch (EBaseException e) {
                this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
                return;
            }
        }
        this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_PERFORM_FAILED", (String[])new String[0]), null, resp);
    }

    private IExtendedPluginInfo getExtendedPluginInfo(CAPublisherProcessor p) {
        Enumeration<String> mappers = p.getMapperInsts().keys();
        Enumeration<String> publishers = p.getPublisherInsts().keys();
        StringBuffer map = new StringBuffer();
        while (mappers.hasMoreElements()) {
            String name = mappers.nextElement();
            if (map.length() == 0) {
                map.append(name);
                continue;
            }
            map.append(",");
            map.append(name);
        }
        StringBuffer publish = new StringBuffer();
        while (publishers.hasMoreElements()) {
            String name = publishers.nextElement();
            publish.append(",");
            publish.append(name);
        }
        String[] epi = new String[]{"type;choice(cacert,crl,certs,xcert);The certType of the request", "mapper;choice(" + map.toString() + ");Use the mapper to find the ldap dn to publish the certificate or crl", "publisher;choice(" + publish.toString() + ");Use the publisher to publish the certificate or crl a directory etc", "enable;boolean;", "predicate;string;"};
        return new ExtendedPluginInfo(epi);
    }

    private NameValuePairs getExtendedPluginInfo(String implType, String implName) {
        IExtendedPluginInfo ext_info = null;
        IExtendedPluginInfo impl = null;
        if (implType.equals("publishrule")) {
            p_processor = this.mProcessor;
            impl = this.getExtendedPluginInfo(p_processor);
        } else if (implType.equals("mapperrule")) {
            p_processor = this.mProcessor;
            Plugin plugin = (Plugin)p_processor.getMapperPlugins().get(implName);
            impl = PublisherAdminServlet.getClassByNameAsExtendedPluginInfo((String)plugin.getClassPath());
        } else if (implType.equals("publisher")) {
            p_processor = this.mProcessor;
            Plugin plugin = (Plugin)p_processor.getPublisherPlugins().get(implName);
            impl = PublisherAdminServlet.getClassByNameAsExtendedPluginInfo((String)plugin.getClassPath());
        }
        if (impl != null && impl instanceof IExtendedPluginInfo) {
            ext_info = impl;
        }
        NameValuePairs nvps = null;
        nvps = ext_info == null ? new NameValuePairs() : this.convertStringArrayToNVPairs(ext_info.getExtendedPluginInfo());
        return nvps;
    }

    private void getExtendedPluginInfo(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        int colon = id.indexOf(58);
        String implType = id.substring(0, colon);
        String implName = id.substring(colon + 1);
        NameValuePairs params = this.getExtendedPluginInfo(implType, implName);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getLDAPDest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        CAEngine engine = CAEngine.getInstance();
        CAConfig config = engine.getConfig().getCAConfig();
        PublishingConfig publishcfg = config.getPublishingConfig();
        ConfigStore ldapcfg = publishcfg.getSubStore("ldappublish", ConfigStore.class);
        ConfigStore ldap = ldapcfg.getSubStore("ldap", ConfigStore.class);
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE") || name.equals("enable") || name.equals("publishingEnable") || name.equals("queue.enable") || name.equals("queue.maxNumberOfThreads") || name.equals("queue.pageSize") || name.equals("queue.priorityLevel") || name.equals("queue.saveStatus")) continue;
            if (name.equals("ldapauth.nicknames")) {
                JssSubsystem jssSubsystem = engine.getJSSSubsystem();
                params.put((Object)name, (Object)jssSubsystem.getAllCerts());
                continue;
            }
            String value = ldap.getString(name, "");
            if (value == null || value.equals("")) {
                if (name.equals("ldapconn.host")) {
                    value = this.mConfig.getString("machineName", null);
                } else if (name.equals("ldapconn.port")) {
                    value = "389";
                } else if (name.equals("ldapauth.bindDN")) {
                    value = "cn=Directory Manager";
                }
            }
            params.put((Object)name, (Object)value);
        }
        params.put((Object)"publishingEnable", (Object)publishcfg.getString("enable", "false"));
        params.put((Object)"queue.enable", (Object)publishcfg.getString("queue.enable", "true"));
        params.put((Object)"queue.maxNumberOfThreads", (Object)publishcfg.getString("queue.maxNumberOfThreads", "3"));
        params.put((Object)"queue.pageSize", (Object)publishcfg.getString("queue.pageSize", "40"));
        params.put((Object)"queue.priorityLevel", (Object)publishcfg.getString("queue.priorityLevel", "0"));
        params.put((Object)"queue.saveStatus", (Object)publishcfg.getString("queue.saveStatus", "200"));
        params.put((Object)"enable", (Object)ldapcfg.getString("enable", "false"));
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void setLDAPDest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAConfig config = engine.getConfig().getCAConfig();
        PublishingConfig publishcfg = config.getPublishingConfig();
        ConfigStore ldapcfg = publishcfg.getSubStore("ldappublish", ConfigStore.class);
        ConfigStore ldap = ldapcfg.getSubStore("ldap", ConfigStore.class);
        publishcfg.putString("enable", req.getParameter("publishingEnable"));
        String enable = req.getParameter("enable");
        ldapcfg.putString("enable", enable);
        if (enable.equals("false")) {
            this.mProcessor.setLdapConnModule(null);
        }
        Enumeration e = req.getParameterNames();
        String pwd = null;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE") || name.equals("enable") || name.equals("publishingEnable") || name.equals("ldapauth.bindPassword")) continue;
            if (name.equals("directoryManagerPwd")) {
                pwd = req.getParameter(name);
                continue;
            }
            if (name.equals("queue.enable")) {
                publishcfg.putString(name, req.getParameter(name));
                continue;
            }
            if (name.equals("queue.maxNumberOfThreads")) {
                publishcfg.putString(name, req.getParameter(name));
                continue;
            }
            if (name.equals("queue.pageSize")) {
                publishcfg.putString(name, req.getParameter(name));
                continue;
            }
            if (name.equals("queue.priorityLevel")) {
                publishcfg.putString(name, req.getParameter(name));
                continue;
            }
            if (name.equals("queue.saveStatus")) {
                publishcfg.putString(name, req.getParameter(name));
                continue;
            }
            ldap.putString(name, req.getParameter(name));
        }
        this.commit(true);
        String prompt = ldap.getString("ldapauth.bindPWPrompt");
        PasswordStore pwdStore = engine.getPasswordStore();
        logger.debug("PublisherAdminServlet: setLDAPDest(): saving password for " + prompt + " to password file");
        pwdStore.putPassword(prompt, pwd);
        pwdStore.commit();
        logger.debug("PublisherAdminServlet: setLDAPDest(): password saved");
        try {
            logger.debug("PublisherAdminServlet: setLDAPDest(): restarting publishing processor");
            this.mProcessor.shutdown();
            this.mProcessor.startup();
            logger.debug("PublisherAdminServlet: setLDAPDest(): publishing processor restarted");
        }
        catch (Exception ex) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_FAIL_RES_LDAP", (Object[])new Object[]{ex.toString()}), (Throwable)ex);
        }
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private void testSetLDAPDest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        logger.debug("PublisherAdmineServlet: in testSetLDAPDest");
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig engineConfig = engine.getConfig();
        CAConfig config = engineConfig.getCAConfig();
        PKISocketConfig socketConfig = engineConfig.getSocketConfig();
        PublishingConfig publishcfg = config.getPublishingConfig();
        ConfigStore ldapcfg = publishcfg.getSubStore("ldappublish", ConfigStore.class);
        LDAPConfig ldap = (LDAPConfig)ldapcfg.getSubStore("ldap", LDAPConfig.class);
        LDAPAuthenticationConfig authConfig = ldap.getAuthenticationConfig();
        publishcfg.putString("enable", req.getParameter("publishingEnable"));
        String ldapPublish = req.getParameter("enable");
        ldapcfg.putString("enable", ldapPublish);
        if (ldapPublish.equals("false")) {
            this.mProcessor.setLdapConnModule(null);
        }
        Enumeration e = req.getParameterNames();
        String pwd = null;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE") || name.equals("enable") || name.equals("publishingEnable") || name.equals("ldapauth.bindPassword")) continue;
            if (name.equals("directoryManagerPwd")) {
                pwd = req.getParameter(name);
                continue;
            }
            if (name.equals("queue.enable")) {
                publishcfg.putString(name, req.getParameter(name));
                continue;
            }
            if (name.equals("queue.maxNumberOfThreads")) {
                publishcfg.putString(name, req.getParameter(name));
                continue;
            }
            if (name.equals("queue.pageSize")) {
                publishcfg.putString(name, req.getParameter(name));
                continue;
            }
            if (name.equals("queue.priorityLevel")) {
                publishcfg.putString(name, req.getParameter(name));
                continue;
            }
            if (name.equals("queue.saveStatus")) {
                publishcfg.putString(name, req.getParameter(name));
                continue;
            }
            ldap.putString(name, req.getParameter(name));
        }
        if (publishcfg.getBoolean("enable") && ldapcfg.getBoolean("enable")) {
            params.put((Object)"title", (Object)"You've attempted to configure CMS to connect to a LDAP directory. The connection status is as follows:\n \n");
            LDAPConnection conn = null;
            LdapConnInfo connInfo = new LdapConnInfo(ldap.getConnectionConfig());
            String host = connInfo.getHost();
            int port = connInfo.getPort();
            boolean secure = connInfo.getSecure();
            String authType = authConfig.getAuthType();
            int version = connInfo.getVersion();
            String bindAs = null;
            String certNickName = null;
            if (authType.equals("SslClientAuth")) {
                try {
                    certNickName = authConfig.getClientCertNickname();
                    PKISocketFactory socketFactory = new PKISocketFactory();
                    socketFactory.setAuditor(engine.getAuditor());
                    socketFactory.addSocketListener((SSLSocketListener)engine.getClientSocketListener());
                    socketFactory.setSecure(true);
                    socketFactory.setClientCertNickname(certNickName);
                    socketFactory.init(socketConfig);
                    conn = new LDAPConnection((LDAPSocketFactory)socketFactory);
                    logger.debug("Publishing Test certNickName=" + certNickName);
                    params.put((Object)"connInited", (Object)("Create ssl LDAPConnection with certificate: " + certNickName + this.dashes(26 - certNickName.length()) + " Success"));
                }
                catch (Exception ex) {
                    params.put((Object)"connInitFail", (Object)("Create ssl LDAPConnection with certificate: " + certNickName + this.dashes(26 - certNickName.length()) + " failure\n exception: " + ex));
                    params.put((Object)"saveOrNot", (Object)"\n \nIf the problem is not fixed then LDAP publishing will fail.\nDo you want to save the configuration anyway?");
                    this.sendResponse(SUCCESS, null, params, resp);
                    return;
                }
                try {
                    conn.connect(host, port);
                    params.put((Object)"connOk", (Object)("Connect to directory server " + host + " at port " + port + this.dashes(33 - host.length() - Integer.valueOf(port).toString().length()) + " Success"));
                    params.put((Object)"authOk", (Object)("Authentication: SSL client authentication" + this.dashes(29) + " Success\nBind to the directory as: " + certNickName + this.dashes(44 - certNickName.length()) + " Success"));
                }
                catch (LDAPException ex) {
                    if (ex.getLDAPResultCode() == 52) {
                        params.put((Object)"connFail", (Object)("Connect to directory server " + host + " at port " + port + this.dashes(33 - host.length() - Integer.valueOf(port).toString().length()) + " Failure\n error: server unavailable"));
                    } else {
                        params.put((Object)"connFail", (Object)("Connect to directory server " + host + " at port " + port + this.dashes(33 - host.length() - Integer.valueOf(port).toString().length()) + " Failure"));
                    }
                    params.put((Object)"saveOrNot", (Object)"\n \nIf the problem is not fixed then LDAP publishing will fail.\nDo you want to save the configuration anyway?");
                    this.sendResponse(SUCCESS, null, params, resp);
                    return;
                }
            }
            try {
                PKISocketFactory socketFactory = new PKISocketFactory();
                socketFactory.setAuditor(engine.getAuditor());
                socketFactory.addSocketListener((SSLSocketListener)engine.getClientSocketListener());
                socketFactory.setSecure(secure);
                socketFactory.init(socketConfig);
                conn = new LDAPConnection((LDAPSocketFactory)socketFactory);
                if (secure) {
                    params.put((Object)"connInited", (Object)("Create ssl LDAPConnection" + this.dashes(45) + " Success"));
                } else {
                    params.put((Object)"connInited", (Object)("Create LDAPConnection" + this.dashes(49) + " Success"));
                }
            }
            catch (Exception ex) {
                params.put((Object)"connInitFail", (Object)("Create LDAPConnection" + this.dashes(49) + " Failure\nexception: " + ex));
                params.put((Object)"saveOrNot", (Object)"\n \nIf the problem is not fixed then LDAP publishing will fail.\nDo you want to save the configuration anyway?");
                this.sendResponse(SUCCESS, null, params, resp);
                return;
            }
            try {
                conn.connect(host, port);
                params.put((Object)"connOk", (Object)("Connect to directory server " + host + " at port " + port + this.dashes(33 - host.length() - Integer.valueOf(port).toString().length()) + " Success"));
            }
            catch (LDAPException ex) {
                if (ex.getLDAPResultCode() == 52) {
                    params.put((Object)"connFail", (Object)("Connect to directory server " + host + " at port " + port + this.dashes(33 - host.length() - Integer.valueOf(port).toString().length()) + " Failure\nerror: server unavailable"));
                } else {
                    params.put((Object)"connFail", (Object)("Connect to directory server " + host + " at port " + port + this.dashes(33 - host.length() - Integer.valueOf(port).toString().length()) + " Failure\nexception: " + ex));
                }
                params.put((Object)"saveOrNot", (Object)"\n \nIf the problem is not fixed then LDAP publishing will fail.\nDo you want to save the configuration anyway?");
                this.sendResponse(SUCCESS, null, params, resp);
                return;
            }
            try {
                bindAs = authConfig.getBindDN();
                conn.authenticate(version, bindAs, pwd);
                params.put((Object)"authOk", (Object)("Authentication: Basic authentication" + this.dashes(34) + " Success\nBind to the directory as: " + bindAs + this.dashes(44 - bindAs.length()) + " Success"));
            }
            catch (LDAPException ex) {
                if (ex.getLDAPResultCode() == 32) {
                    params.put((Object)"authFail", (Object)("Authentication: Basic authentication" + this.dashes(34) + "Failure\nBind to the directory as: " + bindAs + this.dashes(44 - bindAs.length()) + "Failure\nThe object doesn't exist. Please correct the value assigned in the \"Directory manager DN\" field."));
                } else if (ex.getLDAPResultCode() == 49) {
                    params.put((Object)"authFail", (Object)("Authentication: Basic authentication" + this.dashes(34) + " Failure\nBind to the directory as: " + bindAs + this.dashes(44 - bindAs.length()) + " Failure\nInvalid password. Please correct the value assigned in the \"Password\" field."));
                } else {
                    params.put((Object)"authFail", (Object)("Authentication: Basic authentication" + this.dashes(34) + " Failure\nBind to the directory as: " + bindAs + this.dashes(44 - bindAs.length()) + " Failure"));
                }
                params.put((Object)"saveOrNot", (Object)"\n \nIf the problem is not fixed then LDAP publishing will fail.\nDo you want to save the configuration anyway?");
                this.sendResponse(SUCCESS, null, params, resp);
                return;
            }
        }
        if (ldapcfg.getBoolean("enable") && pwd != null) {
            String prompt = ldap.getString("ldapauth.bindPWPrompt");
            PasswordStore pwdStore = engine.getPasswordStore();
            logger.debug("PublisherAdminServlet: testSetLDAPDest(): saving password for " + prompt + " to password file");
            pwdStore.putPassword(prompt, pwd);
            pwdStore.commit();
            logger.debug("PublisherAdminServlet: testSetLDAPDest(): password saved");
        }
        this.mProcessor.shutdown();
        if (publishcfg.getBoolean("enable")) {
            this.mProcessor.startup();
            if (ldapcfg.getBoolean("enable")) {
                CertificateAuthority ca = this.mProcessor.getAuthority();
                try {
                    this.mProcessor.publishCACert((X509Certificate)ca.getCACert());
                    logger.debug("PublisherAdminServlet: " + CMS.getLogMessage((String)"ADMIN_SRVLT_PUB_CA_CERT", (Object[])new Object[0]));
                    params.put((Object)"publishCA", (Object)"CA certificate is published.");
                }
                catch (Exception ex) {
                    logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_NO_PUB_CA_CERT", (Object[])new Object[]{ex.toString()}), (Throwable)ex);
                    params.put((Object)"publishCA", (Object)"Failed to publish CA certificate.");
                    int index = ex.toString().indexOf("Failed to create CA");
                    if (index > -1) {
                        params.put((Object)"createError", (Object)ex.toString().substring(index));
                    }
                    this.mProcessor.shutdown();
                    params.put((Object)"saveOrNot", (Object)"\n \nIf the problem is not fixed then the CA certificate won't be published.\nDo you want to enable LDAP publishing anyway?");
                    this.sendResponse(SUCCESS, null, params, resp);
                    return;
                }
                try {
                    logger.debug("PublisherAdminServlet: about to update CRL");
                    CRLIssuingPoint masterCRLIssuingPoint = engine.getMasterCRLIssuingPoint();
                    if (masterCRLIssuingPoint != null) {
                        masterCRLIssuingPoint.publishCRL();
                    }
                    logger.debug(CMS.getLogMessage((String)"ADMIN_SRVLT_PUB_CRL", (Object[])new Object[0]));
                    params.put((Object)"publishCRL", (Object)"CRL is published.");
                }
                catch (Exception ex) {
                    logger.warn("Could not publish crl " + ex.toString(), (Throwable)ex);
                    params.put((Object)"publishCRL", (Object)"Failed to publish CRL.");
                    this.mProcessor.shutdown();
                    params.put((Object)"saveOrNot", (Object)"\n \nIf the problem is not fixed then the CRL won't be published.\nDo you want to enable LDAP publishing anyway?");
                    this.sendResponse(SUCCESS, null, params, resp);
                    return;
                }
            }
            this.commit(true);
            params.put((Object)"saveOk", (Object)"\n \nConfiguration changes are now committed.");
            params.put((Object)"restarted", (Object)"Publishing is restarted.");
        } else {
            this.commit(true);
            params.put((Object)"saveOk", (Object)"\n \nConfiguration changes are now committed.");
            params.put((Object)"stopped", (Object)"Publishing is stopped.");
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void addMapperPlugin(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (this.mProcessor.getMapperPlugins().containsKey(id)) {
            this.sendResponse(ERROR, new ELdapException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_PLUGIN_ID", (String[])new String[]{id})).toString(), null, resp);
            return;
        }
        String classPath = req.getParameter("class");
        if (classPath == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_NULL_CLASS", (String[])new String[0]), null, resp);
            return;
        }
        PublishingMapperConfig destStore = this.publishingConfig.getMapperConfig();
        ConfigStore instancesConfig = destStore.getSubStore("impl", ConfigStore.class);
        Class<?> newImpl = null;
        try {
            newImpl = Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_NO_CLASS", (String[])new String[0]), null, resp);
            return;
        }
        catch (IllegalArgumentException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_NO_CLASS", (String[])new String[0]), null, resp);
            return;
        }
        try {
            if (!Mapper.class.isAssignableFrom(newImpl)) {
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_CLASS", (String[])new String[]{classPath}), null, resp);
                return;
            }
        }
        catch (NullPointerException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_CLASS", (String[])new String[]{classPath}), null, resp);
            return;
        }
        ConfigStore substore = instancesConfig.makeSubStore(id);
        substore.put("class", classPath);
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        MapperPlugin plugin = new MapperPlugin(id, classPath);
        this.mProcessor.getMapperPlugins().put(id, plugin);
        logger.info(CMS.getLogMessage((String)"ADMIN_SRVLT_MAPPER_ADDED", (Object[])new Object[]{""}));
        NameValuePairs params = new NameValuePairs();
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private boolean isValidID(String id) {
        if (id == null) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            if (Character.isLetterOrDigit(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private synchronized void addMapperInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.isValidID(id)) {
            this.sendResponse(ERROR, "Invalid ID '" + id + "'", null, resp);
            return;
        }
        if (this.mProcessor.getMapperInsts().containsKey(id)) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_INST_ID", (String[])new String[]{id}), null, resp);
            return;
        }
        String implname = req.getParameter("implName");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ADD_MISSING_PARAMS", (String[])new String[0]), null, resp);
            return;
        }
        MapperPlugin plugin = this.mProcessor.getMapperPlugins().get(implname);
        if (plugin == null) {
            this.sendResponse(ERROR, new EMapperPluginNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_MAPPER_PLUGIN_NOT_FOUND", (String[])new String[]{implname})).toString(), null, resp);
            return;
        }
        Vector<String> configParams = this.mProcessor.getMapperDefaultParams(implname);
        PublishingMapperConfig destStore = this.publishingConfig.getMapperConfig();
        ConfigStore instancesConfig = destStore.getSubStore("instance", ConfigStore.class);
        ConfigStore substore = instancesConfig.makeSubStore(id);
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                int index;
                String kv = configParams.elementAt(i);
                String val = req.getParameter(kv.substring(0, index = kv.indexOf(61)));
                if (val == null) {
                    substore.put(kv.substring(0, index), kv.substring(index + 1));
                    continue;
                }
                substore.put(kv.substring(0, index), val);
            }
        }
        substore.put("pluginName", implname);
        String className = plugin.getClassPath();
        Mapper mapperInst = null;
        try {
            mapperInst = (Mapper)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            instancesConfig.removeSubStore(id);
            this.sendResponse(ERROR, new ELdapException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className})).toString(), null, resp);
            return;
        }
        try {
            mapperInst.init(substore);
        }
        catch (EBaseException e) {
            instancesConfig.removeSubStore(id);
            this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
            return;
        }
        catch (Throwable e) {
            instancesConfig.removeSubStore(id);
            this.sendResponse(ERROR, e.toString(), null, resp);
            return;
        }
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            instancesConfig.removeSubStore(id);
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        this.mProcessor.getMapperInsts().put(id, new MapperProxy(true, mapperInst));
        logger.info(CMS.getLogMessage((String)"ADMIN_SRVLT_MAPPER_INST_ADDED", (Object[])new Object[]{id}));
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)implname);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void listMapperPlugins(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<String> e = this.mProcessor.getMapperPlugins().keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            MapperPlugin value = this.mProcessor.getMapperPlugins().get(name);
            String c = value.getClassPath();
            String desc = "unknown";
            try {
                Mapper lp = (Mapper)Class.forName(c).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                desc = lp.getDescription();
            }
            catch (Exception exp) {
                this.sendResponse(ERROR, exp.toString(), null, resp);
                return;
            }
            params.put((Object)name, (Object)(value.getClassPath() + "," + desc));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    public String getMapperPluginName(Mapper mapper) {
        ConfigStore cs = mapper.getConfigStore();
        try {
            return cs.getString("pluginName", "");
        }
        catch (EBaseException e) {
            return "";
        }
    }

    private synchronized void listMapperInsts(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<String> e = this.mProcessor.getMapperInsts().keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Mapper value = this.mProcessor.getMapperInstance(name);
            params.put((Object)name, (Object)(this.getMapperPluginName(value) + ";visible"));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void delMapperInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.mProcessor.getMapperInsts().containsKey(id)) {
            this.sendResponse(ERROR, new EMapperNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_MAPPER_NOT_FOUND", (String[])new String[]{id})).toString(), null, resp);
            return;
        }
        this.mProcessor.getMapperInsts().remove(id);
        PublishingMapperConfig destStore = this.publishingConfig.getMapperConfig();
        ConfigStore instancesConfig = destStore.getSubStore("instance", ConfigStore.class);
        instancesConfig.removeSubStore(id);
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void delMapperPlugin(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.mProcessor.getMapperPlugins().containsKey(id)) {
            this.sendResponse(ERROR, new EMapperPluginNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_MAPPER_PLUGIN_NOT_FOUND", (String[])new String[]{id})).toString(), null, resp);
            return;
        }
        Enumeration<String> e = this.mProcessor.getMapperInsts().keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Mapper mapper = this.mProcessor.getMapperInstance(name);
            if (!id.equals(this.getMapperPluginName(mapper))) continue;
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_IN_USE", (String[])new String[0]), null, resp);
            return;
        }
        this.mProcessor.getMapperPlugins().remove(id);
        PublishingMapperConfig destStore = this.publishingConfig.getMapperConfig();
        ConfigStore instancesConfig = destStore.getSubStore("impl", ConfigStore.class);
        instancesConfig.removeSubStore(id);
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e2) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void getMapperConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String implname = req.getParameter("RS_ID");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        Vector<String> configParams = this.mProcessor.getMapperDefaultParams(implname);
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)"");
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                String kv = configParams.elementAt(i);
                int index = kv.indexOf(61);
                params.put((Object)kv.substring(0, index), (Object)kv.substring(index + 1));
            }
        }
        this.sendResponse(0, null, params, resp);
    }

    private synchronized void getMapperInstConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.mProcessor.getMapperInsts().containsKey(id)) {
            this.sendResponse(ERROR, new EMapperNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_MAPPER_NOT_FOUND", (String[])new String[]{id})).toString(), null, resp);
            return;
        }
        Mapper mapperInst = this.mProcessor.getMapperInstance(id);
        Vector configParams = mapperInst.getInstanceParams();
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)this.getMapperPluginName(mapperInst));
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                String kv = (String)configParams.elementAt(i);
                int index = kv.indexOf(61);
                params.put((Object)kv.substring(0, index), (Object)kv.substring(index + 1));
            }
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void modMapperInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.mProcessor.getMapperInsts().containsKey(id)) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_INST_ID", (String[])new String[]{id}), null, resp);
            return;
        }
        String implname = req.getParameter("implName");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ADD_MISSING_PARAMS", (String[])new String[0]), null, resp);
            return;
        }
        MapperPlugin plugin = this.mProcessor.getMapperPlugins().get(implname);
        if (plugin == null) {
            this.sendResponse(ERROR, new EMapperPluginNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_MAPPER_PLUGIN_NOT_FOUND", (String[])new String[]{implname})).toString(), null, resp);
            return;
        }
        Mapper oldinst = this.mProcessor.getMapperInstance(id);
        Vector oldConfigParms = oldinst.getInstanceParams();
        NameValuePairs saveParams = new NameValuePairs();
        saveParams.put((Object)"pluginName", (Object)implname);
        if (oldConfigParms != null) {
            for (int i = 0; i < oldConfigParms.size(); ++i) {
                String kv = (String)oldConfigParms.elementAt(i);
                int index = kv.indexOf(61);
                saveParams.put((Object)kv.substring(0, index), (Object)kv.substring(index + 1));
            }
        }
        PublishingMapperConfig destStore = this.publishingConfig.getMapperConfig();
        ConfigStore instancesConfig = destStore.getSubStore("instance", ConfigStore.class);
        Vector<String> configParams = this.mProcessor.getMapperInstanceParams(id);
        instancesConfig.removeSubStore(id);
        ConfigStore substore = instancesConfig.makeSubStore(id);
        substore.put("pluginName", implname);
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                int index;
                String kv = configParams.elementAt(i);
                String key = kv.substring(0, index = kv.indexOf(61));
                String val = req.getParameter(key);
                if (val == null) continue;
                substore.put(key, val);
            }
        }
        String className = plugin.getClassPath();
        Mapper newMgrInst = null;
        try {
            newMgrInst = (Mapper)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            PublisherAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, new ELdapException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className})).toString(), null, resp);
            return;
        }
        try {
            newMgrInst.init(substore);
        }
        catch (EBaseException e) {
            PublisherAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
            return;
        }
        catch (Throwable e) {
            PublisherAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, e.toString(), null, resp);
            return;
        }
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            PublisherAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        this.mProcessor.getMapperInsts().put(id, new MapperProxy(true, newMgrInst));
        logger.info(CMS.getLogMessage((String)"ADMIN_SRVLT_MAPPER_REPLACED", (Object[])new Object[]{id}));
        NameValuePairs params = new NameValuePairs();
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void addRulePlugin(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (this.mProcessor.getRulePlugins().containsKey(id)) {
            this.sendResponse(ERROR, new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_SRVLT_ILL_PLUGIN_ID", (String[])new String[]{id})).toString(this.getLocale(req)), null, resp);
            return;
        }
        String classPath = req.getParameter("class");
        if (classPath == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((String)"CMS_LDAP_SRVLT_NULL_CLASS", (String[])new String[0]), null, resp);
            return;
        }
        PublishingRuleConfig destStore = this.publishingConfig.getRuleConfig();
        ConfigStore instancesConfig = destStore.getSubStore("impl", ConfigStore.class);
        Class<?> newImpl = null;
        try {
            newImpl = Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_NO_CLASS", (String[])new String[0]), null, resp);
            return;
        }
        catch (IllegalArgumentException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_NO_CLASS", (String[])new String[0]), null, resp);
            return;
        }
        try {
            if (!LdapRule.class.isAssignableFrom(newImpl)) {
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_CLASS", (String[])new String[]{classPath}), null, resp);
                return;
            }
        }
        catch (NullPointerException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_CLASS", (String[])new String[]{classPath}), null, resp);
            return;
        }
        ConfigStore substore = instancesConfig.makeSubStore(id);
        substore.put("class", classPath);
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        RulePlugin plugin = new RulePlugin(id, classPath);
        this.mProcessor.getRulePlugins().put(id, plugin);
        logger.info(CMS.getLogMessage((String)"ADMIN_SRVLT_RULE_PLUG_ADDED", (Object[])new Object[]{id}));
        NameValuePairs params = new NameValuePairs();
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void addRuleInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.isValidID(id)) {
            this.sendResponse(ERROR, "Invalid ID '" + id + "'", null, resp);
            return;
        }
        if (this.mProcessor.getRuleInsts().containsKey(id)) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_INST_ID", (String[])new String[]{id}), null, resp);
            return;
        }
        String implname = req.getParameter("implName");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ADD_MISSING_PARAMS", (String[])new String[0]), null, resp);
            return;
        }
        RulePlugin plugin = this.mProcessor.getRulePlugins().get(implname);
        if (plugin == null) {
            this.sendResponse(ERROR, new EPublisherPluginNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_PUBLISHER_PLUGIN_NOT_FOUND", (String[])new String[]{implname})).toString(), null, resp);
            return;
        }
        Vector<String> configParams = this.mProcessor.getRuleDefaultParams(implname);
        PublishingRuleConfig destStore = this.publishingConfig.getRuleConfig();
        ConfigStore instancesConfig = destStore.getSubStore("instance", ConfigStore.class);
        ConfigStore substore = instancesConfig.makeSubStore(id);
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                int index;
                String kv = configParams.elementAt(i);
                String val = req.getParameter(kv.substring(0, index = kv.indexOf(61)));
                if (val == null) {
                    substore.put(kv.substring(0, index), kv.substring(index + 1));
                    continue;
                }
                if (val.equals(NOMAPPER)) {
                    val = "";
                }
                substore.put(kv.substring(0, index), val);
            }
        }
        substore.put("pluginName", implname);
        String className = plugin.getClassPath();
        LdapRule ruleInst = null;
        try {
            ruleInst = (LdapRule)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            instancesConfig.removeSubStore(id);
            this.sendResponse(ERROR, new ELdapException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className})).toString(), null, resp);
            return;
        }
        try {
            Hashtable<String, MapperProxy> mappers = this.mProcessor.getMapperInsts();
            Hashtable<String, PublisherProxy> publishers = this.mProcessor.getPublisherInsts();
            ruleInst.init(mappers, publishers, substore);
            ruleInst.setInstanceName(id);
        }
        catch (EBaseException e) {
            instancesConfig.removeSubStore(id);
            this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
            return;
        }
        catch (Throwable e) {
            instancesConfig.removeSubStore(id);
            this.sendResponse(ERROR, e.toString(), null, resp);
            return;
        }
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            instancesConfig.removeSubStore(id);
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        this.mProcessor.getRuleInsts().put(id, ruleInst);
        logger.info(CMS.getLogMessage((String)"ADMIN_SRVLT_RULE_INST_ADDED", (Object[])new Object[]{id}));
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)implname);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void listRulePlugins(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<String> e = this.mProcessor.getRulePlugins().keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            RulePlugin value = this.mProcessor.getRulePlugins().get(name);
            String c = value.getClassPath();
            String desc = "unknown";
            try {
                LdapRule lp = (LdapRule)Class.forName(c).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                desc = lp.getDescription();
            }
            catch (Exception exception) {
                // empty catch block
            }
            params.put((Object)name, (Object)(value.getClassPath() + "," + desc));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void listRuleInsts(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<String> e = this.mProcessor.getRuleInsts().keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            LdapRule value = this.mProcessor.getRuleInsts().get(name);
            String enabled = value.enabled() ? "enabled" : "disabled";
            params.put((Object)name, (Object)(value.getInstanceName() + ";visible;" + enabled));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    public String getRulePluginName(LdapRule rule) {
        ConfigStore cs = rule.getConfigStore();
        try {
            return cs.getString("pluginName", "");
        }
        catch (EBaseException e) {
            return "";
        }
    }

    private synchronized void delRulePlugin(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.mProcessor.getRulePlugins().containsKey(id)) {
            this.sendResponse(ERROR, new ERulePluginNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_RULE_PLUGIN_NOT_FOUND", (String[])new String[]{id})).toString(), null, resp);
            return;
        }
        Enumeration<LdapRule> e = this.mProcessor.getRuleInsts().elements();
        while (e.hasMoreElements()) {
            LdapRule rule = e.nextElement();
            if (!id.equals(this.getRulePluginName(rule))) continue;
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_IN_USE", (String[])new String[0]), null, resp);
            return;
        }
        this.mProcessor.getRulePlugins().remove(id);
        PublishingRuleConfig destStore = this.publishingConfig.getRuleConfig();
        ConfigStore instancesConfig = destStore.getSubStore("impl", ConfigStore.class);
        instancesConfig.removeSubStore(id);
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e2) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void delRuleInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.mProcessor.getRuleInsts().containsKey(id)) {
            this.sendResponse(ERROR, new ERuleNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_RULE_NOT_FOUND", (String[])new String[]{id})).toString(), null, resp);
            return;
        }
        this.mProcessor.getRuleInsts().remove(id);
        PublishingRuleConfig destStore = this.publishingConfig.getRuleConfig();
        ConfigStore instancesConfig = destStore.getSubStore("instance", ConfigStore.class);
        instancesConfig.removeSubStore(id);
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void getRuleConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String implname = req.getParameter("RS_ID");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        Vector<String> configParams = this.mProcessor.getRuleDefaultParams(implname);
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)"");
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                String kv = configParams.elementAt(i);
                int index = kv.indexOf(61);
                params.put((Object)kv.substring(0, index), (Object)kv.substring(index + 1));
            }
        }
        this.sendResponse(0, null, params, resp);
    }

    private synchronized void getRuleInstConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.mProcessor.getRuleInsts().containsKey(id)) {
            this.sendResponse(ERROR, new ERuleNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_RULE_NOT_FOUND", (String[])new String[]{id})).toString(), null, resp);
            return;
        }
        LdapRule ruleInst = this.mProcessor.getRuleInsts().get(id);
        Vector<String> configParams = ruleInst.getInstanceParams();
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)this.getRulePluginName(ruleInst));
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                String kv = configParams.elementAt(i);
                int index = kv.indexOf(61);
                params.put((Object)kv.substring(0, index), (Object)kv.substring(index + 1));
            }
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void modRuleInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.mProcessor.getRuleInsts().containsKey(id)) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_INST_ID", (String[])new String[]{id}), null, resp);
            return;
        }
        String implname = req.getParameter("implName");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ADD_MISSING_PARAMS", (String[])new String[0]), null, resp);
            return;
        }
        RulePlugin plugin = this.mProcessor.getRulePlugins().get(implname);
        if (plugin == null) {
            this.sendResponse(ERROR, "", null, resp);
            return;
        }
        LdapRule oldinst = this.mProcessor.getRuleInsts().get(id);
        Vector<String> oldConfigParms = oldinst.getInstanceParams();
        NameValuePairs saveParams = new NameValuePairs();
        saveParams.put((Object)"pluginName", (Object)implname);
        if (oldConfigParms != null) {
            for (int i = 0; i < oldConfigParms.size(); ++i) {
                String kv = oldConfigParms.elementAt(i);
                int index = kv.indexOf(61);
                saveParams.put((Object)kv.substring(0, index), (Object)kv.substring(index + 1));
            }
        }
        PublishingRuleConfig destStore = this.publishingConfig.getRuleConfig();
        ConfigStore instancesConfig = destStore.getSubStore("instance", ConfigStore.class);
        Vector<String> configParams = this.mProcessor.getRuleDefaultParams(implname);
        instancesConfig.removeSubStore(id);
        ConfigStore substore = instancesConfig.makeSubStore(id);
        substore.put("pluginName", implname);
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                int index;
                String kv = configParams.elementAt(i);
                String key = kv.substring(0, index = kv.indexOf(61));
                String val = req.getParameter(key);
                if (val == null) {
                    substore.put(key, kv.substring(index + 1));
                    continue;
                }
                if (val.equals(NOMAPPER)) {
                    val = "";
                }
                substore.put(key, val);
            }
        }
        String className = plugin.getClassPath();
        LdapRule newRuleInst = null;
        try {
            newRuleInst = (LdapRule)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            PublisherAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, new ELdapException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className})).toString(), null, resp);
            return;
        }
        try {
            Hashtable<String, MapperProxy> mappers = this.mProcessor.getMapperInsts();
            Hashtable<String, PublisherProxy> publishers = this.mProcessor.getPublisherInsts();
            newRuleInst.init(mappers, publishers, substore);
        }
        catch (EBaseException e) {
            PublisherAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
            return;
        }
        catch (Throwable e) {
            PublisherAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, e.toString(), null, resp);
            return;
        }
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            PublisherAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        this.mProcessor.getRuleInsts().put(id, newRuleInst);
        logger.info(CMS.getLogMessage((String)"ADMIN_SRVLT_RULE_INST_REP", (Object[])new Object[]{id}));
        NameValuePairs params = new NameValuePairs();
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void addPublisherPlugin(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (this.mProcessor.getPublisherPlugins().containsKey(id)) {
            this.sendResponse(ERROR, new ELdapException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_PLUGIN_ID", (String[])new String[]{id})).toString(), null, resp);
            return;
        }
        String classPath = req.getParameter("class");
        if (classPath == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_NULL_CLASS", (String[])new String[0]), null, resp);
            return;
        }
        PublishingPublisherConfig destStore = this.publishingConfig.getPublisherConfig();
        ConfigStore instancesConfig = destStore.getSubStore("impl", ConfigStore.class);
        Class<?> newImpl = null;
        try {
            newImpl = Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_NO_CLASS", (String[])new String[0]), null, resp);
            return;
        }
        catch (IllegalArgumentException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_NO_CLASS", (String[])new String[0]), null, resp);
            return;
        }
        try {
            if (!Publisher.class.isAssignableFrom(newImpl)) {
                this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_CLASS", (String[])new String[]{classPath}), null, resp);
                return;
            }
        }
        catch (NullPointerException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_CLASS", (String[])new String[]{classPath}), null, resp);
            return;
        }
        ConfigStore substore = instancesConfig.makeSubStore(id);
        substore.put("class", classPath);
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        PublisherPlugin plugin = new PublisherPlugin(id, classPath);
        this.mProcessor.getPublisherPlugins().put(id, plugin);
        logger.info(CMS.getLogMessage((String)"ADMIN_SRVLT_PUB_PLUG_ADDED", (Object[])new Object[]{id}));
        NameValuePairs params = new NameValuePairs();
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void addPublisherInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.isValidID(id)) {
            this.sendResponse(ERROR, "Invalid ID '" + id + "'", null, resp);
            return;
        }
        if (this.mProcessor.getPublisherInsts().containsKey(id)) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_INST_ID", (String[])new String[]{id}), null, resp);
            return;
        }
        String implname = req.getParameter("implName");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ADD_MISSING_PARAMS", (String[])new String[0]), null, resp);
            return;
        }
        PublisherPlugin plugin = this.mProcessor.getPublisherPlugins().get(implname);
        if (plugin == null) {
            this.sendResponse(ERROR, new EPublisherPluginNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_PUBLISHER_PLUGIN_NOT_FOUND", (String[])new String[]{implname})).toString(), null, resp);
            return;
        }
        Vector<String> configParams = this.mProcessor.getPublisherDefaultParams(implname);
        PublishingPublisherConfig destStore = this.publishingConfig.getPublisherConfig();
        ConfigStore instancesConfig = destStore.getSubStore("instance", ConfigStore.class);
        ConfigStore substore = instancesConfig.makeSubStore(id);
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                String kv = configParams.elementAt(i);
                int index = kv.indexOf(61);
                String val = null;
                val = index == -1 ? req.getParameter(kv) : req.getParameter(kv.substring(0, index));
                if (val == null) {
                    if (index == -1) {
                        substore.put(kv, "");
                        continue;
                    }
                    substore.put(kv.substring(0, index), kv.substring(index + 1));
                    continue;
                }
                if (index == -1) {
                    substore.put(kv, val);
                    continue;
                }
                substore.put(kv.substring(0, index), val);
            }
        }
        substore.put("pluginName", implname);
        String className = plugin.getClassPath();
        Publisher publisherInst = null;
        try {
            publisherInst = (Publisher)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            instancesConfig.removeSubStore(id);
            this.sendResponse(ERROR, new ELdapException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className})).toString(), null, resp);
            return;
        }
        try {
            publisherInst.init(substore);
        }
        catch (EBaseException e) {
            instancesConfig.removeSubStore(id);
            this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
            return;
        }
        catch (Throwable e) {
            instancesConfig.removeSubStore(id);
            this.sendResponse(ERROR, e.toString(), null, resp);
            return;
        }
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            instancesConfig.removeSubStore(id);
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        this.mProcessor.getPublisherInsts().put(id, new PublisherProxy(true, publisherInst));
        logger.info(CMS.getLogMessage((String)"ADMIN_SRVLT_PUB_INST_ADDED", (Object[])new Object[]{id}));
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)implname);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void listPublisherPlugins(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<String> e = this.mProcessor.getPublisherPlugins().keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            PublisherPlugin value = this.mProcessor.getPublisherPlugins().get(name);
            String c = value.getClassPath();
            String desc = "unknown";
            try {
                Publisher lp = (Publisher)Class.forName(c).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                desc = lp.getDescription();
            }
            catch (Exception exception) {
                // empty catch block
            }
            params.put((Object)name, (Object)(value.getClassPath() + "," + desc));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    public String getPublisherPluginName(Publisher pub) {
        ConfigStore cs = pub.getConfigStore();
        try {
            return cs.getString("pluginName", "");
        }
        catch (EBaseException e) {
            return "";
        }
    }

    private synchronized void listPublisherInsts(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<String> e = this.mProcessor.getPublisherInsts().keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Publisher value = this.mProcessor.getPublisherInstance(name);
            if (value == null) continue;
            params.put((Object)name, (Object)(this.getPublisherPluginName(value) + ";visible"));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void delPublisherPlugin(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.mProcessor.getPublisherPlugins().containsKey(id)) {
            this.sendResponse(ERROR, new EPublisherPluginNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_PUBLISHER_PLUGIN_NOT_FOUND", (String[])new String[]{id})).toString(), null, resp);
            return;
        }
        Enumeration<String> e = this.mProcessor.getPublisherInsts().keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Publisher publisher = this.mProcessor.getPublisherInstance(name);
            if (!id.equals(this.getPublisherPluginName(publisher))) continue;
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_IN_USE", (String[])new String[0]), null, resp);
            return;
        }
        this.mProcessor.getPublisherPlugins().remove(id);
        PublishingPublisherConfig destStore = this.publishingConfig.getPublisherConfig();
        ConfigStore instancesConfig = destStore.getSubStore("impl", ConfigStore.class);
        instancesConfig.removeSubStore(id);
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e2) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void delPublisherInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.mProcessor.getPublisherInsts().containsKey(id)) {
            this.sendResponse(ERROR, new EPublisherNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_PUBLISHER_NOT_FOUND", (String[])new String[]{id})).toString(), null, resp);
            return;
        }
        this.mProcessor.getPublisherInsts().remove(id);
        PublishingPublisherConfig destStore = this.publishingConfig.getPublisherConfig();
        ConfigStore instancesConfig = destStore.getSubStore("instance", ConfigStore.class);
        instancesConfig.removeSubStore(id);
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void getConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String implname = req.getParameter("RS_ID");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        Vector<String> configParams = this.mProcessor.getPublisherDefaultParams(implname);
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)"");
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                String kv = configParams.elementAt(i);
                int index = kv.indexOf(61);
                if (index == -1) {
                    params.put((Object)kv, (Object)"");
                    continue;
                }
                params.put((Object)kv.substring(0, index), (Object)kv.substring(index + 1));
            }
        }
        this.sendResponse(0, null, params, resp);
    }

    private synchronized void getInstConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.mProcessor.getPublisherInsts().containsKey(id)) {
            this.sendResponse(ERROR, new EPublisherNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_PUBLISHER_NOT_FOUND", (String[])new String[]{id})).toString(), null, resp);
            return;
        }
        Publisher publisherInst = this.mProcessor.getPublisherInstance(id);
        Vector configParams = publisherInst.getInstanceParams();
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)this.getPublisherPluginName(publisherInst));
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                String kv = (String)configParams.elementAt(i);
                int index = kv.indexOf(61);
                params.put((Object)kv.substring(0, index), (Object)kv.substring(index + 1));
            }
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void modPublisherInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_NULL_RS_ID", (String[])new String[0]), null, resp);
            return;
        }
        if (!this.mProcessor.getPublisherInsts().containsKey(id)) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ILL_INST_ID", (String[])new String[]{id}), null, resp);
            return;
        }
        String implname = req.getParameter("implName");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_SRVLT_ADD_MISSING_PARAMS", (String[])new String[0]), null, resp);
            return;
        }
        PublisherPlugin plugin = this.mProcessor.getPublisherPlugins().get(implname);
        if (plugin == null) {
            this.sendResponse(ERROR, new EPublisherPluginNotFound(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_PUBLISHER_PLUGIN_NOT_FOUND", (String[])new String[]{implname})).toString(), null, resp);
            return;
        }
        Publisher oldinst = this.mProcessor.getPublisherInstance(id);
        Vector oldConfigParms = oldinst.getInstanceParams();
        NameValuePairs saveParams = new NameValuePairs();
        String pubType = "";
        saveParams.put((Object)"pluginName", (Object)implname);
        if (oldConfigParms != null) {
            for (int i = 0; i < oldConfigParms.size(); ++i) {
                String kv = (String)oldConfigParms.elementAt(i);
                int index = kv.indexOf(61);
                if (index <= -1) continue;
                if (kv.substring(0, index).equalsIgnoreCase("caObjectClass")) {
                    pubType = "cacert";
                } else if (kv.substring(0, index).equalsIgnoreCase("crlObjectClass")) {
                    pubType = "crl";
                }
                saveParams.put((Object)kv.substring(0, index), (Object)kv.substring(index + 1));
            }
        }
        PublishingPublisherConfig destStore = this.publishingConfig.getPublisherConfig();
        ConfigStore instancesConfig = destStore.getSubStore("instance", ConfigStore.class);
        if (pubType.equals("cacert")) {
            saveParams.put((Object)"caObjectClassAdded", (Object)instancesConfig.getString(id + ".caObjectClassAdded", ""));
            saveParams.put((Object)"caObjectClassDeleted", (Object)instancesConfig.getString(id + ".caObjectClassDeleted", ""));
        } else if (pubType.equals("crl")) {
            saveParams.put((Object)"crlObjectClassAdded", (Object)instancesConfig.getString(id + ".crlObjectClassAdded", ""));
            saveParams.put((Object)"crlObjectClassDeleted", (Object)instancesConfig.getString(id + ".crlObjectClassDeleted", ""));
        }
        Vector<String> configParams = this.mProcessor.getPublisherInstanceParams(id);
        instancesConfig.removeSubStore(id);
        ConfigStore substore = instancesConfig.makeSubStore(id);
        substore.put("pluginName", implname);
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                int index;
                String kv = configParams.elementAt(i);
                String key = kv.substring(0, index = kv.indexOf(61));
                String val = req.getParameter(key);
                if (val == null) continue;
                substore.put(key, val);
            }
        }
        if (pubType.equals("cacert")) {
            this.processChangedOC(saveParams, substore, "caObjectClass");
            substore.put("pubtype", "cacert");
        }
        if (pubType.equals("crl")) {
            this.processChangedOC(saveParams, substore, "crlObjectClass");
            substore.put("pubtype", "crl");
        }
        String className = plugin.getClassPath();
        Publisher newMgrInst = null;
        try {
            newMgrInst = (Publisher)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            PublisherAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, new ELdapException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_LDAP_FAIL_LOAD_CLASS", (String[])new String[]{className})).toString(), null, resp);
            return;
        }
        try {
            newMgrInst.init(substore);
        }
        catch (EBaseException e) {
            PublisherAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
            return;
        }
        catch (Throwable e) {
            PublisherAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, e.toString(), null, resp);
            return;
        }
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            PublisherAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_COMMIT_FAILED", (String[])new String[0]), null, resp);
            return;
        }
        this.mProcessor.getPublisherInsts().put(id, new PublisherProxy(true, newMgrInst));
        logger.info(CMS.getLogMessage((String)"ADMIN_SRVLT_PUB_INST_REP", (Object[])new Object[]{id}));
        NameValuePairs params = new NameValuePairs();
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private String[] getExtras(String[] list1, String[] list2) {
        Vector<String> extras = new Vector<String>();
        for (int i = 0; i < list1.length; ++i) {
            boolean match = false;
            for (int j = 0; j < list2.length; ++j) {
                if (!list1[i].trim().equalsIgnoreCase(list2[j].trim())) continue;
                match = true;
                break;
            }
            if (match) continue;
            extras.add(list1[i].trim());
        }
        return extras.toArray(new String[extras.size()]);
    }

    private String[] joinLists(String[] list1, String[] list2) {
        int i;
        Vector<String> sum = new Vector<String>();
        for (i = 0; i < list1.length; ++i) {
            sum.add(list1[i]);
        }
        for (i = 0; i < list2.length; ++i) {
            boolean match = false;
            for (int j = 0; j < list1.length; ++j) {
                if (!list2[i].trim().equalsIgnoreCase(list1[j].trim())) continue;
                match = true;
                break;
            }
            if (match) continue;
            sum.add(list2[i].trim());
        }
        return sum.toArray(new String[sum.size()]);
    }

    private static String join(String[] s, String delimiter) {
        if (s.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(s[0]);
        if (s.length > 1) {
            for (int i = 1; i < s.length; ++i) {
                buffer.append(delimiter + s[i].trim());
            }
        }
        return buffer.toString();
    }

    private void processChangedOC(NameValuePairs saveParams, ConfigStore newstore, String objName) {
        String newOC = null;
        String oldOC = null;
        String oldAdded = null;
        String oldDeleted = null;
        try {
            newOC = newstore.getString(objName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        oldOC = (String)saveParams.get((Object)objName);
        oldAdded = (String)saveParams.get((Object)(objName + "Added"));
        oldDeleted = (String)saveParams.get((Object)(objName + "Deleted"));
        if (oldOC == null || newOC == null) {
            return;
        }
        if (oldOC.equalsIgnoreCase(newOC)) {
            return;
        }
        String[] oldList = oldOC.split(",");
        String[] newList = newOC.split(",");
        String[] deletedList = this.getExtras(oldList, newList);
        String[] addedList = this.getExtras(newList, oldList);
        if (addedList.length == 0 && deletedList.length == 0) {
            return;
        }
        if (oldAdded != null) {
            String[] oldAddedList = oldAdded.split(",");
            addedList = this.joinLists(addedList, oldAddedList);
        }
        if (oldDeleted != null) {
            String[] oldDeletedList = oldDeleted.split(",");
            deletedList = this.joinLists(deletedList, oldDeletedList);
        }
        String[] addedList1 = this.getExtras(addedList, deletedList);
        String[] deletedList1 = this.getExtras(deletedList, addedList);
        String addedListStr = PublisherAdminServlet.join(addedList1, ",");
        String deletedListStr = PublisherAdminServlet.join(deletedList1, ",");
        logger.debug("processChangedOC: added list is " + addedListStr);
        logger.debug("processChangedOC: deleted list is " + deletedListStr);
        newstore.put(objName + "Added", addedListStr);
        newstore.put(objName + "Deleted", deletedListStr);
    }

    private static void restore(ConfigStore store, String id, NameValuePairs saveParams) {
        store.removeSubStore(id);
        ConfigStore rstore = store.makeSubStore(id);
        for (String key : saveParams.keySet()) {
            String value = (String)saveParams.get((Object)key);
            if (value == null) continue;
            rstore.put(key, value);
        }
    }

    private String dashes(int len) {
        String dashes = "...................................................";
        if (len <= 0) {
            return "";
        }
        String new1 = dashes.substring(0, len);
        return new1;
    }
}

