/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.input;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.input.EnrollInput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectNameInput
extends EnrollInput {
    public static Logger logger = LoggerFactory.getLogger(SubjectNameInput.class);
    public static final String CONFIG_UID = "sn_uid";
    public static final String CONFIG_EMAIL = "sn_e";
    public static final String CONFIG_CN = "sn_cn";
    public static final String CONFIG_OU3 = "sn_ou3";
    public static final String CONFIG_OU2 = "sn_ou2";
    public static final String CONFIG_OU1 = "sn_ou1";
    public static final String CONFIG_OU = "sn_ou";
    public static final String CONFIG_O = "sn_o";
    public static final String CONFIG_C = "sn_c";
    public static final String VAL_UID = "sn_uid";
    public static final String VAL_EMAIL = "sn_e";
    public static final String VAL_CN = "sn_cn";
    public static final String VAL_OU3 = "sn_ou3";
    public static final String VAL_OU2 = "sn_ou2";
    public static final String VAL_OU1 = "sn_ou1";
    public static final String VAL_OU = "sn_ou";
    public static final String VAL_O = "sn_o";
    public static final String VAL_C = "sn_c";

    public SubjectNameInput() {
        this.addConfigName("sn_uid");
        this.addConfigName("sn_e");
        this.addConfigName("sn_cn");
        this.addConfigName("sn_ou3");
        this.addConfigName("sn_ou2");
        this.addConfigName("sn_ou1");
        this.addConfigName("sn_ou");
        this.addConfigName("sn_o");
        this.addConfigName("sn_c");
    }

    @Override
    public void init(Profile profile, ConfigStore config) throws EProfileException {
        super.init(profile, config);
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_SUBJECT_NAME_NAME", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_SUBJECT_NAME_TEXT", (String[])new String[0]);
    }

    @Override
    public String getConfig(String name) {
        String config = super.getConfig(name);
        if (config == null || config.equals("")) {
            return "true";
        }
        return config;
    }

    @Override
    public Enumeration<String> getValueNames() {
        Vector<String> v = new Vector<String>();
        String c_uid = this.getConfig("sn_uid");
        if (c_uid == null || c_uid.equals("")) {
            v.addElement("sn_uid");
        } else if (c_uid.equals("true")) {
            v.addElement("sn_uid");
        }
        String c_email = this.getConfig("sn_e");
        if (c_email == null || c_email.equals("")) {
            v.addElement("sn_e");
        } else if (c_email.equals("true")) {
            v.addElement("sn_e");
        }
        String c_cn = this.getConfig("sn_cn");
        if (c_cn == null || c_cn.equals("")) {
            v.addElement("sn_cn");
        } else if (c_cn.equals("true")) {
            v.addElement("sn_cn");
        }
        String c_ou3 = this.getConfig("sn_ou3");
        if (c_ou3 == null || c_ou3.equals("")) {
            v.addElement("sn_ou3");
        } else if (c_ou3.equals("true")) {
            v.addElement("sn_ou3");
        }
        String c_ou2 = this.getConfig("sn_ou2");
        if (c_ou2 == null || c_ou2.equals("")) {
            v.addElement("sn_ou2");
        } else if (c_ou2.equals("true")) {
            v.addElement("sn_ou2");
        }
        String c_ou1 = this.getConfig("sn_ou1");
        if (c_ou1 == null || c_ou1.equals("")) {
            v.addElement("sn_ou1");
        } else if (c_ou1.equals("true")) {
            v.addElement("sn_ou1");
        }
        String c_ou = this.getConfig("sn_ou");
        if (c_ou == null || c_ou.equals("")) {
            v.addElement("sn_ou");
        } else if (c_ou.equals("true")) {
            v.addElement("sn_ou");
        }
        String c_o = this.getConfig("sn_o");
        if (c_o == null || c_o.equals("")) {
            v.addElement("sn_o");
        } else if (c_o.equals("true")) {
            v.addElement("sn_o");
        }
        String c_c = this.getConfig("sn_c");
        if (c_c == null || c_c.equals("")) {
            v.addElement("sn_c");
        } else if (c_c.equals("true")) {
            v.addElement("sn_c");
        }
        return v.elements();
    }

    @Override
    public void populate(Map<String, String> ctx, Request request) throws Exception {
        String c;
        String o;
        String ou;
        String ou1;
        String ou2;
        String ou3;
        String cn;
        String email;
        X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
        Object subjectName = "";
        String uid = ctx.get("sn_uid");
        if (uid != null && !uid.equals("")) {
            subjectName = (String)subjectName + "UID=" + uid;
        }
        if ((email = ctx.get("sn_e")) != null && !email.equals("")) {
            if (!((String)subjectName).equals("")) {
                subjectName = (String)subjectName + ",";
            }
            subjectName = (String)subjectName + "E=" + email;
        }
        if ((cn = ctx.get("sn_cn")) != null && !cn.equals("")) {
            if (!((String)subjectName).equals("")) {
                subjectName = (String)subjectName + ",";
            }
            subjectName = (String)subjectName + "CN=" + cn;
        }
        if ((ou3 = ctx.get("sn_ou3")) != null && !ou3.equals("")) {
            if (!((String)subjectName).equals("")) {
                subjectName = (String)subjectName + ",";
            }
            subjectName = (String)subjectName + "OU=" + ou3;
        }
        if ((ou2 = ctx.get("sn_ou2")) != null && !ou2.equals("")) {
            if (!((String)subjectName).equals("")) {
                subjectName = (String)subjectName + ",";
            }
            subjectName = (String)subjectName + "OU=" + ou2;
        }
        if ((ou1 = ctx.get("sn_ou1")) != null && !ou1.equals("")) {
            if (!((String)subjectName).equals("")) {
                subjectName = (String)subjectName + ",";
            }
            subjectName = (String)subjectName + "OU=" + ou1;
        }
        if ((ou = ctx.get("sn_ou")) != null && !ou.equals("")) {
            if (!((String)subjectName).equals("")) {
                subjectName = (String)subjectName + ",";
            }
            subjectName = (String)subjectName + "OU=" + ou;
        }
        if ((o = ctx.get("sn_o")) != null && !o.equals("")) {
            if (!((String)subjectName).equals("")) {
                subjectName = (String)subjectName + ",";
            }
            subjectName = (String)subjectName + "O=" + o;
        }
        if ((c = ctx.get("sn_c")) != null && !c.equals("")) {
            if (!((String)subjectName).equals("")) {
                subjectName = (String)subjectName + ",";
            }
            subjectName = (String)subjectName + "C=" + c;
        }
        if (((String)subjectName).equals("")) {
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SUBJECT_NAME_NOT_FOUND", (String[])new String[0]));
        }
        X500Name name = null;
        try {
            name = new X500Name((String)subjectName);
        }
        catch (Exception e) {
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_INVALID_SUBJECT_NAME", (String[])new String[]{subjectName}));
        }
        this.parseSubjectName(name, info, request);
        request.setExtData("req_x509info", info);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("sn_uid")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_UID", (String[])new String[0]));
        }
        if (name.equals("sn_e")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_UID", (String[])new String[0]));
        }
        if (name.equals("sn_cn")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_CN", (String[])new String[0]));
        }
        if (name.equals("sn_ou3")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_OU", (String[])new String[0]));
        }
        if (name.equals("sn_ou2")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_OU", (String[])new String[0]));
        }
        if (name.equals("sn_ou1")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_OU", (String[])new String[0]));
        }
        if (name.equals("sn_ou")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_OU", (String[])new String[0]));
        }
        if (name.equals("sn_o")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_O", (String[])new String[0]));
        }
        if (name.equals("sn_c")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_C", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("sn_uid")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_UID", (String[])new String[0]));
        }
        if (name.equals("sn_e")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_EMAIL", (String[])new String[0]));
        }
        if (name.equals("sn_cn")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_CN", (String[])new String[0]));
        }
        if (name.equals("sn_ou3")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_OU", (String[])new String[0]) + " 3");
        }
        if (name.equals("sn_ou2")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_OU", (String[])new String[0]) + " 2");
        }
        if (name.equals("sn_ou1")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_OU", (String[])new String[0]) + " 1");
        }
        if (name.equals("sn_ou")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_OU", (String[])new String[0]));
        }
        if (name.equals("sn_o")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_O", (String[])new String[0]));
        }
        if (name.equals("sn_c")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SN_C", (String[])new String[0]));
        }
        return null;
    }

    protected void parseSubjectName(X500Name subj, X509CertInfo info, Request req) throws EProfileException {
        try {
            req.setExtData("req_subject_name", new CertificateSubjectName(subj));
        }
        catch (Exception e) {
            logger.warn("SubjectNameInput: parseSubject Name " + e.getMessage(), (Throwable)e);
        }
    }
}

