/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.input;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.input.EnrollInput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectDNInput
extends EnrollInput {
    public static Logger logger = LoggerFactory.getLogger(SubjectDNInput.class);
    public static final String VAL_SUBJECT = "subject";

    @Override
    public void init(Profile profile, ConfigStore config) throws EProfileException {
        super.init(profile, config);
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_SUBJECT_NAME_NAME", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_SUBJECT_NAME_TEXT", (String[])new String[0]);
    }

    @Override
    public String getConfig(String name) {
        String config = super.getConfig(name);
        if (config == null || config.equals("")) {
            return "true";
        }
        return config;
    }

    @Override
    public Enumeration<String> getValueNames() {
        Vector<String> v = new Vector<String>();
        v.addElement(VAL_SUBJECT);
        return v.elements();
    }

    @Override
    public void populate(Map<String, String> ctx, Request request) throws Exception {
        X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
        String subjectName = "";
        subjectName = ctx.get(VAL_SUBJECT);
        if (subjectName == null || subjectName.equals("")) {
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SUBJECT_NAME_NOT_FOUND", (String[])new String[0]));
        }
        X500Name name = null;
        try {
            name = new X500Name(subjectName);
        }
        catch (Exception e) {
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_INVALID_SUBJECT_NAME", (String[])new String[]{subjectName}));
        }
        this.parseSubjectName(name, info, request);
        request.setExtData("req_x509info", info);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_SUBJECT)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[0]));
        }
        return null;
    }

    protected void parseSubjectName(X500Name subj, X509CertInfo info, Request req) throws EProfileException {
        try {
            req.setExtData("req_subject_name", new CertificateSubjectName(subj));
        }
        catch (Exception e) {
            logger.warn("SubjectNameInput: parseSubject Name " + e.getMessage(), (Throwable)e);
        }
    }
}

