/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.x509.CRLDistributionPoint;
import org.mozilla.jss.netscape.security.x509.CRLDistributionPointsExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.GeneralNamesException;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLDistributionPointsExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(CRLDistributionPointsExtDefault.class);
    public static final String CONFIG_CRITICAL = "crlDistPointsCritical";
    public static final String CONFIG_NUM_POINTS = "crlDistPointsNum";
    public static final String CONFIG_POINT_TYPE = "crlDistPointsPointType_";
    public static final String CONFIG_POINT_NAME = "crlDistPointsPointName_";
    public static final String CONFIG_REASONS = "crlDistPointsReasons_";
    public static final String CONFIG_ISSUER_TYPE = "crlDistPointsIssuerType_";
    public static final String CONFIG_ISSUER_NAME = "crlDistPointsIssuerName_";
    public static final String CONFIG_ENABLE = "crlDistPointsEnable_";
    public static final String VAL_CRITICAL = "crlDistPointsCritical";
    public static final String VAL_CRL_DISTRIBUTION_POINTS = "crlDistPointsValue";
    private static final String REASONS = "Reasons";
    private static final String POINT_TYPE = "Point Type";
    private static final String POINT_NAME = "Point Name";
    private static final String ISSUER_TYPE = "Issuer Type";
    private static final String ISSUER_NAME = "Issuer Name";
    private static final String ENABLE = "Enable";
    private static final String RELATIVETOISSUER = "RelativeToIssuer";
    private static final int DEF_NUM_POINTS = 1;
    private static final int MAX_NUM_POINTS = 100;

    @Override
    public void init(CAEngineConfig engineConfig, ConfigStore config) throws EProfileException {
        super.init(engineConfig, config);
        this.refreshConfigAndValueNames();
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        int num = 0;
        if (name.equals(CONFIG_NUM_POINTS)) {
            try {
                num = Integer.parseInt(value);
                if (num >= 100 || num < 0) {
                    throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_POINTS}));
                }
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_POINTS}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public Enumeration<String> getConfigNames() {
        this.refreshConfigAndValueNames();
        return super.getConfigNames();
    }

    @Override
    protected void refreshConfigAndValueNames() {
        super.refreshConfigAndValueNames();
        this.addValueName("crlDistPointsCritical");
        this.addValueName(VAL_CRL_DISTRIBUTION_POINTS);
        this.addConfigName("crlDistPointsCritical");
        int num = this.getNumPoints();
        this.addConfigName(CONFIG_NUM_POINTS);
        for (int i = 0; i < num; ++i) {
            this.addConfigName(CONFIG_POINT_TYPE + i);
            this.addConfigName(CONFIG_POINT_NAME + i);
            this.addConfigName(CONFIG_REASONS + i);
            this.addConfigName(CONFIG_ISSUER_TYPE + i);
            this.addConfigName(CONFIG_ISSUER_NAME + i);
            this.addConfigName(CONFIG_ENABLE + i);
        }
    }

    protected int getNumPoints() {
        int num = 1;
        String val = this.getConfig(CONFIG_NUM_POINTS);
        if (val != null) {
            try {
                num = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (num >= 100) {
            num = 1;
        }
        return num;
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("crlDistPointsCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_POINT_TYPE)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POINT_TYPE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_POINT_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POINT_NAME", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_REASONS)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_REASONS", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_ISSUER_TYPE)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ISSUER_TYPE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_ISSUER_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ISSUER_NAME", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_ENABLE)) {
            return new Descriptor("boolean", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ENABLE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_NUM_POINTS)) {
            return new Descriptor("integer", null, "1", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NUM_DIST_POINTS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("crlDistPointsCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(VAL_CRL_DISTRIBUTION_POINTS)) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRL_DISTRIBUTION_POINTS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            CRLDistributionPointsExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ext = (CRLDistributionPointsExtension)this.getExtension(PKIXExtensions.CRLDistributionPoints_Id.toString(), info);
            if (ext == null) {
                this.populate(locale, info);
            }
            if (name.equals("crlDistPointsCritical")) {
                ext = (CRLDistributionPointsExtension)this.getExtension(PKIXExtensions.CRLDistributionPoints_Id.toString(), info);
                boolean val = Boolean.valueOf(value);
                if (ext == null) {
                    return;
                }
                ext.setCritical(val);
            } else if (name.equals(VAL_CRL_DISTRIBUTION_POINTS)) {
                ext = (CRLDistributionPointsExtension)this.getExtension(PKIXExtensions.CRLDistributionPoints_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Vector<NameValuePairs> v = this.parseRecords(value);
                int size = v.size();
                boolean critical = ext.isCritical();
                for (int i = 0; i < size; ++i) {
                    NameValuePairs nvps = v.elementAt(i);
                    String pointType = null;
                    String pointValue = null;
                    String issuerType = null;
                    String issuerValue = null;
                    String enable = null;
                    CRLDistributionPoint cdp = new CRLDistributionPoint();
                    for (String name1 : nvps.keySet()) {
                        if (name1.equals(REASONS)) {
                            this.addReasons(locale, cdp, REASONS, (String)nvps.get((Object)name1));
                            continue;
                        }
                        if (name1.equals(POINT_TYPE)) {
                            pointType = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (name1.equals(POINT_NAME)) {
                            pointValue = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (name1.equals(ISSUER_TYPE)) {
                            issuerType = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (name1.equals(ISSUER_NAME)) {
                            issuerValue = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (!name1.equals(ENABLE)) continue;
                        enable = (String)nvps.get((Object)name1);
                    }
                    if (enable == null || !enable.equals("true")) continue;
                    if (pointType != null) {
                        this.addCRLPoint(locale, cdp, pointType, pointValue);
                    }
                    if (issuerType != null) {
                        this.addIssuer(locale, cdp, issuerType, issuerValue);
                    }
                    if (i == 0) {
                        ext = new CRLDistributionPointsExtension(cdp);
                        ext.setCritical(critical);
                        continue;
                    }
                    ext.addPoint(cdp);
                }
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(PKIXExtensions.CRLDistributionPoints_Id.toString(), (Extension)ext, info);
        }
        catch (EProfileException e) {
            logger.error("CRLDistributionPointsExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    private void addCRLPoint(Locale locale, CRLDistributionPoint cdp, String type, String value) throws EPropertyException {
        block6: {
            try {
                if (value == null || value.length() == 0) {
                    return;
                }
                if (type.equals(RELATIVETOISSUER)) {
                    cdp.setRelativeName(new RDN(value));
                    break block6;
                }
                if (this.isGeneralNameType(type)) {
                    GeneralNames gen = new GeneralNames();
                    gen.addElement((Object)this.parseGeneralName(type, value));
                    cdp.setFullName(gen);
                    break block6;
                }
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{type}));
            }
            catch (IOException e) {
                logger.error("CRLDistributionPointsExtDefault: addCRLPoint " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{type}));
            }
            catch (GeneralNamesException e) {
                logger.error("CRLDistributionPointsExtDefault: addCRLPoint " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{type}));
            }
        }
    }

    private void addIssuer(Locale locale, CRLDistributionPoint cdp, String type, String value) throws EPropertyException {
        if (value == null || value.length() == 0) {
            return;
        }
        try {
            if (!this.isGeneralNameType(type)) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{type}));
            }
            GeneralNames gen = new GeneralNames();
            gen.addElement((Object)this.parseGeneralName(type, value));
            cdp.setCRLIssuer(gen);
        }
        catch (IOException e) {
            logger.warn("CRLDistributionPointsExtDefault: addIssuer " + e.getMessage(), (Throwable)e);
        }
        catch (GeneralNamesException e) {
            logger.warn("CRLDistributionPointsExtDefault: addIssuer " + e.getMessage(), (Throwable)e);
        }
    }

    private void addReasons(Locale locale, CRLDistributionPoint cdp, String type, String value) throws EPropertyException {
        if (value == null || value.length() == 0) {
            return;
        }
        if (type.equals(REASONS)) {
            if (value != null && !value.equals("")) {
                StringTokenizer st = new StringTokenizer(value, ", \t");
                byte reasonBits = 0;
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    CRLDistributionPointsExtension.Reason r = CRLDistributionPointsExtension.Reason.fromString((String)s);
                    if (r == null) {
                        logger.error("CRLDistributeionPointsExtDefault: addReasons Unknown reason: " + s);
                        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{s}));
                    }
                    reasonBits = (byte)(reasonBits | r.getBitMask());
                }
                if (reasonBits != 0) {
                    BitArray ba = new BitArray(8, new byte[]{reasonBits});
                    cdp.setReasons(ba);
                }
            }
        } else {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{type}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        CRLDistributionPointsExtension ext = null;
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        ext = (CRLDistributionPointsExtension)this.getExtension(PKIXExtensions.CRLDistributionPoints_Id.toString(), info);
        if (ext == null) {
            try {
                this.populate(locale, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("crlDistPointsCritical")) {
            ext = (CRLDistributionPointsExtension)this.getExtension(PKIXExtensions.CRLDistributionPoints_Id.toString(), info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals(VAL_CRL_DISTRIBUTION_POINTS)) {
            ext = (CRLDistributionPointsExtension)this.getExtension(PKIXExtensions.CRLDistributionPoints_Id.toString(), info);
            if (ext == null) {
                return "";
            }
            Vector<NameValuePairs> recs = new Vector<NameValuePairs>();
            int num = this.getNumPoints();
            for (int i = 0; i < num; ++i) {
                NameValuePairs pairs = null;
                if (i < ext.getNumPoints()) {
                    CRLDistributionPoint p = ext.getPointAt(i);
                    GeneralNames gns = p.getFullName();
                    pairs = this.buildGeneralNames(gns, p);
                    recs.addElement(pairs);
                    continue;
                }
                pairs = this.buildEmptyGeneralNames();
                recs.addElement(pairs);
            }
            return CRLDistributionPointsExtDefault.buildRecords(recs);
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    protected NameValuePairs buildEmptyGeneralNames() {
        NameValuePairs pairs = new NameValuePairs();
        pairs.put((Object)POINT_TYPE, (Object)"");
        pairs.put((Object)POINT_NAME, (Object)"");
        pairs.put((Object)REASONS, (Object)"");
        pairs.put((Object)ISSUER_TYPE, (Object)"");
        pairs.put((Object)ISSUER_NAME, (Object)"");
        pairs.put((Object)ENABLE, (Object)"false");
        return pairs;
    }

    protected NameValuePairs buildGeneralNames(GeneralNames gns, CRLDistributionPoint p) throws EPropertyException {
        BitArray reasons;
        String s;
        NameValuePairs pairs = new NameValuePairs();
        RDN rdn = null;
        boolean hasFullName = false;
        pairs.put((Object)ENABLE, (Object)"true");
        if (gns == null) {
            rdn = p.getRelativeName();
            if (rdn != null) {
                hasFullName = true;
                pairs.put((Object)POINT_TYPE, (Object)RELATIVETOISSUER);
                pairs.put((Object)POINT_NAME, (Object)rdn.toString());
            } else {
                pairs.put((Object)POINT_TYPE, (Object)"");
                pairs.put((Object)POINT_NAME, (Object)"");
            }
        } else {
            GeneralName gn = (GeneralName)gns.elementAt(0);
            if (gn != null) {
                hasFullName = true;
                pairs.put((Object)POINT_TYPE, (Object)CRLDistributionPointsExtDefault.getGeneralNameType(gn));
                pairs.put((Object)POINT_NAME, (Object)CRLDistributionPointsExtDefault.getGeneralNameValue(gn));
            }
        }
        if (!hasFullName) {
            pairs.put((Object)POINT_TYPE, (Object)"DirectoryName");
            pairs.put((Object)POINT_NAME, (Object)"");
        }
        if ((s = this.convertBitArrayToReasonNames(reasons = p.getReasons())).length() > 0) {
            pairs.put((Object)REASONS, (Object)s);
        } else {
            pairs.put((Object)REASONS, (Object)"");
        }
        gns = p.getCRLIssuer();
        if (gns == null) {
            pairs.put((Object)ISSUER_TYPE, (Object)"DirectoryName");
            pairs.put((Object)ISSUER_NAME, (Object)"");
        } else {
            GeneralName gn = (GeneralName)gns.elementAt(0);
            if (gn != null) {
                hasFullName = true;
                pairs.put((Object)ISSUER_TYPE, (Object)CRLDistributionPointsExtDefault.getGeneralNameType(gn));
                pairs.put((Object)ISSUER_NAME, (Object)CRLDistributionPointsExtDefault.getGeneralNameValue(gn));
            }
        }
        return pairs;
    }

    private String convertBitArrayToReasonNames(BitArray reasons) {
        StringBuffer sb = new StringBuffer();
        if (reasons != null) {
            byte[] b = reasons.toByteArray();
            CRLDistributionPointsExtension.Reason[] reasonArray = CRLDistributionPointsExtension.Reason.bitArrayToReasonArray((byte[])b);
            for (int i = 0; i < reasonArray.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(reasonArray[i].getName());
            }
        }
        return sb.toString();
    }

    @Override
    public String getText(Locale locale) {
        StringBuffer sb = new StringBuffer();
        int num = this.getNumPoints();
        for (int i = 0; i < num; ++i) {
            sb.append("Record #");
            sb.append(i);
            sb.append("{");
            sb.append("Point Type:");
            sb.append(this.getConfig(CONFIG_POINT_TYPE + i));
            sb.append(",");
            sb.append("Point Name:");
            sb.append(this.getConfig(CONFIG_POINT_NAME + i));
            sb.append(",");
            sb.append("Reasons:");
            sb.append(this.getConfig(CONFIG_REASONS + i));
            sb.append(",");
            sb.append("Issuer Type:");
            sb.append(this.getConfig(CONFIG_ISSUER_TYPE + i));
            sb.append(",");
            sb.append("Issuer Name:");
            sb.append(this.getConfig(CONFIG_ISSUER_NAME + i));
            sb.append(",");
            sb.append("Enable:");
            sb.append(this.getConfig(CONFIG_ENABLE + i));
            sb.append("}");
        }
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_CRL_DIST_POINTS_EXT", (String[])new String[]{this.getConfig("crlDistPointsCritical"), sb.toString()});
    }

    private void populate(Locale locale, X509CertInfo info) throws EProfileException {
        CRLDistributionPointsExtension ext = this.createExtension(locale);
        if (ext == null) {
            return;
        }
        this.addExtension(PKIXExtensions.CRLDistributionPoints_Id.toString(), (Extension)ext, info);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        CRLDistributionPointsExtension ext = this.createExtension(request);
        if (ext == null) {
            return;
        }
        this.addExtension(PKIXExtensions.CRLDistributionPoints_Id.toString(), (Extension)ext, info);
    }

    public CRLDistributionPointsExtension createExtension(Request request) {
        CRLDistributionPointsExtension ext = null;
        int num = 0;
        try {
            boolean critical = this.getConfigBoolean("crlDistPointsCritical");
            num = this.getNumPoints();
            for (int i = 0; i < num; ++i) {
                CRLDistributionPoint cdp = new CRLDistributionPoint();
                String enable = this.getConfig(CONFIG_ENABLE + i);
                String pointType = this.getConfig(CONFIG_POINT_TYPE + i);
                String pointName = this.getConfig(CONFIG_POINT_NAME + i);
                String reasons = this.getConfig(CONFIG_REASONS + i);
                String issuerType = this.getConfig(CONFIG_ISSUER_TYPE + i);
                String issuerName = this.getConfig(CONFIG_ISSUER_NAME + i);
                if (enable == null || !enable.equals("true")) continue;
                if (pointType != null) {
                    this.addCRLPoint(this.getLocale(request), cdp, pointType, pointName);
                }
                if (issuerType != null) {
                    this.addIssuer(this.getLocale(request), cdp, issuerType, issuerName);
                }
                if (reasons != null) {
                    this.addReasons(this.getLocale(request), cdp, REASONS, reasons);
                }
                if (i == 0) {
                    ext = new CRLDistributionPointsExtension(cdp);
                    ext.setCritical(critical);
                    continue;
                }
                ext.addPoint(cdp);
            }
        }
        catch (Exception e) {
            logger.warn("CRLDistribtionPointsExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }

    private CRLDistributionPointsExtension createExtension(Locale locale) {
        CRLDistributionPointsExtension ext = null;
        int num = 0;
        try {
            boolean critical = this.getConfigBoolean("crlDistPointsCritical");
            num = this.getNumPoints();
            for (int i = 0; i < num; ++i) {
                CRLDistributionPoint cdp = new CRLDistributionPoint();
                String enable = this.getConfig(CONFIG_ENABLE + i);
                String pointType = this.getConfig(CONFIG_POINT_TYPE + i);
                String pointName = this.getConfig(CONFIG_POINT_NAME + i);
                String reasons = this.getConfig(CONFIG_REASONS + i);
                String issuerType = this.getConfig(CONFIG_ISSUER_TYPE + i);
                String issuerName = this.getConfig(CONFIG_ISSUER_NAME + i);
                if (enable == null || !enable.equals("true")) continue;
                if (pointType != null) {
                    this.addCRLPoint(locale, cdp, pointType, pointName);
                }
                if (issuerType != null) {
                    this.addIssuer(locale, cdp, issuerType, issuerName);
                }
                this.addReasons(locale, cdp, REASONS, reasons);
                if (i == 0) {
                    ext = new CRLDistributionPointsExtension(cdp);
                    ext.setCritical(critical);
                    continue;
                }
                ext.addPoint(cdp);
            }
        }
        catch (Exception e) {
            logger.warn("CRLDistribtionPointsExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }
}

