/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConstraintsExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(BasicConstraintsExtDefault.class);
    public static final String CONFIG_CRITICAL = "basicConstraintsCritical";
    public static final String CONFIG_IS_CA = "basicConstraintsIsCA";
    public static final String CONFIG_PATH_LEN = "basicConstraintsPathLen";
    public static final String VAL_CRITICAL = "basicConstraintsCritical";
    public static final String VAL_IS_CA = "basicConstraintsIsCA";
    public static final String VAL_PATH_LEN = "basicConstraintsPathLen";

    public BasicConstraintsExtDefault() {
        this.addValueName("basicConstraintsCritical");
        this.addValueName("basicConstraintsIsCA");
        this.addValueName("basicConstraintsPathLen");
        this.addConfigName("basicConstraintsCritical");
        this.addConfigName("basicConstraintsIsCA");
        this.addConfigName("basicConstraintsPathLen");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("basicConstraintsCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("basicConstraintsIsCA")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_IS_CA", (String[])new String[0]));
        }
        if (name.equals("basicConstraintsPathLen")) {
            return new Descriptor("integer", null, "-1", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_PATH_LEN", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("basicConstraintsCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("basicConstraintsIsCA")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_IS_CA", (String[])new String[0]));
        }
        if (name.equals("basicConstraintsPathLen")) {
            return new Descriptor("integer", null, "-1", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_PATH_LEN", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            BasicConstraintsExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ext = (BasicConstraintsExtension)this.getExtension(PKIXExtensions.BasicConstraints_Id.toString(), info);
            if (ext == null) {
                this.populate(null, info);
            }
            if (name.equals("basicConstraintsCritical")) {
                ext = (BasicConstraintsExtension)this.getExtension(PKIXExtensions.BasicConstraints_Id.toString(), info);
                boolean val = Boolean.valueOf(value);
                if (ext == null) {
                    return;
                }
                ext.setCritical(val);
            } else if (name.equals("basicConstraintsIsCA")) {
                ext = (BasicConstraintsExtension)this.getExtension(PKIXExtensions.BasicConstraints_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean isCA = Boolean.valueOf(value);
                ext.set("is_ca", (Object)isCA);
            } else if (name.equals("basicConstraintsPathLen")) {
                ext = (BasicConstraintsExtension)this.getExtension(PKIXExtensions.BasicConstraints_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Integer pathLen = Integer.valueOf(value);
                ext.set("path_len", (Object)pathLen);
            } else {
                throw new EPropertyException("Invalid name " + name);
            }
            this.replaceExtension(PKIXExtensions.BasicConstraints_Id.toString(), (Extension)ext, info);
        }
        catch (IOException e) {
            logger.error("BasicConstraintsExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (EProfileException e) {
            logger.error("BasicConstraintsExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        try {
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            BasicConstraintsExtension ext = (BasicConstraintsExtension)this.getExtension(PKIXExtensions.BasicConstraints_Id.toString(), info);
            if (ext == null) {
                logger.debug("BasicConstraintsExtDefault: getValue ext is null, populating a new one ");
                try {
                    this.populate(null, info);
                }
                catch (EProfileException e) {
                    logger.error("BasicConstraintsExtDefault: getValue " + e.getMessage(), (Throwable)e);
                    throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
                }
            }
            if (name.equals("basicConstraintsCritical")) {
                ext = (BasicConstraintsExtension)this.getExtension(PKIXExtensions.BasicConstraints_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                return ext.isCritical() ? "true" : "false";
            }
            if (name.equals("basicConstraintsIsCA")) {
                ext = (BasicConstraintsExtension)this.getExtension(PKIXExtensions.BasicConstraints_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean isCA = (Boolean)ext.get("is_ca");
                return isCA.toString();
            }
            if (name.equals("basicConstraintsPathLen")) {
                ext = (BasicConstraintsExtension)this.getExtension(PKIXExtensions.BasicConstraints_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Integer pathLen = (Integer)ext.get("path_len");
                String pLen = null;
                pLen = pathLen.toString();
                if (pLen.equals("-2")) {
                    pLen = "-1";
                }
                logger.debug("BasicConstriantsExtDefault getValue(pLen) " + pLen);
                return pLen;
            }
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (IOException e) {
            logger.error("BasicConstraintsExtDefault: getValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig("basicConstraintsCritical"), this.getConfig("basicConstraintsIsCA"), this.getConfig("basicConstraintsPathLen")};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_BASIC_CONSTRAINTS_EXT", (String[])params);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        BasicConstraintsExtension ext = this.createExtension();
        this.addExtension(PKIXExtensions.BasicConstraints_Id.toString(), (Extension)ext, info);
    }

    public BasicConstraintsExtension createExtension() {
        BasicConstraintsExtension ext = null;
        boolean critical = Boolean.valueOf(this.getConfig("basicConstraintsCritical"));
        boolean isCA = Boolean.valueOf(this.getConfig("basicConstraintsIsCA"));
        String pathLenStr = this.getConfig("basicConstraintsPathLen");
        int pathLen = -2;
        if (!pathLenStr.equals("")) {
            pathLen = Integer.valueOf(pathLenStr);
        }
        try {
            ext = new BasicConstraintsExtension(isCA, critical, pathLen);
        }
        catch (Exception e) {
            logger.error("BasicConstraintsExtDefault: createExtension " + e.getMessage(), (Throwable)e);
            return null;
        }
        ext.setCritical(critical);
        return ext;
    }
}

