/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.listeners;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.listeners.EListenersException;
import com.netscape.certsrv.notification.ENotificationException;
import com.netscape.certsrv.notification.EmailResolver;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cms.notification.MailNotification;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.notification.EmailFormProcessor;
import com.netscape.cmscore.notification.EmailResolverKeys;
import com.netscape.cmscore.notification.EmailTemplate;
import com.netscape.cmscore.notification.ReqCertSANameEmailResolver;
import com.netscape.cmscore.request.Request;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateRevokedListener
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(CertificateRevokedListener.class);
    protected static final String PROP_CERT_ISSUED_SUBSTORE = "certRevoked";
    protected static final String PROP_ENABLED = "enabled";
    protected static final String PROP_NOTIFY_SUBSTORE = "notification";
    protected static final String PROP_SENDER_EMAIL = "senderEmail";
    protected static final String PROP_EMAIL_SUBJECT = "emailSubject";
    public static final String PROP_EMAIL_TEMPLATE = "emailTemplate";
    protected static final String REJECT_FILE_NAME = "certRequestRejected";
    private boolean mEnabled = false;
    private String mSenderEmail = null;
    private String mSubject = null;
    private String mSubject_Success = null;
    private String mFormPath = null;
    private String mRejectPath = null;
    private Hashtable<String, Object> mContentParams = new Hashtable();
    private CAConfig mConfig;
    private DateFormat mDateFormat = null;
    private CertificateAuthority mSubsystem;
    private String mHttpHost = null;
    private String mHttpPort = null;
    private RequestId mReqId = null;

    public void init(Subsystem sub, ConfigStore config) throws EListenersException, EPropertyNotFound, EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        this.mSubsystem = (CertificateAuthority)sub;
        this.mConfig = this.mSubsystem.getConfigStore();
        ConfigStore nc = this.mConfig.getSubStore(PROP_NOTIFY_SUBSTORE, ConfigStore.class);
        ConfigStore rc = nc.getSubStore(PROP_CERT_ISSUED_SUBSTORE, ConfigStore.class);
        this.mEnabled = rc.getBoolean(PROP_ENABLED, false);
        this.mSenderEmail = rc.getString(PROP_SENDER_EMAIL);
        if (this.mSenderEmail == null) {
            throw new EListenersException(CMS.getLogMessage((String)"NO_NOTIFY_SENDER_EMAIL_CONFIG_FOUND", (Object[])new Object[0]));
        }
        this.mFormPath = rc.getString(PROP_EMAIL_TEMPLATE);
        String mDir = null;
        int ridx = this.mFormPath.lastIndexOf(File.separator);
        if (ridx == -1) {
            logger.debug("CertificateRevokedListener: file separator: " + File.separator + " not found. Use default /");
            ridx = this.mFormPath.lastIndexOf("/");
            mDir = this.mFormPath.substring(0, ridx + 1);
        } else {
            mDir = this.mFormPath.substring(0, ridx + File.separator.length());
        }
        logger.debug("CertificateRevokedListener: template file directory: " + mDir);
        this.mRejectPath = mDir + REJECT_FILE_NAME;
        if (this.mFormPath.endsWith(".html")) {
            this.mRejectPath = this.mRejectPath + ".html";
        } else if (this.mFormPath.endsWith(".HTML")) {
            this.mRejectPath = this.mRejectPath + ".HTML";
        } else if (this.mFormPath.endsWith(".htm")) {
            this.mRejectPath = this.mRejectPath + ".htm";
        } else if (this.mFormPath.endsWith(".HTM")) {
            this.mRejectPath = this.mRejectPath + ".HTM";
        }
        logger.debug("CertificateRevokedListener: Reject file path: " + this.mRejectPath);
        this.mDateFormat = DateFormat.getDateTimeInstance();
        this.mSubject_Success = rc.getString(PROP_EMAIL_SUBJECT, "Your Certificate Request");
        this.mSubject = new String(this.mSubject_Success);
        this.mHttpHost = cs.getHostname();
        this.mHttpPort = engine.getEESSLPort();
        engine.registerRequestListener(this);
    }

    public void accept(Request r) {
        if (!this.mEnabled) {
            return;
        }
        this.mSubject = this.mSubject_Success;
        this.mReqId = r.getRequestId();
        String rs = r.getRequestStatus().toString();
        String requestType = r.getRequestType();
        if (!requestType.equals("revocation")) {
            return;
        }
        if (!rs.equals("complete")) {
            logger.warn("CertificateRevokedListener: Request status: " + rs);
            return;
        }
        if (r.getExtDataInInteger("Result") == null) {
            return;
        }
        if (r.getExtDataInInteger("Result").equals(Request.RES_ERROR)) {
            logger.warn("CertificateRevokedListener: Request errored. No need to email notify for enrollment request id " + this.mReqId);
            return;
        }
        if (requestType.equals("revocation")) {
            logger.debug("CertificateRevokedListener: accept() revocation request...");
            RevokedCertImpl[] crlentries = r.getExtDataInRevokedCertArray("CERT_INFO");
            if (crlentries != null) {
                logger.debug("CertificateRevokedListener: Sending email notification..");
                String mEmail = null;
                EmailResolverKeys keys = new EmailResolverKeys();
                try {
                    keys.set("request", (Object)r);
                    keys.set("cert", (Object)crlentries[0]);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_SET_RESOLVER", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                ReqCertSANameEmailResolver er = new ReqCertSANameEmailResolver();
                try {
                    mEmail = ((EmailResolver)er).getEmail(keys);
                }
                catch (ENotificationException e) {
                    logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_EXCEPTION", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_EXCEPTION", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                catch (Exception e) {
                    logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_EXCEPTION", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                if (mEmail != null && !mEmail.equals("")) {
                    this.mailIt(mEmail, crlentries);
                } else {
                    logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_NOTIFY_ERROR", (Object[])new Object[]{crlentries[0].getSerialNumber().toString(), this.mReqId.toString()}));
                    this.mSubject = "Certificate Issued notification undeliverable";
                    this.mailIt(this.mSenderEmail, crlentries);
                }
            }
        }
    }

    private void mailIt(String mEmail, RevokedCertImpl[] crlentries) {
        CAEngine engine = CAEngine.getInstance();
        MailNotification mn = engine.getMailNotification();
        mn.setFrom(this.mSenderEmail);
        mn.setTo(mEmail);
        mn.setSubject(this.mSubject);
        EmailTemplate template = new EmailTemplate(this.mFormPath);
        if (!template.init()) {
            return;
        }
        this.buildContentParams(crlentries, mEmail);
        EmailFormProcessor et = new EmailFormProcessor();
        String c = et.getEmailContent(template.toString(), this.mContentParams);
        if (template.isHTML()) {
            mn.setContentType("text/html");
        }
        mn.setContent(c);
        try {
            mn.sendNotification();
        }
        catch (ENotificationException e) {
            logger.warn(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
    }

    private void buildContentParams(RevokedCertImpl[] crlentries, String mEmail) {
        this.mContentParams.put("InstanceID", this.mConfig.getName());
        this.mContentParams.put("SerialNumber", crlentries[0].getSerialNumber().toString());
        this.mContentParams.put("HexSerialNumber", Long.toHexString(crlentries[0].getSerialNumber().longValue()));
        this.mContentParams.put("RequestId", this.mReqId.toString());
        this.mContentParams.put("HttpHost", this.mHttpHost);
        this.mContentParams.put("HttpPort", this.mHttpPort);
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certDB = engine.getCertificateRepository();
        try {
            RevokedCertImpl revCert = crlentries[0];
            X509CertImpl cert = certDB.getX509Certificate(revCert.getSerialNumber());
            this.mContentParams.put("IssuerDN", cert.getIssuerDN().toString());
            this.mContentParams.put("SubjectDN", cert.getSubjectDN().toString());
            Date date = crlentries[0].getRevocationDate();
            this.mContentParams.put("RevocationDate", this.mDateFormat.format(date));
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_SET_RESOLVER", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        this.mContentParams.put("SenderEmail", this.mSenderEmail);
        this.mContentParams.put("RecipientEmail", mEmail);
    }

    public void set(String name, String val) {
        if (name.equalsIgnoreCase(PROP_ENABLED)) {
            this.mEnabled = val.equalsIgnoreCase("true");
        } else if (name.equalsIgnoreCase(PROP_SENDER_EMAIL)) {
            this.mSenderEmail = val;
        } else if (name.equalsIgnoreCase(PROP_EMAIL_SUBJECT)) {
            this.mSubject = this.mSubject_Success = val;
        } else if (name.equalsIgnoreCase(PROP_EMAIL_TEMPLATE)) {
            this.mFormPath = val;
        } else {
            logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_SET", (Object[])new Object[0]));
        }
    }
}

