/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.group;

import com.netscape.certsrv.group.GroupClient;
import com.netscape.certsrv.group.GroupData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.group.GroupCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupModifyCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(GroupModifyCLI.class);
    public GroupCLI groupCLI;

    public GroupModifyCLI(GroupCLI groupCLI) {
        super("mod", "Modify group", (CLI)groupCLI);
        this.groupCLI = groupCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Group ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "description", true, "Description");
        option.setArgName("description");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Group ID specified.");
        }
        String groupID = cmdArgs[0];
        GroupData groupData = new GroupData();
        groupData.setID(groupID);
        groupData.setDescription(cmd.getOptionValue("description"));
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        GroupClient groupClient = this.groupCLI.getGroupClient();
        groupData = groupClient.modifyGroup(groupID, groupData);
        MainCLI.printMessage("Modified group \"" + groupID + "\"");
        GroupCLI.printGroup(groupData);
    }
}

