/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.group;

import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.group.GroupClient;
import com.netscape.certsrv.group.GroupData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.cli.SubsystemCLI;
import com.netscape.cmstools.group.GroupAddCLI;
import com.netscape.cmstools.group.GroupFindCLI;
import com.netscape.cmstools.group.GroupMemberCLI;
import com.netscape.cmstools.group.GroupModifyCLI;
import com.netscape.cmstools.group.GroupRemoveCLI;
import com.netscape.cmstools.group.GroupShowCLI;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(GroupCLI.class);
    public GroupClient groupClient;

    public GroupCLI(CLI parent) {
        super("group", "Group management commands", parent);
        this.addModule((CLI)new GroupFindCLI(this));
        this.addModule((CLI)new GroupShowCLI(this));
        this.addModule((CLI)new GroupAddCLI(this));
        this.addModule((CLI)new GroupModifyCLI(this));
        this.addModule((CLI)new GroupRemoveCLI(this));
        this.addModule(new GroupMemberCLI(this));
    }

    public String getFullName() {
        return this.parent instanceof MainCLI ? this.name : this.parent.getFullName() + "-" + this.name;
    }

    public String getManPage() {
        return "pki-group";
    }

    public GroupClient getGroupClient() throws Exception {
        String subsystem;
        if (this.groupClient != null) {
            return this.groupClient;
        }
        PKIClient client = this.getClient();
        if (this.parent instanceof SubsystemCLI) {
            SubsystemCLI subsystemCLI = (SubsystemCLI)this.parent;
            subsystem = subsystemCLI.getName();
        } else {
            subsystem = client.getSubsystem();
            if (subsystem == null) {
                subsystem = "ca";
            }
        }
        this.groupClient = new GroupClient(client, subsystem);
        return this.groupClient;
    }

    public static void printGroup(GroupData groupData) {
        System.out.println("  Group ID: " + groupData.getID());
        String description = groupData.getDescription();
        if (!StringUtils.isEmpty((CharSequence)description)) {
            System.out.println("  Description: " + description);
        }
    }
}

