/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the FileFilePublication type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &FileFilePublication{}

// FileFilePublication Serializer for File Publications.
type FileFilePublication struct {
	RepositoryVersion *string `json:"repository_version,omitempty"`
	// A URI of the repository to be published.
	Repository *string `json:"repository,omitempty"`
	// Filename to use for manifest file containing metadata for all the files.
	Manifest NullableString `json:"manifest,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _FileFilePublication FileFilePublication

// NewFileFilePublication instantiates a new FileFilePublication object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewFileFilePublication() *FileFilePublication {
	this := FileFilePublication{}
	var manifest string = "PULP_MANIFEST"
	this.Manifest = *NewNullableString(&manifest)
	return &this
}

// NewFileFilePublicationWithDefaults instantiates a new FileFilePublication object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewFileFilePublicationWithDefaults() *FileFilePublication {
	this := FileFilePublication{}
	var manifest string = "PULP_MANIFEST"
	this.Manifest = *NewNullableString(&manifest)
	return &this
}

// GetRepositoryVersion returns the RepositoryVersion field value if set, zero value otherwise.
func (o *FileFilePublication) GetRepositoryVersion() string {
	if o == nil || IsNil(o.RepositoryVersion) {
		var ret string
		return ret
	}
	return *o.RepositoryVersion
}

// GetRepositoryVersionOk returns a tuple with the RepositoryVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *FileFilePublication) GetRepositoryVersionOk() (*string, bool) {
	if o == nil || IsNil(o.RepositoryVersion) {
		return nil, false
	}
	return o.RepositoryVersion, true
}

// HasRepositoryVersion returns a boolean if a field has been set.
func (o *FileFilePublication) HasRepositoryVersion() bool {
	if o != nil && !IsNil(o.RepositoryVersion) {
		return true
	}

	return false
}

// SetRepositoryVersion gets a reference to the given string and assigns it to the RepositoryVersion field.
func (o *FileFilePublication) SetRepositoryVersion(v string) {
	o.RepositoryVersion = &v
}

// GetRepository returns the Repository field value if set, zero value otherwise.
func (o *FileFilePublication) GetRepository() string {
	if o == nil || IsNil(o.Repository) {
		var ret string
		return ret
	}
	return *o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *FileFilePublication) GetRepositoryOk() (*string, bool) {
	if o == nil || IsNil(o.Repository) {
		return nil, false
	}
	return o.Repository, true
}

// HasRepository returns a boolean if a field has been set.
func (o *FileFilePublication) HasRepository() bool {
	if o != nil && !IsNil(o.Repository) {
		return true
	}

	return false
}

// SetRepository gets a reference to the given string and assigns it to the Repository field.
func (o *FileFilePublication) SetRepository(v string) {
	o.Repository = &v
}

// GetManifest returns the Manifest field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *FileFilePublication) GetManifest() string {
	if o == nil || IsNil(o.Manifest.Get()) {
		var ret string
		return ret
	}
	return *o.Manifest.Get()
}

// GetManifestOk returns a tuple with the Manifest field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *FileFilePublication) GetManifestOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Manifest.Get(), o.Manifest.IsSet()
}

// HasManifest returns a boolean if a field has been set.
func (o *FileFilePublication) HasManifest() bool {
	if o != nil && o.Manifest.IsSet() {
		return true
	}

	return false
}

// SetManifest gets a reference to the given NullableString and assigns it to the Manifest field.
func (o *FileFilePublication) SetManifest(v string) {
	o.Manifest.Set(&v)
}
// SetManifestNil sets the value for Manifest to be an explicit nil
func (o *FileFilePublication) SetManifestNil() {
	o.Manifest.Set(nil)
}

// UnsetManifest ensures that no value is present for Manifest, not even an explicit nil
func (o *FileFilePublication) UnsetManifest() {
	o.Manifest.Unset()
}

func (o FileFilePublication) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o FileFilePublication) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.RepositoryVersion) {
		toSerialize["repository_version"] = o.RepositoryVersion
	}
	if !IsNil(o.Repository) {
		toSerialize["repository"] = o.Repository
	}
	if o.Manifest.IsSet() {
		toSerialize["manifest"] = o.Manifest.Get()
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *FileFilePublication) UnmarshalJSON(bytes []byte) (err error) {
	varFileFilePublication := _FileFilePublication{}

	if err = json.Unmarshal(bytes, &varFileFilePublication); err == nil {
		*o = FileFilePublication(varFileFilePublication)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "repository_version")
		delete(additionalProperties, "repository")
		delete(additionalProperties, "manifest")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableFileFilePublication struct {
	value *FileFilePublication
	isSet bool
}

func (v NullableFileFilePublication) Get() *FileFilePublication {
	return v.value
}

func (v *NullableFileFilePublication) Set(val *FileFilePublication) {
	v.value = val
	v.isSet = true
}

func (v NullableFileFilePublication) IsSet() bool {
	return v.isSet
}

func (v *NullableFileFilePublication) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableFileFilePublication(val *FileFilePublication) *NullableFileFilePublication {
	return &NullableFileFilePublication{value: val, isSet: true}
}

func (v NullableFileFilePublication) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableFileFilePublication) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


