/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the DebReleaseComponentResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DebReleaseComponentResponse{}

// DebReleaseComponentResponse A Serializer for ReleaseComponent.
type DebReleaseComponentResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// Name of the component.
	Component string `json:"component"`
	// Name of the distribution.
	Distribution string `json:"distribution"`
	Codename string `json:"codename"`
	Suite string `json:"suite"`
	AdditionalProperties map[string]interface{}
}

type _DebReleaseComponentResponse DebReleaseComponentResponse

// NewDebReleaseComponentResponse instantiates a new DebReleaseComponentResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDebReleaseComponentResponse(component string, distribution string, codename string, suite string) *DebReleaseComponentResponse {
	this := DebReleaseComponentResponse{}
	this.Component = component
	this.Distribution = distribution
	this.Codename = codename
	this.Suite = suite
	return &this
}

// NewDebReleaseComponentResponseWithDefaults instantiates a new DebReleaseComponentResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDebReleaseComponentResponseWithDefaults() *DebReleaseComponentResponse {
	this := DebReleaseComponentResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *DebReleaseComponentResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebReleaseComponentResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *DebReleaseComponentResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *DebReleaseComponentResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *DebReleaseComponentResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebReleaseComponentResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *DebReleaseComponentResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *DebReleaseComponentResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetComponent returns the Component field value
func (o *DebReleaseComponentResponse) GetComponent() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Component
}

// GetComponentOk returns a tuple with the Component field value
// and a boolean to check if the value has been set.
func (o *DebReleaseComponentResponse) GetComponentOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Component, true
}

// SetComponent sets field value
func (o *DebReleaseComponentResponse) SetComponent(v string) {
	o.Component = v
}

// GetDistribution returns the Distribution field value
func (o *DebReleaseComponentResponse) GetDistribution() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Distribution
}

// GetDistributionOk returns a tuple with the Distribution field value
// and a boolean to check if the value has been set.
func (o *DebReleaseComponentResponse) GetDistributionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Distribution, true
}

// SetDistribution sets field value
func (o *DebReleaseComponentResponse) SetDistribution(v string) {
	o.Distribution = v
}

// GetCodename returns the Codename field value
func (o *DebReleaseComponentResponse) GetCodename() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Codename
}

// GetCodenameOk returns a tuple with the Codename field value
// and a boolean to check if the value has been set.
func (o *DebReleaseComponentResponse) GetCodenameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Codename, true
}

// SetCodename sets field value
func (o *DebReleaseComponentResponse) SetCodename(v string) {
	o.Codename = v
}

// GetSuite returns the Suite field value
func (o *DebReleaseComponentResponse) GetSuite() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Suite
}

// GetSuiteOk returns a tuple with the Suite field value
// and a boolean to check if the value has been set.
func (o *DebReleaseComponentResponse) GetSuiteOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Suite, true
}

// SetSuite sets field value
func (o *DebReleaseComponentResponse) SetSuite(v string) {
	o.Suite = v
}

func (o DebReleaseComponentResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DebReleaseComponentResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	toSerialize["component"] = o.Component
	toSerialize["distribution"] = o.Distribution
	toSerialize["codename"] = o.Codename
	toSerialize["suite"] = o.Suite

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *DebReleaseComponentResponse) UnmarshalJSON(bytes []byte) (err error) {
	varDebReleaseComponentResponse := _DebReleaseComponentResponse{}

	if err = json.Unmarshal(bytes, &varDebReleaseComponentResponse); err == nil {
		*o = DebReleaseComponentResponse(varDebReleaseComponentResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "component")
		delete(additionalProperties, "distribution")
		delete(additionalProperties, "codename")
		delete(additionalProperties, "suite")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableDebReleaseComponentResponse struct {
	value *DebReleaseComponentResponse
	isSet bool
}

func (v NullableDebReleaseComponentResponse) Get() *DebReleaseComponentResponse {
	return v.value
}

func (v *NullableDebReleaseComponentResponse) Set(val *DebReleaseComponentResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableDebReleaseComponentResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableDebReleaseComponentResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDebReleaseComponentResponse(val *DebReleaseComponentResponse) *NullableDebReleaseComponentResponse {
	return &NullableDebReleaseComponentResponse{value: val, isSet: true}
}

func (v NullableDebReleaseComponentResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDebReleaseComponentResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


