; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s

; Verify that we lower @llvm.trap() and @llvm.debugtrap() correctly.

declare void @llvm.trap()
declare void @llvm.debugtrap()

define void @test_trap() nounwind {
; RV32I-LABEL: test_trap:
; RV32I:       # %bb.0:
; RV32I-NEXT:    unimp
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_trap:
; RV64I:       # %bb.0:
; RV64I-NEXT:    unimp
; RV64I-NEXT:    ret
  tail call void @llvm.trap()
  ret void
}

define void @test_debugtrap() nounwind {
; RV32I-LABEL: test_debugtrap:
; RV32I:       # %bb.0:
; RV32I-NEXT:    ebreak
; RV32I-NEXT:    ret
;
; RV64I-LABEL: test_debugtrap:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ebreak
; RV64I-NEXT:    ret
  tail call void @llvm.debugtrap()
  ret void
}
