/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;

public class Extensions
extends Vector<Extension>
implements CertAttrSet {
    private static final long serialVersionUID = 4597917347772057433L;
    public static final String IDENT = "x509.info.extensions";
    public static final String NAME = "extensions";
    private Hashtable<String, Extension> map = new Hashtable();

    public void parseExtension(Extension ext) throws IOException {
        try {
            Class<?> extClass = OIDMap.getClass(ext.getExtensionId());
            if (extClass == null) {
                if (ext.isCritical()) {
                    throw new IOException("Unsupported CRITICAL extension: " + ext.getExtensionId());
                }
                this.map.put(ext.getExtensionId().toString(), ext);
                this.addElement(ext);
                return;
            }
            Class[] params = new Class[]{Boolean.class, Object.class};
            Constructor<?> cons = extClass.getConstructor(params);
            byte[] extData = ext.getExtensionValue();
            int extLen = extData.length;
            Object value = Array.newInstance(Byte.TYPE, extLen);
            for (int i = 0; i < extLen; ++i) {
                Array.setByte(value, i, extData[i]);
            }
            Object[] passed = new Object[]{ext.isCritical(), value};
            CertAttrSet certExt = (CertAttrSet)cons.newInstance(passed);
            this.map.put(certExt.getName(), (Extension)((Object)certExt));
            this.addElement((Extension)((Object)certExt));
        }
        catch (NoSuchMethodException nosuch) {
            throw new IOException(nosuch.toString());
        }
        catch (InvocationTargetException invk) {
            throw new IOException(invk.getTargetException().toString());
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public Extensions() {
    }

    public Extensions(DerInputStream in) throws IOException {
        DerValue[] exts = in.getSequence(5);
        for (int i = 0; i < exts.length; ++i) {
            Extension ext = new Extension(exts[i]);
            this.parseExtension(ext);
        }
    }

    @Override
    public void decode(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        DerInputStream str = val.toDerInputStream();
        this.map = new Hashtable();
        DerValue[] exts = str.getSequence(5);
        for (int i = 0; i < exts.length; ++i) {
            Extension ext = new Extension(exts[i]);
            this.parseExtension(ext);
        }
    }

    @Override
    public void encode(OutputStream out) throws CertificateException, IOException {
        DerOutputStream extOut = new DerOutputStream();
        for (int i = 0; i < this.size(); ++i) {
            Object thisOne = this.elementAt(i);
            if (thisOne instanceof CertAttrSet) {
                ((CertAttrSet)thisOne).encode(extOut);
                continue;
            }
            if (thisOne instanceof Extension) {
                ((Extension)thisOne).encode(extOut);
                continue;
            }
            throw new CertificateException("Invalid extension object");
        }
        try (DerOutputStream seq = new DerOutputStream();){
            seq.write((byte)48, extOut);
            out.write(seq.toByteArray());
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        this.map.put(name, (Extension)obj);
        this.addElement((Extension)obj);
    }

    @Override
    public Object get(String name) throws IOException {
        Extension obj = this.map.get(name);
        if (obj == null) {
            throw new IOException("No extension found with name " + name);
        }
        return obj;
    }

    @Override
    public void delete(String name) throws IOException {
        Extension obj = this.map.get(name);
        if (obj == null) {
            throw new IOException("No extension found with name " + name);
        }
        this.map.remove(name);
        this.removeElement(obj);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.map.keys();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public synchronized int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Extensions other = (Extensions)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }
}

