/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.mozilla.jss.crypto.CMACAlgorithm;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.util.NativeEnclosure;

public class JSSOAEPParameterSpec
extends NativeEnclosure
implements AlgorithmParameterSpec {
    public long hashAlg;
    public long mgf;
    public byte[] sourceData;

    public JSSOAEPParameterSpec(String mdName, String mgfName, AlgorithmParameterSpec mgfSpec, PSource pSrc) {
        this.setDigestAlgorithm(mdName);
        this.setMaskGenAlgorithm(mgfName);
        this.setMaskGenAlgorithmType(mgfSpec);
        this.setPSource(pSrc);
    }

    public JSSOAEPParameterSpec(OAEPParameterSpec copy) {
        this.setDigestAlgorithm(copy.getDigestAlgorithm());
        this.setMaskGenAlgorithm(copy.getMGFAlgorithm());
        this.setMaskGenAlgorithmType(copy.getMGFParameters());
        this.setPSource(copy.getPSource());
    }

    public void setDigestAlgorithm(String algo) throws IllegalArgumentException {
        switch (algo.toLowerCase()) {
            case "md5": 
            case "ckm_md5": {
                this.hashAlg = 528L;
                break;
            }
            case "sha1": 
            case "sha-1": 
            case "ckm_sha_1": {
                this.hashAlg = 544L;
                break;
            }
            case "sha256": 
            case "sha-256": 
            case "ckm_sha256": {
                this.hashAlg = 592L;
                break;
            }
            case "sha384": 
            case "sha-384": 
            case "ckm_sha384": {
                this.hashAlg = 608L;
                break;
            }
            case "sha512": 
            case "sha-512": 
            case "ckm_sha512": {
                this.hashAlg = 624L;
                break;
            }
            default: {
                String msg = "Unknown algorithm identifier: " + algo;
                throw new IllegalArgumentException(msg);
            }
        }
    }

    public void setDigestAlgorithm(DigestAlgorithm algo) throws IllegalArgumentException {
        if (algo instanceof HMACAlgorithm || algo instanceof CMACAlgorithm) {
            String msg = "Unable to use MAC digest algorithm " + algo;
            msg = msg + " in place of an unkeyed hash algorithm";
            throw new IllegalArgumentException(msg);
        }
        this.hashAlg = algo.getEnum().getValue();
    }

    public void setDigestAlgorithm(long algo) throws IllegalArgumentException {
        this.hashAlg = algo;
    }

    public void setMaskGenAlgorithm(String algo) throws IllegalArgumentException {
        if (!algo.toLowerCase().equals("mgf1")) {
            String msg = "Unknown mask generation algorithm: " + algo;
            throw new IllegalArgumentException(msg);
        }
    }

    public void setMaskGenAlgorithmType(String algo) throws IllegalArgumentException {
        switch (algo.toLowerCase()) {
            case "sha1": 
            case "sha-1": 
            case "ckm_sha_1": {
                this.hashAlg = 1L;
                break;
            }
            case "sha256": 
            case "sha-256": 
            case "ckm_sha256": {
                this.hashAlg = 2L;
                break;
            }
            case "sha384": 
            case "sha-384": 
            case "ckm_sha384": {
                this.hashAlg = 3L;
                break;
            }
            case "sha512": 
            case "sha-512": 
            case "ckm_sha512": {
                this.hashAlg = 4L;
                break;
            }
            default: {
                String msg = "Unknown mask generation algorithm identifier: " + algo;
                throw new IllegalArgumentException(msg);
            }
        }
    }

    public void setMaskGenAlgorithmType(AlgorithmParameterSpec algo) throws IllegalArgumentException {
        if (!(algo instanceof MGF1ParameterSpec)) {
            Object msg = "Unknown mask generation algorithm parameter ";
            msg = (String)msg + "specification: " + algo;
            throw new IllegalArgumentException((String)msg);
        }
        MGF1ParameterSpec mgf1 = (MGF1ParameterSpec)algo;
        switch (mgf1.getDigestAlgorithm().toLowerCase()) {
            case "sha1": 
            case "sha-1": {
                this.mgf = 1L;
                break;
            }
            case "sha256": 
            case "sha-256": {
                this.mgf = 2L;
                break;
            }
            case "sha384": 
            case "sha-384": {
                this.mgf = 3L;
                break;
            }
            case "sha512": 
            case "sha-512": {
                this.mgf = 4L;
                break;
            }
            default: {
                Object msg = "Unknown mask generation algorithm identifier: ";
                msg = (String)msg + mgf1.getDigestAlgorithm();
                throw new IllegalArgumentException((String)msg);
            }
        }
    }

    public void setMaskGenAlgorithmType(long algo) throws IllegalArgumentException {
        this.mgf = algo;
    }

    public void setPSource(PSource spec) throws IllegalArgumentException {
        if (spec == null) {
            this.sourceData = null;
            return;
        }
        if (!(spec instanceof PSource.PSpecified)) {
            Object msg = "Expected PSource spec to be an instance of ";
            msg = (String)msg + "PSource.PSpecified, but wasn't: " + spec;
            throw new IllegalArgumentException((String)msg);
        }
        PSource.PSpecified value = (PSource.PSpecified)spec;
        this.setPSource(value.getValue());
    }

    public void setPSource(byte[] data) throws IllegalArgumentException {
        if (data == null || data.length == 0) {
            this.sourceData = null;
            return;
        }
        this.sourceData = data;
    }

    @Override
    protected native void acquireNativeResources() throws Exception;

    @Override
    protected native void releaseNativeResources() throws Exception;
}

