/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerEncoder;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AVAValueConverter;
import org.mozilla.jss.netscape.security.x509.GenericValueConverter;
import org.mozilla.jss.netscape.security.x509.X500NameAttrMap;

public final class Attribute
implements Serializable,
DerEncoder {
    private static final long serialVersionUID = -931486084625476764L;
    ObjectIdentifier oid;
    Vector<String> valueSet = new Vector();
    protected transient X500NameAttrMap attrMap;

    public Attribute(ObjectIdentifier oid, String value) throws IOException {
        if (oid == null || value == null) {
            throw new IOException("Invalid Input - null passed");
        }
        this.attrMap = X500NameAttrMap.getDefault();
        this.oid = oid;
        this.valueSet.addElement(value);
    }

    public Attribute(ObjectIdentifier oid, Vector<String> values) throws IOException {
        if (oid == null || values == null) {
            throw new IOException("Invalid Input - null passed");
        }
        this.attrMap = X500NameAttrMap.getDefault();
        this.oid = oid;
        Enumeration<String> vals = values.elements();
        while (vals.hasMoreElements()) {
            this.valueSet.addElement(vals.nextElement());
        }
    }

    public Attribute(String attr, Vector<String> values) throws IOException {
        if (attr == null || values == null) {
            throw new IOException("Invalid Input - null passed");
        }
        ObjectIdentifier identifier = null;
        try {
            identifier = new ObjectIdentifier(attr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ObjectIdentifier id = identifier;
        if (identifier == null) {
            this.attrMap = X500NameAttrMap.getDefault();
            id = this.attrMap.getOid(attr);
            if (id == null) {
                throw new IOException("Attr is not supported - does not contain in attr map");
            }
        }
        this.oid = id;
        Enumeration<String> vals = values.elements();
        while (vals.hasMoreElements()) {
            this.valueSet.addElement(vals.nextElement());
        }
    }

    public Attribute(DerValue val) throws IOException {
        if (val == null) {
            throw new IOException("Invalid Input - null passed");
        }
        this.attrMap = X500NameAttrMap.getDefault();
        this.decodeThis(val);
    }

    public ObjectIdentifier getOid() {
        return this.oid;
    }

    public Enumeration<String> getValues() {
        if (this.valueSet == null) {
            return null;
        }
        return this.valueSet.elements();
    }

    public void encode(DerOutputStream out) throws IOException {
        this.encodeThis(out);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        this.encodeThis(out);
    }

    public String toString() {
        String theoid = "Attribute: " + this.oid + "\n";
        StringBuffer values = new StringBuffer("Values: ");
        Enumeration<String> n = this.valueSet.elements();
        if (n.hasMoreElements()) {
            values.append(n.nextElement());
            while (n.hasMoreElements()) {
                values.append("," + n.nextElement());
            }
        }
        return theoid + values.toString() + "\n";
    }

    private void encodeThis(OutputStream out) throws IOException {
        try (DerOutputStream tmp2 = new DerOutputStream();){
            DerOutputStream tmp = new DerOutputStream();
            tmp.putOID(this.oid);
            this.encodeValueSet(tmp);
            tmp2.write((byte)48, tmp);
            out.write(tmp2.toByteArray());
        }
    }

    private void encodeValueSet(OutputStream out) throws IOException {
        try (DerOutputStream tmp2 = new DerOutputStream();){
            DerOutputStream tmp = new DerOutputStream();
            AVAValueConverter converter = this.attrMap.getValueConverter(this.oid);
            if (converter == null) {
                converter = new GenericValueConverter();
            }
            Enumeration<String> vals = this.valueSet.elements();
            while (vals.hasMoreElements()) {
                String val = vals.nextElement();
                DerValue derobj = converter.getValue(val);
                derobj.encode(tmp);
            }
            tmp2.write((byte)49, tmp);
            out.write(tmp2.toByteArray());
        }
    }

    private void decodeThis(DerValue val) throws IOException {
        if (val == null) {
            throw new IOException("Invalid Input - null passed.");
        }
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for Attribute.");
        }
        if (val.data.available() == 0) {
            throw new IOException("No data available in passed DER encoded value.");
        }
        this.oid = val.data.getDerValue().getOID();
        if (val.data.available() == 0) {
            throw new IOException("Invalid encoding for Attribute - value missing");
        }
        this.decodeValueSet(val.data.getDerValue());
        if (this.oid == null) {
            throw new IOException("Invalid encoding for Attribute - OID missing");
        }
    }

    private void decodeValueSet(DerValue val) throws IOException {
        if (val == null) {
            throw new IOException("Invalid Input - null passed.");
        }
        AVAValueConverter converter = this.attrMap.getValueConverter(this.oid);
        if (converter == null) {
            converter = new GenericValueConverter();
        }
        if (val.tag != 49) {
            throw new IOException("Invalid encoding for Attribute Value Set.");
        }
        if (val.data.available() == 0) {
            throw new IOException("No data available in passed DER encoded attribute value set.");
        }
        while (val.data.available() != 0) {
            DerValue value = val.data.getDerValue();
            this.valueSet.addElement(converter.getAsString(value));
        }
    }
}

