/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.wisp.engine.StealAwareRunnable;
import com.alibaba.wisp.engine.TimeOut;
import com.alibaba.wisp.engine.WispCarrier;
import com.alibaba.wisp.engine.WispConfiguration;
import com.alibaba.wisp.engine.WispEngine;
import com.alibaba.wisp.engine.WispEventPump;
import com.alibaba.wisp.engine.WispSysmon;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.misc.UnsafeAccess;

class WispScheduler {
    private static final SchedulingPolicy SCHEDULING_POLICY = WispConfiguration.SCHEDULING_POLICY;
    private static final int IDX_MASK = 65535;
    private static final int STEAL_HIGH_WATER_LEVEL = 4;
    private int PARALLEL;
    private int STEAL_RETRY;
    private int PUSH_RETRY;
    private int HELP_STEAL_RETRY;
    private final boolean IS_ROOT_CARRIER;
    private volatile Worker[] workers;
    private final ThreadFactory threadFactory;
    private final WispEngine engine;
    private int sharedSeed = WispScheduler.randomSeed();
    private static final AtomicIntegerFieldUpdater<Worker> LENGTH_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Worker.class, "queueLength");
    private static final UnsafeAccess UA = SharedSecrets.getUnsafeAccess();
    private static final JavaLangAccess JLA = SharedSecrets.getJavaLangAccess();

    WispScheduler(int n, ThreadFactory threadFactory, WispEngine wispEngine) {
        this(n, Math.max(1, n / 2), n, Math.max(1, n / 4), threadFactory, wispEngine, false);
    }

    WispScheduler(int n, int n2, int n3, int n4, ThreadFactory threadFactory, WispEngine wispEngine, boolean bl) {
        assert (n > 0);
        this.PARALLEL = n;
        this.STEAL_RETRY = n2;
        this.PUSH_RETRY = n3;
        this.HELP_STEAL_RETRY = n4;
        this.IS_ROOT_CARRIER = bl;
        this.engine = wispEngine;
        this.threadFactory = threadFactory;
        this.workers = new Worker[this.PARALLEL];
        for (int i = n - 1; i >= 0; --i) {
            this.workers[i] = new Worker(i);
            this.workers[i].next = i == this.PARALLEL - 1 ? null : this.workers[i + 1];
        }
        this.workers[this.PARALLEL - 1].next = this.workers[0];
        if (!bl) {
            this.startWorkerThreads();
        }
    }

    void startWorkerThreads() {
        for (Worker worker : this.workers) {
            worker.thread.start();
        }
    }

    private int generateRandom() {
        this.sharedSeed = WispScheduler.nextRandom(this.sharedSeed);
        return this.sharedSeed;
    }

    private Runnable trySteal(int n) {
        Worker worker = null;
        for (int i = 0; i < this.STEAL_RETRY; ++i) {
            Runnable runnable;
            Worker worker2 = this.getWorker(n + i);
            int n2 = worker2.queueLength;
            if (n2 >= 4 && (runnable = worker2.pollTask(true)) != null) {
                return runnable;
            }
            if (worker != null && n2 <= worker.queueLength) continue;
            worker = worker2;
        }
        return worker == null ? null : worker.pollTask(true);
    }

    private boolean tryPush(int n, StealAwareRunnable stealAwareRunnable, boolean bl) {
        assert (n > 0);
        int n2 = this.generateRandom();
        Worker worker = null;
        int n3 = Integer.MAX_VALUE;
        Worker worker2 = this.getWorker(n2);
        for (int i = 0; i < n; ++i) {
            if (worker2.idleOrPolling()) {
                if (stealAwareRunnable != null) {
                    worker2.pushAndSignal(stealAwareRunnable);
                } else {
                    worker2.signal();
                }
                return true;
            }
            int n4 = worker2.queueLength;
            if (n4 < n3) {
                worker = worker2;
                n3 = n4;
            }
            worker2 = worker2.next;
        }
        if (bl) {
            assert (worker != null && stealAwareRunnable != null);
            worker.pushAndSignal(stealAwareRunnable);
            return true;
        }
        return false;
    }

    private Worker getWorker(int n) {
        return this.workers[(n & 0xFFFF) % this.PARALLEL];
    }

    private Worker castToWorker(Thread thread, boolean bl) {
        if (thread == null) {
            return null;
        }
        Worker worker = WispScheduler.JLA.getWispTask((Thread)thread).carrier.worker;
        if (worker == null || worker.theScheduler() != this) {
            return null;
        }
        return bl && worker.hasBeenHandoff ? null : worker;
    }

    void addTimer(final TimeOut timeOut, Thread thread) {
        Worker worker = this.castToWorker(thread, true);
        if (worker != null) {
            worker.timerManager.addTimer(timeOut);
        } else {
            this.tryPush(1, new StealAwareRunnable(){

                @Override
                public void run() {
                    Worker worker = WispScheduler.this.castToWorker(JLA.currentThread0(), false);
                    assert (worker != null);
                    worker.timerManager.addTimer(timeOut);
                }
            }, true);
        }
    }

    void cancelTimer(TimeOut timeOut, Thread thread) {
        Worker worker = this.castToWorker(thread, true);
        if (worker != null) {
            worker.timerManager.cancelTimer(timeOut);
        }
    }

    void executeWithWorkerThread(StealAwareRunnable stealAwareRunnable, Thread thread) {
        Worker worker = this.castToWorker(thread, false);
        boolean bl = stealAwareRunnable.isStealEnable();
        if (worker == null || worker.hasBeenHandoff && bl) {
            this.execute(stealAwareRunnable);
        } else {
            SCHEDULING_POLICY.enqueue(worker, bl, stealAwareRunnable);
        }
    }

    private void signalIdleWorkerToHelpSteal() {
        this.tryPush(this.HELP_STEAL_RETRY, null, false);
    }

    public void execute(StealAwareRunnable stealAwareRunnable) {
        this.tryPush(this.PUSH_RETRY, stealAwareRunnable, true);
    }

    void handOffWorkerThread(Thread thread) {
        assert ("Wisp-Sysmon".equals(Thread.currentThread().getName()));
        Worker worker = this.castToWorker(thread, true);
        if (worker != null && !worker.hasBeenHandoff) {
            worker.hasBeenHandoff = true;
            worker.pushAndSignal(new StealAwareRunnable(){

                @Override
                public void run() {
                }
            });
            worker.thread.setName(worker.thread.getName() + " (HandOff)");
            Worker[] workerArray = Arrays.copyOf(this.workers, this.workers.length);
            Worker worker2 = workerArray[this.PARALLEL - 1];
            for (int i = 0; i < this.PARALLEL; ++i) {
                if (workerArray[i] == worker) {
                    workerArray[i] = new Worker(i);
                    workerArray[i].copyContextFromDetachedCarrier(worker);
                    workerArray[i].next = worker.next;
                    worker2.next = workerArray[i];
                    workerArray[i].thread.start();
                    break;
                }
                worker2 = workerArray[i];
            }
            this.workers = workerArray;
            WispEngine.deRegisterPerfCounter(WispScheduler.JLA.getWispTask((Thread)thread).carrier);
        }
    }

    void checkAndGrowWorkers(int n) {
        int n2;
        assert ("Wisp-Sysmon".equals(Thread.currentThread().getName()));
        if (n <= this.workers.length) {
            return;
        }
        double d = (double)n / (double)this.workers.length;
        Worker[] workerArray = Arrays.copyOf(this.workers, n);
        for (n2 = n - 1; n2 >= this.workers.length; --n2) {
            if (workerArray[n2] != null) continue;
            workerArray[n2] = new Worker(n2);
            workerArray[n2].next = n2 == n - 1 ? workerArray[0] : workerArray[n2 + 1];
        }
        workerArray[this.workers.length - 1].next = workerArray[this.workers.length];
        for (n2 = this.workers.length; n2 < n; ++n2) {
            workerArray[n2].thread.start();
        }
        n2 = this.workers.length;
        this.workers = workerArray;
        this.adjustParameters(n2, d);
    }

    private void adjustParameters(int n, double d) {
        this.PARALLEL = Integer.min((int)Math.round((double)n * d), this.workers.length);
        this.PUSH_RETRY = (int)((double)this.PARALLEL * d);
        this.STEAL_RETRY = (int)((double)this.STEAL_RETRY * d);
        this.HELP_STEAL_RETRY = (int)((double)this.HELP_STEAL_RETRY * d);
    }

    private static void doExec(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static int nextRandom(int n) {
        n ^= n << 13;
        n ^= n >>> 17;
        return n ^ n << 5;
    }

    private static int randomSeed() {
        int n = 0;
        while (n == 0) {
            n = (int)System.nanoTime();
        }
        return n;
    }

    static enum SchedulingPolicy {
        PULL{

            @Override
            void enqueue(Worker worker, boolean bl, StealAwareRunnable stealAwareRunnable) {
                WispScheduler wispScheduler = worker.theScheduler();
                if (!worker.pushAndSignal(stealAwareRunnable) && bl && wispScheduler.HELP_STEAL_RETRY > 0) {
                    wispScheduler.signalIdleWorkerToHelpSteal();
                }
            }

            @Override
            Runnable steal(Worker worker, int n) {
                return worker.theScheduler().trySteal(n);
            }
        }
        ,
        PUSH{

            @Override
            void enqueue(Worker worker, boolean bl, StealAwareRunnable stealAwareRunnable) {
                WispScheduler wispScheduler = worker.theScheduler();
                if (bl && !worker.idleOrPolling() && !worker.isProcessingTimer() && wispScheduler.STEAL_RETRY > 0 && wispScheduler.tryPush(wispScheduler.STEAL_RETRY, stealAwareRunnable, false)) {
                    return;
                }
                worker.pushAndSignal(stealAwareRunnable);
            }

            @Override
            Runnable steal(Worker worker, int n) {
                return null;
            }
        };


        abstract void enqueue(Worker var1, boolean var2, StealAwareRunnable var3);

        abstract Runnable steal(Worker var1, int var2);
    }

    class Worker
    implements Runnable {
        ConcurrentLinkedQueue<StealAwareRunnable> taskQueue;
        private final TimeOut.TimerManager timerManager;
        private final Thread thread;
        private final WispEventPump pump;
        volatile boolean hasBeenHandoff = false;
        private Worker next;
        private static final int QL_PROCESSING_TIMER = -1;
        private static final int QL_POLLING = -1000002;
        private static final int QL_IDLE = -2000002;
        volatile int queueLength;

        Worker(int n) {
            this.thread = WispScheduler.this.threadFactory.newThread(this);
            WispEngine.carrierThreads.add(this.thread);
            this.taskQueue = new ConcurrentLinkedQueue();
            this.timerManager = new TimeOut.TimerManager();
            this.queueLength = 0;
            this.pump = WispConfiguration.CARRIER_AS_POLLER && WispScheduler.this.IS_ROOT_CARRIER ? WispEventPump.Pool.INSTANCE.getPump(n) : null;
        }

        void processTimer() {
            this.timerManager.processTimeoutEventsAndGetWaitDeadline(System.nanoTime());
        }

        @Override
        public void run() {
            try {
                WispCarrier wispCarrier = WispCarrier.current();
                wispCarrier.engine = WispScheduler.this.engine;
                wispCarrier.worker = this;
                ((WispScheduler)WispScheduler.this).engine.carrierEngines.add(wispCarrier);
                WispEngine.registerPerfCounter(wispCarrier);
                WispSysmon.INSTANCE.register(wispCarrier);
                this.runCarrier(wispCarrier);
            }
            finally {
                WispEngine.carrierThreads.remove(this.thread);
                try {
                    ((WispScheduler)WispScheduler.this).engine.shutdownBarrier.await();
                }
                catch (Exception exception) {
                    StringWriter stringWriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringWriter));
                    System.out.println("[Wisp-ERROR] unexpected error on current" + Thread.currentThread() + "has exception" + stringWriter.toString());
                }
            }
        }

        private void runCarrier(WispCarrier wispCarrier) {
            int n = WispScheduler.randomSeed();
            while (true) {
                Runnable runnable;
                if ((runnable = this.pollTask(false)) != null) {
                    WispScheduler.doExec(runnable);
                    continue;
                }
                if (wispCarrier.engine.terminated) {
                    return;
                }
                n = WispScheduler.nextRandom(n);
                runnable = SCHEDULING_POLICY.steal(this, n);
                if (runnable != null) {
                    WispScheduler.doExec(runnable);
                    continue;
                }
                this.doParkOrPolling();
            }
        }

        private void doParkOrPolling() {
            int n = -1;
            if (this.queueLength != 0 || !LENGTH_UPDATER.compareAndSet(this, 0, n)) {
                return;
            }
            long l = System.nanoTime();
            long l2 = this.timerManager.processTimeoutEventsAndGetWaitDeadline(l);
            assert (l2 != 0L);
            if (this.queueLength == n) {
                int n2;
                int n3 = n2 = this.pump != null && this.pump.tryAcquire(this) ? -1000002 : -2000002;
                if (LENGTH_UPDATER.compareAndSet(this, n, n2)) {
                    n = n2;
                    if (this.taskQueue.peek() == null) {
                        if (n == -2000002) {
                            UA.park0(false, l2 < 0L ? 0L : l2 - l);
                        } else {
                            this.doPolling(l2, l);
                        }
                    }
                }
                if (n2 == -1000002) {
                    this.pump.release(this);
                }
            }
            LENGTH_UPDATER.addAndGet(this, -n);
        }

        private void doPolling(long l, long l2) {
            while (!(l >= 0L && l <= l2 || this.pump.pollAndDispatchEvents(l < 0L ? -1L : TimeOut.nanos2Millis(l - l2)) || this.queueLength != -1000002)) {
                l2 = l < 0L ? l2 : System.nanoTime();
            }
        }

        private boolean doSignalIfNecessary(int n) {
            Thread thread = JLA.currentThread0();
            if (this.thread != thread) {
                if (n == -2000002) {
                    UA.unpark0(this.thread);
                } else if (n == -1000002) {
                    this.pump.wakeup();
                }
            }
            return n < 0;
        }

        boolean idleOrPolling() {
            return this.queueLength == -2000002 || this.queueLength == -1000002;
        }

        boolean isProcessingTimer() {
            return this.queueLength == -1;
        }

        Runnable pollTask(boolean bl) {
            StealAwareRunnable stealAwareRunnable = this.taskQueue.poll();
            if (stealAwareRunnable != null) {
                LENGTH_UPDATER.decrementAndGet(this);
                if (bl && !stealAwareRunnable.isStealEnable()) {
                    this.pushAndSignal(stealAwareRunnable);
                    return null;
                }
            }
            return stealAwareRunnable;
        }

        boolean pushAndSignal(StealAwareRunnable stealAwareRunnable) {
            this.taskQueue.offer(stealAwareRunnable);
            return this.doSignalIfNecessary(LENGTH_UPDATER.getAndIncrement(this));
        }

        void signal() {
            this.doSignalIfNecessary(this.queueLength);
        }

        void copyContextFromDetachedCarrier(Worker worker) {
            StealAwareRunnable stealAwareRunnable;
            this.timerManager.copyTimer(worker.timerManager.queue);
            while ((stealAwareRunnable = worker.taskQueue.poll()) != null) {
                this.pushAndSignal(stealAwareRunnable);
            }
        }

        WispScheduler theScheduler() {
            return WispScheduler.this;
        }
    }
}

