/*
 * Copyright 2020 The TensorFlow Runtime Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file declares the interface to the BEFToMLIR library.

#ifndef TFRT_BEF_CONVERTER_BEF_TO_MLIR_H_
#define TFRT_BEF_CONVERTER_BEF_TO_MLIR_H_

#include "tfrt/support/forward_decls.h"

namespace mlir {
class Location;
class MLIRContext;
class ModuleOp;
template <typename OpTy>
class OwningOpRef;
}  // namespace mlir

namespace tfrt {

// This function converts the specified host executor compatible program in
// BinaryExecutableFormat (BEF) format to a MLIR module containing this host
// executor program.
//
// On error, this emits the error message through the MLIR error handler, and
// returns a null module.
mlir::OwningOpRef<mlir::ModuleOp> ConvertBEFToMLIR(mlir::Location location,
                                                   ArrayRef<uint8_t> bef_file,
                                                   mlir::MLIRContext* context);

}  // namespace tfrt

#endif  // TFRT_BEF_CONVERTER_BEF_TO_MLIR_H_
