/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.common.ShareableEnv;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPUrl;

class ContextEnv
extends ShareableEnv {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 389;
    public static final int DEFAULT_SSL_PORT = 636;
    public static final int DEFAULT_LDAP_VERSION = 3;
    public static final String P_PROVIDER_URL = "java.naming.provider.url";
    public static final String P_SECURITY_PROTOCOL = "java.naming.security.protocol";
    public static final String P_SECURITY_AUTHMODE = "java.naming.security.authentication";
    public static final String P_USER_DN = "java.naming.security.principal";
    public static final String P_USER_PASSWORD = "java.naming.security.credentials";
    public static final String P_AUTHORITATIVE = "java.naming.authoritative";
    public static final String P_LANGUAGE = "java.naming.language";
    public static final String P_BATCHSIZE = "java.naming.batchsize";
    public static final String P_REFERRAL_MODE = "java.naming.referral";
    public static final String P_CONNECT_CTRLS = "java.naming.ldap.control.connect";
    public static final String P_BINARY_ATTRS = "java.naming.ldap.attributes.binary";
    public static final String P_ATTRS_ONLY = "java.naming.ldap.typesOnly";
    public static final String P_DELETE_OLDRDN = "java.naming.ldap.deleteRDN";
    public static final String P_SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    public static final String P_CIPHER_SUITE = "java.naming.ldap.ssl.ciphers";
    public static final String P_TIME_LIMIT = "java.naming.ldap.timelimit";
    public static final String P_MAX_RESULTS = "java.naming.ldap.maxresults";
    public static final String P_DEREF_ALIASES = "java.naming.ldap.derefAliases";
    public static final String P_REFERRAL_HOPLIMIT = "java.naming.referral.limit";
    public static final String P_LDAP_VERSION = "java.naming.ldap.version";
    public static final String P_JNDIREF_SEPARATOR = "java.naming.ref.separator";
    public static final String P_SASL_AUTHID = "java.naming.security.sasl.authorizationId";
    public static final String P_SASL_CALLBACK = "java.naming.security.sasl.callback";
    public static final String P_SASL_PKGS = "javax.security.sasl.client.pkgs";
    private static final String SASL_PROP_PREFIX = "javax.security.sasl";
    public static final String P_TRACE = "com.netscape.ldap.trace";
    private static final String V_REFERRAL_FOLLOW = "follow";
    private static final String V_REFERRAL_IGNORE = "ignore";
    private static final String V_REFERRAL_THROW_EXCEPTION = "throw";
    private static final String V_DEREF_NEVER = "never";
    private static final String V_DEREF_SEARCHING = "searching";
    private static final String V_DEREF_FINDING = "finding";
    private static final String V_DEREF_ALWAYS = "always";
    private static final String V_AUTH_NONE = "none";
    private static final String V_AUTH_SIMPLE = "simple";

    public ContextEnv(ShareableEnv parent, int parentSharedEnvIdx) {
        super(parent, parentSharedEnvIdx);
    }

    public ContextEnv(Hashtable<Object, Object> initialEnv) {
        super(initialEnv);
    }

    @Override
    public Object clone() {
        this.freezeUpdates();
        if (this.m_sharedEnv != null) {
            return new ContextEnv(this, this.m_sharedEnv.size() - 1);
        }
        return new ContextEnv(this.m_parentEnv, this.m_parentSharedEnvIdx);
    }

    Object updateProperty(String name, Object val, LDAPSearchConstraints cons) throws NamingException {
        Object oldVal = this.getProperty(name);
        this.setProperty(name, val);
        try {
            if (name.equalsIgnoreCase(P_BATCHSIZE)) {
                this.updateBatchSize(cons);
            } else if (name.equalsIgnoreCase(P_TIME_LIMIT)) {
                this.updateTimeLimit(cons);
            } else if (name.equalsIgnoreCase(P_MAX_RESULTS)) {
                this.updateMaxResults(cons);
            } else if (name.equalsIgnoreCase(P_DEREF_ALIASES)) {
                this.updateDerefAliases(cons);
            } else if (name.equalsIgnoreCase(P_REFERRAL_MODE)) {
                this.updateReferralMode(cons);
            } else if (name.equalsIgnoreCase(P_REFERRAL_HOPLIMIT)) {
                this.updateReferralHopLimit(cons);
            }
        }
        catch (IllegalArgumentException e) {
            if (oldVal == null) {
                this.removeProperty(name);
            } else {
                this.setProperty(name, oldVal);
            }
            throw e;
        }
        return oldVal;
    }

    void updateSearchCons(LDAPSearchConstraints cons) throws NamingException {
        this.updateBatchSize(cons);
        this.updateTimeLimit(cons);
        this.updateMaxResults(cons);
        this.updateDerefAliases(cons);
        this.updateReferralMode(cons);
        this.updateReferralHopLimit(cons);
    }

    void updateBatchSize(LDAPSearchConstraints cons) {
        String size = (String)this.getProperty(P_BATCHSIZE);
        if (size != null) {
            int n = -1;
            try {
                n = Integer.parseInt(size);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal value for java.naming.batchsize");
            }
            cons.setBatchSize(n);
        }
    }

    void updateTimeLimit(LDAPSearchConstraints cons) {
        String millis = (String)this.getProperty(P_TIME_LIMIT);
        if (millis != null) {
            int n = -1;
            try {
                n = Integer.parseInt(millis);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal value for java.naming.ldap.timelimit");
            }
            cons.setTimeLimit(n);
        }
    }

    void updateMaxResults(LDAPSearchConstraints cons) {
        String max = (String)this.getProperty(P_MAX_RESULTS);
        if (max != null) {
            int n = -1;
            try {
                n = Integer.parseInt(max);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal value for java.naming.ldap.maxresults");
            }
            cons.setMaxResults(n);
        }
    }

    final void updateDerefAliases(LDAPSearchConstraints cons) throws IllegalArgumentException {
        String deref = (String)this.getProperty(P_DEREF_ALIASES);
        if (deref != null) {
            if (deref.equalsIgnoreCase(V_DEREF_NEVER)) {
                cons.setDereference(0);
            } else if (deref.equalsIgnoreCase(V_DEREF_SEARCHING)) {
                cons.setDereference(1);
            } else if (deref.equalsIgnoreCase(V_DEREF_FINDING)) {
                cons.setDereference(2);
            } else if (deref.equalsIgnoreCase(V_DEREF_ALWAYS)) {
                cons.setDereference(3);
            } else {
                throw new IllegalArgumentException("Illegal value for java.naming.ldap.derefAliases");
            }
        }
    }

    void updateReferralMode(LDAPSearchConstraints cons) {
        String mode = (String)this.getProperty(P_REFERRAL_MODE);
        if (mode != null) {
            if (mode.equalsIgnoreCase(V_REFERRAL_FOLLOW)) {
                cons.setReferrals(true);
                String user = this.getUserDN();
                String passwd = this.getUserPassword();
                if (user != null && passwd != null) {
                    cons.setRebindProc((LDAPRebind)new ReferralRebindProc(user, passwd));
                }
            } else if (mode.equalsIgnoreCase(V_REFERRAL_THROW_EXCEPTION)) {
                cons.setReferrals(false);
            } else if (mode.equalsIgnoreCase(V_REFERRAL_IGNORE)) {
                cons.setServerControls(new LDAPControl("2.16.840.1.113730.3.4.2", false, null));
                cons.setReferrals(false);
            } else {
                throw new IllegalArgumentException("Illegal value for java.naming.referral");
            }
        }
    }

    boolean ignoreReferralsMode() {
        String mode = (String)this.getProperty(P_REFERRAL_MODE);
        return mode == null || mode.equalsIgnoreCase(V_REFERRAL_IGNORE);
    }

    void updateReferralHopLimit(LDAPSearchConstraints cons) throws IllegalArgumentException {
        String limit = (String)this.getProperty(P_REFERRAL_HOPLIMIT);
        if (limit != null) {
            int n = -1;
            try {
                n = Integer.parseInt(limit);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal value for java.naming.referral.limit");
            }
            cons.setHopLimit(n);
        }
    }

    boolean isSSLEnabled() throws NamingException {
        String secMode = (String)this.getProperty(P_SECURITY_PROTOCOL);
        if (secMode != null) {
            if (secMode.equalsIgnoreCase("ssl")) {
                return true;
            }
            throw new AuthenticationNotSupportedException("Unsupported value for java.naming.security.protocol");
        }
        return false;
    }

    LDAPUrl getDirectoryServerURL() throws NamingException {
        String url = (String)this.getProperty(P_PROVIDER_URL);
        try {
            return url == null ? null : new LDAPUrl(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Illegal value for java.naming.provider.url");
        }
    }

    int getLdapVersion() throws NamingException {
        String version = (String)this.getProperty(P_LDAP_VERSION);
        if (version != null) {
            int v = -1;
            try {
                v = Integer.parseInt(version);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal value for java.naming.ldap.version property.");
            }
            return v;
        }
        return 3;
    }

    String getUserDN() {
        return (String)this.getProperty(P_USER_DN);
    }

    String getUserPassword() {
        return (String)this.getProperty(P_USER_PASSWORD);
    }

    String getSocketFactory() {
        return (String)this.getProperty(P_SOCKET_FACTORY);
    }

    Object getCipherSuite() {
        return this.getProperty(P_CIPHER_SUITE);
    }

    LDAPControl[] getConnectControls() throws NamingException {
        Control[] reqCtls = (Control[])this.getProperty(P_CONNECT_CTRLS);
        if (reqCtls != null) {
            LDAPControl[] ldapCtls = new LDAPControl[reqCtls.length];
            for (int i = 0; i < reqCtls.length; ++i) {
                try {
                    ldapCtls[i] = (LDAPControl)reqCtls[i];
                    continue;
                }
                catch (ClassCastException ex) {
                    throw new NamingException("Unsupported control type " + reqCtls[i].getClass().getName());
                }
            }
            return ldapCtls;
        }
        return null;
    }

    boolean getAttrsOnlyFlag() {
        String flag = (String)this.getProperty(P_ATTRS_ONLY);
        if (flag == null) {
            return false;
        }
        if (flag.equalsIgnoreCase("true")) {
            return true;
        }
        if (flag.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Illegal value for java.naming.ldap.typesOnly");
    }

    boolean getDeleteOldRDNFlag() {
        String flag = (String)this.getProperty(P_DELETE_OLDRDN);
        if (flag == null) {
            return true;
        }
        if (flag.equalsIgnoreCase("true")) {
            return true;
        }
        if (flag.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Illegal value for java.naming.ldap.deleteRDN");
    }

    char getRefSeparator() throws NamingException {
        String sep = (String)this.getProperty(P_JNDIREF_SEPARATOR);
        if (sep != null) {
            if (sep.length() != 1) {
                throw new IllegalArgumentException("Illegal value for java.naming.ref.separator");
            }
            return sep.charAt(0);
        }
        return '#';
    }

    String[] getUserDefBinaryAttrs() {
        String binAttrList = (String)this.getProperty(P_BINARY_ATTRS);
        if (binAttrList == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(binAttrList);
        String[] binAttrs = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            binAttrs[i] = tok.nextToken();
            ++i;
        }
        return binAttrs;
    }

    String[] getSaslMechanisms() {
        String authMode = (String)this.getProperty(P_SECURITY_AUTHMODE);
        if (authMode != null) {
            if (authMode.equalsIgnoreCase(V_AUTH_NONE)) {
                return null;
            }
            if (authMode.equalsIgnoreCase(V_AUTH_SIMPLE)) {
                return null;
            }
            StringTokenizer tok = new StringTokenizer(authMode);
            int cnt = tok.countTokens();
            String[] mechanisms = new String[cnt];
            int i = 0;
            while (tok.hasMoreTokens()) {
                mechanisms[i] = tok.nextToken();
                ++i;
            }
        }
        return null;
    }

    Hashtable<Object, Object> getSaslProps() {
        Hashtable<Object, Object> props = this.getAllProperties();
        Hashtable<Object, Object> saslProps = new Hashtable<Object, Object>();
        String prefixUpperCase = SASL_PROP_PREFIX.toUpperCase();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(SASL_PROP_PREFIX) && !key.startsWith(prefixUpperCase) || key.equalsIgnoreCase(P_SASL_AUTHID) || key.equalsIgnoreCase(P_SASL_CALLBACK)) continue;
            saslProps.put(key, props.get(key));
        }
        return saslProps.size() > 0 ? saslProps : null;
    }

    String getSaslAuthId() {
        String id = (String)this.getProperty(P_SASL_AUTHID);
        if (id != null) {
            return id;
        }
        return (String)this.getProperty(P_USER_DN);
    }

    Object getSaslCallback() {
        return this.getProperty(P_SASL_CALLBACK);
    }

    static class ReferralRebindProc
    implements LDAPRebind {
        LDAPRebindAuth auth;

        public ReferralRebindProc(final String user, final String passwd) {
            this.auth = new LDAPRebindAuth(){

                public String getDN() {
                    return user;
                }

                public String getPassword() {
                    return passwd;
                }
            };
        }

        public LDAPRebindAuth getRebindAuthentication(String host, int port) {
            return this.auth;
        }
    }
}

