/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.util.LDAPWriter;
import netscape.ldap.util.LDIF;

public class LDIFWriter
extends LDAPWriter {
    private String m_sep;
    private boolean m_foldLines;
    private boolean m_attrsOnly;
    private boolean m_toFiles;
    private static final String DEFAULT_SEPARATOR = ":";
    private static final int MAX_LINE = 77;

    public LDIFWriter(PrintWriter pw) {
        this(pw, false, DEFAULT_SEPARATOR, true, false);
    }

    public LDIFWriter(PrintWriter pw, boolean attrsOnly, String separator, boolean foldLines, boolean toFiles) {
        super(pw);
        this.m_attrsOnly = attrsOnly;
        this.m_sep = separator;
        this.m_foldLines = foldLines;
        this.m_toFiles = toFiles;
    }

    @Override
    protected void printAttribute(LDAPAttribute attr) {
        String attrName = attr.getName();
        if (this.m_attrsOnly) {
            this.printString(attrName + this.m_sep);
            return;
        }
        Enumeration<byte[]> enumVals = attr.getByteValues();
        if (enumVals != null) {
            while (enumVals.hasMoreElements()) {
                String s;
                if (this.m_toFiles) {
                    try {
                        FileOutputStream f = this.getTempFile(attrName);
                        f.write(enumVals.nextElement());
                    }
                    catch (Exception e) {
                        System.err.println("Error writing values of " + attrName + ", " + e.toString());
                        System.exit(1);
                    }
                    continue;
                }
                byte[] b = enumVals.nextElement();
                if (LDIF.isPrintable(b)) {
                    try {
                        s = new String(b, "UTF8");
                    }
                    catch (UnsupportedEncodingException e) {
                        s = "";
                    }
                    this.printString(attrName + this.m_sep + " " + s);
                    continue;
                }
                s = this.getPrintableValue(b);
                if (s.length() > 0) {
                    this.printString(attrName + ":: " + s);
                    continue;
                }
                this.printString(attrName + this.m_sep + " ");
            }
        } else {
            this.printString(attrName + this.m_sep + " ");
        }
    }

    @Override
    protected void printEntryStart(String dn) {
        if (dn == null) {
            this.printString("dn" + this.m_sep + " ");
        } else {
            byte[] b = null;
            try {
                b = dn.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (LDIF.isPrintable(b)) {
                this.printString("dn" + this.m_sep + " " + dn);
            } else {
                dn = this.getPrintableValue(b);
                this.printString("dn" + this.m_sep + this.m_sep + " " + dn);
            }
        }
    }

    @Override
    protected void printEntryEnd(String dn) {
        this.m_pw.println();
    }

    protected void printString(String value) {
        if (this.m_foldLines) {
            LDIF.breakString(this.m_pw, value, 77);
        } else {
            this.m_pw.print(value);
            this.m_pw.print('\n');
        }
    }

    protected FileOutputStream getTempFile(String name) throws IOException {
        String filename;
        File f;
        int num = 0;
        do {
            filename = name + "." + num;
            f = new File(filename);
            ++num;
        } while (f.exists());
        this.printString(name + this.m_sep + " " + filename);
        return new FileOutputStream(f);
    }
}

