/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDITContentRuleSchema;
import netscape.ldap.LDAPDITStructureRuleSchema;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMatchingRuleSchema;
import netscape.ldap.LDAPNameFormSchema;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchemaElement;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSyntaxSchema;

public class LDAPSchema
implements Serializable {
    static final long serialVersionUID = -3911737419783579398L;
    private Hashtable<String, LDAPObjectClassSchema> objectClasses = new Hashtable();
    private Hashtable<String, LDAPAttributeSchema> attributes = new Hashtable();
    private Hashtable<String, LDAPMatchingRuleSchema> matchingRules = new Hashtable();
    private Hashtable<String, LDAPSyntaxSchema> syntaxes = new Hashtable();
    private Hashtable<String, LDAPDITStructureRuleSchema> structureRulesByName = new Hashtable();
    private Hashtable<Integer, LDAPDITStructureRuleSchema> structureRulesById = new Hashtable();
    private Hashtable<String, LDAPDITContentRuleSchema> contentRules = new Hashtable();
    private Hashtable<String, LDAPNameFormSchema> nameForms = new Hashtable();

    public LDAPSchema() {
    }

    public LDAPSchema(LDAPEntry entry) {
        this.initialize(entry);
    }

    public void addObjectClass(LDAPObjectClassSchema objectSchema) {
        this.objectClasses.put(objectSchema.getName().toLowerCase(), objectSchema);
    }

    public void addAttribute(LDAPAttributeSchema attrSchema) {
        this.attributes.put(attrSchema.getName().toLowerCase(), attrSchema);
    }

    public void addMatchingRule(LDAPMatchingRuleSchema matchSchema) {
        this.matchingRules.put(matchSchema.getName().toLowerCase(), matchSchema);
    }

    public void addSyntax(LDAPSyntaxSchema syntaxSchema) {
        String name = syntaxSchema.getName().toLowerCase();
        if (name.length() < 1) {
            name = syntaxSchema.getOID();
        }
        this.syntaxes.put(name, syntaxSchema);
    }

    public void addDITStructureRule(LDAPDITStructureRuleSchema rule) {
        String name = rule.getName().toLowerCase();
        this.structureRulesByName.put(name, rule);
        this.structureRulesById.put(rule.getRuleID(), rule);
    }

    public void addDITContentRule(LDAPDITContentRuleSchema rule) {
        String name = rule.getName().toLowerCase();
        this.contentRules.put(name, rule);
    }

    public void addNameForm(LDAPNameFormSchema nameForm) {
        String name = nameForm.getName().toLowerCase();
        this.nameForms.put(name, nameForm);
    }

    public Enumeration<LDAPObjectClassSchema> getObjectClasses() {
        return this.objectClasses.elements();
    }

    public Enumeration<LDAPAttributeSchema> getAttributes() {
        return this.attributes.elements();
    }

    public Enumeration<LDAPMatchingRuleSchema> getMatchingRules() {
        return this.matchingRules.elements();
    }

    public Enumeration<LDAPSyntaxSchema> getSyntaxes() {
        return this.syntaxes.elements();
    }

    public Enumeration<LDAPDITStructureRuleSchema> getDITStructureRules() {
        return this.structureRulesByName.elements();
    }

    public Enumeration<LDAPDITContentRuleSchema> getDITContentRules() {
        return this.contentRules.elements();
    }

    public Enumeration<LDAPNameFormSchema> getNameForms() {
        return this.nameForms.elements();
    }

    public LDAPObjectClassSchema getObjectClass(String name) {
        return this.objectClasses.get(name.toLowerCase());
    }

    public LDAPAttributeSchema getAttribute(String name) {
        return this.attributes.get(name.toLowerCase());
    }

    public LDAPMatchingRuleSchema getMatchingRule(String name) {
        return this.matchingRules.get(name.toLowerCase());
    }

    public LDAPSyntaxSchema getSyntax(String name) {
        return this.syntaxes.get(name.toLowerCase());
    }

    public LDAPDITStructureRuleSchema getDITStructureRule(String name) {
        return this.structureRulesByName.get(name.toLowerCase());
    }

    public LDAPDITStructureRuleSchema getDITStructureRule(int ID) {
        return this.structureRulesById.get(ID);
    }

    public LDAPDITContentRuleSchema getDITContentRule(String name) {
        return this.contentRules.get(name.toLowerCase());
    }

    public LDAPNameFormSchema getNameForm(String name) {
        return this.nameForms.get(name.toLowerCase());
    }

    public Enumeration<String> getObjectClassNames() {
        return this.objectClasses.keys();
    }

    public Enumeration<String> getAttributeNames() {
        return this.attributes.keys();
    }

    public Enumeration<String> getMatchingRuleNames() {
        return this.matchingRules.keys();
    }

    public Enumeration<String> getSyntaxNames() {
        return this.syntaxes.keys();
    }

    public Enumeration<String> getDITStructureRuleNames() {
        return this.structureRulesByName.keys();
    }

    public Enumeration<String> getDITContentRuleNames() {
        return this.contentRules.keys();
    }

    public Enumeration<String> getNameFormNames() {
        return this.nameForms.keys();
    }

    public void fetchSchema(LDAPConnection ld, String dn) throws LDAPException {
        String entryName = LDAPSchema.getSchemaDN(ld, dn);
        LDAPEntry entry = LDAPSchema.readSchema(ld, entryName);
        this.initialize(entry);
    }

    protected void initialize(LDAPEntry entry) {
        LDAPMatchingRuleSchema sch;
        LDAPSchemaElement sch2;
        Enumeration<String> en;
        LDAPAttribute attr = entry.getAttribute("objectclasses");
        if (attr != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPObjectClassSchema(en.nextElement());
                this.addObjectClass((LDAPObjectClassSchema)sch2);
            }
        }
        if ((attr = entry.getAttribute("attributetypes")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPAttributeSchema(en.nextElement());
                this.addAttribute((LDAPAttributeSchema)sch2);
            }
        }
        if ((attr = entry.getAttribute("ldapsyntaxes")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPSyntaxSchema(en.nextElement());
                this.addSyntax((LDAPSyntaxSchema)sch2);
            }
        }
        if ((attr = entry.getAttribute("ldapditstructurerules")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPDITStructureRuleSchema(en.nextElement());
                this.addDITStructureRule((LDAPDITStructureRuleSchema)sch2);
            }
        }
        if ((attr = entry.getAttribute("ldapditcontentrules")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPDITContentRuleSchema(en.nextElement());
                this.addDITContentRule((LDAPDITContentRuleSchema)sch2);
            }
        }
        if ((attr = entry.getAttribute("nameforms")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                sch2 = new LDAPNameFormSchema(en.nextElement());
                this.addNameForm((LDAPNameFormSchema)sch2);
            }
        }
        Hashtable<String, String> h = new Hashtable<String, String>();
        attr = entry.getAttribute("matchingruleuse");
        if (attr != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                String use = en.nextElement();
                sch = new LDAPMatchingRuleSchema(null, use);
                h.put(sch.getOID(), use);
            }
        }
        if ((attr = entry.getAttribute("matchingrules")) != null) {
            en = attr.getStringValues();
            while (en.hasMoreElements()) {
                String raw = en.nextElement();
                sch = new LDAPMatchingRuleSchema(raw, null);
                String use = (String)h.get(sch.getOID());
                if (use != null) {
                    sch = new LDAPMatchingRuleSchema(raw, use);
                }
                this.addMatchingRule(sch);
            }
        }
    }

    public void fetchSchema(LDAPConnection ld) throws LDAPException {
        this.fetchSchema(ld, "");
    }

    static boolean isAttributeSyntaxStandardsCompliant(LDAPConnection ld) throws LDAPException {
        Enumeration<String> en;
        String[] attrs;
        String schemaBug = (String)ld.getProperty("com.netscape.ldap.schema.quoting");
        if (schemaBug != null) {
            return schemaBug.equalsIgnoreCase("standard");
        }
        boolean compliant = true;
        String entryName = LDAPSchema.getSchemaDN(ld, "");
        LDAPEntry entry = ld.read(entryName, attrs = new String[]{"attributetypes"});
        LDAPAttribute attr = entry.getAttribute("attributetypes");
        if (attr != null && (en = attr.getStringValues()).hasMoreElements()) {
            compliant = !LDAPSchema.isSyntaxQuoted(en.nextElement());
        }
        ld.setProperty("com.netscape.ldap.schema.quoting", compliant ? "standard" : "NetscapeBug");
        return compliant;
    }

    static boolean isSyntaxQuoted(String raw) {
        int ind = raw.indexOf(" SYNTAX ");
        if (ind >= 0) {
            int l = raw.length() - (ind += 8);
            char[] ch = new char[l];
            raw.getChars(ind, raw.length(), ch, 0);
            for (ind = 0; ind < ch.length && ch[ind] == ' '; ++ind) {
            }
            if (ind < ch.length) {
                return ch[ind] == '\'';
            }
        }
        return false;
    }

    public String toString() {
        Object s = "Object classes:\n";
        Enumeration<LDAPObjectClassSchema> en1 = this.getObjectClasses();
        while (en1.hasMoreElements()) {
            s = (String)s + en1.nextElement().toString();
            s = (String)s + "\n";
        }
        s = (String)s + "Attributes:\n";
        Enumeration<LDAPAttributeSchema> en2 = this.getAttributes();
        while (en2.hasMoreElements()) {
            s = (String)s + en2.nextElement().toString();
            s = (String)s + "\n";
        }
        s = (String)s + "Matching rules:\n";
        Enumeration<LDAPMatchingRuleSchema> en3 = this.getMatchingRules();
        while (en3.hasMoreElements()) {
            s = (String)s + en3.nextElement().toString();
            s = (String)s + "\n";
        }
        s = (String)s + "Syntaxes:\n";
        Enumeration<LDAPSyntaxSchema> en4 = this.getSyntaxes();
        while (en4.hasMoreElements()) {
            s = (String)s + en4.nextElement().toString();
            s = (String)s + "\n";
        }
        return s;
    }

    static String getSchemaDN(LDAPConnection ld, String dn) throws LDAPException {
        Enumeration<String> en;
        if (ld == null || !ld.isConnected()) {
            throw new LDAPException("No connection", 80);
        }
        String[] attrs = new String[]{"subschemasubentry"};
        LDAPEntry entry = ld.read(dn, attrs);
        if (entry == null) {
            throw new LDAPException("", 32);
        }
        LDAPAttribute attr = entry.getAttribute(attrs[0]);
        String entryName = "cn=schema";
        if (attr != null && (en = attr.getStringValues()).hasMoreElements()) {
            entryName = en.nextElement();
        }
        return entryName;
    }

    private static LDAPEntry readSchema(LDAPConnection ld, String dn, String[] attrs) throws LDAPException {
        LDAPSearchResults results = ld.search(dn, 0, "objectclass=subschema", attrs, false);
        if (!results.hasMoreElements()) {
            throw new LDAPException("Cannot read schema", 50);
        }
        return results.next();
    }

    private static LDAPEntry readSchema(LDAPConnection ld, String dn) throws LDAPException {
        return LDAPSchema.readSchema(ld, dn, new String[]{"*", "ldapSyntaxes", "matchingRules", "attributeTypes", "objectClasses"});
    }

    private static void printEnum(Enumeration<? extends LDAPSchemaElement> en) {
        while (en.hasMoreElements()) {
            LDAPSchemaElement s = en.nextElement();
            System.out.println("  " + s);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: netscape.ldap.LDAPSchema HOST PORT");
            System.exit(1);
        }
        int port = Integer.parseInt(args[1]);
        LDAPConnection ld = new LDAPConnection();
        try {
            ld.connect(args[0], port);
            LDAPSchema schema = new LDAPSchema();
            schema.fetchSchema(ld);
            ld.disconnect();
            System.out.println("Object classes: ");
            LDAPSchema.printEnum(schema.getObjectClasses());
            System.out.println("\nAttributes: ");
            LDAPSchema.printEnum(schema.getAttributes());
            System.out.println("\nMatching rules: ");
            LDAPSchema.printEnum(schema.getMatchingRules());
            System.out.println("\nSyntaxes: ");
            LDAPSchema.printEnum(schema.getSyntaxes());
            System.exit(0);
        }
        catch (LDAPException e) {
            System.err.println(e);
        }
    }
}

