/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.X500Name;

public final class X500Signer {
    private Signature sig;
    private X500Name agent;
    private AlgorithmId algid;

    public void update(byte[] buf, int offset, int len) throws SignatureException {
        this.sig.update(buf, offset, len);
    }

    public byte[] sign() throws SignatureException {
        return this.sig.sign();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public X500Name getSigner() {
        return this.agent;
    }

    public X500Signer(Signature sig, X500Name agent) {
        if (sig == null || agent == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.sig = sig;
        this.agent = agent;
        try {
            String alg = sig.getAlgorithm();
            if (alg.equals("DSA")) {
                alg = "SHA1withDSA";
            }
            this.algid = AlgorithmId.get(alg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("internal error! " + e.getMessage());
        }
    }
}

