/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.SecretDecoderRing;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.SecretDecoderRing.Encoding;
import org.mozilla.jss.SecretDecoderRing.KeyManager;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.TokenException;

public class Decryptor {
    private CryptoToken token;
    private KeyManager keyManager;

    public Decryptor(CryptoToken token) {
        this.token = token;
        this.keyManager = new KeyManager(token);
    }

    public byte[] decrypt(byte[] ciphertext) throws NotInitializedException, GeneralSecurityException, TokenException {
        CryptoManager cm = CryptoManager.getInstance();
        CryptoToken savedToken = cm.getThreadToken();
        try {
            cm.setThreadToken(this.token);
            Encoding encoding = (Encoding)ASN1Util.decode(Encoding.getTemplate(), ciphertext);
            EncryptionAlgorithm alg = EncryptionAlgorithm.fromOID(encoding.getEncryptionOID());
            SecretKey key = this.keyManager.lookupKey(alg, encoding.getKeyID());
            if (key == null) {
                throw new InvalidKeyException("No matching key found");
            }
            IvParameterSpec ivSpec = new IvParameterSpec(encoding.getIv());
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(alg.toString(), "Mozilla-JSS");
            cipher.init(2, (Key)key, ivSpec);
            byte[] paddedPtext = cipher.doFinal(encoding.getCiphertext());
            byte[] byArray = Cipher.unPad(paddedPtext, alg.getBlockSize());
            return byArray;
        }
        catch (InvalidBERException ibe) {
            throw new GeneralSecurityException(ibe.toString());
        }
        catch (IllegalStateException ise) {
            throw new GeneralSecurityException(ise.toString());
        }
        finally {
            cm.setThreadToken(savedToken);
        }
    }
}

