/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cmc.TaggedRequest;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class EncryptedPOP
implements ASN1Value {
    private TaggedRequest request;
    private ContentInfo cms;
    private AlgorithmIdentifier thePOPAlgID;
    private AlgorithmIdentifier witnessAlgID;
    private OCTET_STRING witness;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public TaggedRequest getRequest() {
        return this.request;
    }

    public ContentInfo getContentInfo() {
        return this.cms;
    }

    public AlgorithmIdentifier getThePOPAlgID() {
        return this.thePOPAlgID;
    }

    public AlgorithmIdentifier getWitnessAlgID() {
        return this.witnessAlgID;
    }

    public OCTET_STRING getWitness() {
        return this.witness;
    }

    public EncryptedPOP(TaggedRequest request, ContentInfo cms, AlgorithmIdentifier thePOPAlgID, AlgorithmIdentifier witnessAlgID, OCTET_STRING witness) {
        if (request == null || cms == null || thePOPAlgID == null || witnessAlgID == null || witness == null) {
            throw new IllegalArgumentException("EncryptedPOP constructor parameter is null");
        }
        this.request = request;
        this.cms = cms;
        this.thePOPAlgID = thePOPAlgID;
        this.witnessAlgID = witnessAlgID;
        this.witness = witness;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(request);
        this.sequence.addElement(cms);
        this.sequence.addElement(thePOPAlgID);
        this.sequence.addElement(witnessAlgID);
        this.sequence.addElement(witness);
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(TaggedRequest.getTemplate());
            this.seqt.addElement(ContentInfo.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new EncryptedPOP((TaggedRequest)seq.elementAt(0), (ContentInfo)seq.elementAt(1), (AlgorithmIdentifier)seq.elementAt(2), (AlgorithmIdentifier)seq.elementAt(3), (OCTET_STRING)seq.elementAt(4));
        }
    }
}

