/**
 * This abstraction is used by the mixin pattern.
 * It describes a class constructor.
 * @public
 */
export declare type Constructor<T = {}> = new (...args: any[]) => T;
/**
 * This abstraction is used by the mixin pattern.
 * It describes the "static side" of a class.
 *
 * @public
 */
export declare type PropertiesOf<T> = {
    [K in keyof T]: T[K];
};
//# sourceMappingURL=Mixin.d.ts.map