"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WarningAppender = void 0;
const tsdoc_1 = require("@microsoft/tsdoc");
const api_extractor_model_1 = require("@microsoft/api-extractor-model");
const DocNoteBox_1 = require("../../nodes/DocNoteBox");
const unstable = 'This API is provided as a preview for developers and may change'
    + ' based on feedback that we receive.  Do not use this API in a production environment.';
const deprecated = '';
class WarningAppender {
    constructor(configuration) {
        this._configuration = configuration;
    }
    append(output, apiItem) {
        const warning = this._warningForItem(apiItem);
        const configuration = this._configuration;
        if (!warning) {
            return;
        }
        output.appendNode(new DocNoteBox_1.DocNoteBox({ configuration }, [
            new tsdoc_1.DocParagraph({ configuration }, [
                new tsdoc_1.DocPlainText({ configuration, text: warning })
            ])
        ]));
    }
    _warningForItem(apiItem) {
        if (this._isDeprecated(apiItem)) {
            return deprecated;
        }
        if (api_extractor_model_1.ApiReleaseTagMixin.isBaseClassOf(apiItem)) {
            switch (apiItem.releaseTag) {
                case api_extractor_model_1.ReleaseTag.Alpha:
                case api_extractor_model_1.ReleaseTag.Beta:
                case api_extractor_model_1.ReleaseTag.None:
                    return unstable;
            }
        }
    }
    _isDeprecated(apiItem) {
        if (apiItem instanceof api_extractor_model_1.ApiDocumentedItem) {
            const tsdocComment = apiItem.tsdocComment;
            if (!tsdocComment) {
                return false;
            }
            if (tsdocComment.deprecatedBlock) {
                return true;
            }
        }
        return false;
    }
}
exports.WarningAppender = WarningAppender;
;
//# sourceMappingURL=WarningAppender.js.map